// Created on: 2005-12-07
// Created by: Sergey KHROMOV
// Copyright (c) 2005-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <math.hxx>
#include <math_ComputeKronrodPointsAndWeights.hxx>

int math::KronrodPointsMax()
{
  return 123;
}

// The array of Kronrod points.
static const double Point[] = {7.74596669241483404277914814883843e-01, // N = 3
                               0.0e+00,
                               9.25820099772551419192723187734373e-01, // N = 5
                               5.77350269189625620036565578629961e-01,
                               0.0e+00,
                               9.60491268708020373701117478049127e-01, // N = 7
                               7.74596669241483404277914814883843e-01,
                               4.34243749346802210276052846893435e-01,
                               0.0e+00,
                               9.76560250737573021240223170025274e-01, // N = 9
                               8.61136311594052239470897802675609e-01,
                               6.40286217496309761898487522557843e-01,
                               3.39981043584856257311344052141067e-01,
                               0.0e+00,
                               9.84085360094842709344220565981232e-01, // N = 11
                               9.06179845938664407789531196613098e-01,
                               7.54166726570849044186672927025938e-01,
                               5.38469310105682996692166852881201e-01,
                               2.79630413161783220044043218877050e-01,
                               0.0e+00,
                               9.88703202612678411220770158251980e-01, // N = 13
                               9.32469514203151716991158082237234e-01,
                               8.21373340865027889989846698881593e-01,
                               6.61209386466264592563391033763764e-01,
                               4.63118212475304602548931143246591e-01,
                               2.38619186083196987979704317694996e-01,
                               0.0e+00,
                               9.91455371120812833929392127174651e-01, // N = 15
                               9.49107912342758597290526267897803e-01,
                               8.64864423359769096677496236225124e-01,
                               7.41531185599394460083999547350686e-01,
                               5.86087235467691591850325494306162e-01,
                               4.05845151377397406200486784655368e-01,
                               2.07784955007898564094404036950436e-01,
                               0.0e+00,
                               9.93379875881715834751162219617981e-01, // N = 17
                               9.60289856497536065127462734380970e-01,
                               8.94120906847456264898710287525319e-01,
                               7.96666477413626505921229181694798e-01,
                               6.72354070945158865946211790287634e-01,
                               5.25532409916329323884554014512105e-01,
                               3.60701097928131819703168048363295e-01,
                               1.83434642495649724569517502459348e-01,
                               0.0e+00,
                               9.94678160677340272854962677229196e-01, // N = 19
                               9.68160239507626529942285742436070e-01,
                               9.14963507249678009713989013107494e-01,
                               8.36031107326635880561127578403102e-01,
                               7.34486765183933520972914266167209e-01,
                               6.13371432700590468733992111083353e-01,
                               4.75462479112459812657931479407125e-01,
                               3.24253423403808638258993823910714e-01,
                               1.64223563614986717285049167003308e-01,
                               0.0e+00,
                               9.95657163025807867562377850845223e-01, // N = 21
                               9.73906528517171743430935748619959e-01,
                               9.30157491355708354596742992725922e-01,
                               8.65063366688984314301080758013995e-01,
                               7.80817726586416904765997060167138e-01,
                               6.79409568299024102522309931373456e-01,
                               5.62757134668604330762775589391822e-01,
                               4.33395394129247379932934336466133e-01,
                               2.94392862701460422680810324891354e-01,
                               1.48874338981631160194751828385051e-01,
                               0.0e+00,
                               9.96369613889542482532135636574822e-01, // N = 23
                               9.78228658146056861966144424513914e-01,
                               9.41677108578067856292648230009945e-01,
                               8.87062599768095094709963177592726e-01,
                               8.16057456656220758794972880423302e-01,
                               7.30152005574049245417711517802672e-01,
                               6.30599520161965076958665576967178e-01,
                               5.19096129206812140211013684165664e-01,
                               3.97944140952377511943893750867574e-01,
                               2.69543155952345125925262436794583e-01,
                               1.36113000799362088288901873056602e-01,
                               0.0e+00,
                               9.96933922529595228922971728025004e-01, // N = 25
                               9.81560634246719354578658567334060e-01,
                               9.50537795943121377462148302583955e-01,
                               9.04117256370474686733018643280957e-01,
                               8.43558124161153055631245933909668e-01,
                               7.69902674194304470489669256494381e-01,
                               6.84059895470055967514610983926104e-01,
                               5.87317954286617260883929247938795e-01,
                               4.81339450478157293566994212596910e-01,
                               3.67831498998180128623403106757905e-01,
                               2.48505748320469427303791576377989e-01,
                               1.25233408511468857771120610777871e-01,
                               0.0e+00,
                               9.97366176994825104351605205010856e-01, // N = 27
                               9.84183054718588357090425233764108e-01,
                               9.57552468386081434559287117735948e-01,
                               9.17598399222978255984628503938438e-01,
                               8.65333160266344436628571656910935e-01,
                               8.01578090733309878146428673062474e-01,
                               7.26948849320632306536538180807838e-01,
                               6.42349339440340227902481728960993e-01,
                               5.49079957956536968133320897322847e-01,
                               4.48492751036446757328945977860712e-01,
                               3.41832463021806476355379800224910e-01,
                               2.30458315955134912522694889958075e-01,
                               1.15971089744933600340637269709987e-01,
                               0.0e+00,
                               9.97720593756543205898879023152404e-01, // N = 29
                               9.86283808696812314131818766327342e-01,
                               9.63158338278853110026034300972242e-01,
                               9.28434883663573629064558190293610e-01,
                               8.82914663252057252407212217804044e-01,
                               8.27201315069764908649574408627814e-01,
                               7.61756752562205652345994622010039e-01,
                               6.87292904811685367860718542942777e-01,
                               6.04789365940921808117991531617008e-01,
                               5.15248636358153988545893753325799e-01,
                               4.19655897642978947814640378055628e-01,
                               3.19112368927889633596350904554129e-01,
                               2.14835918533484881987050130192074e-01,
                               1.08054948707343417835247123548470e-01,
                               0.0e+00,
                               9.98002298693397182915987286833115e-01, // N = 31
                               9.87992518020485377405748295132071e-01,
                               9.67739075679138860408556865877472e-01,
                               9.37273392400705951388317771488801e-01,
                               8.97264532344082099690751874732086e-01,
                               8.48206583410427428226796564558754e-01,
                               7.90418501442466170381351275864290e-01,
                               7.24417731360170069621062793885358e-01,
                               6.50996741297416692262345350172836e-01,
                               5.70972172608538719451587439834839e-01,
                               4.85081863640239585588886939149234e-01,
                               3.94151347077563662946175782053615e-01,
                               2.99180007153169003064618891585269e-01,
                               2.01194093997434320097994486786774e-01,
                               1.01142066918717341006406229553249e-01,
                               0.0e+00,
                               9.98239274145444333008470039203530e-01, // N = 33
                               9.89400934991649716465644814888947e-01,
                               9.71505950969392517713174584059743e-01,
                               9.44575023073232156178846707916819e-01,
                               9.09157667012342796120094590150984e-01,
                               8.65631202387831533151540952530922e-01,
                               8.14240287062444223487034378194949e-01,
                               7.55404408355002887631712837901432e-01,
                               6.89741106681762028429716337996069e-01,
                               6.17876244402643437503286349965492e-01,
                               5.40407676352139598741075587895466e-01,
                               4.58016777657227425191166503282147e-01,
                               3.71483780878416325332835867811809e-01,
                               2.81603550779259248493247014266672e-01,
                               1.89168579018083871101651993740234e-01,
                               9.50125098376376625575190359995759e-02,
                               0.0e+00,
                               9.98432970606058178830721772101242e-01, // N = 35
                               9.90575475314417253080989667068934e-01,
                               9.74659256967431053553241326881107e-01,
                               9.50675521768767683994383332901634e-01,
                               9.19096136803891461397597595350817e-01,
                               8.80239153726985912307156922906870e-01,
                               8.34274092850134429966146853985265e-01,
                               7.81514003896801145998551874072291e-01,
                               7.22472287372409871508693868236151e-01,
                               6.57671159216690837112651024654042e-01,
                               5.87569212334035029243750614114106e-01,
                               5.12690537086476605388440930255456e-01,
                               4.33687295209799150708107617901987e-01,
                               3.51231763453875855951480389194330e-01,
                               2.65946507451681912748142622149317e-01,
                               1.78484181495847438192470235662768e-01,
                               8.95856394252265292310610789172642e-02,
                               0.0e+00,
                               9.98599165412682676645772517076693e-01, // N = 37
                               9.91565168420931009052310400875285e-01,
                               9.77310380774861098274186588241719e-01,
                               9.55823949571397601943090194254182e-01,
                               9.27504501573343409503991097153630e-01,
                               8.92602466497555813162989579723217e-01,
                               8.51249373433717426706834885408171e-01,
                               8.03704958972523364479911833768710e-01,
                               7.50380481703357804512677375896601e-01,
                               6.91687043060353334844592154695420e-01,
                               6.28003754863833640875725450314349e-01,
                               5.59770831073947316980365940253250e-01,
                               4.87509042585078489207006668948452e-01,
                               4.11751161462842685256902086621267e-01,
                               3.33023422791407619492076719325269e-01,
                               2.51886225691505316603979736100882e-01,
                               1.68936828066548888616082990665745e-01,
                               8.47750130417350422629141348807025e-02,
                               0.0e+00,
                               9.98738012080314652152424059750047e-01, // N = 39
                               9.92406843843584351994024927989813e-01,
                               9.79572300789263605835799353371840e-01,
                               9.60208152134830017487843178969342e-01,
                               9.34664000165519315288520374451764e-01,
                               9.03155903614818122981944270577515e-01,
                               8.65773542685335240065569450962357e-01,
                               8.22714656537143040893056422646623e-01,
                               7.74328859009534631319127129245317e-01,
                               7.20966177335228941558398219058290e-01,
                               6.62923065744907780150185772072291e-01,
                               6.00545304661680989788408169260947e-01,
                               5.34275632530553434840214777068468e-01,
                               4.64570741375960827301838662606315e-01,
                               3.91851230871520184173562029172899e-01,
                               3.16564099963629608236459489489789e-01,
                               2.39224928318241325531090524236788e-01,
                               1.60358645640225422335234384263458e-01,
                               8.04519227440115697325140331486182e-02,
                               0.0e+00,
                               9.98859031588277712643275663140230e-01, // N = 41
                               9.93128599185094884660429670475423e-01,
                               9.81507877450250143525067869632039e-01,
                               9.63971927277913365195161077281227e-01,
                               9.40822633831754462363505808752961e-01,
                               9.12234428251325946135352751298342e-01,
                               8.78276811252282185726869556674501e-01,
                               8.39116971822218782328661745850695e-01,
                               7.95041428837550689934232650557533e-01,
                               7.46331906460150462656599756883224e-01,
                               6.93237656334751317643849688465707e-01,
                               6.36053680726514802934445924620377e-01,
                               5.75140446819710104975342801481020e-01,
                               5.10867001950827015477329950954299e-01,
                               4.43593175238724879427820724231424e-01,
                               3.73706088715419659784799932822352e-01,
                               3.01627868114912933705795694550034e-01,
                               2.27785851141645345752095863645081e-01,
                               1.52605465240922860692407425631245e-01,
                               7.65265211334970607559569089062279e-02,
                               0.0e+00,
                               9.98961930687316979060597077477723e-01, // N = 43
                               9.93752170620389452260212692635832e-01,
                               9.83184863561686106514514449372655e-01,
                               9.67226838566306312827691726852208e-01,
                               9.46147216778512656354394039226463e-01,
                               9.20099334150401015897102752205683e-01,
                               8.89128315331184304604050794296199e-01,
                               8.53363364583317296485631686664419e-01,
                               8.13052580847531847219045175734209e-01,
                               7.68439963475677778603767364984378e-01,
                               7.19723452572024857687438270659186e-01,
                               6.67138804197412560448299245763337e-01,
                               6.10997123789766005685919481038582e-01,
                               5.51618835887220049229995311179664e-01,
                               4.89295908895668762994546341360547e-01,
                               4.24342120207438944223810040057288e-01,
                               3.57125253659921149118616767736967e-01,
                               2.88021316802401172729730660648784e-01,
                               2.17380093871728852228386585920816e-01,
                               1.45561854160894815768401144850941e-01,
                               7.29672475957908045485211800951220e-02,
                               0.0e+00,
                               9.99052772392180266081140871392563e-01, // N = 45
                               9.94294585482399351228366413124604e-01,
                               9.84640721597348722582410118775442e-01,
                               9.70060497835428914292776880756719e-01,
                               9.50790380343184859945893094845815e-01,
                               9.26956772187173649868441316357348e-01,
                               8.98593852179612295749677741696360e-01,
                               8.65812577720300069472614268306643e-01,
                               8.28820204471430677095611372351414e-01,
                               7.87816805979208112375999917276204e-01,
                               7.42971193879007452132157141022617e-01,
                               6.94487263186682857174503169517266e-01,
                               6.42622572592912555400346263922984e-01,
                               5.87640403506911712661064939311473e-01,
                               5.29793398630515000036211858969182e-01,
                               4.69355837986757229440826222344185e-01,
                               4.06633105434211661322052577816066e-01,
                               3.41935820892083852662324261473259e-01,
                               2.75571451345615225925200775236590e-01,
                               2.07860426688221355817631774698384e-01,
                               1.39137790722961979250626995963103e-01,
                               6.97392733197221420526901169978373e-02,
                               0.0e+00,
                               9.99131136463421554161357107659569e-01, // N = 47
                               9.94769334997552157062727928860113e-01,
                               9.85918150727375652841999453812605e-01,
                               9.72542471218115212039379002817441e-01,
                               9.54855839860111244021823040384334e-01,
                               9.32971086826015816306778560829116e-01,
                               9.06907694741281411587863203749293e-01,
                               8.76752358270442067045280509773875e-01,
                               8.42687322997013099623586640518624e-01,
                               8.04888401618840232387697142257821e-01,
                               7.63491316221165616795474306854885e-01,
                               7.18661363131950281513127265498042e-01,
                               6.70623789037042561389512229652610e-01,
                               6.19609875763646456015010244300356e-01,
                               5.65827305907601885159863286389736e-01,
                               5.09501477846007522209959006431745e-01,
                               4.50900980924738292721087873360375e-01,
                               3.90301038030290592395488147303695e-01,
                               3.27957345711785142050587182893651e-01,
                               2.64135680970345232410068092576694e-01,
                               1.99134670993493134716345593915321e-01,
                               1.33256824298466497458193202874099e-01,
                               6.67836574066257848691918752592755e-02,
                               0.0e+00,
                               9.99201056021875144708133120730054e-01, // N = 49
                               9.95187219997021421669103347085183e-01,
                               9.87040496015809343255398289329605e-01,
                               9.74728555971309362782051266549388e-01,
                               9.58441684405209493036181811476126e-01,
                               9.38274552002732797895134808641160e-01,
                               9.14240690794911659011745541647542e-01,
                               8.86415527004400738420031302666757e-01,
                               8.54953803904051512496664599893847e-01,
                               8.20001985973903169124810119683389e-01,
                               7.81677226476464204196759055776056e-01,
                               7.40124191578554357917596462357324e-01,
                               6.95532072396779055267757030378561e-01,
                               6.48093651936975545524433073296677e-01,
                               5.97990513906078269279475989605999e-01,
                               5.45421471388839562699502039322397e-01,
                               4.90612365463446109536960193509003e-01,
                               4.33793507626045515834789512155112e-01,
                               3.75191154797950676691442595256376e-01,
                               3.15042679696163507863104769057827e-01,
                               2.53600430369677443120934867692995e-01,
                               1.91118867473616310670436746477208e-01,
                               1.27851240286216916164363510688418e-01,
                               6.40568928626057132458271325958776e-02,
                               0.0e+00,
                               9.99262104992609589970697925309651e-01, // N = 51
                               9.95556969790497903183279504446546e-01,
                               9.88035794534077194128940391237848e-01,
                               9.76663921459517081480328215548070e-01,
                               9.61614986425842532824503905430902e-01,
                               9.42974571228974323133797952323221e-01,
                               9.20747115281701833389149669528706e-01,
                               8.94991997878275102884515490586637e-01,
                               8.65847065293275375275072747172089e-01,
                               8.33442628760833748025049771968042e-01,
                               7.97873797998499667549765490548452e-01,
                               7.59259263037357023939932787470752e-01,
                               7.17766406813084456572937597229611e-01,
                               6.73566368473468291000472163432278e-01,
                               6.26810099010317145484805223532021e-01,
                               5.77662930241222949412360776477726e-01,
                               5.26325284334718701551025787921390e-01,
                               4.73002731445714641456135041153175e-01,
                               4.17885382193037779874345005737268e-01,
                               3.61172305809387805819454797529033e-01,
                               3.03089538931108182229223757531145e-01,
                               2.43866883720988331107903945849102e-01,
                               1.83718939421049054505630238054437e-01,
                               1.22864692610710410369811995678901e-01,
                               6.15444830056854352839934563235147e-02,
                               0.0e+00,
                               9.99317064760071649409667315921979e-01, // N = 53
                               9.95885701145616808460658830881584e-01,
                               9.88919144824434881435593069909373e-01,
                               9.78385445956470922723724470415618e-01,
                               9.64441118239312333848545222281246e-01,
                               9.47159066661714454937737173167989e-01,
                               9.26540570770361004981907626643078e-01,
                               9.02637861984306844043146611511474e-01,
                               8.75569635163670922928247364325216e-01,
                               8.45445942788498161490906568360515e-01,
                               8.12349727085128203718511485931231e-01,
                               7.76385948820678795101457581040449e-01,
                               7.37696979507612815574191245104885e-01,
                               6.96427260419957061543527743197046e-01,
                               6.52710009506913380050718842539936e-01,
                               6.06692293017617845229949580243556e-01,
                               5.58544530980815689957807990140282e-01,
                               5.08440714824505701763257548009278e-01,
                               4.56550216028299815640423275908688e-01,
                               4.03051755123486177279090725278365e-01,
                               3.48138197103694813083762937822030e-01,
                               2.92004839485956679823175363708287e-01,
                               2.34845255152457549341349363203335e-01,
                               1.76858820356889961944446554298338e-01,
                               1.18251662892057157749903240073763e-01,
                               5.92300934293130201813148971723422e-02,
                               0.0e+00,
                               9.99365546522977044041624594683526e-01, // N = 55
                               9.96179262888988503732434764970094e-01,
                               9.89709602301697688453430146182654e-01,
                               9.79923475961500756170607928652316e-01,
                               9.66964925626242921552488951419946e-01,
                               9.50900557814704727732646460935939e-01,
                               9.31725922454987864895770144357812e-01,
                               9.09482320677491240523693249997450e-01,
                               8.84276659710189316676576254394604e-01,
                               8.56207908018294383545310211047763e-01,
                               8.25343907246362085139423925284063e-01,
                               7.91771639070507959878852943802485e-01,
                               7.55618350427228357979458905901993e-01,
                               7.17013473739423923269953320414061e-01,
                               6.76068826884504314733703722595237e-01,
                               6.32907971946495173654056998202577e-01,
                               5.87683411872107930307151946180966e-01,
                               5.40551564579456522707801013893913e-01,
                               4.91656061412170497515461420334759e-01,
                               4.41148251750026643147606364436797e-01,
                               3.89201852747204479765485984898987e-01,
                               3.35993903638508506492854621683364e-01,
                               2.81689781320006937814781622364535e-01,
                               2.26459365439536680630894238674955e-01,
                               1.70490430850875285262446823253413e-01,
                               1.13972585609529830641406533686677e-01,
                               5.70829167231878126242961002390075e-02,
                               0.0e+00,
                               9.99409527464458324885754336719401e-01, // N = 57
                               9.96442497573954089062908678897657e-01,
                               9.90417243607036867913961941667367e-01,
                               9.81303165370872920725275889708428e-01,
                               9.69231347359594486157163828465855e-01,
                               9.54259280628938277857287175720558e-01,
                               9.36380950324850358512662751309108e-01,
                               9.15633026392132176596305725979619e-01,
                               8.92108688876811939394428918603808e-01,
                               8.65892522574395195888996568100993e-01,
                               8.37044208419339241800116724334657e-01,
                               8.05641370917179133748220465349732e-01,
                               7.71793447243434016513674578163773e-01,
                               7.35610878013631563909768829034874e-01,
                               6.97193171944897938097085443587275e-01,
                               6.56651094038864902024954517401056e-01,
                               6.14115617729884100128856516676024e-01,
                               5.69720471811401840689370601467090e-01,
                               5.23594465442833056911808853328694e-01,
                               4.75874224955118385604890818285639e-01,
                               4.26709291931107070894313437747769e-01,
                               3.76251516089078807958401284849970e-01,
                               3.24650637057820157238552383205388e-01,
                               2.72061627635178326922726910197525e-01,
                               2.18646765777540580399929126542702e-01,
                               1.64569282133380900834396243226365e-01,
                               1.09991649290732920740687461602647e-01,
                               5.50792898840343839172994933051086e-02,
                               0.0e+00,
                               9.99448667882050778565883319970453e-01, // N = 59
                               9.96679442260596570868358412553789e-01,
                               9.91055405722805371482309055863880e-01,
                               9.82545505261413265607473022100748e-01,
                               9.71271237101307027828056561702397e-01,
                               9.57285595778087805562961420946522e-01,
                               9.40578916002972831300610323523870e-01,
                               9.21180232953058952816149940190371e-01,
                               8.99174270592779323330034912942210e-01,
                               8.74637804920102679417936997197103e-01,
                               8.47619919760977058587059218552895e-01,
                               8.18185487615252449167257964290911e-01,
                               7.86433199580495512215350117912749e-01,
                               7.52462851734477466969508441252401e-01,
                               7.16358665327582411208595658536069e-01,
                               6.78214537602686351469571945926873e-01,
                               6.38148568478847155738264973479090e-01,
                               5.96281797138227931398546388663817e-01,
                               5.52724357701319446434240489907097e-01,
                               5.07592955124228195629143556288909e-01,
                               4.61023045388234409269756497451453e-01,
                               4.13152888174009136346143122864305e-01,
                               3.64111378713378119886812100958196e-01,
                               3.14031637867639989991630500298925e-01,
                               2.63061896295217478858319282153388e-01,
                               2.11352286166000963296696113502549e-01,
                               1.59043478004521871005394473286287e-01,
                               1.06278230132678980224270048893231e-01,
                               5.32117722046491353760089282332046e-02,
                               0.0e+00,
                               9.99484410050490490462493653467391e-01, // N = 61
                               9.96893484074649172121951323788380e-01,
                               9.91630996870404346488214741839329e-01,
                               9.83668123279747175224940747284563e-01,
                               9.73116322501125785571218784753000e-01,
                               9.60021864968307214738274524279404e-01,
                               9.44374444748559804807541695481632e-01,
                               9.26200047429274420096589892636985e-01,
                               9.05573307699907403822692231187830e-01,
                               8.82560535792052069936630687152501e-01,
                               8.57205233546060485494422209740151e-01,
                               8.29565762382768023819323843781604e-01,
                               7.99727835821838928254123857186642e-01,
                               7.67777432104825741099318747728830e-01,
                               7.33790062453226643590653566207038e-01,
                               6.97850494793315401231836858642055e-01,
                               6.60061064126626795278696135937935e-01,
                               6.20526182989242558463161003601272e-01,
                               5.79345235826361437680986909981584e-01,
                               5.36624148142019863350071773311356e-01,
                               4.92480467861778292704144632807584e-01,
                               4.47033769538089376105460814869730e-01,
                               4.00401254830394681683003454963909e-01,
                               3.52704725530878282491187292180257e-01,
                               3.04073202273625220470876229228452e-01,
                               2.54636926167890076388999887058162e-01,
                               2.04525116682310353910523303966329e-01,
                               1.53869913608583541719809772985172e-01,
                               1.02806937966737399481331749484525e-01,
                               5.14718425553176983644476649715216e-02,
                               0.0e+00,
                               9.99516462879228351212645975465421e-01, // N = 63
                               9.97087481819476706412785915745189e-01,
                               9.92153590932694062765051512542414e-01,
                               9.84685909665152570013901822676416e-01,
                               9.74788362516032513838126760674641e-01,
                               9.62503925092949463859781644714531e-01,
                               9.47819958262127615356007481750567e-01,
                               9.30756997896648008428144294157391e-01,
                               9.11383461987592791153645066515310e-01,
                               8.89760029948270747546246184356278e-01,
                               8.65922609043559332597794764296850e-01,
                               8.39920320146267163075037842645543e-01,
                               8.11831075102920074471057887421921e-01,
                               7.81733148416624890053583385451930e-01,
                               7.49690911026608564071693763253279e-01,
                               7.15776784586852898861764060711721e-01,
                               6.80083687850750795433896200847812e-01,
                               6.42706722924260454021805344382301e-01,
                               6.03731488500522717188800925214309e-01,
                               5.63249161407149201430399898526957e-01,
                               5.21366801919327049752439506846713e-01,
                               4.78193782044902537808894749105093e-01,
                               4.33831684206103185275082978478167e-01,
                               3.88385901608232997350711457329453e-01,
                               3.41974685364181518743009746685857e-01,
                               2.94718069981701968895748677823576e-01,
                               2.46728632359113658756299969354586e-01,
                               1.98121199335570846722376359139162e-01,
                               1.49021273651722158115617844487133e-01,
                               9.95553121523416878480006175777817e-02,
                               4.98418078330689212629422968348081e-02,
                               0.0e+00,
                               9.99545902124364449292670542490669e-01, // N = 65
                               9.97263861849481458854427273763577e-01,
                               9.92628035262972052699126379593508e-01,
                               9.85611511545268492717752906173700e-01,
                               9.76310283614663876328165770246414e-01,
                               9.64762255587506500909000806132099e-01,
                               9.50954684848661191409746606950648e-01,
                               9.34906075937739555747896247339668e-01,
                               9.16677266651364286431658001674805e-01,
                               8.96321155766052202196192411065567e-01,
                               8.73869768945310432251005750003969e-01,
                               8.49367613732569970430574812780833e-01,
                               8.22882950136051283251958921027835e-01,
                               7.94483795967942385551907591434428e-01,
                               7.64228251997803864625780079222750e-01,
                               7.32182118740290044378582479112083e-01,
                               6.98426557795210345425118703133194e-01,
                               6.63044266930215564492812063690508e-01,
                               6.26112937701823968339454040687997e-01,
                               5.87715757240762415314350164408097e-01,
                               5.47946314199152628710010048962431e-01,
                               5.06899908932229359415089220419759e-01,
                               4.64669308481992060499976560095092e-01,
                               4.21351276130635277183955622604117e-01,
                               3.77049421154121044974516507863882e-01,
                               3.31868602282127833635883007445955e-01,
                               2.85912458589459961277867705575773e-01,
                               2.39287362252137536522411664918764e-01,
                               1.92103608983142881694305970086134e-01,
                               1.44471961582796709633313980702951e-01,
                               9.65026968768942505771946116510662e-02,
                               4.83076656877380675170208235158498e-02,
                               0.0e+00,
                               9.99572480401970664409816436091205e-01, // N = 67
                               9.97424694246454968116211148299044e-01,
                               9.93061355532605327667283745540772e-01,
                               9.86455726230642260254910524963634e-01,
                               9.77697766395559941798865111195482e-01,
                               9.66822909689992404658198665856617e-01,
                               9.53816931548339130841895894263871e-01,
                               9.38694372611168059705732957809232e-01,
                               9.21511400117664969400266272714362e-01,
                               9.02316767743433501003380570182344e-01,
                               8.81136957366152051562835367803928e-01,
                               8.58009652676503753454539946687873e-01,
                               8.32997339086677390795898645592388e-01,
                               8.06162356274166214120668882969767e-01,
                               7.77554541237250207430520276830066e-01,
                               7.47230496449561631955305074370699e-01,
                               7.15264381722218511860944545333041e-01,
                               6.81731959969742673521864162466954e-01,
                               6.46700582975177629130314471694874e-01,
                               6.10242345836378707879532612423645e-01,
                               5.72442931691055756360242412483785e-01,
                               5.33389904786347623932840633642627e-01,
                               4.93164173270868089193896821598173e-01,
                               4.51850017272450443783782247919589e-01,
                               4.09542745071417801927537993833539e-01,
                               3.66339257748072966158758845267585e-01,
                               3.22330369697089780256504809585749e-01,
                               2.77609097152497152904970789677463e-01,
                               2.32277655397241128421015332605748e-01,
                               1.86439298827991373208590175636346e-01,
                               1.40191060341774725861441197594104e-01,
                               9.36310658547330892931270795997989e-02,
                               4.68652733813287036834793752859696e-02,
                               0.0e+00,
                               9.99597015785066211890352860791609e-01, // N = 69
                               9.97571753790841619924378846917534e-01,
                               9.93457022641509590599184775783215e-01,
                               9.87227816406309521823914110427722e-01,
                               9.78967718582760548784449383674655e-01,
                               9.68708262533344299782811503973790e-01,
                               9.56435429333021058795338831259869e-01,
                               9.42162397405107210346386636956595e-01,
                               9.25939527470533874087266212882241e-01,
                               9.07809677718324659068116488924716e-01,
                               8.87796593664716304772355215391144e-01,
                               8.65934638334564410477867113513639e-01,
                               8.42278986723549505377661716920557e-01,
                               8.16884227900933623800483474042267e-01,
                               7.89795615219529123507413714833092e-01,
                               7.61064876629872655300346195872407e-01,
                               7.30757257014758798696618669055169e-01,
                               6.98939113216263341321621282986598e-01,
                               6.65671902786864166934321929147700e-01,
                               6.31021727080528394004943493200699e-01,
                               5.95063987759908319397084142110543e-01,
                               5.57875500669746671178472752217203e-01,
                               5.19530467383866101371836521138903e-01,
                               4.80106545190326861050067464020685e-01,
                               4.39687752436393519683832664668444e-01,
                               3.98359277758645713429785928383353e-01,
                               3.56204949553047378607573136832798e-01,
                               3.13311081339463060047023645893205e-01,
                               2.69768000950774633484030573526979e-01,
                               2.25666691616449310853198539916775e-01,
                               1.81097495284798515324808931836742e-01,
                               1.36152357259183010018688264608500e-01,
                               9.09251724409930600634410780003236e-02,
                               4.55098219531021030981321473518619e-02,
                               0.0e+00,
                               9.99619298560587732360716017865343e-01, // N = 71
                               9.97706569099600315553288965020329e-01,
                               9.93820293038909063909613905707374e-01,
                               9.87935764443851338612034851394128e-01,
                               9.80131657851340709619591962109553e-01,
                               9.70437616039229955511302705417620e-01,
                               9.58838696995843009496240938460687e-01,
                               9.45345148207827001840541925048456e-01,
                               9.30003753050705816995957775361603e-01,
                               9.12854261359317131763191355275922e-01,
                               8.93916305839049241122040712070884e-01,
                               8.73219125025222031588612026098417e-01,
                               8.50813544681091160626351665996481e-01,
                               8.26749899092225182251070236816304e-01,
                               8.01067213125705612775107056222623e-01,
                               7.73810252286912580999000965675805e-01,
                               7.45038975666406422249110619304702e-01,
                               7.14814501556628623113454068516148e-01,
                               6.83190418488156314680281866458245e-01,
                               6.50224364665890064429731864947826e-01,
                               6.15985710487221616027397885773098e-01,
                               5.80545344749764269387526383070508e-01,
                               5.43968351696258012317741759034107e-01,
                               5.06322773241488444107005761907203e-01,
                               4.67686183461529514371335380928940e-01,
                               4.28137541517814079750081646125182e-01,
                               3.87750696027842511881544851348735e-01,
                               3.46601554430814084994949553220067e-01,
                               3.04774001471050381972816012421390e-01,
                               2.62352941209295809077417516164132e-01,
                               2.19418258415018024853893052750209e-01,
                               1.76051061165989675139087466959609e-01,
                               1.32339270613416964961217558993667e-01,
                               8.83713432756591671379808872188732e-02,
                               4.42304079604761840593951660594030e-02,
                               0.0e+00,
                               9.99639961514879438198022398864850e-01, // N = 73
                               9.97830462484085689567336885374971e-01,
                               9.94153696684936805105792245740304e-01,
                               9.88586478902212184571851594228065e-01,
                               9.81202279982642422417882244189968e-01,
                               9.72027691049697772918136706721270e-01,
                               9.61048148322967143997175298864022e-01,
                               9.48272984399507579134080970106879e-01,
                               9.33744457633886137948309169587446e-01,
                               9.17497774515658837124476576718735e-01,
                               8.99550617190168932957305969466688e-01,
                               8.79929800890397073587223530921619e-01,
                               8.58680523229590431100177738699131e-01,
                               8.35847166992474965852011337119620e-01,
                               8.11465360006536462478266003017779e-01,
                               7.85576230132206565492936078953790e-01,
                               7.58232874152525937461177818477154e-01,
                               7.29489171593556751105325020034797e-01,
                               6.99394262480945050342029389867093e-01,
                               6.68001236585521018795930103806313e-01,
                               6.35371511784057152461002715426730e-01,
                               6.01567658135980787292851346137468e-01,
                               5.66649609403106824245810457796324e-01,
                               5.30680285926245498551168111589504e-01,
                               4.93728458077752119237402439466678e-01,
                               4.55863944433420709145821092533879e-01,
                               4.17155110553159791386690358194755e-01,
                               3.77672547119689006045462065230822e-01,
                               3.37490767013667758433825838437770e-01,
                               2.96684995344028201724739801647956e-01,
                               2.55329699932149156715865956357447e-01,
                               2.13500892316865448217200196268095e-01,
                               1.71276852197153162116194380359957e-01,
                               1.28736103809384605511922927689739e-01,
                               8.59568500443915195496913383976789e-02,
                               4.30181984737084827097319816857635e-02,
                               0.0e+00,
                               9.99658826759632690439616453659255e-01, // N = 75
                               9.97944582477913177953610102122184e-01,
                               9.94461234288736228847938036778942e-01,
                               9.89185963214318619840526025654981e-01,
                               9.82188189256598565002320810890524e-01,
                               9.73493030056485353362916157493601e-01,
                               9.63085370067332302568274826626293e-01,
                               9.50972343262094566007647244987311e-01,
                               9.37193420230154727867954989051213e-01,
                               9.21781437412463544589513730898034e-01,
                               9.04750981775800378059670947550330e-01,
                               8.86124962155485973447355263488134e-01,
                               8.65945248518772414669797399255913e-01,
                               8.44252987340555760553684194746893e-01,
                               8.21079044176752592676393760484643e-01,
                               7.96459200509902154330177381780231e-01,
                               7.70442506972236706985768250888214e-01,
                               7.43078833981965058974594739993336e-01,
                               7.14411252525748552422157899854938e-01,
                               6.84486309130959091895363144431030e-01,
                               6.53360767050603974404054952174192e-01,
                               6.21092608408924218288404972554417e-01,
                               5.87734674344266960765992280357750e-01,
                               5.53342391861581739398445733968401e-01,
                               5.17979488535271648252944487467175e-01,
                               4.81710877803205761438221088610590e-01,
                               4.44597083516632518573885590740247e-01,
                               4.06700509318326075547389564235345e-01,
                               3.68090520120306408102806017268449e-01,
                               3.28837429883706844346846764892689e-01,
                               2.89007390856978629845031036893488e-01,
                               2.48667792791365999116592888640298e-01,
                               2.07891987066149058760444745530549e-01,
                               1.66753930239851994032918014454481e-01,
                               1.25323304735560470124511311951210e-01,
                               8.36704089547703616647211788404093e-02,
                               4.18707394357286030728282355539704e-02,
                               0.0e+00,
                               9.99676391182877210894730524159968e-01, // N = 77
                               9.98049930535687690458246379421325e-01,
                               9.94744779244139287754933320684358e-01,
                               9.89739454266385654257476289785700e-01,
                               9.83099072994788603097049417556264e-01,
                               9.74846328590153965443221295572584e-01,
                               9.64966573751256495583561445528176e-01,
                               9.53466330933529948588045499491272e-01,
                               9.40381489814268278770725828508148e-01,
                               9.25741332048584664171642089058878e-01,
                               9.09559042074942203370824245212134e-01,
                               8.91855739004632441790931807190645e-01,
                               8.72668895636572128360342048836173e-01,
                               8.52035021932362468533028732053936e-01,
                               8.29982434799397261748765686206752e-01,
                               8.06544167605316997260445077699842e-01,
                               7.81763915901667938435082305659307e-01,
                               7.55685903753970822371854865195928e-01,
                               7.28349806133262056562216457678005e-01,
                               6.99798680379184800948166866874089e-01,
                               6.70083061983433814212673951260513e-01,
                               6.39254415829681565952569144428708e-01,
                               6.07361590714389998346689480968053e-01,
                               5.74456021047807130486262394697405e-01,
                               5.40594495447936251864007317635696e-01,
                               5.05834717927931554193321517232107e-01,
                               4.70232884957751062771080796665046e-01,
                               4.33847169432376555953112529095961e-01,
                               3.96739483624291400243322414098657e-01,
                               3.58972440479435161986287994295708e-01,
                               3.20607811555410571191515600730781e-01,
                               2.81708809790164882436158677592175e-01,
                               2.42341033568550967558508091315161e-01,
                               2.02570453892116503213927103388414e-01,
                               1.62462620605486607328060699728667e-01,
                               1.22084025337867510541123294842691e-01,
                               8.15023241711042428780942259436415e-02,
                               4.07851479045782880361592503959400e-02,
                               0.0e+00,
                               9.99692503534965415390445286902832e-01, // N = 79
                               9.98147383066433024900732107198564e-01,
                               9.95007423359634879389545858430211e-01,
                               9.90251536854686253974477949668653e-01,
                               9.83941456918198342762593711086083e-01,
                               9.76098709333471314941732543957187e-01,
                               9.66708343769861810912402688700240e-01,
                               9.55775212324652456707951841963222e-01,
                               9.43332998197736749546038481639698e-01,
                               9.29409148486738279082430835842388e-01,
                               9.14014488521817547450609708903357e-01,
                               8.97167119292992865098312904592603e-01,
                               8.78901930932081798530930427659769e-01,
                               8.59252937999905874733030941570178e-01,
                               8.38244768742385515380988181277644e-01,
                               8.15906297430142868343239115347387e-01,
                               7.92278082619136347908295192610240e-01,
                               7.67401242931063154451010177581338e-01,
                               7.41310715094635086508390031667659e-01,
                               7.14044435894534812447886906738859e-01,
                               6.85649309326793465757532430870924e-01,
                               6.56173213432011070977978306473233e-01,
                               6.25659418394658550788278716936475e-01,
                               5.94153454957277893377920463535702e-01,
                               5.61708133125002007091097766533494e-01,
                               5.28377268660437326985856998362578e-01,
                               4.94210838073494529432139188429574e-01,
                               4.59260512309135837671902891088394e-01,
                               4.23584074047897995995981546002440e-01,
                               3.87240163971561468514437365229242e-01,
                               3.50283891950397718861864859718480e-01,
                               3.12771559248185782031725921115139e-01,
                               2.74764712406530109412017282011220e-01,
                               2.36325512461835696154111019495758e-01,
                               1.97512603474731568420352800785622e-01,
                               1.58385339997837770731337059260113e-01,
                               1.19007656055122243432542461505363e-01,
                               7.94438046087556498653370340434776e-02,
                               3.97543267640566369558463577504881e-02,
                               0.0e+00,
                               9.99707559258700140247810850269161e-01, // N = 81
                               9.98237709710559473208490999240894e-01,
                               9.95250573446072817063168258755468e-01,
                               9.90726238699457195657771535479696e-01,
                               9.84722839864250243380183746921830e-01,
                               9.77259949983774300896754994028015e-01,
                               9.68323126854150340037108435353730e-01,
                               9.57916819213792014586772438633488e-01,
                               9.46071837162500095530504040652886e-01,
                               9.32812808278676408590968094358686e-01,
                               9.18149543072899088080873752915068e-01,
                               9.02098806968874455947116075549275e-01,
                               8.84692008701090104594300100870896e-01,
                               8.65959503212259340543255348165985e-01,
                               8.45923985587310967027008246077457e-01,
                               8.24612230833311699029763985890895e-01,
                               8.02060566140252562128409863362322e-01,
                               7.78305651426519640168066871410701e-01,
                               7.53379803438942063920080727257300e-01,
                               7.27318255189927320714105007937178e-01,
                               7.00162977487330140391463828564156e-01,
                               6.71956684614179677872414231387665e-01,
                               6.42739524305579901231055828247918e-01,
                               6.12553889667980522304446822090540e-01,
                               5.81447065829129638991901174449595e-01,
                               5.49467125095128294809398994402727e-01,
                               5.16660607386383086137016107386444e-01,
                               4.83075801686178918359360068279784e-01,
                               4.48764513638163831110716728289844e-01,
                               4.13779204371604814038931863251491e-01,
                               3.78171435473588890552321117866086e-01,
                               3.41994090825758711993387350958074e-01,
                               3.05302441735246787857249728403986e-01,
                               2.68152185007253573978402982902480e-01,
                               2.30598521880719553589500492307707e-01,
                               1.92697580701371246059139252793102e-01,
                               1.54506879379394418405624378465291e-01,
                               1.16084070675255029980732501826424e-01,
                               7.74865883312825937112577889820386e-02,
                               3.87724175060509684831444587871374e-02,
                               0.0e+00,
                               9.99721429324918919867570821224945e-01, // N = 83
                               9.98321588574771601187762826157268e-01,
                               9.95476651842137405523658344463911e-01,
                               9.91167109699016557478046252072090e-01,
                               9.85448238798800613125195013708435e-01,
                               9.78338673561083282947947736829519e-01,
                               9.69823836067798761284564079687698e-01,
                               9.59906891730345823710024433239596e-01,
                               9.48616879571488214040186903730500e-01,
                               9.35976987497853740727293825329980e-01,
                               9.21995207495127644392596266698092e-01,
                               9.06685944758101269869143834512215e-01,
                               8.90078577248639590813183986028889e-01,
                               8.72201511692441089351746086322237e-01,
                               8.53074552370187033645265728409868e-01,
                               8.32721200401360994725052933063125e-01,
                               8.11175322139445431623983040481107e-01,
                               7.88471145047409338602051320776809e-01,
                               7.64637245027556033960536296945065e-01,
                               7.39704803069926142278234237892320e-01,
                               7.13712927612934922017018379847286e-01,
                               6.86701502034951172248611328541301e-01,
                               6.58706241077727683297382554883370e-01,
                               6.29764839072196269675885105243651e-01,
                               5.99921416448969568868676560668973e-01,
                               5.69220941610215858119659060321283e-01,
                               5.37704976253966959731656061194371e-01,
                               5.05416599199405291997777567303274e-01,
                               4.72404286698761111118471944791963e-01,
                               4.38717277051406895349572323539178e-01,
                               4.04401755283383568251309725383180e-01,
                               3.69505022640480851325861522127525e-01,
                               3.34079019574284430404986778739840e-01,
                               2.98176277341824502720157852309057e-01,
                               2.61846368937023177281275820860174e-01,
                               2.25139605633422557051659396165633e-01,
                               1.88110354745297886358557093444688e-01,
                               1.50813354863992277188344814931042e-01,
                               1.13300301683207080283288803457253e-01,
                               7.56232589891624312761209125710593e-02,
                               3.78378939143896100838482254857809e-02,
                               0.0e+00,
                               9.99734432248282289812379985960433e-01, // N = 85
                               9.98399618990062243106820005777990e-01,
                               9.95686728319411629151147735683480e-01,
                               9.91577288340860785176289482478751e-01,
                               9.86123534198684370544185640028445e-01,
                               9.79342508063748340418896987102926e-01,
                               9.71220149713752256559473607921973e-01,
                               9.61759365338204719186876445746748e-01,
                               9.50986859947952956062522389402147e-01,
                               9.38923557354988114198590665182564e-01,
                               9.25576712465747686309214259381406e-01,
                               9.10959724904127354783156533812871e-01,
                               8.95099182807171933617951253836509e-01,
                               8.78020569812173135026966974692186e-01,
                               8.59742209518730704509437146043638e-01,
                               8.40285983261817026601647739880718e-01,
                               8.19682375581742173054067279736046e-01,
                               7.97962053255487524516809116903460e-01,
                               7.75151551255706672272083324060077e-01,
                               7.51279935689480260485595408681547e-01,
                               7.26382365746304881071182535379194e-01,
                               7.00494590556170915185418834880693e-01,
                               6.73649861879432210187701457471121e-01,
                               6.45883388869247565544640110601904e-01,
                               6.17234850884114116809087136061862e-01,
                               5.87744597485109210310838534496725e-01,
                               5.57451443484292208374597521469695e-01,
                               5.26395749931192313830763396254042e-01,
                               4.94621159850633040910850013460731e-01,
                               4.62171912070421797569252930770745e-01,
                               4.29091308587839448396294983467669e-01,
                               3.95423852042975199072571967917611e-01,
                               3.61216369741547693728023205039790e-01,
                               3.26516124465411616828447449734085e-01,
                               2.91369828745837111672045693921973e-01,
                               2.55825079342879013744038729782915e-01,
                               2.19930967478449229668413522631454e-01,
                               1.83736806564854360246386022481602e-01,
                               1.47291623055288006804985911912809e-01,
                               1.10645027208519916572804220322723e-01,
                               7.38473616000984989238276057221810e-02,
                               3.69489431653515221221084630087717e-02,
                               0.0e+00,
                               9.99746457530964471871470777841751e-01, // N = 87
                               9.98472332242507754074267722899094e-01,
                               9.95882724285588105672673009394202e-01,
                               9.91959557593244056761250249110162e-01,
                               9.86752630714975431658331217477098e-01,
                               9.80278220980255521332935586542590e-01,
                               9.72522244949065028940538013557671e-01,
                               9.63486613014079784633736380783375e-01,
                               9.53196590390627984668014960334403e-01,
                               9.41671956847638047527482285659062e-01,
                               9.28918551269247716462018615857232e-01,
                               9.14947907206138832947317496291362e-01,
                               8.99784996804390946323337630019523e-01,
                               8.83453765218616959842279356962536e-01,
                               8.65970246227808715389073768164963e-01,
                               8.47353716209315099838761398132192e-01,
                               8.27632708282065476801392378547462e-01,
                               8.06835964136938477153648818784859e-01,
                               7.84987034881737710811933084187331e-01,
                               7.62111747194954891604368185653584e-01,
                               7.38242982423637394973070513515268e-01,
                               7.13414235268956975488663374562748e-01,
                               6.87655201113672398527398854639614e-01,
                               6.60997313751497839184878557716729e-01,
                               6.33477715195780999302144209650578e-01,
                               6.05134259639601324032298634847393e-01,
                               5.76001743325693649211416413891129e-01,
                               5.46116316660084533118890703917714e-01,
                               5.15518923436850018404697948426474e-01,
                               4.84251176785734704921537741029169e-01,
                               4.52352007556055535353323193703545e-01,
                               4.19861376029269317555758789239917e-01,
                               3.86823366296790649432324471490574e-01,
                               3.53282612864304013111649283018778e-01,
                               3.19281214509383126642916295168106e-01,
                               2.84861998032913399381271801757975e-01,
                               2.50071400103100527356758675523452e-01,
                               2.14956244860518452810538292396814e-01,
                               1.79560810292162004175864353783254e-01,
                               1.43929809510713241360591041484440e-01,
                               1.08111163035700369450253788272676e-01,
                               7.21529908745863340913118122443848e-02,
                               3.61007394374324996899616735390737e-02,
                               0.0e+00,
                               9.99757764519839775552156879712129e-01, // N = 89
                               9.98540200636773844777849262754899e-01,
                               9.96065462440955173839540748303989e-01,
                               9.92316392138515857013203458336648e-01,
                               9.87340194175236884888136046356522e-01,
                               9.81151833077913870795327966334298e-01,
                               9.73737734615330086107576335052727e-01,
                               9.65099650422493016144187549798517e-01,
                               9.55260928192337210873574804281816e-01,
                               9.44239509118193875991664754110388e-01,
                               9.32040696149230352141046296310378e-01,
                               9.18675259984175429650576916174032e-01,
                               9.04165912394972903776135808584513e-01,
                               8.88534238286043165366834273299901e-01,
                               8.71795127436839734080820107919862e-01,
                               8.53966595004710282701410051231505e-01,
                               8.35074442856522436429145272995811e-01,
                               8.15144539645135224326111256232252e-01,
                               7.94198832442848723367490038071992e-01,
                               7.72261479248755766668921296513872e-01,
                               7.49362168787880533749046207958600e-01,
                               7.25531053660716906961170025169849e-01,
                               7.00795870781748986289017011586111e-01,
                               6.75186070666122684080789895233465e-01,
                               6.48735193430612699927451103576459e-01,
                               6.21477345903576172680971012596274e-01,
                               5.93445114446988553069672889250796e-01,
                               5.64672453185470990533190160931554e-01,
                               5.35196366644274279522619508497883e-01,
                               5.05054391388202295054554724629270e-01,
                               4.74283106405047449882772525597829e-01,
                               4.42920174525411547428177527763182e-01,
                               4.11005485816235749396696519397665e-01,
                               3.78579352014707049001174254954094e-01,
                               3.45681495610433653364879091896000e-01,
                               3.12352466502785919288953664363362e-01,
                               2.78634340176660666443808622716460e-01,
                               2.44569456928201617307294668535178e-01,
                               2.10199819285652844680356565731927e-01,
                               1.75568014775516811898370406197500e-01,
                               1.40717523161141305765298170626920e-01,
                               1.05691901708653293590067789864406e-01,
                               7.05345542264027153267491598853667e-02,
                               3.52892369641354466947014145716821e-02,
                               0.0e+00,
                               9.99768258198128423330786063161213e-01, // N = 91
                               9.98603645181936561137092667195247e-01,
                               9.96236484002620437117059282172704e-01,
                               9.92649998447203807394600971747423e-01,
                               9.87889297558341872296239216666436e-01,
                               9.81968715034540529096318550728029e-01,
                               9.74874728599846251952953934960533e-01,
                               9.66608310396894654381583222857444e-01,
                               9.57191624013281616711878996284213e-01,
                               9.46641690995629225824359309626743e-01,
                               9.34962701708230703445678955176845e-01,
                               9.22163936719000210118224458710756e-01,
                               9.08266807683464127975980773044284e-01,
                               8.93291671753241756093188996601384e-01,
                               8.77251587193021764576883469999302e-01,
                               8.60162475960664307805814132734668e-01,
                               8.42048576910406909590278701216448e-01,
                               8.22934220502086088977478084416362e-01,
                               8.02838951166836345407773478655145e-01,
                               7.81784312593906238753049819933949e-01,
                               7.59798164520410823641327624500263e-01,
                               7.36908848945490135839975209819386e-01,
                               7.13141224275491425466100281482795e-01,
                               6.88521680771200461634862222126685e-01,
                               6.63081708602233588223384685989004e-01,
                               6.36853394453223642379668945068261e-01,
                               6.09866054493895526356084246799583e-01,
                               5.82150212569353397995541854470503e-01,
                               5.53740672159348856773419811361236e-01,
                               5.24672820462916300598976704350207e-01,
                               4.94979657498101965895642706527724e-01,
                               4.64695123919634800468969615394599e-01,
                               4.33856843741782960410802161277388e-01,
                               4.02502943858541961663632946510916e-01,
                               3.70669342359731035507763863279251e-01,
                               3.38392654250602553656079862776096e-01,
                               3.05712721866233050338479415586335e-01,
                               2.72669769752378055027719483405235e-01,
                               2.39301853204712033917900271262624e-01,
                               2.05647489783263637264099088497460e-01,
                               1.71748065949780898131749040658178e-01,
                               1.37645205983253027248736088949954e-01,
                               1.03378302832145274603448115158244e-01,
                               6.89869801631440432432285092545499e-02,
                               3.45134487517777116538653103816614e-02,
                               0.0e+00,
                               9.99778151819073701567219814023701e-01, // N = 93
                               9.98663042133818290579938548034988e-01,
                               9.96396428126260058633079097489826e-01,
                               9.92962348906174518958778207888827e-01,
                               9.88403682683398288055798275308916e-01,
                               9.82733669804167098149605408252683e-01,
                               9.75939278300314128067327601456782e-01,
                               9.68021391853992163589737174334005e-01,
                               9.59000582510578958306268759770319e-01,
                               9.48892363446089848189046733750729e-01,
                               9.37700536141863771888438350288197e-01,
                               9.25433798806753804555569331569131e-01,
                               9.12111713155850378775824083277257e-01,
                               8.97752711533942315824674551549833e-01,
                               8.82368961494760961628003315126989e-01,
                               8.65975394866858150244581793231191e-01,
                               8.48594023341959768913511652499437e-01,
                               8.30246837066066167842848244617926e-01,
                               8.10952109491733574841987319814507e-01,
                               7.90730057075274439526424430368934e-01,
                               7.69605935121729034520399181928951e-01,
                               7.47605359615666653638754723942839e-01,
                               7.24751619869023477882308270636713e-01,
                               7.01069512020405793961685958493035e-01,
                               6.76587580423016810016179078957066e-01,
                               6.51334846201997552661566714959918e-01,
                               6.25338836340463721796822937903926e-01,
                               5.98628289712715533354980834701564e-01,
                               5.71234774920969967659800659021130e-01,
                               5.43190330261802412081806323840283e-01,
                               5.14526028633666476785890608880436e-01,
                               4.85273918388164582360388976667309e-01,
                               4.55468160975091074238463306755875e-01,
                               4.25143313282828061439033717761049e-01,
                               3.94333316514864751223257144374656e-01,
                               3.63072877020995887775711707945447e-01,
                               3.31398212978702144670961615702254e-01,
                               2.99345822701870045712269075011136e-01,
                               2.66951828959114290107379474648042e-01,
                               2.34252922206269642568798872162006e-01,
                               2.01286770415851939963758354679157e-01,
                               1.68091179467103307709763271304837e-01,
                               1.34703753620199817575553424831014e-01,
                               1.01162475305584267926128916315065e-01,
                               6.75058073721548634882339001705986e-02,
                               3.37721900160520283051823753339704e-02,
                               0.0e+00,
                               9.99787363335372880612794688204303e-01, // N = 95
                               9.98718728584212067644898525031749e-01,
                               9.96546543724575517586572459549643e-01,
                               9.93255210987768477615134088409832e-01,
                               9.88885792674205510444096489663934e-01,
                               9.83451003071623697238123895658646e-01,
                               9.76937911700182959329197274200851e-01,
                               9.69346787326564318654220642201835e-01,
                               9.60697217836146144520625966833904e-01,
                               9.51003969257708692275343764777062e-01,
                               9.40269961836116774378524496569298e-01,
                               9.28502693012360658109116684499895e-01,
                               9.15720667876155580700014979811385e-01,
                               9.01941329438525118966651916707633e-01,
                               8.87175367212682863815587097633397e-01,
                               8.71436015796896668028637122915825e-01,
                               8.54744023317656531624209037545370e-01,
                               8.37120139899902193647562853584532e-01,
                               8.18580687449319110982060010428540e-01,
                               7.99143754167741859895102152222535e-01,
                               7.78833114428370443249605159508064e-01,
                               7.57672918445438714485362652339973e-01,
                               7.35684106401860882229470917081926e-01,
                               7.12888973409064652386746274714824e-01,
                               6.89314395527633405613698869274231e-01,
                               6.64987747390332728514295013155788e-01,
                               6.39933874489238219140929686545860e-01,
                               6.14178699956373419510669009468984e-01,
                               5.87751987103851236682316994119901e-01,
                               5.60684005934663942660733937373152e-01,
                               5.33002879017402952932513926498359e-01,
                               5.04737583863577476961381762521341e-01,
                               4.75920403113300860553636084659956e-01,
                               4.46584073104855372449151218461338e-01,
                               4.16759379711043709271223178802757e-01,
                               3.86477764084667108068771312900935e-01,
                               3.55773565088884413665226702505606e-01,
                               3.24681486337735913938473686357611e-01,
                               2.93234353977043005201608139032032e-01,
                               2.61465459214974327295522016356699e-01,
                               2.29410670550207917983698280295357e-01,
                               1.97106110279111595984247173873882e-01,
                               1.64586006722905575649917864211602e-01,
                               1.31884866554515062242458611763141e-01,
                               9.90395191785916478854900901751535e-02,
                               6.60869239163558025440536880523723e-02,
                               3.30620601558881954673552172607742e-02,
                               0.0e+00,
                               9.99796069672232223801700001786230e-01, // N = 97
                               9.98771007252425957467778516729595e-01,
                               9.96687331944437593378438577929046e-01,
                               9.93530172266350986021166136197280e-01,
                               9.89338657752443673132347612408921e-01,
                               9.84124583722826629106350537767867e-01,
                               9.77875485474333006052916061889846e-01,
                               9.70591592546247272643711312412051e-01,
                               9.62291159467156820284117202390917e-01,
                               9.52987703160430799087521336332429e-01,
                               9.42683863363016016911899441765854e-01,
                               9.31386690706554554175511384528363e-01,
                               9.19113162182880749639934947481379e-01,
                               9.05879136715569965865313406538917e-01,
                               8.91694605580593546712009356269846e-01,
                               8.76572020274247964977121228002943e-01,
                               8.60530296630311331007590069930302e-01,
                               8.43588261624393487281281522882637e-01,
                               8.25761222530026373078726464882493e-01,
                               8.07066204029442735290444943530019e-01,
                               7.87524837967449320430546322313603e-01,
                               7.67159032515740468838316701294389e-01,
                               7.45988461809639957778017560485750e-01,
                               7.24034130923814855940179313620320e-01,
                               7.01320487752545629334122168074828e-01,
                               6.77872379632663779602808062918484e-01,
                               6.53713194553681820053725459729321e-01,
                               6.28867396776513820633169871143764e-01,
                               6.03362074167368755972518101771129e-01,
                               5.77224726083972461410098730993923e-01,
                               5.50481888618180814631841712980531e-01,
                               5.23160974722233107492286308115581e-01,
                               4.95291390296794198366825412449543e-01,
                               4.66902904750958192003906788158929e-01,
                               4.38024655410838570368525779485935e-01,
                               4.08686481990716943268893146523624e-01,
                               3.78919695568152803399897265990148e-01,
                               3.48755886292161032535830145207001e-01,
                               3.18226241206747473277971494098892e-01,
                               2.87362487355455498150291759884567e-01,
                               2.56197366314654950691931389883393e-01,
                               2.24763790394689466634048358173459e-01,
                               1.93094434019761701515349727742432e-01,
                               1.61222356068891931046849208541971e-01,
                               1.29181210976448440641561887787248e-01,
                               9.70046992094628079961182720580837e-02,
                               6.47264110276269538646332080134016e-02,
                               3.23801709628692702125363211962394e-02,
                               0.0e+00,
                               9.99804199685638605998860839463305e-01, // N = 99
                               9.98820150606635537293698234861949e-01,
                               9.96819814299826467696163945220178e-01,
                               9.93788661944167484030288051144453e-01,
                               9.89764238414064689841609379072906e-01,
                               9.84757895914213032817485782288713e-01,
                               9.78757303031206671306563293910585e-01,
                               9.71762200901555184273661325278226e-01,
                               9.63790018136355119970914984151023e-01,
                               9.54853658674136962503098402521573e-01,
                               9.44955059221329274343759152543498e-01,
                               9.34100294755810023339392955676885e-01,
                               9.22305475453936041141389523545513e-01,
                               9.09585655828073380568810080148978e-01,
                               8.95949624583592951765353973314632e-01,
                               8.81408445573009124984764639521018e-01,
                               8.65980004315145768245542967633810e-01,
                               8.49682119844165750777165158069693e-01,
                               8.32528501487459937635549067636020e-01,
                               8.14534427359855262018584198813187e-01,
                               7.95720320762525079594240651204018e-01,
                               7.76106894345446884919681451719953e-01,
                               7.55711890369514471821332790568704e-01,
                               7.34554254237402393101774578099139e-01,
                               7.12657066705008501728002556774300e-01,
                               6.90043824425132013011818798986496e-01,
                               6.66735700841571632402349223411875e-01,
                               6.42754832419237587259885913226753e-01,
                               6.18126817800879191366902887239121e-01,
                               5.92877694108900121783278791554039e-01,
                               5.67031549495391362647467303759186e-01,
                               5.40613246991726081880358378839446e-01,
                               5.13650628401734365979791618883610e-01,
                               4.86171941452491707114091923358501e-01,
                               4.58203691539029622781242778728483e-01,
                               4.29772993341576259318514985352522e-01,
                               4.00909573929279949844328712060815e-01,
                               3.71643501262285180786193450330757e-01,
                               3.42003195991855746260768000865937e-01,
                               3.12017532119749085861570847555413e-01,
                               2.81717708241029429760970970164635e-01,
                               2.51135178612577114609649697740679e-01,
                               2.20299765509805400842680001005647e-01,
                               1.89241592461813740166931552266760e-01,
                               1.57992877664368286394491747159918e-01,
                               1.26585997269672068110679674646235e-01,
                               9.50516499861236013879661754799599e-02,
                               6.34206849826871726927279837582319e-02,
                               3.17258634590728075264287610934844e-02,
                               0.0e+00,
                               9.99811901364364707944787369342521e-01, // N = 101
                               9.98866404420070685965526990912622e-01,
                               9.96944387018876443384840513317613e-01,
                               9.94031969432090822813563590898411e-01,
                               9.90165010669680323296404367283685e-01,
                               9.85354084048005951501636445755139e-01,
                               9.79587296760769388193068607506575e-01,
                               9.72864385106692153293295177718392e-01,
                               9.65201651066145083213143607281381e-01,
                               9.56610955242807925458237150451168e-01,
                               9.47094034244939653177652871818282e-01,
                               9.36656618944877616961264266137732e-01,
                               9.25313546474801684738054063927848e-01,
                               9.13078556655792072938027104100911e-01,
                               8.99959887564294458428548750816844e-01,
                               8.85967979523613058390196783875581e-01,
                               8.71119198204099887128393220336875e-01,
                               8.55429769429945974223983284900896e-01,
                               8.38912586967224371825579964934150e-01,
                               8.21582070859335766854769644851331e-01,
                               8.03456868050459127594820074591553e-01,
                               7.84555832900399541252056678786175e-01,
                               7.64895679372351477987024281901540e-01,
                               7.44494302226068382921653210360091e-01,
                               7.23372766022592594836737589503173e-01,
                               7.01552468706821974464560298656579e-01,
                               6.79053389406747531786834315425949e-01,
                               6.55896465685439244985843743052101e-01,
                               6.32105068445064643967157280712854e-01,
                               6.07702927184949559524795859033475e-01,
                               5.82712817817836126188524303870508e-01,
                               5.57158304514649982408514006237965e-01,
                               5.31064824522707978893265590158990e-01,
                               5.04458144907464434147925658180611e-01,
                               4.77363392233042638235218646514113e-01,
                               4.49806334974038601881574095386895e-01,
                               4.21814157310613335738480600412004e-01,
                               3.93414311897564872300137039928813e-01,
                               3.64633828861614051053408047664561e-01,
                               3.35500245419437514993177273936453e-01,
                               3.06042119229184006456989664002322e-01,
                               2.76288193779532342819749146656250e-01,
                               2.46266947398144003811282232163649e-01,
                               2.16007236876041841533435672317864e-01,
                               1.85538581722772905058249648391211e-01,
                               1.54890589998145700167953009440680e-01,
                               1.24092724359160286318193300303392e-01,
                               9.31747015600867395379580671033182e-02,
                               6.21665648194164380258008861801500e-02,
                               3.10983383271895494348591171274165e-02,
                               0.0e+00,
                               9.99819112765990558600037729775067e-01, // N = 103
                               9.98909990848903195370667162933387e-01,
                               9.97061892790189085999941198679153e-01,
                               9.94261260436752225544410066504497e-01,
                               9.90542561209446725811744727252517e-01,
                               9.85915991735902719206308120192261e-01,
                               9.80369811985698280665246784337796e-01,
                               9.73903368019323756321625751297688e-01,
                               9.66532262529666730266342256072676e-01,
                               9.58267848613908346244727454177337e-01,
                               9.49111298412882331554385473282309e-01,
                               9.39067544002962550919733075716067e-01,
                               9.28150705207862136703056421538349e-01,
                               9.16373862309780018442495475028409e-01,
                               9.03744267561153669099383023421979e-01,
                               8.90271218029527466875094887654996e-01,
                               8.75970232505341006579158147360431e-01,
                               8.60856711182292344552990925876657e-01,
                               8.44942229630138208484879669413203e-01,
                               8.28239763823064967240838996076491e-01,
                               8.10766967185254872063637776591349e-01,
                               7.92541712099381068235004477173788e-01,
                               7.73579112391981738028334802947938e-01,
                               7.53895354485375368547295238386141e-01,
                               7.33510375203127340526521038555074e-01,
                               7.12444457577036005524462325411150e-01,
                               6.90715739487578916921961535990704e-01,
                               6.68343221175369928133136454562191e-01,
                               6.45349038152381093702558700897498e-01,
                               6.21755704600723380082172297989018e-01,
                               5.97583952754948355412523142149439e-01,
                               5.72855216351303542232642485032557e-01,
                               5.47593624977224080474513812077930e-01,
                               5.21823669366185516338418892701156e-01,
                               4.95568268590575622400962174651795e-01,
                               4.68850904286041147983610244409647e-01,
                               4.41697422430716302166331388434628e-01,
                               4.14133983226303847846594408110832e-01,
                               3.86185284311379217747628445067676e-01,
                               3.57876456688409227968605819114600e-01,
                               3.29234735898236097195734828346758e-01,
                               3.00287606335331858087300815896015e-01,
                               2.71061127323951434053839193438762e-01,
                               2.41581666447798659724810477200663e-01,
                               2.11877487738543840434246590120893e-01,
                               1.81977026957077708813059757630981e-01,
                               1.51907278395672029613905351652647e-01,
                               1.21695421018888833009086170022783e-01,
                               9.13703630258353993731645914522232e-02,
                               6.09611001505786023746402690903778e-02,
                               3.04951270720150574566886803040688e-02,
                               0.0e+00,
                               9.99825958605753184471609529282432e-01, // N = 105
                               9.98951111103950406544527140795253e-01,
                               9.97172647272209999869119201321155e-01,
                               9.94477590929216059834061525180005e-01,
                               9.90898929927916505278062686556950e-01,
                               9.86446195651550006289198790909722e-01,
                               9.81108058725305931524474090110743e-01,
                               9.74883884221744767550887900142698e-01,
                               9.67788315389516373699052564916201e-01,
                               9.59831826933086773578907013870776e-01,
                               9.51015450880597801308624639204936e-01,
                               9.41343853641359307182767679478275e-01,
                               9.30830086101182008206933460314758e-01,
                               9.19486128916425005108692403155146e-01,
                               9.07318797865176551731281051615952e-01,
                               8.94336890534495387861113613325870e-01,
                               8.80554655409332864834937026898842e-01,
                               8.65986162846067886178502703842241e-01,
                               8.50642328731863406332536214904394e-01,
                               8.34535432326734660790634734439664e-01,
                               8.17681643545920544546845576405758e-01,
                               8.00097283430468486642439529532567e-01,
                               7.81796625447064630343163571524201e-01,
                               7.62794995193745162254117531119846e-01,
                               7.43110643846613960761260386789218e-01,
                               7.22762099749983621954640966578154e-01,
                               7.01766516625169423093666409840807e-01,
                               6.80141904227168136998216141364537e-01,
                               6.57908531247582750722813216270879e-01,
                               6.35086977695245913366761669749394e-01,
                               6.11696885293400938188312920829048e-01,
                               5.87758604979579324378846649779007e-01,
                               5.63294244766945118030321282276418e-01,
                               5.38326209285827195216711515968200e-01,
                               5.12876260540496620166095453896560e-01,
                               4.86966745698095837546759412362007e-01,
                               4.60621364092353102748234050523024e-01,
                               4.33864067718762014269628934926004e-01,
                               4.06718373143070577313551439146977e-01,
                               3.79208269116093732442607233679155e-01,
                               3.51358750909551098562388915524934e-01,
                               3.23195003434807837106035321994568e-01,
                               2.94741926173722801340915111723007e-01,
                               2.66024783605001813313606362498831e-01,
                               2.37069537757488429940977425758319e-01,
                               2.07902264156365673697379747864034e-01,
                               1.78548866175569198588846120401286e-01,
                               1.49035508606948974286154907531454e-01,
                               1.19388766921929054265483216568100e-01,
                               8.96352446489004223151297878757759e-02,
                               5.98014644188371788380287341624353e-02,
                               2.99141097973383701669192191729962e-02,
                               0.0e+00,
                               9.99832384738033597137984997971216e-01, // N = 107
                               9.98989947776328324202665953635005e-01,
                               9.97277351123438626778749949153280e-01,
                               9.94681919308007533864213201013627e-01,
                               9.91235411120107601234963112801779e-01,
                               9.86947035023371777029410623072181e-01,
                               9.81805625337224818771630907576764e-01,
                               9.75810233714985097996930107910885e-01,
                               9.68974906490348009135971096839057e-01,
                               9.61309694623136312685574011993594e-01,
                               9.52815174340658432861062010488240e-01,
                               9.43495353464442354507468735391740e-01,
                               9.33362684473861281553297430946259e-01,
                               9.22428603042812378376424931047950e-01,
                               9.10699111184307463773279778251890e-01,
                               8.98182057875426931303763922187500e-01,
                               8.84890990273399680177135451231152e-01,
                               8.70839297558241520746946662256960e-01,
                               8.56036800652357321439467341406271e-01,
                               8.40494576545801619360531731217634e-01,
                               8.24227972761158889092314439039910e-01,
                               8.07252498416895725164010855223751e-01,
                               7.89581092738756873394834201462800e-01,
                               7.71227654925532357665929339418653e-01,
                               7.52209500084542903586282136529917e-01,
                               7.32544230807510521330527808459010e-01,
                               7.12247460236342666561881742381956e-01,
                               6.91335575601366714160178617021302e-01,
                               6.69827815209352417369359500298742e-01,
                               6.47743743916510239522210667928448e-01,
                               6.25101287234140157167416873562615e-01,
                               6.01919005713769661447543057875009e-01,
                               5.78217909362410575901947140664561e-01,
                               5.54019328277068012766903848387301e-01,
                               5.29343163098038194114280940993922e-01,
                               5.04209831657133733529008168261498e-01,
                               4.78641899588388042285913570594857e-01,
                               4.52662219461845760637430657880032e-01,
                               4.26292331993750106544638356353971e-01,
                               3.99554186953953061056665774231078e-01,
                               3.72471646187148619500106860868982e-01,
                               3.45068808495722412210682250588434e-01,
                               3.17368513608647651036420711534447e-01,
                               2.89393906451626048426106763145071e-01,
                               2.61169855111708648642832031327998e-01,
                               2.32721403724272662971728209413413e-01,
                               2.04072341864729916993681513304182e-01,
                               1.75246662155325721998977428484068e-01,
                               1.46269927516438108527907502320886e-01,
                               1.17167809071955383859453547756857e-01,
                               8.79646898408178723460792980404221e-02,
                               5.86850543002596578001650584610616e-02,
                               2.93548347565188230690047532789322e-02,
                               0.0e+00,
                               9.99838496991500957911114255693974e-01, // N = 109
                               9.99026666867340762401283882354619e-01,
                               9.97376257556823131444900809583487e-01,
                               9.94875117018338972485480553586967e-01,
                               9.91553698211184442179444431531010e-01,
                               9.87420637397343425867290989117464e-01,
                               9.82465151950908555100738794862991e-01,
                               9.76686328857903185429734094213927e-01,
                               9.70097391469713077327696737484075e-01,
                               9.62707645785923493697566755145090e-01,
                               9.54517572854841733764885702839820e-01,
                               9.45530975164995735049444647302153e-01,
                               9.35759401075758279198169020673959e-01,
                               9.25213359866651430252204590942711e-01,
                               9.13898506039289570956896113784751e-01,
                               9.01822286284701291059207051148405e-01,
                               8.88997178496309548023646129877307e-01,
                               8.75435454065568774417727127001854e-01,
                               8.61146397234632821060529295209562e-01,
                               8.46140515970772555398582426278153e-01,
                               8.30431910430066477779575961903902e-01,
                               8.14034785913567704440652050834615e-01,
                               7.96961390914122658202245474967640e-01,
                               7.79224915346254154435712280246662e-01,
                               7.60841255928319748491617247054819e-01,
                               7.41826538809184032885468695894815e-01,
                               7.22195561816759812323596179339802e-01,
                               7.01963889719172673409275375888683e-01,
                               6.81149186997542011035022824216867e-01,
                               6.59769387631983339481678285665112e-01,
                               6.37841506713889505597592233243631e-01,
                               6.15383198331127312386001904087607e-01,
                               5.92413763456913988747487564978655e-01,
                               5.68952768195209790391686510702129e-01,
                               5.45019138816307258110782640869729e-01,
                               5.20632334385933037701477132941363e-01,
                               4.95813099347452879150921489781467e-01,
                               4.70582412481382328373058498982573e-01,
                               4.44960809469015783346179659929476e-01,
                               4.18969263255204171780832211879897e-01,
                               3.92629727027398955918613410176476e-01,
                               3.65964340372190832795240567065775e-01,
                               3.38994942740873717035299250710523e-01,
                               3.11743720834467996638750264537521e-01,
                               2.84233571955057440217018438488594e-01,
                               2.56487520069996810523349495269940e-01,
                               2.28528396646337894626554998467327e-01,
                               2.00379293606213509937319372511411e-01,
                               1.72063765976273014279840367635188e-01,
                               1.43605427316255751524209927083575e-01,
                               1.15027783942082142965013247248862e-01,
                               8.63545182632479008111303642181156e-02,
                               5.76095412484042002088102663037716e-02,
                               2.88167481993414215102333741924667e-02,
                               0.0e+00,
                               9.99844247854056455970805927790934e-01, // N = 111
                               9.99061419564818642413683846825734e-01,
                               9.97469953387629004737391369417310e-01,
                               9.95057977847412122862635897035943e-01,
                               9.91854854685616071918730085599236e-01,
                               9.87868941198889349841749663028168e-01,
                               9.83089623421721348073276658396935e-01,
                               9.77515735503988958399190778436605e-01,
                               9.71159987429690008120530819724081e-01,
                               9.64031328593135117266399447544245e-01,
                               9.56129870134652115609696920728311e-01,
                               9.47458868041210822141806602303404e-01,
                               9.38029367680076719970827525685309e-01,
                               9.27851424720791739808589682070306e-01,
                               9.16930017610292913410319215472555e-01,
                               9.05271800743999932592487311922014e-01,
                               8.92888667147356818176717752066907e-01,
                               8.79792322419895689300517460651463e-01,
                               8.65991135401215306188760223449208e-01,
                               8.51494606617154925487511718529277e-01,
                               8.36316151070498836617161941831000e-01,
                               8.20469298559321047470405119383940e-01,
                               8.03965178084336096198114773869747e-01,
                               7.86815781127622404511612330679782e-01,
                               7.69036222838821337255410526267951e-01,
                               7.50641856348021607736598070914624e-01,
                               7.31646182790427701547741889953613e-01,
                               7.12063399986637701744029982364736e-01,
                               6.91910308531763162953609480609884e-01,
                               6.71203990319826027111105304356897e-01,
                               6.49960011187695307910416886443272e-01,
                               6.28194512249927727864928783674259e-01,
                               6.05925868530523548116661913809367e-01,
                               5.83172738026031867164533650793601e-01,
                               5.59952469474765179846542650921037e-01,
                               5.36282885908343276426535339851398e-01,
                               5.12183768360713331802003267512191e-01,
                               4.87675158187473589688210040549166e-01,
                               4.62775909679958630249529960565269e-01,
                               4.37505260037174437126594739311258e-01,
                               4.11884189528080923992092721164227e-01,
                               3.85933900740979385357576347814756e-01,
                               3.59674472333918637811933649572893e-01,
                               3.33126278890023941325893019893556e-01,
                               3.06311265931144161012156246215454e-01,
                               2.79251553200806246213261374577996e-01,
                               2.51968156052061742489200923955650e-01,
                               2.24482300647845550711778628283355e-01,
                               1.96816644257305217724507429011283e-01,
                               1.68993963646873357475897137192078e-01,
                               1.41035916797047605752979393400892e-01,
                               1.12964288059329065472269348902046e-01,
                               8.48021794792412353380939293856500e-02,
                               5.65727538183364089818816466959106e-02,
                               2.82980127344324081106741175517527e-02,
                               0.0e+00,
                               9.99849727701272672497623261733679e-01, // N = 113
                               9.99094343801465445409348831162788e-01,
                               9.97558643017585011669723371596774e-01,
                               9.95231226081069730859951505408389e-01,
                               9.92140296283393618992363371944521e-01,
                               9.88293715540161543664510190865258e-01,
                               9.83681226358892768502073522540741e-01,
                               9.78301709140256603447483030322473e-01,
                               9.72167163223401575855575629248051e-01,
                               9.65285901905490129060183335241163e-01,
                               9.57657974899251973610603272391018e-01,
                               9.49286479561962992512746950524161e-01,
                               9.40181691354067039512187875516247e-01,
                               9.30352880247496294430220586946234e-01,
                               9.19804746997011868359095387859270e-01,
                               9.08543620420655617664351666462608e-01,
                               8.96580487561356997971984128525946e-01,
                               8.83926108327827808608390114386566e-01,
                               8.70588412638168884782885470485780e-01,
                               8.56576433762749056555207971541677e-01,
                               8.41902531226671468900235595356207e-01,
                               8.26579132142881811695644955761964e-01,
                               8.10616794710246946209508678293787e-01,
                               7.94026922893866782260374748148024e-01,
                               7.76823431109068818223306607251288e-01,
                               7.59020422705128594564882860140642e-01,
                               7.40630719964353811946011774125509e-01,
                               7.21667834450188117045854596653953e-01,
                               7.02147232370385232513854134595022e-01,
                               6.82084612694471070781787602754775e-01,
                               6.61494777796274080472471723624039e-01,
                               6.40393106807006895486722442001337e-01,
                               6.18796522289203010380731484474381e-01,
                               5.96722182770663245321429712930694e-01,
                               5.74186613536352252751271407760214e-01,
                               5.51206824855534627261022251332179e-01,
                               5.27801045241467758906139806640567e-01,
                               5.03987718384381611080868879071204e-01,
                               4.79784841393908645379440258693649e-01,
                               4.55210814878459546495292897816398e-01,
                               4.30284986026011395665591408032924e-01,
                               4.05026880927091159634301220648922e-01,
                               3.79455715295564433020558681164403e-01,
                               3.53591032174954633671148940265994e-01,
                               3.27453083667926803101977384358179e-01,
                               3.01062253867220630532131053769263e-01,
                               2.74438719000083708454695852196892e-01,
                               2.47602909434337076222121254431840e-01,
                               2.20575748906897434187257545090688e-01,
                               1.93378238635275478962682882411173e-01,
                               1.66031252361970665942791924862831e-01,
                               1.38555846810376304123479940244579e-01,
                               1.10973369857817541483946399694105e-01,
                               8.33051868224354424841138211377256e-02,
                               5.55726024759832515353963344750809e-02,
                               2.77970352872756037987400645761227e-02,
                               0.0e+00,
                               9.99854894687858819501968810072867e-01, // N = 115
                               9.99125565625262779256843259645393e-01,
                               9.97642821235557586412312502943678e-01,
                               9.95395523678430427239050004573073e-01,
                               9.92410902746466483392850932432339e-01,
                               9.88696577650222119260092767945025e-01,
                               9.84242460410267527848304780491162e-01,
                               9.79047226709469309291478111845208e-01,
                               9.73122431304167201382426810596371e-01,
                               9.66476085171886878377733864908805e-01,
                               9.59107936500770974497243059886387e-01,
                               9.51020626447876771258904682326829e-01,
                               9.42224004691850636206140734429937e-01,
                               9.32726961067101845159754702763166e-01,
                               9.22533631336081350049482807662571e-01,
                               9.11649678521391004792917556187604e-01,
                               9.00085598710066991934297675470589e-01,
                               8.87851678882221384547790421493119e-01,
                               8.74955079071092045595037234306801e-01,
                               8.61403983262046923918830998445628e-01,
                               8.47210176685496585413659431651467e-01,
                               8.32385521150439511295360262010945e-01,
                               8.16939630046407683217069006786915e-01,
                               8.00882894547218393554999238403980e-01,
                               7.84228572848437277542643641936593e-01,
                               7.66990119359450495117869195382809e-01,
                               7.49179258825715121972166343766730e-01,
                               7.30808344744523608049746599135688e-01,
                               7.11892115406623671169938916136744e-01,
                               6.92445551199517894680468543811003e-01,
                               6.72482224206294443291653806227259e-01,
                               6.52016228280976939402080461150035e-01,
                               6.31063701810954391646646399749443e-01,
                               6.09641032908715407856448109669145e-01,
                               5.87763403337325129882628971245140e-01,
                               5.65446429269236716663726838305593e-01,
                               5.42707517864783994809840805828571e-01,
                               5.19564311391187527711110760719748e-01,
                               4.96033369800928214399249327470898e-01,
                               4.72131609517975669998435250818147e-01,
                               4.47877541072230322960479043103987e-01,
                               4.23289881451563765324408450396731e-01,
                               3.98386335255423662538021289947210e-01,
                               3.73184890086593945568438357440755e-01,
                               3.47704970207239949520072741506738e-01,
                               3.21966168395378227184977504293784e-01,
                               2.95987095315011106144709174259333e-01,
                               2.69786573161838683088120660613640e-01,
                               2.43384732641507312012052466343448e-01,
                               2.16801828796123863263289877068019e-01,
                               1.90057134279709577517891716524900e-01,
                               1.63170062591264264373336345670396e-01,
                               1.36161230978666281110633917705854e-01,
                               1.09051332808787634909286623496882e-01,
                               8.18600540328312115123665648752649e-02,
                               5.46071510016465644365979414942558e-02,
                               2.73134992669634146800206053740112e-02,
                               0.0e+00,
                               9.99859826449020050453952990210382e-01, // N = 117
                               9.99155200407386479000138024275657e-01,
                               9.97722653989439822730389550997643e-01,
                               9.95551476597290818659757860586978e-01,
                               9.92667865432662055447110560635338e-01,
                               9.89079008248442415052181786450092e-01,
                               9.84775148347481366073452591081150e-01,
                               9.79755014694350223614094375079731e-01,
                               9.74029544612234343681222981103929e-01,
                               9.67606202502923951058733109675813e-01,
                               9.60484700511014533041986851458205e-01,
                               9.52667557518869112520576436509145e-01,
                               9.44163963446301823800865804514615e-01,
                               9.34982137588259321070438545575598e-01,
                               9.25125993163076643099884677212685e-01,
                               9.14600928564352377847512798325624e-01,
                               9.03416667513910032205615152633982e-01,
                               8.91582692022030554035438854043605e-01,
                               8.79105801417309762335605682892492e-01,
                               8.65993794074807476945920825528447e-01,
                               8.52257556804856264420777733903378e-01,
                               8.37908013339372925720738294330658e-01,
                               8.22954303007449095019865126232617e-01,
                               8.07406327913088306402755733870436e-01,
                               7.91276323986599416926424055418465e-01,
                               7.74576681749652551367546493565897e-01,
                               7.57318558012922804500988149811747e-01,
                               7.39513731020042031083505662536481e-01,
                               7.21175801585986597785904450574890e-01,
                               7.02318571153908055570980195625452e-01,
                               6.82954968823778152398062957217917e-01,
                               6.63098445332125141504775456269272e-01,
                               6.42763898439352110436573184415465e-01,
                               6.21966435263078820661064582964173e-01,
                               6.00720539162537092714444497687509e-01,
                               5.79041135130225259608494070562301e-01,
                               5.56944300711045836571599920716835e-01,
                               5.34446309648847872608712350483984e-01,
                               5.11562988962252607194614029140212e-01,
                               4.88310537216718187902841918912600e-01,
                               4.64706061824322724795877093129093e-01,
                               4.40766839186839565201125878957100e-01,
                               4.16509828690222960734246271385928e-01,
                               3.91952296330753180431116788895451e-01,
                               3.67112205963718629675440752180293e-01,
                               3.42007653597995564531686341069872e-01,
                               3.16656515968480156697495431217249e-01,
                               2.91076914311109324895454619763768e-01,
                               2.65287478030947765361702295194846e-01,
                               2.39306924966153522493783611935214e-01,
                               2.13153829911464171020796243283257e-01,
                               1.86846951835761582172423800329852e-01,
                               1.60405381814621633695949753928289e-01,
                               1.33848250595466650159082178106473e-01,
                               1.07194608263487964339155666948500e-01,
                               8.04636302141423925826657637117023e-02,
                               5.36746560008261944241247931586258e-02,
                               2.68470123659424186879363105617813e-02,
                               0.0e+00,
                               9.99864485999864660570324303989764e-01, // N = 119
                               9.99183353909294691419518130715005e-01,
                               9.97798561090643354454243763029808e-01,
                               9.95699640383245987429461365536554e-01,
                               9.92911916659194870860005721624475e-01,
                               9.89442365133731072113221216568490e-01,
                               9.85281396661880193299509755888721e-01,
                               9.80427573956715758818347694614204e-01,
                               9.74891446852234833109207556844922e-01,
                               9.68680221681781583598080942465458e-01,
                               9.61793363870761974787626513716532e-01,
                               9.54233009376951435420721736591076e-01,
                               9.46007985309327059653128344507422e-01,
                               9.37126190353453569770181275089271e-01,
                               9.27591062944103317278177200932987e-01,
                               9.17407438788155227271658986865077e-01,
                               9.06584626937524951095781489129877e-01,
                               8.95131711743472280318201228510588e-01,
                               8.83054841403417944967202402040130e-01,
                               8.70361094292882442324810199352214e-01,
                               8.57060873086851637836502959544305e-01,
                               8.43164625816872237429322467505699e-01,
                               8.28680690050779378275080944149522e-01,
                               8.13618107288211267480448896094458e-01,
                               7.97988559567177402342963432602119e-01,
                               7.81803889862361156559700248180889e-01,
                               7.65074321108725863282984391844366e-01,
                               7.47810645278640606647968525066972e-01,
                               7.30025846901660835364111790113384e-01,
                               7.11733118677198017820728637161665e-01,
                               6.92944340065247521565083843597677e-01,
                               6.73671864504937212281276970315957e-01,
                               6.53929922889664339002990800508996e-01,
                               6.33732966238849892981477296416415e-01,
                               6.13094328338653959953319372289116e-01,
                               5.92027740704030080998165885830531e-01,
                               5.70548578313916920912163277535001e-01,
                               5.48672427808396534487656026612967e-01,
                               5.26413882543813826941914157941937e-01,
                               5.03787866557718233551099729083944e-01,
                               4.80810766222562524507821990482626e-01,
                               4.57499158253266813289883430115879e-01,
                               4.33868700218387415290521857968997e-01,
                               4.09935317810419252992915062350221e-01,
                               3.85716254483585652135246846228256e-01,
                               3.61228914169794967925497530814027e-01,
                               3.36489819509034782107903538417304e-01,
                               3.11515700803013495523430265166098e-01,
                               2.86324488375485852742485803901218e-01,
                               2.60934237342811625737226677301805e-01,
                               2.35362131666981638788982422738627e-01,
                               2.09625503392036560690314672683598e-01,
                               1.83742787853736933012527288155979e-01,
                               1.57732505587858146123281244399550e-01,
                               1.31612293928506179918613838708552e-01,
                               1.05399879016344150128858814241539e-01,
                               7.91140112194403666290298815511051e-02,
                               5.27734840883100908559555364263360e-02,
                               2.63961772670387659345259123711003e-02,
                               0.0e+00,
                               9.99868940397354744042957008787198e-01, // N = 121
                               9.99210123227435853543454413738800e-01,
                               9.97870677972810815603565970377531e-01,
                               9.95840525118838137963450662937248e-01,
                               9.93144065090209360313622255489463e-01,
                               9.89787895222221880686674921889789e-01,
                               9.85762734034170584607181808678433e-01,
                               9.81067201752598094799395767040551e-01,
                               9.75711308690630829687506775371730e-01,
                               9.69701788765052641316799508786062e-01,
                               9.63038090441001637387330447381828e-01,
                               9.55722255839995926685048743820516e-01,
                               9.47762543370821441968132603506092e-01,
                               9.39166276116423337505523250001715e-01,
                               9.29936713783543367206618768250337e-01,
                               9.20078476177627391230373632424744e-01,
                               9.09600210102026740521807823824929e-01,
                               8.98510310810045731422235348873073e-01,
                               8.86814628766955048710940445744200e-01,
                               8.74519922646898484330790779495146e-01,
                               8.61635826127129189622166904882761e-01,
                               8.48171984785929811145877010858385e-01,
                               8.34136340635023287859439733438194e-01,
                               8.19537526162145479879939102829667e-01,
                               8.04386348421674890474264429940376e-01,
                               7.88693739932263659930811172671383e-01,
                               7.72469446343257204468102372629801e-01,
                               7.55723775306585521249758130579721e-01,
                               7.38468736789273050291626532271039e-01,
                               7.20716513355730614698302360920934e-01,
                               7.02478440712774987453315134189324e-01,
                               6.83766327381355343284496939304518e-01,
                               6.64593339488917966839665041334229e-01,
                               6.44972828489476568414318080613157e-01,
                               6.24917533728280072402583300572587e-01,
                               6.04440597048510275257626744860318e-01,
                               5.83556249655679537546859592112014e-01,
                               5.62278900753944377299831103300676e-01,
                               5.40622515318440521880916094232816e-01,
                               5.18601400058569916851070047414396e-01,
                               4.96230730931717545217907172627747e-01,
                               4.73525841761707255717084308344056e-01,
                               4.50501745628638761154149960930226e-01,
                               4.27173741583078470096523915344733e-01,
                               4.03557809082794538557692476388183e-01,
                               3.79670056576798142788931045288336e-01,
                               3.55526365012931999665113380615367e-01,
                               3.31142848268448197757152229314670e-01,
                               3.06536132423845697481112893001409e-01,
                               2.81722937423261932110563066089526e-01,
                               2.56719828242537528861788587164483e-01,
                               2.31543551376029554944580013398081e-01,
                               2.06211210860876931194596295426891e-01,
                               1.80739964873425501545867177810578e-01,
                               1.55146875314619403507521155916038e-01,
                               1.29449135396945080866970556598972e-01,
                               1.03664149738055655358692774825613e-01,
                               7.78093339495365687863426273906953e-02,
                               5.19020575387993676752529381701606e-02,
                               2.59597723012477965554012371285353e-02,
                               0.0e+00,
                               9.99873156841666665961554372188402e-01, // N = 123
                               9.99235597631363381410096735635307e-01,
                               9.97939362912048655296359811472939e-01,
                               9.95974599815120154033820654149167e-01,
                               9.93364923890532991457291700498899e-01,
                               9.90116745232517247998771381389815e-01,
                               9.86220946061099223989288020675303e-01,
                               9.81676011284037142168301670608344e-01,
                               9.76491611476062559837885146407643e-01,
                               9.70674258833183034589353610499529e-01,
                               9.64223199293384292118958001083229e-01,
                               9.57140151912984293858244200237095e-01,
                               9.49433064026402484536504289280856e-01,
                               9.41108986681361003867607450956712e-01,
                               9.32170778558261137192175738164224e-01,
                               9.22622581382954942696983380301390e-01,
                               9.12472689684431403911446523125051e-01,
                               9.01729162474001366689435599255376e-01,
                               8.90397296633347767880195533507504e-01,
                               8.78483237214880974264019641850609e-01,
                               8.65996207556978703223649063147604e-01,
                               8.52945450847663377835772280377569e-01,
                               8.39338225221052502966756492241984e-01,
                               8.25182428108660159793430466379505e-01,
                               8.10488396698326396538902827160200e-01,
                               7.95266599282359432088185258180602e-01,
                               7.79525982934400674118080587504664e-01,
                               7.63276011172312029984254877490457e-01,
                               7.46528169802813335031999031343730e-01,
                               7.29294123449465536701552537124371e-01,
                               7.11584308053892944379015261802124e-01,
                               6.93409590894490612811296159634367e-01,
                               6.74782568703803486975800751679344e-01,
                               6.55716032095070788798807370767463e-01,
                               6.36221732403661754950974227540428e-01,
                               6.16311785197921735424131384206703e-01,
                               5.95999818721726248860193209111458e-01,
                               5.75299651350830498763855302968295e-01,
                               5.54224184709951606109257227217313e-01,
                               5.32786626502925186876780117017915e-01,
                               5.11001529803897236448051444313023e-01,
                               4.88883622262252126589032741321716e-01,
                               4.66446791250155978758584751631133e-01,
                               4.43705176538531753660521417259588e-01,
                               4.20674130015539771143551206478151e-01,
                               3.97369154725756679180648234250839e-01,
                               3.73804956537792554271959488687571e-01,
                               3.49996442204067115255838871235028e-01,
                               3.25959622107470647911497962923022e-01,
                               3.01710628963030746962914463438210e-01,
                               2.77264816096504940201583622183534e-01,
                               2.52637687169053049007771960532409e-01,
                               2.27845760080053222340623619857070e-01,
                               2.02905642518058815237935732511687e-01,
                               1.77833160508530901955381864354422e-01,
                               1.52644240230815381176299183607625e-01,
                               1.27355748407546320866146061234758e-01,
                               1.01984606562274149332836259418400e-01,
                               7.65469356526298355669624129404838e-02,
                               5.10589067079742220389704243643791e-02,
                               2.55375714453470840925586315961482e-02,
                               0.0e+00};

// The array of Kronrod weights
static const double Weight[] = {
  5.55555555555555802271783250034787e-01, // N = 3
  8.88888888888888839545643349993043e-01,
  1.97979797979798310958443607887602e-01, // N = 5
  4.90909090909090739529574420885183e-01, 6.22222222222222343113173792517046e-01,
  1.04656226026467708001277401308471e-01, // N = 7
  2.68488089868333834608904453489231e-01, 4.01397414775962579902568450052058e-01,
  4.50916538658474641554363415707485e-01,
  6.29773736654729299200283776372089e-02, // N = 9
  1.70053605335722224367600574623793e-01, 2.66798340452284177271025100708357e-01,
  3.26949189601452139264381457905984e-01, 3.46442981890136114664358046866255e-01,
  4.25820367510814992706436044045404e-02, // N = 11
  1.15233316622473352941469215693360e-01, 1.86800796556492704203478183444531e-01,
  2.41040339228647398917004807117337e-01, 2.72849801912559364325261412886903e-01,
  2.82987417857491263539770898205461e-01,
  3.03961541198198813285014097118619e-02, // N = 13
  8.36944404469071312480110691467416e-02, 1.37320604634446341574260941342800e-01,
  1.81071994323137114291100147056568e-01, 2.13209652271962923908432685493608e-01,
  2.33770864116994686598971497915045e-01, 2.41072580173465278452482607463025e-01,
  2.29353220105290855901358781920862e-02, // N = 15
  6.30920926299782247603786800027592e-02, 1.04790010322249771412828067695955e-01,
  1.40653259715525863482454838049307e-01, 1.69004726639266911192294173815753e-01,
  1.90350578064785225240740373919834e-01, 2.04432940075298913429335811997589e-01,
  2.09482141084727430113687773882702e-01,
  1.78223833207103513065483468835737e-02, // N = 17
  4.94393950021396119676175828772102e-02, 8.24822989313585691606434124878433e-02,
  1.11646370826840243828392829072982e-01, 1.36263109255171682709928404619859e-01,
  1.56652606168187102930744458717527e-01, 1.72070608555212584134253006595827e-01,
  1.81400025068034459474475283968786e-01, 1.84446405744691427353032509017794e-01,
  1.43047756438394544492576088146052e-02, // N = 19
  3.96318951602609714779390515104751e-02, 6.65181559402738958874934382947686e-02,
  9.07906816887268930393872778950026e-02, 1.11789134684419061427362862559676e-01,
  1.30001406855340173596147224088782e-01, 1.45239588384365431172895455347316e-01,
  1.56413527788484357783360678695317e-01, 1.62862827440115903732120727909205e-01,
  1.64896012828349813883477281706291e-01,
  1.16946388673721448497877517525012e-02, // N = 21
  3.25581623079650439578358600556385e-02, 5.47558965743512385260238772843877e-02,
  7.50396748109193878484290962660452e-02, 9.31254545836976144190799686839455e-02,
  1.09387158802297462800723337750242e-01, 1.23491976262065136782375418533775e-01,
  1.34709217311474449552122223394690e-01, 1.42775938577059724465811996196862e-01,
  1.47739104901337736652777721246821e-01, 1.49445554002917535552086292227614e-01,
  9.76544104596046430577516161974927e-03, // N = 23
  2.71565546821052362924664436150124e-02, 4.58293785644262596790099451027345e-02,
  6.30974247503747198706491872144397e-02, 7.86645719322274644680348387737467e-02,
  9.29530985969004713842522846789507e-02, 1.05872074481388703248718741178891e-01,
  1.16739502461048444414970504112716e-01, 1.25158799100319434449701816447487e-01,
  1.31280684229804434082211628265213e-01, 1.35193572799884670354586546636710e-01,
  1.36577794711118527537507816305151e-01,
  8.25771143316878473983333464047973e-03, // N = 25
  2.30360840389826869445411006154245e-02, 3.89152304692995665291732620971743e-02,
  5.36970176077564489980353812370595e-02, 6.72509070508397616139362185094797e-02,
  7.99202753336016175067513245267037e-02, 9.15494682950501043050550720181491e-02,
  1.01649732279059809569865535650024e-01, 1.10022604977644142265624793708412e-01,
  1.16712053501756771178854421577853e-01, 1.21626303523947362772439362288424e-01,
  1.24584164536156449809567448028247e-01, 1.25556893905473809791573103211704e-01,
  7.08784635124846355141992049198052e-03, // N = 27
  1.97537463827065877530753112978346e-02, 3.34435899895524704761307077660604e-02,
  4.62790179738298765310666738059808e-02, 5.81152104231143842860696224761341e-02,
  6.93036332477813266095267863420304e-02, 7.98059621694767046262697363090410e-02,
  8.91684418775404441515064490886289e-02, 9.71417348760790222428340712212957e-02,
  1.03830601169039679620986760255619e-01, 1.09266351095285305095039518619160e-01,
  1.13210259171529881161433195302379e-01, 1.15488799091286301057301955097500e-01,
  1.16209612363060474371501129553508e-01,
  6.13955868637816679772578609686207e-03, // N = 29
  1.71484589099355280716885374658887e-02, 2.90487012615084326527803426643004e-02,
  4.02505948726886303434824299074535e-02, 5.06915432604655991077891030727187e-02,
  6.06671258667422844124139658106287e-02, 7.01029790027480753655808598523436e-02,
  7.86557972496214341528997238128795e-02, 8.61837628694576418642014914439642e-02,
  9.27368300178544185952134171202488e-02, 9.82649264721037057901398270587379e-02,
  1.02616627321400769035086852909444e-01, 1.05731639841764077369923313653999e-01,
  1.07626421114118631106038037614780e-01, 1.08270066506429230024366461293539e-01,
  5.37747987292346019128075340631767e-03, // N = 31
  1.50079473293151695323377481372518e-02, 2.54608473267151740049296648749078e-02,
  3.53463607913763536161333433938125e-02, 4.45897513247650728596127578384767e-02,
  5.34815246909283378839994327336171e-02, 6.20095678006703857065851082097652e-02,
  6.98541213187276466278774478269042e-02, 7.68496807577201124228594153464655e-02,
  8.30805028231330067178816989326151e-02, 8.85644430562117918048770093264466e-02,
  9.31265981708242762682203874646802e-02, 9.66427269836229174693187360389857e-02,
  9.91735987217921693970268393059087e-02, 1.00769845523875550830084080189408e-01,
  1.01330007014790793307135174927680e-01,
  4.74277704924697899452334937109299e-03, // N = 33
  1.32579306880912708294095736505369e-02, 2.24988594400489447244773089096270e-02,
  3.12605436473811573727665802380216e-02, 3.95129512024209178511213735873753e-02,
  4.75062159764066058165177253158618e-02, 5.52056330954225488172326663516287e-02,
  6.23588060118346679261414067241276e-02, 6.88629951915312038535077476808510e-02,
  7.47698238855998703611405176161497e-02, 8.00539412637194525146355772449169e-02,
  8.45958037925919476007763364577841e-02, 8.83375025791130336072498607791204e-02,
  9.12920328281904974732086088806682e-02, 9.34386740609211147168267075358017e-02,
  9.47284012472300179785733575954509e-02, 9.51542160804982745103686170295987e-02,
  4.21897579377691900326396989839850e-03, // N = 35
  1.17858375622883811834062939283285e-02, 2.00222339532946207174557429198103e-02,
  2.78567224578629146769515045889420e-02, 3.52497467518806256725483194713888e-02,
  4.24426302050016288069933523274813e-02, 4.94361418239588831791131440240861e-02,
  5.59940445300942321593673511870293e-02, 6.20009152682301292736077868994471e-02,
  6.75280167181304402657104901663843e-02, 7.25898901141902724853949280259258e-02,
  7.70562230462022296206825444642163e-02, 8.08366784408182520449415164875973e-02,
  8.39725719912355339502596507372800e-02, 8.64905322056510050821032109524822e-02,
  8.83087822976041658673551637548371e-02, 8.93618458677885862950773798729642e-02,
  8.96964219439821547341651353235648e-02,
  3.77351012844074100091584789140597e-03, // N = 37
  1.05544305675438383762543281818580e-02, 1.79333762057115979338117739416703e-02,
  2.49644027537403480343503048288767e-02, 3.16340198488447715829963158284954e-02,
  3.81537583251759099267630404028750e-02, 4.45091951650895267800223109588842e-02,
  5.05075715021018889494541781459702e-02, 5.60723903829939418486105751071591e-02,
  6.12535657913583428402226616071857e-02, 6.60399581928171192091170382809651e-02,
  7.03374500242248956727308950576116e-02, 7.40970273813158775144671608359204e-02,
  7.73320701646387637095969580514065e-02, 8.00300194950957916040223949494248e-02,
  8.21439997833294244244939363852609e-02, 8.36548514371627388586105666945514e-02,
  8.45693335440753507503686137170007e-02, 8.48781386126768178090884475750499e-02,
  3.39815311963492837701861226662459e-03, // N = 39
  9.49920546171027432857947303546098e-03, 1.61534143690916995317330417947232e-02,
  2.25086957522035689682748937912038e-02, 2.85442381171149145435705918316671e-02,
  3.44623528628813236007744080779958e-02, 4.02700232495143625732758607682626e-02,
  4.57859730879225448885172511381825e-02, 5.09262255062440383213129280193243e-02,
  5.57522010334808443277054834652517e-02, 6.02774115032086166277025540694012e-02,
  6.44023522619290161861371757368033e-02, 6.80597804981340898100583558516519e-02,
  7.12814247649301430120871714279929e-02, 7.40840745337379008583766903939249e-02,
  7.64028619398165881326789872218797e-02, 7.81869106857413648237198344759236e-02,
  7.94656835853552179216308104514610e-02, 8.02662160208506003655770655313972e-02,
  8.05456032929982579382510721188737e-02,
  3.07358371851970246096952266157132e-03, // N = 41
  8.60026985564303798892371588635797e-03, 1.46261692569714871203778727704048e-02,
  2.03883734612666754626442155995392e-02, 2.58821336049522253419663542217677e-02,
  3.12873067770326196423980036342982e-02, 3.66001697582009968834348967448022e-02,
  4.16688733279727760439037353989988e-02, 4.64348218674976512265750727692648e-02,
  5.09445739237290168288652125738736e-02, 5.51951053482847564524149674980436e-02,
  5.91114008806389937267233847251191e-02, 6.26532375547814990301986881604535e-02,
  6.58345971336182639310763420326111e-02, 6.86486729285213093110229465310113e-02,
  7.10544235534444207358362177728850e-02, 7.30306903327871265174664472397126e-02,
  7.45828754004993627058084371128643e-02, 7.57044976845567124668079372895590e-02,
  7.63778676720801019683904087287374e-02, 7.66007119180001361247178692792659e-02,
  2.79548123241232099323028137405345e-03, // N = 43
  7.81833730212382581326036046220906e-03, 1.33046426070887128384478970133387e-02,
  1.85600554088754185477760927369673e-02, 2.35741990830289349645454421988688e-02,
  2.85184265702047093360427254538081e-02, 3.34025463208076148213798717279133e-02,
  3.80831534534658497359593809505895e-02, 4.24969328811189081540611311993416e-02,
  4.66973247315148262681638868798473e-02, 5.06971977965171571867131206090562e-02,
  5.44186751783839323115543606945721e-02, 5.78104574976093729676840382580849e-02,
  6.08986802046619438155694581382704e-02, 6.36956152491011812211141318584851e-02,
  6.61495778159501279791498973281705e-02, 6.82207062610256376178341497507063e-02,
  6.99297650083991056968457655784732e-02, 7.12933463637844544447119687902159e-02,
  7.22754822220333659199553721919074e-02, 7.28456528305081590923819589988852e-02,
  7.30274879627689638139642624992121e-02,
  2.55173329221139791322947587559611e-03, // N = 45
  7.14224577312841824722200456676546e-03, 1.21547145356169263019641135770144e-02,
  1.69604728123593055666429307848375e-02, 2.15594944486100330294231497418878e-02,
  2.61058711763036133124415982820210e-02, 3.06016012229099361452444583164834e-02,
  3.49240004607826656779501206528948e-02, 3.90270074808360192819556289123284e-02,
  4.29532548651164261532819921285409e-02, 4.67043249593880327452666278986726e-02,
  5.02194562942364433610897833659692e-02, 5.34657348412062999321037182198779e-02,
  5.64572978608792325205811835076020e-02, 5.91911830291232260448097690641589e-02,
  6.16324131388590185087750228376535e-02, 6.37611302901642529317172147784731e-02,
  6.55826103897497181272058242029743e-02, 6.70927443324166872251623772172024e-02,
  6.82731235095964533732271206645237e-02, 6.91161994196663465039875973161543e-02,
  6.96251623651319706542750509470352e-02, 6.97964470034189016223180601627973e-02,
  2.33998949946640335054159898220405e-03, // N = 47
  6.54685940139563757322882509015471e-03, 1.11469818828354976653072228032215e-02,
  1.55633574611121414110748162329401e-02, 1.97915998280810308262989138938792e-02,
  2.39783158613828470406836856909649e-02, 2.81343907445832583369416113328043e-02,
  3.21435410254925016393379166856903e-02, 3.59565794576613625976868604539050e-02,
  3.96203136006606088104220475543116e-02, 4.31469438241565625413720397318684e-02,
  4.64741331712496680284019134887785e-02, 4.95618239500199495028986973466090e-02,
  5.24323933189405899657486997966771e-02, 5.50957582046861515934210729028564e-02,
  5.75102602994165407190862993047631e-02, 5.96442712520207779514080925764574e-02,
  6.15137201590668231121483700007957e-02, 6.31299044502810074996901334998256e-02,
  6.44629681747904831334849973245582e-02, 6.54880595317243879849300469686568e-02,
  6.62213047541439503440585667703999e-02, 6.66780944357798222021926903835265e-02,
  6.68368714221058285440690838186129e-02,
  2.15230855094616100112170364866415e-03, // N = 49
  6.02567101572035624529322106468499e-03, 1.02597864092800142993278100789212e-02,
  1.43274446308840081726332371658827e-02, 1.82311785503874168590243698417908e-02,
  2.21040849000614728070424064299004e-02, 2.59511946613731718513928825586845e-02,
  2.96713060906589227994079038808195e-02, 3.32273783198292621543501468295290e-02,
  3.66581002422127488760139613077627e-02, 3.99676238936221978059748494160885e-02,
  4.31059281936955265845945461933297e-02, 4.60458917765644917818868009362632e-02,
  4.88013867532589573627888057671953e-02, 5.13719513834576396726916414081643e-02,
  5.37279455017507998060288798569673e-02, 5.58517151030638800413008482337318e-02,
  5.77486753756895204725552162017266e-02, 5.94165432459521428154580746650026e-02,
  6.08380348731280343188565495893272e-02, 6.20040014197816222174530764732481e-02,
  6.29171122696984830291455637052422e-02, 6.35748787129722797706321557598130e-02,
  6.39696262413755045717067559962743e-02, 6.41004637692669798632039146468742e-02,
  1.98738389233050127477553381538655e-03, // N = 51
  5.56193213535594640356540807601959e-03, 9.47397338617417261730224709026515e-03,
  1.32362291955716339375559442714803e-02, 1.68478177091289232913950968395511e-02,
  2.04353711458829453984087365370215e-02, 2.40099456069531071167322267001509e-02,
  2.74753175878516067709433912114037e-02, 3.07923001673870572192370786979154e-02,
  3.40021302743288081349426477117959e-02, 3.71162714834156332033288094862655e-02,
  4.00838255040327148814860436232266e-02, 4.28728450201689356702239308560820e-02,
  4.55029130499226830419701173013891e-02, 4.79825371388375582215601866664656e-02,
  5.02776790807149542850140733207809e-02, 5.23628858064081187384530835515761e-02,
  5.42511298885454129603544970450457e-02, 5.59508112204117058485763891440001e-02,
  5.74371163615675431324270050481573e-02, 5.86896800223938933105394255562715e-02,
  5.97203403241740801710157882098429e-02, 6.05394553760467968306357988694799e-02,
  6.11285097170536154131958994639717e-02, 6.14711898714256840814407212292281e-02,
  6.15808180678330818746957220355398e-02,
  1.83981185146107092780176639479350e-03, // N = 53
  5.15173594601833328282536328401875e-03, 8.77527670729943976013487372256350e-03,
  1.22618158633556548903209559853167e-02, 1.56152409285371558678168213418758e-02,
  1.89514371450910344696350051663103e-02, 2.22769735973087114333512914754465e-02,
  2.55069151234083094093030297244695e-02, 2.86108832572471716293449617296574e-02,
  3.16238591915242867047552977055602e-02, 3.45513687785811499098009846875357e-02,
  3.73516075433682481765629290748620e-02, 4.00019941896014447069163111336820e-02,
  4.25158571389079517621745196720440e-02, 4.48943287753945582951864423648658e-02,
  4.71122199916565870259077541959414e-02, 4.91541399458680500211826824852324e-02,
  5.10256137066896348075673017774534e-02, 5.27256963108731838141274295139738e-02,
  5.42387955368089300089984305941471e-02, 5.55556924442242999750973808659182e-02,
  5.66789557753628603364859372959472e-02, 5.76069978277142097367047313127841e-02,
  5.83313553537838369589252351943287e-02, 5.88485769306596878669424199870264e-02,
  5.91603358092347084151718661360064e-02, 5.92650286600385350910258352996607e-02,
  1.70886049635052121066502994750635e-03, // N = 55
  4.78353655531941167333709330478086e-03, 8.15078489918117862766955283859716e-03,
  1.13935063444865203319267266124371e-02, 1.45128827747717601553967270433532e-02,
  1.76192534776518847094983755141584e-02, 2.07233831861199715995702774762321e-02,
  2.37442938214378687633576703319704e-02, 2.66500927136609153111912462463806e-02,
  2.94773082453517153156408170389113e-02, 3.22366327916649847429297892631439e-02,
  3.48857827646454343728521507728146e-02, 3.73987947325040703816512177581899e-02,
  3.97930352907439194298788720516313e-02, 4.20760498836970364688880863468512e-02,
  4.42196413088645698397094463416579e-02, 4.62030328414019669791557021198969e-02,
  4.80372226588824113857612019273802e-02, 4.97288989532169989349341676643235e-02,
  5.12573120491268130471951280924259e-02, 5.26056347498077767066426702058379e-02,
  5.37830940251159614340359382822498e-02, 5.47971549572735597277706176555512e-02,
  5.56319998035080323650625189202401e-02, 5.62739336119517513656873575200734e-02,
  5.67325818528369094084773394115473e-02, 5.70173101466441359375103559159470e-02,
  5.71159701275654393959335664021637e-02,
  1.59073604070683626877935612498050e-03, // N = 57
  4.45493629669261887588094239731618e-03, 7.59080105310381419991827556259523e-03,
  1.06118588421720491665745100817730e-02, 1.35226653313627164648691447723650e-02,
  1.64248857998400554780715765446075e-02, 1.93257803768257831189547601979939e-02,
  2.21530233818411602386699854605467e-02, 2.48812743609629558050322373219387e-02,
  2.75421408387825708552476555723842e-02, 3.01418139152947912873248270670956e-02,
  3.26448788910208009816926733037690e-02, 3.50323223518431564604824757225288e-02,
  3.73167750660178890176332799910597e-02, 3.95003620383103659641221838683123e-02,
  4.15615404229303861405320219546411e-02, 4.34869654635349350835227255629434e-02,
  4.52821749717779303834319648558449e-02, 4.69471747435963801531322303617344e-02,
  4.84681238318949852983408277395938e-02, 4.98363449077796408226426194687519e-02,
  5.10544369656874136298441158032801e-02, 5.21215342402874121097156034920772e-02,
  5.30292824785586897062827915760863e-02, 5.37732082090743648827846357107774e-02,
  5.43547798764375811320093134781928e-02, 5.47728968446952665938276538781793e-02,
  5.50237748090774622666820903305052e-02, 5.51070152997779061365690722595900e-02,
  1.48503230412374512964257533553791e-03, // N = 59
  4.15774244739312587998414372236766e-03, 7.08636458790203732638346423300391e-03,
  9.90975355787943393282013460066082e-03, 1.26302962946196611904170481466281e-02,
  1.53449041737669256840748133186025e-02, 1.80638261465426892826702243155523e-02,
  2.07179403579355117526183960308117e-02, 2.32808150168917586675387809691529e-02,
  2.57849773781425942176248611303890e-02, 2.82403515646854619269845443341183e-02,
  3.06112790420932923129981872989447e-02, 3.28763049391902831275480423300905e-02,
  3.50509668800313978209715060074814e-02, 3.71420802022058502145362979263155e-02,
  3.91259797325003780277263842890534e-02, 4.09854738855193051483283284142090e-02,
  4.27301386748522651903847702214989e-02, 4.43655707500960894140717982736533e-02,
  4.58742757569110051751870571479230e-02, 4.72422209376026080995814027119195e-02,
  4.84769417203402067095829863774270e-02, 4.95841471528194049911419938325707e-02,
  5.05503145288304644999755055323476e-02, 5.13638822664084990221589066550223e-02,
  5.20321731840021547976782301248022e-02, 5.25618984127512248183400345169503e-02,
  5.29424463358925470601867857567413e-02, 5.31642228165634597725208720930823e-02,
  5.32353579030115861558947187859303e-02,
  1.38901369867671297883560121988467e-03, // N = 61
  3.89046112709973872581525888847409e-03, 6.63070391593134200042269910113646e-03,
  9.27327965951760431473349655107086e-03, 1.18230152534958520005314852596712e-02,
  1.43697295070457069926517235103347e-02, 1.69208891890542077740544613106977e-02,
  1.94141411939422747767736154855811e-02, 2.18280358216083776590199505562850e-02,
  2.41911620780811756348249730308453e-02, 2.65099548823328583224689936059804e-02,
  2.87540487650424191057307865548864e-02, 3.09072575623881573569917691202136e-02,
  3.29814470574837995120454081643402e-02, 3.49793380280609897403643060442846e-02,
  3.68823646518216460843397896951501e-02, 3.86789456247275467704049844996916e-02,
  4.03745389515359973109376312550012e-02, 4.19698102151635152323727595558012e-02,
  4.34525397013559924741521456326154e-02, 4.48148001331629755594754271896818e-02,
  4.60592382710063794060140196506836e-02, 4.71855465692997064208746849089948e-02,
  4.81858617570871186619463344413816e-02, 4.90554345550293854905099522056844e-02,
  4.97956834270740222869733315746998e-02, 5.04059214027822721782001735846279e-02,
  5.08817958987483887067782006852212e-02, 5.12215478492599324278344852245937e-02,
  5.14261285374583640428447495196451e-02, 5.14947294294524487989761496464780e-02,
  1.30246271267266404587925610059074e-03, // N = 63
  3.64713272677797805537691644417464e-03, 6.21744174797783568514608631971896e-03,
  8.69759093344999421881791334953959e-03, 1.10906494535923660915699429097003e-02,
  1.34823525002951451201571586580030e-02, 1.58823377570664267532940527871688e-02,
  1.82308870459734727320633140834616e-02, 2.05057508028605832428592492533426e-02,
  2.27360386405732056713802080594178e-02, 2.49309353806482711379821637365239e-02,
  2.70599742359002963520975271194402e-02, 2.91051633767215808812345301248570e-02,
  3.10804943630842364643562802939414e-02, 3.29921865123988591883552601302654e-02,
  3.48201380392518175521665568794560e-02, 3.65499425876553082903619440457987e-02,
  3.81900879909417220736678189041413e-02, 3.97454217782653301815898316817766e-02,
  4.12010625351898612800383148169203e-02, 4.25451960368526671540934103177278e-02,
  4.37841956551739686087643121936708e-02, 4.49226469517313778401224055869534e-02,
  4.59489447540288309390632548456779e-02, 4.68532673005632033236267375286843e-02,
  4.76414364160321207597448278647789e-02, 4.83185016326540400788402962461987e-02,
  4.88752161616571728641744698506955e-02, 4.93033500326472071129124685739953e-02,
  4.96090348242765252773089912352589e-02, 4.97983005161995520571061035752791e-02,
  4.98637171937756085160486918539391e-02,
  1.22336081795172192145104705929270e-03, // N = 65
  3.42681877577254590666600009285503e-03, 5.84173707916625997715875939775287e-03,
  8.17250403853159342049128355256471e-03, 1.04239873988075156668875465015844e-02,
  1.26760548066536405525939201766050e-02, 1.49361036060853651086244298085148e-02,
  1.71498052097839859264638562308392e-02, 1.92987714303275020855110710726876e-02,
  2.14089131848227767762615769697732e-02, 2.34866596721624472376976910936719e-02,
  2.55056954808952768276597566909913e-02, 2.74520984222116105899491600439433e-02,
  2.93369566896209271744666580161720e-02, 3.11633255619743615438821393581748e-02,
  3.29150776439031400588675069229794e-02, 3.45821227447337675720007155177882e-02,
  3.61697694756424950601747525524843e-02, 3.76791306456132485402932275064813e-02,
  3.90994201333069515968965390584344e-02, 4.04234923703730361643771118451696e-02,
  4.16540199856420406687718127614062e-02, 4.27911155964466327628059616472456e-02,
  4.38275440301400809328669083697605e-02, 4.47586387497661830625617085388512e-02,
  4.55858265645481958161511215621431e-02, 4.63087567380258691152050687378505e-02,
  4.69229682817032256458844585722545e-02, 4.74260618738824094031691913642135e-02,
  4.78189087369880749811557052453281e-02, 4.81009691854588014581217692011705e-02,
  4.82701930757775538038956142372626e-02, 4.83263839865678140883531455074262e-02,
  1.15160129004742220470980385016446e-03, // N = 67
  3.22508952862994927035522607638995e-03, 5.49895030069660634836070656206175e-03,
  7.69465598754205237080894264067865e-03, 9.81563482128566117124179868369538e-03,
  1.19382338545769087212455872304417e-02, 1.40714538620498822579785169750721e-02,
  1.61631626533988541349895484700028e-02, 1.81943779525545433484179369543199e-02,
  2.01912748960626532712669956026730e-02, 2.21623428612947974414293383915719e-02,
  2.40812526535429081986361410372410e-02, 2.59327194192369783753981948848377e-02,
  2.77294076333354858054924818588916e-02, 2.94770275698765411853674578424034e-02,
  3.11583166083577237093216183438926e-02, 3.27610610773681476537433354678797e-02,
  3.42928773345582832421385433008254e-02, 3.57580635550850747805817775315518e-02,
  3.71438479939325688627960175836051e-02, 3.84401906206052260128736008937267e-02,
  3.96526225681413033163913439693715e-02, 4.07849728885320908511324944356602e-02,
  4.18272280048631941995473937367933e-02, 4.27709880050780935634158197444776e-02,
  4.36210523005745795521725938215241e-02, 4.43813870354051315247900788563129e-02,
  4.50439274744267800776320598288294e-02, 4.56015770080309551515185262360319e-02,
  4.60591411616620913238584478222037e-02, 4.64211428552714355788566535920836e-02,
  4.66810091950832992124809095457749e-02, 4.68326866336052152761659783664072e-02,
  4.68814447905708600594643087333679e-02,
  1.08566449090454430169427890717770e-03, // N = 69
  3.04135509836280524056939533750210e-03, 5.18554868303459839257163466186284e-03,
  7.25644130761681806218721391132931e-03, 9.25880912675061326644332382329594e-03,
  1.12640938399336965752839390120243e-02, 1.32794693467551076088151162934992e-02,
  1.52571615892031220429458926446387e-02, 1.71812317334183208006326282202281e-02,
  1.90752233953005757849386014868287e-02, 2.09454147928236564246695650126640e-02,
  2.27687840047177750268936335942271e-02, 2.45332419916974298068623738799943e-02,
  2.62491191320310575385565954320555e-02, 2.79196335601209419396973032689857e-02,
  2.95306676104479977340577789846066e-02, 3.10733839228619912464779417859972e-02,
  3.25528956072243663699694593560707e-02, 3.39706097099168879971387013938511e-02,
  3.53169823296533499923377519280621e-02, 3.65856069613536907803030828745250e-02,
  3.77791510382876061235890574607765e-02, 3.88980364602782499594546550270024e-02,
  3.99356779984855886356243104273744e-02, 4.08876557940064319640605106087605e-02,
  4.17554190617230938653570149199368e-02, 4.25388848261954027885067830538901e-02,
  4.32337145652979329413234665935306e-02, 4.38372568862537143052904298201611e-02,
  4.43503631054797120558674805579358e-02, 4.47727112312344271982667009979195e-02,
  4.51018669264676708152705941756722e-02, 4.53368566008377910092619345050480e-02,
  4.54782563462682171140372133777419e-02, 4.55256218501140716425901189268188e-02,
  1.02550911074644366879904389122657e-03, // N = 71
  2.87226001447005033564985332361630e-03, 4.89809089031627026972204319577031e-03,
  6.85548721878363482434837195000910e-03, 8.74803476789708447936000368372333e-03,
  1.06441267608039253494967013580208e-02, 1.25521386316194451249206309739748e-02,
  1.44261486252934487128918306098058e-02, 1.62497719998498067750514195495271e-02,
  1.80466511295591033881002829275531e-02, 1.98246307319263764812333761256014e-02,
  2.15607290028205604570654685403497e-02, 2.32418108954669105914447868599382e-02,
  2.48793898649795584832045136636225e-02, 2.64787298392453081252728708250288e-02,
  2.80248592704805711550708480217509e-02, 2.95073129404832372457700984114126e-02,
  3.09329856908927419700816585645953e-02, 3.23057496748598085845038951902097e-02,
  3.36145496277944280660854303732776e-02, 3.48507762898166845166869620697980e-02,
  3.60193210644327230229855274501460e-02, 3.71234780367496533526328050811571e-02,
  3.81545539384521500969604801412061e-02, 3.91053151646672883523514485659689e-02,
  3.99798348609348361271109695280757e-02, 4.07813447585925192839795272448100e-02,
  4.15027911411042157996398316299747e-02, 4.21380228974243611905770023895457e-02,
  4.26909348444928088417427147760463e-02, 4.31650461201108504027956769277807e-02,
  4.35545454169717280445972562574752e-02, 4.38541549245971135073673963233887e-02,
  4.40679834669348430287172391217609e-02, 4.42000975259000394856911952956580e-02,
  4.42456657210557741111145446666342e-02,
  9.69970723056737650982772613872385e-04, // N = 73
  2.71743687890924024916361467774095e-03, 4.63395164325241647879094486484064e-03,
  6.48601212092189075703041467590992e-03, 8.27822898659344268146309531175575e-03,
  1.00748554613388739686907769055324e-02, 1.18827604423468926458928862643916e-02,
  1.36595943388832276321753766978873e-02, 1.53914070441378350584393785993598e-02,
  1.70996514888438200241438380544423e-02, 1.87903735394326400209852323541782e-02,
  2.04432631425704516847652314481820e-02, 2.20477319276916987333958530825839e-02,
  2.36133900508943110618798044697542e-02, 2.51435062625416684556345359169427e-02,
  2.66256318015112812547240395133485e-02, 2.80519817974916041425359480854240e-02,
  2.94274467726939881195846737682587e-02, 3.07536188420513834085312510069343e-02,
  3.20220215354759460413269778200629e-02, 3.32269174323257948655552240779798e-02,
  3.43709400346649610047400358325831e-02, 3.54547340356671514260966660003760e-02,
  3.64723338657418488795158850734879e-02, 3.74196314217593653528304287192441e-02,
  3.82980935912858380665291235800396e-02, 3.91078464427406582992752248628676e-02,
  3.98447829980593387633192037355911e-02, 4.05062091376607799619868899299036e-02,
  4.10929816023217417408908147535840e-02, 4.16049557991777507748309972157585e-02,
  4.20395629128239925464960435874673e-02, 4.23954203576963062349847177756601e-02,
  4.26730754760015068560718987100699e-02, 4.28722419739430843366179146869399e-02,
  4.29917262050515183724463952330552e-02, 4.30314238248796915309313249053957e-02,
  9.19046467820539762609566292184127e-04, // N = 75
  2.57430114789888560625219504629513e-03, 4.39053424147683134248776326558072e-03,
  6.14631782634312683749611139205626e-03, 7.84526932154258616058939423965057e-03,
  9.54898990912019657306686326592171e-03, 1.12652602088919671224909180295981e-02,
  1.29533087209931594557810186074676e-02, 1.45988479259487567707420652141082e-02,
  1.62233229017583052700146595270780e-02, 1.78339863185541201706652003622366e-02,
  1.94106010531388054052293057338829e-02, 2.09417640401454059617680769633807e-02,
  2.24379827940323905988151409474085e-02, 2.39041239571709876465810395984590e-02,
  2.53270869762166339622666555442265e-02, 2.66978178706687406529507455843486e-02,
  2.80225996781889273579135846148347e-02, 2.93049591842368360727899556650300e-02,
  3.05352495319923672445483475712535e-02, 3.17060254827262327781411954674695e-02,
  3.28216729927391787091650598995329e-02, 3.38850902028915296204658602619020e-02,
  3.48886820916981810203338909559534e-02, 3.58261765004404056367270925420598e-02,
  3.67011100454975106033295162433205e-02, 3.75161976645481398673354078709963e-02,
  3.82652457003135951230099465192325e-02, 3.89428943026916274394721995122381e-02,
  3.95523917674562366930679502274870e-02, 4.00965670518957234547130497048784e-02,
  4.05702759714426930415243077732157e-02, 4.09688946616749288809344875517127e-02,
  4.12957235315390552843339833088976e-02, 4.15539208724312394971356354744785e-02,
  4.17391693588452170060598689360631e-02, 4.18474379306157523439324563696573e-02,
  4.18823075888248921860856910370785e-02,
  8.71830039578744340859894901285543e-04, // N = 77
  2.44262927158914481748364089241932e-03, 4.16585596178396973254809410036614e-03,
  5.83193947997377986486311485236911e-03, 7.44528650820709767682581414760534e-03,
  9.06397404052702339305458423268647e-03, 1.06945277358895321495602104278078e-02,
  1.22991393615884351403488849996393e-02, 1.38654948950711481847619666041282e-02,
  1.54131994589632136116730265484875e-02, 1.69480245616357577675969992014871e-02,
  1.84519184755407329723286835587714e-02, 1.99155342606260228610626228373803e-02,
  2.13478081415702965195624329908242e-02, 2.27519867911305413710199019305946e-02,
  2.41170183907028386205428915900484e-02, 2.54360049739543563063204345553459e-02,
  2.67136013970907422454548196810720e-02, 2.79515074077417366438247370297177e-02,
  2.91421617238904751001626891593332e-02, 3.02804200572957642190186078323677e-02,
  3.13688591433207222824997018051363e-02, 3.24082802092718474940014061758120e-02,
  3.33932859263476877753618055066909e-02, 3.43200950022273312822740365390928e-02,
  3.51901806253909280042257989862264e-02, 3.60038290706020183695734715456638e-02,
  3.67572089260188861192801823563059e-02, 3.74476941752304517962990360047115e-02,
  3.80761544360130391173591135611787e-02, 3.86425885362942089784610288916156e-02,
  3.91444324761338405260779893524159e-02, 3.95801090552659121102330175290263e-02,
  3.99501607343730053001351620878268e-02, 4.02544277830611738067112526096025e-02,
  4.04914571212889526363731818037195e-02, 4.06606738918781976388494570073817e-02,
  4.07624450992558687301148268034012e-02, 4.07965097073479873723833577514597e-02,
  8.28340760507506579900238730118645e-04, // N = 79
  2.32040070293279294261212797323424e-03, 3.95792719985567451740360311873701e-03,
  5.54164675245742872899956665833088e-03, 7.07513035758614017289858111325884e-03,
  8.61413688422363321706143324263394e-03, 1.01658913604506656591652813403925e-02,
  1.16939421274049413362883242939461e-02, 1.31857183185855042495404632063583e-02,
  1.46607491797503108194034027178532e-02, 1.61257467574369671436951279019922e-02,
  1.75627515999212981123722698839629e-02, 1.89617742220646694206731552867495e-02,
  2.03324376996833061648217721995024e-02, 2.16792519803111830012376515242067e-02,
  2.29906614889065358253716908620845e-02, 2.42587643200532984688599924538721e-02,
  2.54893157235800589532903615008763e-02, 2.66855529271449835870821942762632e-02,
  2.78389946961139084224967632508196e-02, 2.89431512073271765550508405340224e-02,
  3.00019960385258799284713404631475e-02, 3.10181220229906497165561773954323e-02,
  3.19848518161208114629623366909073e-02, 3.28967104059759915535288143928483e-02,
  3.37568236254099721116439525303576e-02, 3.45675295529186826781753438808664e-02,
  3.53233652633343636617624383688963e-02, 3.60196353593554910443863548152876e-02,
  3.66591144056713572063621597862948e-02, 3.72441422807844799147680703299557e-02,
  3.77701545467850965942524510410294e-02, 3.82330819135516877804725766054617e-02,
  3.86356463038312197832979677514231e-02, 3.89803717033950364312389069709752e-02,
  3.92633980655014841465444419554842e-02, 3.94811658198129522556740766958683e-02,
  3.96365421612499824188802222124650e-02, 3.97323761009928042020611371754057e-02,
  3.97653726949877134311250870268850e-02,
  7.87863323894412892652028279627530e-04, // N = 81
  2.20748573572655207991610737394694e-03, 3.76522867934218213870067870630010e-03,
  5.27194271488538781372801267366413e-03, 6.73181348520744595592679715423401e-03,
  8.19757638675165482833318009170398e-03, 9.67540148401653012089074223922580e-03,
  1.11313216640265694179490196802362e-02, 1.25543847685168352690254778281087e-02,
  1.39625598669800687207098732756094e-02, 1.53613263591038558264489921612039e-02,
  1.67345324750035190364272352780972e-02, 1.80738684088178856723683196605634e-02,
  1.93876458943171882387535021052827e-02, 2.06790432735283989662544712473391e-02,
  2.19381873358342055491121413979272e-02, 2.31589310133770848176837375831383e-02,
  2.43456901822737999119272700454530e-02, 2.55002176031297218827820216802138e-02,
  2.66157374990245755574935770937373e-02, 2.76876261110605252635519235582251e-02,
  2.87183868410914207303097356316357e-02, 2.97089272777770613265246879564074e-02,
  3.06543608914110025931432090828821e-02, 3.15512236191161504761382161632355e-02,
  3.24009825076053761816474718671088e-02, 3.32040443412578642479182633451273e-02,
  3.39568628342087827642892250423756e-02, 3.46569358434978061489495360092405e-02,
  3.53051447086217343174219251977775e-02, 3.59016027836281254037587018501654e-02,
  3.64438265303401107142455828125094e-02, 3.69301695340484223417654163768020e-02,
  3.73611800254688292133309346354508e-02, 3.77368012630936722207053435340640e-02,
  3.80554637788527092001622520456294e-02, 3.83163240051739087399518268739484e-02,
  3.85197417499504937699050799437828e-02, 3.86655554391414288395445453261345e-02,
  3.87530293787521837312048944568232e-02, 3.87821047642838354074790174763621e-02,
  7.50429320820811046263698607106107e-04, // N = 83
  2.10228358929712274769108226735170e-03, 3.58621484585954029139509557921883e-03,
  5.02192668922512089335619123176002e-03, 6.41289622624138973272511776713145e-03,
  7.80982310440631651710097216323447e-03, 9.21941893246768819081271573168124e-03,
  1.06088920583386186330399070243402e-02, 1.19670940382880144209343242778232e-02,
  1.33118755979416379664481695499489e-02, 1.46494567490795292441507768899100e-02,
  1.59637886319773589227644094989955e-02, 1.72460491044326529042063356200742e-02,
  1.85050797107342429592691246398317e-02, 1.97450684633009715396312344637408e-02,
  2.09557486858472780122397693958192e-02, 2.21301689763428871549066911939008e-02,
  2.32736234908143199695551572858676e-02, 2.43891006082099515150929391893442e-02,
  2.54690919863180299798077754758197e-02, 2.65078988129795987960246606007786e-02,
  2.75091495122560501795927478951853e-02, 2.84751929771580730710311968323367e-02,
  2.94001228729363767167015453196655e-02, 3.02791292235336691185398905190596e-02,
  3.11150132077961695531431729477845e-02, 3.19098287082358739175091955075914e-02,
  3.26587344403081389354603913943720e-02, 3.33575951739588441591344292191934e-02,
  3.40088278201884641749330739912693e-02, 3.46144155702144129538311290161801e-02,
  3.51702958963641329481752961783059e-02, 3.56728717226359182124184599160799e-02,
  3.61244401151421812290465140904416e-02, 3.65270705771046921839229071338195e-02,
  3.68773068051132940636804846690211e-02, 3.71719913379935235075990362929588e-02,
  3.74134748786695003897051492458559e-02, 3.76040317405194959854419778366719e-02,
  3.77406930826910957943454150154139e-02, 3.78206578048135774738902625813353e-02,
  3.78464538188871546520175570549327e-02,
  7.15467085805285740902903501847732e-04, // N = 85
  2.00472607890585024711938011421353e-03, 3.41970626170950975364348778384738e-03,
  4.78882487864555183437742513774538e-03, 6.11604246466967982343021503766067e-03,
  7.44944624579055997282139855997229e-03, 8.79485362349846991336654866699973e-03,
  1.01215761169300231397949474398956e-02, 1.14198071629799825094098153499544e-02,
  1.27060638110606544809444429233736e-02, 1.39855304404149002189816641816833e-02,
  1.52436686048831124967728456454097e-02, 1.64730429295141117540524078322051e-02,
  1.76813899779599131845131410045724e-02, 1.88717912456202799309501472180273e-02,
  2.00353755789132344233838267655301e-02, 2.11666351695655105547011487487907e-02,
  2.22697501233139333320920627556916e-02, 2.33464879538915447143576642474727e-02,
  2.43907490429229739659078290969774e-02, 2.53983645346068133419326073862976e-02,
  2.63717534092876501605751116130705e-02, 2.73118919361154607883257483535999e-02,
  2.82143480656886803947802633274478e-02, 2.90759540779039135638406321504590e-02,
  2.98981597074336122310533880863659e-02, 3.06814605059700824807311647646202e-02,
  3.14225871220973618225258405800560e-02, 3.21191860976889481671392445605306e-02,
  3.27721456785988810023191319942271e-02, 3.33816694117022028098773489546147e-02,
  3.39453928788535155836036949494883e-02, 3.44616733261326538273472408491216e-02,
  3.49310680053013938861639076094434e-02, 3.53536040512073476693721829633432e-02,
  3.57276815866811731092766990514065e-02, 3.60523130644657963106425313526415e-02,
  3.63278603059973143052374666694959e-02, 3.65542409672942117393468208774721e-02,
  3.67305413863710447652799473416962e-02, 3.68564040020365121796963592259999e-02,
  3.69320725127922286357140535528742e-02, 3.69573851375539982888618339984532e-02,
  6.83014409444813791125183932706477e-04, // N = 87
  1.91352970506636138256495449638805e-03, 3.26448731385196215873389924411185e-03,
  4.57197215965471012721899057851260e-03, 5.83933975749266996613240365832098e-03,
  7.11288144376080559705410877313625e-03, 8.39883736760512096541919646597307e-03,
  9.66754483943707901283382000201527e-03, 1.09090470052662421446276752590165e-02,
  1.21397171508674378559433648661070e-02, 1.33653282186976807288658619654598e-02,
  1.45714496319469446333760842549054e-02, 1.57502335708427990135227503287751e-02,
  1.69098279309978505313694085998577e-02, 1.80541291607646606220960450173152e-02,
  1.91739560289897227607358587420094e-02, 2.02631490603018930840573119667170e-02,
  2.13265957410324960563663410084700e-02, 2.23670667107838463949498475358268e-02,
  2.33778723066415776432602768863944e-02, 2.43539740944365146191330495639704e-02,
  2.52987057545335410069231585339367e-02, 2.62142153588320742096939852672222e-02,
  2.70952482125000997104091737810450e-02, 2.79375527135172704862320358643046e-02,
  2.87436662944730685065319875093337e-02, 2.95154217742633132037788357138197e-02,
  3.02485081805798951271047059208286e-02, 3.09392646059463184704529936652762e-02,
  3.15898303301099386830586013275024e-02, 3.22019211811579442183983701397665e-02,
  3.27719086922384494897642071009614e-02, 3.32965992993431922353231300348853e-02,
  3.37779701913215324449168974751956e-02, 3.42177572733837961904690416758967e-02,
  3.46128591168387289567220932440250e-02, 3.49604635767021970638168681944080e-02,
  3.52625393246283128090290404088591e-02, 3.55209439395506657022316687744024e-02,
  3.57329991487812179129512912822975e-02, 3.58962058048124116327315391572483e-02,
  3.60126320686600803755439414999273e-02, 3.60843383740518872104807712730690e-02,
  3.61089903517822843892481898819824e-02,
  6.52609239669610613314432168152734e-04, // N = 89
  1.82866662312671304779776448867779e-03, 3.11963151271295920791137845640151e-03,
  4.36914294179755868102743576741886e-03, 5.58094000187005744029189457933171e-03,
  6.79904203010949902824533452871947e-03, 8.02892548576001306714911009976277e-03,
  9.24272339819595147025754755532034e-03, 1.04316020380666729661101044257521e-02,
  1.16107862439096629764145873764392e-02, 1.27851713787794172422218608176081e-02,
  1.39416004820396635666135409792332e-02, 1.50733817093048685920031459772872e-02,
  1.61877238133181465540300081329406e-02, 1.72875948436387871787189851602307e-02,
  1.83649818414824868295642801285794e-02, 1.94149243967382048592362764338759e-02,
  2.04413742261562551838505186196926e-02, 2.14460870609502682326841238591442e-02,
  2.24235475869847371288567927649638e-02, 2.33699841659307551433588656664142e-02,
  2.42877246620108351582434380588893e-02, 2.51777859133709806804812814107208e-02,
  2.60361382845751762604713519522193e-02, 2.68598852030172072224978307986021e-02,
  2.76504499909962717096867379495961e-02, 2.84083918817896255437638330931804e-02,
  2.91307017028212891784910709702672e-02, 2.98151821571169158009428912237126e-02,
  3.04627224781950436960364925198519e-02, 3.10735961751540008812799698034723e-02,
  3.16455750815045205870390532254532e-02, 3.21770615260243697530739837020519e-02,
  3.26686211404204132624506939919229e-02, 3.31203489644073603703766650596663e-02,
  3.35306657372060334942887038778281e-02, 3.38985174843230638308533286817692e-02,
  3.42242721444562039700976185940817e-02, 3.45079117379547203880996164571116e-02,
  3.47484304960003417828140470646758e-02, 3.49452891969027831797767191801540e-02,
  3.50987332775636734494284496577166e-02, 3.52086668839763292093714142083627e-02,
  3.52746151705842295176474010531820e-02, 3.52965433781745607788593588338699e-02,
  6.24291857182897379045793950780308e-04, // N = 91
  1.74909651748554237880861617071560e-03, 2.98417191546624738576753976815326e-03,
  4.17984253266521534053712372269729e-03, 5.33932741808157765306397379845293e-03,
  6.50505471381713704093208150425198e-03, 7.68283318432196743463791221984138e-03,
  8.84569677730070828836073104639581e-03, 9.98469672095886155716026877371405e-03,
  1.11149000844716055319549852242744e-02, 1.22416738114025872713463982677240e-02,
  1.33519700688588816017698945870507e-02, 1.44387621659281071423430731215376e-02,
  1.55095798910579157209310707798977e-02, 1.65680549706382421182304653939354e-02,
  1.76059282334919929569050367490490e-02, 1.86177060256254127412756105286462e-02,
  1.96079145136814521344081896359057e-02, 2.05791313174339962621672839304665e-02,
  2.15253610497680575308621087060601e-02, 2.24421209931162310424745953696402e-02,
  2.33324891507515723432231169454099e-02, 2.41984441723208584806847909476346e-02,
  2.50352854772741412192615939602547e-02, 2.58392332899758658815159151345142e-02,
  2.66126057045400245260058369467515e-02, 2.73570586993094229388834293104082e-02,
  2.80687353777391221387738085013552e-02, 2.87443783519136901449808618735915e-02,
  2.93859058381667412329640853840829e-02, 2.99948279904526486638882687429941e-02,
  3.05678919944721502743867347362539e-02, 3.11022503108643218194817592348045e-02,
  3.15996335417294063607762666379131e-02, 3.20615270348692388280298359859444e-02,
  3.24851405886130914502096800333675e-02, 3.28679599954718945631348958613671e-02,
  3.32116653448070800469515972963563e-02, 3.35178056108507357868653286914196e-02,
  3.37839606270188136383225696590671e-02, 3.40078912750661072061930667587148e-02,
  3.41913225869242831667094151271158e-02, 3.43359362733218348440189515713428e-02,
  3.44396142526863374699885866903060e-02, 3.45003417525124450593310143631243e-02,
  3.45199599911868298951489464343467e-02,
  5.97684967573795951877035914634462e-04, // N = 93
  1.67481784665280742686876980229727e-03, 2.85737287489860446870748589276445e-03,
  4.00226648687370106100003042115532e-03, 5.11302445937321901892058662042473e-03,
  6.23008715205487176996834719489016e-03, 7.35860658178920639532760716861048e-03,
  8.47316188178166840305749474282493e-03, 9.56575253679172420040455193657181e-03,
  1.06504500408590233040406758391327e-02, 1.17318719141599886457427714958612e-02,
  1.27980532271761669738108224692041e-02, 1.38429393314047043117565038983230e-02,
  1.48732556066118511844953431477734e-02, 1.58918480543355881973166532361574e-02,
  1.68914437747765648623055056987141e-02, 1.78675538554650091549458323925137e-02,
  1.88239115205497999083750215731925e-02, 1.97622425881105352740707559178190e-02,
  2.06775388971262852333410364735755e-02, 2.15663760475398903759813862279771e-02,
  2.24309874464064494536952309999833e-02, 2.32724096628488842652959789347733e-02,
  2.40869687772391309621422550435454e-02, 2.48720134761777275644867302162311e-02,
  2.56289337266913212765029328465971e-02, 2.63583327910462995868901003859719e-02,
  2.70574413972946813122799625261905e-02, 2.77242163581443122610803442285032e-02,
  2.83595421252021591407288525488184e-02, 2.89637455436348445481087310326984e-02,
  2.95347393935718287305558504840519e-02, 3.00709935046277812564774478687468e-02,
  3.05730794046400675134655955389462e-02, 3.10411465983298183457517183114760e-02,
  3.14736658599958779580774148598721e-02, 3.18695649487714324776810315142939e-02,
  3.22292189517152868893923312043626e-02, 3.25526625041441947105980148080562e-02,
  3.28388523306812965540935067565442e-02, 3.30871434458519381172081352815439e-02,
  3.32977861301501157353932569549215e-02, 3.34707369892656356191729116744682e-02,
  3.36053965903812049131893502362800e-02, 3.37015328101193389898071472998708e-02,
  3.37593131525360870548446712291479e-02, 3.37786328692505979920390757342830e-02,
  5.72829097876508940706541395115892e-04, // N = 95
  1.60497905815551087337078595140838e-03, 2.73845730772187285345653506851704e-03,
  3.83604480111798080629870177915564e-03, 4.90081757383967978741745596948931e-03,
  5.97180029668951343341243287454745e-03, 7.05440772856855136119236249214737e-03,
  8.12401483719167941122130116582412e-03, 9.17253328779174190166223468168027e-03,
  1.02138704414025029837409519473113e-02, 1.12530244456118411894296471587040e-02,
  1.22781383591508072572473508898838e-02, 1.32828836421370020948184986764318e-02,
  1.42742372608193092420325598368436e-02, 1.52555900985343467768373670878645e-02,
  1.62194725139671695746113044833692e-02, 1.71609553687083887796305248230055e-02,
  1.80842419026828564454500991587338e-02, 1.89917369831594622098247526764681e-02,
  1.98780383270258063921342994717634e-02, 2.07391343915472731174176601598447e-02,
  2.15778786449664188029640143895449e-02, 2.23961039599647956932493286785757e-02,
  2.31895838033569084979390595435689e-02, 2.39549396073645559646081437676912e-02,
  2.46943034508163294926674780072062e-02, 2.54091862980178433140121541100598e-02,
  2.60961216921010222269394773775275e-02, 2.67521972010912149897432499301431e-02,
  2.73791509492214008014698833903822e-02, 2.79783309851037095827841483242082e-02,
  2.85468102111126192932388789813558e-02, 2.90820389037249327213174865391920e-02,
  2.95855533122951590285776291011643e-02, 3.00586464349271269280716722960278e-02,
  3.04988008629325860199266173822252e-02, 3.09037604143260723199571060604285e-02,
  3.12749827594418494669525898643769e-02, 3.16137837632046794777984644042590e-02,
  3.19179720704921635054951423171588e-02, 3.21855341273307241078960316826851e-02,
  3.24179341623930181159884966746176e-02, 3.26165707709662258673155577071157e-02,
  3.27795190150783621874097661930136e-02, 3.29049658280787735153971595991607e-02,
  3.29944447353025666069825660997594e-02, 3.30494862372945411022051587224269e-02,
  3.30683841507867434805767459238268e-02,
  5.49413282427096472983196751016521e-04, // N = 97
  1.53959552984370877729003446177103e-03, 2.62683534109881986970402856229612e-03,
  3.67970049756695134074435671323045e-03, 4.70151400816572022367534344766682e-03,
  5.72955182652640660628806656973211e-03, 6.76866032980113791622800434311102e-03,
  7.79555351944573229200363684299191e-03, 8.80295005812674162537501132419493e-03,
  9.80388895764546138000827824043881e-03, 1.08027238623195978584057286298048e-02,
  1.17885255864751004734047867827940e-02, 1.27557895092654683538713200618986e-02,
  1.37107987316064695859640920616584e-02, 1.46562739456828142192712505220697e-02,
  1.55855845622811482742431365977609e-02, 1.64946501366945164068766871423577e-02,
  1.73869966697634305285991018763525e-02, 1.82643079635756953871261742960996e-02,
  1.91220180797116584558992258280341e-02, 1.99570068622041546513301568666066e-02,
  2.07714123931758871954844636320558e-02, 2.15662756387350364184474216244780e-02,
  2.23382371948743531364645065195873e-02, 2.30848662203849037954928036242563e-02,
  2.38075143310232280324800768767091e-02, 2.45068135293130227869706772025893e-02,
  2.51802133721940948896111933663633e-02, 2.58258177135411888525329260346552e-02,
  2.64445011553372938406525349819276e-02, 2.70366303443647787441150853737781e-02,
  2.76002566622617941105577443750008e-02, 2.81339283397896364191659301923210e-02,
  2.86382196330264363060003063310432e-02, 2.91133232289075873089334578480702e-02,
  2.95577759324559749543048781106336e-02, 2.99705168403725935588610695958778e-02,
  3.03519274946024396333310590989640e-02, 3.07020854917752043788947702296355e-02,
  3.10199445653509889297971824362321e-02, 3.13048034688244436463122610803111e-02,
  3.15569185173944152800196150110423e-02, 3.17762889143052076890150203780649e-02,
  3.19622443006865250558767854727193e-02, 3.21144264228078180067882385628764e-02,
  3.22330079434589994447080130157701e-02, 3.23179296153411899084062497422565e-02,
  3.23688730441163419193628669745522e-02, 3.23858168627014497698013428816921e-02,
  5.27476968378448856505924524640250e-04, // N = 99
  1.47796392817401583442971091386653e-03, 2.52187657314923482226864948074763e-03,
  3.53295570148335269164419081278083e-03, 4.51413316260013304515030796437713e-03,
  5.50142039933779799371071916880283e-03, 6.49987253216620722295893131104094e-03,
  7.48691027641318167240580550014784e-03, 8.45518563977508755269418827538175e-03,
  9.41757222968566017062830297845721e-03, 1.03787329241164811427511338592922e-02,
  1.13278438578784945711674936319469e-02, 1.22591748799479142995050295894544e-02,
  1.31792068212073232302827818784863e-02, 1.40911110472703472729083529202398e-02,
  1.49880989346804997103257406365628e-02, 1.58657236988720695691768014512490e-02,
  1.67278985537773657032989405024637e-02, 1.75768726412449984020103244120037e-02,
  1.84077538519827818563889820779877e-02, 1.92169329826558238361045027886576e-02,
  2.00070643859270071163170001682374e-02, 2.07798535198554165659423631495883e-02,
  2.15314818077819852826237934095843e-02, 2.22589139301300892315182977654331e-02,
  2.29641216311695130214420856873403e-02, 2.36484943738632588661197075907694e-02,
  2.43089029298124773004197152204142e-02, 2.49427312116374186312661720421602e-02,
  2.55515676298999211413232046652411e-02, 2.61366295727179995256328481900709e-02,
  2.66952731071584993538525765188751e-02, 2.72252058087953593967789345242636e-02,
  2.77278075508690588502069829246466e-02, 2.82042205700282801184020087248427e-02,
  2.86521667109021771491228491868242e-02, 2.90696140121513013632181809953181e-02,
  2.94578454056429669960515127513645e-02, 2.98179973237099396610183532629890e-02,
  3.01480810667995972884636302069339e-02, 3.04462797396853959708273862361239e-02,
  3.07138558577389579606897740404747e-02, 3.09519926155660748956499617179361e-02,
  3.11589374965972366882116517672330e-02, 3.13330525912319732273481065476517e-02,
  3.14756358269987560061231590680109e-02, 3.15879594586861711658087870091549e-02,
  3.16684660566114092872247454124590e-02, 3.17156645039733814384064203295566e-02,
  3.17309313985214072606488855399220e-02,
  5.06761668035003286919559783996192e-04, // N = 101
  1.42011023816578920916930961482194e-03, 2.42310374582142351931879353799104e-03,
  3.39459089289617177778723977610298e-03, 4.33770360526359102792959276939655e-03,
  5.28690708431084430835023013628415e-03, 6.24676165289294801907793441841932e-03,
  7.19585591375769551003571677938453e-03, 8.12753366255909368010001969651057e-03,
  9.05390685313328495709139787095410e-03, 9.97908051277203618500966086912740e-03,
  1.08930311491453272326745960185690e-02, 1.17907321005433739224965705716386e-02,
  1.26780618370114523535407968779509e-02, 1.35576160115580858500639038766167e-02,
  1.44233248722898995536345623236230e-02, 1.52714638121734802567175393051002e-02,
  1.61053634782937077352116261863557e-02, 1.69266578757386911002758012045888e-02,
  1.77311684667018631955670571187511e-02, 1.85160424617774148348114948703369e-02,
  1.92833235218073315020426150567801e-02, 2.00340458307194310694221428548190e-02,
  2.07651284717193032602899904759397e-02, 2.14743382018096930219375195747489e-02,
  2.21629849266008066566158163368527e-02, 2.28317175688748479067680108300920e-02,
  2.34781840789095759547411290668606e-02, 2.41006258772179897398313386247537e-02,
  2.46999035373259012704494352874462e-02, 2.52764125748327281306693237183936e-02,
  2.58283368091226477047950282894817e-02, 2.63543068186906682959236292163041e-02,
  2.68548963629062706348626932140178e-02, 2.73303318901101099935857519085403e-02,
  2.77792238924391733656538150398774e-02, 2.82005405794783677031478674734899e-02,
  2.85946683834066468776757830028146e-02, 2.89617197905012967173998816861058e-02,
  2.93006670351198122981273286313808e-02, 2.96107849404606930654448859741024e-02,
  2.98923358170391541277499669604367e-02, 3.01453537745721283913624688466371e-02,
  3.03691332001646135951844485134643e-02, 3.05632377063106766557076809931459e-02,
  3.07278456694170497287554866261416e-02, 3.08629341217089812887675037700319e-02,
  3.09680956236687426885723084524216e-02, 3.10431739969451274407941099298114e-02,
  3.10882877824048831083558752652607e-02, 3.11033666417499451983808000932186e-02,
  4.87304999364339202442414356042377e-04, // N = 103
  1.36544874278114909682546596059183e-03, 2.33000101504979425723340646925408e-03,
  3.26439686591731541981387110240576e-03, 4.17142620889466436695514062193979e-03,
  5.08442054529746612079321721466840e-03, 6.00810667526670109939157526923736e-03,
  6.92170379743429608349059023453265e-03, 7.81850559964216394737146487159407e-03,
  8.71046071554973724837545034915820e-03, 9.60192687508169134824598245359084e-03,
  1.04829822954283138208841918981307e-02, 1.13484134998613310496562434082080e-02,
  1.22042546136597804262713395928586e-02, 1.30534765769616117880858041644387e-02,
  1.38898821603156662207734228786649e-02, 1.47094397009207931287244619511512e-02,
  1.55158008495526258951890952175745e-02, 1.63110735961609527866489344205547e-02,
  1.70908075092283534557324742308992e-02, 1.78517392463072542552193766596247e-02,
  1.85963452026383369020123836889979e-02, 1.93262180774479153111400364650763e-02,
  2.00378923852116766490816246459872e-02, 2.07286281998831957429363370692954e-02,
  2.14002572074576749572294431800401e-02, 2.20540651816187628642129681111328e-02,
  2.26872155004254998089674444372577e-02, 2.32973479088205807918665612987752e-02,
  2.38859241386193341116772614896036e-02, 2.44540540935250724774441266617941e-02,
  2.49993407798070887970709463843377e-02, 2.55197149350083161978286483417833e-02,
  2.60164282047372456829759101992749e-02, 2.64905023258958892407033403060268e-02,
  2.69398692856771919401648318626030e-02, 2.73626926097259963455154974099059e-02,
  2.77601154404415600973621280900261e-02, 2.81331335941108623410755740223976e-02,
  2.84799378615283420301818040343278e-02, 2.87988834796081318023741602019072e-02,
  2.90910743327394555324261204987124e-02, 2.93575269882304958068974798379713e-02,
  2.95966428135477736816039140421708e-02, 2.98069371187293062630541129465200e-02,
  2.99895246374859078541952328578191e-02, 3.01454796444084321960232841774996e-02,
  3.02733778891073959660396042181674e-02, 3.03718677577939841216725369577034e-02,
  3.04421131727412100365093294840335e-02, 3.04852771810882154646105135498146e-02,
  3.05000799265303483565059394777563e-02,
  4.68890412532647817694941849708812e-04, // N = 105
  1.31401177344744424062283894016900e-03, 2.24217902861296742439423113069097e-03,
  3.14135858114051322656501419317010e-03, 4.01450330166162015765873860573265e-03,
  4.89357103356846158404014346388067e-03, 5.78285549480728969934384409157246e-03,
  6.66260052647352999516394689294430e-03, 7.52669680988031237350854851797521e-03,
  8.38642143571117007483373129161919e-03, 9.24564642367758926511100980860647e-03,
  1.00951448880688358228363554758289e-02, 1.09303080645236048995538880035383e-02,
  1.17566440766198408024445498654131e-02, 1.25766261025257782696362696128745e-02,
  1.33846768435568388294631958501668e-02, 1.41773833343292691294701413085022e-02,
  1.49578928259961208696582346533432e-02, 1.57277848399199025875017099451725e-02,
  1.64832217695500757304039041173382e-02, 1.72215865726433534077521869676275e-02,
  1.79448306232038203023027023164104e-02, 1.86539732755886776549569816552321e-02,
  1.93461807334540242253595465626859e-02, 2.00193966775023858561954881452039e-02,
  2.06748872641002549854771785931007e-02, 2.13133092548962732593054170138203e-02,
  2.19324898926281479372146776540831e-02, 2.25307977860183597518251019664604e-02,
  2.31090761942293887454269452064182e-02, 2.36677407273614449911836032924839e-02,
  2.42050995837327191650967250780013e-02, 2.47198654939469256164308319512202e-02,
  2.52126087546057850441449943446059e-02, 2.56835817560204203446883042261106e-02,
  2.61314711855362737102925763110761e-02, 2.65552845576970258933968693781935e-02,
  2.69554112786925467726284466607467e-02, 2.73319919344256617721455882019654e-02,
  2.76840302548599162535403195306571e-02, 2.80107981542931303020615985133190e-02,
  2.83125631747852650466068524792718e-02, 2.85893880912908293634444589770283e-02,
  2.88405556942007770815372680317523e-02, 2.90655840023386971560093172683992e-02,
  2.92646570346388849859220471216759e-02, 2.94377813146978681291265900199505e-02,
  2.95844950874515726091384948404084e-02, 2.97045524573255476097344285335566e-02,
  2.97980781089354634927346410222526e-02, 2.98650341454565829146794442294777e-02,
  2.99052001262343561394096980166069e-02, 2.99185624812038503117506138551107e-02,
  4.51553309690733660746592148527156e-04, // N = 107
  1.26530785343076336221801447834423e-03, 2.15921230854912828481251274581609e-03,
  3.02531841217637065613588198687012e-03, 3.86627851607895464680630936982197e-03,
  4.71303044511106172115288970303482e-03, 5.57000106329473294169973840439525e-03,
  6.41799937477051038459130438695865e-03, 7.25087895074616548690693562662091e-03,
  8.07975781197234170505350192570404e-03, 8.90871556022121251217082971152195e-03,
  9.72862286059749531430540514520544e-03, 1.05347153795185971558723281304992e-02,
  1.13326238067258493191769019858839e-02, 1.21251357806568139247049842310844e-02,
  1.29065708397862050071935868800210e-02, 1.36732569668983061639266907150159e-02,
  1.44286090602558526169163499730530e-02, 1.51746066083601870849717485612018e-02,
  1.59071838709435829650740146234966e-02, 1.66233766851126944785743688726143e-02,
  1.73255013842881742947010792477158e-02, 1.80150498883290891005692913040548e-02,
  1.86888639929835911890343425056926e-02, 1.93444594182588837372183121487978e-02,
  1.99835441514096164017377788013619e-02, 2.06073140941819381299904279103430e-02,
  2.12131876782280688609194641003342e-02, 2.17990265723951720522322261786030e-02,
  2.23661836713129648368525437263088e-02, 2.29156788265721216013570682434874e-02,
  2.34453311252252327712142232485348e-02, 2.39532656229841066364283364009680e-02,
  2.44406269940015581643155684332669e-02, 2.49083388857638081403944596559086e-02,
  2.53545182345186401184911062500760e-02, 2.57774995610442307636400727233195e-02,
  2.61783122575080344496267770182385e-02, 2.65578400478954645969054126908304e-02,
  2.69144328127892337731985605842056e-02, 2.72465969621118221655198254893548e-02,
  2.75553096322739554668856953867362e-02, 2.78414564425344748799240335301874e-02,
  2.81035761152278289187744775290412e-02, 2.83403186910750094773536744696685e-02,
  2.85526543486100820024020663367992e-02, 2.87415032954145312216187591047856e-02,
  2.89055606864295280833410117793392e-02, 2.90435969416686888544543165835421e-02,
  2.91566095980958922551096179631713e-02, 2.92455804105937709758133991044815e-02,
  2.93093349655318205493337302414147e-02, 2.93467429255595164960812581966820e-02,
  2.93588566005714667050963129213415e-02,
  4.35110966080865207809835748520300e-04, // N = 109
  1.21937278348611239341126033508544e-03, 2.08078078058774153594190359228833e-03,
  2.91542524966249263704276550868144e-03, 3.72609189131934250352462534294773e-03,
  4.54249285080746308118637699635656e-03, 5.36867401571611019966967504046806e-03,
  6.18634824193941418313258395755838e-03, 6.98988746239648326558091540050555e-03,
  7.78981475496990250634299357557211e-03, 8.58978451265931738922709826056234e-03,
  9.38127427684858072876039614129695e-03, 1.01600427506467558963487718415308e-02,
  1.09312588153440710253549994490641e-02, 1.16972771848123414939468744933038e-02,
  1.24529552338060768568173131143340e-02, 1.31951543139994745962306765818539e-02,
  1.39268499962953689469413731671921e-02, 1.46495648399596299638059093695119e-02,
  1.53597626103089482385577468903648e-02, 1.60550348684188014247720133198527e-02,
  1.67372436594253465313997253360867e-02, 1.74073878188885748652392493340813e-02,
  1.80628534085319411572889691797172e-02, 1.87017425701202430476932647707144e-02,
  1.93252767050864811271271292980600e-02, 1.99341134851707645070373331463998e-02,
  2.05262419687796578149363568854824e-02, 2.11001475195162664644232819455283e-02,
  2.16566536092034286897778372349421e-02, 2.21961889406663212542802909865713e-02,
  2.27171772786052099390996517058738e-02, 2.32184109114097064763271305309900e-02,
  2.37004541036327232017555388665642e-02, 2.41635787338281317337962406099905e-02,
  2.46065470625421445216574056757963e-02, 2.50284112321297949610432453937392e-02,
  2.54295616580526538663686864083502e-02, 2.58101613110101532622131514926878e-02,
  2.61692528500437580907256318596410e-02, 2.65061187838481378264976484615545e-02,
  2.68210307458623467558034292324010e-02, 2.71140749954542764621479022935091e-02,
  2.73845382884497154374336957971536e-02, 2.76319151680443908514206441395800e-02,
  2.78563947899993120949080349646465e-02, 2.80580079008002393481380210005227e-02,
  2.82362623629186307305793945943151e-02, 2.83908539447119030729727029438436e-02,
  2.85219130068849746617587470609578e-02, 2.86294276249504583975458160693961e-02,
  2.87131124484366201388141348616045e-02, 2.87728591594232224748495241328783e-02,
  2.88087537695146077287855490567381e-02, 2.88207475679800907697458711709260e-02,
  4.19596408108236331498813731499808e-04, // N = 111
  1.17579127342019753958701766549666e-03, 2.00653090914678679246296866267585e-03,
  2.81156047295043429873340201652354e-03, 3.59340038641513693368212400969242e-03,
  4.38084198612032765796087119269941e-03, 5.17803784244214200527256508621576e-03,
  5.96720939332967027779464075365468e-03, 6.74270170968126365818040568456126e-03,
  7.51488439837821181610522103255789e-03, 8.28758315713630164256464638583566e-03,
  9.05236863927878949998007129806865e-03, 9.80486938298080236420251054596520e-03,
  1.05503506587694591278836497849625e-02, 1.12914321845241603925469320302000e-02,
  1.20228876577233596140148463859987e-02, 1.27413585722091892565854820418281e-02,
  1.34500448351212876368920845493449e-02, 1.41508085326335214526594086237310e-02,
  1.48399208761505526504853591518440e-02, 1.55146780276252480718079951316213e-02,
  1.61772515941589582755266718550047e-02, 1.68290427088716651460309492449596e-02,
  1.74671619803365811562922971234002e-02, 1.80893475667000883100321573238034e-02,
  1.86971972097750467611820823776725e-02, 1.92918278970221589163624997809166e-02,
  1.98708813839717432503384486608411e-02, 2.04324127548036922619179023286051e-02,
  2.09776801637053846028013737168294e-02, 2.15076267814876681550018133748381e-02,
  2.20202614459384937717345565033611e-02, 2.25138790831208024378895515837939e-02,
  2.29895337377514531740363423750750e-02, 2.34480678479211043785390700122662e-02,
  2.38877615203779009034334990246862e-02, 2.43070993404254018233068279641884e-02,
  2.47070166596951787396641009308951e-02, 2.50883063927027985529072395820549e-02,
  2.54494596097490956287945351732560e-02, 2.57891158987605569052892207082550e-02,
  2.61081495823131636002667477214345e-02, 2.64073418128670835136606598325670e-02,
  2.66853539795080911545266388884556e-02, 2.69409550746184563163598824075962e-02,
  2.71749995965336749170759844673739e-02, 2.73882861514089734344956639233715e-02,
  2.75796170527947935580126426202696e-02, 2.77478702380414936345953691443356e-02,
  2.78939113457810777818579595077608e-02, 2.80185801656523507385809779179908e-02,
  2.81207969531590586120817221171819e-02, 2.81995307047123340560279558530965e-02,
  2.82556826334946949164095286732845e-02, 2.82901540486563025933453019433728e-02,
  2.83019635580757829285136750741003e-02,
  4.04854425681090213714335979133807e-04, // N = 113
  1.13460065721315947646907762447199e-03, 1.93619770255745986958784143894263e-03,
  2.71300553415214622948736788998758e-03, 3.46765413778949609449608892930428e-03,
  4.22783675301201256058192257114570e-03, 4.99736923841801339990498220799964e-03,
  5.75927432452592001632662999099921e-03, 6.50834972907541730452463113465456e-03,
  7.25443562482007853892129745077000e-03, 8.00098358553998599551615455993669e-03,
  8.74009715423504883469174586707595e-03, 9.46785986312446113666307923040222e-03,
  1.01891295077848678674037330438296e-02, 1.09061472133281517349345790535153e-02,
  1.16141559009874974217613186056042e-02, 1.23102595419394798825774017814183e-02,
  1.29972732953008585782272987785291e-02, 1.36766618470586364536556445159476e-02,
  1.43451565061390069744096109616294e-02, 1.50005340839299023542041666701152e-02,
  1.56445707763738471596237644689609e-02, 1.62782409845618029897718059828549e-02,
  1.68991269319162043527349226224032e-02, 1.75054728474512630298498550018849e-02,
  1.80984551625723404100209990019721e-02, 1.86787272173665544472420663169032e-02,
  1.92444240978762934335399847896042e-02, 1.97941378967653458520459253122681e-02,
  2.03286705267696418686362846983684e-02, 2.08484582266852264131884453490784e-02,
  2.13520314275737234377405826535323e-02, 2.18382580667711920230367184103670e-02,
  2.23076942432819877448757495130849e-02, 2.27606260248175255866964761253257e-02,
  2.31958887755068718372619684942038e-02, 2.36125814725028533580530876179182e-02,
  2.40110936936184966861151934836016e-02, 2.43916059940075570511286429109532e-02,
  2.47532037580798502940382377346396e-02, 2.50951885612041569739716351250536e-02,
  2.54178348386583062568089275146122e-02, 2.57212479828857892849569566351420e-02,
  2.60047287870536041054503328950886e-02, 2.62677633311022978856996701324533e-02,
  2.65105451385762025395820273843128e-02, 2.67331249347123878212784120478318e-02,
  2.69349966860487517739120022497445e-02, 2.71158197923241812976602460594222e-02,
  2.72757297141034554810445911243733e-02, 2.74147356920586872386369492460290e-02,
  2.75325106364013652560096545585111e-02, 2.76288810142683236015237469018757e-02,
  2.77039389105926646406086177876205e-02, 2.77576593729842273361452242852465e-02,
  2.77898855555865076372157318473910e-02, 2.78006086006585100001142762948803e-02,
  3.90915649315165525650578315364214e-04, // N = 115
  1.09544774581676494437654234559432e-03, 1.86948539049794620198197137028728e-03,
  2.61967148259253414244174251734876e-03, 3.34840082427376780488392782331175e-03,
  4.08253277469900009016834374619975e-03, 4.82596873651658462428537532673545e-03,
  5.56219082883947085749198890880507e-03, 6.28597801067373295608176064774852e-03,
  7.00702336924278416235845057258302e-03, 7.72892041939083219298511906458771e-03,
  8.44386127736928074338784711017070e-03, 9.14782010487214837513025855741944e-03,
  9.84573026897666604695391612267485e-03, 1.05400574018447035912204867713626e-02,
  1.12259764623539801120521985922096e-02, 1.19004038082574092882737204490695e-02,
  1.25663435418484556449492117735645e-02, 1.32255501650315552414349795640192e-02,
  1.38745915850606981595261046891210e-02, 1.45109917324911831537637141309460e-02,
  1.51367907712192228258940573937252e-02, 1.57533075260849128595985746414954e-02,
  1.63578889332766930220230960912886e-02, 1.69484676856983609849471861252823e-02,
  1.75265425278505852790811303520968e-02, 1.80931604001294439598712671113390e-02,
  1.86461594592584288532233216528766e-02, 1.91837641265290605174786975339885e-02,
  1.97071491606809721941484525586930e-02, 2.02171915021548548319074711798748e-02,
  2.07120672203955427659316512745136e-02, 2.11902203202165816120494667984531e-02,
  2.16526269985368481629794956688784e-02, 2.21000614087627812731629006748335e-02,
  2.25309479997394326855619794969243e-02, 2.29439034872242347828930064679298e-02,
  2.33397843304292730570725922234487e-02, 2.37193087488832173026498395529416e-02,
  2.40810933295038838430901506626469e-02, 2.44238953340682046766474400101288e-02,
  2.47485044866966839849364845349555e-02, 2.50556173981367792669150418305435e-02,
  2.53440051086880717423621689476931e-02, 2.56125419858145644824709563636134e-02,
  2.58619887037024528964046510282060e-02, 2.60930465932716834642768333196727e-02,
  2.63046142212462509546444522356978e-02, 2.64956647494280807253463905226454e-02,
  2.66669579323899515188589504077754e-02, 2.68192209479638163371895132058853e-02,
  2.69514592602958652500788616634964e-02, 2.70627293311034959610861250212110e-02,
  2.71538119767414480587586211868256e-02, 2.72254780070373680889161960294587e-02,
  2.72768227061053053494887876695429e-02, 2.73069715408828482539060900080585e-02,
  2.73167443997778501552087249137912e-02,
  3.77647427242911945272779705717880e-04, // N = 117
  1.05837011439779407270811439900626e-03, 1.80617313800840234225275615642659e-03,
  2.53094782753637316530248568824391e-03, 3.23517931884357472574476055626747e-03,
  3.94473943923181677440048531479988e-03, 4.66323069988397020252390845485024e-03,
  5.37484887798359619454080515765781e-03, 6.07477027746751094272603666013310e-03,
  6.77221488932363072099640532997000e-03, 7.47044550924513568040952193882731e-03,
  8.16212453558611862602933939569994e-03, 8.84362404397421794643996406648512e-03,
  9.51951620381025556683063371110620e-03, 1.01919338946583164229320317417660e-02,
  1.08564635664575460244352100858123e-02, 1.15104247450775829669789018794290e-02,
  1.21564828797915101821214278743355e-02, 1.27960449741006798002329603036742e-02,
  1.34260808219927568057938671586271e-02, 1.40445323370501588128300696212136e-02,
  1.46530936467704070436113283903978e-02, 1.52527121337979968546116893435283e-02,
  1.58411455621914956659601614319399e-02, 1.64167657806962852262699925631750e-02,
  1.69807046277164266911974266349716e-02, 1.75336071893156322798468238488567e-02,
  1.80737404254324510177731610838237e-02, 1.85997937732175072644835722712742e-02,
  1.91125463991515566475332121854080e-02, 1.96124376931245229804812169049910e-02,
  2.00980961418281353636494657166622e-02, 2.05684607808666840289557597998282e-02,
  2.10240778328049451872949759945186e-02, 2.14652432242582701105160225552027e-02,
  2.18908619216992700318158426853188e-02, 2.23000799702017249437346890772460e-02,
  2.26932844628910772299956732922510e-02, 2.30706695193658786746659927757719e-02,
  2.34313646795689216328906212538641e-02, 2.37746956782716109546349514403119e-02,
  2.41009384545167702762480388400945e-02, 2.44102138598359594268139005635021e-02,
  2.47018430569586472378418307016545e-02, 2.49753137873618136222120256206836e-02,
  2.52308230415292725212772495524405e-02, 2.54684380204729630958748742841635e-02,
  2.56876501029307188761485747363622e-02, 2.58880977463781351832761146170014e-02,
  2.60699208417950085980852037437216e-02, 2.62331460610968833502276709168655e-02,
  2.63774210266963238247228673571954e-02, 2.65025281123261423343873133262605e-02,
  2.66085646530480127158746483928553e-02, 2.66955248192748822999575963876850e-02,
  2.67632035784580481208028146511424e-02, 2.68115238229036725869924850940151e-02,
  2.68405493251363570783585288381801e-02, 2.68502454488868912141352751632439e-02,
  3.65078057985456676855923197067000e-04, // N = 119
  1.02306558201893595290432603661657e-03, 1.74601192536355661819036377835346e-03,
  2.44676829912422299367902311928447e-03, 3.12761049197181773690035200274906e-03,
  3.81365291023223794766860983429524e-03, 4.50856663104702657524081033102448e-03,
  5.19696383430109497963966802558389e-03, 5.87400848501561014675109717586565e-03,
  6.54878027494493111099194138091661e-03, 7.22466002612738838334349722458683e-03,
  7.89439419219833612983983073263516e-03, 8.55426260451658260208773754129652e-03,
  9.20889637165119880057861934119501e-03, 9.86061950098042830359368338122295e-03,
  1.05049632261270259325769416136609e-02, 1.11390861716998430114289320158605e-02,
  1.17658136266726044000252571208875e-02, 1.23868012490963921856668150667247e-02,
  1.29988794858331285775321362052637e-02, 1.35997725844584586157859362742784e-02,
  1.41914008729523751645151818934210e-02, 1.47750081640068645777441602717772e-02,
  1.53481501390926519667878835662123e-02, 1.59089304494055353011994213829894e-02,
  1.64587583817501006966388388264022e-02, 1.69986181370096987863771431648274e-02,
  1.75265213303943019618191812014629e-02, 1.80408412909007845326136987296195e-02,
  1.85426786673440237296350829865332e-02, 1.90328524838918738959492316098476e-02,
  1.95096867277235429261050825289203e-02, 1.99717567379526297899339226660231e-02,
  2.04199710253188358721754269708981e-02, 2.08550455126902747893247180854814e-02,
  2.12755326971375141598130653619592e-02, 2.16801660166034658450140426566577e-02,
  2.20697348529071343814500494318054e-02, 2.24448951052200230960043114691871e-02,
  2.28043751663471634671953580664194e-02, 2.31470365748371667558025421840284e-02,
  2.34735985042059183691698365237244e-02, 2.37846882120206076782764625932032e-02,
  2.40791748791160005460643134256316e-02, 2.43560265009216472820163801316085e-02,
  2.46159266741874764583553059082988e-02, 2.48594979119677421397494043731058e-02,
  2.50857253235578780969916579124401e-02, 2.52936667517428825924241664324654e-02,
  2.54839959210502696451694504276020e-02, 2.56573495857394459629396976652060e-02,
  2.58128100395869780614432897891675e-02, 2.59495112888946943829893143629306e-02,
  2.60681371123701322023435977826011e-02, 2.61693542620219689320837375134943e-02,
  2.62523270664075034086515358922043e-02, 2.63162534981451375071248577341976e-02,
  2.63618435229457555302179372347382e-02, 2.63898076154782078306393344746539e-02,
  2.63993789295778047421237033631769e-02,
  3.53093520084849172083196755522749e-04, // N = 121
  9.89571115950004659422845065819274e-04, 1.68881658669494403093858103659386e-03,
  2.36661114697426979563976701115280e-03, 3.02530527821434332483296891780356e-03,
  3.68912213435799605718012905697378e-03, 4.36146638924708208995273395203185e-03,
  5.02758855697252836358668304228559e-03, 5.68300310799131971895015169593535e-03,
  6.33636534216348076137270695085135e-03, 6.99076245664267004881198275256793e-03,
  7.63935787810085704940821216268887e-03, 8.27878115796717994889775127376197e-03,
  8.91334185215238335164844585278843e-03, 9.54507013554981020853063000686234e-03,
  1.01698598486048459588193537683765e-02, 1.07852228420445457601761773958060e-02,
  1.13936849294165726265148919083003e-02, 1.19965963864798828147906206709195e-02,
  1.25911404187634759499481162947632e-02, 1.31754066037134184158352567806105e-02,
  1.37510109230750358216832651692130e-02, 1.43188721544276597458233979409670e-02,
  1.48769056234409682848429667956225e-02, 1.54235980364135338155362475731636e-02,
  1.59600374493414562393489575242711e-02, 1.64868578020029125930090430074415e-02,
  1.70024452957587488000079645189544e-02, 1.75055780683059658553446524820174e-02,
  1.79970118283644883727667718176235e-02, 1.84771856788641802848971451567195e-02,
  1.89448180410103153570311462772224e-02, 1.93989142700467485924686883436152e-02,
  1.98400093852729338117502067007081e-02, 2.02684056500298838410234480988947e-02,
  2.06830736179305745003897953893102e-02, 2.10832054091250609140217875392409e-02,
  2.14691842165754959159684744918195e-02, 2.18412143691306404047480782537605e-02,
  2.21984694712669961003115304265521e-02, 2.25403022380505843602627180644049e-02,
  2.28669888878399764353677170447554e-02, 2.31786626241193595421297146685902e-02,
  2.34746687593110382741290464991835e-02, 2.37545034365186959190996418556097e-02,
  2.40183661731710323961053177299618e-02, 2.42663377114907714837688246234393e-02,
  2.44979145258998713685638648485110e-02, 2.47127249670960509597694709782445e-02,
  2.49109126326128756112598949812309e-02, 2.50925186266442515337082852511230e-02,
  2.52571769735132345413575194470468e-02, 2.54046411432650130757249229418449e-02,
  2.55350129860712551921331225912581e-02, 2.56483023113076545607125211745370e-02,
  2.57442717748336546979004424429149e-02, 2.58227959361498476953400427191809e-02,
  2.58839441460039648701396686192311e-02, 2.59276995637101499714294305931617e-02,
  2.59539479341057872929798833183668e-02, 2.59626833396368744688587071323127e-02,
  3.41719892175625409528466613906517e-04, // N = 123
  9.57626730429707436961783706408369e-04, 1.63437621843620000186558804955439e-03,
  2.29042751022067456526110085235359e-03, 2.92794402925707292553725302752810e-03,
  3.57045900608622679417436529547558e-03, 4.22143197723970613893795800208864e-03,
  4.86649212256053034092451170522509e-03, 5.50114666466848274001266716481950e-03,
  6.13391752819161719528784360022655e-03, 6.76799034872303459375864065350470e-03,
  7.39660819010769330500432161557001e-03, 8.01632254467577257117660849417007e-03,
  8.63148856579408138567366393090197e-03, 9.24429987508506439963795742187358e-03,
  9.85060548725638640554791436443338e-03, 1.04477786229770375908687540800202e-02,
  1.10384808647819611382434601409841e-02, 1.16242768474777678766596267223576e-02,
  1.22022304064804774231811634876976e-02, 1.27702428201099289772901812511918e-02,
  1.33301247978780106756557799485563e-02, 1.38830514927025371746394100114230e-02,
  1.44267637885174306033864155551782e-02, 1.49595162675938489482696525101346e-02,
  1.54826369491387720589425924799798e-02, 1.59970534152014641493533275706795e-02,
  1.65009311034759117986503440533852e-02, 1.69927748385710758460831470983976e-02,
  1.74736188761436261884796294907574e-02, 1.79442310499626847541954077769333e-02,
  1.84030666484911176183913994464092e-02, 1.88488171465532317050417532300344e-02,
  1.92823315728945857139287056725152e-02, 1.97042755610167021063094949795413e-02,
  2.01133155331176156910277796896480e-02, 2.05082883737674748214629971698741e-02,
  2.08899257342916866431181688312790e-02, 2.12588308265912254158003236170771e-02,
  2.16138318553032206248420976635316e-02, 2.19538830286163805238786039808474e-02,
  2.22796439427585084291916217580365e-02, 2.25916842253013720742682579611937e-02,
  2.28889610296301240777161467576661e-02, 2.31705257730093587553721334870716e-02,
  2.34369979580673973296178758118913e-02, 2.36889354512221893267476247046943e-02,
  2.39254012621366307644876769700204e-02, 2.41455287920958570901941442343741e-02,
  2.43499210573638602550516907285783e-02, 2.45391413584526985047773450787645e-02,
  2.47123413642655505306766627882098e-02, 2.48687241848650139597332042740163e-02,
  2.50088945299346658568406809308726e-02, 2.51334352407285716024532007395464e-02,
  2.52415730131379974221506046205832e-02, 2.53325700400168808690271049499643e-02,
  2.54070473028063167908463526600826e-02, 2.54656192691375404812959004630102e-02,
  2.55075760862055710143092568387146e-02, 2.55322291096868950188714109117427e-02,
  2.55402277932229235246630594247108e-02};

//=======================================================================
// function : KronrodPointsAndWeights
// purpose  : Returns Kronrod points and their weights
//=======================================================================

bool math::KronrodPointsAndWeights(const int Index, math_Vector& Points, math_Vector& Weights)
{
  if (Index < 3 ||                // Index is less then 3
      Index % 2 == 0 ||           // Index is even
      Points.Length() != Index || // Inconsistent length of Points
      Weights.Length() != Index)  // Inconsistent length of Weights
    return false;

  if (Index <= 123)
  {
    // Get points from the array.
    int i;
    int aStartInd = 0;

    // Compute the index of starting point in the array.
    for (i = 3; i < Index; i += 2)
      aStartInd += (i + 1) / 2;

    // Get points from the array.
    int aNbPts   = i / 2;
    int aLowerI  = Points.Lower();
    int anUpperI = Points.Upper();

    for (i = 0; i < aNbPts; i++)
    {
      Points.Value(aLowerI + i)   = -Point[aStartInd + i];
      Points.Value(anUpperI - i)  = Point[aStartInd + i];
      Weights.Value(aLowerI + i)  = Weight[aStartInd + i];
      Weights.Value(anUpperI - i) = Weight[aStartInd + i];
    }
    Points.Value(aLowerI + aNbPts)  = Point[aStartInd + aNbPts];
    Weights.Value(aLowerI + aNbPts) = Weight[aStartInd + aNbPts];

    return true;
  }
  else
  {
    math_ComputeKronrodPointsAndWeights PWcomputer((Index - 1) / 2);
    if (!PWcomputer.IsDone())
      return false;
    Points  = PWcomputer.Points();
    Weights = PWcomputer.Weights();
    return true;
  }
}
