// Created on: 1998-01-07
// Created by: Philippe MANGIN
// Copyright (c) 1998-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <BRep_Tool.hxx>
#include <BRepAdaptor_Curve.hxx>
#include <BRepFill_SectionLaw.hxx>
#include <BRepLProp.hxx>
#include <BRepTools_WireExplorer.hxx>
#include <GeomFill_SectionLaw.hxx>
#include <Standard_Type.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Shape.hxx>
#include <TopoDS_Wire.hxx>

IMPLEMENT_STANDARD_RTTIEXT(BRepFill_SectionLaw, Standard_Transient)

//=======================================================================
// function : NbLaw
// purpose  : Gives the number of elementary (or Geometric) law
//=======================================================================
int BRepFill_SectionLaw::NbLaw() const
{
  return myLaws->Length();
}

//=================================================================================================

const occ::handle<GeomFill_SectionLaw>& BRepFill_SectionLaw::Law(const int Index) const
{
  return myLaws->Value(Index);
}

//=================================================================================================

int BRepFill_SectionLaw::IndexOfEdge(const TopoDS_Shape& anEdge) const
{
  return myIndices(anEdge);
}

//=================================================================================================

bool BRepFill_SectionLaw::IsUClosed() const
{
  return uclosed;
}

//=================================================================================================

bool BRepFill_SectionLaw::IsVClosed() const
{
  return vclosed;
}

//=================================================================================================

bool BRepFill_SectionLaw::IsDone() const
{
  return myDone;
}

//=======================================================================
// function : Init
// purpose  : Prepare the parsing of a wire
//=======================================================================
void BRepFill_SectionLaw::Init(const TopoDS_Wire& W)
{
  myIterator.Init(W);
}

//=======================================================================
// function :
// purpose  : Parses the wire omitting the degenerated Edges
//=======================================================================
TopoDS_Edge BRepFill_SectionLaw::CurrentEdge()
{
  TopoDS_Edge E;
  // Class BRep_Tool without fields and without Constructor :
  //  BRep_Tool B;
  bool Suivant = false;
  if (myIterator.More())
  {
    E = myIterator.Current();
    //    Next = (B.Degenerated(E));
    Suivant = (BRep_Tool::Degenerated(E));
  }

  while (Suivant)
  {
    myIterator.Next();
    E = myIterator.Current();
    //    Next = (B.Degenerated(E) && myIterator.More());
    Suivant = (BRep_Tool::Degenerated(E) && myIterator.More());
  }

  if (myIterator.More())
    myIterator.Next();
  return E;
}
