// Created on: 1998-08-20
// Created by: Yves FRICAUD
// Copyright (c) 1998-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _TopOpeBRepDS_GapTool_HeaderFile
#define _TopOpeBRepDS_GapTool_HeaderFile

#include <Standard.hxx>
#include <Standard_Type.hxx>

#include <Standard_Integer.hxx>
#include <TopOpeBRepDS_Interference.hxx>
#include <NCollection_List.hxx>
#include <NCollection_DataMap.hxx>
#include <TopoDS_Shape.hxx>
#include <Standard_Transient.hxx>
class TopOpeBRepDS_HDataStructure;
class TopOpeBRepDS_Interference;
class TopOpeBRepDS_Curve;
class TopoDS_Shape;

class TopOpeBRepDS_GapTool : public Standard_Transient
{

public:
  Standard_EXPORT TopOpeBRepDS_GapTool();

  Standard_EXPORT TopOpeBRepDS_GapTool(const occ::handle<TopOpeBRepDS_HDataStructure>& HDS);

  Standard_EXPORT void Init(const occ::handle<TopOpeBRepDS_HDataStructure>& HDS);

  Standard_EXPORT const NCollection_List<occ::handle<TopOpeBRepDS_Interference>>& Interferences(
    const int IndexPoint) const;

  Standard_EXPORT const NCollection_List<occ::handle<TopOpeBRepDS_Interference>>& SameInterferences(
    const occ::handle<TopOpeBRepDS_Interference>& I) const;

  Standard_EXPORT NCollection_List<occ::handle<TopOpeBRepDS_Interference>>& ChangeSameInterferences(
    const occ::handle<TopOpeBRepDS_Interference>& I);

  Standard_EXPORT bool Curve(const occ::handle<TopOpeBRepDS_Interference>& I,
                             TopOpeBRepDS_Curve&                           C) const;

  Standard_EXPORT bool EdgeSupport(const occ::handle<TopOpeBRepDS_Interference>& I,
                                   TopoDS_Shape&                                 E) const;

  //! Return les faces qui ont genere la section origine
  //! de I
  Standard_EXPORT bool FacesSupport(const occ::handle<TopOpeBRepDS_Interference>& I,
                                    TopoDS_Shape&                                 F1,
                                    TopoDS_Shape&                                 F2) const;

  Standard_EXPORT bool ParameterOnEdge(const occ::handle<TopOpeBRepDS_Interference>& I,
                                       const TopoDS_Shape&                           E,
                                       double&                                       U) const;

  Standard_EXPORT void SetPoint(const occ::handle<TopOpeBRepDS_Interference>& I,
                                const int                                     IndexPoint);

  Standard_EXPORT void SetParameterOnEdge(const occ::handle<TopOpeBRepDS_Interference>& I,
                                          const TopoDS_Shape&                           E,
                                          const double                                  U);

  DEFINE_STANDARD_RTTIEXT(TopOpeBRepDS_GapTool, Standard_Transient)

private:
  occ::handle<TopOpeBRepDS_HDataStructure>                                           myHDS;
  NCollection_DataMap<int, NCollection_List<occ::handle<TopOpeBRepDS_Interference>>> myGToI;
  NCollection_DataMap<occ::handle<TopOpeBRepDS_Interference>, TopoDS_Shape>          myInterToShape;
};

#endif // _TopOpeBRepDS_GapTool_HeaderFile
