// Created on: 1994-02-14
// Created by: Jacques GOUSSARD
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _IntPatch_CSFunction_HeaderFile
#define _IntPatch_CSFunction_HeaderFile

#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <math_FunctionSetWithDerivatives.hxx>
#include <math_Vector.hxx>

class math_Matrix;

//! this function is associated to the intersection between
//! a curve on surface and a surface.
class IntPatch_CSFunction : public math_FunctionSetWithDerivatives
{
public:
  DEFINE_STANDARD_ALLOC

  //! S1 is the surface on which the intersection is searched.
  //! C is a curve on the surface S2.
  Standard_EXPORT IntPatch_CSFunction(const occ::handle<Adaptor3d_Surface>& S1,
                                      const occ::handle<Adaptor2d_Curve2d>& C,
                                      const occ::handle<Adaptor3d_Surface>& S2);

  Standard_EXPORT int NbVariables() const override;

  Standard_EXPORT int NbEquations() const override;

  Standard_EXPORT bool Value(const math_Vector& X, math_Vector& F) override;

  Standard_EXPORT bool Derivatives(const math_Vector& X, math_Matrix& D) override;

  Standard_EXPORT bool Values(const math_Vector& X, math_Vector& F, math_Matrix& D) override;

  Standard_EXPORT const gp_Pnt& Point() const;

  Standard_EXPORT double Root() const;

  Standard_EXPORT const occ::handle<Adaptor3d_Surface>& AuxillarSurface() const;

  Standard_EXPORT const occ::handle<Adaptor2d_Curve2d>& AuxillarCurve() const;

private:
  void*  curve;
  void*  surface1;
  void*  surface2;
  gp_Pnt p;
  double f;
};

#endif // _IntPatch_CSFunction_HeaderFile
