// Created on: 1998-05-18
// Created by: Andre LIEUTIER
// Copyright (c) 1998-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Plate_SampledCurveConstraint.hxx>
#include <Plate_PinpointConstraint.hxx>
#include <NCollection_Sequence.hxx>
#include <Standard_DimensionMismatch.hxx>

static inline double B0(double t)
{
  double s = t;
  if (s < 0.)
    s = -s;
  s = 1. - s;
  if (s < 0.)
    s = 0;
  return s;
}

Plate_SampledCurveConstraint::Plate_SampledCurveConstraint(
  const NCollection_Sequence<Plate_PinpointConstraint>& SOPPC,
  const int                                             n)
    : myLXYZC(n, SOPPC.Length())
{
  int m = SOPPC.Length();

  if (n > m)
    throw Standard_DimensionMismatch();
  for (int index = 1; index <= m; index++)
    myLXYZC.SetPPC(index, SOPPC(index));

  double ratio = double(n + 1) / double(m + 1);
  for (int i = 1; i <= n; i++)
    for (int j = 1; j <= m; j++)
    {
      myLXYZC.SetCoeff(i, j, B0(ratio * j - i));
    }
}
