// Created on: 1993-02-05
// Created by: Jacques GOUSSARD
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Contap_ThePathPointOfTheSearch.hxx>

#include <Adaptor3d_HVertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Standard_DomainError.hxx>
#include <gp_Pnt.hxx>

Contap_ThePathPointOfTheSearch::Contap_ThePathPointOfTheSearch()
    : tol(0.0),
      isnew(true),
      param(0.0)
{
}

Contap_ThePathPointOfTheSearch::Contap_ThePathPointOfTheSearch(
  const gp_Pnt&                         P,
  const double                          Tol,
  const occ::handle<Adaptor3d_HVertex>& V,
  const occ::handle<Adaptor2d_Curve2d>& A,
  const double                          Parameter)
    : point(P),
      tol(Tol),
      isnew(false),
      vtx(V),
      arc(A),
      param(Parameter)
{
}

Contap_ThePathPointOfTheSearch::Contap_ThePathPointOfTheSearch(
  const gp_Pnt&                         P,
  const double                          Tol,
  const occ::handle<Adaptor2d_Curve2d>& A,
  const double                          Parameter)
    : point(P),
      tol(Tol),
      isnew(true),
      arc(A),
      param(Parameter)
{
}
