// Created on: 2016-07-07
// Copyright (c) 2016 OPEN CASCADE SAS
// Created by: Oleg AGASHIN
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _BRepMesh_TorusRangeSplitter_HeaderFile
#define _BRepMesh_TorusRangeSplitter_HeaderFile

#include <BRepMesh_UVParamRangeSplitter.hxx>
#include <IMeshTools_Parameters.hxx>

//! Auxiliary class extending UV range splitter in order to generate
//! internal nodes for NURBS surface.
class BRepMesh_TorusRangeSplitter : public BRepMesh_UVParamRangeSplitter
{
public:
  //! Constructor.
  BRepMesh_TorusRangeSplitter() = default;

  //! Destructor.
  ~BRepMesh_TorusRangeSplitter() override = default;

  //! Returns list of nodes generated using surface data and specified parameters.
  Standard_EXPORT Handle(IMeshData::ListOfPnt2d) GenerateSurfaceNodes(
    const IMeshTools_Parameters& theParameters) const override;

  //! Registers border point.
  Standard_EXPORT void AddPoint(const gp_Pnt2d& thePoint) override;

private:
  Handle(IMeshData::SequenceOfReal) fillParams(
    const IMeshData::IMapOfReal&                 theParams,
    const std::pair<double, double>&             theRange,
    const int                                    theStepsNb,
    const double                                 theScale,
    const occ::handle<NCollection_IncAllocator>& theAllocator) const;

  double FUN_CalcAverageDUV(NCollection_Array1<double>& P, const int PLen) const;
};

#endif
