// Created on: 2000-01-31
// Created by: data exchange team
// Copyright (c) 2000-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Message_Msg.hxx>
#include <ShapeExtend_MsgRegistrator.hxx>
#include <Standard_Transient.hxx>
#include <Standard_Type.hxx>
#include <TopoDS_Shape.hxx>

IMPLEMENT_STANDARD_RTTIEXT(ShapeExtend_MsgRegistrator, ShapeExtend_BasicMsgRegistrator)

//=================================================================================================

ShapeExtend_MsgRegistrator::ShapeExtend_MsgRegistrator()

  = default;

//=================================================================================================

void ShapeExtend_MsgRegistrator::Send(const occ::handle<Standard_Transient>& object,
                                      const Message_Msg&                     message,
                                      const Message_Gravity)
{
  if (object.IsNull())
  {
#ifdef OCCT_DEBUG
    std::cout << "Warning: ShapeExtend_MsgRegistrator::Send: null object" << std::endl;
#endif
    return;
  }
  if (myMapTransient.IsBound(object))
  {
    NCollection_List<Message_Msg>& list = myMapTransient.ChangeFind(object);
    list.Append(message);
  }
  else
  {
    NCollection_List<Message_Msg> list;
    list.Append(message);
    myMapTransient.Bind(object, list);
  }
}

//=================================================================================================

void ShapeExtend_MsgRegistrator::Send(const TopoDS_Shape& shape,
                                      const Message_Msg&  message,
                                      const Message_Gravity)
{
  if (shape.IsNull())
  {
#ifdef OCCT_DEBUG
    std::cout << "Warning: ShapeExtend_MsgRegistrator::Send: null shape" << std::endl;
#endif
    return;
  }
  if (myMapShape.IsBound(shape))
  {
    NCollection_List<Message_Msg>& list = myMapShape.ChangeFind(shape);
    list.Append(message);
  }
  else
  {
    NCollection_List<Message_Msg> list;
    list.Append(message);
    myMapShape.Bind(shape, list);
  }
}
