// Created on: 1995-03-14
// Created by: Modelistation
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef OCCT_DEBUG
  #define No_Standard_OutOfRange
  #define No_Standard_RangeError
#endif

#include <AppCont_ContMatrices.hxx>
#include <math_Matrix.hxx>
#include <Standard_DimensionError.hxx>

static const double IBP[] = {

  26.47058823529411764705882,

  233.1623931623931623931624,
  -202.3931623931623931623932,
  -202.3931623931623931623932,
  233.1623931623931623931624,

  1312.284733611978202211523,
  -2232.104121475054229934924,
  1043.382294587587958309084,
  -2232.104121475054229934924,
  4341.973969631236442516269,
  -2232.104121475054229934924,
  1043.382294587587958309084,
  -2232.104121475054229934924,
  1312.284733611978202211523,

  6024.115786259541984732824,
  -15570.41441221374045801527,
  14258.32158778625954198473,
  -4571.980213740458015267176,
  -15570.41441221374045801527,
  43677.45563358778625954198,
  -42397.68036641221374045802,
  14258.32158778625954198473,
  14258.32158778625954198473,
  -42397.68036641221374045802,
  43677.45563358778625954198,
  -15570.41441221374045801527,
  -4571.980213740458015267176,
  14258.32158778625954198473,
  -15570.41441221374045801527,
  6024.115786259541984732824,

  24957.54363355886804621476,
  -88026.1798029742692878662,
  121356.8758470624805719615,
  -76588.5723263387552691746,
  18641.58101673643813967271,
  -88026.1798029742692878662,
  327812.3938808723516133624,
  -469986.4003978862294062791,
  306109.5153761994544171007,
  -76588.5723263387552691746,
  121356.8758470624805719615,
  -469986.4003978862294062791,
  698278.023674230649673609,
  -469986.4003978862294062791,
  121356.8758470624805719615,
  -76588.5723263387552691746,
  306109.5153761994544171007,
  -469986.4003978862294062791,
  327812.3938808723516133624,
  -88026.1798029742692878662,
  18641.58101673643813967271,
  -76588.5723263387552691746,
  121356.8758470624805719615,
  -88026.1798029742692878662,
  24957.54363355886804621476,

  98367.7712230203578689444,
  -444285.7555701185132903563,
  825576.58725641417957011,
  -782089.257683857375182854,
  376546.0628493633112795309,
  -73736.5713258466528375967,
  -444285.7555701185132903563,
  2.08256633912937135942837e6,
  -3.977051519418284632555968e6,
  3.851780531114775685240162e6,
  -1.890053000102507989867809e6,
  376546.0628493633112795309,
  825576.58725641417957011,
  -3.977051519418284632555968e6,
  7.778075206692342537890243e6,
  -7.695917087499528953394164e6,
  3.851780531114775685240162e6,
  -782089.257683857375182854,
  -782089.257683857375182854,
  3.851780531114775685240162e6,
  -7.695917087499528953394164e6,
  7.778075206692342537890243e6,
  -3.977051519418284632555968e6,
  825576.58725641417957011,
  376546.0628493633112795309,
  -1.890053000102507989867809e6,
  3.851780531114775685240162e6,
  -3.977051519418284632555968e6,
  2.08256633912937135942837e6,
  -444285.7555701185132903563,
  -73736.5713258466528375967,
  376546.0628493633112795309,
  -782089.257683857375182854,
  825576.58725641417957011,
  -444285.7555701185132903563,
  98367.7712230203578689444,

  379424.3576663019898221824,
  -2.100567756809113573889156e6,
  4.937601766796749036011036e6,
  -6.271766132734029342492488e6,
  4.529063696431671303622051e6,
  -1.761378397072727762621633e6,
  288349.6337797560116283951,
  -2.100567756809113573889156e6,
  1.193103871938176972715142e7,
  -2.859495611028310089134257e7,
  3.690514312323372413797674e7,
  -2.701917026792813277778569e7,
  1.063771445230158340452527e7,
  -1.761378397072727762621633e6,
  4.937601766796749036011036e6,
  -2.859495611028310089134257e7,
  6.9690376965723542957392e7,
  -9.12956887128514574150779e7,
  6.77573630608649012904804e7,
  -2.701917026792813277778569e7,
  4.529063696431671303622051e6,
  -6.271766132734029342492488e6,
  3.690514312323372413797674e7,
  -9.12956887128514574150779e7,
  1.213190697836762751042589e8,
  -9.12956887128514574150779e7,
  3.690514312323372413797674e7,
  -6.271766132734029342492488e6,
  4.529063696431671303622051e6,
  -2.701917026792813277778569e7,
  6.77573630608649012904804e7,
  -9.12956887128514574150779e7,
  6.9690376965723542957392e7,
  -2.859495611028310089134257e7,
  4.937601766796749036011036e6,
  -1.761378397072727762621633e6,
  1.063771445230158340452527e7,
  -2.701917026792813277778569e7,
  3.690514312323372413797674e7,
  -2.859495611028310089134257e7,
  1.193103871938176972715142e7,
  -2.100567756809113573889156e6,
  288349.6337797560116283951,
  -1.761378397072727762621633e6,
  4.529063696431671303622051e6,
  -6.271766132734029342492488e6,
  4.937601766796749036011036e6,
  -2.100567756809113573889156e6,
  379424.3576663019898221824,

  1.452974869223263193466215e6,
  -9.54668825061006490415138e6,
  2.721973837703798749033461e7,
  -4.350374868055059599038883e7,
  4.202141422750570829233055e7,
  -2.451017043298497347602259e7,
  7.991047598446538869433524e6,
  -1.123773209043682998008278e6,
  -9.54668825061006490415138e6,
  6.385435421979097774529554e7,
  -1.846249832438100242983772e8,
  2.985493944077993876619928e8,
  -2.913314043942371502236017e8,
  1.714855402038289893783723e8,
  -5.637913391787499010935156e7,
  7.991047598446538869433524e6,
  2.721973837703798749033461e7,
  -1.846249832438100242983772e8,
  5.40319358928775065292078e8,
  -8.832368049486145317516e8,
  8.70442689275133667737839e8,
  -5.170925151674042869519639e8,
  1.714855402038289893783723e8,
  -2.451017043298497347602259e7,
  -4.350374868055059599038883e7,
  2.985493944077993876619928e8,
  -8.832368049486145317516e8,
  1.458599704412164109287365e9,
  -1.451542518419474486052937e9,
  8.70442689275133667737839e8,
  -2.913314043942371502236017e8,
  4.202141422750570829233055e7,
  4.202141422750570829233055e7,
  -2.913314043942371502236017e8,
  8.70442689275133667737839e8,
  -1.451542518419474486052937e9,
  1.458599704412164109287365e9,
  -8.832368049486145317516e8,
  2.985493944077993876619928e8,
  -4.350374868055059599038883e7,
  -2.451017043298497347602259e7,
  1.714855402038289893783723e8,
  -5.170925151674042869519639e8,
  8.70442689275133667737839e8,
  -8.832368049486145317516e8,
  5.40319358928775065292078e8,
  -1.846249832438100242983772e8,
  2.721973837703798749033461e7,
  7.991047598446538869433524e6,
  -5.637913391787499010935156e7,
  1.714855402038289893783723e8,
  -2.913314043942371502236017e8,
  2.985493944077993876619928e8,
  -1.846249832438100242983772e8,
  6.385435421979097774529554e7,
  -9.54668825061006490415138e6,
  -1.123773209043682998008278e6,
  7.991047598446538869433524e6,
  -2.451017043298497347602259e7,
  4.202141422750570829233055e7,
  -4.350374868055059599038883e7,
  2.721973837703798749033461e7,
  -9.54668825061006490415138e6,
  1.452974869223263193466215e6,

  5.560607611745377639735581e6,
  -4.23093458473816722615521e7,
  1.420058346993117419568523e8,
  -2.740364253417776520855963e8,
  3.321910573326025071057344e8,
  -2.588659254160959305579957e8,
  1.265970421609363060463309e8,
  -3.551991579381018293604389e7,
  4.378399734021468479235454e6,
  -4.23093458473816722615521e7,
  3.259898087597103635930482e8,
  -1.105355118891772081560826e9,
  2.151758326728129935856799e9,
  -2.628567328045235162067118e9,
  2.062650328481124369433013e9,
  -1.015188425693322741687653e9,
  2.865363610140186243927609e8,
  -3.551991579381018293604389e7,
  1.420058346993117419568523e8,
  -1.105355118891772081560826e9,
  3.781688652780383989844049e9,
  -7.421273723227459465714927e9,
  9.13302514321401573694069e9,
  -7.216166675820305637735378e9,
  3.574681860686398865142925e9,
  -1.015188425693322741687653e9,
  1.265970421609363060463309e8,
  -2.740364253417776520855963e8,
  2.151758326728129935856799e9,
  -7.421273723227459465714927e9,
  1.467433091244596150799624e10,
  -1.81892167000015149367315e10,
  1.447079469487827844447852e10,
  -7.216166675820305637735378e9,
  2.062650328481124369433013e9,
  -2.588659254160959305579957e8,
  3.321910573326025071057344e8,
  -2.628567328045235162067118e9,
  9.13302514321401573694069e9,
  -1.81892167000015149367315e10,
  2.27051661410290031969744e10,
  -1.81892167000015149367315e10,
  9.13302514321401573694069e9,
  -2.628567328045235162067118e9,
  3.321910573326025071057344e8,
  -2.588659254160959305579957e8,
  2.062650328481124369433013e9,
  -7.216166675820305637735378e9,
  1.447079469487827844447852e10,
  -1.81892167000015149367315e10,
  1.467433091244596150799624e10,
  -7.421273723227459465714927e9,
  2.151758326728129935856799e9,
  -2.740364253417776520855963e8,
  1.265970421609363060463309e8,
  -1.015188425693322741687653e9,
  3.574681860686398865142925e9,
  -7.216166675820305637735378e9,
  9.13302514321401573694069e9,
  -7.421273723227459465714927e9,
  3.781688652780383989844049e9,
  -1.105355118891772081560826e9,
  1.420058346993117419568523e8,
  -3.551991579381018293604389e7,
  2.865363610140186243927609e8,
  -1.015188425693322741687653e9,
  2.062650328481124369433013e9,
  -2.628567328045235162067118e9,
  2.151758326728129935856799e9,
  -1.105355118891772081560826e9,
  3.259898087597103635930482e8,
  -4.23093458473816722615521e7,
  4.378399734021468479235454e6,
  -3.551991579381018293604389e7,
  1.265970421609363060463309e8,
  -2.588659254160959305579957e8,
  3.321910573326025071057344e8,
  -2.740364253417776520855963e8,
  1.420058346993117419568523e8,
  -4.23093458473816722615521e7,
  5.560607611745377639735581e6,

  2.132337226293670673258186e7,
  -1.843506390892821601442104e8,
  7.12255328219202770645525e8,
  -1.612129790715497173438289e9,
  2.354173925570040323803437e9,
  -2.299120412824705614668737e9,
  1.501255141412536010108203e9,
  -6.31914640886814889537362e8,
  1.555816035736471677004303e8,
  -1.707245312473887382236267e7,
  -1.843506390892821601442104e8,
  1.60820905428231791951475e9,
  -6.260594353912318324922438e9,
  1.426423885368552024639007e10,
  -2.095349579079813495265661e10,
  2.05740939972954242131459e10,
  -1.350128998372500673095336e10,
  5.709499320946611798992131e9,
  -1.411896919754674193108196e9,
  1.555816035736471677004303e8,
  7.12255328219202770645525e8,
  -6.260594353912318324922438e9,
  2.453652886836799352912602e10,
  -5.624807132201120451037885e10,
  8.30945898245248007260812e10,
  -8.20221151315526135829267e10,
  5.409376020276072355003867e10,
  -2.298392726108220566293283e10,
  5.709499320946611798992131e9,
  -6.31914640886814889537362e8,
  -1.612129790715497173438289e9,
  1.426423885368552024639007e10,
  -5.624807132201120451037885e10,
  1.296891965027134019398027e11,
  -1.926377914566337187310184e11,
  1.911464262762033697479643e11,
  -1.266956070888319331951626e11,
  5.409376020276072355003867e10,
  -1.350128998372500673095336e10,
  1.501255141412536010108203e9,
  2.354173925570040323803437e9,
  -2.095349579079813495265661e10,
  8.30945898245248007260812e10,
  -1.926377914566337187310184e11,
  2.876634357717733159931421e11,
  -2.869201908866922662028238e11,
  1.911464262762033697479643e11,
  -8.20221151315526135829267e10,
  2.05740939972954242131459e10,
  -2.299120412824705614668737e9,
  -2.299120412824705614668737e9,
  2.05740939972954242131459e10,
  -8.20221151315526135829267e10,
  1.911464262762033697479643e11,
  -2.869201908866922662028238e11,
  2.876634357717733159931421e11,
  -1.926377914566337187310184e11,
  8.30945898245248007260812e10,
  -2.095349579079813495265661e10,
  2.354173925570040323803437e9,
  1.501255141412536010108203e9,
  -1.350128998372500673095336e10,
  5.409376020276072355003867e10,
  -1.266956070888319331951626e11,
  1.911464262762033697479643e11,
  -1.926377914566337187310184e11,
  1.296891965027134019398027e11,
  -5.624807132201120451037885e10,
  1.426423885368552024639007e10,
  -1.612129790715497173438289e9,
  -6.31914640886814889537362e8,
  5.709499320946611798992131e9,
  -2.298392726108220566293283e10,
  5.409376020276072355003867e10,
  -8.20221151315526135829267e10,
  8.30945898245248007260812e10,
  -5.624807132201120451037885e10,
  2.453652886836799352912602e10,
  -6.260594353912318324922438e9,
  7.12255328219202770645525e8,
  1.555816035736471677004303e8,
  -1.411896919754674193108196e9,
  5.709499320946611798992131e9,
  -1.350128998372500673095336e10,
  2.05740939972954242131459e10,
  -2.095349579079813495265661e10,
  1.426423885368552024639007e10,
  -6.260594353912318324922438e9,
  1.60820905428231791951475e9,
  -1.843506390892821601442104e8,
  -1.707245312473887382236267e7,
  1.555816035736471677004303e8,
  -6.31914640886814889537362e8,
  1.501255141412536010108203e9,
  -2.299120412824705614668737e9,
  2.354173925570040323803437e9,
  -1.612129790715497173438289e9,
  7.12255328219202770645525e8,
  -1.843506390892821601442104e8,
  2.132337226293670673258186e7,

  8.19964632966083083429933e7,
  -7.9358376390451356858392e8,
  3.46911685303336409003036e9,
  -9.01386256873687634454116e9,
  1.54098064192429540806439e10,
  -1.810629356107438220182302e10,
  1.480537903017488385436778e10,
  -8.317984805805170672409134e9,
  3.072699424147019492512373e9,
  -6.7391298116386623749832e8,
  6.664168591232068796809859e7,
  -7.9358376390451356858392e8,
  7.731293550647291600687029e9,
  -3.399017208527457913317929e10,
  8.87668634690802562928606e10,
  -1.524542355314731239818956e11,
  1.798930355235131880847798e11,
  -1.476785904225120914863749e11,
  8.32766240505698982207978e10,
  -3.087052830893256875485858e10,
  6.79319553309934277764306e9,
  -6.7391298116386623749832e8,
  3.46911685303336409003036e9,
  -3.399017208527457913317929e10,
  1.502082309139123485048441e11,
  -3.94139969445003840891484e11,
  6.79915011221928517813355e11,
  -8.0561438426569486136167e11,
  6.63941870776684301662998e11,
  -3.757967684973583972581609e11,
  1.39804930678062293684427e11,
  -3.087052830893256875485858e10,
  3.072699424147019492512373e9,
  -9.01386256873687634454116e9,
  8.87668634690802562928606e10,
  -3.94139969445003840891484e11,
  1.038842622279097450660266e12,
  -1.799698891846855896866532e12,
  2.141100274605904272270379e12,
  -1.771476524865847934563005e12,
  1.006457534360828570304177e12,
  -3.757967684973583972581609e11,
  8.32766240505698982207978e10,
  -8.317984805805170672409134e9,
  1.54098064192429540806439e10,
  -1.524542355314731239818956e11,
  6.79915011221928517813355e11,
  -1.799698891846855896866532e12,
  3.130675270566978980018127e12,
  -3.739508295621324299692986e12,
  3.106069333902535138557296e12,
  -1.771476524865847934563005e12,
  6.63941870776684301662998e11,
  -1.476785904225120914863749e11,
  1.480537903017488385436778e10,
  -1.810629356107438220182302e10,
  1.798930355235131880847798e11,
  -8.0561438426569486136167e11,
  2.141100274605904272270379e12,
  -3.739508295621324299692986e12,
  4.484471171114994281550674e12,
  -3.739508295621324299692986e12,
  2.141100274605904272270379e12,
  -8.0561438426569486136167e11,
  1.798930355235131880847798e11,
  -1.810629356107438220182302e10,
  1.480537903017488385436778e10,
  -1.476785904225120914863749e11,
  6.63941870776684301662998e11,
  -1.771476524865847934563005e12,
  3.106069333902535138557296e12,
  -3.739508295621324299692986e12,
  3.130675270566978980018127e12,
  -1.799698891846855896866532e12,
  6.79915011221928517813355e11,
  -1.524542355314731239818956e11,
  1.54098064192429540806439e10,
  -8.317984805805170672409134e9,
  8.32766240505698982207978e10,
  -3.757967684973583972581609e11,
  1.006457534360828570304177e12,
  -1.771476524865847934563005e12,
  2.141100274605904272270379e12,
  -1.799698891846855896866532e12,
  1.038842622279097450660266e12,
  -3.94139969445003840891484e11,
  8.87668634690802562928606e10,
  -9.01386256873687634454116e9,
  3.072699424147019492512373e9,
  -3.087052830893256875485858e10,
  1.39804930678062293684427e11,
  -3.757967684973583972581609e11,
  6.63941870776684301662998e11,
  -8.0561438426569486136167e11,
  6.79915011221928517813355e11,
  -3.94139969445003840891484e11,
  1.502082309139123485048441e11,
  -3.399017208527457913317929e10,
  3.46911685303336409003036e9,
  -6.7391298116386623749832e8,
  6.79319553309934277764306e9,
  -3.087052830893256875485858e10,
  8.32766240505698982207978e10,
  -1.476785904225120914863749e11,
  1.798930355235131880847798e11,
  -1.524542355314731239818956e11,
  8.87668634690802562928606e10,
  -3.399017208527457913317929e10,
  7.731293550647291600687029e9,
  -7.9358376390451356858392e8,
  6.664168591232068796809859e7,
  -6.7391298116386623749832e8,
  3.072699424147019492512373e9,
  -8.317984805805170672409134e9,
  1.480537903017488385436778e10,
  -1.810629356107438220182302e10,
  1.54098064192429540806439e10,
  -9.01386256873687634454116e9,
  3.46911685303336409003036e9,
  -7.9358376390451356858392e8,
  8.19964632966083083429933e7,

  3.161901623732055345797152e8,
  -3.385348746404123112103241e9,
  1.651788682775172914135411e10,
  -4.846146026241161478518879e10,
  9.49667431710831468698334e10,
  -1.304933764703680299957291e11,
  1.282812976270097262686527e11,
  -9.02100005419839564264508e10,
  4.446928465953483302173958e10,
  -1.463435547143036762318166e10,
  2.893560323040305382312512e9,
  -2.604189318477385456956824e8,
  -3.385348746404123112103241e9,
  3.642511412744488093342736e10,
  -1.785056151950470393191079e11,
  5.257940019738653815515697e11,
  -1.034125310157774548478225e12,
  1.425803945854079241884896e12,
  -1.406083006877245961716972e12,
  9.9174482843450223196284e11,
  -4.902710539041155889509949e11,
  1.617795326065262438056683e11,
  -3.207065877654429069052444e10,
  2.893560323040305382312512e9,
  1.651788682775172914135411e10,
  -1.785056151950470393191079e11,
  8.78305535193261734130318e11,
  -2.596737467602900935951455e12,
  5.125102105965848538899639e12,
  -7.08958507719143172573878e12,
  7.013440217626095071562526e12,
  -4.96154588639707087015215e12,
  2.459782310666609869835804e12,
  -8.13919156842322298994068e11,
  1.617795326065262438056683e11,
  -1.463435547143036762318166e10,
  -4.846146026241161478518879e10,
  5.257940019738653815515697e11,
  -2.596737467602900935951455e12,
  7.704499537732265221220792e12,
  -1.525742425979533296761269e13,
  2.117387219369744488234593e13,
  -2.101154699645887748325695e13,
  1.490888195041554774564785e13,
  -7.412858094412151418435217e12,
  2.459782310666609869835804e12,
  -4.902710539041155889509949e11,
  4.446928465953483302173958e10,
  9.49667431710831468698334e10,
  -1.034125310157774548478225e12,
  5.125102105965848538899639e12,
  -1.525742425979533296761269e13,
  3.031332475746504415042085e13,
  -4.220148054093181486616748e13,
  4.200734490323440302888757e13,
  -2.989657923294870201506152e13,
  1.490888195041554774564785e13,
  -4.96154588639707087015215e12,
  9.9174482843450223196284e11,
  -9.02100005419839564264508e10,
  -1.304933764703680299957291e11,
  1.425803945854079241884896e12,
  -7.08958507719143172573878e12,
  2.117387219369744488234593e13,
  -4.220148054093181486616748e13,
  5.89352684471360411306144e13,
  -5.884482203269112642997519e13,
  4.200734490323440302888757e13,
  -2.101154699645887748325695e13,
  7.013440217626095071562526e12,
  -1.406083006877245961716972e12,
  1.282812976270097262686527e11,
  1.282812976270097262686527e11,
  -1.406083006877245961716972e12,
  7.013440217626095071562526e12,
  -2.101154699645887748325695e13,
  4.200734490323440302888757e13,
  -5.884482203269112642997519e13,
  5.89352684471360411306144e13,
  -4.220148054093181486616748e13,
  2.117387219369744488234593e13,
  -7.08958507719143172573878e12,
  1.425803945854079241884896e12,
  -1.304933764703680299957291e11,
  -9.02100005419839564264508e10,
  9.9174482843450223196284e11,
  -4.96154588639707087015215e12,
  1.490888195041554774564785e13,
  -2.989657923294870201506152e13,
  4.200734490323440302888757e13,
  -4.220148054093181486616748e13,
  3.031332475746504415042085e13,
  -1.525742425979533296761269e13,
  5.125102105965848538899639e12,
  -1.034125310157774548478225e12,
  9.49667431710831468698334e10,
  4.446928465953483302173958e10,
  -4.902710539041155889509949e11,
  2.459782310666609869835804e12,
  -7.412858094412151418435217e12,
  1.490888195041554774564785e13,
  -2.101154699645887748325695e13,
  2.117387219369744488234593e13,
  -1.525742425979533296761269e13,
  7.704499537732265221220792e12,
  -2.596737467602900935951455e12,
  5.257940019738653815515697e11,
  -4.846146026241161478518879e10,
  -1.463435547143036762318166e10,
  1.617795326065262438056683e11,
  -8.13919156842322298994068e11,
  2.459782310666609869835804e12,
  -4.96154588639707087015215e12,
  7.013440217626095071562526e12,
  -7.08958507719143172573878e12,
  5.125102105965848538899639e12,
  -2.596737467602900935951455e12,
  8.78305535193261734130318e11,
  -1.785056151950470393191079e11,
  1.651788682775172914135411e10,
  2.893560323040305382312512e9,
  -3.207065877654429069052444e10,
  1.617795326065262438056683e11,
  -4.902710539041155889509949e11,
  9.9174482843450223196284e11,
  -1.406083006877245961716972e12,
  1.425803945854079241884896e12,
  -1.034125310157774548478225e12,
  5.257940019738653815515697e11,
  -1.785056151950470393191079e11,
  3.642511412744488093342736e10,
  -3.385348746404123112103241e9,
  -2.604189318477385456956824e8,
  2.893560323040305382312512e9,
  -1.463435547143036762318166e10,
  4.446928465953483302173958e10,
  -9.02100005419839564264508e10,
  1.282812976270097262686527e11,
  -1.304933764703680299957291e11,
  9.49667431710831468698334e10,
  -4.846146026241161478518879e10,
  1.651788682775172914135411e10,
  -3.385348746404123112103241e9,
  3.161901623732055345797152e8,

  1.222398053129430736192152e9,
  -1.434002928657849914170628e10,
  7.72434596353202298405699e10,
  -2.525666213449228873380118e11,
  5.58222806380922424077109e11,
  -8.78490353224492029632626e11,
  1.009284274692670347093429e12,
  -8.52877031516987499418246e11,
  5.260821501374686315513124e11,
  -2.309987746248280049279264e11,
  6.853481922330590879642998e10,
  -1.233579626733071249820762e10,
  1.018701515431916638250304e9,
  -1.434002928657849914170628e10,
  1.688600159872869777262006e11,
  -9.1268783759065102781966e11,
  2.993646204749266056023757e12,
  -6.635892509044890009941689e12,
  1.047166300627526649655813e13,
  -1.206176958915648714013855e13,
  1.021749488810981598995064e13,
  -6.317154788633405621385867e12,
  2.779991957410293299841488e12,
  -8.26556596448448638346526e11,
  1.49081053668454878467139e11,
  -1.233579626733071249820762e10,
  7.72434596353202298405699e10,
  -9.1268783759065102781966e11,
  4.948746403742559330075579e12,
  -1.628037013480389683418476e13,
  3.618939112570769540522645e13,
  -5.726028907813803232758304e13,
  6.612276685073062489844987e13,
  -5.614867774231460185297093e13,
  3.479609367360309943648447e13,
  -1.534723343427456964350214e13,
  4.573038572928762340491902e12,
  -8.26556596448448638346526e11,
  6.853481922330590879642998e10,
  -2.525666213449228873380118e11,
  2.993646204749266056023757e12,
  -1.628037013480389683418476e13,
  5.371091422270480003233196e13,
  -1.19716930126593032527684e14,
  1.899141935494942399681648e14,
  -2.198586822140753815644986e14,
  1.871477883686187713664772e14,
  -1.162508654916510061426364e14,
  5.139111226980196807476885e13,
  -1.534723343427456964350214e13,
  2.779991957410293299841488e12,
  -2.309987746248280049279264e11,
  5.58222806380922424077109e11,
  -6.635892509044890009941689e12,
  3.618939112570769540522645e13,
  -1.19716930126593032527684e14,
  2.675394442583161508148917e14,
  -4.254968953078648981259926e14,
  4.938106721915482907425201e14,
  -4.213604783431562103009296e14,
  2.623583108110001887419365e14,
  -1.162508654916510061426364e14,
  3.479609367360309943648447e13,
  -6.317154788633405621385867e12,
  5.260821501374686315513124e11,
  -8.78490353224492029632626e11,
  1.047166300627526649655813e13,
  -5.726028907813803232758304e13,
  1.899141935494942399681648e14,
  -4.254968953078648981259926e14,
  6.78409124443077844741412e14,
  -7.89268779322459049729387e14,
  6.75106222249126118590991e14,
  -4.213604783431562103009296e14,
  1.871477883686187713664772e14,
  -5.614867774231460185297093e13,
  1.021749488810981598995064e13,
  -8.52877031516987499418246e11,
  1.009284274692670347093429e12,
  -1.206176958915648714013855e13,
  6.612276685073062489844987e13,
  -2.198586822140753815644986e14,
  4.938106721915482907425201e14,
  -7.89268779322459049729387e14,
  9.20493016388140207933177e14,
  -7.89268779322459049729387e14,
  4.938106721915482907425201e14,
  -2.198586822140753815644986e14,
  6.612276685073062489844987e13,
  -1.206176958915648714013855e13,
  1.009284274692670347093429e12,
  -8.52877031516987499418246e11,
  1.021749488810981598995064e13,
  -5.614867774231460185297093e13,
  1.871477883686187713664772e14,
  -4.213604783431562103009296e14,
  6.75106222249126118590991e14,
  -7.89268779322459049729387e14,
  6.78409124443077844741412e14,
  -4.254968953078648981259926e14,
  1.899141935494942399681648e14,
  -5.726028907813803232758304e13,
  1.047166300627526649655813e13,
  -8.78490353224492029632626e11,
  5.260821501374686315513124e11,
  -6.317154788633405621385867e12,
  3.479609367360309943648447e13,
  -1.162508654916510061426364e14,
  2.623583108110001887419365e14,
  -4.213604783431562103009296e14,
  4.938106721915482907425201e14,
  -4.254968953078648981259926e14,
  2.675394442583161508148917e14,
  -1.19716930126593032527684e14,
  3.618939112570769540522645e13,
  -6.635892509044890009941689e12,
  5.58222806380922424077109e11,
  -2.309987746248280049279264e11,
  2.779991957410293299841488e12,
  -1.534723343427456964350214e13,
  5.139111226980196807476885e13,
  -1.162508654916510061426364e14,
  1.871477883686187713664772e14,
  -2.198586822140753815644986e14,
  1.899141935494942399681648e14,
  -1.19716930126593032527684e14,
  5.371091422270480003233196e13,
  -1.628037013480389683418476e13,
  2.993646204749266056023757e12,
  -2.525666213449228873380118e11,
  6.853481922330590879642998e10,
  -8.26556596448448638346526e11,
  4.573038572928762340491902e12,
  -1.534723343427456964350214e13,
  3.479609367360309943648447e13,
  -5.614867774231460185297093e13,
  6.612276685073062489844987e13,
  -5.726028907813803232758304e13,
  3.618939112570769540522645e13,
  -1.628037013480389683418476e13,
  4.948746403742559330075579e12,
  -9.1268783759065102781966e11,
  7.72434596353202298405699e10,
  -1.233579626733071249820762e10,
  1.49081053668454878467139e11,
  -8.26556596448448638346526e11,
  2.779991957410293299841488e12,
  -6.317154788633405621385867e12,
  1.021749488810981598995064e13,
  -1.206176958915648714013855e13,
  1.047166300627526649655813e13,
  -6.635892509044890009941689e12,
  2.993646204749266056023757e12,
  -9.1268783759065102781966e11,
  1.688600159872869777262006e11,
  -1.434002928657849914170628e10,
  1.018701515431916638250304e9,
  -1.233579626733071249820762e10,
  6.853481922330590879642998e10,
  -2.309987746248280049279264e11,
  5.260821501374686315513124e11,
  -8.52877031516987499418246e11,
  1.009284274692670347093429e12,
  -8.78490353224492029632626e11,
  5.58222806380922424077109e11,
  -2.525666213449228873380118e11,
  7.72434596353202298405699e10,
  -1.434002928657849914170628e10,
  1.222398053129430736192152e9,

  4.736545317349154897088679e9,
  -6.040035428443576768719941e10,
  3.559593710252867391134028e11,
  -1.283489121305511992699625e12,
  3.158758246394969233256754e12,
  -5.602750998585231463919524e12,
  7.368056501328986890692977e12,
  -7.273516777215203705225458e12,
  5.389626950885682885619529e12,
  -2.960653627028236526130433e12,
  1.171892789720987373957371e12,
  -3.165115291835695603044987e11,
  5.228072443887814985316051e10,
  -3.988717931640190903512695e9,
  -6.040035428443576768719941e10,
  7.72498051099684287256855e11,
  -4.564949731190185990266442e12,
  1.650149648701313669314623e13,
  -4.070754352563600043467225e13,
  7.23651147177788486595591e13,
  -9.5367482328557399940038e13,
  9.43338669862333818633328e13,
  -7.003568077331180596300123e13,
  3.854355373608335490836092e13,
  -1.528359009720225879562367e13,
  4.134981279189415097578603e12,
  -6.84145191048463247571072e11,
  5.228072443887814985316051e10,
  3.559593710252867391134028e11,
  -4.564949731190185990266442e12,
  2.704450770557062705657507e13,
  -9.7996267515306357193318e13,
  2.422989987484433413367473e14,
  -4.316688692035342548876889e14,
  5.70067527589236222259613e14,
  -5.65018266307540273364846e14,
  4.202921953828788810067869e14,
  -2.317354526605282125270513e14,
  9.20554450987001622149731e13,
  -2.494929815792049961272214e13,
  4.134981279189415097578603e12,
  -3.165115291835695603044987e11,
  -1.283489121305511992699625e12,
  1.650149648701313669314623e13,
  -9.7996267515306357193318e13,
  3.55908106636176028622247e14,
  -8.81938290356709483207031e14,
  1.574564314409621553961993e15,
  -2.083664155330198905479505e15,
  2.069319448208384158290753e15,
  -1.542249863478656544682862e15,
  8.5194492959093795872583e14,
  -3.390499774831293468711131e14,
  9.20554450987001622149731e13,
  -1.528359009720225879562367e13,
  1.171892789720987373957371e12,
  3.158758246394969233256754e12,
  -4.070754352563600043467225e13,
  2.422989987484433413367473e14,
  -8.81938290356709483207031e14,
  2.190120745127209106537522e15,
  -3.918267671135725784401427e15,
  5.195676564194944671215258e15,
  -5.170133143881929197465491e15,
  3.860733907975725079131881e15,
  -2.136734702177203215262816e15,
  8.5194492959093795872583e14,
  -2.317354526605282125270513e14,
  3.854355373608335490836092e13,
  -2.960653627028236526130433e12,
  -5.602750998585231463919524e12,
  7.23651147177788486595591e13,
  -4.316688692035342548876889e14,
  1.574564314409621553961993e15,
  -3.918267671135725784401427e15,
  7.02435948537403231806205e15,
  -9.33309802741367405095571e15,
  9.30556229751293307109751e15,
  -6.962344079574714886739283e15,
  3.860733907975725079131881e15,
  -1.542249863478656544682862e15,
  4.202921953828788810067869e14,
  -7.003568077331180596300123e13,
  5.389626950885682885619529e12,
  7.368056501328986890692977e12,
  -9.5367482328557399940038e13,
  5.70067527589236222259613e14,
  -2.083664155330198905479505e15,
  5.195676564194944671215258e15,
  -9.33309802741367405095571e15,
  1.242532338338453946561492e16,
  -1.241309655222913877428094e16,
  9.30556229751293307109751e15,
  -5.170133143881929197465491e15,
  2.069319448208384158290753e15,
  -5.65018266307540273364846e14,
  9.43338669862333818633328e13,
  -7.273516777215203705225458e12,
  -7.273516777215203705225458e12,
  9.43338669862333818633328e13,
  -5.65018266307540273364846e14,
  2.069319448208384158290753e15,
  -5.170133143881929197465491e15,
  9.30556229751293307109751e15,
  -1.241309655222913877428094e16,
  1.242532338338453946561492e16,
  -9.33309802741367405095571e15,
  5.195676564194944671215258e15,
  -2.083664155330198905479505e15,
  5.70067527589236222259613e14,
  -9.5367482328557399940038e13,
  7.368056501328986890692977e12,
  5.389626950885682885619529e12,
  -7.003568077331180596300123e13,
  4.202921953828788810067869e14,
  -1.542249863478656544682862e15,
  3.860733907975725079131881e15,
  -6.962344079574714886739283e15,
  9.30556229751293307109751e15,
  -9.33309802741367405095571e15,
  7.02435948537403231806205e15,
  -3.918267671135725784401427e15,
  1.574564314409621553961993e15,
  -4.316688692035342548876889e14,
  7.23651147177788486595591e13,
  -5.602750998585231463919524e12,
  -2.960653627028236526130433e12,
  3.854355373608335490836092e13,
  -2.317354526605282125270513e14,
  8.5194492959093795872583e14,
  -2.136734702177203215262816e15,
  3.860733907975725079131881e15,
  -5.170133143881929197465491e15,
  5.195676564194944671215258e15,
  -3.918267671135725784401427e15,
  2.190120745127209106537522e15,
  -8.81938290356709483207031e14,
  2.422989987484433413367473e14,
  -4.070754352563600043467225e13,
  3.158758246394969233256754e12,
  1.171892789720987373957371e12,
  -1.528359009720225879562367e13,
  9.20554450987001622149731e13,
  -3.390499774831293468711131e14,
  8.5194492959093795872583e14,
  -1.542249863478656544682862e15,
  2.069319448208384158290753e15,
  -2.083664155330198905479505e15,
  1.574564314409621553961993e15,
  -8.81938290356709483207031e14,
  3.55908106636176028622247e14,
  -9.7996267515306357193318e13,
  1.650149648701313669314623e13,
  -1.283489121305511992699625e12,
  -3.165115291835695603044987e11,
  4.134981279189415097578603e12,
  -2.494929815792049961272214e13,
  9.20554450987001622149731e13,
  -2.317354526605282125270513e14,
  4.202921953828788810067869e14,
  -5.65018266307540273364846e14,
  5.70067527589236222259613e14,
  -4.316688692035342548876889e14,
  2.422989987484433413367473e14,
  -9.7996267515306357193318e13,
  2.704450770557062705657507e13,
  -4.564949731190185990266442e12,
  3.559593710252867391134028e11,
  5.228072443887814985316051e10,
  -6.84145191048463247571072e11,
  4.134981279189415097578603e12,
  -1.528359009720225879562367e13,
  3.854355373608335490836092e13,
  -7.003568077331180596300123e13,
  9.43338669862333818633328e13,
  -9.5367482328557399940038e13,
  7.23651147177788486595591e13,
  -4.070754352563600043467225e13,
  1.650149648701313669314623e13,
  -4.564949731190185990266442e12,
  7.72498051099684287256855e11,
  -6.040035428443576768719941e10,
  -3.988717931640190903512695e9,
  5.228072443887814985316051e10,
  -3.165115291835695603044987e11,
  1.171892789720987373957371e12,
  -2.960653627028236526130433e12,
  5.389626950885682885619529e12,
  -7.273516777215203705225458e12,
  7.368056501328986890692977e12,
  -5.602750998585231463919524e12,
  3.158758246394969233256754e12,
  -1.283489121305511992699625e12,
  3.559593710252867391134028e11,
  -6.040035428443576768719941e10,
  4.736545317349154897088679e9,

  1.838979025781051242631162e10,
  -2.532280881290688216117093e11,
  1.620537266950072005952704e12,
  -6.387622388652466108230474e12,
  1.732399295423952994451031e13,
  -3.419682568714119915451959e13,
  5.066373290913283471024771e13,
  -5.722764271304914811692417e13,
  4.952385711440852807835038e13,
  -3.267362585849252767963935e13,
  1.617733609843002138186656e13,
  -5.828724631152663269066797e12,
  1.444668843740967333034896e12,
  -2.204769898848496811465842e11,
  1.563138425325755011430057e10,
  -2.532280881290688216117093e11,
  3.495142444273788422333412e12,
  -2.241613332013562601890868e13,
  8.85385105537660134739587e13,
  -2.405932435764394609027763e14,
  4.757966280256079659284011e14,
  -7.06148067541214473445017e14,
  7.98977626101326163254407e14,
  -6.92538790790587478005852e14,
  4.576164220152073779181684e14,
  -2.269145152729097308077059e14,
  8.18763529793858177365311e13,
  -2.032187074261369856990959e13,
  3.105644167982801880209335e12,
  -2.204769898848496811465842e11,
  1.620537266950072005952704e12,
  -2.241613332013562601890868e13,
  1.44063448194494421722997e14,
  -5.7013602879146366051515e14,
  1.552188096116453272318827e15,
  -3.075125822328563426959043e15,
  4.571803759659676811931538e15,
  -5.181428267870918351636783e15,
  4.498394289678466582654513e15,
  -2.977085972682620749452534e15,
  1.478455661100059416555887e15,
  -5.342475288280451796263538e14,
  1.327911638664760334265054e14,
  -2.032187074261369856990959e13,
  1.444668843740967333034896e12,
  -6.387622388652466108230474e12,
  8.85385105537660134739587e13,
  -5.7013602879146366051515e14,
  2.260595373562425035180787e15,
  -6.165645557200476206208111e15,
  1.223658435664580017835203e16,
  -1.822316747448798921065861e16,
  2.06872543196004305963226e16,
  -1.798904274685872485913352e16,
  1.19239720301954951749763e16,
  -5.930623955398980407476257e15,
  2.146258694523177972397832e15,
  -5.342475288280451796263538e14,
  8.18763529793858177365311e13,
  -5.828724631152663269066797e12,
  1.732399295423952994451031e13,
  -2.405932435764394609027763e14,
  1.552188096116453272318827e15,
  -6.165645557200476206208111e15,
  1.684619431201987800262822e16,
  -3.349120279212584933286535e16,
  4.996009470398597767224583e16,
  -5.680862221998630024599228e16,
  4.947844955753753135953656e16,
  -3.284819661450471133782823e16,
  1.636291523951385162466402e16,
  -5.930623955398980407476257e15,
  1.478455661100059416555887e15,
  -2.269145152729097308077059e14,
  1.617733609843002138186656e13,
  -3.419682568714119915451959e13,
  4.757966280256079659284011e14,
  -3.075125822328563426959043e15,
  1.223658435664580017835203e16,
  -3.349120279212584933286535e16,
  6.669489229092280662271897e16,
  -9.96563193228878364811986e16,
  1.135020255987438347474939e17,
  -9.9015288332320259874277e16,
  6.583920197953646954112155e16,
  -3.284819661450471133782823e16,
  1.19239720301954951749763e16,
  -2.977085972682620749452534e15,
  4.576164220152073779181684e14,
  -3.267362585849252767963935e13,
  5.066373290913283471024771e13,
  -7.06148067541214473445017e14,
  4.571803759659676811931538e15,
  -1.822316747448798921065861e16,
  4.996009470398597767224583e16,
  -9.96563193228878364811986e16,
  1.491518672738987185566811e17,
  -1.701499050739932725611571e17,
  1.48671612637396770623936e17,
  -9.9015288332320259874277e16,
  4.947844955753753135953656e16,
  -1.798904274685872485913352e16,
  4.498394289678466582654513e15,
  -6.92538790790587478005852e14,
  4.952385711440852807835038e13,
  -5.722764271304914811692417e13,
  7.98977626101326163254407e14,
  -5.181428267870918351636783e15,
  2.06872543196004305963226e16,
  -5.680862221998630024599228e16,
  1.135020255987438347474939e17,
  -1.701499050739932725611571e17,
  1.944178513165232134999648e17,
  -1.701499050739932725611571e17,
  1.135020255987438347474939e17,
  -5.680862221998630024599228e16,
  2.06872543196004305963226e16,
  -5.181428267870918351636783e15,
  7.98977626101326163254407e14,
  -5.722764271304914811692417e13,
  4.952385711440852807835038e13,
  -6.92538790790587478005852e14,
  4.498394289678466582654513e15,
  -1.798904274685872485913352e16,
  4.947844955753753135953656e16,
  -9.9015288332320259874277e16,
  1.48671612637396770623936e17,
  -1.701499050739932725611571e17,
  1.491518672738987185566811e17,
  -9.96563193228878364811986e16,
  4.996009470398597767224583e16,
  -1.822316747448798921065861e16,
  4.571803759659676811931538e15,
  -7.06148067541214473445017e14,
  5.066373290913283471024771e13,
  -3.267362585849252767963935e13,
  4.576164220152073779181684e14,
  -2.977085972682620749452534e15,
  1.19239720301954951749763e16,
  -3.284819661450471133782823e16,
  6.583920197953646954112155e16,
  -9.9015288332320259874277e16,
  1.135020255987438347474939e17,
  -9.96563193228878364811986e16,
  6.669489229092280662271897e16,
  -3.349120279212584933286535e16,
  1.223658435664580017835203e16,
  -3.075125822328563426959043e15,
  4.757966280256079659284011e14,
  -3.419682568714119915451959e13,
  1.617733609843002138186656e13,
  -2.269145152729097308077059e14,
  1.478455661100059416555887e15,
  -5.930623955398980407476257e15,
  1.636291523951385162466402e16,
  -3.284819661450471133782823e16,
  4.947844955753753135953656e16,
  -5.680862221998630024599228e16,
  4.996009470398597767224583e16,
  -3.349120279212584933286535e16,
  1.684619431201987800262822e16,
  -6.165645557200476206208111e15,
  1.552188096116453272318827e15,
  -2.405932435764394609027763e14,
  1.732399295423952994451031e13,
  -5.828724631152663269066797e12,
  8.18763529793858177365311e13,
  -5.342475288280451796263538e14,
  2.146258694523177972397832e15,
  -5.930623955398980407476257e15,
  1.19239720301954951749763e16,
  -1.798904274685872485913352e16,
  2.06872543196004305963226e16,
  -1.822316747448798921065861e16,
  1.223658435664580017835203e16,
  -6.165645557200476206208111e15,
  2.260595373562425035180787e15,
  -5.7013602879146366051515e14,
  8.85385105537660134739587e13,
  -6.387622388652466108230474e12,
  1.444668843740967333034896e12,
  -2.032187074261369856990959e13,
  1.327911638664760334265054e14,
  -5.342475288280451796263538e14,
  1.478455661100059416555887e15,
  -2.977085972682620749452534e15,
  4.498394289678466582654513e15,
  -5.181428267870918351636783e15,
  4.571803759659676811931538e15,
  -3.075125822328563426959043e15,
  1.552188096116453272318827e15,
  -5.7013602879146366051515e14,
  1.44063448194494421722997e14,
  -2.241613332013562601890868e13,
  1.620537266950072005952704e12,
  -2.204769898848496811465842e11,
  3.105644167982801880209335e12,
  -2.032187074261369856990959e13,
  8.18763529793858177365311e13,
  -2.269145152729097308077059e14,
  4.576164220152073779181684e14,
  -6.92538790790587478005852e14,
  7.98977626101326163254407e14,
  -7.06148067541214473445017e14,
  4.757966280256079659284011e14,
  -2.405932435764394609027763e14,
  8.85385105537660134739587e13,
  -2.241613332013562601890868e13,
  3.495142444273788422333412e12,
  -2.532280881290688216117093e11,
  1.563138425325755011430057e10,
  -2.204769898848496811465842e11,
  1.444668843740967333034896e12,
  -5.828724631152663269066797e12,
  1.617733609843002138186656e13,
  -3.267362585849252767963935e13,
  4.952385711440852807835038e13,
  -5.722764271304914811692417e13,
  5.066373290913283471024771e13,
  -3.419682568714119915451959e13,
  1.732399295423952994451031e13,
  -6.387622388652466108230474e12,
  1.620537266950072005952704e12,
  -2.532280881290688216117093e11,
  1.838979025781051242631162e10,

  7.15245199577127002436751e10,
  -1.057542018538138601223763e12,
  7.302475242164482249659651e12,
  -3.123660321607121508788022e13,
  9.25621575027836261847558e13,
  -2.012633953040166383175315e14,
  3.317177735577575987045108e14,
  -4.219913795399268389897367e14,
  4.177530542533862070217063e14,
  -3.218170411334388122156603e14,
  1.913398956269710569246768e14,
  -8.62252198759489206361802e13,
  2.850800203761081511215591e13,
  -6.528267066348025998257338e12,
  9.2587223009508884165583e11,
  -6.130681125971552835398137e10,
  -1.057542018538138601223763e12,
  1.566616965893577232850079e13,
  -1.083701881731511082974134e14,
  4.643411755468081474651918e14,
  -1.378176981353906614065984e15,
  3.001256695434538118745137e15,
  -4.953886611589203127686462e15,
  6.310952390621894183502057e15,
  -6.256082156973049736355795e15,
  4.825728945864293223924584e15,
  -2.872843280450781955010555e15,
  1.296212775269478056692759e15,
  -4.290707233326520948295283e14,
  9.83707494704470373140918e13,
  -1.396729023850486495863468e13,
  9.2587223009508884165583e11,
  7.302475242164482249659651e12,
  -1.083701881731511082974134e14,
  7.50921591091479137333953e14,
  -3.222756658008162964651056e15,
  9.5801495133712046378111e15,
  -2.089401126795740773931073e16,
  3.453767157994266090941752e16,
  -4.406048603930455663428503e16,
  4.373661364838162650345524e16,
  -3.378131545604562076922608e16,
  2.013634041152382274706076e16,
  -9.09672902562829938627879e15,
  3.014843474972251296345174e15,
  -6.92016541669662681077031e14,
  9.83707494704470373140918e13,
  -6.528267066348025998257338e12,
  -3.123660321607121508788022e13,
  4.643411755468081474651918e14,
  -3.222756658008162964651056e15,
  1.385290644967471851217622e16,
  -4.124236200392663173713369e16,
  9.00804219766025012743092e16,
  -1.49114639835968637082923e17,
  1.904925663505081204980736e17,
  -1.893475577105593872563246e17,
  1.464409233284952228905512e17,
  -8.74026258836938599612386e16,
  3.9534382947608086894361e16,
  -1.311864428714629109739016e16,
  3.014843474972251296345174e15,
  -4.290707233326520948295283e14,
  2.850800203761081511215591e13,
  9.25621575027836261847558e13,
  -1.378176981353906614065984e15,
  9.5801495133712046378111e15,
  -4.124236200392663173713369e16,
  1.229664383282994229089399e17,
  -2.689663550717071566252406e17,
  4.458591106165942373208448e17,
  -5.703634580687121863323732e17,
  5.676977717387081884874783e17,
  -4.396349728703924138749832e17,
  2.627337707075610278740723e17,
  -1.189921195424956014949822e17,
  3.9534382947608086894361e16,
  -9.09672902562829938627879e15,
  1.296212775269478056692759e15,
  -8.62252198759489206361802e13,
  -2.012633953040166383175315e14,
  3.001256695434538118745137e15,
  -2.089401126795740773931073e16,
  9.00804219766025012743092e16,
  -2.689663550717071566252406e17,
  5.89144692678331021945808e17,
  -9.77965175308634065038212e17,
  1.252763483750427425101187e18,
  -1.248581535670459499207285e18,
  9.68201314849961263526828e17,
  -5.79368811088435187640149e17,
  2.627337707075610278740723e17,
  -8.74026258836938599612386e16,
  2.013634041152382274706076e16,
  -2.872843280450781955010555e15,
  1.913398956269710569246768e14,
  3.317177735577575987045108e14,
  -4.953886611589203127686462e15,
  3.453767157994266090941752e16,
  -1.49114639835968637082923e17,
  4.458591106165942373208448e17,
  -9.77965175308634065038212e17,
  1.625620351478924700366076e18,
  -2.085222186956171813347403e18,
  2.081044858335505698944521e18,
  -1.615867682827803976664397e18,
  9.68201314849961263526828e17,
  -4.396349728703924138749832e17,
  1.464409233284952228905512e17,
  -3.378131545604562076922608e16,
  4.825728945864293223924584e15,
  -3.218170411334388122156603e14,
  -4.219913795399268389897367e14,
  6.310952390621894183502057e15,
  -4.406048603930455663428503e16,
  1.904925663505081204980736e17,
  -5.703634580687121863323732e17,
  1.252763483750427425101187e18,
  -2.085222186956171813347403e18,
  2.678362821685749900567014e18,
  -2.676573522972896407495971e18,
  2.081044858335505698944521e18,
  -1.248581535670459499207285e18,
  5.676977717387081884874783e17,
  -1.893475577105593872563246e17,
  4.373661364838162650345524e16,
  -6.256082156973049736355795e15,
  4.177530542533862070217063e14,
  4.177530542533862070217063e14,
  -6.256082156973049736355795e15,
  4.373661364838162650345524e16,
  -1.893475577105593872563246e17,
  5.676977717387081884874783e17,
  -1.248581535670459499207285e18,
  2.081044858335505698944521e18,
  -2.676573522972896407495971e18,
  2.678362821685749900567014e18,
  -2.085222186956171813347403e18,
  1.252763483750427425101187e18,
  -5.703634580687121863323732e17,
  1.904925663505081204980736e17,
  -4.406048603930455663428503e16,
  6.310952390621894183502057e15,
  -4.219913795399268389897367e14,
  -3.218170411334388122156603e14,
  4.825728945864293223924584e15,
  -3.378131545604562076922608e16,
  1.464409233284952228905512e17,
  -4.396349728703924138749832e17,
  9.68201314849961263526828e17,
  -1.615867682827803976664397e18,
  2.081044858335505698944521e18,
  -2.085222186956171813347403e18,
  1.625620351478924700366076e18,
  -9.77965175308634065038212e17,
  4.458591106165942373208448e17,
  -1.49114639835968637082923e17,
  3.453767157994266090941752e16,
  -4.953886611589203127686462e15,
  3.317177735577575987045108e14,
  1.913398956269710569246768e14,
  -2.872843280450781955010555e15,
  2.013634041152382274706076e16,
  -8.74026258836938599612386e16,
  2.627337707075610278740723e17,
  -5.79368811088435187640149e17,
  9.68201314849961263526828e17,
  -1.248581535670459499207285e18,
  1.252763483750427425101187e18,
  -9.77965175308634065038212e17,
  5.89144692678331021945808e17,
  -2.689663550717071566252406e17,
  9.00804219766025012743092e16,
  -2.089401126795740773931073e16,
  3.001256695434538118745137e15,
  -2.012633953040166383175315e14,
  -8.62252198759489206361802e13,
  1.296212775269478056692759e15,
  -9.09672902562829938627879e15,
  3.9534382947608086894361e16,
  -1.189921195424956014949822e17,
  2.627337707075610278740723e17,
  -4.396349728703924138749832e17,
  5.676977717387081884874783e17,
  -5.703634580687121863323732e17,
  4.458591106165942373208448e17,
  -2.689663550717071566252406e17,
  1.229664383282994229089399e17,
  -4.124236200392663173713369e16,
  9.5801495133712046378111e15,
  -1.378176981353906614065984e15,
  9.25621575027836261847558e13,
  2.850800203761081511215591e13,
  -4.290707233326520948295283e14,
  3.014843474972251296345174e15,
  -1.311864428714629109739016e16,
  3.9534382947608086894361e16,
  -8.74026258836938599612386e16,
  1.464409233284952228905512e17,
  -1.893475577105593872563246e17,
  1.904925663505081204980736e17,
  -1.49114639835968637082923e17,
  9.00804219766025012743092e16,
  -4.124236200392663173713369e16,
  1.385290644967471851217622e16,
  -3.222756658008162964651056e15,
  4.643411755468081474651918e14,
  -3.123660321607121508788022e13,
  -6.528267066348025998257338e12,
  9.83707494704470373140918e13,
  -6.92016541669662681077031e14,
  3.014843474972251296345174e15,
  -9.09672902562829938627879e15,
  2.013634041152382274706076e16,
  -3.378131545604562076922608e16,
  4.373661364838162650345524e16,
  -4.406048603930455663428503e16,
  3.453767157994266090941752e16,
  -2.089401126795740773931073e16,
  9.5801495133712046378111e15,
  -3.222756658008162964651056e15,
  7.50921591091479137333953e14,
  -1.083701881731511082974134e14,
  7.302475242164482249659651e12,
  9.2587223009508884165583e11,
  -1.396729023850486495863468e13,
  9.83707494704470373140918e13,
  -4.290707233326520948295283e14,
  1.296212775269478056692759e15,
  -2.872843280450781955010555e15,
  4.825728945864293223924584e15,
  -6.256082156973049736355795e15,
  6.310952390621894183502057e15,
  -4.953886611589203127686462e15,
  3.001256695434538118745137e15,
  -1.378176981353906614065984e15,
  4.643411755468081474651918e14,
  -1.083701881731511082974134e14,
  1.566616965893577232850079e13,
  -1.057542018538138601223763e12,
  -6.130681125971552835398137e10,
  9.2587223009508884165583e11,
  -6.528267066348025998257338e12,
  2.850800203761081511215591e13,
  -8.62252198759489206361802e13,
  1.913398956269710569246768e14,
  -3.218170411334388122156603e14,
  4.177530542533862070217063e14,
  -4.219913795399268389897367e14,
  3.317177735577575987045108e14,
  -2.012633953040166383175315e14,
  9.25621575027836261847558e13,
  -3.123660321607121508788022e13,
  7.302475242164482249659651e12,
  -1.057542018538138601223763e12,
  7.15245199577127002436751e10,

  2.786180299337560193602678e11,
  -4.402017063783537229060879e12,
  3.262003764385493225256992e13,
  -1.504855111430158185923787e14,
  4.83726204527391948521738e14,
  -1.148785596356684891862231e15,
  2.084996573067615179522642e15,
  -2.94999140064542628455425e15,
  3.288275332145100113243442e15,
  -2.897250273978418503892384e15,
  2.011058972040236278281712e15,
  -1.088153829084758480737448e15,
  4.499338878230970675897172e14,
  -1.374342649246539360779125e14,
  2.924664036160469702312753e13,
  -3.873997198031493533811414e12,
  2.406247627960639723635776e11,
  -4.402017063783537229060879e12,
  6.965756992465439249752137e13,
  -5.169411671829623936284069e14,
  2.388150804840408034043108e15,
  -7.68689294512480074390981e15,
  1.827893565222543082042556e16,
  -3.321672751276779738531732e16,
  4.70535800274422248424055e16,
  -5.251012725964157826443903e16,
  4.631779973775320423597115e16,
  -3.218541212102528926370195e16,
  1.743345400769885919449608e16,
  -7.215863251844710731206059e15,
  2.206325467606641206803175e15,
  -4.699751506354707774380071e14,
  6.23121549381603633220176e13,
  -3.873997198031493533811414e12,
  3.262003764385493225256992e13,
  -5.169411671829623936284069e14,
  3.841733004091988255376721e15,
  -1.777203656887393539954468e16,
  5.727883899659057686888609e16,
  -1.363775084099762874673558e17,
  2.481300957567352736256348e17,
  -3.519085349396908787265173e17,
  3.931695022561815622243668e17,
  -3.471926807845793097789848e17,
  2.415210105298934157115459e17,
  -1.309606273779675922293163e17,
  5.426204931229746327964598e16,
  -1.660802498771486484909637e16,
  3.541232853120270673800308e15,
  -4.699751506354707774380071e14,
  2.924664036160469702312753e13,
  -1.504855111430158185923787e14,
  2.388150804840408034043108e15,
  -1.777203656887393539954468e16,
  8.23223210602173297467837e16,
  -2.656609315691769493127069e17,
  6.33305781666004236120079e17,
  -1.153646548446837788400304e18,
  1.638069365922054264106847e18,
  -1.832225866927266926921173e18,
  1.619775749517293447513812e18,
  -1.128011853582413248047409e18,
  6.12299545702423137263006e17,
  -2.539654029177201083888274e17,
  7.78113446345287921942005e16,
  -1.660802498771486484909637e16,
  2.206325467606641206803175e15,
  -1.374342649246539360779125e14,
  4.83726204527391948521738e14,
  -7.68689294512480074390981e15,
  5.727883899659057686888609e16,
  -2.656609315691769493127069e17,
  8.58375264691235351269023e17,
  -2.048753736789887226733917e18,
  3.736493137273724377358176e18,
  -5.31163176626078679451969e18,
  5.947970843325656079615712e18,
  -5.264164507495269863632993e18,
  3.669984187274004635517297e18,
  -1.994262234074965892985368e18,
  8.2804335434200732881313e17,
  -2.539654029177201083888274e17,
  5.426204931229746327964598e16,
  -7.215863251844710731206059e15,
  4.499338878230970675897172e14,
  -1.148785596356684891862231e15,
  1.827893565222543082042556e16,
  -1.363775084099762874673558e17,
  6.33305781666004236120079e17,
  -2.048753736789887226733917e18,
  4.895752554866444432737217e18,
  -8.939269511131472700294026e18,
  1.272229791101406980852848e19,
  -1.426258919450057896886816e19,
  1.263699002597448247116296e19,
  -8.81974909907962403457233e18,
  4.797840641899872810526702e18,
  -1.994262234074965892985368e18,
  6.12299545702423137263006e17,
  -1.309606273779675922293163e17,
  1.743345400769885919449608e16,
  -1.088153829084758480737448e15,
  2.084996573067615179522642e15,
  -3.321672751276779738531732e16,
  2.481300957567352736256348e17,
  -1.153646548446837788400304e18,
  3.736493137273724377358176e18,
  -8.939269511131472700294026e18,
  1.634128740010875786167861e19,
  -2.328334867468451826664513e19,
  2.61317383541092629025317e19,
  -2.31791988475077455425556e19,
  1.619537643348039199888736e19,
  -8.81974909907962403457233e18,
  3.669984187274004635517297e18,
  -1.128011853582413248047409e18,
  2.415210105298934157115459e17,
  -3.218541212102528926370195e16,
  2.011058972040236278281712e15,
  -2.94999140064542628455425e15,
  4.70535800274422248424055e16,
  -3.519085349396908787265173e17,
  1.638069365922054264106847e18,
  -5.31163176626078679451969e18,
  1.272229791101406980852848e19,
  -2.328334867468451826664513e19,
  3.321211215846065036843442e19,
  -3.731709295161313879749503e19,
  3.313776861429083290308719e19,
  -2.31791988475077455425556e19,
  1.263699002597448247116296e19,
  -5.264164507495269863632993e18,
  1.619775749517293447513812e18,
  -3.471926807845793097789848e17,
  4.631779973775320423597115e16,
  -2.897250273978418503892384e15,
  3.288275332145100113243442e15,
  -5.251012725964157826443903e16,
  3.931695022561815622243668e17,
  -1.832225866927266926921173e18,
  5.947970843325656079615712e18,
  -1.426258919450057896886816e19,
  2.61317383541092629025317e19,
  -3.731709295161313879749503e19,
  4.197650233057228905864424e19,
  -3.731709295161313879749503e19,
  2.61317383541092629025317e19,
  -1.426258919450057896886816e19,
  5.947970843325656079615712e18,
  -1.832225866927266926921173e18,
  3.931695022561815622243668e17,
  -5.251012725964157826443903e16,
  3.288275332145100113243442e15,
  -2.897250273978418503892384e15,
  4.631779973775320423597115e16,
  -3.471926807845793097789848e17,
  1.619775749517293447513812e18,
  -5.264164507495269863632993e18,
  1.263699002597448247116296e19,
  -2.31791988475077455425556e19,
  3.313776861429083290308719e19,
  -3.731709295161313879749503e19,
  3.321211215846065036843442e19,
  -2.328334867468451826664513e19,
  1.272229791101406980852848e19,
  -5.31163176626078679451969e18,
  1.638069365922054264106847e18,
  -3.519085349396908787265173e17,
  4.70535800274422248424055e16,
  -2.94999140064542628455425e15,
  2.011058972040236278281712e15,
  -3.218541212102528926370195e16,
  2.415210105298934157115459e17,
  -1.128011853582413248047409e18,
  3.669984187274004635517297e18,
  -8.81974909907962403457233e18,
  1.619537643348039199888736e19,
  -2.31791988475077455425556e19,
  2.61317383541092629025317e19,
  -2.328334867468451826664513e19,
  1.634128740010875786167861e19,
  -8.939269511131472700294026e18,
  3.736493137273724377358176e18,
  -1.153646548446837788400304e18,
  2.481300957567352736256348e17,
  -3.321672751276779738531732e16,
  2.084996573067615179522642e15,
  -1.088153829084758480737448e15,
  1.743345400769885919449608e16,
  -1.309606273779675922293163e17,
  6.12299545702423137263006e17,
  -1.994262234074965892985368e18,
  4.797840641899872810526702e18,
  -8.81974909907962403457233e18,
  1.263699002597448247116296e19,
  -1.426258919450057896886816e19,
  1.272229791101406980852848e19,
  -8.939269511131472700294026e18,
  4.895752554866444432737217e18,
  -2.048753736789887226733917e18,
  6.33305781666004236120079e17,
  -1.363775084099762874673558e17,
  1.827893565222543082042556e16,
  -1.148785596356684891862231e15,
  4.499338878230970675897172e14,
  -7.215863251844710731206059e15,
  5.426204931229746327964598e16,
  -2.539654029177201083888274e17,
  8.2804335434200732881313e17,
  -1.994262234074965892985368e18,
  3.669984187274004635517297e18,
  -5.264164507495269863632993e18,
  5.947970843325656079615712e18,
  -5.31163176626078679451969e18,
  3.736493137273724377358176e18,
  -2.048753736789887226733917e18,
  8.58375264691235351269023e17,
  -2.656609315691769493127069e17,
  5.727883899659057686888609e16,
  -7.68689294512480074390981e15,
  4.83726204527391948521738e14,
  -1.374342649246539360779125e14,
  2.206325467606641206803175e15,
  -1.660802498771486484909637e16,
  7.78113446345287921942005e16,
  -2.539654029177201083888274e17,
  6.12299545702423137263006e17,
  -1.128011853582413248047409e18,
  1.619775749517293447513812e18,
  -1.832225866927266926921173e18,
  1.638069365922054264106847e18,
  -1.153646548446837788400304e18,
  6.33305781666004236120079e17,
  -2.656609315691769493127069e17,
  8.23223210602173297467837e16,
  -1.777203656887393539954468e16,
  2.388150804840408034043108e15,
  -1.504855111430158185923787e14,
  2.924664036160469702312753e13,
  -4.699751506354707774380071e14,
  3.541232853120270673800308e15,
  -1.660802498771486484909637e16,
  5.426204931229746327964598e16,
  -1.309606273779675922293163e17,
  2.415210105298934157115459e17,
  -3.471926807845793097789848e17,
  3.931695022561815622243668e17,
  -3.519085349396908787265173e17,
  2.481300957567352736256348e17,
  -1.363775084099762874673558e17,
  5.727883899659057686888609e16,
  -1.777203656887393539954468e16,
  3.841733004091988255376721e15,
  -5.169411671829623936284069e14,
  3.262003764385493225256992e13,
  -3.873997198031493533811414e12,
  6.23121549381603633220176e13,
  -4.699751506354707774380071e14,
  2.206325467606641206803175e15,
  -7.215863251844710731206059e15,
  1.743345400769885919449608e16,
  -3.218541212102528926370195e16,
  4.631779973775320423597115e16,
  -5.251012725964157826443903e16,
  4.70535800274422248424055e16,
  -3.321672751276779738531732e16,
  1.827893565222543082042556e16,
  -7.68689294512480074390981e15,
  2.388150804840408034043108e15,
  -5.169411671829623936284069e14,
  6.965756992465439249752137e13,
  -4.402017063783537229060879e12,
  2.406247627960639723635776e11,
  -3.873997198031493533811414e12,
  2.924664036160469702312753e13,
  -1.374342649246539360779125e14,
  4.499338878230970675897172e14,
  -1.088153829084758480737448e15,
  2.011058972040236278281712e15,
  -2.897250273978418503892384e15,
  3.288275332145100113243442e15,
  -2.94999140064542628455425e15,
  2.084996573067615179522642e15,
  -1.148785596356684891862231e15,
  4.83726204527391948521738e14,
  -1.504855111430158185923787e14,
  3.262003764385493225256992e13,
  -4.402017063783537229060879e12,
  2.786180299337560193602678e11,

  1.086841817509296936894374e12,
  -1.827154513227670564286539e13,
  1.44617305857318596974353e14,
  -7.15696383277095990348324e14,
  2.480329409632671148894275e15,
  -6.38794204376046625373197e15,
  1.265983194125306798110444e16,
  -1.972024001188603605943051e16,
  2.44432627322588851888826e16,
  -2.424593439423106478503813e16,
  1.924631096338902215754669e16,
  -1.215645347438950825823079e16,
  6.03480895723775998179091e15,
  -2.305191581703931220518319e15,
  6.54310877587858092536026e14,
  -1.300427569547848891683439e14,
  1.615824227466601245739163e13,
  -9.45079966400036639971878e11,
  -1.827154513227670564286539e13,
  3.075697273529597903904916e14,
  -2.437380308021730399540741e15,
  1.207659981961391191759234e16,
  -4.190042027739703341392344e16,
  1.080302441667390634582969e17,
  -2.143243449352917544866779e17,
  3.3419512238869831663137e17,
  -4.146463085281681864461828e17,
  4.116951003984397341720054e17,
  -3.27107714738646259170136e17,
  2.067977991611799228214422e17,
  -1.027515208653584158119591e17,
  3.928331657360563448818209e16,
  -1.115971151563958304506875e16,
  2.219803893637569990785944e15,
  -2.760416579400539563704197e14,
  1.615824227466601245739163e13,
  1.44617305857318596974353e14,
  -2.437380308021730399540741e15,
  1.933828071864848516455409e16,
  -9.59259585615357199335342e16,
  3.331888318035043341238955e17,
  -8.59969516260251976090472e17,
  1.707894765660930367267178e18,
  -2.665808393603892122643396e18,
  3.310808840330814155717692e18,
  -3.290399105432315258106326e18,
  2.616797412198637433954253e18,
  -1.655854641658416444027711e18,
  8.2347936077368735206319e17,
  -3.151029958363598450979617e17,
  8.95920724234561461589496e16,
  -1.783595069116027540120864e16,
  2.219803893637569990785944e15,
  -1.300427569547848891683439e14,
  -7.15696383277095990348324e14,
  1.207659981961391191759234e16,
  -9.59259585615357199335342e16,
  4.763616505724729150710994e17,
  -1.656380269696729119113366e18,
  4.279660034430287379062307e18,
  -8.50809747979828480593155e18,
  1.329335968341675258666284e19,
  -1.652587532694462503091512e19,
  1.643971223426628447903643e19,
  -1.308646447625677303993045e19,
  8.288442330259809420887645e18,
  -4.125668327050386542811775e18,
  1.580075680402649613091989e18,
  -4.496473502625580670433133e17,
  8.95920724234561461589496e16,
  -1.115971151563958304506875e16,
  6.54310877587858092536026e14,
  2.480329409632671148894275e15,
  -4.190042027739703341392344e16,
  3.331888318035043341238955e17,
  -1.656380269696729119113366e18,
  5.765560078368210535503341e18,
  -1.491210298463101508537934e19,
  2.967569471323040825004503e19,
  -4.641231803762250810027348e19,
  5.775436973683502255861838e19,
  -5.750806812038184247645247e19,
  4.582092785818242624563075e19,
  -2.904789613031206136669835e19,
  1.447204606860554412227537e19,
  -5.547552463069190567500004e18,
  1.580075680402649613091989e18,
  -3.151029958363598450979617e17,
  3.928331657360563448818209e16,
  -2.305191581703931220518319e15,
  -6.38794204376046625373197e15,
  1.080302441667390634582969e17,
  -8.59969516260251976090472e17,
  4.279660034430287379062307e18,
  -1.491210298463101508537934e19,
  3.860793488220662064402477e19,
  -7.69079914944379230325603e19,
  1.204009180430208944059232e20,
  -1.499687731902681898384013e20,
  1.494713987631960729974516e20,
  -1.192067305588210409300004e20,
  7.56403889716832283244299e19,
  -3.771951564266636930415653e19,
  1.447204606860554412227537e19,
  -4.125668327050386542811775e18,
  8.2347936077368735206319e17,
  -1.027515208653584158119591e17,
  6.03480895723775998179091e15,
  1.265983194125306798110444e16,
  -2.143243449352917544866779e17,
  1.707894765660930367267178e18,
  -8.50809747979828480593155e18,
  2.967569471323040825004503e19,
  -7.69079914944379230325603e19,
  1.533535086091592830606883e20,
  -2.403112981931229924093288e20,
  2.996142657839978490434945e20,
  -2.989044778195779241670024e20,
  2.386071616437208496287207e20,
  -1.515447178914922238274048e20,
  7.56403889716832283244299e19,
  -2.904789613031206136669835e19,
  8.288442330259809420887645e18,
  -1.655854641658416444027711e18,
  2.067977991611799228214422e17,
  -1.215645347438950825823079e16,
  -1.972024001188603605943051e16,
  3.3419512238869831663137e17,
  -2.665808393603892122643396e18,
  1.329335968341675258666284e19,
  -4.641231803762250810027348e19,
  1.204009180430208944059232e20,
  -2.403112981931229924093288e20,
  3.769408887168597582908061e20,
  -4.704103070289196858606285e20,
  4.697415454984635138425604e20,
  -3.753352856461222487793469e20,
  2.386071616437208496287207e20,
  -1.192067305588210409300004e20,
  4.582092785818242624563075e19,
  -1.308646447625677303993045e19,
  2.616797412198637433954253e18,
  -3.27107714738646259170136e17,
  1.924631096338902215754669e16,
  2.44432627322588851888826e16,
  -4.146463085281681864461828e17,
  3.310808840330814155717692e18,
  -1.652587532694462503091512e19,
  5.775436973683502255861838e19,
  -1.499687731902681898384013e20,
  2.996142657839978490434945e20,
  -4.704103070289196858606285e20,
  5.876164103999010741453174e20,
  -5.873378567856724108539238e20,
  4.697415454984635138425604e20,
  -2.989044778195779241670024e20,
  1.494713987631960729974516e20,
  -5.750806812038184247645247e19,
  1.643971223426628447903643e19,
  -3.290399105432315258106326e18,
  4.116951003984397341720054e17,
  -2.424593439423106478503813e16,
  -2.424593439423106478503813e16,
  4.116951003984397341720054e17,
  -3.290399105432315258106326e18,
  1.643971223426628447903643e19,
  -5.750806812038184247645247e19,
  1.494713987631960729974516e20,
  -2.989044778195779241670024e20,
  4.697415454984635138425604e20,
  -5.873378567856724108539238e20,
  5.876164103999010741453174e20,
  -4.704103070289196858606285e20,
  2.996142657839978490434945e20,
  -1.499687731902681898384013e20,
  5.775436973683502255861838e19,
  -1.652587532694462503091512e19,
  3.310808840330814155717692e18,
  -4.146463085281681864461828e17,
  2.44432627322588851888826e16,
  1.924631096338902215754669e16,
  -3.27107714738646259170136e17,
  2.616797412198637433954253e18,
  -1.308646447625677303993045e19,
  4.582092785818242624563075e19,
  -1.192067305588210409300004e20,
  2.386071616437208496287207e20,
  -3.753352856461222487793469e20,
  4.697415454984635138425604e20,
  -4.704103070289196858606285e20,
  3.769408887168597582908061e20,
  -2.403112981931229924093288e20,
  1.204009180430208944059232e20,
  -4.641231803762250810027348e19,
  1.329335968341675258666284e19,
  -2.665808393603892122643396e18,
  3.3419512238869831663137e17,
  -1.972024001188603605943051e16,
  -1.215645347438950825823079e16,
  2.067977991611799228214422e17,
  -1.655854641658416444027711e18,
  8.288442330259809420887645e18,
  -2.904789613031206136669835e19,
  7.56403889716832283244299e19,
  -1.515447178914922238274048e20,
  2.386071616437208496287207e20,
  -2.989044778195779241670024e20,
  2.996142657839978490434945e20,
  -2.403112981931229924093288e20,
  1.533535086091592830606883e20,
  -7.69079914944379230325603e19,
  2.967569471323040825004503e19,
  -8.50809747979828480593155e18,
  1.707894765660930367267178e18,
  -2.143243449352917544866779e17,
  1.265983194125306798110444e16,
  6.03480895723775998179091e15,
  -1.027515208653584158119591e17,
  8.2347936077368735206319e17,
  -4.125668327050386542811775e18,
  1.447204606860554412227537e19,
  -3.771951564266636930415653e19,
  7.56403889716832283244299e19,
  -1.192067305588210409300004e20,
  1.494713987631960729974516e20,
  -1.499687731902681898384013e20,
  1.204009180430208944059232e20,
  -7.69079914944379230325603e19,
  3.860793488220662064402477e19,
  -1.491210298463101508537934e19,
  4.279660034430287379062307e18,
  -8.59969516260251976090472e17,
  1.080302441667390634582969e17,
  -6.38794204376046625373197e15,
  -2.305191581703931220518319e15,
  3.928331657360563448818209e16,
  -3.151029958363598450979617e17,
  1.580075680402649613091989e18,
  -5.547552463069190567500004e18,
  1.447204606860554412227537e19,
  -2.904789613031206136669835e19,
  4.582092785818242624563075e19,
  -5.750806812038184247645247e19,
  5.775436973683502255861838e19,
  -4.641231803762250810027348e19,
  2.967569471323040825004503e19,
  -1.491210298463101508537934e19,
  5.765560078368210535503341e18,
  -1.656380269696729119113366e18,
  3.331888318035043341238955e17,
  -4.190042027739703341392344e16,
  2.480329409632671148894275e15,
  6.54310877587858092536026e14,
  -1.115971151563958304506875e16,
  8.95920724234561461589496e16,
  -4.496473502625580670433133e17,
  1.580075680402649613091989e18,
  -4.125668327050386542811775e18,
  8.288442330259809420887645e18,
  -1.308646447625677303993045e19,
  1.643971223426628447903643e19,
  -1.652587532694462503091512e19,
  1.329335968341675258666284e19,
  -8.50809747979828480593155e18,
  4.279660034430287379062307e18,
  -1.656380269696729119113366e18,
  4.763616505724729150710994e17,
  -9.59259585615357199335342e16,
  1.207659981961391191759234e16,
  -7.15696383277095990348324e14,
  -1.300427569547848891683439e14,
  2.219803893637569990785944e15,
  -1.783595069116027540120864e16,
  8.95920724234561461589496e16,
  -3.151029958363598450979617e17,
  8.2347936077368735206319e17,
  -1.655854641658416444027711e18,
  2.616797412198637433954253e18,
  -3.290399105432315258106326e18,
  3.310808840330814155717692e18,
  -2.665808393603892122643396e18,
  1.707894765660930367267178e18,
  -8.59969516260251976090472e17,
  3.331888318035043341238955e17,
  -9.59259585615357199335342e16,
  1.933828071864848516455409e16,
  -2.437380308021730399540741e15,
  1.44617305857318596974353e14,
  1.615824227466601245739163e13,
  -2.760416579400539563704197e14,
  2.219803893637569990785944e15,
  -1.115971151563958304506875e16,
  3.928331657360563448818209e16,
  -1.027515208653584158119591e17,
  2.067977991611799228214422e17,
  -3.27107714738646259170136e17,
  4.116951003984397341720054e17,
  -4.146463085281681864461828e17,
  3.3419512238869831663137e17,
  -2.143243449352917544866779e17,
  1.080302441667390634582969e17,
  -4.190042027739703341392344e16,
  1.207659981961391191759234e16,
  -2.437380308021730399540741e15,
  3.075697273529597903904916e14,
  -1.827154513227670564286539e13,
  -9.45079966400036639971878e11,
  1.615824227466601245739163e13,
  -1.300427569547848891683439e14,
  6.54310877587858092536026e14,
  -2.305191581703931220518319e15,
  6.03480895723775998179091e15,
  -1.215645347438950825823079e16,
  1.924631096338902215754669e16,
  -2.424593439423106478503813e16,
  2.44432627322588851888826e16,
  -1.972024001188603605943051e16,
  1.265983194125306798110444e16,
  -6.38794204376046625373197e15,
  2.480329409632671148894275e15,
  -7.15696383277095990348324e14,
  1.44617305857318596974353e14,
  -1.827154513227670564286539e13,
  1.086841817509296936894374e12,

  4.244870305797070487754679e12,
  -7.56536444501370530970474e13,
  6.36937224431604667453585e14,
  -3.365815020753400856342956e15,
  1.250998118829492311697068e16,
  -3.472835494995675312118883e16,
  7.46234074078089799876295e16,
  -1.269058868353950958014444e17,
  1.731524759499159298647059e17,
  -1.909623248992195991218858e17,
  1.706341238788345920033737e17,
  -1.232396270599699974524317e17,
  7.141073921166704998415293e16,
  -3.274725942837141483827102e16,
  1.162320649140370549793568e16,
  -3.081114386332221909715716e15,
  5.74414327717655714386729e14,
  -6.720858759375768085109127e13,
  3.714261671399010740774129e12,
  -7.56536444501370530970474e13,
  1.349785027228279697763873e15,
  -1.137581427735283029966397e16,
  6.017426506483011632552664e16,
  -2.238705515988967964815187e17,
  6.22057648428893566815334e17,
  -1.337873520038045982871051e18,
  2.277213372300820706398885e18,
  -3.109724433410560209887144e18,
  3.432433763341405131530662e18,
  -3.069533258005984053128714e18,
  2.218707987937459974159605e18,
  -1.286614698901580146785762e18,
  5.90456022902574440695118e17,
  -2.097292717595180908425355e17,
  5.563585129940079894878339e16,
  -1.03795788088759915267903e16,
  1.215292730161667448037835e15,
  -6.720858759375768085109127e13,
  6.36937224431604667453585e14,
  -1.137581427735283029966397e16,
  9.59702292532320218531097e16,
  -5.081446049099692055523664e17,
  1.892271364007581705359864e18,
  -5.26278232290057913753471e18,
  1.132889119939307704304114e19,
  -1.929983750354786276414064e19,
  2.637789242845062047651587e19,
  -2.913935294175865620097449e19,
  2.607963329425824559105023e19,
  -1.886570495024964838040354e19,
  1.094858453254101510506875e19,
  -5.028365691217083211589216e18,
  1.787400326433525806178791e18,
  -4.744987144520085640121004e17,
  8.8587396233092165027015e16,
  -1.03795788088759915267903e16,
  5.74414327717655714386729e14,
  -3.365815020753400856342956e15,
  6.017426506483011632552664e16,
  -5.081446049099692055523664e17,
  2.69308041727481067173521e18,
  -1.003797674225849793602637e19,
  2.794275433311652258678169e19,
  -6.020369798999870513208786e19,
  1.026509270838346305469696e20,
  -1.404154226622342105233555e20,
  1.552432179866089902749088e20,
  -1.390545461302039393774431e20,
  1.006702401933255943390421e20,
  -5.846879696133237918169933e19,
  2.687356420613946303429936e19,
  -9.55975884569431549491071e18,
  2.539695243824734023425378e18,
  -4.744987144520085640121004e17,
  5.563585129940079894878339e16,
  -3.081114386332221909715716e15,
  1.250998118829492311697068e16,
  -2.238705515988967964815187e17,
  1.892271364007581705359864e18,
  -1.003797674225849793602637e19,
  3.744857163717828943601087e19,
  -1.043379933110733027074452e20,
  2.249951241679487263240871e20,
  -3.839568399354127911158229e20,
  5.256507316967144262733747e20,
  -5.81636620111257638675152e20,
  5.214047815383409101869726e20,
  -3.777774521005005107096049e20,
  2.195830971691318947566601e20,
  -1.010031321331104720703217e20,
  3.595726191523772234508656e19,
  -9.55975884569431549491071e18,
  1.787400326433525806178791e18,
  -2.097292717595180908425355e17,
  1.162320649140370549793568e16,
  -3.472835494995675312118883e16,
  6.22057648428893566815334e17,
  -5.26278232290057913753471e18,
  2.794275433311652258678169e19,
  -1.043379933110733027074452e20,
  2.909560944742373877225647e20,
  -6.27956806904990359543554e20,
  1.0725190948077002397091e21,
  -1.469536724578874985731138e21,
  1.627385124674384414761265e21,
  -1.46003813549835776595347e21,
  1.058695913028612059646732e21,
  -6.15851205817043117964242e20,
  2.834975626764073626375736e20,
  -1.010031321331104720703217e20,
  2.687356420613946303429936e19,
  -5.028365691217083211589216e18,
  5.90456022902574440695118e17,
  -3.274725942837141483827102e16,
  7.46234074078089799876295e16,
  -1.337873520038045982871051e18,
  1.132889119939307704304114e19,
  -6.020369798999870513208786e19,
  2.249951241679487263240871e20,
  -6.27956806904990359543554e20,
  1.356435254027274508172493e21,
  -2.318658911366034419638113e21,
  3.179586257728811230248803e21,
  -3.523991650281755618760156e21,
  3.164166544121566815887419e21,
  -2.296219656199285745037989e21,
  1.336785426646127379203625e21,
  -6.15851205817043117964242e20,
  2.195830971691318947566601e20,
  -5.846879696133237918169933e19,
  1.094858453254101510506875e19,
  -1.286614698901580146785762e18,
  7.141073921166704998415293e16,
  -1.269058868353950958014444e17,
  2.277213372300820706398885e18,
  -1.929983750354786276414064e19,
  1.026509270838346305469696e20,
  -3.839568399354127911158229e20,
  1.0725190948077002397091e21,
  -2.318658911366034419638113e21,
  3.966742223965086506245216e21,
  -5.444073856197780084164239e21,
  6.038675612637637980227205e21,
  -5.426463913000535662047253e21,
  3.941116383690751305848525e21,
  -2.296219656199285745037989e21,
  1.058695913028612059646732e21,
  -3.777774521005005107096049e20,
  1.006702401933255943390421e20,
  -1.886570495024964838040354e19,
  2.218707987937459974159605e18,
  -1.232396270599699974524317e17,
  1.731524759499159298647059e17,
  -3.109724433410560209887144e18,
  2.637789242845062047651587e19,
  -1.404154226622342105233555e20,
  5.256507316967144262733747e20,
  -1.469536724578874985731138e21,
  3.179586257728811230248803e21,
  -5.444073856197780084164239e21,
  7.477706672440134792666946e21,
  -8.301159455938285333757251e21,
  7.465605011849656721431462e21,
  -5.426463913000535662047253e21,
  3.164166544121566815887419e21,
  -1.46003813549835776595347e21,
  5.214047815383409101869726e20,
  -1.390545461302039393774431e20,
  2.607963329425824559105023e19,
  -3.069533258005984053128714e18,
  1.706341238788345920033737e17,
  -1.909623248992195991218858e17,
  3.432433763341405131530662e18,
  -2.913935294175865620097449e19,
  1.552432179866089902749088e20,
  -5.81636620111257638675152e20,
  1.627385124674384414761265e21,
  -3.523991650281755618760156e21,
  6.038675612637637980227205e21,
  -8.301159455938285333757251e21,
  9.222763305071885968825838e21,
  -8.301159455938285333757251e21,
  6.038675612637637980227205e21,
  -3.523991650281755618760156e21,
  1.627385124674384414761265e21,
  -5.81636620111257638675152e20,
  1.552432179866089902749088e20,
  -2.913935294175865620097449e19,
  3.432433763341405131530662e18,
  -1.909623248992195991218858e17,
  1.706341238788345920033737e17,
  -3.069533258005984053128714e18,
  2.607963329425824559105023e19,
  -1.390545461302039393774431e20,
  5.214047815383409101869726e20,
  -1.46003813549835776595347e21,
  3.164166544121566815887419e21,
  -5.426463913000535662047253e21,
  7.465605011849656721431462e21,
  -8.301159455938285333757251e21,
  7.477706672440134792666946e21,
  -5.444073856197780084164239e21,
  3.179586257728811230248803e21,
  -1.469536724578874985731138e21,
  5.256507316967144262733747e20,
  -1.404154226622342105233555e20,
  2.637789242845062047651587e19,
  -3.109724433410560209887144e18,
  1.731524759499159298647059e17,
  -1.232396270599699974524317e17,
  2.218707987937459974159605e18,
  -1.886570495024964838040354e19,
  1.006702401933255943390421e20,
  -3.777774521005005107096049e20,
  1.058695913028612059646732e21,
  -2.296219656199285745037989e21,
  3.941116383690751305848525e21,
  -5.426463913000535662047253e21,
  6.038675612637637980227205e21,
  -5.444073856197780084164239e21,
  3.966742223965086506245216e21,
  -2.318658911366034419638113e21,
  1.0725190948077002397091e21,
  -3.839568399354127911158229e20,
  1.026509270838346305469696e20,
  -1.929983750354786276414064e19,
  2.277213372300820706398885e18,
  -1.269058868353950958014444e17,
  7.141073921166704998415293e16,
  -1.286614698901580146785762e18,
  1.094858453254101510506875e19,
  -5.846879696133237918169933e19,
  2.195830971691318947566601e20,
  -6.15851205817043117964242e20,
  1.336785426646127379203625e21,
  -2.296219656199285745037989e21,
  3.164166544121566815887419e21,
  -3.523991650281755618760156e21,
  3.179586257728811230248803e21,
  -2.318658911366034419638113e21,
  1.356435254027274508172493e21,
  -6.27956806904990359543554e20,
  2.249951241679487263240871e20,
  -6.020369798999870513208786e19,
  1.132889119939307704304114e19,
  -1.337873520038045982871051e18,
  7.46234074078089799876295e16,
  -3.274725942837141483827102e16,
  5.90456022902574440695118e17,
  -5.028365691217083211589216e18,
  2.687356420613946303429936e19,
  -1.010031321331104720703217e20,
  2.834975626764073626375736e20,
  -6.15851205817043117964242e20,
  1.058695913028612059646732e21,
  -1.46003813549835776595347e21,
  1.627385124674384414761265e21,
  -1.469536724578874985731138e21,
  1.0725190948077002397091e21,
  -6.27956806904990359543554e20,
  2.909560944742373877225647e20,
  -1.043379933110733027074452e20,
  2.794275433311652258678169e19,
  -5.26278232290057913753471e18,
  6.22057648428893566815334e17,
  -3.472835494995675312118883e16,
  1.162320649140370549793568e16,
  -2.097292717595180908425355e17,
  1.787400326433525806178791e18,
  -9.55975884569431549491071e18,
  3.595726191523772234508656e19,
  -1.010031321331104720703217e20,
  2.195830971691318947566601e20,
  -3.777774521005005107096049e20,
  5.214047815383409101869726e20,
  -5.81636620111257638675152e20,
  5.256507316967144262733747e20,
  -3.839568399354127911158229e20,
  2.249951241679487263240871e20,
  -1.043379933110733027074452e20,
  3.744857163717828943601087e19,
  -1.003797674225849793602637e19,
  1.892271364007581705359864e18,
  -2.238705515988967964815187e17,
  1.250998118829492311697068e16,
  -3.081114386332221909715716e15,
  5.563585129940079894878339e16,
  -4.744987144520085640121004e17,
  2.539695243824734023425378e18,
  -9.55975884569431549491071e18,
  2.687356420613946303429936e19,
  -5.846879696133237918169933e19,
  1.006702401933255943390421e20,
  -1.390545461302039393774431e20,
  1.552432179866089902749088e20,
  -1.404154226622342105233555e20,
  1.026509270838346305469696e20,
  -6.020369798999870513208786e19,
  2.794275433311652258678169e19,
  -1.003797674225849793602637e19,
  2.69308041727481067173521e18,
  -5.081446049099692055523664e17,
  6.017426506483011632552664e16,
  -3.365815020753400856342956e15,
  5.74414327717655714386729e14,
  -1.03795788088759915267903e16,
  8.8587396233092165027015e16,
  -4.744987144520085640121004e17,
  1.787400326433525806178791e18,
  -5.028365691217083211589216e18,
  1.094858453254101510506875e19,
  -1.886570495024964838040354e19,
  2.607963329425824559105023e19,
  -2.913935294175865620097449e19,
  2.637789242845062047651587e19,
  -1.929983750354786276414064e19,
  1.132889119939307704304114e19,
  -5.26278232290057913753471e18,
  1.892271364007581705359864e18,
  -5.081446049099692055523664e17,
  9.59702292532320218531097e16,
  -1.137581427735283029966397e16,
  6.36937224431604667453585e14,
  -6.720858759375768085109127e13,
  1.215292730161667448037835e15,
  -1.03795788088759915267903e16,
  5.563585129940079894878339e16,
  -2.097292717595180908425355e17,
  5.90456022902574440695118e17,
  -1.286614698901580146785762e18,
  2.218707987937459974159605e18,
  -3.069533258005984053128714e18,
  3.432433763341405131530662e18,
  -3.109724433410560209887144e18,
  2.277213372300820706398885e18,
  -1.337873520038045982871051e18,
  6.22057648428893566815334e17,
  -2.238705515988967964815187e17,
  6.017426506483011632552664e16,
  -1.137581427735283029966397e16,
  1.349785027228279697763873e15,
  -7.56536444501370530970474e13,
  3.714261671399010740774129e12,
  -6.720858759375768085109127e13,
  5.74414327717655714386729e14,
  -3.081114386332221909715716e15,
  1.162320649140370549793568e16,
  -3.274725942837141483827102e16,
  7.141073921166704998415293e16,
  -1.232396270599699974524317e17,
  1.706341238788345920033737e17,
  -1.909623248992195991218858e17,
  1.731524759499159298647059e17,
  -1.269058868353950958014444e17,
  7.46234074078089799876295e16,
  -3.472835494995675312118883e16,
  1.250998118829492311697068e16,
  -3.365815020753400856342956e15,
  6.36937224431604667453585e14,
  -7.56536444501370530970474e13,
  4.244870305797070487754679e12,

  1.659780989895998607840983e13,
  -3.125699584952214363996735e14,
  2.789056221909559171707699e15,
  -1.56737016762778594701723e16,
  6.219170516030167633772058e16,
  -1.851247931617859734386911e17,
  4.28704863828693589703952e17,
  -7.90357457095291832489624e17,
  1.177157104213401539078995e18,
  -1.428898280597829012780083e18,
  1.419425909466928353568968e18,
  -1.153895681027350499498757e18,
  7.64486791872366717649255e17,
  -4.09174373596179017979601e17,
  1.743423984461734634719628e17,
  -5.778824924273652609636418e16,
  1.436887282161062844446128e16,
  -2.522451050487263333406215e15,
  2.788636380567376023138026e14,
  -1.460607289834425422135112e13,
  -3.125699584952214363996735e14,
  5.89170950998962415550123e15,
  -5.261811848765548217837078e16,
  2.959518657886997206674375e17,
  -1.175281643840137141200903e18,
  3.501252755043276759570489e18,
  -8.114408310055641620059186e18,
  1.497105613877674495787759e19,
  -2.231440088650420588947372e19,
  2.710603979062902561645085e19,
  -2.694535918238767577232444e19,
  2.19198349567660628427385e19,
  -1.453227514223321530186452e19,
  7.783209840032988701950999e18,
  -3.318441509508852319209889e18,
  1.100641808524606996309652e18,
  -2.738415061732442395584862e17,
  4.810215167621649729071013e16,
  -5.321011236627165586227186e15,
  2.788636380567376023138026e14,
  2.789056221909559171707699e15,
  -5.261811848765548217837078e16,
  4.703290834685635194696212e17,
  -2.647583050682989512540678e18,
  1.052259075692483785448004e19,
  -3.137236901612963684692409e19,
  7.276379562795810047111551e19,
  -1.34349984695070426893254e20,
  2.003962810424930863187864e20,
  -2.436030606146390637932257e20,
  2.423295059816580609886465e20,
  -1.972690878429716565518849e20,
  1.308726630813740848156285e20,
  -7.013940818329196715161145e19,
  2.992404607530864672335629e19,
  -9.93138884325233395046526e18,
  2.472500551622553850950443e18,
  -4.34580593129383643897495e17,
  4.810215167621649729071013e16,
  -2.522451050487263333406215e15,
  -1.56737016762778594701723e16,
  2.959518657886997206674375e17,
  -2.647583050682989512540678e18,
  1.491593640004781666581822e19,
  -5.932920768711240786389383e19,
  1.770232889043242780206524e20,
  -4.108926875516491687100303e20,
  7.592308502692181443583e20,
  -1.13329406470261710475962e21,
  1.378625669936159298812678e21,
  -1.372381470609686153082862e21,
  1.117962116211382877817529e21,
  -7.4218360004958502583761e20,
  3.98028348686551189914877e20,
  -1.699249305414683925105736e20,
  5.643223818858081605750816e19,
  -1.405821048584831041083993e19,
  2.472500551622553850950443e18,
  -2.738415061732442395584862e17,
  1.436887282161062844446128e16,
  6.219170516030167633772058e16,
  -1.175281643840137141200903e18,
  1.052259075692483785448004e19,
  -5.932920768711240786389383e19,
  2.361699672271249414774657e20,
  -7.05209533419736227081637e20,
  1.638105038740723964958572e21,
  -3.029053840817005494960601e21,
  4.524703528557917837044534e21,
  -5.508116069717362391812522e21,
  5.487011671480079151127116e21,
  -4.472885672607356758880305e21,
  2.971442482989671876069853e21,
  -1.594634138634699272813868e21,
  6.8122606506919456423926e20,
  -2.263834949042899898606286e20,
  5.643223818858081605750816e19,
  -9.93138884325233395046526e18,
  1.100641808524606996309652e18,
  -5.778824924273652609636418e16,
  -1.851247931617859734386911e17,
  3.501252755043276759570489e18,
  -3.137236901612963684692409e19,
  1.770232889043242780206524e20,
  -7.05209533419736227081637e20,
  2.107356718829485376022324e21,
  -4.898724416248230093019816e21,
  9.064939236472086851508606e21,
  -1.35506514991189685881795e22,
  1.65074883820324606043553e22,
  -1.645574721283494546067938e22,
  1.34236142839649348657264e22,
  -8.923706257531426259644389e21,
  4.792165138173254085626623e21,
  -2.048572969660974650159333e21,
  6.8122606506919456423926e20,
  -1.699249305414683925105736e20,
  2.992404607530864672335629e19,
  -3.318441509508852319209889e18,
  1.743423984461734634719628e17,
  4.28704863828693589703952e17,
  -8.114408310055641620059186e18,
  7.276379562795810047111551e19,
  -4.108926875516491687100303e20,
  1.638105038740723964958572e21,
  -4.898724416248230093019816e21,
  1.139581446364393005975705e22,
  -2.1102839455920145701479e22,
  3.156793860073221239686902e22,
  -3.848342227843865650618186e22,
  3.838960900405949654627707e22,
  -3.133760905523989438264709e22,
  2.084678281701710205692974e22,
  -1.120263409848485246715121e22,
  4.792165138173254085626623e21,
  -1.594634138634699272813868e21,
  3.98028348686551189914877e20,
  -7.013940818329196715161145e19,
  7.783209840032988701950999e18,
  -4.09174373596179017979601e17,
  -7.90357457095291832489624e17,
  1.497105613877674495787759e19,
  -1.34349984695070426893254e20,
  7.592308502692181443583e20,
  -3.029053840817005494960601e21,
  9.064939236472086851508606e21,
  -2.1102839455920145701479e22,
  3.910634295626263518652569e22,
  -5.854106404093446295069686e22,
  7.1415681953358826304782e22,
  -7.129132229548520350646746e22,
  5.823574220937745950024313e22,
  -3.876692860372681861752816e22,
  2.084678281701710205692974e22,
  -8.923706257531426259644389e21,
  2.971442482989671876069853e21,
  -7.4218360004958502583761e20,
  1.308726630813740848156285e20,
  -1.453227514223321530186452e19,
  7.64486791872366717649255e17,
  1.177157104213401539078995e18,
  -2.231440088650420588947372e19,
  2.003962810424930863187864e20,
  -1.13329406470261710475962e21,
  4.524703528557917837044534e21,
  -1.35506514991189685881795e22,
  3.156793860073221239686902e22,
  -5.854106404093446295069686e22,
  8.7696093018038116193311e22,
  -1.070576503895681522690917e23,
  1.069457784424774229242685e23,
  -8.74214333658809436231311e22,
  5.823574220937745950024313e22,
  -3.133760905523989438264709e22,
  1.34236142839649348657264e22,
  -4.472885672607356758880305e21,
  1.117962116211382877817529e21,
  -1.972690878429716565518849e20,
  2.19198349567660628427385e19,
  -1.153895681027350499498757e18,
  -1.428898280597829012780083e18,
  2.710603979062902561645085e19,
  -2.436030606146390637932257e20,
  1.378625669936159298812678e21,
  -5.508116069717362391812522e21,
  1.65074883820324606043553e22,
  -3.848342227843865650618186e22,
  7.1415681953358826304782e22,
  -1.070576503895681522690917e23,
  1.307852380086941953566378e23,
  -1.307396710689887714464121e23,
  1.069457784424774229242685e23,
  -7.129132229548520350646746e22,
  3.838960900405949654627707e22,
  -1.645574721283494546067938e22,
  5.487011671480079151127116e21,
  -1.372381470609686153082862e21,
  2.423295059816580609886465e20,
  -2.694535918238767577232444e19,
  1.419425909466928353568968e18,
  1.419425909466928353568968e18,
  -2.694535918238767577232444e19,
  2.423295059816580609886465e20,
  -1.372381470609686153082862e21,
  5.487011671480079151127116e21,
  -1.645574721283494546067938e22,
  3.838960900405949654627707e22,
  -7.129132229548520350646746e22,
  1.069457784424774229242685e23,
  -1.307396710689887714464121e23,
  1.307852380086941953566378e23,
  -1.070576503895681522690917e23,
  7.1415681953358826304782e22,
  -3.848342227843865650618186e22,
  1.65074883820324606043553e22,
  -5.508116069717362391812522e21,
  1.378625669936159298812678e21,
  -2.436030606146390637932257e20,
  2.710603979062902561645085e19,
  -1.428898280597829012780083e18,
  -1.153895681027350499498757e18,
  2.19198349567660628427385e19,
  -1.972690878429716565518849e20,
  1.117962116211382877817529e21,
  -4.472885672607356758880305e21,
  1.34236142839649348657264e22,
  -3.133760905523989438264709e22,
  5.823574220937745950024313e22,
  -8.74214333658809436231311e22,
  1.069457784424774229242685e23,
  -1.070576503895681522690917e23,
  8.7696093018038116193311e22,
  -5.854106404093446295069686e22,
  3.156793860073221239686902e22,
  -1.35506514991189685881795e22,
  4.524703528557917837044534e21,
  -1.13329406470261710475962e21,
  2.003962810424930863187864e20,
  -2.231440088650420588947372e19,
  1.177157104213401539078995e18,
  7.64486791872366717649255e17,
  -1.453227514223321530186452e19,
  1.308726630813740848156285e20,
  -7.4218360004958502583761e20,
  2.971442482989671876069853e21,
  -8.923706257531426259644389e21,
  2.084678281701710205692974e22,
  -3.876692860372681861752816e22,
  5.823574220937745950024313e22,
  -7.129132229548520350646746e22,
  7.1415681953358826304782e22,
  -5.854106404093446295069686e22,
  3.910634295626263518652569e22,
  -2.1102839455920145701479e22,
  9.064939236472086851508606e21,
  -3.029053840817005494960601e21,
  7.592308502692181443583e20,
  -1.34349984695070426893254e20,
  1.497105613877674495787759e19,
  -7.90357457095291832489624e17,
  -4.09174373596179017979601e17,
  7.783209840032988701950999e18,
  -7.013940818329196715161145e19,
  3.98028348686551189914877e20,
  -1.594634138634699272813868e21,
  4.792165138173254085626623e21,
  -1.120263409848485246715121e22,
  2.084678281701710205692974e22,
  -3.133760905523989438264709e22,
  3.838960900405949654627707e22,
  -3.848342227843865650618186e22,
  3.156793860073221239686902e22,
  -2.1102839455920145701479e22,
  1.139581446364393005975705e22,
  -4.898724416248230093019816e21,
  1.638105038740723964958572e21,
  -4.108926875516491687100303e20,
  7.276379562795810047111551e19,
  -8.114408310055641620059186e18,
  4.28704863828693589703952e17,
  1.743423984461734634719628e17,
  -3.318441509508852319209889e18,
  2.992404607530864672335629e19,
  -1.699249305414683925105736e20,
  6.8122606506919456423926e20,
  -2.048572969660974650159333e21,
  4.792165138173254085626623e21,
  -8.923706257531426259644389e21,
  1.34236142839649348657264e22,
  -1.645574721283494546067938e22,
  1.65074883820324606043553e22,
  -1.35506514991189685881795e22,
  9.064939236472086851508606e21,
  -4.898724416248230093019816e21,
  2.107356718829485376022324e21,
  -7.05209533419736227081637e20,
  1.770232889043242780206524e20,
  -3.137236901612963684692409e19,
  3.501252755043276759570489e18,
  -1.851247931617859734386911e17,
  -5.778824924273652609636418e16,
  1.100641808524606996309652e18,
  -9.93138884325233395046526e18,
  5.643223818858081605750816e19,
  -2.263834949042899898606286e20,
  6.8122606506919456423926e20,
  -1.594634138634699272813868e21,
  2.971442482989671876069853e21,
  -4.472885672607356758880305e21,
  5.487011671480079151127116e21,
  -5.508116069717362391812522e21,
  4.524703528557917837044534e21,
  -3.029053840817005494960601e21,
  1.638105038740723964958572e21,
  -7.05209533419736227081637e20,
  2.361699672271249414774657e20,
  -5.932920768711240786389383e19,
  1.052259075692483785448004e19,
  -1.175281643840137141200903e18,
  6.219170516030167633772058e16,
  1.436887282161062844446128e16,
  -2.738415061732442395584862e17,
  2.472500551622553850950443e18,
  -1.405821048584831041083993e19,
  5.643223818858081605750816e19,
  -1.699249305414683925105736e20,
  3.98028348686551189914877e20,
  -7.4218360004958502583761e20,
  1.117962116211382877817529e21,
  -1.372381470609686153082862e21,
  1.378625669936159298812678e21,
  -1.13329406470261710475962e21,
  7.592308502692181443583e20,
  -4.108926875516491687100303e20,
  1.770232889043242780206524e20,
  -5.932920768711240786389383e19,
  1.491593640004781666581822e19,
  -2.647583050682989512540678e18,
  2.959518657886997206674375e17,
  -1.56737016762778594701723e16,
  -2.522451050487263333406215e15,
  4.810215167621649729071013e16,
  -4.34580593129383643897495e17,
  2.472500551622553850950443e18,
  -9.93138884325233395046526e18,
  2.992404607530864672335629e19,
  -7.013940818329196715161145e19,
  1.308726630813740848156285e20,
  -1.972690878429716565518849e20,
  2.423295059816580609886465e20,
  -2.436030606146390637932257e20,
  2.003962810424930863187864e20,
  -1.34349984695070426893254e20,
  7.276379562795810047111551e19,
  -3.137236901612963684692409e19,
  1.052259075692483785448004e19,
  -2.647583050682989512540678e18,
  4.703290834685635194696212e17,
  -5.261811848765548217837078e16,
  2.789056221909559171707699e15,
  2.788636380567376023138026e14,
  -5.321011236627165586227186e15,
  4.810215167621649729071013e16,
  -2.738415061732442395584862e17,
  1.100641808524606996309652e18,
  -3.318441509508852319209889e18,
  7.783209840032988701950999e18,
  -1.453227514223321530186452e19,
  2.19198349567660628427385e19,
  -2.694535918238767577232444e19,
  2.710603979062902561645085e19,
  -2.231440088650420588947372e19,
  1.497105613877674495787759e19,
  -8.114408310055641620059186e18,
  3.501252755043276759570489e18,
  -1.175281643840137141200903e18,
  2.959518657886997206674375e17,
  -5.261811848765548217837078e16,
  5.89170950998962415550123e15,
  -3.125699584952214363996735e14,
  -1.460607289834425422135112e13,
  2.788636380567376023138026e14,
  -2.522451050487263333406215e15,
  1.436887282161062844446128e16,
  -5.778824924273652609636418e16,
  1.743423984461734634719628e17,
  -4.09174373596179017979601e17,
  7.64486791872366717649255e17,
  -1.153895681027350499498757e18,
  1.419425909466928353568968e18,
  -1.428898280597829012780083e18,
  1.177157104213401539078995e18,
  -7.90357457095291832489624e17,
  4.28704863828693589703952e17,
  -1.851247931617859734386911e17,
  6.219170516030167633772058e16,
  -1.56737016762778594701723e16,
  2.789056221909559171707699e15,
  -3.125699584952214363996735e14,
  1.659780989895998607840983e13,

  6.496511596591836138804435e13,
  -1.288950738005529068025471e15,
  1.215031435968597564546827e16,
  -7.23542169496215245159155e16,
  3.052613436387308286874293e17,
  -9.69910385000838332284994e17,
  2.408071537648562136049135e18,
  -4.783904919276831486927738e18,
  7.723286671176171732661139e18,
  -1.023265091749762264786818e19,
  1.118683563937686707599989e19,
  -1.010923868817845767351182e19,
  7.538059300458301219030728e18,
  -4.612757575341622301810617e18,
  2.293815585525999108146788e18,
  -9.12680401874844918584156e17,
  2.837529883139446142781176e17,
  -6.643453564358195710952392e16,
  1.101932775353563667505769e16,
  -1.154552007598355003470563e15,
  5.746914127264622566648207e13,
  -1.288950738005529068025471e15,
  2.55936538276434831050661e16,
  -2.414420512392375530421173e17,
  1.438828517048416176354611e18,
  -6.074742345922157702733957e18,
  1.93147999473615888413433e19,
  -4.798691025224482337670347e19,
  9.53945318130279364697056e19,
  -1.54107516592637505139382e20,
  2.043074219552335271365214e20,
  -2.234969106239101381911424e20,
  2.020902228913060475386035e20,
  -1.507799528627226506381457e20,
  9.23202116409002983012535e19,
  -4.593481180973149000375449e19,
  1.828710142438788757652262e19,
  -5.688594254479223805296569e18,
  1.332578074297951676196363e18 - 2.211485989509238838152829e17,
  2.318297719233534691193811e16,
  -1.154552007598355003470563e15,
  1.215031435968597564546827e16,
  -2.414420512392375530421173e17,
  2.279366279249893526490874e18,
  -1.359322808667681773693718e19,
  5.743096423389292497872287e19,
  -1.827283536715017474862984e20,
  4.542858797634152841195376e20,
  -9.03679215154775025995069e20,
  1.460807527650626923410452e21,
  -1.937876146363326663712756e21,
  2.121195680038814024769242e21,
  -1.919184693684534127746422e21,
  1.432756921917570722175582e21,
  -8.77765641087329573238516e20,
  4.369907652969020365385215e20,
  -1.740682638412025254628715e20,
  5.417765024042545325001517e19,
  -1.269827187084978746082081e19,
  2.108479347376760719931399e18,
  -2.211485989509238838152829e17,
  1.101932775353563667505769e16,
  -7.23542169496215245159155e16,
  1.438828517048416176354611e18,
  -1.359322808667681773693718e19,
  8.11215955153656210176085e19,
  -3.429721327772027935410962e20,
  1.091971602496275162589579e21,
  -2.716573707333110630431996e21,
  5.407392461023628291671443e21,
  -8.746669580972039234945013e21,
  1.161039286867673030619577e22,
  -1.271651505435535626720189e22,
  1.151240762906599961041908e22,
  -8.599628033383787075088929e21,
  5.27156359574291438753086e21,
  -2.625929155144876473237384e21,
  1.046589924981257732988251e21,
  -3.259266184071743565537089e20,
  7.64334869901452924947704e19,
  -1.269827187084978746082081e19,
  1.332578074297951676196363e18,
  -6.643453564358195710952392e16,
  3.052613436387308286874293e17,
  -6.074742345922157702733957e18,
  5.743096423389292497872287e19,
  -3.429721327772027935410962e20,
  1.451023745591946553822272e21,
  -4.622906893429499528755454e21,
  1.150822815529141858827471e22,
  -2.292204337537454713822096e22,
  3.710070479741037919227124e22,
  -4.927834380841297933958992e22,
  5.400612239711492273133138e22,
  -4.892185146666178139932811e22,
  3.656575562284067133142591e22,
  -2.242791933755296870599148e22,
  1.117850798936900142132061e22,
  -4.457850429353289586241369e21,
  1.389037062145247279541515e21,
  -3.259266184071743565537089e20,
  5.417765024042545325001517e19,
  -5.688594254479223805296569e18,
  2.837529883139446142781176e17,
  -9.69910385000838332284994e17,
  1.93147999473615888413433e19,
  -1.827283536715017474862984e20,
  1.091971602496275162589579e21,
  -4.622906893429499528755454e21,
  1.473803408814518022658143e22,
  -3.671237930250940655653395e22,
  7.317001223578601906488863e22,
  -1.185042540010062292961934e23,
  1.574984532045768861821788e23,
  -1.727142548238805712394157e23,
  1.56548824426305954057677e23,
  -1.170792969857552999452602e23,
  7.185387509720713339819124e22,
  -3.583421280375830472781161e22,
  1.429847196712168609484685e22,
  -4.457850429353289586241369e21,
  1.046589924981257732988251e21,
  -1.740682638412025254628715e20,
  1.828710142438788757652262e19,
  -9.12680401874844918584156e17,
  2.408071537648562136049135e18,
  -4.798691025224482337670347e19,
  4.542858797634152841195376e20,
  -2.716573707333110630431996e21,
  1.150822815529141858827471e22,
  -3.671237930250940655653395e22,
  9.15085804268293286808625e22,
  -1.824969166266505823693547e23,
  2.957511289046894056918661e23,
  -3.933108399256643756824736e23,
  4.315709212376680824786492e23,
  -3.914132383595245781039121e23,
  2.929037769416298320186187e23,
  -1.798671277531295944846297e23,
  8.97540171681163347243745e22,
  -3.583421280375830472781161e22,
  1.117850798936900142132061e22,
  -2.625929155144876473237384e21,
  4.369907652969020365385215e20,
  -4.593481180973149000375449e19,
  2.293815585525999108146788e18,
  -4.783904919276831486927738e18,
  9.53945318130279364697056e19,
  -9.03679215154775025995069e20,
  5.407392461023628291671443e21,
  -2.292204337537454713822096e22,
  7.317001223578601906488863e22,
  -1.824969166266505823693547e23,
  3.641831676787587508271457e23,
  -5.905531565015814834012155e23,
  7.85840624786714274927682e23,
  -8.62808758507768454244663e23,
  7.82996146193424540037047e23,
  -5.862851049847708736684689e23,
  3.602413718134538688871834e23,
  -1.798671277531295944846297e23,
  7.185387509720713339819124e22,
  -2.242791933755296870599148e22,
  5.27156359574291438753086e21,
  -8.77765641087329573238516e20,
  9.23202116409002983012535e19,
  -4.612757575341622301810617e18,
  7.723286671176171732661139e18,
  -1.54107516592637505139382e20,
  1.460807527650626923410452e21,
  -8.746669580972039234945013e21,
  3.710070479741037919227124e22,
  -1.185042540010062292961934e23,
  2.957511289046894056918661e23,
  -5.905531565015814834012155e23,
  9.58218692094404229705836e23,
  -1.27586579850606257132289e24,
  1.401678410285746993106862e24,
  -1.272785763927146831418856e24,
  9.53597265547873395247993e23,
  -5.862851049847708736684689e23,
  2.929037769416298320186187e23,
  -1.170792969857552999452602e23,
  3.656575562284067133142591e22,
  -8.599628033383787075088929e21,
  1.432756921917570722175582e21,
  -1.507799528627226506381457e20,
  7.538059300458301219030728e18,
  -1.023265091749762264786818e19,
  2.043074219552335271365214e20,
  -1.937876146363326663712756e21,
  1.161039286867673030619577e22,
  -4.927834380841297933958992e22,
  1.574984532045768861821788e23,
  -3.933108399256643756824736e23,
  7.85840624786714274927682e23,
  -1.27586579850606257132289e24,
  1.699844532891693190081969e24,
  -1.868596309737324336096837e24,
  1.697791768815146533703889e24,
  -1.272785763927146831418856e24,
  7.82996146193424540037047e23,
  -3.914132383595245781039121e23,
  1.56548824426305954057677e23,
  -4.892185146666178139932811e22,
  1.151240762906599961041908e22,
  -1.919184693684534127746422e21,
  2.020902228913060475386035e20,
  -1.010923868817845767351182e19,
  1.118683563937686707599989e19,
  -2.234969106239101381911424e20,
  2.121195680038814024769242e21,
  -1.271651505435535626720189e22,
  5.400612239711492273133138e22,
  -1.727142548238805712394157e23,
  4.315709212376680824786492e23,
  -8.62808758507768454244663e23,
  1.401678410285746993106862e24,
  -1.868596309737324336096837e24,
  2.055342997195489250375921e24,
  -1.868596309737324336096837e24,
  1.401678410285746993106862e24,
  -8.62808758507768454244663e23,
  4.315709212376680824786492e23,
  -1.727142548238805712394157e23,
  5.400612239711492273133138e22,
  -1.271651505435535626720189e22,
  2.121195680038814024769242e21,
  -2.234969106239101381911424e20,
  1.118683563937686707599989e19,
  -1.010923868817845767351182e19,
  2.020902228913060475386035e20,
  -1.919184693684534127746422e21,
  1.151240762906599961041908e22,
  -4.892185146666178139932811e22,
  1.56548824426305954057677e23,
  -3.914132383595245781039121e23,
  7.82996146193424540037047e23,
  -1.272785763927146831418856e24,
  1.697791768815146533703889e24,
  -1.868596309737324336096837e24,
  1.699844532891693190081969e24,
  -1.27586579850606257132289e24,
  7.85840624786714274927682e23,
  -3.933108399256643756824736e23,
  1.574984532045768861821788e23,
  -4.927834380841297933958992e22,
  1.161039286867673030619577e22,
  -1.937876146363326663712756e21,
  2.043074219552335271365214e20,
  -1.023265091749762264786818e19,
  7.538059300458301219030728e18,
  -1.507799528627226506381457e20,
  1.432756921917570722175582e21,
  -8.599628033383787075088929e21,
  3.656575562284067133142591e22,
  -1.170792969857552999452602e23,
  2.929037769416298320186187e23,
  -5.862851049847708736684689e23,
  9.53597265547873395247993e23,
  -1.272785763927146831418856e24,
  1.401678410285746993106862e24,
  -1.27586579850606257132289e24,
  9.58218692094404229705836e23,
  -5.905531565015814834012155e23,
  2.957511289046894056918661e23,
  -1.185042540010062292961934e23,
  3.710070479741037919227124e22,
  -8.746669580972039234945013e21,
  1.460807527650626923410452e21,
  -1.54107516592637505139382e20,
  7.723286671176171732661139e18,
  -4.612757575341622301810617e18,
  9.23202116409002983012535e19,
  -8.77765641087329573238516e20,
  5.27156359574291438753086e21,
  -2.242791933755296870599148e22,
  7.185387509720713339819124e22,
  -1.798671277531295944846297e23,
  3.602413718134538688871834e23,
  -5.862851049847708736684689e23,
  7.82996146193424540037047e23,
  -8.62808758507768454244663e23,
  7.85840624786714274927682e23,
  -5.905531565015814834012155e23,
  3.641831676787587508271457e23,
  -1.824969166266505823693547e23,
  7.317001223578601906488863e22,
  -2.292204337537454713822096e22,
  5.407392461023628291671443e21,
  -9.03679215154775025995069e20,
  9.53945318130279364697056e19,
  -4.783904919276831486927738e18,
  2.293815585525999108146788e18,
  -4.593481180973149000375449e19,
  4.369907652969020365385215e20,
  -2.625929155144876473237384e21,
  1.117850798936900142132061e22,
  -3.583421280375830472781161e22,
  8.97540171681163347243745e22,
  -1.798671277531295944846297e23,
  2.929037769416298320186187e23,
  -3.914132383595245781039121e23,
  4.315709212376680824786492e23,
  -3.933108399256643756824736e23,
  2.957511289046894056918661e23,
  -1.824969166266505823693547e23,
  9.15085804268293286808625e22,
  -3.671237930250940655653395e22,
  1.150822815529141858827471e22,
  -2.716573707333110630431996e21,
  4.542858797634152841195376e20,
  -4.798691025224482337670347e19,
  2.408071537648562136049135e18,
  -9.12680401874844918584156e17,
  1.828710142438788757652262e19,
  -1.740682638412025254628715e20,
  1.046589924981257732988251e21,
  -4.457850429353289586241369e21,
  1.429847196712168609484685e22,
  -3.583421280375830472781161e22,
  7.185387509720713339819124e22,
  -1.170792969857552999452602e23,
  1.56548824426305954057677e23,
  -1.727142548238805712394157e23,
  1.574984532045768861821788e23,
  -1.185042540010062292961934e23,
  7.317001223578601906488863e22,
  -3.671237930250940655653395e22,
  1.473803408814518022658143e22,
  -4.622906893429499528755454e21,
  1.091971602496275162589579e21,
  -1.827283536715017474862984e20,
  1.93147999473615888413433e19,
  -9.69910385000838332284994e17,
  2.837529883139446142781176e17,
  -5.688594254479223805296569e18,
  5.417765024042545325001517e19,
  -3.259266184071743565537089e20,
  1.389037062145247279541515e21,
  -4.457850429353289586241369e21,
  1.117850798936900142132061e22,
  -2.242791933755296870599148e22,
  3.656575562284067133142591e22,
  -4.892185146666178139932811e22,
  5.400612239711492273133138e22,
  -4.927834380841297933958992e22,
  3.710070479741037919227124e22,
  -2.292204337537454713822096e22,
  1.150822815529141858827471e22,
  -4.622906893429499528755454e21,
  1.451023745591946553822272e21,
  -3.429721327772027935410962e20,
  5.743096423389292497872287e19,
  -6.074742345922157702733957e18,
  3.052613436387308286874293e17,
  -6.643453564358195710952392e16,
  1.332578074297951676196363e18,
  -1.269827187084978746082081e19,
  7.64334869901452924947704e19,
  -3.259266184071743565537089e20,
  1.046589924981257732988251e21,
  -2.625929155144876473237384e21,
  5.27156359574291438753086e21,
  -8.599628033383787075088929e21,
  1.151240762906599961041908e22,
  -1.271651505435535626720189e22,
  1.161039286867673030619577e22,
  -8.746669580972039234945013e21,
  5.407392461023628291671443e21,
  -2.716573707333110630431996e21,
  1.091971602496275162589579e21,
  -3.429721327772027935410962e20,
  8.11215955153656210176085e19,
  -1.359322808667681773693718e19,
  1.438828517048416176354611e18,
  -7.23542169496215245159155e16,
  1.101932775353563667505769e16,
  -2.211485989509238838152829e17,
  2.108479347376760719931399e18,
  -1.269827187084978746082081e19,
  5.417765024042545325001517e19,
  -1.740682638412025254628715e20,
  4.369907652969020365385215e20,
  -8.77765641087329573238516e20,
  1.432756921917570722175582e21,
  -1.919184693684534127746422e21,
  2.121195680038814024769242e21,
  -1.937876146363326663712756e21,
  1.460807527650626923410452e21,
  -9.03679215154775025995069e20,
  4.542858797634152841195376e20,
  -1.827283536715017474862984e20,
  5.743096423389292497872287e19,
  -1.359322808667681773693718e19,
  2.279366279249893526490874e18,
  -2.414420512392375530421173e17,
  1.215031435968597564546827e16,
  -1.154552007598355003470563e15,
  2.318297719233534691193811e16,
  -2.211485989509238838152829e17,
  1.332578074297951676196363e18,
  -5.688594254479223805296569e18,
  1.828710142438788757652262e19,
  -4.593481180973149000375449e19,
  9.23202116409002983012535e19,
  -1.507799528627226506381457e20,
  2.020902228913060475386035e20,
  -2.234969106239101381911424e20,
  2.043074219552335271365214e20,
  -1.54107516592637505139382e20,
  9.53945318130279364697056e19,
  -4.798691025224482337670347e19,
  1.93147999473615888413433e19,
  -6.074742345922157702733957e18,
  1.438828517048416176354611e18,
  -2.414420512392375530421173e17,
  2.55936538276434831050661e16,
  -1.288950738005529068025471e15,
  5.746914127264622566648207e13,
  -1.154552007598355003470563e15,
  1.101932775353563667505769e16,
  -6.643453564358195710952392e16,
  2.837529883139446142781176e17,
  -9.12680401874844918584156e17,
  2.293815585525999108146788e18,
  -4.612757575341622301810617e18,
  7.538059300458301219030728e18,
  -1.010923868817845767351182e19,
  1.118683563937686707599989e19,
  -1.023265091749762264786818e19,
  7.723286671176171732661139e18,
  -4.783904919276831486927738e18,
  2.408071537648562136049135e18,
  -9.69910385000838332284994e17,
  3.052613436387308286874293e17,
  -7.23542169496215245159155e16,
  1.215031435968597564546827e16,
  -1.288950738005529068025471e15,
  6.496511596591836138804435e13,

  2.545151522781942036441328e14,
  -5.30625529982123820050715e15,
  5.268983075615018456770515e16,
  -3.314197284827155042988239e17,
  1.481453429413100220990967e18,
  -5.004257075261915587453697e18,
  1.326033354807269046091651e19,
  -2.824003532908534593254543e19,
  4.912364042053934313993436e19,
  -7.054183020172744618406722e19,
  8.41685634118782972976469e19,
  -8.37022503465384697473027e19,
  6.937566690671276138264798e19,
  -4.777718739217838694847346e19,
  2.716181366030319183873892e19,
  -1.261254947159072513395332e19,
  4.706865698350448965238259e18,
  -1.377876142745100180974124e18,
  3.047993255159331904973577e17,
  -4.791334995764022694935919e16,
  4.770781864568600513926535e15,
  -2.262356911841254572097669e14,
  -5.30625529982123820050715e15,
  1.107019901366334236413424e17,
  -1.099964824252183853070347e18,
  6.923210508053318772436286e18,
  -3.096615951623687528077407e19,
  1.046652555950281133062438e20,
  -2.775075336916513705942237e20,
  5.91339852461918670460234e20,
  -1.02922078904462642053566e21,
  1.478787031275939492183496e21,
  -1.765406884438168420034278e21,
  1.756561537362769127492807e21,
  -1.456667122893340833250301e21,
  1.003682698750040736033779e21,
  -5.708911866710427363873902e20,
  2.652237221174801467913308e20,
  -9.90267610741866015062925e19,
  2.900272321562472403919292e19,
  -6.418700813537427668749927e18,
  1.009464516628488349178569e18,
  -1.005593531414488023026192e17,
  4.770781864568600513926535e15,
  5.268983075615018456770515e16,
  -1.099964824252183853070347e18,
  1.093654010228281261410325e19,
  -6.887791395265143515432052e19,
  3.082655494098064236632815e20,
  -1.042556582730021573870103e21,
  2.765832648630929431143632e21,
  -5.897081927159826778608215e21,
  1.026957782638630102487296e22,
  -1.476349176982018100038208e22,
  1.763450591356792666744666e22,
  -1.755547986010565563320529e22,
  1.456587364248468825444839e22,
  -1.004143442986245837975184e22,
  5.714419856858134735741063e21,
  -2.656117098523175165998175e21,
  9.92202191309137041291814e20,
  -2.907341177058963376000099e20,
  6.437406991631031799645793e19,
  -1.012881497882446552124409e19,
  1.009464516628488349178569e18,
  -4.791334995764022694935919e16,
  -3.314197284827155042988239e17,
  6.923210508053318772436286e18,
  -6.887791395265143515432052e19,
  4.340559980203950475237804e20,
  -1.943798571516913199107719e21,
  6.577811420491724900714889e21,
  -1.746057265408890788328463e22,
  3.724912412380800584546556e22,
  -6.490431208829469544080673e22,
  9.33572487950888341046236e22,
  -1.115722991403662546314943e23,
  1.111312572333066376163792e23,
  -9.22543751810894422534287e22,
  6.363114431032079823298291e22,
  -3.622984256023102650730259e22,
  1.684840383202832468580541e22,
  -6.296888862464372739178351e21,
  1.846006939332721195988894e21,
  -4.089376396010402868729563e20,
  6.437406991631031799645793e19,
  -6.418700813537427668749927e18,
  3.047993255159331904973577e17,
  1.481453429413100220990967e18,
  -3.096615951623687528077407e19,
  3.082655494098064236632815e20,
  -1.943798571516913199107719e21,
  8.709892105423369638132222e21,
  -2.94913534062055024645092e22,
  7.83284418978664144778261e22,
  -1.671940926889217098797428e23,
  2.91486596664441959486213e23,
  -4.194978486746647355640174e23,
  5.016159831227330725187201e23,
  -4.998978660309050716002568e23,
  4.152016001002674935677001e23,
  -2.865271779872895225649511e23,
  1.632239011994162788679382e23,
  -7.59441949834594144631342e22,
  2.839734704982516195649895e22,
  -8.329108309033556973924691e21,
  1.846006939332721195988894e21,
  -2.907341177058963376000099e20,
  2.900272321562472403919292e19,
  -1.377876142745100180974124e18,
  -5.004257075261915587453697e18,
  1.046652555950281133062438e20,
  -1.042556582730021573870103e21,
  6.577811420491724900714889e21,
  -2.94913534062055024645092e22,
  9.99136494528509155703686e22,
  -2.655182511104207384569407e23,
  5.670708507001175629989329e23,
  -9.89175520255975365532115e23,
  1.424360393306288156708647e24,
  -1.704095884938477659621673e24,
  1.699157765797593771280853e24,
  -1.412012573025819803485923e24,
  9.74922206707328161715873e23,
  -5.5566119020651201387255e23,
  2.586668297913814996639808e23,
  -9.67701791317245718825366e22,
  2.839734704982516195649895e22,
  -6.296888862464372739178351e21,
  9.92202191309137041291814e20,
  -9.90267610741866015062925e19,
  4.706865698350448965238259e18,
  1.326033354807269046091651e19,
  -2.775075336916513705942237e20,
  2.765832648630929431143632e21,
  -1.746057265408890788328463e22,
  7.83284418978664144778261e22,
  -2.655182511104207384569407e23,
  7.06001926223158397072769e23,
  -1.508648544304089530513043e24,
  2.633060088765568426570965e24,
  -3.793512065334994577006546e24,
  4.540957061278993321289237e24,
  -4.530191616389777826472677e24,
  3.766593361662072947026129e24,
  -2.601988281443157327678216e24,
  1.483776950492738292132594e24,
  -6.91067617246429310328649e23,
  2.586668297913814996639808e23,
  -7.59441949834594144631342e22,
  1.684840383202832468580541e22,
  -2.656117098523175165998175e21,
  2.652237221174801467913308e20,
  -1.261254947159072513395332e19,
  -2.824003532908534593254543e19,
  5.91339852461918670460234e20,
  -5.897081927159826778608215e21,
  3.724912412380800584546556e22,
  -1.671940926889217098797428e23,
  5.670708507001175629989329e23,
  -1.508648544304089530513043e24,
  3.225576561722959540857019e24,
  -5.632679726011553687060084e24,
  8.119490543932221371086942e24,
  -9.72446734727667331530411e24,
  9.70653640454423177053944e24,
  -8.074655249068615464372654e24,
  5.580928351453156144648535e24,
  -3.184153404425872706935997e24,
  1.483776950492738292132594e24,
  -5.5566119020651201387255e23,
  1.632239011994162788679382e23 - 3.622984256023102650730259e22,
  5.714419856858134735741063e21,
  -5.708911866710427363873902e20,
  2.716181366030319183873892e19,
  4.912364042053934313993436e19,
  -1.02922078904462642053566e21,
  1.026957782638630102487296e22,
  -6.490431208829469544080673e22,
  2.91486596664441959486213e23,
  -9.89175520255975365532115e23,
  2.633060088765568426570965e24,
  -5.632679726011553687060084e24,
  9.84138449431430701382541e24,
  -1.419390378023339249933254e25,
  1.700863246742445789307702e25,
  -1.698622950496748122198399e25,
  1.413788696384177489525341e25,
  -9.77672796225346848908501e24,
  5.580928351453156144648535e24,
  -2.601988281443157327678216e24,
  9.74922206707328161715873e23,
  -2.865271779872895225649511e23,
  6.363114431032079823298291e22,
  -1.004143442986245837975184e22,
  1.003682698750040736033779e21,
  -4.777718739217838694847346e19,
  -7.054183020172744618406722e19,
  1.478787031275939492183496e21,
  -1.476349176982018100038208e22,
  9.33572487950888341046236e22,
  -4.194978486746647355640174e23,
  1.424360393306288156708647e24,
  -3.793512065334994577006546e24,
  8.119490543932221371086942e24,
  -1.419390378023339249933254e25,
  2.048228563774802670699915e25,
  -2.455703267021814375597418e25,
  2.453762294740740831989306e25,
  -2.043375347067418062359178e25,
  1.413788696384177489525341e25,
  -8.074655249068615464372654e24,
  3.766593361662072947026129e24,
  -1.412012573025819803485923e24,
  4.152016001002674935677001e23,
  -9.22543751810894422534287e22,
  1.456587364248468825444839e22,
  -1.456667122893340833250301e21,
  6.937566690671276138264798e19,
  8.41685634118782972976469e19,
  -1.765406884438168420034278e21,
  1.763450591356792666744666e22,
  -1.115722991403662546314943e23,
  5.016159831227330725187201e23,
  -1.704095884938477659621673e24,
  4.540957061278993321289237e24,
  -9.72446734727667331530411e24,
  1.700863246742445789307702e25,
  -2.455703267021814375597418e25,
  2.945796681462772431089503e25,
  -2.945020415949407616932544e25,
  2.453762294740740831989306e25,
  -1.698622950496748122198399e25,
  9.70653640454423177053944e24,
  -4.530191616389777826472677e24,
  1.699157765797593771280853e24,
  -4.998978660309050716002568e23,
  1.111312572333066376163792e23,
  -1.755547986010565563320529e22,
  1.756561537362769127492807e21,
  -8.37022503465384697473027e19,
  -8.37022503465384697473027e19,
  1.756561537362769127492807e21,
  -1.755547986010565563320529e22,
  1.111312572333066376163792e23,
  -4.998978660309050716002568e23,
  1.699157765797593771280853e24,
  -4.530191616389777826472677e24,
  9.70653640454423177053944e24,
  -1.698622950496748122198399e25,
  2.453762294740740831989306e25,
  -2.945020415949407616932544e25,
  2.945796681462772431089503e25,
  -2.455703267021814375597418e25,
  1.700863246742445789307702e25,
  -9.72446734727667331530411e24,
  4.540957061278993321289237e24,
  -1.704095884938477659621673e24,
  5.016159831227330725187201e23,
  -1.115722991403662546314943e23,
  1.763450591356792666744666e22,
  -1.765406884438168420034278e21,
  8.41685634118782972976469e19,
  6.937566690671276138264798e19,
  -1.456667122893340833250301e21,
  1.456587364248468825444839e22,
  -9.22543751810894422534287e22,
  4.152016001002674935677001e23,
  -1.412012573025819803485923e24,
  3.766593361662072947026129e24,
  -8.074655249068615464372654e24,
  1.413788696384177489525341e25,
  -2.043375347067418062359178e25,
  2.453762294740740831989306e25,
  -2.455703267021814375597418e25,
  2.048228563774802670699915e25,
  -1.419390378023339249933254e25,
  8.119490543932221371086942e24,
  -3.793512065334994577006546e24,
  1.424360393306288156708647e24,
  -4.194978486746647355640174e23,
  9.33572487950888341046236e22,
  -1.476349176982018100038208e22,
  1.478787031275939492183496e21,
  -7.054183020172744618406722e19,
  -4.777718739217838694847346e19,
  1.003682698750040736033779e21,
  -1.004143442986245837975184e22,
  6.363114431032079823298291e22,
  -2.865271779872895225649511e23,
  9.74922206707328161715873e23,
  -2.601988281443157327678216e24,
  5.580928351453156144648535e24,
  -9.77672796225346848908501e24,
  1.413788696384177489525341e25,
  -1.698622950496748122198399e25,
  1.700863246742445789307702e25,
  -1.419390378023339249933254e25,
  9.84138449431430701382541e24,
  -5.632679726011553687060084e24,
  2.633060088765568426570965e24,
  -9.89175520255975365532115e23,
  2.91486596664441959486213e23 - 6.490431208829469544080673e22,
  1.026957782638630102487296e22,
  -1.02922078904462642053566e21,
  4.912364042053934313993436e19,
  2.716181366030319183873892e19,
  -5.708911866710427363873902e20,
  5.714419856858134735741063e21,
  -3.622984256023102650730259e22,
  1.632239011994162788679382e23,
  -5.5566119020651201387255e23,
  1.483776950492738292132594e24,
  -3.184153404425872706935997e24,
  5.580928351453156144648535e24,
  -8.074655249068615464372654e24,
  9.70653640454423177053944e24,
  -9.72446734727667331530411e24,
  8.119490543932221371086942e24,
  -5.632679726011553687060084e24,
  3.225576561722959540857019e24,
  -1.508648544304089530513043e24,
  5.670708507001175629989329e23,
  -1.671940926889217098797428e23,
  3.724912412380800584546556e22,
  -5.897081927159826778608215e21,
  5.91339852461918670460234e20,
  -2.824003532908534593254543e19,
  -1.261254947159072513395332e19,
  2.652237221174801467913308e20,
  -2.656117098523175165998175e21,
  1.684840383202832468580541e22,
  -7.59441949834594144631342e22,
  2.586668297913814996639808e23,
  -6.91067617246429310328649e23,
  1.483776950492738292132594e24,
  -2.601988281443157327678216e24,
  3.766593361662072947026129e24,
  -4.530191616389777826472677e24,
  4.540957061278993321289237e24,
  -3.793512065334994577006546e24,
  2.633060088765568426570965e24,
  -1.508648544304089530513043e24,
  7.06001926223158397072769e23,
  -2.655182511104207384569407e23,
  7.83284418978664144778261e22,
  -1.746057265408890788328463e22,
  2.765832648630929431143632e21,
  -2.775075336916513705942237e20,
  1.326033354807269046091651e19,
  4.706865698350448965238259e18,
  -9.90267610741866015062925e19,
  9.92202191309137041291814e20,
  -6.296888862464372739178351e21,
  2.839734704982516195649895e22,
  -9.67701791317245718825366e22,
  2.586668297913814996639808e23,
  -5.5566119020651201387255e23,
  9.74922206707328161715873e23,
  -1.412012573025819803485923e24,
  1.699157765797593771280853e24,
  -1.704095884938477659621673e24,
  1.424360393306288156708647e24,
  -9.89175520255975365532115e23,
  5.670708507001175629989329e23,
  -2.655182511104207384569407e23,
  9.99136494528509155703686e22,
  -2.94913534062055024645092e22,
  6.577811420491724900714889e21,
  -1.042556582730021573870103e21,
  1.046652555950281133062438e20,
  -5.004257075261915587453697e18,
  -1.377876142745100180974124e18,
  2.900272321562472403919292e19,
  -2.907341177058963376000099e20,
  1.846006939332721195988894e21,
  -8.329108309033556973924691e21,
  2.839734704982516195649895e22,
  -7.59441949834594144631342e22,
  1.632239011994162788679382e23,
  -2.865271779872895225649511e23,
  4.152016001002674935677001e23,
  -4.998978660309050716002568e23,
  5.016159831227330725187201e23,
  -4.194978486746647355640174e23,
  2.91486596664441959486213e23,
  -1.671940926889217098797428e23,
  7.83284418978664144778261e22,
  -2.94913534062055024645092e22,
  8.709892105423369638132222e21,
  -1.943798571516913199107719e21,
  3.082655494098064236632815e20,
  -3.096615951623687528077407e19,
  1.481453429413100220990967e18,
  3.047993255159331904973577e17,
  -6.418700813537427668749927e18,
  6.437406991631031799645793e19,
  -4.089376396010402868729563e20,
  1.846006939332721195988894e21,
  -6.296888862464372739178351e21,
  1.684840383202832468580541e22,
  -3.622984256023102650730259e22,
  6.363114431032079823298291e22,
  -9.22543751810894422534287e22,
  1.111312572333066376163792e23,
  -1.115722991403662546314943e23,
  9.33572487950888341046236e22,
  -6.490431208829469544080673e22,
  3.724912412380800584546556e22,
  -1.746057265408890788328463e22,
  6.577811420491724900714889e21,
  -1.943798571516913199107719e21,
  4.340559980203950475237804e20,
  -6.887791395265143515432052e19,
  6.923210508053318772436286e18,
  -3.314197284827155042988239e17,
  -4.791334995764022694935919e16,
  1.009464516628488349178569e18,
  -1.012881497882446552124409e19,
  6.437406991631031799645793e19,
  -2.907341177058963376000099e20,
  9.92202191309137041291814e20,
  -2.656117098523175165998175e21,
  5.714419856858134735741063e21,
  -1.004143442986245837975184e22,
  1.456587364248468825444839e22,
  -1.755547986010565563320529e22,
  1.763450591356792666744666e22,
  -1.476349176982018100038208e22,
  1.026957782638630102487296e22,
  -5.897081927159826778608215e21,
  2.765832648630929431143632e21,
  -1.042556582730021573870103e21,
  3.082655494098064236632815e20,
  -6.887791395265143515432052e19,
  1.093654010228281261410325e19,
  -1.099964824252183853070347e18,
  5.268983075615018456770515e16,
  4.770781864568600513926535e15,
  -1.005593531414488023026192e17,
  1.009464516628488349178569e18,
  -6.418700813537427668749927e18,
  2.900272321562472403919292e19,
  -9.90267610741866015062925e19,
  2.652237221174801467913308e20,
  -5.708911866710427363873902e20,
  1.003682698750040736033779e21,
  -1.456667122893340833250301e21,
  1.756561537362769127492807e21,
  -1.765406884438168420034278e21,
  1.478787031275939492183496e21,
  -1.02922078904462642053566e21,
  5.91339852461918670460234e20,
  -2.775075336916513705942237e20,
  1.046652555950281133062438e20,
  -3.096615951623687528077407e19,
  6.923210508053318772436286e18,
  -1.099964824252183853070347e18,
  1.107019901366334236413424e17,
  -5.30625529982123820050715e15,
  -2.262356911841254572097669e14,
  4.770781864568600513926535e15,
  -4.791334995764022694935919e16,
  3.047993255159331904973577e17,
  -1.377876142745100180974124e18,
  4.706865698350448965238259e18,
  -1.261254947159072513395332e19,
  2.716181366030319183873892e19,
  -4.777718739217838694847346e19,
  6.937566690671276138264798e19,
  -8.37022503465384697473027e19,
  8.41685634118782972976469e19,
  -7.054183020172744618406722e19,
  4.912364042053934313993436e19,
  -2.824003532908534593254543e19,
  1.326033354807269046091651e19,
  -5.004257075261915587453697e18,
  1.481453429413100220990967e18,
  -3.314197284827155042988239e17,
  5.268983075615018456770515e16,
  -5.30625529982123820050715e15,
  2.545151522781942036441328e14,

  9.97968964752745276301212e14,
  -2.181120059306095022991318e16,
  2.275506084750259792986743e17,
  -1.507519669159281868188423e18,
  7.117016841228088938691528e18,
  -2.546861047358108320256935e19,
  7.174132627104822323218871e19,
  -1.630489640280949334699262e20,
  3.040218937712636141233471e20,
  -4.703633889976864261942915e20,
  6.08242004547283758398413e20,
  -6.60115412585193292536534e20,
  6.02061143641734764111656e20,
  -4.608504632447382171220113e20,
  2.948424202323130736521479e20,
  -1.56515051917918034475047e20,
  6.816365460627030749921607e19,
  -2.395105174128890315655387e19,
  6.624325248782939629581095e18,
  -1.388728361275345749541586e18,
  2.07456546424951263928487e17,
  -1.967910797975516439767751e16,
  8.91043718849938616922e14,
  -2.181120059306095022991318e16,
  4.769755727394188650102058e17,
  -4.979001588796241870242807e18,
  3.300418498075076544388477e19,
  -1.558978767089385985354224e20,
  5.581852809821975009322089e20,
  -1.573144024701478897897028e21,
  3.577160129623937641531009e21,
  -6.673320682926244770477462e21,
  1.032959305243471356302803e22,
  -1.336394419892045356841942e22,
  1.451051517134545383403778e22,
  -1.324050721515730212236408e22,
  1.013961895174451214980927e22,
  -6.490016973213691911606248e21,
  3.446696615179825069726598e21,
  -1.501716183942478425568933e21,
  5.278915659262480849911991e20,
  -1.460643200716912208665761e20,
  3.063370279476763791329126e19,
  -4.578112688326909153188215e18,
  4.344496428296447623654838e17,
  -1.967910797975516439767751e16,
  2.275506084750259792986743e17,
  -4.979001588796241870242807e18,
  5.200326458047276978543584e19,
  -3.449009599365158671245671e20,
  1.630038087825899741562221e21,
  -5.8393360097705339176415e21,
  1.646556791718480264185949e22,
  -3.74598110478132509075286e22,
  6.991722726552370459738565e22,
  -1.082771041789136511695499e23,
  1.401508330237335360449177e23,
  -1.522467484779164012551638e23,
  1.389858825871832511043601e23,
  -1.064842619156884472191212e23,
  6.818743171926312378745496e22,
  -3.622875269034671912953384e22,
  1.579164035061848168162916e22,
  -5.553547813987716121893014e21,
  1.537282915858274908507669e21,
  -3.225452008183216070316367e20,
  4.822327054223435608598976e19,
  -4.578112688326909153188215e18,
  2.07456546424951263928487e17,
  -1.507519669159281868188423e18,
  3.300418498075076544388477e19,
  -3.449009599365158671245671e20,
  2.288710049593490291355671e21,
  -1.082237204101998728308878e22,
  3.87893471071290873577176e22,
  -1.094324614332891405105506e23,
  2.490874328098080635141729e23,
  -4.651400221577930525746574e23,
  7.20685981000853770745154e23,
  -9.33279769149977390734794e23,
  1.014303336074941502062711e24,
  -9.26384410820953730786871e23,
  7.10074437210927785120602e23,
  -4.549021496732344506536559e23,
  2.418018663796479987661344e23,
  -1.054444275782798448278571e23,
  3.709835373812136256618904e22,
  -1.027361681553579604407409e22,
  2.156469820070080052266635e21,
  -3.225452008183216070316367e20,
  3.063370279476763791329126e19,
  -1.388728361275345749541586e18,
  7.117016841228088938691528e18,
  -1.558978767089385985354224e20,
  1.630038087825899741562221e21,
  -1.082237204101998728308878e22,
  5.120104515004406593726935e22,
  -1.836073381099275249679801e23,
  5.182527301198832977285138e23,
  -1.180217161291809799658582e24,
  2.204983998575493799299137e24,
  -3.418034992014504751073432e24,
  4.428413562750582885367252e24,
  -4.815122833970428519275322e24,
  4.399784079790133754107262e24,
  -3.373977083122952114622982e24,
  2.162479385355931609609248e24,
  -1.149971501254446186686466e24,
  5.016979182100765761915762e23,
  -1.76588500774936059114546e23,
  4.892357929442122117853482e22,
  -1.027361681553579604407409e22,
  1.537282915858274908507669e21,
  -1.460643200716912208665761e20,
  6.624325248782939629581095e18,
  -2.546861047358108320256935e19,
  5.581852809821975009322089e20,
  -5.8393360097705339176415e21,
  3.87893471071290873577176e22,
  -1.836073381099275249679801e23,
  6.58748248187976572528988e23,
  -1.860314724528526834720655e24,
  4.238570458618960828997243e24,
  -7.922695413945882922252865e24,
  1.2287160774814202869019e25,
  -1.59267919826482501431692e25,
  1.732567960037021853055253e25,
  -1.583852766034141499616904e25,
  1.215133388775982515204266e25,
  -7.791662153698116766357685e24,
  4.145334046792305637367689e24,
  -1.809285720915770115793953e24,
  6.37115004213149912482631e23,
  -1.76588500774936059114546e23,
  3.709835373812136256618904e22,
  -5.553547813987716121893014e21,
  5.278915659262480849911991e20,
  -2.395105174128890315655387e19,
  7.174132627104822323218871e19,
  -1.573144024701478897897028e21,
  1.646556791718480264185949e22,
  -1.094324614332891405105506e23,
  5.182527301198832977285138e23,
  -1.860314724528526834720655e24,
  5.256133378016078670608717e24,
  -1.198146914523338214271984e25,
  2.240640270121448696670708e25,
  -3.476619080184002596088017e25,
  4.508563882997026685850282e25,
  -4.906847793451903642790391e25,
  4.487739226679740890706276e25,
  -3.44457335485406821392923e25,
  2.209726493297909482834416e25,
  -1.176151271415076169091301e25,
  5.135756468392421763058128e24,
  -1.809285720915770115793953e24,
  5.016979182100765761915762e23,
  -1.054444275782798448278571e23,
  1.579164035061848168162916e22,
  -1.501716183942478425568933e21,
  6.816365460627030749921607e19,
  -1.630489640280949334699262e20,
  3.577160129623937641531009e21,
  -3.74598110478132509075286e22,
  2.490874328098080635141729e23,
  -1.180217161291809799658582e24,
  4.238570458618960828997243e24,
  -1.198146914523338214271984e25,
  2.732515371002751775746574e25,
  -5.112481168557454094729321e25,
  7.93637181447367996775059e25,
  -1.029690651844424614182568e26,
  1.121174392159723596914516e26,
  -1.025885029791954109350034e26,
  7.87781045591209998653331e25,
  -5.055989838221673254936957e25,
  2.692322358991044791045192e25,
  -1.176151271415076169091301e25,
  4.145334046792305637367689e24,
  -1.149971501254446186686466e24,
  2.418018663796479987661344e23,
  -3.622875269034671912953384e22,
  3.446696615179825069726598e21,
  -1.56515051917918034475047e20,
  3.040218937712636141233471e20,
  -6.673320682926244770477462e21,
  6.991722726552370459738565e22,
  -4.651400221577930525746574e23,
  2.204983998575493799299137e24,
  -7.922695413945882922252865e24,
  2.240640270121448696670708e25,
  -5.112481168557454094729321e25,
  9.56987938763136811712135e25,
  -1.486281356249114022257522e26,
  1.929251177160734483932014e26,
  -2.101633119461251808029122e26,
  1.923902045946715967244105e26,
  -1.478050150140383309749399e26,
  9.49047850015148315475069e25,
  -5.055989838221673254936957e25,
  2.209726493297909482834416e25,
  -7.791662153698116766357685e24,
  2.162479385355931609609248e24,
  -4.549021496732344506536559e23,
  6.818743171926312378745496e22,
  -6.490016973213691911606248e21,
  2.948424202323130736521479e20,
  -4.703633889976864261942915e20,
  1.032959305243471356302803e22,
  -1.082771041789136511695499e23,
  7.20685981000853770745154e23,
  -3.418034992014504751073432e24,
  1.2287160774814202869019e25,
  -3.476619080184002596088017e25,
  7.93637181447367996775059e25,
  -1.486281356249114022257522e26,
  2.309398562382819332650104e26,
  -2.999086476539898664605777e26,
  3.268575893923463520800793e26,
  -2.99354109552523599338073e26,
  2.300865442236521335728454e26,
  -1.478050150140383309749399e26,
  7.87781045591209998653331e25,
  -3.44457335485406821392923e25,
  1.215133388775982515204266e25,
  -3.373977083122952114622982e24,
  7.10074437210927785120602e23,
  -1.064842619156884472191212e23,
  1.013961895174451214980927e22,
  -4.608504632447382171220113e20,
  6.08242004547283758398413e20,
  -1.336394419892045356841942e22,
  1.401508330237335360449177e23,
  -9.33279769149977390734794e23,
  4.428413562750582885367252e24,
  -1.59267919826482501431692e25,
  4.508563882997026685850282e25,
  -1.029690651844424614182568e26,
  1.929251177160734483932014e26,
  -2.999086476539898664605777e26,
  3.896555364978337835391328e26,
  -4.24865680329914429284816e26,
  3.892951594077941161446702e26,
  -2.99354109552523599338073e26,
  1.923902045946715967244105e26,
  -1.025885029791954109350034e26,
  4.487739226679740890706276e25,
  -1.583852766034141499616904e25,
  4.399784079790133754107262e24,
  -9.26384410820953730786871e23,
  1.389858825871832511043601e23,
  -1.324050721515730212236408e22,
  6.02061143641734764111656e20,
  -6.60115412585193292536534e20,
  1.451051517134545383403778e22,
  -1.522467484779164012551638e23,
  1.014303336074941502062711e24,
  -4.815122833970428519275322e24,
  1.732567960037021853055253e25,
  -4.906847793451903642790391e25,
  1.121174392159723596914516e26,
  -2.101633119461251808029122e26,
  3.268575893923463520800793e26,
  -4.24865680329914429284816e26,
  4.634719556969687170542072e26,
  -4.24865680329914429284816e26,
  3.268575893923463520800793e26,
  -2.101633119461251808029122e26,
  1.121174392159723596914516e26,
  -4.906847793451903642790391e25,
  1.732567960037021853055253e25,
  -4.815122833970428519275322e24,
  1.014303336074941502062711e24,
  -1.522467484779164012551638e23,
  1.451051517134545383403778e22,
  -6.60115412585193292536534e20,
  6.02061143641734764111656e20,
  -1.324050721515730212236408e22,
  1.389858825871832511043601e23,
  -9.26384410820953730786871e23,
  4.399784079790133754107262e24,
  -1.583852766034141499616904e25,
  4.487739226679740890706276e25,
  -1.025885029791954109350034e26,
  1.923902045946715967244105e26,
  -2.99354109552523599338073e26,
  3.892951594077941161446702e26,
  -4.24865680329914429284816e26,
  3.896555364978337835391328e26,
  -2.999086476539898664605777e26,
  1.929251177160734483932014e26,
  -1.029690651844424614182568e26,
  4.508563882997026685850282e25,
  -1.59267919826482501431692e25,
  4.428413562750582885367252e24,
  -9.33279769149977390734794e23,
  1.401508330237335360449177e23,
  -1.336394419892045356841942e22,
  6.08242004547283758398413e20,
  -4.608504632447382171220113e20,
  1.013961895174451214980927e22,
  -1.064842619156884472191212e23,
  7.10074437210927785120602e23,
  -3.373977083122952114622982e24,
  1.215133388775982515204266e25,
  -3.44457335485406821392923e25,
  7.87781045591209998653331e25,
  -1.478050150140383309749399e26,
  2.300865442236521335728454e26,
  -2.99354109552523599338073e26,
  3.268575893923463520800793e26,
  -2.999086476539898664605777e26,
  2.309398562382819332650104e26,
  -1.486281356249114022257522e26,
  7.93637181447367996775059e25,
  -3.476619080184002596088017e25,
  1.2287160774814202869019e25,
  -3.418034992014504751073432e24,
  7.20685981000853770745154e23,
  -1.082771041789136511695499e23,
  1.032959305243471356302803e22,
  -4.703633889976864261942915e20,
  2.948424202323130736521479e20,
  -6.490016973213691911606248e21,
  6.818743171926312378745496e22,
  -4.549021496732344506536559e23,
  2.162479385355931609609248e24,
  -7.791662153698116766357685e24,
  2.209726493297909482834416e25,
  -5.055989838221673254936957e25,
  9.49047850015148315475069e25,
  -1.478050150140383309749399e26,
  1.923902045946715967244105e26,
  -2.101633119461251808029122e26,
  1.929251177160734483932014e26,
  -1.486281356249114022257522e26,
  9.56987938763136811712135e25,
  -5.112481168557454094729321e25,
  2.240640270121448696670708e25,
  -7.922695413945882922252865e24,
  2.204983998575493799299137e24,
  -4.651400221577930525746574e23,
  6.991722726552370459738565e22,
  -6.673320682926244770477462e21,
  3.040218937712636141233471e20,
  -1.56515051917918034475047e20,
  3.446696615179825069726598e21,
  -3.622875269034671912953384e22,
  2.418018663796479987661344e23,
  -1.149971501254446186686466e24,
  4.145334046792305637367689e24,
  -1.176151271415076169091301e25,
  2.692322358991044791045192e25,
  -5.055989838221673254936957e25,
  7.87781045591209998653331e25,
  -1.025885029791954109350034e26,
  1.121174392159723596914516e26,
  -1.029690651844424614182568e26,
  7.93637181447367996775059e25,
  -5.112481168557454094729321e25,
  2.732515371002751775746574e25,
  -1.198146914523338214271984e25,
  4.238570458618960828997243e24,
  -1.180217161291809799658582e24,
  2.490874328098080635141729e23,
  -3.74598110478132509075286e22,
  3.577160129623937641531009e21,
  -1.630489640280949334699262e20,
  6.816365460627030749921607e19,
  -1.501716183942478425568933e21,
  1.579164035061848168162916e22,
  -1.054444275782798448278571e23,
  5.016979182100765761915762e23,
  -1.809285720915770115793953e24,
  5.135756468392421763058128e24,
  -1.176151271415076169091301e25,
  2.209726493297909482834416e25,
  -3.44457335485406821392923e25,
  4.487739226679740890706276e25,
  -4.906847793451903642790391e25,
  4.508563882997026685850282e25,
  -3.476619080184002596088017e25,
  2.240640270121448696670708e25,
  -1.198146914523338214271984e25,
  5.256133378016078670608717e24,
  -1.860314724528526834720655e24,
  5.182527301198832977285138e23,
  -1.094324614332891405105506e23,
  1.646556791718480264185949e22,
  -1.573144024701478897897028e21,
  7.174132627104822323218871e19,
  -2.395105174128890315655387e19,
  5.278915659262480849911991e20,
  -5.553547813987716121893014e21,
  3.709835373812136256618904e22,
  -1.76588500774936059114546e23,
  6.37115004213149912482631e23,
  -1.809285720915770115793953e24,
  4.145334046792305637367689e24,
  -7.791662153698116766357685e24,
  1.215133388775982515204266e25,
  -1.583852766034141499616904e25,
  1.732567960037021853055253e25,
  -1.59267919826482501431692e25,
  1.2287160774814202869019e25,
  -7.922695413945882922252865e24,
  4.238570458618960828997243e24,
  -1.860314724528526834720655e24,
  6.58748248187976572528988e23,
  -1.836073381099275249679801e23,
  3.87893471071290873577176e22,
  -5.8393360097705339176415e21,
  5.581852809821975009322089e20,
  -2.546861047358108320256935e19,
  6.624325248782939629581095e18,
  -1.460643200716912208665761e20,
  1.537282915858274908507669e21,
  -1.027361681553579604407409e22,
  4.892357929442122117853482e22,
  -1.76588500774936059114546e23,
  5.016979182100765761915762e23,
  -1.149971501254446186686466e24,
  2.162479385355931609609248e24,
  -3.373977083122952114622982e24,
  4.399784079790133754107262e24,
  -4.815122833970428519275322e24,
  4.428413562750582885367252e24,
  -3.418034992014504751073432e24,
  2.204983998575493799299137e24,
  -1.180217161291809799658582e24,
  5.182527301198832977285138e23,
  -1.836073381099275249679801e23,
  5.120104515004406593726935e22,
  -1.082237204101998728308878e22,
  1.630038087825899741562221e21,
  -1.558978767089385985354224e20,
  7.117016841228088938691528e18,
  -1.388728361275345749541586e18,
  3.063370279476763791329126e19,
  -3.225452008183216070316367e20,
  2.156469820070080052266635e21,
  -1.027361681553579604407409e22,
  3.709835373812136256618904e22,
  -1.054444275782798448278571e23,
  2.418018663796479987661344e23,
  -4.549021496732344506536559e23,
  7.10074437210927785120602e23,
  -9.26384410820953730786871e23,
  1.014303336074941502062711e24,
  -9.33279769149977390734794e23,
  7.20685981000853770745154e23,
  -4.651400221577930525746574e23,
  2.490874328098080635141729e23,
  -1.094324614332891405105506e23,
  3.87893471071290873577176e22,
  -1.082237204101998728308878e22,
  2.288710049593490291355671e21,
  -3.449009599365158671245671e20,
  3.300418498075076544388477e19,
  -1.507519669159281868188423e18,
  2.07456546424951263928487e17,
  -4.578112688326909153188215e18,
  4.822327054223435608598976e19,
  -3.225452008183216070316367e20,
  1.537282915858274908507669e21,
  -5.553547813987716121893014e21,
  1.579164035061848168162916e22,
  -3.622875269034671912953384e22,
  6.818743171926312378745496e22,
  -1.064842619156884472191212e23,
  1.389858825871832511043601e23,
  -1.522467484779164012551638e23,
  1.401508330237335360449177e23,
  -1.082771041789136511695499e23,
  6.991722726552370459738565e22,
  -3.74598110478132509075286e22,
  1.646556791718480264185949e22,
  -5.8393360097705339176415e21,
  1.630038087825899741562221e21,
  -3.449009599365158671245671e20,
  5.200326458047276978543584e19,
  -4.979001588796241870242807e18,
  2.275506084750259792986743e17,
  -1.967910797975516439767751e16,
  4.344496428296447623654838e17,
  -4.578112688326909153188215e18,
  3.063370279476763791329126e19,
  -1.460643200716912208665761e20,
  5.278915659262480849911991e20,
  -1.501716183942478425568933e21,
  3.446696615179825069726598e21,
  -6.490016973213691911606248e21,
  1.013961895174451214980927e22,
  -1.324050721515730212236408e22,
  1.451051517134545383403778e22,
  -1.336394419892045356841942e22,
  1.032959305243471356302803e22,
  -6.673320682926244770477462e21,
  3.577160129623937641531009e21,
  -1.573144024701478897897028e21,
  5.581852809821975009322089e20,
  -1.558978767089385985354224e20,
  3.300418498075076544388477e19,
  -4.979001588796241870242807e18,
  4.769755727394188650102058e17,
  -2.181120059306095022991318e16,
  8.91043718849938616922e14,
  -1.967910797975516439767751e16,
  2.07456546424951263928487e17,
  -1.388728361275345749541586e18,
  6.624325248782939629581095e18,
  -2.395105174128890315655387e19,
  6.816365460627030749921607e19,
  -1.56515051917918034475047e20,
  2.948424202323130736521479e20,
  -4.608504632447382171220113e20,
  6.02061143641734764111656e20,
  -6.60115412585193292536534e20,
  6.08242004547283758398413e20,
  -4.703633889976864261942915e20,
  3.040218937712636141233471e20,
  -1.630489640280949334699262e20,
  7.174132627104822323218871e19,
  -2.546861047358108320256935e19,
  7.117016841228088938691528e18,
  -1.507519669159281868188423e18,
  2.275506084750259792986743e17,
  -2.181120059306095022991318e16,
  9.97968964752745276301212e14,

  3.91616137389441893377958e15,
  -8.95315514158120708669274e16,
  9.7907165718702577801836e17,
  -6.81419514385368135790775e18,
  3.38798511905650898370408e19,
  -1.280370083823155906224479e20,
  3.820493289663147417910301e20,
  -9.22962520116914289845234e20,
  1.836444470382667166402974e21,
  -3.045364570903806982507173e21,
  4.242561503316544911002879e21,
  -4.989842793287990681890954e21,
  4.966396120278352562553888e21,
  -4.183029248293791228945254e21,
  2.97445999325103424634958e21,
  -1.776843150838326807421809e21,
  8.84611729156939532821269e20,
  -3.627260850328911881348485e20,
  1.204141246602995877504405e20,
  -3.156139925458774766780377e19,
  6.287685476389237681675142e18,
  -8.94827185650722412535045e17,
  8.10465351088981278134965e16,
  -3.511041232145420502073481e15,
  -8.95315514158120708669274e16,
  2.04792228739257010513492e18,
  -2.240622300216811820212458e19,
  1.560201969000433448584626e20,
  -7.76095835366084033606292e20,
  2.934355586641843339764137e21,
  -8.759836555964760652480868e21,
  2.117171995053317763693614e22,
  -4.21445816623363758009456e22,
  6.991842493847314927716319e22,
  -9.74463501698859522297128e22,
  1.146584885636028981012175e23,
  -1.141667389528552381680354e23,
  9.61977985784305539446218e22,
  -6.843142440379280302922981e22,
  4.089470636602721812338464e22,
  -2.036754550627935588530505e22,
  8.354689995479286513193606e21,
  -2.774547602643870449785341e21,
  7.27498214581318052043373e20,
  -1.449857283508050449337974e20,
  2.064097889023087048903326e19,
  -1.870166353391617151322589e18,
  8.10465351088981278134965e16,
  9.7907165718702577801836e17,
  -2.240622300216811820212458e19,
  2.452653882532046353755094e20,
  -1.708664143311506554597839e21,
  8.503457827759858652905055e21,
  -3.216573790271406943465086e22,
  9.60668987509202406448655e22,
  -2.322883791679548078529879e23,
  4.625976297859995763168941e23,
  -7.67786525536695931139179e23,
  1.070529489620552484338625e24,
  -1.26014528298281446235175e24,
  1.255256869585435462389008e24,
  -1.058118038465531398243648e24,
  7.53005263751517845032422e23,
  -4.501741436651110597749699e23,
  2.242956426525732759867901e23,
  -9.20404910976300857123337e22,
  3.057771700427825973278987e22,
  -8.020603040522619885970636e21,
  1.599044547290710875907707e21,
  -2.277319126545755300323223e20,
  2.064097889023087048903326e19,
  -8.94827185650722412535045e17,
  -6.81419514385368135790775e18,
  1.560201969000433448584626e20,
  -1.708664143311506554597839e21,
  1.190917822109851099976131e22,
  -5.92955144785153685990689e22,
  2.243973308118288348206093e23,
  -6.70490563310856877813085e23,
  1.621952349286441389276623e24,
  -3.231490052263942203991208e24,
  5.365694493928191487187726e24,
  -7.484580450440977924589811e24,
  8.813943335954883737636007e24,
  -8.78335817657381420832598e24,
  7.406927429664902788021398e24,
  -5.273217602456300380289476e24,
  3.153768041119756739531419e24,
  -1.571952609688507002078509e24,
  6.45304837735116848535983e23,
  -2.144650245707317697156047e23,
  5.627583977517781232241665e22,
  -1.122373107661339691347864e22,
  1.599044547290710875907707e21,
  -1.449857283508050449337974e20,
  6.287685476389237681675142e18,
  3.38798511905650898370408e19,
  -7.76095835366084033606292e20,
  8.503457827759858652905055e21,
  -5.92955144785153685990689e22,
  2.953657125051914349108046e23,
  -1.118281754685983168411113e24,
  3.342864551668905716352428e24,
  -8.090104127498098748107855e24,
  1.612524086847546578459213e25,
  -2.678639387600587601891894e25,
  3.737991756002768395926701e25,
  -4.403737645792118242190033e25,
  4.390256575832728979424041e25,
  -3.703765000346055477457229e25,
  2.637879956009548841624054e25,
  -1.578269387030734162859264e25,
  7.869751212375750520390729e24,
  -3.23187705105794067485544e24,
  1.074516263658254045626275e24,
  -2.820612471121031085957077e23,
  5.627583977517781232241665e22,
  -8.020603040522619885970636e21,
  7.27498214581318052043373e20,
  -3.156139925458774766780377e19,
  -1.280370083823155906224479e20,
  2.934355586641843339764137e21,
  -3.216573790271406943465086e22,
  2.243973308118288348206093e23,
  -1.118281754685983168411113e24,
  4.23579801151889606201518e24,
  -1.266756809574627692961815e25,
  3.067021041939116038946148e25,
  -6.115821872715153646276255e25,
  1.016358019243288889838096e26,
  -1.418902687147567693560781e26,
  1.672305204149673882576174e26,
  -1.667868990072450195106908e26,
  1.407639833972293095366286e26,
  -1.002945822762581994718588e26,
  6.003108465444083748356615e25,
  -2.994518650607890901151444e25,
  1.230241063972646016784595e25,
  -4.091817113781438290070793e24,
  1.074516263658254045626275e24,
  -2.144650245707317697156047e23,
  3.057771700427825973278987e22,
  -2.774547602643870449785341e21,
  1.204141246602995877504405e20,
  3.820493289663147417910301e20,
  -8.759836555964760652480868e21,
  9.60668987509202406448655e22,
  -6.70490563310856877813085e23,
  3.342864551668905716352428e24,
  -1.266756809574627692961815e25,
  3.790004286554061275952134e25,
  -9.180148643012207501349e25,
  1.831354477181600240594703e26,
  -3.044718350006539760894844e26,
  4.252399820733147478786238e26,
  -5.013908554841757223798244e26,
  5.002655092765615441071848e26,
  -4.223829348471367973299471e26,
  3.010696370600323016333693e26,
  -1.802764010691914551601132e26,
  8.99624967864855392619269e25,
  -3.697388785216688993932993e25,
  1.230241063972646016784595e25,
  -3.23187705105794067485544e24,
  6.45304837735116848535983e23,
  -9.20404910976300857123337e22,
  8.354689995479286513193606e21,
  -3.627260850328911881348485e20,
  -9.22962520116914289845234e20,
  2.117171995053317763693614e22,
  -2.322883791679548078529879e23,
  1.621952349286441389276623e24,
  -8.090104127498098748107855e24,
  3.067021041939116038946148e25,
  -9.180148643012207501349e25,
  2.224562518886603856958915e26,
  -4.439669581277226132362646e26,
  7.38426353483741761410709e26,
  -1.031750124455270915868007e27,
  1.217014690396713911073324e27,
  -1.214779883034172534763942e27,
  1.026076409890571406428304e27,
  -7.31670163065659955920852e26,
  4.382895267636137710255907e26,
  -2.188045579217644302084069e26,
  8.99624967864855392619269e25,
  -2.994518650607890901151444e25,
  7.869751212375750520390729e24,
  -1.571952609688507002078509e24,
  2.242956426525732759867901e23,
  -2.036754550627935588530505e22,
  8.84611729156939532821269e20,
  1.836444470382667166402974e21,
  -4.21445816623363758009456e22,
  4.625976297859995763168941e23,
  -3.231490052263942203991208e24,
  1.612524086847546578459213e25,
  -6.115821872715153646276255e25,
  1.831354477181600240594703e26,
  -4.439669581277226132362646e26,
  8.86418404158098220313148e26,
  -1.474946193247923952396725e27,
  2.061689359337849482776148e27,
  -2.432893547478076719065737e27,
  2.429418756791649309897898e27,
  -2.052867646024308819691187e27,
  1.464441554120665185186201e27,
  -8.77591227069269796734159e26,
  4.382895267636137710255907e26,
  -1.802764010691914551601132e26,
  6.003108465444083748356615e25,
  -1.578269387030734162859264e25,
  3.153768041119756739531419e24,
  -4.501741436651110597749699e23,
  4.089470636602721812338464e22,
  -1.776843150838326807421809e21,
  -3.045364570903806982507173e21,
  6.991842493847314927716319e22,
  -7.67786525536695931139179e23,
  5.365694493928191487187726e24,
  -2.678639387600587601891894e25,
  1.016358019243288889838096e26,
  -3.044718350006539760894844e26,
  7.38426353483741761410709e26,
  -1.474946193247923952396725e27,
  2.455237718665668935337948e27,
  -3.433362621102278825595717e27,
  4.053197624509502790448301e27,
  -4.049062373375733505104178e27,
  3.422864203145552492943824e27,
  -2.442736642250717294797886e27,
  1.464441554120665185186201e27,
  -7.31670163065659955920852e26,
  3.010696370600323016333693e26,
  -1.002945822762581994718588e26,
  2.637879956009548841624054e25,
  -5.273217602456300380289476e24,
  7.53005263751517845032422e23,
  -6.843142440379280302922981e22,
  2.97445999325103424634958e21,
  4.242561503316544911002879e21,
  -9.74463501698859522297128e22,
  1.070529489620552484338625e24,
  -7.484580450440977924589811e24,
  3.737991756002768395926701e25,
  -1.418902687147567693560781e26,
  4.252399820733147478786238e26,
  -1.031750124455270915868007e27,
  2.061689359337849482776148e27,
  -3.433362621102278825595717e27,
  4.803129242794365019128663e27,
  -5.67257535215528835050175e27,
  5.66910252650479416206082e27,
  -4.794312596812245784539224e27,
  3.422864203145552492943824e27,
  -2.052867646024308819691187e27,
  1.026076409890571406428304e27,
  -4.223829348471367973299471e26,
  1.407639833972293095366286e26,
  -3.703765000346055477457229e25,
  7.406927429664902788021398e24,
  -1.058118038465531398243648e24,
  9.61977985784305539446218e22,
  -4.183029248293791228945254e21,
  -4.989842793287990681890954e21,
  1.146584885636028981012175e23,
  -1.26014528298281446235175e24,
  8.813943335954883737636007e24,
  -4.403737645792118242190033e25,
  1.672305204149673882576174e26,
  -5.013908554841757223798244e26,
  1.217014690396713911073324e27,
  -2.432893547478076719065737e27,
  4.053197624509502790448301e27,
  -5.67257535215528835050175e27,
  6.70214570794069817962606e27,
  -6.70077777964952297020887e27,
  5.66910252650479416206082e27,
  -4.049062373375733505104178e27,
  2.429418756791649309897898e27,
  -1.214779883034172534763942e27,
  5.002655092765615441071848e26,
  -1.667868990072450195106908e26,
  4.390256575832728979424041e25,
  -8.78335817657381420832598e24,
  1.255256869585435462389008e24,
  -1.141667389528552381680354e23,
  4.966396120278352562553888e21,
  4.966396120278352562553888e21,
  -1.141667389528552381680354e23,
  1.255256869585435462389008e24,
  -8.78335817657381420832598e24,
  4.390256575832728979424041e25,
  -1.667868990072450195106908e26,
  5.002655092765615441071848e26,
  -1.214779883034172534763942e27,
  2.429418756791649309897898e27,
  -4.049062373375733505104178e27,
  5.66910252650479416206082e27,
  -6.70077777964952297020887e27,
  6.70214570794069817962606e27,
  -5.67257535215528835050175e27,
  4.053197624509502790448301e27,
  -2.432893547478076719065737e27,
  1.217014690396713911073324e27,
  -5.013908554841757223798244e26,
  1.672305204149673882576174e26,
  -4.403737645792118242190033e25,
  8.813943335954883737636007e24,
  -1.26014528298281446235175e24,
  1.146584885636028981012175e23,
  -4.989842793287990681890954e21,
  -4.183029248293791228945254e21,
  9.61977985784305539446218e22,
  -1.058118038465531398243648e24,
  7.406927429664902788021398e24,
  -3.703765000346055477457229e25,
  1.407639833972293095366286e26,
  -4.223829348471367973299471e26,
  1.026076409890571406428304e27,
  -2.052867646024308819691187e27,
  3.422864203145552492943824e27,
  -4.794312596812245784539224e27,
  5.66910252650479416206082e27,
  -5.67257535215528835050175e27,
  4.803129242794365019128663e27,
  -3.433362621102278825595717e27,
  2.061689359337849482776148e27,
  -1.031750124455270915868007e27,
  4.252399820733147478786238e26,
  -1.418902687147567693560781e26,
  3.737991756002768395926701e25,
  -7.484580450440977924589811e24,
  1.070529489620552484338625e24,
  -9.74463501698859522297128e22,
  4.242561503316544911002879e21,
  2.97445999325103424634958e21,
  -6.843142440379280302922981e22,
  7.53005263751517845032422e23,
  -5.273217602456300380289476e24,
  2.637879956009548841624054e25,
  -1.002945822762581994718588e26,
  3.010696370600323016333693e26,
  -7.31670163065659955920852e26,
  1.464441554120665185186201e27,
  -2.442736642250717294797886e27,
  3.422864203145552492943824e27,
  -4.049062373375733505104178e27,
  4.053197624509502790448301e27,
  -3.433362621102278825595717e27,
  2.455237718665668935337948e27,
  -1.474946193247923952396725e27,
  7.38426353483741761410709e26,
  -3.044718350006539760894844e26,
  1.016358019243288889838096e26,
  -2.678639387600587601891894e25,
  5.365694493928191487187726e24,
  -7.67786525536695931139179e23,
  6.991842493847314927716319e22,
  -3.045364570903806982507173e21,
  -1.776843150838326807421809e21,
  4.089470636602721812338464e22,
  -4.501741436651110597749699e23,
  3.153768041119756739531419e24,
  -1.578269387030734162859264e25,
  6.003108465444083748356615e25,
  -1.802764010691914551601132e26,
  4.382895267636137710255907e26,
  -8.77591227069269796734159e26,
  1.464441554120665185186201e27,
  -2.052867646024308819691187e27,
  2.429418756791649309897898e27,
  -2.432893547478076719065737e27,
  2.061689359337849482776148e27,
  -1.474946193247923952396725e27,
  8.86418404158098220313148e26,
  -4.439669581277226132362646e26,
  1.831354477181600240594703e26,
  -6.115821872715153646276255e25,
  1.612524086847546578459213e25,
  -3.231490052263942203991208e24,
  4.625976297859995763168941e23,
  -4.21445816623363758009456e22,
  1.836444470382667166402974e21,
  8.84611729156939532821269e20,
  -2.036754550627935588530505e22,
  2.242956426525732759867901e23,
  -1.571952609688507002078509e24,
  7.869751212375750520390729e24,
  -2.994518650607890901151444e25,
  8.99624967864855392619269e25,
  -2.188045579217644302084069e26,
  4.382895267636137710255907e26,
  -7.31670163065659955920852e26,
  1.026076409890571406428304e27,
  -1.214779883034172534763942e27,
  1.217014690396713911073324e27,
  -1.031750124455270915868007e27,
  7.38426353483741761410709e26,
  -4.439669581277226132362646e26,
  2.224562518886603856958915e26,
  -9.180148643012207501349e25,
  3.067021041939116038946148e25,
  -8.090104127498098748107855e24,
  1.621952349286441389276623e24,
  -2.322883791679548078529879e23,
  2.117171995053317763693614e22,
  -9.22962520116914289845234e20,
  -3.627260850328911881348485e20,
  8.354689995479286513193606e21,
  -9.20404910976300857123337e22,
  6.45304837735116848535983e23,
  -3.23187705105794067485544e24,
  1.230241063972646016784595e25,
  -3.697388785216688993932993e25,
  8.99624967864855392619269e25,
  -1.802764010691914551601132e26,
  3.010696370600323016333693e26,
  -4.223829348471367973299471e26,
  5.002655092765615441071848e26,
  -5.013908554841757223798244e26,
  4.252399820733147478786238e26,
  -3.044718350006539760894844e26,
  1.831354477181600240594703e26,
  -9.180148643012207501349e25,
  3.790004286554061275952134e25,
  -1.266756809574627692961815e25,
  3.342864551668905716352428e24,
  -6.70490563310856877813085e23,
  9.60668987509202406448655e22,
  -8.759836555964760652480868e21,
  3.820493289663147417910301e20,
  1.204141246602995877504405e20,
  -2.774547602643870449785341e21,
  3.057771700427825973278987e22,
  -2.144650245707317697156047e23,
  1.074516263658254045626275e24,
  -4.091817113781438290070793e24,
  1.230241063972646016784595e25,
  -2.994518650607890901151444e25,
  6.003108465444083748356615e25,
  -1.002945822762581994718588e26,
  1.407639833972293095366286e26,
  -1.667868990072450195106908e26,
  1.672305204149673882576174e26,
  -1.418902687147567693560781e26,
  1.016358019243288889838096e26,
  -6.115821872715153646276255e25,
  3.067021041939116038946148e25,
  -1.266756809574627692961815e25,
  4.23579801151889606201518e24,
  -1.118281754685983168411113e24,
  2.243973308118288348206093e23,
  -3.216573790271406943465086e22,
  2.934355586641843339764137e21,
  -1.280370083823155906224479e20,
  -3.156139925458774766780377e19,
  7.27498214581318052043373e20,
  -8.020603040522619885970636e21,
  5.627583977517781232241665e22,
  -2.820612471121031085957077e23,
  1.074516263658254045626275e24,
  -3.23187705105794067485544e24,
  7.869751212375750520390729e24,
  -1.578269387030734162859264e25,
  2.637879956009548841624054e25,
  -3.703765000346055477457229e25,
  4.390256575832728979424041e25,
  -4.403737645792118242190033e25,
  3.737991756002768395926701e25,
  -2.678639387600587601891894e25,
  1.612524086847546578459213e25,
  -8.090104127498098748107855e24,
  3.342864551668905716352428e24,
  -1.118281754685983168411113e24,
  2.953657125051914349108046e23,
  -5.92955144785153685990689e22,
  8.503457827759858652905055e21,
  -7.76095835366084033606292e20,
  3.38798511905650898370408e19,
  6.287685476389237681675142e18,
  -1.449857283508050449337974e20,
  1.599044547290710875907707e21,
  -1.122373107661339691347864e22,
  5.627583977517781232241665e22,
  -2.144650245707317697156047e23,
  6.45304837735116848535983e23,
  -1.571952609688507002078509e24,
  3.153768041119756739531419e24,
  -5.273217602456300380289476e24,
  7.406927429664902788021398e24,
  -8.78335817657381420832598e24,
  8.813943335954883737636007e24,
  -7.484580450440977924589811e24,
  5.365694493928191487187726e24,
  -3.231490052263942203991208e24,
  1.621952349286441389276623e24,
  -6.70490563310856877813085e23,
  2.243973308118288348206093e23,
  -5.92955144785153685990689e22,
  1.190917822109851099976131e22,
  -1.708664143311506554597839e21,
  1.560201969000433448584626e20,
  -6.81419514385368135790775e18,
  -8.94827185650722412535045e17,
  2.064097889023087048903326e19,
  -2.277319126545755300323223e20,
  1.599044547290710875907707e21,
  -8.020603040522619885970636e21,
  3.057771700427825973278987e22,
  -9.20404910976300857123337e22,
  2.242956426525732759867901e23,
  -4.501741436651110597749699e23,
  7.53005263751517845032422e23,
  -1.058118038465531398243648e24,
  1.255256869585435462389008e24,
  -1.26014528298281446235175e24,
  1.070529489620552484338625e24,
  -7.67786525536695931139179e23,
  4.625976297859995763168941e23,
  -2.322883791679548078529879e23,
  9.60668987509202406448655e22,
  -3.216573790271406943465086e22,
  8.503457827759858652905055e21,
  -1.708664143311506554597839e21,
  2.452653882532046353755094e20,
  -2.240622300216811820212458e19,
  9.7907165718702577801836e17,
  8.10465351088981278134965e16,
  -1.870166353391617151322589e18,
  2.064097889023087048903326e19,
  -1.449857283508050449337974e20,
  7.27498214581318052043373e20,
  -2.774547602643870449785341e21,
  8.354689995479286513193606e21,
  -2.036754550627935588530505e22,
  4.089470636602721812338464e22,
  -6.843142440379280302922981e22,
  9.61977985784305539446218e22,
  -1.141667389528552381680354e23,
  1.146584885636028981012175e23,
  -9.74463501698859522297128e22,
  6.991842493847314927716319e22,
  -4.21445816623363758009456e22,
  2.117171995053317763693614e22,
  -8.759836555964760652480868e21,
  2.934355586641843339764137e21,
  -7.76095835366084033606292e20,
  1.560201969000433448584626e20,
  -2.240622300216811820212458e19,
  2.04792228739257010513492e18,
  -8.95315514158120708669274e16,
  -3.511041232145420502073481e15,
  8.10465351088981278134965e16,
  -8.94827185650722412535045e17,
  6.287685476389237681675142e18,
  -3.156139925458774766780377e19,
  1.204141246602995877504405e20,
  -3.627260850328911881348485e20,
  8.84611729156939532821269e20,
  -1.776843150838326807421809e21,
  2.97445999325103424634958e21,
  -4.183029248293791228945254e21,
  4.966396120278352562553888e21,
  -4.989842793287990681890954e21,
  4.242561503316544911002879e21,
  -3.045364570903806982507173e21,
  1.836444470382667166402974e21,
  -9.22962520116914289845234e20,
  3.820493289663147417910301e20,
  -1.280370083823155906224479e20,
  3.38798511905650898370408e19,
  -6.81419514385368135790775e18,
  9.7907165718702577801836e17,
  -8.95315514158120708669274e16,
  3.91616137389441893377958e15

};

void IBPMatrix(const int classe, math_Matrix& IBPMa)
{
  if (classe > 26)
    throw Standard_DimensionError("IBPMatrix: classe > 26");
  //  math_Matrix IBPMa(1, classe-2, 1, classe-2);
  int i, j, k = 0, Som = 0;
  for (i = 1; i < classe - 2; i++)
  {
    Som += (i) * (i);
  }
  for (i = 1; i <= classe - 2; i++)
  {
    for (j = 1; j <= classe - 2; j++)
    {
      IBPMa(i + IBPMa.LowerRow() - 1, j + IBPMa.LowerCol() - 1) = IBP[Som + k];
      k++;
    }
  }
}
