// Created on: 1995-03-14
// Created by: Modelistation
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef OCCT_DEBUG
  #define No_Standard_OutOfRange
  #define No_Standard_RangeError
#endif

#include <AppCont_ContMatrices.hxx>
#include <math_Matrix.hxx>
#include <Standard_DimensionError.hxx>

static const double BBMatrix[] = {

  0.3333333333333333333333333,
  0.1666666666666666666666667,
  0.1666666666666666666666667,
  0.3333333333333333333333333,

  0.2,
  0.1,
  0.03333333333333333333333333,
  0.1,
  0.1333333333333333333333333,
  0.1,
  0.03333333333333333333333333,
  0.1,
  0.2,

  0.1428571428571428571428571,
  0.0714285714285714285714286,
  0.02857142857142857142857143,
  0.007142857142857142857142857,
  0.0714285714285714285714286,
  0.0857142857142857142857143,
  0.0642857142857142857142857,
  0.02857142857142857142857143,
  0.02857142857142857142857143,
  0.0642857142857142857142857,
  0.0857142857142857142857143,
  0.0714285714285714285714286,
  0.007142857142857142857142857,
  0.02857142857142857142857143,
  0.0714285714285714285714286,
  0.1428571428571428571428571,

  0.1111111111111111111111111,
  0.05555555555555555555555556,
  0.02380952380952380952380952,
  0.00793650793650793650793651,
  0.001587301587301587301587302,
  0.05555555555555555555555556,
  0.0634920634920634920634921,
  0.04761904761904761904761905,
  0.02539682539682539682539683,
  0.00793650793650793650793651,
  0.02380952380952380952380952,
  0.04761904761904761904761905,
  0.05714285714285714285714286,
  0.04761904761904761904761905,
  0.02380952380952380952380952,
  0.00793650793650793650793651,
  0.02539682539682539682539683,
  0.04761904761904761904761905,
  0.0634920634920634920634921,
  0.05555555555555555555555556,
  0.001587301587301587301587302,
  0.00793650793650793650793651,
  0.02380952380952380952380952,
  0.05555555555555555555555556,
  0.1111111111111111111111111,

  0.0909090909090909090909091,
  0.04545454545454545454545455,
  0.02020202020202020202020202,
  0.007575757575757575757575758,
  0.002164502164502164502164502,
  0.0003607503607503607503607504,
  0.04545454545454545454545455,
  0.05050505050505050505050505,
  0.03787878787878787878787879,
  0.02164502164502164502164502,
  0.00901875901875901875901876,
  0.002164502164502164502164502,
  0.02020202020202020202020202,
  0.03787878787878787878787879,
  0.04329004329004329004329004,
  0.03607503607503607503607504,
  0.02164502164502164502164502,
  0.007575757575757575757575758,
  0.007575757575757575757575758,
  0.02164502164502164502164502,
  0.03607503607503607503607504,
  0.04329004329004329004329004,
  0.03787878787878787878787879,
  0.02020202020202020202020202,
  0.002164502164502164502164502,
  0.00901875901875901875901876,
  0.02164502164502164502164502,
  0.03787878787878787878787879,
  0.05050505050505050505050505,
  0.04545454545454545454545455,
  0.0003607503607503607503607504,
  0.002164502164502164502164502,
  0.007575757575757575757575758,
  0.02020202020202020202020202,
  0.04545454545454545454545455,
  0.0909090909090909090909091,

  0.0769230769230769230769231,
  0.03846153846153846153846154,
  0.01748251748251748251748252,
  0.006993006993006993006993007,
  0.002331002331002331002331002,
  0.000582750582750582750582751,
  0.0000832500832500832500832501,
  0.03846153846153846153846154,
  0.04195804195804195804195804,
  0.03146853146853146853146853,
  0.01864801864801864801864802,
  0.00874125874125874125874126,
  0.002997002997002997002997003,
  0.000582750582750582750582751,
  0.01748251748251748251748252,
  0.03146853146853146853146853,
  0.03496503496503496503496503,
  0.02913752913752913752913753,
  0.01873126873126873126873127,
  0.00874125874125874125874126,
  0.002331002331002331002331002,
  0.006993006993006993006993007,
  0.01864801864801864801864802,
  0.02913752913752913752913753,
  0.03330003330003330003330003,
  0.02913752913752913752913753,
  0.01864801864801864801864802,
  0.006993006993006993006993007,
  0.002331002331002331002331002,
  0.00874125874125874125874126,
  0.01873126873126873126873127,
  0.02913752913752913752913753,
  0.03496503496503496503496503,
  0.03146853146853146853146853,
  0.01748251748251748251748252,
  0.000582750582750582750582751,
  0.002997002997002997002997003,
  0.00874125874125874125874126,
  0.01864801864801864801864802,
  0.03146853146853146853146853,
  0.04195804195804195804195804,
  0.03846153846153846153846154,
  0.0000832500832500832500832501,
  0.000582750582750582750582751,
  0.002331002331002331002331002,
  0.006993006993006993006993007,
  0.01748251748251748251748252,
  0.03846153846153846153846154,
  0.0769230769230769230769231,

  0.0666666666666666666666667,
  0.03333333333333333333333333,
  0.01538461538461538461538462,
  0.006410256410256410256410256,
  0.002331002331002331002331002,
  0.000699300699300699300699301,
  0.0001554001554001554001554002,
  0.00001942501942501942501942502,
  0.03333333333333333333333333,
  0.03589743589743589743589744,
  0.02692307692307692307692308,
  0.01631701631701631701631702,
  0.00815850815850815850815851,
  0.003263403263403263403263403,
  0.000951825951825951825951826,
  0.0001554001554001554001554002,
  0.01538461538461538461538462,
  0.02692307692307692307692308,
  0.02937062937062937062937063,
  0.02447552447552447552447552,
  0.01631701631701631701631702,
  0.00856643356643356643356643,
  0.003263403263403263403263403,
  0.000699300699300699300699301,
  0.006410256410256410256410256,
  0.01631701631701631701631702,
  0.02447552447552447552447552,
  0.02719502719502719502719503,
  0.02379564879564879564879565,
  0.01631701631701631701631702,
  0.00815850815850815850815851,
  0.002331002331002331002331002,
  0.002331002331002331002331002,
  0.00815850815850815850815851,
  0.01631701631701631701631702,
  0.02379564879564879564879565,
  0.02719502719502719502719503,
  0.02447552447552447552447552,
  0.01631701631701631701631702,
  0.006410256410256410256410256,
  0.000699300699300699300699301,
  0.003263403263403263403263403,
  0.00856643356643356643356643,
  0.01631701631701631701631702,
  0.02447552447552447552447552,
  0.02937062937062937062937063,
  0.02692307692307692307692308,
  0.01538461538461538461538462,
  0.0001554001554001554001554002,
  0.000951825951825951825951826,
  0.003263403263403263403263403,
  0.00815850815850815850815851,
  0.01631701631701631701631702,
  0.02692307692307692307692308,
  0.03589743589743589743589744,
  0.03333333333333333333333333,
  0.00001942501942501942501942502,
  0.0001554001554001554001554002,
  0.000699300699300699300699301,
  0.002331002331002331002331002,
  0.006410256410256410256410256,
  0.01538461538461538461538462,
  0.03333333333333333333333333,
  0.0666666666666666666666667,

  0.05882352941176470588235294,
  0.02941176470588235294117647,
  0.01372549019607843137254902,
  0.005882352941176470588235294,
  0.002262443438914027149321267,
  0.000754147812971342383107089,
  0.0002056766762649115590292061,
  0.00004113533525298231180584122,
  4.570592805886923533982358e-6,
  0.02941176470588235294117647,
  0.0313725490196078431372549,
  0.02352941176470588235294118,
  0.01447963800904977375565611,
  0.00754147812971342383107089,
  0.003290826820238584944467297,
  0.001151789387083504730563554,
  0.0002925179395767631061748709,
  0.00004113533525298231180584122,
  0.01372549019607843137254902,
  0.02352941176470588235294118,
  0.02533936651583710407239819,
  0.02111613876319758672699849,
  0.01439736733854380913204443,
  0.00806252570958453311394488,
  0.003583344759815348050642168,
  0.001151789387083504730563554,
  0.0002056766762649115590292061,
  0.005882352941176470588235294,
  0.01447963800904977375565611,
  0.02111613876319758672699849,
  0.02303578774167009461127108,
  0.0201563142739613327848622,
  0.01433337903926139220256867,
  0.00806252570958453311394488,
  0.003290826820238584944467297,
  0.000754147812971342383107089,
  0.002262443438914027149321267,
  0.00754147812971342383107089,
  0.01439736733854380913204443,
  0.0201563142739613327848622,
  0.02239590474884592531651355,
  0.0201563142739613327848622,
  0.01439736733854380913204443,
  0.00754147812971342383107089,
  0.002262443438914027149321267,
  0.000754147812971342383107089,
  0.003290826820238584944467297,
  0.00806252570958453311394488,
  0.01433337903926139220256867,
  0.0201563142739613327848622,
  0.02303578774167009461127108,
  0.02111613876319758672699849,
  0.01447963800904977375565611,
  0.005882352941176470588235294,
  0.0002056766762649115590292061,
  0.001151789387083504730563554,
  0.003583344759815348050642168,
  0.00806252570958453311394488,
  0.01439736733854380913204443,
  0.02111613876319758672699849,
  0.02533936651583710407239819,
  0.02352941176470588235294118,
  0.01372549019607843137254902,
  0.00004113533525298231180584122,
  0.0002925179395767631061748709,
  0.001151789387083504730563554,
  0.003290826820238584944467297,
  0.00754147812971342383107089,
  0.01447963800904977375565611,
  0.02352941176470588235294118,
  0.0313725490196078431372549,
  0.02941176470588235294117647,
  4.570592805886923533982358e-6,
  0.00004113533525298231180584122,
  0.0002056766762649115590292061,
  0.000754147812971342383107089,
  0.002262443438914027149321267,
  0.005882352941176470588235294,
  0.01372549019607843137254902,
  0.02941176470588235294117647,
  0.05882352941176470588235294,

  0.05263157894736842105263158,
  0.02631578947368421052631579,
  0.01238390092879256965944272,
  0.005417956656346749226006192,
  0.002167182662538699690402477,
  0.00077399380804953560371517,
  0.0002381519409383186472969755,
  0.00005953798523457966182424387,
  0.00001082508822446902942258979,
  1.082508822446902942258979e-6,
  0.02631578947368421052631579,
  0.02786377708978328173374613,
  0.0208978328173374613003096,
  0.01300309597523219814241486,
  0.006965944272445820433436533,
  0.003215051202667301738509169,
  0.001250297689926172898309121,
  0.0003897031760808850592132326,
  0.0000876832146181991383229773,
  0.00001082508822446902942258979,
  0.01238390092879256965944272,
  0.0208978328173374613003096,
  0.0222910216718266253869969,
  0.01857585139318885448916409,
  0.01286020481066920695403668,
  0.007501786139557037389854727,
  0.003637229643421593885990171,
  0.001402931433891186213167637,
  0.0003897031760808850592132326,
  0.00005953798523457966182424387,
  0.005417956656346749226006192,
  0.01300309597523219814241486,
  0.01857585139318885448916409,
  0.02000476303881876637294594,
  0.0175041676589664205763277,
  0.0127303037519755786009656,
  0.007638182251185347160579359,
  0.003637229643421593885990171,
  0.001250297689926172898309121,
  0.0002381519409383186472969755,
  0.002167182662538699690402477,
  0.006965944272445820433436533,
  0.01286020481066920695403668,
  0.0175041676589664205763277,
  0.0190954556279633679014484,
  0.01718591006516703111130356,
  0.0127303037519755786009656,
  0.007501786139557037389854727,
  0.003215051202667301738509169,
  0.00077399380804953560371517,
  0.00077399380804953560371517,
  0.003215051202667301738509169,
  0.007501786139557037389854727,
  0.0127303037519755786009656,
  0.01718591006516703111130356,
  0.0190954556279633679014484,
  0.0175041676589664205763277,
  0.01286020481066920695403668,
  0.006965944272445820433436533,
  0.002167182662538699690402477,
  0.0002381519409383186472969755,
  0.001250297689926172898309121,
  0.003637229643421593885990171,
  0.007638182251185347160579359,
  0.0127303037519755786009656,
  0.0175041676589664205763277,
  0.02000476303881876637294594,
  0.01857585139318885448916409,
  0.01300309597523219814241486,
  0.005417956656346749226006192,
  0.00005953798523457966182424387,
  0.0003897031760808850592132326,
  0.001402931433891186213167637,
  0.003637229643421593885990171,
  0.007501786139557037389854727,
  0.01286020481066920695403668,
  0.01857585139318885448916409,
  0.0222910216718266253869969,
  0.0208978328173374613003096,
  0.01238390092879256965944272,
  0.00001082508822446902942258979,
  0.0000876832146181991383229773,
  0.0003897031760808850592132326,
  0.001250297689926172898309121,
  0.003215051202667301738509169,
  0.006965944272445820433436533,
  0.01300309597523219814241486,
  0.0208978328173374613003096,
  0.02786377708978328173374613,
  0.02631578947368421052631579,
  1.082508822446902942258979e-6,
  0.00001082508822446902942258979,
  0.00005953798523457966182424387,
  0.0002381519409383186472969755,
  0.00077399380804953560371517,
  0.002167182662538699690402477,
  0.005417956656346749226006192,
  0.01238390092879256965944272,
  0.02631578947368421052631579,
  0.05263157894736842105263158,

  0.04761904761904761904761905,
  0.02380952380952380952380952,
  0.0112781954887218045112782,
  0.005012531328320802005012531,
  0.002063983488132094943240454,
  0.00077399380804953560371517,
  0.0002579979360165118679050568,
  0.0000737136960047176765443019,
  0.00001701085292416561766406968,
  2.835142154027602944011613e-6,
  2.577401958206911767283284e-7,
  0.02380952380952380952380952,
  0.02506265664160401002506266,
  0.01879699248120300751879699,
  0.01179419136075482824708831,
  0.006449948400412796697626419,
  0.003095975232198142414860681,
  0.001289989680082559339525284,
  0.000453622744644416471041858,
  0.0001275813969312421324805226,
  0.00002577401958206911767283284,
  2.835142154027602944011613e-6,
  0.0112781954887218045112782,
  0.01879699248120300751879699,
  0.01990269792127377266696152,
  0.01658558160106147722246793,
  0.01160990712074303405572755,
  0.006965944272445820433436533,
  0.003572279114074779709454632,
  0.001530976763174905589766271,
  0.000521923896536899632874865,
  0.0001275813969312421324805226,
  0.00001701085292416561766406968,
  0.005012531328320802005012531,
  0.01179419136075482824708831,
  0.01658558160106147722246793,
  0.01769128704113224237063246,
  0.01547987616099071207430341,
  0.01143129316503929507025482,
  0.007144558228149559418909264,
  0.003711458819817952944887929,
  0.001530976763174905589766271,
  0.000453622744644416471041858,
  0.0000737136960047176765443019,
  0.002063983488132094943240454,
  0.006449948400412796697626419,
  0.01160990712074303405572755,
  0.01547987616099071207430341,
  0.01667063586568230531078828,
  0.01500357227911407477970945,
  0.01136634263569248089371928,
  0.007144558228149559418909264,
  0.003572279114074779709454632,
  0.001289989680082559339525284,
  0.0002579979360165118679050568,
  0.00077399380804953560371517,
  0.003095975232198142414860681,
  0.006965944272445820433436533,
  0.01143129316503929507025482,
  0.01500357227911407477970945,
  0.01636753339539717248695577,
  0.01500357227911407477970945,
  0.01143129316503929507025482,
  0.006965944272445820433436533,
  0.003095975232198142414860681,
  0.00077399380804953560371517,
  0.0002579979360165118679050568,
  0.001289989680082559339525284,
  0.003572279114074779709454632,
  0.007144558228149559418909264,
  0.01136634263569248089371928,
  0.01500357227911407477970945,
  0.01667063586568230531078828,
  0.01547987616099071207430341,
  0.01160990712074303405572755,
  0.006449948400412796697626419,
  0.002063983488132094943240454,
  0.0000737136960047176765443019,
  0.000453622744644416471041858,
  0.001530976763174905589766271,
  0.003711458819817952944887929,
  0.007144558228149559418909264,
  0.01143129316503929507025482,
  0.01547987616099071207430341,
  0.01769128704113224237063246,
  0.01658558160106147722246793,
  0.01179419136075482824708831,
  0.005012531328320802005012531,
  0.00001701085292416561766406968,
  0.0001275813969312421324805226,
  0.000521923896536899632874865,
  0.001530976763174905589766271,
  0.003572279114074779709454632,
  0.006965944272445820433436533,
  0.01160990712074303405572755,
  0.01658558160106147722246793,
  0.01990269792127377266696152,
  0.01879699248120300751879699,
  0.0112781954887218045112782,
  2.835142154027602944011613e-6,
  0.00002577401958206911767283284,
  0.0001275813969312421324805226,
  0.000453622744644416471041858,
  0.001289989680082559339525284,
  0.003095975232198142414860681,
  0.006449948400412796697626419,
  0.01179419136075482824708831,
  0.01879699248120300751879699,
  0.02506265664160401002506266,
  0.02380952380952380952380952,
  2.577401958206911767283284e-7,
  2.835142154027602944011613e-6,
  0.00001701085292416561766406968,
  0.0000737136960047176765443019,
  0.0002579979360165118679050568,
  0.00077399380804953560371517,
  0.002063983488132094943240454,
  0.005012531328320802005012531,
  0.0112781954887218045112782,
  0.02380952380952380952380952,
  0.04761904761904761904761905,

  0.04347826086956521739130435,
  0.02173913043478260869565217,
  0.01035196687370600414078675,
  0.004658385093167701863354037,
  0.001961425302386400784570121,
  0.000762776506483600305110603,
  0.0002692152375824471665096244,
  0.0000841297617445147395342576,
  0.00002243460313187059720913537,
  4.807414956829413687671865e-6,
  7.396023010506790288725946e-7,
  6.16335250875565857393829e-8,
  0.02173913043478260869565217,
  0.02277432712215320910973085,
  0.01708074534161490683229814,
  0.01078783916312520431513567,
  0.005993243979514002397297592,
  0.002961367613406918831605869,
  0.001295598330865526988827568,
  0.000493561268901153138600978,
  0.0001586446935753706516931715,
  0.0000406781265577873465879927,
  7.457656535594346874465329e-6,
  7.396023010506790288725946e-7,
  0.01035196687370600414078675,
  0.01708074534161490683229814,
  0.01797973193854200719189278,
  0.01498310994878500599324398,
  0.0105763129050247101128781,
  0.006477991654327634944137838,
  0.003454928882308071970206847,
  0.001586446935753706516931715,
  0.000610171898366810198819891,
  0.0001864414133898586718616332,
  0.0000406781265577873465879927,
  4.807414956829413687671865e-6,
  0.004658385093167701863354037,
  0.01078783916312520431513567,
  0.01498310994878500599324398,
  0.01586446935753706516931715,
  0.01388141068784493202315251,
  0.01036478664692421591062054,
  0.006663077130165567371113205,
  0.003661031390200861192919343,
  0.001677972720508728046754699,
  0.000610171898366810198819891,
  0.0001586446935753706516931715,
  0.00002243460313187059720913537,
  0.001961425302386400784570121,
  0.005993243979514002397297592,
  0.0105763129050247101128781,
  0.01388141068784493202315251,
  0.01480683806703459415802934,
  0.01332615426033113474222641,
  0.01025088789256241134017416,
  0.006711890882034912187018796,
  0.003661031390200861192919343,
  0.001586446935753706516931715,
  0.000493561268901153138600978,
  0.0000841297617445147395342576,
  0.000762776506483600305110603,
  0.002961367613406918831605869,
  0.006477991654327634944137838,
  0.01036478664692421591062054,
  0.01332615426033113474222641,
  0.01435124304958737587624383,
  0.01315530612878842788655684,
  0.01025088789256241134017416,
  0.006663077130165567371113205,
  0.003454928882308071970206847,
  0.001295598330865526988827568,
  0.0002692152375824471665096244,
  0.0002692152375824471665096244,
  0.001295598330865526988827568,
  0.003454928882308071970206847,
  0.006663077130165567371113205,
  0.01025088789256241134017416,
  0.01315530612878842788655684,
  0.01435124304958737587624383,
  0.01332615426033113474222641,
  0.01036478664692421591062054,
  0.006477991654327634944137838,
  0.002961367613406918831605869,
  0.000762776506483600305110603,
  0.0000841297617445147395342576,
  0.000493561268901153138600978,
  0.001586446935753706516931715,
  0.003661031390200861192919343,
  0.006711890882034912187018796,
  0.01025088789256241134017416,
  0.01332615426033113474222641,
  0.01480683806703459415802934,
  0.01388141068784493202315251,
  0.0105763129050247101128781,
  0.005993243979514002397297592,
  0.001961425302386400784570121,
  0.00002243460313187059720913537,
  0.0001586446935753706516931715,
  0.000610171898366810198819891,
  0.001677972720508728046754699,
  0.003661031390200861192919343,
  0.006663077130165567371113205,
  0.01036478664692421591062054,
  0.01388141068784493202315251,
  0.01586446935753706516931715,
  0.01498310994878500599324398,
  0.01078783916312520431513567,
  0.004658385093167701863354037,
  4.807414956829413687671865e-6,
  0.0000406781265577873465879927,
  0.0001864414133898586718616332,
  0.000610171898366810198819891,
  0.001586446935753706516931715,
  0.003454928882308071970206847,
  0.006477991654327634944137838,
  0.0105763129050247101128781,
  0.01498310994878500599324398,
  0.01797973193854200719189278,
  0.01708074534161490683229814,
  0.01035196687370600414078675,
  7.396023010506790288725946e-7,
  7.457656535594346874465329e-6,
  0.0000406781265577873465879927,
  0.0001586446935753706516931715,
  0.000493561268901153138600978,
  0.001295598330865526988827568,
  0.002961367613406918831605869,
  0.005993243979514002397297592,
  0.01078783916312520431513567,
  0.01708074534161490683229814,
  0.02277432712215320910973085,
  0.02173913043478260869565217,
  6.16335250875565857393829e-8,
  7.396023010506790288725946e-7,
  4.807414956829413687671865e-6,
  0.00002243460313187059720913537,
  0.0000841297617445147395342576,
  0.0002692152375824471665096244,
  0.000762776506483600305110603,
  0.001961425302386400784570121,
  0.004658385093167701863354037,
  0.01035196687370600414078675,
  0.02173913043478260869565217,
  0.04347826086956521739130435,

  0.04,
  0.02,
  0.00956521739130434782608696,
  0.004347826086956521739130435,
  0.001863354037267080745341615,
  0.000745341614906832298136646,
  0.0002745995423340961098398169,
  0.0000915331807780320366132723,
  0.00002692152375824471665096244,
  6.730380939561179162740611e-6,
  1.346076187912235832548122e-6,
  1.922965982731765475068746e-7,
  1.479204602101358057745189e-8,
  0.02,
  0.02086956521739130434782609,
  0.01565217391304347826086957,
  0.00993788819875776397515528,
  0.005590062111801242236024845,
  0.002824452435436417129780974,
  0.001281464530892448512585812,
  0.000516893256158298559698479,
  0.0001817202853681518373939965,
  0.00005384304751648943330192489,
  0.00001269157548602965213545372,
  2.130054627025955603153073e-6,
  1.922965982731765475068746e-7,
  0.00956521739130434782608696,
  0.01565217391304347826086957,
  0.01639751552795031055900621,
  0.01366459627329192546583851,
  0.0097090552468126838836221,
  0.006041189931350114416475973,
  0.003316731727015749091398573,
  0.001599138511239736169067169,
  0.000666307713016556737111321,
  0.0002326788839105436224833183,
  0.0000644341524675351569953804,
  0.00001269157548602965213545372,
  1.346076187912235832548122e-6,
  0.004347826086956521739130435,
  0.00993788819875776397515528,
  0.01366459627329192546583851,
  0.01438378555083360575351422,
  0.01258581235697940503432494,
  0.00947637636290214026113878,
  0.006218871988154529546372325,
  0.003553641136088302597927043,
  0.001745091629329077168624887,
  0.000715935027417057299948672,
  0.0002326788839105436224833183,
  0.00005384304751648943330192489,
  6.730380939561179162740611e-6,
  0.001863354037267080745341615,
  0.005590062111801242236024845,
  0.0097090552468126838836221,
  0.01258581235697940503432494,
  0.01332615426033113474222641,
  0.01199353883429802126800377,
  0.00932830798223179431955849,
  0.006282329865584677807049593,
  0.00362442107629885258099015,
  0.001745091629329077168624887,
  0.000666307713016556737111321,
  0.0001817202853681518373939965,
  0.00002692152375824471665096244,
  0.000745341614906832298136646,
  0.002824452435436417129780974,
  0.006041189931350114416475973,
  0.00947637636290214026113878,
  0.01199353883429802126800377,
  0.01279310808991788935253735,
  0.01172701574909139857315924,
  0.00927851795532506260733478,
  0.006282329865584677807049593,
  0.003553641136088302597927043,
  0.001599138511239736169067169,
  0.000516893256158298559698479,
  0.0000915331807780320366132723,
  0.0002745995423340961098398169,
  0.001281464530892448512585812,
  0.003316731727015749091398573,
  0.006218871988154529546372325,
  0.00932830798223179431955849,
  0.01172701574909139857315924,
  0.01262909388363689077109457,
  0.01172701574909139857315924,
  0.00932830798223179431955849,
  0.006218871988154529546372325,
  0.003316731727015749091398573,
  0.001281464530892448512585812,
  0.0002745995423340961098398169,
  0.0000915331807780320366132723,
  0.000516893256158298559698479,
  0.001599138511239736169067169,
  0.003553641136088302597927043,
  0.006282329865584677807049593,
  0.00927851795532506260733478,
  0.01172701574909139857315924,
  0.01279310808991788935253735,
  0.01199353883429802126800377,
  0.00947637636290214026113878,
  0.006041189931350114416475973,
  0.002824452435436417129780974,
  0.000745341614906832298136646,
  0.00002692152375824471665096244,
  0.0001817202853681518373939965,
  0.000666307713016556737111321,
  0.001745091629329077168624887,
  0.00362442107629885258099015,
  0.006282329865584677807049593,
  0.00932830798223179431955849,
  0.01199353883429802126800377,
  0.01332615426033113474222641,
  0.01258581235697940503432494,
  0.0097090552468126838836221,
  0.005590062111801242236024845,
  0.001863354037267080745341615,
  6.730380939561179162740611e-6,
  0.00005384304751648943330192489,
  0.0002326788839105436224833183,
  0.000715935027417057299948672,
  0.001745091629329077168624887,
  0.003553641136088302597927043,
  0.006218871988154529546372325,
  0.00947637636290214026113878,
  0.01258581235697940503432494,
  0.01438378555083360575351422,
  0.01366459627329192546583851,
  0.00993788819875776397515528,
  0.004347826086956521739130435,
  1.346076187912235832548122e-6,
  0.00001269157548602965213545372,
  0.0000644341524675351569953804,
  0.0002326788839105436224833183,
  0.000666307713016556737111321,
  0.001599138511239736169067169,
  0.003316731727015749091398573,
  0.006041189931350114416475973,
  0.0097090552468126838836221,
  0.01366459627329192546583851,
  0.01639751552795031055900621,
  0.01565217391304347826086957,
  0.00956521739130434782608696,
  1.922965982731765475068746e-7,
  2.130054627025955603153073e-6,
  0.00001269157548602965213545372,
  0.00005384304751648943330192489,
  0.0001817202853681518373939965,
  0.000516893256158298559698479,
  0.001281464530892448512585812,
  0.002824452435436417129780974,
  0.005590062111801242236024845,
  0.00993788819875776397515528,
  0.01565217391304347826086957,
  0.02086956521739130434782609,
  0.02,
  1.479204602101358057745189e-8,
  1.922965982731765475068746e-7,
  1.346076187912235832548122e-6,
  6.730380939561179162740611e-6,
  0.00002692152375824471665096244,
  0.0000915331807780320366132723,
  0.0002745995423340961098398169,
  0.000745341614906832298136646,
  0.001863354037267080745341615,
  0.004347826086956521739130435,
  0.00956521739130434782608696,
  0.02,
  0.04,

  0.03703703703703703703703704,
  0.01851851851851851851851852,
  0.00888888888888888888888889,
  0.004074074074074074074074074,
  0.00177133655394524959742351,
  0.000724637681159420289855072,
  0.0002760524499654934437543133,
  0.0000966183574879227053140097,
  0.0000305110602593440122044241,
  8.47529451648444783456225e-6,
  1.994186945055164196367588e-6,
  3.739100521978432868189228e-7,
  4.985467362637910490918971e-8,
  3.561048116169936064942122e-9,
  0.01851851851851851851851852,
  0.01925925925925925925925926,
  0.01444444444444444444444444,
  0.00921095008051529790660225,
  0.00523349436392914653784219,
  0.002691511387163561076604555,
  0.001256038647342995169082126,
  0.000528858377828629544876684,
  0.0001983218916857360793287567,
  0.0000648110757142928363819466,
  0.00001782304582143053000503532,
  3.888664542857570182916798e-6,
  6.018171316327191949752187e-7,
  4.985467362637910490918971e-8,
  0.00888888888888888888888889,
  0.01444444444444444444444444,
  0.01507246376811594202898551,
  0.01256038647342995169082126,
  0.00897170462387853692201518,
  0.005652173913043478260869565,
  0.003173150266971777269260107,
  0.001586575133485888634630053,
  0.000699959617714362632925024,
  0.0002673456873214579500755298,
  0.0000855506199428665440241695,
  0.00002166541673877789101910787,
  3.888664542857570182916798e-6,
  3.739100521978432868189228e-7,
  0.004074074074074074074074074,
  0.00921095008051529790660225,
  0.01256038647342995169082126,
  0.01315850011502185415228893,
  0.01151368760064412238325282,
  0.00872616323417238749046529,
  0.005817442156114924993643529,
  0.003422024797714661760966782,
  0.001764481536321622470498497,
  0.000784214016142943320221554,
  0.0002912794917102360903680058,
  0.0000855506199428665440241695,
  0.00001782304582143053000503532,
  1.994186945055164196367588e-6,
  0.00177133655394524959742351,
  0.00523349436392914653784219,
  0.00897170462387853692201518,
  0.01151368760064412238325282,
  0.01211967115857276040342402,
  0.01090770404271548436308162,
  0.00855506199428665440241695,
  0.005881605121072074901661656,
  0.003528963072643244940996994,
  0.001820496823188975564800036,
  0.000784214016142943320221554,
  0.0002673456873214579500755298,
  0.0000648110757142928363819466,
  8.47529451648444783456225e-6,
  0.000724637681159420289855072,
  0.002691511387163561076604555,
  0.005652173913043478260869565,
  0.00872616323417238749046529,
  0.01090770404271548436308162,
  0.01154933369228698344326289,
  0.01058688921792973482299098,
  0.00846951137434378785839279,
  0.005898409707132280829952118,
  0.003528963072643244940996994,
  0.001764481536321622470498497,
  0.000699959617714362632925024,
  0.0001983218916857360793287567,
  0.0000305110602593440122044241,
  0.0002760524499654934437543133,
  0.001256038647342995169082126,
  0.003173150266971777269260107,
  0.005817442156114924993643529,
  0.00855506199428665440241695,
  0.01058688921792973482299098,
  0.01129268183245838381119038,
  0.01048606170156849925324821,
  0.00846951137434378785839279,
  0.005881605121072074901661656,
  0.003422024797714661760966782,
  0.001586575133485888634630053,
  0.000528858377828629544876684,
  0.0000966183574879227053140097,
  0.0000966183574879227053140097,
  0.000528858377828629544876684,
  0.001586575133485888634630053,
  0.003422024797714661760966782,
  0.005881605121072074901661656,
  0.00846951137434378785839279,
  0.01048606170156849925324821,
  0.01129268183245838381119038,
  0.01058688921792973482299098,
  0.00855506199428665440241695,
  0.005817442156114924993643529,
  0.003173150266971777269260107,
  0.001256038647342995169082126,
  0.0002760524499654934437543133,
  0.0000305110602593440122044241,
  0.0001983218916857360793287567,
  0.000699959617714362632925024,
  0.001764481536321622470498497,
  0.003528963072643244940996994,
  0.005898409707132280829952118,
  0.00846951137434378785839279,
  0.01058688921792973482299098,
  0.01154933369228698344326289,
  0.01090770404271548436308162,
  0.00872616323417238749046529,
  0.005652173913043478260869565,
  0.002691511387163561076604555,
  0.000724637681159420289855072,
  8.47529451648444783456225e-6,
  0.0000648110757142928363819466,
  0.0002673456873214579500755298,
  0.000784214016142943320221554,
  0.001820496823188975564800036,
  0.003528963072643244940996994,
  0.005881605121072074901661656,
  0.00855506199428665440241695,
  0.01090770404271548436308162,
  0.01211967115857276040342402,
  0.01151368760064412238325282,
  0.00897170462387853692201518,
  0.00523349436392914653784219,
  0.00177133655394524959742351,
  1.994186945055164196367588e-6,
  0.00001782304582143053000503532,
  0.0000855506199428665440241695,
  0.0002912794917102360903680058,
  0.000784214016142943320221554,
  0.001764481536321622470498497,
  0.003422024797714661760966782,
  0.005817442156114924993643529,
  0.00872616323417238749046529,
  0.01151368760064412238325282,
  0.01315850011502185415228893,
  0.01256038647342995169082126,
  0.00921095008051529790660225,
  0.004074074074074074074074074,
  3.739100521978432868189228e-7,
  3.888664542857570182916798e-6,
  0.00002166541673877789101910787,
  0.0000855506199428665440241695,
  0.0002673456873214579500755298,
  0.000699959617714362632925024,
  0.001586575133485888634630053,
  0.003173150266971777269260107,
  0.005652173913043478260869565,
  0.00897170462387853692201518,
  0.01256038647342995169082126,
  0.01507246376811594202898551,
  0.01444444444444444444444444,
  0.00888888888888888888888889,
  4.985467362637910490918971e-8,
  6.018171316327191949752187e-7,
  3.888664542857570182916798e-6,
  0.00001782304582143053000503532,
  0.0000648110757142928363819466,
  0.0001983218916857360793287567,
  0.000528858377828629544876684,
  0.001256038647342995169082126,
  0.002691511387163561076604555,
  0.00523349436392914653784219,
  0.00921095008051529790660225,
  0.01444444444444444444444444,
  0.01925925925925925925925926,
  0.01851851851851851851851852,
  3.561048116169936064942122e-9,
  4.985467362637910490918971e-8,
  3.739100521978432868189228e-7,
  1.994186945055164196367588e-6,
  8.47529451648444783456225e-6,
  0.0000305110602593440122044241,
  0.0000966183574879227053140097,
  0.0002760524499654934437543133,
  0.000724637681159420289855072,
  0.00177133655394524959742351,
  0.004074074074074074074074074,
  0.00888888888888888888888889,
  0.01851851851851851851851852,
  0.03703703703703703703703704,

  0.03448275862068965517241379,
  0.0172413793103448275862069,
  0.00830140485312899106002554,
  0.003831417624521072796934866,
  0.001685823754789272030651341,
  0.000702426564495530012771392,
  0.0002748625687156421789105447,
  0.0000999500249875062468765617,
  0.00003331667499583541562552057,
  9.99500249875062468765617e-6,
  2.63026381546069070727794e-6,
  5.845030701023757127284311e-7,
  1.031476006063015963638408e-7,
  1.28934500757876995454801e-8,
  8.595633383858466363653399e-10,
  0.0172413793103448275862069,
  0.01787994891443167305236271,
  0.01340996168582375478927203,
  0.0085823754789272030651341,
  0.004916985951468710089399745,
  0.002565383974679327003165084,
  0.001224387806096951524237881,
  0.000533066799933366650008329,
  0.0002098950524737631184407796,
  0.0000736473868328993398037823,
  0.0000225033681989414649400446,
  5.776265633952889396375084e-6,
  1.173303956896680658638689e-6,
  1.684744143236259407276066e-7,
  1.28934500757876995454801e-8,
  0.00830140485312899106002554,
  0.01340996168582375478927203,
  0.01394636015325670498084291,
  0.01162196679438058748403576,
  0.00833749791770781276028652,
  0.005305680493086789938364151,
  0.003031817424621022821922372,
  0.001559220389805097451274363,
  0.000718062021620768563086878,
  0.0002925437865862390442205798,
  0.0001032507482069078979602046,
  0.00003050590287931369712460591,
  7.118044005173195995741379e-6,
  1.173303956896680658638689e-6,
  1.031476006063015963638408e-7,
  0.003831417624521072796934866,
  0.0085823754789272030651341,
  0.01162196679438058748403576,
  0.01212726969848409128768949,
  0.0106113609861735798767283,
  0.00808484646565606085845966,
  0.00545727136431784107946027,
  0.003282569241694942002682869,
  0.001755262719517434265323479,
  0.000826005985655263183681637,
  0.000335564931672450668370665,
  0.0001138887040827711359318621,
  0.00003050590287931369712460591,
  5.776265633952889396375084e-6,
  5.845030701023757127284311e-7,
  0.001685823754789272030651341,
  0.004916985951468710089399745,
  0.00833749791770781276028652,
  0.0106113609861735798767283,
  0.01111666389027708368038203,
  0.01000499750124937531234383,
  0.00789868223782845419395565,
  0.005516539975626221976730933,
  0.003407274690827960632686753,
  0.001845607124198478676038658,
  0.000861283324625956715484707,
  0.000335564931672450668370665,
  0.0001032507482069078979602046,
  0.0000225033681989414649400446,
  2.63026381546069070727794e-6,
  0.000702426564495530012771392,
  0.002565383974679327003165084,
  0.005305680493086789938364151,
  0.00808484646565606085845966,
  0.01000499750124937531234383,
  0.01053157631710460559194087,
  0.00965394495734588845927913,
  0.007788056436178195731855435,
  0.005536821372595436028115973,
  0.003445133298503826861938828,
  0.001845607124198478676038658,
  0.000826005985655263183681637,
  0.0002925437865862390442205798,
  0.0000736473868328993398037823,
  9.99500249875062468765617e-6,
  0.0002748625687156421789105447,
  0.001224387806096951524237881,
  0.003031817424621022821922372,
  0.00545727136431784107946027,
  0.00789868223782845419395565,
  0.00965394495734588845927913,
  0.01022182407248388189806026,
  0.00949169378159217604819881,
  0.007751549921633610439362362,
  0.005536821372595436028115973,
  0.003407274690827960632686753,
  0.001755262719517434265323479,
  0.000718062021620768563086878,
  0.0002098950524737631184407796,
  0.00003331667499583541562552057,
  0.0000999500249875062468765617,
  0.000533066799933366650008329,
  0.001559220389805097451274363,
  0.003282569241694942002682869,
  0.005516539975626221976730933,
  0.007788056436178195731855435,
  0.00949169378159217604819881,
  0.01012447336703165445141206,
  0.00949169378159217604819881,
  0.007788056436178195731855435,
  0.005516539975626221976730933,
  0.003282569241694942002682869,
  0.001559220389805097451274363,
  0.000533066799933366650008329,
  0.0000999500249875062468765617,
  0.00003331667499583541562552057,
  0.0002098950524737631184407796,
  0.000718062021620768563086878,
  0.001755262719517434265323479,
  0.003407274690827960632686753,
  0.005536821372595436028115973,
  0.007751549921633610439362362,
  0.00949169378159217604819881,
  0.01022182407248388189806026,
  0.00965394495734588845927913,
  0.00789868223782845419395565,
  0.00545727136431784107946027,
  0.003031817424621022821922372,
  0.001224387806096951524237881,
  0.0002748625687156421789105447,
  9.99500249875062468765617e-6,
  0.0000736473868328993398037823,
  0.0002925437865862390442205798,
  0.000826005985655263183681637,
  0.001845607124198478676038658,
  0.003445133298503826861938828,
  0.005536821372595436028115973,
  0.007788056436178195731855435,
  0.00965394495734588845927913,
  0.01053157631710460559194087,
  0.01000499750124937531234383,
  0.00808484646565606085845966,
  0.005305680493086789938364151,
  0.002565383974679327003165084,
  0.000702426564495530012771392,
  2.63026381546069070727794e-6,
  0.0000225033681989414649400446,
  0.0001032507482069078979602046,
  0.000335564931672450668370665,
  0.000861283324625956715484707,
  0.001845607124198478676038658,
  0.003407274690827960632686753,
  0.005516539975626221976730933,
  0.00789868223782845419395565,
  0.01000499750124937531234383,
  0.01111666389027708368038203,
  0.0106113609861735798767283,
  0.00833749791770781276028652,
  0.004916985951468710089399745,
  0.001685823754789272030651341,
  5.845030701023757127284311e-7,
  5.776265633952889396375084e-6,
  0.00003050590287931369712460591,
  0.0001138887040827711359318621,
  0.000335564931672450668370665,
  0.000826005985655263183681637,
  0.001755262719517434265323479,
  0.003282569241694942002682869,
  0.00545727136431784107946027,
  0.00808484646565606085845966,
  0.0106113609861735798767283,
  0.01212726969848409128768949,
  0.01162196679438058748403576,
  0.0085823754789272030651341,
  0.003831417624521072796934866,
  1.031476006063015963638408e-7,
  1.173303956896680658638689e-6,
  7.118044005173195995741379e-6,
  0.00003050590287931369712460591,
  0.0001032507482069078979602046,
  0.0002925437865862390442205798,
  0.000718062021620768563086878,
  0.001559220389805097451274363,
  0.003031817424621022821922372,
  0.005305680493086789938364151,
  0.00833749791770781276028652,
  0.01162196679438058748403576,
  0.01394636015325670498084291,
  0.01340996168582375478927203,
  0.00830140485312899106002554,
  1.28934500757876995454801e-8,
  1.684744143236259407276066e-7,
  1.173303956896680658638689e-6,
  5.776265633952889396375084e-6,
  0.0000225033681989414649400446,
  0.0000736473868328993398037823,
  0.0002098950524737631184407796,
  0.000533066799933366650008329,
  0.001224387806096951524237881,
  0.002565383974679327003165084,
  0.004916985951468710089399745,
  0.0085823754789272030651341,
  0.01340996168582375478927203,
  0.01787994891443167305236271,
  0.0172413793103448275862069,
  8.595633383858466363653399e-10,
  1.28934500757876995454801e-8,
  1.031476006063015963638408e-7,
  5.845030701023757127284311e-7,
  2.63026381546069070727794e-6,
  9.99500249875062468765617e-6,
  0.00003331667499583541562552057,
  0.0000999500249875062468765617,
  0.0002748625687156421789105447,
  0.000702426564495530012771392,
  0.001685823754789272030651341,
  0.003831417624521072796934866,
  0.00830140485312899106002554,
  0.0172413793103448275862069,
  0.03448275862068965517241379,

  0.03225806451612903225806452,
  0.01612903225806451612903226,
  0.007786429365962180200222469,
  0.003615127919911012235817575,
  0.001606723519960449882585589,
  0.000679767643060190334940057,
  0.0002719070572240761339760227,
  0.0001019651464590285502410085,
  0.00003546613789879253921426384,
  0.00001128468024052489884090213,
  3.224194354435685383114894e-6,
  8.060485886089213457787235e-7,
  1.696944397071413359534155e-7,
  2.828240661785688932556925e-8,
  3.327341955041986979478735e-9,
  2.079588721901241862174209e-10,
  0.01612903225806451612903226,
  0.01668520578420467185761958,
  0.01251390433815350389321468,
  0.00803361759980224941292794,
  0.00463477938450129773822766,
  0.002447163515016685205784205,
  0.001189593375355333086145099,
  0.000531992068481888088213958,
  0.0002176331189244087633602554,
  0.0000806048588608921345778724,
  0.00002659960342409440441069788,
  7.6362497868213601179037e-6,
  1.838356430160697806162001e-6,
  3.493709052794086328452672e-7,
  4.679074624277794189891971e-8,
  3.327341955041986979478735e-9,
  0.007786429365962180200222469,
  0.01251390433815350389321468,
  0.01297738227660363366703745,
  0.01081448523050302805586454,
  0.007786429365962180200222469,
  0.004996292176492398961809418,
  0.002896401261734724035831547,
  0.001523431832470861343521787,
  0.000725443729748029211200851,
  0.0003103287066144347181248086,
  0.0001175982467170489458157169,
  0.00003860548503337465392940202,
  0.00001059758412680872852963977,
  2.292746565896119153047066e-6,
  3.493709052794086328452672e-7,
  2.828240661785688932556925e-8,
  0.003615127919911012235817575,
  0.00803361759980224941292794,
  0.01081448523050302805586454,
  0.01124706463972314917809912,
  0.00984118155975775553083673,
  0.007530643280510282493162021,
  0.005134529509438828972610469,
  0.003143589495574793248537022,
  0.001728974222566136286695362,
  0.000849320670734242386446844,
  0.0003680389573181717007936326,
  0.000137768593648513470885317,
  0.00004305268551516045965166157,
  0.00001059758412680872852963977,
  1.838356430160697806162001e-6,
  1.696944397071413359534155e-7,
  0.001606723519960449882585589,
  0.00463477938450129773822766,
  0.007786429365962180200222469,
  0.00984118155975775553083673,
  0.01026905901887765794522094,
  0.00924215311698989215069884,
  0.007335042156341184246586384,
  0.005186922667698408860086086,
  0.003275951158546363490580686,
  0.001840194786590858503968163,
  0.000909272718080188907843092,
  0.0003874741696364441368649541,
  0.000137768593648513470885317,
  0.00003860548503337465392940202,
  7.6362497868213601179037e-6,
  8.060485886089213457787235e-7,
  0.000679767643060190334940057,
  0.002447163515016685205784205,
  0.004996292176492398961809418,
  0.007530643280510282493162021,
  0.00924215311698989215069884,
  0.00968225564637036320549403,
  0.00887540100917283293836952,
  0.007207092548801999679277509,
  0.00520512239635699976836709,
  0.003333999966294025995424672,
  0.001875374981040389622426378,
  0.000909272718080188907843092,
  0.0003680389573181717007936326,
  0.0001175982467170489458157169,
  0.00002659960342409440441069788,
  3.224194354435685383114894e-6,
  0.0002719070572240761339760227,
  0.001189593375355333086145099,
  0.002896401261734724035831547,
  0.005134529509438828972610469,
  0.007335042156341184246586384,
  0.00887540100917283293836952,
  0.00934252737807666625091529,
  0.00867520399392833294727848,
  0.007144285642058627133052868,
  0.00520937494733441561785105,
  0.003333999966294025995424672,
  0.001840194786590858503968163,
  0.000849320670734242386446844,
  0.0003103287066144347181248086,
  0.0000806048588608921345778724,
  0.00001128468024052489884090213,
  0.0001019651464590285502410085,
  0.000531992068481888088213958,
  0.001523431832470861343521787,
  0.003143589495574793248537022,
  0.005186922667698408860086086,
  0.007207092548801999679277509,
  0.00867520399392833294727848,
  0.00918551011121823488535369,
  0.00861141572926709520501908,
  0.007144285642058627133052868,
  0.00520512239635699976836709,
  0.003275951158546363490580686,
  0.001728974222566136286695362,
  0.000725443729748029211200851,
  0.0002176331189244087633602554,
  0.00003546613789879253921426384,
  0.00003546613789879253921426384,
  0.0002176331189244087633602554,
  0.000725443729748029211200851,
  0.001728974222566136286695362,
  0.003275951158546363490580686,
  0.00520512239635699976836709,
  0.007144285642058627133052868,
  0.00861141572926709520501908,
  0.00918551011121823488535369,
  0.00867520399392833294727848,
  0.007207092548801999679277509,
  0.005186922667698408860086086,
  0.003143589495574793248537022,
  0.001523431832470861343521787,
  0.000531992068481888088213958,
  0.0001019651464590285502410085,
  0.00001128468024052489884090213,
  0.0000806048588608921345778724,
  0.0003103287066144347181248086,
  0.000849320670734242386446844,
  0.001840194786590858503968163,
  0.003333999966294025995424672,
  0.00520937494733441561785105,
  0.007144285642058627133052868,
  0.00867520399392833294727848,
  0.00934252737807666625091529,
  0.00887540100917283293836952,
  0.007335042156341184246586384,
  0.005134529509438828972610469,
  0.002896401261734724035831547,
  0.001189593375355333086145099,
  0.0002719070572240761339760227,
  3.224194354435685383114894e-6,
  0.00002659960342409440441069788,
  0.0001175982467170489458157169,
  0.0003680389573181717007936326,
  0.000909272718080188907843092,
  0.001875374981040389622426378,
  0.003333999966294025995424672,
  0.00520512239635699976836709,
  0.007207092548801999679277509,
  0.00887540100917283293836952,
  0.00968225564637036320549403,
  0.00924215311698989215069884,
  0.007530643280510282493162021,
  0.004996292176492398961809418,
  0.002447163515016685205784205,
  0.000679767643060190334940057,
  8.060485886089213457787235e-7,
  7.6362497868213601179037e-6,
  0.00003860548503337465392940202,
  0.000137768593648513470885317,
  0.0003874741696364441368649541,
  0.000909272718080188907843092,
  0.001840194786590858503968163,
  0.003275951158546363490580686,
  0.005186922667698408860086086,
  0.007335042156341184246586384,
  0.00924215311698989215069884,
  0.01026905901887765794522094,
  0.00984118155975775553083673,
  0.007786429365962180200222469,
  0.00463477938450129773822766,
  0.001606723519960449882585589,
  1.696944397071413359534155e-7,
  1.838356430160697806162001e-6,
  0.00001059758412680872852963977,
  0.00004305268551516045965166157,
  0.000137768593648513470885317,
  0.0003680389573181717007936326,
  0.000849320670734242386446844,
  0.001728974222566136286695362,
  0.003143589495574793248537022,
  0.005134529509438828972610469,
  0.007530643280510282493162021,
  0.00984118155975775553083673,
  0.01124706463972314917809912,
  0.01081448523050302805586454,
  0.00803361759980224941292794,
  0.003615127919911012235817575,
  2.828240661785688932556925e-8,
  3.493709052794086328452672e-7,
  2.292746565896119153047066e-6,
  0.00001059758412680872852963977,
  0.00003860548503337465392940202,
  0.0001175982467170489458157169,
  0.0003103287066144347181248086,
  0.000725443729748029211200851,
  0.001523431832470861343521787,
  0.002896401261734724035831547,
  0.004996292176492398961809418,
  0.007786429365962180200222469,
  0.01081448523050302805586454,
  0.01297738227660363366703745,
  0.01251390433815350389321468,
  0.007786429365962180200222469,
  3.327341955041986979478735e-9,
  4.679074624277794189891971e-8,
  3.493709052794086328452672e-7,
  1.838356430160697806162001e-6,
  7.6362497868213601179037e-6,
  0.00002659960342409440441069788,
  0.0000806048588608921345778724,
  0.0002176331189244087633602554,
  0.000531992068481888088213958,
  0.001189593375355333086145099,
  0.002447163515016685205784205,
  0.00463477938450129773822766,
  0.00803361759980224941292794,
  0.01251390433815350389321468,
  0.01668520578420467185761958,
  0.01612903225806451612903226,
  2.079588721901241862174209e-10,
  3.327341955041986979478735e-9,
  2.828240661785688932556925e-8,
  1.696944397071413359534155e-7,
  8.060485886089213457787235e-7,
  3.224194354435685383114894e-6,
  0.00001128468024052489884090213,
  0.00003546613789879253921426384,
  0.0001019651464590285502410085,
  0.0002719070572240761339760227,
  0.000679767643060190334940057,
  0.001606723519960449882585589,
  0.003615127919911012235817575,
  0.007786429365962180200222469,
  0.01612903225806451612903226,
  0.03225806451612903225806452,

  0.03030303030303030303030303,
  0.01515151515151515151515152,
  0.007331378299120234604105572,
  0.0034213098729227761485826,
  0.001533690632689520342468062,
  0.000657295985438365861057741,
  0.0002677872533267416470975982,
  0.0001029950974333621719606147,
  0.00003707823507601038190582128,
  0.00001235941169200346063527376,
  3.76156008017496628030071e-6,
  1.025880021865899894627466e-6,
  2.442571480633094987208253e-7,
  4.885142961266189974416506e-8,
  7.71338362305187890697343e-9,
  8.570426247835421007748257e-10,
  5.041427204609071181028386e-11,
  0.01515151515151515151515152,
  0.01564027370478983382209189,
  0.01173020527859237536656891,
  0.007550476960933023224458152,
  0.004381973236255772407051606,
  0.002337052392669745283760857,
  0.001153545091253656325958884,
  0.000527334898858814320438347,
  0.0002224694104560622914349277,
  0.0000859785161182849435497305,
  0.00003009248064139973024240568,
  9.37947448563108475087969e-6,
  2.540274339858418786696583e-6,
  5.759326438545402917206828e-7,
  1.028451149740250520929791e-7,
  1.290605364379922222343267e-8,
  8.570426247835421007748257e-10,
  0.007331378299120234604105572,
  0.01173020527859237536656891,
  0.0121346951157852158964506,
  0.01011224592982101324704217,
  0.007303288727092954011752677,
  0.004719048100583139515286345,
  0.002768508219008775182301322,
  0.001483129403040415276232851,
  0.000725443729748029211200851,
  0.0003224194354435685383114894,
  0.0001289677741774274153245958,
  0.0000457249381174515381605385,
  0.00001403835819395441961069164,
  3.599579024090876823254268e-6,
  7.259655174637062500680876e-7,
  1.028451149740250520929791e-7,
  7.71338362305187890697343e-9,
  0.0034213098729227761485826,
  0.007550476960933023224458152,
  0.01011224592982101324704217,
  0.01048677355685142114508077,
  0.00917592686224499350194567,
  0.007047111830204155009494275,
  0.004844889383265356569027314,
  0.003009248064139973024240568,
  0.001692702036078734826135319,
  0.000859785161182849435497305,
  0.0003912022483381964931512738,
  0.0001572296117722894996397464,
  0.0000545936151987116318193564,
  0.00001580991571365404722370502,
  3.599579024090876823254268e-6,
  5.759326438545402917206828e-7,
  4.885142961266189974416506e-8,
  0.001533690632689520342468062,
  0.004381973236255772407051606,
  0.007303288727092954011752677,
  0.00917592686224499350194567,
  0.0095429639367347932420235,
  0.00858866754306131391782115,
  0.006846039345918438630147292,
  0.004890028104227456164390923,
  0.003143589495574793248537022,
  0.001816296152998769432488057,
  0.000936826436809891602020156,
  0.0004258301985499507281909799,
  0.0001669922347254708738003843,
  0.0000545936151987116318193564,
  0.00001403835819395441961069164,
  2.540274339858418786696583e-6,
  2.442571480633094987208253e-7,
  0.000657295985438365861057741,
  0.002337052392669745283760857,
  0.004719048100583139515286345,
  0.007047111830204155009494275,
  0.00858866754306131391782115,
  0.00896208787102050147946555,
  0.00821524721510212635617675,
  0.00670632425722622559687898,
  0.004903999613096677467717754,
  0.003211976354776771206926248,
  0.001873652873619783204040311,
  0.000961875272018712233090213,
  0.0004258301985499507281909799,
  0.0001572296117722894996397464,
  0.0000457249381174515381605385,
  9.37947448563108475087969e-6,
  1.025880021865899894627466e-6,
  0.0002677872533267416470975982,
  0.001153545091253656325958884,
  0.002768508219008775182301322,
  0.004844889383265356569027314,
  0.006846039345918438630147292,
  0.00821524721510212635617675,
  0.00860644946344032284932802,
  0.00799170307319458550294745,
  0.006624701231727090614285387,
  0.004907186097575622677248435,
  0.003232969664285116116775439,
  0.001873652873619783204040311,
  0.000936826436809891602020156,
  0.0003912022483381964931512738,
  0.0001289677741774274153245958,
  0.00003009248064139973024240568,
  3.76156008017496628030071e-6,
  0.0001029950974333621719606147,
  0.000527334898858814320438347,
  0.001483129403040415276232851,
  0.003009248064139973024240568,
  0.004890028104227456164390923,
  0.00670632425722622559687898,
  0.00799170307319458550294745,
  0.00841231902441535316099732,
  0.00788654908538939358843498,
  0.006597897274051257381174366,
  0.004907186097575622677248435,
  0.003211976354776771206926248,
  0.001816296152998769432488057,
  0.000859785161182849435497305,
  0.0003224194354435685383114894,
  0.0000859785161182849435497305,
  0.00001235941169200346063527376,
  0.00003707823507601038190582128,
  0.0002224694104560622914349277,
  0.000725443729748029211200851,
  0.001692702036078734826135319,
  0.003143589495574793248537022,
  0.004903999613096677467717754,
  0.006624701231727090614285387,
  0.00788654908538939358843498,
  0.00835046373747112262304881,
  0.00788654908538939358843498,
  0.006624701231727090614285387,
  0.004903999613096677467717754,
  0.003143589495574793248537022,
  0.001692702036078734826135319,
  0.000725443729748029211200851,
  0.0002224694104560622914349277,
  0.00003707823507601038190582128,
  0.00001235941169200346063527376,
  0.0000859785161182849435497305,
  0.0003224194354435685383114894,
  0.000859785161182849435497305,
  0.001816296152998769432488057,
  0.003211976354776771206926248,
  0.004907186097575622677248435,
  0.006597897274051257381174366,
  0.00788654908538939358843498,
  0.00841231902441535316099732,
  0.00799170307319458550294745,
  0.00670632425722622559687898,
  0.004890028104227456164390923,
  0.003009248064139973024240568,
  0.001483129403040415276232851,
  0.000527334898858814320438347,
  0.0001029950974333621719606147,
  3.76156008017496628030071e-6,
  0.00003009248064139973024240568,
  0.0001289677741774274153245958,
  0.0003912022483381964931512738,
  0.000936826436809891602020156,
  0.001873652873619783204040311,
  0.003232969664285116116775439,
  0.004907186097575622677248435,
  0.006624701231727090614285387,
  0.00799170307319458550294745,
  0.00860644946344032284932802,
  0.00821524721510212635617675,
  0.006846039345918438630147292,
  0.004844889383265356569027314,
  0.002768508219008775182301322,
  0.001153545091253656325958884,
  0.0002677872533267416470975982,
  1.025880021865899894627466e-6,
  9.37947448563108475087969e-6,
  0.0000457249381174515381605385,
  0.0001572296117722894996397464,
  0.0004258301985499507281909799,
  0.000961875272018712233090213,
  0.001873652873619783204040311,
  0.003211976354776771206926248,
  0.004903999613096677467717754,
  0.00670632425722622559687898,
  0.00821524721510212635617675,
  0.00896208787102050147946555,
  0.00858866754306131391782115,
  0.007047111830204155009494275,
  0.004719048100583139515286345,
  0.002337052392669745283760857,
  0.000657295985438365861057741,
  2.442571480633094987208253e-7,
  2.540274339858418786696583e-6,
  0.00001403835819395441961069164,
  0.0000545936151987116318193564,
  0.0001669922347254708738003843,
  0.0004258301985499507281909799,
  0.000936826436809891602020156,
  0.001816296152998769432488057,
  0.003143589495574793248537022,
  0.004890028104227456164390923,
  0.006846039345918438630147292,
  0.00858866754306131391782115,
  0.0095429639367347932420235,
  0.00917592686224499350194567,
  0.007303288727092954011752677,
  0.004381973236255772407051606,
  0.001533690632689520342468062,
  4.885142961266189974416506e-8,
  5.759326438545402917206828e-7,
  3.599579024090876823254268e-6,
  0.00001580991571365404722370502,
  0.0000545936151987116318193564,
  0.0001572296117722894996397464,
  0.0003912022483381964931512738,
  0.000859785161182849435497305,
  0.001692702036078734826135319,
  0.003009248064139973024240568,
  0.004844889383265356569027314,
  0.007047111830204155009494275,
  0.00917592686224499350194567,
  0.01048677355685142114508077,
  0.01011224592982101324704217,
  0.007550476960933023224458152,
  0.0034213098729227761485826,
  7.71338362305187890697343e-9,
  1.028451149740250520929791e-7,
  7.259655174637062500680876e-7,
  3.599579024090876823254268e-6,
  0.00001403835819395441961069164,
  0.0000457249381174515381605385,
  0.0001289677741774274153245958,
  0.0003224194354435685383114894,
  0.000725443729748029211200851,
  0.001483129403040415276232851,
  0.002768508219008775182301322,
  0.004719048100583139515286345,
  0.007303288727092954011752677,
  0.01011224592982101324704217,
  0.0121346951157852158964506,
  0.01173020527859237536656891,
  0.007331378299120234604105572,
  8.570426247835421007748257e-10,
  1.290605364379922222343267e-8,
  1.028451149740250520929791e-7,
  5.759326438545402917206828e-7,
  2.540274339858418786696583e-6,
  9.37947448563108475087969e-6,
  0.00003009248064139973024240568,
  0.0000859785161182849435497305,
  0.0002224694104560622914349277,
  0.000527334898858814320438347,
  0.001153545091253656325958884,
  0.002337052392669745283760857,
  0.004381973236255772407051606,
  0.007550476960933023224458152,
  0.01173020527859237536656891,
  0.01564027370478983382209189,
  0.01515151515151515151515152,
  5.041427204609071181028386e-11,
  8.570426247835421007748257e-10,
  7.71338362305187890697343e-9,
  4.885142961266189974416506e-8,
  2.442571480633094987208253e-7,
  1.025880021865899894627466e-6,
  3.76156008017496628030071e-6,
  0.00001235941169200346063527376,
  0.00003707823507601038190582128,
  0.0001029950974333621719606147,
  0.0002677872533267416470975982,
  0.000657295985438365861057741,
  0.001533690632689520342468062,
  0.0034213098729227761485826,
  0.007331378299120234604105572,
  0.01515151515151515151515152,
  0.03030303030303030303030303,

  0.02857142857142857142857143,
  0.01428571428571428571428571,
  0.006926406926406926406926407,
  0.003246753246753246753246753,
  0.001466275659824046920821114,
  0.000635386119257086999022483,
  0.0002629183941753463444230964,
  0.0001032893691403146353090736,
  0.00003825532190382023529965688,
  0.00001324222681286085068065046,
  4.237512580115472217808147e-6,
  1.235941169200346063527376e-6,
  3.224194354435685383114894e-7,
  7.32771444189928496162476e-8,
  1.39575513179033999269043e-8,
  2.093632697685509989035646e-9,
  2.203823892300536830563837e-10,
  1.224346606833631572535465e-11,
  0.01428571428571428571428571,
  0.01471861471861471861471861,
  0.01103896103896103896103896,
  0.007121910347716799329702556,
  0.004154447702834799608993157,
  0.002234806350490443927596319,
  0.00111740317524522196379816,
  0.000520272377891955200075334,
  0.0002251178558186344615710578,
  0.0000900471423274537846284231,
  0.00003301728552006638769708848,
  0.00001096226080508133030259064,
  3.238849783319483953038144e-6,
  8.304743034152522956508061e-7,
  1.779587793032683490680299e-7,
  2.997200493528730089566819e-8,
  3.538361693749195244627495e-9,
  2.203823892300536830563837e-10,
  0.006926406926406926406926407,
  0.01103896103896103896103896,
  0.01139505655634687892752409,
  0.00949588046362239910627007,
  0.006876327232278289007988674,
  0.004469612700980887855192638,
  0.002648659378359044654928971,
  0.00144075427723926055405477,
  0.000720377138619630277027385,
  0.0003301728552006638769708848,
  0.0001378112786924510095182823,
  0.0000518215965331117432486103,
  0.00001727386551103724774953677,
  4.982845820491513773904836e-6,
  1.198880197411492035826728e-6,
  2.264551483999484956561597e-7,
  2.997200493528730089566819e-8,
  2.093632697685509989035646e-9,
  0.003246753246753246753246753,
  0.007121910347716799329702556,
  0.00949588046362239910627007,
  0.00982332461754041286855525,
  0.00859540904034786125998584,
  0.006621648445897611637322427,
  0.00458421815485219267199245,
  0.00288150855447852110810954,
  0.001650864276003319384854424,
  0.000861320491827818809489265,
  0.0004071696870458779826676523,
  0.0001727386551103724774953677,
  0.0000647769956663896790607629,
  0.00002098040345470111062696773,
  5.661378709998712391403991e-6,
  1.198880197411492035826728e-6,
  1.779587793032683490680299e-7,
  1.39575513179033999269043e-8,
  0.001466275659824046920821114,
  0.004154447702834799608993157,
  0.006876327232278289007988674,
  0.00859540904034786125998584,
  0.00891375752332370797331865,
  0.00802238177099133717598679,
  0.006417905416793069740789429,
  0.004622419972809294277592387,
  0.003014621721397365833212426,
  0.001781367380825716174170979,
  0.000950062603107048626224522,
  0.0004534389696647277534253401,
  0.0001909216714377801067054064,
  0.0000693518891974842267946989,
  0.00002098040345470111062696773,
  4.982845820491513773904836e-6,
  8.304743034152522956508061e-7,
  7.32771444189928496162476e-8,
  0.000635386119257086999022483,
  0.002234806350490443927596319,
  0.004469612700980887855192638,
  0.006621648445897611637322427,
  0.00802238177099133717598679,
  0.00834327704183099066302626,
  0.007648003955011741441107403,
  0.006270413180506520933081846,
  0.004631555190146862052844545,
  0.003087703460097908035229697,
  0.001852622076058744821137818,
  0.000992792691476456554868113,
  0.0004688187709749933731321645,
  0.0001909216714377801067054064,
  0.0000647769956663896790607629,
  0.00001727386551103724774953677,
  3.238849783319483953038144e-6,
  3.224194354435685383114894e-7,
  0.0002629183941753463444230964,
  0.00111740317524522196379816,
  0.002648659378359044654928971,
  0.00458421815485219267199245,
  0.006417905416793069740789429,
  0.007648003955011741441107403,
  0.00798052586609920846028599,
  0.007410488304234979284551273,
  0.006175406920195816070459394,
  0.004631555190146862052844545,
  0.003120205601783149172442641,
  0.001875275083899973492528658,
  0.000992792691476456554868113,
  0.0004534389696647277534253401,
  0.0001727386551103724774953677,
  0.0000518215965331117432486103,
  0.00001096226080508133030259064,
  1.235941169200346063527376e-6,
  0.0001032893691403146353090736,
  0.000520272377891955200075334,
  0.00144075427723926055405477,
  0.00288150855447852110810954,
  0.004622419972809294277592387,
  0.006270413180506520933081846,
  0.007410488304234979284551273,
  0.007763368699674740202863238,
  0.007278158155945068940184286,
  0.006128975289216900160155188,
  0.004630781329630546787672809,
  0.003120205601783149172442641,
  0.001852622076058744821137818,
  0.000950062603107048626224522,
  0.0004071696870458779826676523,
  0.0001378112786924510095182823,
  0.00003301728552006638769708848,
  4.237512580115472217808147e-6,
  0.00003825532190382023529965688,
  0.0002251178558186344615710578,
  0.000720377138619630277027385,
  0.001650864276003319384854424,
  0.003014621721397365833212426,
  0.004631555190146862052844545,
  0.006175406920195816070459394,
  0.007278158155945068940184286,
  0.007661219111521125200193985,
  0.007235595827547729355738764,
  0.006128975289216900160155188,
  0.004631555190146862052844545,
  0.003087703460097908035229697,
  0.001781367380825716174170979,
  0.000861320491827818809489265,
  0.0003301728552006638769708848,
  0.0000900471423274537846284231,
  0.00001324222681286085068065046,
  0.00001324222681286085068065046,
  0.0000900471423274537846284231,
  0.0003301728552006638769708848,
  0.000861320491827818809489265,
  0.001781367380825716174170979,
  0.003087703460097908035229697,
  0.004631555190146862052844545,
  0.006128975289216900160155188,
  0.007235595827547729355738764,
  0.007661219111521125200193985,
  0.007278158155945068940184286,
  0.006175406920195816070459394,
  0.004631555190146862052844545,
  0.003014621721397365833212426,
  0.001650864276003319384854424,
  0.000720377138619630277027385,
  0.0002251178558186344615710578,
  0.00003825532190382023529965688,
  4.237512580115472217808147e-6,
  0.00003301728552006638769708848,
  0.0001378112786924510095182823,
  0.0004071696870458779826676523,
  0.000950062603107048626224522,
  0.001852622076058744821137818,
  0.003120205601783149172442641,
  0.004630781329630546787672809,
  0.006128975289216900160155188,
  0.007278158155945068940184286,
  0.007763368699674740202863238,
  0.007410488304234979284551273,
  0.006270413180506520933081846,
  0.004622419972809294277592387,
  0.00288150855447852110810954,
  0.00144075427723926055405477,
  0.000520272377891955200075334,
  0.0001032893691403146353090736,
  1.235941169200346063527376e-6,
  0.00001096226080508133030259064,
  0.0000518215965331117432486103,
  0.0001727386551103724774953677,
  0.0004534389696647277534253401,
  0.000992792691476456554868113,
  0.001875275083899973492528658,
  0.003120205601783149172442641,
  0.004631555190146862052844545,
  0.006175406920195816070459394,
  0.007410488304234979284551273,
  0.00798052586609920846028599,
  0.007648003955011741441107403,
  0.006417905416793069740789429,
  0.00458421815485219267199245,
  0.002648659378359044654928971,
  0.00111740317524522196379816,
  0.0002629183941753463444230964,
  3.224194354435685383114894e-7,
  3.238849783319483953038144e-6,
  0.00001727386551103724774953677,
  0.0000647769956663896790607629,
  0.0001909216714377801067054064,
  0.0004688187709749933731321645,
  0.000992792691476456554868113,
  0.001852622076058744821137818,
  0.003087703460097908035229697,
  0.004631555190146862052844545,
  0.006270413180506520933081846,
  0.007648003955011741441107403,
  0.00834327704183099066302626,
  0.00802238177099133717598679,
  0.006621648445897611637322427,
  0.004469612700980887855192638,
  0.002234806350490443927596319,
  0.000635386119257086999022483,
  7.32771444189928496162476e-8,
  8.304743034152522956508061e-7,
  4.982845820491513773904836e-6,
  0.00002098040345470111062696773,
  0.0000693518891974842267946989,
  0.0001909216714377801067054064,
  0.0004534389696647277534253401,
  0.000950062603107048626224522,
  0.001781367380825716174170979,
  0.003014621721397365833212426,
  0.004622419972809294277592387,
  0.006417905416793069740789429,
  0.00802238177099133717598679,
  0.00891375752332370797331865,
  0.00859540904034786125998584,
  0.006876327232278289007988674,
  0.004154447702834799608993157,
  0.001466275659824046920821114,
  1.39575513179033999269043e-8,
  1.779587793032683490680299e-7,
  1.198880197411492035826728e-6,
  5.661378709998712391403991e-6,
  0.00002098040345470111062696773,
  0.0000647769956663896790607629,
  0.0001727386551103724774953677,
  0.0004071696870458779826676523,
  0.000861320491827818809489265,
  0.001650864276003319384854424,
  0.00288150855447852110810954,
  0.00458421815485219267199245,
  0.006621648445897611637322427,
  0.00859540904034786125998584,
  0.00982332461754041286855525,
  0.00949588046362239910627007,
  0.007121910347716799329702556,
  0.003246753246753246753246753,
  2.093632697685509989035646e-9,
  2.997200493528730089566819e-8,
  2.264551483999484956561597e-7,
  1.198880197411492035826728e-6,
  4.982845820491513773904836e-6,
  0.00001727386551103724774953677,
  0.0000518215965331117432486103,
  0.0001378112786924510095182823,
  0.0003301728552006638769708848,
  0.000720377138619630277027385,
  0.00144075427723926055405477,
  0.002648659378359044654928971,
  0.004469612700980887855192638,
  0.006876327232278289007988674,
  0.00949588046362239910627007,
  0.01139505655634687892752409,
  0.01103896103896103896103896,
  0.006926406926406926406926407,
  2.203823892300536830563837e-10,
  3.538361693749195244627495e-9,
  2.997200493528730089566819e-8,
  1.779587793032683490680299e-7,
  8.304743034152522956508061e-7,
  3.238849783319483953038144e-6,
  0.00001096226080508133030259064,
  0.00003301728552006638769708848,
  0.0000900471423274537846284231,
  0.0002251178558186344615710578,
  0.000520272377891955200075334,
  0.00111740317524522196379816,
  0.002234806350490443927596319,
  0.004154447702834799608993157,
  0.007121910347716799329702556,
  0.01103896103896103896103896,
  0.01471861471861471861471861,
  0.01428571428571428571428571,
  1.224346606833631572535465e-11,
  2.203823892300536830563837e-10,
  2.093632697685509989035646e-9,
  1.39575513179033999269043e-8,
  7.32771444189928496162476e-8,
  3.224194354435685383114894e-7,
  1.235941169200346063527376e-6,
  4.237512580115472217808147e-6,
  0.00001324222681286085068065046,
  0.00003825532190382023529965688,
  0.0001032893691403146353090736,
  0.0002629183941753463444230964,
  0.000635386119257086999022483,
  0.001466275659824046920821114,
  0.003246753246753246753246753,
  0.006926406926406926406926407,
  0.01428571428571428571428571,
  0.02857142857142857142857143,

  0.02702702702702702702702703,
  0.01351351351351351351351351,
  0.006563706563706563706563707,
  0.003088803088803088803088803,
  0.001404001404001404001404001,
  0.000614250614250614250614251,
  0.0002575889672663866212253309,
  0.0001030355869065546484901324,
  0.00003908246399903797011694676,
  0.0000139580228567992750417667,
  4.652674285599758347255566e-6,
  1.431592087876848722232482e-6,
  4.00845784605517642225095e-7,
  1.002114461513794105562737e-7,
  2.17850969894303066426682e-8,
  3.960926725350964844121492e-9,
  5.658466750501378348744988e-10,
  5.658466750501378348744988e-11,
  2.978140395000725446707888e-12,
  0.01351351351351351351351351,
  0.01389961389961389961389961,
  0.01042471042471042471042471,
  0.006739206739206739206739207,
  0.003948753948753948753948754,
  0.002139969881905365776333518,
  0.00108187366251882380914639,
  0.000511624983260133426985485,
  0.0002261199702801482556766205,
  0.0000930534857119951669451113,
  0.00003543190417495200587525393,
  0.00001236895563925597296008864,
  3.908246399903797011694676e-6,
  1.097968888267287454790477e-6,
  2.673625539611901269782007e-7,
  5.432128080481323214795188e-8,
  8.65745412826710887357983e-9,
  9.64917487980235044733356e-10,
  5.658466750501378348744988e-11,
  0.006563706563706563706563707,
  0.01042471042471042471042471,
  0.01074061074061074061074061,
  0.00895050895050895050895051,
  0.006496337141498431821012466,
  0.004244273599112308789728145,
  0.002536807208664828242136362,
  0.0013978325435500073987282,
  0.000711859165696763027130102,
  0.0003346346505412133888218427,
  0.000144562169033804183971036,
  0.00005694873325574104217040813,
  0.00002022092702558921062572463,
  6.363228784276325022081176e-6,
  1.731490825653421774715966e-6,
  3.924712538147756022689524e-7,
  6.9715288506571981981985e-8,
  8.65745412826710887357983e-9,
  5.658466750501378348744988e-10,
  0.003088803088803088803088803,
  0.006739206739206739206739207,
  0.00895050895050895050895051,
  0.0092392350456866585898844,
  0.00808433066497582626614885,
  0.006244448513636500288335661,
  0.004348812357711134129376621,
  0.002761150703308656590080394,
  0.001606246322597824266344845,
  0.000856664705385506275383917,
  0.0004176240438754343092496596,
  0.0001848770470911013542923394,
  0.0000735306437294153113662714,
  0.0000258569296630910985024251,
  7.84942507629551204537905e-6,
  1.983012650853603043043128e-6,
  3.924712538147756022689524e-7,
  5.432128080481323214795188e-8,
  3.960926725350964844121492e-9,
  0.001404001404001404001404001,
  0.003948753948753948753948754,
  0.006496337141498431821012466,
  0.00808433066497582626614885,
  0.00836310068790602717187812,
  0.007526790619115424454690306,
  0.006040017163487686290800863,
  0.004380671788903157090031395,
  0.002891243380676083679420721,
  0.001740100182814309621873582,
  0.000953272274063491358069875,
  0.0004726969954033841444974588,
  0.0002100875535126151753322039,
  0.00008241896330110287647648,
  0.00002788611540262879279279398,
  7.84942507629551204537905e-6,
  1.731490825653421774715966e-6,
  2.673625539611901269782007e-7,
  2.17850969894303066426682e-8,
  0.000614250614250614250614251,
  0.002139969881905365776333518,
  0.004244273599112308789728145,
  0.006244448513636500288335661,
  0.007526790619115424454690306,
  0.007805560642045625360419576,
  0.007155097255208489913717945,
  0.005887622884285843129002195,
  0.004385052460692060247121426,
  0.002965735963753084225106279,
  0.001819883432303028956315216,
  0.001008420256860552841594579,
  0.000500008377360024117290645,
  0.0002186271447566097354955048,
  0.00008241896330110287647648,
  0.0000258569296630910985024251,
  6.363228784276325022081176e-6,
  1.097968888267287454790477e-6,
  1.002114461513794105562737e-7,
  0.0002575889672663866212253309,
  0.00108187366251882380914639,
  0.002536807208664828242136362,
  0.004348812357711134129376621,
  0.006040017163487686290800863,
  0.007155097255208489913717945,
  0.007441301145416829510266663,
  0.006909779635029913116676187,
  0.005783185129318514238957243,
  0.004381200855544328968907002,
  0.003004252015230397007250516,
  0.001857173973051518149936683,
  0.001026332985107417924965009,
  0.000500008377360024117290645,
  0.0002100875535126151753322039,
  0.0000735306437294153113662714,
  0.00002022092702558921062572463,
  3.908246399903797011694676e-6,
  4.00845784605517642225095e-7,
  0.0001030355869065546484901324,
  0.000511624983260133426985485,
  0.0013978325435500073987282,
  0.002761150703308656590080394,
  0.004380671788903157090031395,
  0.005887622884285843129002195,
  0.006909779635029913116676187,
  0.007210204836552952817401238,
  0.006759567034268393266313661,
  0.005722384790915041918572411,
  0.004377624365050007067707895,
  0.003016162241948330228468597,
  0.001857173973051518149936683,
  0.001008420256860552841594579,
  0.0004726969954033841444974588,
  0.0001848770470911013542923394,
  0.00005694873325574104217040813,
  0.00001236895563925597296008864,
  1.431592087876848722232482e-6,
  0.00003908246399903797011694676,
  0.0002261199702801482556766205,
  0.000711859165696763027130102,
  0.001606246322597824266344845,
  0.002891243380676083679420721,
  0.004385052460692060247121426,
  0.005783185129318514238957243,
  0.006759567034268393266313661,
  0.007081451178757364374233359,
  0.006688037224381955242331506,
  0.005702431738683561838198442,
  0.004377624365050007067707895,
  0.003004252015230397007250516,
  0.001819883432303028956315216,
  0.000953272274063491358069875,
  0.0004176240438754343092496596,
  0.000144562169033804183971036,
  0.00003543190417495200587525393,
  4.652674285599758347255566e-6,
  0.0000139580228567992750417667,
  0.0000930534857119951669451113,
  0.0003346346505412133888218427,
  0.000856664705385506275383917,
  0.001740100182814309621873582,
  0.002965735963753084225106279,
  0.004381200855544328968907002,
  0.005722384790915041918572411,
  0.006688037224381955242331506,
  0.007040039183559952886664743,
  0.006688037224381955242331506,
  0.005722384790915041918572411,
  0.004381200855544328968907002,
  0.002965735963753084225106279,
  0.001740100182814309621873582,
  0.000856664705385506275383917,
  0.0003346346505412133888218427,
  0.0000930534857119951669451113,
  0.0000139580228567992750417667,
  4.652674285599758347255566e-6,
  0.00003543190417495200587525393,
  0.000144562169033804183971036,
  0.0004176240438754343092496596,
  0.000953272274063491358069875,
  0.001819883432303028956315216,
  0.003004252015230397007250516,
  0.004377624365050007067707895,
  0.005702431738683561838198442,
  0.006688037224381955242331506,
  0.007081451178757364374233359,
  0.006759567034268393266313661,
  0.005783185129318514238957243,
  0.004385052460692060247121426,
  0.002891243380676083679420721,
  0.001606246322597824266344845,
  0.000711859165696763027130102,
  0.0002261199702801482556766205,
  0.00003908246399903797011694676,
  1.431592087876848722232482e-6,
  0.00001236895563925597296008864,
  0.00005694873325574104217040813,
  0.0001848770470911013542923394,
  0.0004726969954033841444974588,
  0.001008420256860552841594579,
  0.001857173973051518149936683,
  0.003016162241948330228468597,
  0.004377624365050007067707895,
  0.005722384790915041918572411,
  0.006759567034268393266313661,
  0.007210204836552952817401238,
  0.006909779635029913116676187,
  0.005887622884285843129002195,
  0.004380671788903157090031395,
  0.002761150703308656590080394,
  0.0013978325435500073987282,
  0.000511624983260133426985485,
  0.0001030355869065546484901324,
  4.00845784605517642225095e-7,
  3.908246399903797011694676e-6,
  0.00002022092702558921062572463,
  0.0000735306437294153113662714,
  0.0002100875535126151753322039,
  0.000500008377360024117290645,
  0.001026332985107417924965009,
  0.001857173973051518149936683,
  0.003004252015230397007250516,
  0.004381200855544328968907002,
  0.005783185129318514238957243,
  0.006909779635029913116676187,
  0.007441301145416829510266663,
  0.007155097255208489913717945,
  0.006040017163487686290800863,
  0.004348812357711134129376621,
  0.002536807208664828242136362,
  0.00108187366251882380914639,
  0.0002575889672663866212253309,
  1.002114461513794105562737e-7,
  1.097968888267287454790477e-6,
  6.363228784276325022081176e-6,
  0.0000258569296630910985024251,
  0.00008241896330110287647648,
  0.0002186271447566097354955048,
  0.000500008377360024117290645,
  0.001008420256860552841594579,
  0.001819883432303028956315216,
  0.002965735963753084225106279,
  0.004385052460692060247121426,
  0.005887622884285843129002195,
  0.007155097255208489913717945,
  0.007805560642045625360419576,
  0.007526790619115424454690306,
  0.006244448513636500288335661,
  0.004244273599112308789728145,
  0.002139969881905365776333518,
  0.000614250614250614250614251,
  2.17850969894303066426682e-8,
  2.673625539611901269782007e-7,
  1.731490825653421774715966e-6,
  7.84942507629551204537905e-6,
  0.00002788611540262879279279398,
  0.00008241896330110287647648,
  0.0002100875535126151753322039,
  0.0004726969954033841444974588,
  0.000953272274063491358069875,
  0.001740100182814309621873582,
  0.002891243380676083679420721,
  0.004380671788903157090031395,
  0.006040017163487686290800863,
  0.007526790619115424454690306,
  0.00836310068790602717187812,
  0.00808433066497582626614885,
  0.006496337141498431821012466,
  0.003948753948753948753948754,
  0.001404001404001404001404001,
  3.960926725350964844121492e-9,
  5.432128080481323214795188e-8,
  3.924712538147756022689524e-7,
  1.983012650853603043043128e-6,
  7.84942507629551204537905e-6,
  0.0000258569296630910985024251,
  0.0000735306437294153113662714,
  0.0001848770470911013542923394,
  0.0004176240438754343092496596,
  0.000856664705385506275383917,
  0.001606246322597824266344845,
  0.002761150703308656590080394,
  0.004348812357711134129376621,
  0.006244448513636500288335661,
  0.00808433066497582626614885,
  0.0092392350456866585898844,
  0.00895050895050895050895051,
  0.006739206739206739206739207,
  0.003088803088803088803088803,
  5.658466750501378348744988e-10,
  8.65745412826710887357983e-9,
  6.9715288506571981981985e-8,
  3.924712538147756022689524e-7,
  1.731490825653421774715966e-6,
  6.363228784276325022081176e-6,
  0.00002022092702558921062572463,
  0.00005694873325574104217040813,
  0.000144562169033804183971036,
  0.0003346346505412133888218427,
  0.000711859165696763027130102,
  0.0013978325435500073987282,
  0.002536807208664828242136362,
  0.004244273599112308789728145,
  0.006496337141498431821012466,
  0.00895050895050895050895051,
  0.01074061074061074061074061,
  0.01042471042471042471042471,
  0.006563706563706563706563707,
  5.658466750501378348744988e-11,
  9.64917487980235044733356e-10,
  8.65745412826710887357983e-9,
  5.432128080481323214795188e-8,
  2.673625539611901269782007e-7,
  1.097968888267287454790477e-6,
  3.908246399903797011694676e-6,
  0.00001236895563925597296008864,
  0.00003543190417495200587525393,
  0.0000930534857119951669451113,
  0.0002261199702801482556766205,
  0.000511624983260133426985485,
  0.00108187366251882380914639,
  0.002139969881905365776333518,
  0.003948753948753948753948754,
  0.006739206739206739206739207,
  0.01042471042471042471042471,
  0.01389961389961389961389961,
  0.01351351351351351351351351,
  2.978140395000725446707888e-12,
  5.658466750501378348744988e-11,
  5.658466750501378348744988e-10,
  3.960926725350964844121492e-9,
  2.17850969894303066426682e-8,
  1.002114461513794105562737e-7,
  4.00845784605517642225095e-7,
  1.431592087876848722232482e-6,
  4.652674285599758347255566e-6,
  0.0000139580228567992750417667,
  0.00003908246399903797011694676,
  0.0001030355869065546484901324,
  0.0002575889672663866212253309,
  0.000614250614250614250614251,
  0.001404001404001404001404001,
  0.003088803088803088803088803,
  0.006563706563706563706563707,
  0.01351351351351351351351351,
  0.02702702702702702702702703,

  0.02564102564102564102564103,
  0.01282051282051282051282051,
  0.006237006237006237006237006,
  0.002945252945252945252945253,
  0.001346401346401346401346401,
  0.000594000594000594000594001,
  0.0002520002520002520002520003,
  0.0001023751023751023751023751,
  0.00003962907188713640326543552,
  0.00001453065969195001453065969,
  5.010572307568970527813687e-6,
  1.610541098861454812511542e-6,
  4.771973626256162407441607e-7,
  1.284762130145889878926586e-7,
  3.083429112350135709423807e-8,
  6.423810650729449394632932e-9,
  1.117184460996425981675293e-9,
  1.523433355904217247739035e-10,
  1.45088891038496880737051e-11,
  7.254444551924844036852549e-13,
  0.01282051282051282051282051,
  0.01316701316701316701316701,
  0.00987525987525987525987526,
  0.006395406395406395406395406,
  0.003762003762003762003762004,
  0.002052002052002052002052002,
  0.001047376047376047376047376,
  0.000501968243903727774695517,
  0.0002258857097566774986129825,
  0.0000952008738438104400284601,
  0.00003740034329578267286832359,
  0.00001360012483483006286120858,
  4.533374944943354287069526e-6,
  1.366986906475226831177888e-6,
  3.661572070915786154940771e-7,
  8.49060190357283746073222e-8,
  1.640229913190207236732361e-8,
  2.481020036758296660603572e-9,
  2.61885448324486869730377e-10,
  1.45088891038496880737051e-11,
  0.006237006237006237006237006,
  0.00987525987525987525987526,
  0.01015741015741015741015741,
  0.00846450846450846450846451,
  0.006156006156006156006156006,
  0.004039879039879039879039879,
  0.002432615335841142292755196,
  0.001355314258540064991677895,
  0.000701024616486240512936842,
  0.0003366030896620440558149123,
  0.0001496013731831306914732944,
  0.0000612005617567352828754386,
  0.00002284820972251450560683041,
  7.68930134892315092537562e-6,
  2.2924625139646661143977e-6,
  5.904827687484746052236501e-7,
  1.265320218746731296907822e-7,
  2.121272131428343644816054e-8,
  2.481020036758296660603572e-9,
  1.523433355904217247739035e-10,
  0.002945252945252945252945253,
  0.006395406395406395406395406,
  0.00846450846450846450846451,
  0.00872100872100872100872101,
  0.007630882630882630882630883,
  0.005907780101328488425262619,
  0.004135446070929941897683833,
  0.002648315217836908604428071,
  0.001560614324796749713323684,
  0.000847741114704407251682001,
  0.0004238705573522036258410007,
  0.0001942097826413732976580585,
  0.000080920742767238874024191,
  0.00003031144879575502973481404,
  0.00001003820706872406828880205,
  2.868059162492590939657729e-6,
  6.811640510919903481687106e-7,
  1.265320218746731296907822e-7,
  1.640229913190207236732361e-8,
  1.117184460996425981675293e-9,
  0.001346401346401346401346401,
  0.003762003762003762003762004,
  0.006156006156006156006156006,
  0.007630882630882630882630883,
  0.00787704013510465123368349,
  0.007089336121594186110315143,
  0.00570406354611026468646046,
  0.004161638199457999235529825,
  0.00277442546630533282368655,
  0.001695482229408814503364003,
  0.000949470048468936121883842,
  0.0004855244566034332441451463,
  0.0002251707624827516494586186,
  0.0000936899326414246373621525,
  0.00003441670994991109127589275,
  0.00001089862481747184557069937,
  2.868059162492590939657729e-6,
  5.904827687484746052236501e-7,
  8.49060190357283746073222e-8,
  6.423810650729449394632932e-9,
  0.000594000594000594000594001,
  0.002052002052002052002052002,
  0.004039879039879039879039879,
  0.005907780101328488425262619,
  0.007089336121594186110315143,
  0.007333795987856054596877734,
  0.006722646322201383380471256,
  0.0055488509326106656473731,
  0.004161638199457999235529825,
  0.002848410145406808365651525,
  0.001780256340879255228532203,
  0.001013268431172382422563783,
  0.000521986767573651551017707,
  0.0002409169696493776389312492,
  0.0000980876233572466101362943,
  0.00003441670994991109127589275,
  0.00001003820706872406828880205,
  2.2924625139646661143977e-6,
  3.661572070915786154940771e-7,
  3.083429112350135709423807e-8,
  0.0002520002520002520002520003,
  0.001047376047376047376047376,
  0.002432615335841142292755196,
  0.004135446070929941897683833,
  0.00570406354611026468646046,
  0.006722646322201383380471256,
  0.006971633223023656839007228,
  0.006473659421379109921935283,
  0.005437873913958452334425638,
  0.004153931462051595533241807,
  0.002889691451861979501385605,
  0.001826953686507780428561973,
  0.001043973535147303102035413,
  0.000534032616056120432964269,
  0.0002409169696493776389312492,
  0.0000936899326414246373621525,
  0.00003031144879575502973481404,
  7.68930134892315092537562e-6,
  1.366986906475226831177888e-6,
  1.284762130145889878926586e-7,
  0.0001023751023751023751023751,
  0.000501968243903727774695517,
  0.001355314258540064991677895,
  0.002648315217836908604428071,
  0.004161638199457999235529825,
  0.0055488509326106656473731,
  0.006473659421379109921935283,
  0.006732605798234274318812695,
  0.006311817935844632173886901,
  0.005366569839172247645430409,
  0.004146894875724009544196225,
  0.002908211990767487212812937,
  0.001841867594152741901448193,
  0.001043973535147303102035413,
  0.000521986767573651551017707,
  0.0002251707624827516494586186,
  0.000080920742767238874024191,
  0.00002284820972251450560683041,
  4.533374944943354287069526e-6,
  4.771973626256162407441607e-7,
  0.00003962907188713640326543552,
  0.0002258857097566774986129825,
  0.000701024616486240512936842,
  0.001560614324796749713323684,
  0.00277442546630533282368655,
  0.004161638199457999235529825,
  0.005437873913958452334425638,
  0.006311817935844632173886901,
  0.006586244802620485746664593,
  0.006220342313586014316294338,
  0.005331721983073726556823718,
  0.004144202086843669278258435,
  0.002908211990767487212812937,
  0.001826953686507780428561973,
  0.001013268431172382422563783,
  0.0004855244566034332441451463,
  0.0001942097826413732976580585,
  0.0000612005617567352828754386,
  0.00001360012483483006286120858,
  1.610541098861454812511542e-6,
  0.00001453065969195001453065969,
  0.0000952008738438104400284601,
  0.0003366030896620440558149123,
  0.000847741114704407251682001,
  0.001695482229408814503364003,
  0.002848410145406808365651525,
  0.004153931462051595533241807,
  0.005366569839172247645430409,
  0.006220342313586014316294338,
  0.006516549090423443569451211,
  0.00619072163590227139097865,
  0.005331721983073726556823718,
  0.004146894875724009544196225,
  0.002889691451861979501385605,
  0.001780256340879255228532203,
  0.000949470048468936121883842,
  0.0004238705573522036258410007,
  0.0001496013731831306914732944,
  0.00003740034329578267286832359,
  5.010572307568970527813687e-6,
  5.010572307568970527813687e-6,
  0.00003740034329578267286832359,
  0.0001496013731831306914732944,
  0.0004238705573522036258410007,
  0.000949470048468936121883842,
  0.001780256340879255228532203,
  0.002889691451861979501385605,
  0.004146894875724009544196225,
  0.005331721983073726556823718,
  0.00619072163590227139097865,
  0.006516549090423443569451211,
  0.006220342313586014316294338,
  0.005366569839172247645430409,
  0.004153931462051595533241807,
  0.002848410145406808365651525,
  0.001695482229408814503364003,
  0.000847741114704407251682001,
  0.0003366030896620440558149123,
  0.0000952008738438104400284601,
  0.00001453065969195001453065969,
  1.610541098861454812511542e-6,
  0.00001360012483483006286120858,
  0.0000612005617567352828754386,
  0.0001942097826413732976580585,
  0.0004855244566034332441451463,
  0.001013268431172382422563783,
  0.001826953686507780428561973,
  0.002908211990767487212812937,
  0.004144202086843669278258435,
  0.005331721983073726556823718,
  0.006220342313586014316294338,
  0.006586244802620485746664593,
  0.006311817935844632173886901,
  0.005437873913958452334425638,
  0.004161638199457999235529825,
  0.00277442546630533282368655,
  0.001560614324796749713323684,
  0.000701024616486240512936842,
  0.0002258857097566774986129825,
  0.00003962907188713640326543552,
  4.771973626256162407441607e-7,
  4.533374944943354287069526e-6,
  0.00002284820972251450560683041,
  0.000080920742767238874024191,
  0.0002251707624827516494586186,
  0.000521986767573651551017707,
  0.001043973535147303102035413,
  0.001841867594152741901448193,
  0.002908211990767487212812937,
  0.004146894875724009544196225,
  0.005366569839172247645430409,
  0.006311817935844632173886901,
  0.006732605798234274318812695,
  0.006473659421379109921935283,
  0.0055488509326106656473731,
  0.004161638199457999235529825,
  0.002648315217836908604428071,
  0.001355314258540064991677895,
  0.000501968243903727774695517,
  0.0001023751023751023751023751,
  1.284762130145889878926586e-7,
  1.366986906475226831177888e-6,
  7.68930134892315092537562e-6,
  0.00003031144879575502973481404,
  0.0000936899326414246373621525,
  0.0002409169696493776389312492,
  0.000534032616056120432964269,
  0.001043973535147303102035413,
  0.001826953686507780428561973,
  0.002889691451861979501385605,
  0.004153931462051595533241807,
  0.005437873913958452334425638,
  0.006473659421379109921935283,
  0.006971633223023656839007228,
  0.006722646322201383380471256,
  0.00570406354611026468646046,
  0.004135446070929941897683833,
  0.002432615335841142292755196,
  0.001047376047376047376047376,
  0.0002520002520002520002520003,
  3.083429112350135709423807e-8,
  3.661572070915786154940771e-7,
  2.2924625139646661143977e-6,
  0.00001003820706872406828880205,
  0.00003441670994991109127589275,
  0.0000980876233572466101362943,
  0.0002409169696493776389312492,
  0.000521986767573651551017707,
  0.001013268431172382422563783,
  0.001780256340879255228532203,
  0.002848410145406808365651525,
  0.004161638199457999235529825,
  0.0055488509326106656473731,
  0.006722646322201383380471256,
  0.007333795987856054596877734,
  0.007089336121594186110315143,
  0.005907780101328488425262619,
  0.004039879039879039879039879,
  0.002052002052002052002052002,
  0.000594000594000594000594001,
  6.423810650729449394632932e-9,
  8.49060190357283746073222e-8,
  5.904827687484746052236501e-7,
  2.868059162492590939657729e-6,
  0.00001089862481747184557069937,
  0.00003441670994991109127589275,
  0.0000936899326414246373621525,
  0.0002251707624827516494586186,
  0.0004855244566034332441451463,
  0.000949470048468936121883842,
  0.001695482229408814503364003,
  0.00277442546630533282368655,
  0.004161638199457999235529825,
  0.00570406354611026468646046,
  0.007089336121594186110315143,
  0.00787704013510465123368349,
  0.007630882630882630882630883,
  0.006156006156006156006156006,
  0.003762003762003762003762004,
  0.001346401346401346401346401,
  1.117184460996425981675293e-9,
  1.640229913190207236732361e-8,
  1.265320218746731296907822e-7,
  6.811640510919903481687106e-7,
  2.868059162492590939657729e-6,
  0.00001003820706872406828880205,
  0.00003031144879575502973481404,
  0.000080920742767238874024191,
  0.0001942097826413732976580585,
  0.0004238705573522036258410007,
  0.000847741114704407251682001,
  0.001560614324796749713323684,
  0.002648315217836908604428071,
  0.004135446070929941897683833,
  0.005907780101328488425262619,
  0.007630882630882630882630883,
  0.00872100872100872100872101,
  0.00846450846450846450846451,
  0.006395406395406395406395406,
  0.002945252945252945252945253,
  1.523433355904217247739035e-10,
  2.481020036758296660603572e-9,
  2.121272131428343644816054e-8,
  1.265320218746731296907822e-7,
  5.904827687484746052236501e-7,
  2.2924625139646661143977e-6,
  7.68930134892315092537562e-6,
  0.00002284820972251450560683041,
  0.0000612005617567352828754386,
  0.0001496013731831306914732944,
  0.0003366030896620440558149123,
  0.000701024616486240512936842,
  0.001355314258540064991677895,
  0.002432615335841142292755196,
  0.004039879039879039879039879,
  0.006156006156006156006156006,
  0.00846450846450846450846451,
  0.01015741015741015741015741,
  0.00987525987525987525987526,
  0.006237006237006237006237006,
  1.45088891038496880737051e-11,
  2.61885448324486869730377e-10,
  2.481020036758296660603572e-9,
  1.640229913190207236732361e-8,
  8.49060190357283746073222e-8,
  3.661572070915786154940771e-7,
  1.366986906475226831177888e-6,
  4.533374944943354287069526e-6,
  0.00001360012483483006286120858,
  0.00003740034329578267286832359,
  0.0000952008738438104400284601,
  0.0002258857097566774986129825,
  0.000501968243903727774695517,
  0.001047376047376047376047376,
  0.002052002052002052002052002,
  0.003762003762003762003762004,
  0.006395406395406395406395406,
  0.00987525987525987525987526,
  0.01316701316701316701316701,
  0.01282051282051282051282051,
  7.254444551924844036852549e-13,
  1.45088891038496880737051e-11,
  1.523433355904217247739035e-10,
  1.117184460996425981675293e-9,
  6.423810650729449394632932e-9,
  3.083429112350135709423807e-8,
  1.284762130145889878926586e-7,
  4.771973626256162407441607e-7,
  1.610541098861454812511542e-6,
  5.010572307568970527813687e-6,
  0.00001453065969195001453065969,
  0.00003962907188713640326543552,
  0.0001023751023751023751023751,
  0.0002520002520002520002520003,
  0.000594000594000594000594001,
  0.001346401346401346401346401,
  0.002945252945252945252945253,
  0.006237006237006237006237006,
  0.01282051282051282051282051,
  0.02564102564102564102564103,

  0.0243902439024390243902439,
  0.01219512195121951219512195,
  0.005941213258286429018136335,
  0.002814258911819887429643527,
  0.001293037878403732062268648,
  0.000574683501512769805452732,
  0.000246292929219758488051171,
  0.0001014147355610770244916586,
  0.00003995125946345458540580492,
  0.00001498172229879546952717684,
  5.316095009250005316095009e-6,
  1.77203166975000177203167e-6,
  5.499408630258626189063803e-7,
  1.571259608645321768303944e-7,
  4.073636022413797177084298e-8,
  9.40069851326260887019453e-9,
  1.880139702652521774038907e-9,
  3.133566171087536290064845e-10,
  4.087260223157656030519363e-11,
  3.71569111196150548229033e-12,
  1.769376719981669277281109e-13,
  0.01219512195121951219512195,
  0.01250781738586616635397123,
  0.00938086303939962476547842,
  0.006084884133664621469499518,
  0.003591771884454811284079577,
  0.001970343433758067904409368,
  0.001014147355610770244916586,
  0.00049170780878097951268683,
  0.0002247258344819320429076527,
  0.0000966562728954546421108184,
  0.00003898469673450003898469673,
  0.00001466508968068966983750347,
  5.106593728097295746987817e-6,
  1.629454408965518870833719e-6,
  4.700349256631304435097267e-7,
  1.2032894096976139353849e-7,
  2.663531245424405846555118e-8,
  4.904712267789187236623235e-9,
  7.059813112726860416351627e-10,
  7.07750687992667710912444e-11,
  3.71569111196150548229033e-12,
  0.005941213258286429018136335,
  0.00938086303939962476547842,
  0.00963439987830231732670757,
  0.00802866656525193110558964,
  0.005849457068969264091215311,
  0.003853759951320926930683028,
  0.002335612091709652685262441,
  0.001313781801586679635460123,
  0.000688675944380114325039581,
  0.0003366860172525003366860173,
  0.0001532501871632070498019113,
  0.0000646835205558990794618457,
  0.00002515470243840519756849554,
  8.93066358759947842668481e-6,
  2.857812348031833096539138e-6,
  8.097134986090193773527559e-7,
  1.980277578119884346786631e-7,
  4.024093474254310437320427e-8,
  6.387449959133826090984805e-9,
  7.059813112726860416351627e-10,
  4.087260223157656030519363e-11,
  0.002814258911819887429643527,
  0.006084884133664621469499518,
  0.00802866656525193110558964,
  0.0082580570385448434228922,
  0.007225799908726737995030678,
  0.005605469020103166444629859,
  0.00394134540476003890638037,
  0.002542803486941960584761529,
  0.001515087077636251515087078,
  0.000835910111799311180737698,
  0.0004269112356689339244481815,
  0.0002012376195072415805479643,
  0.0000870739699790949146601769,
  0.00003429374817638199715846966,
  0.00001214570247913529066029134,
  3.802132949990177945830332e-6,
  1.026143835934849161516709e-6,
  2.29948198528817739275453e-7,
  4.024093474254310437320427e-8,
  4.904712267789187236623235e-9,
  3.133566171087536290064845e-10,
  0.001293037878403732062268648,
  0.003591771884454811284079577,
  0.005849457068969264091215311,
  0.007225799908726737995030678,
  0.007444763542324517934274032,
  0.006700287188092066140846629,
  0.005403457409751666242618249,
  0.003962535433817888577920049,
  0.002664463481360304388601412,
  0.001649429774175426526277065,
  0.000940785871196354389061733,
  0.000493419163214871183074336,
  0.0002368411983431381678756811,
  0.0001032384710726499706124764,
  0.00004039766259364564067444728,
  0.00001395555616871394859662724,
  4.15343933592677041566287e-6,
  1.026143835934849161516709e-6,
  1.980277578119884346786631e-7,
  2.663531245424405846555118e-8,
  1.880139702652521774038907e-9,
  0.000574683501512769805452732,
  0.001970343433758067904409368,
  0.003853759951320926930683028,
  0.005605469020103166444629859,
  0.006700287188092066140846629,
  0.006916425484482132790551359,
  0.006340056694108621724672079,
  0.005246943470986445565245858,
  0.003958631458021023663064956,
  0.002736831625298485495452315,
  0.001736835454516346564421661,
  0.001010522446264056182936239,
  0.000536840049577779847184877,
  0.0002585450405993321003164626,
  0.0001116444493497115887730179,
  0.00004253121879989012905638778,
  0.00001395555616871394859662724,
  3.802132949990177945830332e-6,
  8.097134986090193773527559e-7,
  1.2032894096976139353849e-7,
  9.40069851326260887019453e-9,
  0.000246292929219758488051171,
  0.001014147355610770244916586,
  0.002335612091709652685262441,
  0.00394134540476003890638037,
  0.005403457409751666242618249,
  0.006340056694108621724672079,
  0.006558679338733056956557323,
  0.006090202243109267173946085,
  0.005131559297434660303973091,
  0.003947353305718969464594685,
  0.002778936727226154503074658,
  0.001789466831925932823949591,
  0.001050339227434786657535629,
  0.00055822224674855794386509,
  0.0002658201174993133066024236,
  0.0001116444493497115887730179,
  0.00004039766259364564067444728,
  0.00001214570247913529066029134,
  2.857812348031833096539138e-6,
  4.700349256631304435097267e-7,
  4.073636022413797177084298e-8,
  0.0001014147355610770244916586,
  0.00049170780878097951268683,
  0.001313781801586679635460123,
  0.002542803486941960584761529,
  0.003962535433817888577920049,
  0.005246943470986445565245858,
  0.006090202243109267173946085,
  0.006315765289150351143351496,
  0.005921029958578454196892028,
  0.005052612231320280914681197,
  0.003936827030237052212689099,
  0.002800904606492764420095011,
  0.001814222301932813317561541,
  0.001063280469997253226409695,
  0.00055822224674855794386509,
  0.0002585450405993321003164626,
  0.0001032384710726499706124764,
  0.00003429374817638199715846966,
  8.93066358759947842668481e-6,
  1.629454408965518870833719e-6,
  1.571259608645321768303944e-7,
  0.00003995125946345458540580492,
  0.0002247258344819320429076527,
  0.000688675944380114325039581,
  0.001515087077636251515087078,
  0.002664463481360304388601412,
  0.003958631458021023663064956,
  0.005131559297434660303973091,
  0.005921029958578454196892028,
  0.006157871156921592364767709,
  0.005815767203759281677836169,
  0.005006616984105816400919833,
  0.00393081498752109552138334,
  0.0028077249910864968009881,
  0.001814222301932813317561541,
  0.001050339227434786657535629,
  0.000536840049577779847184877,
  0.0002368411983431381678756811,
  0.0000870739699790949146601769,
  0.00002515470243840519756849554,
  5.106593728097295746987817e-6,
  5.499408630258626189063803e-7,
  0.00001498172229879546952717684,
  0.0000966562728954546421108184,
  0.0003366860172525003366860173,
  0.000835910111799311180737698,
  0.001649429774175426526277065,
  0.002736831625298485495452315,
  0.003947353305718969464594685,
  0.005052612231320280914681197,
  0.005815767203759281677836169,
  0.006068626647400989576872524,
  0.005765195315030940098028898,
  0.004991511095264883201756622,
  0.00393081498752109552138334,
  0.002800904606492764420095011,
  0.001789466831925932823949591,
  0.001010522446264056182936239,
  0.000493419163214871183074336,
  0.0002012376195072415805479643,
  0.0000646835205558990794618457,
  0.00001466508968068966983750347,
  1.77203166975000177203167e-6,
  5.316095009250005316095009e-6,
  0.00003898469673450003898469673,
  0.0001532501871632070498019113,
  0.0004269112356689339244481815,
  0.000940785871196354389061733,
  0.001736835454516346564421661,
  0.002778936727226154503074658,
  0.003936827030237052212689099,
  0.005006616984105816400919833,
  0.005765195315030940098028898,
  0.006039728425270508674125512,
  0.005765195315030940098028898,
  0.005006616984105816400919833,
  0.003936827030237052212689099,
  0.002778936727226154503074658,
  0.001736835454516346564421661,
  0.000940785871196354389061733,
  0.0004269112356689339244481815,
  0.0001532501871632070498019113,
  0.00003898469673450003898469673,
  5.316095009250005316095009e-6,
  1.77203166975000177203167e-6,
  0.00001466508968068966983750347,
  0.0000646835205558990794618457,
  0.0002012376195072415805479643,
  0.000493419163214871183074336,
  0.001010522446264056182936239,
  0.001789466831925932823949591,
  0.002800904606492764420095011,
  0.00393081498752109552138334,
  0.004991511095264883201756622,
  0.005765195315030940098028898,
  0.006068626647400989576872524,
  0.005815767203759281677836169,
  0.005052612231320280914681197,
  0.003947353305718969464594685,
  0.002736831625298485495452315,
  0.001649429774175426526277065,
  0.000835910111799311180737698,
  0.0003366860172525003366860173,
  0.0000966562728954546421108184,
  0.00001498172229879546952717684,
  5.499408630258626189063803e-7,
  5.106593728097295746987817e-6,
  0.00002515470243840519756849554,
  0.0000870739699790949146601769,
  0.0002368411983431381678756811,
  0.000536840049577779847184877,
  0.001050339227434786657535629,
  0.001814222301932813317561541,
  0.0028077249910864968009881,
  0.00393081498752109552138334,
  0.005006616984105816400919833,
  0.005815767203759281677836169,
  0.006157871156921592364767709,
  0.005921029958578454196892028,
  0.005131559297434660303973091,
  0.003958631458021023663064956,
  0.002664463481360304388601412,
  0.001515087077636251515087078,
  0.000688675944380114325039581,
  0.0002247258344819320429076527,
  0.00003995125946345458540580492,
  1.571259608645321768303944e-7,
  1.629454408965518870833719e-6,
  8.93066358759947842668481e-6,
  0.00003429374817638199715846966,
  0.0001032384710726499706124764,
  0.0002585450405993321003164626,
  0.00055822224674855794386509,
  0.001063280469997253226409695,
  0.001814222301932813317561541,
  0.002800904606492764420095011,
  0.003936827030237052212689099,
  0.005052612231320280914681197,
  0.005921029958578454196892028,
  0.006315765289150351143351496,
  0.006090202243109267173946085,
  0.005246943470986445565245858,
  0.003962535433817888577920049,
  0.002542803486941960584761529,
  0.001313781801586679635460123,
  0.00049170780878097951268683,
  0.0001014147355610770244916586,
  4.073636022413797177084298e-8,
  4.700349256631304435097267e-7,
  2.857812348031833096539138e-6,
  0.00001214570247913529066029134,
  0.00004039766259364564067444728,
  0.0001116444493497115887730179,
  0.0002658201174993133066024236,
  0.00055822224674855794386509,
  0.001050339227434786657535629,
  0.001789466831925932823949591,
  0.002778936727226154503074658,
  0.003947353305718969464594685,
  0.005131559297434660303973091,
  0.006090202243109267173946085,
  0.006558679338733056956557323,
  0.006340056694108621724672079,
  0.005403457409751666242618249,
  0.00394134540476003890638037,
  0.002335612091709652685262441,
  0.001014147355610770244916586,
  0.000246292929219758488051171,
  9.40069851326260887019453e-9,
  1.2032894096976139353849e-7,
  8.097134986090193773527559e-7,
  3.802132949990177945830332e-6,
  0.00001395555616871394859662724,
  0.00004253121879989012905638778,
  0.0001116444493497115887730179,
  0.0002585450405993321003164626,
  0.000536840049577779847184877,
  0.001010522446264056182936239,
  0.001736835454516346564421661,
  0.002736831625298485495452315,
  0.003958631458021023663064956,
  0.005246943470986445565245858,
  0.006340056694108621724672079,
  0.006916425484482132790551359,
  0.006700287188092066140846629,
  0.005605469020103166444629859,
  0.003853759951320926930683028,
  0.001970343433758067904409368,
  0.000574683501512769805452732,
  1.880139702652521774038907e-9,
  2.663531245424405846555118e-8,
  1.980277578119884346786631e-7,
  1.026143835934849161516709e-6,
  4.15343933592677041566287e-6,
  0.00001395555616871394859662724,
  0.00004039766259364564067444728,
  0.0001032384710726499706124764,
  0.0002368411983431381678756811,
  0.000493419163214871183074336,
  0.000940785871196354389061733,
  0.001649429774175426526277065,
  0.002664463481360304388601412,
  0.003962535433817888577920049,
  0.005403457409751666242618249,
  0.006700287188092066140846629,
  0.007444763542324517934274032,
  0.007225799908726737995030678,
  0.005849457068969264091215311,
  0.003591771884454811284079577,
  0.001293037878403732062268648,
  3.133566171087536290064845e-10,
  4.904712267789187236623235e-9,
  4.024093474254310437320427e-8,
  2.29948198528817739275453e-7,
  1.026143835934849161516709e-6,
  3.802132949990177945830332e-6,
  0.00001214570247913529066029134,
  0.00003429374817638199715846966,
  0.0000870739699790949146601769,
  0.0002012376195072415805479643,
  0.0004269112356689339244481815,
  0.000835910111799311180737698,
  0.001515087077636251515087078,
  0.002542803486941960584761529,
  0.00394134540476003890638037,
  0.005605469020103166444629859,
  0.007225799908726737995030678,
  0.0082580570385448434228922,
  0.00802866656525193110558964,
  0.006084884133664621469499518,
  0.002814258911819887429643527,
  4.087260223157656030519363e-11,
  7.059813112726860416351627e-10,
  6.387449959133826090984805e-9,
  4.024093474254310437320427e-8,
  1.980277578119884346786631e-7,
  8.097134986090193773527559e-7,
  2.857812348031833096539138e-6,
  8.93066358759947842668481e-6,
  0.00002515470243840519756849554,
  0.0000646835205558990794618457,
  0.0001532501871632070498019113,
  0.0003366860172525003366860173,
  0.000688675944380114325039581,
  0.001313781801586679635460123,
  0.002335612091709652685262441,
  0.003853759951320926930683028,
  0.005849457068969264091215311,
  0.00802866656525193110558964,
  0.00963439987830231732670757,
  0.00938086303939962476547842,
  0.005941213258286429018136335,
  3.71569111196150548229033e-12,
  7.07750687992667710912444e-11,
  7.059813112726860416351627e-10,
  4.904712267789187236623235e-9,
  2.663531245424405846555118e-8,
  1.2032894096976139353849e-7,
  4.700349256631304435097267e-7,
  1.629454408965518870833719e-6,
  5.106593728097295746987817e-6,
  0.00001466508968068966983750347,
  0.00003898469673450003898469673,
  0.0000966562728954546421108184,
  0.0002247258344819320429076527,
  0.00049170780878097951268683,
  0.001014147355610770244916586,
  0.001970343433758067904409368,
  0.003591771884454811284079577,
  0.006084884133664621469499518,
  0.00938086303939962476547842,
  0.01250781738586616635397123,
  0.01219512195121951219512195,
  1.769376719981669277281109e-13,
  3.71569111196150548229033e-12,
  4.087260223157656030519363e-11,
  3.133566171087536290064845e-10,
  1.880139702652521774038907e-9,
  9.40069851326260887019453e-9,
  4.073636022413797177084298e-8,
  1.571259608645321768303944e-7,
  5.499408630258626189063803e-7,
  1.77203166975000177203167e-6,
  5.316095009250005316095009e-6,
  0.00001498172229879546952717684,
  0.00003995125946345458540580492,
  0.0001014147355610770244916586,
  0.000246292929219758488051171,
  0.000574683501512769805452732,
  0.001293037878403732062268648,
  0.002814258911819887429643527,
  0.005941213258286429018136335,
  0.01219512195121951219512195,
  0.0243902439024390243902439,

  0.02325581395348837209302326,
  0.01162790697674418604651163,
  0.005672149744753261486103233,
  0.002694271128757799205899036,
  0.001243509751734368864261093,
  0.000556306994196954491906279,
  0.0002405651866797641046081205,
  0.0001002354944499017102533835,
  0.00004009419777996068410135342,
  0.00001533013444527908509757631,
  5.574594343737849126391384e-6,
  1.916266805659885637197038e-6,
  6.18150582470930850708722e-7,
  1.854451747412792552126166e-7,
  5.11572895838011738517563e-8,
  1.278932239595029346293908e-8,
  2.842071643544509658430906e-9,
  5.465522391431749343136357e-10,
  8.74483582629079894901817e-11,
  1.093104478286349868627271e-11,
  9.5052563329247814663241e-13,
  4.3205710604203552119655e-14,
  0.01162790697674418604651163,
  0.01191151446398184912081679,
  0.00893363584798638684061259,
  0.005803045508093721366551769,
  0.003436013787687071861774074,
  0.001894450845103142323788949,
  0.000982307845609036760483159,
  0.000481130373359528209216241,
  0.000222876570012134391033994,
  0.0000975554010154123597118492,
  0.0000402416029188575983811378,
  0.00001557739467826745743785979,
  5.62517030048547074144937e-6,
  1.880030392204693139052044e-6,
  5.755195078177632058322584e-7,
  1.591560120384925408721307e-7,
  3.902382987482269030999359e-8,
  8.26386985584480500682217e-9,
  1.453828956120845325274271e-9,
  1.996103829914204107928061e-10,
  1.905371837645376648476785e-11,
  9.5052563329247814663241e-13,
  0.005672149744753261486103233,
  0.00893363584798638684061259,
  0.00916270343383219163139753,
  0.007635586194860159692831275,
  0.00557191425030335977584985,
  0.003683654421033887851811845,
  0.002245275075677798309675791,
  0.001273580400069339377337108,
  0.000675383545491316336466648,
  0.0003353466909904799865094817,
  0.0001557739467826745743785979,
  0.0000675020436058256488973924,
  0.0000271559945540677897863073,
  0.00001007159138681085610206452,
  3.410485972253411590117087e-6,
  1.040635463328605074933162e-6,
  2.809715750987233702319539e-7,
  6.54223030254380396373422e-8,
  1.264199092278995935021105e-8,
  1.905371837645376648476785e-9,
  1.996103829914204107928061e-10,
  1.093104478286349868627271e-11,
  0.002694271128757799205899036,
  0.005803045508093721366551769,
  0.007635586194860159692831275,
  0.00784195338931583968452942,
  0.006861709215651359723963241,
  0.005332528304734770985480004,
  0.003764137626871603048574121,
  0.002444245212254287693879299,
  0.001470366260496719940849266,
  0.0008221402746863380314426,
  0.0004275129428368957763501521,
  0.0002063855586109152023759355,
  0.0000921364100941585724892569,
  0.00003779955285914197845713105,
  0.00001412290985945964030266435,
  4.745297712778439141695221e-6,
  1.408760258481099120190769e-6,
  3.60296741299513841481015e-7,
  7.64265814877756633444577e-8,
  1.264199092278995935021105e-8,
  1.453828956120845325274271e-9,
  8.74483582629079894901817e-11,
  0.001243509751734368864261093,
  0.003436013787687071861774074,
  0.00557191425030335977584985,
  0.006861709215651359723963241,
  0.007057758050384255716076476,
  0.006351982245345830144468829,
  0.005132914945734004157146528,
  0.003780941812705851276469541,
  0.002561283163445899251801947,
  0.001603173535638359161313071,
  0.00092873501374911841069171,
  0.000497536614508456291441987,
  0.0002456970935844228599713518,
  0.0001112179151432446673834817,
  0.00004575822794464923458063248,
  0.00001690512310177318944228922,
  5.512540141882561774659529e-6,
  1.547638275127457182725269e-6,
  3.60296741299513841481015e-7,
  6.54223030254380396373422e-8,
  8.26386985584480500682217e-9,
  5.465522391431749343136357e-10,
  0.000556306994196954491906279,
  0.001894450845103142323788949,
  0.003683654421033887851811845,
  0.005332528304734770985480004,
  0.006351982245345830144468829,
  0.006544466555810855300361823,
  0.005999094342826617358665005,
  0.004976207288980604260643783,
  0.003773623860810291564321535,
  0.002631415872289168830293178,
  0.001691624489328751390902757,
  0.001002444141824445268683115,
  0.000546203538814601588705544,
  0.0002722614562706629457547633,
  0.0001231658968843475230795358,
  0.0000499803639530685600902464,
  0.00001789069846047340503230411,
  5.512540141882561774659529e-6,
  1.408760258481099120190769e-6,
  2.809715750987233702319539e-7,
  3.902382987482269030999359e-8,
  2.842071643544509658430906e-9,
  0.0002405651866797641046081205,
  0.000982307845609036760483159,
  0.002245275075677798309675791,
  0.003764137626871603048574121,
  0.005132914945734004157146528,
  0.005999094342826617358665005,
  0.006192613515175863079912263,
  0.005750283978377587145632816,
  0.004857998533456927071310482,
  0.003759165531841669757561683,
  0.002673184378198520716488308,
  0.00174785132420672508385774,
  0.001048710794524035050314644,
  0.000574774185460288441037834,
  0.0002856020797318203433728366,
  0.0001272227446078108802297181,
  0.0000499803639530685600902464,
  0.00001690512310177318944228922,
  4.745297712778439141695221e-6,
  1.040635463328605074933162e-6,
  1.591560120384925408721307e-7,
  1.278932239595029346293908e-8,
  0.0001002354944499017102533835,
  0.000481130373359528209216241,
  0.001273580400069339377337108,
  0.002444245212254287693879299,
  0.003780941812705851276469541,
  0.004976207288980604260643783,
  0.005750283978377587145632816,
  0.005948569632804400495482223,
  0.005576784030754125464514584,
  0.004773543532497358422300549,
  0.003745395694728696608266585,
  0.002696684900204661557951941,
  0.001779062954996130888926628,
  0.001071007798994326287648137,
  0.000584186072178723429626257,
  0.0002856020797318203433728366,
  0.0001231658968843475230795358,
  0.00004575822794464923458063248,
  0.00001412290985945964030266435,
  3.410485972253411590117087e-6,
  5.755195078177632058322584e-7,
  5.11572895838011738517563e-8,
  0.00004009419777996068410135342,
  0.000222876570012134391033994,
  0.000675383545491316336466648,
  0.001470366260496719940849266,
  0.002561283163445899251801947,
  0.003773623860810291564321535,
  0.004857998533456927071310482,
  0.005576784030754125464514584,
  0.00578333158744872270394105,
  0.005462035388146015887055436,
  0.004719198575358157726415897,
  0.003736032205491874866745918,
  0.002707269714124547004888347,
  0.001789069846047340503230411,
  0.001071007798994326287648137,
  0.000574774185460288441037834,
  0.0002722614562706629457547633,
  0.0001112179151432446673834817,
  0.00003779955285914197845713105,
  0.00001007159138681085610206452,
  1.880030392204693139052044e-6,
  1.854451747412792552126166e-7,
  0.00001533013444527908509757631,
  0.0000975554010154123597118492,
  0.0003353466909904799865094817,
  0.0008221402746863380314426,
  0.001603173535638359161313071,
  0.002631415872289168830293178,
  0.003759165531841669757561683,
  0.004773543532497358422300549,
  0.005462035388146015887055436,
  0.005680516803671856522537654,
  0.005396490963488263696410771,
  0.004692600837815881475139801,
  0.00373275066644445117340666,
  0.002707269714124547004888347,
  0.001779062954996130888926628,
  0.001048710794524035050314644,
  0.000546203538814601588705544,
  0.0002456970935844228599713518,
  0.0000921364100941585724892569,
  0.0000271559945540677897863073,
  5.62517030048547074144937e-6,
  6.18150582470930850708722e-7,
  5.574594343737849126391384e-6,
  0.0000402416029188575983811378,
  0.0001557739467826745743785979,
  0.0004275129428368957763501521,
  0.00092873501374911841069171,
  0.001691624489328751390902757,
  0.002673184378198520716488308,
  0.003745395694728696608266585,
  0.004719198575358157726415897,
  0.005396490963488263696410771,
  0.005631121005379057770167761,
  0.00537516095968000968970559,
  0.004692600837815881475139801,
  0.003736032205491874866745918,
  0.002696684900204661557951941,
  0.00174785132420672508385774,
  0.001002444141824445268683115,
  0.000497536614508456291441987,
  0.0002063855586109152023759355,
  0.0000675020436058256488973924,
  0.00001557739467826745743785979,
  1.916266805659885637197038e-6,
  1.916266805659885637197038e-6,
  0.00001557739467826745743785979,
  0.0000675020436058256488973924,
  0.0002063855586109152023759355,
  0.000497536614508456291441987,
  0.001002444141824445268683115,
  0.00174785132420672508385774,
  0.002696684900204661557951941,
  0.003736032205491874866745918,
  0.004692600837815881475139801,
  0.00537516095968000968970559,
  0.005631121005379057770167761,
  0.005396490963488263696410771,
  0.004719198575358157726415897,
  0.003745395694728696608266585,
  0.002673184378198520716488308,
  0.001691624489328751390902757,
  0.00092873501374911841069171,
  0.0004275129428368957763501521,
  0.0001557739467826745743785979,
  0.0000402416029188575983811378,
  5.574594343737849126391384e-6,
  6.18150582470930850708722e-7,
  5.62517030048547074144937e-6,
  0.0000271559945540677897863073,
  0.0000921364100941585724892569,
  0.0002456970935844228599713518,
  0.000546203538814601588705544,
  0.001048710794524035050314644,
  0.001779062954996130888926628,
  0.002707269714124547004888347,
  0.00373275066644445117340666,
  0.004692600837815881475139801,
  0.005396490963488263696410771,
  0.005680516803671856522537654,
  0.005462035388146015887055436,
  0.004773543532497358422300549,
  0.003759165531841669757561683,
  0.002631415872289168830293178,
  0.001603173535638359161313071,
  0.0008221402746863380314426,
  0.0003353466909904799865094817,
  0.0000975554010154123597118492,
  0.00001533013444527908509757631,
  1.854451747412792552126166e-7,
  1.880030392204693139052044e-6,
  0.00001007159138681085610206452,
  0.00003779955285914197845713105,
  0.0001112179151432446673834817,
  0.0002722614562706629457547633,
  0.000574774185460288441037834,
  0.001071007798994326287648137,
  0.001789069846047340503230411,
  0.002707269714124547004888347,
  0.003736032205491874866745918,
  0.004719198575358157726415897,
  0.005462035388146015887055436,
  0.00578333158744872270394105,
  0.005576784030754125464514584,
  0.004857998533456927071310482,
  0.003773623860810291564321535,
  0.002561283163445899251801947,
  0.001470366260496719940849266,
  0.000675383545491316336466648,
  0.000222876570012134391033994,
  0.00004009419777996068410135342,
  5.11572895838011738517563e-8,
  5.755195078177632058322584e-7,
  3.410485972253411590117087e-6,
  0.00001412290985945964030266435,
  0.00004575822794464923458063248,
  0.0001231658968843475230795358,
  0.0002856020797318203433728366,
  0.000584186072178723429626257,
  0.001071007798994326287648137,
  0.001779062954996130888926628,
  0.002696684900204661557951941,
  0.003745395694728696608266585,
  0.004773543532497358422300549,
  0.005576784030754125464514584,
  0.005948569632804400495482223,
  0.005750283978377587145632816,
  0.004976207288980604260643783,
  0.003780941812705851276469541,
  0.002444245212254287693879299,
  0.001273580400069339377337108,
  0.000481130373359528209216241,
  0.0001002354944499017102533835,
  1.278932239595029346293908e-8,
  1.591560120384925408721307e-7,
  1.040635463328605074933162e-6,
  4.745297712778439141695221e-6,
  0.00001690512310177318944228922,
  0.0000499803639530685600902464,
  0.0001272227446078108802297181,
  0.0002856020797318203433728366,
  0.000574774185460288441037834,
  0.001048710794524035050314644,
  0.00174785132420672508385774,
  0.002673184378198520716488308,
  0.003759165531841669757561683,
  0.004857998533456927071310482,
  0.005750283978377587145632816,
  0.006192613515175863079912263,
  0.005999094342826617358665005,
  0.005132914945734004157146528,
  0.003764137626871603048574121,
  0.002245275075677798309675791,
  0.000982307845609036760483159,
  0.0002405651866797641046081205,
  2.842071643544509658430906e-9,
  3.902382987482269030999359e-8,
  2.809715750987233702319539e-7,
  1.408760258481099120190769e-6,
  5.512540141882561774659529e-6,
  0.00001789069846047340503230411,
  0.0000499803639530685600902464,
  0.0001231658968843475230795358,
  0.0002722614562706629457547633,
  0.000546203538814601588705544,
  0.001002444141824445268683115,
  0.001691624489328751390902757,
  0.002631415872289168830293178,
  0.003773623860810291564321535,
  0.004976207288980604260643783,
  0.005999094342826617358665005,
  0.006544466555810855300361823,
  0.006351982245345830144468829,
  0.005332528304734770985480004,
  0.003683654421033887851811845,
  0.001894450845103142323788949,
  0.000556306994196954491906279,
  5.465522391431749343136357e-10,
  8.26386985584480500682217e-9,
  6.54223030254380396373422e-8,
  3.60296741299513841481015e-7,
  1.547638275127457182725269e-6,
  5.512540141882561774659529e-6,
  0.00001690512310177318944228922,
  0.00004575822794464923458063248,
  0.0001112179151432446673834817,
  0.0002456970935844228599713518,
  0.000497536614508456291441987,
  0.00092873501374911841069171,
  0.001603173535638359161313071,
  0.002561283163445899251801947,
  0.003780941812705851276469541,
  0.005132914945734004157146528,
  0.006351982245345830144468829,
  0.007057758050384255716076476,
  0.006861709215651359723963241,
  0.00557191425030335977584985,
  0.003436013787687071861774074,
  0.001243509751734368864261093,
  8.74483582629079894901817e-11,
  1.453828956120845325274271e-9,
  1.264199092278995935021105e-8,
  7.64265814877756633444577e-8,
  3.60296741299513841481015e-7,
  1.408760258481099120190769e-6,
  4.745297712778439141695221e-6,
  0.00001412290985945964030266435,
  0.00003779955285914197845713105,
  0.0000921364100941585724892569,
  0.0002063855586109152023759355,
  0.0004275129428368957763501521,
  0.0008221402746863380314426,
  0.001470366260496719940849266,
  0.002444245212254287693879299,
  0.003764137626871603048574121,
  0.005332528304734770985480004,
  0.006861709215651359723963241,
  0.00784195338931583968452942,
  0.007635586194860159692831275,
  0.005803045508093721366551769,
  0.002694271128757799205899036,
  1.093104478286349868627271e-11,
  1.996103829914204107928061e-10,
  1.905371837645376648476785e-9,
  1.264199092278995935021105e-8,
  6.54223030254380396373422e-8,
  2.809715750987233702319539e-7,
  1.040635463328605074933162e-6,
  3.410485972253411590117087e-6,
  0.00001007159138681085610206452,
  0.0000271559945540677897863073,
  0.0000675020436058256488973924,
  0.0001557739467826745743785979,
  0.0003353466909904799865094817,
  0.000675383545491316336466648,
  0.001273580400069339377337108,
  0.002245275075677798309675791,
  0.003683654421033887851811845,
  0.00557191425030335977584985,
  0.007635586194860159692831275,
  0.00916270343383219163139753,
  0.00893363584798638684061259,
  0.005672149744753261486103233,
  9.5052563329247814663241e-13,
  1.905371837645376648476785e-11,
  1.996103829914204107928061e-10,
  1.453828956120845325274271e-9,
  8.26386985584480500682217e-9,
  3.902382987482269030999359e-8,
  1.591560120384925408721307e-7,
  5.755195078177632058322584e-7,
  1.880030392204693139052044e-6,
  5.62517030048547074144937e-6,
  0.00001557739467826745743785979,
  0.0000402416029188575983811378,
  0.0000975554010154123597118492,
  0.000222876570012134391033994,
  0.000481130373359528209216241,
  0.000982307845609036760483159,
  0.001894450845103142323788949,
  0.003436013787687071861774074,
  0.005803045508093721366551769,
  0.00893363584798638684061259,
  0.01191151446398184912081679,
  0.01162790697674418604651163,
  4.3205710604203552119655e-14,
  9.5052563329247814663241e-13,
  1.093104478286349868627271e-11,
  8.74483582629079894901817e-11,
  5.465522391431749343136357e-10,
  2.842071643544509658430906e-9,
  1.278932239595029346293908e-8,
  5.11572895838011738517563e-8,
  1.854451747412792552126166e-7,
  6.18150582470930850708722e-7,
  1.916266805659885637197038e-6,
  5.574594343737849126391384e-6,
  0.00001533013444527908509757631,
  0.00004009419777996068410135342,
  0.0001002354944499017102533835,
  0.0002405651866797641046081205,
  0.000556306994196954491906279,
  0.001243509751734368864261093,
  0.002694271128757799205899036,
  0.005672149744753261486103233,
  0.01162790697674418604651163,
  0.02325581395348837209302326,

  0.02222222222222222222222222,
  0.01111111111111111111111111,
  0.005426356589147286821705426,
  0.002583979328165374677002584,
  0.001197453835003466313732905,
  0.000538854225751559841179807,
  0.0002348851753276030076937621,
  0.0000988990211905696874500051,
  0.00004009419777996068410135342,
  0.00001559218802554026603941522,
  5.791384123772098814639938e-6,
  2.044017926037211346343507e-6,
  6.813393086790704487811691e-7,
  2.129185339622095152441154e-7,
  6.18150582470930850708722e-8,
  1.648401553255815601889925e-8,
  3.978900300962313521803268e-9,
  8.526214930633528975292717e-10,
  1.578928690858060921350503e-10,
  2.429121062858555263616159e-11,
  2.914945275430266316339391e-12,
  2.429121062858555263616159e-13,
  1.056139592547197940702678e-14,
  0.01111111111111111111111111,
  0.01136950904392764857881137,
  0.00852713178294573643410853,
  0.005546101972647633453078717,
  0.003292998046259532362765488,
  0.00182381430254374100091627,
  0.000951903078959233241706299,
  0.0004704385872848720267892134,
  0.0002205180877897837625574438,
  0.0000980080390176816722477528,
  0.00004122102817508376215126073,
  0.00001635214340829769077074806,
  6.089470071319192135981699e-6,
  2.115448660011630022425404e-6,
  6.799656407180239357795942e-7,
  2.000818437055334799535358e-7,
  5.314673973428233061265794e-8,
  1.250511523159584249709599e-8,
  2.538431510687190250478886e-9,
  4.275253070631057263964439e-10,
  5.611269655203262658953327e-11,
  5.11171562792843803300096e-12,
  2.429121062858555263616159e-13,
  0.005426356589147286821705426,
  0.00852713178294573643410853,
  0.00873511060692002268859898,
  0.007279258839100018907165816,
  0.005319458382419244586005789,
  0.003527640822025393778088049,
  0.002161077260339880873062949,
  0.001234901291622789070321685,
  0.000661554263369351287672331,
  0.0003329390737218303866063367,
  0.0001573893803048652736684501,
  0.0000697521117260198371939722,
  0.00002887587420915874980610677,
  0.00001110610546506105761773337,
  3.939111297952690386585235e-6,
  1.275521753622775934703791e-6,
  3.720271781399763142886056e-7,
  9.59527111039757914681019e-8,
  2.132282468977239810402264e-8,
  3.927888758642283861267329e-9,
  5.635666479791102931383559e-10,
  5.611269655203262658953327e-11,
  2.914945275430266316339391e-12,
  0.002583979328165374677002584,
  0.005546101972647633453078717,
  0.007279258839100018907165816,
  0.00746590650164104503299058,
  0.006532668188935914403866758,
  0.005084887671387954995442233,
  0.003601795433899801455104915,
  0.002352192936424360133946067,
  0.001426881744522130228312872,
  0.000807125027204437300863847,
  0.0004262629049923434495187189,
  0.0002100063578847909076807765,
  0.0000962529140305291660203559,
  0.00004085004308987975215718022,
  0.00001594402192028469918379738,
  5.668985571656781932016847e-6,
  1.812440098630653838841925e-6,
  5.117477925545375544965434e-7,
  1.243831440236723222734654e-7,
  2.504740657684934636170471e-8,
  3.927888758642283861267329e-9,
  4.275253070631057263964439e-10,
  2.429121062858555263616159e-11,
  0.001197453835003466313732905,
  0.003292998046259532362765488,
  0.005319458382419244586005789,
  0.006532668188935914403866758,
  0.006709226788636885063430724,
  0.006038304109773196557087652,
  0.004888150946006873403356671,
  0.003614767086122729911725941,
  0.00246461392235640675799496,
  0.001557499075933562604010704,
  0.000914402683290027077193381,
  0.000498765099976378405741844,
  0.0002522490160800074695705879,
  0.0001178086064109924995247251,
  0.00005048940274756821408202504,
  0.00001967792107084709882171232,
  6.887272374796484587599313e-6,
  2.126951762804796710876259e-6,
  5.651321108901633772859624e-7,
  1.243831440236723222734654e-7,
  2.132282468977239810402264e-8,
  2.538431510687190250478886e-9,
  1.578928690858060921350503e-10,
  0.000538854225751559841179807,
  0.00182381430254374100091627,
  0.003527640822025393778088049,
  0.005084887671387954995442233,
  0.006038304109773196557087652,
  0.006210827084338145030147299,
  0.005693258160643299610968357,
  0.004732058730924300975350323,
  0.003604497861446244883567629,
  0.002532192046033921136843209,
  0.001645924829922048738948086,
  0.00099065068133239297140449,
  0.000551344278003444897775713,
  0.0002827406553863819988593402,
  0.0001328259672282179170465582,
  0.00005667241268403964460653149,
  0.00002169490798060892645093784,
  7.324112157136517369626073e-6,
  2.126951762804796710876259e-6,
  5.117477925545375544965434e-7,
  9.59527111039757914681019e-8,
  1.250511523159584249709599e-8,
  8.526214930633528975292717e-10,
  0.0002348851753276030076937621,
  0.000951903078959233241706299,
  0.002161077260339880873062949,
  0.003601795433899801455104915,
  0.004888150946006873403356671,
  0.005693258160643299610968357,
  0.005865781135208248084028005,
  0.005446796768407658935168861,
  0.004612206940990356356392988,
  0.003587272065214721610527879,
  0.002572939964016076189619996,
  0.001704155041101556956761296,
  0.00104142808067317369579857,
  0.000585418151857701189945942,
  0.0003010721923839606119721986,
  0.000140500356445848285587026,
  0.00005879634481701259777283153,
  0.00002169490798060892645093784,
  6.887272374796484587599313e-6,
  1.812440098630653838841925e-6,
  3.720271781399763142886056e-7,
  5.314673973428233061265794e-8,
  3.978900300962313521803268e-9,
  0.0000988990211905696874500051,
  0.0004704385872848720267892134,
  0.001234901291622789070321685,
  0.002352192936424360133946067,
  0.003614767086122729911725941,
  0.004732058730924300975350323,
  0.005446796768407658935168861,
  0.005622499889969196320174309,
  0.005271093646846121550163414,
  0.004523850486182111981749444,
  0.003570610562308024099880811,
  0.002596807681678562981731499,
  0.001739528222662883535839369,
  0.00107047890625408217590115,
  0.000602144384767921223944397,
  0.0003071809035337801026498953,
  0.000140500356445848285587026,
  0.00005667241268403964460653149,
  0.00001967792107084709882171232,
  5.668985571656781932016847e-6,
  1.275521753622775934703791e-6,
  2.000818437055334799535358e-7,
  1.648401553255815601889925e-8,
  0.00004009419777996068410135342,
  0.0002205180877897837625574438,
  0.000661554263369351287672331,
  0.001426881744522130228312872,
  0.00246461392235640675799496,
  0.003604497861446244883567629,
  0.004612206940990356356392988,
  0.005271093646846121550163414,
  0.005452855496737367120858704,
  0.005149919080251957836366554,
  0.004463263202885030124851014,
  0.003558125909992261777853256,
  0.002609292333994325303759054,
  0.001756254455573103569837825,
  0.001079932863985945673378538,
  0.000602144384767921223944397,
  0.0003010721923839606119721986,
  0.0001328259672282179170465582,
  0.00005048940274756821408202504,
  0.00001594402192028469918379738,
  3.939111297952690386585235e-6,
  6.799656407180239357795942e-7,
  6.18150582470930850708722e-8,
  0.00001559218802554026603941522,
  0.0000980080390176816722477528,
  0.0003329390737218303866063367,
  0.000807125027204437300863847,
  0.001557499075933562604010704,
  0.002532192046033921136843209,
  0.003587272065214721610527879,
  0.004523850486182111981749444,
  0.005149919080251957836366554,
  0.005340656823964993311787538,
  0.005073623982766743646198161,
  0.00442789002132370354577294,
  0.003551536787936720552338713,
  0.00261317088075611545657029,
  0.001756254455573103569837825,
  0.00107047890625408217590115,
  0.000585418151857701189945942,
  0.0002827406553863819988593402,
  0.0001178086064109924995247251,
  0.00004085004308987975215718022,
  0.00001110610546506105761773337,
  2.115448660011630022425404e-6,
  2.129185339622095152441154e-7,
  5.791384123772098814639938e-6,
  0.00004122102817508376215126073,
  0.0001573893803048652736684501,
  0.0004262629049923434495187189,
  0.000914402683290027077193381,
  0.001645924829922048738948086,
  0.002572939964016076189619996,
  0.003570610562308024099880811,
  0.004463263202885030124851014,
  0.005073623982766743646198161,
  0.005276568942077413392046087,
  0.00503672489925571278331672,
  0.00441625878847783512160379,
  0.003551536787936720552338713,
  0.002609292333994325303759054,
  0.001739528222662883535839369,
  0.00104142808067317369579857,
  0.000551344278003444897775713,
  0.0002522490160800074695705879,
  0.0000962529140305291660203559,
  0.00002887587420915874980610677,
  6.089470071319192135981699e-6,
  6.813393086790704487811691e-7,
  2.044017926037211346343507e-6,
  0.00001635214340829769077074806,
  0.0000697521117260198371939722,
  0.0002100063578847909076807765,
  0.000498765099976378405741844,
  0.00099065068133239297140449,
  0.001704155041101556956761296,
  0.002596807681678562981731499,
  0.003558125909992261777853256,
  0.00442789002132370354577294,
  0.00503672489925571278331672,
  0.005255712938353787252156577,
  0.00503672489925571278331672,
  0.00442789002132370354577294,
  0.003558125909992261777853256,
  0.002596807681678562981731499,
  0.001704155041101556956761296,
  0.00099065068133239297140449,
  0.000498765099976378405741844,
  0.0002100063578847909076807765,
  0.0000697521117260198371939722,
  0.00001635214340829769077074806,
  2.044017926037211346343507e-6,
  6.813393086790704487811691e-7,
  6.089470071319192135981699e-6,
  0.00002887587420915874980610677,
  0.0000962529140305291660203559,
  0.0002522490160800074695705879,
  0.000551344278003444897775713,
  0.00104142808067317369579857,
  0.001739528222662883535839369,
  0.002609292333994325303759054,
  0.003551536787936720552338713,
  0.00441625878847783512160379,
  0.00503672489925571278331672,
  0.005276568942077413392046087,
  0.005073623982766743646198161,
  0.004463263202885030124851014,
  0.003570610562308024099880811,
  0.002572939964016076189619996,
  0.001645924829922048738948086,
  0.000914402683290027077193381,
  0.0004262629049923434495187189,
  0.0001573893803048652736684501,
  0.00004122102817508376215126073,
  5.791384123772098814639938e-6,
  2.129185339622095152441154e-7,
  2.115448660011630022425404e-6,
  0.00001110610546506105761773337,
  0.00004085004308987975215718022,
  0.0001178086064109924995247251,
  0.0002827406553863819988593402,
  0.000585418151857701189945942,
  0.00107047890625408217590115,
  0.001756254455573103569837825,
  0.00261317088075611545657029,
  0.003551536787936720552338713,
  0.00442789002132370354577294,
  0.005073623982766743646198161,
  0.005340656823964993311787538,
  0.005149919080251957836366554,
  0.004523850486182111981749444,
  0.003587272065214721610527879,
  0.002532192046033921136843209,
  0.001557499075933562604010704,
  0.000807125027204437300863847,
  0.0003329390737218303866063367,
  0.0000980080390176816722477528,
  0.00001559218802554026603941522,
  6.18150582470930850708722e-8,
  6.799656407180239357795942e-7,
  3.939111297952690386585235e-6,
  0.00001594402192028469918379738,
  0.00005048940274756821408202504,
  0.0001328259672282179170465582,
  0.0003010721923839606119721986,
  0.000602144384767921223944397,
  0.001079932863985945673378538,
  0.001756254455573103569837825,
  0.002609292333994325303759054,
  0.003558125909992261777853256,
  0.004463263202885030124851014,
  0.005149919080251957836366554,
  0.005452855496737367120858704,
  0.005271093646846121550163414,
  0.004612206940990356356392988,
  0.003604497861446244883567629,
  0.00246461392235640675799496,
  0.001426881744522130228312872,
  0.000661554263369351287672331,
  0.0002205180877897837625574438,
  0.00004009419777996068410135342,
  1.648401553255815601889925e-8,
  2.000818437055334799535358e-7,
  1.275521753622775934703791e-6,
  5.668985571656781932016847e-6,
  0.00001967792107084709882171232,
  0.00005667241268403964460653149,
  0.000140500356445848285587026,
  0.0003071809035337801026498953,
  0.000602144384767921223944397,
  0.00107047890625408217590115,
  0.001739528222662883535839369,
  0.002596807681678562981731499,
  0.003570610562308024099880811,
  0.004523850486182111981749444,
  0.005271093646846121550163414,
  0.005622499889969196320174309,
  0.005446796768407658935168861,
  0.004732058730924300975350323,
  0.003614767086122729911725941,
  0.002352192936424360133946067,
  0.001234901291622789070321685,
  0.0004704385872848720267892134,
  0.0000988990211905696874500051,
  3.978900300962313521803268e-9,
  5.314673973428233061265794e-8,
  3.720271781399763142886056e-7,
  1.812440098630653838841925e-6,
  6.887272374796484587599313e-6,
  0.00002169490798060892645093784,
  0.00005879634481701259777283153,
  0.000140500356445848285587026,
  0.0003010721923839606119721986,
  0.000585418151857701189945942,
  0.00104142808067317369579857,
  0.001704155041101556956761296,
  0.002572939964016076189619996,
  0.003587272065214721610527879,
  0.004612206940990356356392988,
  0.005446796768407658935168861,
  0.005865781135208248084028005,
  0.005693258160643299610968357,
  0.004888150946006873403356671,
  0.003601795433899801455104915,
  0.002161077260339880873062949,
  0.000951903078959233241706299,
  0.0002348851753276030076937621,
  8.526214930633528975292717e-10,
  1.250511523159584249709599e-8,
  9.59527111039757914681019e-8,
  5.117477925545375544965434e-7,
  2.126951762804796710876259e-6,
  7.324112157136517369626073e-6,
  0.00002169490798060892645093784,
  0.00005667241268403964460653149,
  0.0001328259672282179170465582,
  0.0002827406553863819988593402,
  0.000551344278003444897775713,
  0.00099065068133239297140449,
  0.001645924829922048738948086,
  0.002532192046033921136843209,
  0.003604497861446244883567629,
  0.004732058730924300975350323,
  0.005693258160643299610968357,
  0.006210827084338145030147299,
  0.006038304109773196557087652,
  0.005084887671387954995442233,
  0.003527640822025393778088049,
  0.00182381430254374100091627,
  0.000538854225751559841179807,
  1.578928690858060921350503e-10,
  2.538431510687190250478886e-9,
  2.132282468977239810402264e-8,
  1.243831440236723222734654e-7,
  5.651321108901633772859624e-7,
  2.126951762804796710876259e-6,
  6.887272374796484587599313e-6,
  0.00001967792107084709882171232,
  0.00005048940274756821408202504,
  0.0001178086064109924995247251,
  0.0002522490160800074695705879,
  0.000498765099976378405741844,
  0.000914402683290027077193381,
  0.001557499075933562604010704,
  0.00246461392235640675799496,
  0.003614767086122729911725941,
  0.004888150946006873403356671,
  0.006038304109773196557087652,
  0.006709226788636885063430724,
  0.006532668188935914403866758,
  0.005319458382419244586005789,
  0.003292998046259532362765488,
  0.001197453835003466313732905,
  2.429121062858555263616159e-11,
  4.275253070631057263964439e-10,
  3.927888758642283861267329e-9,
  2.504740657684934636170471e-8,
  1.243831440236723222734654e-7,
  5.117477925545375544965434e-7,
  1.812440098630653838841925e-6,
  5.668985571656781932016847e-6,
  0.00001594402192028469918379738,
  0.00004085004308987975215718022,
  0.0000962529140305291660203559,
  0.0002100063578847909076807765,
  0.0004262629049923434495187189,
  0.000807125027204437300863847,
  0.001426881744522130228312872,
  0.002352192936424360133946067,
  0.003601795433899801455104915,
  0.005084887671387954995442233,
  0.006532668188935914403866758,
  0.00746590650164104503299058,
  0.007279258839100018907165816,
  0.005546101972647633453078717,
  0.002583979328165374677002584,
  2.914945275430266316339391e-12,
  5.611269655203262658953327e-11,
  5.635666479791102931383559e-10,
  3.927888758642283861267329e-9,
  2.132282468977239810402264e-8,
  9.59527111039757914681019e-8,
  3.720271781399763142886056e-7,
  1.275521753622775934703791e-6,
  3.939111297952690386585235e-6,
  0.00001110610546506105761773337,
  0.00002887587420915874980610677,
  0.0000697521117260198371939722,
  0.0001573893803048652736684501,
  0.0003329390737218303866063367,
  0.000661554263369351287672331,
  0.001234901291622789070321685,
  0.002161077260339880873062949,
  0.003527640822025393778088049,
  0.005319458382419244586005789,
  0.007279258839100018907165816,
  0.00873511060692002268859898,
  0.00852713178294573643410853,
  0.005426356589147286821705426,
  2.429121062858555263616159e-13,
  5.11171562792843803300096e-12,
  5.611269655203262658953327e-11,
  4.275253070631057263964439e-10,
  2.538431510687190250478886e-9,
  1.250511523159584249709599e-8,
  5.314673973428233061265794e-8,
  2.000818437055334799535358e-7,
  6.799656407180239357795942e-7,
  2.115448660011630022425404e-6,
  6.089470071319192135981699e-6,
  0.00001635214340829769077074806,
  0.00004122102817508376215126073,
  0.0000980080390176816722477528,
  0.0002205180877897837625574438,
  0.0004704385872848720267892134,
  0.000951903078959233241706299,
  0.00182381430254374100091627,
  0.003292998046259532362765488,
  0.005546101972647633453078717,
  0.00852713178294573643410853,
  0.01136950904392764857881137,
  0.01111111111111111111111111,
  1.056139592547197940702678e-14,
  2.429121062858555263616159e-13,
  2.914945275430266316339391e-12,
  2.429121062858555263616159e-11,
  1.578928690858060921350503e-10,
  8.526214930633528975292717e-10,
  3.978900300962313521803268e-9,
  1.648401553255815601889925e-8,
  6.18150582470930850708722e-8,
  2.129185339622095152441154e-7,
  6.813393086790704487811691e-7,
  2.044017926037211346343507e-6,
  5.791384123772098814639938e-6,
  0.00001559218802554026603941522,
  0.00004009419777996068410135342,
  0.0000988990211905696874500051,
  0.0002348851753276030076937621,
  0.000538854225751559841179807,
  0.001197453835003466313732905,
  0.002583979328165374677002584,
  0.005426356589147286821705426,
  0.01111111111111111111111111,
  0.02222222222222222222222222,

  0.02127659574468085106382979,
  0.01063829787234042553191489,
  0.005200945626477541371158392,
  0.002482269503546099290780142,
  0.001154543955137720600362857,
  0.000522293693990873604926054,
  0.0002292996705325786558211945,
  0.0000974523599763459287240077,
  0.00003998045537491115024574674,
  0.00001578175870062282246542634,
  5.971476265100527419350509e-6,
  2.156366429064079345876573e-6,
  7.393256328219700614433963e-7,
  2.39193587089460902231687e-7,
  7.2482905178624515827784e-8,
  2.038581708148814507656424e-8,
  5.260856021029198729435932e-9,
  1.227533071573479703535051e-9,
  2.539723596358923524555278e-10,
  4.535220707783792008134424e-11,
  6.718845493013025197236184e-12,
  7.752514030399644458349443e-13,
  6.20201122431971556667955e-14,
  2.584171343466548152783148e-15,
  0.01063829787234042553191489,
  0.010874704491725768321513,
  0.00815602836879432624113475,
  0.005310902193633514761669141,
  0.003161251305734234977184012,
  0.001757964140749769694629158,
  0.000922931173893629089680308,
  0.0004597752368114782278260875,
  0.0002177882700685949500228836,
  0.0000981028243552229504607584,
  0.0000419662081964009288082133,
  0.00001700448955490531141319812,
  6.50171659452261906975222e-6,
  2.333949546751709409654643e-6,
  7.814563214570455612682957e-7,
  2.419993769673431415540529e-7,
  6.8566490140747223440315e-8,
  1.752409281487657231943141e-8,
  3.963782898603034215109487e-9,
  7.726672316964978976821611e-10,
  1.24815475889434275779426e-10,
  1.569108839752888038369927e-11,
  1.367026640693803972822285e-12,
  6.20201122431971556667955e-14,
  0.005200945626477541371158392,
  0.00815602836879432624113475,
  0.00834570344713838033976579,
  0.006954752872615316949804827,
  0.005088843565328280694979142,
  0.003384080970943306662161129,
  0.002082511366734342561329926,
  0.00119783548537727222512586,
  0.000647478640744471473041005,
  0.0003297344929717215834931045,
  0.0001582725566264263600766901,
  0.0000715188825397488097672744,
  0.00003034134410777222232551036,
  0.00001203442735043850164353175,
  4.436655244401290928490969e-6,
  1.50846278309643891568693e-6,
  4.681436223402741462476678e-7,
  1.308048356539001290986131e-7,
  3.229749028491361212311434e-8,
  6.864851173918885167868432e-9,
  1.208213806609723789544844e-9,
  1.654102235239502807114965e-10,
  1.569108839752888038369927e-11,
  7.752514030399644458349443e-13,
  0.002482269503546099290780142,
  0.005310902193633514761669141,
  0.006954752872615316949804827,
  0.007124380991459592972970798,
  0.006233833367527143851349449,
  0.004859193189046799309769827,
  0.003452584634322725825362772,
  0.002266175242605650155643518,
  0.001384884870481230650671039,
  0.000791362783132131800383451,
  0.0004236118427354352578523177,
  0.0002123894087544055562785725,
  0.0000995575353536276045055809,
  0.0000434792213951326510992115,
  0.00001759873246945845401634751,
  6.554010712763838047467349e-6,
  2.223682206116302194676422e-6,
  6.782472959831858545854011e-7,
  1.826050412262423454653003e-7,
  4.228748323134033263406954e-8,
  8.10510095267356375486333e-9,
  1.208213806609723789544844e-9,
  1.24815475889434275779426e-10,
  6.718845493013025197236184e-12,
  0.001154543955137720600362857,
  0.003161251305734234977184012,
  0.005088843565328280694979142,
  0.006233833367527143851349449,
  0.006393675248745788565486614,
  0.005754307723871209708937953,
  0.004665654911246926791030772,
  0.003462212176203076626677597,
  0.002374088349396395401150352,
  0.001512899438340840206615421,
  0.000898570575499408122717038,
  0.000497787676768138022527904,
  0.0002569226718803293019498861,
  0.0001231911272862091781144326,
  0.00005461675593969865039556124,
  0.00002223682206116302194676422,
  8.23586002265297109139416e-6,
  2.739075618393635181979504e-6,
  8.034621813954663200473212e-7,
  2.026275238168390938715832e-7,
  4.228748323134033263406954e-8,
  6.864851173918885167868432e-9,
  7.726672316964978976821611e-10,
  4.535220707783792008134424e-11,
  0.000522293693990873604926054,
  0.001757964140749769694629158,
  0.003384080970943306662161129,
  0.004859193189046799309769827,
  0.005754307723871209708937953,
  0.005909829554246107268638978,
  0.005417343758058931662919064,
  0.004510767863853151262185669,
  0.003449410719417115671083159,
  0.002438977276355536333089102,
  0.001600578837608320718589723,
  0.000976306153145251347409567,
  0.000553240153448975763532088,
  0.0002905611415991968201043858,
  0.0001408332063873658056628401,
  0.0000625925361721625802945956,
  0.00002527775499260411896512514,
  9.15946886790831604853946e-6,
  2.925941443915156515505662e-6,
  8.034621813954663200473212e-7,
  1.826050412262423454653003e-7,
  3.229749028491361212311434e-8,
  3.963782898603034215109487e-9,
  2.539723596358923524555278e-10,
  0.0002292996705325786558211945,
  0.000922931173893629089680308,
  0.002082511366734342561329926,
  0.003452584634322725825362772,
  0.004665654911246926791030772,
  0.005417343758058931662919064,
  0.00557212500828918685328818,
  0.005174116079125673506624738,
  0.004390159097439965399560384,
  0.00342981179487497296840655,
  0.002478315619522561112655055,
  0.001659720460346927290596264,
  0.001030171320215334180370095,
  0.000591499466826936383783928,
  0.0003129626808608129014729779,
  0.0001516665299556247137907508,
  0.0000667332731804748740679304,
  0.00002633347299523640863955095,
  9.15946886790831604853946e-6,
  2.739075618393635181979504e-6,
  6.782472959831858545854011e-7,
  1.308048356539001290986131e-7,
  1.752409281487657231943141e-8,
  1.227533071573479703535051e-9,
  0.0000974523599763459287240077,
  0.0004597752368114782278260875,
  0.00119783548537727222512586,
  0.002266175242605650155643518,
  0.003462212176203076626677597,
  0.004510767863853151262185669,
  0.005174116079125673506624738,
  0.005330907475462815128037609,
  0.004997725758246389182535258,
  0.004299118931824850909707749,
  0.003410634352581048388368148,
  0.002501844634808668723755945,
  0.001697680287905882348262963,
  0.001064073114926763865008125,
  0.000613888335534671460581611,
  0.0003241330411623065311870904,
  0.0001553137488902718795271475,
  0.0000667332731804748740679304,
  0.00002527775499260411896512514,
  8.23586002265297109139416e-6,
  2.223682206116302194676422e-6,
  4.681436223402741462476678e-7,
  6.8566490140747223440315e-8,
  5.260856021029198729435932e-9,
  0.00003998045537491115024574674,
  0.0002177882700685949500228836,
  0.000647478640744471473041005,
  0.001384884870481230650671039,
  0.002374088349396395401150352,
  0.003449410719417115671083159,
  0.004390159097439965399560384,
  0.004997725758246389182535258,
  0.005158942718189821091649299,
  0.004872334789401497697668782,
  0.004233890920445439378663908,
  0.003395360575811764696525926,
  0.002515081908008714590019204,
  0.001718887339497080089628509,
  0.001080443470541021770623635,
  0.00062125499556108751810859,
  0.0003241330411623065311870904,
  0.0001516665299556247137907508,
  0.0000625925361721625802945956,
  0.00002223682206116302194676422,
  6.554010712763838047467349e-6,
  1.50846278309643891568693e-6,
  2.419993769673431415540529e-7,
  2.038581708148814507656424e-8,
  0.00001578175870062282246542634,
  0.0000981028243552229504607584,
  0.0003297344929717215834931045,
  0.000791362783132131800383451,
  0.001512899438340840206615421,
  0.002438977276355536333089102,
  0.00342981179487497296840655,
  0.004299118931824850909707749,
  0.004872334789401497697668782,
  0.005040346333863618307933223,
  0.004788329017170437392536562,
  0.004191803180014524316698674,
  0.003385687183857885025025852,
  0.002521034764595717464788481,
  0.001725708321003020883634972,
  0.001080443470541021770623635,
  0.000613888335534671460581611,
  0.0003129626808608129014729779,
  0.0001408332063873658056628401,
  0.00005461675593969865039556124,
  0.00001759873246945845401634751,
  4.436655244401290928490969e-6,
  7.814563214570455612682957e-7,
  7.2482905178624515827784e-8,
  5.971476265100527419350509e-6,
  0.0000419662081964009288082133,
  0.0001582725566264263600766901,
  0.0004236118427354352578523177,
  0.000898570575499408122717038,
  0.001600578837608320718589723,
  0.002478315619522561112655055,
  0.003410634352581048388368148,
  0.004233890920445439378663908,
  0.004788329017170437392536562,
  0.004965674536324898036704583,
  0.004739962057401039035036193,
  0.00417116661051291435083185,
  0.003382388309165920931924545,
  0.002521034764595717464788481,
  0.001718887339497080089628509,
  0.001064073114926763865008125,
  0.000591499466826936383783928,
  0.0002905611415991968201043858,
  0.0001231911272862091781144326,
  0.0000434792213951326510992115,
  0.00001203442735043850164353175,
  2.333949546751709409654643e-6,
  2.39193587089460902231687e-7,
  2.156366429064079345876573e-6,
  0.00001700448955490531141319812,
  0.0000715188825397488097672744,
  0.0002123894087544055562785725,
  0.000497787676768138022527904,
  0.000976306153145251347409567,
  0.001659720460346927290596264,
  0.002501844634808668723755945,
  0.003395360575811764696525926,
  0.004191803180014524316698674,
  0.004739962057401039035036193,
  0.00492956053969708059643764,
  0.004724162183876368904919405,
  0.00417116661051291435083185,
  0.003385687183857885025025852,
  0.002515081908008714590019204,
  0.001697680287905882348262963,
  0.001030171320215334180370095,
  0.000553240153448975763532088,
  0.0002569226718803293019498861,
  0.0000995575353536276045055809,
  0.00003034134410777222232551036,
  6.50171659452261906975222e-6,
  7.393256328219700614433963e-7,
  7.393256328219700614433963e-7,
  6.50171659452261906975222e-6,
  0.00003034134410777222232551036,
  0.0000995575353536276045055809,
  0.0002569226718803293019498861,
  0.000553240153448975763532088,
  0.001030171320215334180370095,
  0.001697680287905882348262963,
  0.002515081908008714590019204,
  0.003385687183857885025025852,
  0.00417116661051291435083185,
  0.004724162183876368904919405,
  0.00492956053969708059643764,
  0.004739962057401039035036193,
  0.004191803180014524316698674,
  0.003395360575811764696525926,
  0.002501844634808668723755945,
  0.001659720460346927290596264,
  0.000976306153145251347409567,
  0.000497787676768138022527904,
  0.0002123894087544055562785725,
  0.0000715188825397488097672744,
  0.00001700448955490531141319812,
  2.156366429064079345876573e-6,
  2.39193587089460902231687e-7,
  2.333949546751709409654643e-6,
  0.00001203442735043850164353175,
  0.0000434792213951326510992115,
  0.0001231911272862091781144326,
  0.0002905611415991968201043858,
  0.000591499466826936383783928,
  0.001064073114926763865008125,
  0.001718887339497080089628509,
  0.002521034764595717464788481,
  0.003382388309165920931924545,
  0.00417116661051291435083185,
  0.004739962057401039035036193,
  0.004965674536324898036704583,
  0.004788329017170437392536562,
  0.004233890920445439378663908,
  0.003410634352581048388368148,
  0.002478315619522561112655055,
  0.001600578837608320718589723,
  0.000898570575499408122717038,
  0.0004236118427354352578523177,
  0.0001582725566264263600766901,
  0.0000419662081964009288082133,
  5.971476265100527419350509e-6,
  7.2482905178624515827784e-8,
  7.814563214570455612682957e-7,
  4.436655244401290928490969e-6,
  0.00001759873246945845401634751,
  0.00005461675593969865039556124,
  0.0001408332063873658056628401,
  0.0003129626808608129014729779,
  0.000613888335534671460581611,
  0.001080443470541021770623635,
  0.001725708321003020883634972,
  0.002521034764595717464788481,
  0.003385687183857885025025852,
  0.004191803180014524316698674,
  0.004788329017170437392536562,
  0.005040346333863618307933223,
  0.004872334789401497697668782,
  0.004299118931824850909707749,
  0.00342981179487497296840655,
  0.002438977276355536333089102,
  0.001512899438340840206615421,
  0.000791362783132131800383451,
  0.0003297344929717215834931045,
  0.0000981028243552229504607584,
  0.00001578175870062282246542634,
  2.038581708148814507656424e-8,
  2.419993769673431415540529e-7,
  1.50846278309643891568693e-6,
  6.554010712763838047467349e-6,
  0.00002223682206116302194676422,
  0.0000625925361721625802945956,
  0.0001516665299556247137907508,
  0.0003241330411623065311870904,
  0.00062125499556108751810859,
  0.001080443470541021770623635,
  0.001718887339497080089628509,
  0.002515081908008714590019204,
  0.003395360575811764696525926,
  0.004233890920445439378663908,
  0.004872334789401497697668782,
  0.005158942718189821091649299,
  0.004997725758246389182535258,
  0.004390159097439965399560384,
  0.003449410719417115671083159,
  0.002374088349396395401150352,
  0.001384884870481230650671039,
  0.000647478640744471473041005,
  0.0002177882700685949500228836,
  0.00003998045537491115024574674,
  5.260856021029198729435932e-9,
  6.8566490140747223440315e-8,
  4.681436223402741462476678e-7,
  2.223682206116302194676422e-6,
  8.23586002265297109139416e-6,
  0.00002527775499260411896512514,
  0.0000667332731804748740679304,
  0.0001553137488902718795271475,
  0.0003241330411623065311870904,
  0.000613888335534671460581611,
  0.001064073114926763865008125,
  0.001697680287905882348262963,
  0.002501844634808668723755945,
  0.003410634352581048388368148,
  0.004299118931824850909707749,
  0.004997725758246389182535258,
  0.005330907475462815128037609,
  0.005174116079125673506624738,
  0.004510767863853151262185669,
  0.003462212176203076626677597,
  0.002266175242605650155643518,
  0.00119783548537727222512586,
  0.0004597752368114782278260875,
  0.0000974523599763459287240077,
  1.227533071573479703535051e-9,
  1.752409281487657231943141e-8,
  1.308048356539001290986131e-7,
  6.782472959831858545854011e-7,
  2.739075618393635181979504e-6,
  9.15946886790831604853946e-6,
  0.00002633347299523640863955095,
  0.0000667332731804748740679304,
  0.0001516665299556247137907508,
  0.0003129626808608129014729779,
  0.000591499466826936383783928,
  0.001030171320215334180370095,
  0.001659720460346927290596264,
  0.002478315619522561112655055,
  0.00342981179487497296840655,
  0.004390159097439965399560384,
  0.005174116079125673506624738,
  0.00557212500828918685328818,
  0.005417343758058931662919064,
  0.004665654911246926791030772,
  0.003452584634322725825362772,
  0.002082511366734342561329926,
  0.000922931173893629089680308,
  0.0002292996705325786558211945,
  2.539723596358923524555278e-10,
  3.963782898603034215109487e-9,
  3.229749028491361212311434e-8,
  1.826050412262423454653003e-7,
  8.034621813954663200473212e-7,
  2.925941443915156515505662e-6,
  9.15946886790831604853946e-6,
  0.00002527775499260411896512514,
  0.0000625925361721625802945956,
  0.0001408332063873658056628401,
  0.0002905611415991968201043858,
  0.000553240153448975763532088,
  0.000976306153145251347409567,
  0.001600578837608320718589723,
  0.002438977276355536333089102,
  0.003449410719417115671083159,
  0.004510767863853151262185669,
  0.005417343758058931662919064,
  0.005909829554246107268638978,
  0.005754307723871209708937953,
  0.004859193189046799309769827,
  0.003384080970943306662161129,
  0.001757964140749769694629158,
  0.000522293693990873604926054,
  4.535220707783792008134424e-11,
  7.726672316964978976821611e-10,
  6.864851173918885167868432e-9,
  4.228748323134033263406954e-8,
  2.026275238168390938715832e-7,
  8.034621813954663200473212e-7,
  2.739075618393635181979504e-6,
  8.23586002265297109139416e-6,
  0.00002223682206116302194676422,
  0.00005461675593969865039556124,
  0.0001231911272862091781144326,
  0.0002569226718803293019498861,
  0.000497787676768138022527904,
  0.000898570575499408122717038,
  0.001512899438340840206615421,
  0.002374088349396395401150352,
  0.003462212176203076626677597,
  0.004665654911246926791030772,
  0.005754307723871209708937953,
  0.006393675248745788565486614,
  0.006233833367527143851349449,
  0.005088843565328280694979142,
  0.003161251305734234977184012,
  0.001154543955137720600362857,
  6.718845493013025197236184e-12,
  1.24815475889434275779426e-10,
  1.208213806609723789544844e-9,
  8.10510095267356375486333e-9,
  4.228748323134033263406954e-8,
  1.826050412262423454653003e-7,
  6.782472959831858545854011e-7,
  2.223682206116302194676422e-6,
  6.554010712763838047467349e-6,
  0.00001759873246945845401634751,
  0.0000434792213951326510992115,
  0.0000995575353536276045055809,
  0.0002123894087544055562785725,
  0.0004236118427354352578523177,
  0.000791362783132131800383451,
  0.001384884870481230650671039,
  0.002266175242605650155643518,
  0.003452584634322725825362772,
  0.004859193189046799309769827,
  0.006233833367527143851349449,
  0.007124380991459592972970798,
  0.006954752872615316949804827,
  0.005310902193633514761669141,
  0.002482269503546099290780142,
  7.752514030399644458349443e-13,
  1.569108839752888038369927e-11,
  1.654102235239502807114965e-10,
  1.208213806609723789544844e-9,
  6.864851173918885167868432e-9,
  3.229749028491361212311434e-8,
  1.308048356539001290986131e-7,
  4.681436223402741462476678e-7,
  1.50846278309643891568693e-6,
  4.436655244401290928490969e-6,
  0.00001203442735043850164353175,
  0.00003034134410777222232551036,
  0.0000715188825397488097672744,
  0.0001582725566264263600766901,
  0.0003297344929717215834931045,
  0.000647478640744471473041005,
  0.00119783548537727222512586,
  0.002082511366734342561329926,
  0.003384080970943306662161129,
  0.005088843565328280694979142,
  0.006954752872615316949804827,
  0.00834570344713838033976579,
  0.00815602836879432624113475,
  0.005200945626477541371158392,
  6.20201122431971556667955e-14,
  1.367026640693803972822285e-12,
  1.569108839752888038369927e-11,
  1.24815475889434275779426e-10,
  7.726672316964978976821611e-10,
  3.963782898603034215109487e-9,
  1.752409281487657231943141e-8,
  6.8566490140747223440315e-8,
  2.419993769673431415540529e-7,
  7.814563214570455612682957e-7,
  2.333949546751709409654643e-6,
  6.50171659452261906975222e-6,
  0.00001700448955490531141319812,
  0.0000419662081964009288082133,
  0.0000981028243552229504607584,
  0.0002177882700685949500228836,
  0.0004597752368114782278260875,
  0.000922931173893629089680308,
  0.001757964140749769694629158,
  0.003161251305734234977184012,
  0.005310902193633514761669141,
  0.00815602836879432624113475,
  0.010874704491725768321513,
  0.01063829787234042553191489,
  2.584171343466548152783148e-15,
  6.20201122431971556667955e-14,
  7.752514030399644458349443e-13,
  6.718845493013025197236184e-12,
  4.535220707783792008134424e-11,
  2.539723596358923524555278e-10,
  1.227533071573479703535051e-9,
  5.260856021029198729435932e-9,
  2.038581708148814507656424e-8,
  7.2482905178624515827784e-8,
  2.39193587089460902231687e-7,
  7.393256328219700614433963e-7,
  2.156366429064079345876573e-6,
  5.971476265100527419350509e-6,
  0.00001578175870062282246542634,
  0.00003998045537491115024574674,
  0.0000974523599763459287240077,
  0.0002292996705325786558211945,
  0.000522293693990873604926054,
  0.001154543955137720600362857,
  0.002482269503546099290780142,
  0.005200945626477541371158392,
  0.01063829787234042553191489,
  0.02127659574468085106382979,

  0.02040816326530612244897959,
  0.0102040816326530612244898,
  0.004993486756404689535388624,
  0.002388189318280503690838037,
  0.001114488348530901722391084,
  0.000506585612968591691995947,
  0.0002238401545675172592540232,
  0.00009593149481465025396601,
  0.00003977647345973303213224803,
  0.00001591058938389321285289921,
  6.119457455343543404961236e-6,
  2.254536957231831780775192e-6,
  7.921346065949679229750675e-7,
  2.640448688649893076583558e-7,
  8.29855302147109252640547e-8,
  2.440750888667968390119256e-8,
  6.656593332730822882143424e-9,
  1.664148333182705720535856e-9,
  3.757754300735141949597094e-10,
  7.51550860147028389919419e-11,
  1.29577734508108343089555e-11,
  1.851110492972976329850785e-12,
  2.056789436636640366500873e-13,
  1.582145720489723358846825e-14,
  6.3285828819588934353873e-16,
  0.0102040816326530612244898,
  0.01042118975249674337820234,
  0.00781589231437255753365176,
  0.005094803878998407873787813,
  0.003039513677811550151975684,
  0.001696472750406446596451544,
  0.000895360618270069037016093,
  0.0004492401708393377746700954,
  0.0002147929566825583735141394,
  0.0000979113192854966944793798,
  0.00004251412547922882786604648,
  0.00001754882820764236629360149,
  6.865166590489721999117251e-6,
  2.534830741103897353520216e-6,
  8.78670319920468620442932e-7,
  2.840146488631817763047861e-7,
  8.48715649923179917473287e-8,
  2.319071225596544746037064e-8,
  5.711786537117415763387583e-9,
  1.243946251277840093659728e-9,
  2.33239922114595017561199e-10,
  3.619949408480487045041536e-11,
  4.366722188551636470417237e-12,
  3.645263740008322618783085e-13,
  1.582145720489723358846825e-14,
  0.004993486756404689535388624,
  0.00781589231437255753365176,
  0.0079895788102475032566218,
  0.006657982341872919380518165,
  0.00487735915741853396479819,
  0.003251572771612355976532127,
  0.002009101875142593936719038,
  0.001162408942046786491958872,
  0.000633363846628056742413488,
  0.0003259416286740876803063563,
  0.0001585661977333399525814706,
  0.0000728763838067370489137062,
  0.00003157976631625272119593936,
  0.0000128605383188359498083011,
  4.89925269288988564125756e-6,
  1.735151995398501164612053e-6,
  5.667230307551556223128075e-7,
  1.689056875976150090030328e-7,
  4.530037598403467674410842e-8,
  1.072903641727137080781515e-8,
  2.185544455370094053443827e-9,
  3.68260237901188009005187e-10,
  4.82086129616100666334063e-11,
  4.366722188551636470417237e-12,
  2.056789436636640366500873e-13,
  0.002388189318280503690838037,
  0.005094803878998407873787813,
  0.006657982341872919380518165,
  0.006812819140521126807972076,
  0.005961216747955985956975566,
  0.00465265697401442806398093,
  0.003315018093985279995586412,
  0.002185726215814470326760272,
  0.00134450921828061168126372,
  0.000775212522251884212620523,
  0.0004199067828864372818361167,
  0.0002137707258330953434802049,
  0.000102169832199641156810392,
  0.00004572635846697226598507056,
  0.00001908667194938351281073258,
  7.388389141696843668670675e-6,
  2.632113631729500556963928e-6,
  8.542356614132253328889016e-7,
  2.491520679121907220925963e-7,
  6.41093040241894255676856e-8,
  1.41780191591957383466997e-8,
  2.592552074824363583396517e-9,
  3.68260237901188009005187e-10,
  3.619949408480487045041536e-11,
  1.851110492972976329850785e-12,
  0.001114488348530901722391084,
  0.003039513677811550151975684,
  0.00487735915741853396479819,
  0.005961216747955985956975566,
  0.00610661227839393683397497,
  0.005495951050554543150577473,
  0.004462524357287876917135555,
  0.003321728656928570036063308,
  0.002289299479775095565394982,
  0.001469673740102530486426409,
  0.000881804244061518291855845,
  0.000495130725275184067619592,
  0.0002600686637809047627900888,
  0.0001275336716617898355989859,
  0.00005818356449086264389078157,
  0.00002456639389614200519833,
  9.53006659764129512004181e-6,
  3.36355291681457474825005e-6,
  1.065817179402149200062773e-6,
  2.977384023431105052806937e-7,
  7.14572165623465212673665e-8,
  1.41780191591957383466997e-8,
  2.185544455370094053443827e-9,
  2.33239922114595017561199e-10,
  1.29577734508108343089555e-11,
  0.000506585612968591691995947,
  0.001696472750406446596451544,
  0.003251572771612355976532127,
  0.00465265697401442806398093,
  0.005495951050554543150577473,
  0.00563687287236363400059228,
  0.00516713346633333116720959,
  0.004309269608988415181919967,
  0.003306765915230693594459419,
  0.002351477984164048778282254,
  0.001556125136579149926804433,
  0.000960253527806417585686482,
  0.000552645910534422620928939,
  0.0002962072374080280052621607,
  0.00014739836337685203118998,
  0.0000677693624721158764091862,
  0.00002859019979292388536012543,
  0.00001096269098813639177207424,
  3.77135309634606640022212e-6,
  1.143315464997544340277864e-6,
  2.977384023431105052806937e-7,
  6.41093040241894255676856e-8,
  1.072903641727137080781515e-8,
  1.243946251277840093659728e-9,
  7.51550860147028389919419e-11,
  0.0002238401545675172592540232,
  0.000895360618270069037016093,
  0.002009101875142593936719038,
  0.003315018093985279995586412,
  0.004462524357287876917135555,
  0.00516713346633333116720959,
  0.005306785722180177955512552,
  0.00492772959916730810154737,
  0.004188570159292211886315264,
  0.003285153066111538734364913,
  0.002389202229899300897719937,
  0.001615426507716004584253821,
  0.001016155383885873851385468,
  0.000594060070579433943886889,
  0.0003219044717425504129436344,
  0.0001609522358712752064718172,
  0.0000737697747743344696329162,
  0.00003070958949881796925895155,
  0.00001146491341289204185667525,
  3.77135309634606640022212e-6,
  1.065817179402149200062773e-6,
  2.491520679121907220925963e-7,
  4.530037598403467674410842e-8,
  5.711786537117415763387583e-9,
  3.757754300735141949597094e-10,
  0.00009593149481465025396601,
  0.0004492401708393377746700954,
  0.001162408942046786491958872,
  0.002185726215814470326760272,
  0.003321728656928570036063308,
  0.004309269608988415181919967,
  0.00492772959916730810154737,
  0.005068521873429231190163009,
  0.004751739256339904240777821,
  0.00409577525125594439609132,
  0.003263820903344580690635271,
  0.002411973218893942328563309,
  0.001654881625185565986542048,
  0.001053505543884710442360985,
  0.000620815766932061510677009,
  0.0003372332561112432897504742,
  0.0001678059711899696177364138,
  0.0000758088152199392155420975,
  0.00003070958949881796925895155,
  0.00001096269098813639177207424,
  3.36355291681457474825005e-6,
  8.542356614132253328889016e-7,
  1.689056875976150090030328e-7,
  2.319071225596544746037064e-8,
  1.664148333182705720535856e-9,
  0.00003977647345973303213224803,
  0.0002147929566825583735141394,
  0.000633363846628056742413488,
  0.00134450921828061168126372,
  0.002289299479775095565394982,
  0.003306765915230693594459419,
  0.004188570159292211886315264,
  0.004751739256339904240777821,
  0.004895731355016871035952906,
  0.004623746279738155978399967,
  0.00402713385654613585215481,
  0.003246113957094764050524786,
  0.002425257554151260497518518,
  0.00167902446056625726751282,
  0.001074931003854587986079636,
  0.000633933668939885222559786,
  0.0003423241812275380201822842,
  0.0001678059711899696177364138,
  0.0000737697747743344696329162,
  0.00002859019979292388536012543,
  9.53006659764129512004181e-6,
  2.632113631729500556963928e-6,
  5.667230307551556223128075e-7,
  8.48715649923179917473287e-8,
  6.656593332730822882143424e-9,
  0.00001591058938389321285289921,
  0.0000979113192854966944793798,
  0.0003259416286740876803063563,
  0.000775212522251884212620523,
  0.001469673740102530486426409,
  0.002351477984164048778282254,
  0.003285153066111538734364913,
  0.00409577525125594439609132,
  0.004623746279738155978399967,
  0.004772899385536161009961256,
  0.004534254416259352959463193,
  0.003979909832453350560030389,
  0.003233676738868347330024691,
  0.002432167119832603120018571,
  0.001690489783839693926826095,
  0.001081913461657404113168701,
  0.000633933668939885222559786,
  0.0003372332561112432897504742,
  0.0001609522358712752064718172,
  0.0000677693624721158764091862,
  0.00002456639389614200519833,
  7.388389141696843668670675e-6,
  1.735151995398501164612053e-6,
  2.840146488631817763047861e-7,
  2.440750888667968390119256e-8,
  6.119457455343543404961236e-6,
  0.00004251412547922882786604648,
  0.0001585661977333399525814706,
  0.0004199067828864372818361167,
  0.000881804244061518291855845,
  0.001556125136579149926804433,
  0.002389202229899300897719937,
  0.003263820903344580690635271,
  0.00402713385654613585215481,
  0.004534254416259352959463193,
  0.004690608016820020302892959,
  0.004477398561510019380034188,
  0.003952271569727980070030178,
  0.003227298678239415678486181,
  0.002434305288729159254629577,
  0.001690489783839693926826095,
  0.001074931003854587986079636,
  0.000620815766932061510677009,
  0.0003219044717425504129436344,
  0.00014739836337685203118998,
  0.00005818356449086264389078157,
  0.00001908667194938351281073258,
  4.89925269288988564125756e-6,
  8.78670319920468620442932e-7,
  8.29855302147109252640547e-8,
  2.254536957231831780775192e-6,
  0.00001754882820764236629360149,
  0.0000728763838067370489137062,
  0.0002137707258330953434802049,
  0.000495130725275184067619592,
  0.000960253527806417585686482,
  0.001615426507716004584253821,
  0.002411973218893942328563309,
  0.003246113957094764050524786,
  0.003979909832453350560030389,
  0.004477398561510019380034188,
  0.004643228137862242320035454,
  0.004449760298784648890033977,
  0.00394317220323070424716857,
  0.003227298678239415678486181,
  0.002432167119832603120018571,
  0.00167902446056625726751282,
  0.001053505543884710442360985,
  0.000594060070579433943886889,
  0.0002962072374080280052621607,
  0.0001275336716617898355989859,
  0.00004572635846697226598507056,
  0.0000128605383188359498083011,
  2.534830741103897353520216e-6,
  2.640448688649893076583558e-7,
  7.921346065949679229750675e-7,
  6.865166590489721999117251e-6,
  0.00003157976631625272119593936,
  0.000102169832199641156810392,
  0.0002600686637809047627900888,
  0.000552645910534422620928939,
  0.001016155383885873851385468,
  0.001654881625185565986542048,
  0.002425257554151260497518518,
  0.003233676738868347330024691,
  0.003952271569727980070030178,
  0.004449760298784648890033977,
  0.004627750710736034845635336,
  0.004449760298784648890033977,
  0.003952271569727980070030178,
  0.003233676738868347330024691,
  0.002425257554151260497518518,
  0.001654881625185565986542048,
  0.001016155383885873851385468,
  0.000552645910534422620928939,
  0.0002600686637809047627900888,
  0.000102169832199641156810392,
  0.00003157976631625272119593936,
  6.865166590489721999117251e-6,
  7.921346065949679229750675e-7,
  2.640448688649893076583558e-7,
  2.534830741103897353520216e-6,
  0.0000128605383188359498083011,
  0.00004572635846697226598507056,
  0.0001275336716617898355989859,
  0.0002962072374080280052621607,
  0.000594060070579433943886889,
  0.001053505543884710442360985,
  0.00167902446056625726751282,
  0.002432167119832603120018571,
  0.003227298678239415678486181,
  0.00394317220323070424716857,
  0.004449760298784648890033977,
  0.004643228137862242320035454,
  0.004477398561510019380034188,
  0.003979909832453350560030389,
  0.003246113957094764050524786,
  0.002411973218893942328563309,
  0.001615426507716004584253821,
  0.000960253527806417585686482,
  0.000495130725275184067619592,
  0.0002137707258330953434802049,
  0.0000728763838067370489137062,
  0.00001754882820764236629360149,
  2.254536957231831780775192e-6,
  8.29855302147109252640547e-8,
  8.78670319920468620442932e-7,
  4.89925269288988564125756e-6,
  0.00001908667194938351281073258,
  0.00005818356449086264389078157,
  0.00014739836337685203118998,
  0.0003219044717425504129436344,
  0.000620815766932061510677009,
  0.001074931003854587986079636,
  0.001690489783839693926826095,
  0.002434305288729159254629577,
  0.003227298678239415678486181,
  0.003952271569727980070030178,
  0.004477398561510019380034188,
  0.004690608016820020302892959,
  0.004534254416259352959463193,
  0.00402713385654613585215481,
  0.003263820903344580690635271,
  0.002389202229899300897719937,
  0.001556125136579149926804433,
  0.000881804244061518291855845,
  0.0004199067828864372818361167,
  0.0001585661977333399525814706,
  0.00004251412547922882786604648,
  6.119457455343543404961236e-6,
  2.440750888667968390119256e-8,
  2.840146488631817763047861e-7,
  1.735151995398501164612053e-6,
  7.388389141696843668670675e-6,
  0.00002456639389614200519833,
  0.0000677693624721158764091862,
  0.0001609522358712752064718172,
  0.0003372332561112432897504742,
  0.000633933668939885222559786,
  0.001081913461657404113168701,
  0.001690489783839693926826095,
  0.002432167119832603120018571,
  0.003233676738868347330024691,
  0.003979909832453350560030389,
  0.004534254416259352959463193,
  0.004772899385536161009961256,
  0.004623746279738155978399967,
  0.00409577525125594439609132,
  0.003285153066111538734364913,
  0.002351477984164048778282254,
  0.001469673740102530486426409,
  0.000775212522251884212620523,
  0.0003259416286740876803063563,
  0.0000979113192854966944793798,
  0.00001591058938389321285289921,
  6.656593332730822882143424e-9,
  8.48715649923179917473287e-8,
  5.667230307551556223128075e-7,
  2.632113631729500556963928e-6,
  9.53006659764129512004181e-6,
  0.00002859019979292388536012543,
  0.0000737697747743344696329162,
  0.0001678059711899696177364138,
  0.0003423241812275380201822842,
  0.000633933668939885222559786,
  0.001074931003854587986079636,
  0.00167902446056625726751282,
  0.002425257554151260497518518,
  0.003246113957094764050524786,
  0.00402713385654613585215481,
  0.004623746279738155978399967,
  0.004895731355016871035952906,
  0.004751739256339904240777821,
  0.004188570159292211886315264,
  0.003306765915230693594459419,
  0.002289299479775095565394982,
  0.00134450921828061168126372,
  0.000633363846628056742413488,
  0.0002147929566825583735141394,
  0.00003977647345973303213224803,
  1.664148333182705720535856e-9,
  2.319071225596544746037064e-8,
  1.689056875976150090030328e-7,
  8.542356614132253328889016e-7,
  3.36355291681457474825005e-6,
  0.00001096269098813639177207424,
  0.00003070958949881796925895155,
  0.0000758088152199392155420975,
  0.0001678059711899696177364138,
  0.0003372332561112432897504742,
  0.000620815766932061510677009,
  0.001053505543884710442360985,
  0.001654881625185565986542048,
  0.002411973218893942328563309,
  0.003263820903344580690635271,
  0.00409577525125594439609132,
  0.004751739256339904240777821,
  0.005068521873429231190163009,
  0.00492772959916730810154737,
  0.004309269608988415181919967,
  0.003321728656928570036063308,
  0.002185726215814470326760272,
  0.001162408942046786491958872,
  0.0004492401708393377746700954,
  0.00009593149481465025396601,
  3.757754300735141949597094e-10,
  5.711786537117415763387583e-9,
  4.530037598403467674410842e-8,
  2.491520679121907220925963e-7,
  1.065817179402149200062773e-6,
  3.77135309634606640022212e-6,
  0.00001146491341289204185667525,
  0.00003070958949881796925895155,
  0.0000737697747743344696329162,
  0.0001609522358712752064718172,
  0.0003219044717425504129436344,
  0.000594060070579433943886889,
  0.001016155383885873851385468,
  0.001615426507716004584253821,
  0.002389202229899300897719937,
  0.003285153066111538734364913,
  0.004188570159292211886315264,
  0.00492772959916730810154737,
  0.005306785722180177955512552,
  0.00516713346633333116720959,
  0.004462524357287876917135555,
  0.003315018093985279995586412,
  0.002009101875142593936719038,
  0.000895360618270069037016093,
  0.0002238401545675172592540232,
  7.51550860147028389919419e-11,
  1.243946251277840093659728e-9,
  1.072903641727137080781515e-8,
  6.41093040241894255676856e-8,
  2.977384023431105052806937e-7,
  1.143315464997544340277864e-6,
  3.77135309634606640022212e-6,
  0.00001096269098813639177207424,
  0.00002859019979292388536012543,
  0.0000677693624721158764091862,
  0.00014739836337685203118998,
  0.0002962072374080280052621607,
  0.000552645910534422620928939,
  0.000960253527806417585686482,
  0.001556125136579149926804433,
  0.002351477984164048778282254,
  0.003306765915230693594459419,
  0.004309269608988415181919967,
  0.00516713346633333116720959,
  0.00563687287236363400059228,
  0.005495951050554543150577473,
  0.00465265697401442806398093,
  0.003251572771612355976532127,
  0.001696472750406446596451544,
  0.000506585612968591691995947,
  1.29577734508108343089555e-11,
  2.33239922114595017561199e-10,
  2.185544455370094053443827e-9,
  1.41780191591957383466997e-8,
  7.14572165623465212673665e-8,
  2.977384023431105052806937e-7,
  1.065817179402149200062773e-6,
  3.36355291681457474825005e-6,
  9.53006659764129512004181e-6,
  0.00002456639389614200519833,
  0.00005818356449086264389078157,
  0.0001275336716617898355989859,
  0.0002600686637809047627900888,
  0.000495130725275184067619592,
  0.000881804244061518291855845,
  0.001469673740102530486426409,
  0.002289299479775095565394982,
  0.003321728656928570036063308,
  0.004462524357287876917135555,
  0.005495951050554543150577473,
  0.00610661227839393683397497,
  0.005961216747955985956975566,
  0.00487735915741853396479819,
  0.003039513677811550151975684,
  0.001114488348530901722391084,
  1.851110492972976329850785e-12,
  3.619949408480487045041536e-11,
  3.68260237901188009005187e-10,
  2.592552074824363583396517e-9,
  1.41780191591957383466997e-8,
  6.41093040241894255676856e-8,
  2.491520679121907220925963e-7,
  8.542356614132253328889016e-7,
  2.632113631729500556963928e-6,
  7.388389141696843668670675e-6,
  0.00001908667194938351281073258,
  0.00004572635846697226598507056,
  0.000102169832199641156810392,
  0.0002137707258330953434802049,
  0.0004199067828864372818361167,
  0.000775212522251884212620523,
  0.00134450921828061168126372,
  0.002185726215814470326760272,
  0.003315018093985279995586412,
  0.00465265697401442806398093,
  0.005961216747955985956975566,
  0.006812819140521126807972076,
  0.006657982341872919380518165,
  0.005094803878998407873787813,
  0.002388189318280503690838037,
  2.056789436636640366500873e-13,
  4.366722188551636470417237e-12,
  4.82086129616100666334063e-11,
  3.68260237901188009005187e-10,
  2.185544455370094053443827e-9,
  1.072903641727137080781515e-8,
  4.530037598403467674410842e-8,
  1.689056875976150090030328e-7,
  5.667230307551556223128075e-7,
  1.735151995398501164612053e-6,
  4.89925269288988564125756e-6,
  0.0000128605383188359498083011,
  0.00003157976631625272119593936,
  0.0000728763838067370489137062,
  0.0001585661977333399525814706,
  0.0003259416286740876803063563,
  0.000633363846628056742413488,
  0.001162408942046786491958872,
  0.002009101875142593936719038,
  0.003251572771612355976532127,
  0.00487735915741853396479819,
  0.006657982341872919380518165,
  0.0079895788102475032566218,
  0.00781589231437255753365176,
  0.004993486756404689535388624,
  1.582145720489723358846825e-14,
  3.645263740008322618783085e-13,
  4.366722188551636470417237e-12,
  3.619949408480487045041536e-11,
  2.33239922114595017561199e-10,
  1.243946251277840093659728e-9,
  5.711786537117415763387583e-9,
  2.319071225596544746037064e-8,
  8.48715649923179917473287e-8,
  2.840146488631817763047861e-7,
  8.78670319920468620442932e-7,
  2.534830741103897353520216e-6,
  6.865166590489721999117251e-6,
  0.00001754882820764236629360149,
  0.00004251412547922882786604648,
  0.0000979113192854966944793798,
  0.0002147929566825583735141394,
  0.0004492401708393377746700954,
  0.000895360618270069037016093,
  0.001696472750406446596451544,
  0.003039513677811550151975684,
  0.005094803878998407873787813,
  0.00781589231437255753365176,
  0.01042118975249674337820234,
  0.0102040816326530612244898,
  6.3285828819588934353873e-16,
  1.582145720489723358846825e-14,
  2.056789436636640366500873e-13,
  1.851110492972976329850785e-12,
  1.29577734508108343089555e-11,
  7.51550860147028389919419e-11,
  3.757754300735141949597094e-10,
  1.664148333182705720535856e-9,
  6.656593332730822882143424e-9,
  2.440750888667968390119256e-8,
  8.29855302147109252640547e-8,
  2.640448688649893076583558e-7,
  7.921346065949679229750675e-7,
  2.254536957231831780775192e-6,
  6.119457455343543404961236e-6,
  0.00001591058938389321285289921,
  0.00003977647345973303213224803,
  0.00009593149481465025396601,
  0.0002238401545675172592540232,
  0.000506585612968591691995947,
  0.001114488348530901722391084,
  0.002388189318280503690838037,
  0.004993486756404689535388624,
  0.0102040816326530612244898,
  0.02040816326530612244897959,

  0.01960784313725490196078431,
  0.00980392156862745098039216,
  0.004801920768307322929171669,
  0.002300920368147258903561425,
  0.00107702655530297225273088,
  0.000491686036116574289290184,
  0.000218527127162921906351193,
  0.0000943639867294435504698333,
  0.00003950120374720892810365116,
  0.00001598858246910837566100166,
  6.23944681721302464819577e-6,
  2.339792556454884243073414e-6,
  8.399255330863687026417382e-7,
  2.873429455295471877458578e-7,
  9.31923066582315203500079e-8,
  2.847542703445963121805798e-8,
  8.13583629555989463373085e-9,
  2.153603725295266226575814e-9,
  5.220857515867312064426215e-10,
  1.142062581595974514093235e-10,
  2.210443706314789382115938e-11,
  3.684072843857982303526563e-12,
  5.081479784631699729002156e-13,
  5.44444262639110685250231e-14,
  4.032920463993412483335044e-15,
  1.551123255382081724359632e-16,
  0.00980392156862745098039216,
  0.01000400160064025610244098,
  0.007503001200480192076830732,
  0.00489557525137714660332218,
  0.002926702595931989817203477,
  0.001638953453721914297633947,
  0.000869141983034348491169517,
  0.0004389022638578769789294573,
  0.0002116135915029049719838455,
  0.0000974913565189535101280589,
  0.00004289619686833954445634592,
  0.0000179984042804221864851801,
  7.183573638238679693646445e-6,
  2.718108944198419343541898e-6,
  9.70753194356578336979249e-7,
  3.254334518223957853492341e-7,
  1.016979536944986829216356e-7,
  2.936732352675363036239746e-8,
  7.74971037511554134563266e-9,
  1.842036421928991151763282e-9,
  3.868276486050881418702891e-10,
  6.98703470386858712737796e-11,
  1.043518170058295480062943e-11,
  1.209876139198023745000513e-12,
  9.6945203461380107772477e-14,
  4.032920463993412483335044e-15,
  0.004801920768307322929171669,
  0.007503001200480192076830732,
  0.007662639523894664248678195,
  0.006385532936578886873898496,
  0.004682724153491183707525563,
  0.003128911138923654568210263,
  0.001940410008634824538424969,
  0.001128605821348826517247176,
  0.000619356853179234064342962,
  0.0003217214765125465834225944,
  0.0001583859576677152410695849,
  0.000073888185993312133991792,
  0.00003261730733038103212250278,
  0.00001359054472099209671770949,
  5.325274666184658305714739e-6,
  1.952600710934374712095404e-6,
  6.656593332730822882143424e-7,
  2.092421801281196163320819e-7,
  5.99977577428299975145755e-8,
  1.547310594420352567481156e-8,
  3.521465490749767912198494e-9,
  6.887219922384750168415422e-10,
  1.113086048062181845400472e-10,
  1.396010929843873551923669e-11,
  1.209876139198023745000513e-12,
  5.44444262639110685250231e-14,
  0.002300920368147258903561425,
  0.00489557525137714660332218,
  0.006385532936578886873898496,
  0.006527433668502862137762907,
  0.005711504459940004370542543,
  0.004462943019860096438377429,
  0.003187816442757211741698164,
  0.002110401129351464219242687,
  0.001305810698786218485656412,
  0.000758932713824468863458428,
  0.0004154158012512882199982973,
  0.0002143423053139324968050183,
  0.0001041941761942727415024394,
  0.00004763162340309611040111517,
  0.0000204135528870411901719065,
  8.1654211548164760687626e-6,
  3.030136756670176666142371e-6,
  1.034961321063817457126427e-6,
  3.219879665531876533282216e-7,
  8.99930069858274022006282e-8,
  2.217684815007889554229766e-8,
  4.693512835995533448105325e-9,
  8.205442020971212321862456e-10,
  1.113086048062181845400472e-10,
  1.043518170058295480062943e-11,
  5.081479784631699729002156e-13,
  0.00107702655530297225273088,
  0.002926702595931989817203477,
  0.004682724153491183707525563,
  0.005711504459940004370542543,
  0.0058443301450548881931133,
  0.00525989713054939937380197,
  0.004276339130527966970570707,
  0.003191981708144089631604564,
  0.002209833490253600514187775,
  0.001427991816801303256244147,
  0.00086451396476619440378024,
  0.0004912011163444286385115,
  0.0002619739287170286072061334,
  0.0001309869643585143036030667,
  0.0000612406586611235705157195,
  0.00002666520345869755466205287,
  0.00001075209816882965913792454,
  3.984601086095697209936742e-6,
  1.343467032859851932852235e-6,
  4.065755494181130849421237e-7,
  1.08420146511496822651233e-7,
  2.482146211343791727363393e-8,
  4.693512835995533448105325e-9,
  6.887219922384750168415422e-10,
  6.98703470386858712737796e-11,
  3.684072843857982303526563e-12,
  0.000491686036116574289290184,
  0.001638953453721914297633947,
  0.003128911138923654568210263,
  0.004462943019860096438377429,
  0.00525989713054939937380197,
  0.005388187304465238382919091,
  0.004939171695759801851009167,
  0.004125022515140054293150513,
  0.00317518180441701547564875,
  0.002269349157511260309923131,
  0.001512899438340840206615421,
  0.00094310614338130298594208,
  0.00055014525030576007513288,
  0.0003000792274395054955270256,
  0.0001527188925361769039735755,
  0.0000722540996945353094068529,
  0.00003161116861635919786549816,
  0.00001269576346052560076545362,
  4.634961263366489168340211e-6,
  1.517882051160955517117262e-6,
  4.378505916810448607069025e-7,
  1.08420146511496822651233e-7,
  2.217684815007889554229766e-8,
  3.521465490749767912198494e-9,
  3.868276486050881418702891e-10,
  2.210443706314789382115938e-11,
  0.000218527127162921906351193,
  0.000869141983034348491169517,
  0.001940410008634824538424969,
  0.003187816442757211741698164,
  0.004276339130527966970570707,
  0.004939171695759801851009167,
  0.005065817123856207026676069,
  0.004703973043580763667627778,
  0.004004733807372812311629054,
  0.003151873829876750430448793,
  0.002305370572709851743413974,
  0.001571843572302171643236801,
  0.001000264091465018318423419,
  0.000593906804307354626563905,
  0.000328427725884251406394786,
  0.0001685928992872490552826568,
  0.000079936288455161190004708,
  0.00003476220947524866876255158,
  0.00001373321855812293086915618,
  4.86500657423383178563225e-6,
  1.517882051160955517117262e-6,
  4.065755494181130849421237e-7,
  8.99930069858274022006282e-8,
  1.547310594420352567481156e-8,
  1.842036421928991151763282e-9,
  1.142062581595974514093235e-10,
  0.0000943639867294435504698333,
  0.0004389022638578769789294573,
  0.001128605821348826517247176,
  0.002110401129351464219242687,
  0.003191981708144089631604564,
  0.004125022515140054293150513,
  0.004703973043580763667627778,
  0.004831107450164027550536637,
  0.004529163234528775828628097,
  0.00391089650727564135043442,
  0.003128717205820513080347536,
  0.002327145029122695679597341,
  0.001612032754548533986387741,
  0.001040021131966796120250156,
  0.000624012679180077672150093,
  0.0003471518812909857394490175,
  0.000178225296198497143020701,
  0.0000838707276228221849509181,
  0.00003584219129180435254312739,
  0.00001373321855812293086915618,
  4.634961263366489168340211e-6,
  1.343467032859851932852235e-6,
  3.219879665531876533282216e-7,
  5.99977577428299975145755e-8,
  7.74971037511554134563266e-9,
  5.220857515867312064426215e-10,
  0.00003950120374720892810365116,
  0.0002116135915029049719838455,
  0.000619356853179234064342962,
  0.001305810698786218485656412,
  0.002209833490253600514187775,
  0.00317518180441701547564875,
  0.004004733807372812311629054,
  0.004529163234528775828628097,
  0.004658567898372455138017471,
  0.004399758570685096519238723,
  0.003839789298052447871335613,
  0.003108920312343601259462073,
  0.002340047546925291270562851,
  0.001638033282847703889393995,
  0.001065125090324615336945849,
  0.000641611066314589714874523,
  0.0003564505923969942860414019,
  0.0001814510934147595347495824,
  0.0000838707276228221849509181,
  0.00003476220947524866876255158,
  0.00001269576346052560076545362,
  3.984601086095697209936742e-6,
  1.034961321063817457126427e-6,
  2.092421801281196163320819e-7,
  2.936732352675363036239746e-8,
  2.153603725295266226575814e-9,
  0.00001598858246910837566100166,
  0.0000974913565189535101280589,
  0.0003217214765125465834225944,
  0.000758932713824468863458428,
  0.001427991816801303256244147,
  0.002269349157511260309923131,
  0.003151873829876750430448793,
  0.00391089650727564135043442,
  0.004399758570685096519238723,
  0.004533084587978584292548987,
  0.004306430358579655077921538,
  0.003788648409307614438054139,
  0.003094062867601218457744213,
  0.002347220106456096761047334,
  0.001652634564749700780737409,
  0.001077272901466471620036237,
  0.000647399580208216117810239,
  0.0003564505923969942860414019,
  0.000178225296198497143020701,
  0.000079936288455161190004708,
  0.00003161116861635919786549816,
  0.00001075209816882965913792454,
  3.030136756670176666142371e-6,
  6.656593332730822882143424e-7,
  1.016979536944986829216356e-7,
  8.13583629555989463373085e-9,
  6.23944681721302464819577e-6,
  0.00004289619686833954445634592,
  0.0001583859576677152410695849,
  0.0004154158012512882199982973,
  0.00086451396476619440378024,
  0.001512899438340840206615421,
  0.002305370572709851743413974,
  0.003128717205820513080347536,
  0.003839789298052447871335613,
  0.004306430358579655077921538,
  0.004445347466920934273983523,
  0.004243286218424528170620636,
  0.003755552170329754817675735,
  0.003084917854199441457376497,
  0.002350413603199574443715426,
  0.001657342925333033261594211,
  0.001077272901466471620036237,
  0.000641611066314589714874523,
  0.0003471518812909857394490175,
  0.0001685928992872490552826568,
  0.0000722540996945353094068529,
  0.00002666520345869755466205287,
  8.1654211548164760687626e-6,
  1.952600710934374712095404e-6,
  3.254334518223957853492341e-7,
  2.847542703445963121805798e-8,
  2.339792556454884243073414e-6,
  0.0000179984042804221864851801,
  0.000073888185993312133991792,
  0.0002143423053139324968050183,
  0.0004912011163444286385115,
  0.00094310614338130298594208,
  0.001571843572302171643236801,
  0.002327145029122695679597341,
  0.003108920312343601259462073,
  0.003788648409307614438054139,
  0.004243286218424528170620636,
  0.004389606432852960176504106,
  0.004206706164817420169149768,
  0.003739294368726595705910905,
  0.003081836018181260197179317,
  0.002350413603199574443715426,
  0.001652634564749700780737409,
  0.001065125090324615336945849,
  0.000624012679180077672150093,
  0.000328427725884251406394786,
  0.0001527188925361769039735755,
  0.0000612406586611235705157195,
  0.0000204135528870411901719065,
  5.325274666184658305714739e-6,
  9.70753194356578336979249e-7,
  9.31923066582315203500079e-8,
  8.399255330863687026417382e-7,
  7.183573638238679693646445e-6,
  0.00003261730733038103212250278,
  0.0001041941761942727415024394,
  0.0002619739287170286072061334,
  0.00055014525030576007513288,
  0.001000264091465018318423419,
  0.001612032754548533986387741,
  0.002340047546925291270562851,
  0.003094062867601218457744213,
  0.003755552170329754817675735,
  0.004206706164817420169149768,
  0.004362510096847694990229389,
  0.004194721246968937490605182,
  0.003739294368726595705910905,
  0.003084917854199441457376497,
  0.002347220106456096761047334,
  0.001638033282847703889393995,
  0.001040021131966796120250156,
  0.000593906804307354626563905,
  0.0003000792274395054955270256,
  0.0001309869643585143036030667,
  0.00004763162340309611040111517,
  0.00001359054472099209671770949,
  2.718108944198419343541898e-6,
  2.873429455295471877458578e-7,
  2.873429455295471877458578e-7,
  2.718108944198419343541898e-6,
  0.00001359054472099209671770949,
  0.00004763162340309611040111517,
  0.0001309869643585143036030667,
  0.0003000792274395054955270256,
  0.000593906804307354626563905,
  0.001040021131966796120250156,
  0.001638033282847703889393995,
  0.002347220106456096761047334,
  0.003084917854199441457376497,
  0.003739294368726595705910905,
  0.004194721246968937490605182,
  0.004362510096847694990229389,
  0.004206706164817420169149768,
  0.003755552170329754817675735,
  0.003094062867601218457744213,
  0.002340047546925291270562851,
  0.001612032754548533986387741,
  0.001000264091465018318423419,
  0.00055014525030576007513288,
  0.0002619739287170286072061334,
  0.0001041941761942727415024394,
  0.00003261730733038103212250278,
  7.183573638238679693646445e-6,
  8.399255330863687026417382e-7,
  9.31923066582315203500079e-8,
  9.70753194356578336979249e-7,
  5.325274666184658305714739e-6,
  0.0000204135528870411901719065,
  0.0000612406586611235705157195,
  0.0001527188925361769039735755,
  0.000328427725884251406394786,
  0.000624012679180077672150093,
  0.001065125090324615336945849,
  0.001652634564749700780737409,
  0.002350413603199574443715426,
  0.003081836018181260197179317,
  0.003739294368726595705910905,
  0.004206706164817420169149768,
  0.004389606432852960176504106,
  0.004243286218424528170620636,
  0.003788648409307614438054139,
  0.003108920312343601259462073,
  0.002327145029122695679597341,
  0.001571843572302171643236801,
  0.00094310614338130298594208,
  0.0004912011163444286385115,
  0.0002143423053139324968050183,
  0.000073888185993312133991792,
  0.0000179984042804221864851801,
  2.339792556454884243073414e-6,
  2.847542703445963121805798e-8,
  3.254334518223957853492341e-7,
  1.952600710934374712095404e-6,
  8.1654211548164760687626e-6,
  0.00002666520345869755466205287,
  0.0000722540996945353094068529,
  0.0001685928992872490552826568,
  0.0003471518812909857394490175,
  0.000641611066314589714874523,
  0.001077272901466471620036237,
  0.001657342925333033261594211,
  0.002350413603199574443715426,
  0.003084917854199441457376497,
  0.003755552170329754817675735,
  0.004243286218424528170620636,
  0.004445347466920934273983523,
  0.004306430358579655077921538,
  0.003839789298052447871335613,
  0.003128717205820513080347536,
  0.002305370572709851743413974,
  0.001512899438340840206615421,
  0.00086451396476619440378024,
  0.0004154158012512882199982973,
  0.0001583859576677152410695849,
  0.00004289619686833954445634592,
  6.23944681721302464819577e-6,
  8.13583629555989463373085e-9,
  1.016979536944986829216356e-7,
  6.656593332730822882143424e-7,
  3.030136756670176666142371e-6,
  0.00001075209816882965913792454,
  0.00003161116861635919786549816,
  0.000079936288455161190004708,
  0.000178225296198497143020701,
  0.0003564505923969942860414019,
  0.000647399580208216117810239,
  0.001077272901466471620036237,
  0.001652634564749700780737409,
  0.002347220106456096761047334,
  0.003094062867601218457744213,
  0.003788648409307614438054139,
  0.004306430358579655077921538,
  0.004533084587978584292548987,
  0.004399758570685096519238723,
  0.00391089650727564135043442,
  0.003151873829876750430448793,
  0.002269349157511260309923131,
  0.001427991816801303256244147,
  0.000758932713824468863458428,
  0.0003217214765125465834225944,
  0.0000974913565189535101280589,
  0.00001598858246910837566100166,
  2.153603725295266226575814e-9,
  2.936732352675363036239746e-8,
  2.092421801281196163320819e-7,
  1.034961321063817457126427e-6,
  3.984601086095697209936742e-6,
  0.00001269576346052560076545362,
  0.00003476220947524866876255158,
  0.0000838707276228221849509181,
  0.0001814510934147595347495824,
  0.0003564505923969942860414019,
  0.000641611066314589714874523,
  0.001065125090324615336945849,
  0.001638033282847703889393995,
  0.002340047546925291270562851,
  0.003108920312343601259462073,
  0.003839789298052447871335613,
  0.004399758570685096519238723,
  0.004658567898372455138017471,
  0.004529163234528775828628097,
  0.004004733807372812311629054,
  0.00317518180441701547564875,
  0.002209833490253600514187775,
  0.001305810698786218485656412,
  0.000619356853179234064342962,
  0.0002116135915029049719838455,
  0.00003950120374720892810365116,
  5.220857515867312064426215e-10,
  7.74971037511554134563266e-9,
  5.99977577428299975145755e-8,
  3.219879665531876533282216e-7,
  1.343467032859851932852235e-6,
  4.634961263366489168340211e-6,
  0.00001373321855812293086915618,
  0.00003584219129180435254312739,
  0.0000838707276228221849509181,
  0.000178225296198497143020701,
  0.0003471518812909857394490175,
  0.000624012679180077672150093,
  0.001040021131966796120250156,
  0.001612032754548533986387741,
  0.002327145029122695679597341,
  0.003128717205820513080347536,
  0.00391089650727564135043442,
  0.004529163234528775828628097,
  0.004831107450164027550536637,
  0.004703973043580763667627778,
  0.004125022515140054293150513,
  0.003191981708144089631604564,
  0.002110401129351464219242687,
  0.001128605821348826517247176,
  0.0004389022638578769789294573,
  0.0000943639867294435504698333,
  1.142062581595974514093235e-10,
  1.842036421928991151763282e-9,
  1.547310594420352567481156e-8,
  8.99930069858274022006282e-8,
  4.065755494181130849421237e-7,
  1.517882051160955517117262e-6,
  4.86500657423383178563225e-6,
  0.00001373321855812293086915618,
  0.00003476220947524866876255158,
  0.000079936288455161190004708,
  0.0001685928992872490552826568,
  0.000328427725884251406394786,
  0.000593906804307354626563905,
  0.001000264091465018318423419,
  0.001571843572302171643236801,
  0.002305370572709851743413974,
  0.003151873829876750430448793,
  0.004004733807372812311629054,
  0.004703973043580763667627778,
  0.005065817123856207026676069,
  0.004939171695759801851009167,
  0.004276339130527966970570707,
  0.003187816442757211741698164,
  0.001940410008634824538424969,
  0.000869141983034348491169517,
  0.000218527127162921906351193,
  2.210443706314789382115938e-11,
  3.868276486050881418702891e-10,
  3.521465490749767912198494e-9,
  2.217684815007889554229766e-8,
  1.08420146511496822651233e-7,
  4.378505916810448607069025e-7,
  1.517882051160955517117262e-6,
  4.634961263366489168340211e-6,
  0.00001269576346052560076545362,
  0.00003161116861635919786549816,
  0.0000722540996945353094068529,
  0.0001527188925361769039735755,
  0.0003000792274395054955270256,
  0.00055014525030576007513288,
  0.00094310614338130298594208,
  0.001512899438340840206615421,
  0.002269349157511260309923131,
  0.00317518180441701547564875,
  0.004125022515140054293150513,
  0.004939171695759801851009167,
  0.005388187304465238382919091,
  0.00525989713054939937380197,
  0.004462943019860096438377429,
  0.003128911138923654568210263,
  0.001638953453721914297633947,
  0.000491686036116574289290184,
  3.684072843857982303526563e-12,
  6.98703470386858712737796e-11,
  6.887219922384750168415422e-10,
  4.693512835995533448105325e-9,
  2.482146211343791727363393e-8,
  1.08420146511496822651233e-7,
  4.065755494181130849421237e-7,
  1.343467032859851932852235e-6,
  3.984601086095697209936742e-6,
  0.00001075209816882965913792454,
  0.00002666520345869755466205287,
  0.0000612406586611235705157195,
  0.0001309869643585143036030667,
  0.0002619739287170286072061334,
  0.0004912011163444286385115,
  0.00086451396476619440378024,
  0.001427991816801303256244147,
  0.002209833490253600514187775,
  0.003191981708144089631604564,
  0.004276339130527966970570707,
  0.00525989713054939937380197,
  0.0058443301450548881931133,
  0.005711504459940004370542543,
  0.004682724153491183707525563,
  0.002926702595931989817203477,
  0.00107702655530297225273088,
  5.081479784631699729002156e-13,
  1.043518170058295480062943e-11,
  1.113086048062181845400472e-10,
  8.205442020971212321862456e-10,
  4.693512835995533448105325e-9,
  2.217684815007889554229766e-8,
  8.99930069858274022006282e-8,
  3.219879665531876533282216e-7,
  1.034961321063817457126427e-6,
  3.030136756670176666142371e-6,
  8.1654211548164760687626e-6,
  0.0000204135528870411901719065,
  0.00004763162340309611040111517,
  0.0001041941761942727415024394,
  0.0002143423053139324968050183,
  0.0004154158012512882199982973,
  0.000758932713824468863458428,
  0.001305810698786218485656412,
  0.002110401129351464219242687,
  0.003187816442757211741698164,
  0.004462943019860096438377429,
  0.005711504459940004370542543,
  0.006527433668502862137762907,
  0.006385532936578886873898496,
  0.00489557525137714660332218,
  0.002300920368147258903561425,
  5.44444262639110685250231e-14,
  1.209876139198023745000513e-12,
  1.396010929843873551923669e-11,
  1.113086048062181845400472e-10,
  6.887219922384750168415422e-10,
  3.521465490749767912198494e-9,
  1.547310594420352567481156e-8,
  5.99977577428299975145755e-8,
  2.092421801281196163320819e-7,
  6.656593332730822882143424e-7,
  1.952600710934374712095404e-6,
  5.325274666184658305714739e-6,
  0.00001359054472099209671770949,
  0.00003261730733038103212250278,
  0.000073888185993312133991792,
  0.0001583859576677152410695849,
  0.0003217214765125465834225944,
  0.000619356853179234064342962,
  0.001128605821348826517247176,
  0.001940410008634824538424969,
  0.003128911138923654568210263,
  0.004682724153491183707525563,
  0.006385532936578886873898496,
  0.007662639523894664248678195,
  0.007503001200480192076830732,
  0.004801920768307322929171669,
  4.032920463993412483335044e-15,
  9.6945203461380107772477e-14,
  1.209876139198023745000513e-12,
  1.043518170058295480062943e-11,
  6.98703470386858712737796e-11,
  3.868276486050881418702891e-10,
  1.842036421928991151763282e-9,
  7.74971037511554134563266e-9,
  2.936732352675363036239746e-8,
  1.016979536944986829216356e-7,
  3.254334518223957853492341e-7,
  9.70753194356578336979249e-7,
  2.718108944198419343541898e-6,
  7.183573638238679693646445e-6,
  0.0000179984042804221864851801,
  0.00004289619686833954445634592,
  0.0000974913565189535101280589,
  0.0002116135915029049719838455,
  0.0004389022638578769789294573,
  0.000869141983034348491169517,
  0.001638953453721914297633947,
  0.002926702595931989817203477,
  0.00489557525137714660332218,
  0.007503001200480192076830732,
  0.01000400160064025610244098,
  0.00980392156862745098039216,
  1.551123255382081724359632e-16,
  4.032920463993412483335044e-15,
  5.44444262639110685250231e-14,
  5.081479784631699729002156e-13,
  3.684072843857982303526563e-12,
  2.210443706314789382115938e-11,
  1.142062581595974514093235e-10,
  5.220857515867312064426215e-10,
  2.153603725295266226575814e-9,
  8.13583629555989463373085e-9,
  2.847542703445963121805798e-8,
  9.31923066582315203500079e-8,
  2.873429455295471877458578e-7,
  8.399255330863687026417382e-7,
  2.339792556454884243073414e-6,
  6.23944681721302464819577e-6,
  0.00001598858246910837566100166,
  0.00003950120374720892810365116,
  0.0000943639867294435504698333,
  0.000218527127162921906351193,
  0.000491686036116574289290184,
  0.00107702655530297225273088,
  0.002300920368147258903561425,
  0.004801920768307322929171669,
  0.00980392156862745098039216,
  0.01960784313725490196078431

};

void MMatrix(const int classe, math_Matrix& M)
{
  if (classe > 24)
    throw Standard_DimensionError("MMatrix: classe > 24");
  int i, j, k = 0, Som = 0;
  for (i = 2; i < classe; i++)
  {
    Som += (i) * (i);
  }
  for (i = 1; i <= classe; i++)
  {
    for (j = 1; j <= classe; j++)
    {
      M(i + M.LowerRow() - 1, j + M.LowerCol() - 1) = BBMatrix[Som + k];
      k++;
    }
  }
}
