// Created by: Kirill GAVRILOV
// Copyright (c) 2019 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _Media_Scaler_HeaderFile
#define _Media_Scaler_HeaderFile

#include <Media_Frame.hxx>

#include <Standard_Transient.hxx>
#include <Standard_Type.hxx>
#include <NCollection_Vec2.hxx>
#include <Standard_TypeDef.hxx>

struct SwsContext;

//! SwsContext wrapper - tool performing image scaling and pixel format conversion.
class Media_Scaler : public Standard_Transient
{
  DEFINE_STANDARD_RTTIEXT(Media_Scaler, Standard_Transient)
public:
  //! Empty constructor.
  Standard_EXPORT Media_Scaler();

  //! Destructor.
  Standard_EXPORT ~Media_Scaler() override;

  //! sws_freeContext() wrapper.
  Standard_EXPORT void Release();

  //! sws_getContext() wrapper - creates conversion context.
  //! @param theSrcDims   dimensions of input frame
  //! @param theSrcFormat pixel format (AVPixelFormat) of input frame
  //! @param theResDims   dimensions of destination frame
  //! @param theResFormat pixel format (AVPixelFormat) of destination frame
  Standard_EXPORT bool Init(const NCollection_Vec2<int>& theSrcDims,
                            int                          theSrcFormat,
                            const NCollection_Vec2<int>& theResDims,
                            int                          theResFormat);

  //! Convert one frame to another.
  Standard_EXPORT bool Convert(const occ::handle<Media_Frame>& theSrc,
                               const occ::handle<Media_Frame>& theRes);

  //! Return TRUE if context was initialized.
  bool IsValid() const { return mySwsContext != nullptr; }

protected:
  SwsContext*           mySwsContext; //!< conversion context
  NCollection_Vec2<int> mySrcDims;    //!< dimensions of input frame
  int                   mySrcFormat;  //!< pixel format (AVPixelFormat) of input frame
  NCollection_Vec2<int> myResDims;    //!< dimensions of destination frame
  int                   myResFormat;  //!< pixel format (AVPixelFormat) of destination frame
};

#endif // _Media_Scaler_HeaderFile
