// Created on: 1996-12-05
// Created by: Odile Olivier
// Copyright (c) 1996-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _PrsDim_DimensionOwner_HeaderFile
#define _PrsDim_DimensionOwner_HeaderFile

#include <Standard.hxx>

#include <PrsDim_DimensionSelectionMode.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Standard_Integer.hxx>
#include <PrsMgr_PresentationManager.hxx>

class SelectMgr_SelectableObject;
class PrsMgr_PresentationManager;

//! The owner is the entity which makes it possible to link
//! the sensitive primitives and the reference shapes that
//! you want to detect. It stocks the various pieces of
//! information which make it possible to find objects. An
//! owner has a priority which you can modulate, so as to
//! make one entity more selectable than another. You
//! might want to make edges more selectable than
//! faces, for example. In that case, you could attribute sa
//! higher priority to the one compared to the other. An
//! edge, could have priority 5, for example, and a face,
//! priority 4. The default priority is 5.
class PrsDim_DimensionOwner : public SelectMgr_EntityOwner
{
  DEFINE_STANDARD_RTTIEXT(PrsDim_DimensionOwner, SelectMgr_EntityOwner)
public:
  //! Initializes the dimension owner, theSO, and attributes it
  //! the priority, thePriority.
  Standard_EXPORT PrsDim_DimensionOwner(const occ::handle<SelectMgr_SelectableObject>& theSelObject,
                                        const PrsDim_DimensionSelectionMode            theSelMode,
                                        const int thePriority = 0);

  PrsDim_DimensionSelectionMode SelectionMode() const { return mySelectionMode; }

  Standard_EXPORT void HilightWithColor(const occ::handle<PrsMgr_PresentationManager>& thePM,
                                        const occ::handle<Prs3d_Drawer>&               theStyle,
                                        const int theMode) override;

  //! Returns true if an object with the selection mode
  //! aMode is highlighted in the presentation manager aPM.
  Standard_EXPORT bool IsHilighted(const occ::handle<PrsMgr_PresentationManager>& thePM,
                                   const int theMode = 0) const override;

  //! Removes highlighting from the selected part of dimension.
  Standard_EXPORT void Unhilight(const occ::handle<PrsMgr_PresentationManager>& thePM,
                                 const int theMode = 0) override;

private:
  PrsDim_DimensionSelectionMode mySelectionMode;
};

#endif // _AIS_DimensionOwner_HeaderFile
