/*
 *******************************************************************************
 * Copyright (c) 2021, STMicroelectronics
 * All rights reserved.
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 *******************************************************************************
 */
#if defined(ARDUINO_RAK811_TRACKER) || defined(ARDUINO_RAK811_TRACKERA)
#include "pins_arduino.h"

// Pin number
const PinName digitalPin[] = {
  PA_0,  //D0
  PA_8,  //D1
  PA_9,  //D2 - UART_TX
  PA_10, //D3 - UART_RX
  PA_12, //D4 - LED1
  PA_13, //D5
  PA_14, //D6
  PA_15, //D7 - GPS_POWER_ON_PIN
  PB_2,  //D8
  PB_3,  //D9
  PB_4,  //D10 - LED2
  PB_5,  //D11
  PB_8,  //D12 - I2C_SCL
  PB_9,  //D13 - I2C_SDA
  PB_10, //D14 - GPS_UART_TX
  PB_11, //D15 - GPS_UART_RX
  PA_1,  //D16/A0
  PA_2,  //D17/A1 - ADC_VBAT
  PB_12, //D18/A2
  PB_14, //D19 - LIS3DH_INT1_PIN
  PB_15, //D20 - LIS3DH_INT2_PIN
  PB_13, //D21 - RADIO_RESET
  PH_1,  //D22 - RADIO_XTAL_EN
  PA_7,  //D23 - RADIO_MOSI
  PA_6,  //D24 - RADIO_MISO
  PA_5,  //D25 - RADIO_SCLK
  PB_0,  //D26 - RADIO_NSS
  PA_11, //D27 - RADIO_DIO_0
  PB_1,  //D28 - RADIO_DIO_1
  PA_3,  //D29 - RADIO_DIO_2
  PH_0,  //D30 - RADIO_DIO_3
  PC_13, //D31 - RADIO_DIO_4
  PB_6,  //D32 - RADIO_RF_CRX_RX
  PB_7,  //D33 - RADIO_RF_CBT_HF
  PA_4   //D34 - RADIO_RF_CTX_PA
};

// Analog (Ax) pin number array
const uint32_t analogInputPin[] = {
  16, // A0
  17, // A1
  18  // A2
};

// ----------------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

/**
  * @brief  System Clock Configuration
  * @param  None
  * @retval None
  */
WEAK void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct;
  RCC_ClkInitTypeDef RCC_ClkInitStruct;
  RCC_PeriphCLKInitTypeDef PeriphClkInit;

  /* Configure the main internal regulator output voltage */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  /* Initializes the CPU, AHB and APB busses clocks */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI | RCC_OSCILLATORTYPE_LSE;
  RCC_OscInitStruct.LSEState = RCC_LSE_ON;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = 16;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL4;
  RCC_OscInitStruct.PLL.PLLDIV = RCC_PLL_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
    Error_Handler();
  }

  /* Initializes the CPU, AHB and APB busses clocks */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_SYSCLK
                                | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK) {
    Error_Handler();
  }

  PeriphClkInit.PeriphClockSelection = RCC_PERIPHCLK_RTC;
  PeriphClkInit.RTCClockSelection = RCC_RTCCLKSOURCE_LSE;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInit) != HAL_OK) {
    Error_Handler();
  }
}

#ifdef __cplusplus
}
#endif
#endif /* ARDUINO_ */
