/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities;

import ExtraUtilities.ai.DefenderHealAI;
import ExtraUtilities.content.EUAttribute;
import ExtraUtilities.content.EUBlocks;
import ExtraUtilities.content.EUFrom;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.content.EUOverride;
import ExtraUtilities.content.EUStatusEffects;
import ExtraUtilities.content.EUTechTree;
import ExtraUtilities.content.EUUnitTypes;
import ExtraUtilities.content.TDPlanet;
import ExtraUtilities.content.TDSectorPresets;
import ExtraUtilities.graphics.MainRenderer;
import ExtraUtilities.net.EUCall;
import ExtraUtilities.ui.EUI;
import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustry.world.Block;
import mindustry.world.meta.Stat;

public class ExtraUtilitiesMod
extends Mod {
    public static String ModName = "extra-utilities";
    public static boolean hardMod;
    public static boolean onlyPlugIn;
    public static boolean coreResetV7;
    public static boolean coreReset;
    public static boolean overrideUnitArm;
    public static boolean overrideUnitMissile;
    public static String massageRand;
    private static boolean show;
    private static final Mat setMat;
    private static final Mat reMat;
    private static final Vec2 vec2;
    private static final Seq<UnlockableContent> updateLog;
    public static Mods.LoadedMod EU;
    public static EUI eui;

    public static String name(String add) {
        return ModName + "-" + add;
    }

    public static void addToTable(UnlockableContent c, Table t) {
        t.row();
        t.table(log -> {
            log.table(Styles.grayPanel, img -> img.button(bt -> bt.image(c.uiIcon).size(64.0f).pad(5.0f), (Button.ButtonStyle)Styles.cleari, () -> Vars.ui.content.show(c)).left().tooltip("click to show")).pad(10.0f).margin(10.0f).left();
            log.image(Tex.whiteui, Pal.accent).growY().width(3.0f).pad(4.0f).margin(5.0f).left();
            log.table(info -> {
                Label n = (Label)info.add((CharSequence)c.localizedName).wrap().fillX().left().maxWidth((float)Core.graphics.getWidth() / 2.0f).get();
                info.row();
                info.image(Tex.whiteui, Pal.accent).left().width(n.getWidth() * 1.3f).height(3.0f).row();
                info.add((CharSequence)c.description).wrap().fillX().left().width((float)Core.graphics.getWidth() / 2.0f).padTop(10.0f).row();
                info.image(Tex.whiteui, Pal.accent).left().width((float)Core.graphics.getWidth() / 2.0f).height(3.0f).row();
            }).left().pad(6.0f);
        });
    }

    public static String toText(String str) {
        return Core.bundle.format(str, new Object[0]);
    }

    public static void setColorName() {
        Mods.LoadedMod mod = Vars.mods.locateMod(ModName);
        String st = ExtraUtilitiesMod.isAps() ? Core.bundle.get("mod.extra-utilities.displayNameAp") : Core.bundle.get("mod.extra-utilities.displayName");
        StringBuilder fin = new StringBuilder();
        for (int i = 0; i < st.length(); ++i) {
            String s = String.valueOf(st.charAt(i));
            Color c = Tmp.c1.set(EUGet.MIKU).shiftHue((float)(i * (int)(80.0f / (float)st.length())));
            int ci = c.rgb888();
            String ct = Integer.toHexString(ci);
            String fct = "[#" + ct + "]";
            fin.append(fct).append(s);
        }
        mod.meta.displayName = fin + "[gray] - " + massageRand;
        if (Vars.ui != null) {
            ExtraUtilitiesMod.rebuildRandSubTitle(massageRand);
        }
    }

    public static void toShow() {
        BaseDialog dialog = new BaseDialog("ExtraUtilities"){
            private float leave = 300.0f;
            private boolean canClose = false;
            {
                this.update(() -> {
                    this.leave -= Time.delta;
                    if (this.leave < 0.0f && !this.canClose) {
                        this.canClose = true;
                    }
                });
                this.cont.table(top -> {
                    top.add((CharSequence)"ExtraUtilities").row();
                    top.add((CharSequence)ExtraUtilitiesMod.toText("eu-log-attention")).row();
                    top.add((CharSequence)ExtraUtilitiesMod.toText("eu-log-open")).row();
                    top.add((CharSequence)"\u670b\u53cb\u670b\u53cb\uff0c[red]\u770b\u8fd9\u91cc[]").row();
                    top.add((CharSequence)"Extra Utilities\uff0c\u66f4\u591a\u5b9e\u7528\u8bbe\u5907\uff0c\u4f5c\u8005\uff1aguiY\uff0c[red]\u4e2d\u56fd\u4eba[]\u6211\u7684\u670b\u53cb").row();
                    top.add((CharSequence)"bilibili\u627eguiY\u5f52\u67d0\u4eba\uff0cQQ\u7fa4\uff1a613420467").row();
                    top.add((CharSequence)"[blue]\u7b2c\u4e00\u6b21\u6a21\u7ec4\u82f1\u6587\uff1f\u770b\u4e0b\u9762\u64cd\u4f5c").row();
                    top.add((CharSequence)"[green]\u6253\u5f00\u8bbe\u7f6e>\u627e\u5230\u8bed\u8a00>\u8bbe\u7f6e\u6210English>\u9000\u51fa\u91cd\u8fdb>\u6253\u5f00Settings>\u8bbe\u7f6e\u6210\u7b80\u4f53\u4e2d\u6587>\u9000\u51fa\u91cd\u8fdb[]").row();
                    top.image((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("LOGO"))).pad(3.0f).height(70.0f).width(460.0f).row();
                });
                this.cont.row();
                updateLog.clear();
                Block duoIII = Vars.content.block(ExtraUtilitiesMod.name("T3-duo"));
                Block T2scorch = Vars.content.block(ExtraUtilitiesMod.name("T2scorch"));
                updateLog.addAll((Object[])new UnlockableContent[]{TDPlanet.supEX, TDSectorPresets.groundZEx, TDSectorPresets.relicValley, EUBlocks.penitent, duoIII, EUBlocks.onyxBlaster, EUBlocks.antiaircraft, Blocks.foreshadow, EUBlocks.guiY});
                ScrollPane p = (ScrollPane)this.cont.pane(t -> {
                    t.table(log -> {
                        log.image(Tex.whiteui, Pal.accent).left().growX().height(3.0f).row();
                        log.table(main -> {
                            main.table(title -> title.add((CharSequence)Core.bundle.format("extra-utilities.update-log", new Object[]{ExtraUtilitiesMod.EU.meta.version})).left()).left().padTop(4.0f);
                            main.row();
                            main.table(info -> {
                                int i = 0;
                                while (i < updateLog.size) {
                                    UnlockableContent content = (UnlockableContent)updateLog.get(i);
                                    info.table(img -> img.add((Element)EUGet.selfStyleImageButton((Drawable)new TextureRegionDrawable(content.uiIcon), Styles.emptyi, () -> Vars.ui.content.show(content))).size(40.0f).pad(10.0f).left().scaling(Scaling.fit)).left().pad(4.0f);
                                    info.image(Tex.whiteui, Pal.accent).growY().width(3.0f).pad(4.0f).margin(5.0f).left();
                                    int finalI = i++;
                                    info.table(c -> {
                                        c.add((CharSequence)content.localizedName).left();
                                        c.row();
                                        c.add((CharSequence)Core.bundle.get("extra-utilities.update-log-" + finalI)).wrap().fillX().left().width((float)Core.graphics.getWidth() / 2.0f).padTop(10.0f).row();
                                        if (finalI != updateLog.size - 1) {
                                            c.image(Tex.whiteui, Pal.accent).left().growX().height(3.0f).row();
                                        }
                                    }).left();
                                    info.row();
                                }
                            }).pad(4.0f);
                            main.image(Tex.whiteui, Pal.accent).growY().width(3.0f).pad(4.0f).margin(5.0f).left();
                        }).left().pad(6.0f);
                        log.row();
                        log.image(Tex.whiteui, Pal.accent).left().growX().height(3.0f).row();
                    });
                    ExtraUtilitiesMod.addToTable((UnlockableContent)TDPlanet.supEX, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)TDSectorPresets.groundZEx, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)TDSectorPresets.relicValley, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)EUBlocks.penitent, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)EUStatusEffects.breakage, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)EUBlocks.rust, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)EUBlocks.ekLiquidDriver, t);
                    ExtraUtilitiesMod.addToTable((UnlockableContent)EUBlocks.guiY, t);
                }).grow().center().maxWidth((float)Core.graphics.getWidth() / 1.1f).get();
                this.buttons.check(ExtraUtilitiesMod.toText("eu-log-not-show-next"), !Core.settings.getBool("eu-first-load"), b -> Core.settings.put("eu-first-load", (Object)(!b ? 1 : 0))).center();
                this.buttons.button("", () -> (this).hide()).update(b -> {
                    b.setDisabled(!this.canClose);
                    b.setText(this.canClose ? ExtraUtilitiesMod.toText("eu-log-understand") : ExtraUtilitiesMod.toText("eu-log-pls-read") + "[accent]" + Math.floor(this.leave / 60.0f) + "[]s");
                }).size(140.0f, 50.0f).center();
            }
        };
        dialog.show();
    }

    public static void log() {
        if (show || onlyPlugIn) {
            return;
        }
        show = true;
        if (Core.settings.getBool("eu-first-load")) {
            ExtraUtilitiesMod.toShow();
        }
        Core.settings.getBoolOnce("eu-open-hard", () -> {
            BaseDialog dialog = new BaseDialog("Hard Mode!");
            dialog.cont.add((CharSequence)ExtraUtilitiesMod.toText("eu-hard-mode-open"));
            dialog.buttons.button("OK", () -> ((BaseDialog)dialog).hide()).size(140.0f, 50.0f).center();
            dialog.show();
        });
    }

    public static void log2() {
        BaseDialog dialog = new BaseDialog("ExtraUtilities"){
            private int con = 0;
            private float bx;
            private float by;
            {
                this.cont.add((CharSequence)Core.bundle.get("eu.ap.main"));
                this.buttons.button("", this::hide).update(b -> {
                    b.setText(this.con > 0 ? (this.con == 5 ? Core.bundle.get("eu.ap.happy") : Core.bundle.get("eu.ap.click")) : Core.bundle.get("eu.ap.ok"));
                    if (this.con > 0) {
                        b.x = this.bx;
                        b.y = this.by;
                    }
                }).size(140.0f, 50.0f).center();
            }

            public void hide() {
                if (this.con >= 5) {
                    super.hide();
                    return;
                }
                ++this.con;
                this.bx = Mathf.random((float)(this.width * 0.8f));
                this.by = Mathf.random((float)(this.height * 0.8f));
            }
        };
        dialog.show();
    }

    public static void afterEnterLoad() {
        EUUnitTypes.suzerain.immunities.addAll(Vars.content.statusEffects().copy().removeAll(s -> !EUUnitTypes.suzerain.immunities.contains(s) && s.reloadMultiplier >= 1.0f && !s.disarm));
        EUUnitTypes.Tera.immunities.addAll(Vars.content.statusEffects().copy().removeAll(s -> (s == StatusEffects.none || s.healthMultiplier > 1.0f || s.damage < 0.0f || s.reloadMultiplier > 1.0f || s.damageMultiplier > 1.0f || s.speedMultiplier > 1.0f) && !s.disarm));
        EUUnitTypes.nihilo.immunities.addAll(Vars.content.statusEffects().copy().removeAll(s -> s.reloadMultiplier >= 1.0f && !s.disarm));
        EUUnitTypes.narwhal.immunities.addAll(Vars.content.statusEffects().copy().removeAll(s -> (s == StatusEffects.none || s.healthMultiplier > 1.0f || s.damage < 0.0f || s.reloadMultiplier > 1.0f || s.damageMultiplier > 1.0f || s.speedMultiplier > 1.0f) && !s.disarm));
        EUUnitTypes.regency.immunities.addAll(Vars.content.statusEffects().copy().removeAll(s -> s == StatusEffects.none || s == EUStatusEffects.EUUnmoving || s == EUStatusEffects.EUDisarmed || s.healthMultiplier > 1.0f || s.damage < 0.0f || s.reloadMultiplier > 1.0f || s.damageMultiplier > 1.0f || s.speedMultiplier > 1.0f));
        if (Vars.ui != null) {
            eui = new EUI();
            eui.init();
            Vars.ui.menufrag.addButton(ExtraUtilitiesMod.toText("eu-rogue-like-start"), (Drawable)Icon.defense, () -> ExtraUtilitiesMod.eui.roguelike.toShow());
        }
    }

    public ExtraUtilitiesMod() {
        Log.info((Object)"Extra Utilities: try load WTMF");
        Events.on(EventType.ClientLoadEvent.class, e -> Time.runTask((float)1.0f, EUFrom::load));
        Log.info((Object)"Loading completed, congratulations! :)");
        Log.info((Object)"Loaded ExtraUtilities Mod constructor.");
        Events.on(EventType.ClientLoadEvent.class, e -> Time.runTask((float)6.0f, ExtraUtilitiesMod::log));
        Log.info((Object)"Extra Utilities: building rand subtitle...");
    }

    public Graphics.Cursor newCursor(String filename) {
        Pixmap p = new Pixmap(ExtraUtilitiesMod.EU.root.child("cursor").child(filename));
        return Core.graphics.newCursor(p, p.width / 2, p.height / 2);
    }

    public Graphics.Cursor newCursor(String filename, int scale) {
        if (scale == 1 || OS.isAndroid || OS.isIos) {
            return this.newCursor(filename);
        }
        Pixmap base = new Pixmap(ExtraUtilitiesMod.EU.root.child("cursor").child(filename));
        Pixmap result = Pixmaps.scale((Pixmap)base, (float)(base.width * scale), (float)(base.height * scale));
        base.dispose();
        return Core.graphics.newCursor(result, result.width / 2, result.height / 2);
    }

    private void overrideUI() {
        Graphics.Cursor.SystemCursor.arrow.set(this.newCursor("cursor.png", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.hand.set(this.newCursor("hand.png", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.ibeam.set(this.newCursor("ibeam.png", Fonts.cursorScale()));
        Vars.ui.drillCursor = this.newCursor("drill.png", Fonts.cursorScale());
        Vars.ui.unloadCursor = this.newCursor("unload.png", Fonts.cursorScale());
        Vars.ui.targetCursor = this.newCursor("target.png", Fonts.cursorScale());
        Vars.ui.repairCursor = this.newCursor("repair.png", Fonts.cursorScale());
    }

    public static boolean isAps() {
        LocalDate date = LocalDate.now();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("MMdd");
        String fd = sdf.format(date);
        return fd.equals("0401");
    }

    private boolean EUVerUnChange(String ver) {
        String verHard = ver + "-hard";
        String verV8 = ver + "-V8";
        String verAll = ver + "-all";
        return ver == null || ver.equals(ExtraUtilitiesMod.EU.meta.version) || verHard.equals(ExtraUtilitiesMod.EU.meta.version) || verV8.equals(ExtraUtilitiesMod.EU.meta.version) || verAll.equals(ExtraUtilitiesMod.EU.meta.version);
    }

    public void init() {
        Mods.LoadedMod mod;
        boolean aps = ExtraUtilitiesMod.isAps();
        if (aps) {
            ExtraUtilitiesMod.EU.meta.version = "2.4.8p5";
        }
        if (!onlyPlugIn) {
            MainRenderer.init();
            EUCall.registerPackets();
            EUOverride.overrideUnitForAll(overrideUnitArm, coreReset);
            EUOverride.overrideTDRules(coreReset);
            EUOverride.overrideBlockAll(hardMod, coreResetV7, coreReset);
            Blocks.foreshadow.stats.add(Stat.ammo, EUStatValues.ammoString(EUItems.lightninAlloy, "fs"));
            EUOverride.overrideJs();
            ExtraUtilitiesMod.afterEnterLoad();
            if (aps) {
                EUOverride.ap4sOverride();
            }
            if (Vars.ui != null && aps) {
                Events.on(EventType.ClientLoadEvent.class, e -> Time.runTask((float)10.0f, ExtraUtilitiesMod::log2));
            }
        }
        Vars.mods.locateMod((String)ExtraUtilitiesMod.ModName).meta.hidden = onlyPlugIn;
        if (onlyPlugIn) {
            mod = Vars.mods.locateMod(ModName);
            mod.meta.displayName = mod.meta.displayName + "-Plug-In";
            mod.meta.version = Vars.mods.locateMod((String)ExtraUtilitiesMod.ModName).meta.version + "-plug-in";
        }
        if (hardMod) {
            EUOverride.overrideHard();
            mod = Vars.mods.locateMod(ModName);
            mod.meta.displayName = mod.meta.displayName + " Hard!";
            mod.meta.version = Vars.mods.locateMod((String)ExtraUtilitiesMod.ModName).meta.version + "-hard";
        }
        if (!onlyPlugIn) {
            if (!coreResetV7 && !coreReset) {
                mod = Vars.mods.locateMod(ModName);
                mod.meta.displayName = mod.meta.displayName + "-V8";
                mod.meta.version = Vars.mods.locateMod((String)ExtraUtilitiesMod.ModName).meta.version + "-V8";
            }
            if (coreReset) {
                mod = Vars.mods.locateMod(ModName);
                mod.meta.displayName = mod.meta.displayName + "-all";
                mod.meta.version = Vars.mods.locateMod((String)ExtraUtilitiesMod.ModName).meta.version + "-all";
            }
        }
        if (Vars.ui != null) {
            if (Core.settings.getBool("use-eu-cursor")) {
                this.overrideUI();
            }
            if (Core.settings.getBool("eu-show-version")) {
                EUOverride.overrideVersion();
            }
            if (Vars.ui.settings != null) {
                final BaseDialog dialog = new BaseDialog("tips");
                Runnable exit = () -> {
                    dialog.hide();
                    Core.app.exit();
                };
                dialog.cont.add((CharSequence)ExtraUtilitiesMod.toText("eu-reset-exit"));
                dialog.buttons.button("OK", exit).center().size(150.0f, 50.0f);
                Vars.ui.settings.addCategory(ExtraUtilitiesMod.toText("EU-SET"), ExtraUtilitiesMod.name("fireWork"), settingsTable -> {
                    settingsTable.pref(new SettingsMenuDialog.SettingsTable.Setting("min-zoom"){
                        final int def = 10;
                        final float min = 1.0f;
                        final float max = 50.0f;
                        final float step = 1.0f;
                        {
                            this.def = 10;
                            this.min = 1.0f;
                            this.max = 50.0f;
                            this.step = 1.0f;
                        }

                        public void add(SettingsMenuDialog.SettingsTable table) {
                            Core.settings.defaults(new Object[]{this.name, 10});
                            Slider slider = new Slider(1.0f, 50.0f, 1.0f, false);
                            slider.setValue((float)Core.settings.getInt(this.name));
                            Label value = new Label((CharSequence)"", Styles.outlineLabel);
                            Table content = new Table();
                            content.add((CharSequence)this.title, Styles.outlineLabel).left().growX().wrap();
                            content.add((Element)value).padLeft(10.0f).right();
                            content.margin(3.0f, 33.0f, 3.0f, 33.0f);
                            content.touchable = Touchable.disabled;
                            slider.update(() -> {
                                float v = Vars.renderer.minZoom * 10.0f;
                                slider.setValue(v);
                                String st = v > 50.0f ? Core.bundle.get("zoom-over") : (v < 1.0f ? Core.bundle.get("zoom-below") : "");
                                value.setText((CharSequence)(st + v / 10.0f + "x"));
                            });
                            slider.changed(() -> {
                                Core.settings.put(this.name, (Object)((int)slider.getValue()));
                                if (!Vars.headless) {
                                    Vars.renderer.minZoom = slider.getValue() / 10.0f;
                                }
                            });
                            slider.change();
                            this.addDesc(table.stack(new Element[]{slider, content}).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get());
                            table.row();
                        }
                    });
                    settingsTable.pref(new SettingsMenuDialog.SettingsTable.Setting("max-zoom"){
                        final int def = 10;
                        final float min = 5.0f;
                        final float max = 50.0f;
                        final float step = 1.0f;
                        {
                            this.def = 10;
                            this.min = 5.0f;
                            this.max = 50.0f;
                            this.step = 1.0f;
                        }

                        public void add(SettingsMenuDialog.SettingsTable table) {
                            Core.settings.defaults(new Object[]{this.name, 10});
                            Slider slider = new Slider(5.0f, 50.0f, 1.0f, false);
                            slider.setValue((float)Core.settings.getInt(this.name));
                            Label value = new Label((CharSequence)"", Styles.outlineLabel);
                            Table content = new Table();
                            content.add((CharSequence)this.title, Styles.outlineLabel).left().growX().wrap();
                            content.add((Element)value).padLeft(10.0f).right();
                            content.margin(3.0f, 33.0f, 3.0f, 33.0f);
                            content.touchable = Touchable.disabled;
                            slider.update(() -> {
                                float v = Vars.renderer.maxZoom;
                                slider.setValue(v);
                                String st = v > 50.0f ? Core.bundle.get("zoom-over") : (v < 5.0f ? Core.bundle.get("zoom-below") : "");
                                value.setText((CharSequence)(st + v + "x"));
                            });
                            slider.changed(() -> {
                                Core.settings.put(this.name, (Object)((int)slider.getValue()));
                                if (!Vars.headless) {
                                    Vars.renderer.maxZoom = slider.getValue();
                                }
                            });
                            slider.change();
                            this.addDesc(table.stack(new Element[]{slider, content}).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get());
                            table.row();
                        }
                    });
                    settingsTable.checkPref("use-eu-cursor", true);
                    settingsTable.checkPref("eu-show-version", true);
                    settingsTable.checkPref("eu-WTMF-open", false);
                    settingsTable.pref((SettingsMenuDialog.SettingsTable.Setting)new SettingsMenuDialog.SettingsTable.CheckSetting("eu-plug-in-mode", false, null){

                        public void add(SettingsMenuDialog.SettingsTable table) {
                            CheckBox box = new CheckBox(this.title);
                            box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                            box.changed(() -> {
                                Core.settings.put(this.name, (Object)box.isChecked());
                                Core.settings.remove("eu-hard-mode");
                                dialog.show();
                            });
                            box.left();
                            this.addDesc(table.add((Element)box).left().padTop(3.0f).get());
                            table.row();
                        }
                    });
                    if (!onlyPlugIn) {
                        settingsTable.checkPref("eu-reset-core-to-V7", true);
                        settingsTable.checkPref("eu-reset-core-to-all", false);
                        settingsTable.checkPref("eu-show-miner-point", true);
                        settingsTable.checkPref("eu-show-hole-acc-disk", true);
                        settingsTable.checkPref("eu-show-rust-range", true);
                        settingsTable.checkPref("eu-first-load", true);
                        if (!this.EUVerUnChange((String)Core.settings.get("eu-version", (Object)""))) {
                            Core.settings.put("eu-first-load", (Object)true);
                            Core.settings.put("eu-version", (Object)ExtraUtilitiesMod.EU.meta.version);
                        }
                        settingsTable.pref(new SettingsMenuDialog.SettingsTable.Setting(Core.bundle.get("eu-show-me-now")){

                            public void add(SettingsMenuDialog.SettingsTable table) {
                                table.button(this.name, ExtraUtilitiesMod::toShow).margin(14.0f).width(200.0f).pad(6.0f);
                                table.row();
                            }
                        });
                        settingsTable.checkPref("eu-override-unit", false);
                        settingsTable.checkPref("eu-override-unit-missile", true);
                        settingsTable.pref((SettingsMenuDialog.SettingsTable.Setting)new SettingsMenuDialog.SettingsTable.CheckSetting("eu-hard-mode", false, null){

                            public void add(SettingsMenuDialog.SettingsTable table) {
                                CheckBox box = new CheckBox(this.title);
                                box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                                box.changed(() -> {
                                    if (!onlyPlugIn) {
                                        Core.settings.put(this.name, (Object)box.isChecked());
                                        Core.settings.put("eu-open-hard", (Object)hardMod);
                                        dialog.show();
                                    }
                                });
                                box.left();
                                this.addDesc(table.add((Element)box).left().padTop(3.0f).get());
                                table.row();
                            }
                        });
                        settingsTable.pref(new SettingsMenuDialog.SettingsTable.Setting(Core.bundle.get("eu-show-donor-and-develop")){

                            public void add(SettingsMenuDialog.SettingsTable table) {
                                table.button(this.name, ExtraUtilitiesMod.eui.ddItemsList::toShow).margin(14.0f).width(200.0f).pad(6.0f);
                                table.row();
                            }
                        });
                    }
                });
            }
            if (!onlyPlugIn) {
                UnitCommand c = new UnitCommand("EUAssist", "defense", u -> new DefenderHealAI());
                EUUnitTypes.narwhal.commands.add((Object)c);
                EUUnitTypes.narwhal.defaultCommand = c;
                if (Core.atlas != null) {
                    TextureRegionDrawable ex = new TextureRegionDrawable((TextureRegion)Core.atlas.find("extra-utilities-serpuloEX"));
                    Icon.icons.put((Object)"ex", (Object)ex);
                    TDPlanet.supEX.icon = "ex";
                }
            }
        }
        ExtraUtilitiesMod.setColorName();
    }

    public void loadContent() {
        EU = Vars.mods.getMod(ExtraUtilitiesMod.class);
        String ms = ExtraUtilitiesMod.isAps() ? Core.bundle.get("mod.random-massageAp") : Core.bundle.get("mod.random-massage");
        String[] me = ms.split(",");
        int len = me.length;
        massageRand = me[Mathf.random((int)(len - 1))];
        if (Core.settings != null) {
            Core.settings.defaults(new Object[]{"eu-override-unit", false});
            Core.settings.defaults(new Object[]{"eu-plug-in-mode", false});
            Core.settings.defaults(new Object[]{"eu-hard-mode", false});
            Core.settings.defaults(new Object[]{"use-eu-cursor", true});
            Core.settings.defaults(new Object[]{"eu-show-version", true});
            Core.settings.defaults(new Object[]{"eu-override-unit-missile", true});
            Core.settings.defaults(new Object[]{"eu-reset-core-to-V7", true});
            Core.settings.defaults(new Object[]{"eu-reset-core-to-all", false});
            hardMod = Core.settings.getBool("eu-hard-mode");
            onlyPlugIn = Core.settings.getBool("eu-plug-in-mode");
            coreResetV7 = Core.settings.getBool("eu-reset-core-to-V7");
            coreReset = Core.settings.getBool("eu-reset-core-to-all");
            overrideUnitArm = Core.settings.getBool("eu-override-unit");
            overrideUnitMissile = Core.settings.getBool("eu-override-unit-missile");
        }
        if (onlyPlugIn) {
            return;
        }
        if (ExtraUtilitiesMod.isAps()) {
            hardMod = true;
        }
        EUOverride.overrideItem();
        EUStatusEffects.load();
        EUAttribute.load();
        EUOverride.overrideUnit1();
        if (overrideUnitMissile) {
            EUOverride.overrideUnitMissile();
        }
        EUUnitTypes.load();
        EUUnitTypes.loadBoss();
        EUOverride.overrideBlock1();
        EUBlocks.load();
        TDPlanet.load();
        TDSectorPresets.load();
        EUTechTree.load();
        if (!Vars.headless) {
            EUGet.loadItems();
        }
    }

    public static void rebuildRandSubTitle(String title) {
        EUMenuFragment subTitle = new EUMenuFragment(title);
        subTitle.build((Group)Vars.ui.menuGroup);
    }

    static {
        show = false;
        setMat = new Mat();
        reMat = new Mat();
        vec2 = new Vec2();
        updateLog = new Seq();
    }

    private static class EUMenuFragment {
        private final String title;

        public EUMenuFragment(String title) {
            this.title = title;
        }

        public void build(Group parent) {
            parent.fill((Table.DrawRect)(Table.DrawRect)LambdaMetafactory.metafactory(null, null, null, (FFFF)V, lambda$build$0(float float float float ), (FFFF)V)((EUMenuFragment)this)).touchable = Touchable.disabled;
        }

        private /* synthetic */ void lambda$build$0(float x, float y, float w, float h) {
            TextureAtlas.AtlasRegion logo = Core.atlas.find("logo");
            float width = Core.graphics.getWidth();
            float height = (float)Core.graphics.getHeight() - Core.scene.marginTop;
            float logoscl = Scl.scl((float)1.0f) * logo.scale;
            float logow = Math.min((float)logo.width * logoscl, (float)Core.graphics.getWidth() - Scl.scl((float)20.0f));
            float logoh = logow * (float)logo.height / (float)logo.width;
            float fx = (int)(width / 2.0f);
            float fy = (float)((int)(height - 6.0f - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl((float)30.0f) : 0.0f);
            if (Core.settings.getBool("macnotch")) {
                fy -= Scl.scl((float)Vars.macNotchHeight);
            }
            float ex = fx + logow / 3.0f - Scl.scl((float)1.0f);
            float ey = fy - logoh / 3.0f - Scl.scl((float)2.0f);
            float ang = 12.0f + Mathf.sin((float)Time.time, (float)8.0f, (float)2.0f);
            float dst = Mathf.dst((float)ex, (float)ey, (float)0.0f, (float)0.0f);
            vec2.set(0.0f, 0.0f);
            float dx = EUGet.dx(0.0f, dst, vec2.angleTo(ex, ey) + ang);
            float dy = EUGet.dy(0.0f, dst, vec2.angleTo(ex, ey) + ang);
            reMat.set(Draw.trans());
            Draw.trans((Mat)setMat.setToTranslation(ex - dx, ey - dy).rotate(ang));
            Fonts.outline.draw((CharSequence)this.title, ex, ey, Color.yellow, Math.min(30.0f / (float)this.title.length(), 1.5f) + Mathf.sin((float)Time.time, (float)8.0f, (float)0.2f), false, 1);
            Draw.trans((Mat)reMat);
        }
    }
}

