/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.content.EUStatusEffects;
import ExtraUtilities.worlds.entity.bullet.ChainLightningFade;
import ExtraUtilities.worlds.entity.bullet.FawnFarsiaBit;
import ExtraUtilities.worlds.entity.bullet.FlameBulletType;
import ExtraUtilities.worlds.entity.bullet.MagneticStormBulletType;
import ExtraUtilities.worlds.entity.bullet.RainbowStorm;
import ExtraUtilities.worlds.entity.bullet.mixBoom;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.StatusEffect;
import mindustry.world.blocks.defense.turrets.Turret;

public class EUBulletTypes {
    public static BulletType b1 = new mixBoom(Pal.bulletYellowBack){
        {
            this.fragBullet = new mixBoom.mixExps(){
                {
                    this.lifetime = 20.0f;
                    this.speed = 2.8f;
                    this.trailColor = this.color = Pal.bulletYellowBack;
                    this.damage = 0.0f;
                    this.splashDamage = 32.0f;
                    this.splashDamageRadius = 22.4f;
                    this.trailWidth = 4.0f;
                    this.trailLength = 8;
                    this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                        {
                            this.lifetime = 30.0f;
                            this.waveRad = splashDamageRadius;
                            this.sparkColor = this.smokeColor = Pal.bulletYellowBack;
                            this.waveColor = this.smokeColor;
                            this.smokeSize = 0.0f;
                            this.smokeSizeBase = 0.0f;
                            this.smokes = 0;
                            this.sparks = 3;
                            this.sparkRad = splashDamageRadius;
                            this.sparkLen = 2.0f;
                            this.sparkStroke = 1.5f;
                        }
                    };
                }
            };
            this.fragBullets = 7;
            this.fragAngle = 15.0f;
            this.fragSpread = 30.0f;
            this.fragRandomSpread = 0.0f;
            this.speed = 8.0f;
            this.aimTo = true;
        }
    };
    public static BulletType b2 = new mixBoom(EUItems.crispSteel.color){
        {
            this.fragBullet = new mixBoom.mixExps(){
                {
                    this.lifetime = 20.0f;
                    this.speed = 3.0f;
                    this.trailColor = this.color = EUItems.crispSteel.color;
                    this.damage = 0.0f;
                    this.splashDamage = 28.0f;
                    this.splashDamageRadius = 32.8f;
                    this.status = StatusEffects.freezing;
                    this.trailWidth = 4.0f;
                    this.trailLength = 8;
                    this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                        {
                            this.lifetime = 30.0f;
                            this.waveRad = splashDamageRadius;
                            this.sparkColor = this.smokeColor = EUItems.crispSteel.color;
                            this.waveColor = this.smokeColor;
                            this.smokeSize = 2.0f;
                            this.smokeSizeBase = 0.0f;
                            this.smokes = 4;
                            this.sparks = 5;
                            this.sparkRad = splashDamageRadius;
                            this.sparkLen = 2.0f;
                            this.sparkStroke = 1.5f;
                        }
                    };
                }
            };
            this.fragBullets = 10;
            this.speed = 6.0f;
        }
    };
    public static BulletType b3 = new mixBoom(Items.pyratite.color){
        {
            this.fragBullet = new mixBoom.mixExps(){
                {
                    this.lifetime = 20.0f;
                    this.speed = 2.1f;
                    this.trailColor = this.color = Items.pyratite.color;
                    this.damage = 0.0f;
                    this.splashDamage = 36.0f;
                    this.splashDamageRadius = 28.0f;
                    this.status = StatusEffects.burning;
                    this.incendChance = 0.5f;
                    this.trailWidth = 4.0f;
                    this.trailLength = 8;
                    this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                        {
                            this.lifetime = 30.0f;
                            this.waveRad = splashDamageRadius;
                            this.sparkColor = this.smokeColor = Items.pyratite.color;
                            this.waveColor = this.smokeColor;
                            this.smokeSize = 2.2f;
                            this.smokeSizeBase = 0.0f;
                            this.smokes = 6;
                            this.sparks = 3;
                            this.sparkRad = splashDamageRadius;
                            this.sparkLen = 2.0f;
                            this.sparkStroke = 1.5f;
                        }
                    };
                }
            };
            this.fragBullets = 9;
            this.speed = 5.0f;
        }
    };
    public static BulletType b4 = new mixBoom(Items.surgeAlloy.color){
        {
            this.fragBullet = new mixBoom.mixExps(){
                {
                    this.circle = false;
                    this.lifetime = 20.0f;
                    this.speed = 3.5f;
                    this.trailColor = this.color = Items.surgeAlloy.color;
                    this.damage = 0.0f;
                    this.splashDamage = 30.0f;
                    this.splashDamageRadius = 24.0f;
                    this.status = StatusEffects.shocked;
                    this.trailWidth = 3.0f;
                    this.trailLength = 8;
                    this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                        {
                            this.lifetime = 30.0f;
                            this.waveRad = splashDamageRadius;
                            this.sparkColor = this.smokeColor = Items.surgeAlloy.color;
                            this.waveColor = this.smokeColor;
                            this.smokeSize = 3.0f;
                            this.smokeSizeBase = 0.0f;
                            this.smokes = 5;
                            this.sparks = 0;
                        }
                    };
                    this.lightningDamage = 10.0f;
                    this.lightning = 1;
                    this.lightningLength = 4;
                }
            };
            this.fragBullets = 10;
            this.fragAngle = 15.0f;
            this.fragSpread = 36.0f;
            this.fragRandomSpread = 0.0f;
            this.lightningDamage = 20.0f;
            this.lightning = 4;
            this.lightningLength = 10;
            this.speed = 6.0f;
        }
    };
    public static BulletType ib = new mixBoom.mixExps(){
        {
            this.lifetime = 50.0f;
            this.speed = 4.0f;
            this.size = 8.0f;
            this.minSize = 3.0f;
            this.trailColor = this.color = EUItems.lightninAlloy.color;
            this.damage = 0.0f;
            this.splashDamage = 80.0f;
            this.splashDamageRadius = 44.0f;
            this.trailWidth = 7.0f;
            this.trailLength = 15;
            this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                {
                    this.lifetime = 30.0f;
                    this.waveRad = splashDamageRadius;
                    this.sparkColor = this.smokeColor = EUItems.lightninAlloy.color;
                    this.waveColor = this.smokeColor;
                    this.smokeSize = 2.2f;
                    this.smokeSizeBase = 0.0f;
                    this.smokes = 6;
                    this.sparks = 3;
                    this.sparkRad = splashDamageRadius;
                    this.sparkLen = 2.0f;
                    this.sparkStroke = 1.5f;
                }
            };
            this.lightning = 3;
            this.lightningColor = EUItems.lightninAlloy.color;
            this.lightningDamage = 30.0f;
            this.lightningLength = 7;
        }
    };
    public static Color c1 = Pal.thoriumPink;
    public static BulletType rankB = new BasicBulletType(){
        {
            this.speed = 2.0f;
            this.lifetime = 216.0f;
            this.damage = 31.0f;
            this.buildingDamageMultiplier = 0.5f;
            this.width = 10.0f;
            this.height = 7.0f;
            this.shrinkY = 0.0f;
            this.despawnEffect = EUFx.gone(c1);
            this.backColor = c1;
            this.frontColor = c1;
        }

        public void update(Bullet b) {
            b.vel.trns(b.rotation(), this.speed * Math.max(0.0f, b.fout() - 0.5f));
        }
    };
    public static BulletType suk = new BasicBulletType(){
        {
            this.speed = 2.0f;
            this.lifetime = 115.0f;
            this.damage = 52.0f;
            this.buildingDamageMultiplier = 0.5f;
            this.width = 32.0f;
            this.height = 18.0f;
            this.shrinkY = 0.0f;
            this.pierce = true;
            this.pierceBuilding = true;
            this.backColor = c1;
            this.frontColor = c1;
            this.fragBullets = 5;
            this.fragRandomSpread = 0.0f;
            this.fragVelocityMin = 1.0f;
            this.fragSpread = 360.0f / (float)this.fragBullets;
            this.intervalBullets = this.fragBullets;
            this.intervalRandomSpread = this.fragRandomSpread;
            this.intervalSpread = this.fragSpread;
            this.bulletInterval = this.lifetime / 4.0f;
            this.intervalBullet = this.fragBullet = rankB;
            this.hitEffect = this.despawnEffect = EUFx.gone(c1);
            this.fragOnHit = false;
        }
    };
    public static BulletType[] rainbowLar = new BulletType[120];
    private static final BulletType rainbowStormSmall;
    public static BulletType setPos;
    public static BulletType rainbowStorm;
    public static BulletType effectForPenitent;
    static BulletType bit;
    static int msTl;
    static float dsRange;
    static ChainLightningFade lightningFade;
    static Effect expEffSmall;
    static BulletType eBall;
    public static BulletType foreshadowEUBullet;

    public static BulletType expFlame(float range, final float slpRange) {
        return new FlameBulletType(Items.blastCompound.color.cpy().mul(Pal.lightFlame), Items.blastCompound.color.cpy(), Pal.lightishGray, range + 8.0f, 22.0f, 66, 30.0f){
            {
                super(colorBegin, colorTo, colorEnd, length, cone, number, lifetime);
                this.damage = 90.0f;
                this.status = EUStatusEffects.flamePoint;
                this.statusDuration = 480.0f;
                this.reloadMultiplier = 0.5f;
            }

            @Override
            public void hit(Bullet b) {
                if (this.absorbable && b.absorbed) {
                    return;
                }
                Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.flameLength, unit -> {
                    if (Angles.within((float)b.rotation(), (float)b.angleTo((Position)unit), (float)this.flameCone) && unit.checkTarget(this.collidesAir, this.collidesGround)) {
                        Fx.hitFlameSmall.at((Position)unit);
                        unit.damage(this.damage);
                        if (unit.hasEffect(this.status)) {
                            Damage.damage((Team)b.team, (float)unit.x, (float)unit.y, (float)slpRange, (float)(this.damage / 3.0f), (boolean)false, (boolean)true);
                            Damage.status((Team)b.team, (float)unit.x, (float)unit.y, (float)slpRange, (StatusEffect)this.status, (float)this.statusDuration, (boolean)false, (boolean)true);
                            EUFx.easyExp.at(unit.x, unit.y, slpRange, Items.blastCompound.color);
                            unit.unapply(this.status);
                        } else {
                            unit.apply(this.status, this.statusDuration);
                        }
                    }
                });
                Vars.indexer.allBuildings(b.x, b.y, this.flameLength, other -> {
                    if (other.team != b.team && Angles.within((float)b.rotation(), (float)b.angleTo((Position)other), (float)this.flameCone)) {
                        Fx.hitFlameSmall.at((Position)other);
                        other.damage(this.damage * this.buildingDamageMultiplier);
                    }
                });
            }
        };
    }

    static {
        final StatusEffect[] rainStatus = new StatusEffect[]{StatusEffects.blasted, StatusEffects.electrified, StatusEffects.wet};
        for (int i = 0; i < 120; ++i) {
            final Color rbc = EUGet.rainBowRed.cpy().shiftHue((float)(i * 3));
            final int finalI = i;
            LaserBulletType ribt = new LaserBulletType(){
                {
                    this.laserAbsorb = false;
                    this.damage = 1.0f;
                    this.buildingDamageMultiplier = 0.2f;
                    this.pierceArmor = true;
                    this.colors = new Color[]{rbc.cpy().a(0.4f), rbc.cpy().a(0.7f), rbc};
                    this.lifetime = 18.0f;
                    this.length = 60.0f;
                    this.laserEffect = Fx.none;
                    this.status = rainStatus[finalI % 3];
                    this.statusDuration = 120.0f;
                    this.hitEffect = new Effect(24.0f, e -> {
                        if (e.color != null) {
                            Draw.color((Color)e.color.set(EUGet.rainBowRed).shiftHue(e.time * 20.0f));
                        }
                        Angles.randLenVectors((long)e.id, (int)3, (float)(32.0f * e.finpow()), (float)e.rotation, (float)90.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(6.0f * e.foutpow())));
                    });
                }

                public void init(Bullet b) {
                    Damage.collideLaser((Bullet)b, (float)b.fdata, (boolean)this.largeHit, (boolean)this.laserAbsorb, (int)this.pierceCap);
                }

                public void draw(Bullet b) {
                    float realLength = b.fdata;
                    float f = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.2f);
                    float baseLen = realLength * f;
                    float cwidth = b.fdata > 50.0f ? 13.0f : b.fdata / 5.0f;
                    for (Color color : this.colors) {
                        Draw.color((Color)color);
                        Lines.stroke((float)((cwidth *= 0.5f) * b.fout()));
                        Lines.lineAngle((float)b.x, (float)b.y, (float)b.rotation(), (float)baseLen, (boolean)false);
                        Tmp.v1.trns(b.rotation(), baseLen);
                        Drawf.tri((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Lines.getStroke(), (float)(cwidth * 2.0f + b.fdata / 10.0f), (float)b.rotation());
                    }
                    Draw.reset();
                }
            };
            EUBulletTypes.rainbowLar[i] = ribt;
        }
        rainbowStormSmall = new RainbowStorm(8.0f, 10.0f){
            {
                this.homingRange = 160.0f;
                this.homingPower = 0.5f;
                this.lifetime = 90.0f;
                this.speed = 4.5f;
                this.inAmi = false;
                this.homingDelay = 15.0f;
                this.sideTrailWidth = 2.0f;
                this.trailLength = 15;
                this.laserLength = 13.0f;
                this.laserAmount = 15;
            }
        };
        setPos = new BulletType(){
            {
                this.damage = 0.0f;
                this.speed = 0.0f;
                this.collidesGround = false;
                this.collidesAir = false;
                this.collidesTiles = false;
                this.collides = false;
                this.keepVelocity = false;
                this.absorbable = false;
                this.hittable = false;
                this.hitEffect = this.despawnEffect = Fx.none;
                this.hitSize = 0.0f;
                this.lifetime = 80.0f;
            }
        };
        rainbowStorm = new RainbowStorm(){
            {
                this.homingRange = 120.0f;
                this.homingPower = 0.4f;
                this.homingDelay = 30.0f;
                this.lifetime = 180.0f;
                this.speed = 3.0f;
                this.trailLength = 18;
                this.splashDamage = 300.0f;
                this.splashDamageRadius = 96.0f;
                this.rotSpeed = -2.8f;
                final Color cor = Color.valueOf((String)"FFF8D8");
                final Color liC = Color.valueOf((String)"FFE5C0");
                this.despawnEffect = new MultiEffect(new Effect[]{EUFx.StormExp(liC, cor)});
                final Effect tef = new Effect(30.0f, e -> {
                    Draw.color((Color)liC, (Color)cor, (float)e.fin());
                    float ex = e.x + Mathf.randomSeed((long)e.id, (float)-4.0f, (float)4.0f);
                    float ey = e.y + (float)Mathf.randomSeed((long)e.id, (int)-4, (int)4);
                    Fill.circle((float)ex, (float)ey, (float)(4.2f * e.fout()));
                });
                this.fragBullet = new BulletType(){
                    {
                        this.speed = 3.2f;
                        this.lifetime = 72.0f;
                        this.damage = 20.0f;
                        this.bulletInterval = 7.2f;
                        this.hitEffect = Fx.hitLancer;
                        this.despawnEffect = Fx.none;
                        this.keepVelocity = false;
                        this.hittable = false;
                        this.absorbable = false;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.trailWidth = 0.0f;
                        this.trailLength = 25;
                        this.trailEffect = tef;
                        this.trailInterval = 1.0f;
                        this.buildingDamageMultiplier = 0.5f;
                    }

                    public void update(Bullet b) {
                        super.update(b);
                        b.rotation(b.rotation() - Time.delta * 3.7f);
                    }

                    public void updateBulletInterval(Bullet b) {
                        Object object = b.data;
                        if (object instanceof Integer) {
                            Integer data = (Integer)object;
                            if (b.timer.get(2, this.bulletInterval)) {
                                int index = (int)(b.time + (float)data.intValue() * 3.3f) % 120;
                                Bullet rb = rainbowLar[index].create((Entityc)b, b.team, b.x, b.y, b.rotation() - 90.0f, 45.0f, 1.0f, 1.0f, null);
                                rb.fdata = 120.0f;
                            }
                        }
                    }

                    public void drawTrail(Bullet b) {
                        if (this.trailLength > 0 && b.trail != null) {
                            float d = b.time < b.lifetime / 2.0f ? b.fin() * 2.0f : b.fout() * 2.0f;
                            float z = Draw.z();
                            Draw.z((float)(z - 1.0E-4f));
                            b.trail.draw(Tmp.c4.set(liC).lerp(cor, b.fin()), 3.5f * d + 1.0f);
                            Draw.z((float)z);
                        }
                    }

                    public void draw(Bullet b) {
                        super.draw(b);
                        float d = b.time < b.lifetime / 2.0f ? b.fin() * 2.0f : b.fout() * 2.0f;
                        Draw.color((Color)liC, (Color)cor, (float)b.fin());
                        Fill.circle((float)b.x, (float)b.y, (float)(2.5f * d + 1.0f));
                    }
                };
                this.fragBullets = 6;
            }

            public void createFrags(Bullet b, float x, float y) {
                for (int i = 0; i < this.fragBullets; ++i) {
                    float a = Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(60 * i);
                    this.fragBullet.create((Entityc)b, b.team, b.x, b.y, a, -1.0f, 1.0f, 1.0f, (Object)i);
                }
            }

            public void updateHoming(Bullet b) {
                if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay) {
                    float realAimX = b.aimX < 0.0f ? b.x : b.aimX;
                    float realAimY = b.aimY < 0.0f ? b.y : b.aimY;
                    Object target = b.aimTile != null && b.aimTile.build != null && b.aimTile.build.team != b.team && this.collidesGround && !b.hasCollided(b.aimTile.build.id) ? b.aimTile.build : Units.closestTarget((Team)b.team, (float)realAimX, (float)realAimY, (float)this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id));
                    if (target != null) {
                        if (b.time < b.lifetime - this.outTime && b.timer.get(1, 21.0f)) {
                            rainbowStormSmall.create(b, b.x, b.y, b.rotation() - 90.0f + Mathf.random((float)120.0f));
                        }
                        b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(this.homingPower * Time.delta * 50.0f)));
                    }
                }
            }

            public void update(Bullet b) {
                Turret.TurretBuild build;
                super.update(b);
                Entityc entityc = b.owner;
                if (entityc instanceof Turret.TurretBuild && !b.within((Position)(build = (Turret.TurretBuild)entityc), build.range())) {
                    b.remove();
                }
            }
        };
        effectForPenitent = new BulletType(){
            {
                this.speed = 0.0f;
                this.absorbable = false;
                this.hittable = false;
                this.collidesGround = false;
                this.collidesAir = true;
                this.pierce = true;
                this.damage = 90.0f;
                this.lifetime = 60.0f;
                this.pierceArmor = true;
                this.trailColor = EUItems.lightninAlloy.color;
                this.trailLength = 14;
                this.trailWidth = 2.0f;
                this.hitEffect = new Effect(24.0f, e -> {
                    Draw.color((Color)EUItems.lightninAlloy.color);
                    Angles.randLenVectors((long)e.id, (int)7, (float)(32.0f * e.finpow()), (float)e.rotation, (float)0.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(8.0f * e.foutpow())));
                });
                this.despawnEffect = Fx.none;
            }

            public void update(Bullet b) {
                if (b.timer.get(2, 12.0f)) {
                    b.collided.clear();
                }
                super.update(b);
            }

            public void draw(Bullet b) {
                super.draw(b);
                Draw.color((Color)this.trailColor);
                Drawf.tri((float)b.x, (float)b.y, (float)3.0f, (float)7.0f, (float)b.rotation());
                Drawf.tri((float)b.x, (float)b.y, (float)2.0f, (float)5.3f, (float)(b.rotation() + 150.0f));
                Drawf.tri((float)b.x, (float)b.y, (float)2.0f, (float)5.3f, (float)(b.rotation() - 150.0f));
            }

            public void removed(Bullet b) {
            }
        };
        bit = new FawnFarsiaBit(){
            {
                this.homingRange = 120.0f;
                final Effect initE = EUFx.chainLightningFade(22.0f, 1.3f, 44.0f).layer(99.9f);
                this.buildingDamageMultiplier = 0.2f;
                final BulletType miss = new BulletType(){
                    {
                        this.damage = 50.0f;
                        this.pierceArmor = true;
                        this.absorbable = false;
                        this.hittable = false;
                        this.keepVelocity = false;
                        this.lifetime = 60.0f;
                        this.speed = 8.0f;
                        this.trailWidth = 2.0f;
                        this.trailLength = 12;
                        this.trailColor = EUItems.lightninAlloy.color.cpy();
                        this.buildingDamageMultiplier = 0.2f;
                    }

                    public void update(Bullet b) {
                        super.update(b);
                        if (b.time < 30.0f) {
                            float fin = Math.min(1.0f, b.time / 30.0f);
                            float fout = 1.0f - fin;
                            b.initVel(b.rotation(), fout * 4.0f);
                        } else {
                            Object object = b.data;
                            if (object instanceof Unit) {
                                Unit u = (Unit)object;
                                b.rotation(b.angleTo((Position)u));
                                b.initVel(b.rotation(), this.speed);
                            }
                        }
                    }

                    public void draw(Bullet b) {
                        super.draw(b);
                        Draw.color((Color)this.trailColor);
                        Fill.circle((float)b.x, (float)b.y, (float)2.0f);
                    }

                    public void removed(Bullet b) {
                    }
                };
                this.intervalBullet = new BulletType(){
                    {
                        this.damage = 50.0f;
                        this.buildingDamageMultiplier = 0.1f;
                        this.speed = 16.0f;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.lifetime = 11.0f;
                        this.trailWidth = 2.0f;
                        this.trailLength = 12;
                        this.trailColor = EUItems.lightninAlloy.color.cpy();
                        this.hittable = false;
                        this.absorbable = false;
                        this.keepVelocity = false;
                        this.hitEffect = this.despawnEffect = new Effect(21.0f, e -> {
                            Draw.color((Color)this.trailColor);
                            Angles.randLenVectors((long)e.id, (int)5, (float)(16.0f * e.finpow()), (float)e.rotation, (float)360.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(9.0f * e.foutpow())));
                        });
                    }

                    public void init(Bullet b) {
                        super.init();
                        float ex = b.x + Angles.trnsx((float)b.rotation(), (float)(this.speed * b.lifetime));
                        float ey = b.y + Angles.trnsy((float)b.rotation(), (float)(this.speed * b.lifetime));
                        float len = Mathf.dst((float)b.x, (float)b.y, (float)ex, (float)ey);
                        float angle = Angles.angle((float)b.x, (float)b.y, (float)ex, (float)ey);
                        initE.at(b.x, b.y, angle, this.trailColor, (Object)Float.valueOf(len));
                    }

                    public void draw(Bullet b) {
                        super.draw(b);
                        Draw.color((Color)this.trailColor);
                        Drawf.tri((float)b.x, (float)b.y, (float)6.0f, (float)8.0f, (float)b.rotation());
                    }

                    public void hitEntity(Bullet b, Hitboxc entity, float health) {
                        super.hitEntity(b, entity, health);
                        if (entity instanceof Unit) {
                            Entityc entityc;
                            Unit u = (Unit)entity;
                            if (!u.dead && u.hasEffect(EUStatusEffects.awsl) && (entityc = b.owner) instanceof FawnFarsiaBit.Bit) {
                                FawnFarsiaBit.Bit bit = (FawnFarsiaBit.Bit)entityc;
                                miss.create((Entityc)b, b.team, bit.x, bit.y, bit.rotation() - 72.0f, -1.0f, 1.0f, 1.0f, (Object)u);
                                miss.create((Entityc)b, b.team, bit.x, bit.y, bit.rotation() + 72.0f, -1.0f, 1.0f, 1.0f, (Object)u);
                            }
                        }
                    }

                    public void removed(Bullet b) {
                    }
                };
                this.bulletInterval = 30.0f;
                this.intervalBullets = 1;
                this.lifetime = 360.0f;
                this.ready = 60.0f;
                this.hittable = true;
                this.trailColor = EUItems.lightninAlloy.color.cpy();
                this.splashDamage = 300.0f;
                this.damage = 300.0f;
                this.splashDamageRadius = 40.0f;
                this.hitEffect = this.despawnEffect = EUFx.layerCircle(15.0f, this.splashDamageRadius, EUItems.lightninAlloy.color);
                this.drawer = b -> {
                    float fout = 1.0f - Math.min(1.0f, b.time / this.ready);
                    float tr = b.rotation() + 1440.0f * Interp.slowFast.apply(fout);
                    Draw.color((Color)this.trailColor);
                    Drawf.tri((float)b.x, (float)b.y, (float)10.0f, (float)5.0f, (float)tr);
                    float dx = EUGet.dx(b.x, 5.5f, tr - 180.0f);
                    float dy = EUGet.dy(b.y, 5.5f, tr - 180.0f);
                    Fill.poly((float)dx, (float)dy, (int)4, (float)5.0f, (float)(tr + 45.0f));
                    dx = EUGet.dx(b.x, 7.0f, tr - 135.0f);
                    dy = EUGet.dy(b.y, 7.0f, tr - 135.0f);
                    Drawf.tri((float)dx, (float)dy, (float)9.0f, (float)4.0f, (float)(tr - 90.0f));
                    dx = EUGet.dx(b.x, 7.0f, tr + 135.0f);
                    dy = EUGet.dy(b.y, 7.0f, tr + 135.0f);
                    Drawf.tri((float)dx, (float)dy, (float)9.0f, (float)4.0f, (float)(tr + 90.0f));
                    Draw.color();
                };
                this.shootSound = Sounds.malignShoot;
                this.vol = 0.6f;
                this.pit = 1.2f;
                this.shootBullet = (b, s) -> {
                    float dx = EUGet.dx(b.x, 7.0f, b.rotation());
                    float dy = EUGet.dy(b.y, 7.0f, b.rotation());
                    s.create((Entityc)b, b.team, dx, dy, b.rotation());
                };
                this.approach = b -> {
                    if (b.target != null) {
                        b.rotation(b.angleTo((Position)b.target));
                        float dx = EUGet.dx(b.target.x(), this.homingRange / 1.5f, b.ang);
                        float dy = EUGet.dy(b.target.y(), this.homingRange / 1.5f, b.ang);
                        EUGet.movePoint(b, dx, dy, this.speed / 100.0f);
                    }
                };
            }
        };
        msTl = 15;
        dsRange = 64.0f;
        lightningFade = new ChainLightningFade(12.0f, 14.0f, 2.0f, Pal.surge, 20.0f, Fx.hitLancer){
            {
                this.buildingDamageMultiplier = 0.1f;
            }
        };
        expEffSmall = new ExplosionEffect(){
            {
                this.lifetime = 20.0f;
                this.waveLife = 12.0f;
                this.waveStroke = 2.0f;
                this.waveColor = EUItems.lightninAlloy.color.cpy();
                this.waveRad = 16.0f;
                this.smokeSize = 2.0f;
                this.smokes = 4;
                this.sparks = 3;
                this.sparkStroke = 1.0f;
                this.sparkLen = 3.0f;
                this.smokeRad = 18.0f;
                this.sparkRad = 18.0f;
                this.smokeColor = Pal.surge.cpy();
                this.sparkColor = EUItems.lightninAlloy.color.cpy();
            }
        };
        eBall = new BulletType(){
            {
                this.buildingDamageMultiplier = 0.2f;
                this.lifetime = 120.0f;
                this.speed = 4.0f;
                this.damage = 50.0f;
                this.keepVelocity = false;
                this.trailColor = EUItems.lightninAlloy.color.cpy();
                this.trailWidth = 0.0f;
                this.trailLength = 18;
                this.splashDamage = 50.0f;
                this.splashDamageRadius = 16.0f;
                this.hitEffect = expEffSmall;
                this.despawnEffect = Fx.none;
                this.buildingDamageMultiplier = 0.2f;
            }

            public void update(Bullet b) {
                super.update(b);
                if (!(b instanceof MagneticStormBulletType.mgs)) {
                    return;
                }
                MagneticStormBulletType.mgs mgs2 = (MagneticStormBulletType.mgs)b;
                Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)80.0f, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id));
                if (b.time < 30.0f || target == null) {
                    b.initVel(b.rotation(), this.speed * 0.4f * Math.max(0.0f, 1.0f - b.fin() * 3.0f));
                } else {
                    b.initVel(b.angleTo((Position)target), this.speed);
                }
                for (int i = 0; i < 2; ++i) {
                    if (!Vars.headless) {
                        if (mgs2.trails[i] == null) {
                            mgs2.trails[i] = new Trail(22);
                        }
                        mgs2.trails[i].length = 22;
                    }
                    float dx = EUGet.dx(b.x, 5.0f, b.time * (8.0f - (i % 2 == 0 ? 0.6f : 0.0f)) + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(180 * i));
                    float dy = EUGet.dy(b.y, 5.0f, b.time * (8.0f - (i % 2 != 0 ? 0.6f : 0.0f)) + Mathf.randomSeed((long)b.id, (float)360.0f) + (float)(180 * i));
                    if (!Vars.headless) {
                        mgs2.trails[i].update(dx, dy, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
                    }
                    if (mgs2.vs[i] == null) continue;
                    mgs2.vs[i].set(dx, dy);
                }
                if (b.timer.get(2, 15.0f)) {
                    Groups.bullet.intersect(b.x - dsRange, b.y - dsRange, dsRange * 2.0f, dsRange * 2.0f, ob -> {
                        if (ob instanceof MagneticStormBulletType.mgs && ob.within((Position)b, dsRange) && ob.team == b.team && ob != b) {
                            float bdx = b.x + (float)Mathf.random((int)-4, (int)4);
                            float bdy = b.y + (float)Mathf.random((int)-4, (int)4);
                            lightningFade.create((Entityc)b, b.team, bdx, bdy, ob.angleTo(bdx, bdy) + 180.0f, -1.0f, 1.0f, 1.0f, ob);
                        }
                    });
                }
            }

            public void draw(Bullet b) {
                super.draw(b);
                float vel = Math.max(0.0f, b.vel.len() / this.speed);
                float out = b.time > b.lifetime - 12.0f ? (b.lifetime - b.time) / 12.0f : 1.0f;
                Draw.color((Color)this.trailColor);
                Drawf.tri((float)b.x, (float)b.y, (float)3.5f, (float)(6.5f * vel), (float)b.rotation());
                Fill.circle((float)b.x, (float)b.y, (float)(4.0f * (1.0f - vel) * out));
                if (!(b instanceof MagneticStormBulletType.mgs)) {
                    return;
                }
                MagneticStormBulletType.mgs mgs2 = (MagneticStormBulletType.mgs)b;
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                for (int i = 0; i < 2; ++i) {
                    if (msTl > 0 && mgs2.trails[i] != null) {
                        mgs2.trails[i].draw(i % 2 == 0 ? this.trailColor : Pal.surge, 1.2f * (1.0f - vel) * out);
                    }
                    if (mgs2.vs[i] == null) continue;
                    Draw.color((Color)(i % 2 == 0 ? this.trailColor : Pal.surge));
                    Fill.circle((float)mgs2.vs[i].x, (float)mgs2.vs[i].y, (float)(1.2f * (1.0f - vel) * out));
                }
                Draw.z((float)z);
            }

            public void drawTrail(Bullet b) {
                if (this.trailLength > 0 && b.trail != null) {
                    float z = Draw.z();
                    Draw.z((float)(z - 1.0E-4f));
                    b.trail.draw(this.trailColor, 2.9f);
                    Draw.z((float)z);
                }
            }

            public void init(Bullet b) {
                super.init(b);
                if (!(b instanceof MagneticStormBulletType.mgs)) {
                    return;
                }
                MagneticStormBulletType.mgs mgs2 = (MagneticStormBulletType.mgs)b;
                for (int i = 0; i < 2; ++i) {
                    mgs2.vs[i] = new Vec2();
                }
            }

            public boolean testCollision(Bullet bullet, Building tile) {
                return bullet.time > 30.0f && super.testCollision(bullet, tile);
            }

            @Nullable
            public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
                MagneticStormBulletType.mgs bullet = MagneticStormBulletType.mgs.create();
                for (int i = 0; i < 2; ++i) {
                    if (bullet.trails[i] == null) continue;
                    bullet.trails[i].clear();
                }
                return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
            }
        };
        foreshadowEUBullet = new BulletType(){
            {
                this.damage = 500.0f;
                this.splashDamage = 700.0f;
                this.splashDamageRadius = 72.0f;
                this.buildingDamageMultiplier = 0.25f;
                this.fragBullet = bit;
                this.fragBullets = 3;
                this.absorbable = false;
                this.hittable = false;
                this.intervalBullet = eBall;
                this.intervalBullets = 2;
                this.bulletInterval = 3.0f;
                this.intervalRandomSpread = 0.0f;
                this.intervalSpread = 180.0f;
                this.trailLength = 10;
                this.trailWidth = 5.0f;
                this.trailColor = EUItems.lightninAlloy.color.cpy();
                int[] side = new int[]{-8, 8};
                this.trailEffect = new Effect(30.0f, e -> {
                    Draw.color((Color)e.color);
                    for (int x : side) {
                        Tmp.v1.set((float)x, -3.0f).rotate(e.rotation - 90.0f);
                        Lines.stroke((float)(2.5f * e.foutpow()));
                        Lines.poly((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (int)6, (float)(5.0f * e.foutpow()), (float)(e.time * 5.0f));
                    }
                });
                this.trailRotation = true;
                this.trailInterval = 0.5f;
                this.speed = 30.0f;
                this.lifetime = 15.0f;
                this.status = EUStatusEffects.awsl;
                this.statusDuration = 30.0f;
                Effect e1 = new Effect(21.0f, e -> Angles.randLenVectors((long)e.id, (int)5, (float)(this.splashDamageRadius * e.finpow()), (float)e.rotation, (float)180.0f, (x, y) -> {
                    Lines.stroke((float)(3.0f * e.foutpow()), (Color)this.trailColor);
                    Lines.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)5.0f, (float)(Mathf.randomSeed((long)e.id, (float)360.0f) + Time.delta));
                }));
                Effect e2 = new Effect(50.0f, e -> {
                    Fx.rand.setSeed((long)e.id);
                    for (int i = 0; i < 5; ++i) {
                        float a = e.rotation + (float)Fx.rand.random(-60, 60);
                        Draw.color((Color)this.trailColor);
                        Drawf.tri((float)e.x, (float)e.y, (float)(21.0f * e.foutpow()), (float)((float)(150 + Fx.rand.random(-40, 40)) * e.foutpow()), (float)a);
                    }
                });
                ExplosionEffect e3 = new ExplosionEffect(){
                    {
                        this.smokes = 0;
                        this.lifetime = 30.0f;
                        this.sparkColor = trailColor.cpy().a(0.6f);
                        this.sparkLen = 7.0f;
                        this.sparks = 6;
                        this.waveColor = trailColor.cpy().mul(Pal.surge);
                        this.waveRad = splashDamageRadius;
                        this.waveLife = 9.0f;
                    }
                };
                this.hitEffect = this.despawnEffect = new MultiEffect(new Effect[]{e1, e2, e3});
            }

            public void draw(Bullet b) {
                super.draw(b);
                Draw.color((Color)this.trailColor);
                Drawf.tri((float)b.x, (float)b.y, (float)12.0f, (float)20.0f, (float)b.rotation());
                Drawf.tri((float)b.x, (float)b.y, (float)7.0f, (float)10.0f, (float)(b.rotation() - 90.0f));
                Drawf.tri((float)b.x, (float)b.y, (float)7.0f, (float)10.0f, (float)(b.rotation() + 90.0f));
            }

            public void drawTrail(Bullet b) {
                super.drawTrail(b);
                if (!(b instanceof RainbowStorm.rbs)) {
                    return;
                }
                RainbowStorm.rbs r = (RainbowStorm.rbs)b;
                if (this.trailLength > 0) {
                    for (int i = 0; i < 2; ++i) {
                        if (r.trails[i] == null) continue;
                        float z = Draw.z();
                        Draw.z((float)(z - 1.0E-4f));
                        r.trails[i].draw(this.trailColor, this.trailWidth * 0.5f);
                        Draw.z((float)z);
                    }
                }
            }

            public void updateTrail(Bullet b) {
                super.updateTrail(b);
                if (b instanceof RainbowStorm.rbs) {
                    RainbowStorm.rbs r = (RainbowStorm.rbs)b;
                    if (!Vars.headless && this.trailLength > 0) {
                        for (int i = 0; i < 2; ++i) {
                            if (r.trails[i] == null) {
                                r.trails[i] = new Trail((int)((double)this.trailLength / 1.2));
                            }
                            r.trails[i].length = (int)((double)this.trailLength / 1.2);
                            float dx = EUGet.txy(b.x, b.y, 12.0f, 5.0f, b.rotation() - 90.0f, b.time * 24.0f + (float)(i * 180), 0);
                            float dy = EUGet.txy(b.x, b.y, 12.0f, 5.0f, b.rotation() - 90.0f, b.time * 24.0f + (float)(i * 180), 1);
                            r.trails[i].update(dx, dy, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
                        }
                    }
                }
            }

            public void updateBulletInterval(Bullet b) {
                super.updateBulletInterval(b);
            }

            @Nullable
            public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
                RainbowStorm.rbs bullet = RainbowStorm.rbs.create();
                for (int i = 0; i < 2; ++i) {
                    if (bullet.trails[i] == null) continue;
                    bullet.trails[i].clear();
                }
                if (bullet.child.size > 0) {
                    bullet.child.clear();
                }
                return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
            }
        };
    }
}

