/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.effect;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Breaker
extends Block {
    public float timerBreak;
    public int maxsize;

    public Breaker(String name) {
        super(name);
        this.size = 1;
        this.rotate = true;
        this.drawArrow = false;
        this.destructible = true;
        this.solid = true;
        this.update = true;
        this.maxsize = 1;
        this.timerBreak = 300.0f;
        this.rebuildable = false;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Rect rect = Tmp.r1;
        rect.setCentered((float)x, (float)y, (float)(this.maxsize * 8));
        int len = 8 * this.maxsize;
        rect.x += (float)(Geometry.d4x((int)rotation) * len);
        rect.y += (float)(Geometry.d4y((int)rotation) * len);
        Drawf.dashRect((Color)(valid ? Pal.accent : Pal.remove), (Rect)rect);
    }

    public class BreakerBuild
    extends Building {
        public float Timer = 0.0f;

        public void updateTile() {
            Tile tile = Vars.world.tile(this.tileX() + Geometry.d4x((int)this.rotation), this.tileY() + Geometry.d4y((int)this.rotation));
            if (tile != null && tile.block() != null && tile.build == null && tile.block().solid && !tile.block().breakable && tile.block().size <= Breaker.this.maxsize) {
                this.Timer += Time.delta;
                if (this.Timer >= Breaker.this.timerBreak) {
                    Call.removeTile((Tile)tile);
                    this.kill();
                }
            }
        }

        public void draw() {
            super.draw();
            int s = Mathf.ceil((float)((Breaker.this.timerBreak - this.Timer) / 60.0f));
            String text = "|" + s + "|";
            Fonts.def.draw((CharSequence)text, this.x, this.y, Color.red, 0.35f, true, 1);
        }
    }
}

