/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.production;

import ExtraUtilities.ui.ItemDisplay;
import arc.Core;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class AdaptiveMining
extends Block {
    public DrawBlock drawer = new DrawDefault();
    public ObjectIntMap<Item> pullItem = new ObjectIntMap();
    public float outTime = 600.0f;

    public AdaptiveMining(String name) {
        super(name);
        this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawRegion("-rot", 3.0f, true), new DrawRegion("-top"), new DrawBlock(){

            public TextureRegion[] icons(Block block) {
                return new TextureRegion[]{Core.atlas.find(block.name + "-team")};
            }
        }});
        this.solid = true;
        this.update = true;
        this.sync = true;
        this.canOverdrive = false;
    }

    public void setStats() {
        this.stats.timePeriod = this.outTime;
        super.setStats();
        this.stats.add(Stat.productionTime, this.outTime / 60.0f, StatUnit.seconds);
        this.stats.add(Stat.output, table -> {
            table.row();
            int i = 0;
            for (Item item : this.pullItem.keys()) {
                table.add((Element)new ItemDisplay(item)).padRight(5.0f);
                if (i != this.pullItem.size - 1) {
                    table.add((CharSequence)"/");
                }
                ++i;
            }
        });
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (!this.coreNearby(x, y, Vars.player.team())) {
            this.drawPlaceText(Core.bundle.get("place.needCore"), x, y, valid);
        }
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        short x = tile.x;
        short y = tile.y;
        return this.coreNearby(x, y, team);
    }

    public boolean coreNearby(int x, int y, Team team) {
        int cornerX = x - (this.size - 1) / 2;
        int cornerY = y - (this.size - 1) / 2;
        int s = this.size;
        for (int i = 0; i < this.size; ++i) {
            int rx = 0;
            int ry = 0;
            rx = cornerX + s;
            ry = cornerY + i;
            Tile other = Vars.world.tile(rx, ry);
            if (other != null && other.build != null && other.build instanceof CoreBlock.CoreBuild && other.build.team == team) {
                return true;
            }
            rx = cornerX + i;
            ry = cornerY + s;
            other = Vars.world.tile(rx, ry);
            if (other != null && other.build != null && other.build instanceof CoreBlock.CoreBuild && other.build.team == team) {
                return true;
            }
            rx = cornerX - 1;
            ry = cornerY + i;
            other = Vars.world.tile(rx, ry);
            if (other != null && other.build != null && other.build instanceof CoreBlock.CoreBuild && other.build.team == team) {
                return true;
            }
            rx = cornerX + i;
            ry = cornerY - 1;
            other = Vars.world.tile(rx, ry);
            if (other == null || other.build == null || !(other.build instanceof CoreBlock.CoreBuild) || other.build.team != team) continue;
            return true;
        }
        return false;
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public TextureRegion[] icons() {
        TextureAtlas.AtlasRegion rf = Core.atlas.find(this.name);
        if (rf.found()) {
            return new TextureRegion[]{rf};
        }
        return this.drawer.finalIcons((Block)this);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    public class AdaptiveMiningBuild
    extends Building {
        public float rot = 0.0f;
        public float work = 0.0f;
        public ObjectIntMap<Item> ruleCopy = new ObjectIntMap();

        public void updateTile() {
            float f;
            if (!this.nearbyCore()) {
                return;
            }
            this.rot += Time.delta;
            if (Vars.net.client()) {
                return;
            }
            for (Item item : AdaptiveMining.this.pullItem.keys()) {
                if (!item.isOnPlanet(Vars.state.getPlanet()) || item.isHidden() || Vars.state.isCampaign() && !item.unlocked()) continue;
                this.ruleCopy.put((Object)item, AdaptiveMining.this.pullItem.get((Object)item));
            }
            int sum = 0;
            for (Item item : this.ruleCopy.keys()) {
                sum += this.ruleCopy.get((Object)item);
            }
            if (sum <= 0) {
                return;
            }
            this.work += Time.delta;
            if (f > AdaptiveMining.this.outTime) {
                this.work -= AdaptiveMining.this.outTime;
                int i = Mathf.random((int)0, (int)(sum - 1));
                int count = 0;
                Item item = null;
                for (Item out : this.ruleCopy.keys()) {
                    if (i >= count && i < count + this.ruleCopy.get((Object)out)) {
                        item = out;
                        break;
                    }
                    count += this.ruleCopy.get((Object)out);
                }
                this.core().handleItem((Building)this, item);
            }
        }

        public boolean nearbyCore() {
            for (int i = 0; i < this.proximity.size; ++i) {
                Object object = this.proximity.get(i);
                if (!(object instanceof CoreBlock.CoreBuild)) continue;
                CoreBlock.CoreBuild cb = (CoreBlock.CoreBuild)object;
                if (cb.team != this.team) continue;
                return true;
            }
            return false;
        }

        public float totalProgress() {
            return this.rot;
        }

        public void draw() {
            AdaptiveMining.this.drawer.draw((Building)this);
            this.drawTeamTop();
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.rot);
            write.f(this.work);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.rot = read.f();
            this.work = read.f();
        }
    }
}

