/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.meta.TurretManager;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.meta.Stat;

public class Cobweb
extends TractorBeamTurret {
    public int webAmount = 8;
    public float webRange = 80.0f;
    public TurretManager manager = new TurretManager();
    public float coolantMulti = 1.0f;

    public Cobweb(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        if (this.damage > 0.0f) {
            this.stats.remove(Stat.damage);
            this.stats.add(Stat.damage, Strings.autoFixed((float)(this.damage * 60.0f), (int)2) + "/s " + ExtraUtilitiesMod.toText("bullet.armorpierce") + "[] " + Strings.autoFixed((float)(this.damage / 2.0f * 60.0f), (int)2) + "/s " + ExtraUtilitiesMod.toText("bullet.armorpierce") + "[]", new Object[0]);
        }
    }

    public class CobwebBuild
    extends TractorBeamTurret.TractorBeamBuild {
        public Seq<Unit> webs;
        public float rotTimer;
        public float cod;

        public CobwebBuild() {
            super((TractorBeamTurret)Cobweb.this);
            this.webs = new Seq();
            this.rotTimer = 0.0f;
            this.cod = 1.0f;
        }

        public void updateTile() {
            float eff = this.efficiency * this.cod;
            float edelta = eff * this.delta();
            this.rotTimer += edelta;
            if (this.timer(Cobweb.this.timerTarget, Cobweb.this.retargetTime / (this.power.status + 1.0E-4f))) {
                Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)Cobweb.this.range, u -> {
                    if (u.targetable(this.team) && !u.inFogTo(this.team)) {
                        Cobweb.this.manager.addEnemy((Unit)u);
                    }
                });
                Cobweb.this.manager.addTurret(this);
                Cobweb.this.manager.update();
            }
            if (this.target != null && Cobweb.this.coolant != null) {
                float maxUsed = Cobweb.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(Math.min(this.liquids.get(liquid), maxUsed * Time.delta), Math.max(0.0f, 1.0f / this.coolantMultiplier / liquid.heatCapacity));
                this.liquids.remove(liquid, used);
                if (Mathf.chance((double)(0.06 * (double)used))) {
                    Cobweb.this.coolEffect.at(this.x + Mathf.range((float)((float)(Cobweb.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(Cobweb.this.size * 8) / 2.0f)));
                }
                this.cod = 1.0f + used * liquid.heatCapacity * Cobweb.this.coolantMulti;
            }
            this.any = false;
            if (this.target != null && this.target.within((Position)this, Cobweb.this.range + this.target.hitSize / 2.0f) && this.target.team() != this.team && this.target.checkTarget(Cobweb.this.targetAir, Cobweb.this.targetGround) && this.efficiency > 0.02f) {
                if (!Vars.headless) {
                    Vars.control.sound.loop(Cobweb.this.shootSound, (Position)this, Cobweb.this.shootSoundVolume);
                }
                float dest = this.angleTo((Position)this.target);
                this.rotation = Angles.moveToward((float)this.rotation, (float)dest, (float)(Cobweb.this.rotateSpeed * edelta));
                this.lastX = this.target.x;
                this.lastY = this.target.y;
                this.strength = Mathf.lerpDelta((float)this.strength, (float)1.0f, (float)0.1f);
                if (Angles.within((float)this.rotation, (float)dest, (float)Cobweb.this.shootCone)) {
                    if (Cobweb.this.damage > 0.0f) {
                        this.target.damageContinuousPierce(Cobweb.this.damage * eff * Vars.state.rules.blockDamage(this.team));
                    }
                    if (Cobweb.this.status != StatusEffects.none) {
                        this.target.apply(Cobweb.this.status, Cobweb.this.statusDuration);
                    }
                    this.any = true;
                    this.target.vel.limit(0.5f / Math.max(1.0E-4f, edelta));
                    this.web();
                }
            } else {
                this.strength = Mathf.lerpDelta((float)this.strength, (float)0.0f, (float)0.1f);
            }
        }

        public void web() {
            float eff = this.efficiency * this.cod;
            float edelta = eff * this.delta();
            this.webs.clear();
            Units.nearbyEnemies((Team)this.team, (float)this.target.x, (float)this.target.y, (float)Cobweb.this.webRange, u -> {
                if (u != this.target && u.targetable(this.team) && !u.inFogTo(this.team) && this.webs.size < Cobweb.this.webAmount) {
                    this.webs.add(u);
                }
            });
            this.webs.removeAll(u -> !this.target.within((Position)u, Cobweb.this.webRange));
            this.webs.sort(u -> u.dst((Position)this.target));
            if (this.webs.size > 0) {
                for (Unit u2 : this.webs) {
                    if (u2 == null || this.target == null) continue;
                    if (Cobweb.this.damage > 0.0f) {
                        u2.damageContinuousPierce(Cobweb.this.damage / 2.0f * eff * Vars.state.rules.blockDamage(this.team));
                    }
                    if (Cobweb.this.status != StatusEffects.none) {
                        u2.apply(Cobweb.this.status, Cobweb.this.statusDuration);
                    }
                    u2.vel.limit(0.5f / Math.max(1.0E-4f, edelta));
                    u2.impulseNet(Tmp.v1.set((Position)this.target).sub((Position)u2).limit((Cobweb.this.force + (1.0f - u2.dst((Position)this.target) / Cobweb.this.range) * Cobweb.this.scaledForce) * edelta));
                }
            }
        }

        public void updateTarget(Seq<Unit> enemies, Seq<Unit> lockedEnemies) {
            float realRange = Cobweb.this.range * this.power.status;
            this.target = null;
            for (Unit enemy : enemies) {
                if (!this.within((Position)enemy, realRange) || lockedEnemies.contains((Object)enemy)) continue;
                this.target = enemy;
                break;
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)Cobweb.this.baseRegion, (float)this.x, (float)this.y);
            Drawf.shadow((TextureRegion)Cobweb.this.region, (float)(this.x - (float)Cobweb.this.size / 2.0f), (float)(this.y - (float)Cobweb.this.size / 2.0f), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)Cobweb.this.region, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
            if (this.any) {
                Draw.z((float)100.0f);
                float ang = this.angleTo(this.lastX, this.lastY);
                Draw.mixcol((Color)Cobweb.this.laserColor, (float)Mathf.absin((float)4.0f, (float)0.6f));
                Drawf.laser((TextureRegion)Cobweb.this.laser, (TextureRegion)Cobweb.this.laserStart, (TextureRegion)Cobweb.this.laserEnd, (float)(this.x + Angles.trnsx((float)ang, (float)Cobweb.this.shootLength)), (float)(this.y + Angles.trnsy((float)ang, (float)Cobweb.this.shootLength)), (float)this.lastX, (float)this.lastY, (float)(this.strength * this.efficiency * Cobweb.this.laserWidth));
                if (this.target != null) {
                    for (int i = 0; i < Cobweb.this.webAmount; ++i) {
                        float a = 360.0f / (float)Cobweb.this.webAmount * (float)i + this.rotTimer * 1.5f;
                        float lx = EUGet.dx(this.target.x, Cobweb.this.webRange * this.strength, a);
                        float ly = EUGet.dy(this.target.y, Cobweb.this.webRange * this.strength, a);
                        if (i <= this.webs.size - 1) {
                            Unit u = (Unit)this.webs.get(i);
                            if (u == null) continue;
                            Drawf.laser((TextureRegion)Cobweb.this.laser, (TextureRegion)Cobweb.this.laserStart, (TextureRegion)Cobweb.this.laserEnd, (float)this.target.x, (float)this.target.y, (float)u.x, (float)u.y, (float)(this.strength * this.efficiency * Cobweb.this.laserWidth * 0.5f));
                            continue;
                        }
                        Drawf.laser((TextureRegion)Cobweb.this.laser, (TextureRegion)Cobweb.this.laserStart, (TextureRegion)Cobweb.this.laserEnd, (float)this.target.x, (float)this.target.y, (float)lx, (float)ly, (float)(this.strength * this.efficiency * Cobweb.this.laserWidth * 0.5f));
                    }
                }
                Draw.mixcol();
            }
        }
    }
}

