/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Entityc;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MultiShootTurret
extends ItemTurret {
    public int perShoot = 3;
    public int shots = 1;
    public TextureRegion[] heats;

    public MultiShootTurret(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.reload);
        this.stats.add(Stat.reload, 60.0f / this.reload * (float)(this.shoot.shots + this.perShoot), StatUnit.none);
    }

    public class MultiShootTurretBuild
    extends ItemTurret.ItemTurretBuild {
        float[] perHeat;

        public MultiShootTurretBuild() {
            super((ItemTurret)MultiShootTurret.this);
            this.perHeat = new float[MultiShootTurret.this.shots];
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            super.bullet(type, xOffset, yOffset, angleOffset, mover);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)MultiShootTurret.this.shootX, (float)MultiShootTurret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)MultiShootTurret.this.shootX, (float)MultiShootTurret.this.shootY);
            for (int i = 0; i < MultiShootTurret.this.perShoot; ++i) {
                float shootAngle = this.rotation + angleOffset + Mathf.range((float)(MultiShootTurret.this.inaccuracy + type.inaccuracy));
                float lifeScl = type.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y) / type.range), (float)(MultiShootTurret.this.minRange / type.range), (float)(this.range() / type.range)) : 1.0f;
                this.handleBullet(type.create((Entityc)this, this.team, bulletX, bulletY, shootAngle, -1.0f, 1.0f - MultiShootTurret.this.velocityRnd + Mathf.random((float)MultiShootTurret.this.velocityRnd), lifeScl, null, mover, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            }
        }

        public void updateTile() {
            super.updateTile();
            for (int i = 0; i < MultiShootTurret.this.shots; ++i) {
                this.perHeat[i] = Mathf.approachDelta((float)this.perHeat[i], (float)0.0f, (float)(1.0f / MultiShootTurret.this.cooldownTime));
            }
        }

        public void draw() {
            super.draw();
            float i = this.totalShots % MultiShootTurret.this.shots;
            this.perHeat[(int)i] = this.heat;
            for (int c = 0; c < MultiShootTurret.this.shots; ++c) {
                if ((double)this.perHeat[c] <= 1.0E-5) continue;
                Draw.color((Color)MultiShootTurret.this.heatColor, (float)this.perHeat[c]);
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)Core.atlas.find(MultiShootTurret.this.name + "-heat-" + c), (float)(this.x + this.recoilOffset.x), (float)(this.y + this.recoilOffset.y), (float)(this.rotation - 90.0f));
            }
            Draw.blend();
            Draw.color();
        }
    }
}

