/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class TurretResupplyPoint
extends Block {
    public float range = 64.0f;

    public TurretResupplyPoint(String name) {
        super(name);
        this.configurable = true;
        this.saveConfig = true;
        this.solid = true;
        this.update = true;
        this.noUpdateDisabled = true;
        this.clearOnDoubleTap = true;
        this.hasItems = true;
        this.itemCapacity = 1;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public class TurretResupplyPointBuild
    extends Building {
        public Item sortItem = null;

        public void updateTile() {
            Vars.indexer.eachBlock((Teamc)this, TurretResupplyPoint.this.range, b -> b.block instanceof Turret && b.block.hasItems, b -> {
                if ((!TurretResupplyPoint.this.hasPower || (double)this.power.status > 0.999) && this.sortItem != null && this.items.get(this.sortItem) > 0 && b.acceptItem((Building)this, this.sortItem)) {
                    b.handleItem((Building)this, this.sortItem);
                    Fx.itemTransfer.at(this.x, this.y, 2.0f, this.sortItem.color, b);
                    this.items.clear();
                }
            });
        }

        public void draw() {
            super.draw();
            Draw.color((Color)(this.sortItem == null ? Color.clear : this.sortItem.color));
            Draw.rect((TextureRegion)Core.atlas.find("unloader-center"), (float)this.x, (float)this.y);
            Draw.color();
        }

        public void drawConfigure() {
            super.drawConfigure();
            Vars.indexer.eachBlock((Teamc)this, TurretResupplyPoint.this.range, b -> b.block instanceof Turret && b.block.hasItems, b -> {
                if (this.sortItem != null && b.acceptItem((Building)this, this.sortItem)) {
                    Drawf.square((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f + 1.0f), (Color)this.sortItem.color);
                }
            });
            Drawf.dashCircle((float)this.x, (float)this.y, (float)TurretResupplyPoint.this.range, (Color)Pal.accent);
        }

        public boolean acceptItem(Building source, Item item) {
            return item == this.sortItem && this.items.get(item) < 1;
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)TurretResupplyPoint.this, (Table)table, (Seq)Vars.content.items(), () -> this.sortItem, arg_0 -> ((TurretResupplyPointBuild)this).configure(arg_0));
        }

        public Item config() {
            return this.sortItem;
        }

        public BlockStatus status() {
            return !TurretResupplyPoint.this.hasPower || (double)this.power.status > 0.999 ? BlockStatus.active : BlockStatus.noInput;
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortItem = id == -1 ? null : Vars.content.item((int)id);
        }
    }
}

