/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.worlds.blocks.turret.TurretResupplyPoint;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;

public class TurretSpeeder
extends TurretResupplyPoint {
    public float reload = 60.0f;
    public float speedBoost = 1.5f;
    public Color baseColor = Color.valueOf((String)"feb380");

    public TurretSpeeder(String name) {
        super(name);
        this.range = 104.0f;
        this.canOverdrive = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speedIncrease, "+" + (int)(this.speedBoost * 100.0f - 100.0f) + "%", new Object[0]);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Drawf.dashSquare((Color)this.baseColor, (float)x, (float)y, (float)this.range);
        Vars.indexer.eachBlock(Vars.player.team(), Tmp.r1.setCentered((float)x, (float)y, this.range), b -> b instanceof Turret.TurretBuild && b.block.canOverdrive, t -> Drawf.selected((Building)t, (Color)Tmp.c1.set(this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f))));
    }

    public class TurretSpeederBuild
    extends TurretResupplyPoint.TurretResupplyPointBuild {
        public float heat;
        public float charge;
        public float smoothEfficiency;

        public TurretSpeederBuild() {
            this.charge = Mathf.random((float)TurretSpeeder.this.reload);
        }

        @Override
        public void updateTile() {
            Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, TurretSpeeder.this.range), b -> b.block instanceof Turret && b.block.hasItems, b -> {
                if ((!TurretSpeeder.this.hasPower || (double)this.power.status > 0.999) && this.sortItem != null && this.items.get(this.sortItem) > 0 && b.acceptItem((Building)this, this.sortItem)) {
                    b.handleItem((Building)this, this.sortItem);
                    Fx.itemTransfer.at(this.x, this.y, 2.0f, this.sortItem.color, b);
                    this.items.clear();
                }
            });
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.08f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)(this.efficiency > 0.0f ? 1.0f : 0.0f), (float)0.08f);
            this.charge += this.heat * Time.delta;
            if (this.charge >= TurretSpeeder.this.reload) {
                this.charge = 0.0f;
                Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, TurretSpeeder.this.range), other -> other instanceof Turret.TurretBuild && other.block.canOverdrive, other -> other.applyBoost(TurretSpeeder.this.speedBoost * this.efficiency, TurretSpeeder.this.reload + 1.0f));
            }
        }

        @Override
        public void draw() {
            super.draw();
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color((Color)TurretSpeeder.this.baseColor);
            Draw.alpha((float)(this.heat * Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
            Draw.rect((TextureRegion)Core.atlas.find(TurretSpeeder.this.name + "-top"), (float)this.x, (float)this.y);
            Draw.alpha((float)1.0f);
            Lines.stroke((float)((2.0f * f + 0.1f) * this.heat));
            float r = Math.max(0.0f, Mathf.clamp((float)(2.0f - f * 2.0f)) * (float)TurretSpeeder.this.size * 8.0f / 2.0f - f - 0.2f);
            float w = Mathf.clamp((float)(0.5f - f)) * (float)TurretSpeeder.this.size * 8.0f;
            Lines.beginLine();
            for (int i = 0; i < 4; ++i) {
                Lines.linePoint((float)(this.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w), (float)(this.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w));
                if (!(f < 0.5f)) continue;
                Lines.linePoint((float)(this.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w), (float)(this.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w));
            }
            Lines.endLine((boolean)true);
            Draw.reset();
        }

        @Override
        public void drawConfigure() {
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Lines.square((float)this.x, (float)this.y, (float)((float)(this.block.size * 8) / 2.0f + 1.0f));
            Draw.reset();
            Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, TurretSpeeder.this.range), b -> b.block instanceof Turret && b.block.hasItems, b -> {
                if (this.sortItem != null && b.acceptItem((Building)this, this.sortItem)) {
                    Drawf.square((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f + 1.0f), (Color)this.sortItem.color);
                }
            });
        }

        public void drawSelect() {
            Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, TurretSpeeder.this.range), other -> other instanceof Turret.TurretBuild && other.block.canOverdrive, other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(TurretSpeeder.this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f))));
            Drawf.dashSquare((Color)TurretSpeeder.this.baseColor, (float)this.x, (float)this.y, (float)TurretSpeeder.this.range);
        }

        @Override
        public BlockStatus status() {
            if (!this.enabled) {
                return BlockStatus.logicDisable;
            }
            if (!this.shouldConsume()) {
                return BlockStatus.noOutput;
            }
            if (!(this.efficiency <= 0.0f) && this.productionValid()) {
                return Vars.state.tick / 30.0 % 1.0 < (double)this.efficiency ? BlockStatus.active : BlockStatus.noInput;
            }
            return BlockStatus.noInput;
        }
    }
}

