/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;

public class AimPart
extends DrawPart {
    public Color color;
    public float x;
    public float y;
    public float rt;
    public float length;
    public float spacing;
    public float width;
    public float layer;
    public boolean drawLine = true;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.reload;
    public DrawPart.PartProgress warmup = DrawPart.PartProgress.warmup;
    public TextureRegion aim;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        Draw.color((Color)this.color);
        Draw.z((float)this.layer);
        float wp = this.warmup.getClamp(params);
        float fout = 1.0f - this.progress.getClamp(params);
        float track = Mathf.curve((float)fout, (float)0.0f, (float)0.25f) * Mathf.curve((float)fout, (float)0.0f, (float)0.3f) * fout;
        if (wp < 1.0E-4f) {
            return;
        }
        Tmp.v1.set(this.x, this.y).rotate(params.rotation - 90.0f);
        float px = params.x + Tmp.v1.x;
        float py = params.y + Tmp.v1.y;
        int i = 0;
        while ((float)i <= this.length / this.spacing) {
            Tmp.v1.trns(params.rotation + this.rt, (float)i * this.spacing);
            float f = Interp.pow3Out.apply(Mathf.clamp((float)((fout * this.length - (float)i * this.spacing) / this.spacing))) * (0.6f + track * 0.4f) * wp;
            Draw.rect((TextureRegion)this.aim, (float)(px + Tmp.v1.x), (float)(py + Tmp.v1.y), (float)(120.0f * Draw.scl * f), (float)(120.0f * Draw.scl * f), (float)(params.rotation - 90.0f + this.rt));
            ++i;
        }
        if (!this.drawLine) {
            return;
        }
        Tmp.v1.trns(params.rotation + this.rt, 0.0f, (2.0f - track) * 8.0f * this.width);
        Lines.stroke((float)(track * 2.0f * wp));
        for (int i2 : Mathf.signs) {
            Lines.lineAngle((float)(px + Tmp.v1.x * (float)i2), (float)(py + Tmp.v1.y * (float)i2), (float)(params.rotation + this.rt), (float)(this.length * (0.75f + track / 4.0f) * Mathf.curve((float)fout, (float)0.0f, (float)0.1f)));
        }
        Draw.reset();
        Draw.z((float)z);
    }

    public void load(String s) {
        this.aim = Core.atlas.find(ExtraUtilitiesMod.name("aim-shoot"));
    }
}

