/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUItems;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class BowHalo
extends DrawPart {
    public float x = 0.0f;
    public float y = -25.0f;
    public float stroke = 4.0f;
    public float radius = 12.0f;
    public Color color;
    public float rotateSpeed;
    public float w1;
    public float h1;
    public float w2;
    public float h2;
    public float layer;
    public DrawPart.PartProgress progress;
    public boolean sinWave;
    public boolean rotAb;

    public BowHalo() {
        this.color = EUItems.lightninAlloy.color;
        this.rotateSpeed = 1.0f;
        this.w1 = 3.0f;
        this.h1 = 6.0f;
        this.w2 = 4.0f;
        this.h2 = 18.0f;
        this.layer = 110.0f;
        this.progress = DrawPart.PartProgress.warmup.delay(0.5f);
        this.sinWave = true;
        this.rotAb = true;
    }

    public void draw(DrawPart.PartParams params) {
        float warmup = this.progress.getClamp(params);
        Lines.stroke((float)(this.stroke * warmup));
        float sin = Mathf.absin((float)Time.time, (float)10.0f, (float)1.5f);
        float realR = this.radius + (this.sinWave ? sin : 0.0f);
        float rot = params.rotation - 90.0f;
        float bx = params.x;
        float by = params.y;
        Draw.z((float)this.layer);
        Draw.color((Color)this.color);
        Tmp.v1.set(this.x, this.y).rotate(rot);
        float px = bx + Tmp.v1.x;
        float py = by + Tmp.v1.y;
        Lines.circle((float)px, (float)py, (float)realR);
        for (int i = 0; i < 2; ++i) {
            float angle = (float)i * 360.0f / 2.0f + (this.rotAb ? rot : 0.0f);
            Drawf.tri((float)(px + Angles.trnsx((float)(angle - Time.time * this.rotateSpeed), (float)realR)), (float)(py + Angles.trnsy((float)(angle - Time.time * this.rotateSpeed), (float)realR)), (float)this.w1, (float)(this.h1 * warmup), (float)(angle - Time.time * this.rotateSpeed));
            Drawf.tri((float)(px + Angles.trnsx((float)angle, (float)realR)), (float)(py + Angles.trnsy((float)angle, (float)realR)), (float)this.w2, (float)(this.h2 * warmup), (float)angle);
        }
        Draw.reset();
    }

    public void load(String name) {
    }
}

