/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.worlds.blocks.liquid.LiquidMassDriver;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawLiquidDriver
extends DrawBlock {
    public TextureRegion base;
    public TextureRegion region;
    public TextureRegion bottom;
    public TextureRegion liquid;
    public TextureRegion top;

    public void load(Block block) {
        this.base = Core.atlas.find(block.name + "-base");
        this.region = Core.atlas.find(block.name + "-region");
        this.bottom = Core.atlas.find(block.name + "-bottom");
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.base, this.bottom, this.region, this.top};
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.base, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.bottom, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.top, (float)plan.drawx(), (float)plan.drawy());
    }

    public void draw(Building build) {
        LiquidMassDriver block = (LiquidMassDriver)build.block;
        LiquidMassDriver.LiquidMassDriverBuild b = (LiquidMassDriver.LiquidMassDriverBuild)build;
        this.drawDriver(block, b);
    }

    public void drawDriver(LiquidMassDriver block, LiquidMassDriver.LiquidMassDriverBuild build) {
        Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
        Draw.z((float)50.0f);
        Drawf.shadow((TextureRegion)this.region, (float)(build.x + Angles.trnsx((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback)) - (float)block.size / 2.0f), (float)(build.y + Angles.trnsy((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback)) - (float)block.size / 2.0f), (float)(build.rotation - 90.0f));
        Draw.rect((TextureRegion)this.bottom, (float)(build.x + Angles.trnsx((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.y + Angles.trnsy((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.rotation - 90.0f));
        Draw.color((Color)build.liquids.current().color);
        Draw.alpha((float)Math.min(build.liquidTotal() / block.liquidCapacity, 1.0f));
        Draw.rect((TextureRegion)this.liquid, (float)(build.x + Angles.trnsx((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.y + Angles.trnsy((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.rotation - 90.0f));
        Draw.color();
        Draw.rect((TextureRegion)this.region, (float)(build.x + Angles.trnsx((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.y + Angles.trnsy((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.rotation - 90.0f));
        Draw.alpha((float)1.0f);
        Draw.rect((TextureRegion)this.top, (float)(build.x + Angles.trnsx((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.y + Angles.trnsy((float)(build.rotation + 180.0f), (float)(build.reloadCounter * block.knockback))), (float)(build.rotation - 90.0f));
    }
}

