/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.worlds.blocks.distribution.PhaseNode;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawPhaseNode
extends DrawBlock {
    public TextureRegion bridgeRegion;
    public TextureRegion endRegion;

    public void draw(Building build) {
        if (!(build instanceof PhaseNode.PhaseNodeBuild)) {
            return;
        }
        this.drawR((PhaseNode.PhaseNodeBuild)build);
    }

    public void drawR(PhaseNode.PhaseNodeBuild build) {
        Draw.z((float)70.0f);
        Building other = Vars.world.build(build.link);
        if (other == null) {
            return;
        }
        float op = (float)Core.settings.getInt("bridgeopacity") / 100.0f;
        if (Mathf.zero((float)op)) {
            return;
        }
        Draw.color((Color)Color.white);
        if (build.block.hasPower) {
            Draw.alpha((float)(Math.max(build.power.status, 0.25f) * op));
        } else {
            Draw.alpha((float)op);
        }
        Draw.rect((TextureRegion)this.endRegion, (float)build.x, (float)build.y);
        Draw.rect((TextureRegion)this.endRegion, (float)other.x, (float)other.y);
        Lines.stroke((float)8.0f);
        Tmp.v1.set(build.x, build.y).sub(other.x, other.y).setLength(4.0f).scl(-1.0f);
        Lines.line((TextureRegion)this.bridgeRegion, (float)build.x, (float)build.y, (float)other.x, (float)other.y, (boolean)false);
        Draw.reset();
    }

    public void load(Block block) {
        this.bridgeRegion = Core.atlas.find(block.name + "-bridge");
        this.endRegion = Core.atlas.find(block.name + "-end");
    }
}

