/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class LingShaPart
extends DrawPart {
    public TextureRegion star;
    public TextureRegion starBig;
    public Color color = Color.valueOf((String)"#f7d7fc");
    public float wx;
    public float wy;
    public DrawPart.PartProgress progressWarmup = DrawPart.PartProgress.warmup;

    public void draw(DrawPart.PartParams params) {
        float warmup = this.progressWarmup.getClamp(params);
        if (warmup < 1.0E-4f) {
            return;
        }
        float z = Draw.z();
        Draw.z((float)110.0f);
        Draw.color((Color)Tmp.c4.set(this.color).a(warmup));
        float rot = params.rotation - 90.0f;
        float ax = params.x + Angles.trnsx((float)rot, (float)this.wx, (float)this.wy);
        float ay = params.y + Angles.trnsy((float)rot, (float)this.wx, (float)this.wy);
        Draw.rect((TextureRegion)this.star, (float)ax, (float)ay, (float)24.0f, (float)24.0f, (float)(rot * 2.0f));
        Draw.rect((TextureRegion)this.starBig, (float)ax, (float)ay, (float)24.0f, (float)24.0f, (float)(-rot));
        Draw.color((Color)this.color);
        float tz = 49.0f;
        Draw.z((float)(tz + (110.0f - tz) * (warmup < 0.6f ? 0.0f : warmup)));
        for (int i : Mathf.signs) {
            float wax = params.x + Angles.trnsx((float)rot, (float)(8 * i), (float)1.0f);
            float way = params.y + Angles.trnsy((float)rot, (float)(8 * i), (float)1.0f);
            float ag = rot + (float)(90 * i) - 90.0f;
            float ex = EUGet.dx(wax, 9.0f * warmup, ag - 4.0f * warmup * (float)i);
            float ey = EUGet.dy(way, 9.0f * warmup, ag - 4.0f * warmup * (float)i);
            Drawf.tri((float)ex, (float)ey, (float)(3.0f * warmup), (float)(22.0f * warmup), (float)ag);
            ex = EUGet.dx(wax, 9.0f * warmup, ag - 8.0f * warmup * (float)i);
            ey = EUGet.dy(way, 9.0f * warmup, ag - 8.0f * warmup * (float)i);
            Drawf.tri((float)ex, (float)ey, (float)(3.0f * warmup), (float)22.0f, (float)(ag - 8.0f * warmup * (float)i + (float)(90 * i)));
            ex = EUGet.dx(wax, 9.0f * warmup, ag - 16.0f * warmup * (float)i);
            ey = EUGet.dy(way, 9.0f * warmup, ag - 16.0f * warmup * (float)i);
            Drawf.tri((float)ex, (float)ey, (float)(4.0f * warmup), (float)22.0f, (float)(ag - 24.0f * warmup * (float)i + (float)(90 * i)));
            Drawf.tri((float)ex, (float)ey, (float)(4.0f * warmup), (float)5.0f, (float)(ag + 180.0f - 24.0f * warmup * (float)i + (float)(90 * i)));
        }
        Draw.z((float)z);
        Draw.reset();
    }

    public void load(String name) {
        this.star = Core.atlas.find(ExtraUtilitiesMod.name("halo-small"));
        this.starBig = Core.atlas.find(ExtraUtilitiesMod.name("halo"));
    }
}

