/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUItems;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawBlock;

public class RunningLight
extends DrawBlock {
    public int size;
    public TextureRegion[] regions;
    public Color color;
    public boolean contrary;

    public RunningLight(int size) {
        this.color = EUItems.lightninAlloy.color;
        this.contrary = true;
        this.size = size;
        this.regions = new TextureRegion[size];
    }

    public void load(Block block) {
        for (int i = 0; i < this.size; ++i) {
            int ci = this.size - 1 - i;
            this.regions[i] = !this.contrary ? Core.atlas.find(block.name + "-glow-" + i) : Core.atlas.find(block.name + "-glow-" + ci);
        }
    }

    public void draw(Building build) {
        for (int i = 0; i < this.size; ++i) {
            float sin = Mathf.absin((float)(Time.time + (float)i * (60.0f / (float)this.size)), (float)6.0f, (float)1.0f);
            float a = sin * build.warmup();
            Draw.color((Color)this.color.cpy().a(a));
            if (build instanceof Turret.TurretBuild) {
                Draw.rect((TextureRegion)this.regions[i], (float)(build.x + ((Turret.TurretBuild)build).recoilOffset.x), (float)(build.y + ((Turret.TurretBuild)build).recoilOffset.y), (float)build.drawrot());
                continue;
            }
            Draw.rect((TextureRegion)this.regions[i], (float)build.x, (float)build.y, (float)build.drawrot());
        }
        Draw.reset();
    }
}

