/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUStatusEffects;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.entities.Damage;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Unit;

public class TerritoryFieldAbility
extends Ability {
    public float range;
    public float healAm;
    public float damageAm;
    public float reload = 90.0f;
    public boolean active = true;
    public boolean open = false;
    public float applyParticleChance = 13.0f;
    protected float timer;

    public TerritoryFieldAbility(float range, float healAm, float damageAm) {
        this.range = range;
        this.healAm = healAm;
        this.damageAm = damageAm;
    }

    public String localized() {
        String re = Core.bundle.format("ability." + ExtraUtilitiesMod.name("TerritoryFieldAbility"), new Object[]{Float.valueOf(this.range / 8.0f)});
        if (this.healAm > 0.0f) {
            re = re + Core.bundle.format("ability." + ExtraUtilitiesMod.name("TerritoryFieldAbilityHeal"), new Object[]{Float.valueOf(this.healAm)});
        }
        if (this.damageAm > 0.0f) {
            re = re + Core.bundle.format("ability." + ExtraUtilitiesMod.name("TerritoryFieldAbilityDamage"), new Object[]{Float.valueOf(this.damageAm)});
        }
        if (this.active) {
            re = re + Core.bundle.get("ability.extra-utilities-TerritoryFieldAbilitySuppression");
        }
        return re;
    }

    public void update(Unit unit) {
        float f;
        Units.nearby((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, u -> {
            if (u != unit) {
                u.apply(EUStatusEffects.speedUp, 60.0f);
                if (this.healAm > 0.0f && !u.dead && u.health < u.maxHealth) {
                    u.heal(this.healAm / 60.0f * Time.delta);
                }
            }
        });
        Units.nearbyEnemies((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, u -> {
            if (!u.inFogTo(unit.team) && u.targetable(unit.team)) {
                u.apply(EUStatusEffects.speedDown, 60.0f);
                if (this.damageAm > 0.0f && !u.dead) {
                    u.damage(this.damageAm / 60.0f * Time.delta);
                }
            }
        });
        if (this.open) {
            Units.nearbyEnemies((Team)unit.team, (float)unit.x, (float)unit.y, (float)(this.range * 2.0f), u -> {
                if (!u.dead && u.type != null && (u.health > unit.maxHealth * 2.0f || u.type.armor >= unit.type.armor * 2.0f)) {
                    u.health -= u.health;
                    u.remove();
                }
            });
        }
        if (!this.active) {
            return;
        }
        this.timer += Time.delta;
        if (f >= this.reload) {
            Damage.applySuppression((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.range, (float)this.reload, (float)this.reload, (float)this.applyParticleChance, (Position)unit);
            this.timer = 0.0f;
        }
    }

    public void draw(Unit unit) {
        Lines.stroke((float)0.4f, (Color)unit.team.color);
        Lines.circle((float)unit.x, (float)unit.y, (float)this.range);
        Draw.alpha((float)0.035f);
        Fill.circle((float)unit.x, (float)unit.y, (float)this.range);
    }
}

