/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.world.blocks.environment.Floor;

public class propeller
extends Ability {
    public float px;
    public float py;
    public float length;
    public float speed;
    public String sprite;
    float rot = 0.0f;

    public propeller(float px, float py, String sprite, float length, float speed) {
        this.px = px;
        this.py = py;
        this.length = length;
        this.speed = speed;
        this.sprite = sprite;
    }

    public String localized() {
        return Core.bundle.format("ability.extra-utilities-propeller", new Object[]{Float.valueOf(this.px), Float.valueOf(this.py)});
    }

    public void update(Unit unit) {
        Floor floor;
        if (unit.type != null && unit.type.naval && !unit.floorOn().isLiquid) {
            unit.elevation = 1.0f;
        }
        float realSpeed = unit.elevation * this.speed * Time.delta;
        this.rot += realSpeed;
        float out = unit.elevation * this.length;
        float x = unit.x + Angles.trnsx((float)unit.rotation, (float)this.px, (float)this.py) + Angles.trnsx((float)unit.rotation, (float)0.0f, (float)out);
        float y = unit.y + Angles.trnsy((float)unit.rotation, (float)this.px, (float)this.py) + Angles.trnsy((float)unit.rotation, (float)0.0f, (float)out);
        if (!unit.moving() && unit.isFlying() && (floor = Vars.world.floorWorld(x, y)) != null) {
            EUFx.wind.at(x + (float)Mathf.range((int)8), y + (float)Mathf.range((int)8), floor.mapColor);
        }
    }

    public void draw(Unit unit) {
        Draw.mixcol((Color)Color.white, (float)unit.hitTime);
        Draw.z((float)Math.max(59.0f, unit.elevation * 90.0f));
        float out = unit.elevation * this.length;
        float x = unit.x + Angles.trnsx((float)unit.rotation, (float)this.px, (float)this.py) + Angles.trnsx((float)unit.rotation, (float)0.0f, (float)out);
        float y = unit.y + Angles.trnsy((float)unit.rotation, (float)this.px, (float)this.py) + Angles.trnsy((float)unit.rotation, (float)0.0f, (float)out);
        Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("wing-s")), (float)x, (float)y, (float)(unit.rotation + this.rot * 2.0f));
        Draw.rect((TextureRegion)Core.atlas.find(this.sprite), (float)x, (float)y, (float)(unit.rotation - 90.0f));
        Draw.mixcol();
        Draw.z((float)Math.min(80.0f, 59.0f));
        if (unit.isFlying()) {
            Draw.color((Color)Pal.shadow);
            float e = Math.max(unit.elevation, unit.type.shadowElevation);
            Draw.rect((TextureRegion)Core.atlas.find(this.sprite), (float)(x + -12.0f * e), (float)(y + -13.0f * e), (float)(unit.rotation - 90.0f));
            Draw.color();
        }
    }
}

