/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.animation;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.graphics.MainRenderer;
import ExtraUtilities.worlds.entity.animation.AnimationType;
import ExtraUtilities.worlds.entity.bullet.BlackHoleBullet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Posc;
import mindustry.graphics.Drawf;

public class DeathAnimation
extends AnimationType {
    public DeathAnimation() {
        this.lifetime = 512.0f;
        final BlackHoleBullet hole = new BlackHoleBullet(){
            {
                this.impulse = 0.0f;
                this.inRad = 25.6f;
                this.outRad = 112.0f;
                this.accColor = EUGet.MIKU;
                this.lifetime = 270.0f;
            }
        };
        this.start = new AnimationType(320.0f){
            {
                this.lifetime = 48.0f;
                this.sprite = "extra-utilities-regency-full";
            }

            @Override
            public void draw(Bullet b) {
                float z = Draw.z();
                Draw.z((float)219.9f);
                if (b.time < b.lifetime - 12.0f) {
                    float shake = Mathf.sin((float)Time.time, (float)(120.0f * b.foutpow() + 6.0f), (float)(40.0f * b.finpow()));
                    float bx = b.x + shake;
                    Draw.rect((TextureRegion)this.frontRegion, (float)bx, (float)b.y, (float)(b.rotation() - 90.0f));
                } else {
                    float out = (b.lifetime - b.time) / 12.0f;
                    out = Interp.fastSlow.apply(out);
                    Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)((float)this.frontRegion.width * this.frontRegion.scl() * Draw.xscl * out), (float)((float)this.frontRegion.height * this.frontRegion.scl() * Draw.yscl * out), (float)(b.rotation() - 90.0f));
                    MainRenderer.addBlackHole(b.x, b.y, 0.0f, 336.0f * out);
                    Draw.color((Color)Color.white);
                    for (int i = 0; i < 4; ++i) {
                        float a = 90 * i;
                        float l = i % 2 == 0 ? 150.0f : 75.0f;
                        Drawf.tri((float)b.x, (float)b.y, (float)(8.0f * out), (float)(l * (1.0f - out)), (float)a);
                    }
                }
                Draw.z((float)z);
            }
        };
        this.loop = new AnimationType(360.0f){
            {
                this.sprite = "extra-utilities-regency-full";
            }

            @Override
            public void draw(Bullet b) {
                float z = Draw.z();
                Draw.z((float)219.9f);
                if (b.time < 12.0f) {
                    float in = b.time / 12.0f;
                    float out = 1.0f - in;
                    in = Interp.fastSlow.apply(in);
                    out = Interp.fastSlow.apply(out);
                    MainRenderer.addBlackHole(b.x, b.y, 0.0f, 336.0f * out);
                    Draw.color((Color)Color.white);
                    for (int i = 0; i < 4; ++i) {
                        float a = 90 * i;
                        float l = i % 2 == 0 ? 150.0f : 75.0f;
                        Drawf.tri((float)b.x, (float)b.y, (float)(8.0f * out), (float)(l * (1.0f - out)), (float)a);
                    }
                    Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)((float)this.frontRegion.width * this.frontRegion.scl() * Draw.xscl * in), (float)((float)this.frontRegion.height * this.frontRegion.scl() * Draw.yscl * in), (float)(b.rotation() - 90.0f));
                } else if (b.time > b.lifetime - 12.0f) {
                    float out = (b.lifetime - b.time) / 12.0f;
                    out = Interp.fastSlow.apply(out);
                    float shake = Mathf.sin((float)Time.time, (float)0.9f, (float)(20.0f * out));
                    MainRenderer.addBlackHole(b.x, b.y, 0.0f, 288.0f * out);
                    Draw.color((Color)Color.white);
                    for (int i = 0; i < 4; ++i) {
                        float a = 90 * i;
                        float l = i % 2 == 0 ? 150.0f : 75.0f;
                        Drawf.tri((float)b.x, (float)b.y, (float)(8.0f * out), (float)(l * (1.0f - out)), (float)a);
                    }
                    Draw.rect((TextureRegion)this.frontRegion, (float)(b.x + shake), (float)b.y, (float)((float)this.frontRegion.width * this.frontRegion.scl() * Draw.xscl * out), (float)((float)this.frontRegion.height * this.frontRegion.scl() * Draw.yscl * out), (float)(b.rotation() - 90.0f));
                } else {
                    float shake = Mathf.sin((float)Time.time, (float)0.9f, (float)20.0f);
                    Draw.rect((TextureRegion)this.frontRegion, (float)(b.x + shake), (float)b.y, (float)(b.rotation() - 90.0f));
                }
                Draw.z((float)z);
            }
        };
        this.end = new AnimationType(320.0f){
            {
                super(drawSize);
                this.lifetime = 180.0f;
                this.sprite = "extra-utilities-regency-full";
            }

            @Override
            public void draw(Bullet b) {
                float z = Draw.z();
                Draw.z((float)219.9f);
                if (b.time < 12.0f) {
                    float in = b.time / 12.0f;
                    float out = 1.0f - in;
                    in = Interp.fastSlow.apply(in);
                    out = Interp.fastSlow.apply(out);
                    MainRenderer.addBlackHole(b.x, b.y, 0.0f, 288.0f * out);
                    Draw.color((Color)Color.white);
                    for (int i = 0; i < 4; ++i) {
                        float a = 90 * i;
                        float l = i % 2 == 0 ? 150.0f : 75.0f;
                        Drawf.tri((float)b.x, (float)b.y, (float)(8.0f * out), (float)(l * (1.0f - out)), (float)a);
                    }
                    Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)((float)this.frontRegion.width * this.frontRegion.scl() * Draw.xscl * in), (float)((float)this.frontRegion.height * this.frontRegion.scl() * Draw.yscl * in), (float)(b.rotation() - 90.0f));
                } else {
                    float in = (b.time - 12.0f) / (b.lifetime - 12.0f);
                    float out = 1.0f - in;
                    out = Interp.fastSlow.apply(out);
                    Entityc a = b.owner;
                    if (a instanceof Posc) {
                        Posc pos = (Posc)a;
                        float dx = EUGet.dx(pos.getX(), b.fdata * out, pos.angleTo((Position)b) + out * 720.0f);
                        float dy = EUGet.dy(pos.getY(), b.fdata * out, pos.angleTo((Position)b) + out * 720.0f);
                        Draw.rect((TextureRegion)this.frontRegion, (float)dx, (float)dy, (float)((float)this.frontRegion.width * this.frontRegion.scl() * Draw.xscl * out), (float)((float)this.frontRegion.height * this.frontRegion.scl() * Draw.yscl * out), (float)(b.rotation() - 90.0f));
                    }
                }
                Draw.z((float)z);
            }

            public void init(Bullet b) {
                Entityc entityc = b.owner;
                if (entityc instanceof Posc) {
                    Posc pos = (Posc)entityc;
                    hole.create(b, pos.getX(), pos.getY(), 0.0f, 0.0f);
                    b.fdata = pos.dst((Position)b);
                }
            }
        };
    }

    public void update(Bullet b) {
        if (!(b instanceof AnimationType.animation)) {
            return;
        }
        AnimationType.animation at = (AnimationType.animation)b;
        if (b.time < this.start.lifetime) {
            if (!at.started) {
                at.started = true;
                this.start.create(b, b.x, b.y, b.rotation());
            }
            at.afx = b.x + (float)Mathf.random((int)-200, (int)200);
            at.afy = b.y + (float)Mathf.random((int)-200, (int)200);
        } else if (b.time > this.lifetime - this.start.lifetime - this.end.lifetime) {
            if (!at.ended) {
                at.ended = true;
                this.end.create(b, at.afx, at.afy, b.rotation());
            }
        } else {
            float endTime = this.lifetime - this.start.lifetime - this.end.lifetime;
            float loopTime = b.time - this.start.lifetime;
            if (at.loop == null || !at.loop.isAdded()) {
                at.loop = this.loop.create(b, at.afx, at.afy, b.rotation());
                at.loop.lifetime = loopTime > endTime / 3.0f ? 24.001f : 48.0f;
                at.afx = b.x + (float)Mathf.random((int)-200, (int)200);
                at.afy = b.y + (float)Mathf.random((int)-200, (int)200);
            }
        }
    }
}

