/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.entity.bullet.ChainLightningFade;
import ExtraUtilities.worlds.entity.bullet.PrismLaser;
import ExtraUtilities.worlds.entity.bullet.liContinuousLaserBullet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.pooling.Pools;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;

public class PrismCtr
extends BulletType {
    public float angleShiftStrength = 5.0f;
    public float shiftAngel = 30.0f;
    public int las = 6;
    public float checkRange = 312.0f;
    public boolean tgAuto = true;
    public Color dc1 = Color.valueOf((String)"87CEEB");
    public BulletType laser = new liContinuousLaserBullet(){
        {
            this.damage = 40.0f;
            this.buildingDamageMultiplier = 0.5f;
            this.lifetime = 15.0f;
            this.chain = new ChainLightningFade(12.0f, -1.0f, 5.0f, Color.valueOf((String)"87CEEB"), 30.0f, Fx.hitLancer);
            this.colors = new Color[]{Color.valueOf((String)"87CEEB").a(0.4f), Color.valueOf((String)"87CEEB").a(0.7f), Color.valueOf((String)"87CEEB")};
            this.width = 4.0f;
            this.length = PrismCtr.this.checkRange + 24.0f;
            this.lTime = 18.0f;
            this.spacing = 6;
            this.incendChance = -1.0f;
            this.incendAmount = 0;
            this.status = StatusEffects.shocked;
            this.hitEffect = this.despawnEffect = Fx.none;
            this.pierceArmor = true;
        }
    };

    public PrismCtr() {
        this.damage = 0.0f;
        this.speed = 0.0f;
        this.lifetime = 180.0f;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.keepVelocity = false;
        this.hittable = false;
        this.absorbable = false;
        this.collidesTiles = false;
        this.collides = false;
    }

    public void init() {
        super.init();
        BulletType bulletType = this.laser;
        if (bulletType instanceof PrismLaser) {
            PrismLaser pl = (PrismLaser)bulletType;
            pl.plan = 3;
        }
    }

    public void init(Bullet b) {
        super.init(b);
        Teamc tc = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.checkRange, u -> u.checkTarget(this.collidesAir, this.collidesGround) && u.targetable(b.team));
        Entityc entityc = b.owner;
        if (entityc instanceof Unit) {
            Unit u2 = (Unit)entityc;
            b.rotation(tc != null ? b.angleTo((Position)tc) : b.angleTo(u2.mounts[0].aimX, u2.mounts[0].aimY));
        }
        if (b instanceof ctr) {
            ctr c = (ctr)b;
            for (int i = 0; i < this.las; ++i) {
                Bullet be = this.laser.create((Entityc)b, b.team, b.x, b.y, 0.0f);
                be.data = 360 / this.las * i;
                c.bs.add((Object)be);
            }
        }
    }

    public void update(Bullet b) {
        super.update(b);
        if (this.tgAuto) {
            Teamc tc = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.checkRange, u -> u.checkTarget(this.collidesAir, this.collidesGround) && u.targetable(b.team));
            Entityc entityc = b.owner;
            if (entityc instanceof Unit) {
                Unit u2 = (Unit)entityc;
                float acg = tc != null ? b.angleTo((Position)tc) : b.angleTo(u2.mounts[0].aimX, u2.mounts[0].aimY);
                b.rotation(Angles.moveToward((float)b.rotation(), (float)acg, (float)(0.8f * Time.delta)));
            }
        }
        float fin = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.6f);
        if (b instanceof ctr) {
            ctr c = (ctr)b;
            for (int i = 0; i < c.bs.size; ++i) {
                if (c.bs.get(i) == null) continue;
                int data = i * (360 / c.bs.size);
                float sine = Mathf.sinDeg((float)((float)data + b.time * (this.angleShiftStrength * (1.0f - Mathf.pow((float)b.fout(), (float)3.0f)))));
                c.vec.set(sine * 2.0f, 0.0f).rotate(b.rotation() - 90.0f);
                ((Bullet)c.bs.get(i)).rotation(b.rotation() + sine * this.shiftAngel * (1.0f - fin));
                ((Bullet)c.bs.get(i)).set(b.x + c.vec.x, b.y + c.vec.y);
                ((Bullet)c.bs.get((int)i)).time = 0.0f;
            }
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        Draw.color((Color)this.dc1);
        Fill.circle((float)b.x, (float)b.y, (float)12.0f);
        for (int i : Mathf.zeroOne) {
            Drawf.tri((float)b.x, (float)b.y, (float)12.0f, (float)30.0f, (float)(b.rotation() - 90.0f + (float)(180 * i)));
        }
        Draw.color((Color)Color.black);
        Fill.circle((float)b.x, (float)b.y, (float)8.0f);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        ctr bullet = ctr.create();
        return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static class ctr
    extends Bullet {
        public Seq<Bullet> bs = new Seq();
        public Vec2 vec = new Vec2();

        public static ctr create() {
            return (ctr)((Object)Pools.obtain(ctr.class, ctr::new));
        }

        public void remove() {
            super.remove();
            this.bs.clear();
        }
    }
}

