/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUStatusEffects;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;

public class ScarletDevil
extends BulletType {
    public BulletType fb;
    public BulletType ff;
    public Color color;
    Mover mover = bullet -> {
        if (!(bullet.data instanceof Float)) {
            return;
        }
        float s = ((Float)bullet.data).floatValue();
        float fout = Math.max((60.0f - bullet.time) / 60.0f, 0.0f);
        if (bullet.time < 70.0f) {
            bullet.initVel(bullet.rotation(), bullet.type.speed * fout * s);
        }
    };

    public ScarletDevil(final Color color) {
        this.color = color;
        this.fb = new stopHoming(){
            {
                this.sColor = color;
                this.lifetime = 180.0f;
                this.speed = 6.0f;
                this.hitEffect = this.despawnEffect = new Effect(24.0f, e -> {
                    Draw.color((Color)color);
                    Angles.randLenVectors((long)e.id, (int)7, (float)(32.0f * e.finpow()), (float)e.rotation, (float)0.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(6.0f * e.foutpow())));
                });
                this.trailLength = 15;
                this.trailWidth = 3.0f;
                this.trailColor = color;
                this.keepVelocity = false;
                this.homingPower = 0.08f;
                this.homingRange = 320.0f;
                this.healPercent = 2.0f;
                this.damage = 55.0f;
                this.collidesTeam = true;
                this.reflectable = false;
                this.healColor = color;
                this.buildingDamageMultiplier = 0.7f;
            }
        };
        this.ff = new BulletType(){
            {
                this.lifetime = 63.0f;
                this.speed = 3.0f;
                this.hitEffect = this.despawnEffect = Fx.none;
                this.trailLength = 15;
                this.trailWidth = 3.0f;
                this.trailColor = color;
                this.keepVelocity = false;
                this.damage = 0.0f;
                this.collides = false;
                this.collidesGround = false;
                this.collidesAir = false;
                this.absorbable = false;
                this.reflectable = false;
            }

            public void draw(Bullet b) {
                super.draw(b);
                Draw.z((float)100.0f);
                Draw.color((Color)color);
                Fill.circle((float)b.x, (float)b.y, (float)3.0f);
                Draw.color((Color)Color.white);
                Fill.circle((float)b.x, (float)b.y, (float)2.0f);
                Draw.reset();
            }

            public void despawned(Bullet b) {
                ScarletDevil.this.fb.create(b, b.x, b.y, 0.0f);
            }
        };
        this.healPercent = 10.0f;
        this.splashDamageRadius = 80.0f;
        this.despawnHit = true;
        this.keepVelocity = false;
        this.hitEffect = this.despawnEffect = new ExplosionEffect(){
            {
                this.lifetime = 30.0f;
                this.waveStroke = 5.0f;
                this.waveLife = 10.0f;
                this.waveRad = ScarletDevil.this.splashDamageRadius;
                this.waveColor = color;
                this.sparkColor = color;
                this.smokes = 0;
                this.sparks = 30;
                this.sparkRad = ScarletDevil.this.splashDamageRadius;
                this.sparkLen = 6.0f;
                this.sparkStroke = 1.0f;
            }
        };
        this.fragBullet = this.fb;
        this.fragBullets = 126;
        this.reflectable = false;
    }

    public float mov(float r) {
        return Mathf.cos((float)((float)(3.0 * ((double)(r / 180.0f) * Math.PI)))) + 1.0f;
    }

    public void createFrags(Bullet b, float x, float y) {
        float r;
        int i;
        int fs = this.fragBullets / 3;
        int rdp = Mathf.randomSeed((long)b.id, (int)1, (int)2);
        for (i = 0; i < fs; ++i) {
            r = (float)(i + 1) * (360.0f / (float)(fs * rdp)) - 30.0f;
            this.ff.create((Entityc)b, b.team, b.x, b.y, r + 30.0f, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf(this.mov(r)), this.mover);
        }
        for (i = 0; i < fs; ++i) {
            r = (float)(i + 1) * (360.0f / (float)(fs * rdp)) - 30.0f;
            this.ff.create((Entityc)b, b.team, b.x, b.y, r - 150.0f, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf(this.mov(r)), this.mover);
        }
        for (i = 0; i < fs; ++i) {
            r = (float)i * (360.0f / (float)fs) + 90.0f;
            this.ff.create((Entityc)b, b.team, b.x, b.y, r, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf(2.2f), this.mover);
        }
    }

    public void removed(Bullet b) {
    }

    public static class stopHoming
    extends BulletType {
        public Color sColor;

        public void draw(Bullet b) {
            super.draw(b);
            Draw.z((float)100.0f);
            Draw.color((Color)this.sColor);
            Fill.circle((float)b.x, (float)b.y, (float)3.0f);
            Draw.color((Color)Color.white);
            Fill.circle((float)b.x, (float)b.y, (float)2.0f);
        }

        public void updateHoming(Bullet b) {
            boolean bl = b.hit = b.time >= this.homingDelay;
            if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay) {
                float realAimY;
                float realAimX = b.aimX < 0.0f ? b.x : b.aimX;
                float f = realAimY = b.aimY < 0.0f ? b.y : b.aimY;
                if (b.timer(2, 12.0f)) {
                    Object target = null;
                    target = this.heals() ? Units.closestTarget(null, (float)realAimX, (float)realAimY, (float)this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && e.team != b.team && !b.hasCollided(e.id), t -> this.collidesGround && (t.team != b.team || t.damaged()) && !b.hasCollided(t.id)) : (b.aimTile != null && b.aimTile.build != null && b.aimTile.build.team != b.team && this.collidesGround && !b.hasCollided(b.aimTile.build.id) ? b.aimTile.build : Units.closestTarget((Team)b.team, (float)realAimX, (float)realAimY, (float)this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id)));
                    if (target != null) {
                        b.initVel(b.angleTo((Position)target), b.type.speed);
                    } else {
                        b.initVel(b.rotation(), 0.0f);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void hitEntity(Bullet b, Hitboxc entity, float health) {
            if (entity instanceof Unit) {
                Unit u = (Unit)entity;
                if (u.type != null) {
                    if (u.type.armor > 80.0f) {
                        u.health -= u.health;
                        u.kill();
                    }
                    float dmg = b.damage * (1.0f + u.type.armor / 10.0f);
                    u.damagePierce(dmg);
                    if (!u.hasEffect(EUStatusEffects.breakage)) return;
                    if (u.health <= dmg * 0.5f) {
                        u.kill();
                        return;
                    }
                    u.health -= dmg * 0.5f;
                    return;
                }
            }
            super.hitEntity(b, entity, health);
        }

        public void removed(Bullet b) {
        }
    }
}

