/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;

public class diffBullet
extends BulletType {
    public float cont;
    public int damType;
    public Color color = Pal.accent;
    public boolean pfin = true;

    public diffBullet(float cont, int damType) {
        this.cont = cont / 2.0f;
        this.damType = damType;
        this.keepVelocity = false;
        this.hittable = false;
        this.absorbable = false;
        this.collidesTiles = false;
        this.collidesGround = false;
        this.collidesAir = false;
        this.collides = false;
        this.despawnEffect = this.hitEffect = Fx.none;
        this.speed = 0.0f;
    }

    public void update(Bullet b) {
        super.update(b);
        if (b instanceof diffEnt) {
            diffEnt d = (diffEnt)b;
            float r = this.splashDamageRadius * (1.0f - b.foutpow());
            Vars.indexer.allBuildings(b.x, b.y, r, bd -> {
                if (bd.team != b.team && bd.block != null && bd.block.targetable && Angles.within((float)b.rotation(), (float)b.angleTo((Position)bd), (float)this.cont)) {
                    d.seq.addUnique(bd);
                }
            });
            Units.nearbyEnemies((Team)b.team, (float)(b.x - r), (float)(b.y - r), (float)(r * 2.0f), (float)(r * 2.0f), u -> {
                if (u.type != null && u.type.targetable && b.within((Position)u, r) && Angles.within((float)b.rotation(), (float)b.angleTo((Position)u), (float)this.cont)) {
                    d.seq.addUnique(u);
                }
            });
            for (int i = 0; i < d.seq.size; ++i) {
                Healthc hc = (Healthc)d.seq.get(i);
                if (hc == null || hc.dead() || b.hasCollided(hc.id())) continue;
                switch (this.damType) {
                    case 1: {
                        hc.damage(this.damage);
                        break;
                    }
                    case 2: {
                        hc.damagePierce(this.damage);
                        break;
                    }
                    case 3: {
                        if (hc.health() <= this.damage) {
                            hc.kill();
                            break;
                        }
                        hc.health(hc.health() - this.damage);
                    }
                }
                EUFx.diffHit.at(hc.getX(), hc.getY(), 0.0f, this.color, (Object)hc);
                b.collided.add(hc.id());
            }
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        float pin = 1.0f - b.foutpow();
        Lines.stroke((float)(5.0f * (this.pfin ? pin : b.foutpow())), (Color)this.color);
        for (float i = b.rotation() - this.cont; i < b.rotation() + this.cont; i += 1.0f) {
            float lx = EUGet.dx(b.x, this.splashDamageRadius * pin, i);
            float ly = EUGet.dy(b.y, this.splashDamageRadius * pin, i);
            Lines.lineAngle((float)lx, (float)ly, (float)(i - 90.0f), (float)(this.splashDamageRadius / (this.cont * 2.0f) * pin));
            Lines.lineAngle((float)lx, (float)ly, (float)(i + 90.0f), (float)(this.splashDamageRadius / (this.cont * 2.0f) * pin));
        }
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        diffEnt bullet = diffEnt.create();
        if (bullet.seq.size > 0) {
            bullet.seq.clear();
        }
        return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static class diffEnt
    extends Bullet {
        public Seq<Healthc> seq = new Seq();

        public static diffEnt create() {
            return (diffEnt)((Object)Pools.obtain(diffEnt.class, diffEnt::new));
        }
    }
}

