/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;

public class mixBoom
extends BulletType {
    public float size = 8.0f;
    public float expIer = 5.0f;
    public Color color;
    public boolean aimTo = false;
    public float aimBefore = 3.0f;

    public mixBoom(Color color) {
        this.color = color;
        this.scaleLife = true;
        this.collidesTiles = false;
        this.collidesGround = false;
        this.collidesAir = false;
        this.collides = false;
        this.despawnEffect = new MultiEffect(new Effect[]{EUFx.expFtEffect(8, 3.0f, 8.0f, 20.0f, 0.5f), new Effect(6.0f, e -> {
            Lines.stroke((float)(6.0f * e.fout()), (Color)Color.white);
            Lines.circle((float)e.x, (float)e.y, (float)(36.0f * e.fin()));
        })});
        this.fragOnHit = false;
        this.damage = 0.0f;
        this.absorbable = false;
        this.hittable = false;
        this.trailEffect = Fx.artilleryTrail;
        this.trailInterval = 2.0f;
        this.despawnSound = this.hitSound = Sounds.shootBig;
    }

    public void createFrags(Bullet b, float x, float y) {
        if (this.fragBullet != null && (this.fragOnAbsorb || !b.absorbed)) {
            for (int i = 0; i < this.fragBullets; ++i) {
                float a = b.rotation() + Mathf.range((float)(this.fragRandomSpread / 2.0f)) + this.fragAngle + ((float)i - (float)this.fragBullets / 2.0f) * this.fragSpread;
                this.fragBullet.create((Entityc)b, b.team, x, y, a, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf((float)i * this.expIer));
            }
        }
    }

    public void update(Bullet b) {
        if (this.aimTo && b.time > b.lifetime - this.aimBefore) {
            this.createFrags(b, b.x, b.y);
            b.remove();
            return;
        }
        super.update(b);
    }

    public void updateTrailEffects(Bullet b) {
        if (this.trailInterval <= 0.0f) {
            return;
        }
        if (b.timer(0, this.trailInterval)) {
            this.trailEffect.at(b.x, b.y, this.size * b.fin(), this.color);
        }
    }

    public void draw(Bullet b) {
        Draw.color((Color)this.color);
        Fill.circle((float)b.x, (float)b.y, (float)(this.size * b.fin() + 1.0f));
        this.drawTrail(b);
        this.drawParts(b);
    }

    public static class mixExps
    extends BulletType {
        public float size = 6.0f;
        public float minSize = 0.0f;
        public Color color;
        public boolean circle = true;

        public mixExps() {
            this.collidesTiles = false;
            this.collidesAir = false;
            this.collides = false;
            this.keepVelocity = false;
        }

        public void update(Bullet b) {
            super.update(b);
            if (!(b.data instanceof Float)) {
                return;
            }
            float ier = ((Float)b.data).floatValue();
            b.lifetime = this.lifetime + ier;
            if (b.time < ier) {
                b.initVel(b.rotation(), 0.0f);
            } else {
                float fout = this.circle ? Math.min(1.0f - (b.time - ((Float)b.data).floatValue()) / this.lifetime, 1.0f) : b.fout();
                b.initVel(b.rotation(), this.speed * fout);
            }
        }

        public void drawTrail(Bullet b) {
            if (!(b.data instanceof Float)) {
                return;
            }
            if (this.trailLength > 0 && b.trail != null) {
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                float fout = this.circle ? Math.min(1.0f - (b.time - ((Float)b.data).floatValue()) / this.lifetime, 1.0f) : b.fout();
                b.trail.draw(this.trailColor, this.minSize + 1.0f + this.trailWidth * fout);
                Draw.z((float)z);
            }
        }

        public void draw(Bullet b) {
            if (!(b.data instanceof Float)) {
                return;
            }
            Draw.color((Color)this.color);
            float fout = this.circle ? Math.min(1.0f - (b.time - ((Float)b.data).floatValue()) / this.lifetime, 1.0f) : b.fout();
            Fill.circle((float)b.x, (float)b.y, (float)(this.size * fout + this.minSize));
            super.draw(b);
        }
    }
}

