/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.weapon;

import ExtraUtilities.worlds.entity.weapon.mounts.reRotMount;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class TractorBeamWeapon
extends Weapon {
    public Color color = Color.white;
    public float shootSoundVolume = 0.8f;
    public float force = 18.0f;
    public float scaledForce = 6.0f;
    public float laserWidth = 0.45f;
    public boolean trueDamage = false;
    public float reRotateTime = 180.0f;

    public TractorBeamWeapon(String name) {
        super(name);
        this.shootSound = Sounds.tractorbeam;
        this.predictTarget = false;
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.rotateSpeed = 10.0f;
        this.useAmmo = false;
        this.useAttackRange = false;
        this.targetInterval = 5.0f;
        this.targetSwitchInterval = 5.0f;
        this.mountType = TractorBeamWeaponMount::new;
    }

    public TractorBeamWeapon() {
        super(null);
    }

    public void addStats(UnitType u, Table t) {
        if (this.bullet.damage > 0.0f) {
            t.row();
            t.add((CharSequence)(Stat.damage.localized() + "[accent]" + this.bullet.damage * 60.0f + "[]" + StatUnit.perSecond.localized()));
        }
        t.row();
        t.add((CharSequence)(Stat.range.localized() + "[accent]" + this.bullet.range / 8.0f + "[]" + StatUnit.blocks.localized()));
    }

    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        return Units.closestEnemy((Team)unit.team, (float)x, (float)y, (float)range, u -> u.checkTarget(air, ground));
    }

    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        return !(target instanceof Unit) || ((Unit)target).type == null || !target.within(x, y, range + ((Unit)target).hitSize / 2.0f) || target.team() == unit.team || ((Unit)target).dead;
    }

    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
    }

    public void update(Unit unit, WeaponMount m) {
        super.update(unit, m);
        float mountX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float mountY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        TractorBeamWeaponMount mount = (TractorBeamWeaponMount)m;
        mount.mx = mountX;
        mount.my = mountY;
        mount.reRotate = mount.target != null ? this.reRotateTime : Math.max(mount.reRotate - Time.delta, 0.0f);
        if (mount.target == null && !mount.shoot && !Angles.within((float)mount.rotation, (float)mount.weapon.baseRotation, (float)0.01f) && mount.reRotate <= 0.0f) {
            mount.rotate = true;
            Tmp.v1.trns(unit.rotation + mount.weapon.baseRotation, 5.0f);
            mount.aimX = mountX + Tmp.v1.x;
            mount.aimY = mountY + Tmp.v1.y;
        }
        mount.any = false;
        if (mount.shoot && mount.target != null) {
            if (!Vars.headless) {
                Vars.control.sound.loop(this.shootSound, (Position)mount, this.shootSoundVolume);
            }
            Unit target = (Unit)mount.target;
            mount.lastX = target.x;
            mount.lastY = target.y;
            mount.strength = Mathf.lerpDelta((float)mount.strength, (float)1.0f, (float)0.1f);
            if (this.bullet.damage > 0.0f) {
                if (this.trueDamage) {
                    target.damageContinuousPierce(this.bullet.damage * Vars.state.rules.unitDamage(unit.team));
                } else {
                    target.damageContinuous(this.bullet.damage * Vars.state.rules.unitDamage(unit.team));
                }
            }
            if (this.bullet.status != StatusEffects.none) {
                target.apply(this.bullet.status, this.bullet.statusDuration);
            }
            mount.any = true;
            target.impulseNet(Tmp.v1.set((Position)mount).sub((Position)target).limit(this.force + (1.0f - target.dst((Position)mount) / this.bullet.range) * this.scaledForce));
        } else {
            mount.strength = Mathf.lerpDelta((float)mount.strength, (float)0.0f, (float)0.1f);
        }
    }

    public void draw(Unit unit, WeaponMount m) {
        super.draw(unit, m);
        TractorBeamWeaponMount mount = (TractorBeamWeaponMount)m;
        float z = Draw.z();
        if (mount.any) {
            Draw.z((float)100.0f);
            float ang = mount.angleTo(mount.lastX, mount.lastY);
            Draw.mixcol((Color)this.color, (float)Mathf.absin((float)4.0f, (float)0.6f));
            TractorBeamTurret t = (TractorBeamTurret)Blocks.parallax;
            Drawf.laser((TextureRegion)t.laser, (TextureRegion)t.laserStart, (TextureRegion)t.laserEnd, (float)(mount.mx + Angles.trnsx((float)ang, (float)this.shootY)), (float)(mount.my + Angles.trnsy((float)ang, (float)this.shootY)), (float)mount.lastX, (float)mount.lastY, (float)(mount.strength * this.laserWidth));
            Draw.mixcol();
        }
        Draw.z((float)z);
        Draw.reset();
    }

    public static class TractorBeamWeaponMount
    extends reRotMount
    implements Position {
        public boolean any;
        public float lastX;
        public float lastY;
        public float strength;
        public float mx;
        public float my;

        public TractorBeamWeaponMount(Weapon weapon) {
            super(weapon);
        }

        public float getX() {
            return this.mx;
        }

        public float getY() {
            return this.my;
        }
    }
}

