#define PERIPH_BASE           (0x40000000UL)
#define APB1PERIPH_BASE       (PERIPH_BASE)
#define APB2PERIPH_BASE       (PERIPH_BASE + 0x00010000UL)
#define AHB1PERIPH_BASE       (PERIPH_BASE + 0x00020000UL)

/*!< APB1 peripherals */
#define TIM2_BASE            (APB1PERIPH_BASE + 0x0000UL)
#define TIM3_BASE            (APB1PERIPH_BASE + 0x0400UL)
#define TIM4_BASE            (APB1PERIPH_BASE + 0x0800UL)
#define TIM5_BASE            (APB1PERIPH_BASE + 0x0C00UL)  
#define TIM6_BASE            (APB1PERIPH_BASE + 0x1000UL)
#define TIM7_BASE            (APB1PERIPH_BASE + 0x1400UL)
#define TIM12_BASE           (APB1PERIPH_BASE + 0x1800UL)  
#define TIM13_BASE           (APB1PERIPH_BASE + 0x1C00UL)  
#define TIM14_BASE           (APB1PERIPH_BASE + 0x2000UL)  
#define RTC_BASE             (APB1PERIPH_BASE + 0x2800UL)
#define WWDG_BASE            (APB1PERIPH_BASE + 0x2C00UL)
#define IWDG_BASE            (APB1PERIPH_BASE + 0x3000UL)
#define SPI2_BASE            (APB1PERIPH_BASE + 0x3800UL)
#define SPI3_BASE            (APB1PERIPH_BASE + 0x3C00UL)  
#define USART2_BASE          (APB1PERIPH_BASE + 0x4400UL)
#define USART3_BASE          (APB1PERIPH_BASE + 0x4800UL)
#define UART4_BASE           (APB1PERIPH_BASE + 0x4C00UL)  
#define UART5_BASE           (APB1PERIPH_BASE + 0x5000UL)  
#define I2C1_BASE            (APB1PERIPH_BASE + 0x5400UL)
#define I2C2_BASE            (APB1PERIPH_BASE + 0x5800UL)
#define USB_BASE             (APB1PERIPH_BASE + 0x5C00UL)
#define USB_SRAM_BASE        (APB1PERIPH_BASE + 0x6000UL)  //! Shared USB/CAN SRAM
#define BxCAN_BASE           (APB1PERIPH_BASE + 0x6400UL)
#define BKP_BASE             (APB1PERIPH_BASE + 0x6C00UL)
#define PWR_BASE             (APB1PERIPH_BASE + 0x7000UL)
#define DAC_BASE             (APB1PERIPH_BASE + 0x7400UL)
#define CEC_BASE             (APB1PERIPH_BASE + 0x7800UL)

/*!< APB2 peripherals */
#define AFIO_BASE            (APB2PERIPH_BASE + 0x0000UL)
#define EXTI_BASE            (APB2PERIPH_BASE + 0x0400UL)
#define GPIOA_BASE           (APB2PERIPH_BASE + 0x0800UL)
#define GPIOB_BASE           (APB2PERIPH_BASE + 0x0C00UL)
#define GPIOC_BASE           (APB2PERIPH_BASE + 0x1000UL)
#define GPIOD_BASE           (APB2PERIPH_BASE + 0x1400UL)  
#define GPIOE_BASE           (APB2PERIPH_BASE + 0x1800UL)  
#define GPIOF_BASE           (APB2PERIPH_BASE + 0x1C00UL)  
#define GPIOG_BASE           (APB2PERIPH_BASE + 0x2000UL)  
#define ADC1_BASE            (APB2PERIPH_BASE + 0x2400UL)
#define ADC2_BASE            (APB2PERIPH_BASE + 0x2800UL)
#define TIM1_BASE            (APB2PERIPH_BASE + 0x2C00UL)
#define SPI1_BASE            (APB2PERIPH_BASE + 0x3000UL)
#define TIM8_BASE            (APB2PERIPH_BASE + 0x3400UL)
#define USART1_BASE          (APB2PERIPH_BASE + 0x3800UL)
#define ADC3_BASE            (APB2PERIPH_BASE + 0x3C00UL)
#define TIM15_BASE           (APB2PERIPH_BASE + 0x4000UL)
#define TIM16_BASE           (APB2PERIPH_BASE + 0x4400UL)
#define TIM17_BASE           (APB2PERIPH_BASE + 0x4800UL)
#define TIM9_BASE            (APB2PERIPH_BASE + 0x4C00UL)  
#define TIM10_BASE           (APB2PERIPH_BASE + 0x5000UL)  
#define TIM11_BASE           (APB2PERIPH_BASE + 0x5400UL)  
#define SDIO_BASE            (APB2PERIPH_BASE + 0x8000UL)

/*!< AHB peripherals */
#define DMA1_BASE            (AHB1PERIPH_BASE + 0x0000UL)
#define DMA2_BASE            (AHB1PERIPH_BASE + 0x0400UL)  
#define RCC_BASE             (AHB1PERIPH_BASE + 0x1000UL)
#define FLASH_INTERFACE_BASE (AHB1PERIPH_BASE + 0x2000UL)
#define CRC_BASE             (AHB1PERIPH_BASE + 0x3000UL)
