/**
 * @file
 * @brief TODO
 *
 * @date 20.04.10
 * @author Eldar Abusalimov
 */

#include <module/embox/arch/context.h>

#include <asm/regs.h>
#include <asm/wim.h>
#include <asm/ptrace.h>
#include <asm/stack.h>
#include <asm/cpu.h>

	.text
	.align 4

	.global context_switch
context_switch:
	save %sp, -STACK_FRAME_SZ, %sp

	st %fp, [%i0 + CTX_KSP]
	st %i7, [%i0 + CTX_RET]
	st %i0, [%i0 + CTX_ARG]

	rd %psr, %t_psr
	st %t_psr, [%i0 + CTX_PSR]

	call winflush
	 nop

	mov %i1, %g1

	ld [%g1 + CTX_PSR], %g2
	wr %g2, %g0, %psr
	 nop; nop; nop ! switching windows affects locals

	mov WIM_INIT, %t_wim
	sll %t_wim, %g2, %t_wim
	srl %t_wim, CONFIG_NWINDOWS, %temp
	wr %t_wim, %temp, %wim
	 ! don't wait

	ld [%g1 + CTX_KSP], %fp
	ld [%g1 + CTX_RET], %i7
	ld [%g1 + CTX_ARG], %i0

	ret
	 restore
