/**
 * @file
 *
 * @date Jul 17, 2025
 * @author Anton Bondarev
 */

#ifndef SRC_DRIVERS_MMC_HOST_STM32CUBE_SDIO_STM32CUBE_DEFINITIONS_H_
#define SRC_DRIVERS_MMC_HOST_STM32CUBE_SDIO_STM32CUBE_DEFINITIONS_H_

#include <config/board_config.h>


#if defined(CONF_SDIO1_MISC_NAME_IN_CUBE_SDIO) || defined(CONF_SDIO2_MISC_NAME_IN_CUBE_SDIO)
# define CUBE_PREFIX          SDIO_
#elif defined(CONF_SDIO1_MISC_NAME_IN_CUBE_SDMMC) || defined(CONF_SDIO2_MISC_NAME_IN_CUBE_SDMMC)
# define CUBE_PREFIX          SDMMC_
#endif

#define CUBE_CLOCK_EDGE_RISING               MACRO_CONCAT(CUBE_PREFIX,CLOCK_EDGE_RISING)
#define CUBE_CLOCK_BYPASS_DISABLE            MACRO_CONCAT(CUBE_PREFIX,CLOCK_BYPASS_DISABLE)
#define CUBE_CLOCK_POWER_SAVE_DISABLE        MACRO_CONCAT(CUBE_PREFIX,CLOCK_POWER_SAVE_DISABLE)
#define CUBE_BUS_WIDE_1B                     MACRO_CONCAT(CUBE_PREFIX,BUS_WIDE_1B)
#define CUBE_BUS_WIDE_4B                     MACRO_CONCAT(CUBE_PREFIX,BUS_WIDE_4B)
#define CUBE_HARDWARE_FLOW_CONTROL_DISABLE   MACRO_CONCAT(CUBE_PREFIX,HARDWARE_FLOW_CONTROL_DISABLE)
#define CUBE_RESPONSE_LONG                   MACRO_CONCAT(CUBE_PREFIX,RESPONSE_LONG)
#define CUBE_RESPONSE_NO                     MACRO_CONCAT(CUBE_PREFIX,RESPONSE_NO)
#define CUBE_RESPONSE_SHORT                  MACRO_CONCAT(CUBE_PREFIX,RESPONSE_SHORT)
#define CUBE_WAIT_NO                         MACRO_CONCAT(CUBE_PREFIX,WAIT_NO)
#define CUBE_CPSM_ENABLE                     MACRO_CONCAT(CUBE_PREFIX,CPSM_ENABLE)

#define CUBE_RESP1                           MACRO_CONCAT(CUBE_PREFIX,RESP1)
#define CUBE_RESP2                           MACRO_CONCAT(CUBE_PREFIX,RESP2)
#define CUBE_RESP3                           MACRO_CONCAT(CUBE_PREFIX,RESP3)
#define CUBE_RESP4                           MACRO_CONCAT(CUBE_PREFIX,RESP4)

#define CUBE_SendCommand                     MACRO_CONCAT(CUBE_PREFIX,SendCommand)
#define CUBE_GetResponse                     MACRO_CONCAT(CUBE_PREFIX,GetResponse)

#define CUBE_CmdInitTypeDef                  MACRO_CONCAT(CUBE_PREFIX,CmdInitTypeDef)

#endif /* SRC_DRIVERS_MMC_HOST_STM32CUBE_SDIO_STM32CUBE_DEFINITIONS_H_ */