/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Unlicense OR CC0-1.0
 */

typedef struct {
    uint32_t address;
    uint8_t ciphertext[128];
} xts_aes_test;

static const uint8_t plaintext[128] = {
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
    0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20,
    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
    0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
    0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
    0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
    0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
    0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80,
};

#if SOC_FLASH_ENCRYPTION_XTS_AES_128
/* Test cases generated with aes_xts_algorithm.py */
static const xts_aes_test tests_xts_aes_128[] = {
    {
        .address = 0x00160000,
        .ciphertext = {
            0x1a, 0x90, 0x01, 0x64, 0xfd, 0xc6, 0xee, 0x40, 0xce, 0x8c, 0x20, 0xc4, 0x73, 0x4b, 0x50, 0xeb,
            0xc8, 0x39, 0xab, 0x38, 0x25, 0x24, 0x88, 0xd7, 0x21, 0xc1, 0x8f, 0xe5, 0x0f, 0xd2, 0x4f, 0xb2,
            0xe9, 0xc2, 0x29, 0x1d, 0xbb, 0x8f, 0xcc, 0xf1, 0xbc, 0xb1, 0x49, 0xda, 0x69, 0x7e, 0xa1, 0x64,
            0xb3, 0x81, 0x80, 0x4c, 0xb3, 0x5f, 0x1a, 0x17, 0xb7, 0x63, 0x69, 0xb4, 0xa0, 0x23, 0x3b, 0xf4,
            0xa3, 0x68, 0x5e, 0x72, 0xcf, 0x2d, 0xa5, 0x92, 0x1b, 0xb0, 0x7a, 0x9e, 0x0e, 0x28, 0x14, 0x45,
            0xe9, 0x55, 0x5d, 0x3a, 0x1e, 0xf9, 0x12, 0x51, 0xfd, 0x59, 0x56, 0x8b, 0x45, 0xb0, 0x42, 0x7a,
            0xb1, 0x68, 0x2e, 0x73, 0x10, 0xe2, 0x9f, 0x43, 0xf6, 0xfe, 0x2c, 0xbf, 0xd7, 0xd3, 0xce, 0x1e,
            0x90, 0x32, 0x5d, 0xae, 0xd4, 0x6f, 0x82, 0x73, 0x91, 0x8f, 0x58, 0xbe, 0x9d, 0xe4, 0xf6, 0x82,
        },
    },
    {
        .address = 0x00160010,
        .ciphertext = {
            0xbf, 0x76, 0x07, 0x12, 0xb2, 0xe9, 0x04, 0xa5, 0xa7, 0x28, 0xac, 0xd9, 0xe0, 0x9b, 0xd3, 0xf8,
            0x99, 0xd2, 0xc9, 0x17, 0xd6, 0xff, 0xbd, 0x95, 0x9a, 0xc8, 0x0e, 0xc6, 0x32, 0x94, 0x54, 0x00,
            0x16, 0x5a, 0x78, 0x2c, 0xa1, 0xda, 0x6a, 0x3e, 0x4f, 0x72, 0xd1, 0x6b, 0x43, 0x49, 0x48, 0x8a,
            0xba, 0x81, 0xf0, 0xad, 0x5f, 0xc1, 0xef, 0xe8, 0x33, 0x41, 0xb8, 0x3b, 0x77, 0xd5, 0x2a, 0xe0,
            0xd6, 0x6d, 0x0b, 0x9a, 0x8a, 0xcc, 0xcb, 0x45, 0xd3, 0x40, 0x03, 0x50, 0xd2, 0x9c, 0xc9, 0x22,
            0xbd, 0xcd, 0x30, 0x8f, 0xa7, 0x3f, 0xa2, 0xc4, 0x46, 0x0a, 0x5c, 0xb9, 0x09, 0x86, 0xe3, 0x6d,
            0xc1, 0x31, 0xd2, 0x69, 0x82, 0x89, 0x85, 0x25, 0x38, 0x7f, 0x4b, 0x86, 0xfc, 0xad, 0xb5, 0x8b,
            0xb5, 0xe6, 0x8f, 0x83, 0x5b, 0x9a, 0xdc, 0x5a, 0x1e, 0x5c, 0xaa, 0xd6, 0x44, 0x57, 0x5d, 0xd8,
        },
    },
    {
        .address = 0x00160020,
        .ciphertext = {
            0xe5, 0x16, 0x28, 0x30, 0xb4, 0x4e, 0x14, 0xde, 0xbc, 0x48, 0x3b, 0x4e, 0x5b, 0xbe, 0x6a, 0x65,
            0x37, 0x9b, 0x00, 0x7a, 0x4e, 0x9c, 0x0e, 0xee, 0x24, 0xc8, 0x6e, 0xf5, 0xf6, 0x03, 0x4a, 0xce,
            0x7b, 0xac, 0x7b, 0x9e, 0x1c, 0x3b, 0x96, 0x3d, 0xd4, 0x15, 0xea, 0x94, 0xe3, 0x3b, 0x69, 0x3b,
            0xe0, 0x1a, 0xbd, 0xf6, 0xc9, 0xe9, 0x6b, 0x16, 0xc7, 0xc5, 0x5d, 0xda, 0x27, 0x59, 0xb8, 0x32,
            0x32, 0xa0, 0x68, 0x90, 0xe6, 0x5f, 0x14, 0x91, 0x05, 0xbc, 0x13, 0xcb, 0xfa, 0x61, 0x0a, 0x1d,
            0xf3, 0xa4, 0x41, 0x60, 0xec, 0x2d, 0xcb, 0x19, 0x6d, 0x9b, 0xc6, 0xac, 0x4f, 0x45, 0x8f, 0xc0,
            0x6b, 0x02, 0x12, 0x21, 0x3c, 0x01, 0x4d, 0xaa, 0xad, 0xee, 0x48, 0x9a, 0xda, 0x25, 0x20, 0xcd,
            0xc8, 0x24, 0x43, 0x14, 0x95, 0xbc, 0xf0, 0x7c, 0xdb, 0xe0, 0x29, 0x8e, 0x5b, 0x61, 0x1d, 0x65,
        },
    },
    {
        .address = 0x00160030,
        .ciphertext = {
            0x0c, 0x1a, 0x8a, 0x43, 0x2c, 0x0b, 0xea, 0xc5, 0x30, 0x33, 0x25, 0xd2, 0x5e, 0x7e, 0x51, 0xac,
            0x1b, 0x85, 0xdb, 0xb1, 0xc8, 0x2f, 0xde, 0x15, 0x08, 0x2c, 0xe8, 0xe4, 0x35, 0x64, 0xc6, 0x6e,
            0x4a, 0x59, 0x33, 0xb4, 0xbd, 0xb7, 0x30, 0x2b, 0x7f, 0x00, 0xf1, 0x85, 0xb8, 0x40, 0x86, 0xee,
            0x8b, 0xd9, 0xd7, 0x60, 0x77, 0x08, 0xdd, 0x94, 0xc2, 0xe4, 0x81, 0x0c, 0xef, 0x69, 0x6b, 0x20,
            0xf8, 0x0e, 0x43, 0xe9, 0x6c, 0xa7, 0xb8, 0x4b, 0x15, 0x19, 0xd6, 0xfa, 0xf9, 0x81, 0x76, 0xd2,
            0x70, 0xb4, 0x72, 0x93, 0xfa, 0xb9, 0x67, 0x74, 0x1c, 0xdf, 0x7d, 0xf2, 0x23, 0x06, 0xb1, 0x1b,
            0x06, 0xb3, 0x41, 0xae, 0x63, 0x99, 0x38, 0x42, 0x37, 0xbd, 0xcb, 0xe1, 0xef, 0xef, 0x4f, 0xbb,
            0xd7, 0x2d, 0xbb, 0xcb, 0xa5, 0xe7, 0xfb, 0x8f, 0xf0, 0xba, 0xb4, 0x8d, 0x22, 0x3d, 0xdf, 0x09,
        },
    },
    {
        .address = 0x00160040,
        .ciphertext = {
            0x66, 0x99, 0xfb, 0x9c, 0x86, 0x4e, 0x3e, 0x29, 0x57, 0xc3, 0xc8, 0x4f, 0x3c, 0xac, 0x25, 0x4b,
            0x3a, 0x2b, 0xbf, 0xac, 0x30, 0xbd, 0x55, 0xb2, 0xdc, 0xd9, 0xf1, 0x67, 0xbf, 0x53, 0xd8, 0x83,
            0x3a, 0x33, 0x85, 0xa8, 0x0d, 0x85, 0x5c, 0xde, 0x10, 0x69, 0xb7, 0xfc, 0xd3, 0x48, 0x01, 0xcd,
            0x7d, 0x94, 0x8b, 0x16, 0x0e, 0xf8, 0x76, 0xb1, 0x07, 0xf7, 0x84, 0xb5, 0x7f, 0xff, 0x08, 0xf7,
            0x70, 0x54, 0x50, 0xfd, 0xe4, 0x31, 0xe9, 0x62, 0x8e, 0x90, 0x94, 0xb1, 0x8c, 0x80, 0xaf, 0xf0,
            0x55, 0x36, 0x8e, 0x31, 0x2e, 0x91, 0xa3, 0x9e, 0x93, 0xc1, 0xb8, 0x7b, 0x78, 0xa9, 0xf2, 0xe0,
            0x62, 0xde, 0x06, 0x44, 0x6a, 0xf5, 0x4b, 0xfb, 0x15, 0xeb, 0x67, 0xb6, 0xe7, 0x6b, 0x6c, 0x81,
            0x49, 0x90, 0x33, 0xe4, 0x1c, 0xa1, 0x4b, 0x68, 0xda, 0x1d, 0x47, 0x33, 0xc3, 0x95, 0xff, 0xae,
        },
    },
    {
        .address = 0x00160050,
        .ciphertext = {
            0xf9, 0x35, 0x63, 0xf6, 0x9b, 0x1e, 0xd6, 0xd8, 0xcf, 0xb2, 0x61, 0x35, 0xb0, 0x44, 0xe8, 0x9c,
            0xc3, 0x36, 0x3d, 0xfd, 0x1d, 0xd5, 0x90, 0xc0, 0xd5, 0x20, 0x5d, 0x0c, 0xac, 0x22, 0x42, 0xb2,
            0x19, 0x9d, 0x3d, 0xb4, 0xc2, 0x82, 0x94, 0xfd, 0x39, 0x99, 0x43, 0xfc, 0xa9, 0x2b, 0xc3, 0x6a,
            0x9f, 0xd5, 0x95, 0xb9, 0xdc, 0xa4, 0xaa, 0x64, 0xce, 0x06, 0x24, 0x9e, 0x77, 0x99, 0xab, 0x9d,
            0x97, 0x1f, 0x5d, 0x29, 0x4b, 0xdc, 0xa8, 0x6b, 0xc6, 0x8a, 0x66, 0xe3, 0xe8, 0x7c, 0x0f, 0x67,
            0x48, 0xe1, 0x02, 0x93, 0xac, 0xe2, 0x0f, 0x41, 0x11, 0x7c, 0xb2, 0xc0, 0x1e, 0x3e, 0xd8, 0x8e,
            0xaa, 0x2c, 0xa5, 0x5a, 0xef, 0x52, 0x35, 0x34, 0x9b, 0x20, 0x8f, 0x6c, 0xea, 0x7c, 0xd4, 0x22,
            0xe5, 0x31, 0xb1, 0xbf, 0xc6, 0x0f, 0xd7, 0x86, 0xb0, 0x64, 0xc1, 0x7a, 0xb5, 0xf1, 0xda, 0x03,
        },
    },
    {
        .address = 0x00160060,
        .ciphertext = {
            0x9c, 0x04, 0x31, 0x2d, 0xd7, 0x9e, 0x8a, 0x2d, 0x63, 0x30, 0xb0, 0xec, 0xb6, 0x93, 0x5c, 0x48,
            0x0b, 0x46, 0xc8, 0x39, 0x4e, 0x31, 0x88, 0x32, 0x9a, 0x77, 0xd6, 0x00, 0x91, 0x7f, 0x35, 0x3c,
            0x21, 0xb2, 0xeb, 0x52, 0xc4, 0xbc, 0x5e, 0xc8, 0x10, 0x5d, 0x3f, 0x83, 0x27, 0x17, 0x0c, 0x25,
            0xb0, 0x00, 0xee, 0x7e, 0x0c, 0x32, 0x6c, 0x01, 0xa7, 0x0b, 0x2b, 0x40, 0xfe, 0x01, 0x23, 0x75,
            0x10, 0xae, 0x6f, 0x34, 0x3a, 0xb0, 0xa3, 0x1d, 0xf4, 0xb1, 0x7a, 0x75, 0x52, 0xfa, 0x0f, 0xd9,
            0xe6, 0x82, 0xff, 0xc3, 0xf9, 0xd6, 0xd2, 0x91, 0xd9, 0x15, 0x10, 0x18, 0x7e, 0x60, 0x59, 0x88,
            0xff, 0x92, 0xf9, 0xf9, 0xa0, 0x00, 0xa0, 0xab, 0x9e, 0xef, 0x4d, 0x4b, 0x73, 0x85, 0x29, 0x35,
            0x94, 0x59, 0xcc, 0x77, 0x28, 0xa3, 0x86, 0xba, 0x1a, 0x4f, 0xdb, 0x90, 0xd8, 0x05, 0x41, 0xc0,
        },
    },
    {
        .address = 0x00160070,
        .ciphertext = {
            0x37, 0x3a, 0xc7, 0x18, 0xf6, 0x3c, 0xbc, 0x52, 0xab, 0xb9, 0x1a, 0x28, 0xa0, 0xff, 0x40, 0xef,
            0xaf, 0xaa, 0x9c, 0x95, 0xe5, 0xa6, 0x59, 0x58, 0x05, 0xe6, 0xd2, 0x9f, 0x2e, 0x82, 0x65, 0xd6,
            0x23, 0xf9, 0x76, 0x92, 0x21, 0xed, 0xf5, 0xd4, 0x78, 0xf0, 0xb8, 0xc7, 0x85, 0xe3, 0x0e, 0xb2,
            0xeb, 0x26, 0xe6, 0x5f, 0xc2, 0x47, 0x64, 0xdf, 0xa5, 0x60, 0x3c, 0x5a, 0x87, 0x54, 0x8c, 0xab,
            0xd5, 0xa9, 0x0b, 0x7b, 0xba, 0x01, 0x51, 0x47, 0x01, 0x4c, 0x65, 0xce, 0x29, 0xf9, 0xc3, 0x64,
            0x8d, 0x43, 0xf8, 0xb0, 0x3c, 0x6a, 0xe3, 0x97, 0x56, 0x4d, 0xd4, 0x02, 0xef, 0x09, 0xdd, 0x9c,
            0xd4, 0x8f, 0xff, 0xb9, 0xb0, 0xd2, 0x35, 0xca, 0x41, 0x64, 0x74, 0x4b, 0x64, 0x1e, 0x0e, 0xe6,
            0x47, 0x7a, 0x81, 0xd8, 0xa1, 0x79, 0x49, 0x7c, 0x36, 0x6b, 0xc9, 0xaf, 0x82, 0x3d, 0x72, 0xd8,
        },
    },
};
#endif

#if SOC_FLASH_ENCRYPTION_XTS_AES_256
static const xts_aes_test tests_xts_aes_256[] = {
    {
        .address = 0x00160000,
        .ciphertext = {
            0x42, 0xfe, 0x14, 0xf3, 0x9c, 0x9e, 0xaf, 0xd9, 0x6d, 0xba, 0x8d, 0x90, 0x2b, 0x89, 0x4e, 0x3d,
            0x94, 0xb3, 0x51, 0x70, 0xeb, 0x17, 0x57, 0xed, 0x8b, 0x8f, 0xdf, 0x9a, 0xa6, 0x60, 0xb4, 0x0e,
            0xb8, 0xc6, 0xa0, 0x3f, 0xd7, 0x54, 0xc0, 0x9a, 0x06, 0xd9, 0xd4, 0xd9, 0x4c, 0x80, 0x29, 0x9a,
            0x7c, 0x55, 0xfa, 0x70, 0xf3, 0x62, 0x1e, 0xcf, 0x74, 0x09, 0x12, 0x62, 0x14, 0x12, 0xaa, 0xce,
            0x9b, 0x2e, 0x99, 0x29, 0x04, 0xbd, 0xf5, 0x72, 0xe1, 0xef, 0xf9, 0x56, 0x5d, 0xca, 0x60, 0xcc,
            0xa8, 0x5c, 0x35, 0xe2, 0xf5, 0x0a, 0x7c, 0x51, 0x50, 0x3e, 0x0c, 0x16, 0xbf, 0x4b, 0xdf, 0x72,
            0x5a, 0x87, 0x71, 0xfa, 0x9f, 0x85, 0xb4, 0x6c, 0x09, 0x43, 0x42, 0x8c, 0x5e, 0x12, 0x2a, 0x2d,
            0xd8, 0xa1, 0xe7, 0x1a, 0x34, 0xff, 0xec, 0x9b, 0x32, 0x84, 0xc3, 0x90, 0xb0, 0x93, 0x14, 0x59,
        },
    },
    {
        .address = 0x00160010,
        .ciphertext = {
            0x08, 0xd3, 0xff, 0x75, 0x1e, 0x57, 0xaa, 0xf7, 0xd4, 0x24, 0x94, 0xec, 0xf8, 0x1c, 0xbd, 0xff,
            0x82, 0xd2, 0x63, 0x88, 0x76, 0x5b, 0x04, 0xf9, 0x28, 0x75, 0xf9, 0x6d, 0x66, 0x40, 0xe5, 0xfc,
            0x50, 0x09, 0xf0, 0xa3, 0x73, 0x50, 0xeb, 0x2c, 0x78, 0x5a, 0x9d, 0xa7, 0x4e, 0x08, 0x2a, 0x36,
            0x7c, 0xf0, 0x49, 0xf2, 0x9b, 0x41, 0xe0, 0xf8, 0xed, 0x93, 0xa8, 0xd3, 0x68, 0xe4, 0x15, 0x79,
            0xca, 0xf3, 0xd6, 0xf7, 0x67, 0xc4, 0x07, 0x7f, 0x3e, 0xb3, 0x49, 0x20, 0xce, 0xbd, 0x87, 0xac,
            0x6c, 0x20, 0x4e, 0xc6, 0x62, 0x03, 0x21, 0xb7, 0xe5, 0xc5, 0xa4, 0x04, 0x1c, 0x6e, 0x7d, 0x6c,
            0x93, 0x9e, 0x3d, 0x6a, 0x9a, 0x22, 0x7d, 0x74, 0xd6, 0x34, 0xaf, 0x96, 0x04, 0x34, 0x3b, 0x83,
            0x05, 0xfb, 0x56, 0x67, 0xfa, 0x55, 0x95, 0x0f, 0xd5, 0x01, 0xf7, 0x64, 0xb7, 0x99, 0x92, 0x79,
        },
    },
    {
        .address = 0x00160020,
        .ciphertext = {
            0x0c, 0x92, 0x23, 0x69, 0x70, 0xf9, 0x7a, 0x08, 0x7b, 0x3d, 0x4b, 0x2e, 0xda, 0xc4, 0x94, 0x40,
            0xb5, 0x55, 0xde, 0xb9, 0x81, 0xbf, 0x65, 0x13, 0x6c, 0x14, 0x45, 0xbe, 0x10, 0xdb, 0x0b, 0x29,
            0x6b, 0xd0, 0x60, 0x05, 0x5a, 0x13, 0x94, 0xbf, 0xaa, 0x31, 0xfd, 0x60, 0x3b, 0xfb, 0x30, 0x8a,
            0x4e, 0x98, 0xfd, 0x05, 0x33, 0xeb, 0x06, 0xa4, 0x77, 0xd2, 0xa4, 0x1c, 0x5a, 0x80, 0x57, 0x1b,
            0x14, 0x4d, 0x38, 0xc2, 0x02, 0x0b, 0x0d, 0xb6, 0xf7, 0x5e, 0x85, 0xa5, 0xa7, 0x9b, 0x0d, 0xfb,
            0x64, 0xa7, 0x95, 0x77, 0xf9, 0x64, 0x32, 0x64, 0xa8, 0x97, 0xc0, 0xf8, 0x52, 0xe0, 0x5f, 0x95,
            0x8e, 0xf9, 0xbd, 0x7e, 0x1a, 0xe9, 0xeb, 0xcb, 0xd3, 0xcb, 0x19, 0x8a, 0xce, 0x5f, 0xd9, 0xef,
            0xc0, 0xb1, 0x9b, 0x79, 0x6d, 0xe9, 0x80, 0x47, 0x17, 0xf0, 0x6b, 0x1e, 0x0c, 0x4c, 0xdc, 0x2a,
        },
    },
    {
        .address = 0x00160030,
        .ciphertext = {
            0xe1, 0x85, 0xc0, 0x9a, 0xd8, 0x5e, 0x26, 0xd8, 0xc5, 0x8c, 0xbb, 0xf0, 0xf1, 0x3e, 0x40, 0xbd,
            0x6b, 0x9b, 0x81, 0x08, 0x93, 0x2d, 0xce, 0x2e, 0x27, 0xe4, 0xbe, 0xc4, 0xea, 0x93, 0xc8, 0xaa,
            0x6a, 0x22, 0x29, 0xfc, 0x7b, 0x91, 0x70, 0x48, 0x15, 0x19, 0x46, 0xd0, 0x3b, 0x39, 0x67, 0xa3,
            0xa6, 0x2f, 0x91, 0xd5, 0xe7, 0x80, 0x17, 0x0d, 0xee, 0xe4, 0x3d, 0x54, 0xf2, 0xf9, 0x6b, 0x7c,
            0x2c, 0x5b, 0x63, 0xf3, 0xaa, 0x54, 0x68, 0xa5, 0xda, 0x3e, 0xa0, 0x09, 0x4a, 0x56, 0x95, 0x6b,
            0x4d, 0xcc, 0x21, 0xb7, 0x0e, 0x38, 0x00, 0xc7, 0x35, 0x03, 0xb8, 0x2b, 0x71, 0xfb, 0x33, 0x1d,
            0x39, 0xdd, 0xd5, 0xdf, 0xc2, 0x16, 0xf5, 0x0e, 0xf8, 0x7f, 0x8d, 0x77, 0x0c, 0x8b, 0xa6, 0xf3,
            0xb2, 0x42, 0x1a, 0x50, 0x7a, 0x33, 0x63, 0xef, 0xbf, 0x73, 0x3e, 0xaa, 0xc4, 0xeb, 0xcf, 0xc4,
        },
    },
    {
        .address = 0x00160040,
        .ciphertext = {
            0x65, 0x17, 0xb9, 0xc9, 0x17, 0xde, 0xba, 0x6c, 0x6a, 0xe6, 0xfb, 0xbf, 0xdd, 0xbf, 0x71, 0xdc,
            0xb4, 0x41, 0x38, 0x21, 0x0d, 0x18, 0x8d, 0x30, 0x40, 0x67, 0x07, 0x88, 0x09, 0x62, 0xf9, 0x55,
            0xbc, 0x82, 0x29, 0xf7, 0xca, 0x87, 0x1d, 0x4a, 0x22, 0x80, 0xee, 0x80, 0xb4, 0x26, 0x61, 0x68,
            0xcc, 0x1d, 0x36, 0xc8, 0x4f, 0x57, 0x0d, 0xca, 0xd0, 0x22, 0x0d, 0x78, 0xa9, 0xc5, 0x04, 0x9f,
            0x8e, 0xa3, 0x96, 0x47, 0x51, 0xf2, 0x8b, 0xbf, 0x39, 0xfa, 0xa2, 0x30, 0x12, 0xfa, 0xcc, 0x2f,
            0x08, 0xcc, 0x33, 0x0f, 0x61, 0x96, 0xcc, 0x8d, 0xb8, 0x5f, 0x29, 0xbd, 0x6b, 0x1e, 0xe4, 0x74,
            0x32, 0x70, 0xc3, 0x69, 0x6d, 0xf0, 0x4b, 0xf9, 0x04, 0x13, 0x4a, 0x47, 0xf6, 0xa6, 0xd4, 0x95,
            0x3e, 0x6a, 0x56, 0x66, 0xd7, 0xe9, 0x94, 0x9a, 0x2f, 0xe4, 0x9b, 0x2e, 0x82, 0x32, 0x97, 0x2f,
        },
    },
    {
        .address = 0x00160050,
        .ciphertext = {
            0x4a, 0xe0, 0xa5, 0xd6, 0x11, 0xf3, 0x7e, 0x57, 0xf2, 0x3e, 0x7f, 0x4e, 0x14, 0xa8, 0x0f, 0x4e,
            0xf3, 0x24, 0x93, 0x11, 0x74, 0x48, 0x2e, 0xa4, 0xc0, 0x9e, 0xa0, 0xf2, 0xc2, 0x60, 0xe9, 0x84,
            0x6c, 0x86, 0x1d, 0xbd, 0x0e, 0xa7, 0x9c, 0x8c, 0x1b, 0xf2, 0xb7, 0x39, 0xbc, 0xd4, 0x31, 0x43,
            0x7b, 0x4c, 0x6d, 0x81, 0x18, 0x76, 0xa4, 0x4f, 0x9b, 0x60, 0xeb, 0x43, 0xc0, 0xcf, 0x83, 0x48,
            0x0b, 0x0f, 0xcf, 0x94, 0x61, 0x57, 0x58, 0x67, 0x5c, 0xbf, 0x27, 0x93, 0xd4, 0x5b, 0xc7, 0xae,
            0x22, 0x84, 0x41, 0xcd, 0x4e, 0x97, 0xac, 0x05, 0xce, 0x94, 0x97, 0xf7, 0x49, 0xd5, 0x1a, 0x37,
            0x7d, 0x2c, 0x10, 0x8e, 0xd9, 0x8e, 0x98, 0x60, 0x1c, 0x59, 0xd5, 0x09, 0x9e, 0x6d, 0x21, 0xdf,
            0x1b, 0x09, 0x98, 0xdc, 0x7f, 0x8b, 0x7f, 0x62, 0xa9, 0xf1, 0x5c, 0x54, 0xd4, 0x73, 0x90, 0x6a,
        },
    },
    {
        .address = 0x00160060,
        .ciphertext = {
            0x1c, 0x36, 0xb4, 0x70, 0xfc, 0x41, 0xbb, 0x9e, 0x12, 0x52, 0xd6, 0xa5, 0xff, 0xb3, 0x2c, 0x70,
            0x4e, 0x64, 0xa6, 0xe9, 0xe5, 0x79, 0xed, 0x62, 0xe1, 0x02, 0xd7, 0xf7, 0xc3, 0x3c, 0x5c, 0xea,
            0x47, 0xd4, 0xdd, 0x12, 0x09, 0x51, 0x32, 0xf6, 0x25, 0xaa, 0xd8, 0x91, 0x9c, 0xfa, 0xab, 0x62,
            0x09, 0x46, 0x4b, 0x4b, 0x8b, 0xbe, 0x11, 0x60, 0x44, 0xa1, 0xf2, 0x19, 0xa5, 0x6d, 0xe1, 0x69,
            0x54, 0xe9, 0x27, 0x33, 0x55, 0x10, 0xfa, 0xb6, 0xd2, 0x0d, 0x09, 0x5f, 0xf0, 0xa5, 0xab, 0x30,
            0xd7, 0xda, 0xab, 0xf8, 0x0f, 0xfd, 0x7e, 0xd9, 0xad, 0x7f, 0xb0, 0x0c, 0xae, 0x45, 0x07, 0x98,
            0x86, 0x09, 0x9c, 0xf7, 0x3b, 0xaf, 0x12, 0x01, 0x68, 0xb6, 0x69, 0x13, 0x8d, 0xcd, 0xbf, 0x8e,
            0xbb, 0xff, 0x17, 0x35, 0x47, 0x86, 0x4f, 0x45, 0x3d, 0x77, 0x44, 0xd1, 0xc3, 0x2e, 0x9a, 0xf9,
        },
    },
    {
        .address = 0x00160070,
        .ciphertext = {
            0xc9, 0x57, 0xb5, 0x8e, 0xd5, 0x82, 0xff, 0xf5, 0xa8, 0x49, 0x18, 0x1f, 0x29, 0x21, 0xff, 0xa7,
            0xf5, 0x8c, 0xf7, 0x72, 0xfe, 0x4c, 0x90, 0xba, 0xa9, 0x03, 0x50, 0x93, 0x4c, 0x69, 0xcb, 0xd6,
            0x0a, 0x0b, 0x7a, 0xc2, 0x97, 0xff, 0x3d, 0xc9, 0x4e, 0xa9, 0xd2, 0x62, 0x1f, 0x4d, 0xd8, 0xf5,
            0x48, 0x9d, 0xba, 0xee, 0x0e, 0x78, 0xcb, 0xe4, 0xee, 0x27, 0x4e, 0x2a, 0xd1, 0xcd, 0xae, 0xb7,
            0xdc, 0x5c, 0x5b, 0xcf, 0x7a, 0x44, 0xf4, 0xe7, 0xe2, 0x18, 0xbe, 0xf4, 0xb9, 0x4f, 0x3a, 0xb6,
            0x65, 0x78, 0x03, 0x06, 0x08, 0x1a, 0xb2, 0x60, 0x4b, 0x5b, 0x9e, 0x86, 0xc0, 0x90, 0x50, 0xc9,
            0xd4, 0xba, 0xee, 0xe4, 0xd0, 0x4a, 0xb3, 0x5d, 0x2f, 0x3e, 0x59, 0x4f, 0xcf, 0xe6, 0xef, 0x46,
            0x6a, 0xb0, 0xfb, 0x5e, 0x50, 0xf3, 0x96, 0xff, 0x62, 0x19, 0xb8, 0xd2, 0x49, 0x64, 0x86, 0x34,
        },
    },
};
#endif
