/*
 *  Copyright (c) 2023, The OpenThread Authors.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the copyright holder nor the
 *     names of its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file
 * @brief
 *  This file defines the Doxygen group structure for OpenThread documentation.
 */

/**
 * @defgroup config                   Config Variables
 * @brief
 *   This module lists all OpenThread configuration variables.
 *
 * @{
 *
 * @defgroup config-announce-sender          Announce Sender
 * @defgroup config-backbone-router          Backbone Router Services
 * @defgroup config-border-agent             Border Agent
 * @defgroup config-border-router            Border Router
 * @defgroup config-border-routing           Border Routing Manager
 * @defgroup config-channel-manager          Channel Manager
 * @defgroup config-channel-monitor          Channel Monitor
 * @defgroup config-child-supervision        Child Supervision
 * @defgroup config-coap                     CoAP
 * @defgroup config-commissioner             Commissioner
 * @defgroup config-crypto                   Crypto Backend Library
 * @defgroup config-dataset-updater          Dataset Updater
 * @defgroup config-dhcpv6-client            DHCPv6 Client
 * @defgroup config-dhcpv6-server            DHCPv6 Server
 * @defgroup config-diag                     DIAG Service
 * @defgroup config-dns-client               DNS Client
 * @defgroup config-dns-dso                  DNS Stateful Operations
 * @defgroup config-dnssd-server             DNS-SD Server
 * @defgroup config-history-tracker          History Tracker
 * @defgroup config-ip6                      IP6 Service
 * @defgroup config-joiner                   Joiner
 * @defgroup config-link-metrics-manager     Link Metrics Manager
 * @defgroup config-link-quality             Link Quality
 * @defgroup config-link-raw                 Link Raw Service
 * @defgroup config-logging                  Logging Service
 * @defgroup config-mac                      MAC
 * @defgroup config-mesh-diag                Mesh Diagnostic
 * @defgroup config-mesh-forwarder           Mesh Forwarder
 * @defgroup config-misc                     Miscellaneous Constants
 * @defgroup config-mle                      MLE Service
 * @defgroup config-mdns                     Multicast DNS
 * @defgroup config-nat64                    NAT64
 * @defgroup config-netdata-publisher        Network Data Publisher
 * @defgroup config-network-diagnostic       Network Diagnostics
 * @defgroup config-p2p                      Peer-to-Peer
 * @defgroup config-parent-search            Parent Search
 * @defgroup config-ping-sender              Ping Sender
 * @defgroup config-platform                 Platform Specific Services
 * @defgroup config-power-calibration        Power Calibration
 * @defgroup config-radio-link               Radio Links
 * @defgroup config-secure-transport         Secure Transport
 * @defgroup config-sntp-client              SNTP Client
 * @defgroup config-srp-client               SRP Client
 * @defgroup config-srp-server               SRP Server
 * @defgroup config-time-sync                Time Sync Service
 * @defgroup config-tmf                      Thread Management Framework Service
 * @defgroup config-trel                     TREL
 * @defgroup config-wakeup                   Wake-up
 *
 * @}
 */
