/**
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** LPPERI_CLK_EN_REG register
 *  need_des
 */
#define LPPERI_CLK_EN_REG (DR_REG_LPPERI_BASE + 0x0)
/** LPPERI_RNG_CK_EN : R/W; bitpos: [24]; default: 1;
 *  need_des
 */
#define LPPERI_RNG_CK_EN    (BIT(24))
#define LPPERI_RNG_CK_EN_M  (LPPERI_RNG_CK_EN_V << LPPERI_RNG_CK_EN_S)
#define LPPERI_RNG_CK_EN_V  0x00000001U
#define LPPERI_RNG_CK_EN_S  24
/** LPPERI_OTP_DBG_CK_EN : R/W; bitpos: [25]; default: 1;
 *  need_des
 */
#define LPPERI_OTP_DBG_CK_EN    (BIT(25))
#define LPPERI_OTP_DBG_CK_EN_M  (LPPERI_OTP_DBG_CK_EN_V << LPPERI_OTP_DBG_CK_EN_S)
#define LPPERI_OTP_DBG_CK_EN_V  0x00000001U
#define LPPERI_OTP_DBG_CK_EN_S  25
/** LPPERI_LP_IO_CK_EN : R/W; bitpos: [27]; default: 1;
 *  need_des
 */
#define LPPERI_LP_IO_CK_EN    (BIT(27))
#define LPPERI_LP_IO_CK_EN_M  (LPPERI_LP_IO_CK_EN_V << LPPERI_LP_IO_CK_EN_S)
#define LPPERI_LP_IO_CK_EN_V  0x00000001U
#define LPPERI_LP_IO_CK_EN_S  27
/** LPPERI_EFUSE_CK_EN : R/W; bitpos: [30]; default: 1;
 *  need_des
 */
#define LPPERI_EFUSE_CK_EN    (BIT(30))
#define LPPERI_EFUSE_CK_EN_M  (LPPERI_EFUSE_CK_EN_V << LPPERI_EFUSE_CK_EN_S)
#define LPPERI_EFUSE_CK_EN_V  0x00000001U
#define LPPERI_EFUSE_CK_EN_S  30
/** LPPERI_LP_CPU_CK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LPPERI_LP_CPU_CK_EN    (BIT(31))
#define LPPERI_LP_CPU_CK_EN_M  (LPPERI_LP_CPU_CK_EN_V << LPPERI_LP_CPU_CK_EN_S)
#define LPPERI_LP_CPU_CK_EN_V  0x00000001U
#define LPPERI_LP_CPU_CK_EN_S  31

/** LPPERI_RESET_EN_REG register
 *  need_des
 */
#define LPPERI_RESET_EN_REG (DR_REG_LPPERI_BASE + 0x4)
/** LPPERI_BUS_RESET_EN : WT; bitpos: [23]; default: 0;
 *  need_des
 */
#define LPPERI_BUS_RESET_EN    (BIT(23))
#define LPPERI_BUS_RESET_EN_M  (LPPERI_BUS_RESET_EN_V << LPPERI_BUS_RESET_EN_S)
#define LPPERI_BUS_RESET_EN_V  0x00000001U
#define LPPERI_BUS_RESET_EN_S  23
/** LPPERI_LP_RNG_RESET_EN : R/W; bitpos: [24]; default: 0;
 *  need_des
 */
#define LPPERI_LP_RNG_RESET_EN    (BIT(24))
#define LPPERI_LP_RNG_RESET_EN_M  (LPPERI_LP_RNG_RESET_EN_V << LPPERI_LP_RNG_RESET_EN_S)
#define LPPERI_LP_RNG_RESET_EN_V  0x00000001U
#define LPPERI_LP_RNG_RESET_EN_S  24
/** LPPERI_OTP_DBG_RESET_EN : R/W; bitpos: [25]; default: 0;
 *  need_des
 */
#define LPPERI_OTP_DBG_RESET_EN    (BIT(25))
#define LPPERI_OTP_DBG_RESET_EN_M  (LPPERI_OTP_DBG_RESET_EN_V << LPPERI_OTP_DBG_RESET_EN_S)
#define LPPERI_OTP_DBG_RESET_EN_V  0x00000001U
#define LPPERI_OTP_DBG_RESET_EN_S  25
/** LPPERI_LP_IO_RESET_EN : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LPPERI_LP_IO_RESET_EN    (BIT(27))
#define LPPERI_LP_IO_RESET_EN_M  (LPPERI_LP_IO_RESET_EN_V << LPPERI_LP_IO_RESET_EN_S)
#define LPPERI_LP_IO_RESET_EN_V  0x00000001U
#define LPPERI_LP_IO_RESET_EN_S  27
/** LPPERI_EFUSE_RESET_EN : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LPPERI_EFUSE_RESET_EN    (BIT(30))
#define LPPERI_EFUSE_RESET_EN_M  (LPPERI_EFUSE_RESET_EN_V << LPPERI_EFUSE_RESET_EN_S)
#define LPPERI_EFUSE_RESET_EN_V  0x00000001U
#define LPPERI_EFUSE_RESET_EN_S  30
/** LPPERI_LP_CPU_RESET_EN : WT; bitpos: [31]; default: 0;
 *  need_des
 */
#define LPPERI_LP_CPU_RESET_EN    (BIT(31))
#define LPPERI_LP_CPU_RESET_EN_M  (LPPERI_LP_CPU_RESET_EN_V << LPPERI_LP_CPU_RESET_EN_S)
#define LPPERI_LP_CPU_RESET_EN_V  0x00000001U
#define LPPERI_LP_CPU_RESET_EN_S  31

/** LPPERI_RNG_DATA_REG register
 *  need_des
 */
#define LPPERI_RNG_DATA_REG (DR_REG_LPPERI_BASE + 0x8)
/** LPPERI_RND_DATA : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LPPERI_RND_DATA    0xFFFFFFFFU
#define LPPERI_RND_DATA_M  (LPPERI_RND_DATA_V << LPPERI_RND_DATA_S)
#define LPPERI_RND_DATA_V  0xFFFFFFFFU
#define LPPERI_RND_DATA_S  0

/** LPPERI_CPU_REG register
 *  need_des
 */
#define LPPERI_CPU_REG (DR_REG_LPPERI_BASE + 0xc)
/** LPPERI_LPCORE_DBGM_UNAVALIABLE : R/W; bitpos: [31]; default: 1;
 *  need_des
 */
#define LPPERI_LPCORE_DBGM_UNAVALIABLE    (BIT(31))
#define LPPERI_LPCORE_DBGM_UNAVALIABLE_M  (LPPERI_LPCORE_DBGM_UNAVALIABLE_V << LPPERI_LPCORE_DBGM_UNAVALIABLE_S)
#define LPPERI_LPCORE_DBGM_UNAVALIABLE_V  0x00000001U
#define LPPERI_LPCORE_DBGM_UNAVALIABLE_S  31

/** LPPERI_BUS_TIMEOUT_REG register
 *  need_des
 */
#define LPPERI_BUS_TIMEOUT_REG (DR_REG_LPPERI_BASE + 0x10)
/** LPPERI_LP_PERI_TIMEOUT_THRES : R/W; bitpos: [29:14]; default: 65535;
 *  need_des
 */
#define LPPERI_LP_PERI_TIMEOUT_THRES    0x0000FFFFU
#define LPPERI_LP_PERI_TIMEOUT_THRES_M  (LPPERI_LP_PERI_TIMEOUT_THRES_V << LPPERI_LP_PERI_TIMEOUT_THRES_S)
#define LPPERI_LP_PERI_TIMEOUT_THRES_V  0x0000FFFFU
#define LPPERI_LP_PERI_TIMEOUT_THRES_S  14
/** LPPERI_LP_PERI_TIMEOUT_INT_CLEAR : WT; bitpos: [30]; default: 0;
 *  need_des
 */
#define LPPERI_LP_PERI_TIMEOUT_INT_CLEAR    (BIT(30))
#define LPPERI_LP_PERI_TIMEOUT_INT_CLEAR_M  (LPPERI_LP_PERI_TIMEOUT_INT_CLEAR_V << LPPERI_LP_PERI_TIMEOUT_INT_CLEAR_S)
#define LPPERI_LP_PERI_TIMEOUT_INT_CLEAR_V  0x00000001U
#define LPPERI_LP_PERI_TIMEOUT_INT_CLEAR_S  30
/** LPPERI_LP_PERI_TIMEOUT_PROTECT_EN : R/W; bitpos: [31]; default: 1;
 *  need_des
 */
#define LPPERI_LP_PERI_TIMEOUT_PROTECT_EN    (BIT(31))
#define LPPERI_LP_PERI_TIMEOUT_PROTECT_EN_M  (LPPERI_LP_PERI_TIMEOUT_PROTECT_EN_V << LPPERI_LP_PERI_TIMEOUT_PROTECT_EN_S)
#define LPPERI_LP_PERI_TIMEOUT_PROTECT_EN_V  0x00000001U
#define LPPERI_LP_PERI_TIMEOUT_PROTECT_EN_S  31

/** LPPERI_BUS_TIMEOUT_ADDR_REG register
 *  need_des
 */
#define LPPERI_BUS_TIMEOUT_ADDR_REG (DR_REG_LPPERI_BASE + 0x14)
/** LPPERI_LP_PERI_TIMEOUT_ADDR : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LPPERI_LP_PERI_TIMEOUT_ADDR    0xFFFFFFFFU
#define LPPERI_LP_PERI_TIMEOUT_ADDR_M  (LPPERI_LP_PERI_TIMEOUT_ADDR_V << LPPERI_LP_PERI_TIMEOUT_ADDR_S)
#define LPPERI_LP_PERI_TIMEOUT_ADDR_V  0xFFFFFFFFU
#define LPPERI_LP_PERI_TIMEOUT_ADDR_S  0

/** LPPERI_BUS_TIMEOUT_UID_REG register
 *  need_des
 */
#define LPPERI_BUS_TIMEOUT_UID_REG (DR_REG_LPPERI_BASE + 0x18)
/** LPPERI_LP_PERI_TIMEOUT_UID : RO; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define LPPERI_LP_PERI_TIMEOUT_UID    0x0000007FU
#define LPPERI_LP_PERI_TIMEOUT_UID_M  (LPPERI_LP_PERI_TIMEOUT_UID_V << LPPERI_LP_PERI_TIMEOUT_UID_S)
#define LPPERI_LP_PERI_TIMEOUT_UID_V  0x0000007FU
#define LPPERI_LP_PERI_TIMEOUT_UID_S  0

/** LPPERI_INTERRUPT_SOURCE_REG register
 *  need_des
 */
#define LPPERI_INTERRUPT_SOURCE_REG (DR_REG_LPPERI_BASE + 0x20)
/** LPPERI_LP_INTERRUPT_SOURCE : RO; bitpos: [5:0]; default: 0;
 *  BIT5~BIT0: pmu_lp_int, modem_lp_int, lp_timer_lp_int, reserved, reserved, lp_io_int
 */
#define LPPERI_LP_INTERRUPT_SOURCE    0x0000003FU
#define LPPERI_LP_INTERRUPT_SOURCE_M  (LPPERI_LP_INTERRUPT_SOURCE_V << LPPERI_LP_INTERRUPT_SOURCE_S)
#define LPPERI_LP_INTERRUPT_SOURCE_V  0x0000003FU
#define LPPERI_LP_INTERRUPT_SOURCE_S  0

/** LPPERI_RNG_CFG_REG register
 *  need_des
 */
#define LPPERI_RNG_CFG_REG (DR_REG_LPPERI_BASE + 0x24)
/** LPPERI_RNG_SAMPLE_ENABLE : R/W; bitpos: [0]; default: 0;
 *  need des
 */
#define LPPERI_RNG_SAMPLE_ENABLE    (BIT(0))
#define LPPERI_RNG_SAMPLE_ENABLE_M  (LPPERI_RNG_SAMPLE_ENABLE_V << LPPERI_RNG_SAMPLE_ENABLE_S)
#define LPPERI_RNG_SAMPLE_ENABLE_V  0x00000001U
#define LPPERI_RNG_SAMPLE_ENABLE_S  0
/** LPPERI_RNG_TIMER_PSCALE : R/W; bitpos: [8:1]; default: 255;
 *  need des
 */
#define LPPERI_RNG_TIMER_PSCALE    0x000000FFU
#define LPPERI_RNG_TIMER_PSCALE_M  (LPPERI_RNG_TIMER_PSCALE_V << LPPERI_RNG_TIMER_PSCALE_S)
#define LPPERI_RNG_TIMER_PSCALE_V  0x000000FFU
#define LPPERI_RNG_TIMER_PSCALE_S  1
/** LPPERI_RNG_TIMER_EN : R/W; bitpos: [9]; default: 1;
 *  need des
 */
#define LPPERI_RNG_TIMER_EN    (BIT(9))
#define LPPERI_RNG_TIMER_EN_M  (LPPERI_RNG_TIMER_EN_V << LPPERI_RNG_TIMER_EN_S)
#define LPPERI_RNG_TIMER_EN_V  0x00000001U
#define LPPERI_RNG_TIMER_EN_S  9
/** LPPERI_RTC_TIMER_EN : R/W; bitpos: [11:10]; default: 3;
 *  need des
 */
#define LPPERI_RTC_TIMER_EN    0x00000003U
#define LPPERI_RTC_TIMER_EN_M  (LPPERI_RTC_TIMER_EN_V << LPPERI_RTC_TIMER_EN_S)
#define LPPERI_RTC_TIMER_EN_V  0x00000003U
#define LPPERI_RTC_TIMER_EN_S  10
/** LPPERI_RNG_SAMPLE_CNT : RO; bitpos: [31:24]; default: 0;
 *  need des
 */
#define LPPERI_RNG_SAMPLE_CNT    0x000000FFU
#define LPPERI_RNG_SAMPLE_CNT_M  (LPPERI_RNG_SAMPLE_CNT_V << LPPERI_RNG_SAMPLE_CNT_S)
#define LPPERI_RNG_SAMPLE_CNT_V  0x000000FFU
#define LPPERI_RNG_SAMPLE_CNT_S  24

/** LPPERI_RNG_DATA_SYNC_REG register
 *  need_des
 */
#define LPPERI_RNG_DATA_SYNC_REG (DR_REG_LPPERI_BASE + 0x28)
/** LPPERI_RND_SYNC_DATA : RO; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define LPPERI_RND_SYNC_DATA    0xFFFFFFFFU
#define LPPERI_RND_SYNC_DATA_M  (LPPERI_RND_SYNC_DATA_V << LPPERI_RND_SYNC_DATA_S)
#define LPPERI_RND_SYNC_DATA_V  0xFFFFFFFFU
#define LPPERI_RND_SYNC_DATA_S  0

/** LPPERI_DATE_REG register
 *  need_des
 */
#define LPPERI_DATE_REG (DR_REG_LPPERI_BASE + 0x3fc)
/** LPPERI_LPPERI_DATE : R/W; bitpos: [30:0]; default: 37753168;
 *  need_des
 */
#define LPPERI_LPPERI_DATE    0x7FFFFFFFU
#define LPPERI_LPPERI_DATE_M  (LPPERI_LPPERI_DATE_V << LPPERI_LPPERI_DATE_S)
#define LPPERI_LPPERI_DATE_V  0x7FFFFFFFU
#define LPPERI_LPPERI_DATE_S  0
/** LPPERI_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LPPERI_CLK_EN    (BIT(31))
#define LPPERI_CLK_EN_M  (LPPERI_CLK_EN_V << LPPERI_CLK_EN_S)
#define LPPERI_CLK_EN_V  0x00000001U
#define LPPERI_CLK_EN_S  31

#ifdef __cplusplus
}
#endif
