/*
 * SPDX-FileCopyrightText: 2022-2023 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include "soc/interrupts.h"

const char *const esp_isr_names[] = {
    [ETS_LP_RTC_INTR_SOURCE]             = "LP_RTC",
    [ETS_LP_WDT_INTR_SOURCE]             = "LP_WDT",
    [ETS_LP_TIMER_REG0_INTR_SOURCE]      = "LP_TIMER_REG0",
    [ETS_LP_TIMER_REG1_INTR_SOURCE]      = "LP_TIMER_REG1",
    [ETS_MB_HP_INTR_SOURCE]              = "MB_HP",
    [ETS_MB_LP_INTR_SOURCE]              = "MB_LP",
    [ETS_PMU_0_INTR_SOURCE]              = "PMU_0",
    [ETS_PMU_1_INTR_SOURCE]              = "PMU_1",
    [ETS_LP_ANAPERI_INTR_SOURCE]         = "LP_ANAPERI",
    [ETS_LP_ADC_INTR_SOURCE]             = "LP_ADC",
    [ETS_LP_GPIO_INTR_SOURCE]            = "LP_GPIO",
    [ETS_LP_I2C_INTR_SOURCE]             = "LP_I2C",
    [ETS_LP_I2S_INTR_SOURCE]             = "LP_I2S",
    [ETS_LP_SPI_INTR_SOURCE]             = "LP_SPI",
    [ETS_LP_TOUCH_INTR_SOURCE]           = "LP_TOUCH",
    [ETS_LP_TSENS_INTR_SOURCE]           = "LP_TSENS",
    [ETS_LP_UART_INTR_SOURCE]            = "LP_UART",
    [ETS_LP_EFUSE_INTR_SOURCE]           = "LP_EFUSE",
    [ETS_LP_SW_INTR_SOURCE]              = "LP_SW",
    [ETS_LP_SYSREG_INTR_SOURCE]          = "LP_SYSREG",
    [ETS_LP_HUK_INTR_SOURCE]             = "LP_HUK",
    [ETS_SYS_ICM_INTR_SOURCE]            = "SYS_ICM",
    [ETS_USB_SERIAL_JTAG_INTR_SOURCE]    = "USB_SERIAL_JTAG",
    [ETS_SDIO_HOST_INTR_SOURCE]          = "SDIO_HOST",
    [ETS_DW_GDMA_INTR_SOURCE]            = "DW_GDMA",
    [ETS_SPI2_INTR_SOURCE]               = "SPI2",
    [ETS_SPI3_INTR_SOURCE]               = "SPI3",
    [ETS_I2S0_INTR_SOURCE]               = "I2S0",
    [ETS_I2S1_INTR_SOURCE]               = "I2S1",
    [ETS_I2S2_INTR_SOURCE]               = "I2S2",
    [ETS_UHCI0_INTR_SOURCE]              = "UHCI0",
    [ETS_UART0_INTR_SOURCE]              = "UART0",
    [ETS_UART1_INTR_SOURCE]              = "UART1",
    [ETS_UART2_INTR_SOURCE]              = "UART2",
    [ETS_UART3_INTR_SOURCE]              = "UART3",
    [ETS_UART4_INTR_SOURCE]              = "UART4",
    [ETS_LCD_CAM_INTR_SOURCE]            = "LCD_CAM",
    [ETS_ADC_INTR_SOURCE]                = "ADC",
    [ETS_PWM0_INTR_SOURCE]               = "PWM0",
    [ETS_PWM1_INTR_SOURCE]               = "PWM1",
    [ETS_TWAI0_INTR_SOURCE]              = "TWAI0",
    [ETS_TWAI1_INTR_SOURCE]              = "TWAI1",
    [ETS_TWAI2_INTR_SOURCE]              = "TWAI2",
    [ETS_RMT_INTR_SOURCE]                = "RMT",
    [ETS_I2C0_INTR_SOURCE]               = "I2C0",
    [ETS_I2C1_INTR_SOURCE]               = "I2C1",
    [ETS_TG0_T0_INTR_SOURCE]             = "TG0_T0",
    [ETS_TG0_T1_INTR_SOURCE]             = "TG0_T1",
    [ETS_TG0_WDT_LEVEL_INTR_SOURCE]      = "TG0_WDT_LEVEL",
    [ETS_TG1_T0_INTR_SOURCE]             = "TG1_T0",
    [ETS_TG1_T1_INTR_SOURCE]             = "TG1_T1",
    [ETS_TG1_WDT_LEVEL_INTR_SOURCE]      = "TG1_WDT_LEVEL",
    [ETS_LEDC_INTR_SOURCE]               = "LEDC",
    [ETS_SYSTIMER_TARGET0_INTR_SOURCE]   = "SYSTIMER_TARGET0",
    [ETS_SYSTIMER_TARGET1_INTR_SOURCE]   = "SYSTIMER_TARGET1",
    [ETS_SYSTIMER_TARGET2_INTR_SOURCE]   = "SYSTIMER_TARGET2",
    [ETS_AHB_PDMA_IN_CH0_INTR_SOURCE]    = "AHB_PDMA_IN_CH0",
    [ETS_AHB_PDMA_IN_CH1_INTR_SOURCE]    = "AHB_PDMA_IN_CH1",
    [ETS_AHB_PDMA_IN_CH2_INTR_SOURCE]    = "AHB_PDMA_IN_CH2",
    [ETS_AHB_PDMA_OUT_CH0_INTR_SOURCE]   = "AHB_PDMA_OUT_CH0",
    [ETS_AHB_PDMA_OUT_CH1_INTR_SOURCE]   = "AHB_PDMA_OUT_CH1",
    [ETS_AHB_PDMA_OUT_CH2_INTR_SOURCE]   = "AHB_PDMA_OUT_CH2",
    [ETS_AXI_PDMA_IN_CH0_INTR_SOURCE]    = "AXI_PDMA_IN_CH0",
    [ETS_AXI_PDMA_IN_CH1_INTR_SOURCE]    = "AXI_PDMA_IN_CH1",
    [ETS_AXI_PDMA_IN_CH2_INTR_SOURCE]    = "AXI_PDMA_IN_CH2",
    [ETS_AXI_PDMA_OUT_CH0_INTR_SOURCE]   = "AXI_PDMA_OUT_CH0",
    [ETS_AXI_PDMA_OUT_CH1_INTR_SOURCE]   = "AXI_PDMA_OUT_CH1",
    [ETS_AXI_PDMA_OUT_CH2_INTR_SOURCE]   = "AXI_PDMA_OUT_CH2",
    [ETS_RSA_INTR_SOURCE]                = "RSA",
    [ETS_AES_INTR_SOURCE]                = "AES",
    [ETS_SHA_INTR_SOURCE]                = "SHA",
    [ETS_ECC_INTR_SOURCE]                = "ECC",
    [ETS_ECDSA_INTR_SOURCE]              = "ECDSA",
    [ETS_KM_INTR_SOURCE]                 = "KM",
    [ETS_GPIO_INTR0_SOURCE]              = "GPIO_INT0",
    [ETS_GPIO_INTR1_SOURCE]              = "GPIO_INT1",
    [ETS_GPIO_INTR2_SOURCE]              = "GPIO_INT2",
    [ETS_GPIO_INTR3_SOURCE]              = "GPIO_INT3",
    [ETS_GPIO_PAD_COMP_INTR_SOURCE]      = "GPIO_PAD_COMP",
    [ETS_FROM_CPU_INTR0_SOURCE]          = "CPU_INT_FROM_CPU_0",
    [ETS_FROM_CPU_INTR1_SOURCE]          = "CPU_INT_FROM_CPU_1",
    [ETS_FROM_CPU_INTR2_SOURCE]          = "CPU_INT_FROM_CPU_2",
    [ETS_FROM_CPU_INTR3_SOURCE]          = "CPU_INT_FROM_CPU_3",
    [ETS_CACHE_INTR_SOURCE]              = "CACHE",
    [ETS_MSPI_INTR_SOURCE]               = "MSPI",
    [ETS_CSI_BRIDGE_INTR_SOURCE]         = "CSI_BRIDGE",
    [ETS_DSI_BRIDGE_INTR_SOURCE]         = "DSI_BRIDGE",
    [ETS_CSI_INTR_SOURCE]                = "CSI",
    [ETS_DSI_INTR_SOURCE]                = "DSI",
    [ETS_GMII_PHY_INTR_SOURCE]           = "GMII_PHY",
    [ETS_LPI_INTR_SOURCE]                = "LPI",
    [ETS_PMT_INTR_SOURCE]                = "PMT",
    [ETS_ETH_MAC_INTR_SOURCE]            = "ETH_MAC",
    [ETS_USB_OTG_INTR_SOURCE]            = "USB_OTG",
    [ETS_USB_OTG_ENDP_MULTI_PROC_INTR_SOURCE] = "USB_OTG_ENDP_MULTI_PROC",
    [ETS_JPEG_INTR_SOURCE]               = "JPEG",
    [ETS_PPA_INTR_SOURCE]                = "PPA",
    [ETS_CORE0_TRACE_INTR_SOURCE]        = "CORE0_TRACE",
    [ETS_CORE1_TRACE_INTR_SOURCE]        = "CORE1_TRACE",
    [ETS_HP_CORE_CTRL_INTR_SOURCE]       = "HP_CORE_CTRL",
    [ETS_ISP_INTR_SOURCE]                = "ISP",
    [ETS_I3C_MST_INTR_SOURCE]            = "I3C_MST",
    [ETS_I3C_SLV_INTR_SOURCE]            = "I3C_SLV",
    [ETS_USB_OTG11_CH0_INTR_SOURCE]      = "USB_OTG11_CH0",
    [ETS_DMA2D_IN_CH0_INTR_SOURCE]       = "DMA2D_IN_CH0",
    [ETS_DMA2D_IN_CH1_INTR_SOURCE]       = "DMA2D_IN_CH1",
    [ETS_DMA2D_OUT_CH0_INTR_SOURCE]      = "DMA2D_OUT_CH0",
    [ETS_DMA2D_OUT_CH1_INTR_SOURCE]      = "DMA2D_OUT_CH1",
    [ETS_DMA2D_OUT_CH2_INTR_SOURCE]      = "DMA2D_OUT_CH2",
    [ETS_PSRAM_MSPI_INTR_SOURCE]         = "PSRAM_MSPI",
    [ETS_HP_SYSREG_INTR_SOURCE]          = "HP_SYSREG",
    [ETS_PCNT_INTR_SOURCE]               = "PCNT",
    [ETS_HP_PAU_INTR_SOURCE]             = "HP_PAU",
    [ETS_HP_PARLIO_RX_INTR_SOURCE]       = "HP_PARLIO_RX",
    [ETS_HP_PARLIO_TX_INTR_SOURCE]       = "HP_PARLIO_TX",
    [ETS_H264_DMA2D_OUT_CH0_INTR_SOURCE] = "H264_DMA2D_OUT_CH0",
    [ETS_H264_DMA2D_OUT_CH1_INTR_SOURCE] = "H264_DMA2D_OUT_CH1",
    [ETS_H264_DMA2D_OUT_CH2_INTR_SOURCE] = "H264_DMA2D_OUT_CH2",
    [ETS_H264_DMA2D_OUT_CH3_INTR_SOURCE] = "H264_DMA2D_OUT_CH3",
    [ETS_H264_DMA2D_OUT_CH4_INTR_SOURCE] = "H264_DMA2D_OUT_CH4",
    [ETS_H264_DMA2D_IN_CH0_INTR_SOURCE]  = "H264_DMA2D_IN_CH0",
    [ETS_H264_DMA2D_IN_CH1_INTR_SOURCE]  = "H264_DMA2D_IN_CH1",
    [ETS_H264_DMA2D_IN_CH2_INTR_SOURCE]  = "H264_DMA2D_IN_CH2",
    [ETS_H264_DMA2D_IN_CH3_INTR_SOURCE]  = "H264_DMA2D_IN_CH3",
    [ETS_H264_DMA2D_IN_CH4_INTR_SOURCE]  = "H264_DMA2D_IN_CH4",
    [ETS_H264_DMA2D_IN_CH5_INTR_SOURCE]  = "H264_DMA2D_IN_CH5",
    [ETS_H264_REG_INTR_SOURCE]           = "H264_REG",
    [ETS_ASSIST_DEBUG_INTR_SOURCE]       = "ASSIST_DEBUG",
    [ETS_DMA2D_IN_CH2_INTR_SOURCE]       = "DMA2D_IN_CH2",     /* This interrupt source only exists on chip ver. >= 3.0 */
    [ETS_DMA2D_OUT_CH3_INTR_SOURCE]      = "DMA2D_OUT_CH3",    /* This interrupt source only exists on chip ver. >= 3.0 */
    [ETS_AXI_PERF_MON_INTR_SOURCE]       = "AXI_PERF_MON",     /* This interrupt source only exists on chip ver. >= 3.0 */
};
