/**
 * SPDX-FileCopyrightText: 2023 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** MB_MASSEGE_0_REG register
 *  need_des
 */
#define MB_MASSEGE_0_REG (DR_REG_MB_BASE + 0x0)
/** MB_MASSEGE_0 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_0    0xFFFFFFFFU
#define MB_MASSEGE_0_M  (MB_MASSEGE_0_V << MB_MASSEGE_0_S)
#define MB_MASSEGE_0_V  0xFFFFFFFFU
#define MB_MASSEGE_0_S  0

/** MB_MASSEGE_1_REG register
 *  need_des
 */
#define MB_MASSEGE_1_REG (DR_REG_MB_BASE + 0x4)
/** MB_MASSEGE_1 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_1    0xFFFFFFFFU
#define MB_MASSEGE_1_M  (MB_MASSEGE_1_V << MB_MASSEGE_1_S)
#define MB_MASSEGE_1_V  0xFFFFFFFFU
#define MB_MASSEGE_1_S  0

/** MB_MASSEGE_2_REG register
 *  need_des
 */
#define MB_MASSEGE_2_REG (DR_REG_MB_BASE + 0x8)
/** MB_MASSEGE_2 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_2    0xFFFFFFFFU
#define MB_MASSEGE_2_M  (MB_MASSEGE_2_V << MB_MASSEGE_2_S)
#define MB_MASSEGE_2_V  0xFFFFFFFFU
#define MB_MASSEGE_2_S  0

/** MB_MASSEGE_3_REG register
 *  need_des
 */
#define MB_MASSEGE_3_REG (DR_REG_MB_BASE + 0xc)
/** MB_MASSEGE_3 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_3    0xFFFFFFFFU
#define MB_MASSEGE_3_M  (MB_MASSEGE_3_V << MB_MASSEGE_3_S)
#define MB_MASSEGE_3_V  0xFFFFFFFFU
#define MB_MASSEGE_3_S  0

/** MB_MASSEGE_4_REG register
 *  need_des
 */
#define MB_MASSEGE_4_REG (DR_REG_MB_BASE + 0x10)
/** MB_MASSEGE_4 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_4    0xFFFFFFFFU
#define MB_MASSEGE_4_M  (MB_MASSEGE_4_V << MB_MASSEGE_4_S)
#define MB_MASSEGE_4_V  0xFFFFFFFFU
#define MB_MASSEGE_4_S  0

/** MB_MASSEGE_5_REG register
 *  need_des
 */
#define MB_MASSEGE_5_REG (DR_REG_MB_BASE + 0x14)
/** MB_MASSEGE_5 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_5    0xFFFFFFFFU
#define MB_MASSEGE_5_M  (MB_MASSEGE_5_V << MB_MASSEGE_5_S)
#define MB_MASSEGE_5_V  0xFFFFFFFFU
#define MB_MASSEGE_5_S  0

/** MB_MASSEGE_6_REG register
 *  need_des
 */
#define MB_MASSEGE_6_REG (DR_REG_MB_BASE + 0x18)
/** MB_MASSEGE_6 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_6    0xFFFFFFFFU
#define MB_MASSEGE_6_M  (MB_MASSEGE_6_V << MB_MASSEGE_6_S)
#define MB_MASSEGE_6_V  0xFFFFFFFFU
#define MB_MASSEGE_6_S  0

/** MB_MASSEGE_7_REG register
 *  need_des
 */
#define MB_MASSEGE_7_REG (DR_REG_MB_BASE + 0x1c)
/** MB_MASSEGE_7 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_7    0xFFFFFFFFU
#define MB_MASSEGE_7_M  (MB_MASSEGE_7_V << MB_MASSEGE_7_S)
#define MB_MASSEGE_7_V  0xFFFFFFFFU
#define MB_MASSEGE_7_S  0

/** MB_MASSEGE_8_REG register
 *  need_des
 */
#define MB_MASSEGE_8_REG (DR_REG_MB_BASE + 0x20)
/** MB_MASSEGE_8 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_8    0xFFFFFFFFU
#define MB_MASSEGE_8_M  (MB_MASSEGE_8_V << MB_MASSEGE_8_S)
#define MB_MASSEGE_8_V  0xFFFFFFFFU
#define MB_MASSEGE_8_S  0

/** MB_MASSEGE_9_REG register
 *  need_des
 */
#define MB_MASSEGE_9_REG (DR_REG_MB_BASE + 0x24)
/** MB_MASSEGE_9 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_9    0xFFFFFFFFU
#define MB_MASSEGE_9_M  (MB_MASSEGE_9_V << MB_MASSEGE_9_S)
#define MB_MASSEGE_9_V  0xFFFFFFFFU
#define MB_MASSEGE_9_S  0

/** MB_MASSEGE_10_REG register
 *  need_des
 */
#define MB_MASSEGE_10_REG (DR_REG_MB_BASE + 0x28)
/** MB_MASSEGE_10 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_10    0xFFFFFFFFU
#define MB_MASSEGE_10_M  (MB_MASSEGE_10_V << MB_MASSEGE_10_S)
#define MB_MASSEGE_10_V  0xFFFFFFFFU
#define MB_MASSEGE_10_S  0

/** MB_MASSEGE_11_REG register
 *  need_des
 */
#define MB_MASSEGE_11_REG (DR_REG_MB_BASE + 0x2c)
/** MB_MASSEGE_11 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_11    0xFFFFFFFFU
#define MB_MASSEGE_11_M  (MB_MASSEGE_11_V << MB_MASSEGE_11_S)
#define MB_MASSEGE_11_V  0xFFFFFFFFU
#define MB_MASSEGE_11_S  0

/** MB_MASSEGE_12_REG register
 *  need_des
 */
#define MB_MASSEGE_12_REG (DR_REG_MB_BASE + 0x30)
/** MB_MASSEGE_12 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_12    0xFFFFFFFFU
#define MB_MASSEGE_12_M  (MB_MASSEGE_12_V << MB_MASSEGE_12_S)
#define MB_MASSEGE_12_V  0xFFFFFFFFU
#define MB_MASSEGE_12_S  0

/** MB_MASSEGE_13_REG register
 *  need_des
 */
#define MB_MASSEGE_13_REG (DR_REG_MB_BASE + 0x34)
/** MB_MASSEGE_13 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_13    0xFFFFFFFFU
#define MB_MASSEGE_13_M  (MB_MASSEGE_13_V << MB_MASSEGE_13_S)
#define MB_MASSEGE_13_V  0xFFFFFFFFU
#define MB_MASSEGE_13_S  0

/** MB_MASSEGE_14_REG register
 *  need_des
 */
#define MB_MASSEGE_14_REG (DR_REG_MB_BASE + 0x38)
/** MB_MASSEGE_14 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_14    0xFFFFFFFFU
#define MB_MASSEGE_14_M  (MB_MASSEGE_14_V << MB_MASSEGE_14_S)
#define MB_MASSEGE_14_V  0xFFFFFFFFU
#define MB_MASSEGE_14_S  0

/** MB_MASSEGE_15_REG register
 *  need_des
 */
#define MB_MASSEGE_15_REG (DR_REG_MB_BASE + 0x3c)
/** MB_MASSEGE_15 : R/W; bitpos: [31:0]; default: 0;
 *  need_des
 */
#define MB_MASSEGE_15    0xFFFFFFFFU
#define MB_MASSEGE_15_M  (MB_MASSEGE_15_V << MB_MASSEGE_15_S)
#define MB_MASSEGE_15_V  0xFFFFFFFFU
#define MB_MASSEGE_15_S  0

/** MB_LP_INT_RAW_REG register
 *  need_des
 */
#define MB_LP_INT_RAW_REG (DR_REG_MB_BASE + 0x40)
/** MB_LP_0_INT_RAW : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_LP_0_INT_RAW    (BIT(0))
#define MB_LP_0_INT_RAW_M  (MB_LP_0_INT_RAW_V << MB_LP_0_INT_RAW_S)
#define MB_LP_0_INT_RAW_V  0x00000001U
#define MB_LP_0_INT_RAW_S  0
/** MB_LP_1_INT_RAW : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_LP_1_INT_RAW    (BIT(1))
#define MB_LP_1_INT_RAW_M  (MB_LP_1_INT_RAW_V << MB_LP_1_INT_RAW_S)
#define MB_LP_1_INT_RAW_V  0x00000001U
#define MB_LP_1_INT_RAW_S  1
/** MB_LP_2_INT_RAW : RO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_LP_2_INT_RAW    (BIT(2))
#define MB_LP_2_INT_RAW_M  (MB_LP_2_INT_RAW_V << MB_LP_2_INT_RAW_S)
#define MB_LP_2_INT_RAW_V  0x00000001U
#define MB_LP_2_INT_RAW_S  2
/** MB_LP_3_INT_RAW : RO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_LP_3_INT_RAW    (BIT(3))
#define MB_LP_3_INT_RAW_M  (MB_LP_3_INT_RAW_V << MB_LP_3_INT_RAW_S)
#define MB_LP_3_INT_RAW_V  0x00000001U
#define MB_LP_3_INT_RAW_S  3
/** MB_LP_4_INT_RAW : RO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_LP_4_INT_RAW    (BIT(4))
#define MB_LP_4_INT_RAW_M  (MB_LP_4_INT_RAW_V << MB_LP_4_INT_RAW_S)
#define MB_LP_4_INT_RAW_V  0x00000001U
#define MB_LP_4_INT_RAW_S  4
/** MB_LP_5_INT_RAW : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_LP_5_INT_RAW    (BIT(5))
#define MB_LP_5_INT_RAW_M  (MB_LP_5_INT_RAW_V << MB_LP_5_INT_RAW_S)
#define MB_LP_5_INT_RAW_V  0x00000001U
#define MB_LP_5_INT_RAW_S  5
/** MB_LP_6_INT_RAW : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_LP_6_INT_RAW    (BIT(6))
#define MB_LP_6_INT_RAW_M  (MB_LP_6_INT_RAW_V << MB_LP_6_INT_RAW_S)
#define MB_LP_6_INT_RAW_V  0x00000001U
#define MB_LP_6_INT_RAW_S  6
/** MB_LP_7_INT_RAW : RO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_LP_7_INT_RAW    (BIT(7))
#define MB_LP_7_INT_RAW_M  (MB_LP_7_INT_RAW_V << MB_LP_7_INT_RAW_S)
#define MB_LP_7_INT_RAW_V  0x00000001U
#define MB_LP_7_INT_RAW_S  7
/** MB_LP_8_INT_RAW : RO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_LP_8_INT_RAW    (BIT(8))
#define MB_LP_8_INT_RAW_M  (MB_LP_8_INT_RAW_V << MB_LP_8_INT_RAW_S)
#define MB_LP_8_INT_RAW_V  0x00000001U
#define MB_LP_8_INT_RAW_S  8
/** MB_LP_9_INT_RAW : RO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_LP_9_INT_RAW    (BIT(9))
#define MB_LP_9_INT_RAW_M  (MB_LP_9_INT_RAW_V << MB_LP_9_INT_RAW_S)
#define MB_LP_9_INT_RAW_V  0x00000001U
#define MB_LP_9_INT_RAW_S  9
/** MB_LP_10_INT_RAW : RO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_LP_10_INT_RAW    (BIT(10))
#define MB_LP_10_INT_RAW_M  (MB_LP_10_INT_RAW_V << MB_LP_10_INT_RAW_S)
#define MB_LP_10_INT_RAW_V  0x00000001U
#define MB_LP_10_INT_RAW_S  10
/** MB_LP_11_INT_RAW : RO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_LP_11_INT_RAW    (BIT(11))
#define MB_LP_11_INT_RAW_M  (MB_LP_11_INT_RAW_V << MB_LP_11_INT_RAW_S)
#define MB_LP_11_INT_RAW_V  0x00000001U
#define MB_LP_11_INT_RAW_S  11
/** MB_LP_12_INT_RAW : RO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_LP_12_INT_RAW    (BIT(12))
#define MB_LP_12_INT_RAW_M  (MB_LP_12_INT_RAW_V << MB_LP_12_INT_RAW_S)
#define MB_LP_12_INT_RAW_V  0x00000001U
#define MB_LP_12_INT_RAW_S  12
/** MB_LP_13_INT_RAW : RO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_LP_13_INT_RAW    (BIT(13))
#define MB_LP_13_INT_RAW_M  (MB_LP_13_INT_RAW_V << MB_LP_13_INT_RAW_S)
#define MB_LP_13_INT_RAW_V  0x00000001U
#define MB_LP_13_INT_RAW_S  13
/** MB_LP_14_INT_RAW : RO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_LP_14_INT_RAW    (BIT(14))
#define MB_LP_14_INT_RAW_M  (MB_LP_14_INT_RAW_V << MB_LP_14_INT_RAW_S)
#define MB_LP_14_INT_RAW_V  0x00000001U
#define MB_LP_14_INT_RAW_S  14
/** MB_LP_15_INT_RAW : RO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_LP_15_INT_RAW    (BIT(15))
#define MB_LP_15_INT_RAW_M  (MB_LP_15_INT_RAW_V << MB_LP_15_INT_RAW_S)
#define MB_LP_15_INT_RAW_V  0x00000001U
#define MB_LP_15_INT_RAW_S  15

/** MB_LP_INT_ST_REG register
 *  need_des
 */
#define MB_LP_INT_ST_REG (DR_REG_MB_BASE + 0x44)
/** MB_LP_0_INT_ST : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_LP_0_INT_ST    (BIT(0))
#define MB_LP_0_INT_ST_M  (MB_LP_0_INT_ST_V << MB_LP_0_INT_ST_S)
#define MB_LP_0_INT_ST_V  0x00000001U
#define MB_LP_0_INT_ST_S  0
/** MB_LP_1_INT_ST : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_LP_1_INT_ST    (BIT(1))
#define MB_LP_1_INT_ST_M  (MB_LP_1_INT_ST_V << MB_LP_1_INT_ST_S)
#define MB_LP_1_INT_ST_V  0x00000001U
#define MB_LP_1_INT_ST_S  1
/** MB_LP_2_INT_ST : RO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_LP_2_INT_ST    (BIT(2))
#define MB_LP_2_INT_ST_M  (MB_LP_2_INT_ST_V << MB_LP_2_INT_ST_S)
#define MB_LP_2_INT_ST_V  0x00000001U
#define MB_LP_2_INT_ST_S  2
/** MB_LP_3_INT_ST : RO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_LP_3_INT_ST    (BIT(3))
#define MB_LP_3_INT_ST_M  (MB_LP_3_INT_ST_V << MB_LP_3_INT_ST_S)
#define MB_LP_3_INT_ST_V  0x00000001U
#define MB_LP_3_INT_ST_S  3
/** MB_LP_4_INT_ST : RO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_LP_4_INT_ST    (BIT(4))
#define MB_LP_4_INT_ST_M  (MB_LP_4_INT_ST_V << MB_LP_4_INT_ST_S)
#define MB_LP_4_INT_ST_V  0x00000001U
#define MB_LP_4_INT_ST_S  4
/** MB_LP_5_INT_ST : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_LP_5_INT_ST    (BIT(5))
#define MB_LP_5_INT_ST_M  (MB_LP_5_INT_ST_V << MB_LP_5_INT_ST_S)
#define MB_LP_5_INT_ST_V  0x00000001U
#define MB_LP_5_INT_ST_S  5
/** MB_LP_6_INT_ST : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_LP_6_INT_ST    (BIT(6))
#define MB_LP_6_INT_ST_M  (MB_LP_6_INT_ST_V << MB_LP_6_INT_ST_S)
#define MB_LP_6_INT_ST_V  0x00000001U
#define MB_LP_6_INT_ST_S  6
/** MB_LP_7_INT_ST : RO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_LP_7_INT_ST    (BIT(7))
#define MB_LP_7_INT_ST_M  (MB_LP_7_INT_ST_V << MB_LP_7_INT_ST_S)
#define MB_LP_7_INT_ST_V  0x00000001U
#define MB_LP_7_INT_ST_S  7
/** MB_LP_8_INT_ST : RO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_LP_8_INT_ST    (BIT(8))
#define MB_LP_8_INT_ST_M  (MB_LP_8_INT_ST_V << MB_LP_8_INT_ST_S)
#define MB_LP_8_INT_ST_V  0x00000001U
#define MB_LP_8_INT_ST_S  8
/** MB_LP_9_INT_ST : RO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_LP_9_INT_ST    (BIT(9))
#define MB_LP_9_INT_ST_M  (MB_LP_9_INT_ST_V << MB_LP_9_INT_ST_S)
#define MB_LP_9_INT_ST_V  0x00000001U
#define MB_LP_9_INT_ST_S  9
/** MB_LP_10_INT_ST : RO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_LP_10_INT_ST    (BIT(10))
#define MB_LP_10_INT_ST_M  (MB_LP_10_INT_ST_V << MB_LP_10_INT_ST_S)
#define MB_LP_10_INT_ST_V  0x00000001U
#define MB_LP_10_INT_ST_S  10
/** MB_LP_11_INT_ST : RO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_LP_11_INT_ST    (BIT(11))
#define MB_LP_11_INT_ST_M  (MB_LP_11_INT_ST_V << MB_LP_11_INT_ST_S)
#define MB_LP_11_INT_ST_V  0x00000001U
#define MB_LP_11_INT_ST_S  11
/** MB_LP_12_INT_ST : RO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_LP_12_INT_ST    (BIT(12))
#define MB_LP_12_INT_ST_M  (MB_LP_12_INT_ST_V << MB_LP_12_INT_ST_S)
#define MB_LP_12_INT_ST_V  0x00000001U
#define MB_LP_12_INT_ST_S  12
/** MB_LP_13_INT_ST : RO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_LP_13_INT_ST    (BIT(13))
#define MB_LP_13_INT_ST_M  (MB_LP_13_INT_ST_V << MB_LP_13_INT_ST_S)
#define MB_LP_13_INT_ST_V  0x00000001U
#define MB_LP_13_INT_ST_S  13
/** MB_LP_14_INT_ST : RO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_LP_14_INT_ST    (BIT(14))
#define MB_LP_14_INT_ST_M  (MB_LP_14_INT_ST_V << MB_LP_14_INT_ST_S)
#define MB_LP_14_INT_ST_V  0x00000001U
#define MB_LP_14_INT_ST_S  14
/** MB_LP_15_INT_ST : RO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_LP_15_INT_ST    (BIT(15))
#define MB_LP_15_INT_ST_M  (MB_LP_15_INT_ST_V << MB_LP_15_INT_ST_S)
#define MB_LP_15_INT_ST_V  0x00000001U
#define MB_LP_15_INT_ST_S  15

/** MB_LP_INT_ENA_REG register
 *  need_des
 */
#define MB_LP_INT_ENA_REG (DR_REG_MB_BASE + 0x48)
/** MB_LP_0_INT_ENA : R/W; bitpos: [0]; default: 1;
 *  need_des
 */
#define MB_LP_0_INT_ENA    (BIT(0))
#define MB_LP_0_INT_ENA_M  (MB_LP_0_INT_ENA_V << MB_LP_0_INT_ENA_S)
#define MB_LP_0_INT_ENA_V  0x00000001U
#define MB_LP_0_INT_ENA_S  0
/** MB_LP_1_INT_ENA : R/W; bitpos: [1]; default: 1;
 *  need_des
 */
#define MB_LP_1_INT_ENA    (BIT(1))
#define MB_LP_1_INT_ENA_M  (MB_LP_1_INT_ENA_V << MB_LP_1_INT_ENA_S)
#define MB_LP_1_INT_ENA_V  0x00000001U
#define MB_LP_1_INT_ENA_S  1
/** MB_LP_2_INT_ENA : R/W; bitpos: [2]; default: 1;
 *  need_des
 */
#define MB_LP_2_INT_ENA    (BIT(2))
#define MB_LP_2_INT_ENA_M  (MB_LP_2_INT_ENA_V << MB_LP_2_INT_ENA_S)
#define MB_LP_2_INT_ENA_V  0x00000001U
#define MB_LP_2_INT_ENA_S  2
/** MB_LP_3_INT_ENA : R/W; bitpos: [3]; default: 1;
 *  need_des
 */
#define MB_LP_3_INT_ENA    (BIT(3))
#define MB_LP_3_INT_ENA_M  (MB_LP_3_INT_ENA_V << MB_LP_3_INT_ENA_S)
#define MB_LP_3_INT_ENA_V  0x00000001U
#define MB_LP_3_INT_ENA_S  3
/** MB_LP_4_INT_ENA : R/W; bitpos: [4]; default: 1;
 *  need_des
 */
#define MB_LP_4_INT_ENA    (BIT(4))
#define MB_LP_4_INT_ENA_M  (MB_LP_4_INT_ENA_V << MB_LP_4_INT_ENA_S)
#define MB_LP_4_INT_ENA_V  0x00000001U
#define MB_LP_4_INT_ENA_S  4
/** MB_LP_5_INT_ENA : R/W; bitpos: [5]; default: 1;
 *  need_des
 */
#define MB_LP_5_INT_ENA    (BIT(5))
#define MB_LP_5_INT_ENA_M  (MB_LP_5_INT_ENA_V << MB_LP_5_INT_ENA_S)
#define MB_LP_5_INT_ENA_V  0x00000001U
#define MB_LP_5_INT_ENA_S  5
/** MB_LP_6_INT_ENA : R/W; bitpos: [6]; default: 1;
 *  need_des
 */
#define MB_LP_6_INT_ENA    (BIT(6))
#define MB_LP_6_INT_ENA_M  (MB_LP_6_INT_ENA_V << MB_LP_6_INT_ENA_S)
#define MB_LP_6_INT_ENA_V  0x00000001U
#define MB_LP_6_INT_ENA_S  6
/** MB_LP_7_INT_ENA : R/W; bitpos: [7]; default: 1;
 *  need_des
 */
#define MB_LP_7_INT_ENA    (BIT(7))
#define MB_LP_7_INT_ENA_M  (MB_LP_7_INT_ENA_V << MB_LP_7_INT_ENA_S)
#define MB_LP_7_INT_ENA_V  0x00000001U
#define MB_LP_7_INT_ENA_S  7
/** MB_LP_8_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_LP_8_INT_ENA    (BIT(8))
#define MB_LP_8_INT_ENA_M  (MB_LP_8_INT_ENA_V << MB_LP_8_INT_ENA_S)
#define MB_LP_8_INT_ENA_V  0x00000001U
#define MB_LP_8_INT_ENA_S  8
/** MB_LP_9_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_LP_9_INT_ENA    (BIT(9))
#define MB_LP_9_INT_ENA_M  (MB_LP_9_INT_ENA_V << MB_LP_9_INT_ENA_S)
#define MB_LP_9_INT_ENA_V  0x00000001U
#define MB_LP_9_INT_ENA_S  9
/** MB_LP_10_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_LP_10_INT_ENA    (BIT(10))
#define MB_LP_10_INT_ENA_M  (MB_LP_10_INT_ENA_V << MB_LP_10_INT_ENA_S)
#define MB_LP_10_INT_ENA_V  0x00000001U
#define MB_LP_10_INT_ENA_S  10
/** MB_LP_11_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_LP_11_INT_ENA    (BIT(11))
#define MB_LP_11_INT_ENA_M  (MB_LP_11_INT_ENA_V << MB_LP_11_INT_ENA_S)
#define MB_LP_11_INT_ENA_V  0x00000001U
#define MB_LP_11_INT_ENA_S  11
/** MB_LP_12_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_LP_12_INT_ENA    (BIT(12))
#define MB_LP_12_INT_ENA_M  (MB_LP_12_INT_ENA_V << MB_LP_12_INT_ENA_S)
#define MB_LP_12_INT_ENA_V  0x00000001U
#define MB_LP_12_INT_ENA_S  12
/** MB_LP_13_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_LP_13_INT_ENA    (BIT(13))
#define MB_LP_13_INT_ENA_M  (MB_LP_13_INT_ENA_V << MB_LP_13_INT_ENA_S)
#define MB_LP_13_INT_ENA_V  0x00000001U
#define MB_LP_13_INT_ENA_S  13
/** MB_LP_14_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_LP_14_INT_ENA    (BIT(14))
#define MB_LP_14_INT_ENA_M  (MB_LP_14_INT_ENA_V << MB_LP_14_INT_ENA_S)
#define MB_LP_14_INT_ENA_V  0x00000001U
#define MB_LP_14_INT_ENA_S  14
/** MB_LP_15_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_LP_15_INT_ENA    (BIT(15))
#define MB_LP_15_INT_ENA_M  (MB_LP_15_INT_ENA_V << MB_LP_15_INT_ENA_S)
#define MB_LP_15_INT_ENA_V  0x00000001U
#define MB_LP_15_INT_ENA_S  15

/** MB_LP_INT_CLR_REG register
 *  need_des
 */
#define MB_LP_INT_CLR_REG (DR_REG_MB_BASE + 0x4c)
/** MB_LP_0_INT_CLR : WO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_LP_0_INT_CLR    (BIT(0))
#define MB_LP_0_INT_CLR_M  (MB_LP_0_INT_CLR_V << MB_LP_0_INT_CLR_S)
#define MB_LP_0_INT_CLR_V  0x00000001U
#define MB_LP_0_INT_CLR_S  0
/** MB_LP_1_INT_CLR : WO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_LP_1_INT_CLR    (BIT(1))
#define MB_LP_1_INT_CLR_M  (MB_LP_1_INT_CLR_V << MB_LP_1_INT_CLR_S)
#define MB_LP_1_INT_CLR_V  0x00000001U
#define MB_LP_1_INT_CLR_S  1
/** MB_LP_2_INT_CLR : WO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_LP_2_INT_CLR    (BIT(2))
#define MB_LP_2_INT_CLR_M  (MB_LP_2_INT_CLR_V << MB_LP_2_INT_CLR_S)
#define MB_LP_2_INT_CLR_V  0x00000001U
#define MB_LP_2_INT_CLR_S  2
/** MB_LP_3_INT_CLR : WO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_LP_3_INT_CLR    (BIT(3))
#define MB_LP_3_INT_CLR_M  (MB_LP_3_INT_CLR_V << MB_LP_3_INT_CLR_S)
#define MB_LP_3_INT_CLR_V  0x00000001U
#define MB_LP_3_INT_CLR_S  3
/** MB_LP_4_INT_CLR : WO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_LP_4_INT_CLR    (BIT(4))
#define MB_LP_4_INT_CLR_M  (MB_LP_4_INT_CLR_V << MB_LP_4_INT_CLR_S)
#define MB_LP_4_INT_CLR_V  0x00000001U
#define MB_LP_4_INT_CLR_S  4
/** MB_LP_5_INT_CLR : WO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_LP_5_INT_CLR    (BIT(5))
#define MB_LP_5_INT_CLR_M  (MB_LP_5_INT_CLR_V << MB_LP_5_INT_CLR_S)
#define MB_LP_5_INT_CLR_V  0x00000001U
#define MB_LP_5_INT_CLR_S  5
/** MB_LP_6_INT_CLR : WO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_LP_6_INT_CLR    (BIT(6))
#define MB_LP_6_INT_CLR_M  (MB_LP_6_INT_CLR_V << MB_LP_6_INT_CLR_S)
#define MB_LP_6_INT_CLR_V  0x00000001U
#define MB_LP_6_INT_CLR_S  6
/** MB_LP_7_INT_CLR : WO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_LP_7_INT_CLR    (BIT(7))
#define MB_LP_7_INT_CLR_M  (MB_LP_7_INT_CLR_V << MB_LP_7_INT_CLR_S)
#define MB_LP_7_INT_CLR_V  0x00000001U
#define MB_LP_7_INT_CLR_S  7
/** MB_LP_8_INT_CLR : WO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_LP_8_INT_CLR    (BIT(8))
#define MB_LP_8_INT_CLR_M  (MB_LP_8_INT_CLR_V << MB_LP_8_INT_CLR_S)
#define MB_LP_8_INT_CLR_V  0x00000001U
#define MB_LP_8_INT_CLR_S  8
/** MB_LP_9_INT_CLR : WO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_LP_9_INT_CLR    (BIT(9))
#define MB_LP_9_INT_CLR_M  (MB_LP_9_INT_CLR_V << MB_LP_9_INT_CLR_S)
#define MB_LP_9_INT_CLR_V  0x00000001U
#define MB_LP_9_INT_CLR_S  9
/** MB_LP_10_INT_CLR : WO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_LP_10_INT_CLR    (BIT(10))
#define MB_LP_10_INT_CLR_M  (MB_LP_10_INT_CLR_V << MB_LP_10_INT_CLR_S)
#define MB_LP_10_INT_CLR_V  0x00000001U
#define MB_LP_10_INT_CLR_S  10
/** MB_LP_11_INT_CLR : WO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_LP_11_INT_CLR    (BIT(11))
#define MB_LP_11_INT_CLR_M  (MB_LP_11_INT_CLR_V << MB_LP_11_INT_CLR_S)
#define MB_LP_11_INT_CLR_V  0x00000001U
#define MB_LP_11_INT_CLR_S  11
/** MB_LP_12_INT_CLR : WO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_LP_12_INT_CLR    (BIT(12))
#define MB_LP_12_INT_CLR_M  (MB_LP_12_INT_CLR_V << MB_LP_12_INT_CLR_S)
#define MB_LP_12_INT_CLR_V  0x00000001U
#define MB_LP_12_INT_CLR_S  12
/** MB_LP_13_INT_CLR : WO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_LP_13_INT_CLR    (BIT(13))
#define MB_LP_13_INT_CLR_M  (MB_LP_13_INT_CLR_V << MB_LP_13_INT_CLR_S)
#define MB_LP_13_INT_CLR_V  0x00000001U
#define MB_LP_13_INT_CLR_S  13
/** MB_LP_14_INT_CLR : WO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_LP_14_INT_CLR    (BIT(14))
#define MB_LP_14_INT_CLR_M  (MB_LP_14_INT_CLR_V << MB_LP_14_INT_CLR_S)
#define MB_LP_14_INT_CLR_V  0x00000001U
#define MB_LP_14_INT_CLR_S  14
/** MB_LP_15_INT_CLR : WO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_LP_15_INT_CLR    (BIT(15))
#define MB_LP_15_INT_CLR_M  (MB_LP_15_INT_CLR_V << MB_LP_15_INT_CLR_S)
#define MB_LP_15_INT_CLR_V  0x00000001U
#define MB_LP_15_INT_CLR_S  15

/** MB_HP_INT_RAW_REG register
 *  need_des
 */
#define MB_HP_INT_RAW_REG (DR_REG_MB_BASE + 0x50)
/** MB_HP_0_INT_RAW : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_HP_0_INT_RAW    (BIT(0))
#define MB_HP_0_INT_RAW_M  (MB_HP_0_INT_RAW_V << MB_HP_0_INT_RAW_S)
#define MB_HP_0_INT_RAW_V  0x00000001U
#define MB_HP_0_INT_RAW_S  0
/** MB_HP_1_INT_RAW : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_HP_1_INT_RAW    (BIT(1))
#define MB_HP_1_INT_RAW_M  (MB_HP_1_INT_RAW_V << MB_HP_1_INT_RAW_S)
#define MB_HP_1_INT_RAW_V  0x00000001U
#define MB_HP_1_INT_RAW_S  1
/** MB_HP_2_INT_RAW : RO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_HP_2_INT_RAW    (BIT(2))
#define MB_HP_2_INT_RAW_M  (MB_HP_2_INT_RAW_V << MB_HP_2_INT_RAW_S)
#define MB_HP_2_INT_RAW_V  0x00000001U
#define MB_HP_2_INT_RAW_S  2
/** MB_HP_3_INT_RAW : RO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_HP_3_INT_RAW    (BIT(3))
#define MB_HP_3_INT_RAW_M  (MB_HP_3_INT_RAW_V << MB_HP_3_INT_RAW_S)
#define MB_HP_3_INT_RAW_V  0x00000001U
#define MB_HP_3_INT_RAW_S  3
/** MB_HP_4_INT_RAW : RO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_HP_4_INT_RAW    (BIT(4))
#define MB_HP_4_INT_RAW_M  (MB_HP_4_INT_RAW_V << MB_HP_4_INT_RAW_S)
#define MB_HP_4_INT_RAW_V  0x00000001U
#define MB_HP_4_INT_RAW_S  4
/** MB_HP_5_INT_RAW : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_HP_5_INT_RAW    (BIT(5))
#define MB_HP_5_INT_RAW_M  (MB_HP_5_INT_RAW_V << MB_HP_5_INT_RAW_S)
#define MB_HP_5_INT_RAW_V  0x00000001U
#define MB_HP_5_INT_RAW_S  5
/** MB_HP_6_INT_RAW : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_HP_6_INT_RAW    (BIT(6))
#define MB_HP_6_INT_RAW_M  (MB_HP_6_INT_RAW_V << MB_HP_6_INT_RAW_S)
#define MB_HP_6_INT_RAW_V  0x00000001U
#define MB_HP_6_INT_RAW_S  6
/** MB_HP_7_INT_RAW : RO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_HP_7_INT_RAW    (BIT(7))
#define MB_HP_7_INT_RAW_M  (MB_HP_7_INT_RAW_V << MB_HP_7_INT_RAW_S)
#define MB_HP_7_INT_RAW_V  0x00000001U
#define MB_HP_7_INT_RAW_S  7
/** MB_HP_8_INT_RAW : RO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_HP_8_INT_RAW    (BIT(8))
#define MB_HP_8_INT_RAW_M  (MB_HP_8_INT_RAW_V << MB_HP_8_INT_RAW_S)
#define MB_HP_8_INT_RAW_V  0x00000001U
#define MB_HP_8_INT_RAW_S  8
/** MB_HP_9_INT_RAW : RO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_HP_9_INT_RAW    (BIT(9))
#define MB_HP_9_INT_RAW_M  (MB_HP_9_INT_RAW_V << MB_HP_9_INT_RAW_S)
#define MB_HP_9_INT_RAW_V  0x00000001U
#define MB_HP_9_INT_RAW_S  9
/** MB_HP_10_INT_RAW : RO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_HP_10_INT_RAW    (BIT(10))
#define MB_HP_10_INT_RAW_M  (MB_HP_10_INT_RAW_V << MB_HP_10_INT_RAW_S)
#define MB_HP_10_INT_RAW_V  0x00000001U
#define MB_HP_10_INT_RAW_S  10
/** MB_HP_11_INT_RAW : RO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_HP_11_INT_RAW    (BIT(11))
#define MB_HP_11_INT_RAW_M  (MB_HP_11_INT_RAW_V << MB_HP_11_INT_RAW_S)
#define MB_HP_11_INT_RAW_V  0x00000001U
#define MB_HP_11_INT_RAW_S  11
/** MB_HP_12_INT_RAW : RO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_HP_12_INT_RAW    (BIT(12))
#define MB_HP_12_INT_RAW_M  (MB_HP_12_INT_RAW_V << MB_HP_12_INT_RAW_S)
#define MB_HP_12_INT_RAW_V  0x00000001U
#define MB_HP_12_INT_RAW_S  12
/** MB_HP_13_INT_RAW : RO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_HP_13_INT_RAW    (BIT(13))
#define MB_HP_13_INT_RAW_M  (MB_HP_13_INT_RAW_V << MB_HP_13_INT_RAW_S)
#define MB_HP_13_INT_RAW_V  0x00000001U
#define MB_HP_13_INT_RAW_S  13
/** MB_HP_14_INT_RAW : RO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_HP_14_INT_RAW    (BIT(14))
#define MB_HP_14_INT_RAW_M  (MB_HP_14_INT_RAW_V << MB_HP_14_INT_RAW_S)
#define MB_HP_14_INT_RAW_V  0x00000001U
#define MB_HP_14_INT_RAW_S  14
/** MB_HP_15_INT_RAW : RO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_HP_15_INT_RAW    (BIT(15))
#define MB_HP_15_INT_RAW_M  (MB_HP_15_INT_RAW_V << MB_HP_15_INT_RAW_S)
#define MB_HP_15_INT_RAW_V  0x00000001U
#define MB_HP_15_INT_RAW_S  15

/** MB_HP_INT_ST_REG register
 *  need_des
 */
#define MB_HP_INT_ST_REG (DR_REG_MB_BASE + 0x54)
/** MB_HP_0_INT_ST : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_HP_0_INT_ST    (BIT(0))
#define MB_HP_0_INT_ST_M  (MB_HP_0_INT_ST_V << MB_HP_0_INT_ST_S)
#define MB_HP_0_INT_ST_V  0x00000001U
#define MB_HP_0_INT_ST_S  0
/** MB_HP_1_INT_ST : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_HP_1_INT_ST    (BIT(1))
#define MB_HP_1_INT_ST_M  (MB_HP_1_INT_ST_V << MB_HP_1_INT_ST_S)
#define MB_HP_1_INT_ST_V  0x00000001U
#define MB_HP_1_INT_ST_S  1
/** MB_HP_2_INT_ST : RO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_HP_2_INT_ST    (BIT(2))
#define MB_HP_2_INT_ST_M  (MB_HP_2_INT_ST_V << MB_HP_2_INT_ST_S)
#define MB_HP_2_INT_ST_V  0x00000001U
#define MB_HP_2_INT_ST_S  2
/** MB_HP_3_INT_ST : RO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_HP_3_INT_ST    (BIT(3))
#define MB_HP_3_INT_ST_M  (MB_HP_3_INT_ST_V << MB_HP_3_INT_ST_S)
#define MB_HP_3_INT_ST_V  0x00000001U
#define MB_HP_3_INT_ST_S  3
/** MB_HP_4_INT_ST : RO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_HP_4_INT_ST    (BIT(4))
#define MB_HP_4_INT_ST_M  (MB_HP_4_INT_ST_V << MB_HP_4_INT_ST_S)
#define MB_HP_4_INT_ST_V  0x00000001U
#define MB_HP_4_INT_ST_S  4
/** MB_HP_5_INT_ST : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_HP_5_INT_ST    (BIT(5))
#define MB_HP_5_INT_ST_M  (MB_HP_5_INT_ST_V << MB_HP_5_INT_ST_S)
#define MB_HP_5_INT_ST_V  0x00000001U
#define MB_HP_5_INT_ST_S  5
/** MB_HP_6_INT_ST : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_HP_6_INT_ST    (BIT(6))
#define MB_HP_6_INT_ST_M  (MB_HP_6_INT_ST_V << MB_HP_6_INT_ST_S)
#define MB_HP_6_INT_ST_V  0x00000001U
#define MB_HP_6_INT_ST_S  6
/** MB_HP_7_INT_ST : RO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_HP_7_INT_ST    (BIT(7))
#define MB_HP_7_INT_ST_M  (MB_HP_7_INT_ST_V << MB_HP_7_INT_ST_S)
#define MB_HP_7_INT_ST_V  0x00000001U
#define MB_HP_7_INT_ST_S  7
/** MB_HP_8_INT_ST : RO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_HP_8_INT_ST    (BIT(8))
#define MB_HP_8_INT_ST_M  (MB_HP_8_INT_ST_V << MB_HP_8_INT_ST_S)
#define MB_HP_8_INT_ST_V  0x00000001U
#define MB_HP_8_INT_ST_S  8
/** MB_HP_9_INT_ST : RO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_HP_9_INT_ST    (BIT(9))
#define MB_HP_9_INT_ST_M  (MB_HP_9_INT_ST_V << MB_HP_9_INT_ST_S)
#define MB_HP_9_INT_ST_V  0x00000001U
#define MB_HP_9_INT_ST_S  9
/** MB_HP_10_INT_ST : RO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_HP_10_INT_ST    (BIT(10))
#define MB_HP_10_INT_ST_M  (MB_HP_10_INT_ST_V << MB_HP_10_INT_ST_S)
#define MB_HP_10_INT_ST_V  0x00000001U
#define MB_HP_10_INT_ST_S  10
/** MB_HP_11_INT_ST : RO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_HP_11_INT_ST    (BIT(11))
#define MB_HP_11_INT_ST_M  (MB_HP_11_INT_ST_V << MB_HP_11_INT_ST_S)
#define MB_HP_11_INT_ST_V  0x00000001U
#define MB_HP_11_INT_ST_S  11
/** MB_HP_12_INT_ST : RO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_HP_12_INT_ST    (BIT(12))
#define MB_HP_12_INT_ST_M  (MB_HP_12_INT_ST_V << MB_HP_12_INT_ST_S)
#define MB_HP_12_INT_ST_V  0x00000001U
#define MB_HP_12_INT_ST_S  12
/** MB_HP_13_INT_ST : RO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_HP_13_INT_ST    (BIT(13))
#define MB_HP_13_INT_ST_M  (MB_HP_13_INT_ST_V << MB_HP_13_INT_ST_S)
#define MB_HP_13_INT_ST_V  0x00000001U
#define MB_HP_13_INT_ST_S  13
/** MB_HP_14_INT_ST : RO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_HP_14_INT_ST    (BIT(14))
#define MB_HP_14_INT_ST_M  (MB_HP_14_INT_ST_V << MB_HP_14_INT_ST_S)
#define MB_HP_14_INT_ST_V  0x00000001U
#define MB_HP_14_INT_ST_S  14
/** MB_HP_15_INT_ST : RO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_HP_15_INT_ST    (BIT(15))
#define MB_HP_15_INT_ST_M  (MB_HP_15_INT_ST_V << MB_HP_15_INT_ST_S)
#define MB_HP_15_INT_ST_V  0x00000001U
#define MB_HP_15_INT_ST_S  15

/** MB_HP_INT_ENA_REG register
 *  need_des
 */
#define MB_HP_INT_ENA_REG (DR_REG_MB_BASE + 0x58)
/** MB_HP_0_INT_ENA : R/W; bitpos: [0]; default: 1;
 *  need_des
 */
#define MB_HP_0_INT_ENA    (BIT(0))
#define MB_HP_0_INT_ENA_M  (MB_HP_0_INT_ENA_V << MB_HP_0_INT_ENA_S)
#define MB_HP_0_INT_ENA_V  0x00000001U
#define MB_HP_0_INT_ENA_S  0
/** MB_HP_1_INT_ENA : R/W; bitpos: [1]; default: 1;
 *  need_des
 */
#define MB_HP_1_INT_ENA    (BIT(1))
#define MB_HP_1_INT_ENA_M  (MB_HP_1_INT_ENA_V << MB_HP_1_INT_ENA_S)
#define MB_HP_1_INT_ENA_V  0x00000001U
#define MB_HP_1_INT_ENA_S  1
/** MB_HP_2_INT_ENA : R/W; bitpos: [2]; default: 1;
 *  need_des
 */
#define MB_HP_2_INT_ENA    (BIT(2))
#define MB_HP_2_INT_ENA_M  (MB_HP_2_INT_ENA_V << MB_HP_2_INT_ENA_S)
#define MB_HP_2_INT_ENA_V  0x00000001U
#define MB_HP_2_INT_ENA_S  2
/** MB_HP_3_INT_ENA : R/W; bitpos: [3]; default: 1;
 *  need_des
 */
#define MB_HP_3_INT_ENA    (BIT(3))
#define MB_HP_3_INT_ENA_M  (MB_HP_3_INT_ENA_V << MB_HP_3_INT_ENA_S)
#define MB_HP_3_INT_ENA_V  0x00000001U
#define MB_HP_3_INT_ENA_S  3
/** MB_HP_4_INT_ENA : R/W; bitpos: [4]; default: 1;
 *  need_des
 */
#define MB_HP_4_INT_ENA    (BIT(4))
#define MB_HP_4_INT_ENA_M  (MB_HP_4_INT_ENA_V << MB_HP_4_INT_ENA_S)
#define MB_HP_4_INT_ENA_V  0x00000001U
#define MB_HP_4_INT_ENA_S  4
/** MB_HP_5_INT_ENA : R/W; bitpos: [5]; default: 1;
 *  need_des
 */
#define MB_HP_5_INT_ENA    (BIT(5))
#define MB_HP_5_INT_ENA_M  (MB_HP_5_INT_ENA_V << MB_HP_5_INT_ENA_S)
#define MB_HP_5_INT_ENA_V  0x00000001U
#define MB_HP_5_INT_ENA_S  5
/** MB_HP_6_INT_ENA : R/W; bitpos: [6]; default: 1;
 *  need_des
 */
#define MB_HP_6_INT_ENA    (BIT(6))
#define MB_HP_6_INT_ENA_M  (MB_HP_6_INT_ENA_V << MB_HP_6_INT_ENA_S)
#define MB_HP_6_INT_ENA_V  0x00000001U
#define MB_HP_6_INT_ENA_S  6
/** MB_HP_7_INT_ENA : R/W; bitpos: [7]; default: 1;
 *  need_des
 */
#define MB_HP_7_INT_ENA    (BIT(7))
#define MB_HP_7_INT_ENA_M  (MB_HP_7_INT_ENA_V << MB_HP_7_INT_ENA_S)
#define MB_HP_7_INT_ENA_V  0x00000001U
#define MB_HP_7_INT_ENA_S  7
/** MB_HP_8_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_HP_8_INT_ENA    (BIT(8))
#define MB_HP_8_INT_ENA_M  (MB_HP_8_INT_ENA_V << MB_HP_8_INT_ENA_S)
#define MB_HP_8_INT_ENA_V  0x00000001U
#define MB_HP_8_INT_ENA_S  8
/** MB_HP_9_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_HP_9_INT_ENA    (BIT(9))
#define MB_HP_9_INT_ENA_M  (MB_HP_9_INT_ENA_V << MB_HP_9_INT_ENA_S)
#define MB_HP_9_INT_ENA_V  0x00000001U
#define MB_HP_9_INT_ENA_S  9
/** MB_HP_10_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_HP_10_INT_ENA    (BIT(10))
#define MB_HP_10_INT_ENA_M  (MB_HP_10_INT_ENA_V << MB_HP_10_INT_ENA_S)
#define MB_HP_10_INT_ENA_V  0x00000001U
#define MB_HP_10_INT_ENA_S  10
/** MB_HP_11_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_HP_11_INT_ENA    (BIT(11))
#define MB_HP_11_INT_ENA_M  (MB_HP_11_INT_ENA_V << MB_HP_11_INT_ENA_S)
#define MB_HP_11_INT_ENA_V  0x00000001U
#define MB_HP_11_INT_ENA_S  11
/** MB_HP_12_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_HP_12_INT_ENA    (BIT(12))
#define MB_HP_12_INT_ENA_M  (MB_HP_12_INT_ENA_V << MB_HP_12_INT_ENA_S)
#define MB_HP_12_INT_ENA_V  0x00000001U
#define MB_HP_12_INT_ENA_S  12
/** MB_HP_13_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_HP_13_INT_ENA    (BIT(13))
#define MB_HP_13_INT_ENA_M  (MB_HP_13_INT_ENA_V << MB_HP_13_INT_ENA_S)
#define MB_HP_13_INT_ENA_V  0x00000001U
#define MB_HP_13_INT_ENA_S  13
/** MB_HP_14_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_HP_14_INT_ENA    (BIT(14))
#define MB_HP_14_INT_ENA_M  (MB_HP_14_INT_ENA_V << MB_HP_14_INT_ENA_S)
#define MB_HP_14_INT_ENA_V  0x00000001U
#define MB_HP_14_INT_ENA_S  14
/** MB_HP_15_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_HP_15_INT_ENA    (BIT(15))
#define MB_HP_15_INT_ENA_M  (MB_HP_15_INT_ENA_V << MB_HP_15_INT_ENA_S)
#define MB_HP_15_INT_ENA_V  0x00000001U
#define MB_HP_15_INT_ENA_S  15

/** MB_HP_INT_CLR_REG register
 *  need_des
 */
#define MB_HP_INT_CLR_REG (DR_REG_MB_BASE + 0x5c)
/** MB_HP_0_INT_CLR : WO; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_HP_0_INT_CLR    (BIT(0))
#define MB_HP_0_INT_CLR_M  (MB_HP_0_INT_CLR_V << MB_HP_0_INT_CLR_S)
#define MB_HP_0_INT_CLR_V  0x00000001U
#define MB_HP_0_INT_CLR_S  0
/** MB_HP_1_INT_CLR : WO; bitpos: [1]; default: 0;
 *  need_des
 */
#define MB_HP_1_INT_CLR    (BIT(1))
#define MB_HP_1_INT_CLR_M  (MB_HP_1_INT_CLR_V << MB_HP_1_INT_CLR_S)
#define MB_HP_1_INT_CLR_V  0x00000001U
#define MB_HP_1_INT_CLR_S  1
/** MB_HP_2_INT_CLR : WO; bitpos: [2]; default: 0;
 *  need_des
 */
#define MB_HP_2_INT_CLR    (BIT(2))
#define MB_HP_2_INT_CLR_M  (MB_HP_2_INT_CLR_V << MB_HP_2_INT_CLR_S)
#define MB_HP_2_INT_CLR_V  0x00000001U
#define MB_HP_2_INT_CLR_S  2
/** MB_HP_3_INT_CLR : WO; bitpos: [3]; default: 0;
 *  need_des
 */
#define MB_HP_3_INT_CLR    (BIT(3))
#define MB_HP_3_INT_CLR_M  (MB_HP_3_INT_CLR_V << MB_HP_3_INT_CLR_S)
#define MB_HP_3_INT_CLR_V  0x00000001U
#define MB_HP_3_INT_CLR_S  3
/** MB_HP_4_INT_CLR : WO; bitpos: [4]; default: 0;
 *  need_des
 */
#define MB_HP_4_INT_CLR    (BIT(4))
#define MB_HP_4_INT_CLR_M  (MB_HP_4_INT_CLR_V << MB_HP_4_INT_CLR_S)
#define MB_HP_4_INT_CLR_V  0x00000001U
#define MB_HP_4_INT_CLR_S  4
/** MB_HP_5_INT_CLR : WO; bitpos: [5]; default: 0;
 *  need_des
 */
#define MB_HP_5_INT_CLR    (BIT(5))
#define MB_HP_5_INT_CLR_M  (MB_HP_5_INT_CLR_V << MB_HP_5_INT_CLR_S)
#define MB_HP_5_INT_CLR_V  0x00000001U
#define MB_HP_5_INT_CLR_S  5
/** MB_HP_6_INT_CLR : WO; bitpos: [6]; default: 0;
 *  need_des
 */
#define MB_HP_6_INT_CLR    (BIT(6))
#define MB_HP_6_INT_CLR_M  (MB_HP_6_INT_CLR_V << MB_HP_6_INT_CLR_S)
#define MB_HP_6_INT_CLR_V  0x00000001U
#define MB_HP_6_INT_CLR_S  6
/** MB_HP_7_INT_CLR : WO; bitpos: [7]; default: 0;
 *  need_des
 */
#define MB_HP_7_INT_CLR    (BIT(7))
#define MB_HP_7_INT_CLR_M  (MB_HP_7_INT_CLR_V << MB_HP_7_INT_CLR_S)
#define MB_HP_7_INT_CLR_V  0x00000001U
#define MB_HP_7_INT_CLR_S  7
/** MB_HP_8_INT_CLR : WO; bitpos: [8]; default: 0;
 *  need_des
 */
#define MB_HP_8_INT_CLR    (BIT(8))
#define MB_HP_8_INT_CLR_M  (MB_HP_8_INT_CLR_V << MB_HP_8_INT_CLR_S)
#define MB_HP_8_INT_CLR_V  0x00000001U
#define MB_HP_8_INT_CLR_S  8
/** MB_HP_9_INT_CLR : WO; bitpos: [9]; default: 0;
 *  need_des
 */
#define MB_HP_9_INT_CLR    (BIT(9))
#define MB_HP_9_INT_CLR_M  (MB_HP_9_INT_CLR_V << MB_HP_9_INT_CLR_S)
#define MB_HP_9_INT_CLR_V  0x00000001U
#define MB_HP_9_INT_CLR_S  9
/** MB_HP_10_INT_CLR : WO; bitpos: [10]; default: 0;
 *  need_des
 */
#define MB_HP_10_INT_CLR    (BIT(10))
#define MB_HP_10_INT_CLR_M  (MB_HP_10_INT_CLR_V << MB_HP_10_INT_CLR_S)
#define MB_HP_10_INT_CLR_V  0x00000001U
#define MB_HP_10_INT_CLR_S  10
/** MB_HP_11_INT_CLR : WO; bitpos: [11]; default: 0;
 *  need_des
 */
#define MB_HP_11_INT_CLR    (BIT(11))
#define MB_HP_11_INT_CLR_M  (MB_HP_11_INT_CLR_V << MB_HP_11_INT_CLR_S)
#define MB_HP_11_INT_CLR_V  0x00000001U
#define MB_HP_11_INT_CLR_S  11
/** MB_HP_12_INT_CLR : WO; bitpos: [12]; default: 0;
 *  need_des
 */
#define MB_HP_12_INT_CLR    (BIT(12))
#define MB_HP_12_INT_CLR_M  (MB_HP_12_INT_CLR_V << MB_HP_12_INT_CLR_S)
#define MB_HP_12_INT_CLR_V  0x00000001U
#define MB_HP_12_INT_CLR_S  12
/** MB_HP_13_INT_CLR : WO; bitpos: [13]; default: 0;
 *  need_des
 */
#define MB_HP_13_INT_CLR    (BIT(13))
#define MB_HP_13_INT_CLR_M  (MB_HP_13_INT_CLR_V << MB_HP_13_INT_CLR_S)
#define MB_HP_13_INT_CLR_V  0x00000001U
#define MB_HP_13_INT_CLR_S  13
/** MB_HP_14_INT_CLR : WO; bitpos: [14]; default: 0;
 *  need_des
 */
#define MB_HP_14_INT_CLR    (BIT(14))
#define MB_HP_14_INT_CLR_M  (MB_HP_14_INT_CLR_V << MB_HP_14_INT_CLR_S)
#define MB_HP_14_INT_CLR_V  0x00000001U
#define MB_HP_14_INT_CLR_S  14
/** MB_HP_15_INT_CLR : WO; bitpos: [15]; default: 0;
 *  need_des
 */
#define MB_HP_15_INT_CLR    (BIT(15))
#define MB_HP_15_INT_CLR_M  (MB_HP_15_INT_CLR_V << MB_HP_15_INT_CLR_S)
#define MB_HP_15_INT_CLR_V  0x00000001U
#define MB_HP_15_INT_CLR_S  15

/** MB_REG_CLK_EN_REG register
 *  need_des
 */
#define MB_REG_CLK_EN_REG (DR_REG_MB_BASE + 0x60)
/** MB_REG_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define MB_REG_CLK_EN    (BIT(0))
#define MB_REG_CLK_EN_M  (MB_REG_CLK_EN_V << MB_REG_CLK_EN_S)
#define MB_REG_CLK_EN_V  0x00000001U
#define MB_REG_CLK_EN_S  0

#ifdef __cplusplus
}
#endif
