# v1.11.0更新内容

※我们继续和一些优秀且具有开源精神的代码编写者保持着积极合作。在这一版本中，我们通过接收GitHub的Pull Request，整合了@AstralBarrage @ChiryuhLii @Cicardo-Thicavasco @diandian157 @IceCola97 @kuangshen04 @LeeMing999 @mengxinzxz @nonamemajun @nonameShijian @rebirth-of-I-am @Sun-F2004 @S-N-O-R-L-A-X @taofendawang1105 @Xiazhiliao @xiyang141 @xizifu @xjm0708 @yx-lingmeng @zhichaoxi2006 @zhonghui1966 @1937475624 共22位贡献者编写的代码（排名不分先后）。

## 新武将

- **十周年：**
  - **神将：** 新杀神孙权
  - **群英荟萃：** 马邈
  - **系列专属：** 新杀阎象、崔烈、星蒋琬、星太史慈、星颜良
  - **限定专属：** 新杀谋庞统、新杀谋吴懿、新杀谋法正、侯昭宁、新杀谋许攸、新杀谋吕蒙、新杀桓阶、凌烈、刘懿君、陶璜、新杀谋朱然、威孙尚香、新杀谋徐盛、苏越、郭缇萦、徐妏、威曹操
  - **新一将成名：** ☆法正、SP蒲元、威孙策、爻袁术、寒冰剑少女、藤甲男孩
  - **联动卡：** 有诸葛亮、波仔、香蕉端午
  - **怀旧：** 牢寒冰剑少女、牢藤甲男孩、牢SP蒲元、牢爻袁术、

- **OL：**
  - **OL专属：** OL谋董昭、OL谋程昱、OL魔曹操、OL谋戏志才、魔孙权、OL谋郭嘉、OL界于禁、闪朱儁、闪孙坚、闪张辽
  - **璀璨星河：** OL崔琰、OL吕玲绮、环淑君、孙鸢
  - **门阀士族：** 族陈群、族荀彧、族韩馥
  - **联动卡：** OL乐刘禅、OL乐邓艾

- **手杀/海外：**
  - **移动版：** 手杀SP钟会、手杀崔令仪、礼卢毓、手杀SP曹操
  - **兵势篇：** 势陈矫、势邓艾、势桓阶
  - **外服武将：** TW起孙坚、TW起何进、TW起皇甫嵩

- **线下：**
  - **绝代智将：** 智将黄崇、智将丁奉、智将廖化、智将张虎、智将乐綝、智将胡烈、诸葛绪、智将陆抗、赵统、赵广、智将诸葛瞻、柳隐、霍弋、姚柯回、夏侯含、结依夏侯含、智将钟会、智将姜维、刘渊、魂诸葛亮
  - **闪耀战姬：** 闪耀甄宓、闪耀吴国太、闪耀芮姬、闪耀吕玲绮、闪耀董绾、领主哥布林、哥布林
  - **26珍藏：** 26神黄月英、26SP徐氏、26界鲁肃、26界张郃、26界太史慈、26界贾诩
  - **欧陆风云：** 马克里努斯、阿尔达希尔、马抗、欧陆于禁、欧陆张辽、欧陆乐进
  - **徐兖纵横：** 徐兖曹操、徐兖程昱、徐兖荀彧、徐兖陈宫、徐兖张闿、徐兖吕布、徐兖张邈、徐兖曹嵩
  - **四象封印·白虎/朱雀：** 标黄舞蝶、标清河公主、标麴义、标文鸳、标许劭、标张嫙、标沮授、标司马徽、标郑玄、标祢衡、标马钧、标张奋、标赵嫣、标刘理
  - **蚀心入魔·慢：** 魔关羽、慢关银屏、慢于禁、慢糜芳、慢寇封、慢陆逊、慢吕蒙、慢庞德、慢颜良文丑
  - **其他：** 渭南朱灵、文心雕龙曹操、SCL贾诩、PE郭照、PE夏侯玄、SCL吕布、PE钟会、PE纪灵、君吕布

### 模式限定武将

**国战：** 【国战无双】十二神将；曹冲、OL钟会、界黄月英、界张角、界曹操、界陆逊、张松、手杀陆逊、OL吴懿

**剑阁：** 毅勇文则、恶来子满、威武翼德、神箭汉升

### 新卡牌

- **应变：** 【百辟刀】
- **活动卡牌：** 【青囊书】【传国玉玺】
- **线下卡牌：** 【联军盛宴】【玉石皆碎】【柳叶刀】【夜行衣】
- **衍生：** 【一鼓作气】

### 跟进武将调整

- **十周年：** 徐馨、SP祝融、新杀谋骆统、新杀谋陆逊、新杀谋徐盛
- **OL：** OL杨奉、族王明山、OL谋邓艾、魔孙权、OL刘璋
- **移动版：** 手杀笮融、谋孙权、手杀谋姜维、手杀谋张辽、手杀孟达、势张燕、势辛宪英、势鲁肃
- **移动版海外：** 幻姜维、海外王越、势太史慈、TW张昭、TW乔公、友诸葛亮、夏侯令女、张勋、星魏延、王越、田畴、张瑶、尹夫人、谋杨婉、手杀糜夫人、手杀向宠、手杀界凌统
- **线下：** 【青史翰墨·江山如故】

## 新功能

### 工程化

无名杀的`PR-Branch`现在可以使用vite构建了

> **注意：** 现在无名杀区分开发环境和生产环境，**不能互相覆盖/混用**
>
> - 开发环境为`PR-Branch`分支，使用vite以及浏览器开发，在PC端运行
> - 生产环境为`build-tooling`分支、发布的完整包以及测试包，直接进入启动器文件夹覆盖
> - 使用`pnpm build`可以将开发环境打包为生产环境，结果将输出在`dist/`文件夹下
> - 开发本体代码或涉及更改本体功能的扩展（例如美化）建议使用开发环境
> - 开发武将扩展可以使用生产环境，需要阅读源码请进入`src/`文件夹查看

1. 开发环境要求
    > **提示：** 请参考`docs/how-to-start.md`或[github文档](https://github.com/libnoname/noname/wiki/%E5%A6%82%E4%BD%95%E8%BF%90%E8%A1%8C%E6%97%A0%E5%90%8D%E6%9D%80%EF%BC%88%E7%A8%8B%E5%BA%8F%E5%91%98%E7%89%88%EF%BC%89) 配置环境。

    - [Node.js](https://nodejs.org/) ^20.19.0 || >=22.12.0
    - [pnpm](https://pnpm.io/) >= 9

2. 下载[PR-Branch](https://github.com/libnoname/noname/tree/PR-Branch)

3. 安装依赖

    ```bash
    pnpm install
    ```

4. 启动

    ```bash
    pnpm dev
    ```

5. 构建

    ```bash
    pnpm build
    ```

### OL单骑无双·战法

具体功能请查看`noname/library/zhanfa.js`

```javascript
/**
 * 添加新战法
 * @param {object} zhanfa 要添加的战法
 * @param {string} [zhanfa.id]
 * @param {Skill | string} [zhanfa.skill] 战法的对应效果
 * @param {string | null} [zhanfa.rarity] 战法的稀有度
 * @param {string} [zhanfa.translate] 战法的翻译
 * @param {string} [zhanfa.info] 战法的说明
 * @param {object | undefined} [zhanfa.card] 战法的对应类似卡牌的信息（包括战法的ai），扩展可以在这里添加路（image属性）或者直接引用已有的卡牌图片（cardimage）
 */
lib.zhanfa.add(zhanfa)
/**
 * 获取所有战法的id
 * @param {boolean | undefined} includeBan 获取所有战法，包括被ban的战法
 * @returns {string[]}
 */
lib.zhanfa.getList(includeBan)
/**
 * 获取对应战法的Object
 * @param {string} id 战法的id
 * @returns {object}
 */
lib.zhanfa.get(id)
/**
 * 是否拥有对应战法
 * @param {string} id 战法的id
 */
player.hasZhanfa(id)
/**
 * 获得对应战法
 * @param {string} id 战法的id
 */
player.addZhanfa(id)
/**
 * 失去对应战法
 * @param {string} id 战法的id
 */
player.removeZhanfa(id)
```

### 本体换肤

具体参考`docs/skin-guide.md`

### 全选/反选

主动技添加`allowChooseAll: true`属性来增加全选/反选按钮
选按钮、选牌系列方法(包括但不限于`chooseButton`、`chooseCard`、`chooseToDiscard`、`chooseToUse`、`chooseToRespond`、`chooseButtonTarget`、`chooseCardTarget`)传入`"allowChooseAll"`来增加全选/反选按钮

### 公共区域lib.commonArea

将仁库迁入lib.commonArea
> lib.config.show_commonCardpile开启后可与查看牌堆一样查看各个公共区域的牌

```javascript
lib.commonArea = new Map([
  [
   "renku",
   {
    /**翻译名 */
    translate: "仁库",
    /** 存牌的区域名，_status.renku即是仁库这一区域 */
    areaStatusName: "renku",
    /** #player.lose和game.cardsGotoSpecial中的参数名，用于指向区域 */
    toName: "toRenku",
    /** #player.gain/.addToExpansion中的参数名，表示来源区域 */
    fromName: "fromRenku",
    /** 处理添加到相应区域中的卡牌*/
    async addHandeler(event, trigger, player) {
    },
    /** 处理从相应区域中移出的卡牌*/
    async removeHandeler(event, trigger, player) {
    },
   },
  ],
 ]);
```

### 共联时机`phaseAny`

```javascript
trigger:{
  player: "phaseAnyBegin"
}
// 等同于
trigger:{
  player: ["phaseZhunbeiBegin", "phaseJudgeBegin", "phaseDrawBegin", "phaseUseBegin", "phaseDiscardBegin", "phaseJieshuBegin"]
}
```

### dialog handle

> 使用例：手杀曹髦【清正】、手杀陆郁生【润微】、孙韶【筑墼】、标郑玄【整经】、刘渊【兼习】、十周年赵襄【扶汉】

```javascript
chooseButton([
 [
  [[`${get.translation(event.skill)}：请选择一个花色的牌`], "addNewRow"],
  [
   dialog => {
    //自定义handler
   },
   "handle",
  ],
  list.map(item => [Array.isArray(item) ? item : [item], "addNewRow"]),
 ],
])
```

### lib.poptip.addType

添加类型"character"，用于武将专属的特定名词，如“向死存魏”、“五禽戏”

```javascript
/**
 * 注册poptip类型
 * @param {string} type 名词类型
 */
addType(type)
```

### game.chooseAnyOL

多名玩家同时进行选择
> 使用例：【翦灭】【忠锷】【搏决】【邀作】【诛逆】

```javascript
/**
 * 此方法用于让所有targets同时执行一个选择函数
 *
 * @param { Player[] } targets 需要执行选择函数的目标
 * @param { function } func 需要执行的函数
 * @param { Any[] } args 函数所需的参数
 * @returns { GameEvent }
 */
chooseAnyOL(targets, func, args)
```

### game.addPlayerOL/removePlayerOL

添加/移除玩家
> 废弃game.addPlayer/removePlayer

```javascript
/**
 * 添加一个新玩家到target的上家或下家（默认为上家）
 * @param { Player } target 新玩家的下家
 * @param { string|undefined|null } [character] 新玩家主将
 * @param { string|undefined|null } [character2] 新玩家副将
 * @param { boolean } [isNext] 是否添加到下家
 * @returns { Player }
 */
addPlayerOL(target, character, character2, isNext)
/**
 * 移除一名玩家，单机联机都可用
 * @param { Player } player 要移除的玩家
 * @returns { Player }
 */
removePlayerOL(player)
```

### game.addTempTag

游戏内创建的临时tag
> 使用例:【烈计】【伸义】【纯刚】【火上浇油】

```javascript
/**
 * 添加游戏内生成使用的临时tag
 *
 * @param {string} id tag对应id
 * @param {string} translation tag对应翻译
 * @returns {string}
 */
addTempTag(id, translation)
```

### player.refreshSkill

批量重置武将牌上的技能
> 使用例：【中流】【摧锋】【登难】

### player.getName

获取一名角色的名字翻译

```javascript
/**
 * 获取一名角色的名字翻译
 * @param { boolean } forDialog 是否用于对话框显示，如【五谷丰登】/【惠民】之类多名角色选择卡牌的卡牌/技能的content中，方便知晓卡牌和角色的对应关系。默认为false。
 * @returns { string } 角色名字翻译，forDialog为true会返回HTML字符串，为对话框中的卡牌呈现类似卡牌动画信息的效果，否则根据player._tempTranslate、lib.translate[`${player.name}_ab`]、get.translation(player.name)的优先级返回纯文本。
 */
getName(forDialog = false)
```

### game.createButtonCardsetion

### card.prepareEquip

装备前的预处理

```javascript
card: {
  async prepareEquip(event, trigger, player) {
    //任意流程
  }
}
```

### get.characterTitle

获取称号

```javascript
// 获取玩家主将称号（纯文本）
get.characterTitle(player);
// 获取玩家副将称号（纯文本）
get.characterTitle(player, true);
// 获取某个角色id称号（纯文本）
get.characterTitle("liubei", true);
// 获取某个角色id称号（非纯文本）
get.characterTitle("liubei", false，false);
```

```javascript
/**
 * 在指定节点（button）内部创建一个卡片内容区域（.cardsetion），并根据当前结构设置节点状态，用于五谷此类须多人选择的牌的执过程中显示每张卡牌对应的选择角色
 * @param {string} innerHTML 要插入到.cardsetion中的HTML内容
 * @param {HTMLElement} button 目标节点
 */
createButtonCardsetion(innerHTML, button)
```

### get.addNewRowList

```javascript
/**
 * 将一组卡牌按花色或颜色分组，生成最终可用于dialog.addNewRow方法的参数列表，用于使用#Player.chooseButton/Player.chooseButtonTarget使用createDialog创建对话框的需要从一组卡牌中选择所有某种颜色/花色的牌的技能，用法可参考手杀曹髦/手杀陆郁生
 * @param {Card[]} cards 要分组的卡牌
 * @param {'suit'|'color'} type 分组类型 目前仅支持'suit'/'color'
 * @param {false | Player} player get.suit/get.color的player参数
 * @returns {Array<Row_Item_Option | Row_Item_Option[]>} 返回一个列表，每一项是一个分组配置（addNewRow方法的参数RowItem）或一对分组配置组成的数组
 */
addNewRowList(cards, type = "suit", player = false)
```

### game.findSkill

获取触发某个事件的skill

```javascript
/**
 * find the skillname of the event
 * 获取触发事件的技能
 * @param { GameEvent } event
 * @param { Boolean } includeCharlotteSkill 是否包含夏洛特技
 * @param { Boolean } includeEquipSkill 是否包含装备技能
 * @param { Boolean } includeGlobalSkill 是否包含全局技能
 * @returns { string | null }
 */
findSkill(event, includeCharlotteSkill = false, includeEquipSkill = false, includeGlobalSkill = false)
```

### game.showChangeLog/showExtensionChangeLog更改

支持多个扩展添加角色/卡牌/文本的更新说明

```javascript
//字符串形式，也是原本支持的形式
game.showExtensionChangeLog("本次更新说明", "扩展名");
```

```javascript
//数组对象，推荐用法
game.showExtensionChangeLog([
 { type: "text", data: "本次更新说明" },
 {
  type: "players",
  data: ["wechat_zhaoyun"],
 },
 {
  type: "cards",
  data: ["nanman"],
 },
],'扩展名');
```

```javascript
//对象形式
game.showExtensionChangeLog({ type: "text", data: "本次更新说明" }, "扩展名");
```

## 调整与bugfix

> **注：** 仅列出功能调整，武将调整不一一列举

- 修改鏖战杀闪、鏖战桃的逻辑(#2920)
- 为单个card实例添加destroyLog的检查，修复转化的延时锦囊牌离开判定区时错误的log(#2921)
- 为国战添加国战无双的神势力规则，修正国战亮将的时机(#2922)
- 跳过本回合指定阶段的写法调整（OL谋鲁肃）(#2923)
- 调整转化/虚拟装备/延时锦囊牌的显示(#2923)
- 令失效技能依然提供蓄力点上限(#2923)
- 修复elementGoto在overflow被限制的状态下游戏出现缩放导致动画不显示的bug(#2924)
- 修复chooseToMove在手机上的选择不同步问题(#2924)
- 修复重启时背景图片重复问题，增加高度，不等待layout.css的加载(#2926)
- 增加新地主技能：恃强和削弱版强易(#2930)
- 导入背景时候可以选择多张背景一起导入(#2932)
- 无限火力添加自由选将功能(#2934)
- 修复联机模式下国战无法创建房间(#2939)
- 将chooseToCompareMultiple/Meanwhile/Effect函数改为数组(#2949)
- 修复同名替换同时存在单/多势力武将的势力显示问题(#2952)
- 为canAddJudge添加第二个参数player，用于判断能否对对方使用延时锦囊牌(#2954)
- 给技能创建默认skill_id属性，可以在技能的非执行非箭头函数中使用this.skill_id获取技能ID(#2955)
- 为斗地主专属地主技增加charlotte标签(#2962)
- 修改info.ai.combo支持传入数组(#2962)
- 调整宗族技卡牌的显示策略，以当前玩家为准(#2965)
- 将Player.storage.counttrigger迁移入Player.getStat().triggerSkill(#2971)
- 修复在`chooseToUse`和`chooseToRespond`里面的`pre_skill`事件的`logSkill`层级寻找问题(#2971)
- 修改`get.skillCount`逻辑为同时获得一个有`usable`技能的`enable`和`trigger`两类发动次数之和(#2971)
- 调整`changeZhuanhuanji`时机逻辑同`logSkill`逻辑（修复谋许攸二技能摸牌时机问题），增加`changeZhuanhuanjiBegin`代替原`changeZhuanhuanji`瞬时时机(#2971)
- 将canAddJudge中使用牌相关逻辑移动至lib.filter.judge(#2974)
- lib.element.content.chooseToCompare支持牌堆拼点并支持可选择牌堆底的牌，用法可参考幻曹昂【複舒】(#2980)
- 修复Player.addAddtionalSkills联机客机获得技能不显示的bug(#2987)
- 添加斗地主农民死亡后另一名农民获得的遗产开关(#2995)
- 为get.skillInfoTranslation默认处理一遍get.plainText，添加第三个参数noHTML用于控制(#3004)
- 为autoswap补充时机(#3004)
- 修改ui.create.buttonPresets.card方法复制原牌标记信息(#3005)
- 修复lib.element.content.chooseToCompare中result.winner赋值错误、lib.element.content.chooseToCompareMultiple中拼点动画错误的bug(#3005)
- 增强card/button/target/confirm/window的_status.event.custom.add/replace的函数判断(#3005)
- lib.element.player.chooseButton支持唯一参数(#3005)
- 修改lib.element.dialog.add支持对话框使用addNewRow方法和特定条件下的递归、修改lib.element.dialog.addNewRow支持使用get.prompt2的情况、调整lib.element.content.chooseButton/chooseButtonTarget支持使用对对话框应用css样式(#3005)
- 补充chooseToMove、chooseToMove_new的_args，保证联机同步(#3007)
- 修改card#$init和ui.create.cardTempName中对image参数的处理，可自由指定读取的路径(#3010)
- 为when创造临时技能添加skill返回值(#3012)
- Player.hasVCard的countCards改为countVCards(#3016)
- 为拼点增加展示牌的时机以符合实际结算(#3019)
- 修复$elementGoto对于未改变位置的动画会返回永久pending的Promise问题(#3027)
- 为chooseToMove与chooseToMove_new添加动画配置开关，并适当缩减chooseToMove的动画长度(#3027)
- 调整君主武将与国战神将等新机制间的结算(#3028)
- 调整君主武将的珠联璧合结算为仅限同势力武将(#3028)
- 国战模式下可猜测势力添加野心家(#3028)
- 添加武将称号(#3032)
- 将player.getStat().card[name]相关的技能进行数值判断再执行减值操作(#3036)
- window.onerror支持获取外置sourcemap映射结果(#3047)
- 调整武将资料页；阵亡效果默认关闭(#3048)
- 取消废弃chooseToGuanxing，增加forceDie和includeOut参数适配(#3052)
- 为转化延时锦囊牌增加`VCard.storage.equipEnable`属性，表该转化延时锦囊牌的实体牌中的装备牌仍然生效，修改了下述函数以适配：`Player#addVirtualJudge`、`Player#removeVirtualJudge`、`Get#nodeintro`；增加了一个新技能equipEnableSkill用以实现该类装备牌的牌面效果(#3052)
- 添加get.bingzhu获取装备牌兵主，lib.bingzhu为扩展开放添加兵主(#3054)
- 调整restoreSkill为没有技能时不进行markSkill(#3061)
- 为tip开关添加介绍(#3061)
- 调整国战“武将易位”的结算(#3061)
- 修复removeVirtualJudge不移除被转化装备牌技能的问题(#3076)
- 简介页面添加武将称号(#3080)
- 简介页面的技能台词移入对应技能页面下(#3080)
- 添加武将和技能引文(#3080)
- 将武将其他原画直接显示在简介底部左对齐(#3089)
- 调整finishSkill对sourceSkill的添加逻辑(#3092)
- 修正get.cardPile对随机获得的判断(#3092)
- 调整技能前缀对重复技能的判断，考虑sourceSkill(#3097)
- 修改`addVirtualJudge`、`removeVirtualJudge`内装备区失去牌后的结算(#3105)
- 切换身份时清除已选中的武将，避免其他武将无法点击(#3108)
- 修复lib.element.content.phaseJudge(#3114)
- 修复休整角色会被计入座次的问题(#3115)
- 为when的assign添加广播，允许when使用mod和ai(#3115)
- 暂时废弃`window.initReadWriteFunction`(#3117)
- 调整lib.filter.canBeDiscarded的判断，弃置自己时会判断lib.filter.cardDiscardable(#3119)
- 为addTempSkill适配共联时机(#3119)
- 修复addJudgeCard未判断canAddJudge导致重复置入延时锦囊的bug(#3119)
- 长按武将介绍添加查看资料功能(#3119)
- 武将介绍显示武将所在分包（需自行启用）(#3119)
- 调整lib.element.content.useCard/respond对addSkillCount属性的判断(#3125)
- 调整changeGroup和addGroup(#3130)
- poptip支持自定义显示框（使用例：【凶疑】【许身】【协战】）(#3130)
- 调整lib.element.player.hasUsableCard逻辑(#3135)
- ui.click.skill对prompt为函数时增加一个player的参数(#3135)
- 调整lib.element.content.useCard中播放语音/动画/存放历史记录与玩家使用实体牌的先后顺序(#3135)
- lib.element.player.$addToExpansion添加第四个参数支持仅刷新武将牌上的牌(#3138)
- index.html内的导入移入boot过程(#3149)
- 修复国战休整导致的ai混乱(#3152)
- 为canMoveCard补全aimTargets的判断(#3152)
- 修复亮出牌的报错以及loseAsync不能正常销毁牌的bug(#3153)
- 无限体力的角色获取已损失体力值始终为0
- 适配装备牌自定义装备技能

## 扩展适配

### 当前版本适配

- 直接导入game文件夹下`codemirror`、`compiler-sfc.esm-browser`、`eslint-linter-browserify`、`jszip`、`typescript`完整包以及直接引用`node_modules`目录下模块的扩展需要适配(工程化)
- 修改了选按钮、选牌系列方法(包括但不限于`chooseButton`、`chooseCard`、`chooseToDiscard`、`chooseToUse`、`chooseToRespond`、`chooseButtonTarget`、`chooseCardTarget`)的扩展需要跟进(#2912)
- 修改了鏖战判定和效果技能的扩展需要跟进(#2920)
- 修改了角色初始化逻辑(`lib.element.player.init/uninit`)/`game.check`/`lib.element.player.changeZhuanhuanji`的扩展需要跟进(#2971)
- `ui.create.cardChooseAll`和`ui.create.buttonChooseAll`不再支持传入函数(#2980)
- 修改了`chooseToCompare`的扩展需要跟进(#2980)
- 自带武将称号的美化扩展需要跟进(#3032)
- 修改了仁库相关机制的扩展需要跟进(#3036)
- 修改了牌移动相关机制(包括但不限于`lose`、`gain`、`addToExpansion`、`cardsGoToSpecial`、`cardsGoToPile`、`useCard`、`equip`)的扩展需要跟进(#3036)
- 修改了`get.nodeIntro`的扩展需要跟进(#3052)
- 修改了`chooseToGuanxing`的扩展需要跟进(#3052)
- 修改了`chooseToDebate`的扩展需要跟进(#3071)
- 修改了`ui.click.charactercard`的扩展需要跟进(#3071)
- 修改了`lib.element.content.equip`的扩展需要跟进(#3097)
- 修改了`addVirtualJudge`、`removeVirtualJudge`的扩展需要跟进(#3105)
- 使用了`window.initReadWriteFunction`的启动器需要跟进(#3117)
- 修改了`ui.click.skill`的扩展需要跟进(#3135)

### 未来版本适配

- 使用`import xxx from "../../noname.js"`相对路径导入的扩展建议改为`import xxx from "noname"`(工程化)
- 不建议使用`noname/`文件夹下没有经过`noname.js`导出的内容，这些内容随时可能更改(工程化)
- 导入`game/dedent.js`、`game/vue.esm-browser.js`以及`noname/get/pinyins/index.js`的扩展建议改为`import xxx from "dedent"`、`import xxx from "vue"`和`import xxx from "pinyin-pro"`(工程化)
- 使用`game/game.js`作为入口的启动器建议改为使用`index.html`启动，无需额外检测`game/config.js`等其他配置文件(工程化)
- 使用了`Player.storage.counttrigger`的扩展建议改为`Player.getStat().triggerSkill`(#2971)
- 使用了`game.addPlayer/removePlayer`建议跟进`game.addPlayerOL/removePlayerOL`(#3005)
- 需要卡牌公共区域的扩展可以使用`lib.commonArea`(#3036)
- 需要显示更新信息的扩展可以跟进`game.showExtensionChangeLog`(#3056)
- 需要获取角色名翻译的扩展可以跟进`player.getName`(#3071)
- 多名角色选择牌需要显示对应角色拿了什么牌而使用直接读取节点然后赋值innerHTML的方法可以参考【五谷丰登】(#3071)
- 有置入任意装备栏的卡牌的扩展建议跟进`prepareEquip`(#3097)
- 改判类技能建议跟进(#3124)

  ```javascript
  //即使用打出牌事件的实体牌进行改判操作，如代替判定牌/替换判定牌
  //lib.skill.reguicai.content
  const { cards } = await player.respond(event.cards, event.name, "highlight", "noOrdering");
  if (cards?.length) {
    if (trigger.player.judging[0].clone) {
      trigger.player.judging[0].clone.classList.remove("thrownhighlight");
      game.broadcast(function (card) {
        if (card.clone) {
          card.clone.classList.remove("thrownhighlight");
        }
      }, trigger.player.judging[0]);
      game.addVideo("deletenode", player, get.cardsInfo([trigger.player.judging[0].clone]));
    }
    await game.cardsDiscard(trigger.player.judging[0]);
    trigger.player.judging[0] = cards[0];
    trigger.orderingCards.addArray(cards);
    game.log(trigger.player, "的判定牌改为", cards);
    await game.delay(2);
  }
  ```
