import require$$0$3 from "../../../../../_virtual/__vite-browser-external.js";
if (!global) {
  var global = globalThis || window;
}
function getDefaultExportFromNamespaceIfPresent(n2) {
  return n2 && Object.prototype.hasOwnProperty.call(n2, "default") ? n2["default"] : n2;
}
var eslintLinterBrowserify = {};
var global$1 = typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {};
function defaultSetTimout() {
  throw new Error("setTimeout has not been defined");
}
function defaultClearTimeout() {
  throw new Error("clearTimeout has not been defined");
}
var cachedSetTimeout = defaultSetTimout;
var cachedClearTimeout = defaultClearTimeout;
if (typeof global$1.setTimeout === "function") {
  cachedSetTimeout = setTimeout;
}
if (typeof global$1.clearTimeout === "function") {
  cachedClearTimeout = clearTimeout;
}
function runTimeout(fun) {
  if (cachedSetTimeout === setTimeout) {
    return setTimeout(fun, 0);
  }
  if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
    cachedSetTimeout = setTimeout;
    return setTimeout(fun, 0);
  }
  try {
    return cachedSetTimeout(fun, 0);
  } catch (e2) {
    try {
      return cachedSetTimeout.call(null, fun, 0);
    } catch (e3) {
      return cachedSetTimeout.call(this, fun, 0);
    }
  }
}
function runClearTimeout(marker) {
  if (cachedClearTimeout === clearTimeout) {
    return clearTimeout(marker);
  }
  if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
    cachedClearTimeout = clearTimeout;
    return clearTimeout(marker);
  }
  try {
    return cachedClearTimeout(marker);
  } catch (e2) {
    try {
      return cachedClearTimeout.call(null, marker);
    } catch (e3) {
      return cachedClearTimeout.call(this, marker);
    }
  }
}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;
function cleanUpNextTick() {
  if (!draining || !currentQueue) {
    return;
  }
  draining = false;
  if (currentQueue.length) {
    queue = currentQueue.concat(queue);
  } else {
    queueIndex = -1;
  }
  if (queue.length) {
    drainQueue();
  }
}
function drainQueue() {
  if (draining) {
    return;
  }
  var timeout = runTimeout(cleanUpNextTick);
  draining = true;
  var len = queue.length;
  while (len) {
    currentQueue = queue;
    queue = [];
    while (++queueIndex < len) {
      if (currentQueue) {
        currentQueue[queueIndex].run();
      }
    }
    queueIndex = -1;
    len = queue.length;
  }
  currentQueue = null;
  draining = false;
  runClearTimeout(timeout);
}
function nextTick(fun) {
  var args = new Array(arguments.length - 1);
  if (arguments.length > 1) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      args[i2 - 1] = arguments[i2];
    }
  }
  queue.push(new Item(fun, args));
  if (queue.length === 1 && !draining) {
    runTimeout(drainQueue);
  }
}
function Item(fun, array) {
  this.fun = fun;
  this.array = array;
}
Item.prototype.run = function() {
  this.fun.apply(null, this.array);
};
var title$1 = "browser";
var platform = "browser";
var browser$2 = true;
var env = {};
var argv = [];
var version$2 = "";
var versions = {};
var release = {};
var config$1 = {};
function noop() {
}
var on = noop;
var addListener = noop;
var once = noop;
var off = noop;
var removeListener = noop;
var removeAllListeners = noop;
var emit = noop;
function binding(name) {
  throw new Error("process.binding is not supported");
}
function cwd() {
  return "/";
}
function chdir(dir) {
  throw new Error("process.chdir is not supported");
}
function umask() {
  return 0;
}
var performance = global$1.performance || {};
var performanceNow = performance.now || performance.mozNow || performance.msNow || performance.oNow || performance.webkitNow || function() {
  return (/* @__PURE__ */ new Date()).getTime();
};
function hrtime(previousTimestamp) {
  var clocktime = performanceNow.call(performance) * 1e-3;
  var seconds = Math.floor(clocktime);
  var nanoseconds = Math.floor(clocktime % 1 * 1e9);
  if (previousTimestamp) {
    seconds = seconds - previousTimestamp[0];
    nanoseconds = nanoseconds - previousTimestamp[1];
    if (nanoseconds < 0) {
      seconds--;
      nanoseconds += 1e9;
    }
  }
  return [seconds, nanoseconds];
}
var startTime = /* @__PURE__ */ new Date();
function uptime() {
  var currentTime = /* @__PURE__ */ new Date();
  var dif = currentTime - startTime;
  return dif / 1e3;
}
var browser$1$1 = {
  nextTick,
  title: title$1,
  browser: browser$2,
  env,
  argv,
  version: version$2,
  versions,
  on,
  addListener,
  once,
  off,
  removeListener,
  removeAllListeners,
  emit,
  binding,
  cwd,
  chdir,
  umask,
  hrtime,
  platform,
  release,
  config: config$1,
  uptime
};
var eslintScope = {};
var estraverse = {};
var hasRequiredEstraverse;
function requireEstraverse() {
  if (hasRequiredEstraverse) return estraverse;
  hasRequiredEstraverse = 1;
  (function(exports$1) {
    (function clone(exports2) {
      var Syntax, VisitorOption, VisitorKeys, BREAK, SKIP, REMOVE;
      function deepCopy(obj) {
        var ret = {}, key, val;
        for (key in obj) {
          if (obj.hasOwnProperty(key)) {
            val = obj[key];
            if (typeof val === "object" && val !== null) {
              ret[key] = deepCopy(val);
            } else {
              ret[key] = val;
            }
          }
        }
        return ret;
      }
      function upperBound(array, func) {
        var diff, len, i2, current;
        len = array.length;
        i2 = 0;
        while (len) {
          diff = len >>> 1;
          current = i2 + diff;
          if (func(array[current])) {
            len = diff;
          } else {
            i2 = current + 1;
            len -= diff + 1;
          }
        }
        return i2;
      }
      Syntax = {
        AssignmentExpression: "AssignmentExpression",
        AssignmentPattern: "AssignmentPattern",
        ArrayExpression: "ArrayExpression",
        ArrayPattern: "ArrayPattern",
        ArrowFunctionExpression: "ArrowFunctionExpression",
        AwaitExpression: "AwaitExpression",
        // CAUTION: It's deferred to ES7.
        BlockStatement: "BlockStatement",
        BinaryExpression: "BinaryExpression",
        BreakStatement: "BreakStatement",
        CallExpression: "CallExpression",
        CatchClause: "CatchClause",
        ChainExpression: "ChainExpression",
        ClassBody: "ClassBody",
        ClassDeclaration: "ClassDeclaration",
        ClassExpression: "ClassExpression",
        ComprehensionBlock: "ComprehensionBlock",
        // CAUTION: It's deferred to ES7.
        ComprehensionExpression: "ComprehensionExpression",
        // CAUTION: It's deferred to ES7.
        ConditionalExpression: "ConditionalExpression",
        ContinueStatement: "ContinueStatement",
        DebuggerStatement: "DebuggerStatement",
        DirectiveStatement: "DirectiveStatement",
        DoWhileStatement: "DoWhileStatement",
        EmptyStatement: "EmptyStatement",
        ExportAllDeclaration: "ExportAllDeclaration",
        ExportDefaultDeclaration: "ExportDefaultDeclaration",
        ExportNamedDeclaration: "ExportNamedDeclaration",
        ExportSpecifier: "ExportSpecifier",
        ExpressionStatement: "ExpressionStatement",
        ForStatement: "ForStatement",
        ForInStatement: "ForInStatement",
        ForOfStatement: "ForOfStatement",
        FunctionDeclaration: "FunctionDeclaration",
        FunctionExpression: "FunctionExpression",
        GeneratorExpression: "GeneratorExpression",
        // CAUTION: It's deferred to ES7.
        Identifier: "Identifier",
        IfStatement: "IfStatement",
        ImportExpression: "ImportExpression",
        ImportDeclaration: "ImportDeclaration",
        ImportDefaultSpecifier: "ImportDefaultSpecifier",
        ImportNamespaceSpecifier: "ImportNamespaceSpecifier",
        ImportSpecifier: "ImportSpecifier",
        Literal: "Literal",
        LabeledStatement: "LabeledStatement",
        LogicalExpression: "LogicalExpression",
        MemberExpression: "MemberExpression",
        MetaProperty: "MetaProperty",
        MethodDefinition: "MethodDefinition",
        ModuleSpecifier: "ModuleSpecifier",
        NewExpression: "NewExpression",
        ObjectExpression: "ObjectExpression",
        ObjectPattern: "ObjectPattern",
        PrivateIdentifier: "PrivateIdentifier",
        Program: "Program",
        Property: "Property",
        PropertyDefinition: "PropertyDefinition",
        RestElement: "RestElement",
        ReturnStatement: "ReturnStatement",
        SequenceExpression: "SequenceExpression",
        SpreadElement: "SpreadElement",
        Super: "Super",
        SwitchStatement: "SwitchStatement",
        SwitchCase: "SwitchCase",
        TaggedTemplateExpression: "TaggedTemplateExpression",
        TemplateElement: "TemplateElement",
        TemplateLiteral: "TemplateLiteral",
        ThisExpression: "ThisExpression",
        ThrowStatement: "ThrowStatement",
        TryStatement: "TryStatement",
        UnaryExpression: "UnaryExpression",
        UpdateExpression: "UpdateExpression",
        VariableDeclaration: "VariableDeclaration",
        VariableDeclarator: "VariableDeclarator",
        WhileStatement: "WhileStatement",
        WithStatement: "WithStatement",
        YieldExpression: "YieldExpression"
      };
      VisitorKeys = {
        AssignmentExpression: ["left", "right"],
        AssignmentPattern: ["left", "right"],
        ArrayExpression: ["elements"],
        ArrayPattern: ["elements"],
        ArrowFunctionExpression: ["params", "body"],
        AwaitExpression: ["argument"],
        // CAUTION: It's deferred to ES7.
        BlockStatement: ["body"],
        BinaryExpression: ["left", "right"],
        BreakStatement: ["label"],
        CallExpression: ["callee", "arguments"],
        CatchClause: ["param", "body"],
        ChainExpression: ["expression"],
        ClassBody: ["body"],
        ClassDeclaration: ["id", "superClass", "body"],
        ClassExpression: ["id", "superClass", "body"],
        ComprehensionBlock: ["left", "right"],
        // CAUTION: It's deferred to ES7.
        ComprehensionExpression: ["blocks", "filter", "body"],
        // CAUTION: It's deferred to ES7.
        ConditionalExpression: ["test", "consequent", "alternate"],
        ContinueStatement: ["label"],
        DebuggerStatement: [],
        DirectiveStatement: [],
        DoWhileStatement: ["body", "test"],
        EmptyStatement: [],
        ExportAllDeclaration: ["source"],
        ExportDefaultDeclaration: ["declaration"],
        ExportNamedDeclaration: ["declaration", "specifiers", "source"],
        ExportSpecifier: ["exported", "local"],
        ExpressionStatement: ["expression"],
        ForStatement: ["init", "test", "update", "body"],
        ForInStatement: ["left", "right", "body"],
        ForOfStatement: ["left", "right", "body"],
        FunctionDeclaration: ["id", "params", "body"],
        FunctionExpression: ["id", "params", "body"],
        GeneratorExpression: ["blocks", "filter", "body"],
        // CAUTION: It's deferred to ES7.
        Identifier: [],
        IfStatement: ["test", "consequent", "alternate"],
        ImportExpression: ["source"],
        ImportDeclaration: ["specifiers", "source"],
        ImportDefaultSpecifier: ["local"],
        ImportNamespaceSpecifier: ["local"],
        ImportSpecifier: ["imported", "local"],
        Literal: [],
        LabeledStatement: ["label", "body"],
        LogicalExpression: ["left", "right"],
        MemberExpression: ["object", "property"],
        MetaProperty: ["meta", "property"],
        MethodDefinition: ["key", "value"],
        ModuleSpecifier: [],
        NewExpression: ["callee", "arguments"],
        ObjectExpression: ["properties"],
        ObjectPattern: ["properties"],
        PrivateIdentifier: [],
        Program: ["body"],
        Property: ["key", "value"],
        PropertyDefinition: ["key", "value"],
        RestElement: ["argument"],
        ReturnStatement: ["argument"],
        SequenceExpression: ["expressions"],
        SpreadElement: ["argument"],
        Super: [],
        SwitchStatement: ["discriminant", "cases"],
        SwitchCase: ["test", "consequent"],
        TaggedTemplateExpression: ["tag", "quasi"],
        TemplateElement: [],
        TemplateLiteral: ["quasis", "expressions"],
        ThisExpression: [],
        ThrowStatement: ["argument"],
        TryStatement: ["block", "handler", "finalizer"],
        UnaryExpression: ["argument"],
        UpdateExpression: ["argument"],
        VariableDeclaration: ["declarations"],
        VariableDeclarator: ["id", "init"],
        WhileStatement: ["test", "body"],
        WithStatement: ["object", "body"],
        YieldExpression: ["argument"]
      };
      BREAK = {};
      SKIP = {};
      REMOVE = {};
      VisitorOption = {
        Break: BREAK,
        Skip: SKIP,
        Remove: REMOVE
      };
      function Reference(parent, key) {
        this.parent = parent;
        this.key = key;
      }
      Reference.prototype.replace = function replace2(node2) {
        this.parent[this.key] = node2;
      };
      Reference.prototype.remove = function remove() {
        if (Array.isArray(this.parent)) {
          this.parent.splice(this.key, 1);
          return true;
        } else {
          this.replace(null);
          return false;
        }
      };
      function Element(node2, path, wrap, ref2) {
        this.node = node2;
        this.path = path;
        this.wrap = wrap;
        this.ref = ref2;
      }
      function Controller() {
      }
      Controller.prototype.path = function path() {
        var i2, iz, j, jz, result, element;
        function addToPath(result2, path2) {
          if (Array.isArray(path2)) {
            for (j = 0, jz = path2.length; j < jz; ++j) {
              result2.push(path2[j]);
            }
          } else {
            result2.push(path2);
          }
        }
        if (!this.__current.path) {
          return null;
        }
        result = [];
        for (i2 = 2, iz = this.__leavelist.length; i2 < iz; ++i2) {
          element = this.__leavelist[i2];
          addToPath(result, element.path);
        }
        addToPath(result, this.__current.path);
        return result;
      };
      Controller.prototype.type = function() {
        var node2 = this.current();
        return node2.type || this.__current.wrap;
      };
      Controller.prototype.parents = function parents() {
        var i2, iz, result;
        result = [];
        for (i2 = 1, iz = this.__leavelist.length; i2 < iz; ++i2) {
          result.push(this.__leavelist[i2].node);
        }
        return result;
      };
      Controller.prototype.current = function current() {
        return this.__current.node;
      };
      Controller.prototype.__execute = function __execute(callback, element) {
        var previous, result;
        result = void 0;
        previous = this.__current;
        this.__current = element;
        this.__state = null;
        if (callback) {
          result = callback.call(this, element.node, this.__leavelist[this.__leavelist.length - 1].node);
        }
        this.__current = previous;
        return result;
      };
      Controller.prototype.notify = function notify(flag) {
        this.__state = flag;
      };
      Controller.prototype.skip = function() {
        this.notify(SKIP);
      };
      Controller.prototype["break"] = function() {
        this.notify(BREAK);
      };
      Controller.prototype.remove = function() {
        this.notify(REMOVE);
      };
      Controller.prototype.__initialize = function(root, visitor) {
        this.visitor = visitor;
        this.root = root;
        this.__worklist = [];
        this.__leavelist = [];
        this.__current = null;
        this.__state = null;
        this.__fallback = null;
        if (visitor.fallback === "iteration") {
          this.__fallback = Object.keys;
        } else if (typeof visitor.fallback === "function") {
          this.__fallback = visitor.fallback;
        }
        this.__keys = VisitorKeys;
        if (visitor.keys) {
          this.__keys = Object.assign(Object.create(this.__keys), visitor.keys);
        }
      };
      function isNode(node2) {
        if (node2 == null) {
          return false;
        }
        return typeof node2 === "object" && typeof node2.type === "string";
      }
      function isProperty(nodeType, key) {
        return (nodeType === Syntax.ObjectExpression || nodeType === Syntax.ObjectPattern) && "properties" === key;
      }
      function candidateExistsInLeaveList(leavelist, candidate) {
        for (var i2 = leavelist.length - 1; i2 >= 0; --i2) {
          if (leavelist[i2].node === candidate) {
            return true;
          }
        }
        return false;
      }
      Controller.prototype.traverse = function traverse2(root, visitor) {
        var worklist, leavelist, element, node2, nodeType, ret, key, current, current2, candidates, candidate, sentinel;
        this.__initialize(root, visitor);
        sentinel = {};
        worklist = this.__worklist;
        leavelist = this.__leavelist;
        worklist.push(new Element(root, null, null, null));
        leavelist.push(new Element(null, null, null, null));
        while (worklist.length) {
          element = worklist.pop();
          if (element === sentinel) {
            element = leavelist.pop();
            ret = this.__execute(visitor.leave, element);
            if (this.__state === BREAK || ret === BREAK) {
              return;
            }
            continue;
          }
          if (element.node) {
            ret = this.__execute(visitor.enter, element);
            if (this.__state === BREAK || ret === BREAK) {
              return;
            }
            worklist.push(sentinel);
            leavelist.push(element);
            if (this.__state === SKIP || ret === SKIP) {
              continue;
            }
            node2 = element.node;
            nodeType = node2.type || element.wrap;
            candidates = this.__keys[nodeType];
            if (!candidates) {
              if (this.__fallback) {
                candidates = this.__fallback(node2);
              } else {
                throw new Error("Unknown node type " + nodeType + ".");
              }
            }
            current = candidates.length;
            while ((current -= 1) >= 0) {
              key = candidates[current];
              candidate = node2[key];
              if (!candidate) {
                continue;
              }
              if (Array.isArray(candidate)) {
                current2 = candidate.length;
                while ((current2 -= 1) >= 0) {
                  if (!candidate[current2]) {
                    continue;
                  }
                  if (candidateExistsInLeaveList(leavelist, candidate[current2])) {
                    continue;
                  }
                  if (isProperty(nodeType, candidates[current])) {
                    element = new Element(candidate[current2], [key, current2], "Property", null);
                  } else if (isNode(candidate[current2])) {
                    element = new Element(candidate[current2], [key, current2], null, null);
                  } else {
                    continue;
                  }
                  worklist.push(element);
                }
              } else if (isNode(candidate)) {
                if (candidateExistsInLeaveList(leavelist, candidate)) {
                  continue;
                }
                worklist.push(new Element(candidate, key, null, null));
              }
            }
          }
        }
      };
      Controller.prototype.replace = function replace2(root, visitor) {
        var worklist, leavelist, node2, nodeType, target, element, current, current2, candidates, candidate, sentinel, outer, key;
        function removeElem(element2) {
          var i2, key2, nextElem, parent;
          if (element2.ref.remove()) {
            key2 = element2.ref.key;
            parent = element2.ref.parent;
            i2 = worklist.length;
            while (i2--) {
              nextElem = worklist[i2];
              if (nextElem.ref && nextElem.ref.parent === parent) {
                if (nextElem.ref.key < key2) {
                  break;
                }
                --nextElem.ref.key;
              }
            }
          }
        }
        this.__initialize(root, visitor);
        sentinel = {};
        worklist = this.__worklist;
        leavelist = this.__leavelist;
        outer = {
          root
        };
        element = new Element(root, null, null, new Reference(outer, "root"));
        worklist.push(element);
        leavelist.push(element);
        while (worklist.length) {
          element = worklist.pop();
          if (element === sentinel) {
            element = leavelist.pop();
            target = this.__execute(visitor.leave, element);
            if (target !== void 0 && target !== BREAK && target !== SKIP && target !== REMOVE) {
              element.ref.replace(target);
            }
            if (this.__state === REMOVE || target === REMOVE) {
              removeElem(element);
            }
            if (this.__state === BREAK || target === BREAK) {
              return outer.root;
            }
            continue;
          }
          target = this.__execute(visitor.enter, element);
          if (target !== void 0 && target !== BREAK && target !== SKIP && target !== REMOVE) {
            element.ref.replace(target);
            element.node = target;
          }
          if (this.__state === REMOVE || target === REMOVE) {
            removeElem(element);
            element.node = null;
          }
          if (this.__state === BREAK || target === BREAK) {
            return outer.root;
          }
          node2 = element.node;
          if (!node2) {
            continue;
          }
          worklist.push(sentinel);
          leavelist.push(element);
          if (this.__state === SKIP || target === SKIP) {
            continue;
          }
          nodeType = node2.type || element.wrap;
          candidates = this.__keys[nodeType];
          if (!candidates) {
            if (this.__fallback) {
              candidates = this.__fallback(node2);
            } else {
              throw new Error("Unknown node type " + nodeType + ".");
            }
          }
          current = candidates.length;
          while ((current -= 1) >= 0) {
            key = candidates[current];
            candidate = node2[key];
            if (!candidate) {
              continue;
            }
            if (Array.isArray(candidate)) {
              current2 = candidate.length;
              while ((current2 -= 1) >= 0) {
                if (!candidate[current2]) {
                  continue;
                }
                if (isProperty(nodeType, candidates[current])) {
                  element = new Element(candidate[current2], [key, current2], "Property", new Reference(candidate, current2));
                } else if (isNode(candidate[current2])) {
                  element = new Element(candidate[current2], [key, current2], null, new Reference(candidate, current2));
                } else {
                  continue;
                }
                worklist.push(element);
              }
            } else if (isNode(candidate)) {
              worklist.push(new Element(candidate, key, null, new Reference(node2, key)));
            }
          }
        }
        return outer.root;
      };
      function traverse(root, visitor) {
        var controller = new Controller();
        return controller.traverse(root, visitor);
      }
      function replace(root, visitor) {
        var controller = new Controller();
        return controller.replace(root, visitor);
      }
      function extendCommentRange(comment2, tokens) {
        var target;
        target = upperBound(tokens, function search(token) {
          return token.range[0] > comment2.range[0];
        });
        comment2.extendedRange = [comment2.range[0], comment2.range[1]];
        if (target !== tokens.length) {
          comment2.extendedRange[1] = tokens[target].range[0];
        }
        target -= 1;
        if (target >= 0) {
          comment2.extendedRange[0] = tokens[target].range[1];
        }
        return comment2;
      }
      function attachComments(tree, providedComments, tokens) {
        var comments = [], comment2, len, i2, cursor2;
        if (!tree.range) {
          throw new Error("attachComments needs range information");
        }
        if (!tokens.length) {
          if (providedComments.length) {
            for (i2 = 0, len = providedComments.length; i2 < len; i2 += 1) {
              comment2 = deepCopy(providedComments[i2]);
              comment2.extendedRange = [0, tree.range[0]];
              comments.push(comment2);
            }
            tree.leadingComments = comments;
          }
          return tree;
        }
        for (i2 = 0, len = providedComments.length; i2 < len; i2 += 1) {
          comments.push(extendCommentRange(deepCopy(providedComments[i2]), tokens));
        }
        cursor2 = 0;
        traverse(tree, {
          enter: function(node2) {
            var comment3;
            while (cursor2 < comments.length) {
              comment3 = comments[cursor2];
              if (comment3.extendedRange[1] > node2.range[0]) {
                break;
              }
              if (comment3.extendedRange[1] === node2.range[0]) {
                if (!node2.leadingComments) {
                  node2.leadingComments = [];
                }
                node2.leadingComments.push(comment3);
                comments.splice(cursor2, 1);
              } else {
                cursor2 += 1;
              }
            }
            if (cursor2 === comments.length) {
              return VisitorOption.Break;
            }
            if (comments[cursor2].extendedRange[0] > node2.range[1]) {
              return VisitorOption.Skip;
            }
          }
        });
        cursor2 = 0;
        traverse(tree, {
          leave: function(node2) {
            var comment3;
            while (cursor2 < comments.length) {
              comment3 = comments[cursor2];
              if (node2.range[1] < comment3.extendedRange[0]) {
                break;
              }
              if (node2.range[1] === comment3.extendedRange[0]) {
                if (!node2.trailingComments) {
                  node2.trailingComments = [];
                }
                node2.trailingComments.push(comment3);
                comments.splice(cursor2, 1);
              } else {
                cursor2 += 1;
              }
            }
            if (cursor2 === comments.length) {
              return VisitorOption.Break;
            }
            if (comments[cursor2].extendedRange[0] > node2.range[1]) {
              return VisitorOption.Skip;
            }
          }
        });
        return tree;
      }
      exports2.Syntax = Syntax;
      exports2.traverse = traverse;
      exports2.replace = replace;
      exports2.attachComments = attachComments;
      exports2.VisitorKeys = VisitorKeys;
      exports2.VisitorOption = VisitorOption;
      exports2.Controller = Controller;
      exports2.cloneEnvironment = function() {
        return clone({});
      };
      return exports2;
    })(exports$1);
  })(estraverse);
  return estraverse;
}
var esrecurse = {};
var version$1 = "4.3.0";
var require$$1$1 = {
  version: version$1
};
var hasRequiredEsrecurse;
function requireEsrecurse() {
  if (hasRequiredEsrecurse) return esrecurse;
  hasRequiredEsrecurse = 1;
  (function() {
    var estraverse2 = requireEstraverse();
    function isNode(node2) {
      if (node2 == null) {
        return false;
      }
      return typeof node2 === "object" && typeof node2.type === "string";
    }
    function isProperty(nodeType, key) {
      return (nodeType === estraverse2.Syntax.ObjectExpression || nodeType === estraverse2.Syntax.ObjectPattern) && key === "properties";
    }
    function Visitor(visitor, options) {
      options = options || {};
      this.__visitor = visitor || this;
      this.__childVisitorKeys = options.childVisitorKeys ? Object.assign({}, estraverse2.VisitorKeys, options.childVisitorKeys) : estraverse2.VisitorKeys;
      if (options.fallback === "iteration") {
        this.__fallback = Object.keys;
      } else if (typeof options.fallback === "function") {
        this.__fallback = options.fallback;
      }
    }
    Visitor.prototype.visitChildren = function(node2) {
      var type2, children, i2, iz, j, jz, child;
      if (node2 == null) {
        return;
      }
      type2 = node2.type || estraverse2.Syntax.Property;
      children = this.__childVisitorKeys[type2];
      if (!children) {
        if (this.__fallback) {
          children = this.__fallback(node2);
        } else {
          throw new Error("Unknown node type " + type2 + ".");
        }
      }
      for (i2 = 0, iz = children.length; i2 < iz; ++i2) {
        child = node2[children[i2]];
        if (child) {
          if (Array.isArray(child)) {
            for (j = 0, jz = child.length; j < jz; ++j) {
              if (child[j]) {
                if (isNode(child[j]) || isProperty(type2, children[i2])) {
                  this.visit(child[j]);
                }
              }
            }
          } else if (isNode(child)) {
            this.visit(child);
          }
        }
      }
    };
    Visitor.prototype.visit = function(node2) {
      var type2;
      if (node2 == null) {
        return;
      }
      type2 = node2.type || estraverse2.Syntax.Property;
      if (this.__visitor[type2]) {
        this.__visitor[type2].call(this, node2);
        return;
      }
      this.visitChildren(node2);
    };
    esrecurse.version = require$$1$1.version;
    esrecurse.Visitor = Visitor;
    esrecurse.visit = function(node2, visitor, options) {
      var v2 = new Visitor(visitor, options);
      v2.visit(node2);
    };
  })();
  return esrecurse;
}
var hasRequiredEslintScope;
function requireEslintScope() {
  if (hasRequiredEslintScope) return eslintScope;
  hasRequiredEslintScope = 1;
  Object.defineProperty(eslintScope, "__esModule", { value: true });
  var estraverse2 = requireEstraverse();
  var esrecurse2 = requireEsrecurse();
  function _interopDefaultLegacy(e2) {
    return e2 && typeof e2 === "object" && "default" in e2 ? e2 : { "default": e2 };
  }
  var estraverse__default = /* @__PURE__ */ _interopDefaultLegacy(estraverse2);
  var esrecurse__default = /* @__PURE__ */ _interopDefaultLegacy(esrecurse2);
  function assert2(condition, message = "Assertion failed.") {
    if (!condition) {
      throw new Error(message);
    }
  }
  const READ = 1;
  const WRITE = 2;
  const RW = READ | WRITE;
  class Reference {
    constructor(ident, scope, flag, writeExpr, maybeImplicitGlobal, partial, init) {
      this.identifier = ident;
      this.from = scope;
      this.tainted = false;
      this.resolved = null;
      this.flag = flag;
      if (this.isWrite()) {
        this.writeExpr = writeExpr;
        this.partial = partial;
        this.init = init;
      }
      this.__maybeImplicitGlobal = maybeImplicitGlobal;
    }
    /**
     * Whether the reference is static.
     * @function Reference#isStatic
     * @returns {boolean} static
     */
    isStatic() {
      return !this.tainted && this.resolved && this.resolved.scope.isStatic();
    }
    /**
     * Whether the reference is writeable.
     * @function Reference#isWrite
     * @returns {boolean} write
     */
    isWrite() {
      return !!(this.flag & Reference.WRITE);
    }
    /**
     * Whether the reference is readable.
     * @function Reference#isRead
     * @returns {boolean} read
     */
    isRead() {
      return !!(this.flag & Reference.READ);
    }
    /**
     * Whether the reference is read-only.
     * @function Reference#isReadOnly
     * @returns {boolean} read only
     */
    isReadOnly() {
      return this.flag === Reference.READ;
    }
    /**
     * Whether the reference is write-only.
     * @function Reference#isWriteOnly
     * @returns {boolean} write only
     */
    isWriteOnly() {
      return this.flag === Reference.WRITE;
    }
    /**
     * Whether the reference is read-write.
     * @function Reference#isReadWrite
     * @returns {boolean} read write
     */
    isReadWrite() {
      return this.flag === Reference.RW;
    }
  }
  Reference.READ = READ;
  Reference.WRITE = WRITE;
  Reference.RW = RW;
  class Variable {
    constructor(name, scope) {
      this.name = name;
      this.identifiers = [];
      this.references = [];
      this.defs = [];
      this.tainted = false;
      this.stack = true;
      this.scope = scope;
    }
  }
  Variable.CatchClause = "CatchClause";
  Variable.Parameter = "Parameter";
  Variable.FunctionName = "FunctionName";
  Variable.ClassName = "ClassName";
  Variable.Variable = "Variable";
  Variable.ImportBinding = "ImportBinding";
  Variable.ImplicitGlobalVariable = "ImplicitGlobalVariable";
  class Definition {
    constructor(type2, name, node2, parent, index, kind) {
      this.type = type2;
      this.name = name;
      this.node = node2;
      this.parent = parent;
      this.index = index;
      this.kind = kind;
    }
  }
  class ParameterDefinition extends Definition {
    constructor(name, node2, index, rest) {
      super(Variable.Parameter, name, node2, null, index, null);
      this.rest = rest;
    }
  }
  const { Syntax: Syntax$2 } = estraverse__default["default"];
  function isStrictScope(scope, block, isMethodDefinition) {
    let body;
    if (scope.upper && scope.upper.isStrict) {
      return true;
    }
    if (isMethodDefinition) {
      return true;
    }
    if (scope.type === "class" || scope.type === "module") {
      return true;
    }
    if (scope.type === "block" || scope.type === "switch") {
      return false;
    }
    if (scope.type === "function") {
      if (block.type === Syntax$2.ArrowFunctionExpression && block.body.type !== Syntax$2.BlockStatement) {
        return false;
      }
      if (block.type === Syntax$2.Program) {
        body = block;
      } else {
        body = block.body;
      }
      if (!body) {
        return false;
      }
    } else if (scope.type === "global") {
      body = block;
    } else {
      return false;
    }
    for (let i2 = 0, iz = body.body.length; i2 < iz; ++i2) {
      const stmt = body.body[i2];
      if (typeof stmt.directive !== "string") {
        break;
      }
      if (stmt.directive === "use strict") {
        return true;
      }
    }
    return false;
  }
  function registerScope(scopeManager, scope) {
    scopeManager.scopes.push(scope);
    const scopes = scopeManager.__nodeToScope.get(scope.block);
    if (scopes) {
      scopes.push(scope);
    } else {
      scopeManager.__nodeToScope.set(scope.block, [scope]);
    }
  }
  function shouldBeStatically(def) {
    return def.type === Variable.ClassName || def.type === Variable.Variable && def.parent.kind !== "var";
  }
  class Scope {
    constructor(scopeManager, type2, upperScope, block, isMethodDefinition) {
      this.type = type2;
      this.set = /* @__PURE__ */ new Map();
      this.taints = /* @__PURE__ */ new Map();
      this.dynamic = this.type === "global" || this.type === "with";
      this.block = block;
      this.through = [];
      this.variables = [];
      this.references = [];
      this.variableScope = this.type === "global" || this.type === "module" || this.type === "function" || this.type === "class-field-initializer" || this.type === "class-static-block" ? this : upperScope.variableScope;
      this.functionExpressionScope = false;
      this.directCallToEvalScope = false;
      this.thisFound = false;
      this.__left = [];
      this.upper = upperScope;
      this.isStrict = scopeManager.isStrictModeSupported() ? isStrictScope(this, block, isMethodDefinition) : false;
      this.childScopes = [];
      if (this.upper) {
        this.upper.childScopes.push(this);
      }
      this.__declaredVariables = scopeManager.__declaredVariables;
      registerScope(scopeManager, this);
    }
    __shouldStaticallyClose(scopeManager) {
      return !this.dynamic || scopeManager.__isOptimistic();
    }
    __shouldStaticallyCloseForGlobal(ref2) {
      const name = ref2.identifier.name;
      if (!this.set.has(name)) {
        return false;
      }
      const variable = this.set.get(name);
      const defs = variable.defs;
      return defs.length > 0 && defs.every(shouldBeStatically);
    }
    __staticCloseRef(ref2) {
      if (!this.__resolve(ref2)) {
        this.__delegateToUpperScope(ref2);
      }
    }
    __dynamicCloseRef(ref2) {
      let current = this;
      do {
        current.through.push(ref2);
        current = current.upper;
      } while (current);
    }
    __globalCloseRef(ref2) {
      if (this.__shouldStaticallyCloseForGlobal(ref2)) {
        this.__staticCloseRef(ref2);
      } else {
        this.__dynamicCloseRef(ref2);
      }
    }
    __close(scopeManager) {
      let closeRef;
      if (this.__shouldStaticallyClose(scopeManager)) {
        closeRef = this.__staticCloseRef;
      } else if (this.type !== "global") {
        closeRef = this.__dynamicCloseRef;
      } else {
        closeRef = this.__globalCloseRef;
      }
      for (let i2 = 0, iz = this.__left.length; i2 < iz; ++i2) {
        const ref2 = this.__left[i2];
        closeRef.call(this, ref2);
      }
      this.__left = null;
      return this.upper;
    }
    // To override by function scopes.
    // References in default parameters isn't resolved to variables which are in their function body.
    __isValidResolution(ref2, variable) {
      return true;
    }
    __resolve(ref2) {
      const name = ref2.identifier.name;
      if (!this.set.has(name)) {
        return false;
      }
      const variable = this.set.get(name);
      if (!this.__isValidResolution(ref2, variable)) {
        return false;
      }
      variable.references.push(ref2);
      variable.stack = variable.stack && ref2.from.variableScope === this.variableScope;
      if (ref2.tainted) {
        variable.tainted = true;
        this.taints.set(variable.name, true);
      }
      ref2.resolved = variable;
      return true;
    }
    __delegateToUpperScope(ref2) {
      if (this.upper) {
        this.upper.__left.push(ref2);
      }
      this.through.push(ref2);
    }
    __addDeclaredVariablesOfNode(variable, node2) {
      if (node2 === null || node2 === void 0) {
        return;
      }
      let variables = this.__declaredVariables.get(node2);
      if (variables === null || variables === void 0) {
        variables = [];
        this.__declaredVariables.set(node2, variables);
      }
      if (!variables.includes(variable)) {
        variables.push(variable);
      }
    }
    __defineGeneric(name, set, variables, node2, def) {
      let variable;
      variable = set.get(name);
      if (!variable) {
        variable = new Variable(name, this);
        set.set(name, variable);
        variables.push(variable);
      }
      if (def) {
        variable.defs.push(def);
        this.__addDeclaredVariablesOfNode(variable, def.node);
        this.__addDeclaredVariablesOfNode(variable, def.parent);
      }
      if (node2) {
        variable.identifiers.push(node2);
      }
    }
    __define(node2, def) {
      if (node2 && node2.type === Syntax$2.Identifier) {
        this.__defineGeneric(
          node2.name,
          this.set,
          this.variables,
          node2,
          def
        );
      }
    }
    __referencing(node2, assign, writeExpr, maybeImplicitGlobal, partial, init) {
      if (!node2 || node2.type !== Syntax$2.Identifier && node2.type !== "JSXIdentifier") {
        return;
      }
      if (node2.name === "super") {
        return;
      }
      const ref2 = new Reference(node2, this, assign || Reference.READ, writeExpr, maybeImplicitGlobal, !!partial, !!init);
      this.references.push(ref2);
      this.__left.push(ref2);
    }
    __detectEval() {
      let current = this;
      this.directCallToEvalScope = true;
      do {
        current.dynamic = true;
        current = current.upper;
      } while (current);
    }
    __detectThis() {
      this.thisFound = true;
    }
    __isClosed() {
      return this.__left === null;
    }
    /**
     * returns resolved {Reference}
     * @function Scope#resolve
     * @param {Espree.Identifier} ident identifier to be resolved.
     * @returns {Reference} reference
     */
    resolve(ident) {
      let ref2, i2, iz;
      assert2(this.__isClosed(), "Scope should be closed.");
      assert2(ident.type === Syntax$2.Identifier, "Target should be identifier.");
      for (i2 = 0, iz = this.references.length; i2 < iz; ++i2) {
        ref2 = this.references[i2];
        if (ref2.identifier === ident) {
          return ref2;
        }
      }
      return null;
    }
    /**
     * returns this scope is static
     * @function Scope#isStatic
     * @returns {boolean} static
     */
    isStatic() {
      return !this.dynamic;
    }
    /**
     * returns this scope has materialized arguments
     * @function Scope#isArgumentsMaterialized
     * @returns {boolean} arguemnts materialized
     */
    isArgumentsMaterialized() {
      return true;
    }
    /**
     * returns this scope has materialized `this` reference
     * @function Scope#isThisMaterialized
     * @returns {boolean} this materialized
     */
    isThisMaterialized() {
      return true;
    }
    isUsedName(name) {
      if (this.set.has(name)) {
        return true;
      }
      for (let i2 = 0, iz = this.through.length; i2 < iz; ++i2) {
        if (this.through[i2].identifier.name === name) {
          return true;
        }
      }
      return false;
    }
  }
  class GlobalScope extends Scope {
    constructor(scopeManager, block) {
      super(scopeManager, "global", null, block, false);
      this.implicit = {
        set: /* @__PURE__ */ new Map(),
        variables: [],
        /**
         * List of {@link Reference}s that are left to be resolved (i.e. which
         * need to be linked to the variable they refer to).
         * @member {Reference[]} Scope#implicit#left
         */
        left: []
      };
    }
    __close(scopeManager) {
      const implicit = [];
      for (let i2 = 0, iz = this.__left.length; i2 < iz; ++i2) {
        const ref2 = this.__left[i2];
        if (ref2.__maybeImplicitGlobal && !this.set.has(ref2.identifier.name)) {
          implicit.push(ref2.__maybeImplicitGlobal);
        }
      }
      for (let i2 = 0, iz = implicit.length; i2 < iz; ++i2) {
        const info = implicit[i2];
        this.__defineImplicit(
          info.pattern,
          new Definition(
            Variable.ImplicitGlobalVariable,
            info.pattern,
            info.node,
            null,
            null,
            null
          )
        );
      }
      this.implicit.left = this.__left;
      return super.__close(scopeManager);
    }
    __defineImplicit(node2, def) {
      if (node2 && node2.type === Syntax$2.Identifier) {
        this.__defineGeneric(
          node2.name,
          this.implicit.set,
          this.implicit.variables,
          node2,
          def
        );
      }
    }
  }
  class ModuleScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "module", upperScope, block, false);
    }
  }
  class FunctionExpressionNameScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "function-expression-name", upperScope, block, false);
      this.__define(
        block.id,
        new Definition(
          Variable.FunctionName,
          block.id,
          block,
          null,
          null,
          null
        )
      );
      this.functionExpressionScope = true;
    }
  }
  class CatchScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "catch", upperScope, block, false);
    }
  }
  class WithScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "with", upperScope, block, false);
    }
    __close(scopeManager) {
      if (this.__shouldStaticallyClose(scopeManager)) {
        return super.__close(scopeManager);
      }
      for (let i2 = 0, iz = this.__left.length; i2 < iz; ++i2) {
        const ref2 = this.__left[i2];
        ref2.tainted = true;
        this.__delegateToUpperScope(ref2);
      }
      this.__left = null;
      return this.upper;
    }
  }
  class BlockScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "block", upperScope, block, false);
    }
  }
  class SwitchScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "switch", upperScope, block, false);
    }
  }
  class FunctionScope extends Scope {
    constructor(scopeManager, upperScope, block, isMethodDefinition) {
      super(scopeManager, "function", upperScope, block, isMethodDefinition);
      if (this.block.type !== Syntax$2.ArrowFunctionExpression) {
        this.__defineArguments();
      }
    }
    isArgumentsMaterialized() {
      if (this.block.type === Syntax$2.ArrowFunctionExpression) {
        return false;
      }
      if (!this.isStatic()) {
        return true;
      }
      const variable = this.set.get("arguments");
      assert2(variable, "Always have arguments variable.");
      return variable.tainted || variable.references.length !== 0;
    }
    isThisMaterialized() {
      if (!this.isStatic()) {
        return true;
      }
      return this.thisFound;
    }
    __defineArguments() {
      this.__defineGeneric(
        "arguments",
        this.set,
        this.variables,
        null,
        null
      );
      this.taints.set("arguments", true);
    }
    // References in default parameters isn't resolved to variables which are in their function body.
    //     const x = 1
    //     function f(a = x) { // This `x` is resolved to the `x` in the outer scope.
    //         const x = 2
    //         console.log(a)
    //     }
    __isValidResolution(ref2, variable) {
      if (this.block.type === "Program") {
        return true;
      }
      const bodyStart = this.block.body.range[0];
      return !(variable.scope === this && ref2.identifier.range[0] < bodyStart && // the reference is in the parameter part.
      variable.defs.every((d2) => d2.name.range[0] >= bodyStart));
    }
  }
  class ForScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "for", upperScope, block, false);
    }
  }
  class ClassScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "class", upperScope, block, false);
    }
  }
  class ClassFieldInitializerScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "class-field-initializer", upperScope, block, true);
    }
  }
  class ClassStaticBlockScope extends Scope {
    constructor(scopeManager, upperScope, block) {
      super(scopeManager, "class-static-block", upperScope, block, true);
    }
  }
  class ScopeManager {
    constructor(options) {
      this.scopes = [];
      this.globalScope = null;
      this.__nodeToScope = /* @__PURE__ */ new WeakMap();
      this.__currentScope = null;
      this.__options = options;
      this.__declaredVariables = /* @__PURE__ */ new WeakMap();
    }
    __isOptimistic() {
      return this.__options.optimistic;
    }
    __ignoreEval() {
      return this.__options.ignoreEval;
    }
    __isJSXEnabled() {
      return this.__options.jsx === true;
    }
    isGlobalReturn() {
      return this.__options.nodejsScope || this.__options.sourceType === "commonjs";
    }
    isModule() {
      return this.__options.sourceType === "module";
    }
    isImpliedStrict() {
      return this.__options.impliedStrict;
    }
    isStrictModeSupported() {
      return this.__options.ecmaVersion >= 5;
    }
    // Returns appropriate scope for this node.
    __get(node2) {
      return this.__nodeToScope.get(node2);
    }
    /**
     * Get variables that are declared by the node.
     *
     * "are declared by the node" means the node is same as `Variable.defs[].node` or `Variable.defs[].parent`.
     * If the node declares nothing, this method returns an empty array.
     * CAUTION: This API is experimental. See https://github.com/estools/escope/pull/69 for more details.
     * @param {Espree.Node} node a node to get.
     * @returns {Variable[]} variables that declared by the node.
     */
    getDeclaredVariables(node2) {
      return this.__declaredVariables.get(node2) || [];
    }
    /**
     * acquire scope from node.
     * @function ScopeManager#acquire
     * @param {Espree.Node} node node for the acquired scope.
     * @param {?boolean} [inner=false] look up the most inner scope, default value is false.
     * @returns {Scope?} Scope from node
     */
    acquire(node2, inner) {
      function predicate(testScope) {
        if (testScope.type === "function" && testScope.functionExpressionScope) {
          return false;
        }
        return true;
      }
      const scopes = this.__get(node2);
      if (!scopes || scopes.length === 0) {
        return null;
      }
      if (scopes.length === 1) {
        return scopes[0];
      }
      if (inner) {
        for (let i2 = scopes.length - 1; i2 >= 0; --i2) {
          const scope = scopes[i2];
          if (predicate(scope)) {
            return scope;
          }
        }
      } else {
        for (let i2 = 0, iz = scopes.length; i2 < iz; ++i2) {
          const scope = scopes[i2];
          if (predicate(scope)) {
            return scope;
          }
        }
      }
      return null;
    }
    /**
     * acquire all scopes from node.
     * @function ScopeManager#acquireAll
     * @param {Espree.Node} node node for the acquired scope.
     * @returns {Scopes?} Scope array
     */
    acquireAll(node2) {
      return this.__get(node2);
    }
    /**
     * release the node.
     * @function ScopeManager#release
     * @param {Espree.Node} node releasing node.
     * @param {?boolean} [inner=false] look up the most inner scope, default value is false.
     * @returns {Scope?} upper scope for the node.
     */
    release(node2, inner) {
      const scopes = this.__get(node2);
      if (scopes && scopes.length) {
        const scope = scopes[0].upper;
        if (!scope) {
          return null;
        }
        return this.acquire(scope.block, inner);
      }
      return null;
    }
    attach() {
    }
    // eslint-disable-line class-methods-use-this -- Desired as instance method
    detach() {
    }
    // eslint-disable-line class-methods-use-this -- Desired as instance method
    __nestScope(scope) {
      if (scope instanceof GlobalScope) {
        assert2(this.__currentScope === null);
        this.globalScope = scope;
      }
      this.__currentScope = scope;
      return scope;
    }
    __nestGlobalScope(node2) {
      return this.__nestScope(new GlobalScope(this, node2));
    }
    __nestBlockScope(node2) {
      return this.__nestScope(new BlockScope(this, this.__currentScope, node2));
    }
    __nestFunctionScope(node2, isMethodDefinition) {
      return this.__nestScope(new FunctionScope(this, this.__currentScope, node2, isMethodDefinition));
    }
    __nestForScope(node2) {
      return this.__nestScope(new ForScope(this, this.__currentScope, node2));
    }
    __nestCatchScope(node2) {
      return this.__nestScope(new CatchScope(this, this.__currentScope, node2));
    }
    __nestWithScope(node2) {
      return this.__nestScope(new WithScope(this, this.__currentScope, node2));
    }
    __nestClassScope(node2) {
      return this.__nestScope(new ClassScope(this, this.__currentScope, node2));
    }
    __nestClassFieldInitializerScope(node2) {
      return this.__nestScope(new ClassFieldInitializerScope(this, this.__currentScope, node2));
    }
    __nestClassStaticBlockScope(node2) {
      return this.__nestScope(new ClassStaticBlockScope(this, this.__currentScope, node2));
    }
    __nestSwitchScope(node2) {
      return this.__nestScope(new SwitchScope(this, this.__currentScope, node2));
    }
    __nestModuleScope(node2) {
      return this.__nestScope(new ModuleScope(this, this.__currentScope, node2));
    }
    __nestFunctionExpressionNameScope(node2) {
      return this.__nestScope(new FunctionExpressionNameScope(this, this.__currentScope, node2));
    }
    __isES6() {
      return this.__options.ecmaVersion >= 6;
    }
  }
  const { Syntax: Syntax$1 } = estraverse__default["default"];
  function getLast(xs) {
    return xs.at(-1) || null;
  }
  class PatternVisitor extends esrecurse__default["default"].Visitor {
    static isPattern(node2) {
      const nodeType = node2.type;
      return nodeType === Syntax$1.Identifier || nodeType === Syntax$1.ObjectPattern || nodeType === Syntax$1.ArrayPattern || nodeType === Syntax$1.SpreadElement || nodeType === Syntax$1.RestElement || nodeType === Syntax$1.AssignmentPattern;
    }
    constructor(options, rootPattern, callback) {
      super(null, options);
      this.rootPattern = rootPattern;
      this.callback = callback;
      this.assignments = [];
      this.rightHandNodes = [];
      this.restElements = [];
    }
    Identifier(pattern2) {
      const lastRestElement = getLast(this.restElements);
      this.callback(pattern2, {
        topLevel: pattern2 === this.rootPattern,
        rest: lastRestElement !== null && lastRestElement !== void 0 && lastRestElement.argument === pattern2,
        assignments: this.assignments
      });
    }
    Property(property) {
      if (property.computed) {
        this.rightHandNodes.push(property.key);
      }
      this.visit(property.value);
    }
    ArrayPattern(pattern2) {
      for (let i2 = 0, iz = pattern2.elements.length; i2 < iz; ++i2) {
        const element = pattern2.elements[i2];
        this.visit(element);
      }
    }
    AssignmentPattern(pattern2) {
      this.assignments.push(pattern2);
      this.visit(pattern2.left);
      this.rightHandNodes.push(pattern2.right);
      this.assignments.pop();
    }
    RestElement(pattern2) {
      this.restElements.push(pattern2);
      this.visit(pattern2.argument);
      this.restElements.pop();
    }
    MemberExpression(node2) {
      if (node2.computed) {
        this.rightHandNodes.push(node2.property);
      }
      this.rightHandNodes.push(node2.object);
    }
    //
    // ForInStatement.left and AssignmentExpression.left are LeftHandSideExpression.
    // By spec, LeftHandSideExpression is Pattern or MemberExpression.
    //   (see also: https://github.com/estree/estree/pull/20#issuecomment-74584758)
    // But espree 2.0 parses to ArrayExpression, ObjectExpression, etc...
    //
    SpreadElement(node2) {
      this.visit(node2.argument);
    }
    ArrayExpression(node2) {
      node2.elements.forEach(this.visit, this);
    }
    AssignmentExpression(node2) {
      this.assignments.push(node2);
      this.visit(node2.left);
      this.rightHandNodes.push(node2.right);
      this.assignments.pop();
    }
    CallExpression(node2) {
      node2.arguments.forEach((a2) => {
        this.rightHandNodes.push(a2);
      });
      this.visit(node2.callee);
    }
  }
  const { Syntax } = estraverse__default["default"];
  function traverseIdentifierInPattern(options, rootPattern, referencer, callback) {
    const visitor = new PatternVisitor(options, rootPattern, callback);
    visitor.visit(rootPattern);
    if (referencer !== null && referencer !== void 0) {
      visitor.rightHandNodes.forEach(referencer.visit, referencer);
    }
  }
  class Importer extends esrecurse__default["default"].Visitor {
    constructor(declaration, referencer) {
      super(null, referencer.options);
      this.declaration = declaration;
      this.referencer = referencer;
    }
    visitImport(id2, specifier) {
      this.referencer.visitPattern(id2, (pattern2) => {
        this.referencer.currentScope().__define(
          pattern2,
          new Definition(
            Variable.ImportBinding,
            pattern2,
            specifier,
            this.declaration,
            null,
            null
          )
        );
      });
    }
    ImportNamespaceSpecifier(node2) {
      const local = node2.local || node2.id;
      if (local) {
        this.visitImport(local, node2);
      }
    }
    ImportDefaultSpecifier(node2) {
      const local = node2.local || node2.id;
      this.visitImport(local, node2);
    }
    ImportSpecifier(node2) {
      const local = node2.local || node2.id;
      if (node2.name) {
        this.visitImport(node2.name, node2);
      } else {
        this.visitImport(local, node2);
      }
    }
  }
  class Referencer extends esrecurse__default["default"].Visitor {
    constructor(options, scopeManager) {
      super(null, options);
      this.options = options;
      this.scopeManager = scopeManager;
      this.parent = null;
      this.isInnerMethodDefinition = false;
    }
    currentScope() {
      return this.scopeManager.__currentScope;
    }
    close(node2) {
      while (this.currentScope() && node2 === this.currentScope().block) {
        this.scopeManager.__currentScope = this.currentScope().__close(this.scopeManager);
      }
    }
    pushInnerMethodDefinition(isInnerMethodDefinition) {
      const previous = this.isInnerMethodDefinition;
      this.isInnerMethodDefinition = isInnerMethodDefinition;
      return previous;
    }
    popInnerMethodDefinition(isInnerMethodDefinition) {
      this.isInnerMethodDefinition = isInnerMethodDefinition;
    }
    referencingDefaultValue(pattern2, assignments, maybeImplicitGlobal, init) {
      const scope = this.currentScope();
      assignments.forEach((assignment) => {
        scope.__referencing(
          pattern2,
          Reference.WRITE,
          assignment.right,
          maybeImplicitGlobal,
          pattern2 !== assignment.left,
          init
        );
      });
    }
    visitPattern(node2, options, callback) {
      let visitPatternOptions = options;
      let visitPatternCallback = callback;
      if (typeof options === "function") {
        visitPatternCallback = options;
        visitPatternOptions = { processRightHandNodes: false };
      }
      traverseIdentifierInPattern(
        this.options,
        node2,
        visitPatternOptions.processRightHandNodes ? this : null,
        visitPatternCallback
      );
    }
    visitFunction(node2) {
      let i2, iz;
      if (node2.type === Syntax.FunctionDeclaration) {
        this.currentScope().__define(
          node2.id,
          new Definition(
            Variable.FunctionName,
            node2.id,
            node2,
            null,
            null,
            null
          )
        );
      }
      if (node2.type === Syntax.FunctionExpression && node2.id) {
        this.scopeManager.__nestFunctionExpressionNameScope(node2);
      }
      this.scopeManager.__nestFunctionScope(node2, this.isInnerMethodDefinition);
      const that = this;
      function visitPatternCallback(pattern2, info) {
        that.currentScope().__define(
          pattern2,
          new ParameterDefinition(
            pattern2,
            node2,
            i2,
            info.rest
          )
        );
        that.referencingDefaultValue(pattern2, info.assignments, null, true);
      }
      for (i2 = 0, iz = node2.params.length; i2 < iz; ++i2) {
        this.visitPattern(node2.params[i2], { processRightHandNodes: true }, visitPatternCallback);
      }
      if (node2.rest) {
        this.visitPattern({
          type: "RestElement",
          argument: node2.rest
        }, (pattern2) => {
          this.currentScope().__define(
            pattern2,
            new ParameterDefinition(
              pattern2,
              node2,
              node2.params.length,
              true
            )
          );
        });
      }
      if (node2.body) {
        if (node2.body.type === Syntax.BlockStatement) {
          this.visitChildren(node2.body);
        } else {
          this.visit(node2.body);
        }
      }
      this.close(node2);
    }
    visitClass(node2) {
      if (node2.type === Syntax.ClassDeclaration) {
        this.currentScope().__define(
          node2.id,
          new Definition(
            Variable.ClassName,
            node2.id,
            node2,
            null,
            null,
            null
          )
        );
      }
      this.scopeManager.__nestClassScope(node2);
      if (node2.id) {
        this.currentScope().__define(
          node2.id,
          new Definition(
            Variable.ClassName,
            node2.id,
            node2
          )
        );
      }
      this.visit(node2.superClass);
      this.visit(node2.body);
      this.close(node2);
    }
    visitProperty(node2) {
      let previous;
      if (node2.computed) {
        this.visit(node2.key);
      }
      const isMethodDefinition = node2.type === Syntax.MethodDefinition;
      if (isMethodDefinition) {
        previous = this.pushInnerMethodDefinition(true);
      }
      this.visit(node2.value);
      if (isMethodDefinition) {
        this.popInnerMethodDefinition(previous);
      }
    }
    visitForIn(node2) {
      if (node2.left.type === Syntax.VariableDeclaration && node2.left.kind !== "var") {
        this.scopeManager.__nestForScope(node2);
      }
      if (node2.left.type === Syntax.VariableDeclaration) {
        this.visit(node2.left);
        this.visitPattern(node2.left.declarations[0].id, (pattern2) => {
          this.currentScope().__referencing(pattern2, Reference.WRITE, node2.right, null, true, true);
        });
      } else {
        this.visitPattern(node2.left, { processRightHandNodes: true }, (pattern2, info) => {
          let maybeImplicitGlobal = null;
          if (!this.currentScope().isStrict) {
            maybeImplicitGlobal = {
              pattern: pattern2,
              node: node2
            };
          }
          this.referencingDefaultValue(pattern2, info.assignments, maybeImplicitGlobal, false);
          this.currentScope().__referencing(pattern2, Reference.WRITE, node2.right, maybeImplicitGlobal, true, false);
        });
      }
      this.visit(node2.right);
      this.visit(node2.body);
      this.close(node2);
    }
    visitVariableDeclaration(variableTargetScope, type2, node2, index) {
      const decl = node2.declarations[index];
      const init = decl.init;
      this.visitPattern(decl.id, { processRightHandNodes: true }, (pattern2, info) => {
        variableTargetScope.__define(
          pattern2,
          new Definition(
            type2,
            pattern2,
            decl,
            node2,
            index,
            node2.kind
          )
        );
        this.referencingDefaultValue(pattern2, info.assignments, null, true);
        if (init) {
          this.currentScope().__referencing(pattern2, Reference.WRITE, init, null, !info.topLevel, true);
        }
      });
    }
    AssignmentExpression(node2) {
      if (PatternVisitor.isPattern(node2.left)) {
        if (node2.operator === "=") {
          this.visitPattern(node2.left, { processRightHandNodes: true }, (pattern2, info) => {
            let maybeImplicitGlobal = null;
            if (!this.currentScope().isStrict) {
              maybeImplicitGlobal = {
                pattern: pattern2,
                node: node2
              };
            }
            this.referencingDefaultValue(pattern2, info.assignments, maybeImplicitGlobal, false);
            this.currentScope().__referencing(pattern2, Reference.WRITE, node2.right, maybeImplicitGlobal, !info.topLevel, false);
          });
        } else {
          this.currentScope().__referencing(node2.left, Reference.RW, node2.right);
        }
      } else {
        this.visit(node2.left);
      }
      this.visit(node2.right);
    }
    CatchClause(node2) {
      this.scopeManager.__nestCatchScope(node2);
      this.visitPattern(node2.param, { processRightHandNodes: true }, (pattern2, info) => {
        this.currentScope().__define(
          pattern2,
          new Definition(
            Variable.CatchClause,
            pattern2,
            node2,
            null,
            null,
            null
          )
        );
        this.referencingDefaultValue(pattern2, info.assignments, null, true);
      });
      this.visit(node2.body);
      this.close(node2);
    }
    Program(node2) {
      this.scopeManager.__nestGlobalScope(node2);
      if (this.scopeManager.isGlobalReturn()) {
        this.currentScope().isStrict = false;
        this.scopeManager.__nestFunctionScope(node2, false);
      }
      if (this.scopeManager.__isES6() && this.scopeManager.isModule()) {
        this.scopeManager.__nestModuleScope(node2);
      }
      if (this.scopeManager.isStrictModeSupported() && this.scopeManager.isImpliedStrict()) {
        this.currentScope().isStrict = true;
      }
      this.visitChildren(node2);
      this.close(node2);
    }
    Identifier(node2) {
      this.currentScope().__referencing(node2);
    }
    // eslint-disable-next-line class-methods-use-this -- Desired as instance method
    PrivateIdentifier() {
    }
    UpdateExpression(node2) {
      if (PatternVisitor.isPattern(node2.argument)) {
        this.currentScope().__referencing(node2.argument, Reference.RW, null);
      } else {
        this.visitChildren(node2);
      }
    }
    MemberExpression(node2) {
      this.visit(node2.object);
      if (node2.computed) {
        this.visit(node2.property);
      }
    }
    Property(node2) {
      this.visitProperty(node2);
    }
    PropertyDefinition(node2) {
      const { computed, key, value } = node2;
      if (computed) {
        this.visit(key);
      }
      if (value) {
        this.scopeManager.__nestClassFieldInitializerScope(value);
        this.visit(value);
        this.close(value);
      }
    }
    StaticBlock(node2) {
      this.scopeManager.__nestClassStaticBlockScope(node2);
      this.visitChildren(node2);
      this.close(node2);
    }
    MethodDefinition(node2) {
      this.visitProperty(node2);
    }
    BreakStatement() {
    }
    // eslint-disable-line class-methods-use-this -- Desired as instance method
    ContinueStatement() {
    }
    // eslint-disable-line class-methods-use-this -- Desired as instance method
    LabeledStatement(node2) {
      this.visit(node2.body);
    }
    ForStatement(node2) {
      if (node2.init && node2.init.type === Syntax.VariableDeclaration && node2.init.kind !== "var") {
        this.scopeManager.__nestForScope(node2);
      }
      this.visitChildren(node2);
      this.close(node2);
    }
    ClassExpression(node2) {
      this.visitClass(node2);
    }
    ClassDeclaration(node2) {
      this.visitClass(node2);
    }
    CallExpression(node2) {
      if (!this.scopeManager.__ignoreEval() && node2.callee.type === Syntax.Identifier && node2.callee.name === "eval") {
        this.currentScope().variableScope.__detectEval();
      }
      this.visitChildren(node2);
    }
    BlockStatement(node2) {
      if (this.scopeManager.__isES6()) {
        this.scopeManager.__nestBlockScope(node2);
      }
      this.visitChildren(node2);
      this.close(node2);
    }
    ThisExpression() {
      this.currentScope().variableScope.__detectThis();
    }
    WithStatement(node2) {
      this.visit(node2.object);
      this.scopeManager.__nestWithScope(node2);
      this.visit(node2.body);
      this.close(node2);
    }
    VariableDeclaration(node2) {
      const variableTargetScope = node2.kind === "var" ? this.currentScope().variableScope : this.currentScope();
      for (let i2 = 0, iz = node2.declarations.length; i2 < iz; ++i2) {
        const decl = node2.declarations[i2];
        this.visitVariableDeclaration(variableTargetScope, Variable.Variable, node2, i2);
        if (decl.init) {
          this.visit(decl.init);
        }
      }
    }
    // sec 13.11.8
    SwitchStatement(node2) {
      this.visit(node2.discriminant);
      if (this.scopeManager.__isES6()) {
        this.scopeManager.__nestSwitchScope(node2);
      }
      for (let i2 = 0, iz = node2.cases.length; i2 < iz; ++i2) {
        this.visit(node2.cases[i2]);
      }
      this.close(node2);
    }
    FunctionDeclaration(node2) {
      this.visitFunction(node2);
    }
    FunctionExpression(node2) {
      this.visitFunction(node2);
    }
    ForOfStatement(node2) {
      this.visitForIn(node2);
    }
    ForInStatement(node2) {
      this.visitForIn(node2);
    }
    ArrowFunctionExpression(node2) {
      this.visitFunction(node2);
    }
    ImportDeclaration(node2) {
      assert2(this.scopeManager.__isES6() && this.scopeManager.isModule(), "ImportDeclaration should appear when the mode is ES6 and in the module context.");
      const importer = new Importer(node2, this);
      importer.visit(node2);
    }
    visitExportDeclaration(node2) {
      if (node2.source) {
        return;
      }
      if (node2.declaration) {
        this.visit(node2.declaration);
        return;
      }
      this.visitChildren(node2);
    }
    // TODO: ExportDeclaration doesn't exist. for bc?
    ExportDeclaration(node2) {
      this.visitExportDeclaration(node2);
    }
    ExportAllDeclaration(node2) {
      this.visitExportDeclaration(node2);
    }
    ExportDefaultDeclaration(node2) {
      this.visitExportDeclaration(node2);
    }
    ExportNamedDeclaration(node2) {
      this.visitExportDeclaration(node2);
    }
    ExportSpecifier(node2) {
      const local = node2.id || node2.local;
      this.visit(local);
    }
    MetaProperty() {
    }
    JSXIdentifier(node2) {
      if (this.scopeManager.__isJSXEnabled() && node2.name !== "this") {
        this.currentScope().__referencing(node2);
      }
    }
    JSXMemberExpression(node2) {
      this.visit(node2.object);
    }
    JSXElement(node2) {
      if (this.scopeManager.__isJSXEnabled()) {
        this.visit(node2.openingElement);
        node2.children.forEach(this.visit, this);
      } else {
        this.visitChildren(node2);
      }
    }
    JSXOpeningElement(node2) {
      if (this.scopeManager.__isJSXEnabled()) {
        const nameNode = node2.name;
        const isComponentName = nameNode.type === "JSXIdentifier" && nameNode.name[0].toUpperCase() === nameNode.name[0];
        const isComponent = isComponentName || nameNode.type === "JSXMemberExpression";
        if (isComponent) {
          this.visit(nameNode);
        }
      }
      node2.attributes.forEach(this.visit, this);
    }
    JSXAttribute(node2) {
      if (node2.value) {
        this.visit(node2.value);
      }
    }
    JSXExpressionContainer(node2) {
      this.visit(node2.expression);
    }
    JSXNamespacedName(node2) {
      this.visit(node2.namespace);
      this.visit(node2.name);
    }
  }
  const version2 = "8.4.0";
  function defaultOptions() {
    return {
      optimistic: false,
      nodejsScope: false,
      impliedStrict: false,
      sourceType: "script",
      // one of ['script', 'module', 'commonjs']
      ecmaVersion: 5,
      childVisitorKeys: null,
      fallback: "iteration"
    };
  }
  function updateDeeply(target, override) {
    function isHashObject(value) {
      return typeof value === "object" && value instanceof Object && !(value instanceof Array) && !(value instanceof RegExp);
    }
    for (const key in override) {
      if (Object.hasOwn(override, key)) {
        const val = override[key];
        if (isHashObject(val)) {
          if (isHashObject(target[key])) {
            updateDeeply(target[key], val);
          } else {
            target[key] = updateDeeply({}, val);
          }
        } else {
          target[key] = val;
        }
      }
    }
    return target;
  }
  function analyze(tree, providedOptions) {
    const options = updateDeeply(defaultOptions(), providedOptions);
    const scopeManager = new ScopeManager(options);
    const referencer = new Referencer(options, scopeManager);
    referencer.visit(tree);
    assert2(scopeManager.__currentScope === null, "currentScope should be null.");
    return scopeManager;
  }
  eslintScope.Definition = Definition;
  eslintScope.PatternVisitor = PatternVisitor;
  eslintScope.Reference = Reference;
  eslintScope.Referencer = Referencer;
  eslintScope.Scope = Scope;
  eslintScope.ScopeManager = ScopeManager;
  eslintScope.Variable = Variable;
  eslintScope.analyze = analyze;
  eslintScope.version = version2;
  return eslintScope;
}
var eslintVisitorKeys$2 = {};
var hasRequiredEslintVisitorKeys$2;
function requireEslintVisitorKeys$2() {
  if (hasRequiredEslintVisitorKeys$2) return eslintVisitorKeys$2;
  hasRequiredEslintVisitorKeys$2 = 1;
  const KEYS = {
    ArrayExpression: [
      "elements"
    ],
    ArrayPattern: [
      "elements"
    ],
    ArrowFunctionExpression: [
      "params",
      "body"
    ],
    AssignmentExpression: [
      "left",
      "right"
    ],
    AssignmentPattern: [
      "left",
      "right"
    ],
    AwaitExpression: [
      "argument"
    ],
    BinaryExpression: [
      "left",
      "right"
    ],
    BlockStatement: [
      "body"
    ],
    BreakStatement: [
      "label"
    ],
    CallExpression: [
      "callee",
      "arguments"
    ],
    CatchClause: [
      "param",
      "body"
    ],
    ChainExpression: [
      "expression"
    ],
    ClassBody: [
      "body"
    ],
    ClassDeclaration: [
      "id",
      "superClass",
      "body"
    ],
    ClassExpression: [
      "id",
      "superClass",
      "body"
    ],
    ConditionalExpression: [
      "test",
      "consequent",
      "alternate"
    ],
    ContinueStatement: [
      "label"
    ],
    DebuggerStatement: [],
    DoWhileStatement: [
      "body",
      "test"
    ],
    EmptyStatement: [],
    ExperimentalRestProperty: [
      "argument"
    ],
    ExperimentalSpreadProperty: [
      "argument"
    ],
    ExportAllDeclaration: [
      "exported",
      "source",
      "attributes"
    ],
    ExportDefaultDeclaration: [
      "declaration"
    ],
    ExportNamedDeclaration: [
      "declaration",
      "specifiers",
      "source",
      "attributes"
    ],
    ExportSpecifier: [
      "local",
      "exported"
    ],
    ExpressionStatement: [
      "expression"
    ],
    ForInStatement: [
      "left",
      "right",
      "body"
    ],
    ForOfStatement: [
      "left",
      "right",
      "body"
    ],
    ForStatement: [
      "init",
      "test",
      "update",
      "body"
    ],
    FunctionDeclaration: [
      "id",
      "params",
      "body"
    ],
    FunctionExpression: [
      "id",
      "params",
      "body"
    ],
    Identifier: [],
    IfStatement: [
      "test",
      "consequent",
      "alternate"
    ],
    ImportAttribute: [
      "key",
      "value"
    ],
    ImportDeclaration: [
      "specifiers",
      "source",
      "attributes"
    ],
    ImportDefaultSpecifier: [
      "local"
    ],
    ImportExpression: [
      "source",
      "options"
    ],
    ImportNamespaceSpecifier: [
      "local"
    ],
    ImportSpecifier: [
      "imported",
      "local"
    ],
    JSXAttribute: [
      "name",
      "value"
    ],
    JSXClosingElement: [
      "name"
    ],
    JSXClosingFragment: [],
    JSXElement: [
      "openingElement",
      "children",
      "closingElement"
    ],
    JSXEmptyExpression: [],
    JSXExpressionContainer: [
      "expression"
    ],
    JSXFragment: [
      "openingFragment",
      "children",
      "closingFragment"
    ],
    JSXIdentifier: [],
    JSXMemberExpression: [
      "object",
      "property"
    ],
    JSXNamespacedName: [
      "namespace",
      "name"
    ],
    JSXOpeningElement: [
      "name",
      "attributes"
    ],
    JSXOpeningFragment: [],
    JSXSpreadAttribute: [
      "argument"
    ],
    JSXSpreadChild: [
      "expression"
    ],
    JSXText: [],
    LabeledStatement: [
      "label",
      "body"
    ],
    Literal: [],
    LogicalExpression: [
      "left",
      "right"
    ],
    MemberExpression: [
      "object",
      "property"
    ],
    MetaProperty: [
      "meta",
      "property"
    ],
    MethodDefinition: [
      "key",
      "value"
    ],
    NewExpression: [
      "callee",
      "arguments"
    ],
    ObjectExpression: [
      "properties"
    ],
    ObjectPattern: [
      "properties"
    ],
    PrivateIdentifier: [],
    Program: [
      "body"
    ],
    Property: [
      "key",
      "value"
    ],
    PropertyDefinition: [
      "key",
      "value"
    ],
    RestElement: [
      "argument"
    ],
    ReturnStatement: [
      "argument"
    ],
    SequenceExpression: [
      "expressions"
    ],
    SpreadElement: [
      "argument"
    ],
    StaticBlock: [
      "body"
    ],
    Super: [],
    SwitchCase: [
      "test",
      "consequent"
    ],
    SwitchStatement: [
      "discriminant",
      "cases"
    ],
    TaggedTemplateExpression: [
      "tag",
      "quasi"
    ],
    TemplateElement: [],
    TemplateLiteral: [
      "quasis",
      "expressions"
    ],
    ThisExpression: [],
    ThrowStatement: [
      "argument"
    ],
    TryStatement: [
      "block",
      "handler",
      "finalizer"
    ],
    UnaryExpression: [
      "argument"
    ],
    UpdateExpression: [
      "argument"
    ],
    VariableDeclaration: [
      "declarations"
    ],
    VariableDeclarator: [
      "id",
      "init"
    ],
    WhileStatement: [
      "test",
      "body"
    ],
    WithStatement: [
      "object",
      "body"
    ],
    YieldExpression: [
      "argument"
    ]
  };
  const NODE_TYPES = Object.keys(KEYS);
  for (const type2 of NODE_TYPES) {
    Object.freeze(KEYS[type2]);
  }
  Object.freeze(KEYS);
  const KEY_BLACKLIST = /* @__PURE__ */ new Set([
    "parent",
    "leadingComments",
    "trailingComments"
  ]);
  function filterKey(key) {
    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
  }
  function getKeys(node2) {
    return Object.keys(node2).filter(filterKey);
  }
  function unionWith(additionalKeys) {
    const retv = (
      /** @type {{ [type: string]: ReadonlyArray<string> }} */
      Object.assign({}, KEYS)
    );
    for (const type2 of Object.keys(additionalKeys)) {
      if (Object.hasOwn(retv, type2)) {
        const keys = new Set(additionalKeys[type2]);
        for (const key of retv[type2]) {
          keys.add(key);
        }
        retv[type2] = Object.freeze(Array.from(keys));
      } else {
        retv[type2] = Object.freeze(Array.from(additionalKeys[type2]));
      }
    }
    return Object.freeze(retv);
  }
  eslintVisitorKeys$2.KEYS = KEYS;
  eslintVisitorKeys$2.getKeys = getKeys;
  eslintVisitorKeys$2.unionWith = unionWith;
  return eslintVisitorKeys$2;
}
var espree = {};
var acorn = { exports: {} };
var hasRequiredAcorn;
function requireAcorn() {
  if (hasRequiredAcorn) return acorn.exports;
  hasRequiredAcorn = 1;
  (function(module, exports$1) {
    (function(global, factory) {
      factory(exports$1);
    })(this, (function(exports2) {
      var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
      var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];
      var nonASCIIidentifierChars = "‌‍·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࢗ-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･";
      var nonASCIIidentifierStartChars = "ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲊᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟍꟐꟑꟓꟕ-Ƛꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ";
      var reservedWords = {
        3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
        5: "class enum extends super const export import",
        6: "enum",
        strict: "implements interface let package private protected public static yield",
        strictBind: "eval arguments"
      };
      var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";
      var keywords$1 = {
        5: ecma5AndLessKeywords,
        "5module": ecma5AndLessKeywords + " export import",
        6: ecma5AndLessKeywords + " const class extends export import super"
      };
      var keywordRelationalOperator = /^in(stanceof)?$/;
      var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
      var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
      function isInAstralSet(code2, set) {
        var pos = 65536;
        for (var i3 = 0; i3 < set.length; i3 += 2) {
          pos += set[i3];
          if (pos > code2) {
            return false;
          }
          pos += set[i3 + 1];
          if (pos >= code2) {
            return true;
          }
        }
        return false;
      }
      function isIdentifierStart(code2, astral) {
        if (code2 < 65) {
          return code2 === 36;
        }
        if (code2 < 91) {
          return true;
        }
        if (code2 < 97) {
          return code2 === 95;
        }
        if (code2 < 123) {
          return true;
        }
        if (code2 <= 65535) {
          return code2 >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code2));
        }
        if (astral === false) {
          return false;
        }
        return isInAstralSet(code2, astralIdentifierStartCodes);
      }
      function isIdentifierChar(code2, astral) {
        if (code2 < 48) {
          return code2 === 36;
        }
        if (code2 < 58) {
          return true;
        }
        if (code2 < 65) {
          return false;
        }
        if (code2 < 91) {
          return true;
        }
        if (code2 < 97) {
          return code2 === 95;
        }
        if (code2 < 123) {
          return true;
        }
        if (code2 <= 65535) {
          return code2 >= 170 && nonASCIIidentifier.test(String.fromCharCode(code2));
        }
        if (astral === false) {
          return false;
        }
        return isInAstralSet(code2, astralIdentifierStartCodes) || isInAstralSet(code2, astralIdentifierCodes);
      }
      var TokenType = function TokenType2(label, conf) {
        if (conf === void 0) conf = {};
        this.label = label;
        this.keyword = conf.keyword;
        this.beforeExpr = !!conf.beforeExpr;
        this.startsExpr = !!conf.startsExpr;
        this.isLoop = !!conf.isLoop;
        this.isAssign = !!conf.isAssign;
        this.prefix = !!conf.prefix;
        this.postfix = !!conf.postfix;
        this.binop = conf.binop || null;
        this.updateContext = null;
      };
      function binop(name, prec) {
        return new TokenType(name, { beforeExpr: true, binop: prec });
      }
      var beforeExpr = { beforeExpr: true }, startsExpr = { startsExpr: true };
      var keywords2 = {};
      function kw(name, options) {
        if (options === void 0) options = {};
        options.keyword = name;
        return keywords2[name] = new TokenType(name, options);
      }
      var types$1 = {
        num: new TokenType("num", startsExpr),
        regexp: new TokenType("regexp", startsExpr),
        string: new TokenType("string", startsExpr),
        name: new TokenType("name", startsExpr),
        privateId: new TokenType("privateId", startsExpr),
        eof: new TokenType("eof"),
        // Punctuation token types.
        bracketL: new TokenType("[", { beforeExpr: true, startsExpr: true }),
        bracketR: new TokenType("]"),
        braceL: new TokenType("{", { beforeExpr: true, startsExpr: true }),
        braceR: new TokenType("}"),
        parenL: new TokenType("(", { beforeExpr: true, startsExpr: true }),
        parenR: new TokenType(")"),
        comma: new TokenType(",", beforeExpr),
        semi: new TokenType(";", beforeExpr),
        colon: new TokenType(":", beforeExpr),
        dot: new TokenType("."),
        question: new TokenType("?", beforeExpr),
        questionDot: new TokenType("?."),
        arrow: new TokenType("=>", beforeExpr),
        template: new TokenType("template"),
        invalidTemplate: new TokenType("invalidTemplate"),
        ellipsis: new TokenType("...", beforeExpr),
        backQuote: new TokenType("`", startsExpr),
        dollarBraceL: new TokenType("${", { beforeExpr: true, startsExpr: true }),
        // Operators. These carry several kinds of properties to help the
        // parser use them properly (the presence of these properties is
        // what categorizes them as operators).
        //
        // `binop`, when present, specifies that this operator is a binary
        // operator, and will refer to its precedence.
        //
        // `prefix` and `postfix` mark the operator as a prefix or postfix
        // unary operator.
        //
        // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
        // binary operators with a very low precedence, that should result
        // in AssignmentExpression nodes.
        eq: new TokenType("=", { beforeExpr: true, isAssign: true }),
        assign: new TokenType("_=", { beforeExpr: true, isAssign: true }),
        incDec: new TokenType("++/--", { prefix: true, postfix: true, startsExpr: true }),
        prefix: new TokenType("!/~", { beforeExpr: true, prefix: true, startsExpr: true }),
        logicalOR: binop("||", 1),
        logicalAND: binop("&&", 2),
        bitwiseOR: binop("|", 3),
        bitwiseXOR: binop("^", 4),
        bitwiseAND: binop("&", 5),
        equality: binop("==/!=/===/!==", 6),
        relational: binop("</>/<=/>=", 7),
        bitShift: binop("<</>>/>>>", 8),
        plusMin: new TokenType("+/-", { beforeExpr: true, binop: 9, prefix: true, startsExpr: true }),
        modulo: binop("%", 10),
        star: binop("*", 10),
        slash: binop("/", 10),
        starstar: new TokenType("**", { beforeExpr: true }),
        coalesce: binop("??", 1),
        // Keyword token types.
        _break: kw("break"),
        _case: kw("case", beforeExpr),
        _catch: kw("catch"),
        _continue: kw("continue"),
        _debugger: kw("debugger"),
        _default: kw("default", beforeExpr),
        _do: kw("do", { isLoop: true, beforeExpr: true }),
        _else: kw("else", beforeExpr),
        _finally: kw("finally"),
        _for: kw("for", { isLoop: true }),
        _function: kw("function", startsExpr),
        _if: kw("if"),
        _return: kw("return", beforeExpr),
        _switch: kw("switch"),
        _throw: kw("throw", beforeExpr),
        _try: kw("try"),
        _var: kw("var"),
        _const: kw("const"),
        _while: kw("while", { isLoop: true }),
        _with: kw("with"),
        _new: kw("new", { beforeExpr: true, startsExpr: true }),
        _this: kw("this", startsExpr),
        _super: kw("super", startsExpr),
        _class: kw("class", startsExpr),
        _extends: kw("extends", beforeExpr),
        _export: kw("export"),
        _import: kw("import", startsExpr),
        _null: kw("null", startsExpr),
        _true: kw("true", startsExpr),
        _false: kw("false", startsExpr),
        _in: kw("in", { beforeExpr: true, binop: 7 }),
        _instanceof: kw("instanceof", { beforeExpr: true, binop: 7 }),
        _typeof: kw("typeof", { beforeExpr: true, prefix: true, startsExpr: true }),
        _void: kw("void", { beforeExpr: true, prefix: true, startsExpr: true }),
        _delete: kw("delete", { beforeExpr: true, prefix: true, startsExpr: true })
      };
      var lineBreak = /\r\n?|\n|\u2028|\u2029/;
      var lineBreakG = new RegExp(lineBreak.source, "g");
      function isNewLine(code2) {
        return code2 === 10 || code2 === 13 || code2 === 8232 || code2 === 8233;
      }
      function nextLineBreak(code2, from, end) {
        if (end === void 0) end = code2.length;
        for (var i3 = from; i3 < end; i3++) {
          var next = code2.charCodeAt(i3);
          if (isNewLine(next)) {
            return i3 < end - 1 && next === 13 && code2.charCodeAt(i3 + 1) === 10 ? i3 + 2 : i3 + 1;
          }
        }
        return -1;
      }
      var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;
      var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
      var ref2 = Object.prototype;
      var hasOwnProperty = ref2.hasOwnProperty;
      var toString = ref2.toString;
      var hasOwn = Object.hasOwn || (function(obj, propName) {
        return hasOwnProperty.call(obj, propName);
      });
      var isArray = Array.isArray || (function(obj) {
        return toString.call(obj) === "[object Array]";
      });
      var regexpCache = /* @__PURE__ */ Object.create(null);
      function wordsRegexp(words) {
        return regexpCache[words] || (regexpCache[words] = new RegExp("^(?:" + words.replace(/ /g, "|") + ")$"));
      }
      function codePointToString(code2) {
        if (code2 <= 65535) {
          return String.fromCharCode(code2);
        }
        code2 -= 65536;
        return String.fromCharCode((code2 >> 10) + 55296, (code2 & 1023) + 56320);
      }
      var loneSurrogate = /(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/;
      var Position = function Position2(line, col) {
        this.line = line;
        this.column = col;
      };
      Position.prototype.offset = function offset(n2) {
        return new Position(this.line, this.column + n2);
      };
      var SourceLocation = function SourceLocation2(p2, start, end) {
        this.start = start;
        this.end = end;
        if (p2.sourceFile !== null) {
          this.source = p2.sourceFile;
        }
      };
      function getLineInfo(input, offset) {
        for (var line = 1, cur = 0; ; ) {
          var nextBreak = nextLineBreak(input, cur, offset);
          if (nextBreak < 0) {
            return new Position(line, offset - cur);
          }
          ++line;
          cur = nextBreak;
        }
      }
      var defaultOptions = {
        // `ecmaVersion` indicates the ECMAScript version to parse. Must be
        // either 3, 5, 6 (or 2015), 7 (2016), 8 (2017), 9 (2018), 10
        // (2019), 11 (2020), 12 (2021), 13 (2022), 14 (2023), or `"latest"`
        // (the latest version the library supports). This influences
        // support for strict mode, the set of reserved words, and support
        // for new syntax features.
        ecmaVersion: null,
        // `sourceType` indicates the mode the code should be parsed in.
        // Can be either `"script"` or `"module"`. This influences global
        // strict mode and parsing of `import` and `export` declarations.
        sourceType: "script",
        // `onInsertedSemicolon` can be a callback that will be called when
        // a semicolon is automatically inserted. It will be passed the
        // position of the inserted semicolon as an offset, and if
        // `locations` is enabled, it is given the location as a `{line,
        // column}` object as second argument.
        onInsertedSemicolon: null,
        // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
        // trailing commas.
        onTrailingComma: null,
        // By default, reserved words are only enforced if ecmaVersion >= 5.
        // Set `allowReserved` to a boolean value to explicitly turn this on
        // an off. When this option has the value "never", reserved words
        // and keywords can also not be used as property names.
        allowReserved: null,
        // When enabled, a return at the top level is not considered an
        // error.
        allowReturnOutsideFunction: false,
        // When enabled, import/export statements are not constrained to
        // appearing at the top of the program, and an import.meta expression
        // in a script isn't considered an error.
        allowImportExportEverywhere: false,
        // By default, await identifiers are allowed to appear at the top-level scope only if ecmaVersion >= 2022.
        // When enabled, await identifiers are allowed to appear at the top-level scope,
        // but they are still not allowed in non-async functions.
        allowAwaitOutsideFunction: null,
        // When enabled, super identifiers are not constrained to
        // appearing in methods and do not raise an error when they appear elsewhere.
        allowSuperOutsideMethod: null,
        // When enabled, hashbang directive in the beginning of file is
        // allowed and treated as a line comment. Enabled by default when
        // `ecmaVersion` >= 2023.
        allowHashBang: false,
        // By default, the parser will verify that private properties are
        // only used in places where they are valid and have been declared.
        // Set this to false to turn such checks off.
        checkPrivateFields: true,
        // When `locations` is on, `loc` properties holding objects with
        // `start` and `end` properties in `{line, column}` form (with
        // line being 1-based and column 0-based) will be attached to the
        // nodes.
        locations: false,
        // A function can be passed as `onToken` option, which will
        // cause Acorn to call that function with object in the same
        // format as tokens returned from `tokenizer().getToken()`. Note
        // that you are not allowed to call the parser from the
        // callback—that will corrupt its internal state.
        onToken: null,
        // A function can be passed as `onComment` option, which will
        // cause Acorn to call that function with `(block, text, start,
        // end)` parameters whenever a comment is skipped. `block` is a
        // boolean indicating whether this is a block (`/* */`) comment,
        // `text` is the content of the comment, and `start` and `end` are
        // character offsets that denote the start and end of the comment.
        // When the `locations` option is on, two more parameters are
        // passed, the full `{line, column}` locations of the start and
        // end of the comments. Note that you are not allowed to call the
        // parser from the callback—that will corrupt its internal state.
        // When this option has an array as value, objects representing the
        // comments are pushed to it.
        onComment: null,
        // Nodes have their start and end characters offsets recorded in
        // `start` and `end` properties (directly on the node, rather than
        // the `loc` object, which holds line/column data. To also add a
        // [semi-standardized][range] `range` property holding a `[start,
        // end]` array with the same numbers, set the `ranges` option to
        // `true`.
        //
        // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
        ranges: false,
        // It is possible to parse multiple files into a single AST by
        // passing the tree produced by parsing the first file as
        // `program` option in subsequent parses. This will add the
        // toplevel forms of the parsed file to the `Program` (top) node
        // of an existing parse tree.
        program: null,
        // When `locations` is on, you can pass this to record the source
        // file in every node's `loc` object.
        sourceFile: null,
        // This value, if given, is stored in every node, whether
        // `locations` is on or off.
        directSourceFile: null,
        // When enabled, parenthesized expressions are represented by
        // (non-standard) ParenthesizedExpression nodes
        preserveParens: false
      };
      var warnedAboutEcmaVersion = false;
      function getOptions(opts) {
        var options = {};
        for (var opt in defaultOptions) {
          options[opt] = opts && hasOwn(opts, opt) ? opts[opt] : defaultOptions[opt];
        }
        if (options.ecmaVersion === "latest") {
          options.ecmaVersion = 1e8;
        } else if (options.ecmaVersion == null) {
          if (!warnedAboutEcmaVersion && typeof console === "object" && console.warn) {
            warnedAboutEcmaVersion = true;
            console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.");
          }
          options.ecmaVersion = 11;
        } else if (options.ecmaVersion >= 2015) {
          options.ecmaVersion -= 2009;
        }
        if (options.allowReserved == null) {
          options.allowReserved = options.ecmaVersion < 5;
        }
        if (!opts || opts.allowHashBang == null) {
          options.allowHashBang = options.ecmaVersion >= 14;
        }
        if (isArray(options.onToken)) {
          var tokens = options.onToken;
          options.onToken = function(token) {
            return tokens.push(token);
          };
        }
        if (isArray(options.onComment)) {
          options.onComment = pushComment(options, options.onComment);
        }
        return options;
      }
      function pushComment(options, array) {
        return function(block, text, start, end, startLoc, endLoc) {
          var comment2 = {
            type: block ? "Block" : "Line",
            value: text,
            start,
            end
          };
          if (options.locations) {
            comment2.loc = new SourceLocation(this, startLoc, endLoc);
          }
          if (options.ranges) {
            comment2.range = [start, end];
          }
          array.push(comment2);
        };
      }
      var SCOPE_TOP = 1, SCOPE_FUNCTION = 2, SCOPE_ASYNC = 4, SCOPE_GENERATOR = 8, SCOPE_ARROW = 16, SCOPE_SIMPLE_CATCH = 32, SCOPE_SUPER = 64, SCOPE_DIRECT_SUPER = 128, SCOPE_CLASS_STATIC_BLOCK = 256, SCOPE_CLASS_FIELD_INIT = 512, SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK;
      function functionFlags(async2, generator) {
        return SCOPE_FUNCTION | (async2 ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0);
      }
      var BIND_NONE = 0, BIND_VAR = 1, BIND_LEXICAL = 2, BIND_FUNCTION = 3, BIND_SIMPLE_CATCH = 4, BIND_OUTSIDE = 5;
      var Parser = function Parser2(options, input, startPos) {
        this.options = options = getOptions(options);
        this.sourceFile = options.sourceFile;
        this.keywords = wordsRegexp(keywords$1[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
        var reserved = "";
        if (options.allowReserved !== true) {
          reserved = reservedWords[options.ecmaVersion >= 6 ? 6 : options.ecmaVersion === 5 ? 5 : 3];
          if (options.sourceType === "module") {
            reserved += " await";
          }
        }
        this.reservedWords = wordsRegexp(reserved);
        var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
        this.reservedWordsStrict = wordsRegexp(reservedStrict);
        this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind);
        this.input = String(input);
        this.containsEsc = false;
        if (startPos) {
          this.pos = startPos;
          this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
          this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
        } else {
          this.pos = this.lineStart = 0;
          this.curLine = 1;
        }
        this.type = types$1.eof;
        this.value = null;
        this.start = this.end = this.pos;
        this.startLoc = this.endLoc = this.curPosition();
        this.lastTokEndLoc = this.lastTokStartLoc = null;
        this.lastTokStart = this.lastTokEnd = this.pos;
        this.context = this.initialContext();
        this.exprAllowed = true;
        this.inModule = options.sourceType === "module";
        this.strict = this.inModule || this.strictDirective(this.pos);
        this.potentialArrowAt = -1;
        this.potentialArrowInForAwait = false;
        this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
        this.labels = [];
        this.undefinedExports = /* @__PURE__ */ Object.create(null);
        if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!") {
          this.skipLineComment(2);
        }
        this.scopeStack = [];
        this.enterScope(SCOPE_TOP);
        this.regexpState = null;
        this.privateNameStack = [];
      };
      var prototypeAccessors = { inFunction: { configurable: true }, inGenerator: { configurable: true }, inAsync: { configurable: true }, canAwait: { configurable: true }, allowSuper: { configurable: true }, allowDirectSuper: { configurable: true }, treatFunctionsAsVar: { configurable: true }, allowNewDotTarget: { configurable: true }, inClassStaticBlock: { configurable: true } };
      Parser.prototype.parse = function parse2() {
        var node2 = this.options.program || this.startNode();
        this.nextToken();
        return this.parseTopLevel(node2);
      };
      prototypeAccessors.inFunction.get = function() {
        return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0;
      };
      prototypeAccessors.inGenerator.get = function() {
        return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0;
      };
      prototypeAccessors.inAsync.get = function() {
        return (this.currentVarScope().flags & SCOPE_ASYNC) > 0;
      };
      prototypeAccessors.canAwait.get = function() {
        for (var i3 = this.scopeStack.length - 1; i3 >= 0; i3--) {
          var ref3 = this.scopeStack[i3];
          var flags2 = ref3.flags;
          if (flags2 & (SCOPE_CLASS_STATIC_BLOCK | SCOPE_CLASS_FIELD_INIT)) {
            return false;
          }
          if (flags2 & SCOPE_FUNCTION) {
            return (flags2 & SCOPE_ASYNC) > 0;
          }
        }
        return this.inModule && this.options.ecmaVersion >= 13 || this.options.allowAwaitOutsideFunction;
      };
      prototypeAccessors.allowSuper.get = function() {
        var ref3 = this.currentThisScope();
        var flags2 = ref3.flags;
        return (flags2 & SCOPE_SUPER) > 0 || this.options.allowSuperOutsideMethod;
      };
      prototypeAccessors.allowDirectSuper.get = function() {
        return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0;
      };
      prototypeAccessors.treatFunctionsAsVar.get = function() {
        return this.treatFunctionsAsVarInScope(this.currentScope());
      };
      prototypeAccessors.allowNewDotTarget.get = function() {
        for (var i3 = this.scopeStack.length - 1; i3 >= 0; i3--) {
          var ref3 = this.scopeStack[i3];
          var flags2 = ref3.flags;
          if (flags2 & (SCOPE_CLASS_STATIC_BLOCK | SCOPE_CLASS_FIELD_INIT) || flags2 & SCOPE_FUNCTION && !(flags2 & SCOPE_ARROW)) {
            return true;
          }
        }
        return false;
      };
      prototypeAccessors.inClassStaticBlock.get = function() {
        return (this.currentVarScope().flags & SCOPE_CLASS_STATIC_BLOCK) > 0;
      };
      Parser.extend = function extend() {
        var plugins = [], len = arguments.length;
        while (len--) plugins[len] = arguments[len];
        var cls = this;
        for (var i3 = 0; i3 < plugins.length; i3++) {
          cls = plugins[i3](cls);
        }
        return cls;
      };
      Parser.parse = function parse2(input, options) {
        return new this(options, input).parse();
      };
      Parser.parseExpressionAt = function parseExpressionAt2(input, pos, options) {
        var parser = new this(options, input, pos);
        parser.nextToken();
        return parser.parseExpression();
      };
      Parser.tokenizer = function tokenizer2(input, options) {
        return new this(options, input);
      };
      Object.defineProperties(Parser.prototype, prototypeAccessors);
      var pp$9 = Parser.prototype;
      var literal = /^(?:'((?:\\[^]|[^'\\])*?)'|"((?:\\[^]|[^"\\])*?)")/;
      pp$9.strictDirective = function(start) {
        if (this.options.ecmaVersion < 5) {
          return false;
        }
        for (; ; ) {
          skipWhiteSpace.lastIndex = start;
          start += skipWhiteSpace.exec(this.input)[0].length;
          var match = literal.exec(this.input.slice(start));
          if (!match) {
            return false;
          }
          if ((match[1] || match[2]) === "use strict") {
            skipWhiteSpace.lastIndex = start + match[0].length;
            var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
            var next = this.input.charAt(end);
            return next === ";" || next === "}" || lineBreak.test(spaceAfter[0]) && !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "=");
          }
          start += match[0].length;
          skipWhiteSpace.lastIndex = start;
          start += skipWhiteSpace.exec(this.input)[0].length;
          if (this.input[start] === ";") {
            start++;
          }
        }
      };
      pp$9.eat = function(type2) {
        if (this.type === type2) {
          this.next();
          return true;
        } else {
          return false;
        }
      };
      pp$9.isContextual = function(name) {
        return this.type === types$1.name && this.value === name && !this.containsEsc;
      };
      pp$9.eatContextual = function(name) {
        if (!this.isContextual(name)) {
          return false;
        }
        this.next();
        return true;
      };
      pp$9.expectContextual = function(name) {
        if (!this.eatContextual(name)) {
          this.unexpected();
        }
      };
      pp$9.canInsertSemicolon = function() {
        return this.type === types$1.eof || this.type === types$1.braceR || lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
      };
      pp$9.insertSemicolon = function() {
        if (this.canInsertSemicolon()) {
          if (this.options.onInsertedSemicolon) {
            this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc);
          }
          return true;
        }
      };
      pp$9.semicolon = function() {
        if (!this.eat(types$1.semi) && !this.insertSemicolon()) {
          this.unexpected();
        }
      };
      pp$9.afterTrailingComma = function(tokType, notNext) {
        if (this.type === tokType) {
          if (this.options.onTrailingComma) {
            this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc);
          }
          if (!notNext) {
            this.next();
          }
          return true;
        }
      };
      pp$9.expect = function(type2) {
        this.eat(type2) || this.unexpected();
      };
      pp$9.unexpected = function(pos) {
        this.raise(pos != null ? pos : this.start, "Unexpected token");
      };
      var DestructuringErrors = function DestructuringErrors2() {
        this.shorthandAssign = this.trailingComma = this.parenthesizedAssign = this.parenthesizedBind = this.doubleProto = -1;
      };
      pp$9.checkPatternErrors = function(refDestructuringErrors, isAssign) {
        if (!refDestructuringErrors) {
          return;
        }
        if (refDestructuringErrors.trailingComma > -1) {
          this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element");
        }
        var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
        if (parens > -1) {
          this.raiseRecoverable(parens, isAssign ? "Assigning to rvalue" : "Parenthesized pattern");
        }
      };
      pp$9.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
        if (!refDestructuringErrors) {
          return false;
        }
        var shorthandAssign = refDestructuringErrors.shorthandAssign;
        var doubleProto = refDestructuringErrors.doubleProto;
        if (!andThrow) {
          return shorthandAssign >= 0 || doubleProto >= 0;
        }
        if (shorthandAssign >= 0) {
          this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns");
        }
        if (doubleProto >= 0) {
          this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property");
        }
      };
      pp$9.checkYieldAwaitInDefaultParams = function() {
        if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos)) {
          this.raise(this.yieldPos, "Yield expression cannot be a default value");
        }
        if (this.awaitPos) {
          this.raise(this.awaitPos, "Await expression cannot be a default value");
        }
      };
      pp$9.isSimpleAssignTarget = function(expr) {
        if (expr.type === "ParenthesizedExpression") {
          return this.isSimpleAssignTarget(expr.expression);
        }
        return expr.type === "Identifier" || expr.type === "MemberExpression";
      };
      var pp$8 = Parser.prototype;
      pp$8.parseTopLevel = function(node2) {
        var exports3 = /* @__PURE__ */ Object.create(null);
        if (!node2.body) {
          node2.body = [];
        }
        while (this.type !== types$1.eof) {
          var stmt = this.parseStatement(null, true, exports3);
          node2.body.push(stmt);
        }
        if (this.inModule) {
          for (var i3 = 0, list2 = Object.keys(this.undefinedExports); i3 < list2.length; i3 += 1) {
            var name = list2[i3];
            this.raiseRecoverable(this.undefinedExports[name].start, "Export '" + name + "' is not defined");
          }
        }
        this.adaptDirectivePrologue(node2.body);
        this.next();
        node2.sourceType = this.options.sourceType;
        return this.finishNode(node2, "Program");
      };
      var loopLabel = { kind: "loop" }, switchLabel = { kind: "switch" };
      pp$8.isLet = function(context) {
        if (this.options.ecmaVersion < 6 || !this.isContextual("let")) {
          return false;
        }
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
        if (nextCh === 91 || nextCh === 92) {
          return true;
        }
        if (context) {
          return false;
        }
        if (nextCh === 123 || nextCh > 55295 && nextCh < 56320) {
          return true;
        }
        if (isIdentifierStart(nextCh, true)) {
          var pos = next + 1;
          while (isIdentifierChar(nextCh = this.input.charCodeAt(pos), true)) {
            ++pos;
          }
          if (nextCh === 92 || nextCh > 55295 && nextCh < 56320) {
            return true;
          }
          var ident = this.input.slice(next, pos);
          if (!keywordRelationalOperator.test(ident)) {
            return true;
          }
        }
        return false;
      };
      pp$8.isAsyncFunction = function() {
        if (this.options.ecmaVersion < 8 || !this.isContextual("async")) {
          return false;
        }
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length, after;
        return !lineBreak.test(this.input.slice(this.pos, next)) && this.input.slice(next, next + 8) === "function" && (next + 8 === this.input.length || !(isIdentifierChar(after = this.input.charCodeAt(next + 8)) || after > 55295 && after < 56320));
      };
      pp$8.isUsingKeyword = function(isAwaitUsing, isFor) {
        if (this.options.ecmaVersion < 17 || !this.isContextual(isAwaitUsing ? "await" : "using")) {
          return false;
        }
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length;
        if (lineBreak.test(this.input.slice(this.pos, next))) {
          return false;
        }
        if (isAwaitUsing) {
          var awaitEndPos = next + 5, after;
          if (this.input.slice(next, awaitEndPos) !== "using" || awaitEndPos === this.input.length || isIdentifierChar(after = this.input.charCodeAt(awaitEndPos)) || after > 55295 && after < 56320) {
            return false;
          }
          skipWhiteSpace.lastIndex = awaitEndPos;
          var skipAfterUsing = skipWhiteSpace.exec(this.input);
          if (skipAfterUsing && lineBreak.test(this.input.slice(awaitEndPos, awaitEndPos + skipAfterUsing[0].length))) {
            return false;
          }
        }
        if (isFor) {
          var ofEndPos = next + 2, after$1;
          if (this.input.slice(next, ofEndPos) === "of") {
            if (ofEndPos === this.input.length || !isIdentifierChar(after$1 = this.input.charCodeAt(ofEndPos)) && !(after$1 > 55295 && after$1 < 56320)) {
              return false;
            }
          }
        }
        var ch = this.input.charCodeAt(next);
        return isIdentifierStart(ch, true) || ch === 92;
      };
      pp$8.isAwaitUsing = function(isFor) {
        return this.isUsingKeyword(true, isFor);
      };
      pp$8.isUsing = function(isFor) {
        return this.isUsingKeyword(false, isFor);
      };
      pp$8.parseStatement = function(context, topLevel, exports3) {
        var starttype = this.type, node2 = this.startNode(), kind;
        if (this.isLet(context)) {
          starttype = types$1._var;
          kind = "let";
        }
        switch (starttype) {
          case types$1._break:
          case types$1._continue:
            return this.parseBreakContinueStatement(node2, starttype.keyword);
          case types$1._debugger:
            return this.parseDebuggerStatement(node2);
          case types$1._do:
            return this.parseDoStatement(node2);
          case types$1._for:
            return this.parseForStatement(node2);
          case types$1._function:
            if (context && (this.strict || context !== "if" && context !== "label") && this.options.ecmaVersion >= 6) {
              this.unexpected();
            }
            return this.parseFunctionStatement(node2, false, !context);
          case types$1._class:
            if (context) {
              this.unexpected();
            }
            return this.parseClass(node2, true);
          case types$1._if:
            return this.parseIfStatement(node2);
          case types$1._return:
            return this.parseReturnStatement(node2);
          case types$1._switch:
            return this.parseSwitchStatement(node2);
          case types$1._throw:
            return this.parseThrowStatement(node2);
          case types$1._try:
            return this.parseTryStatement(node2);
          case types$1._const:
          case types$1._var:
            kind = kind || this.value;
            if (context && kind !== "var") {
              this.unexpected();
            }
            return this.parseVarStatement(node2, kind);
          case types$1._while:
            return this.parseWhileStatement(node2);
          case types$1._with:
            return this.parseWithStatement(node2);
          case types$1.braceL:
            return this.parseBlock(true, node2);
          case types$1.semi:
            return this.parseEmptyStatement(node2);
          case types$1._export:
          case types$1._import:
            if (this.options.ecmaVersion > 10 && starttype === types$1._import) {
              skipWhiteSpace.lastIndex = this.pos;
              var skip = skipWhiteSpace.exec(this.input);
              var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
              if (nextCh === 40 || nextCh === 46) {
                return this.parseExpressionStatement(node2, this.parseExpression());
              }
            }
            if (!this.options.allowImportExportEverywhere) {
              if (!topLevel) {
                this.raise(this.start, "'import' and 'export' may only appear at the top level");
              }
              if (!this.inModule) {
                this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'");
              }
            }
            return starttype === types$1._import ? this.parseImport(node2) : this.parseExport(node2, exports3);
          // If the statement does not start with a statement keyword or a
          // brace, it's an ExpressionStatement or LabeledStatement. We
          // simply start parsing an expression, and afterwards, if the
          // next token is a colon and the expression was a simple
          // Identifier node, we switch to interpreting it as a label.
          default:
            if (this.isAsyncFunction()) {
              if (context) {
                this.unexpected();
              }
              this.next();
              return this.parseFunctionStatement(node2, true, !context);
            }
            var usingKind = this.isAwaitUsing(false) ? "await using" : this.isUsing(false) ? "using" : null;
            if (usingKind) {
              if (topLevel && this.options.sourceType === "script") {
                this.raise(this.start, "Using declaration cannot appear in the top level when source type is `script`");
              }
              if (usingKind === "await using") {
                if (!this.canAwait) {
                  this.raise(this.start, "Await using cannot appear outside of async function");
                }
                this.next();
              }
              this.next();
              this.parseVar(node2, false, usingKind);
              this.semicolon();
              return this.finishNode(node2, "VariableDeclaration");
            }
            var maybeName = this.value, expr = this.parseExpression();
            if (starttype === types$1.name && expr.type === "Identifier" && this.eat(types$1.colon)) {
              return this.parseLabeledStatement(node2, maybeName, expr, context);
            } else {
              return this.parseExpressionStatement(node2, expr);
            }
        }
      };
      pp$8.parseBreakContinueStatement = function(node2, keyword2) {
        var isBreak = keyword2 === "break";
        this.next();
        if (this.eat(types$1.semi) || this.insertSemicolon()) {
          node2.label = null;
        } else if (this.type !== types$1.name) {
          this.unexpected();
        } else {
          node2.label = this.parseIdent();
          this.semicolon();
        }
        var i3 = 0;
        for (; i3 < this.labels.length; ++i3) {
          var lab = this.labels[i3];
          if (node2.label == null || lab.name === node2.label.name) {
            if (lab.kind != null && (isBreak || lab.kind === "loop")) {
              break;
            }
            if (node2.label && isBreak) {
              break;
            }
          }
        }
        if (i3 === this.labels.length) {
          this.raise(node2.start, "Unsyntactic " + keyword2);
        }
        return this.finishNode(node2, isBreak ? "BreakStatement" : "ContinueStatement");
      };
      pp$8.parseDebuggerStatement = function(node2) {
        this.next();
        this.semicolon();
        return this.finishNode(node2, "DebuggerStatement");
      };
      pp$8.parseDoStatement = function(node2) {
        this.next();
        this.labels.push(loopLabel);
        node2.body = this.parseStatement("do");
        this.labels.pop();
        this.expect(types$1._while);
        node2.test = this.parseParenExpression();
        if (this.options.ecmaVersion >= 6) {
          this.eat(types$1.semi);
        } else {
          this.semicolon();
        }
        return this.finishNode(node2, "DoWhileStatement");
      };
      pp$8.parseForStatement = function(node2) {
        this.next();
        var awaitAt = this.options.ecmaVersion >= 9 && this.canAwait && this.eatContextual("await") ? this.lastTokStart : -1;
        this.labels.push(loopLabel);
        this.enterScope(0);
        this.expect(types$1.parenL);
        if (this.type === types$1.semi) {
          if (awaitAt > -1) {
            this.unexpected(awaitAt);
          }
          return this.parseFor(node2, null);
        }
        var isLet = this.isLet();
        if (this.type === types$1._var || this.type === types$1._const || isLet) {
          var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
          this.next();
          this.parseVar(init$1, true, kind);
          this.finishNode(init$1, "VariableDeclaration");
          return this.parseForAfterInit(node2, init$1, awaitAt);
        }
        var startsWithLet = this.isContextual("let"), isForOf = false;
        var usingKind = this.isUsing(true) ? "using" : this.isAwaitUsing(true) ? "await using" : null;
        if (usingKind) {
          var init$2 = this.startNode();
          this.next();
          if (usingKind === "await using") {
            this.next();
          }
          this.parseVar(init$2, true, usingKind);
          this.finishNode(init$2, "VariableDeclaration");
          return this.parseForAfterInit(node2, init$2, awaitAt);
        }
        var containsEsc = this.containsEsc;
        var refDestructuringErrors = new DestructuringErrors();
        var initPos = this.start;
        var init = awaitAt > -1 ? this.parseExprSubscripts(refDestructuringErrors, "await") : this.parseExpression(true, refDestructuringErrors);
        if (this.type === types$1._in || (isForOf = this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
          if (awaitAt > -1) {
            if (this.type === types$1._in) {
              this.unexpected(awaitAt);
            }
            node2.await = true;
          } else if (isForOf && this.options.ecmaVersion >= 8) {
            if (init.start === initPos && !containsEsc && init.type === "Identifier" && init.name === "async") {
              this.unexpected();
            } else if (this.options.ecmaVersion >= 9) {
              node2.await = false;
            }
          }
          if (startsWithLet && isForOf) {
            this.raise(init.start, "The left-hand side of a for-of loop may not start with 'let'.");
          }
          this.toAssignable(init, false, refDestructuringErrors);
          this.checkLValPattern(init);
          return this.parseForIn(node2, init);
        } else {
          this.checkExpressionErrors(refDestructuringErrors, true);
        }
        if (awaitAt > -1) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node2, init);
      };
      pp$8.parseForAfterInit = function(node2, init, awaitAt) {
        if ((this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) && init.declarations.length === 1) {
          if (this.options.ecmaVersion >= 9) {
            if (this.type === types$1._in) {
              if (awaitAt > -1) {
                this.unexpected(awaitAt);
              }
            } else {
              node2.await = awaitAt > -1;
            }
          }
          return this.parseForIn(node2, init);
        }
        if (awaitAt > -1) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node2, init);
      };
      pp$8.parseFunctionStatement = function(node2, isAsync, declarationPosition) {
        this.next();
        return this.parseFunction(node2, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync);
      };
      pp$8.parseIfStatement = function(node2) {
        this.next();
        node2.test = this.parseParenExpression();
        node2.consequent = this.parseStatement("if");
        node2.alternate = this.eat(types$1._else) ? this.parseStatement("if") : null;
        return this.finishNode(node2, "IfStatement");
      };
      pp$8.parseReturnStatement = function(node2) {
        if (!this.inFunction && !this.options.allowReturnOutsideFunction) {
          this.raise(this.start, "'return' outside of function");
        }
        this.next();
        if (this.eat(types$1.semi) || this.insertSemicolon()) {
          node2.argument = null;
        } else {
          node2.argument = this.parseExpression();
          this.semicolon();
        }
        return this.finishNode(node2, "ReturnStatement");
      };
      pp$8.parseSwitchStatement = function(node2) {
        this.next();
        node2.discriminant = this.parseParenExpression();
        node2.cases = [];
        this.expect(types$1.braceL);
        this.labels.push(switchLabel);
        this.enterScope(0);
        var cur;
        for (var sawDefault = false; this.type !== types$1.braceR; ) {
          if (this.type === types$1._case || this.type === types$1._default) {
            var isCase = this.type === types$1._case;
            if (cur) {
              this.finishNode(cur, "SwitchCase");
            }
            node2.cases.push(cur = this.startNode());
            cur.consequent = [];
            this.next();
            if (isCase) {
              cur.test = this.parseExpression();
            } else {
              if (sawDefault) {
                this.raiseRecoverable(this.lastTokStart, "Multiple default clauses");
              }
              sawDefault = true;
              cur.test = null;
            }
            this.expect(types$1.colon);
          } else {
            if (!cur) {
              this.unexpected();
            }
            cur.consequent.push(this.parseStatement(null));
          }
        }
        this.exitScope();
        if (cur) {
          this.finishNode(cur, "SwitchCase");
        }
        this.next();
        this.labels.pop();
        return this.finishNode(node2, "SwitchStatement");
      };
      pp$8.parseThrowStatement = function(node2) {
        this.next();
        if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) {
          this.raise(this.lastTokEnd, "Illegal newline after throw");
        }
        node2.argument = this.parseExpression();
        this.semicolon();
        return this.finishNode(node2, "ThrowStatement");
      };
      var empty$1 = [];
      pp$8.parseCatchClauseParam = function() {
        var param = this.parseBindingAtom();
        var simple = param.type === "Identifier";
        this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
        this.checkLValPattern(param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
        this.expect(types$1.parenR);
        return param;
      };
      pp$8.parseTryStatement = function(node2) {
        this.next();
        node2.block = this.parseBlock();
        node2.handler = null;
        if (this.type === types$1._catch) {
          var clause = this.startNode();
          this.next();
          if (this.eat(types$1.parenL)) {
            clause.param = this.parseCatchClauseParam();
          } else {
            if (this.options.ecmaVersion < 10) {
              this.unexpected();
            }
            clause.param = null;
            this.enterScope(0);
          }
          clause.body = this.parseBlock(false);
          this.exitScope();
          node2.handler = this.finishNode(clause, "CatchClause");
        }
        node2.finalizer = this.eat(types$1._finally) ? this.parseBlock() : null;
        if (!node2.handler && !node2.finalizer) {
          this.raise(node2.start, "Missing catch or finally clause");
        }
        return this.finishNode(node2, "TryStatement");
      };
      pp$8.parseVarStatement = function(node2, kind, allowMissingInitializer) {
        this.next();
        this.parseVar(node2, false, kind, allowMissingInitializer);
        this.semicolon();
        return this.finishNode(node2, "VariableDeclaration");
      };
      pp$8.parseWhileStatement = function(node2) {
        this.next();
        node2.test = this.parseParenExpression();
        this.labels.push(loopLabel);
        node2.body = this.parseStatement("while");
        this.labels.pop();
        return this.finishNode(node2, "WhileStatement");
      };
      pp$8.parseWithStatement = function(node2) {
        if (this.strict) {
          this.raise(this.start, "'with' in strict mode");
        }
        this.next();
        node2.object = this.parseParenExpression();
        node2.body = this.parseStatement("with");
        return this.finishNode(node2, "WithStatement");
      };
      pp$8.parseEmptyStatement = function(node2) {
        this.next();
        return this.finishNode(node2, "EmptyStatement");
      };
      pp$8.parseLabeledStatement = function(node2, maybeName, expr, context) {
        for (var i$1 = 0, list2 = this.labels; i$1 < list2.length; i$1 += 1) {
          var label = list2[i$1];
          if (label.name === maybeName) {
            this.raise(expr.start, "Label '" + maybeName + "' is already declared");
          }
        }
        var kind = this.type.isLoop ? "loop" : this.type === types$1._switch ? "switch" : null;
        for (var i3 = this.labels.length - 1; i3 >= 0; i3--) {
          var label$1 = this.labels[i3];
          if (label$1.statementStart === node2.start) {
            label$1.statementStart = this.start;
            label$1.kind = kind;
          } else {
            break;
          }
        }
        this.labels.push({ name: maybeName, kind, statementStart: this.start });
        node2.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
        this.labels.pop();
        node2.label = expr;
        return this.finishNode(node2, "LabeledStatement");
      };
      pp$8.parseExpressionStatement = function(node2, expr) {
        node2.expression = expr;
        this.semicolon();
        return this.finishNode(node2, "ExpressionStatement");
      };
      pp$8.parseBlock = function(createNewLexicalScope, node2, exitStrict) {
        if (createNewLexicalScope === void 0) createNewLexicalScope = true;
        if (node2 === void 0) node2 = this.startNode();
        node2.body = [];
        this.expect(types$1.braceL);
        if (createNewLexicalScope) {
          this.enterScope(0);
        }
        while (this.type !== types$1.braceR) {
          var stmt = this.parseStatement(null);
          node2.body.push(stmt);
        }
        if (exitStrict) {
          this.strict = false;
        }
        this.next();
        if (createNewLexicalScope) {
          this.exitScope();
        }
        return this.finishNode(node2, "BlockStatement");
      };
      pp$8.parseFor = function(node2, init) {
        node2.init = init;
        this.expect(types$1.semi);
        node2.test = this.type === types$1.semi ? null : this.parseExpression();
        this.expect(types$1.semi);
        node2.update = this.type === types$1.parenR ? null : this.parseExpression();
        this.expect(types$1.parenR);
        node2.body = this.parseStatement("for");
        this.exitScope();
        this.labels.pop();
        return this.finishNode(node2, "ForStatement");
      };
      pp$8.parseForIn = function(node2, init) {
        var isForIn = this.type === types$1._in;
        this.next();
        if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || this.options.ecmaVersion < 8 || this.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) {
          this.raise(
            init.start,
            (isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer"
          );
        }
        node2.left = init;
        node2.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
        this.expect(types$1.parenR);
        node2.body = this.parseStatement("for");
        this.exitScope();
        this.labels.pop();
        return this.finishNode(node2, isForIn ? "ForInStatement" : "ForOfStatement");
      };
      pp$8.parseVar = function(node2, isFor, kind, allowMissingInitializer) {
        node2.declarations = [];
        node2.kind = kind;
        for (; ; ) {
          var decl = this.startNode();
          this.parseVarId(decl, kind);
          if (this.eat(types$1.eq)) {
            decl.init = this.parseMaybeAssign(isFor);
          } else if (!allowMissingInitializer && kind === "const" && !(this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
            this.unexpected();
          } else if (!allowMissingInitializer && (kind === "using" || kind === "await using") && this.options.ecmaVersion >= 17 && this.type !== types$1._in && !this.isContextual("of")) {
            this.raise(this.lastTokEnd, "Missing initializer in " + kind + " declaration");
          } else if (!allowMissingInitializer && decl.id.type !== "Identifier" && !(isFor && (this.type === types$1._in || this.isContextual("of")))) {
            this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
          } else {
            decl.init = null;
          }
          node2.declarations.push(this.finishNode(decl, "VariableDeclarator"));
          if (!this.eat(types$1.comma)) {
            break;
          }
        }
        return node2;
      };
      pp$8.parseVarId = function(decl, kind) {
        decl.id = kind === "using" || kind === "await using" ? this.parseIdent() : this.parseBindingAtom();
        this.checkLValPattern(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
      };
      var FUNC_STATEMENT = 1, FUNC_HANGING_STATEMENT = 2, FUNC_NULLABLE_ID = 4;
      pp$8.parseFunction = function(node2, statement, allowExpressionBody, isAsync, forInit) {
        this.initFunction(node2);
        if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
          if (this.type === types$1.star && statement & FUNC_HANGING_STATEMENT) {
            this.unexpected();
          }
          node2.generator = this.eat(types$1.star);
        }
        if (this.options.ecmaVersion >= 8) {
          node2.async = !!isAsync;
        }
        if (statement & FUNC_STATEMENT) {
          node2.id = statement & FUNC_NULLABLE_ID && this.type !== types$1.name ? null : this.parseIdent();
          if (node2.id && !(statement & FUNC_HANGING_STATEMENT)) {
            this.checkLValSimple(node2.id, this.strict || node2.generator || node2.async ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION);
          }
        }
        var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        this.enterScope(functionFlags(node2.async, node2.generator));
        if (!(statement & FUNC_STATEMENT)) {
          node2.id = this.type === types$1.name ? this.parseIdent() : null;
        }
        this.parseFunctionParams(node2);
        this.parseFunctionBody(node2, allowExpressionBody, false, forInit);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node2, statement & FUNC_STATEMENT ? "FunctionDeclaration" : "FunctionExpression");
      };
      pp$8.parseFunctionParams = function(node2) {
        this.expect(types$1.parenL);
        node2.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
        this.checkYieldAwaitInDefaultParams();
      };
      pp$8.parseClass = function(node2, isStatement) {
        this.next();
        var oldStrict = this.strict;
        this.strict = true;
        this.parseClassId(node2, isStatement);
        this.parseClassSuper(node2);
        var privateNameMap = this.enterClassBody();
        var classBody = this.startNode();
        var hadConstructor = false;
        classBody.body = [];
        this.expect(types$1.braceL);
        while (this.type !== types$1.braceR) {
          var element = this.parseClassElement(node2.superClass !== null);
          if (element) {
            classBody.body.push(element);
            if (element.type === "MethodDefinition" && element.kind === "constructor") {
              if (hadConstructor) {
                this.raiseRecoverable(element.start, "Duplicate constructor in the same class");
              }
              hadConstructor = true;
            } else if (element.key && element.key.type === "PrivateIdentifier" && isPrivateNameConflicted(privateNameMap, element)) {
              this.raiseRecoverable(element.key.start, "Identifier '#" + element.key.name + "' has already been declared");
            }
          }
        }
        this.strict = oldStrict;
        this.next();
        node2.body = this.finishNode(classBody, "ClassBody");
        this.exitClassBody();
        return this.finishNode(node2, isStatement ? "ClassDeclaration" : "ClassExpression");
      };
      pp$8.parseClassElement = function(constructorAllowsSuper) {
        if (this.eat(types$1.semi)) {
          return null;
        }
        var ecmaVersion3 = this.options.ecmaVersion;
        var node2 = this.startNode();
        var keyName = "";
        var isGenerator = false;
        var isAsync = false;
        var kind = "method";
        var isStatic = false;
        if (this.eatContextual("static")) {
          if (ecmaVersion3 >= 13 && this.eat(types$1.braceL)) {
            this.parseClassStaticBlock(node2);
            return node2;
          }
          if (this.isClassElementNameStart() || this.type === types$1.star) {
            isStatic = true;
          } else {
            keyName = "static";
          }
        }
        node2.static = isStatic;
        if (!keyName && ecmaVersion3 >= 8 && this.eatContextual("async")) {
          if ((this.isClassElementNameStart() || this.type === types$1.star) && !this.canInsertSemicolon()) {
            isAsync = true;
          } else {
            keyName = "async";
          }
        }
        if (!keyName && (ecmaVersion3 >= 9 || !isAsync) && this.eat(types$1.star)) {
          isGenerator = true;
        }
        if (!keyName && !isAsync && !isGenerator) {
          var lastValue = this.value;
          if (this.eatContextual("get") || this.eatContextual("set")) {
            if (this.isClassElementNameStart()) {
              kind = lastValue;
            } else {
              keyName = lastValue;
            }
          }
        }
        if (keyName) {
          node2.computed = false;
          node2.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc);
          node2.key.name = keyName;
          this.finishNode(node2.key, "Identifier");
        } else {
          this.parseClassElementName(node2);
        }
        if (ecmaVersion3 < 13 || this.type === types$1.parenL || kind !== "method" || isGenerator || isAsync) {
          var isConstructor = !node2.static && checkKeyName(node2, "constructor");
          var allowsDirectSuper = isConstructor && constructorAllowsSuper;
          if (isConstructor && kind !== "method") {
            this.raise(node2.key.start, "Constructor can't have get/set modifier");
          }
          node2.kind = isConstructor ? "constructor" : kind;
          this.parseClassMethod(node2, isGenerator, isAsync, allowsDirectSuper);
        } else {
          this.parseClassField(node2);
        }
        return node2;
      };
      pp$8.isClassElementNameStart = function() {
        return this.type === types$1.name || this.type === types$1.privateId || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword;
      };
      pp$8.parseClassElementName = function(element) {
        if (this.type === types$1.privateId) {
          if (this.value === "constructor") {
            this.raise(this.start, "Classes can't have an element named '#constructor'");
          }
          element.computed = false;
          element.key = this.parsePrivateIdent();
        } else {
          this.parsePropertyName(element);
        }
      };
      pp$8.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
        var key = method.key;
        if (method.kind === "constructor") {
          if (isGenerator) {
            this.raise(key.start, "Constructor can't be a generator");
          }
          if (isAsync) {
            this.raise(key.start, "Constructor can't be an async method");
          }
        } else if (method.static && checkKeyName(method, "prototype")) {
          this.raise(key.start, "Classes may not have a static property named prototype");
        }
        var value = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);
        if (method.kind === "get" && value.params.length !== 0) {
          this.raiseRecoverable(value.start, "getter should have no params");
        }
        if (method.kind === "set" && value.params.length !== 1) {
          this.raiseRecoverable(value.start, "setter should have exactly one param");
        }
        if (method.kind === "set" && value.params[0].type === "RestElement") {
          this.raiseRecoverable(value.params[0].start, "Setter cannot use rest params");
        }
        return this.finishNode(method, "MethodDefinition");
      };
      pp$8.parseClassField = function(field) {
        if (checkKeyName(field, "constructor")) {
          this.raise(field.key.start, "Classes can't have a field named 'constructor'");
        } else if (field.static && checkKeyName(field, "prototype")) {
          this.raise(field.key.start, "Classes can't have a static field named 'prototype'");
        }
        if (this.eat(types$1.eq)) {
          this.enterScope(SCOPE_CLASS_FIELD_INIT | SCOPE_SUPER);
          field.value = this.parseMaybeAssign();
          this.exitScope();
        } else {
          field.value = null;
        }
        this.semicolon();
        return this.finishNode(field, "PropertyDefinition");
      };
      pp$8.parseClassStaticBlock = function(node2) {
        node2.body = [];
        var oldLabels = this.labels;
        this.labels = [];
        this.enterScope(SCOPE_CLASS_STATIC_BLOCK | SCOPE_SUPER);
        while (this.type !== types$1.braceR) {
          var stmt = this.parseStatement(null);
          node2.body.push(stmt);
        }
        this.next();
        this.exitScope();
        this.labels = oldLabels;
        return this.finishNode(node2, "StaticBlock");
      };
      pp$8.parseClassId = function(node2, isStatement) {
        if (this.type === types$1.name) {
          node2.id = this.parseIdent();
          if (isStatement) {
            this.checkLValSimple(node2.id, BIND_LEXICAL, false);
          }
        } else {
          if (isStatement === true) {
            this.unexpected();
          }
          node2.id = null;
        }
      };
      pp$8.parseClassSuper = function(node2) {
        node2.superClass = this.eat(types$1._extends) ? this.parseExprSubscripts(null, false) : null;
      };
      pp$8.enterClassBody = function() {
        var element = { declared: /* @__PURE__ */ Object.create(null), used: [] };
        this.privateNameStack.push(element);
        return element.declared;
      };
      pp$8.exitClassBody = function() {
        var ref3 = this.privateNameStack.pop();
        var declared = ref3.declared;
        var used = ref3.used;
        if (!this.options.checkPrivateFields) {
          return;
        }
        var len = this.privateNameStack.length;
        var parent = len === 0 ? null : this.privateNameStack[len - 1];
        for (var i3 = 0; i3 < used.length; ++i3) {
          var id2 = used[i3];
          if (!hasOwn(declared, id2.name)) {
            if (parent) {
              parent.used.push(id2);
            } else {
              this.raiseRecoverable(id2.start, "Private field '#" + id2.name + "' must be declared in an enclosing class");
            }
          }
        }
      };
      function isPrivateNameConflicted(privateNameMap, element) {
        var name = element.key.name;
        var curr = privateNameMap[name];
        var next = "true";
        if (element.type === "MethodDefinition" && (element.kind === "get" || element.kind === "set")) {
          next = (element.static ? "s" : "i") + element.kind;
        }
        if (curr === "iget" && next === "iset" || curr === "iset" && next === "iget" || curr === "sget" && next === "sset" || curr === "sset" && next === "sget") {
          privateNameMap[name] = "true";
          return false;
        } else if (!curr) {
          privateNameMap[name] = next;
          return false;
        } else {
          return true;
        }
      }
      function checkKeyName(node2, name) {
        var computed = node2.computed;
        var key = node2.key;
        return !computed && (key.type === "Identifier" && key.name === name || key.type === "Literal" && key.value === name);
      }
      pp$8.parseExportAllDeclaration = function(node2, exports3) {
        if (this.options.ecmaVersion >= 11) {
          if (this.eatContextual("as")) {
            node2.exported = this.parseModuleExportName();
            this.checkExport(exports3, node2.exported, this.lastTokStart);
          } else {
            node2.exported = null;
          }
        }
        this.expectContextual("from");
        if (this.type !== types$1.string) {
          this.unexpected();
        }
        node2.source = this.parseExprAtom();
        if (this.options.ecmaVersion >= 16) {
          node2.attributes = this.parseWithClause();
        }
        this.semicolon();
        return this.finishNode(node2, "ExportAllDeclaration");
      };
      pp$8.parseExport = function(node2, exports3) {
        this.next();
        if (this.eat(types$1.star)) {
          return this.parseExportAllDeclaration(node2, exports3);
        }
        if (this.eat(types$1._default)) {
          this.checkExport(exports3, "default", this.lastTokStart);
          node2.declaration = this.parseExportDefaultDeclaration();
          return this.finishNode(node2, "ExportDefaultDeclaration");
        }
        if (this.shouldParseExportStatement()) {
          node2.declaration = this.parseExportDeclaration(node2);
          if (node2.declaration.type === "VariableDeclaration") {
            this.checkVariableExport(exports3, node2.declaration.declarations);
          } else {
            this.checkExport(exports3, node2.declaration.id, node2.declaration.id.start);
          }
          node2.specifiers = [];
          node2.source = null;
          if (this.options.ecmaVersion >= 16) {
            node2.attributes = [];
          }
        } else {
          node2.declaration = null;
          node2.specifiers = this.parseExportSpecifiers(exports3);
          if (this.eatContextual("from")) {
            if (this.type !== types$1.string) {
              this.unexpected();
            }
            node2.source = this.parseExprAtom();
            if (this.options.ecmaVersion >= 16) {
              node2.attributes = this.parseWithClause();
            }
          } else {
            for (var i3 = 0, list2 = node2.specifiers; i3 < list2.length; i3 += 1) {
              var spec = list2[i3];
              this.checkUnreserved(spec.local);
              this.checkLocalExport(spec.local);
              if (spec.local.type === "Literal") {
                this.raise(spec.local.start, "A string literal cannot be used as an exported binding without `from`.");
              }
            }
            node2.source = null;
            if (this.options.ecmaVersion >= 16) {
              node2.attributes = [];
            }
          }
          this.semicolon();
        }
        return this.finishNode(node2, "ExportNamedDeclaration");
      };
      pp$8.parseExportDeclaration = function(node2) {
        return this.parseStatement(null);
      };
      pp$8.parseExportDefaultDeclaration = function() {
        var isAsync;
        if (this.type === types$1._function || (isAsync = this.isAsyncFunction())) {
          var fNode = this.startNode();
          this.next();
          if (isAsync) {
            this.next();
          }
          return this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync);
        } else if (this.type === types$1._class) {
          var cNode = this.startNode();
          return this.parseClass(cNode, "nullableID");
        } else {
          var declaration = this.parseMaybeAssign();
          this.semicolon();
          return declaration;
        }
      };
      pp$8.checkExport = function(exports3, name, pos) {
        if (!exports3) {
          return;
        }
        if (typeof name !== "string") {
          name = name.type === "Identifier" ? name.name : name.value;
        }
        if (hasOwn(exports3, name)) {
          this.raiseRecoverable(pos, "Duplicate export '" + name + "'");
        }
        exports3[name] = true;
      };
      pp$8.checkPatternExport = function(exports3, pat) {
        var type2 = pat.type;
        if (type2 === "Identifier") {
          this.checkExport(exports3, pat, pat.start);
        } else if (type2 === "ObjectPattern") {
          for (var i3 = 0, list2 = pat.properties; i3 < list2.length; i3 += 1) {
            var prop = list2[i3];
            this.checkPatternExport(exports3, prop);
          }
        } else if (type2 === "ArrayPattern") {
          for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
            var elt = list$1[i$1];
            if (elt) {
              this.checkPatternExport(exports3, elt);
            }
          }
        } else if (type2 === "Property") {
          this.checkPatternExport(exports3, pat.value);
        } else if (type2 === "AssignmentPattern") {
          this.checkPatternExport(exports3, pat.left);
        } else if (type2 === "RestElement") {
          this.checkPatternExport(exports3, pat.argument);
        }
      };
      pp$8.checkVariableExport = function(exports3, decls) {
        if (!exports3) {
          return;
        }
        for (var i3 = 0, list2 = decls; i3 < list2.length; i3 += 1) {
          var decl = list2[i3];
          this.checkPatternExport(exports3, decl.id);
        }
      };
      pp$8.shouldParseExportStatement = function() {
        return this.type.keyword === "var" || this.type.keyword === "const" || this.type.keyword === "class" || this.type.keyword === "function" || this.isLet() || this.isAsyncFunction();
      };
      pp$8.parseExportSpecifier = function(exports3) {
        var node2 = this.startNode();
        node2.local = this.parseModuleExportName();
        node2.exported = this.eatContextual("as") ? this.parseModuleExportName() : node2.local;
        this.checkExport(
          exports3,
          node2.exported,
          node2.exported.start
        );
        return this.finishNode(node2, "ExportSpecifier");
      };
      pp$8.parseExportSpecifiers = function(exports3) {
        var nodes = [], first = true;
        this.expect(types$1.braceL);
        while (!this.eat(types$1.braceR)) {
          if (!first) {
            this.expect(types$1.comma);
            if (this.afterTrailingComma(types$1.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          nodes.push(this.parseExportSpecifier(exports3));
        }
        return nodes;
      };
      pp$8.parseImport = function(node2) {
        this.next();
        if (this.type === types$1.string) {
          node2.specifiers = empty$1;
          node2.source = this.parseExprAtom();
        } else {
          node2.specifiers = this.parseImportSpecifiers();
          this.expectContextual("from");
          node2.source = this.type === types$1.string ? this.parseExprAtom() : this.unexpected();
        }
        if (this.options.ecmaVersion >= 16) {
          node2.attributes = this.parseWithClause();
        }
        this.semicolon();
        return this.finishNode(node2, "ImportDeclaration");
      };
      pp$8.parseImportSpecifier = function() {
        var node2 = this.startNode();
        node2.imported = this.parseModuleExportName();
        if (this.eatContextual("as")) {
          node2.local = this.parseIdent();
        } else {
          this.checkUnreserved(node2.imported);
          node2.local = node2.imported;
        }
        this.checkLValSimple(node2.local, BIND_LEXICAL);
        return this.finishNode(node2, "ImportSpecifier");
      };
      pp$8.parseImportDefaultSpecifier = function() {
        var node2 = this.startNode();
        node2.local = this.parseIdent();
        this.checkLValSimple(node2.local, BIND_LEXICAL);
        return this.finishNode(node2, "ImportDefaultSpecifier");
      };
      pp$8.parseImportNamespaceSpecifier = function() {
        var node2 = this.startNode();
        this.next();
        this.expectContextual("as");
        node2.local = this.parseIdent();
        this.checkLValSimple(node2.local, BIND_LEXICAL);
        return this.finishNode(node2, "ImportNamespaceSpecifier");
      };
      pp$8.parseImportSpecifiers = function() {
        var nodes = [], first = true;
        if (this.type === types$1.name) {
          nodes.push(this.parseImportDefaultSpecifier());
          if (!this.eat(types$1.comma)) {
            return nodes;
          }
        }
        if (this.type === types$1.star) {
          nodes.push(this.parseImportNamespaceSpecifier());
          return nodes;
        }
        this.expect(types$1.braceL);
        while (!this.eat(types$1.braceR)) {
          if (!first) {
            this.expect(types$1.comma);
            if (this.afterTrailingComma(types$1.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          nodes.push(this.parseImportSpecifier());
        }
        return nodes;
      };
      pp$8.parseWithClause = function() {
        var nodes = [];
        if (!this.eat(types$1._with)) {
          return nodes;
        }
        this.expect(types$1.braceL);
        var attributeKeys = {};
        var first = true;
        while (!this.eat(types$1.braceR)) {
          if (!first) {
            this.expect(types$1.comma);
            if (this.afterTrailingComma(types$1.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          var attr = this.parseImportAttribute();
          var keyName = attr.key.type === "Identifier" ? attr.key.name : attr.key.value;
          if (hasOwn(attributeKeys, keyName)) {
            this.raiseRecoverable(attr.key.start, "Duplicate attribute key '" + keyName + "'");
          }
          attributeKeys[keyName] = true;
          nodes.push(attr);
        }
        return nodes;
      };
      pp$8.parseImportAttribute = function() {
        var node2 = this.startNode();
        node2.key = this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
        this.expect(types$1.colon);
        if (this.type !== types$1.string) {
          this.unexpected();
        }
        node2.value = this.parseExprAtom();
        return this.finishNode(node2, "ImportAttribute");
      };
      pp$8.parseModuleExportName = function() {
        if (this.options.ecmaVersion >= 13 && this.type === types$1.string) {
          var stringLiteral = this.parseLiteral(this.value);
          if (loneSurrogate.test(stringLiteral.value)) {
            this.raise(stringLiteral.start, "An export name cannot include a lone surrogate.");
          }
          return stringLiteral;
        }
        return this.parseIdent(true);
      };
      pp$8.adaptDirectivePrologue = function(statements) {
        for (var i3 = 0; i3 < statements.length && this.isDirectiveCandidate(statements[i3]); ++i3) {
          statements[i3].directive = statements[i3].expression.raw.slice(1, -1);
        }
      };
      pp$8.isDirectiveCandidate = function(statement) {
        return this.options.ecmaVersion >= 5 && statement.type === "ExpressionStatement" && statement.expression.type === "Literal" && typeof statement.expression.value === "string" && // Reject parenthesized strings.
        (this.input[statement.start] === '"' || this.input[statement.start] === "'");
      };
      var pp$7 = Parser.prototype;
      pp$7.toAssignable = function(node2, isBinding, refDestructuringErrors) {
        if (this.options.ecmaVersion >= 6 && node2) {
          switch (node2.type) {
            case "Identifier":
              if (this.inAsync && node2.name === "await") {
                this.raise(node2.start, "Cannot use 'await' as identifier inside an async function");
              }
              break;
            case "ObjectPattern":
            case "ArrayPattern":
            case "AssignmentPattern":
            case "RestElement":
              break;
            case "ObjectExpression":
              node2.type = "ObjectPattern";
              if (refDestructuringErrors) {
                this.checkPatternErrors(refDestructuringErrors, true);
              }
              for (var i3 = 0, list2 = node2.properties; i3 < list2.length; i3 += 1) {
                var prop = list2[i3];
                this.toAssignable(prop, isBinding);
                if (prop.type === "RestElement" && (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")) {
                  this.raise(prop.argument.start, "Unexpected token");
                }
              }
              break;
            case "Property":
              if (node2.kind !== "init") {
                this.raise(node2.key.start, "Object pattern can't contain getter or setter");
              }
              this.toAssignable(node2.value, isBinding);
              break;
            case "ArrayExpression":
              node2.type = "ArrayPattern";
              if (refDestructuringErrors) {
                this.checkPatternErrors(refDestructuringErrors, true);
              }
              this.toAssignableList(node2.elements, isBinding);
              break;
            case "SpreadElement":
              node2.type = "RestElement";
              this.toAssignable(node2.argument, isBinding);
              if (node2.argument.type === "AssignmentPattern") {
                this.raise(node2.argument.start, "Rest elements cannot have a default value");
              }
              break;
            case "AssignmentExpression":
              if (node2.operator !== "=") {
                this.raise(node2.left.end, "Only '=' operator can be used for specifying default value.");
              }
              node2.type = "AssignmentPattern";
              delete node2.operator;
              this.toAssignable(node2.left, isBinding);
              break;
            case "ParenthesizedExpression":
              this.toAssignable(node2.expression, isBinding, refDestructuringErrors);
              break;
            case "ChainExpression":
              this.raiseRecoverable(node2.start, "Optional chaining cannot appear in left-hand side");
              break;
            case "MemberExpression":
              if (!isBinding) {
                break;
              }
            default:
              this.raise(node2.start, "Assigning to rvalue");
          }
        } else if (refDestructuringErrors) {
          this.checkPatternErrors(refDestructuringErrors, true);
        }
        return node2;
      };
      pp$7.toAssignableList = function(exprList, isBinding) {
        var end = exprList.length;
        for (var i3 = 0; i3 < end; i3++) {
          var elt = exprList[i3];
          if (elt) {
            this.toAssignable(elt, isBinding);
          }
        }
        if (end) {
          var last = exprList[end - 1];
          if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier") {
            this.unexpected(last.argument.start);
          }
        }
        return exprList;
      };
      pp$7.parseSpread = function(refDestructuringErrors) {
        var node2 = this.startNode();
        this.next();
        node2.argument = this.parseMaybeAssign(false, refDestructuringErrors);
        return this.finishNode(node2, "SpreadElement");
      };
      pp$7.parseRestBinding = function() {
        var node2 = this.startNode();
        this.next();
        if (this.options.ecmaVersion === 6 && this.type !== types$1.name) {
          this.unexpected();
        }
        node2.argument = this.parseBindingAtom();
        return this.finishNode(node2, "RestElement");
      };
      pp$7.parseBindingAtom = function() {
        if (this.options.ecmaVersion >= 6) {
          switch (this.type) {
            case types$1.bracketL:
              var node2 = this.startNode();
              this.next();
              node2.elements = this.parseBindingList(types$1.bracketR, true, true);
              return this.finishNode(node2, "ArrayPattern");
            case types$1.braceL:
              return this.parseObj(true);
          }
        }
        return this.parseIdent();
      };
      pp$7.parseBindingList = function(close, allowEmpty, allowTrailingComma, allowModifiers) {
        var elts = [], first = true;
        while (!this.eat(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(types$1.comma);
          }
          if (allowEmpty && this.type === types$1.comma) {
            elts.push(null);
          } else if (allowTrailingComma && this.afterTrailingComma(close)) {
            break;
          } else if (this.type === types$1.ellipsis) {
            var rest = this.parseRestBinding();
            this.parseBindingListItem(rest);
            elts.push(rest);
            if (this.type === types$1.comma) {
              this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
            }
            this.expect(close);
            break;
          } else {
            elts.push(this.parseAssignableListItem(allowModifiers));
          }
        }
        return elts;
      };
      pp$7.parseAssignableListItem = function(allowModifiers) {
        var elem = this.parseMaybeDefault(this.start, this.startLoc);
        this.parseBindingListItem(elem);
        return elem;
      };
      pp$7.parseBindingListItem = function(param) {
        return param;
      };
      pp$7.parseMaybeDefault = function(startPos, startLoc, left) {
        left = left || this.parseBindingAtom();
        if (this.options.ecmaVersion < 6 || !this.eat(types$1.eq)) {
          return left;
        }
        var node2 = this.startNodeAt(startPos, startLoc);
        node2.left = left;
        node2.right = this.parseMaybeAssign();
        return this.finishNode(node2, "AssignmentPattern");
      };
      pp$7.checkLValSimple = function(expr, bindingType, checkClashes) {
        if (bindingType === void 0) bindingType = BIND_NONE;
        var isBind = bindingType !== BIND_NONE;
        switch (expr.type) {
          case "Identifier":
            if (this.strict && this.reservedWordsStrictBind.test(expr.name)) {
              this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode");
            }
            if (isBind) {
              if (bindingType === BIND_LEXICAL && expr.name === "let") {
                this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name");
              }
              if (checkClashes) {
                if (hasOwn(checkClashes, expr.name)) {
                  this.raiseRecoverable(expr.start, "Argument name clash");
                }
                checkClashes[expr.name] = true;
              }
              if (bindingType !== BIND_OUTSIDE) {
                this.declareName(expr.name, bindingType, expr.start);
              }
            }
            break;
          case "ChainExpression":
            this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
            break;
          case "MemberExpression":
            if (isBind) {
              this.raiseRecoverable(expr.start, "Binding member expression");
            }
            break;
          case "ParenthesizedExpression":
            if (isBind) {
              this.raiseRecoverable(expr.start, "Binding parenthesized expression");
            }
            return this.checkLValSimple(expr.expression, bindingType, checkClashes);
          default:
            this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
        }
      };
      pp$7.checkLValPattern = function(expr, bindingType, checkClashes) {
        if (bindingType === void 0) bindingType = BIND_NONE;
        switch (expr.type) {
          case "ObjectPattern":
            for (var i3 = 0, list2 = expr.properties; i3 < list2.length; i3 += 1) {
              var prop = list2[i3];
              this.checkLValInnerPattern(prop, bindingType, checkClashes);
            }
            break;
          case "ArrayPattern":
            for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
              var elem = list$1[i$1];
              if (elem) {
                this.checkLValInnerPattern(elem, bindingType, checkClashes);
              }
            }
            break;
          default:
            this.checkLValSimple(expr, bindingType, checkClashes);
        }
      };
      pp$7.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
        if (bindingType === void 0) bindingType = BIND_NONE;
        switch (expr.type) {
          case "Property":
            this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
            break;
          case "AssignmentPattern":
            this.checkLValPattern(expr.left, bindingType, checkClashes);
            break;
          case "RestElement":
            this.checkLValPattern(expr.argument, bindingType, checkClashes);
            break;
          default:
            this.checkLValPattern(expr, bindingType, checkClashes);
        }
      };
      var TokContext = function TokContext2(token, isExpr, preserveSpace, override, generator) {
        this.token = token;
        this.isExpr = !!isExpr;
        this.preserveSpace = !!preserveSpace;
        this.override = override;
        this.generator = !!generator;
      };
      var types = {
        b_stat: new TokContext("{", false),
        b_expr: new TokContext("{", true),
        b_tmpl: new TokContext("${", false),
        p_stat: new TokContext("(", false),
        p_expr: new TokContext("(", true),
        q_tmpl: new TokContext("`", true, true, function(p2) {
          return p2.tryReadTemplateToken();
        }),
        f_stat: new TokContext("function", false),
        f_expr: new TokContext("function", true),
        f_expr_gen: new TokContext("function", true, false, null, true),
        f_gen: new TokContext("function", false, false, null, true)
      };
      var pp$6 = Parser.prototype;
      pp$6.initialContext = function() {
        return [types.b_stat];
      };
      pp$6.curContext = function() {
        return this.context[this.context.length - 1];
      };
      pp$6.braceIsBlock = function(prevType) {
        var parent = this.curContext();
        if (parent === types.f_expr || parent === types.f_stat) {
          return true;
        }
        if (prevType === types$1.colon && (parent === types.b_stat || parent === types.b_expr)) {
          return !parent.isExpr;
        }
        if (prevType === types$1._return || prevType === types$1.name && this.exprAllowed) {
          return lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
        }
        if (prevType === types$1._else || prevType === types$1.semi || prevType === types$1.eof || prevType === types$1.parenR || prevType === types$1.arrow) {
          return true;
        }
        if (prevType === types$1.braceL) {
          return parent === types.b_stat;
        }
        if (prevType === types$1._var || prevType === types$1._const || prevType === types$1.name) {
          return false;
        }
        return !this.exprAllowed;
      };
      pp$6.inGeneratorContext = function() {
        for (var i3 = this.context.length - 1; i3 >= 1; i3--) {
          var context = this.context[i3];
          if (context.token === "function") {
            return context.generator;
          }
        }
        return false;
      };
      pp$6.updateContext = function(prevType) {
        var update, type2 = this.type;
        if (type2.keyword && prevType === types$1.dot) {
          this.exprAllowed = false;
        } else if (update = type2.updateContext) {
          update.call(this, prevType);
        } else {
          this.exprAllowed = type2.beforeExpr;
        }
      };
      pp$6.overrideContext = function(tokenCtx) {
        if (this.curContext() !== tokenCtx) {
          this.context[this.context.length - 1] = tokenCtx;
        }
      };
      types$1.parenR.updateContext = types$1.braceR.updateContext = function() {
        if (this.context.length === 1) {
          this.exprAllowed = true;
          return;
        }
        var out = this.context.pop();
        if (out === types.b_stat && this.curContext().token === "function") {
          out = this.context.pop();
        }
        this.exprAllowed = !out.isExpr;
      };
      types$1.braceL.updateContext = function(prevType) {
        this.context.push(this.braceIsBlock(prevType) ? types.b_stat : types.b_expr);
        this.exprAllowed = true;
      };
      types$1.dollarBraceL.updateContext = function() {
        this.context.push(types.b_tmpl);
        this.exprAllowed = true;
      };
      types$1.parenL.updateContext = function(prevType) {
        var statementParens = prevType === types$1._if || prevType === types$1._for || prevType === types$1._with || prevType === types$1._while;
        this.context.push(statementParens ? types.p_stat : types.p_expr);
        this.exprAllowed = true;
      };
      types$1.incDec.updateContext = function() {
      };
      types$1._function.updateContext = types$1._class.updateContext = function(prevType) {
        if (prevType.beforeExpr && prevType !== types$1._else && !(prevType === types$1.semi && this.curContext() !== types.p_stat) && !(prevType === types$1._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) && !((prevType === types$1.colon || prevType === types$1.braceL) && this.curContext() === types.b_stat)) {
          this.context.push(types.f_expr);
        } else {
          this.context.push(types.f_stat);
        }
        this.exprAllowed = false;
      };
      types$1.colon.updateContext = function() {
        if (this.curContext().token === "function") {
          this.context.pop();
        }
        this.exprAllowed = true;
      };
      types$1.backQuote.updateContext = function() {
        if (this.curContext() === types.q_tmpl) {
          this.context.pop();
        } else {
          this.context.push(types.q_tmpl);
        }
        this.exprAllowed = false;
      };
      types$1.star.updateContext = function(prevType) {
        if (prevType === types$1._function) {
          var index = this.context.length - 1;
          if (this.context[index] === types.f_expr) {
            this.context[index] = types.f_expr_gen;
          } else {
            this.context[index] = types.f_gen;
          }
        }
        this.exprAllowed = true;
      };
      types$1.name.updateContext = function(prevType) {
        var allowed = false;
        if (this.options.ecmaVersion >= 6 && prevType !== types$1.dot) {
          if (this.value === "of" && !this.exprAllowed || this.value === "yield" && this.inGeneratorContext()) {
            allowed = true;
          }
        }
        this.exprAllowed = allowed;
      };
      var pp$5 = Parser.prototype;
      pp$5.checkPropClash = function(prop, propHash, refDestructuringErrors) {
        if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement") {
          return;
        }
        if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand)) {
          return;
        }
        var key = prop.key;
        var name;
        switch (key.type) {
          case "Identifier":
            name = key.name;
            break;
          case "Literal":
            name = String(key.value);
            break;
          default:
            return;
        }
        var kind = prop.kind;
        if (this.options.ecmaVersion >= 6) {
          if (name === "__proto__" && kind === "init") {
            if (propHash.proto) {
              if (refDestructuringErrors) {
                if (refDestructuringErrors.doubleProto < 0) {
                  refDestructuringErrors.doubleProto = key.start;
                }
              } else {
                this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
              }
            }
            propHash.proto = true;
          }
          return;
        }
        name = "$" + name;
        var other = propHash[name];
        if (other) {
          var redefinition;
          if (kind === "init") {
            redefinition = this.strict && other.init || other.get || other.set;
          } else {
            redefinition = other.init || other[kind];
          }
          if (redefinition) {
            this.raiseRecoverable(key.start, "Redefinition of property");
          }
        } else {
          other = propHash[name] = {
            init: false,
            get: false,
            set: false
          };
        }
        other[kind] = true;
      };
      pp$5.parseExpression = function(forInit, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
        if (this.type === types$1.comma) {
          var node2 = this.startNodeAt(startPos, startLoc);
          node2.expressions = [expr];
          while (this.eat(types$1.comma)) {
            node2.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors));
          }
          return this.finishNode(node2, "SequenceExpression");
        }
        return expr;
      };
      pp$5.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
        if (this.isContextual("yield")) {
          if (this.inGenerator) {
            return this.parseYield(forInit);
          } else {
            this.exprAllowed = false;
          }
        }
        var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1, oldDoubleProto = -1;
        if (refDestructuringErrors) {
          oldParenAssign = refDestructuringErrors.parenthesizedAssign;
          oldTrailingComma = refDestructuringErrors.trailingComma;
          oldDoubleProto = refDestructuringErrors.doubleProto;
          refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
        } else {
          refDestructuringErrors = new DestructuringErrors();
          ownDestructuringErrors = true;
        }
        var startPos = this.start, startLoc = this.startLoc;
        if (this.type === types$1.parenL || this.type === types$1.name) {
          this.potentialArrowAt = this.start;
          this.potentialArrowInForAwait = forInit === "await";
        }
        var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
        if (afterLeftParse) {
          left = afterLeftParse.call(this, left, startPos, startLoc);
        }
        if (this.type.isAssign) {
          var node2 = this.startNodeAt(startPos, startLoc);
          node2.operator = this.value;
          if (this.type === types$1.eq) {
            left = this.toAssignable(left, false, refDestructuringErrors);
          }
          if (!ownDestructuringErrors) {
            refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
          }
          if (refDestructuringErrors.shorthandAssign >= left.start) {
            refDestructuringErrors.shorthandAssign = -1;
          }
          if (this.type === types$1.eq) {
            this.checkLValPattern(left);
          } else {
            this.checkLValSimple(left);
          }
          node2.left = left;
          this.next();
          node2.right = this.parseMaybeAssign(forInit);
          if (oldDoubleProto > -1) {
            refDestructuringErrors.doubleProto = oldDoubleProto;
          }
          return this.finishNode(node2, "AssignmentExpression");
        } else {
          if (ownDestructuringErrors) {
            this.checkExpressionErrors(refDestructuringErrors, true);
          }
        }
        if (oldParenAssign > -1) {
          refDestructuringErrors.parenthesizedAssign = oldParenAssign;
        }
        if (oldTrailingComma > -1) {
          refDestructuringErrors.trailingComma = oldTrailingComma;
        }
        return left;
      };
      pp$5.parseMaybeConditional = function(forInit, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseExprOps(forInit, refDestructuringErrors);
        if (this.checkExpressionErrors(refDestructuringErrors)) {
          return expr;
        }
        if (this.eat(types$1.question)) {
          var node2 = this.startNodeAt(startPos, startLoc);
          node2.test = expr;
          node2.consequent = this.parseMaybeAssign();
          this.expect(types$1.colon);
          node2.alternate = this.parseMaybeAssign(forInit);
          return this.finishNode(node2, "ConditionalExpression");
        }
        return expr;
      };
      pp$5.parseExprOps = function(forInit, refDestructuringErrors) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseMaybeUnary(refDestructuringErrors, false, false, forInit);
        if (this.checkExpressionErrors(refDestructuringErrors)) {
          return expr;
        }
        return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit);
      };
      pp$5.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
        var prec = this.type.binop;
        if (prec != null && (!forInit || this.type !== types$1._in)) {
          if (prec > minPrec) {
            var logical = this.type === types$1.logicalOR || this.type === types$1.logicalAND;
            var coalesce = this.type === types$1.coalesce;
            if (coalesce) {
              prec = types$1.logicalAND.binop;
            }
            var op = this.value;
            this.next();
            var startPos = this.start, startLoc = this.startLoc;
            var right = this.parseExprOp(this.parseMaybeUnary(null, false, false, forInit), startPos, startLoc, prec, forInit);
            var node2 = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
            if (logical && this.type === types$1.coalesce || coalesce && (this.type === types$1.logicalOR || this.type === types$1.logicalAND)) {
              this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
            }
            return this.parseExprOp(node2, leftStartPos, leftStartLoc, minPrec, forInit);
          }
        }
        return left;
      };
      pp$5.buildBinary = function(startPos, startLoc, left, right, op, logical) {
        if (right.type === "PrivateIdentifier") {
          this.raise(right.start, "Private identifier can only be left side of binary expression");
        }
        var node2 = this.startNodeAt(startPos, startLoc);
        node2.left = left;
        node2.operator = op;
        node2.right = right;
        return this.finishNode(node2, logical ? "LogicalExpression" : "BinaryExpression");
      };
      pp$5.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec, forInit) {
        var startPos = this.start, startLoc = this.startLoc, expr;
        if (this.isContextual("await") && this.canAwait) {
          expr = this.parseAwait(forInit);
          sawUnary = true;
        } else if (this.type.prefix) {
          var node2 = this.startNode(), update = this.type === types$1.incDec;
          node2.operator = this.value;
          node2.prefix = true;
          this.next();
          node2.argument = this.parseMaybeUnary(null, true, update, forInit);
          this.checkExpressionErrors(refDestructuringErrors, true);
          if (update) {
            this.checkLValSimple(node2.argument);
          } else if (this.strict && node2.operator === "delete" && isLocalVariableAccess(node2.argument)) {
            this.raiseRecoverable(node2.start, "Deleting local variable in strict mode");
          } else if (node2.operator === "delete" && isPrivateFieldAccess(node2.argument)) {
            this.raiseRecoverable(node2.start, "Private fields can not be deleted");
          } else {
            sawUnary = true;
          }
          expr = this.finishNode(node2, update ? "UpdateExpression" : "UnaryExpression");
        } else if (!sawUnary && this.type === types$1.privateId) {
          if ((forInit || this.privateNameStack.length === 0) && this.options.checkPrivateFields) {
            this.unexpected();
          }
          expr = this.parsePrivateIdent();
          if (this.type !== types$1._in) {
            this.unexpected();
          }
        } else {
          expr = this.parseExprSubscripts(refDestructuringErrors, forInit);
          if (this.checkExpressionErrors(refDestructuringErrors)) {
            return expr;
          }
          while (this.type.postfix && !this.canInsertSemicolon()) {
            var node$1 = this.startNodeAt(startPos, startLoc);
            node$1.operator = this.value;
            node$1.prefix = false;
            node$1.argument = expr;
            this.checkLValSimple(expr);
            this.next();
            expr = this.finishNode(node$1, "UpdateExpression");
          }
        }
        if (!incDec && this.eat(types$1.starstar)) {
          if (sawUnary) {
            this.unexpected(this.lastTokStart);
          } else {
            return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false, false, forInit), "**", false);
          }
        } else {
          return expr;
        }
      };
      function isLocalVariableAccess(node2) {
        return node2.type === "Identifier" || node2.type === "ParenthesizedExpression" && isLocalVariableAccess(node2.expression);
      }
      function isPrivateFieldAccess(node2) {
        return node2.type === "MemberExpression" && node2.property.type === "PrivateIdentifier" || node2.type === "ChainExpression" && isPrivateFieldAccess(node2.expression) || node2.type === "ParenthesizedExpression" && isPrivateFieldAccess(node2.expression);
      }
      pp$5.parseExprSubscripts = function(refDestructuringErrors, forInit) {
        var startPos = this.start, startLoc = this.startLoc;
        var expr = this.parseExprAtom(refDestructuringErrors, forInit);
        if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")") {
          return expr;
        }
        var result = this.parseSubscripts(expr, startPos, startLoc, false, forInit);
        if (refDestructuringErrors && result.type === "MemberExpression") {
          if (refDestructuringErrors.parenthesizedAssign >= result.start) {
            refDestructuringErrors.parenthesizedAssign = -1;
          }
          if (refDestructuringErrors.parenthesizedBind >= result.start) {
            refDestructuringErrors.parenthesizedBind = -1;
          }
          if (refDestructuringErrors.trailingComma >= result.start) {
            refDestructuringErrors.trailingComma = -1;
          }
        }
        return result;
      };
      pp$5.parseSubscripts = function(base, startPos, startLoc, noCalls, forInit) {
        var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" && this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 && this.potentialArrowAt === base.start;
        var optionalChained = false;
        while (true) {
          var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit);
          if (element.optional) {
            optionalChained = true;
          }
          if (element === base || element.type === "ArrowFunctionExpression") {
            if (optionalChained) {
              var chainNode = this.startNodeAt(startPos, startLoc);
              chainNode.expression = element;
              element = this.finishNode(chainNode, "ChainExpression");
            }
            return element;
          }
          base = element;
        }
      };
      pp$5.shouldParseAsyncArrow = function() {
        return !this.canInsertSemicolon() && this.eat(types$1.arrow);
      };
      pp$5.parseSubscriptAsyncArrow = function(startPos, startLoc, exprList, forInit) {
        return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true, forInit);
      };
      pp$5.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit) {
        var optionalSupported = this.options.ecmaVersion >= 11;
        var optional = optionalSupported && this.eat(types$1.questionDot);
        if (noCalls && optional) {
          this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions");
        }
        var computed = this.eat(types$1.bracketL);
        if (computed || optional && this.type !== types$1.parenL && this.type !== types$1.backQuote || this.eat(types$1.dot)) {
          var node2 = this.startNodeAt(startPos, startLoc);
          node2.object = base;
          if (computed) {
            node2.property = this.parseExpression();
            this.expect(types$1.bracketR);
          } else if (this.type === types$1.privateId && base.type !== "Super") {
            node2.property = this.parsePrivateIdent();
          } else {
            node2.property = this.parseIdent(this.options.allowReserved !== "never");
          }
          node2.computed = !!computed;
          if (optionalSupported) {
            node2.optional = optional;
          }
          base = this.finishNode(node2, "MemberExpression");
        } else if (!noCalls && this.eat(types$1.parenL)) {
          var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
          this.yieldPos = 0;
          this.awaitPos = 0;
          this.awaitIdentPos = 0;
          var exprList = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
          if (maybeAsyncArrow && !optional && this.shouldParseAsyncArrow()) {
            this.checkPatternErrors(refDestructuringErrors, false);
            this.checkYieldAwaitInDefaultParams();
            if (this.awaitIdentPos > 0) {
              this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function");
            }
            this.yieldPos = oldYieldPos;
            this.awaitPos = oldAwaitPos;
            this.awaitIdentPos = oldAwaitIdentPos;
            return this.parseSubscriptAsyncArrow(startPos, startLoc, exprList, forInit);
          }
          this.checkExpressionErrors(refDestructuringErrors, true);
          this.yieldPos = oldYieldPos || this.yieldPos;
          this.awaitPos = oldAwaitPos || this.awaitPos;
          this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
          var node$1 = this.startNodeAt(startPos, startLoc);
          node$1.callee = base;
          node$1.arguments = exprList;
          if (optionalSupported) {
            node$1.optional = optional;
          }
          base = this.finishNode(node$1, "CallExpression");
        } else if (this.type === types$1.backQuote) {
          if (optional || optionalChained) {
            this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
          }
          var node$2 = this.startNodeAt(startPos, startLoc);
          node$2.tag = base;
          node$2.quasi = this.parseTemplate({ isTagged: true });
          base = this.finishNode(node$2, "TaggedTemplateExpression");
        }
        return base;
      };
      pp$5.parseExprAtom = function(refDestructuringErrors, forInit, forNew) {
        if (this.type === types$1.slash) {
          this.readRegexp();
        }
        var node2, canBeArrow = this.potentialArrowAt === this.start;
        switch (this.type) {
          case types$1._super:
            if (!this.allowSuper) {
              this.raise(this.start, "'super' keyword outside a method");
            }
            node2 = this.startNode();
            this.next();
            if (this.type === types$1.parenL && !this.allowDirectSuper) {
              this.raise(node2.start, "super() call outside constructor of a subclass");
            }
            if (this.type !== types$1.dot && this.type !== types$1.bracketL && this.type !== types$1.parenL) {
              this.unexpected();
            }
            return this.finishNode(node2, "Super");
          case types$1._this:
            node2 = this.startNode();
            this.next();
            return this.finishNode(node2, "ThisExpression");
          case types$1.name:
            var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
            var id2 = this.parseIdent(false);
            if (this.options.ecmaVersion >= 8 && !containsEsc && id2.name === "async" && !this.canInsertSemicolon() && this.eat(types$1._function)) {
              this.overrideContext(types.f_expr);
              return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true, forInit);
            }
            if (canBeArrow && !this.canInsertSemicolon()) {
              if (this.eat(types$1.arrow)) {
                return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id2], false, forInit);
              }
              if (this.options.ecmaVersion >= 8 && id2.name === "async" && this.type === types$1.name && !containsEsc && (!this.potentialArrowInForAwait || this.value !== "of" || this.containsEsc)) {
                id2 = this.parseIdent(false);
                if (this.canInsertSemicolon() || !this.eat(types$1.arrow)) {
                  this.unexpected();
                }
                return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id2], true, forInit);
              }
            }
            return id2;
          case types$1.regexp:
            var value = this.value;
            node2 = this.parseLiteral(value.value);
            node2.regex = { pattern: value.pattern, flags: value.flags };
            return node2;
          case types$1.num:
          case types$1.string:
            return this.parseLiteral(this.value);
          case types$1._null:
          case types$1._true:
          case types$1._false:
            node2 = this.startNode();
            node2.value = this.type === types$1._null ? null : this.type === types$1._true;
            node2.raw = this.type.keyword;
            this.next();
            return this.finishNode(node2, "Literal");
          case types$1.parenL:
            var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow, forInit);
            if (refDestructuringErrors) {
              if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr)) {
                refDestructuringErrors.parenthesizedAssign = start;
              }
              if (refDestructuringErrors.parenthesizedBind < 0) {
                refDestructuringErrors.parenthesizedBind = start;
              }
            }
            return expr;
          case types$1.bracketL:
            node2 = this.startNode();
            this.next();
            node2.elements = this.parseExprList(types$1.bracketR, true, true, refDestructuringErrors);
            return this.finishNode(node2, "ArrayExpression");
          case types$1.braceL:
            this.overrideContext(types.b_expr);
            return this.parseObj(false, refDestructuringErrors);
          case types$1._function:
            node2 = this.startNode();
            this.next();
            return this.parseFunction(node2, 0);
          case types$1._class:
            return this.parseClass(this.startNode(), false);
          case types$1._new:
            return this.parseNew();
          case types$1.backQuote:
            return this.parseTemplate();
          case types$1._import:
            if (this.options.ecmaVersion >= 11) {
              return this.parseExprImport(forNew);
            } else {
              return this.unexpected();
            }
          default:
            return this.parseExprAtomDefault();
        }
      };
      pp$5.parseExprAtomDefault = function() {
        this.unexpected();
      };
      pp$5.parseExprImport = function(forNew) {
        var node2 = this.startNode();
        if (this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword import");
        }
        this.next();
        if (this.type === types$1.parenL && !forNew) {
          return this.parseDynamicImport(node2);
        } else if (this.type === types$1.dot) {
          var meta = this.startNodeAt(node2.start, node2.loc && node2.loc.start);
          meta.name = "import";
          node2.meta = this.finishNode(meta, "Identifier");
          return this.parseImportMeta(node2);
        } else {
          this.unexpected();
        }
      };
      pp$5.parseDynamicImport = function(node2) {
        this.next();
        node2.source = this.parseMaybeAssign();
        if (this.options.ecmaVersion >= 16) {
          if (!this.eat(types$1.parenR)) {
            this.expect(types$1.comma);
            if (!this.afterTrailingComma(types$1.parenR)) {
              node2.options = this.parseMaybeAssign();
              if (!this.eat(types$1.parenR)) {
                this.expect(types$1.comma);
                if (!this.afterTrailingComma(types$1.parenR)) {
                  this.unexpected();
                }
              }
            } else {
              node2.options = null;
            }
          } else {
            node2.options = null;
          }
        } else {
          if (!this.eat(types$1.parenR)) {
            var errorPos = this.start;
            if (this.eat(types$1.comma) && this.eat(types$1.parenR)) {
              this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
            } else {
              this.unexpected(errorPos);
            }
          }
        }
        return this.finishNode(node2, "ImportExpression");
      };
      pp$5.parseImportMeta = function(node2) {
        this.next();
        var containsEsc = this.containsEsc;
        node2.property = this.parseIdent(true);
        if (node2.property.name !== "meta") {
          this.raiseRecoverable(node2.property.start, "The only valid meta property for import is 'import.meta'");
        }
        if (containsEsc) {
          this.raiseRecoverable(node2.start, "'import.meta' must not contain escaped characters");
        }
        if (this.options.sourceType !== "module" && !this.options.allowImportExportEverywhere) {
          this.raiseRecoverable(node2.start, "Cannot use 'import.meta' outside a module");
        }
        return this.finishNode(node2, "MetaProperty");
      };
      pp$5.parseLiteral = function(value) {
        var node2 = this.startNode();
        node2.value = value;
        node2.raw = this.input.slice(this.start, this.end);
        if (node2.raw.charCodeAt(node2.raw.length - 1) === 110) {
          node2.bigint = node2.value != null ? node2.value.toString() : node2.raw.slice(0, -1).replace(/_/g, "");
        }
        this.next();
        return this.finishNode(node2, "Literal");
      };
      pp$5.parseParenExpression = function() {
        this.expect(types$1.parenL);
        var val = this.parseExpression();
        this.expect(types$1.parenR);
        return val;
      };
      pp$5.shouldParseArrow = function(exprList) {
        return !this.canInsertSemicolon();
      };
      pp$5.parseParenAndDistinguishExpression = function(canBeArrow, forInit) {
        var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
        if (this.options.ecmaVersion >= 6) {
          this.next();
          var innerStartPos = this.start, innerStartLoc = this.startLoc;
          var exprList = [], first = true, lastIsComma = false;
          var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
          this.yieldPos = 0;
          this.awaitPos = 0;
          while (this.type !== types$1.parenR) {
            first ? first = false : this.expect(types$1.comma);
            if (allowTrailingComma && this.afterTrailingComma(types$1.parenR, true)) {
              lastIsComma = true;
              break;
            } else if (this.type === types$1.ellipsis) {
              spreadStart = this.start;
              exprList.push(this.parseParenItem(this.parseRestBinding()));
              if (this.type === types$1.comma) {
                this.raiseRecoverable(
                  this.start,
                  "Comma is not permitted after the rest element"
                );
              }
              break;
            } else {
              exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
            }
          }
          var innerEndPos = this.lastTokEnd, innerEndLoc = this.lastTokEndLoc;
          this.expect(types$1.parenR);
          if (canBeArrow && this.shouldParseArrow(exprList) && this.eat(types$1.arrow)) {
            this.checkPatternErrors(refDestructuringErrors, false);
            this.checkYieldAwaitInDefaultParams();
            this.yieldPos = oldYieldPos;
            this.awaitPos = oldAwaitPos;
            return this.parseParenArrowList(startPos, startLoc, exprList, forInit);
          }
          if (!exprList.length || lastIsComma) {
            this.unexpected(this.lastTokStart);
          }
          if (spreadStart) {
            this.unexpected(spreadStart);
          }
          this.checkExpressionErrors(refDestructuringErrors, true);
          this.yieldPos = oldYieldPos || this.yieldPos;
          this.awaitPos = oldAwaitPos || this.awaitPos;
          if (exprList.length > 1) {
            val = this.startNodeAt(innerStartPos, innerStartLoc);
            val.expressions = exprList;
            this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
          } else {
            val = exprList[0];
          }
        } else {
          val = this.parseParenExpression();
        }
        if (this.options.preserveParens) {
          var par = this.startNodeAt(startPos, startLoc);
          par.expression = val;
          return this.finishNode(par, "ParenthesizedExpression");
        } else {
          return val;
        }
      };
      pp$5.parseParenItem = function(item) {
        return item;
      };
      pp$5.parseParenArrowList = function(startPos, startLoc, exprList, forInit) {
        return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, false, forInit);
      };
      var empty = [];
      pp$5.parseNew = function() {
        if (this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword new");
        }
        var node2 = this.startNode();
        this.next();
        if (this.options.ecmaVersion >= 6 && this.type === types$1.dot) {
          var meta = this.startNodeAt(node2.start, node2.loc && node2.loc.start);
          meta.name = "new";
          node2.meta = this.finishNode(meta, "Identifier");
          this.next();
          var containsEsc = this.containsEsc;
          node2.property = this.parseIdent(true);
          if (node2.property.name !== "target") {
            this.raiseRecoverable(node2.property.start, "The only valid meta property for new is 'new.target'");
          }
          if (containsEsc) {
            this.raiseRecoverable(node2.start, "'new.target' must not contain escaped characters");
          }
          if (!this.allowNewDotTarget) {
            this.raiseRecoverable(node2.start, "'new.target' can only be used in functions and class static block");
          }
          return this.finishNode(node2, "MetaProperty");
        }
        var startPos = this.start, startLoc = this.startLoc;
        node2.callee = this.parseSubscripts(this.parseExprAtom(null, false, true), startPos, startLoc, true, false);
        if (this.eat(types$1.parenL)) {
          node2.arguments = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false);
        } else {
          node2.arguments = empty;
        }
        return this.finishNode(node2, "NewExpression");
      };
      pp$5.parseTemplateElement = function(ref3) {
        var isTagged = ref3.isTagged;
        var elem = this.startNode();
        if (this.type === types$1.invalidTemplate) {
          if (!isTagged) {
            this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
          }
          elem.value = {
            raw: this.value.replace(/\r\n?/g, "\n"),
            cooked: null
          };
        } else {
          elem.value = {
            raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
            cooked: this.value
          };
        }
        this.next();
        elem.tail = this.type === types$1.backQuote;
        return this.finishNode(elem, "TemplateElement");
      };
      pp$5.parseTemplate = function(ref3) {
        if (ref3 === void 0) ref3 = {};
        var isTagged = ref3.isTagged;
        if (isTagged === void 0) isTagged = false;
        var node2 = this.startNode();
        this.next();
        node2.expressions = [];
        var curElt = this.parseTemplateElement({ isTagged });
        node2.quasis = [curElt];
        while (!curElt.tail) {
          if (this.type === types$1.eof) {
            this.raise(this.pos, "Unterminated template literal");
          }
          this.expect(types$1.dollarBraceL);
          node2.expressions.push(this.parseExpression());
          this.expect(types$1.braceR);
          node2.quasis.push(curElt = this.parseTemplateElement({ isTagged }));
        }
        this.next();
        return this.finishNode(node2, "TemplateLiteral");
      };
      pp$5.isAsyncProp = function(prop) {
        return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" && (this.type === types$1.name || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword || this.options.ecmaVersion >= 9 && this.type === types$1.star) && !lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
      };
      pp$5.parseObj = function(isPattern, refDestructuringErrors) {
        var node2 = this.startNode(), first = true, propHash = {};
        node2.properties = [];
        this.next();
        while (!this.eat(types$1.braceR)) {
          if (!first) {
            this.expect(types$1.comma);
            if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types$1.braceR)) {
              break;
            }
          } else {
            first = false;
          }
          var prop = this.parseProperty(isPattern, refDestructuringErrors);
          if (!isPattern) {
            this.checkPropClash(prop, propHash, refDestructuringErrors);
          }
          node2.properties.push(prop);
        }
        return this.finishNode(node2, isPattern ? "ObjectPattern" : "ObjectExpression");
      };
      pp$5.parseProperty = function(isPattern, refDestructuringErrors) {
        var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
        if (this.options.ecmaVersion >= 9 && this.eat(types$1.ellipsis)) {
          if (isPattern) {
            prop.argument = this.parseIdent(false);
            if (this.type === types$1.comma) {
              this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
            }
            return this.finishNode(prop, "RestElement");
          }
          prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
          if (this.type === types$1.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
            refDestructuringErrors.trailingComma = this.start;
          }
          return this.finishNode(prop, "SpreadElement");
        }
        if (this.options.ecmaVersion >= 6) {
          prop.method = false;
          prop.shorthand = false;
          if (isPattern || refDestructuringErrors) {
            startPos = this.start;
            startLoc = this.startLoc;
          }
          if (!isPattern) {
            isGenerator = this.eat(types$1.star);
          }
        }
        var containsEsc = this.containsEsc;
        this.parsePropertyName(prop);
        if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
          isAsync = true;
          isGenerator = this.options.ecmaVersion >= 9 && this.eat(types$1.star);
          this.parsePropertyName(prop);
        } else {
          isAsync = false;
        }
        this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
        return this.finishNode(prop, "Property");
      };
      pp$5.parseGetterSetter = function(prop) {
        var kind = prop.key.name;
        this.parsePropertyName(prop);
        prop.value = this.parseMethod(false);
        prop.kind = kind;
        var paramCount = prop.kind === "get" ? 0 : 1;
        if (prop.value.params.length !== paramCount) {
          var start = prop.value.start;
          if (prop.kind === "get") {
            this.raiseRecoverable(start, "getter should have no params");
          } else {
            this.raiseRecoverable(start, "setter should have exactly one param");
          }
        } else {
          if (prop.kind === "set" && prop.value.params[0].type === "RestElement") {
            this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params");
          }
        }
      };
      pp$5.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
        if ((isGenerator || isAsync) && this.type === types$1.colon) {
          this.unexpected();
        }
        if (this.eat(types$1.colon)) {
          prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
          prop.kind = "init";
        } else if (this.options.ecmaVersion >= 6 && this.type === types$1.parenL) {
          if (isPattern) {
            this.unexpected();
          }
          prop.method = true;
          prop.value = this.parseMethod(isGenerator, isAsync);
          prop.kind = "init";
        } else if (!isPattern && !containsEsc && this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" && (prop.key.name === "get" || prop.key.name === "set") && (this.type !== types$1.comma && this.type !== types$1.braceR && this.type !== types$1.eq)) {
          if (isGenerator || isAsync) {
            this.unexpected();
          }
          this.parseGetterSetter(prop);
        } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
          if (isGenerator || isAsync) {
            this.unexpected();
          }
          this.checkUnreserved(prop.key);
          if (prop.key.name === "await" && !this.awaitIdentPos) {
            this.awaitIdentPos = startPos;
          }
          if (isPattern) {
            prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
          } else if (this.type === types$1.eq && refDestructuringErrors) {
            if (refDestructuringErrors.shorthandAssign < 0) {
              refDestructuringErrors.shorthandAssign = this.start;
            }
            prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
          } else {
            prop.value = this.copyNode(prop.key);
          }
          prop.kind = "init";
          prop.shorthand = true;
        } else {
          this.unexpected();
        }
      };
      pp$5.parsePropertyName = function(prop) {
        if (this.options.ecmaVersion >= 6) {
          if (this.eat(types$1.bracketL)) {
            prop.computed = true;
            prop.key = this.parseMaybeAssign();
            this.expect(types$1.bracketR);
            return prop.key;
          } else {
            prop.computed = false;
          }
        }
        return prop.key = this.type === types$1.num || this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
      };
      pp$5.initFunction = function(node2) {
        node2.id = null;
        if (this.options.ecmaVersion >= 6) {
          node2.generator = node2.expression = false;
        }
        if (this.options.ecmaVersion >= 8) {
          node2.async = false;
        }
      };
      pp$5.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
        var node2 = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.initFunction(node2);
        if (this.options.ecmaVersion >= 6) {
          node2.generator = isGenerator;
        }
        if (this.options.ecmaVersion >= 8) {
          node2.async = !!isAsync;
        }
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        this.enterScope(functionFlags(isAsync, node2.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));
        this.expect(types$1.parenL);
        node2.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
        this.checkYieldAwaitInDefaultParams();
        this.parseFunctionBody(node2, false, true, false);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node2, "FunctionExpression");
      };
      pp$5.parseArrowExpression = function(node2, params, isAsync, forInit) {
        var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
        this.initFunction(node2);
        if (this.options.ecmaVersion >= 8) {
          node2.async = !!isAsync;
        }
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        node2.params = this.toAssignableList(params, true);
        this.parseFunctionBody(node2, true, false, forInit);
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.finishNode(node2, "ArrowFunctionExpression");
      };
      pp$5.parseFunctionBody = function(node2, isArrowFunction, isMethod, forInit) {
        var isExpression = isArrowFunction && this.type !== types$1.braceL;
        var oldStrict = this.strict, useStrict = false;
        if (isExpression) {
          node2.body = this.parseMaybeAssign(forInit);
          node2.expression = true;
          this.checkParams(node2, false);
        } else {
          var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node2.params);
          if (!oldStrict || nonSimple) {
            useStrict = this.strictDirective(this.end);
            if (useStrict && nonSimple) {
              this.raiseRecoverable(node2.start, "Illegal 'use strict' directive in function with non-simple parameter list");
            }
          }
          var oldLabels = this.labels;
          this.labels = [];
          if (useStrict) {
            this.strict = true;
          }
          this.checkParams(node2, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node2.params));
          if (this.strict && node2.id) {
            this.checkLValSimple(node2.id, BIND_OUTSIDE);
          }
          node2.body = this.parseBlock(false, void 0, useStrict && !oldStrict);
          node2.expression = false;
          this.adaptDirectivePrologue(node2.body.body);
          this.labels = oldLabels;
        }
        this.exitScope();
      };
      pp$5.isSimpleParamList = function(params) {
        for (var i3 = 0, list2 = params; i3 < list2.length; i3 += 1) {
          var param = list2[i3];
          if (param.type !== "Identifier") {
            return false;
          }
        }
        return true;
      };
      pp$5.checkParams = function(node2, allowDuplicates) {
        var nameHash = /* @__PURE__ */ Object.create(null);
        for (var i3 = 0, list2 = node2.params; i3 < list2.length; i3 += 1) {
          var param = list2[i3];
          this.checkLValInnerPattern(param, BIND_VAR, allowDuplicates ? null : nameHash);
        }
      };
      pp$5.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
        var elts = [], first = true;
        while (!this.eat(close)) {
          if (!first) {
            this.expect(types$1.comma);
            if (allowTrailingComma && this.afterTrailingComma(close)) {
              break;
            }
          } else {
            first = false;
          }
          var elt = void 0;
          if (allowEmpty && this.type === types$1.comma) {
            elt = null;
          } else if (this.type === types$1.ellipsis) {
            elt = this.parseSpread(refDestructuringErrors);
            if (refDestructuringErrors && this.type === types$1.comma && refDestructuringErrors.trailingComma < 0) {
              refDestructuringErrors.trailingComma = this.start;
            }
          } else {
            elt = this.parseMaybeAssign(false, refDestructuringErrors);
          }
          elts.push(elt);
        }
        return elts;
      };
      pp$5.checkUnreserved = function(ref3) {
        var start = ref3.start;
        var end = ref3.end;
        var name = ref3.name;
        if (this.inGenerator && name === "yield") {
          this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator");
        }
        if (this.inAsync && name === "await") {
          this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function");
        }
        if (!(this.currentThisScope().flags & SCOPE_VAR) && name === "arguments") {
          this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer");
        }
        if (this.inClassStaticBlock && (name === "arguments" || name === "await")) {
          this.raise(start, "Cannot use " + name + " in class static initialization block");
        }
        if (this.keywords.test(name)) {
          this.raise(start, "Unexpected keyword '" + name + "'");
        }
        if (this.options.ecmaVersion < 6 && this.input.slice(start, end).indexOf("\\") !== -1) {
          return;
        }
        var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
        if (re.test(name)) {
          if (!this.inAsync && name === "await") {
            this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function");
          }
          this.raiseRecoverable(start, "The keyword '" + name + "' is reserved");
        }
      };
      pp$5.parseIdent = function(liberal) {
        var node2 = this.parseIdentNode();
        this.next(!!liberal);
        this.finishNode(node2, "Identifier");
        if (!liberal) {
          this.checkUnreserved(node2);
          if (node2.name === "await" && !this.awaitIdentPos) {
            this.awaitIdentPos = node2.start;
          }
        }
        return node2;
      };
      pp$5.parseIdentNode = function() {
        var node2 = this.startNode();
        if (this.type === types$1.name) {
          node2.name = this.value;
        } else if (this.type.keyword) {
          node2.name = this.type.keyword;
          if ((node2.name === "class" || node2.name === "function") && (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
            this.context.pop();
          }
          this.type = types$1.name;
        } else {
          this.unexpected();
        }
        return node2;
      };
      pp$5.parsePrivateIdent = function() {
        var node2 = this.startNode();
        if (this.type === types$1.privateId) {
          node2.name = this.value;
        } else {
          this.unexpected();
        }
        this.next();
        this.finishNode(node2, "PrivateIdentifier");
        if (this.options.checkPrivateFields) {
          if (this.privateNameStack.length === 0) {
            this.raise(node2.start, "Private field '#" + node2.name + "' must be declared in an enclosing class");
          } else {
            this.privateNameStack[this.privateNameStack.length - 1].used.push(node2);
          }
        }
        return node2;
      };
      pp$5.parseYield = function(forInit) {
        if (!this.yieldPos) {
          this.yieldPos = this.start;
        }
        var node2 = this.startNode();
        this.next();
        if (this.type === types$1.semi || this.canInsertSemicolon() || this.type !== types$1.star && !this.type.startsExpr) {
          node2.delegate = false;
          node2.argument = null;
        } else {
          node2.delegate = this.eat(types$1.star);
          node2.argument = this.parseMaybeAssign(forInit);
        }
        return this.finishNode(node2, "YieldExpression");
      };
      pp$5.parseAwait = function(forInit) {
        if (!this.awaitPos) {
          this.awaitPos = this.start;
        }
        var node2 = this.startNode();
        this.next();
        node2.argument = this.parseMaybeUnary(null, true, false, forInit);
        return this.finishNode(node2, "AwaitExpression");
      };
      var pp$4 = Parser.prototype;
      pp$4.raise = function(pos, message) {
        var loc = getLineInfo(this.input, pos);
        message += " (" + loc.line + ":" + loc.column + ")";
        if (this.sourceFile) {
          message += " in " + this.sourceFile;
        }
        var err = new SyntaxError(message);
        err.pos = pos;
        err.loc = loc;
        err.raisedAt = this.pos;
        throw err;
      };
      pp$4.raiseRecoverable = pp$4.raise;
      pp$4.curPosition = function() {
        if (this.options.locations) {
          return new Position(this.curLine, this.pos - this.lineStart);
        }
      };
      var pp$3 = Parser.prototype;
      var Scope = function Scope2(flags2) {
        this.flags = flags2;
        this.var = [];
        this.lexical = [];
        this.functions = [];
      };
      pp$3.enterScope = function(flags2) {
        this.scopeStack.push(new Scope(flags2));
      };
      pp$3.exitScope = function() {
        this.scopeStack.pop();
      };
      pp$3.treatFunctionsAsVarInScope = function(scope) {
        return scope.flags & SCOPE_FUNCTION || !this.inModule && scope.flags & SCOPE_TOP;
      };
      pp$3.declareName = function(name, bindingType, pos) {
        var redeclared = false;
        if (bindingType === BIND_LEXICAL) {
          var scope = this.currentScope();
          redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
          scope.lexical.push(name);
          if (this.inModule && scope.flags & SCOPE_TOP) {
            delete this.undefinedExports[name];
          }
        } else if (bindingType === BIND_SIMPLE_CATCH) {
          var scope$1 = this.currentScope();
          scope$1.lexical.push(name);
        } else if (bindingType === BIND_FUNCTION) {
          var scope$2 = this.currentScope();
          if (this.treatFunctionsAsVar) {
            redeclared = scope$2.lexical.indexOf(name) > -1;
          } else {
            redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1;
          }
          scope$2.functions.push(name);
        } else {
          for (var i3 = this.scopeStack.length - 1; i3 >= 0; --i3) {
            var scope$3 = this.scopeStack[i3];
            if (scope$3.lexical.indexOf(name) > -1 && !(scope$3.flags & SCOPE_SIMPLE_CATCH && scope$3.lexical[0] === name) || !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
              redeclared = true;
              break;
            }
            scope$3.var.push(name);
            if (this.inModule && scope$3.flags & SCOPE_TOP) {
              delete this.undefinedExports[name];
            }
            if (scope$3.flags & SCOPE_VAR) {
              break;
            }
          }
        }
        if (redeclared) {
          this.raiseRecoverable(pos, "Identifier '" + name + "' has already been declared");
        }
      };
      pp$3.checkLocalExport = function(id2) {
        if (this.scopeStack[0].lexical.indexOf(id2.name) === -1 && this.scopeStack[0].var.indexOf(id2.name) === -1) {
          this.undefinedExports[id2.name] = id2;
        }
      };
      pp$3.currentScope = function() {
        return this.scopeStack[this.scopeStack.length - 1];
      };
      pp$3.currentVarScope = function() {
        for (var i3 = this.scopeStack.length - 1; ; i3--) {
          var scope = this.scopeStack[i3];
          if (scope.flags & (SCOPE_VAR | SCOPE_CLASS_FIELD_INIT | SCOPE_CLASS_STATIC_BLOCK)) {
            return scope;
          }
        }
      };
      pp$3.currentThisScope = function() {
        for (var i3 = this.scopeStack.length - 1; ; i3--) {
          var scope = this.scopeStack[i3];
          if (scope.flags & (SCOPE_VAR | SCOPE_CLASS_FIELD_INIT | SCOPE_CLASS_STATIC_BLOCK) && !(scope.flags & SCOPE_ARROW)) {
            return scope;
          }
        }
      };
      var Node = function Node2(parser, pos, loc) {
        this.type = "";
        this.start = pos;
        this.end = 0;
        if (parser.options.locations) {
          this.loc = new SourceLocation(parser, loc);
        }
        if (parser.options.directSourceFile) {
          this.sourceFile = parser.options.directSourceFile;
        }
        if (parser.options.ranges) {
          this.range = [pos, 0];
        }
      };
      var pp$2 = Parser.prototype;
      pp$2.startNode = function() {
        return new Node(this, this.start, this.startLoc);
      };
      pp$2.startNodeAt = function(pos, loc) {
        return new Node(this, pos, loc);
      };
      function finishNodeAt(node2, type2, pos, loc) {
        node2.type = type2;
        node2.end = pos;
        if (this.options.locations) {
          node2.loc.end = loc;
        }
        if (this.options.ranges) {
          node2.range[1] = pos;
        }
        return node2;
      }
      pp$2.finishNode = function(node2, type2) {
        return finishNodeAt.call(this, node2, type2, this.lastTokEnd, this.lastTokEndLoc);
      };
      pp$2.finishNodeAt = function(node2, type2, pos, loc) {
        return finishNodeAt.call(this, node2, type2, pos, loc);
      };
      pp$2.copyNode = function(node2) {
        var newNode = new Node(this, node2.start, this.startLoc);
        for (var prop in node2) {
          newNode[prop] = node2[prop];
        }
        return newNode;
      };
      var scriptValuesAddedInUnicode = "Gara Garay Gukh Gurung_Khema Hrkt Katakana_Or_Hiragana Kawi Kirat_Rai Krai Nag_Mundari Nagm Ol_Onal Onao Sunu Sunuwar Todhri Todr Tulu_Tigalari Tutg Unknown Zzzz";
      var ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
      var ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
      var ecma11BinaryProperties = ecma10BinaryProperties;
      var ecma12BinaryProperties = ecma11BinaryProperties + " EBase EComp EMod EPres ExtPict";
      var ecma13BinaryProperties = ecma12BinaryProperties;
      var ecma14BinaryProperties = ecma13BinaryProperties;
      var unicodeBinaryProperties = {
        9: ecma9BinaryProperties,
        10: ecma10BinaryProperties,
        11: ecma11BinaryProperties,
        12: ecma12BinaryProperties,
        13: ecma13BinaryProperties,
        14: ecma14BinaryProperties
      };
      var ecma14BinaryPropertiesOfStrings = "Basic_Emoji Emoji_Keycap_Sequence RGI_Emoji_Modifier_Sequence RGI_Emoji_Flag_Sequence RGI_Emoji_Tag_Sequence RGI_Emoji_ZWJ_Sequence RGI_Emoji";
      var unicodeBinaryPropertiesOfStrings = {
        9: "",
        10: "",
        11: "",
        12: "",
        13: "",
        14: ecma14BinaryPropertiesOfStrings
      };
      var unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";
      var ecma9ScriptValues = "Adlam Adlm Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
      var ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
      var ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
      var ecma12ScriptValues = ecma11ScriptValues + " Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi";
      var ecma13ScriptValues = ecma12ScriptValues + " Cypro_Minoan Cpmn Old_Uyghur Ougr Tangsa Tnsa Toto Vithkuqi Vith";
      var ecma14ScriptValues = ecma13ScriptValues + " " + scriptValuesAddedInUnicode;
      var unicodeScriptValues = {
        9: ecma9ScriptValues,
        10: ecma10ScriptValues,
        11: ecma11ScriptValues,
        12: ecma12ScriptValues,
        13: ecma13ScriptValues,
        14: ecma14ScriptValues
      };
      var data2 = {};
      function buildUnicodeData(ecmaVersion3) {
        var d2 = data2[ecmaVersion3] = {
          binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion3] + " " + unicodeGeneralCategoryValues),
          binaryOfStrings: wordsRegexp(unicodeBinaryPropertiesOfStrings[ecmaVersion3]),
          nonBinary: {
            General_Category: wordsRegexp(unicodeGeneralCategoryValues),
            Script: wordsRegexp(unicodeScriptValues[ecmaVersion3])
          }
        };
        d2.nonBinary.Script_Extensions = d2.nonBinary.Script;
        d2.nonBinary.gc = d2.nonBinary.General_Category;
        d2.nonBinary.sc = d2.nonBinary.Script;
        d2.nonBinary.scx = d2.nonBinary.Script_Extensions;
      }
      for (var i2 = 0, list = [9, 10, 11, 12, 13, 14]; i2 < list.length; i2 += 1) {
        var ecmaVersion2 = list[i2];
        buildUnicodeData(ecmaVersion2);
      }
      var pp$1 = Parser.prototype;
      var BranchID = function BranchID2(parent, base) {
        this.parent = parent;
        this.base = base || this;
      };
      BranchID.prototype.separatedFrom = function separatedFrom(alt) {
        for (var self2 = this; self2; self2 = self2.parent) {
          for (var other = alt; other; other = other.parent) {
            if (self2.base === other.base && self2 !== other) {
              return true;
            }
          }
        }
        return false;
      };
      BranchID.prototype.sibling = function sibling() {
        return new BranchID(this.parent, this.base);
      };
      var RegExpValidationState = function RegExpValidationState2(parser) {
        this.parser = parser;
        this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "") + (parser.options.ecmaVersion >= 13 ? "d" : "") + (parser.options.ecmaVersion >= 15 ? "v" : "");
        this.unicodeProperties = data2[parser.options.ecmaVersion >= 14 ? 14 : parser.options.ecmaVersion];
        this.source = "";
        this.flags = "";
        this.start = 0;
        this.switchU = false;
        this.switchV = false;
        this.switchN = false;
        this.pos = 0;
        this.lastIntValue = 0;
        this.lastStringValue = "";
        this.lastAssertionIsQuantifiable = false;
        this.numCapturingParens = 0;
        this.maxBackReference = 0;
        this.groupNames = /* @__PURE__ */ Object.create(null);
        this.backReferenceNames = [];
        this.branchID = null;
      };
      RegExpValidationState.prototype.reset = function reset(start, pattern2, flags2) {
        var unicodeSets = flags2.indexOf("v") !== -1;
        var unicode2 = flags2.indexOf("u") !== -1;
        this.start = start | 0;
        this.source = pattern2 + "";
        this.flags = flags2;
        if (unicodeSets && this.parser.options.ecmaVersion >= 15) {
          this.switchU = true;
          this.switchV = true;
          this.switchN = true;
        } else {
          this.switchU = unicode2 && this.parser.options.ecmaVersion >= 6;
          this.switchV = false;
          this.switchN = unicode2 && this.parser.options.ecmaVersion >= 9;
        }
      };
      RegExpValidationState.prototype.raise = function raise(message) {
        this.parser.raiseRecoverable(this.start, "Invalid regular expression: /" + this.source + "/: " + message);
      };
      RegExpValidationState.prototype.at = function at(i3, forceU) {
        if (forceU === void 0) forceU = false;
        var s2 = this.source;
        var l2 = s2.length;
        if (i3 >= l2) {
          return -1;
        }
        var c2 = s2.charCodeAt(i3);
        if (!(forceU || this.switchU) || c2 <= 55295 || c2 >= 57344 || i3 + 1 >= l2) {
          return c2;
        }
        var next = s2.charCodeAt(i3 + 1);
        return next >= 56320 && next <= 57343 ? (c2 << 10) + next - 56613888 : c2;
      };
      RegExpValidationState.prototype.nextIndex = function nextIndex(i3, forceU) {
        if (forceU === void 0) forceU = false;
        var s2 = this.source;
        var l2 = s2.length;
        if (i3 >= l2) {
          return l2;
        }
        var c2 = s2.charCodeAt(i3), next;
        if (!(forceU || this.switchU) || c2 <= 55295 || c2 >= 57344 || i3 + 1 >= l2 || (next = s2.charCodeAt(i3 + 1)) < 56320 || next > 57343) {
          return i3 + 1;
        }
        return i3 + 2;
      };
      RegExpValidationState.prototype.current = function current(forceU) {
        if (forceU === void 0) forceU = false;
        return this.at(this.pos, forceU);
      };
      RegExpValidationState.prototype.lookahead = function lookahead(forceU) {
        if (forceU === void 0) forceU = false;
        return this.at(this.nextIndex(this.pos, forceU), forceU);
      };
      RegExpValidationState.prototype.advance = function advance(forceU) {
        if (forceU === void 0) forceU = false;
        this.pos = this.nextIndex(this.pos, forceU);
      };
      RegExpValidationState.prototype.eat = function eat(ch, forceU) {
        if (forceU === void 0) forceU = false;
        if (this.current(forceU) === ch) {
          this.advance(forceU);
          return true;
        }
        return false;
      };
      RegExpValidationState.prototype.eatChars = function eatChars(chs, forceU) {
        if (forceU === void 0) forceU = false;
        var pos = this.pos;
        for (var i3 = 0, list2 = chs; i3 < list2.length; i3 += 1) {
          var ch = list2[i3];
          var current = this.at(pos, forceU);
          if (current === -1 || current !== ch) {
            return false;
          }
          pos = this.nextIndex(pos, forceU);
        }
        this.pos = pos;
        return true;
      };
      pp$1.validateRegExpFlags = function(state) {
        var validFlags = state.validFlags;
        var flags2 = state.flags;
        var u2 = false;
        var v2 = false;
        for (var i3 = 0; i3 < flags2.length; i3++) {
          var flag = flags2.charAt(i3);
          if (validFlags.indexOf(flag) === -1) {
            this.raise(state.start, "Invalid regular expression flag");
          }
          if (flags2.indexOf(flag, i3 + 1) > -1) {
            this.raise(state.start, "Duplicate regular expression flag");
          }
          if (flag === "u") {
            u2 = true;
          }
          if (flag === "v") {
            v2 = true;
          }
        }
        if (this.options.ecmaVersion >= 15 && u2 && v2) {
          this.raise(state.start, "Invalid regular expression flag");
        }
      };
      function hasProp(obj) {
        for (var _ in obj) {
          return true;
        }
        return false;
      }
      pp$1.validateRegExpPattern = function(state) {
        this.regexp_pattern(state);
        if (!state.switchN && this.options.ecmaVersion >= 9 && hasProp(state.groupNames)) {
          state.switchN = true;
          this.regexp_pattern(state);
        }
      };
      pp$1.regexp_pattern = function(state) {
        state.pos = 0;
        state.lastIntValue = 0;
        state.lastStringValue = "";
        state.lastAssertionIsQuantifiable = false;
        state.numCapturingParens = 0;
        state.maxBackReference = 0;
        state.groupNames = /* @__PURE__ */ Object.create(null);
        state.backReferenceNames.length = 0;
        state.branchID = null;
        this.regexp_disjunction(state);
        if (state.pos !== state.source.length) {
          if (state.eat(
            41
            /* ) */
          )) {
            state.raise("Unmatched ')'");
          }
          if (state.eat(
            93
            /* ] */
          ) || state.eat(
            125
            /* } */
          )) {
            state.raise("Lone quantifier brackets");
          }
        }
        if (state.maxBackReference > state.numCapturingParens) {
          state.raise("Invalid escape");
        }
        for (var i3 = 0, list2 = state.backReferenceNames; i3 < list2.length; i3 += 1) {
          var name = list2[i3];
          if (!state.groupNames[name]) {
            state.raise("Invalid named capture referenced");
          }
        }
      };
      pp$1.regexp_disjunction = function(state) {
        var trackDisjunction = this.options.ecmaVersion >= 16;
        if (trackDisjunction) {
          state.branchID = new BranchID(state.branchID, null);
        }
        this.regexp_alternative(state);
        while (state.eat(
          124
          /* | */
        )) {
          if (trackDisjunction) {
            state.branchID = state.branchID.sibling();
          }
          this.regexp_alternative(state);
        }
        if (trackDisjunction) {
          state.branchID = state.branchID.parent;
        }
        if (this.regexp_eatQuantifier(state, true)) {
          state.raise("Nothing to repeat");
        }
        if (state.eat(
          123
          /* { */
        )) {
          state.raise("Lone quantifier brackets");
        }
      };
      pp$1.regexp_alternative = function(state) {
        while (state.pos < state.source.length && this.regexp_eatTerm(state)) {
        }
      };
      pp$1.regexp_eatTerm = function(state) {
        if (this.regexp_eatAssertion(state)) {
          if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
            if (state.switchU) {
              state.raise("Invalid quantifier");
            }
          }
          return true;
        }
        if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
          this.regexp_eatQuantifier(state);
          return true;
        }
        return false;
      };
      pp$1.regexp_eatAssertion = function(state) {
        var start = state.pos;
        state.lastAssertionIsQuantifiable = false;
        if (state.eat(
          94
          /* ^ */
        ) || state.eat(
          36
          /* $ */
        )) {
          return true;
        }
        if (state.eat(
          92
          /* \ */
        )) {
          if (state.eat(
            66
            /* B */
          ) || state.eat(
            98
            /* b */
          )) {
            return true;
          }
          state.pos = start;
        }
        if (state.eat(
          40
          /* ( */
        ) && state.eat(
          63
          /* ? */
        )) {
          var lookbehind = false;
          if (this.options.ecmaVersion >= 9) {
            lookbehind = state.eat(
              60
              /* < */
            );
          }
          if (state.eat(
            61
            /* = */
          ) || state.eat(
            33
            /* ! */
          )) {
            this.regexp_disjunction(state);
            if (!state.eat(
              41
              /* ) */
            )) {
              state.raise("Unterminated group");
            }
            state.lastAssertionIsQuantifiable = !lookbehind;
            return true;
          }
        }
        state.pos = start;
        return false;
      };
      pp$1.regexp_eatQuantifier = function(state, noError) {
        if (noError === void 0) noError = false;
        if (this.regexp_eatQuantifierPrefix(state, noError)) {
          state.eat(
            63
            /* ? */
          );
          return true;
        }
        return false;
      };
      pp$1.regexp_eatQuantifierPrefix = function(state, noError) {
        return state.eat(
          42
          /* * */
        ) || state.eat(
          43
          /* + */
        ) || state.eat(
          63
          /* ? */
        ) || this.regexp_eatBracedQuantifier(state, noError);
      };
      pp$1.regexp_eatBracedQuantifier = function(state, noError) {
        var start = state.pos;
        if (state.eat(
          123
          /* { */
        )) {
          var min = 0, max = -1;
          if (this.regexp_eatDecimalDigits(state)) {
            min = state.lastIntValue;
            if (state.eat(
              44
              /* , */
            ) && this.regexp_eatDecimalDigits(state)) {
              max = state.lastIntValue;
            }
            if (state.eat(
              125
              /* } */
            )) {
              if (max !== -1 && max < min && !noError) {
                state.raise("numbers out of order in {} quantifier");
              }
              return true;
            }
          }
          if (state.switchU && !noError) {
            state.raise("Incomplete quantifier");
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatAtom = function(state) {
        return this.regexp_eatPatternCharacters(state) || state.eat(
          46
          /* . */
        ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state);
      };
      pp$1.regexp_eatReverseSolidusAtomEscape = function(state) {
        var start = state.pos;
        if (state.eat(
          92
          /* \ */
        )) {
          if (this.regexp_eatAtomEscape(state)) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatUncapturingGroup = function(state) {
        var start = state.pos;
        if (state.eat(
          40
          /* ( */
        )) {
          if (state.eat(
            63
            /* ? */
          )) {
            if (this.options.ecmaVersion >= 16) {
              var addModifiers = this.regexp_eatModifiers(state);
              var hasHyphen = state.eat(
                45
                /* - */
              );
              if (addModifiers || hasHyphen) {
                for (var i3 = 0; i3 < addModifiers.length; i3++) {
                  var modifier = addModifiers.charAt(i3);
                  if (addModifiers.indexOf(modifier, i3 + 1) > -1) {
                    state.raise("Duplicate regular expression modifiers");
                  }
                }
                if (hasHyphen) {
                  var removeModifiers = this.regexp_eatModifiers(state);
                  if (!addModifiers && !removeModifiers && state.current() === 58) {
                    state.raise("Invalid regular expression modifiers");
                  }
                  for (var i$1 = 0; i$1 < removeModifiers.length; i$1++) {
                    var modifier$1 = removeModifiers.charAt(i$1);
                    if (removeModifiers.indexOf(modifier$1, i$1 + 1) > -1 || addModifiers.indexOf(modifier$1) > -1) {
                      state.raise("Duplicate regular expression modifiers");
                    }
                  }
                }
              }
            }
            if (state.eat(
              58
              /* : */
            )) {
              this.regexp_disjunction(state);
              if (state.eat(
                41
                /* ) */
              )) {
                return true;
              }
              state.raise("Unterminated group");
            }
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatCapturingGroup = function(state) {
        if (state.eat(
          40
          /* ( */
        )) {
          if (this.options.ecmaVersion >= 9) {
            this.regexp_groupSpecifier(state);
          } else if (state.current() === 63) {
            state.raise("Invalid group");
          }
          this.regexp_disjunction(state);
          if (state.eat(
            41
            /* ) */
          )) {
            state.numCapturingParens += 1;
            return true;
          }
          state.raise("Unterminated group");
        }
        return false;
      };
      pp$1.regexp_eatModifiers = function(state) {
        var modifiers = "";
        var ch = 0;
        while ((ch = state.current()) !== -1 && isRegularExpressionModifier(ch)) {
          modifiers += codePointToString(ch);
          state.advance();
        }
        return modifiers;
      };
      function isRegularExpressionModifier(ch) {
        return ch === 105 || ch === 109 || ch === 115;
      }
      pp$1.regexp_eatExtendedAtom = function(state) {
        return state.eat(
          46
          /* . */
        ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state) || this.regexp_eatInvalidBracedQuantifier(state) || this.regexp_eatExtendedPatternCharacter(state);
      };
      pp$1.regexp_eatInvalidBracedQuantifier = function(state) {
        if (this.regexp_eatBracedQuantifier(state, true)) {
          state.raise("Nothing to repeat");
        }
        return false;
      };
      pp$1.regexp_eatSyntaxCharacter = function(state) {
        var ch = state.current();
        if (isSyntaxCharacter(ch)) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      function isSyntaxCharacter(ch) {
        return ch === 36 || ch >= 40 && ch <= 43 || ch === 46 || ch === 63 || ch >= 91 && ch <= 94 || ch >= 123 && ch <= 125;
      }
      pp$1.regexp_eatPatternCharacters = function(state) {
        var start = state.pos;
        var ch = 0;
        while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
          state.advance();
        }
        return state.pos !== start;
      };
      pp$1.regexp_eatExtendedPatternCharacter = function(state) {
        var ch = state.current();
        if (ch !== -1 && ch !== 36 && !(ch >= 40 && ch <= 43) && ch !== 46 && ch !== 63 && ch !== 91 && ch !== 94 && ch !== 124) {
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_groupSpecifier = function(state) {
        if (state.eat(
          63
          /* ? */
        )) {
          if (!this.regexp_eatGroupName(state)) {
            state.raise("Invalid group");
          }
          var trackDisjunction = this.options.ecmaVersion >= 16;
          var known = state.groupNames[state.lastStringValue];
          if (known) {
            if (trackDisjunction) {
              for (var i3 = 0, list2 = known; i3 < list2.length; i3 += 1) {
                var altID = list2[i3];
                if (!altID.separatedFrom(state.branchID)) {
                  state.raise("Duplicate capture group name");
                }
              }
            } else {
              state.raise("Duplicate capture group name");
            }
          }
          if (trackDisjunction) {
            (known || (state.groupNames[state.lastStringValue] = [])).push(state.branchID);
          } else {
            state.groupNames[state.lastStringValue] = true;
          }
        }
      };
      pp$1.regexp_eatGroupName = function(state) {
        state.lastStringValue = "";
        if (state.eat(
          60
          /* < */
        )) {
          if (this.regexp_eatRegExpIdentifierName(state) && state.eat(
            62
            /* > */
          )) {
            return true;
          }
          state.raise("Invalid capture group name");
        }
        return false;
      };
      pp$1.regexp_eatRegExpIdentifierName = function(state) {
        state.lastStringValue = "";
        if (this.regexp_eatRegExpIdentifierStart(state)) {
          state.lastStringValue += codePointToString(state.lastIntValue);
          while (this.regexp_eatRegExpIdentifierPart(state)) {
            state.lastStringValue += codePointToString(state.lastIntValue);
          }
          return true;
        }
        return false;
      };
      pp$1.regexp_eatRegExpIdentifierStart = function(state) {
        var start = state.pos;
        var forceU = this.options.ecmaVersion >= 11;
        var ch = state.current(forceU);
        state.advance(forceU);
        if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
          ch = state.lastIntValue;
        }
        if (isRegExpIdentifierStart(ch)) {
          state.lastIntValue = ch;
          return true;
        }
        state.pos = start;
        return false;
      };
      function isRegExpIdentifierStart(ch) {
        return isIdentifierStart(ch, true) || ch === 36 || ch === 95;
      }
      pp$1.regexp_eatRegExpIdentifierPart = function(state) {
        var start = state.pos;
        var forceU = this.options.ecmaVersion >= 11;
        var ch = state.current(forceU);
        state.advance(forceU);
        if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
          ch = state.lastIntValue;
        }
        if (isRegExpIdentifierPart(ch)) {
          state.lastIntValue = ch;
          return true;
        }
        state.pos = start;
        return false;
      };
      function isRegExpIdentifierPart(ch) {
        return isIdentifierChar(ch, true) || ch === 36 || ch === 95 || ch === 8204 || ch === 8205;
      }
      pp$1.regexp_eatAtomEscape = function(state) {
        if (this.regexp_eatBackReference(state) || this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state) || state.switchN && this.regexp_eatKGroupName(state)) {
          return true;
        }
        if (state.switchU) {
          if (state.current() === 99) {
            state.raise("Invalid unicode escape");
          }
          state.raise("Invalid escape");
        }
        return false;
      };
      pp$1.regexp_eatBackReference = function(state) {
        var start = state.pos;
        if (this.regexp_eatDecimalEscape(state)) {
          var n2 = state.lastIntValue;
          if (state.switchU) {
            if (n2 > state.maxBackReference) {
              state.maxBackReference = n2;
            }
            return true;
          }
          if (n2 <= state.numCapturingParens) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatKGroupName = function(state) {
        if (state.eat(
          107
          /* k */
        )) {
          if (this.regexp_eatGroupName(state)) {
            state.backReferenceNames.push(state.lastStringValue);
            return true;
          }
          state.raise("Invalid named reference");
        }
        return false;
      };
      pp$1.regexp_eatCharacterEscape = function(state) {
        return this.regexp_eatControlEscape(state) || this.regexp_eatCControlLetter(state) || this.regexp_eatZero(state) || this.regexp_eatHexEscapeSequence(state) || this.regexp_eatRegExpUnicodeEscapeSequence(state, false) || !state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state) || this.regexp_eatIdentityEscape(state);
      };
      pp$1.regexp_eatCControlLetter = function(state) {
        var start = state.pos;
        if (state.eat(
          99
          /* c */
        )) {
          if (this.regexp_eatControlLetter(state)) {
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatZero = function(state) {
        if (state.current() === 48 && !isDecimalDigit(state.lookahead())) {
          state.lastIntValue = 0;
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_eatControlEscape = function(state) {
        var ch = state.current();
        if (ch === 116) {
          state.lastIntValue = 9;
          state.advance();
          return true;
        }
        if (ch === 110) {
          state.lastIntValue = 10;
          state.advance();
          return true;
        }
        if (ch === 118) {
          state.lastIntValue = 11;
          state.advance();
          return true;
        }
        if (ch === 102) {
          state.lastIntValue = 12;
          state.advance();
          return true;
        }
        if (ch === 114) {
          state.lastIntValue = 13;
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_eatControlLetter = function(state) {
        var ch = state.current();
        if (isControlLetter(ch)) {
          state.lastIntValue = ch % 32;
          state.advance();
          return true;
        }
        return false;
      };
      function isControlLetter(ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
      }
      pp$1.regexp_eatRegExpUnicodeEscapeSequence = function(state, forceU) {
        if (forceU === void 0) forceU = false;
        var start = state.pos;
        var switchU = forceU || state.switchU;
        if (state.eat(
          117
          /* u */
        )) {
          if (this.regexp_eatFixedHexDigits(state, 4)) {
            var lead = state.lastIntValue;
            if (switchU && lead >= 55296 && lead <= 56319) {
              var leadSurrogateEnd = state.pos;
              if (state.eat(
                92
                /* \ */
              ) && state.eat(
                117
                /* u */
              ) && this.regexp_eatFixedHexDigits(state, 4)) {
                var trail = state.lastIntValue;
                if (trail >= 56320 && trail <= 57343) {
                  state.lastIntValue = (lead - 55296) * 1024 + (trail - 56320) + 65536;
                  return true;
                }
              }
              state.pos = leadSurrogateEnd;
              state.lastIntValue = lead;
            }
            return true;
          }
          if (switchU && state.eat(
            123
            /* { */
          ) && this.regexp_eatHexDigits(state) && state.eat(
            125
            /* } */
          ) && isValidUnicode(state.lastIntValue)) {
            return true;
          }
          if (switchU) {
            state.raise("Invalid unicode escape");
          }
          state.pos = start;
        }
        return false;
      };
      function isValidUnicode(ch) {
        return ch >= 0 && ch <= 1114111;
      }
      pp$1.regexp_eatIdentityEscape = function(state) {
        if (state.switchU) {
          if (this.regexp_eatSyntaxCharacter(state)) {
            return true;
          }
          if (state.eat(
            47
            /* / */
          )) {
            state.lastIntValue = 47;
            return true;
          }
          return false;
        }
        var ch = state.current();
        if (ch !== 99 && (!state.switchN || ch !== 107)) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_eatDecimalEscape = function(state) {
        state.lastIntValue = 0;
        var ch = state.current();
        if (ch >= 49 && ch <= 57) {
          do {
            state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
            state.advance();
          } while ((ch = state.current()) >= 48 && ch <= 57);
          return true;
        }
        return false;
      };
      var CharSetNone = 0;
      var CharSetOk = 1;
      var CharSetString = 2;
      pp$1.regexp_eatCharacterClassEscape = function(state) {
        var ch = state.current();
        if (isCharacterClassEscape(ch)) {
          state.lastIntValue = -1;
          state.advance();
          return CharSetOk;
        }
        var negate = false;
        if (state.switchU && this.options.ecmaVersion >= 9 && ((negate = ch === 80) || ch === 112)) {
          state.lastIntValue = -1;
          state.advance();
          var result;
          if (state.eat(
            123
            /* { */
          ) && (result = this.regexp_eatUnicodePropertyValueExpression(state)) && state.eat(
            125
            /* } */
          )) {
            if (negate && result === CharSetString) {
              state.raise("Invalid property name");
            }
            return result;
          }
          state.raise("Invalid property name");
        }
        return CharSetNone;
      };
      function isCharacterClassEscape(ch) {
        return ch === 100 || ch === 68 || ch === 115 || ch === 83 || ch === 119 || ch === 87;
      }
      pp$1.regexp_eatUnicodePropertyValueExpression = function(state) {
        var start = state.pos;
        if (this.regexp_eatUnicodePropertyName(state) && state.eat(
          61
          /* = */
        )) {
          var name = state.lastStringValue;
          if (this.regexp_eatUnicodePropertyValue(state)) {
            var value = state.lastStringValue;
            this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
            return CharSetOk;
          }
        }
        state.pos = start;
        if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
          var nameOrValue = state.lastStringValue;
          return this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue);
        }
        return CharSetNone;
      };
      pp$1.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
        if (!hasOwn(state.unicodeProperties.nonBinary, name)) {
          state.raise("Invalid property name");
        }
        if (!state.unicodeProperties.nonBinary[name].test(value)) {
          state.raise("Invalid property value");
        }
      };
      pp$1.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
        if (state.unicodeProperties.binary.test(nameOrValue)) {
          return CharSetOk;
        }
        if (state.switchV && state.unicodeProperties.binaryOfStrings.test(nameOrValue)) {
          return CharSetString;
        }
        state.raise("Invalid property name");
      };
      pp$1.regexp_eatUnicodePropertyName = function(state) {
        var ch = 0;
        state.lastStringValue = "";
        while (isUnicodePropertyNameCharacter(ch = state.current())) {
          state.lastStringValue += codePointToString(ch);
          state.advance();
        }
        return state.lastStringValue !== "";
      };
      function isUnicodePropertyNameCharacter(ch) {
        return isControlLetter(ch) || ch === 95;
      }
      pp$1.regexp_eatUnicodePropertyValue = function(state) {
        var ch = 0;
        state.lastStringValue = "";
        while (isUnicodePropertyValueCharacter(ch = state.current())) {
          state.lastStringValue += codePointToString(ch);
          state.advance();
        }
        return state.lastStringValue !== "";
      };
      function isUnicodePropertyValueCharacter(ch) {
        return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch);
      }
      pp$1.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
        return this.regexp_eatUnicodePropertyValue(state);
      };
      pp$1.regexp_eatCharacterClass = function(state) {
        if (state.eat(
          91
          /* [ */
        )) {
          var negate = state.eat(
            94
            /* ^ */
          );
          var result = this.regexp_classContents(state);
          if (!state.eat(
            93
            /* ] */
          )) {
            state.raise("Unterminated character class");
          }
          if (negate && result === CharSetString) {
            state.raise("Negated character class may contain strings");
          }
          return true;
        }
        return false;
      };
      pp$1.regexp_classContents = function(state) {
        if (state.current() === 93) {
          return CharSetOk;
        }
        if (state.switchV) {
          return this.regexp_classSetExpression(state);
        }
        this.regexp_nonEmptyClassRanges(state);
        return CharSetOk;
      };
      pp$1.regexp_nonEmptyClassRanges = function(state) {
        while (this.regexp_eatClassAtom(state)) {
          var left = state.lastIntValue;
          if (state.eat(
            45
            /* - */
          ) && this.regexp_eatClassAtom(state)) {
            var right = state.lastIntValue;
            if (state.switchU && (left === -1 || right === -1)) {
              state.raise("Invalid character class");
            }
            if (left !== -1 && right !== -1 && left > right) {
              state.raise("Range out of order in character class");
            }
          }
        }
      };
      pp$1.regexp_eatClassAtom = function(state) {
        var start = state.pos;
        if (state.eat(
          92
          /* \ */
        )) {
          if (this.regexp_eatClassEscape(state)) {
            return true;
          }
          if (state.switchU) {
            var ch$1 = state.current();
            if (ch$1 === 99 || isOctalDigit(ch$1)) {
              state.raise("Invalid class escape");
            }
            state.raise("Invalid escape");
          }
          state.pos = start;
        }
        var ch = state.current();
        if (ch !== 93) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_eatClassEscape = function(state) {
        var start = state.pos;
        if (state.eat(
          98
          /* b */
        )) {
          state.lastIntValue = 8;
          return true;
        }
        if (state.switchU && state.eat(
          45
          /* - */
        )) {
          state.lastIntValue = 45;
          return true;
        }
        if (!state.switchU && state.eat(
          99
          /* c */
        )) {
          if (this.regexp_eatClassControlLetter(state)) {
            return true;
          }
          state.pos = start;
        }
        return this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state);
      };
      pp$1.regexp_classSetExpression = function(state) {
        var result = CharSetOk, subResult;
        if (this.regexp_eatClassSetRange(state)) ;
        else if (subResult = this.regexp_eatClassSetOperand(state)) {
          if (subResult === CharSetString) {
            result = CharSetString;
          }
          var start = state.pos;
          while (state.eatChars(
            [38, 38]
            /* && */
          )) {
            if (state.current() !== 38 && (subResult = this.regexp_eatClassSetOperand(state))) {
              if (subResult !== CharSetString) {
                result = CharSetOk;
              }
              continue;
            }
            state.raise("Invalid character in character class");
          }
          if (start !== state.pos) {
            return result;
          }
          while (state.eatChars(
            [45, 45]
            /* -- */
          )) {
            if (this.regexp_eatClassSetOperand(state)) {
              continue;
            }
            state.raise("Invalid character in character class");
          }
          if (start !== state.pos) {
            return result;
          }
        } else {
          state.raise("Invalid character in character class");
        }
        for (; ; ) {
          if (this.regexp_eatClassSetRange(state)) {
            continue;
          }
          subResult = this.regexp_eatClassSetOperand(state);
          if (!subResult) {
            return result;
          }
          if (subResult === CharSetString) {
            result = CharSetString;
          }
        }
      };
      pp$1.regexp_eatClassSetRange = function(state) {
        var start = state.pos;
        if (this.regexp_eatClassSetCharacter(state)) {
          var left = state.lastIntValue;
          if (state.eat(
            45
            /* - */
          ) && this.regexp_eatClassSetCharacter(state)) {
            var right = state.lastIntValue;
            if (left !== -1 && right !== -1 && left > right) {
              state.raise("Range out of order in character class");
            }
            return true;
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatClassSetOperand = function(state) {
        if (this.regexp_eatClassSetCharacter(state)) {
          return CharSetOk;
        }
        return this.regexp_eatClassStringDisjunction(state) || this.regexp_eatNestedClass(state);
      };
      pp$1.regexp_eatNestedClass = function(state) {
        var start = state.pos;
        if (state.eat(
          91
          /* [ */
        )) {
          var negate = state.eat(
            94
            /* ^ */
          );
          var result = this.regexp_classContents(state);
          if (state.eat(
            93
            /* ] */
          )) {
            if (negate && result === CharSetString) {
              state.raise("Negated character class may contain strings");
            }
            return result;
          }
          state.pos = start;
        }
        if (state.eat(
          92
          /* \ */
        )) {
          var result$1 = this.regexp_eatCharacterClassEscape(state);
          if (result$1) {
            return result$1;
          }
          state.pos = start;
        }
        return null;
      };
      pp$1.regexp_eatClassStringDisjunction = function(state) {
        var start = state.pos;
        if (state.eatChars(
          [92, 113]
          /* \q */
        )) {
          if (state.eat(
            123
            /* { */
          )) {
            var result = this.regexp_classStringDisjunctionContents(state);
            if (state.eat(
              125
              /* } */
            )) {
              return result;
            }
          } else {
            state.raise("Invalid escape");
          }
          state.pos = start;
        }
        return null;
      };
      pp$1.regexp_classStringDisjunctionContents = function(state) {
        var result = this.regexp_classString(state);
        while (state.eat(
          124
          /* | */
        )) {
          if (this.regexp_classString(state) === CharSetString) {
            result = CharSetString;
          }
        }
        return result;
      };
      pp$1.regexp_classString = function(state) {
        var count = 0;
        while (this.regexp_eatClassSetCharacter(state)) {
          count++;
        }
        return count === 1 ? CharSetOk : CharSetString;
      };
      pp$1.regexp_eatClassSetCharacter = function(state) {
        var start = state.pos;
        if (state.eat(
          92
          /* \ */
        )) {
          if (this.regexp_eatCharacterEscape(state) || this.regexp_eatClassSetReservedPunctuator(state)) {
            return true;
          }
          if (state.eat(
            98
            /* b */
          )) {
            state.lastIntValue = 8;
            return true;
          }
          state.pos = start;
          return false;
        }
        var ch = state.current();
        if (ch < 0 || ch === state.lookahead() && isClassSetReservedDoublePunctuatorCharacter(ch)) {
          return false;
        }
        if (isClassSetSyntaxCharacter(ch)) {
          return false;
        }
        state.advance();
        state.lastIntValue = ch;
        return true;
      };
      function isClassSetReservedDoublePunctuatorCharacter(ch) {
        return ch === 33 || ch >= 35 && ch <= 38 || ch >= 42 && ch <= 44 || ch === 46 || ch >= 58 && ch <= 64 || ch === 94 || ch === 96 || ch === 126;
      }
      function isClassSetSyntaxCharacter(ch) {
        return ch === 40 || ch === 41 || ch === 45 || ch === 47 || ch >= 91 && ch <= 93 || ch >= 123 && ch <= 125;
      }
      pp$1.regexp_eatClassSetReservedPunctuator = function(state) {
        var ch = state.current();
        if (isClassSetReservedPunctuator(ch)) {
          state.lastIntValue = ch;
          state.advance();
          return true;
        }
        return false;
      };
      function isClassSetReservedPunctuator(ch) {
        return ch === 33 || ch === 35 || ch === 37 || ch === 38 || ch === 44 || ch === 45 || ch >= 58 && ch <= 62 || ch === 64 || ch === 96 || ch === 126;
      }
      pp$1.regexp_eatClassControlLetter = function(state) {
        var ch = state.current();
        if (isDecimalDigit(ch) || ch === 95) {
          state.lastIntValue = ch % 32;
          state.advance();
          return true;
        }
        return false;
      };
      pp$1.regexp_eatHexEscapeSequence = function(state) {
        var start = state.pos;
        if (state.eat(
          120
          /* x */
        )) {
          if (this.regexp_eatFixedHexDigits(state, 2)) {
            return true;
          }
          if (state.switchU) {
            state.raise("Invalid escape");
          }
          state.pos = start;
        }
        return false;
      };
      pp$1.regexp_eatDecimalDigits = function(state) {
        var start = state.pos;
        var ch = 0;
        state.lastIntValue = 0;
        while (isDecimalDigit(ch = state.current())) {
          state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
          state.advance();
        }
        return state.pos !== start;
      };
      function isDecimalDigit(ch) {
        return ch >= 48 && ch <= 57;
      }
      pp$1.regexp_eatHexDigits = function(state) {
        var start = state.pos;
        var ch = 0;
        state.lastIntValue = 0;
        while (isHexDigit(ch = state.current())) {
          state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
          state.advance();
        }
        return state.pos !== start;
      };
      function isHexDigit(ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
      }
      function hexToInt(ch) {
        if (ch >= 65 && ch <= 70) {
          return 10 + (ch - 65);
        }
        if (ch >= 97 && ch <= 102) {
          return 10 + (ch - 97);
        }
        return ch - 48;
      }
      pp$1.regexp_eatLegacyOctalEscapeSequence = function(state) {
        if (this.regexp_eatOctalDigit(state)) {
          var n1 = state.lastIntValue;
          if (this.regexp_eatOctalDigit(state)) {
            var n2 = state.lastIntValue;
            if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
              state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
            } else {
              state.lastIntValue = n1 * 8 + n2;
            }
          } else {
            state.lastIntValue = n1;
          }
          return true;
        }
        return false;
      };
      pp$1.regexp_eatOctalDigit = function(state) {
        var ch = state.current();
        if (isOctalDigit(ch)) {
          state.lastIntValue = ch - 48;
          state.advance();
          return true;
        }
        state.lastIntValue = 0;
        return false;
      };
      function isOctalDigit(ch) {
        return ch >= 48 && ch <= 55;
      }
      pp$1.regexp_eatFixedHexDigits = function(state, length) {
        var start = state.pos;
        state.lastIntValue = 0;
        for (var i3 = 0; i3 < length; ++i3) {
          var ch = state.current();
          if (!isHexDigit(ch)) {
            state.pos = start;
            return false;
          }
          state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
          state.advance();
        }
        return true;
      };
      var Token = function Token2(p2) {
        this.type = p2.type;
        this.value = p2.value;
        this.start = p2.start;
        this.end = p2.end;
        if (p2.options.locations) {
          this.loc = new SourceLocation(p2, p2.startLoc, p2.endLoc);
        }
        if (p2.options.ranges) {
          this.range = [p2.start, p2.end];
        }
      };
      var pp = Parser.prototype;
      pp.next = function(ignoreEscapeSequenceInKeyword) {
        if (!ignoreEscapeSequenceInKeyword && this.type.keyword && this.containsEsc) {
          this.raiseRecoverable(this.start, "Escape sequence in keyword " + this.type.keyword);
        }
        if (this.options.onToken) {
          this.options.onToken(new Token(this));
        }
        this.lastTokEnd = this.end;
        this.lastTokStart = this.start;
        this.lastTokEndLoc = this.endLoc;
        this.lastTokStartLoc = this.startLoc;
        this.nextToken();
      };
      pp.getToken = function() {
        this.next();
        return new Token(this);
      };
      if (typeof Symbol !== "undefined") {
        pp[Symbol.iterator] = function() {
          var this$1$1 = this;
          return {
            next: function() {
              var token = this$1$1.getToken();
              return {
                done: token.type === types$1.eof,
                value: token
              };
            }
          };
        };
      }
      pp.nextToken = function() {
        var curContext = this.curContext();
        if (!curContext || !curContext.preserveSpace) {
          this.skipSpace();
        }
        this.start = this.pos;
        if (this.options.locations) {
          this.startLoc = this.curPosition();
        }
        if (this.pos >= this.input.length) {
          return this.finishToken(types$1.eof);
        }
        if (curContext.override) {
          return curContext.override(this);
        } else {
          this.readToken(this.fullCharCodeAtPos());
        }
      };
      pp.readToken = function(code2) {
        if (isIdentifierStart(code2, this.options.ecmaVersion >= 6) || code2 === 92) {
          return this.readWord();
        }
        return this.getTokenFromCode(code2);
      };
      pp.fullCharCodeAtPos = function() {
        var code2 = this.input.charCodeAt(this.pos);
        if (code2 <= 55295 || code2 >= 56320) {
          return code2;
        }
        var next = this.input.charCodeAt(this.pos + 1);
        return next <= 56319 || next >= 57344 ? code2 : (code2 << 10) + next - 56613888;
      };
      pp.skipBlockComment = function() {
        var startLoc = this.options.onComment && this.curPosition();
        var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
        if (end === -1) {
          this.raise(this.pos - 2, "Unterminated comment");
        }
        this.pos = end + 2;
        if (this.options.locations) {
          for (var nextBreak = void 0, pos = start; (nextBreak = nextLineBreak(this.input, pos, this.pos)) > -1; ) {
            ++this.curLine;
            pos = this.lineStart = nextBreak;
          }
        }
        if (this.options.onComment) {
          this.options.onComment(
            true,
            this.input.slice(start + 2, end),
            start,
            this.pos,
            startLoc,
            this.curPosition()
          );
        }
      };
      pp.skipLineComment = function(startSkip) {
        var start = this.pos;
        var startLoc = this.options.onComment && this.curPosition();
        var ch = this.input.charCodeAt(this.pos += startSkip);
        while (this.pos < this.input.length && !isNewLine(ch)) {
          ch = this.input.charCodeAt(++this.pos);
        }
        if (this.options.onComment) {
          this.options.onComment(
            false,
            this.input.slice(start + startSkip, this.pos),
            start,
            this.pos,
            startLoc,
            this.curPosition()
          );
        }
      };
      pp.skipSpace = function() {
        loop: while (this.pos < this.input.length) {
          var ch = this.input.charCodeAt(this.pos);
          switch (ch) {
            case 32:
            case 160:
              ++this.pos;
              break;
            case 13:
              if (this.input.charCodeAt(this.pos + 1) === 10) {
                ++this.pos;
              }
            case 10:
            case 8232:
            case 8233:
              ++this.pos;
              if (this.options.locations) {
                ++this.curLine;
                this.lineStart = this.pos;
              }
              break;
            case 47:
              switch (this.input.charCodeAt(this.pos + 1)) {
                case 42:
                  this.skipBlockComment();
                  break;
                case 47:
                  this.skipLineComment(2);
                  break;
                default:
                  break loop;
              }
              break;
            default:
              if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
                ++this.pos;
              } else {
                break loop;
              }
          }
        }
      };
      pp.finishToken = function(type2, val) {
        this.end = this.pos;
        if (this.options.locations) {
          this.endLoc = this.curPosition();
        }
        var prevType = this.type;
        this.type = type2;
        this.value = val;
        this.updateContext(prevType);
      };
      pp.readToken_dot = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next >= 48 && next <= 57) {
          return this.readNumber(true);
        }
        var next2 = this.input.charCodeAt(this.pos + 2);
        if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) {
          this.pos += 3;
          return this.finishToken(types$1.ellipsis);
        } else {
          ++this.pos;
          return this.finishToken(types$1.dot);
        }
      };
      pp.readToken_slash = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (this.exprAllowed) {
          ++this.pos;
          return this.readRegexp();
        }
        if (next === 61) {
          return this.finishOp(types$1.assign, 2);
        }
        return this.finishOp(types$1.slash, 1);
      };
      pp.readToken_mult_modulo_exp = function(code2) {
        var next = this.input.charCodeAt(this.pos + 1);
        var size = 1;
        var tokentype = code2 === 42 ? types$1.star : types$1.modulo;
        if (this.options.ecmaVersion >= 7 && code2 === 42 && next === 42) {
          ++size;
          tokentype = types$1.starstar;
          next = this.input.charCodeAt(this.pos + 2);
        }
        if (next === 61) {
          return this.finishOp(types$1.assign, size + 1);
        }
        return this.finishOp(tokentype, size);
      };
      pp.readToken_pipe_amp = function(code2) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === code2) {
          if (this.options.ecmaVersion >= 12) {
            var next2 = this.input.charCodeAt(this.pos + 2);
            if (next2 === 61) {
              return this.finishOp(types$1.assign, 3);
            }
          }
          return this.finishOp(code2 === 124 ? types$1.logicalOR : types$1.logicalAND, 2);
        }
        if (next === 61) {
          return this.finishOp(types$1.assign, 2);
        }
        return this.finishOp(code2 === 124 ? types$1.bitwiseOR : types$1.bitwiseAND, 1);
      };
      pp.readToken_caret = function() {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === 61) {
          return this.finishOp(types$1.assign, 2);
        }
        return this.finishOp(types$1.bitwiseXOR, 1);
      };
      pp.readToken_plus_min = function(code2) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === code2) {
          if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 && (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
            this.skipLineComment(3);
            this.skipSpace();
            return this.nextToken();
          }
          return this.finishOp(types$1.incDec, 2);
        }
        if (next === 61) {
          return this.finishOp(types$1.assign, 2);
        }
        return this.finishOp(types$1.plusMin, 1);
      };
      pp.readToken_lt_gt = function(code2) {
        var next = this.input.charCodeAt(this.pos + 1);
        var size = 1;
        if (next === code2) {
          size = code2 === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
          if (this.input.charCodeAt(this.pos + size) === 61) {
            return this.finishOp(types$1.assign, size + 1);
          }
          return this.finishOp(types$1.bitShift, size);
        }
        if (next === 33 && code2 === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 && this.input.charCodeAt(this.pos + 3) === 45) {
          this.skipLineComment(4);
          this.skipSpace();
          return this.nextToken();
        }
        if (next === 61) {
          size = 2;
        }
        return this.finishOp(types$1.relational, size);
      };
      pp.readToken_eq_excl = function(code2) {
        var next = this.input.charCodeAt(this.pos + 1);
        if (next === 61) {
          return this.finishOp(types$1.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2);
        }
        if (code2 === 61 && next === 62 && this.options.ecmaVersion >= 6) {
          this.pos += 2;
          return this.finishToken(types$1.arrow);
        }
        return this.finishOp(code2 === 61 ? types$1.eq : types$1.prefix, 1);
      };
      pp.readToken_question = function() {
        var ecmaVersion3 = this.options.ecmaVersion;
        if (ecmaVersion3 >= 11) {
          var next = this.input.charCodeAt(this.pos + 1);
          if (next === 46) {
            var next2 = this.input.charCodeAt(this.pos + 2);
            if (next2 < 48 || next2 > 57) {
              return this.finishOp(types$1.questionDot, 2);
            }
          }
          if (next === 63) {
            if (ecmaVersion3 >= 12) {
              var next2$1 = this.input.charCodeAt(this.pos + 2);
              if (next2$1 === 61) {
                return this.finishOp(types$1.assign, 3);
              }
            }
            return this.finishOp(types$1.coalesce, 2);
          }
        }
        return this.finishOp(types$1.question, 1);
      };
      pp.readToken_numberSign = function() {
        var ecmaVersion3 = this.options.ecmaVersion;
        var code2 = 35;
        if (ecmaVersion3 >= 13) {
          ++this.pos;
          code2 = this.fullCharCodeAtPos();
          if (isIdentifierStart(code2, true) || code2 === 92) {
            return this.finishToken(types$1.privateId, this.readWord1());
          }
        }
        this.raise(this.pos, "Unexpected character '" + codePointToString(code2) + "'");
      };
      pp.getTokenFromCode = function(code2) {
        switch (code2) {
          // The interpretation of a dot depends on whether it is followed
          // by a digit or another two dots.
          case 46:
            return this.readToken_dot();
          // Punctuation tokens.
          case 40:
            ++this.pos;
            return this.finishToken(types$1.parenL);
          case 41:
            ++this.pos;
            return this.finishToken(types$1.parenR);
          case 59:
            ++this.pos;
            return this.finishToken(types$1.semi);
          case 44:
            ++this.pos;
            return this.finishToken(types$1.comma);
          case 91:
            ++this.pos;
            return this.finishToken(types$1.bracketL);
          case 93:
            ++this.pos;
            return this.finishToken(types$1.bracketR);
          case 123:
            ++this.pos;
            return this.finishToken(types$1.braceL);
          case 125:
            ++this.pos;
            return this.finishToken(types$1.braceR);
          case 58:
            ++this.pos;
            return this.finishToken(types$1.colon);
          case 96:
            if (this.options.ecmaVersion < 6) {
              break;
            }
            ++this.pos;
            return this.finishToken(types$1.backQuote);
          case 48:
            var next = this.input.charCodeAt(this.pos + 1);
            if (next === 120 || next === 88) {
              return this.readRadixNumber(16);
            }
            if (this.options.ecmaVersion >= 6) {
              if (next === 111 || next === 79) {
                return this.readRadixNumber(8);
              }
              if (next === 98 || next === 66) {
                return this.readRadixNumber(2);
              }
            }
          // Anything else beginning with a digit is an integer, octal
          // number, or float.
          case 49:
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:
          case 56:
          case 57:
            return this.readNumber(false);
          // Quotes produce strings.
          case 34:
          case 39:
            return this.readString(code2);
          // Operators are parsed inline in tiny state machines. '=' (61) is
          // often referred to. `finishOp` simply skips the amount of
          // characters it is given as second argument, and returns a token
          // of the type given by its first argument.
          case 47:
            return this.readToken_slash();
          case 37:
          case 42:
            return this.readToken_mult_modulo_exp(code2);
          case 124:
          case 38:
            return this.readToken_pipe_amp(code2);
          case 94:
            return this.readToken_caret();
          case 43:
          case 45:
            return this.readToken_plus_min(code2);
          case 60:
          case 62:
            return this.readToken_lt_gt(code2);
          case 61:
          case 33:
            return this.readToken_eq_excl(code2);
          case 63:
            return this.readToken_question();
          case 126:
            return this.finishOp(types$1.prefix, 1);
          case 35:
            return this.readToken_numberSign();
        }
        this.raise(this.pos, "Unexpected character '" + codePointToString(code2) + "'");
      };
      pp.finishOp = function(type2, size) {
        var str = this.input.slice(this.pos, this.pos + size);
        this.pos += size;
        return this.finishToken(type2, str);
      };
      pp.readRegexp = function() {
        var escaped, inClass, start = this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(start, "Unterminated regular expression");
          }
          var ch = this.input.charAt(this.pos);
          if (lineBreak.test(ch)) {
            this.raise(start, "Unterminated regular expression");
          }
          if (!escaped) {
            if (ch === "[") {
              inClass = true;
            } else if (ch === "]" && inClass) {
              inClass = false;
            } else if (ch === "/" && !inClass) {
              break;
            }
            escaped = ch === "\\";
          } else {
            escaped = false;
          }
          ++this.pos;
        }
        var pattern2 = this.input.slice(start, this.pos);
        ++this.pos;
        var flagsStart = this.pos;
        var flags2 = this.readWord1();
        if (this.containsEsc) {
          this.unexpected(flagsStart);
        }
        var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
        state.reset(start, pattern2, flags2);
        this.validateRegExpFlags(state);
        this.validateRegExpPattern(state);
        var value = null;
        try {
          value = new RegExp(pattern2, flags2);
        } catch (e2) {
        }
        return this.finishToken(types$1.regexp, { pattern: pattern2, flags: flags2, value });
      };
      pp.readInt = function(radix2, len, maybeLegacyOctalNumericLiteral) {
        var allowSeparators = this.options.ecmaVersion >= 12 && len === void 0;
        var isLegacyOctalNumericLiteral = maybeLegacyOctalNumericLiteral && this.input.charCodeAt(this.pos) === 48;
        var start = this.pos, total = 0, lastCode = 0;
        for (var i3 = 0, e2 = len == null ? Infinity : len; i3 < e2; ++i3, ++this.pos) {
          var code2 = this.input.charCodeAt(this.pos), val = void 0;
          if (allowSeparators && code2 === 95) {
            if (isLegacyOctalNumericLiteral) {
              this.raiseRecoverable(this.pos, "Numeric separator is not allowed in legacy octal numeric literals");
            }
            if (lastCode === 95) {
              this.raiseRecoverable(this.pos, "Numeric separator must be exactly one underscore");
            }
            if (i3 === 0) {
              this.raiseRecoverable(this.pos, "Numeric separator is not allowed at the first of digits");
            }
            lastCode = code2;
            continue;
          }
          if (code2 >= 97) {
            val = code2 - 97 + 10;
          } else if (code2 >= 65) {
            val = code2 - 65 + 10;
          } else if (code2 >= 48 && code2 <= 57) {
            val = code2 - 48;
          } else {
            val = Infinity;
          }
          if (val >= radix2) {
            break;
          }
          lastCode = code2;
          total = total * radix2 + val;
        }
        if (allowSeparators && lastCode === 95) {
          this.raiseRecoverable(this.pos - 1, "Numeric separator is not allowed at the last of digits");
        }
        if (this.pos === start || len != null && this.pos - start !== len) {
          return null;
        }
        return total;
      };
      function stringToNumber(str, isLegacyOctalNumericLiteral) {
        if (isLegacyOctalNumericLiteral) {
          return parseInt(str, 8);
        }
        return parseFloat(str.replace(/_/g, ""));
      }
      function stringToBigInt(str) {
        if (typeof BigInt !== "function") {
          return null;
        }
        return BigInt(str.replace(/_/g, ""));
      }
      pp.readRadixNumber = function(radix2) {
        var start = this.pos;
        this.pos += 2;
        var val = this.readInt(radix2);
        if (val == null) {
          this.raise(this.start + 2, "Expected number in radix " + radix2);
        }
        if (this.options.ecmaVersion >= 11 && this.input.charCodeAt(this.pos) === 110) {
          val = stringToBigInt(this.input.slice(start, this.pos));
          ++this.pos;
        } else if (isIdentifierStart(this.fullCharCodeAtPos())) {
          this.raise(this.pos, "Identifier directly after number");
        }
        return this.finishToken(types$1.num, val);
      };
      pp.readNumber = function(startsWithDot) {
        var start = this.pos;
        if (!startsWithDot && this.readInt(10, void 0, true) === null) {
          this.raise(start, "Invalid number");
        }
        var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
        if (octal && this.strict) {
          this.raise(start, "Invalid number");
        }
        var next = this.input.charCodeAt(this.pos);
        if (!octal && !startsWithDot && this.options.ecmaVersion >= 11 && next === 110) {
          var val$1 = stringToBigInt(this.input.slice(start, this.pos));
          ++this.pos;
          if (isIdentifierStart(this.fullCharCodeAtPos())) {
            this.raise(this.pos, "Identifier directly after number");
          }
          return this.finishToken(types$1.num, val$1);
        }
        if (octal && /[89]/.test(this.input.slice(start, this.pos))) {
          octal = false;
        }
        if (next === 46 && !octal) {
          ++this.pos;
          this.readInt(10);
          next = this.input.charCodeAt(this.pos);
        }
        if ((next === 69 || next === 101) && !octal) {
          next = this.input.charCodeAt(++this.pos);
          if (next === 43 || next === 45) {
            ++this.pos;
          }
          if (this.readInt(10) === null) {
            this.raise(start, "Invalid number");
          }
        }
        if (isIdentifierStart(this.fullCharCodeAtPos())) {
          this.raise(this.pos, "Identifier directly after number");
        }
        var val = stringToNumber(this.input.slice(start, this.pos), octal);
        return this.finishToken(types$1.num, val);
      };
      pp.readCodePoint = function() {
        var ch = this.input.charCodeAt(this.pos), code2;
        if (ch === 123) {
          if (this.options.ecmaVersion < 6) {
            this.unexpected();
          }
          var codePos = ++this.pos;
          code2 = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
          ++this.pos;
          if (code2 > 1114111) {
            this.invalidStringToken(codePos, "Code point out of bounds");
          }
        } else {
          code2 = this.readHexChar(4);
        }
        return code2;
      };
      pp.readString = function(quote) {
        var out = "", chunkStart = ++this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(this.start, "Unterminated string constant");
          }
          var ch = this.input.charCodeAt(this.pos);
          if (ch === quote) {
            break;
          }
          if (ch === 92) {
            out += this.input.slice(chunkStart, this.pos);
            out += this.readEscapedChar(false);
            chunkStart = this.pos;
          } else if (ch === 8232 || ch === 8233) {
            if (this.options.ecmaVersion < 10) {
              this.raise(this.start, "Unterminated string constant");
            }
            ++this.pos;
            if (this.options.locations) {
              this.curLine++;
              this.lineStart = this.pos;
            }
          } else {
            if (isNewLine(ch)) {
              this.raise(this.start, "Unterminated string constant");
            }
            ++this.pos;
          }
        }
        out += this.input.slice(chunkStart, this.pos++);
        return this.finishToken(types$1.string, out);
      };
      var INVALID_TEMPLATE_ESCAPE_ERROR = {};
      pp.tryReadTemplateToken = function() {
        this.inTemplateElement = true;
        try {
          this.readTmplToken();
        } catch (err) {
          if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
            this.readInvalidTemplateToken();
          } else {
            throw err;
          }
        }
        this.inTemplateElement = false;
      };
      pp.invalidStringToken = function(position, message) {
        if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
          throw INVALID_TEMPLATE_ESCAPE_ERROR;
        } else {
          this.raise(position, message);
        }
      };
      pp.readTmplToken = function() {
        var out = "", chunkStart = this.pos;
        for (; ; ) {
          if (this.pos >= this.input.length) {
            this.raise(this.start, "Unterminated template");
          }
          var ch = this.input.charCodeAt(this.pos);
          if (ch === 96 || ch === 36 && this.input.charCodeAt(this.pos + 1) === 123) {
            if (this.pos === this.start && (this.type === types$1.template || this.type === types$1.invalidTemplate)) {
              if (ch === 36) {
                this.pos += 2;
                return this.finishToken(types$1.dollarBraceL);
              } else {
                ++this.pos;
                return this.finishToken(types$1.backQuote);
              }
            }
            out += this.input.slice(chunkStart, this.pos);
            return this.finishToken(types$1.template, out);
          }
          if (ch === 92) {
            out += this.input.slice(chunkStart, this.pos);
            out += this.readEscapedChar(true);
            chunkStart = this.pos;
          } else if (isNewLine(ch)) {
            out += this.input.slice(chunkStart, this.pos);
            ++this.pos;
            switch (ch) {
              case 13:
                if (this.input.charCodeAt(this.pos) === 10) {
                  ++this.pos;
                }
              case 10:
                out += "\n";
                break;
              default:
                out += String.fromCharCode(ch);
                break;
            }
            if (this.options.locations) {
              ++this.curLine;
              this.lineStart = this.pos;
            }
            chunkStart = this.pos;
          } else {
            ++this.pos;
          }
        }
      };
      pp.readInvalidTemplateToken = function() {
        for (; this.pos < this.input.length; this.pos++) {
          switch (this.input[this.pos]) {
            case "\\":
              ++this.pos;
              break;
            case "$":
              if (this.input[this.pos + 1] !== "{") {
                break;
              }
            // fall through
            case "`":
              return this.finishToken(types$1.invalidTemplate, this.input.slice(this.start, this.pos));
            case "\r":
              if (this.input[this.pos + 1] === "\n") {
                ++this.pos;
              }
            // fall through
            case "\n":
            case "\u2028":
            case "\u2029":
              ++this.curLine;
              this.lineStart = this.pos + 1;
              break;
          }
        }
        this.raise(this.start, "Unterminated template");
      };
      pp.readEscapedChar = function(inTemplate) {
        var ch = this.input.charCodeAt(++this.pos);
        ++this.pos;
        switch (ch) {
          case 110:
            return "\n";
          // 'n' -> '\n'
          case 114:
            return "\r";
          // 'r' -> '\r'
          case 120:
            return String.fromCharCode(this.readHexChar(2));
          // 'x'
          case 117:
            return codePointToString(this.readCodePoint());
          // 'u'
          case 116:
            return "	";
          // 't' -> '\t'
          case 98:
            return "\b";
          // 'b' -> '\b'
          case 118:
            return "\v";
          // 'v' -> '\u000b'
          case 102:
            return "\f";
          // 'f' -> '\f'
          case 13:
            if (this.input.charCodeAt(this.pos) === 10) {
              ++this.pos;
            }
          // '\r\n'
          case 10:
            if (this.options.locations) {
              this.lineStart = this.pos;
              ++this.curLine;
            }
            return "";
          case 56:
          case 57:
            if (this.strict) {
              this.invalidStringToken(
                this.pos - 1,
                "Invalid escape sequence"
              );
            }
            if (inTemplate) {
              var codePos = this.pos - 1;
              this.invalidStringToken(
                codePos,
                "Invalid escape sequence in template string"
              );
            }
          default:
            if (ch >= 48 && ch <= 55) {
              var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
              var octal = parseInt(octalStr, 8);
              if (octal > 255) {
                octalStr = octalStr.slice(0, -1);
                octal = parseInt(octalStr, 8);
              }
              this.pos += octalStr.length - 1;
              ch = this.input.charCodeAt(this.pos);
              if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
                this.invalidStringToken(
                  this.pos - 1 - octalStr.length,
                  inTemplate ? "Octal literal in template string" : "Octal literal in strict mode"
                );
              }
              return String.fromCharCode(octal);
            }
            if (isNewLine(ch)) {
              if (this.options.locations) {
                this.lineStart = this.pos;
                ++this.curLine;
              }
              return "";
            }
            return String.fromCharCode(ch);
        }
      };
      pp.readHexChar = function(len) {
        var codePos = this.pos;
        var n2 = this.readInt(16, len);
        if (n2 === null) {
          this.invalidStringToken(codePos, "Bad character escape sequence");
        }
        return n2;
      };
      pp.readWord1 = function() {
        this.containsEsc = false;
        var word = "", first = true, chunkStart = this.pos;
        var astral = this.options.ecmaVersion >= 6;
        while (this.pos < this.input.length) {
          var ch = this.fullCharCodeAtPos();
          if (isIdentifierChar(ch, astral)) {
            this.pos += ch <= 65535 ? 1 : 2;
          } else if (ch === 92) {
            this.containsEsc = true;
            word += this.input.slice(chunkStart, this.pos);
            var escStart = this.pos;
            if (this.input.charCodeAt(++this.pos) !== 117) {
              this.invalidStringToken(this.pos, "Expecting Unicode escape sequence \\uXXXX");
            }
            ++this.pos;
            var esc = this.readCodePoint();
            if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral)) {
              this.invalidStringToken(escStart, "Invalid Unicode escape");
            }
            word += codePointToString(esc);
            chunkStart = this.pos;
          } else {
            break;
          }
          first = false;
        }
        return word + this.input.slice(chunkStart, this.pos);
      };
      pp.readWord = function() {
        var word = this.readWord1();
        var type2 = types$1.name;
        if (this.keywords.test(word)) {
          type2 = keywords2[word];
        }
        return this.finishToken(type2, word);
      };
      var version2 = "8.15.0";
      Parser.acorn = {
        Parser,
        version: version2,
        defaultOptions,
        Position,
        SourceLocation,
        getLineInfo,
        Node,
        TokenType,
        tokTypes: types$1,
        keywordTypes: keywords2,
        TokContext,
        tokContexts: types,
        isIdentifierChar,
        isIdentifierStart,
        Token,
        isNewLine,
        lineBreak,
        lineBreakG,
        nonASCIIwhitespace
      };
      function parse(input, options) {
        return Parser.parse(input, options);
      }
      function parseExpressionAt(input, pos, options) {
        return Parser.parseExpressionAt(input, pos, options);
      }
      function tokenizer(input, options) {
        return Parser.tokenizer(input, options);
      }
      exports2.Node = Node;
      exports2.Parser = Parser;
      exports2.Position = Position;
      exports2.SourceLocation = SourceLocation;
      exports2.TokContext = TokContext;
      exports2.Token = Token;
      exports2.TokenType = TokenType;
      exports2.defaultOptions = defaultOptions;
      exports2.getLineInfo = getLineInfo;
      exports2.isIdentifierChar = isIdentifierChar;
      exports2.isIdentifierStart = isIdentifierStart;
      exports2.isNewLine = isNewLine;
      exports2.keywordTypes = keywords2;
      exports2.lineBreak = lineBreak;
      exports2.lineBreakG = lineBreakG;
      exports2.nonASCIIwhitespace = nonASCIIwhitespace;
      exports2.parse = parse;
      exports2.parseExpressionAt = parseExpressionAt;
      exports2.tokContexts = types;
      exports2.tokTypes = types$1;
      exports2.tokenizer = tokenizer;
      exports2.version = version2;
    }));
  })(acorn, acorn.exports);
  return acorn.exports;
}
var acornJsx = { exports: {} };
var xhtml;
var hasRequiredXhtml;
function requireXhtml() {
  if (hasRequiredXhtml) return xhtml;
  hasRequiredXhtml = 1;
  xhtml = {
    quot: '"',
    amp: "&",
    apos: "'",
    lt: "<",
    gt: ">",
    nbsp: " ",
    iexcl: "¡",
    cent: "¢",
    pound: "£",
    curren: "¤",
    yen: "¥",
    brvbar: "¦",
    sect: "§",
    uml: "¨",
    copy: "©",
    ordf: "ª",
    laquo: "«",
    not: "¬",
    shy: "­",
    reg: "®",
    macr: "¯",
    deg: "°",
    plusmn: "±",
    sup2: "²",
    sup3: "³",
    acute: "´",
    micro: "µ",
    para: "¶",
    middot: "·",
    cedil: "¸",
    sup1: "¹",
    ordm: "º",
    raquo: "»",
    frac14: "¼",
    frac12: "½",
    frac34: "¾",
    iquest: "¿",
    Agrave: "À",
    Aacute: "Á",
    Acirc: "Â",
    Atilde: "Ã",
    Auml: "Ä",
    Aring: "Å",
    AElig: "Æ",
    Ccedil: "Ç",
    Egrave: "È",
    Eacute: "É",
    Ecirc: "Ê",
    Euml: "Ë",
    Igrave: "Ì",
    Iacute: "Í",
    Icirc: "Î",
    Iuml: "Ï",
    ETH: "Ð",
    Ntilde: "Ñ",
    Ograve: "Ò",
    Oacute: "Ó",
    Ocirc: "Ô",
    Otilde: "Õ",
    Ouml: "Ö",
    times: "×",
    Oslash: "Ø",
    Ugrave: "Ù",
    Uacute: "Ú",
    Ucirc: "Û",
    Uuml: "Ü",
    Yacute: "Ý",
    THORN: "Þ",
    szlig: "ß",
    agrave: "à",
    aacute: "á",
    acirc: "â",
    atilde: "ã",
    auml: "ä",
    aring: "å",
    aelig: "æ",
    ccedil: "ç",
    egrave: "è",
    eacute: "é",
    ecirc: "ê",
    euml: "ë",
    igrave: "ì",
    iacute: "í",
    icirc: "î",
    iuml: "ï",
    eth: "ð",
    ntilde: "ñ",
    ograve: "ò",
    oacute: "ó",
    ocirc: "ô",
    otilde: "õ",
    ouml: "ö",
    divide: "÷",
    oslash: "ø",
    ugrave: "ù",
    uacute: "ú",
    ucirc: "û",
    uuml: "ü",
    yacute: "ý",
    thorn: "þ",
    yuml: "ÿ",
    OElig: "Œ",
    oelig: "œ",
    Scaron: "Š",
    scaron: "š",
    Yuml: "Ÿ",
    fnof: "ƒ",
    circ: "ˆ",
    tilde: "˜",
    Alpha: "Α",
    Beta: "Β",
    Gamma: "Γ",
    Delta: "Δ",
    Epsilon: "Ε",
    Zeta: "Ζ",
    Eta: "Η",
    Theta: "Θ",
    Iota: "Ι",
    Kappa: "Κ",
    Lambda: "Λ",
    Mu: "Μ",
    Nu: "Ν",
    Xi: "Ξ",
    Omicron: "Ο",
    Pi: "Π",
    Rho: "Ρ",
    Sigma: "Σ",
    Tau: "Τ",
    Upsilon: "Υ",
    Phi: "Φ",
    Chi: "Χ",
    Psi: "Ψ",
    Omega: "Ω",
    alpha: "α",
    beta: "β",
    gamma: "γ",
    delta: "δ",
    epsilon: "ε",
    zeta: "ζ",
    eta: "η",
    theta: "θ",
    iota: "ι",
    kappa: "κ",
    lambda: "λ",
    mu: "μ",
    nu: "ν",
    xi: "ξ",
    omicron: "ο",
    pi: "π",
    rho: "ρ",
    sigmaf: "ς",
    sigma: "σ",
    tau: "τ",
    upsilon: "υ",
    phi: "φ",
    chi: "χ",
    psi: "ψ",
    omega: "ω",
    thetasym: "ϑ",
    upsih: "ϒ",
    piv: "ϖ",
    ensp: " ",
    emsp: " ",
    thinsp: " ",
    zwnj: "‌",
    zwj: "‍",
    lrm: "‎",
    rlm: "‏",
    ndash: "–",
    mdash: "—",
    lsquo: "‘",
    rsquo: "’",
    sbquo: "‚",
    ldquo: "“",
    rdquo: "”",
    bdquo: "„",
    dagger: "†",
    Dagger: "‡",
    bull: "•",
    hellip: "…",
    permil: "‰",
    prime: "′",
    Prime: "″",
    lsaquo: "‹",
    rsaquo: "›",
    oline: "‾",
    frasl: "⁄",
    euro: "€",
    image: "ℑ",
    weierp: "℘",
    real: "ℜ",
    trade: "™",
    alefsym: "ℵ",
    larr: "←",
    uarr: "↑",
    rarr: "→",
    darr: "↓",
    harr: "↔",
    crarr: "↵",
    lArr: "⇐",
    uArr: "⇑",
    rArr: "⇒",
    dArr: "⇓",
    hArr: "⇔",
    forall: "∀",
    part: "∂",
    exist: "∃",
    empty: "∅",
    nabla: "∇",
    isin: "∈",
    notin: "∉",
    ni: "∋",
    prod: "∏",
    sum: "∑",
    minus: "−",
    lowast: "∗",
    radic: "√",
    prop: "∝",
    infin: "∞",
    ang: "∠",
    and: "∧",
    or: "∨",
    cap: "∩",
    cup: "∪",
    "int": "∫",
    there4: "∴",
    sim: "∼",
    cong: "≅",
    asymp: "≈",
    ne: "≠",
    equiv: "≡",
    le: "≤",
    ge: "≥",
    sub: "⊂",
    sup: "⊃",
    nsub: "⊄",
    sube: "⊆",
    supe: "⊇",
    oplus: "⊕",
    otimes: "⊗",
    perp: "⊥",
    sdot: "⋅",
    lceil: "⌈",
    rceil: "⌉",
    lfloor: "⌊",
    rfloor: "⌋",
    lang: "〈",
    rang: "〉",
    loz: "◊",
    spades: "♠",
    clubs: "♣",
    hearts: "♥",
    diams: "♦"
  };
  return xhtml;
}
var hasRequiredAcornJsx;
function requireAcornJsx() {
  if (hasRequiredAcornJsx) return acornJsx.exports;
  hasRequiredAcornJsx = 1;
  (function(module) {
    const XHTMLEntities = requireXhtml();
    const hexNumber = /^[\da-fA-F]+$/;
    const decimalNumber = /^\d+$/;
    const acornJsxMap = /* @__PURE__ */ new WeakMap();
    function getJsxTokens(acorn2) {
      acorn2 = acorn2.Parser.acorn || acorn2;
      let acornJsx2 = acornJsxMap.get(acorn2);
      if (!acornJsx2) {
        const tt = acorn2.tokTypes;
        const TokContext = acorn2.TokContext;
        const TokenType = acorn2.TokenType;
        const tc_oTag = new TokContext("<tag", false);
        const tc_cTag = new TokContext("</tag", false);
        const tc_expr = new TokContext("<tag>...</tag>", true, true);
        const tokContexts = {
          tc_oTag,
          tc_cTag,
          tc_expr
        };
        const tokTypes = {
          jsxName: new TokenType("jsxName"),
          jsxText: new TokenType("jsxText", { beforeExpr: true }),
          jsxTagStart: new TokenType("jsxTagStart", { startsExpr: true }),
          jsxTagEnd: new TokenType("jsxTagEnd")
        };
        tokTypes.jsxTagStart.updateContext = function() {
          this.context.push(tc_expr);
          this.context.push(tc_oTag);
          this.exprAllowed = false;
        };
        tokTypes.jsxTagEnd.updateContext = function(prevType) {
          let out = this.context.pop();
          if (out === tc_oTag && prevType === tt.slash || out === tc_cTag) {
            this.context.pop();
            this.exprAllowed = this.curContext() === tc_expr;
          } else {
            this.exprAllowed = true;
          }
        };
        acornJsx2 = { tokContexts, tokTypes };
        acornJsxMap.set(acorn2, acornJsx2);
      }
      return acornJsx2;
    }
    function getQualifiedJSXName(object) {
      if (!object)
        return object;
      if (object.type === "JSXIdentifier")
        return object.name;
      if (object.type === "JSXNamespacedName")
        return object.namespace.name + ":" + object.name.name;
      if (object.type === "JSXMemberExpression")
        return getQualifiedJSXName(object.object) + "." + getQualifiedJSXName(object.property);
    }
    module.exports = function(options) {
      options = options || {};
      return function(Parser) {
        return plugin({
          allowNamespaces: options.allowNamespaces !== false,
          allowNamespacedObjects: !!options.allowNamespacedObjects
        }, Parser);
      };
    };
    Object.defineProperty(module.exports, "tokTypes", {
      get: function get_tokTypes() {
        return getJsxTokens(requireAcorn()).tokTypes;
      },
      configurable: true,
      enumerable: true
    });
    function plugin(options, Parser) {
      const acorn2 = Parser.acorn || requireAcorn();
      const acornJsx2 = getJsxTokens(acorn2);
      const tt = acorn2.tokTypes;
      const tok = acornJsx2.tokTypes;
      const tokContexts = acorn2.tokContexts;
      const tc_oTag = acornJsx2.tokContexts.tc_oTag;
      const tc_cTag = acornJsx2.tokContexts.tc_cTag;
      const tc_expr = acornJsx2.tokContexts.tc_expr;
      const isNewLine = acorn2.isNewLine;
      const isIdentifierStart = acorn2.isIdentifierStart;
      const isIdentifierChar = acorn2.isIdentifierChar;
      return class extends Parser {
        // Expose actual `tokTypes` and `tokContexts` to other plugins.
        static get acornJsx() {
          return acornJsx2;
        }
        // Reads inline JSX contents token.
        jsx_readToken() {
          let out = "", chunkStart = this.pos;
          for (; ; ) {
            if (this.pos >= this.input.length)
              this.raise(this.start, "Unterminated JSX contents");
            let ch = this.input.charCodeAt(this.pos);
            switch (ch) {
              case 60:
              // '<'
              case 123:
                if (this.pos === this.start) {
                  if (ch === 60 && this.exprAllowed) {
                    ++this.pos;
                    return this.finishToken(tok.jsxTagStart);
                  }
                  return this.getTokenFromCode(ch);
                }
                out += this.input.slice(chunkStart, this.pos);
                return this.finishToken(tok.jsxText, out);
              case 38:
                out += this.input.slice(chunkStart, this.pos);
                out += this.jsx_readEntity();
                chunkStart = this.pos;
                break;
              case 62:
              // '>'
              case 125:
                this.raise(
                  this.pos,
                  "Unexpected token `" + this.input[this.pos] + "`. Did you mean `" + (ch === 62 ? "&gt;" : "&rbrace;") + '` or `{"' + this.input[this.pos] + '"}`?'
                );
              default:
                if (isNewLine(ch)) {
                  out += this.input.slice(chunkStart, this.pos);
                  out += this.jsx_readNewLine(true);
                  chunkStart = this.pos;
                } else {
                  ++this.pos;
                }
            }
          }
        }
        jsx_readNewLine(normalizeCRLF) {
          let ch = this.input.charCodeAt(this.pos);
          let out;
          ++this.pos;
          if (ch === 13 && this.input.charCodeAt(this.pos) === 10) {
            ++this.pos;
            out = normalizeCRLF ? "\n" : "\r\n";
          } else {
            out = String.fromCharCode(ch);
          }
          if (this.options.locations) {
            ++this.curLine;
            this.lineStart = this.pos;
          }
          return out;
        }
        jsx_readString(quote) {
          let out = "", chunkStart = ++this.pos;
          for (; ; ) {
            if (this.pos >= this.input.length)
              this.raise(this.start, "Unterminated string constant");
            let ch = this.input.charCodeAt(this.pos);
            if (ch === quote) break;
            if (ch === 38) {
              out += this.input.slice(chunkStart, this.pos);
              out += this.jsx_readEntity();
              chunkStart = this.pos;
            } else if (isNewLine(ch)) {
              out += this.input.slice(chunkStart, this.pos);
              out += this.jsx_readNewLine(false);
              chunkStart = this.pos;
            } else {
              ++this.pos;
            }
          }
          out += this.input.slice(chunkStart, this.pos++);
          return this.finishToken(tt.string, out);
        }
        jsx_readEntity() {
          let str = "", count = 0, entity;
          let ch = this.input[this.pos];
          if (ch !== "&")
            this.raise(this.pos, "Entity must start with an ampersand");
          let startPos = ++this.pos;
          while (this.pos < this.input.length && count++ < 10) {
            ch = this.input[this.pos++];
            if (ch === ";") {
              if (str[0] === "#") {
                if (str[1] === "x") {
                  str = str.substr(2);
                  if (hexNumber.test(str))
                    entity = String.fromCharCode(parseInt(str, 16));
                } else {
                  str = str.substr(1);
                  if (decimalNumber.test(str))
                    entity = String.fromCharCode(parseInt(str, 10));
                }
              } else {
                entity = XHTMLEntities[str];
              }
              break;
            }
            str += ch;
          }
          if (!entity) {
            this.pos = startPos;
            return "&";
          }
          return entity;
        }
        // Read a JSX identifier (valid tag or attribute name).
        //
        // Optimized version since JSX identifiers can't contain
        // escape characters and so can be read as single slice.
        // Also assumes that first character was already checked
        // by isIdentifierStart in readToken.
        jsx_readWord() {
          let ch, start = this.pos;
          do {
            ch = this.input.charCodeAt(++this.pos);
          } while (isIdentifierChar(ch) || ch === 45);
          return this.finishToken(tok.jsxName, this.input.slice(start, this.pos));
        }
        // Parse next token as JSX identifier
        jsx_parseIdentifier() {
          let node2 = this.startNode();
          if (this.type === tok.jsxName)
            node2.name = this.value;
          else if (this.type.keyword)
            node2.name = this.type.keyword;
          else
            this.unexpected();
          this.next();
          return this.finishNode(node2, "JSXIdentifier");
        }
        // Parse namespaced identifier.
        jsx_parseNamespacedName() {
          let startPos = this.start, startLoc = this.startLoc;
          let name = this.jsx_parseIdentifier();
          if (!options.allowNamespaces || !this.eat(tt.colon)) return name;
          var node2 = this.startNodeAt(startPos, startLoc);
          node2.namespace = name;
          node2.name = this.jsx_parseIdentifier();
          return this.finishNode(node2, "JSXNamespacedName");
        }
        // Parses element name in any form - namespaced, member
        // or single identifier.
        jsx_parseElementName() {
          if (this.type === tok.jsxTagEnd) return "";
          let startPos = this.start, startLoc = this.startLoc;
          let node2 = this.jsx_parseNamespacedName();
          if (this.type === tt.dot && node2.type === "JSXNamespacedName" && !options.allowNamespacedObjects) {
            this.unexpected();
          }
          while (this.eat(tt.dot)) {
            let newNode = this.startNodeAt(startPos, startLoc);
            newNode.object = node2;
            newNode.property = this.jsx_parseIdentifier();
            node2 = this.finishNode(newNode, "JSXMemberExpression");
          }
          return node2;
        }
        // Parses any type of JSX attribute value.
        jsx_parseAttributeValue() {
          switch (this.type) {
            case tt.braceL:
              let node2 = this.jsx_parseExpressionContainer();
              if (node2.expression.type === "JSXEmptyExpression")
                this.raise(node2.start, "JSX attributes must only be assigned a non-empty expression");
              return node2;
            case tok.jsxTagStart:
            case tt.string:
              return this.parseExprAtom();
            default:
              this.raise(this.start, "JSX value should be either an expression or a quoted JSX text");
          }
        }
        // JSXEmptyExpression is unique type since it doesn't actually parse anything,
        // and so it should start at the end of last read token (left brace) and finish
        // at the beginning of the next one (right brace).
        jsx_parseEmptyExpression() {
          let node2 = this.startNodeAt(this.lastTokEnd, this.lastTokEndLoc);
          return this.finishNodeAt(node2, "JSXEmptyExpression", this.start, this.startLoc);
        }
        // Parses JSX expression enclosed into curly brackets.
        jsx_parseExpressionContainer() {
          let node2 = this.startNode();
          this.next();
          node2.expression = this.type === tt.braceR ? this.jsx_parseEmptyExpression() : this.parseExpression();
          this.expect(tt.braceR);
          return this.finishNode(node2, "JSXExpressionContainer");
        }
        // Parses following JSX attribute name-value pair.
        jsx_parseAttribute() {
          let node2 = this.startNode();
          if (this.eat(tt.braceL)) {
            this.expect(tt.ellipsis);
            node2.argument = this.parseMaybeAssign();
            this.expect(tt.braceR);
            return this.finishNode(node2, "JSXSpreadAttribute");
          }
          node2.name = this.jsx_parseNamespacedName();
          node2.value = this.eat(tt.eq) ? this.jsx_parseAttributeValue() : null;
          return this.finishNode(node2, "JSXAttribute");
        }
        // Parses JSX opening tag starting after '<'.
        jsx_parseOpeningElementAt(startPos, startLoc) {
          let node2 = this.startNodeAt(startPos, startLoc);
          node2.attributes = [];
          let nodeName = this.jsx_parseElementName();
          if (nodeName) node2.name = nodeName;
          while (this.type !== tt.slash && this.type !== tok.jsxTagEnd)
            node2.attributes.push(this.jsx_parseAttribute());
          node2.selfClosing = this.eat(tt.slash);
          this.expect(tok.jsxTagEnd);
          return this.finishNode(node2, nodeName ? "JSXOpeningElement" : "JSXOpeningFragment");
        }
        // Parses JSX closing tag starting after '</'.
        jsx_parseClosingElementAt(startPos, startLoc) {
          let node2 = this.startNodeAt(startPos, startLoc);
          let nodeName = this.jsx_parseElementName();
          if (nodeName) node2.name = nodeName;
          this.expect(tok.jsxTagEnd);
          return this.finishNode(node2, nodeName ? "JSXClosingElement" : "JSXClosingFragment");
        }
        // Parses entire JSX element, including it's opening tag
        // (starting after '<'), attributes, contents and closing tag.
        jsx_parseElementAt(startPos, startLoc) {
          let node2 = this.startNodeAt(startPos, startLoc);
          let children = [];
          let openingElement = this.jsx_parseOpeningElementAt(startPos, startLoc);
          let closingElement = null;
          if (!openingElement.selfClosing) {
            contents: for (; ; ) {
              switch (this.type) {
                case tok.jsxTagStart:
                  startPos = this.start;
                  startLoc = this.startLoc;
                  this.next();
                  if (this.eat(tt.slash)) {
                    closingElement = this.jsx_parseClosingElementAt(startPos, startLoc);
                    break contents;
                  }
                  children.push(this.jsx_parseElementAt(startPos, startLoc));
                  break;
                case tok.jsxText:
                  children.push(this.parseExprAtom());
                  break;
                case tt.braceL:
                  children.push(this.jsx_parseExpressionContainer());
                  break;
                default:
                  this.unexpected();
              }
            }
            if (getQualifiedJSXName(closingElement.name) !== getQualifiedJSXName(openingElement.name)) {
              this.raise(
                closingElement.start,
                "Expected corresponding JSX closing tag for <" + getQualifiedJSXName(openingElement.name) + ">"
              );
            }
          }
          let fragmentOrElement = openingElement.name ? "Element" : "Fragment";
          node2["opening" + fragmentOrElement] = openingElement;
          node2["closing" + fragmentOrElement] = closingElement;
          node2.children = children;
          if (this.type === tt.relational && this.value === "<") {
            this.raise(this.start, "Adjacent JSX elements must be wrapped in an enclosing tag");
          }
          return this.finishNode(node2, "JSX" + fragmentOrElement);
        }
        // Parse JSX text
        jsx_parseText() {
          let node2 = this.parseLiteral(this.value);
          node2.type = "JSXText";
          return node2;
        }
        // Parses entire JSX element from current position.
        jsx_parseElement() {
          let startPos = this.start, startLoc = this.startLoc;
          this.next();
          return this.jsx_parseElementAt(startPos, startLoc);
        }
        parseExprAtom(refShortHandDefaultPos) {
          if (this.type === tok.jsxText)
            return this.jsx_parseText();
          else if (this.type === tok.jsxTagStart)
            return this.jsx_parseElement();
          else
            return super.parseExprAtom(refShortHandDefaultPos);
        }
        readToken(code2) {
          let context = this.curContext();
          if (context === tc_expr) return this.jsx_readToken();
          if (context === tc_oTag || context === tc_cTag) {
            if (isIdentifierStart(code2)) return this.jsx_readWord();
            if (code2 == 62) {
              ++this.pos;
              return this.finishToken(tok.jsxTagEnd);
            }
            if ((code2 === 34 || code2 === 39) && context == tc_oTag)
              return this.jsx_readString(code2);
          }
          if (code2 === 60 && this.exprAllowed && this.input.charCodeAt(this.pos + 1) !== 33) {
            ++this.pos;
            return this.finishToken(tok.jsxTagStart);
          }
          return super.readToken(code2);
        }
        updateContext(prevType) {
          if (this.type == tt.braceL) {
            var curContext = this.curContext();
            if (curContext == tc_oTag) this.context.push(tokContexts.b_expr);
            else if (curContext == tc_expr) this.context.push(tokContexts.b_tmpl);
            else super.updateContext(prevType);
            this.exprAllowed = true;
          } else if (this.type === tt.slash && prevType === tok.jsxTagStart) {
            this.context.length -= 2;
            this.context.push(tc_cTag);
            this.exprAllowed = false;
          } else {
            return super.updateContext(prevType);
          }
        }
      };
    }
  })(acornJsx);
  return acornJsx.exports;
}
var eslintVisitorKeys$1 = {};
var hasRequiredEslintVisitorKeys$1;
function requireEslintVisitorKeys$1() {
  if (hasRequiredEslintVisitorKeys$1) return eslintVisitorKeys$1;
  hasRequiredEslintVisitorKeys$1 = 1;
  const KEYS = {
    ArrayExpression: [
      "elements"
    ],
    ArrayPattern: [
      "elements"
    ],
    ArrowFunctionExpression: [
      "params",
      "body"
    ],
    AssignmentExpression: [
      "left",
      "right"
    ],
    AssignmentPattern: [
      "left",
      "right"
    ],
    AwaitExpression: [
      "argument"
    ],
    BinaryExpression: [
      "left",
      "right"
    ],
    BlockStatement: [
      "body"
    ],
    BreakStatement: [
      "label"
    ],
    CallExpression: [
      "callee",
      "arguments"
    ],
    CatchClause: [
      "param",
      "body"
    ],
    ChainExpression: [
      "expression"
    ],
    ClassBody: [
      "body"
    ],
    ClassDeclaration: [
      "id",
      "superClass",
      "body"
    ],
    ClassExpression: [
      "id",
      "superClass",
      "body"
    ],
    ConditionalExpression: [
      "test",
      "consequent",
      "alternate"
    ],
    ContinueStatement: [
      "label"
    ],
    DebuggerStatement: [],
    DoWhileStatement: [
      "body",
      "test"
    ],
    EmptyStatement: [],
    ExperimentalRestProperty: [
      "argument"
    ],
    ExperimentalSpreadProperty: [
      "argument"
    ],
    ExportAllDeclaration: [
      "exported",
      "source",
      "attributes"
    ],
    ExportDefaultDeclaration: [
      "declaration"
    ],
    ExportNamedDeclaration: [
      "declaration",
      "specifiers",
      "source",
      "attributes"
    ],
    ExportSpecifier: [
      "local",
      "exported"
    ],
    ExpressionStatement: [
      "expression"
    ],
    ForInStatement: [
      "left",
      "right",
      "body"
    ],
    ForOfStatement: [
      "left",
      "right",
      "body"
    ],
    ForStatement: [
      "init",
      "test",
      "update",
      "body"
    ],
    FunctionDeclaration: [
      "id",
      "params",
      "body"
    ],
    FunctionExpression: [
      "id",
      "params",
      "body"
    ],
    Identifier: [],
    IfStatement: [
      "test",
      "consequent",
      "alternate"
    ],
    ImportAttribute: [
      "key",
      "value"
    ],
    ImportDeclaration: [
      "specifiers",
      "source",
      "attributes"
    ],
    ImportDefaultSpecifier: [
      "local"
    ],
    ImportExpression: [
      "source",
      "options"
    ],
    ImportNamespaceSpecifier: [
      "local"
    ],
    ImportSpecifier: [
      "imported",
      "local"
    ],
    JSXAttribute: [
      "name",
      "value"
    ],
    JSXClosingElement: [
      "name"
    ],
    JSXClosingFragment: [],
    JSXElement: [
      "openingElement",
      "children",
      "closingElement"
    ],
    JSXEmptyExpression: [],
    JSXExpressionContainer: [
      "expression"
    ],
    JSXFragment: [
      "openingFragment",
      "children",
      "closingFragment"
    ],
    JSXIdentifier: [],
    JSXMemberExpression: [
      "object",
      "property"
    ],
    JSXNamespacedName: [
      "namespace",
      "name"
    ],
    JSXOpeningElement: [
      "name",
      "attributes"
    ],
    JSXOpeningFragment: [],
    JSXSpreadAttribute: [
      "argument"
    ],
    JSXSpreadChild: [
      "expression"
    ],
    JSXText: [],
    LabeledStatement: [
      "label",
      "body"
    ],
    Literal: [],
    LogicalExpression: [
      "left",
      "right"
    ],
    MemberExpression: [
      "object",
      "property"
    ],
    MetaProperty: [
      "meta",
      "property"
    ],
    MethodDefinition: [
      "key",
      "value"
    ],
    NewExpression: [
      "callee",
      "arguments"
    ],
    ObjectExpression: [
      "properties"
    ],
    ObjectPattern: [
      "properties"
    ],
    PrivateIdentifier: [],
    Program: [
      "body"
    ],
    Property: [
      "key",
      "value"
    ],
    PropertyDefinition: [
      "key",
      "value"
    ],
    RestElement: [
      "argument"
    ],
    ReturnStatement: [
      "argument"
    ],
    SequenceExpression: [
      "expressions"
    ],
    SpreadElement: [
      "argument"
    ],
    StaticBlock: [
      "body"
    ],
    Super: [],
    SwitchCase: [
      "test",
      "consequent"
    ],
    SwitchStatement: [
      "discriminant",
      "cases"
    ],
    TaggedTemplateExpression: [
      "tag",
      "quasi"
    ],
    TemplateElement: [],
    TemplateLiteral: [
      "quasis",
      "expressions"
    ],
    ThisExpression: [],
    ThrowStatement: [
      "argument"
    ],
    TryStatement: [
      "block",
      "handler",
      "finalizer"
    ],
    UnaryExpression: [
      "argument"
    ],
    UpdateExpression: [
      "argument"
    ],
    VariableDeclaration: [
      "declarations"
    ],
    VariableDeclarator: [
      "id",
      "init"
    ],
    WhileStatement: [
      "test",
      "body"
    ],
    WithStatement: [
      "object",
      "body"
    ],
    YieldExpression: [
      "argument"
    ]
  };
  const NODE_TYPES = Object.keys(KEYS);
  for (const type2 of NODE_TYPES) {
    Object.freeze(KEYS[type2]);
  }
  Object.freeze(KEYS);
  const KEY_BLACKLIST = /* @__PURE__ */ new Set([
    "parent",
    "leadingComments",
    "trailingComments"
  ]);
  function filterKey(key) {
    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
  }
  function getKeys(node2) {
    return Object.keys(node2).filter(filterKey);
  }
  function unionWith(additionalKeys) {
    const retv = (
      /** @type {{ [type: string]: ReadonlyArray<string> }} */
      Object.assign({}, KEYS)
    );
    for (const type2 of Object.keys(additionalKeys)) {
      if (Object.hasOwn(retv, type2)) {
        const keys = new Set(additionalKeys[type2]);
        for (const key of retv[type2]) {
          keys.add(key);
        }
        retv[type2] = Object.freeze(Array.from(keys));
      } else {
        retv[type2] = Object.freeze(Array.from(additionalKeys[type2]));
      }
    }
    return Object.freeze(retv);
  }
  eslintVisitorKeys$1.KEYS = KEYS;
  eslintVisitorKeys$1.getKeys = getKeys;
  eslintVisitorKeys$1.unionWith = unionWith;
  return eslintVisitorKeys$1;
}
var hasRequiredEspree;
function requireEspree() {
  if (hasRequiredEspree) return espree;
  hasRequiredEspree = 1;
  Object.defineProperty(espree, "__esModule", { value: true });
  var acorn2 = requireAcorn();
  var jsx = requireAcornJsx();
  var visitorKeys = requireEslintVisitorKeys$1();
  function _interopDefaultLegacy(e2) {
    return e2 && typeof e2 === "object" && "default" in e2 ? e2 : { "default": e2 };
  }
  function _interopNamespace(e2) {
    if (e2 && e2.__esModule) return e2;
    var n2 = /* @__PURE__ */ Object.create(null);
    if (e2) {
      Object.keys(e2).forEach(function(k) {
        if (k !== "default") {
          var d2 = Object.getOwnPropertyDescriptor(e2, k);
          Object.defineProperty(n2, k, d2.get ? d2 : {
            enumerable: true,
            get: function() {
              return e2[k];
            }
          });
        }
      });
    }
    n2["default"] = e2;
    return Object.freeze(n2);
  }
  var acorn__namespace = /* @__PURE__ */ _interopNamespace(acorn2);
  var jsx__default = /* @__PURE__ */ _interopDefaultLegacy(jsx);
  var visitorKeys__namespace = /* @__PURE__ */ _interopNamespace(visitorKeys);
  const Token = {
    Boolean: "Boolean",
    Identifier: "Identifier",
    PrivateIdentifier: "PrivateIdentifier",
    Keyword: "Keyword",
    Null: "Null",
    Numeric: "Numeric",
    Punctuator: "Punctuator",
    String: "String",
    RegularExpression: "RegularExpression",
    Template: "Template",
    JSXIdentifier: "JSXIdentifier",
    JSXText: "JSXText"
  };
  function convertTemplatePart(tokens, code2) {
    const firstToken = tokens[0], lastTemplateToken = tokens.at(-1);
    const token = {
      type: Token.Template,
      value: code2.slice(firstToken.start, lastTemplateToken.end)
    };
    if (firstToken.loc) {
      token.loc = {
        start: firstToken.loc.start,
        end: lastTemplateToken.loc.end
      };
    }
    if (firstToken.range) {
      token.start = firstToken.range[0];
      token.end = lastTemplateToken.range[1];
      token.range = [token.start, token.end];
    }
    return token;
  }
  function TokenTranslator(acornTokTypes, code2) {
    this._acornTokTypes = acornTokTypes;
    this._tokens = [];
    this._curlyBrace = null;
    this._code = code2;
  }
  TokenTranslator.prototype = {
    constructor: TokenTranslator,
    /**
     * Translates a single Esprima token to a single Acorn token. This may be
     * inaccurate due to how templates are handled differently in Esprima and
     * Acorn, but should be accurate for all other tokens.
     * @param {AcornToken} token The Acorn token to translate.
     * @param {Object} extra Espree extra object.
     * @returns {EsprimaToken} The Esprima version of the token.
     */
    translate(token, extra) {
      const type2 = token.type, tt = this._acornTokTypes;
      if (type2 === tt.name) {
        token.type = Token.Identifier;
        if (token.value === "static") {
          token.type = Token.Keyword;
        }
        if (extra.ecmaVersion > 5 && (token.value === "yield" || token.value === "let")) {
          token.type = Token.Keyword;
        }
      } else if (type2 === tt.privateId) {
        token.type = Token.PrivateIdentifier;
      } else if (type2 === tt.semi || type2 === tt.comma || type2 === tt.parenL || type2 === tt.parenR || type2 === tt.braceL || type2 === tt.braceR || type2 === tt.dot || type2 === tt.bracketL || type2 === tt.colon || type2 === tt.question || type2 === tt.bracketR || type2 === tt.ellipsis || type2 === tt.arrow || type2 === tt.jsxTagStart || type2 === tt.incDec || type2 === tt.starstar || type2 === tt.jsxTagEnd || type2 === tt.prefix || type2 === tt.questionDot || type2.binop && !type2.keyword || type2.isAssign) {
        token.type = Token.Punctuator;
        token.value = this._code.slice(token.start, token.end);
      } else if (type2 === tt.jsxName) {
        token.type = Token.JSXIdentifier;
      } else if (type2.label === "jsxText" || type2 === tt.jsxAttrValueToken) {
        token.type = Token.JSXText;
      } else if (type2.keyword) {
        if (type2.keyword === "true" || type2.keyword === "false") {
          token.type = Token.Boolean;
        } else if (type2.keyword === "null") {
          token.type = Token.Null;
        } else {
          token.type = Token.Keyword;
        }
      } else if (type2 === tt.num) {
        token.type = Token.Numeric;
        token.value = this._code.slice(token.start, token.end);
      } else if (type2 === tt.string) {
        if (extra.jsxAttrValueToken) {
          extra.jsxAttrValueToken = false;
          token.type = Token.JSXText;
        } else {
          token.type = Token.String;
        }
        token.value = this._code.slice(token.start, token.end);
      } else if (type2 === tt.regexp) {
        token.type = Token.RegularExpression;
        const value = token.value;
        token.regex = {
          flags: value.flags,
          pattern: value.pattern
        };
        token.value = `/${value.pattern}/${value.flags}`;
      }
      return token;
    },
    /**
     * Function to call during Acorn's onToken handler.
     * @param {AcornToken} token The Acorn token.
     * @param {Object} extra The Espree extra object.
     * @returns {void}
     */
    onToken(token, extra) {
      const tt = this._acornTokTypes, tokens = extra.tokens, templateTokens = this._tokens;
      const translateTemplateTokens = () => {
        tokens.push(convertTemplatePart(this._tokens, this._code));
        this._tokens = [];
      };
      if (token.type === tt.eof) {
        if (this._curlyBrace) {
          tokens.push(this.translate(this._curlyBrace, extra));
        }
        return;
      }
      if (token.type === tt.backQuote) {
        if (this._curlyBrace) {
          tokens.push(this.translate(this._curlyBrace, extra));
          this._curlyBrace = null;
        }
        templateTokens.push(token);
        if (templateTokens.length > 1) {
          translateTemplateTokens();
        }
        return;
      }
      if (token.type === tt.dollarBraceL) {
        templateTokens.push(token);
        translateTemplateTokens();
        return;
      }
      if (token.type === tt.braceR) {
        if (this._curlyBrace) {
          tokens.push(this.translate(this._curlyBrace, extra));
        }
        this._curlyBrace = token;
        return;
      }
      if (token.type === tt.template || token.type === tt.invalidTemplate) {
        if (this._curlyBrace) {
          templateTokens.push(this._curlyBrace);
          this._curlyBrace = null;
        }
        templateTokens.push(token);
        return;
      }
      if (this._curlyBrace) {
        tokens.push(this.translate(this._curlyBrace, extra));
        this._curlyBrace = null;
      }
      tokens.push(this.translate(token, extra));
    }
  };
  const SUPPORTED_VERSIONS = [
    3,
    5,
    6,
    // 2015
    7,
    // 2016
    8,
    // 2017
    9,
    // 2018
    10,
    // 2019
    11,
    // 2020
    12,
    // 2021
    13,
    // 2022
    14,
    // 2023
    15,
    // 2024
    16,
    // 2025
    17
    // 2026
  ];
  function getLatestEcmaVersion() {
    return SUPPORTED_VERSIONS.at(-1);
  }
  function getSupportedEcmaVersions() {
    return [...SUPPORTED_VERSIONS];
  }
  function normalizeEcmaVersion(ecmaVersion2 = 5) {
    let version3 = ecmaVersion2 === "latest" ? getLatestEcmaVersion() : ecmaVersion2;
    if (typeof version3 !== "number") {
      throw new Error(`ecmaVersion must be a number or "latest". Received value of type ${typeof ecmaVersion2} instead.`);
    }
    if (version3 >= 2015) {
      version3 -= 2009;
    }
    if (!SUPPORTED_VERSIONS.includes(version3)) {
      throw new Error("Invalid ecmaVersion.");
    }
    return version3;
  }
  function normalizeSourceType(sourceType = "script") {
    if (sourceType === "script" || sourceType === "module") {
      return sourceType;
    }
    if (sourceType === "commonjs") {
      return "script";
    }
    throw new Error("Invalid sourceType.");
  }
  function normalizeOptions(options) {
    const ecmaVersion2 = normalizeEcmaVersion(options.ecmaVersion);
    const sourceType = normalizeSourceType(options.sourceType);
    const ranges = options.range === true;
    const locations = options.loc === true;
    if (ecmaVersion2 !== 3 && options.allowReserved) {
      throw new Error("`allowReserved` is only supported when ecmaVersion is 3");
    }
    if (typeof options.allowReserved !== "undefined" && typeof options.allowReserved !== "boolean") {
      throw new Error("`allowReserved`, when present, must be `true` or `false`");
    }
    const allowReserved = ecmaVersion2 === 3 ? options.allowReserved || "never" : false;
    const ecmaFeatures = options.ecmaFeatures || {};
    const allowReturnOutsideFunction = options.sourceType === "commonjs" || Boolean(ecmaFeatures.globalReturn);
    if (sourceType === "module" && ecmaVersion2 < 6) {
      throw new Error("sourceType 'module' is not supported when ecmaVersion < 2015. Consider adding `{ ecmaVersion: 2015 }` to the parser options.");
    }
    return Object.assign({}, options, {
      ecmaVersion: ecmaVersion2,
      sourceType,
      ranges,
      locations,
      allowReserved,
      allowReturnOutsideFunction
    });
  }
  const STATE = Symbol("espree's internal state");
  const ESPRIMA_FINISH_NODE = Symbol("espree's esprimaFinishNode");
  function convertAcornCommentToEsprimaComment(block, text, start, end, startLoc, endLoc, code2) {
    let type2;
    if (block) {
      type2 = "Block";
    } else if (code2.slice(start, start + 2) === "#!") {
      type2 = "Hashbang";
    } else {
      type2 = "Line";
    }
    const comment2 = {
      type: type2,
      value: text
    };
    if (typeof start === "number") {
      comment2.start = start;
      comment2.end = end;
      comment2.range = [start, end];
    }
    if (typeof startLoc === "object") {
      comment2.loc = {
        start: startLoc,
        end: endLoc
      };
    }
    return comment2;
  }
  var espree$1 = () => (Parser) => {
    const tokTypes = Object.assign({}, Parser.acorn.tokTypes);
    if (Parser.acornJsx) {
      Object.assign(tokTypes, Parser.acornJsx.tokTypes);
    }
    return class Espree extends Parser {
      constructor(opts, code2) {
        if (typeof opts !== "object" || opts === null) {
          opts = {};
        }
        if (typeof code2 !== "string" && !(code2 instanceof String)) {
          code2 = String(code2);
        }
        const originalSourceType = opts.sourceType;
        const options = normalizeOptions(opts);
        const ecmaFeatures = options.ecmaFeatures || {};
        const tokenTranslator = options.tokens === true ? new TokenTranslator(tokTypes, code2) : null;
        const state = {
          originalSourceType: originalSourceType || options.sourceType,
          tokens: tokenTranslator ? [] : null,
          comments: options.comment === true ? [] : null,
          impliedStrict: ecmaFeatures.impliedStrict === true && options.ecmaVersion >= 5,
          ecmaVersion: options.ecmaVersion,
          jsxAttrValueToken: false,
          lastToken: null,
          templateElements: []
        };
        super({
          // do not use spread, because we don't want to pass any unknown options to acorn
          ecmaVersion: options.ecmaVersion,
          sourceType: options.sourceType,
          ranges: options.ranges,
          locations: options.locations,
          allowReserved: options.allowReserved,
          // Truthy value is true for backward compatibility.
          allowReturnOutsideFunction: options.allowReturnOutsideFunction,
          // Collect tokens
          onToken(token) {
            if (tokenTranslator) {
              tokenTranslator.onToken(token, state);
            }
            if (token.type !== tokTypes.eof) {
              state.lastToken = token;
            }
          },
          // Collect comments
          onComment(block, text, start, end, startLoc, endLoc) {
            if (state.comments) {
              const comment2 = convertAcornCommentToEsprimaComment(block, text, start, end, startLoc, endLoc, code2);
              state.comments.push(comment2);
            }
          }
        }, code2);
        this[STATE] = state;
      }
      tokenize() {
        do {
          this.next();
        } while (this.type !== tokTypes.eof);
        this.next();
        const extra = this[STATE];
        const tokens = extra.tokens;
        if (extra.comments) {
          tokens.comments = extra.comments;
        }
        return tokens;
      }
      finishNode(...args) {
        const result = super.finishNode(...args);
        return this[ESPRIMA_FINISH_NODE](result);
      }
      finishNodeAt(...args) {
        const result = super.finishNodeAt(...args);
        return this[ESPRIMA_FINISH_NODE](result);
      }
      parse() {
        const extra = this[STATE];
        const program = super.parse();
        program.sourceType = extra.originalSourceType;
        if (extra.comments) {
          program.comments = extra.comments;
        }
        if (extra.tokens) {
          program.tokens = extra.tokens;
        }
        if (program.body.length) {
          const [firstNode] = program.body;
          if (program.range) {
            program.range[0] = firstNode.range[0];
          }
          if (program.loc) {
            program.loc.start = firstNode.loc.start;
          }
          program.start = firstNode.start;
        }
        if (extra.lastToken) {
          if (program.range) {
            program.range[1] = extra.lastToken.range[1];
          }
          if (program.loc) {
            program.loc.end = extra.lastToken.loc.end;
          }
          program.end = extra.lastToken.end;
        }
        this[STATE].templateElements.forEach((templateElement) => {
          const startOffset = -1;
          const endOffset = templateElement.tail ? 1 : 2;
          templateElement.start += startOffset;
          templateElement.end += endOffset;
          if (templateElement.range) {
            templateElement.range[0] += startOffset;
            templateElement.range[1] += endOffset;
          }
          if (templateElement.loc) {
            templateElement.loc.start.column += startOffset;
            templateElement.loc.end.column += endOffset;
          }
        });
        return program;
      }
      parseTopLevel(node2) {
        if (this[STATE].impliedStrict) {
          this.strict = true;
        }
        return super.parseTopLevel(node2);
      }
      /**
       * Overwrites the default raise method to throw Esprima-style errors.
       * @param {int} pos The position of the error.
       * @param {string} message The error message.
       * @throws {SyntaxError} A syntax error.
       * @returns {void}
       */
      raise(pos, message) {
        const loc = Parser.acorn.getLineInfo(this.input, pos);
        const err = new SyntaxError(message);
        err.index = pos;
        err.lineNumber = loc.line;
        err.column = loc.column + 1;
        throw err;
      }
      /**
       * Overwrites the default raise method to throw Esprima-style errors.
       * @param {int} pos The position of the error.
       * @param {string} message The error message.
       * @throws {SyntaxError} A syntax error.
       * @returns {void}
       */
      raiseRecoverable(pos, message) {
        this.raise(pos, message);
      }
      /**
       * Overwrites the default unexpected method to throw Esprima-style errors.
       * @param {int} pos The position of the error.
       * @throws {SyntaxError} A syntax error.
       * @returns {void}
       */
      unexpected(pos) {
        let message = "Unexpected token";
        if (pos !== null && pos !== void 0) {
          this.pos = pos;
          if (this.options.locations) {
            while (this.pos < this.lineStart) {
              this.lineStart = this.input.lastIndexOf("\n", this.lineStart - 2) + 1;
              --this.curLine;
            }
          }
          this.nextToken();
        }
        if (this.end > this.start) {
          message += ` ${this.input.slice(this.start, this.end)}`;
        }
        this.raise(this.start, message);
      }
      /*
      * Esprima-FB represents JSX strings as tokens called "JSXText", but Acorn-JSX
      * uses regular tt.string without any distinction between this and regular JS
      * strings. As such, we intercept an attempt to read a JSX string and set a flag
      * on extra so that when tokens are converted, the next token will be switched
      * to JSXText via onToken.
      */
      jsx_readString(quote) {
        const result = super.jsx_readString(quote);
        if (this.type === tokTypes.string) {
          this[STATE].jsxAttrValueToken = true;
        }
        return result;
      }
      /**
       * Performs last-minute Esprima-specific compatibility checks and fixes.
       * @param {ASTNode} result The node to check.
       * @returns {ASTNode} The finished node.
       */
      [ESPRIMA_FINISH_NODE](result) {
        if (result.type === "TemplateElement") {
          this[STATE].templateElements.push(result);
        }
        if (result.type.includes("Function") && !result.generator) {
          result.generator = false;
        }
        return result;
      }
    };
  };
  const version$12 = "10.4.0";
  const parsers = {
    _regular: null,
    _jsx: null,
    get regular() {
      if (this._regular === null) {
        this._regular = acorn__namespace.Parser.extend(espree$1());
      }
      return this._regular;
    },
    get jsx() {
      if (this._jsx === null) {
        this._jsx = acorn__namespace.Parser.extend(jsx__default["default"](), espree$1());
      }
      return this._jsx;
    },
    get(options) {
      const useJsx = Boolean(
        options && options.ecmaFeatures && options.ecmaFeatures.jsx
      );
      return useJsx ? this.jsx : this.regular;
    }
  };
  function tokenize(code2, options) {
    const Parser = parsers.get(options);
    if (!options || options.tokens !== true) {
      options = Object.assign({}, options, { tokens: true });
    }
    return new Parser(options, code2).tokenize();
  }
  function parse(code2, options) {
    const Parser = parsers.get(options);
    return new Parser(options, code2).parse();
  }
  const version2 = version$12;
  const name = "espree";
  const VisitorKeys = (function() {
    return visitorKeys__namespace.KEYS;
  })();
  const Syntax = (function() {
    let key, types = {};
    if (typeof Object.create === "function") {
      types = /* @__PURE__ */ Object.create(null);
    }
    for (key in VisitorKeys) {
      if (Object.hasOwn(VisitorKeys, key)) {
        types[key] = key;
      }
    }
    if (typeof Object.freeze === "function") {
      Object.freeze(types);
    }
    return types;
  })();
  const latestEcmaVersion = getLatestEcmaVersion();
  const supportedEcmaVersions = getSupportedEcmaVersions();
  espree.Syntax = Syntax;
  espree.VisitorKeys = VisitorKeys;
  espree.latestEcmaVersion = latestEcmaVersion;
  espree.name = name;
  espree.parse = parse;
  espree.supportedEcmaVersions = supportedEcmaVersions;
  espree.tokenize = tokenize;
  espree.version = version2;
  return espree;
}
var lodash_merge = { exports: {} };
lodash_merge.exports;
var hasRequiredLodash_merge;
function requireLodash_merge() {
  if (hasRequiredLodash_merge) return lodash_merge.exports;
  hasRequiredLodash_merge = 1;
  (function(module, exports$1) {
    var LARGE_ARRAY_SIZE = 200;
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var HOT_COUNT = 800, HOT_SPAN = 16;
    var MAX_SAFE_INTEGER = 9007199254740991;
    var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]";
    var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    var freeGlobal = typeof global$1 == "object" && global$1 && global$1.Object === Object && global$1;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    var freeExports = exports$1 && !exports$1.nodeType && exports$1;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal.process;
    var nodeUtil = (function() {
      try {
        var types = freeModule && freeModule.require && freeModule.require("util").types;
        if (types) {
          return types;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e2) {
      }
    })();
    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    function apply(func, thisArg, args) {
      switch (args.length) {
        case 0:
          return func.call(thisArg);
        case 1:
          return func.call(thisArg, args[0]);
        case 2:
          return func.call(thisArg, args[0], args[1]);
        case 3:
          return func.call(thisArg, args[0], args[1], args[2]);
      }
      return func.apply(thisArg, args);
    }
    function baseTimes(n2, iteratee) {
      var index = -1, result = Array(n2);
      while (++index < n2) {
        result[index] = iteratee(index);
      }
      return result;
    }
    function baseUnary(func) {
      return function(value) {
        return func(value);
      };
    }
    function getValue(object, key) {
      return object == null ? void 0 : object[key];
    }
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }
    var arrayProto = Array.prototype, funcProto = Function.prototype, objectProto = Object.prototype;
    var coreJsData = root["__core-js_shared__"];
    var funcToString = funcProto.toString;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var maskSrcKey = (function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    })();
    var nativeObjectToString = objectProto.toString;
    var objectCtorString = funcToString.call(Object);
    var reIsNative = RegExp(
      "^" + funcToString.call(hasOwnProperty).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    var Buffer = moduleExports ? root.Buffer : void 0, Symbol2 = root.Symbol, Uint8Array = root.Uint8Array;
    Buffer ? Buffer.allocUnsafe : void 0;
    var getPrototype = overArg(Object.getPrototypeOf, Object), objectCreate = Object.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    var defineProperty = (function() {
      try {
        var func = getNative(Object, "defineProperty");
        func({}, "", {});
        return func;
      } catch (e2) {
      }
    })();
    var nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0, nativeMax = Math.max, nativeNow = Date.now;
    var Map2 = getNative(root, "Map"), nativeCreate = getNative(Object, "create");
    var baseCreate = /* @__PURE__ */ (function() {
      function object() {
      }
      return function(proto) {
        if (!isObject(proto)) {
          return {};
        }
        if (objectCreate) {
          return objectCreate(proto);
        }
        object.prototype = proto;
        var result = new object();
        object.prototype = void 0;
        return result;
      };
    })();
    function Hash(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
      this.size = 0;
    }
    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }
    function hashGet(key) {
      var data2 = this.__data__;
      if (nativeCreate) {
        var result = data2[key];
        return result === HASH_UNDEFINED ? void 0 : result;
      }
      return hasOwnProperty.call(data2, key) ? data2[key] : void 0;
    }
    function hashHas(key) {
      var data2 = this.__data__;
      return nativeCreate ? data2[key] !== void 0 : hasOwnProperty.call(data2, key);
    }
    function hashSet(key, value) {
      var data2 = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data2[key] = nativeCreate && value === void 0 ? HASH_UNDEFINED : value;
      return this;
    }
    Hash.prototype.clear = hashClear;
    Hash.prototype["delete"] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    function ListCache(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }
    function listCacheDelete(key) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      if (index < 0) {
        return false;
      }
      var lastIndex = data2.length - 1;
      if (index == lastIndex) {
        data2.pop();
      } else {
        splice.call(data2, index, 1);
      }
      --this.size;
      return true;
    }
    function listCacheGet(key) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      return index < 0 ? void 0 : data2[index][1];
    }
    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    function listCacheSet(key, value) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      if (index < 0) {
        ++this.size;
        data2.push([key, value]);
      } else {
        data2[index][1] = value;
      }
      return this;
    }
    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype["delete"] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    function MapCache(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        "hash": new Hash(),
        "map": new (Map2 || ListCache)(),
        "string": new Hash()
      };
    }
    function mapCacheDelete(key) {
      var result = getMapData(this, key)["delete"](key);
      this.size -= result ? 1 : 0;
      return result;
    }
    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    function mapCacheSet(key, value) {
      var data2 = getMapData(this, key), size = data2.size;
      data2.set(key, value);
      this.size += data2.size == size ? 0 : 1;
      return this;
    }
    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype["delete"] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    function Stack(entries) {
      var data2 = this.__data__ = new ListCache(entries);
      this.size = data2.size;
    }
    function stackClear() {
      this.__data__ = new ListCache();
      this.size = 0;
    }
    function stackDelete(key) {
      var data2 = this.__data__, result = data2["delete"](key);
      this.size = data2.size;
      return result;
    }
    function stackGet(key) {
      return this.__data__.get(key);
    }
    function stackHas(key) {
      return this.__data__.has(key);
    }
    function stackSet(key, value) {
      var data2 = this.__data__;
      if (data2 instanceof ListCache) {
        var pairs = data2.__data__;
        if (!Map2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
          pairs.push([key, value]);
          this.size = ++data2.size;
          return this;
        }
        data2 = this.__data__ = new MapCache(pairs);
      }
      data2.set(key, value);
      this.size = data2.size;
      return this;
    }
    Stack.prototype.clear = stackClear;
    Stack.prototype["delete"] = stackDelete;
    Stack.prototype.get = stackGet;
    Stack.prototype.has = stackHas;
    Stack.prototype.set = stackSet;
    function arrayLikeKeys(value, inherited) {
      var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
      for (var key in value) {
        if (!(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
        (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
        isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
        isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
        isIndex(key, length)))) {
          result.push(key);
        }
      }
      return result;
    }
    function assignMergeValue(object, key, value) {
      if (value !== void 0 && !eq(object[key], value) || value === void 0 && !(key in object)) {
        baseAssignValue(object, key, value);
      }
    }
    function assignValue(object, key, value) {
      var objValue = object[key];
      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) || value === void 0 && !(key in object)) {
        baseAssignValue(object, key, value);
      }
    }
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }
    function baseAssignValue(object, key, value) {
      if (key == "__proto__" && defineProperty) {
        defineProperty(object, key, {
          "configurable": true,
          "enumerable": true,
          "value": value,
          "writable": true
        });
      } else {
        object[key] = value;
      }
    }
    var baseFor = createBaseFor();
    function baseGetTag(value) {
      if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
      }
      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }
    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }
      var pattern2 = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern2.test(toSource(value));
    }
    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }
    function baseKeysIn(object) {
      if (!isObject(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype(object), result = [];
      for (var key in object) {
        if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object, key)))) {
          result.push(key);
        }
      }
      return result;
    }
    function baseMerge(object, source, srcIndex, customizer, stack) {
      if (object === source) {
        return;
      }
      baseFor(source, function(srcValue, key) {
        stack || (stack = new Stack());
        if (isObject(srcValue)) {
          baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
        } else {
          var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack) : void 0;
          if (newValue === void 0) {
            newValue = srcValue;
          }
          assignMergeValue(object, key, newValue);
        }
      }, keysIn);
    }
    function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
      var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
      if (stacked) {
        assignMergeValue(object, key, stacked);
        return;
      }
      var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : void 0;
      var isCommon = newValue === void 0;
      if (isCommon) {
        var isArr = isArray(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
        newValue = srcValue;
        if (isArr || isBuff || isTyped) {
          if (isArray(objValue)) {
            newValue = objValue;
          } else if (isArrayLikeObject(objValue)) {
            newValue = copyArray(objValue);
          } else if (isBuff) {
            isCommon = false;
            newValue = cloneBuffer(srcValue);
          } else if (isTyped) {
            isCommon = false;
            newValue = cloneTypedArray(srcValue);
          } else {
            newValue = [];
          }
        } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
          newValue = objValue;
          if (isArguments(objValue)) {
            newValue = toPlainObject(objValue);
          } else if (!isObject(objValue) || isFunction(objValue)) {
            newValue = initCloneObject(srcValue);
          }
        } else {
          isCommon = false;
        }
      }
      if (isCommon) {
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack["delete"](srcValue);
      }
      assignMergeValue(object, key, newValue);
    }
    function baseRest(func, start) {
      return setToString(overRest(func, start, identity), func + "");
    }
    var baseSetToString = !defineProperty ? identity : function(func, string) {
      return defineProperty(func, "toString", {
        "configurable": true,
        "enumerable": false,
        "value": constant(string),
        "writable": true
      });
    };
    function cloneBuffer(buffer, isDeep) {
      {
        return buffer.slice();
      }
    }
    function cloneArrayBuffer(arrayBuffer) {
      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
      new Uint8Array(result).set(new Uint8Array(arrayBuffer));
      return result;
    }
    function cloneTypedArray(typedArray, isDeep) {
      var buffer = cloneArrayBuffer(typedArray.buffer);
      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
    }
    function copyArray(source, array) {
      var index = -1, length = source.length;
      array || (array = Array(length));
      while (++index < length) {
        array[index] = source[index];
      }
      return array;
    }
    function copyObject(source, props, object, customizer) {
      var isNew = !object;
      object || (object = {});
      var index = -1, length = props.length;
      while (++index < length) {
        var key = props[index];
        var newValue = void 0;
        if (newValue === void 0) {
          newValue = source[key];
        }
        if (isNew) {
          baseAssignValue(object, key, newValue);
        } else {
          assignValue(object, key, newValue);
        }
      }
      return object;
    }
    function createAssigner(assigner) {
      return baseRest(function(object, sources) {
        var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : void 0, guard = length > 2 ? sources[2] : void 0;
        customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : void 0;
        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
          customizer = length < 3 ? void 0 : customizer;
          length = 1;
        }
        object = Object(object);
        while (++index < length) {
          var source = sources[index];
          if (source) {
            assigner(object, source, index, customizer);
          }
        }
        return object;
      });
    }
    function createBaseFor(fromRight) {
      return function(object, iteratee, keysFunc) {
        var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
        while (length--) {
          var key = props[++index];
          if (iteratee(iterable[key], key, iterable) === false) {
            break;
          }
        }
        return object;
      };
    }
    function getMapData(map, key) {
      var data2 = map.__data__;
      return isKeyable(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
    }
    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : void 0;
    }
    function getRawTag(value) {
      var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
      try {
        value[symToStringTag] = void 0;
        var unmasked = true;
      } catch (e2) {
      }
      var result = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }
      return result;
    }
    function initCloneObject(object) {
      return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
    }
    function isIndex(value, length) {
      var type2 = typeof value;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (type2 == "number" || type2 != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
    }
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type2 = typeof index;
      if (type2 == "number" ? isArrayLike(object) && isIndex(index, object.length) : type2 == "string" && index in object) {
        return eq(object[index], value);
      }
      return false;
    }
    function isKeyable(value) {
      var type2 = typeof value;
      return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
    }
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    function isPrototype(value) {
      var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
      return value === proto;
    }
    function nativeKeysIn(object) {
      var result = [];
      if (object != null) {
        for (var key in Object(object)) {
          result.push(key);
        }
      }
      return result;
    }
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    function overRest(func, start, transform) {
      start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
      return function() {
        var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
        while (++index < length) {
          array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while (++index < start) {
          otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return apply(func, this, otherArgs);
      };
    }
    function safeGet(object, key) {
      if (key === "constructor" && typeof object[key] === "function") {
        return;
      }
      if (key == "__proto__") {
        return;
      }
      return object[key];
    }
    var setToString = shortOut(baseSetToString);
    function shortOut(func) {
      var count = 0, lastCalled = 0;
      return function() {
        var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return arguments[0];
          }
        } else {
          count = 0;
        }
        return func.apply(void 0, arguments);
      };
    }
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e2) {
        }
        try {
          return func + "";
        } catch (e2) {
        }
      }
      return "";
    }
    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    var isArguments = baseIsArguments(/* @__PURE__ */ (function() {
      return arguments;
    })()) ? baseIsArguments : function(value) {
      return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
    };
    var isArray = Array.isArray;
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    function isArrayLikeObject(value) {
      return isObjectLike(value) && isArrayLike(value);
    }
    var isBuffer = nativeIsBuffer || stubFalse;
    function isFunction(value) {
      if (!isObject(value)) {
        return false;
      }
      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    function isLength(value) {
      return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    function isObject(value) {
      var type2 = typeof value;
      return value != null && (type2 == "object" || type2 == "function");
    }
    function isObjectLike(value) {
      return value != null && typeof value == "object";
    }
    function isPlainObject(value) {
      if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
        return false;
      }
      var proto = getPrototype(value);
      if (proto === null) {
        return true;
      }
      var Ctor = hasOwnProperty.call(proto, "constructor") && proto.constructor;
      return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
    }
    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    function toPlainObject(value) {
      return copyObject(value, keysIn(value));
    }
    function keysIn(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeysIn(object);
    }
    var merge = createAssigner(function(object, source, srcIndex) {
      baseMerge(object, source, srcIndex);
    });
    function constant(value) {
      return function() {
        return value;
      };
    }
    function identity(value) {
      return value;
    }
    function stubFalse() {
      return false;
    }
    module.exports = merge;
  })(lodash_merge, lodash_merge.exports);
  return lodash_merge.exports;
}
var version = "9.39.1";
var require$$5 = {
  version
};
var eslintrcUniversal = {};
var uri_all = { exports: {} };
var hasRequiredUri_all;
function requireUri_all() {
  if (hasRequiredUri_all) return uri_all.exports;
  hasRequiredUri_all = 1;
  (function(module, exports$1) {
    (function(global, factory) {
      factory(exports$1);
    })(this, (function(exports2) {
      function merge() {
        for (var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++) {
          sets[_key] = arguments[_key];
        }
        if (sets.length > 1) {
          sets[0] = sets[0].slice(0, -1);
          var xl = sets.length - 1;
          for (var x2 = 1; x2 < xl; ++x2) {
            sets[x2] = sets[x2].slice(1, -1);
          }
          sets[xl] = sets[xl].slice(1);
          return sets.join("");
        } else {
          return sets[0];
        }
      }
      function subexp(str) {
        return "(?:" + str + ")";
      }
      function typeOf(o2) {
        return o2 === void 0 ? "undefined" : o2 === null ? "null" : Object.prototype.toString.call(o2).split(" ").pop().split("]").shift().toLowerCase();
      }
      function toUpperCase(str) {
        return str.toUpperCase();
      }
      function toArray(obj) {
        return obj !== void 0 && obj !== null ? obj instanceof Array ? obj : typeof obj.length !== "number" || obj.split || obj.setInterval || obj.call ? [obj] : Array.prototype.slice.call(obj) : [];
      }
      function assign(target, source) {
        var obj = target;
        if (source) {
          for (var key in source) {
            obj[key] = source[key];
          }
        }
        return obj;
      }
      function buildExps(isIRI) {
        var ALPHA$$ = "[A-Za-z]", DIGIT$$ = "[0-9]", HEXDIG$$2 = merge(DIGIT$$, "[A-Fa-f]"), PCT_ENCODED$2 = subexp(subexp("%[EFef]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%" + HEXDIG$$2 + HEXDIG$$2)), GEN_DELIMS$$ = "[\\:\\/\\?\\#\\[\\]\\@]", SUB_DELIMS$$ = "[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]", RESERVED$$ = merge(GEN_DELIMS$$, SUB_DELIMS$$), UCSCHAR$$ = isIRI ? "[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]" : "[]", IPRIVATE$$ = isIRI ? "[\\uE000-\\uF8FF]" : "[]", UNRESERVED$$2 = merge(ALPHA$$, DIGIT$$, "[\\-\\.\\_\\~]", UCSCHAR$$);
        subexp(ALPHA$$ + merge(ALPHA$$, DIGIT$$, "[\\+\\-\\.]") + "*");
        subexp(subexp(PCT_ENCODED$2 + "|" + merge(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]")) + "*");
        var DEC_OCTET_RELAXED$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("0?[1-9]" + DIGIT$$) + "|0?0?" + DIGIT$$), IPV4ADDRESS$ = subexp(DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$), H16$ = subexp(HEXDIG$$2 + "{1,4}"), LS32$ = subexp(subexp(H16$ + "\\:" + H16$) + "|" + IPV4ADDRESS$), IPV6ADDRESS1$ = subexp(subexp(H16$ + "\\:") + "{6}" + LS32$), IPV6ADDRESS2$ = subexp("\\:\\:" + subexp(H16$ + "\\:") + "{5}" + LS32$), IPV6ADDRESS3$ = subexp(subexp(H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{4}" + LS32$), IPV6ADDRESS4$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,1}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{3}" + LS32$), IPV6ADDRESS5$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,2}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{2}" + LS32$), IPV6ADDRESS6$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,3}" + H16$) + "?\\:\\:" + H16$ + "\\:" + LS32$), IPV6ADDRESS7$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,4}" + H16$) + "?\\:\\:" + LS32$), IPV6ADDRESS8$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,5}" + H16$) + "?\\:\\:" + H16$), IPV6ADDRESS9$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,6}" + H16$) + "?\\:\\:"), IPV6ADDRESS$ = subexp([IPV6ADDRESS1$, IPV6ADDRESS2$, IPV6ADDRESS3$, IPV6ADDRESS4$, IPV6ADDRESS5$, IPV6ADDRESS6$, IPV6ADDRESS7$, IPV6ADDRESS8$, IPV6ADDRESS9$].join("|")), ZONEID$ = subexp(subexp(UNRESERVED$$2 + "|" + PCT_ENCODED$2) + "+");
        subexp("[vV]" + HEXDIG$$2 + "+\\." + merge(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]") + "+");
        subexp(subexp(PCT_ENCODED$2 + "|" + merge(UNRESERVED$$2, SUB_DELIMS$$)) + "*");
        var PCHAR$ = subexp(PCT_ENCODED$2 + "|" + merge(UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@]"));
        subexp(subexp(PCT_ENCODED$2 + "|" + merge(UNRESERVED$$2, SUB_DELIMS$$, "[\\@]")) + "+");
        subexp(subexp(PCHAR$ + "|" + merge("[\\/\\?]", IPRIVATE$$)) + "*");
        return {
          NOT_SCHEME: new RegExp(merge("[^]", ALPHA$$, DIGIT$$, "[\\+\\-\\.]"), "g"),
          NOT_USERINFO: new RegExp(merge("[^\\%\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
          NOT_HOST: new RegExp(merge("[^\\%\\[\\]\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
          NOT_PATH: new RegExp(merge("[^\\%\\/\\:\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
          NOT_PATH_NOSCHEME: new RegExp(merge("[^\\%\\/\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
          NOT_QUERY: new RegExp(merge("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]", IPRIVATE$$), "g"),
          NOT_FRAGMENT: new RegExp(merge("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]"), "g"),
          ESCAPE: new RegExp(merge("[^]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
          UNRESERVED: new RegExp(UNRESERVED$$2, "g"),
          OTHER_CHARS: new RegExp(merge("[^\\%]", UNRESERVED$$2, RESERVED$$), "g"),
          PCT_ENCODED: new RegExp(PCT_ENCODED$2, "g"),
          IPV4ADDRESS: new RegExp("^(" + IPV4ADDRESS$ + ")$"),
          IPV6ADDRESS: new RegExp("^\\[?(" + IPV6ADDRESS$ + ")" + subexp(subexp("\\%25|\\%(?!" + HEXDIG$$2 + "{2})") + "(" + ZONEID$ + ")") + "?\\]?$")
          //RFC 6874, with relaxed parsing rules
        };
      }
      var URI_PROTOCOL = buildExps(false);
      var IRI_PROTOCOL = buildExps(true);
      var slicedToArray = /* @__PURE__ */ (function() {
        function sliceIterator(arr, i2) {
          var _arr = [];
          var _n = true;
          var _d = false;
          var _e = void 0;
          try {
            for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
              _arr.push(_s.value);
              if (i2 && _arr.length === i2) break;
            }
          } catch (err) {
            _d = true;
            _e = err;
          } finally {
            try {
              if (!_n && _i["return"]) _i["return"]();
            } finally {
              if (_d) throw _e;
            }
          }
          return _arr;
        }
        return function(arr, i2) {
          if (Array.isArray(arr)) {
            return arr;
          } else if (Symbol.iterator in Object(arr)) {
            return sliceIterator(arr, i2);
          } else {
            throw new TypeError("Invalid attempt to destructure non-iterable instance");
          }
        };
      })();
      var toConsumableArray = function(arr) {
        if (Array.isArray(arr)) {
          for (var i2 = 0, arr2 = Array(arr.length); i2 < arr.length; i2++) arr2[i2] = arr[i2];
          return arr2;
        } else {
          return Array.from(arr);
        }
      };
      var maxInt = 2147483647;
      var base = 36;
      var tMin = 1;
      var tMax = 26;
      var skew = 38;
      var damp = 700;
      var initialBias = 72;
      var initialN = 128;
      var delimiter2 = "-";
      var regexPunycode = /^xn--/;
      var regexNonASCII = /[^\0-\x7E]/;
      var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
      var errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      };
      var baseMinusTMin = base - tMin;
      var floor = Math.floor;
      var stringFromCharCode = String.fromCharCode;
      function error$1(type2) {
        throw new RangeError(errors[type2]);
      }
      function map(array, fn) {
        var result = [];
        var length = array.length;
        while (length--) {
          result[length] = fn(array[length]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [];
        var counter = 0;
        var length = string.length;
        while (counter < length) {
          var value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length) {
            var extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      var ucs2encode = function ucs2encode2(array) {
        return String.fromCodePoint.apply(String, toConsumableArray(array));
      };
      var basicToDigit = function basicToDigit2(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      };
      var digitToBasic = function digitToBasic2(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      };
      var adapt = function adapt2(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (
          ;
          /* no initialization */
          delta > baseMinusTMin * tMax >> 1;
          k += base
        ) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      };
      var decode = function decode2(input) {
        var output = [];
        var inputLength = input.length;
        var i2 = 0;
        var n2 = initialN;
        var bias = initialBias;
        var basic = input.lastIndexOf(delimiter2);
        if (basic < 0) {
          basic = 0;
        }
        for (var j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error$1("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (var index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          var oldi = i2;
          for (
            var w = 1, k = base;
            ;
            /* no condition */
            k += base
          ) {
            if (index >= inputLength) {
              error$1("invalid-input");
            }
            var digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i2) / w)) {
              error$1("overflow");
            }
            i2 += digit * w;
            var t2 = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t2) {
              break;
            }
            var baseMinusT = base - t2;
            if (w > floor(maxInt / baseMinusT)) {
              error$1("overflow");
            }
            w *= baseMinusT;
          }
          var out = output.length + 1;
          bias = adapt(i2 - oldi, out, oldi == 0);
          if (floor(i2 / out) > maxInt - n2) {
            error$1("overflow");
          }
          n2 += floor(i2 / out);
          i2 %= out;
          output.splice(i2++, 0, n2);
        }
        return String.fromCodePoint.apply(String, output);
      };
      var encode = function encode2(input) {
        var output = [];
        input = ucs2decode(input);
        var inputLength = input.length;
        var n2 = initialN;
        var delta = 0;
        var bias = initialBias;
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = void 0;
        try {
          for (var _iterator = input[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var _currentValue2 = _step.value;
            if (_currentValue2 < 128) {
              output.push(stringFromCharCode(_currentValue2));
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        var basicLength = output.length;
        var handledCPCount = basicLength;
        if (basicLength) {
          output.push(delimiter2);
        }
        while (handledCPCount < inputLength) {
          var m2 = maxInt;
          var _iteratorNormalCompletion2 = true;
          var _didIteratorError2 = false;
          var _iteratorError2 = void 0;
          try {
            for (var _iterator2 = input[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
              var currentValue = _step2.value;
              if (currentValue >= n2 && currentValue < m2) {
                m2 = currentValue;
              }
            }
          } catch (err) {
            _didIteratorError2 = true;
            _iteratorError2 = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion2 && _iterator2.return) {
                _iterator2.return();
              }
            } finally {
              if (_didIteratorError2) {
                throw _iteratorError2;
              }
            }
          }
          var handledCPCountPlusOne = handledCPCount + 1;
          if (m2 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error$1("overflow");
          }
          delta += (m2 - n2) * handledCPCountPlusOne;
          n2 = m2;
          var _iteratorNormalCompletion3 = true;
          var _didIteratorError3 = false;
          var _iteratorError3 = void 0;
          try {
            for (var _iterator3 = input[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
              var _currentValue = _step3.value;
              if (_currentValue < n2 && ++delta > maxInt) {
                error$1("overflow");
              }
              if (_currentValue == n2) {
                var q = delta;
                for (
                  var k = base;
                  ;
                  /* no condition */
                  k += base
                ) {
                  var t2 = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                  if (q < t2) {
                    break;
                  }
                  var qMinusT = q - t2;
                  var baseMinusT = base - t2;
                  output.push(stringFromCharCode(digitToBasic(t2 + qMinusT % baseMinusT, 0)));
                  q = floor(qMinusT / baseMinusT);
                }
                output.push(stringFromCharCode(digitToBasic(q, 0)));
                bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                delta = 0;
                ++handledCPCount;
              }
            }
          } catch (err) {
            _didIteratorError3 = true;
            _iteratorError3 = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion3 && _iterator3.return) {
                _iterator3.return();
              }
            } finally {
              if (_didIteratorError3) {
                throw _iteratorError3;
              }
            }
          }
          ++delta;
          ++n2;
        }
        return output.join("");
      };
      var toUnicode = function toUnicode2(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      };
      var toASCII = function toASCII2(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      };
      var punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "2.1.0",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      var SCHEMES = {};
      function pctEncChar(chr) {
        var c2 = chr.charCodeAt(0);
        var e2 = void 0;
        if (c2 < 16) e2 = "%0" + c2.toString(16).toUpperCase();
        else if (c2 < 128) e2 = "%" + c2.toString(16).toUpperCase();
        else if (c2 < 2048) e2 = "%" + (c2 >> 6 | 192).toString(16).toUpperCase() + "%" + (c2 & 63 | 128).toString(16).toUpperCase();
        else e2 = "%" + (c2 >> 12 | 224).toString(16).toUpperCase() + "%" + (c2 >> 6 & 63 | 128).toString(16).toUpperCase() + "%" + (c2 & 63 | 128).toString(16).toUpperCase();
        return e2;
      }
      function pctDecChars(str) {
        var newStr = "";
        var i2 = 0;
        var il = str.length;
        while (i2 < il) {
          var c2 = parseInt(str.substr(i2 + 1, 2), 16);
          if (c2 < 128) {
            newStr += String.fromCharCode(c2);
            i2 += 3;
          } else if (c2 >= 194 && c2 < 224) {
            if (il - i2 >= 6) {
              var c22 = parseInt(str.substr(i2 + 4, 2), 16);
              newStr += String.fromCharCode((c2 & 31) << 6 | c22 & 63);
            } else {
              newStr += str.substr(i2, 6);
            }
            i2 += 6;
          } else if (c2 >= 224) {
            if (il - i2 >= 9) {
              var _c = parseInt(str.substr(i2 + 4, 2), 16);
              var c3 = parseInt(str.substr(i2 + 7, 2), 16);
              newStr += String.fromCharCode((c2 & 15) << 12 | (_c & 63) << 6 | c3 & 63);
            } else {
              newStr += str.substr(i2, 9);
            }
            i2 += 9;
          } else {
            newStr += str.substr(i2, 3);
            i2 += 3;
          }
        }
        return newStr;
      }
      function _normalizeComponentEncoding(components, protocol) {
        function decodeUnreserved2(str) {
          var decStr = pctDecChars(str);
          return !decStr.match(protocol.UNRESERVED) ? str : decStr;
        }
        if (components.scheme) components.scheme = String(components.scheme).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_SCHEME, "");
        if (components.userinfo !== void 0) components.userinfo = String(components.userinfo).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_USERINFO, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
        if (components.host !== void 0) components.host = String(components.host).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_HOST, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
        if (components.path !== void 0) components.path = String(components.path).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(components.scheme ? protocol.NOT_PATH : protocol.NOT_PATH_NOSCHEME, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
        if (components.query !== void 0) components.query = String(components.query).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_QUERY, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
        if (components.fragment !== void 0) components.fragment = String(components.fragment).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_FRAGMENT, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
        return components;
      }
      function _stripLeadingZeros(str) {
        return str.replace(/^0*(.*)/, "$1") || "0";
      }
      function _normalizeIPv4(host, protocol) {
        var matches = host.match(protocol.IPV4ADDRESS) || [];
        var _matches = slicedToArray(matches, 2), address = _matches[1];
        if (address) {
          return address.split(".").map(_stripLeadingZeros).join(".");
        } else {
          return host;
        }
      }
      function _normalizeIPv6(host, protocol) {
        var matches = host.match(protocol.IPV6ADDRESS) || [];
        var _matches2 = slicedToArray(matches, 3), address = _matches2[1], zone = _matches2[2];
        if (address) {
          var _address$toLowerCase$ = address.toLowerCase().split("::").reverse(), _address$toLowerCase$2 = slicedToArray(_address$toLowerCase$, 2), last = _address$toLowerCase$2[0], first = _address$toLowerCase$2[1];
          var firstFields = first ? first.split(":").map(_stripLeadingZeros) : [];
          var lastFields = last.split(":").map(_stripLeadingZeros);
          var isLastFieldIPv4Address = protocol.IPV4ADDRESS.test(lastFields[lastFields.length - 1]);
          var fieldCount = isLastFieldIPv4Address ? 7 : 8;
          var lastFieldsStart = lastFields.length - fieldCount;
          var fields = Array(fieldCount);
          for (var x2 = 0; x2 < fieldCount; ++x2) {
            fields[x2] = firstFields[x2] || lastFields[lastFieldsStart + x2] || "";
          }
          if (isLastFieldIPv4Address) {
            fields[fieldCount - 1] = _normalizeIPv4(fields[fieldCount - 1], protocol);
          }
          var allZeroFields = fields.reduce(function(acc, field, index) {
            if (!field || field === "0") {
              var lastLongest = acc[acc.length - 1];
              if (lastLongest && lastLongest.index + lastLongest.length === index) {
                lastLongest.length++;
              } else {
                acc.push({ index, length: 1 });
              }
            }
            return acc;
          }, []);
          var longestZeroFields = allZeroFields.sort(function(a2, b) {
            return b.length - a2.length;
          })[0];
          var newHost = void 0;
          if (longestZeroFields && longestZeroFields.length > 1) {
            var newFirst = fields.slice(0, longestZeroFields.index);
            var newLast = fields.slice(longestZeroFields.index + longestZeroFields.length);
            newHost = newFirst.join(":") + "::" + newLast.join(":");
          } else {
            newHost = fields.join(":");
          }
          if (zone) {
            newHost += "%" + zone;
          }
          return newHost;
        } else {
          return host;
        }
      }
      var URI_PARSE = /^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i;
      var NO_MATCH_IS_UNDEFINED = "".match(/(){0}/)[1] === void 0;
      function parse(uriString) {
        var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var components = {};
        var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
        if (options.reference === "suffix") uriString = (options.scheme ? options.scheme + ":" : "") + "//" + uriString;
        var matches = uriString.match(URI_PARSE);
        if (matches) {
          if (NO_MATCH_IS_UNDEFINED) {
            components.scheme = matches[1];
            components.userinfo = matches[3];
            components.host = matches[4];
            components.port = parseInt(matches[5], 10);
            components.path = matches[6] || "";
            components.query = matches[7];
            components.fragment = matches[8];
            if (isNaN(components.port)) {
              components.port = matches[5];
            }
          } else {
            components.scheme = matches[1] || void 0;
            components.userinfo = uriString.indexOf("@") !== -1 ? matches[3] : void 0;
            components.host = uriString.indexOf("//") !== -1 ? matches[4] : void 0;
            components.port = parseInt(matches[5], 10);
            components.path = matches[6] || "";
            components.query = uriString.indexOf("?") !== -1 ? matches[7] : void 0;
            components.fragment = uriString.indexOf("#") !== -1 ? matches[8] : void 0;
            if (isNaN(components.port)) {
              components.port = uriString.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/) ? matches[4] : void 0;
            }
          }
          if (components.host) {
            components.host = _normalizeIPv6(_normalizeIPv4(components.host, protocol), protocol);
          }
          if (components.scheme === void 0 && components.userinfo === void 0 && components.host === void 0 && components.port === void 0 && !components.path && components.query === void 0) {
            components.reference = "same-document";
          } else if (components.scheme === void 0) {
            components.reference = "relative";
          } else if (components.fragment === void 0) {
            components.reference = "absolute";
          } else {
            components.reference = "uri";
          }
          if (options.reference && options.reference !== "suffix" && options.reference !== components.reference) {
            components.error = components.error || "URI is not a " + options.reference + " reference.";
          }
          var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
          if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
            if (components.host && (options.domainHost || schemeHandler && schemeHandler.domainHost)) {
              try {
                components.host = punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase());
              } catch (e2) {
                components.error = components.error || "Host's domain name can not be converted to ASCII via punycode: " + e2;
              }
            }
            _normalizeComponentEncoding(components, URI_PROTOCOL);
          } else {
            _normalizeComponentEncoding(components, protocol);
          }
          if (schemeHandler && schemeHandler.parse) {
            schemeHandler.parse(components, options);
          }
        } else {
          components.error = components.error || "URI can not be parsed.";
        }
        return components;
      }
      function _recomposeAuthority(components, options) {
        var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
        var uriTokens = [];
        if (components.userinfo !== void 0) {
          uriTokens.push(components.userinfo);
          uriTokens.push("@");
        }
        if (components.host !== void 0) {
          uriTokens.push(_normalizeIPv6(_normalizeIPv4(String(components.host), protocol), protocol).replace(protocol.IPV6ADDRESS, function(_, $1, $2) {
            return "[" + $1 + ($2 ? "%25" + $2 : "") + "]";
          }));
        }
        if (typeof components.port === "number" || typeof components.port === "string") {
          uriTokens.push(":");
          uriTokens.push(String(components.port));
        }
        return uriTokens.length ? uriTokens.join("") : void 0;
      }
      var RDS1 = /^\.\.?\//;
      var RDS2 = /^\/\.(\/|$)/;
      var RDS3 = /^\/\.\.(\/|$)/;
      var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/;
      function removeDotSegments(input) {
        var output = [];
        while (input.length) {
          if (input.match(RDS1)) {
            input = input.replace(RDS1, "");
          } else if (input.match(RDS2)) {
            input = input.replace(RDS2, "/");
          } else if (input.match(RDS3)) {
            input = input.replace(RDS3, "/");
            output.pop();
          } else if (input === "." || input === "..") {
            input = "";
          } else {
            var im = input.match(RDS5);
            if (im) {
              var s2 = im[0];
              input = input.slice(s2.length);
              output.push(s2);
            } else {
              throw new Error("Unexpected dot segment condition");
            }
          }
        }
        return output.join("");
      }
      function serialize(components) {
        var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var protocol = options.iri ? IRI_PROTOCOL : URI_PROTOCOL;
        var uriTokens = [];
        var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
        if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
        if (components.host) {
          if (protocol.IPV6ADDRESS.test(components.host)) ;
          else if (options.domainHost || schemeHandler && schemeHandler.domainHost) {
            try {
              components.host = !options.iri ? punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase()) : punycode.toUnicode(components.host);
            } catch (e2) {
              components.error = components.error || "Host's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e2;
            }
          }
        }
        _normalizeComponentEncoding(components, protocol);
        if (options.reference !== "suffix" && components.scheme) {
          uriTokens.push(components.scheme);
          uriTokens.push(":");
        }
        var authority = _recomposeAuthority(components, options);
        if (authority !== void 0) {
          if (options.reference !== "suffix") {
            uriTokens.push("//");
          }
          uriTokens.push(authority);
          if (components.path && components.path.charAt(0) !== "/") {
            uriTokens.push("/");
          }
        }
        if (components.path !== void 0) {
          var s2 = components.path;
          if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
            s2 = removeDotSegments(s2);
          }
          if (authority === void 0) {
            s2 = s2.replace(/^\/\//, "/%2F");
          }
          uriTokens.push(s2);
        }
        if (components.query !== void 0) {
          uriTokens.push("?");
          uriTokens.push(components.query);
        }
        if (components.fragment !== void 0) {
          uriTokens.push("#");
          uriTokens.push(components.fragment);
        }
        return uriTokens.join("");
      }
      function resolveComponents(base2, relative2) {
        var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        var skipNormalization = arguments[3];
        var target = {};
        if (!skipNormalization) {
          base2 = parse(serialize(base2, options), options);
          relative2 = parse(serialize(relative2, options), options);
        }
        options = options || {};
        if (!options.tolerant && relative2.scheme) {
          target.scheme = relative2.scheme;
          target.userinfo = relative2.userinfo;
          target.host = relative2.host;
          target.port = relative2.port;
          target.path = removeDotSegments(relative2.path || "");
          target.query = relative2.query;
        } else {
          if (relative2.userinfo !== void 0 || relative2.host !== void 0 || relative2.port !== void 0) {
            target.userinfo = relative2.userinfo;
            target.host = relative2.host;
            target.port = relative2.port;
            target.path = removeDotSegments(relative2.path || "");
            target.query = relative2.query;
          } else {
            if (!relative2.path) {
              target.path = base2.path;
              if (relative2.query !== void 0) {
                target.query = relative2.query;
              } else {
                target.query = base2.query;
              }
            } else {
              if (relative2.path.charAt(0) === "/") {
                target.path = removeDotSegments(relative2.path);
              } else {
                if ((base2.userinfo !== void 0 || base2.host !== void 0 || base2.port !== void 0) && !base2.path) {
                  target.path = "/" + relative2.path;
                } else if (!base2.path) {
                  target.path = relative2.path;
                } else {
                  target.path = base2.path.slice(0, base2.path.lastIndexOf("/") + 1) + relative2.path;
                }
                target.path = removeDotSegments(target.path);
              }
              target.query = relative2.query;
            }
            target.userinfo = base2.userinfo;
            target.host = base2.host;
            target.port = base2.port;
          }
          target.scheme = base2.scheme;
        }
        target.fragment = relative2.fragment;
        return target;
      }
      function resolve2(baseURI, relativeURI, options) {
        var schemelessOptions = assign({ scheme: "null" }, options);
        return serialize(resolveComponents(parse(baseURI, schemelessOptions), parse(relativeURI, schemelessOptions), schemelessOptions, true), schemelessOptions);
      }
      function normalize2(uri, options) {
        if (typeof uri === "string") {
          uri = serialize(parse(uri, options), options);
        } else if (typeOf(uri) === "object") {
          uri = parse(serialize(uri, options), options);
        }
        return uri;
      }
      function equal(uriA, uriB, options) {
        if (typeof uriA === "string") {
          uriA = serialize(parse(uriA, options), options);
        } else if (typeOf(uriA) === "object") {
          uriA = serialize(uriA, options);
        }
        if (typeof uriB === "string") {
          uriB = serialize(parse(uriB, options), options);
        } else if (typeOf(uriB) === "object") {
          uriB = serialize(uriB, options);
        }
        return uriA === uriB;
      }
      function escapeComponent(str, options) {
        return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.ESCAPE : IRI_PROTOCOL.ESCAPE, pctEncChar);
      }
      function unescapeComponent(str, options) {
        return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.PCT_ENCODED : IRI_PROTOCOL.PCT_ENCODED, pctDecChars);
      }
      var handler = {
        scheme: "http",
        domainHost: true,
        parse: function parse2(components, options) {
          if (!components.host) {
            components.error = components.error || "HTTP URIs must have a host.";
          }
          return components;
        },
        serialize: function serialize2(components, options) {
          var secure = String(components.scheme).toLowerCase() === "https";
          if (components.port === (secure ? 443 : 80) || components.port === "") {
            components.port = void 0;
          }
          if (!components.path) {
            components.path = "/";
          }
          return components;
        }
      };
      var handler$1 = {
        scheme: "https",
        domainHost: handler.domainHost,
        parse: handler.parse,
        serialize: handler.serialize
      };
      function isSecure(wsComponents) {
        return typeof wsComponents.secure === "boolean" ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
      }
      var handler$2 = {
        scheme: "ws",
        domainHost: true,
        parse: function parse2(components, options) {
          var wsComponents = components;
          wsComponents.secure = isSecure(wsComponents);
          wsComponents.resourceName = (wsComponents.path || "/") + (wsComponents.query ? "?" + wsComponents.query : "");
          wsComponents.path = void 0;
          wsComponents.query = void 0;
          return wsComponents;
        },
        serialize: function serialize2(wsComponents, options) {
          if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
            wsComponents.port = void 0;
          }
          if (typeof wsComponents.secure === "boolean") {
            wsComponents.scheme = wsComponents.secure ? "wss" : "ws";
            wsComponents.secure = void 0;
          }
          if (wsComponents.resourceName) {
            var _wsComponents$resourc = wsComponents.resourceName.split("?"), _wsComponents$resourc2 = slicedToArray(_wsComponents$resourc, 2), path = _wsComponents$resourc2[0], query = _wsComponents$resourc2[1];
            wsComponents.path = path && path !== "/" ? path : void 0;
            wsComponents.query = query;
            wsComponents.resourceName = void 0;
          }
          wsComponents.fragment = void 0;
          return wsComponents;
        }
      };
      var handler$3 = {
        scheme: "wss",
        domainHost: handler$2.domainHost,
        parse: handler$2.parse,
        serialize: handler$2.serialize
      };
      var O = {};
      var UNRESERVED$$ = "[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]";
      var HEXDIG$$ = "[0-9A-Fa-f]";
      var PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$));
      var ATEXT$$ = "[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]";
      var QTEXT$$ = "[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]";
      var VCHAR$$ = merge(QTEXT$$, '[\\"\\\\]');
      var SOME_DELIMS$$ = "[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]";
      var UNRESERVED = new RegExp(UNRESERVED$$, "g");
      var PCT_ENCODED = new RegExp(PCT_ENCODED$, "g");
      var NOT_LOCAL_PART = new RegExp(merge("[^]", ATEXT$$, "[\\.]", '[\\"]', VCHAR$$), "g");
      var NOT_HFNAME = new RegExp(merge("[^]", UNRESERVED$$, SOME_DELIMS$$), "g");
      var NOT_HFVALUE = NOT_HFNAME;
      function decodeUnreserved(str) {
        var decStr = pctDecChars(str);
        return !decStr.match(UNRESERVED) ? str : decStr;
      }
      var handler$4 = {
        scheme: "mailto",
        parse: function parse$$1(components, options) {
          var mailtoComponents = components;
          var to = mailtoComponents.to = mailtoComponents.path ? mailtoComponents.path.split(",") : [];
          mailtoComponents.path = void 0;
          if (mailtoComponents.query) {
            var unknownHeaders = false;
            var headers = {};
            var hfields = mailtoComponents.query.split("&");
            for (var x2 = 0, xl = hfields.length; x2 < xl; ++x2) {
              var hfield = hfields[x2].split("=");
              switch (hfield[0]) {
                case "to":
                  var toAddrs = hfield[1].split(",");
                  for (var _x = 0, _xl = toAddrs.length; _x < _xl; ++_x) {
                    to.push(toAddrs[_x]);
                  }
                  break;
                case "subject":
                  mailtoComponents.subject = unescapeComponent(hfield[1], options);
                  break;
                case "body":
                  mailtoComponents.body = unescapeComponent(hfield[1], options);
                  break;
                default:
                  unknownHeaders = true;
                  headers[unescapeComponent(hfield[0], options)] = unescapeComponent(hfield[1], options);
                  break;
              }
            }
            if (unknownHeaders) mailtoComponents.headers = headers;
          }
          mailtoComponents.query = void 0;
          for (var _x2 = 0, _xl2 = to.length; _x2 < _xl2; ++_x2) {
            var addr = to[_x2].split("@");
            addr[0] = unescapeComponent(addr[0]);
            if (!options.unicodeSupport) {
              try {
                addr[1] = punycode.toASCII(unescapeComponent(addr[1], options).toLowerCase());
              } catch (e2) {
                mailtoComponents.error = mailtoComponents.error || "Email address's domain name can not be converted to ASCII via punycode: " + e2;
              }
            } else {
              addr[1] = unescapeComponent(addr[1], options).toLowerCase();
            }
            to[_x2] = addr.join("@");
          }
          return mailtoComponents;
        },
        serialize: function serialize$$1(mailtoComponents, options) {
          var components = mailtoComponents;
          var to = toArray(mailtoComponents.to);
          if (to) {
            for (var x2 = 0, xl = to.length; x2 < xl; ++x2) {
              var toAddr = String(to[x2]);
              var atIdx = toAddr.lastIndexOf("@");
              var localPart = toAddr.slice(0, atIdx).replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_LOCAL_PART, pctEncChar);
              var domain = toAddr.slice(atIdx + 1);
              try {
                domain = !options.iri ? punycode.toASCII(unescapeComponent(domain, options).toLowerCase()) : punycode.toUnicode(domain);
              } catch (e2) {
                components.error = components.error || "Email address's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e2;
              }
              to[x2] = localPart + "@" + domain;
            }
            components.path = to.join(",");
          }
          var headers = mailtoComponents.headers = mailtoComponents.headers || {};
          if (mailtoComponents.subject) headers["subject"] = mailtoComponents.subject;
          if (mailtoComponents.body) headers["body"] = mailtoComponents.body;
          var fields = [];
          for (var name in headers) {
            if (headers[name] !== O[name]) {
              fields.push(name.replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFNAME, pctEncChar) + "=" + headers[name].replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFVALUE, pctEncChar));
            }
          }
          if (fields.length) {
            components.query = fields.join("&");
          }
          return components;
        }
      };
      var URN_PARSE = /^([^\:]+)\:(.*)/;
      var handler$5 = {
        scheme: "urn",
        parse: function parse$$1(components, options) {
          var matches = components.path && components.path.match(URN_PARSE);
          var urnComponents = components;
          if (matches) {
            var scheme = options.scheme || urnComponents.scheme || "urn";
            var nid = matches[1].toLowerCase();
            var nss = matches[2];
            var urnScheme = scheme + ":" + (options.nid || nid);
            var schemeHandler = SCHEMES[urnScheme];
            urnComponents.nid = nid;
            urnComponents.nss = nss;
            urnComponents.path = void 0;
            if (schemeHandler) {
              urnComponents = schemeHandler.parse(urnComponents, options);
            }
          } else {
            urnComponents.error = urnComponents.error || "URN can not be parsed.";
          }
          return urnComponents;
        },
        serialize: function serialize$$1(urnComponents, options) {
          var scheme = options.scheme || urnComponents.scheme || "urn";
          var nid = urnComponents.nid;
          var urnScheme = scheme + ":" + (options.nid || nid);
          var schemeHandler = SCHEMES[urnScheme];
          if (schemeHandler) {
            urnComponents = schemeHandler.serialize(urnComponents, options);
          }
          var uriComponents = urnComponents;
          var nss = urnComponents.nss;
          uriComponents.path = (nid || options.nid) + ":" + nss;
          return uriComponents;
        }
      };
      var UUID = /^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/;
      var handler$6 = {
        scheme: "urn:uuid",
        parse: function parse2(urnComponents, options) {
          var uuidComponents = urnComponents;
          uuidComponents.uuid = uuidComponents.nss;
          uuidComponents.nss = void 0;
          if (!options.tolerant && (!uuidComponents.uuid || !uuidComponents.uuid.match(UUID))) {
            uuidComponents.error = uuidComponents.error || "UUID is not valid.";
          }
          return uuidComponents;
        },
        serialize: function serialize2(uuidComponents, options) {
          var urnComponents = uuidComponents;
          urnComponents.nss = (uuidComponents.uuid || "").toLowerCase();
          return urnComponents;
        }
      };
      SCHEMES[handler.scheme] = handler;
      SCHEMES[handler$1.scheme] = handler$1;
      SCHEMES[handler$2.scheme] = handler$2;
      SCHEMES[handler$3.scheme] = handler$3;
      SCHEMES[handler$4.scheme] = handler$4;
      SCHEMES[handler$5.scheme] = handler$5;
      SCHEMES[handler$6.scheme] = handler$6;
      exports2.SCHEMES = SCHEMES;
      exports2.pctEncChar = pctEncChar;
      exports2.pctDecChars = pctDecChars;
      exports2.parse = parse;
      exports2.removeDotSegments = removeDotSegments;
      exports2.serialize = serialize;
      exports2.resolveComponents = resolveComponents;
      exports2.resolve = resolve2;
      exports2.normalize = normalize2;
      exports2.equal = equal;
      exports2.escapeComponent = escapeComponent;
      exports2.unescapeComponent = unescapeComponent;
      Object.defineProperty(exports2, "__esModule", { value: true });
    }));
  })(uri_all, uri_all.exports);
  return uri_all.exports;
}
var fastDeepEqual;
var hasRequiredFastDeepEqual;
function requireFastDeepEqual() {
  if (hasRequiredFastDeepEqual) return fastDeepEqual;
  hasRequiredFastDeepEqual = 1;
  fastDeepEqual = function equal(a2, b) {
    if (a2 === b) return true;
    if (a2 && b && typeof a2 == "object" && typeof b == "object") {
      if (a2.constructor !== b.constructor) return false;
      var length, i2, keys;
      if (Array.isArray(a2)) {
        length = a2.length;
        if (length != b.length) return false;
        for (i2 = length; i2-- !== 0; )
          if (!equal(a2[i2], b[i2])) return false;
        return true;
      }
      if (a2.constructor === RegExp) return a2.source === b.source && a2.flags === b.flags;
      if (a2.valueOf !== Object.prototype.valueOf) return a2.valueOf() === b.valueOf();
      if (a2.toString !== Object.prototype.toString) return a2.toString() === b.toString();
      keys = Object.keys(a2);
      length = keys.length;
      if (length !== Object.keys(b).length) return false;
      for (i2 = length; i2-- !== 0; )
        if (!Object.prototype.hasOwnProperty.call(b, keys[i2])) return false;
      for (i2 = length; i2-- !== 0; ) {
        var key = keys[i2];
        if (!equal(a2[key], b[key])) return false;
      }
      return true;
    }
    return a2 !== a2 && b !== b;
  };
  return fastDeepEqual;
}
var ucs2length;
var hasRequiredUcs2length;
function requireUcs2length() {
  if (hasRequiredUcs2length) return ucs2length;
  hasRequiredUcs2length = 1;
  ucs2length = function ucs2length2(str) {
    var length = 0, len = str.length, pos = 0, value;
    while (pos < len) {
      length++;
      value = str.charCodeAt(pos++);
      if (value >= 55296 && value <= 56319 && pos < len) {
        value = str.charCodeAt(pos);
        if ((value & 64512) == 56320) pos++;
      }
    }
    return length;
  };
  return ucs2length;
}
var util;
var hasRequiredUtil;
function requireUtil() {
  if (hasRequiredUtil) return util;
  hasRequiredUtil = 1;
  util = {
    copy,
    checkDataType,
    checkDataTypes,
    coerceToTypes,
    toHash,
    getProperty,
    escapeQuotes,
    equal: requireFastDeepEqual(),
    ucs2length: requireUcs2length(),
    varOccurences,
    varReplace,
    schemaHasRules,
    schemaHasRulesExcept,
    schemaUnknownRules,
    toQuotedString,
    getPathExpr,
    getPath,
    getData,
    unescapeFragment,
    unescapeJsonPointer,
    escapeFragment,
    escapeJsonPointer
  };
  function copy(o2, to) {
    to = to || {};
    for (var key in o2) to[key] = o2[key];
    return to;
  }
  function checkDataType(dataType, data2, strictNumbers, negate) {
    var EQUAL = negate ? " !== " : " === ", AND = negate ? " || " : " && ", OK = negate ? "!" : "", NOT = negate ? "" : "!";
    switch (dataType) {
      case "null":
        return data2 + EQUAL + "null";
      case "array":
        return OK + "Array.isArray(" + data2 + ")";
      case "object":
        return "(" + OK + data2 + AND + "typeof " + data2 + EQUAL + '"object"' + AND + NOT + "Array.isArray(" + data2 + "))";
      case "integer":
        return "(typeof " + data2 + EQUAL + '"number"' + AND + NOT + "(" + data2 + " % 1)" + AND + data2 + EQUAL + data2 + (strictNumbers ? AND + OK + "isFinite(" + data2 + ")" : "") + ")";
      case "number":
        return "(typeof " + data2 + EQUAL + '"' + dataType + '"' + (strictNumbers ? AND + OK + "isFinite(" + data2 + ")" : "") + ")";
      default:
        return "typeof " + data2 + EQUAL + '"' + dataType + '"';
    }
  }
  function checkDataTypes(dataTypes, data2, strictNumbers) {
    switch (dataTypes.length) {
      case 1:
        return checkDataType(dataTypes[0], data2, strictNumbers, true);
      default:
        var code2 = "";
        var types = toHash(dataTypes);
        if (types.array && types.object) {
          code2 = types.null ? "(" : "(!" + data2 + " || ";
          code2 += "typeof " + data2 + ' !== "object")';
          delete types.null;
          delete types.array;
          delete types.object;
        }
        if (types.number) delete types.integer;
        for (var t2 in types)
          code2 += (code2 ? " && " : "") + checkDataType(t2, data2, strictNumbers, true);
        return code2;
    }
  }
  var COERCE_TO_TYPES = toHash(["string", "number", "integer", "boolean", "null"]);
  function coerceToTypes(optionCoerceTypes, dataTypes) {
    if (Array.isArray(dataTypes)) {
      var types = [];
      for (var i2 = 0; i2 < dataTypes.length; i2++) {
        var t2 = dataTypes[i2];
        if (COERCE_TO_TYPES[t2]) types[types.length] = t2;
        else if (optionCoerceTypes === "array" && t2 === "array") types[types.length] = t2;
      }
      if (types.length) return types;
    } else if (COERCE_TO_TYPES[dataTypes]) {
      return [dataTypes];
    } else if (optionCoerceTypes === "array" && dataTypes === "array") {
      return ["array"];
    }
  }
  function toHash(arr) {
    var hash = {};
    for (var i2 = 0; i2 < arr.length; i2++) hash[arr[i2]] = true;
    return hash;
  }
  var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
  var SINGLE_QUOTE = /'|\\/g;
  function getProperty(key) {
    return typeof key == "number" ? "[" + key + "]" : IDENTIFIER.test(key) ? "." + key : "['" + escapeQuotes(key) + "']";
  }
  function escapeQuotes(str) {
    return str.replace(SINGLE_QUOTE, "\\$&").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\f/g, "\\f").replace(/\t/g, "\\t");
  }
  function varOccurences(str, dataVar) {
    dataVar += "[^0-9]";
    var matches = str.match(new RegExp(dataVar, "g"));
    return matches ? matches.length : 0;
  }
  function varReplace(str, dataVar, expr) {
    dataVar += "([^0-9])";
    expr = expr.replace(/\$/g, "$$$$");
    return str.replace(new RegExp(dataVar, "g"), expr + "$1");
  }
  function schemaHasRules(schema, rules2) {
    if (typeof schema == "boolean") return !schema;
    for (var key in schema) if (rules2[key]) return true;
  }
  function schemaHasRulesExcept(schema, rules2, exceptKeyword) {
    if (typeof schema == "boolean") return !schema && exceptKeyword != "not";
    for (var key in schema) if (key != exceptKeyword && rules2[key]) return true;
  }
  function schemaUnknownRules(schema, rules2) {
    if (typeof schema == "boolean") return;
    for (var key in schema) if (!rules2[key]) return key;
  }
  function toQuotedString(str) {
    return "'" + escapeQuotes(str) + "'";
  }
  function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
    var path = jsonPointers ? "'/' + " + expr + (isNumber ? "" : ".replace(/~/g, '~0').replace(/\\//g, '~1')") : isNumber ? "'[' + " + expr + " + ']'" : "'[\\'' + " + expr + " + '\\']'";
    return joinPaths(currentPath, path);
  }
  function getPath(currentPath, prop, jsonPointers) {
    var path = jsonPointers ? toQuotedString("/" + escapeJsonPointer(prop)) : toQuotedString(getProperty(prop));
    return joinPaths(currentPath, path);
  }
  var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
  var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
  function getData($data, lvl, paths) {
    var up, jsonPointer, data2, matches;
    if ($data === "") return "rootData";
    if ($data[0] == "/") {
      if (!JSON_POINTER.test($data)) throw new Error("Invalid JSON-pointer: " + $data);
      jsonPointer = $data;
      data2 = "rootData";
    } else {
      matches = $data.match(RELATIVE_JSON_POINTER);
      if (!matches) throw new Error("Invalid JSON-pointer: " + $data);
      up = +matches[1];
      jsonPointer = matches[2];
      if (jsonPointer == "#") {
        if (up >= lvl) throw new Error("Cannot access property/index " + up + " levels up, current level is " + lvl);
        return paths[lvl - up];
      }
      if (up > lvl) throw new Error("Cannot access data " + up + " levels up, current level is " + lvl);
      data2 = "data" + (lvl - up || "");
      if (!jsonPointer) return data2;
    }
    var expr = data2;
    var segments = jsonPointer.split("/");
    for (var i2 = 0; i2 < segments.length; i2++) {
      var segment = segments[i2];
      if (segment) {
        data2 += getProperty(unescapeJsonPointer(segment));
        expr += " && " + data2;
      }
    }
    return expr;
  }
  function joinPaths(a2, b) {
    if (a2 == '""') return b;
    return (a2 + " + " + b).replace(/([^\\])' \+ '/g, "$1");
  }
  function unescapeFragment(str) {
    return unescapeJsonPointer(decodeURIComponent(str));
  }
  function escapeFragment(str) {
    return encodeURIComponent(escapeJsonPointer(str));
  }
  function escapeJsonPointer(str) {
    return str.replace(/~/g, "~0").replace(/\//g, "~1");
  }
  function unescapeJsonPointer(str) {
    return str.replace(/~1/g, "/").replace(/~0/g, "~");
  }
  return util;
}
var schema_obj;
var hasRequiredSchema_obj;
function requireSchema_obj() {
  if (hasRequiredSchema_obj) return schema_obj;
  hasRequiredSchema_obj = 1;
  var util2 = requireUtil();
  schema_obj = SchemaObject;
  function SchemaObject(obj) {
    util2.copy(obj, this);
  }
  return schema_obj;
}
var jsonSchemaTraverse = { exports: {} };
var hasRequiredJsonSchemaTraverse;
function requireJsonSchemaTraverse() {
  if (hasRequiredJsonSchemaTraverse) return jsonSchemaTraverse.exports;
  hasRequiredJsonSchemaTraverse = 1;
  var traverse = jsonSchemaTraverse.exports = function(schema, opts, cb) {
    if (typeof opts == "function") {
      cb = opts;
      opts = {};
    }
    cb = opts.cb || cb;
    var pre = typeof cb == "function" ? cb : cb.pre || function() {
    };
    var post = cb.post || function() {
    };
    _traverse(opts, pre, post, schema, "", schema);
  };
  traverse.keywords = {
    additionalItems: true,
    items: true,
    contains: true,
    additionalProperties: true,
    propertyNames: true,
    not: true
  };
  traverse.arrayKeywords = {
    items: true,
    allOf: true,
    anyOf: true,
    oneOf: true
  };
  traverse.propsKeywords = {
    definitions: true,
    properties: true,
    patternProperties: true,
    dependencies: true
  };
  traverse.skipKeywords = {
    default: true,
    enum: true,
    const: true,
    required: true,
    maximum: true,
    minimum: true,
    exclusiveMaximum: true,
    exclusiveMinimum: true,
    multipleOf: true,
    maxLength: true,
    minLength: true,
    pattern: true,
    format: true,
    maxItems: true,
    minItems: true,
    uniqueItems: true,
    maxProperties: true,
    minProperties: true
  };
  function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
    if (schema && typeof schema == "object" && !Array.isArray(schema)) {
      pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
      for (var key in schema) {
        var sch = schema[key];
        if (Array.isArray(sch)) {
          if (key in traverse.arrayKeywords) {
            for (var i2 = 0; i2 < sch.length; i2++)
              _traverse(opts, pre, post, sch[i2], jsonPtr + "/" + key + "/" + i2, rootSchema, jsonPtr, key, schema, i2);
          }
        } else if (key in traverse.propsKeywords) {
          if (sch && typeof sch == "object") {
            for (var prop in sch)
              _traverse(opts, pre, post, sch[prop], jsonPtr + "/" + key + "/" + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
          }
        } else if (key in traverse.keywords || opts.allKeys && !(key in traverse.skipKeywords)) {
          _traverse(opts, pre, post, sch, jsonPtr + "/" + key, rootSchema, jsonPtr, key, schema);
        }
      }
      post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
    }
  }
  function escapeJsonPtr(str) {
    return str.replace(/~/g, "~0").replace(/\//g, "~1");
  }
  return jsonSchemaTraverse.exports;
}
var resolve_1;
var hasRequiredResolve;
function requireResolve() {
  if (hasRequiredResolve) return resolve_1;
  hasRequiredResolve = 1;
  var URI = requireUri_all(), equal = requireFastDeepEqual(), util2 = requireUtil(), SchemaObject = requireSchema_obj(), traverse = requireJsonSchemaTraverse();
  resolve_1 = resolve2;
  resolve2.normalizeId = normalizeId;
  resolve2.fullPath = getFullPath;
  resolve2.url = resolveUrl;
  resolve2.ids = resolveIds;
  resolve2.inlineRef = inlineRef;
  resolve2.schema = resolveSchema;
  function resolve2(compile, root, ref2) {
    var refVal = this._refs[ref2];
    if (typeof refVal == "string") {
      if (this._refs[refVal]) refVal = this._refs[refVal];
      else return resolve2.call(this, compile, root, refVal);
    }
    refVal = refVal || this._schemas[ref2];
    if (refVal instanceof SchemaObject) {
      return inlineRef(refVal.schema, this._opts.inlineRefs) ? refVal.schema : refVal.validate || this._compile(refVal);
    }
    var res = resolveSchema.call(this, root, ref2);
    var schema, v2, baseId;
    if (res) {
      schema = res.schema;
      root = res.root;
      baseId = res.baseId;
    }
    if (schema instanceof SchemaObject) {
      v2 = schema.validate || compile.call(this, schema.schema, root, void 0, baseId);
    } else if (schema !== void 0) {
      v2 = inlineRef(schema, this._opts.inlineRefs) ? schema : compile.call(this, schema, root, void 0, baseId);
    }
    return v2;
  }
  function resolveSchema(root, ref2) {
    var p2 = URI.parse(ref2), refPath = _getFullPath(p2), baseId = getFullPath(this._getId(root.schema));
    if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
      var id2 = normalizeId(refPath);
      var refVal = this._refs[id2];
      if (typeof refVal == "string") {
        return resolveRecursive.call(this, root, refVal, p2);
      } else if (refVal instanceof SchemaObject) {
        if (!refVal.validate) this._compile(refVal);
        root = refVal;
      } else {
        refVal = this._schemas[id2];
        if (refVal instanceof SchemaObject) {
          if (!refVal.validate) this._compile(refVal);
          if (id2 == normalizeId(ref2))
            return { schema: refVal, root, baseId };
          root = refVal;
        } else {
          return;
        }
      }
      if (!root.schema) return;
      baseId = getFullPath(this._getId(root.schema));
    }
    return getJsonPointer.call(this, p2, baseId, root.schema, root);
  }
  function resolveRecursive(root, ref2, parsedRef) {
    var res = resolveSchema.call(this, root, ref2);
    if (res) {
      var schema = res.schema;
      var baseId = res.baseId;
      root = res.root;
      var id2 = this._getId(schema);
      if (id2) baseId = resolveUrl(baseId, id2);
      return getJsonPointer.call(this, parsedRef, baseId, schema, root);
    }
  }
  var PREVENT_SCOPE_CHANGE = util2.toHash(["properties", "patternProperties", "enum", "dependencies", "definitions"]);
  function getJsonPointer(parsedRef, baseId, schema, root) {
    parsedRef.fragment = parsedRef.fragment || "";
    if (parsedRef.fragment.slice(0, 1) != "/") return;
    var parts = parsedRef.fragment.split("/");
    for (var i2 = 1; i2 < parts.length; i2++) {
      var part = parts[i2];
      if (part) {
        part = util2.unescapeFragment(part);
        schema = schema[part];
        if (schema === void 0) break;
        var id2;
        if (!PREVENT_SCOPE_CHANGE[part]) {
          id2 = this._getId(schema);
          if (id2) baseId = resolveUrl(baseId, id2);
          if (schema.$ref) {
            var $ref = resolveUrl(baseId, schema.$ref);
            var res = resolveSchema.call(this, root, $ref);
            if (res) {
              schema = res.schema;
              root = res.root;
              baseId = res.baseId;
            }
          }
        }
      }
    }
    if (schema !== void 0 && schema !== root.schema)
      return { schema, root, baseId };
  }
  var SIMPLE_INLINED = util2.toHash([
    "type",
    "format",
    "pattern",
    "maxLength",
    "minLength",
    "maxProperties",
    "minProperties",
    "maxItems",
    "minItems",
    "maximum",
    "minimum",
    "uniqueItems",
    "multipleOf",
    "required",
    "enum"
  ]);
  function inlineRef(schema, limit) {
    if (limit === false) return false;
    if (limit === void 0 || limit === true) return checkNoRef(schema);
    else if (limit) return countKeys(schema) <= limit;
  }
  function checkNoRef(schema) {
    var item;
    if (Array.isArray(schema)) {
      for (var i2 = 0; i2 < schema.length; i2++) {
        item = schema[i2];
        if (typeof item == "object" && !checkNoRef(item)) return false;
      }
    } else {
      for (var key in schema) {
        if (key == "$ref") return false;
        item = schema[key];
        if (typeof item == "object" && !checkNoRef(item)) return false;
      }
    }
    return true;
  }
  function countKeys(schema) {
    var count = 0, item;
    if (Array.isArray(schema)) {
      for (var i2 = 0; i2 < schema.length; i2++) {
        item = schema[i2];
        if (typeof item == "object") count += countKeys(item);
        if (count == Infinity) return Infinity;
      }
    } else {
      for (var key in schema) {
        if (key == "$ref") return Infinity;
        if (SIMPLE_INLINED[key]) {
          count++;
        } else {
          item = schema[key];
          if (typeof item == "object") count += countKeys(item) + 1;
          if (count == Infinity) return Infinity;
        }
      }
    }
    return count;
  }
  function getFullPath(id2, normalize2) {
    if (normalize2 !== false) id2 = normalizeId(id2);
    var p2 = URI.parse(id2);
    return _getFullPath(p2);
  }
  function _getFullPath(p2) {
    return URI.serialize(p2).split("#")[0] + "#";
  }
  var TRAILING_SLASH_HASH = /#\/?$/;
  function normalizeId(id2) {
    return id2 ? id2.replace(TRAILING_SLASH_HASH, "") : "";
  }
  function resolveUrl(baseId, id2) {
    id2 = normalizeId(id2);
    return URI.resolve(baseId, id2);
  }
  function resolveIds(schema) {
    var schemaId = normalizeId(this._getId(schema));
    var baseIds = { "": schemaId };
    var fullPaths = { "": getFullPath(schemaId, false) };
    var localRefs = {};
    var self2 = this;
    traverse(schema, { allKeys: true }, function(sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
      if (jsonPtr === "") return;
      var id2 = self2._getId(sch);
      var baseId = baseIds[parentJsonPtr];
      var fullPath = fullPaths[parentJsonPtr] + "/" + parentKeyword;
      if (keyIndex !== void 0)
        fullPath += "/" + (typeof keyIndex == "number" ? keyIndex : util2.escapeFragment(keyIndex));
      if (typeof id2 == "string") {
        id2 = baseId = normalizeId(baseId ? URI.resolve(baseId, id2) : id2);
        var refVal = self2._refs[id2];
        if (typeof refVal == "string") refVal = self2._refs[refVal];
        if (refVal && refVal.schema) {
          if (!equal(sch, refVal.schema))
            throw new Error('id "' + id2 + '" resolves to more than one schema');
        } else if (id2 != normalizeId(fullPath)) {
          if (id2[0] == "#") {
            if (localRefs[id2] && !equal(sch, localRefs[id2]))
              throw new Error('id "' + id2 + '" resolves to more than one schema');
            localRefs[id2] = sch;
          } else {
            self2._refs[id2] = fullPath;
          }
        }
      }
      baseIds[jsonPtr] = baseId;
      fullPaths[jsonPtr] = fullPath;
    });
    return localRefs;
  }
  return resolve_1;
}
var error_classes;
var hasRequiredError_classes;
function requireError_classes() {
  if (hasRequiredError_classes) return error_classes;
  hasRequiredError_classes = 1;
  var resolve2 = requireResolve();
  error_classes = {
    Validation: errorSubclass(ValidationError),
    MissingRef: errorSubclass(MissingRefError)
  };
  function ValidationError(errors) {
    this.message = "validation failed";
    this.errors = errors;
    this.ajv = this.validation = true;
  }
  MissingRefError.message = function(baseId, ref2) {
    return "can't resolve reference " + ref2 + " from id " + baseId;
  };
  function MissingRefError(baseId, ref2, message) {
    this.message = message || MissingRefError.message(baseId, ref2);
    this.missingRef = resolve2.url(baseId, ref2);
    this.missingSchema = resolve2.normalizeId(resolve2.fullPath(this.missingRef));
  }
  function errorSubclass(Subclass) {
    Subclass.prototype = Object.create(Error.prototype);
    Subclass.prototype.constructor = Subclass;
    return Subclass;
  }
  return error_classes;
}
var fastJsonStableStringify;
var hasRequiredFastJsonStableStringify;
function requireFastJsonStableStringify() {
  if (hasRequiredFastJsonStableStringify) return fastJsonStableStringify;
  hasRequiredFastJsonStableStringify = 1;
  fastJsonStableStringify = function(data2, opts) {
    if (!opts) opts = {};
    if (typeof opts === "function") opts = { cmp: opts };
    var cycles = typeof opts.cycles === "boolean" ? opts.cycles : false;
    var cmp = opts.cmp && /* @__PURE__ */ (function(f2) {
      return function(node2) {
        return function(a2, b) {
          var aobj = { key: a2, value: node2[a2] };
          var bobj = { key: b, value: node2[b] };
          return f2(aobj, bobj);
        };
      };
    })(opts.cmp);
    var seen = [];
    return (function stringify(node2) {
      if (node2 && node2.toJSON && typeof node2.toJSON === "function") {
        node2 = node2.toJSON();
      }
      if (node2 === void 0) return;
      if (typeof node2 == "number") return isFinite(node2) ? "" + node2 : "null";
      if (typeof node2 !== "object") return JSON.stringify(node2);
      var i2, out;
      if (Array.isArray(node2)) {
        out = "[";
        for (i2 = 0; i2 < node2.length; i2++) {
          if (i2) out += ",";
          out += stringify(node2[i2]) || "null";
        }
        return out + "]";
      }
      if (node2 === null) return "null";
      if (seen.indexOf(node2) !== -1) {
        if (cycles) return JSON.stringify("__cycle__");
        throw new TypeError("Converting circular structure to JSON");
      }
      var seenIndex = seen.push(node2) - 1;
      var keys = Object.keys(node2).sort(cmp && cmp(node2));
      out = "";
      for (i2 = 0; i2 < keys.length; i2++) {
        var key = keys[i2];
        var value = stringify(node2[key]);
        if (!value) continue;
        if (out) out += ",";
        out += JSON.stringify(key) + ":" + value;
      }
      seen.splice(seenIndex, 1);
      return "{" + out + "}";
    })(data2);
  };
  return fastJsonStableStringify;
}
var validate;
var hasRequiredValidate;
function requireValidate() {
  if (hasRequiredValidate) return validate;
  hasRequiredValidate = 1;
  validate = function generate_validate(it, $keyword, $ruleType) {
    var out = "";
    var $async = it.schema.$async === true, $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, "$ref"), $id2 = it.self._getId(it.schema);
    if (it.opts.strictKeywords) {
      var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
      if ($unknownKwd) {
        var $keywordsMsg = "unknown keyword: " + $unknownKwd;
        if (it.opts.strictKeywords === "log") it.logger.warn($keywordsMsg);
        else throw new Error($keywordsMsg);
      }
    }
    if (it.isTop) {
      out += " var validate = ";
      if ($async) {
        it.async = true;
        out += "async ";
      }
      out += "function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ";
      if ($id2 && (it.opts.sourceCode || it.opts.processCode)) {
        out += " " + ("/*# sourceURL=" + $id2 + " */") + " ";
      }
    }
    if (typeof it.schema == "boolean" || !($refKeywords || it.schema.$ref)) {
      var $keyword = "false schema";
      var $lvl = it.level;
      var $dataLvl = it.dataLevel;
      var $schema2 = it.schema[$keyword];
      var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
      var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
      var $breakOnError = !it.opts.allErrors;
      var $errorKeyword;
      var $data = "data" + ($dataLvl || "");
      var $valid = "valid" + $lvl;
      if (it.schema === false) {
        if (it.isTop) {
          $breakOnError = true;
        } else {
          out += " var " + $valid + " = false; ";
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = "";
        if (it.createErrors !== false) {
          out += " { keyword: '" + ($errorKeyword || "false schema") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
          if (it.opts.messages !== false) {
            out += " , message: 'boolean schema is false' ";
          }
          if (it.opts.verbose) {
            out += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out += " } ";
        } else {
          out += " {} ";
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out += " throw new ValidationError([" + __err + "]); ";
          } else {
            out += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
      } else {
        if (it.isTop) {
          if ($async) {
            out += " return data; ";
          } else {
            out += " validate.errors = null; return true; ";
          }
        } else {
          out += " var " + $valid + " = true; ";
        }
      }
      if (it.isTop) {
        out += " }; return validate; ";
      }
      return out;
    }
    if (it.isTop) {
      var $top = it.isTop, $lvl = it.level = 0, $dataLvl = it.dataLevel = 0, $data = "data";
      it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
      it.baseId = it.baseId || it.rootId;
      delete it.isTop;
      it.dataPathArr = [""];
      if (it.schema.default !== void 0 && it.opts.useDefaults && it.opts.strictDefaults) {
        var $defaultMsg = "default is ignored in the schema root";
        if (it.opts.strictDefaults === "log") it.logger.warn($defaultMsg);
        else throw new Error($defaultMsg);
      }
      out += " var vErrors = null; ";
      out += " var errors = 0;     ";
      out += " if (rootData === undefined) rootData = data; ";
    } else {
      var $lvl = it.level, $dataLvl = it.dataLevel, $data = "data" + ($dataLvl || "");
      if ($id2) it.baseId = it.resolve.url(it.baseId, $id2);
      if ($async && !it.async) throw new Error("async schema in sync schema");
      out += " var errs_" + $lvl + " = errors;";
    }
    var $valid = "valid" + $lvl, $breakOnError = !it.opts.allErrors, $closingBraces1 = "", $closingBraces2 = "";
    var $errorKeyword;
    var $typeSchema = it.schema.type, $typeIsArray = Array.isArray($typeSchema);
    if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
      if ($typeIsArray) {
        if ($typeSchema.indexOf("null") == -1) $typeSchema = $typeSchema.concat("null");
      } else if ($typeSchema != "null") {
        $typeSchema = [$typeSchema, "null"];
        $typeIsArray = true;
      }
    }
    if ($typeIsArray && $typeSchema.length == 1) {
      $typeSchema = $typeSchema[0];
      $typeIsArray = false;
    }
    if (it.schema.$ref && $refKeywords) {
      if (it.opts.extendRefs == "fail") {
        throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
      } else if (it.opts.extendRefs !== true) {
        $refKeywords = false;
        it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
      }
    }
    if (it.schema.$comment && it.opts.$comment) {
      out += " " + it.RULES.all.$comment.code(it, "$comment");
    }
    if ($typeSchema) {
      if (it.opts.coerceTypes) {
        var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
      }
      var $rulesGroup = it.RULES.types[$typeSchema];
      if ($coerceToTypes || $typeIsArray || $rulesGroup === true || $rulesGroup && !$shouldUseGroup($rulesGroup)) {
        var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type";
        var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type", $method = $typeIsArray ? "checkDataTypes" : "checkDataType";
        out += " if (" + it.util[$method]($typeSchema, $data, it.opts.strictNumbers, true) + ") { ";
        if ($coerceToTypes) {
          var $dataType = "dataType" + $lvl, $coerced = "coerced" + $lvl;
          out += " var " + $dataType + " = typeof " + $data + "; var " + $coerced + " = undefined; ";
          if (it.opts.coerceTypes == "array") {
            out += " if (" + $dataType + " == 'object' && Array.isArray(" + $data + ") && " + $data + ".length == 1) { " + $data + " = " + $data + "[0]; " + $dataType + " = typeof " + $data + "; if (" + it.util.checkDataType(it.schema.type, $data, it.opts.strictNumbers) + ") " + $coerced + " = " + $data + "; } ";
          }
          out += " if (" + $coerced + " !== undefined) ; ";
          var arr1 = $coerceToTypes;
          if (arr1) {
            var $type, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
              $type = arr1[$i += 1];
              if ($type == "string") {
                out += " else if (" + $dataType + " == 'number' || " + $dataType + " == 'boolean') " + $coerced + " = '' + " + $data + "; else if (" + $data + " === null) " + $coerced + " = ''; ";
              } else if ($type == "number" || $type == "integer") {
                out += " else if (" + $dataType + " == 'boolean' || " + $data + " === null || (" + $dataType + " == 'string' && " + $data + " && " + $data + " == +" + $data + " ";
                if ($type == "integer") {
                  out += " && !(" + $data + " % 1)";
                }
                out += ")) " + $coerced + " = +" + $data + "; ";
              } else if ($type == "boolean") {
                out += " else if (" + $data + " === 'false' || " + $data + " === 0 || " + $data + " === null) " + $coerced + " = false; else if (" + $data + " === 'true' || " + $data + " === 1) " + $coerced + " = true; ";
              } else if ($type == "null") {
                out += " else if (" + $data + " === '' || " + $data + " === 0 || " + $data + " === false) " + $coerced + " = null; ";
              } else if (it.opts.coerceTypes == "array" && $type == "array") {
                out += " else if (" + $dataType + " == 'string' || " + $dataType + " == 'number' || " + $dataType + " == 'boolean' || " + $data + " == null) " + $coerced + " = [" + $data + "]; ";
              }
            }
          }
          out += " else {   ";
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
            if ($typeIsArray) {
              out += "" + $typeSchema.join(",");
            } else {
              out += "" + $typeSchema;
            }
            out += "' } ";
            if (it.opts.messages !== false) {
              out += " , message: 'should be ";
              if ($typeIsArray) {
                out += "" + $typeSchema.join(",");
              } else {
                out += "" + $typeSchema;
              }
              out += "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out += " } if (" + $coerced + " !== undefined) {  ";
          var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
          out += " " + $data + " = " + $coerced + "; ";
          if (!$dataLvl) {
            out += "if (" + $parentData + " !== undefined)";
          }
          out += " " + $parentData + "[" + $parentDataProperty + "] = " + $coerced + "; } ";
        } else {
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
            if ($typeIsArray) {
              out += "" + $typeSchema.join(",");
            } else {
              out += "" + $typeSchema;
            }
            out += "' } ";
            if (it.opts.messages !== false) {
              out += " , message: 'should be ";
              if ($typeIsArray) {
                out += "" + $typeSchema.join(",");
              } else {
                out += "" + $typeSchema;
              }
              out += "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
        }
        out += " } ";
      }
    }
    if (it.schema.$ref && !$refKeywords) {
      out += " " + it.RULES.all.$ref.code(it, "$ref") + " ";
      if ($breakOnError) {
        out += " } if (errors === ";
        if ($top) {
          out += "0";
        } else {
          out += "errs_" + $lvl;
        }
        out += ") { ";
        $closingBraces2 += "}";
      }
    } else {
      var arr2 = it.RULES;
      if (arr2) {
        var $rulesGroup, i2 = -1, l2 = arr2.length - 1;
        while (i2 < l2) {
          $rulesGroup = arr2[i2 += 1];
          if ($shouldUseGroup($rulesGroup)) {
            if ($rulesGroup.type) {
              out += " if (" + it.util.checkDataType($rulesGroup.type, $data, it.opts.strictNumbers) + ") { ";
            }
            if (it.opts.useDefaults) {
              if ($rulesGroup.type == "object" && it.schema.properties) {
                var $schema2 = it.schema.properties, $schemaKeys = Object.keys($schema2);
                var arr3 = $schemaKeys;
                if (arr3) {
                  var $propertyKey, i3 = -1, l3 = arr3.length - 1;
                  while (i3 < l3) {
                    $propertyKey = arr3[i3 += 1];
                    var $sch = $schema2[$propertyKey];
                    if ($sch.default !== void 0) {
                      var $passData = $data + it.util.getProperty($propertyKey);
                      if (it.compositeRule) {
                        if (it.opts.strictDefaults) {
                          var $defaultMsg = "default is ignored for: " + $passData;
                          if (it.opts.strictDefaults === "log") it.logger.warn($defaultMsg);
                          else throw new Error($defaultMsg);
                        }
                      } else {
                        out += " if (" + $passData + " === undefined ";
                        if (it.opts.useDefaults == "empty") {
                          out += " || " + $passData + " === null || " + $passData + " === '' ";
                        }
                        out += " ) " + $passData + " = ";
                        if (it.opts.useDefaults == "shared") {
                          out += " " + it.useDefault($sch.default) + " ";
                        } else {
                          out += " " + JSON.stringify($sch.default) + " ";
                        }
                        out += "; ";
                      }
                    }
                  }
                }
              } else if ($rulesGroup.type == "array" && Array.isArray(it.schema.items)) {
                var arr4 = it.schema.items;
                if (arr4) {
                  var $sch, $i = -1, l4 = arr4.length - 1;
                  while ($i < l4) {
                    $sch = arr4[$i += 1];
                    if ($sch.default !== void 0) {
                      var $passData = $data + "[" + $i + "]";
                      if (it.compositeRule) {
                        if (it.opts.strictDefaults) {
                          var $defaultMsg = "default is ignored for: " + $passData;
                          if (it.opts.strictDefaults === "log") it.logger.warn($defaultMsg);
                          else throw new Error($defaultMsg);
                        }
                      } else {
                        out += " if (" + $passData + " === undefined ";
                        if (it.opts.useDefaults == "empty") {
                          out += " || " + $passData + " === null || " + $passData + " === '' ";
                        }
                        out += " ) " + $passData + " = ";
                        if (it.opts.useDefaults == "shared") {
                          out += " " + it.useDefault($sch.default) + " ";
                        } else {
                          out += " " + JSON.stringify($sch.default) + " ";
                        }
                        out += "; ";
                      }
                    }
                  }
                }
              }
            }
            var arr5 = $rulesGroup.rules;
            if (arr5) {
              var $rule, i5 = -1, l5 = arr5.length - 1;
              while (i5 < l5) {
                $rule = arr5[i5 += 1];
                if ($shouldUseRule($rule)) {
                  var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                  if ($code) {
                    out += " " + $code + " ";
                    if ($breakOnError) {
                      $closingBraces1 += "}";
                    }
                  }
                }
              }
            }
            if ($breakOnError) {
              out += " " + $closingBraces1 + " ";
              $closingBraces1 = "";
            }
            if ($rulesGroup.type) {
              out += " } ";
              if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
                out += " else { ";
                var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type";
                var $$outStack = $$outStack || [];
                $$outStack.push(out);
                out = "";
                if (it.createErrors !== false) {
                  out += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
                  if ($typeIsArray) {
                    out += "" + $typeSchema.join(",");
                  } else {
                    out += "" + $typeSchema;
                  }
                  out += "' } ";
                  if (it.opts.messages !== false) {
                    out += " , message: 'should be ";
                    if ($typeIsArray) {
                      out += "" + $typeSchema.join(",");
                    } else {
                      out += "" + $typeSchema;
                    }
                    out += "' ";
                  }
                  if (it.opts.verbose) {
                    out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                  }
                  out += " } ";
                } else {
                  out += " {} ";
                }
                var __err = out;
                out = $$outStack.pop();
                if (!it.compositeRule && $breakOnError) {
                  if (it.async) {
                    out += " throw new ValidationError([" + __err + "]); ";
                  } else {
                    out += " validate.errors = [" + __err + "]; return false; ";
                  }
                } else {
                  out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
                }
                out += " } ";
              }
            }
            if ($breakOnError) {
              out += " if (errors === ";
              if ($top) {
                out += "0";
              } else {
                out += "errs_" + $lvl;
              }
              out += ") { ";
              $closingBraces2 += "}";
            }
          }
        }
      }
    }
    if ($breakOnError) {
      out += " " + $closingBraces2 + " ";
    }
    if ($top) {
      if ($async) {
        out += " if (errors === 0) return data;           ";
        out += " else throw new ValidationError(vErrors); ";
      } else {
        out += " validate.errors = vErrors; ";
        out += " return errors === 0;       ";
      }
      out += " }; return validate;";
    } else {
      out += " var " + $valid + " = errors === errs_" + $lvl + ";";
    }
    function $shouldUseGroup($rulesGroup2) {
      var rules2 = $rulesGroup2.rules;
      for (var i4 = 0; i4 < rules2.length; i4++)
        if ($shouldUseRule(rules2[i4])) return true;
    }
    function $shouldUseRule($rule2) {
      return it.schema[$rule2.keyword] !== void 0 || $rule2.implements && $ruleImplementsSomeKeyword($rule2);
    }
    function $ruleImplementsSomeKeyword($rule2) {
      var impl = $rule2.implements;
      for (var i4 = 0; i4 < impl.length; i4++)
        if (it.schema[impl[i4]] !== void 0) return true;
    }
    return out;
  };
  return validate;
}
var compile_1;
var hasRequiredCompile;
function requireCompile() {
  if (hasRequiredCompile) return compile_1;
  hasRequiredCompile = 1;
  var resolve2 = requireResolve(), util2 = requireUtil(), errorClasses = requireError_classes(), stableStringify = requireFastJsonStableStringify();
  var validateGenerator = requireValidate();
  var ucs2length2 = util2.ucs2length;
  var equal = requireFastDeepEqual();
  var ValidationError = errorClasses.Validation;
  compile_1 = compile;
  function compile(schema, root, localRefs, baseId) {
    var self2 = this, opts = this._opts, refVal = [void 0], refs = {}, patterns = [], patternsHash = {}, defaults = [], defaultsHash = {}, customRules = [];
    root = root || { schema, refVal, refs };
    var c2 = checkCompiling.call(this, schema, root, baseId);
    var compilation = this._compilations[c2.index];
    if (c2.compiling) return compilation.callValidate = callValidate;
    var formats = this._formats;
    var RULES = this.RULES;
    try {
      var v2 = localCompile(schema, root, localRefs, baseId);
      compilation.validate = v2;
      var cv = compilation.callValidate;
      if (cv) {
        cv.schema = v2.schema;
        cv.errors = null;
        cv.refs = v2.refs;
        cv.refVal = v2.refVal;
        cv.root = v2.root;
        cv.$async = v2.$async;
        if (opts.sourceCode) cv.source = v2.source;
      }
      return v2;
    } finally {
      endCompiling.call(this, schema, root, baseId);
    }
    function callValidate() {
      var validate2 = compilation.validate;
      var result = validate2.apply(this, arguments);
      callValidate.errors = validate2.errors;
      return result;
    }
    function localCompile(_schema, _root, localRefs2, baseId2) {
      var isRoot = !_root || _root && _root.schema == _schema;
      if (_root.schema != root.schema)
        return compile.call(self2, _schema, _root, localRefs2, baseId2);
      var $async = _schema.$async === true;
      var sourceCode2 = validateGenerator({
        isTop: true,
        schema: _schema,
        isRoot,
        baseId: baseId2,
        root: _root,
        schemaPath: "",
        errSchemaPath: "#",
        errorPath: '""',
        MissingRefError: errorClasses.MissingRef,
        RULES,
        validate: validateGenerator,
        util: util2,
        resolve: resolve2,
        resolveRef,
        usePattern,
        useDefault,
        useCustomRule,
        opts,
        formats,
        logger: self2.logger,
        self: self2
      });
      sourceCode2 = vars(refVal, refValCode) + vars(patterns, patternCode) + vars(defaults, defaultCode) + vars(customRules, customRuleCode) + sourceCode2;
      if (opts.processCode) sourceCode2 = opts.processCode(sourceCode2, _schema);
      var validate2;
      try {
        var makeValidate = new Function(
          "self",
          "RULES",
          "formats",
          "root",
          "refVal",
          "defaults",
          "customRules",
          "equal",
          "ucs2length",
          "ValidationError",
          sourceCode2
        );
        validate2 = makeValidate(
          self2,
          RULES,
          formats,
          root,
          refVal,
          defaults,
          customRules,
          equal,
          ucs2length2,
          ValidationError
        );
        refVal[0] = validate2;
      } catch (e2) {
        self2.logger.error("Error compiling schema, function code:", sourceCode2);
        throw e2;
      }
      validate2.schema = _schema;
      validate2.errors = null;
      validate2.refs = refs;
      validate2.refVal = refVal;
      validate2.root = isRoot ? validate2 : _root;
      if ($async) validate2.$async = true;
      if (opts.sourceCode === true) {
        validate2.source = {
          code: sourceCode2,
          patterns,
          defaults
        };
      }
      return validate2;
    }
    function resolveRef(baseId2, ref2, isRoot) {
      ref2 = resolve2.url(baseId2, ref2);
      var refIndex = refs[ref2];
      var _refVal, refCode;
      if (refIndex !== void 0) {
        _refVal = refVal[refIndex];
        refCode = "refVal[" + refIndex + "]";
        return resolvedRef(_refVal, refCode);
      }
      if (!isRoot && root.refs) {
        var rootRefId = root.refs[ref2];
        if (rootRefId !== void 0) {
          _refVal = root.refVal[rootRefId];
          refCode = addLocalRef(ref2, _refVal);
          return resolvedRef(_refVal, refCode);
        }
      }
      refCode = addLocalRef(ref2);
      var v3 = resolve2.call(self2, localCompile, root, ref2);
      if (v3 === void 0) {
        var localSchema = localRefs && localRefs[ref2];
        if (localSchema) {
          v3 = resolve2.inlineRef(localSchema, opts.inlineRefs) ? localSchema : compile.call(self2, localSchema, root, localRefs, baseId2);
        }
      }
      if (v3 === void 0) {
        removeLocalRef(ref2);
      } else {
        replaceLocalRef(ref2, v3);
        return resolvedRef(v3, refCode);
      }
    }
    function addLocalRef(ref2, v3) {
      var refId = refVal.length;
      refVal[refId] = v3;
      refs[ref2] = refId;
      return "refVal" + refId;
    }
    function removeLocalRef(ref2) {
      delete refs[ref2];
    }
    function replaceLocalRef(ref2, v3) {
      var refId = refs[ref2];
      refVal[refId] = v3;
    }
    function resolvedRef(refVal2, code2) {
      return typeof refVal2 == "object" || typeof refVal2 == "boolean" ? { code: code2, schema: refVal2, inline: true } : { code: code2, $async: refVal2 && !!refVal2.$async };
    }
    function usePattern(regexStr) {
      var index = patternsHash[regexStr];
      if (index === void 0) {
        index = patternsHash[regexStr] = patterns.length;
        patterns[index] = regexStr;
      }
      return "pattern" + index;
    }
    function useDefault(value) {
      switch (typeof value) {
        case "boolean":
        case "number":
          return "" + value;
        case "string":
          return util2.toQuotedString(value);
        case "object":
          if (value === null) return "null";
          var valueStr = stableStringify(value);
          var index = defaultsHash[valueStr];
          if (index === void 0) {
            index = defaultsHash[valueStr] = defaults.length;
            defaults[index] = value;
          }
          return "default" + index;
      }
    }
    function useCustomRule(rule, schema2, parentSchema, it) {
      if (self2._opts.validateSchema !== false) {
        var deps = rule.definition.dependencies;
        if (deps && !deps.every(function(keyword2) {
          return Object.prototype.hasOwnProperty.call(parentSchema, keyword2);
        }))
          throw new Error("parent schema must have all required keywords: " + deps.join(","));
        var validateSchema = rule.definition.validateSchema;
        if (validateSchema) {
          var valid = validateSchema(schema2);
          if (!valid) {
            var message = "keyword schema is invalid: " + self2.errorsText(validateSchema.errors);
            if (self2._opts.validateSchema == "log") self2.logger.error(message);
            else throw new Error(message);
          }
        }
      }
      var compile2 = rule.definition.compile, inline = rule.definition.inline, macro = rule.definition.macro;
      var validate2;
      if (compile2) {
        validate2 = compile2.call(self2, schema2, parentSchema, it);
      } else if (macro) {
        validate2 = macro.call(self2, schema2, parentSchema, it);
        if (opts.validateSchema !== false) self2.validateSchema(validate2, true);
      } else if (inline) {
        validate2 = inline.call(self2, it, rule.keyword, schema2, parentSchema);
      } else {
        validate2 = rule.definition.validate;
        if (!validate2) return;
      }
      if (validate2 === void 0)
        throw new Error('custom keyword "' + rule.keyword + '"failed to compile');
      var index = customRules.length;
      customRules[index] = validate2;
      return {
        code: "customRule" + index,
        validate: validate2
      };
    }
  }
  function checkCompiling(schema, root, baseId) {
    var index = compIndex.call(this, schema, root, baseId);
    if (index >= 0) return { index, compiling: true };
    index = this._compilations.length;
    this._compilations[index] = {
      schema,
      root,
      baseId
    };
    return { index, compiling: false };
  }
  function endCompiling(schema, root, baseId) {
    var i2 = compIndex.call(this, schema, root, baseId);
    if (i2 >= 0) this._compilations.splice(i2, 1);
  }
  function compIndex(schema, root, baseId) {
    for (var i2 = 0; i2 < this._compilations.length; i2++) {
      var c2 = this._compilations[i2];
      if (c2.schema == schema && c2.root == root && c2.baseId == baseId) return i2;
    }
    return -1;
  }
  function patternCode(i2, patterns) {
    return "var pattern" + i2 + " = new RegExp(" + util2.toQuotedString(patterns[i2]) + ");";
  }
  function defaultCode(i2) {
    return "var default" + i2 + " = defaults[" + i2 + "];";
  }
  function refValCode(i2, refVal) {
    return refVal[i2] === void 0 ? "" : "var refVal" + i2 + " = refVal[" + i2 + "];";
  }
  function customRuleCode(i2) {
    return "var customRule" + i2 + " = customRules[" + i2 + "];";
  }
  function vars(arr, statement) {
    if (!arr.length) return "";
    var code2 = "";
    for (var i2 = 0; i2 < arr.length; i2++)
      code2 += statement(i2, arr);
    return code2;
  }
  return compile_1;
}
var cache = { exports: {} };
var hasRequiredCache;
function requireCache() {
  if (hasRequiredCache) return cache.exports;
  hasRequiredCache = 1;
  var Cache = cache.exports = function Cache2() {
    this._cache = {};
  };
  Cache.prototype.put = function Cache_put(key, value) {
    this._cache[key] = value;
  };
  Cache.prototype.get = function Cache_get(key) {
    return this._cache[key];
  };
  Cache.prototype.del = function Cache_del(key) {
    delete this._cache[key];
  };
  Cache.prototype.clear = function Cache_clear() {
    this._cache = {};
  };
  return cache.exports;
}
var formats_1;
var hasRequiredFormats;
function requireFormats() {
  if (hasRequiredFormats) return formats_1;
  hasRequiredFormats = 1;
  var util2 = requireUtil();
  var DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
  var DAYS = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
  var HOSTNAME = /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;
  var URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
  var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
  var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
  var URL2 = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
  var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
  var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$/;
  var JSON_POINTER_URI_FRAGMENT = /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
  var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;
  formats_1 = formats;
  function formats(mode) {
    mode = mode == "full" ? "full" : "fast";
    return util2.copy(formats[mode]);
  }
  formats.fast = {
    // date: http://tools.ietf.org/html/rfc3339#section-5.6
    date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
    // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
    time: /^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,
    "date-time": /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,
    // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
    uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
    "uri-reference": /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
    "uri-template": URITEMPLATE,
    url: URL2,
    // email (sources from jsen validator):
    // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
    // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'willful violation')
    email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
    hostname: HOSTNAME,
    // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
    ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
    // optimized http://stackoverflow.com/questions/53497/regular-expression-that-matches-valid-ipv6-addresses
    ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
    regex,
    // uuid: http://tools.ietf.org/html/rfc4122
    uuid: UUID,
    // JSON-pointer: https://tools.ietf.org/html/rfc6901
    // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
    "json-pointer": JSON_POINTER,
    "json-pointer-uri-fragment": JSON_POINTER_URI_FRAGMENT,
    // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
    "relative-json-pointer": RELATIVE_JSON_POINTER
  };
  formats.full = {
    date,
    time,
    "date-time": date_time,
    uri,
    "uri-reference": URIREF,
    "uri-template": URITEMPLATE,
    url: URL2,
    email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
    hostname: HOSTNAME,
    ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
    ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
    regex,
    uuid: UUID,
    "json-pointer": JSON_POINTER,
    "json-pointer-uri-fragment": JSON_POINTER_URI_FRAGMENT,
    "relative-json-pointer": RELATIVE_JSON_POINTER
  };
  function isLeapYear(year) {
    return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
  }
  function date(str) {
    var matches = str.match(DATE);
    if (!matches) return false;
    var year = +matches[1];
    var month = +matches[2];
    var day = +matches[3];
    return month >= 1 && month <= 12 && day >= 1 && day <= (month == 2 && isLeapYear(year) ? 29 : DAYS[month]);
  }
  function time(str, full) {
    var matches = str.match(TIME);
    if (!matches) return false;
    var hour = matches[1];
    var minute = matches[2];
    var second = matches[3];
    var timeZone = matches[5];
    return (hour <= 23 && minute <= 59 && second <= 59 || hour == 23 && minute == 59 && second == 60) && (!full || timeZone);
  }
  var DATE_TIME_SEPARATOR = /t|\s/i;
  function date_time(str) {
    var dateTime = str.split(DATE_TIME_SEPARATOR);
    return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
  }
  var NOT_URI_FRAGMENT = /\/|:/;
  function uri(str) {
    return NOT_URI_FRAGMENT.test(str) && URI.test(str);
  }
  var Z_ANCHOR = /[^\\]\\Z/;
  function regex(str) {
    if (Z_ANCHOR.test(str)) return false;
    try {
      new RegExp(str);
      return true;
    } catch (e2) {
      return false;
    }
  }
  return formats_1;
}
var ref;
var hasRequiredRef;
function requireRef() {
  if (hasRequiredRef) return ref;
  hasRequiredRef = 1;
  ref = function generate_ref(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $async, $refCode;
    if ($schema2 == "#" || $schema2 == "#/") {
      if (it.isRoot) {
        $async = it.async;
        $refCode = "validate";
      } else {
        $async = it.root.schema.$async === true;
        $refCode = "root.refVal[0]";
      }
    } else {
      var $refVal = it.resolveRef(it.baseId, $schema2, it.isRoot);
      if ($refVal === void 0) {
        var $message = it.MissingRefError.message(it.baseId, $schema2);
        if (it.opts.missingRefs == "fail") {
          it.logger.error($message);
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: '$ref' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { ref: '" + it.util.escapeQuotes($schema2) + "' } ";
            if (it.opts.messages !== false) {
              out += " , message: 'can\\'t resolve reference " + it.util.escapeQuotes($schema2) + "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: " + it.util.toQuotedString($schema2) + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          if ($breakOnError) {
            out += " if (false) { ";
          }
        } else if (it.opts.missingRefs == "ignore") {
          it.logger.warn($message);
          if ($breakOnError) {
            out += " if (true) { ";
          }
        } else {
          throw new it.MissingRefError(it.baseId, $schema2, $message);
        }
      } else if ($refVal.inline) {
        var $it = it.util.copy(it);
        $it.level++;
        var $nextValid = "valid" + $it.level;
        $it.schema = $refVal.schema;
        $it.schemaPath = "";
        $it.errSchemaPath = $schema2;
        var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
        out += " " + $code + " ";
        if ($breakOnError) {
          out += " if (" + $nextValid + ") { ";
        }
      } else {
        $async = $refVal.$async === true || it.async && $refVal.$async !== false;
        $refCode = $refVal.code;
      }
    }
    if ($refCode) {
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      if (it.opts.passContext) {
        out += " " + $refCode + ".call(this, ";
      } else {
        out += " " + $refCode + "( ";
      }
      out += " " + $data + ", (dataPath || '')";
      if (it.errorPath != '""') {
        out += " + " + it.errorPath;
      }
      var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
      out += " , " + $parentData + " , " + $parentDataProperty + ", rootData)  ";
      var __callValidate = out;
      out = $$outStack.pop();
      if ($async) {
        if (!it.async) throw new Error("async schema referenced by sync schema");
        if ($breakOnError) {
          out += " var " + $valid + "; ";
        }
        out += " try { await " + __callValidate + "; ";
        if ($breakOnError) {
          out += " " + $valid + " = true; ";
        }
        out += " } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ";
        if ($breakOnError) {
          out += " " + $valid + " = false; ";
        }
        out += " } ";
        if ($breakOnError) {
          out += " if (" + $valid + ") { ";
        }
      } else {
        out += " if (!" + __callValidate + ") { if (vErrors === null) vErrors = " + $refCode + ".errors; else vErrors = vErrors.concat(" + $refCode + ".errors); errors = vErrors.length; } ";
        if ($breakOnError) {
          out += " else { ";
        }
      }
    }
    return out;
  };
  return ref;
}
var allOf;
var hasRequiredAllOf;
function requireAllOf() {
  if (hasRequiredAllOf) return allOf;
  hasRequiredAllOf = 1;
  allOf = function generate_allOf(it, $keyword, $ruleType) {
    var out = " ";
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $currentBaseId = $it.baseId, $allSchemasEmpty = true;
    var arr1 = $schema2;
    if (arr1) {
      var $sch, $i = -1, l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
          $allSchemasEmpty = false;
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + "[" + $i + "]";
          $it.errSchemaPath = $errSchemaPath + "/" + $i;
          out += "  " + it.validate($it) + " ";
          $it.baseId = $currentBaseId;
          if ($breakOnError) {
            out += " if (" + $nextValid + ") { ";
            $closingBraces += "}";
          }
        }
      }
    }
    if ($breakOnError) {
      if ($allSchemasEmpty) {
        out += " if (true) { ";
      } else {
        out += " " + $closingBraces.slice(0, -1) + " ";
      }
    }
    return out;
  };
  return allOf;
}
var anyOf;
var hasRequiredAnyOf;
function requireAnyOf() {
  if (hasRequiredAnyOf) return anyOf;
  hasRequiredAnyOf = 1;
  anyOf = function generate_anyOf(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $noEmptySchema = $schema2.every(function($sch2) {
      return it.opts.strictKeywords ? typeof $sch2 == "object" && Object.keys($sch2).length > 0 || $sch2 === false : it.util.schemaHasRules($sch2, it.RULES.all);
    });
    if ($noEmptySchema) {
      var $currentBaseId = $it.baseId;
      out += " var " + $errs + " = errors; var " + $valid + " = false;  ";
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      var arr1 = $schema2;
      if (arr1) {
        var $sch, $i = -1, l1 = arr1.length - 1;
        while ($i < l1) {
          $sch = arr1[$i += 1];
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + "[" + $i + "]";
          $it.errSchemaPath = $errSchemaPath + "/" + $i;
          out += "  " + it.validate($it) + " ";
          $it.baseId = $currentBaseId;
          out += " " + $valid + " = " + $valid + " || " + $nextValid + "; if (!" + $valid + ") { ";
          $closingBraces += "}";
        }
      }
      it.compositeRule = $it.compositeRule = $wasComposite;
      out += " " + $closingBraces + " if (!" + $valid + ") {   var err =   ";
      if (it.createErrors !== false) {
        out += " { keyword: 'anyOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
        if (it.opts.messages !== false) {
          out += " , message: 'should match some schema in anyOf' ";
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError(vErrors); ";
        } else {
          out += " validate.errors = vErrors; return false; ";
        }
      }
      out += " } else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
      if (it.opts.allErrors) {
        out += " } ";
      }
    } else {
      if ($breakOnError) {
        out += " if (true) { ";
      }
    }
    return out;
  };
  return anyOf;
}
var comment;
var hasRequiredComment;
function requireComment() {
  if (hasRequiredComment) return comment;
  hasRequiredComment = 1;
  comment = function generate_comment(it, $keyword, $ruleType) {
    var out = " ";
    var $schema2 = it.schema[$keyword];
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    !it.opts.allErrors;
    var $comment = it.util.toQuotedString($schema2);
    if (it.opts.$comment === true) {
      out += " console.log(" + $comment + ");";
    } else if (typeof it.opts.$comment == "function") {
      out += " self._opts.$comment(" + $comment + ", " + it.util.toQuotedString($errSchemaPath) + ", validate.root.schema);";
    }
    return out;
  };
  return comment;
}
var _const;
var hasRequired_const;
function require_const() {
  if (hasRequired_const) return _const;
  hasRequired_const = 1;
  _const = function generate_const(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $isData = it.opts.$data && $schema2 && $schema2.$data;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
    }
    if (!$isData) {
      out += " var schema" + $lvl + " = validate.schema" + $schemaPath + ";";
    }
    out += "var " + $valid + " = equal(" + $data + ", schema" + $lvl + "); if (!" + $valid + ") {   ";
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'const' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { allowedValue: schema" + $lvl + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should be equal to constant' ";
      }
      if (it.opts.verbose) {
        out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += " }";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _const;
}
var contains;
var hasRequiredContains;
function requireContains() {
  if (hasRequiredContains) return contains;
  hasRequiredContains = 1;
  contains = function generate_contains(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $idx = "i" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $currentBaseId = it.baseId, $nonEmptySchema = it.opts.strictKeywords ? typeof $schema2 == "object" && Object.keys($schema2).length > 0 || $schema2 === false : it.util.schemaHasRules($schema2, it.RULES.all);
    out += "var " + $errs + " = errors;var " + $valid + ";";
    if ($nonEmptySchema) {
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      $it.schema = $schema2;
      $it.schemaPath = $schemaPath;
      $it.errSchemaPath = $errSchemaPath;
      out += " var " + $nextValid + " = false; for (var " + $idx + " = 0; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
      $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
      var $passData = $data + "[" + $idx + "]";
      $it.dataPathArr[$dataNxt] = $idx;
      var $code = it.validate($it);
      $it.baseId = $currentBaseId;
      if (it.util.varOccurences($code, $nextData) < 2) {
        out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
      } else {
        out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
      }
      out += " if (" + $nextValid + ") break; }  ";
      it.compositeRule = $it.compositeRule = $wasComposite;
      out += " " + $closingBraces + " if (!" + $nextValid + ") {";
    } else {
      out += " if (" + $data + ".length == 0) {";
    }
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'contains' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
      if (it.opts.messages !== false) {
        out += " , message: 'should contain a valid item' ";
      }
      if (it.opts.verbose) {
        out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += " } else { ";
    if ($nonEmptySchema) {
      out += "  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
    }
    if (it.opts.allErrors) {
      out += " } ";
    }
    return out;
  };
  return contains;
}
var dependencies$1;
var hasRequiredDependencies;
function requireDependencies() {
  if (hasRequiredDependencies) return dependencies$1;
  hasRequiredDependencies = 1;
  dependencies$1 = function generate_dependencies(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $schemaDeps = {}, $propertyDeps = {}, $ownProperties = it.opts.ownProperties;
    for ($property in $schema2) {
      if ($property == "__proto__") continue;
      var $sch = $schema2[$property];
      var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
      $deps[$property] = $sch;
    }
    out += "var " + $errs + " = errors;";
    var $currentErrorPath = it.errorPath;
    out += "var missing" + $lvl + ";";
    for (var $property in $propertyDeps) {
      $deps = $propertyDeps[$property];
      if ($deps.length) {
        out += " if ( " + $data + it.util.getProperty($property) + " !== undefined ";
        if ($ownProperties) {
          out += " && Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($property) + "') ";
        }
        if ($breakOnError) {
          out += " && ( ";
          var arr1 = $deps;
          if (arr1) {
            var $propertyKey, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
              $propertyKey = arr1[$i += 1];
              if ($i) {
                out += " || ";
              }
              var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
              out += " ( ( " + $useData + " === undefined ";
              if ($ownProperties) {
                out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
              }
              out += ") && (missing" + $lvl + " = " + it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop) + ") ) ";
            }
          }
          out += ")) {  ";
          var $propertyPath = "missing" + $lvl, $missingProperty = "' + " + $propertyPath + " + '";
          if (it.opts._errorDataPathProperty) {
            it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + " + " + $propertyPath;
          }
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: 'dependencies' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { property: '" + it.util.escapeQuotes($property) + "', missingProperty: '" + $missingProperty + "', depsCount: " + $deps.length + ", deps: '" + it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", ")) + "' } ";
            if (it.opts.messages !== false) {
              out += " , message: 'should have ";
              if ($deps.length == 1) {
                out += "property " + it.util.escapeQuotes($deps[0]);
              } else {
                out += "properties " + it.util.escapeQuotes($deps.join(", "));
              }
              out += " when property " + it.util.escapeQuotes($property) + " is present' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
        } else {
          out += " ) { ";
          var arr2 = $deps;
          if (arr2) {
            var $propertyKey, i2 = -1, l2 = arr2.length - 1;
            while (i2 < l2) {
              $propertyKey = arr2[i2 += 1];
              var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
              }
              out += " if ( " + $useData + " === undefined ";
              if ($ownProperties) {
                out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
              }
              out += ") {  var err =   ";
              if (it.createErrors !== false) {
                out += " { keyword: 'dependencies' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { property: '" + it.util.escapeQuotes($property) + "', missingProperty: '" + $missingProperty + "', depsCount: " + $deps.length + ", deps: '" + it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", ")) + "' } ";
                if (it.opts.messages !== false) {
                  out += " , message: 'should have ";
                  if ($deps.length == 1) {
                    out += "property " + it.util.escapeQuotes($deps[0]);
                  } else {
                    out += "properties " + it.util.escapeQuotes($deps.join(", "));
                  }
                  out += " when property " + it.util.escapeQuotes($property) + " is present' ";
                }
                if (it.opts.verbose) {
                  out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out += " } ";
              } else {
                out += " {} ";
              }
              out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ";
            }
          }
        }
        out += " }   ";
        if ($breakOnError) {
          $closingBraces += "}";
          out += " else { ";
        }
      }
    }
    it.errorPath = $currentErrorPath;
    var $currentBaseId = $it.baseId;
    for (var $property in $schemaDeps) {
      var $sch = $schemaDeps[$property];
      if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
        out += " " + $nextValid + " = true; if ( " + $data + it.util.getProperty($property) + " !== undefined ";
        if ($ownProperties) {
          out += " && Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($property) + "') ";
        }
        out += ") { ";
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + it.util.getProperty($property);
        $it.errSchemaPath = $errSchemaPath + "/" + it.util.escapeFragment($property);
        out += "  " + it.validate($it) + " ";
        $it.baseId = $currentBaseId;
        out += " }  ";
        if ($breakOnError) {
          out += " if (" + $nextValid + ") { ";
          $closingBraces += "}";
        }
      }
    }
    if ($breakOnError) {
      out += "   " + $closingBraces + " if (" + $errs + " == errors) {";
    }
    return out;
  };
  return dependencies$1;
}
var _enum;
var hasRequired_enum;
function require_enum() {
  if (hasRequired_enum) return _enum;
  hasRequired_enum = 1;
  _enum = function generate_enum(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $isData = it.opts.$data && $schema2 && $schema2.$data;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
    }
    var $i = "i" + $lvl, $vSchema = "schema" + $lvl;
    if (!$isData) {
      out += " var " + $vSchema + " = validate.schema" + $schemaPath + ";";
    }
    out += "var " + $valid + ";";
    if ($isData) {
      out += " if (schema" + $lvl + " === undefined) " + $valid + " = true; else if (!Array.isArray(schema" + $lvl + ")) " + $valid + " = false; else {";
    }
    out += "" + $valid + " = false;for (var " + $i + "=0; " + $i + "<" + $vSchema + ".length; " + $i + "++) if (equal(" + $data + ", " + $vSchema + "[" + $i + "])) { " + $valid + " = true; break; }";
    if ($isData) {
      out += "  }  ";
    }
    out += " if (!" + $valid + ") {   ";
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'enum' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { allowedValues: schema" + $lvl + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should be equal to one of the allowed values' ";
      }
      if (it.opts.verbose) {
        out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += " }";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _enum;
}
var format;
var hasRequiredFormat;
function requireFormat() {
  if (hasRequiredFormat) return format;
  hasRequiredFormat = 1;
  format = function generate_format(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    if (it.opts.format === false) {
      if ($breakOnError) {
        out += " if (true) { ";
      }
      return out;
    }
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    var $unknownFormats = it.opts.unknownFormats, $allowUnknown = Array.isArray($unknownFormats);
    if ($isData) {
      var $format = "format" + $lvl, $isObject = "isObject" + $lvl, $formatType = "formatType" + $lvl;
      out += " var " + $format + " = formats[" + $schemaValue + "]; var " + $isObject + " = typeof " + $format + " == 'object' && !(" + $format + " instanceof RegExp) && " + $format + ".validate; var " + $formatType + " = " + $isObject + " && " + $format + ".type || 'string'; if (" + $isObject + ") { ";
      if (it.async) {
        out += " var async" + $lvl + " = " + $format + ".async; ";
      }
      out += " " + $format + " = " + $format + ".validate; } if (  ";
      if ($isData) {
        out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'string') || ";
      }
      out += " (";
      if ($unknownFormats != "ignore") {
        out += " (" + $schemaValue + " && !" + $format + " ";
        if ($allowUnknown) {
          out += " && self._opts.unknownFormats.indexOf(" + $schemaValue + ") == -1 ";
        }
        out += ") || ";
      }
      out += " (" + $format + " && " + $formatType + " == '" + $ruleType + "' && !(typeof " + $format + " == 'function' ? ";
      if (it.async) {
        out += " (async" + $lvl + " ? await " + $format + "(" + $data + ") : " + $format + "(" + $data + ")) ";
      } else {
        out += " " + $format + "(" + $data + ") ";
      }
      out += " : " + $format + ".test(" + $data + "))))) {";
    } else {
      var $format = it.formats[$schema2];
      if (!$format) {
        if ($unknownFormats == "ignore") {
          it.logger.warn('unknown format "' + $schema2 + '" ignored in schema at path "' + it.errSchemaPath + '"');
          if ($breakOnError) {
            out += " if (true) { ";
          }
          return out;
        } else if ($allowUnknown && $unknownFormats.indexOf($schema2) >= 0) {
          if ($breakOnError) {
            out += " if (true) { ";
          }
          return out;
        } else {
          throw new Error('unknown format "' + $schema2 + '" is used in schema at path "' + it.errSchemaPath + '"');
        }
      }
      var $isObject = typeof $format == "object" && !($format instanceof RegExp) && $format.validate;
      var $formatType = $isObject && $format.type || "string";
      if ($isObject) {
        var $async = $format.async === true;
        $format = $format.validate;
      }
      if ($formatType != $ruleType) {
        if ($breakOnError) {
          out += " if (true) { ";
        }
        return out;
      }
      if ($async) {
        if (!it.async) throw new Error("async format in sync schema");
        var $formatRef = "formats" + it.util.getProperty($schema2) + ".validate";
        out += " if (!(await " + $formatRef + "(" + $data + "))) { ";
      } else {
        out += " if (! ";
        var $formatRef = "formats" + it.util.getProperty($schema2);
        if ($isObject) $formatRef += ".validate";
        if (typeof $format == "function") {
          out += " " + $formatRef + "(" + $data + ") ";
        } else {
          out += " " + $formatRef + ".test(" + $data + ") ";
        }
        out += ") { ";
      }
    }
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'format' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { format:  ";
      if ($isData) {
        out += "" + $schemaValue;
      } else {
        out += "" + it.util.toQuotedString($schema2);
      }
      out += "  } ";
      if (it.opts.messages !== false) {
        out += ` , message: 'should match format "`;
        if ($isData) {
          out += "' + " + $schemaValue + " + '";
        } else {
          out += "" + it.util.escapeQuotes($schema2);
        }
        out += `"' `;
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + it.util.toQuotedString($schema2);
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += " } ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return format;
}
var _if;
var hasRequired_if;
function require_if() {
  if (hasRequired_if) return _if;
  hasRequired_if = 1;
  _if = function generate_if(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $thenSch = it.schema["then"], $elseSch = it.schema["else"], $thenPresent = $thenSch !== void 0 && (it.opts.strictKeywords ? typeof $thenSch == "object" && Object.keys($thenSch).length > 0 || $thenSch === false : it.util.schemaHasRules($thenSch, it.RULES.all)), $elsePresent = $elseSch !== void 0 && (it.opts.strictKeywords ? typeof $elseSch == "object" && Object.keys($elseSch).length > 0 || $elseSch === false : it.util.schemaHasRules($elseSch, it.RULES.all)), $currentBaseId = $it.baseId;
    if ($thenPresent || $elsePresent) {
      var $ifClause;
      $it.createErrors = false;
      $it.schema = $schema2;
      $it.schemaPath = $schemaPath;
      $it.errSchemaPath = $errSchemaPath;
      out += " var " + $errs + " = errors; var " + $valid + " = true;  ";
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      out += "  " + it.validate($it) + " ";
      $it.baseId = $currentBaseId;
      $it.createErrors = true;
      out += "  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; }  ";
      it.compositeRule = $it.compositeRule = $wasComposite;
      if ($thenPresent) {
        out += " if (" + $nextValid + ") {  ";
        $it.schema = it.schema["then"];
        $it.schemaPath = it.schemaPath + ".then";
        $it.errSchemaPath = it.errSchemaPath + "/then";
        out += "  " + it.validate($it) + " ";
        $it.baseId = $currentBaseId;
        out += " " + $valid + " = " + $nextValid + "; ";
        if ($thenPresent && $elsePresent) {
          $ifClause = "ifClause" + $lvl;
          out += " var " + $ifClause + " = 'then'; ";
        } else {
          $ifClause = "'then'";
        }
        out += " } ";
        if ($elsePresent) {
          out += " else { ";
        }
      } else {
        out += " if (!" + $nextValid + ") { ";
      }
      if ($elsePresent) {
        $it.schema = it.schema["else"];
        $it.schemaPath = it.schemaPath + ".else";
        $it.errSchemaPath = it.errSchemaPath + "/else";
        out += "  " + it.validate($it) + " ";
        $it.baseId = $currentBaseId;
        out += " " + $valid + " = " + $nextValid + "; ";
        if ($thenPresent && $elsePresent) {
          $ifClause = "ifClause" + $lvl;
          out += " var " + $ifClause + " = 'else'; ";
        } else {
          $ifClause = "'else'";
        }
        out += " } ";
      }
      out += " if (!" + $valid + ") {   var err =   ";
      if (it.createErrors !== false) {
        out += " { keyword: 'if' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { failingKeyword: " + $ifClause + " } ";
        if (it.opts.messages !== false) {
          out += ` , message: 'should match "' + ` + $ifClause + ` + '" schema' `;
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError(vErrors); ";
        } else {
          out += " validate.errors = vErrors; return false; ";
        }
      }
      out += " }   ";
      if ($breakOnError) {
        out += " else { ";
      }
    } else {
      if ($breakOnError) {
        out += " if (true) { ";
      }
    }
    return out;
  };
  return _if;
}
var items;
var hasRequiredItems;
function requireItems() {
  if (hasRequiredItems) return items;
  hasRequiredItems = 1;
  items = function generate_items(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $idx = "i" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $currentBaseId = it.baseId;
    out += "var " + $errs + " = errors;var " + $valid + ";";
    if (Array.isArray($schema2)) {
      var $additionalItems = it.schema.additionalItems;
      if ($additionalItems === false) {
        out += " " + $valid + " = " + $data + ".length <= " + $schema2.length + "; ";
        var $currErrSchemaPath = $errSchemaPath;
        $errSchemaPath = it.errSchemaPath + "/additionalItems";
        out += "  if (!" + $valid + ") {   ";
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = "";
        if (it.createErrors !== false) {
          out += " { keyword: 'additionalItems' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schema2.length + " } ";
          if (it.opts.messages !== false) {
            out += " , message: 'should NOT have more than " + $schema2.length + " items' ";
          }
          if (it.opts.verbose) {
            out += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out += " } ";
        } else {
          out += " {} ";
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out += " throw new ValidationError([" + __err + "]); ";
          } else {
            out += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out += " } ";
        $errSchemaPath = $currErrSchemaPath;
        if ($breakOnError) {
          $closingBraces += "}";
          out += " else { ";
        }
      }
      var arr1 = $schema2;
      if (arr1) {
        var $sch, $i = -1, l1 = arr1.length - 1;
        while ($i < l1) {
          $sch = arr1[$i += 1];
          if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
            out += " " + $nextValid + " = true; if (" + $data + ".length > " + $i + ") { ";
            var $passData = $data + "[" + $i + "]";
            $it.schema = $sch;
            $it.schemaPath = $schemaPath + "[" + $i + "]";
            $it.errSchemaPath = $errSchemaPath + "/" + $i;
            $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
            $it.dataPathArr[$dataNxt] = $i;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
            } else {
              out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
            }
            out += " }  ";
            if ($breakOnError) {
              out += " if (" + $nextValid + ") { ";
              $closingBraces += "}";
            }
          }
        }
      }
      if (typeof $additionalItems == "object" && (it.opts.strictKeywords ? typeof $additionalItems == "object" && Object.keys($additionalItems).length > 0 || $additionalItems === false : it.util.schemaHasRules($additionalItems, it.RULES.all))) {
        $it.schema = $additionalItems;
        $it.schemaPath = it.schemaPath + ".additionalItems";
        $it.errSchemaPath = it.errSchemaPath + "/additionalItems";
        out += " " + $nextValid + " = true; if (" + $data + ".length > " + $schema2.length + ") {  for (var " + $idx + " = " + $schema2.length + "; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
        $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
        var $passData = $data + "[" + $idx + "]";
        $it.dataPathArr[$dataNxt] = $idx;
        var $code = it.validate($it);
        $it.baseId = $currentBaseId;
        if (it.util.varOccurences($code, $nextData) < 2) {
          out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
        } else {
          out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
        }
        if ($breakOnError) {
          out += " if (!" + $nextValid + ") break; ";
        }
        out += " } }  ";
        if ($breakOnError) {
          out += " if (" + $nextValid + ") { ";
          $closingBraces += "}";
        }
      }
    } else if (it.opts.strictKeywords ? typeof $schema2 == "object" && Object.keys($schema2).length > 0 || $schema2 === false : it.util.schemaHasRules($schema2, it.RULES.all)) {
      $it.schema = $schema2;
      $it.schemaPath = $schemaPath;
      $it.errSchemaPath = $errSchemaPath;
      out += "  for (var " + $idx + " = 0; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
      $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
      var $passData = $data + "[" + $idx + "]";
      $it.dataPathArr[$dataNxt] = $idx;
      var $code = it.validate($it);
      $it.baseId = $currentBaseId;
      if (it.util.varOccurences($code, $nextData) < 2) {
        out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
      } else {
        out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
      }
      if ($breakOnError) {
        out += " if (!" + $nextValid + ") break; ";
      }
      out += " }";
    }
    if ($breakOnError) {
      out += " " + $closingBraces + " if (" + $errs + " == errors) {";
    }
    return out;
  };
  return items;
}
var _limit;
var hasRequired_limit;
function require_limit() {
  if (hasRequired_limit) return _limit;
  hasRequired_limit = 1;
  _limit = function generate__limit(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    var $isMax = $keyword == "maximum", $exclusiveKeyword = $isMax ? "exclusiveMaximum" : "exclusiveMinimum", $schemaExcl = it.schema[$exclusiveKeyword], $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data, $op = $isMax ? "<" : ">", $notOp = $isMax ? ">" : "<", $errorKeyword = void 0;
    if (!($isData || typeof $schema2 == "number" || $schema2 === void 0)) {
      throw new Error($keyword + " must be number");
    }
    if (!($isDataExcl || $schemaExcl === void 0 || typeof $schemaExcl == "number" || typeof $schemaExcl == "boolean")) {
      throw new Error($exclusiveKeyword + " must be number or boolean");
    }
    if ($isDataExcl) {
      var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr), $exclusive = "exclusive" + $lvl, $exclType = "exclType" + $lvl, $exclIsNumber = "exclIsNumber" + $lvl, $opExpr = "op" + $lvl, $opStr = "' + " + $opExpr + " + '";
      out += " var schemaExcl" + $lvl + " = " + $schemaValueExcl + "; ";
      $schemaValueExcl = "schemaExcl" + $lvl;
      out += " var " + $exclusive + "; var " + $exclType + " = typeof " + $schemaValueExcl + "; if (" + $exclType + " != 'boolean' && " + $exclType + " != 'undefined' && " + $exclType + " != 'number') { ";
      var $errorKeyword = $exclusiveKeyword;
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      if (it.createErrors !== false) {
        out += " { keyword: '" + ($errorKeyword || "_exclusiveLimit") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
        if (it.opts.messages !== false) {
          out += " , message: '" + $exclusiveKeyword + " should be boolean' ";
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError([" + __err + "]); ";
        } else {
          out += " validate.errors = [" + __err + "]; return false; ";
        }
      } else {
        out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      }
      out += " } else if ( ";
      if ($isData) {
        out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
      }
      out += " " + $exclType + " == 'number' ? ( (" + $exclusive + " = " + $schemaValue + " === undefined || " + $schemaValueExcl + " " + $op + "= " + $schemaValue + ") ? " + $data + " " + $notOp + "= " + $schemaValueExcl + " : " + $data + " " + $notOp + " " + $schemaValue + " ) : ( (" + $exclusive + " = " + $schemaValueExcl + " === true) ? " + $data + " " + $notOp + "= " + $schemaValue + " : " + $data + " " + $notOp + " " + $schemaValue + " ) || " + $data + " !== " + $data + ") { var op" + $lvl + " = " + $exclusive + " ? '" + $op + "' : '" + $op + "='; ";
      if ($schema2 === void 0) {
        $errorKeyword = $exclusiveKeyword;
        $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
        $schemaValue = $schemaValueExcl;
        $isData = $isDataExcl;
      }
    } else {
      var $exclIsNumber = typeof $schemaExcl == "number", $opStr = $op;
      if ($exclIsNumber && $isData) {
        var $opExpr = "'" + $opStr + "'";
        out += " if ( ";
        if ($isData) {
          out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
        }
        out += " ( " + $schemaValue + " === undefined || " + $schemaExcl + " " + $op + "= " + $schemaValue + " ? " + $data + " " + $notOp + "= " + $schemaExcl + " : " + $data + " " + $notOp + " " + $schemaValue + " ) || " + $data + " !== " + $data + ") { ";
      } else {
        if ($exclIsNumber && $schema2 === void 0) {
          $exclusive = true;
          $errorKeyword = $exclusiveKeyword;
          $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
          $schemaValue = $schemaExcl;
          $notOp += "=";
        } else {
          if ($exclIsNumber) $schemaValue = Math[$isMax ? "min" : "max"]($schemaExcl, $schema2);
          if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
            $exclusive = true;
            $errorKeyword = $exclusiveKeyword;
            $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
            $notOp += "=";
          } else {
            $exclusive = false;
            $opStr += "=";
          }
        }
        var $opExpr = "'" + $opStr + "'";
        out += " if ( ";
        if ($isData) {
          out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
        }
        out += " " + $data + " " + $notOp + " " + $schemaValue + " || " + $data + " !== " + $data + ") { ";
      }
    }
    $errorKeyword = $errorKeyword || $keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: '" + ($errorKeyword || "_limit") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { comparison: " + $opExpr + ", limit: " + $schemaValue + ", exclusive: " + $exclusive + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should be " + $opStr + " ";
        if ($isData) {
          out += "' + " + $schemaValue;
        } else {
          out += "" + $schemaValue + "'";
        }
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + $schema2;
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += " } ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _limit;
}
var _limitItems;
var hasRequired_limitItems;
function require_limitItems() {
  if (hasRequired_limitItems) return _limitItems;
  hasRequired_limitItems = 1;
  _limitItems = function generate__limitItems(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    if (!($isData || typeof $schema2 == "number")) {
      throw new Error($keyword + " must be number");
    }
    var $op = $keyword == "maxItems" ? ">" : "<";
    out += "if ( ";
    if ($isData) {
      out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
    }
    out += " " + $data + ".length " + $op + " " + $schemaValue + ") { ";
    var $errorKeyword = $keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: '" + ($errorKeyword || "_limitItems") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should NOT have ";
        if ($keyword == "maxItems") {
          out += "more";
        } else {
          out += "fewer";
        }
        out += " than ";
        if ($isData) {
          out += "' + " + $schemaValue + " + '";
        } else {
          out += "" + $schema2;
        }
        out += " items' ";
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + $schema2;
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += "} ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _limitItems;
}
var _limitLength;
var hasRequired_limitLength;
function require_limitLength() {
  if (hasRequired_limitLength) return _limitLength;
  hasRequired_limitLength = 1;
  _limitLength = function generate__limitLength(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    if (!($isData || typeof $schema2 == "number")) {
      throw new Error($keyword + " must be number");
    }
    var $op = $keyword == "maxLength" ? ">" : "<";
    out += "if ( ";
    if ($isData) {
      out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
    }
    if (it.opts.unicode === false) {
      out += " " + $data + ".length ";
    } else {
      out += " ucs2length(" + $data + ") ";
    }
    out += " " + $op + " " + $schemaValue + ") { ";
    var $errorKeyword = $keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: '" + ($errorKeyword || "_limitLength") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should NOT be ";
        if ($keyword == "maxLength") {
          out += "longer";
        } else {
          out += "shorter";
        }
        out += " than ";
        if ($isData) {
          out += "' + " + $schemaValue + " + '";
        } else {
          out += "" + $schema2;
        }
        out += " characters' ";
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + $schema2;
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += "} ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _limitLength;
}
var _limitProperties;
var hasRequired_limitProperties;
function require_limitProperties() {
  if (hasRequired_limitProperties) return _limitProperties;
  hasRequired_limitProperties = 1;
  _limitProperties = function generate__limitProperties(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    if (!($isData || typeof $schema2 == "number")) {
      throw new Error($keyword + " must be number");
    }
    var $op = $keyword == "maxProperties" ? ">" : "<";
    out += "if ( ";
    if ($isData) {
      out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
    }
    out += " Object.keys(" + $data + ").length " + $op + " " + $schemaValue + ") { ";
    var $errorKeyword = $keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: '" + ($errorKeyword || "_limitProperties") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should NOT have ";
        if ($keyword == "maxProperties") {
          out += "more";
        } else {
          out += "fewer";
        }
        out += " than ";
        if ($isData) {
          out += "' + " + $schemaValue + " + '";
        } else {
          out += "" + $schema2;
        }
        out += " properties' ";
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + $schema2;
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += "} ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return _limitProperties;
}
var multipleOf;
var hasRequiredMultipleOf;
function requireMultipleOf() {
  if (hasRequiredMultipleOf) return multipleOf;
  hasRequiredMultipleOf = 1;
  multipleOf = function generate_multipleOf(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    if (!($isData || typeof $schema2 == "number")) {
      throw new Error($keyword + " must be number");
    }
    out += "var division" + $lvl + ";if (";
    if ($isData) {
      out += " " + $schemaValue + " !== undefined && ( typeof " + $schemaValue + " != 'number' || ";
    }
    out += " (division" + $lvl + " = " + $data + " / " + $schemaValue + ", ";
    if (it.opts.multipleOfPrecision) {
      out += " Math.abs(Math.round(division" + $lvl + ") - division" + $lvl + ") > 1e-" + it.opts.multipleOfPrecision + " ";
    } else {
      out += " division" + $lvl + " !== parseInt(division" + $lvl + ") ";
    }
    out += " ) ";
    if ($isData) {
      out += "  )  ";
    }
    out += " ) {   ";
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'multipleOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { multipleOf: " + $schemaValue + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should be multiple of ";
        if ($isData) {
          out += "' + " + $schemaValue;
        } else {
          out += "" + $schemaValue + "'";
        }
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + $schema2;
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += "} ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return multipleOf;
}
var not;
var hasRequiredNot;
function requireNot() {
  if (hasRequiredNot) return not;
  hasRequiredNot = 1;
  not = function generate_not(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    $it.level++;
    var $nextValid = "valid" + $it.level;
    if (it.opts.strictKeywords ? typeof $schema2 == "object" && Object.keys($schema2).length > 0 || $schema2 === false : it.util.schemaHasRules($schema2, it.RULES.all)) {
      $it.schema = $schema2;
      $it.schemaPath = $schemaPath;
      $it.errSchemaPath = $errSchemaPath;
      out += " var " + $errs + " = errors;  ";
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      $it.createErrors = false;
      var $allErrorsOption;
      if ($it.opts.allErrors) {
        $allErrorsOption = $it.opts.allErrors;
        $it.opts.allErrors = false;
      }
      out += " " + it.validate($it) + " ";
      $it.createErrors = true;
      if ($allErrorsOption) $it.opts.allErrors = $allErrorsOption;
      it.compositeRule = $it.compositeRule = $wasComposite;
      out += " if (" + $nextValid + ") {   ";
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      if (it.createErrors !== false) {
        out += " { keyword: 'not' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
        if (it.opts.messages !== false) {
          out += " , message: 'should NOT be valid' ";
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError([" + __err + "]); ";
        } else {
          out += " validate.errors = [" + __err + "]; return false; ";
        }
      } else {
        out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      }
      out += " } else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
      if (it.opts.allErrors) {
        out += " } ";
      }
    } else {
      out += "  var err =   ";
      if (it.createErrors !== false) {
        out += " { keyword: 'not' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
        if (it.opts.messages !== false) {
          out += " , message: 'should NOT be valid' ";
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      if ($breakOnError) {
        out += " if (false) { ";
      }
    }
    return out;
  };
  return not;
}
var oneOf;
var hasRequiredOneOf;
function requireOneOf() {
  if (hasRequiredOneOf) return oneOf;
  hasRequiredOneOf = 1;
  oneOf = function generate_oneOf(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $currentBaseId = $it.baseId, $prevValid = "prevValid" + $lvl, $passingSchemas = "passingSchemas" + $lvl;
    out += "var " + $errs + " = errors , " + $prevValid + " = false , " + $valid + " = false , " + $passingSchemas + " = null; ";
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var arr1 = $schema2;
    if (arr1) {
      var $sch, $i = -1, l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + "[" + $i + "]";
          $it.errSchemaPath = $errSchemaPath + "/" + $i;
          out += "  " + it.validate($it) + " ";
          $it.baseId = $currentBaseId;
        } else {
          out += " var " + $nextValid + " = true; ";
        }
        if ($i) {
          out += " if (" + $nextValid + " && " + $prevValid + ") { " + $valid + " = false; " + $passingSchemas + " = [" + $passingSchemas + ", " + $i + "]; } else { ";
          $closingBraces += "}";
        }
        out += " if (" + $nextValid + ") { " + $valid + " = " + $prevValid + " = true; " + $passingSchemas + " = " + $i + "; }";
      }
    }
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += "" + $closingBraces + "if (!" + $valid + ") {   var err =   ";
    if (it.createErrors !== false) {
      out += " { keyword: 'oneOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { passingSchemas: " + $passingSchemas + " } ";
      if (it.opts.messages !== false) {
        out += " , message: 'should match exactly one schema in oneOf' ";
      }
      if (it.opts.verbose) {
        out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError(vErrors); ";
      } else {
        out += " validate.errors = vErrors; return false; ";
      }
    }
    out += "} else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; }";
    if (it.opts.allErrors) {
      out += " } ";
    }
    return out;
  };
  return oneOf;
}
var pattern;
var hasRequiredPattern;
function requirePattern() {
  if (hasRequiredPattern) return pattern;
  hasRequiredPattern = 1;
  pattern = function generate_pattern(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    var $regexp = $isData ? "(new RegExp(" + $schemaValue + "))" : it.usePattern($schema2);
    out += "if ( ";
    if ($isData) {
      out += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'string') || ";
    }
    out += " !" + $regexp + ".test(" + $data + ") ) {   ";
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = "";
    if (it.createErrors !== false) {
      out += " { keyword: 'pattern' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { pattern:  ";
      if ($isData) {
        out += "" + $schemaValue;
      } else {
        out += "" + it.util.toQuotedString($schema2);
      }
      out += "  } ";
      if (it.opts.messages !== false) {
        out += ` , message: 'should match pattern "`;
        if ($isData) {
          out += "' + " + $schemaValue + " + '";
        } else {
          out += "" + it.util.escapeQuotes($schema2);
        }
        out += `"' `;
      }
      if (it.opts.verbose) {
        out += " , schema:  ";
        if ($isData) {
          out += "validate.schema" + $schemaPath;
        } else {
          out += "" + it.util.toQuotedString($schema2);
        }
        out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
      }
      out += " } ";
    } else {
      out += " {} ";
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      if (it.async) {
        out += " throw new ValidationError([" + __err + "]); ";
      } else {
        out += " validate.errors = [" + __err + "]; return false; ";
      }
    } else {
      out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
    }
    out += "} ";
    if ($breakOnError) {
      out += " else { ";
    }
    return out;
  };
  return pattern;
}
var properties$3;
var hasRequiredProperties;
function requireProperties() {
  if (hasRequiredProperties) return properties$3;
  hasRequiredProperties = 1;
  properties$3 = function generate_properties(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    var $key = "key" + $lvl, $idx = "idx" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $dataProperties = "dataProperties" + $lvl;
    var $schemaKeys = Object.keys($schema2 || {}).filter(notProto), $pProperties = it.schema.patternProperties || {}, $pPropertyKeys = Object.keys($pProperties).filter(notProto), $aProperties = it.schema.additionalProperties, $someProperties = $schemaKeys.length || $pPropertyKeys.length, $noAdditional = $aProperties === false, $additionalIsSchema = typeof $aProperties == "object" && Object.keys($aProperties).length, $removeAdditional = it.opts.removeAdditional, $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
    var $required = it.schema.required;
    if ($required && !(it.opts.$data && $required.$data) && $required.length < it.opts.loopRequired) {
      var $requiredHash = it.util.toHash($required);
    }
    function notProto(p2) {
      return p2 !== "__proto__";
    }
    out += "var " + $errs + " = errors;var " + $nextValid + " = true;";
    if ($ownProperties) {
      out += " var " + $dataProperties + " = undefined;";
    }
    if ($checkAdditional) {
      if ($ownProperties) {
        out += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
      } else {
        out += " for (var " + $key + " in " + $data + ") { ";
      }
      if ($someProperties) {
        out += " var isAdditional" + $lvl + " = !(false ";
        if ($schemaKeys.length) {
          if ($schemaKeys.length > 8) {
            out += " || validate.schema" + $schemaPath + ".hasOwnProperty(" + $key + ") ";
          } else {
            var arr1 = $schemaKeys;
            if (arr1) {
              var $propertyKey, i1 = -1, l1 = arr1.length - 1;
              while (i1 < l1) {
                $propertyKey = arr1[i1 += 1];
                out += " || " + $key + " == " + it.util.toQuotedString($propertyKey) + " ";
              }
            }
          }
        }
        if ($pPropertyKeys.length) {
          var arr2 = $pPropertyKeys;
          if (arr2) {
            var $pProperty, $i = -1, l2 = arr2.length - 1;
            while ($i < l2) {
              $pProperty = arr2[$i += 1];
              out += " || " + it.usePattern($pProperty) + ".test(" + $key + ") ";
            }
          }
        }
        out += " ); if (isAdditional" + $lvl + ") { ";
      }
      if ($removeAdditional == "all") {
        out += " delete " + $data + "[" + $key + "]; ";
      } else {
        var $currentErrorPath = it.errorPath;
        var $additionalProperty = "' + " + $key + " + '";
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
        }
        if ($noAdditional) {
          if ($removeAdditional) {
            out += " delete " + $data + "[" + $key + "]; ";
          } else {
            out += " " + $nextValid + " = false; ";
            var $currErrSchemaPath = $errSchemaPath;
            $errSchemaPath = it.errSchemaPath + "/additionalProperties";
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = "";
            if (it.createErrors !== false) {
              out += " { keyword: 'additionalProperties' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { additionalProperty: '" + $additionalProperty + "' } ";
              if (it.opts.messages !== false) {
                out += " , message: '";
                if (it.opts._errorDataPathProperty) {
                  out += "is an invalid additional property";
                } else {
                  out += "should NOT have additional properties";
                }
                out += "' ";
              }
              if (it.opts.verbose) {
                out += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
              }
              out += " } ";
            } else {
              out += " {} ";
            }
            var __err = out;
            out = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) {
              if (it.async) {
                out += " throw new ValidationError([" + __err + "]); ";
              } else {
                out += " validate.errors = [" + __err + "]; return false; ";
              }
            } else {
              out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
            }
            $errSchemaPath = $currErrSchemaPath;
            if ($breakOnError) {
              out += " break; ";
            }
          }
        } else if ($additionalIsSchema) {
          if ($removeAdditional == "failing") {
            out += " var " + $errs + " = errors;  ";
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            $it.schema = $aProperties;
            $it.schemaPath = it.schemaPath + ".additionalProperties";
            $it.errSchemaPath = it.errSchemaPath + "/additionalProperties";
            $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
            var $passData = $data + "[" + $key + "]";
            $it.dataPathArr[$dataNxt] = $key;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
            } else {
              out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
            }
            out += " if (!" + $nextValid + ") { errors = " + $errs + "; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete " + $data + "[" + $key + "]; }  ";
            it.compositeRule = $it.compositeRule = $wasComposite;
          } else {
            $it.schema = $aProperties;
            $it.schemaPath = it.schemaPath + ".additionalProperties";
            $it.errSchemaPath = it.errSchemaPath + "/additionalProperties";
            $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
            var $passData = $data + "[" + $key + "]";
            $it.dataPathArr[$dataNxt] = $key;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
            } else {
              out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
            }
            if ($breakOnError) {
              out += " if (!" + $nextValid + ") break; ";
            }
          }
        }
        it.errorPath = $currentErrorPath;
      }
      if ($someProperties) {
        out += " } ";
      }
      out += " }  ";
      if ($breakOnError) {
        out += " if (" + $nextValid + ") { ";
        $closingBraces += "}";
      }
    }
    var $useDefaults = it.opts.useDefaults && !it.compositeRule;
    if ($schemaKeys.length) {
      var arr3 = $schemaKeys;
      if (arr3) {
        var $propertyKey, i3 = -1, l3 = arr3.length - 1;
        while (i3 < l3) {
          $propertyKey = arr3[i3 += 1];
          var $sch = $schema2[$propertyKey];
          if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
            var $prop = it.util.getProperty($propertyKey), $passData = $data + $prop, $hasDefault = $useDefaults && $sch.default !== void 0;
            $it.schema = $sch;
            $it.schemaPath = $schemaPath + $prop;
            $it.errSchemaPath = $errSchemaPath + "/" + it.util.escapeFragment($propertyKey);
            $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
            $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              $code = it.util.varReplace($code, $nextData, $passData);
              var $useData = $passData;
            } else {
              var $useData = $nextData;
              out += " var " + $nextData + " = " + $passData + "; ";
            }
            if ($hasDefault) {
              out += " " + $code + " ";
            } else {
              if ($requiredHash && $requiredHash[$propertyKey]) {
                out += " if ( " + $useData + " === undefined ";
                if ($ownProperties) {
                  out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                }
                out += ") { " + $nextValid + " = false; ";
                var $currentErrorPath = it.errorPath, $currErrSchemaPath = $errSchemaPath, $missingProperty = it.util.escapeQuotes($propertyKey);
                if (it.opts._errorDataPathProperty) {
                  it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                }
                $errSchemaPath = it.errSchemaPath + "/required";
                var $$outStack = $$outStack || [];
                $$outStack.push(out);
                out = "";
                if (it.createErrors !== false) {
                  out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                  if (it.opts.messages !== false) {
                    out += " , message: '";
                    if (it.opts._errorDataPathProperty) {
                      out += "is a required property";
                    } else {
                      out += "should have required property \\'" + $missingProperty + "\\'";
                    }
                    out += "' ";
                  }
                  if (it.opts.verbose) {
                    out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                  }
                  out += " } ";
                } else {
                  out += " {} ";
                }
                var __err = out;
                out = $$outStack.pop();
                if (!it.compositeRule && $breakOnError) {
                  if (it.async) {
                    out += " throw new ValidationError([" + __err + "]); ";
                  } else {
                    out += " validate.errors = [" + __err + "]; return false; ";
                  }
                } else {
                  out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
                }
                $errSchemaPath = $currErrSchemaPath;
                it.errorPath = $currentErrorPath;
                out += " } else { ";
              } else {
                if ($breakOnError) {
                  out += " if ( " + $useData + " === undefined ";
                  if ($ownProperties) {
                    out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out += ") { " + $nextValid + " = true; } else { ";
                } else {
                  out += " if (" + $useData + " !== undefined ";
                  if ($ownProperties) {
                    out += " &&   Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out += " ) { ";
                }
              }
              out += " " + $code + " } ";
            }
          }
          if ($breakOnError) {
            out += " if (" + $nextValid + ") { ";
            $closingBraces += "}";
          }
        }
      }
    }
    if ($pPropertyKeys.length) {
      var arr4 = $pPropertyKeys;
      if (arr4) {
        var $pProperty, i4 = -1, l4 = arr4.length - 1;
        while (i4 < l4) {
          $pProperty = arr4[i4 += 1];
          var $sch = $pProperties[$pProperty];
          if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
            $it.schema = $sch;
            $it.schemaPath = it.schemaPath + ".patternProperties" + it.util.getProperty($pProperty);
            $it.errSchemaPath = it.errSchemaPath + "/patternProperties/" + it.util.escapeFragment($pProperty);
            if ($ownProperties) {
              out += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
            } else {
              out += " for (var " + $key + " in " + $data + ") { ";
            }
            out += " if (" + it.usePattern($pProperty) + ".test(" + $key + ")) { ";
            $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
            var $passData = $data + "[" + $key + "]";
            $it.dataPathArr[$dataNxt] = $key;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
            } else {
              out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
            }
            if ($breakOnError) {
              out += " if (!" + $nextValid + ") break; ";
            }
            out += " } ";
            if ($breakOnError) {
              out += " else " + $nextValid + " = true; ";
            }
            out += " }  ";
            if ($breakOnError) {
              out += " if (" + $nextValid + ") { ";
              $closingBraces += "}";
            }
          }
        }
      }
    }
    if ($breakOnError) {
      out += " " + $closingBraces + " if (" + $errs + " == errors) {";
    }
    return out;
  };
  return properties$3;
}
var propertyNames;
var hasRequiredPropertyNames;
function requirePropertyNames() {
  if (hasRequiredPropertyNames) return propertyNames;
  hasRequiredPropertyNames = 1;
  propertyNames = function generate_propertyNames(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $errs = "errs__" + $lvl;
    var $it = it.util.copy(it);
    var $closingBraces = "";
    $it.level++;
    var $nextValid = "valid" + $it.level;
    out += "var " + $errs + " = errors;";
    if (it.opts.strictKeywords ? typeof $schema2 == "object" && Object.keys($schema2).length > 0 || $schema2 === false : it.util.schemaHasRules($schema2, it.RULES.all)) {
      $it.schema = $schema2;
      $it.schemaPath = $schemaPath;
      $it.errSchemaPath = $errSchemaPath;
      var $key = "key" + $lvl, $idx = "idx" + $lvl, $i = "i" + $lvl, $invalidName = "' + " + $key + " + '", $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $dataProperties = "dataProperties" + $lvl, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
      if ($ownProperties) {
        out += " var " + $dataProperties + " = undefined; ";
      }
      if ($ownProperties) {
        out += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
      } else {
        out += " for (var " + $key + " in " + $data + ") { ";
      }
      out += " var startErrs" + $lvl + " = errors; ";
      var $passData = $key;
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      var $code = it.validate($it);
      $it.baseId = $currentBaseId;
      if (it.util.varOccurences($code, $nextData) < 2) {
        out += " " + it.util.varReplace($code, $nextData, $passData) + " ";
      } else {
        out += " var " + $nextData + " = " + $passData + "; " + $code + " ";
      }
      it.compositeRule = $it.compositeRule = $wasComposite;
      out += " if (!" + $nextValid + ") { for (var " + $i + "=startErrs" + $lvl + "; " + $i + "<errors; " + $i + "++) { vErrors[" + $i + "].propertyName = " + $key + "; }   var err =   ";
      if (it.createErrors !== false) {
        out += " { keyword: 'propertyNames' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { propertyName: '" + $invalidName + "' } ";
        if (it.opts.messages !== false) {
          out += " , message: 'property name \\'" + $invalidName + "\\' is invalid' ";
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError(vErrors); ";
        } else {
          out += " validate.errors = vErrors; return false; ";
        }
      }
      if ($breakOnError) {
        out += " break; ";
      }
      out += " } }";
    }
    if ($breakOnError) {
      out += " " + $closingBraces + " if (" + $errs + " == errors) {";
    }
    return out;
  };
  return propertyNames;
}
var required$1;
var hasRequiredRequired;
function requireRequired() {
  if (hasRequiredRequired) return required$1;
  hasRequiredRequired = 1;
  required$1 = function generate_required(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $isData = it.opts.$data && $schema2 && $schema2.$data;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
    }
    var $vSchema = "schema" + $lvl;
    if (!$isData) {
      if ($schema2.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
        var $required = [];
        var arr1 = $schema2;
        if (arr1) {
          var $property, i1 = -1, l1 = arr1.length - 1;
          while (i1 < l1) {
            $property = arr1[i1 += 1];
            var $propertySch = it.schema.properties[$property];
            if (!($propertySch && (it.opts.strictKeywords ? typeof $propertySch == "object" && Object.keys($propertySch).length > 0 || $propertySch === false : it.util.schemaHasRules($propertySch, it.RULES.all)))) {
              $required[$required.length] = $property;
            }
          }
        }
      } else {
        var $required = $schema2;
      }
    }
    if ($isData || $required.length) {
      var $currentErrorPath = it.errorPath, $loopRequired = $isData || $required.length >= it.opts.loopRequired, $ownProperties = it.opts.ownProperties;
      if ($breakOnError) {
        out += " var missing" + $lvl + "; ";
        if ($loopRequired) {
          if (!$isData) {
            out += " var " + $vSchema + " = validate.schema" + $schemaPath + "; ";
          }
          var $i = "i" + $lvl, $propertyPath = "schema" + $lvl + "[" + $i + "]", $missingProperty = "' + " + $propertyPath + " + '";
          if (it.opts._errorDataPathProperty) {
            it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
          }
          out += " var " + $valid + " = true; ";
          if ($isData) {
            out += " if (schema" + $lvl + " === undefined) " + $valid + " = true; else if (!Array.isArray(schema" + $lvl + ")) " + $valid + " = false; else {";
          }
          out += " for (var " + $i + " = 0; " + $i + " < " + $vSchema + ".length; " + $i + "++) { " + $valid + " = " + $data + "[" + $vSchema + "[" + $i + "]] !== undefined ";
          if ($ownProperties) {
            out += " &&   Object.prototype.hasOwnProperty.call(" + $data + ", " + $vSchema + "[" + $i + "]) ";
          }
          out += "; if (!" + $valid + ") break; } ";
          if ($isData) {
            out += "  }  ";
          }
          out += "  if (!" + $valid + ") {   ";
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
            if (it.opts.messages !== false) {
              out += " , message: '";
              if (it.opts._errorDataPathProperty) {
                out += "is a required property";
              } else {
                out += "should have required property \\'" + $missingProperty + "\\'";
              }
              out += "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out += " } else { ";
        } else {
          out += " if ( ";
          var arr2 = $required;
          if (arr2) {
            var $propertyKey, $i = -1, l2 = arr2.length - 1;
            while ($i < l2) {
              $propertyKey = arr2[$i += 1];
              if ($i) {
                out += " || ";
              }
              var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
              out += " ( ( " + $useData + " === undefined ";
              if ($ownProperties) {
                out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
              }
              out += ") && (missing" + $lvl + " = " + it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop) + ") ) ";
            }
          }
          out += ") {  ";
          var $propertyPath = "missing" + $lvl, $missingProperty = "' + " + $propertyPath + " + '";
          if (it.opts._errorDataPathProperty) {
            it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + " + " + $propertyPath;
          }
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = "";
          if (it.createErrors !== false) {
            out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
            if (it.opts.messages !== false) {
              out += " , message: '";
              if (it.opts._errorDataPathProperty) {
                out += "is a required property";
              } else {
                out += "should have required property \\'" + $missingProperty + "\\'";
              }
              out += "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out += " throw new ValidationError([" + __err + "]); ";
            } else {
              out += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out += " } else { ";
        }
      } else {
        if ($loopRequired) {
          if (!$isData) {
            out += " var " + $vSchema + " = validate.schema" + $schemaPath + "; ";
          }
          var $i = "i" + $lvl, $propertyPath = "schema" + $lvl + "[" + $i + "]", $missingProperty = "' + " + $propertyPath + " + '";
          if (it.opts._errorDataPathProperty) {
            it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
          }
          if ($isData) {
            out += " if (" + $vSchema + " && !Array.isArray(" + $vSchema + ")) {  var err =   ";
            if (it.createErrors !== false) {
              out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
              if (it.opts.messages !== false) {
                out += " , message: '";
                if (it.opts._errorDataPathProperty) {
                  out += "is a required property";
                } else {
                  out += "should have required property \\'" + $missingProperty + "\\'";
                }
                out += "' ";
              }
              if (it.opts.verbose) {
                out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
              }
              out += " } ";
            } else {
              out += " {} ";
            }
            out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (" + $vSchema + " !== undefined) { ";
          }
          out += " for (var " + $i + " = 0; " + $i + " < " + $vSchema + ".length; " + $i + "++) { if (" + $data + "[" + $vSchema + "[" + $i + "]] === undefined ";
          if ($ownProperties) {
            out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", " + $vSchema + "[" + $i + "]) ";
          }
          out += ") {  var err =   ";
          if (it.createErrors !== false) {
            out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
            if (it.opts.messages !== false) {
              out += " , message: '";
              if (it.opts._errorDataPathProperty) {
                out += "is a required property";
              } else {
                out += "should have required property \\'" + $missingProperty + "\\'";
              }
              out += "' ";
            }
            if (it.opts.verbose) {
              out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out += " } ";
          } else {
            out += " {} ";
          }
          out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ";
          if ($isData) {
            out += "  }  ";
          }
        } else {
          var arr3 = $required;
          if (arr3) {
            var $propertyKey, i3 = -1, l3 = arr3.length - 1;
            while (i3 < l3) {
              $propertyKey = arr3[i3 += 1];
              var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
              }
              out += " if ( " + $useData + " === undefined ";
              if ($ownProperties) {
                out += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
              }
              out += ") {  var err =   ";
              if (it.createErrors !== false) {
                out += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                if (it.opts.messages !== false) {
                  out += " , message: '";
                  if (it.opts._errorDataPathProperty) {
                    out += "is a required property";
                  } else {
                    out += "should have required property \\'" + $missingProperty + "\\'";
                  }
                  out += "' ";
                }
                if (it.opts.verbose) {
                  out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out += " } ";
              } else {
                out += " {} ";
              }
              out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ";
            }
          }
        }
      }
      it.errorPath = $currentErrorPath;
    } else if ($breakOnError) {
      out += " if (true) {";
    }
    return out;
  };
  return required$1;
}
var uniqueItems;
var hasRequiredUniqueItems;
function requireUniqueItems() {
  if (hasRequiredUniqueItems) return uniqueItems;
  hasRequiredUniqueItems = 1;
  uniqueItems = function generate_uniqueItems(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    if (($schema2 || $isData) && it.opts.uniqueItems !== false) {
      if ($isData) {
        out += " var " + $valid + "; if (" + $schemaValue + " === false || " + $schemaValue + " === undefined) " + $valid + " = true; else if (typeof " + $schemaValue + " != 'boolean') " + $valid + " = false; else { ";
      }
      out += " var i = " + $data + ".length , " + $valid + " = true , j; if (i > 1) { ";
      var $itemType = it.schema.items && it.schema.items.type, $typeIsArray = Array.isArray($itemType);
      if (!$itemType || $itemType == "object" || $itemType == "array" || $typeIsArray && ($itemType.indexOf("object") >= 0 || $itemType.indexOf("array") >= 0)) {
        out += " outer: for (;i--;) { for (j = i; j--;) { if (equal(" + $data + "[i], " + $data + "[j])) { " + $valid + " = false; break outer; } } } ";
      } else {
        out += " var itemIndices = {}, item; for (;i--;) { var item = " + $data + "[i]; ";
        var $method = "checkDataType" + ($typeIsArray ? "s" : "");
        out += " if (" + it.util[$method]($itemType, "item", it.opts.strictNumbers, true) + ") continue; ";
        if ($typeIsArray) {
          out += ` if (typeof item == 'string') item = '"' + item; `;
        }
        out += " if (typeof itemIndices[item] == 'number') { " + $valid + " = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ";
      }
      out += " } ";
      if ($isData) {
        out += "  }  ";
      }
      out += " if (!" + $valid + ") {   ";
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      if (it.createErrors !== false) {
        out += " { keyword: 'uniqueItems' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { i: i, j: j } ";
        if (it.opts.messages !== false) {
          out += " , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' ";
        }
        if (it.opts.verbose) {
          out += " , schema:  ";
          if ($isData) {
            out += "validate.schema" + $schemaPath;
          } else {
            out += "" + $schema2;
          }
          out += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError([" + __err + "]); ";
        } else {
          out += " validate.errors = [" + __err + "]; return false; ";
        }
      } else {
        out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      }
      out += " } ";
      if ($breakOnError) {
        out += " else { ";
      }
    } else {
      if ($breakOnError) {
        out += " if (true) { ";
      }
    }
    return out;
  };
  return uniqueItems;
}
var dotjs;
var hasRequiredDotjs;
function requireDotjs() {
  if (hasRequiredDotjs) return dotjs;
  hasRequiredDotjs = 1;
  dotjs = {
    "$ref": requireRef(),
    allOf: requireAllOf(),
    anyOf: requireAnyOf(),
    "$comment": requireComment(),
    const: require_const(),
    contains: requireContains(),
    dependencies: requireDependencies(),
    "enum": require_enum(),
    format: requireFormat(),
    "if": require_if(),
    items: requireItems(),
    maximum: require_limit(),
    minimum: require_limit(),
    maxItems: require_limitItems(),
    minItems: require_limitItems(),
    maxLength: require_limitLength(),
    minLength: require_limitLength(),
    maxProperties: require_limitProperties(),
    minProperties: require_limitProperties(),
    multipleOf: requireMultipleOf(),
    not: requireNot(),
    oneOf: requireOneOf(),
    pattern: requirePattern(),
    properties: requireProperties(),
    propertyNames: requirePropertyNames(),
    required: requireRequired(),
    uniqueItems: requireUniqueItems(),
    validate: requireValidate()
  };
  return dotjs;
}
var rules$3;
var hasRequiredRules$2;
function requireRules$2() {
  if (hasRequiredRules$2) return rules$3;
  hasRequiredRules$2 = 1;
  var ruleModules = requireDotjs(), toHash = requireUtil().toHash;
  rules$3 = function rules2() {
    var RULES = [
      {
        type: "number",
        rules: [
          { "maximum": ["exclusiveMaximum"] },
          { "minimum": ["exclusiveMinimum"] },
          "multipleOf",
          "format"
        ]
      },
      {
        type: "string",
        rules: ["maxLength", "minLength", "pattern", "format"]
      },
      {
        type: "array",
        rules: ["maxItems", "minItems", "items", "contains", "uniqueItems"]
      },
      {
        type: "object",
        rules: [
          "maxProperties",
          "minProperties",
          "required",
          "dependencies",
          "propertyNames",
          { "properties": ["additionalProperties", "patternProperties"] }
        ]
      },
      { rules: ["$ref", "const", "enum", "not", "anyOf", "oneOf", "allOf", "if"] }
    ];
    var ALL = ["type", "$comment"];
    var KEYWORDS = [
      "$schema",
      "$id",
      "id",
      "$data",
      "$async",
      "title",
      "description",
      "default",
      "definitions",
      "examples",
      "readOnly",
      "writeOnly",
      "contentMediaType",
      "contentEncoding",
      "additionalItems",
      "then",
      "else"
    ];
    var TYPES = ["number", "integer", "string", "array", "object", "boolean", "null"];
    RULES.all = toHash(ALL);
    RULES.types = toHash(TYPES);
    RULES.forEach(function(group) {
      group.rules = group.rules.map(function(keyword2) {
        var implKeywords;
        if (typeof keyword2 == "object") {
          var key = Object.keys(keyword2)[0];
          implKeywords = keyword2[key];
          keyword2 = key;
          implKeywords.forEach(function(k) {
            ALL.push(k);
            RULES.all[k] = true;
          });
        }
        ALL.push(keyword2);
        var rule = RULES.all[keyword2] = {
          keyword: keyword2,
          code: ruleModules[keyword2],
          implements: implKeywords
        };
        return rule;
      });
      RULES.all.$comment = {
        keyword: "$comment",
        code: ruleModules.$comment
      };
      if (group.type) RULES.types[group.type] = group;
    });
    RULES.keywords = toHash(ALL.concat(KEYWORDS));
    RULES.custom = {};
    return RULES;
  };
  return rules$3;
}
var data;
var hasRequiredData;
function requireData() {
  if (hasRequiredData) return data;
  hasRequiredData = 1;
  var KEYWORDS = [
    "multipleOf",
    "maximum",
    "exclusiveMaximum",
    "minimum",
    "exclusiveMinimum",
    "maxLength",
    "minLength",
    "pattern",
    "additionalItems",
    "maxItems",
    "minItems",
    "uniqueItems",
    "maxProperties",
    "minProperties",
    "required",
    "additionalProperties",
    "enum",
    "format",
    "const"
  ];
  data = function(metaSchema, keywordsJsonPointers) {
    for (var i2 = 0; i2 < keywordsJsonPointers.length; i2++) {
      metaSchema = JSON.parse(JSON.stringify(metaSchema));
      var segments = keywordsJsonPointers[i2].split("/");
      var keywords2 = metaSchema;
      var j;
      for (j = 1; j < segments.length; j++)
        keywords2 = keywords2[segments[j]];
      for (j = 0; j < KEYWORDS.length; j++) {
        var key = KEYWORDS[j];
        var schema = keywords2[key];
        if (schema) {
          keywords2[key] = {
            anyOf: [
              schema,
              { $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#" }
            ]
          };
        }
      }
    }
    return metaSchema;
  };
  return data;
}
var async;
var hasRequiredAsync;
function requireAsync() {
  if (hasRequiredAsync) return async;
  hasRequiredAsync = 1;
  var MissingRefError = requireError_classes().MissingRef;
  async = compileAsync;
  function compileAsync(schema, meta, callback) {
    var self2 = this;
    if (typeof this._opts.loadSchema != "function")
      throw new Error("options.loadSchema should be a function");
    if (typeof meta == "function") {
      callback = meta;
      meta = void 0;
    }
    var p2 = loadMetaSchemaOf(schema).then(function() {
      var schemaObj = self2._addSchema(schema, void 0, meta);
      return schemaObj.validate || _compileAsync(schemaObj);
    });
    if (callback) {
      p2.then(
        function(v2) {
          callback(null, v2);
        },
        callback
      );
    }
    return p2;
    function loadMetaSchemaOf(sch) {
      var $schema2 = sch.$schema;
      return $schema2 && !self2.getSchema($schema2) ? compileAsync.call(self2, { $ref: $schema2 }, true) : Promise.resolve();
    }
    function _compileAsync(schemaObj) {
      try {
        return self2._compile(schemaObj);
      } catch (e2) {
        if (e2 instanceof MissingRefError) return loadMissingSchema(e2);
        throw e2;
      }
      function loadMissingSchema(e2) {
        var ref2 = e2.missingSchema;
        if (added(ref2)) throw new Error("Schema " + ref2 + " is loaded but " + e2.missingRef + " cannot be resolved");
        var schemaPromise = self2._loadingSchemas[ref2];
        if (!schemaPromise) {
          schemaPromise = self2._loadingSchemas[ref2] = self2._opts.loadSchema(ref2);
          schemaPromise.then(removePromise, removePromise);
        }
        return schemaPromise.then(function(sch) {
          if (!added(ref2)) {
            return loadMetaSchemaOf(sch).then(function() {
              if (!added(ref2)) self2.addSchema(sch, ref2, void 0, meta);
            });
          }
        }).then(function() {
          return _compileAsync(schemaObj);
        });
        function removePromise() {
          delete self2._loadingSchemas[ref2];
        }
        function added(ref3) {
          return self2._refs[ref3] || self2._schemas[ref3];
        }
      }
    }
  }
  return async;
}
var custom;
var hasRequiredCustom;
function requireCustom() {
  if (hasRequiredCustom) return custom;
  hasRequiredCustom = 1;
  custom = function generate_custom(it, $keyword, $ruleType) {
    var out = " ";
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema2 = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = "data" + ($dataLvl || "");
    var $valid = "valid" + $lvl;
    var $errs = "errs__" + $lvl;
    var $isData = it.opts.$data && $schema2 && $schema2.$data, $schemaValue;
    if ($isData) {
      out += " var schema" + $lvl + " = " + it.util.getData($schema2.$data, $dataLvl, it.dataPathArr) + "; ";
      $schemaValue = "schema" + $lvl;
    } else {
      $schemaValue = $schema2;
    }
    var $rule = this, $definition = "definition" + $lvl, $rDef = $rule.definition, $closingBraces = "";
    var $compile, $inline, $macro, $ruleValidate, $validateCode;
    if ($isData && $rDef.$data) {
      $validateCode = "keywordValidate" + $lvl;
      var $validateSchema = $rDef.validateSchema;
      out += " var " + $definition + " = RULES.custom['" + $keyword + "'].definition; var " + $validateCode + " = " + $definition + ".validate;";
    } else {
      $ruleValidate = it.useCustomRule($rule, $schema2, it.schema, it);
      if (!$ruleValidate) return;
      $schemaValue = "validate.schema" + $schemaPath;
      $validateCode = $ruleValidate.code;
      $compile = $rDef.compile;
      $inline = $rDef.inline;
      $macro = $rDef.macro;
    }
    var $ruleErrs = $validateCode + ".errors", $i = "i" + $lvl, $ruleErr = "ruleErr" + $lvl, $asyncKeyword = $rDef.async;
    if ($asyncKeyword && !it.async) throw new Error("async keyword in sync schema");
    if (!($inline || $macro)) {
      out += "" + $ruleErrs + " = null;";
    }
    out += "var " + $errs + " = errors;var " + $valid + ";";
    if ($isData && $rDef.$data) {
      $closingBraces += "}";
      out += " if (" + $schemaValue + " === undefined) { " + $valid + " = true; } else { ";
      if ($validateSchema) {
        $closingBraces += "}";
        out += " " + $valid + " = " + $definition + ".validateSchema(" + $schemaValue + "); if (" + $valid + ") { ";
      }
    }
    if ($inline) {
      if ($rDef.statements) {
        out += " " + $ruleValidate.validate + " ";
      } else {
        out += " " + $valid + " = " + $ruleValidate.validate + "; ";
      }
    } else if ($macro) {
      var $it = it.util.copy(it);
      var $closingBraces = "";
      $it.level++;
      var $nextValid = "valid" + $it.level;
      $it.schema = $ruleValidate.validate;
      $it.schemaPath = "";
      var $wasComposite = it.compositeRule;
      it.compositeRule = $it.compositeRule = true;
      var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
      it.compositeRule = $it.compositeRule = $wasComposite;
      out += " " + $code;
    } else {
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      out += "  " + $validateCode + ".call( ";
      if (it.opts.passContext) {
        out += "this";
      } else {
        out += "self";
      }
      if ($compile || $rDef.schema === false) {
        out += " , " + $data + " ";
      } else {
        out += " , " + $schemaValue + " , " + $data + " , validate.schema" + it.schemaPath + " ";
      }
      out += " , (dataPath || '')";
      if (it.errorPath != '""') {
        out += " + " + it.errorPath;
      }
      var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
      out += " , " + $parentData + " , " + $parentDataProperty + " , rootData )  ";
      var def_callRuleValidate = out;
      out = $$outStack.pop();
      if ($rDef.errors === false) {
        out += " " + $valid + " = ";
        if ($asyncKeyword) {
          out += "await ";
        }
        out += "" + def_callRuleValidate + "; ";
      } else {
        if ($asyncKeyword) {
          $ruleErrs = "customErrors" + $lvl;
          out += " var " + $ruleErrs + " = null; try { " + $valid + " = await " + def_callRuleValidate + "; } catch (e) { " + $valid + " = false; if (e instanceof ValidationError) " + $ruleErrs + " = e.errors; else throw e; } ";
        } else {
          out += " " + $ruleErrs + " = null; " + $valid + " = " + def_callRuleValidate + "; ";
        }
      }
    }
    if ($rDef.modifying) {
      out += " if (" + $parentData + ") " + $data + " = " + $parentData + "[" + $parentDataProperty + "];";
    }
    out += "" + $closingBraces;
    if ($rDef.valid) {
      if ($breakOnError) {
        out += " if (true) { ";
      }
    } else {
      out += " if ( ";
      if ($rDef.valid === void 0) {
        out += " !";
        if ($macro) {
          out += "" + $nextValid;
        } else {
          out += "" + $valid;
        }
      } else {
        out += " " + !$rDef.valid + " ";
      }
      out += ") { ";
      $errorKeyword = $rule.keyword;
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = "";
      if (it.createErrors !== false) {
        out += " { keyword: '" + ($errorKeyword || "custom") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { keyword: '" + $rule.keyword + "' } ";
        if (it.opts.messages !== false) {
          out += ` , message: 'should pass "` + $rule.keyword + `" keyword validation' `;
        }
        if (it.opts.verbose) {
          out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
        }
        out += " } ";
      } else {
        out += " {} ";
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        if (it.async) {
          out += " throw new ValidationError([" + __err + "]); ";
        } else {
          out += " validate.errors = [" + __err + "]; return false; ";
        }
      } else {
        out += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
      }
      var def_customError = out;
      out = $$outStack.pop();
      if ($inline) {
        if ($rDef.errors) {
          if ($rDef.errors != "full") {
            out += "  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + "; if (" + $ruleErr + ".schemaPath === undefined) { " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '"; } ';
            if (it.opts.verbose) {
              out += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
            }
            out += " } ";
          }
        } else {
          if ($rDef.errors === false) {
            out += " " + def_customError + " ";
          } else {
            out += " if (" + $errs + " == errors) { " + def_customError + " } else {  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + "; if (" + $ruleErr + ".schemaPath === undefined) { " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '"; } ';
            if (it.opts.verbose) {
              out += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
            }
            out += " } } ";
          }
        }
      } else if ($macro) {
        out += "   var err =   ";
        if (it.createErrors !== false) {
          out += " { keyword: '" + ($errorKeyword || "custom") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { keyword: '" + $rule.keyword + "' } ";
          if (it.opts.messages !== false) {
            out += ` , message: 'should pass "` + $rule.keyword + `" keyword validation' `;
          }
          if (it.opts.verbose) {
            out += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out += " } ";
        } else {
          out += " {} ";
        }
        out += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out += " throw new ValidationError(vErrors); ";
          } else {
            out += " validate.errors = vErrors; return false; ";
          }
        }
      } else {
        if ($rDef.errors === false) {
          out += " " + def_customError + " ";
        } else {
          out += " if (Array.isArray(" + $ruleErrs + ")) { if (vErrors === null) vErrors = " + $ruleErrs + "; else vErrors = vErrors.concat(" + $ruleErrs + "); errors = vErrors.length;  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + ";  " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '";  ';
          if (it.opts.verbose) {
            out += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
          }
          out += " } } else { " + def_customError + " } ";
        }
      }
      out += " } ";
      if ($breakOnError) {
        out += " else { ";
      }
    }
    return out;
  };
  return custom;
}
var $schema$2 = "http://json-schema.org/draft-07/schema#";
var $id$1 = "http://json-schema.org/draft-07/schema#";
var title = "Core schema meta-schema";
var definitions$1 = {
  schemaArray: {
    type: "array",
    minItems: 1,
    items: {
      $ref: "#"
    }
  },
  nonNegativeInteger: {
    type: "integer",
    minimum: 0
  },
  nonNegativeIntegerDefault0: {
    allOf: [
      {
        $ref: "#/definitions/nonNegativeInteger"
      },
      {
        "default": 0
      }
    ]
  },
  simpleTypes: {
    "enum": [
      "array",
      "boolean",
      "integer",
      "null",
      "number",
      "object",
      "string"
    ]
  },
  stringArray: {
    type: "array",
    items: {
      type: "string"
    },
    uniqueItems: true,
    "default": []
  }
};
var type$2 = [
  "object",
  "boolean"
];
var properties$2 = {
  $id: {
    type: "string",
    format: "uri-reference"
  },
  $schema: {
    type: "string",
    format: "uri"
  },
  $ref: {
    type: "string",
    format: "uri-reference"
  },
  $comment: {
    type: "string"
  },
  title: {
    type: "string"
  },
  description: {
    type: "string"
  },
  "default": true,
  readOnly: {
    type: "boolean",
    "default": false
  },
  examples: {
    type: "array",
    items: true
  },
  multipleOf: {
    type: "number",
    exclusiveMinimum: 0
  },
  maximum: {
    type: "number"
  },
  exclusiveMaximum: {
    type: "number"
  },
  minimum: {
    type: "number"
  },
  exclusiveMinimum: {
    type: "number"
  },
  maxLength: {
    $ref: "#/definitions/nonNegativeInteger"
  },
  minLength: {
    $ref: "#/definitions/nonNegativeIntegerDefault0"
  },
  pattern: {
    type: "string",
    format: "regex"
  },
  additionalItems: {
    $ref: "#"
  },
  items: {
    anyOf: [
      {
        $ref: "#"
      },
      {
        $ref: "#/definitions/schemaArray"
      }
    ],
    "default": true
  },
  maxItems: {
    $ref: "#/definitions/nonNegativeInteger"
  },
  minItems: {
    $ref: "#/definitions/nonNegativeIntegerDefault0"
  },
  uniqueItems: {
    type: "boolean",
    "default": false
  },
  contains: {
    $ref: "#"
  },
  maxProperties: {
    $ref: "#/definitions/nonNegativeInteger"
  },
  minProperties: {
    $ref: "#/definitions/nonNegativeIntegerDefault0"
  },
  required: {
    $ref: "#/definitions/stringArray"
  },
  additionalProperties: {
    $ref: "#"
  },
  definitions: {
    type: "object",
    additionalProperties: {
      $ref: "#"
    },
    "default": {}
  },
  properties: {
    type: "object",
    additionalProperties: {
      $ref: "#"
    },
    "default": {}
  },
  patternProperties: {
    type: "object",
    additionalProperties: {
      $ref: "#"
    },
    propertyNames: {
      format: "regex"
    },
    "default": {}
  },
  dependencies: {
    type: "object",
    additionalProperties: {
      anyOf: [
        {
          $ref: "#"
        },
        {
          $ref: "#/definitions/stringArray"
        }
      ]
    }
  },
  propertyNames: {
    $ref: "#"
  },
  "const": true,
  "enum": {
    type: "array",
    items: true,
    minItems: 1,
    uniqueItems: true
  },
  type: {
    anyOf: [
      {
        $ref: "#/definitions/simpleTypes"
      },
      {
        type: "array",
        items: {
          $ref: "#/definitions/simpleTypes"
        },
        minItems: 1,
        uniqueItems: true
      }
    ]
  },
  format: {
    type: "string"
  },
  contentMediaType: {
    type: "string"
  },
  contentEncoding: {
    type: "string"
  },
  "if": {
    $ref: "#"
  },
  then: {
    $ref: "#"
  },
  "else": {
    $ref: "#"
  },
  allOf: {
    $ref: "#/definitions/schemaArray"
  },
  anyOf: {
    $ref: "#/definitions/schemaArray"
  },
  oneOf: {
    $ref: "#/definitions/schemaArray"
  },
  not: {
    $ref: "#"
  }
};
var require$$13 = {
  $schema: $schema$2,
  $id: $id$1,
  title,
  definitions: definitions$1,
  type: type$2,
  properties: properties$2,
  "default": true
};
var definition_schema;
var hasRequiredDefinition_schema;
function requireDefinition_schema() {
  if (hasRequiredDefinition_schema) return definition_schema;
  hasRequiredDefinition_schema = 1;
  var metaSchema = require$$13;
  definition_schema = {
    $id: "https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",
    definitions: {
      simpleTypes: metaSchema.definitions.simpleTypes
    },
    type: "object",
    dependencies: {
      schema: ["validate"],
      $data: ["validate"],
      statements: ["inline"],
      valid: { not: { required: ["macro"] } }
    },
    properties: {
      type: metaSchema.properties.type,
      schema: { type: "boolean" },
      statements: { type: "boolean" },
      dependencies: {
        type: "array",
        items: { type: "string" }
      },
      metaSchema: { type: "object" },
      modifying: { type: "boolean" },
      valid: { type: "boolean" },
      $data: { type: "boolean" },
      async: { type: "boolean" },
      errors: {
        anyOf: [
          { type: "boolean" },
          { const: "full" }
        ]
      }
    }
  };
  return definition_schema;
}
var keyword$1;
var hasRequiredKeyword$1;
function requireKeyword$1() {
  if (hasRequiredKeyword$1) return keyword$1;
  hasRequiredKeyword$1 = 1;
  var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
  var customRuleCode = requireCustom();
  var definitionSchema = requireDefinition_schema();
  keyword$1 = {
    add: addKeyword,
    get: getKeyword,
    remove: removeKeyword,
    validate: validateKeyword
  };
  function addKeyword(keyword2, definition) {
    var RULES = this.RULES;
    if (RULES.keywords[keyword2])
      throw new Error("Keyword " + keyword2 + " is already defined");
    if (!IDENTIFIER.test(keyword2))
      throw new Error("Keyword " + keyword2 + " is not a valid identifier");
    if (definition) {
      this.validateKeyword(definition, true);
      var dataType = definition.type;
      if (Array.isArray(dataType)) {
        for (var i2 = 0; i2 < dataType.length; i2++)
          _addRule(keyword2, dataType[i2], definition);
      } else {
        _addRule(keyword2, dataType, definition);
      }
      var metaSchema = definition.metaSchema;
      if (metaSchema) {
        if (definition.$data && this._opts.$data) {
          metaSchema = {
            anyOf: [
              metaSchema,
              { "$ref": "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#" }
            ]
          };
        }
        definition.validateSchema = this.compile(metaSchema, true);
      }
    }
    RULES.keywords[keyword2] = RULES.all[keyword2] = true;
    function _addRule(keyword3, dataType2, definition2) {
      var ruleGroup;
      for (var i3 = 0; i3 < RULES.length; i3++) {
        var rg = RULES[i3];
        if (rg.type == dataType2) {
          ruleGroup = rg;
          break;
        }
      }
      if (!ruleGroup) {
        ruleGroup = { type: dataType2, rules: [] };
        RULES.push(ruleGroup);
      }
      var rule = {
        keyword: keyword3,
        definition: definition2,
        custom: true,
        code: customRuleCode,
        implements: definition2.implements
      };
      ruleGroup.rules.push(rule);
      RULES.custom[keyword3] = rule;
    }
    return this;
  }
  function getKeyword(keyword2) {
    var rule = this.RULES.custom[keyword2];
    return rule ? rule.definition : this.RULES.keywords[keyword2] || false;
  }
  function removeKeyword(keyword2) {
    var RULES = this.RULES;
    delete RULES.keywords[keyword2];
    delete RULES.all[keyword2];
    delete RULES.custom[keyword2];
    for (var i2 = 0; i2 < RULES.length; i2++) {
      var rules2 = RULES[i2].rules;
      for (var j = 0; j < rules2.length; j++) {
        if (rules2[j].keyword == keyword2) {
          rules2.splice(j, 1);
          break;
        }
      }
    }
    return this;
  }
  function validateKeyword(definition, throwError) {
    validateKeyword.errors = null;
    var v2 = this._validateKeyword = this._validateKeyword || this.compile(definitionSchema, true);
    if (v2(definition)) return true;
    validateKeyword.errors = v2.errors;
    if (throwError)
      throw new Error("custom keyword definition is invalid: " + this.errorsText(v2.errors));
    else
      return false;
  }
  return keyword$1;
}
var $schema$1 = "http://json-schema.org/draft-07/schema#";
var $id = "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#";
var description$1 = "Meta-schema for $data reference (JSON Schema extension proposal)";
var type$1 = "object";
var required = [
  "$data"
];
var properties$1 = {
  $data: {
    type: "string",
    anyOf: [
      {
        format: "relative-json-pointer"
      },
      {
        format: "json-pointer"
      }
    ]
  }
};
var additionalProperties = false;
var require$$12 = {
  $schema: $schema$1,
  $id,
  description: description$1,
  type: type$1,
  required,
  properties: properties$1,
  additionalProperties
};
var ajv$1;
var hasRequiredAjv$1;
function requireAjv$1() {
  if (hasRequiredAjv$1) return ajv$1;
  hasRequiredAjv$1 = 1;
  var compileSchema = requireCompile(), resolve2 = requireResolve(), Cache = requireCache(), SchemaObject = requireSchema_obj(), stableStringify = requireFastJsonStableStringify(), formats = requireFormats(), rules2 = requireRules$2(), $dataMetaSchema = requireData(), util2 = requireUtil();
  ajv$1 = Ajv;
  Ajv.prototype.validate = validate2;
  Ajv.prototype.compile = compile;
  Ajv.prototype.addSchema = addSchema;
  Ajv.prototype.addMetaSchema = addMetaSchema;
  Ajv.prototype.validateSchema = validateSchema;
  Ajv.prototype.getSchema = getSchema;
  Ajv.prototype.removeSchema = removeSchema;
  Ajv.prototype.addFormat = addFormat;
  Ajv.prototype.errorsText = errorsText;
  Ajv.prototype._addSchema = _addSchema;
  Ajv.prototype._compile = _compile;
  Ajv.prototype.compileAsync = requireAsync();
  var customKeyword = requireKeyword$1();
  Ajv.prototype.addKeyword = customKeyword.add;
  Ajv.prototype.getKeyword = customKeyword.get;
  Ajv.prototype.removeKeyword = customKeyword.remove;
  Ajv.prototype.validateKeyword = customKeyword.validate;
  var errorClasses = requireError_classes();
  Ajv.ValidationError = errorClasses.Validation;
  Ajv.MissingRefError = errorClasses.MissingRef;
  Ajv.$dataMetaSchema = $dataMetaSchema;
  var META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
  var META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes", "strictDefaults"];
  var META_SUPPORT_DATA = ["/properties"];
  function Ajv(opts) {
    if (!(this instanceof Ajv)) return new Ajv(opts);
    opts = this._opts = util2.copy(opts) || {};
    setLogger(this);
    this._schemas = {};
    this._refs = {};
    this._fragments = {};
    this._formats = formats(opts.format);
    this._cache = opts.cache || new Cache();
    this._loadingSchemas = {};
    this._compilations = [];
    this.RULES = rules2();
    this._getId = chooseGetId(opts);
    opts.loopRequired = opts.loopRequired || Infinity;
    if (opts.errorDataPath == "property") opts._errorDataPathProperty = true;
    if (opts.serialize === void 0) opts.serialize = stableStringify;
    this._metaOpts = getMetaSchemaOptions(this);
    if (opts.formats) addInitialFormats(this);
    if (opts.keywords) addInitialKeywords(this);
    addDefaultMetaSchema(this);
    if (typeof opts.meta == "object") this.addMetaSchema(opts.meta);
    if (opts.nullable) this.addKeyword("nullable", { metaSchema: { type: "boolean" } });
    addInitialSchemas(this);
  }
  function validate2(schemaKeyRef, data2) {
    var v2;
    if (typeof schemaKeyRef == "string") {
      v2 = this.getSchema(schemaKeyRef);
      if (!v2) throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
    } else {
      var schemaObj = this._addSchema(schemaKeyRef);
      v2 = schemaObj.validate || this._compile(schemaObj);
    }
    var valid = v2(data2);
    if (v2.$async !== true) this.errors = v2.errors;
    return valid;
  }
  function compile(schema, _meta) {
    var schemaObj = this._addSchema(schema, void 0, _meta);
    return schemaObj.validate || this._compile(schemaObj);
  }
  function addSchema(schema, key, _skipValidation, _meta) {
    if (Array.isArray(schema)) {
      for (var i2 = 0; i2 < schema.length; i2++) this.addSchema(schema[i2], void 0, _skipValidation, _meta);
      return this;
    }
    var id2 = this._getId(schema);
    if (id2 !== void 0 && typeof id2 != "string")
      throw new Error("schema id must be string");
    key = resolve2.normalizeId(key || id2);
    checkUnique(this, key);
    this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
    return this;
  }
  function addMetaSchema(schema, key, skipValidation) {
    this.addSchema(schema, key, skipValidation, true);
    return this;
  }
  function validateSchema(schema, throwOrLogError) {
    var $schema2 = schema.$schema;
    if ($schema2 !== void 0 && typeof $schema2 != "string")
      throw new Error("$schema must be a string");
    $schema2 = $schema2 || this._opts.defaultMeta || defaultMeta(this);
    if (!$schema2) {
      this.logger.warn("meta-schema not available");
      this.errors = null;
      return true;
    }
    var valid = this.validate($schema2, schema);
    if (!valid && throwOrLogError) {
      var message = "schema is invalid: " + this.errorsText();
      if (this._opts.validateSchema == "log") this.logger.error(message);
      else throw new Error(message);
    }
    return valid;
  }
  function defaultMeta(self2) {
    var meta = self2._opts.meta;
    self2._opts.defaultMeta = typeof meta == "object" ? self2._getId(meta) || meta : self2.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : void 0;
    return self2._opts.defaultMeta;
  }
  function getSchema(keyRef) {
    var schemaObj = _getSchemaObj(this, keyRef);
    switch (typeof schemaObj) {
      case "object":
        return schemaObj.validate || this._compile(schemaObj);
      case "string":
        return this.getSchema(schemaObj);
      case "undefined":
        return _getSchemaFragment(this, keyRef);
    }
  }
  function _getSchemaFragment(self2, ref2) {
    var res = resolve2.schema.call(self2, { schema: {} }, ref2);
    if (res) {
      var schema = res.schema, root = res.root, baseId = res.baseId;
      var v2 = compileSchema.call(self2, schema, root, void 0, baseId);
      self2._fragments[ref2] = new SchemaObject({
        ref: ref2,
        fragment: true,
        schema,
        root,
        baseId,
        validate: v2
      });
      return v2;
    }
  }
  function _getSchemaObj(self2, keyRef) {
    keyRef = resolve2.normalizeId(keyRef);
    return self2._schemas[keyRef] || self2._refs[keyRef] || self2._fragments[keyRef];
  }
  function removeSchema(schemaKeyRef) {
    if (schemaKeyRef instanceof RegExp) {
      _removeAllSchemas(this, this._schemas, schemaKeyRef);
      _removeAllSchemas(this, this._refs, schemaKeyRef);
      return this;
    }
    switch (typeof schemaKeyRef) {
      case "undefined":
        _removeAllSchemas(this, this._schemas);
        _removeAllSchemas(this, this._refs);
        this._cache.clear();
        return this;
      case "string":
        var schemaObj = _getSchemaObj(this, schemaKeyRef);
        if (schemaObj) this._cache.del(schemaObj.cacheKey);
        delete this._schemas[schemaKeyRef];
        delete this._refs[schemaKeyRef];
        return this;
      case "object":
        var serialize = this._opts.serialize;
        var cacheKey = serialize ? serialize(schemaKeyRef) : schemaKeyRef;
        this._cache.del(cacheKey);
        var id2 = this._getId(schemaKeyRef);
        if (id2) {
          id2 = resolve2.normalizeId(id2);
          delete this._schemas[id2];
          delete this._refs[id2];
        }
    }
    return this;
  }
  function _removeAllSchemas(self2, schemas, regex) {
    for (var keyRef in schemas) {
      var schemaObj = schemas[keyRef];
      if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
        self2._cache.del(schemaObj.cacheKey);
        delete schemas[keyRef];
      }
    }
  }
  function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
    if (typeof schema != "object" && typeof schema != "boolean")
      throw new Error("schema should be object or boolean");
    var serialize = this._opts.serialize;
    var cacheKey = serialize ? serialize(schema) : schema;
    var cached = this._cache.get(cacheKey);
    if (cached) return cached;
    shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;
    var id2 = resolve2.normalizeId(this._getId(schema));
    if (id2 && shouldAddSchema) checkUnique(this, id2);
    var willValidate = this._opts.validateSchema !== false && !skipValidation;
    var recursiveMeta;
    if (willValidate && !(recursiveMeta = id2 && id2 == resolve2.normalizeId(schema.$schema)))
      this.validateSchema(schema, true);
    var localRefs = resolve2.ids.call(this, schema);
    var schemaObj = new SchemaObject({
      id: id2,
      schema,
      localRefs,
      cacheKey,
      meta
    });
    if (id2[0] != "#" && shouldAddSchema) this._refs[id2] = schemaObj;
    this._cache.put(cacheKey, schemaObj);
    if (willValidate && recursiveMeta) this.validateSchema(schema, true);
    return schemaObj;
  }
  function _compile(schemaObj, root) {
    if (schemaObj.compiling) {
      schemaObj.validate = callValidate;
      callValidate.schema = schemaObj.schema;
      callValidate.errors = null;
      callValidate.root = root ? root : callValidate;
      if (schemaObj.schema.$async === true)
        callValidate.$async = true;
      return callValidate;
    }
    schemaObj.compiling = true;
    var currentOpts;
    if (schemaObj.meta) {
      currentOpts = this._opts;
      this._opts = this._metaOpts;
    }
    var v2;
    try {
      v2 = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs);
    } catch (e2) {
      delete schemaObj.validate;
      throw e2;
    } finally {
      schemaObj.compiling = false;
      if (schemaObj.meta) this._opts = currentOpts;
    }
    schemaObj.validate = v2;
    schemaObj.refs = v2.refs;
    schemaObj.refVal = v2.refVal;
    schemaObj.root = v2.root;
    return v2;
    function callValidate() {
      var _validate = schemaObj.validate;
      var result = _validate.apply(this, arguments);
      callValidate.errors = _validate.errors;
      return result;
    }
  }
  function chooseGetId(opts) {
    switch (opts.schemaId) {
      case "auto":
        return _get$IdOrId;
      case "id":
        return _getId;
      default:
        return _get$Id;
    }
  }
  function _getId(schema) {
    if (schema.$id) this.logger.warn("schema $id ignored", schema.$id);
    return schema.id;
  }
  function _get$Id(schema) {
    if (schema.id) this.logger.warn("schema id ignored", schema.id);
    return schema.$id;
  }
  function _get$IdOrId(schema) {
    if (schema.$id && schema.id && schema.$id != schema.id)
      throw new Error("schema $id is different from id");
    return schema.$id || schema.id;
  }
  function errorsText(errors, options) {
    errors = errors || this.errors;
    if (!errors) return "No errors";
    options = options || {};
    var separator = options.separator === void 0 ? ", " : options.separator;
    var dataVar = options.dataVar === void 0 ? "data" : options.dataVar;
    var text = "";
    for (var i2 = 0; i2 < errors.length; i2++) {
      var e2 = errors[i2];
      if (e2) text += dataVar + e2.dataPath + " " + e2.message + separator;
    }
    return text.slice(0, -separator.length);
  }
  function addFormat(name, format2) {
    if (typeof format2 == "string") format2 = new RegExp(format2);
    this._formats[name] = format2;
    return this;
  }
  function addDefaultMetaSchema(self2) {
    var $dataSchema;
    if (self2._opts.$data) {
      $dataSchema = require$$12;
      self2.addMetaSchema($dataSchema, $dataSchema.$id, true);
    }
    if (self2._opts.meta === false) return;
    var metaSchema = require$$13;
    if (self2._opts.$data) metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
    self2.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
    self2._refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
  }
  function addInitialSchemas(self2) {
    var optsSchemas = self2._opts.schemas;
    if (!optsSchemas) return;
    if (Array.isArray(optsSchemas)) self2.addSchema(optsSchemas);
    else for (var key in optsSchemas) self2.addSchema(optsSchemas[key], key);
  }
  function addInitialFormats(self2) {
    for (var name in self2._opts.formats) {
      var format2 = self2._opts.formats[name];
      self2.addFormat(name, format2);
    }
  }
  function addInitialKeywords(self2) {
    for (var name in self2._opts.keywords) {
      var keyword2 = self2._opts.keywords[name];
      self2.addKeyword(name, keyword2);
    }
  }
  function checkUnique(self2, id2) {
    if (self2._schemas[id2] || self2._refs[id2])
      throw new Error('schema with key or id "' + id2 + '" already exists');
  }
  function getMetaSchemaOptions(self2) {
    var metaOpts = util2.copy(self2._opts);
    for (var i2 = 0; i2 < META_IGNORE_OPTIONS.length; i2++)
      delete metaOpts[META_IGNORE_OPTIONS[i2]];
    return metaOpts;
  }
  function setLogger(self2) {
    var logger = self2._opts.logger;
    if (logger === false) {
      self2.logger = { log: noop2, warn: noop2, error: noop2 };
    } else {
      if (logger === void 0) logger = console;
      if (!(typeof logger == "object" && logger.log && logger.warn && logger.error))
        throw new Error("logger must implement log, warn and error methods");
      self2.logger = logger;
    }
  }
  function noop2() {
  }
  return ajv$1;
}
var builtin = {
  AggregateError: false,
  "Array": false,
  "ArrayBuffer": false,
  Atomics: false,
  BigInt: false,
  BigInt64Array: false,
  BigUint64Array: false,
  "Boolean": false,
  constructor: false,
  "DataView": false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  FinalizationRegistry: false,
  "Float32Array": false,
  "Float64Array": false,
  "Function": false,
  globalThis: false,
  hasOwnProperty: false,
  "Infinity": false,
  "Int16Array": false,
  "Int32Array": false,
  "Int8Array": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Map": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  "Promise": false,
  propertyIsEnumerable: false,
  "Proxy": false,
  "RangeError": false,
  "ReferenceError": false,
  "Reflect": false,
  "RegExp": false,
  "Set": false,
  SharedArrayBuffer: false,
  "String": false,
  "Symbol": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "Uint16Array": false,
  "Uint32Array": false,
  "Uint8Array": false,
  "Uint8ClampedArray": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false,
  "WeakMap": false,
  WeakRef: false,
  "WeakSet": false
};
var es5 = {
  "Array": false,
  "Boolean": false,
  constructor: false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  "Function": false,
  hasOwnProperty: false,
  "Infinity": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  propertyIsEnumerable: false,
  "RangeError": false,
  "ReferenceError": false,
  "RegExp": false,
  "String": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false
};
var es2015 = {
  "Array": false,
  "ArrayBuffer": false,
  "Boolean": false,
  constructor: false,
  "DataView": false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  "Float32Array": false,
  "Float64Array": false,
  "Function": false,
  hasOwnProperty: false,
  "Infinity": false,
  "Int16Array": false,
  "Int32Array": false,
  "Int8Array": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Map": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  "Promise": false,
  propertyIsEnumerable: false,
  "Proxy": false,
  "RangeError": false,
  "ReferenceError": false,
  "Reflect": false,
  "RegExp": false,
  "Set": false,
  "String": false,
  "Symbol": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "Uint16Array": false,
  "Uint32Array": false,
  "Uint8Array": false,
  "Uint8ClampedArray": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false,
  "WeakMap": false,
  "WeakSet": false
};
var es2017 = {
  "Array": false,
  "ArrayBuffer": false,
  Atomics: false,
  "Boolean": false,
  constructor: false,
  "DataView": false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  "Float32Array": false,
  "Float64Array": false,
  "Function": false,
  hasOwnProperty: false,
  "Infinity": false,
  "Int16Array": false,
  "Int32Array": false,
  "Int8Array": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Map": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  "Promise": false,
  propertyIsEnumerable: false,
  "Proxy": false,
  "RangeError": false,
  "ReferenceError": false,
  "Reflect": false,
  "RegExp": false,
  "Set": false,
  SharedArrayBuffer: false,
  "String": false,
  "Symbol": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "Uint16Array": false,
  "Uint32Array": false,
  "Uint8Array": false,
  "Uint8ClampedArray": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false,
  "WeakMap": false,
  "WeakSet": false
};
var es2020 = {
  "Array": false,
  "ArrayBuffer": false,
  Atomics: false,
  BigInt: false,
  BigInt64Array: false,
  BigUint64Array: false,
  "Boolean": false,
  constructor: false,
  "DataView": false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  "Float32Array": false,
  "Float64Array": false,
  "Function": false,
  globalThis: false,
  hasOwnProperty: false,
  "Infinity": false,
  "Int16Array": false,
  "Int32Array": false,
  "Int8Array": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Map": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  "Promise": false,
  propertyIsEnumerable: false,
  "Proxy": false,
  "RangeError": false,
  "ReferenceError": false,
  "Reflect": false,
  "RegExp": false,
  "Set": false,
  SharedArrayBuffer: false,
  "String": false,
  "Symbol": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "Uint16Array": false,
  "Uint32Array": false,
  "Uint8Array": false,
  "Uint8ClampedArray": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false,
  "WeakMap": false,
  "WeakSet": false
};
var es2021 = {
  AggregateError: false,
  "Array": false,
  "ArrayBuffer": false,
  Atomics: false,
  BigInt: false,
  BigInt64Array: false,
  BigUint64Array: false,
  "Boolean": false,
  constructor: false,
  "DataView": false,
  "Date": false,
  "decodeURI": false,
  "decodeURIComponent": false,
  "encodeURI": false,
  "encodeURIComponent": false,
  "Error": false,
  "escape": false,
  "eval": false,
  "EvalError": false,
  FinalizationRegistry: false,
  "Float32Array": false,
  "Float64Array": false,
  "Function": false,
  globalThis: false,
  hasOwnProperty: false,
  "Infinity": false,
  "Int16Array": false,
  "Int32Array": false,
  "Int8Array": false,
  "isFinite": false,
  "isNaN": false,
  isPrototypeOf: false,
  "JSON": false,
  "Map": false,
  "Math": false,
  "NaN": false,
  "Number": false,
  "Object": false,
  "parseFloat": false,
  "parseInt": false,
  "Promise": false,
  propertyIsEnumerable: false,
  "Proxy": false,
  "RangeError": false,
  "ReferenceError": false,
  "Reflect": false,
  "RegExp": false,
  "Set": false,
  SharedArrayBuffer: false,
  "String": false,
  "Symbol": false,
  "SyntaxError": false,
  toLocaleString: false,
  toString: false,
  "TypeError": false,
  "Uint16Array": false,
  "Uint32Array": false,
  "Uint8Array": false,
  "Uint8ClampedArray": false,
  "undefined": false,
  "unescape": false,
  "URIError": false,
  valueOf: false,
  "WeakMap": false,
  WeakRef: false,
  "WeakSet": false
};
var browser$1 = {
  AbortController: false,
  AbortSignal: false,
  addEventListener: false,
  alert: false,
  AnalyserNode: false,
  Animation: false,
  AnimationEffectReadOnly: false,
  AnimationEffectTiming: false,
  AnimationEffectTimingReadOnly: false,
  AnimationEvent: false,
  AnimationPlaybackEvent: false,
  AnimationTimeline: false,
  applicationCache: false,
  ApplicationCache: false,
  ApplicationCacheErrorEvent: false,
  atob: false,
  Attr: false,
  Audio: false,
  AudioBuffer: false,
  AudioBufferSourceNode: false,
  AudioContext: false,
  AudioDestinationNode: false,
  AudioListener: false,
  AudioNode: false,
  AudioParam: false,
  AudioProcessingEvent: false,
  AudioScheduledSourceNode: false,
  AudioWorkletGlobalScope: false,
  AudioWorkletNode: false,
  AudioWorkletProcessor: false,
  BarProp: false,
  BaseAudioContext: false,
  BatteryManager: false,
  BeforeUnloadEvent: false,
  BiquadFilterNode: false,
  Blob: false,
  BlobEvent: false,
  blur: false,
  BroadcastChannel: false,
  btoa: false,
  BudgetService: false,
  ByteLengthQueuingStrategy: false,
  Cache: false,
  caches: false,
  CacheStorage: false,
  cancelAnimationFrame: false,
  cancelIdleCallback: false,
  CanvasCaptureMediaStreamTrack: false,
  CanvasGradient: false,
  CanvasPattern: false,
  CanvasRenderingContext2D: false,
  ChannelMergerNode: false,
  ChannelSplitterNode: false,
  CharacterData: false,
  clearInterval: false,
  clearTimeout: false,
  clientInformation: false,
  ClipboardEvent: false,
  ClipboardItem: false,
  close: false,
  closed: false,
  CloseEvent: false,
  Comment: false,
  CompositionEvent: false,
  CompressionStream: false,
  confirm: false,
  console: false,
  ConstantSourceNode: false,
  ConvolverNode: false,
  CountQueuingStrategy: false,
  createImageBitmap: false,
  Credential: false,
  CredentialsContainer: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CSS: false,
  CSSConditionRule: false,
  CSSFontFaceRule: false,
  CSSGroupingRule: false,
  CSSImportRule: false,
  CSSKeyframeRule: false,
  CSSKeyframesRule: false,
  CSSMatrixComponent: false,
  CSSMediaRule: false,
  CSSNamespaceRule: false,
  CSSPageRule: false,
  CSSPerspective: false,
  CSSRotate: false,
  CSSRule: false,
  CSSRuleList: false,
  CSSScale: false,
  CSSSkew: false,
  CSSSkewX: false,
  CSSSkewY: false,
  CSSStyleDeclaration: false,
  CSSStyleRule: false,
  CSSStyleSheet: false,
  CSSSupportsRule: false,
  CSSTransformValue: false,
  CSSTranslate: false,
  CustomElementRegistry: false,
  customElements: false,
  CustomEvent: false,
  DataTransfer: false,
  DataTransferItem: false,
  DataTransferItemList: false,
  DecompressionStream: false,
  defaultstatus: false,
  defaultStatus: false,
  DelayNode: false,
  DeviceMotionEvent: false,
  DeviceOrientationEvent: false,
  devicePixelRatio: false,
  dispatchEvent: false,
  document: false,
  Document: false,
  DocumentFragment: false,
  DocumentType: false,
  DOMError: false,
  DOMException: false,
  DOMImplementation: false,
  DOMMatrix: false,
  DOMMatrixReadOnly: false,
  DOMParser: false,
  DOMPoint: false,
  DOMPointReadOnly: false,
  DOMQuad: false,
  DOMRect: false,
  DOMRectList: false,
  DOMRectReadOnly: false,
  DOMStringList: false,
  DOMStringMap: false,
  DOMTokenList: false,
  DragEvent: false,
  DynamicsCompressorNode: false,
  Element: false,
  ErrorEvent: false,
  event: false,
  Event: false,
  EventSource: false,
  EventTarget: false,
  external: false,
  fetch: false,
  File: false,
  FileList: false,
  FileReader: false,
  find: false,
  focus: false,
  FocusEvent: false,
  FontFace: false,
  FontFaceSetLoadEvent: false,
  FormData: false,
  FormDataEvent: false,
  frameElement: false,
  frames: false,
  GainNode: false,
  Gamepad: false,
  GamepadButton: false,
  GamepadEvent: false,
  getComputedStyle: false,
  getSelection: false,
  HashChangeEvent: false,
  Headers: false,
  history: false,
  History: false,
  HTMLAllCollection: false,
  HTMLAnchorElement: false,
  HTMLAreaElement: false,
  HTMLAudioElement: false,
  HTMLBaseElement: false,
  HTMLBodyElement: false,
  HTMLBRElement: false,
  HTMLButtonElement: false,
  HTMLCanvasElement: false,
  HTMLCollection: false,
  HTMLContentElement: false,
  HTMLDataElement: false,
  HTMLDataListElement: false,
  HTMLDetailsElement: false,
  HTMLDialogElement: false,
  HTMLDirectoryElement: false,
  HTMLDivElement: false,
  HTMLDListElement: false,
  HTMLDocument: false,
  HTMLElement: false,
  HTMLEmbedElement: false,
  HTMLFieldSetElement: false,
  HTMLFontElement: false,
  HTMLFormControlsCollection: false,
  HTMLFormElement: false,
  HTMLFrameElement: false,
  HTMLFrameSetElement: false,
  HTMLHeadElement: false,
  HTMLHeadingElement: false,
  HTMLHRElement: false,
  HTMLHtmlElement: false,
  HTMLIFrameElement: false,
  HTMLImageElement: false,
  HTMLInputElement: false,
  HTMLLabelElement: false,
  HTMLLegendElement: false,
  HTMLLIElement: false,
  HTMLLinkElement: false,
  HTMLMapElement: false,
  HTMLMarqueeElement: false,
  HTMLMediaElement: false,
  HTMLMenuElement: false,
  HTMLMetaElement: false,
  HTMLMeterElement: false,
  HTMLModElement: false,
  HTMLObjectElement: false,
  HTMLOListElement: false,
  HTMLOptGroupElement: false,
  HTMLOptionElement: false,
  HTMLOptionsCollection: false,
  HTMLOutputElement: false,
  HTMLParagraphElement: false,
  HTMLParamElement: false,
  HTMLPictureElement: false,
  HTMLPreElement: false,
  HTMLProgressElement: false,
  HTMLQuoteElement: false,
  HTMLScriptElement: false,
  HTMLSelectElement: false,
  HTMLShadowElement: false,
  HTMLSlotElement: false,
  HTMLSourceElement: false,
  HTMLSpanElement: false,
  HTMLStyleElement: false,
  HTMLTableCaptionElement: false,
  HTMLTableCellElement: false,
  HTMLTableColElement: false,
  HTMLTableElement: false,
  HTMLTableRowElement: false,
  HTMLTableSectionElement: false,
  HTMLTemplateElement: false,
  HTMLTextAreaElement: false,
  HTMLTimeElement: false,
  HTMLTitleElement: false,
  HTMLTrackElement: false,
  HTMLUListElement: false,
  HTMLUnknownElement: false,
  HTMLVideoElement: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  IdleDeadline: false,
  IIRFilterNode: false,
  Image: false,
  ImageBitmap: false,
  ImageBitmapRenderingContext: false,
  ImageCapture: false,
  ImageData: false,
  indexedDB: false,
  innerHeight: false,
  innerWidth: false,
  InputEvent: false,
  IntersectionObserver: false,
  IntersectionObserverEntry: false,
  "Intl": false,
  isSecureContext: false,
  KeyboardEvent: false,
  KeyframeEffect: false,
  KeyframeEffectReadOnly: false,
  length: false,
  localStorage: false,
  location: true,
  Location: false,
  locationbar: false,
  matchMedia: false,
  MediaDeviceInfo: false,
  MediaDevices: false,
  MediaElementAudioSourceNode: false,
  MediaEncryptedEvent: false,
  MediaError: false,
  MediaKeyMessageEvent: false,
  MediaKeySession: false,
  MediaKeyStatusMap: false,
  MediaKeySystemAccess: false,
  MediaList: false,
  MediaMetadata: false,
  MediaQueryList: false,
  MediaQueryListEvent: false,
  MediaRecorder: false,
  MediaSettingsRange: false,
  MediaSource: false,
  MediaStream: false,
  MediaStreamAudioDestinationNode: false,
  MediaStreamAudioSourceNode: false,
  MediaStreamConstraints: false,
  MediaStreamEvent: false,
  MediaStreamTrack: false,
  MediaStreamTrackEvent: false,
  menubar: false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  MIDIAccess: false,
  MIDIConnectionEvent: false,
  MIDIInput: false,
  MIDIInputMap: false,
  MIDIMessageEvent: false,
  MIDIOutput: false,
  MIDIOutputMap: false,
  MIDIPort: false,
  MimeType: false,
  MimeTypeArray: false,
  MouseEvent: false,
  moveBy: false,
  moveTo: false,
  MutationEvent: false,
  MutationObserver: false,
  MutationRecord: false,
  name: false,
  NamedNodeMap: false,
  NavigationPreloadManager: false,
  navigator: false,
  Navigator: false,
  NavigatorUAData: false,
  NetworkInformation: false,
  Node: false,
  NodeFilter: false,
  NodeIterator: false,
  NodeList: false,
  Notification: false,
  OfflineAudioCompletionEvent: false,
  OfflineAudioContext: false,
  offscreenBuffering: false,
  OffscreenCanvas: true,
  OffscreenCanvasRenderingContext2D: false,
  onabort: true,
  onafterprint: true,
  onanimationend: true,
  onanimationiteration: true,
  onanimationstart: true,
  onappinstalled: true,
  onauxclick: true,
  onbeforeinstallprompt: true,
  onbeforeprint: true,
  onbeforeunload: true,
  onblur: true,
  oncancel: true,
  oncanplay: true,
  oncanplaythrough: true,
  onchange: true,
  onclick: true,
  onclose: true,
  oncontextmenu: true,
  oncuechange: true,
  ondblclick: true,
  ondevicemotion: true,
  ondeviceorientation: true,
  ondeviceorientationabsolute: true,
  ondrag: true,
  ondragend: true,
  ondragenter: true,
  ondragleave: true,
  ondragover: true,
  ondragstart: true,
  ondrop: true,
  ondurationchange: true,
  onemptied: true,
  onended: true,
  onerror: true,
  onfocus: true,
  ongotpointercapture: true,
  onhashchange: true,
  oninput: true,
  oninvalid: true,
  onkeydown: true,
  onkeypress: true,
  onkeyup: true,
  onlanguagechange: true,
  onload: true,
  onloadeddata: true,
  onloadedmetadata: true,
  onloadstart: true,
  onlostpointercapture: true,
  onmessage: true,
  onmessageerror: true,
  onmousedown: true,
  onmouseenter: true,
  onmouseleave: true,
  onmousemove: true,
  onmouseout: true,
  onmouseover: true,
  onmouseup: true,
  onmousewheel: true,
  onoffline: true,
  ononline: true,
  onpagehide: true,
  onpageshow: true,
  onpause: true,
  onplay: true,
  onplaying: true,
  onpointercancel: true,
  onpointerdown: true,
  onpointerenter: true,
  onpointerleave: true,
  onpointermove: true,
  onpointerout: true,
  onpointerover: true,
  onpointerup: true,
  onpopstate: true,
  onprogress: true,
  onratechange: true,
  onrejectionhandled: true,
  onreset: true,
  onresize: true,
  onscroll: true,
  onsearch: true,
  onseeked: true,
  onseeking: true,
  onselect: true,
  onstalled: true,
  onstorage: true,
  onsubmit: true,
  onsuspend: true,
  ontimeupdate: true,
  ontoggle: true,
  ontransitionend: true,
  onunhandledrejection: true,
  onunload: true,
  onvolumechange: true,
  onwaiting: true,
  onwheel: true,
  open: false,
  openDatabase: false,
  opener: false,
  Option: false,
  origin: false,
  OscillatorNode: false,
  outerHeight: false,
  outerWidth: false,
  OverconstrainedError: false,
  PageTransitionEvent: false,
  pageXOffset: false,
  pageYOffset: false,
  PannerNode: false,
  parent: false,
  Path2D: false,
  PaymentAddress: false,
  PaymentRequest: false,
  PaymentRequestUpdateEvent: false,
  PaymentResponse: false,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceLongTaskTiming: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceNavigationTiming: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformancePaintTiming: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  PeriodicWave: false,
  Permissions: false,
  PermissionStatus: false,
  personalbar: false,
  PhotoCapabilities: false,
  Plugin: false,
  PluginArray: false,
  PointerEvent: false,
  PopStateEvent: false,
  postMessage: false,
  Presentation: false,
  PresentationAvailability: false,
  PresentationConnection: false,
  PresentationConnectionAvailableEvent: false,
  PresentationConnectionCloseEvent: false,
  PresentationConnectionList: false,
  PresentationReceiver: false,
  PresentationRequest: false,
  print: false,
  ProcessingInstruction: false,
  ProgressEvent: false,
  PromiseRejectionEvent: false,
  prompt: false,
  PushManager: false,
  PushSubscription: false,
  PushSubscriptionOptions: false,
  queueMicrotask: false,
  RadioNodeList: false,
  Range: false,
  ReadableByteStreamController: false,
  ReadableStream: false,
  ReadableStreamBYOBReader: false,
  ReadableStreamBYOBRequest: false,
  ReadableStreamDefaultController: false,
  ReadableStreamDefaultReader: false,
  registerProcessor: false,
  RemotePlayback: false,
  removeEventListener: false,
  reportError: false,
  Request: false,
  requestAnimationFrame: false,
  requestIdleCallback: false,
  resizeBy: false,
  ResizeObserver: false,
  ResizeObserverEntry: false,
  resizeTo: false,
  Response: false,
  RTCCertificate: false,
  RTCDataChannel: false,
  RTCDataChannelEvent: false,
  RTCDtlsTransport: false,
  RTCIceCandidate: false,
  RTCIceGatherer: false,
  RTCIceTransport: false,
  RTCPeerConnection: false,
  RTCPeerConnectionIceEvent: false,
  RTCRtpContributingSource: false,
  RTCRtpReceiver: false,
  RTCRtpSender: false,
  RTCSctpTransport: false,
  RTCSessionDescription: false,
  RTCStatsReport: false,
  RTCTrackEvent: false,
  screen: false,
  Screen: false,
  screenLeft: false,
  ScreenOrientation: false,
  screenTop: false,
  screenX: false,
  screenY: false,
  ScriptProcessorNode: false,
  scroll: false,
  scrollbars: false,
  scrollBy: false,
  scrollTo: false,
  scrollX: false,
  scrollY: false,
  SecurityPolicyViolationEvent: false,
  Selection: false,
  self: false,
  ServiceWorker: false,
  ServiceWorkerContainer: false,
  ServiceWorkerRegistration: false,
  sessionStorage: false,
  setInterval: false,
  setTimeout: false,
  ShadowRoot: false,
  SharedWorker: false,
  SourceBuffer: false,
  SourceBufferList: false,
  speechSynthesis: false,
  SpeechSynthesisEvent: false,
  SpeechSynthesisUtterance: false,
  StaticRange: false,
  status: false,
  statusbar: false,
  StereoPannerNode: false,
  stop: false,
  Storage: false,
  StorageEvent: false,
  StorageManager: false,
  structuredClone: false,
  styleMedia: false,
  StyleSheet: false,
  StyleSheetList: false,
  SubmitEvent: false,
  SubtleCrypto: false,
  SVGAElement: false,
  SVGAngle: false,
  SVGAnimatedAngle: false,
  SVGAnimatedBoolean: false,
  SVGAnimatedEnumeration: false,
  SVGAnimatedInteger: false,
  SVGAnimatedLength: false,
  SVGAnimatedLengthList: false,
  SVGAnimatedNumber: false,
  SVGAnimatedNumberList: false,
  SVGAnimatedPreserveAspectRatio: false,
  SVGAnimatedRect: false,
  SVGAnimatedString: false,
  SVGAnimatedTransformList: false,
  SVGAnimateElement: false,
  SVGAnimateMotionElement: false,
  SVGAnimateTransformElement: false,
  SVGAnimationElement: false,
  SVGCircleElement: false,
  SVGClipPathElement: false,
  SVGComponentTransferFunctionElement: false,
  SVGDefsElement: false,
  SVGDescElement: false,
  SVGDiscardElement: false,
  SVGElement: false,
  SVGEllipseElement: false,
  SVGFEBlendElement: false,
  SVGFEColorMatrixElement: false,
  SVGFEComponentTransferElement: false,
  SVGFECompositeElement: false,
  SVGFEConvolveMatrixElement: false,
  SVGFEDiffuseLightingElement: false,
  SVGFEDisplacementMapElement: false,
  SVGFEDistantLightElement: false,
  SVGFEDropShadowElement: false,
  SVGFEFloodElement: false,
  SVGFEFuncAElement: false,
  SVGFEFuncBElement: false,
  SVGFEFuncGElement: false,
  SVGFEFuncRElement: false,
  SVGFEGaussianBlurElement: false,
  SVGFEImageElement: false,
  SVGFEMergeElement: false,
  SVGFEMergeNodeElement: false,
  SVGFEMorphologyElement: false,
  SVGFEOffsetElement: false,
  SVGFEPointLightElement: false,
  SVGFESpecularLightingElement: false,
  SVGFESpotLightElement: false,
  SVGFETileElement: false,
  SVGFETurbulenceElement: false,
  SVGFilterElement: false,
  SVGForeignObjectElement: false,
  SVGGElement: false,
  SVGGeometryElement: false,
  SVGGradientElement: false,
  SVGGraphicsElement: false,
  SVGImageElement: false,
  SVGLength: false,
  SVGLengthList: false,
  SVGLinearGradientElement: false,
  SVGLineElement: false,
  SVGMarkerElement: false,
  SVGMaskElement: false,
  SVGMatrix: false,
  SVGMetadataElement: false,
  SVGMPathElement: false,
  SVGNumber: false,
  SVGNumberList: false,
  SVGPathElement: false,
  SVGPatternElement: false,
  SVGPoint: false,
  SVGPointList: false,
  SVGPolygonElement: false,
  SVGPolylineElement: false,
  SVGPreserveAspectRatio: false,
  SVGRadialGradientElement: false,
  SVGRect: false,
  SVGRectElement: false,
  SVGScriptElement: false,
  SVGSetElement: false,
  SVGStopElement: false,
  SVGStringList: false,
  SVGStyleElement: false,
  SVGSVGElement: false,
  SVGSwitchElement: false,
  SVGSymbolElement: false,
  SVGTextContentElement: false,
  SVGTextElement: false,
  SVGTextPathElement: false,
  SVGTextPositioningElement: false,
  SVGTitleElement: false,
  SVGTransform: false,
  SVGTransformList: false,
  SVGTSpanElement: false,
  SVGUnitTypes: false,
  SVGUseElement: false,
  SVGViewElement: false,
  TaskAttributionTiming: false,
  Text: false,
  TextDecoder: false,
  TextDecoderStream: false,
  TextEncoder: false,
  TextEncoderStream: false,
  TextEvent: false,
  TextMetrics: false,
  TextTrack: false,
  TextTrackCue: false,
  TextTrackCueList: false,
  TextTrackList: false,
  TimeRanges: false,
  ToggleEvent: false,
  toolbar: false,
  top: false,
  Touch: false,
  TouchEvent: false,
  TouchList: false,
  TrackEvent: false,
  TransformStream: false,
  TransformStreamDefaultController: false,
  TransitionEvent: false,
  TreeWalker: false,
  UIEvent: false,
  URL: false,
  URLSearchParams: false,
  ValidityState: false,
  visualViewport: false,
  VisualViewport: false,
  VTTCue: false,
  WaveShaperNode: false,
  WebAssembly: false,
  WebGL2RenderingContext: false,
  WebGLActiveInfo: false,
  WebGLBuffer: false,
  WebGLContextEvent: false,
  WebGLFramebuffer: false,
  WebGLProgram: false,
  WebGLQuery: false,
  WebGLRenderbuffer: false,
  WebGLRenderingContext: false,
  WebGLSampler: false,
  WebGLShader: false,
  WebGLShaderPrecisionFormat: false,
  WebGLSync: false,
  WebGLTexture: false,
  WebGLTransformFeedback: false,
  WebGLUniformLocation: false,
  WebGLVertexArrayObject: false,
  WebSocket: false,
  WheelEvent: false,
  window: false,
  Window: false,
  Worker: false,
  WritableStream: false,
  WritableStreamDefaultController: false,
  WritableStreamDefaultWriter: false,
  XMLDocument: false,
  XMLHttpRequest: false,
  XMLHttpRequestEventTarget: false,
  XMLHttpRequestUpload: false,
  XMLSerializer: false,
  XPathEvaluator: false,
  XPathExpression: false,
  XPathResult: false,
  XRAnchor: false,
  XRBoundedReferenceSpace: false,
  XRCPUDepthInformation: false,
  XRDepthInformation: false,
  XRFrame: false,
  XRInputSource: false,
  XRInputSourceArray: false,
  XRInputSourceEvent: false,
  XRInputSourcesChangeEvent: false,
  XRPose: false,
  XRReferenceSpace: false,
  XRReferenceSpaceEvent: false,
  XRRenderState: false,
  XRRigidTransform: false,
  XRSession: false,
  XRSessionEvent: false,
  XRSpace: false,
  XRSystem: false,
  XRView: false,
  XRViewerPose: false,
  XRViewport: false,
  XRWebGLBinding: false,
  XRWebGLDepthInformation: false,
  XRWebGLLayer: false,
  XSLTProcessor: false
};
var worker = {
  addEventListener: false,
  applicationCache: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  ByteLengthQueuingStrategy: false,
  Cache: false,
  caches: false,
  clearInterval: false,
  clearTimeout: false,
  close: true,
  CompressionStream: false,
  console: false,
  CountQueuingStrategy: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CustomEvent: false,
  DecompressionStream: false,
  ErrorEvent: false,
  Event: false,
  fetch: false,
  File: false,
  FileReaderSync: false,
  FormData: false,
  Headers: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  ImageData: false,
  importScripts: true,
  indexedDB: false,
  location: false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  name: false,
  navigator: false,
  Notification: false,
  onclose: true,
  onconnect: true,
  onerror: true,
  onlanguagechange: true,
  onmessage: true,
  onoffline: true,
  ononline: true,
  onrejectionhandled: true,
  onunhandledrejection: true,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  postMessage: true,
  "Promise": false,
  queueMicrotask: false,
  ReadableByteStreamController: false,
  ReadableStream: false,
  ReadableStreamBYOBReader: false,
  ReadableStreamBYOBRequest: false,
  ReadableStreamDefaultController: false,
  ReadableStreamDefaultReader: false,
  removeEventListener: false,
  reportError: false,
  Request: false,
  Response: false,
  self: true,
  ServiceWorkerRegistration: false,
  setInterval: false,
  setTimeout: false,
  SubtleCrypto: false,
  TextDecoder: false,
  TextDecoderStream: false,
  TextEncoder: false,
  TextEncoderStream: false,
  TransformStream: false,
  TransformStreamDefaultController: false,
  URL: false,
  URLSearchParams: false,
  WebAssembly: false,
  WebSocket: false,
  Worker: false,
  WorkerGlobalScope: false,
  WritableStream: false,
  WritableStreamDefaultController: false,
  WritableStreamDefaultWriter: false,
  XMLHttpRequest: false
};
var node = {
  __dirname: false,
  __filename: false,
  AbortController: false,
  AbortSignal: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  Buffer: false,
  ByteLengthQueuingStrategy: false,
  clearImmediate: false,
  clearInterval: false,
  clearTimeout: false,
  CompressionStream: false,
  console: false,
  CountQueuingStrategy: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CustomEvent: false,
  DecompressionStream: false,
  DOMException: false,
  Event: false,
  EventTarget: false,
  exports: true,
  fetch: false,
  File: false,
  FormData: false,
  global: false,
  Headers: false,
  "Intl": false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  module: false,
  performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformanceResourceTiming: false,
  process: false,
  queueMicrotask: false,
  ReadableByteStreamController: false,
  ReadableStream: false,
  ReadableStreamBYOBReader: false,
  ReadableStreamBYOBRequest: false,
  ReadableStreamDefaultController: false,
  ReadableStreamDefaultReader: false,
  Request: false,
  require: false,
  Response: false,
  setImmediate: false,
  setInterval: false,
  setTimeout: false,
  structuredClone: false,
  SubtleCrypto: false,
  TextDecoder: false,
  TextDecoderStream: false,
  TextEncoder: false,
  TextEncoderStream: false,
  TransformStream: false,
  TransformStreamDefaultController: false,
  URL: false,
  URLSearchParams: false,
  WebAssembly: false,
  WritableStream: false,
  WritableStreamDefaultController: false,
  WritableStreamDefaultWriter: false
};
var nodeBuiltin = {
  AbortController: false,
  AbortSignal: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  Buffer: false,
  ByteLengthQueuingStrategy: false,
  clearImmediate: false,
  clearInterval: false,
  clearTimeout: false,
  CompressionStream: false,
  console: false,
  CountQueuingStrategy: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CustomEvent: false,
  DecompressionStream: false,
  DOMException: false,
  Event: false,
  EventTarget: false,
  fetch: false,
  File: false,
  FormData: false,
  global: false,
  Headers: false,
  "Intl": false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformanceResourceTiming: false,
  process: false,
  queueMicrotask: false,
  ReadableByteStreamController: false,
  ReadableStream: false,
  ReadableStreamBYOBReader: false,
  ReadableStreamBYOBRequest: false,
  ReadableStreamDefaultController: false,
  ReadableStreamDefaultReader: false,
  Request: false,
  Response: false,
  setImmediate: false,
  setInterval: false,
  setTimeout: false,
  structuredClone: false,
  SubtleCrypto: false,
  TextDecoder: false,
  TextDecoderStream: false,
  TextEncoder: false,
  TextEncoderStream: false,
  TransformStream: false,
  TransformStreamDefaultController: false,
  URL: false,
  URLSearchParams: false,
  WebAssembly: false,
  WritableStream: false,
  WritableStreamDefaultController: false,
  WritableStreamDefaultWriter: false
};
var commonjs = {
  exports: true,
  global: false,
  module: false,
  require: false
};
var amd = {
  define: false,
  require: false
};
var mocha = {
  after: false,
  afterEach: false,
  before: false,
  beforeEach: false,
  context: false,
  describe: false,
  it: false,
  mocha: false,
  run: false,
  setup: false,
  specify: false,
  suite: false,
  suiteSetup: false,
  suiteTeardown: false,
  teardown: false,
  test: false,
  xcontext: false,
  xdescribe: false,
  xit: false,
  xspecify: false
};
var jasmine = {
  afterAll: false,
  afterEach: false,
  beforeAll: false,
  beforeEach: false,
  describe: false,
  expect: false,
  expectAsync: false,
  fail: false,
  fdescribe: false,
  fit: false,
  it: false,
  jasmine: false,
  pending: false,
  runs: false,
  spyOn: false,
  spyOnAllFunctions: false,
  spyOnProperty: false,
  waits: false,
  waitsFor: false,
  xdescribe: false,
  xit: false
};
var jest = {
  afterAll: false,
  afterEach: false,
  beforeAll: false,
  beforeEach: false,
  describe: false,
  expect: false,
  fdescribe: false,
  fit: false,
  it: false,
  jest: false,
  pit: false,
  require: false,
  test: false,
  xdescribe: false,
  xit: false,
  xtest: false
};
var qunit = {
  asyncTest: false,
  deepEqual: false,
  equal: false,
  expect: false,
  module: false,
  notDeepEqual: false,
  notEqual: false,
  notOk: false,
  notPropEqual: false,
  notStrictEqual: false,
  ok: false,
  propEqual: false,
  QUnit: false,
  raises: false,
  start: false,
  stop: false,
  strictEqual: false,
  test: false,
  throws: false
};
var phantomjs = {
  console: true,
  exports: true,
  phantom: true,
  require: true,
  WebPage: true
};
var couch = {
  emit: false,
  exports: false,
  getRow: false,
  log: false,
  module: false,
  provides: false,
  require: false,
  respond: false,
  send: false,
  start: false,
  sum: false
};
var rhino = {
  defineClass: false,
  deserialize: false,
  gc: false,
  help: false,
  importClass: false,
  importPackage: false,
  java: false,
  load: false,
  loadClass: false,
  Packages: false,
  print: false,
  quit: false,
  readFile: false,
  readUrl: false,
  runCommand: false,
  seal: false,
  serialize: false,
  spawn: false,
  sync: false,
  toint32: false,
  version: false
};
var nashorn = {
  __DIR__: false,
  __FILE__: false,
  __LINE__: false,
  com: false,
  edu: false,
  exit: false,
  java: false,
  Java: false,
  javafx: false,
  JavaImporter: false,
  javax: false,
  JSAdapter: false,
  load: false,
  loadWithNewGlobal: false,
  org: false,
  Packages: false,
  print: false,
  quit: false
};
var wsh = {
  ActiveXObject: false,
  CollectGarbage: false,
  Debug: false,
  Enumerator: false,
  GetObject: false,
  RuntimeObject: false,
  ScriptEngine: false,
  ScriptEngineBuildVersion: false,
  ScriptEngineMajorVersion: false,
  ScriptEngineMinorVersion: false,
  VBArray: false,
  WScript: false,
  WSH: false
};
var jquery = {
  $: false,
  jQuery: false
};
var yui = {
  YAHOO: false,
  YAHOO_config: false,
  YUI: false,
  YUI_config: false
};
var shelljs = {
  cat: false,
  cd: false,
  chmod: false,
  config: false,
  cp: false,
  dirs: false,
  echo: false,
  env: false,
  error: false,
  exec: false,
  exit: false,
  find: false,
  grep: false,
  ln: false,
  ls: false,
  mkdir: false,
  mv: false,
  popd: false,
  pushd: false,
  pwd: false,
  rm: false,
  sed: false,
  set: false,
  target: false,
  tempdir: false,
  test: false,
  touch: false,
  which: false
};
var prototypejs = {
  $: false,
  $$: false,
  $A: false,
  $break: false,
  $continue: false,
  $F: false,
  $H: false,
  $R: false,
  $w: false,
  Abstract: false,
  Ajax: false,
  Autocompleter: false,
  Builder: false,
  Class: false,
  Control: false,
  Draggable: false,
  Draggables: false,
  Droppables: false,
  Effect: false,
  Element: false,
  Enumerable: false,
  Event: false,
  Field: false,
  Form: false,
  Hash: false,
  Insertion: false,
  ObjectRange: false,
  PeriodicalExecuter: false,
  Position: false,
  Prototype: false,
  Scriptaculous: false,
  Selector: false,
  Sortable: false,
  SortableObserver: false,
  Sound: false,
  Template: false,
  Toggle: false,
  Try: false
};
var meteor = {
  $: false,
  Accounts: false,
  AccountsClient: false,
  AccountsCommon: false,
  AccountsServer: false,
  App: false,
  Assets: false,
  Blaze: false,
  check: false,
  Cordova: false,
  DDP: false,
  DDPRateLimiter: false,
  DDPServer: false,
  Deps: false,
  EJSON: false,
  Email: false,
  HTTP: false,
  Log: false,
  Match: false,
  Meteor: false,
  Mongo: false,
  MongoInternals: false,
  Npm: false,
  Package: false,
  Plugin: false,
  process: false,
  Random: false,
  ReactiveDict: false,
  ReactiveVar: false,
  Router: false,
  ServiceConfiguration: false,
  Session: false,
  share: false,
  Spacebars: false,
  Template: false,
  Tinytest: false,
  Tracker: false,
  UI: false,
  Utils: false,
  WebApp: false,
  WebAppInternals: false
};
var mongo = {
  _isWindows: false,
  _rand: false,
  BulkWriteResult: false,
  cat: false,
  cd: false,
  connect: false,
  db: false,
  getHostName: false,
  getMemInfo: false,
  hostname: false,
  ISODate: false,
  listFiles: false,
  load: false,
  ls: false,
  md5sumFile: false,
  mkdir: false,
  Mongo: false,
  NumberInt: false,
  NumberLong: false,
  ObjectId: false,
  PlanCache: false,
  print: false,
  printjson: false,
  pwd: false,
  quit: false,
  removeFile: false,
  rs: false,
  sh: false,
  UUID: false,
  version: false,
  WriteResult: false
};
var applescript = {
  $: false,
  Application: false,
  Automation: false,
  console: false,
  delay: false,
  Library: false,
  ObjC: false,
  ObjectSpecifier: false,
  Path: false,
  Progress: false,
  Ref: false
};
var serviceworker = {
  addEventListener: false,
  applicationCache: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  ByteLengthQueuingStrategy: false,
  Cache: false,
  caches: false,
  CacheStorage: false,
  clearInterval: false,
  clearTimeout: false,
  Client: false,
  clients: false,
  Clients: false,
  close: true,
  CompressionStream: false,
  console: false,
  CountQueuingStrategy: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CustomEvent: false,
  DecompressionStream: false,
  ErrorEvent: false,
  Event: false,
  ExtendableEvent: false,
  ExtendableMessageEvent: false,
  fetch: false,
  FetchEvent: false,
  File: false,
  FileReaderSync: false,
  FormData: false,
  Headers: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  ImageData: false,
  importScripts: false,
  indexedDB: false,
  location: false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  name: false,
  navigator: false,
  Notification: false,
  onclose: true,
  onconnect: true,
  onerror: true,
  onfetch: true,
  oninstall: true,
  onlanguagechange: true,
  onmessage: true,
  onmessageerror: true,
  onnotificationclick: true,
  onnotificationclose: true,
  onoffline: true,
  ononline: true,
  onpush: true,
  onpushsubscriptionchange: true,
  onrejectionhandled: true,
  onsync: true,
  onunhandledrejection: true,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  postMessage: true,
  "Promise": false,
  queueMicrotask: false,
  ReadableByteStreamController: false,
  ReadableStream: false,
  ReadableStreamBYOBReader: false,
  ReadableStreamBYOBRequest: false,
  ReadableStreamDefaultController: false,
  ReadableStreamDefaultReader: false,
  registration: false,
  removeEventListener: false,
  Request: false,
  Response: false,
  self: false,
  ServiceWorker: false,
  ServiceWorkerContainer: false,
  ServiceWorkerGlobalScope: false,
  ServiceWorkerMessageEvent: false,
  ServiceWorkerRegistration: false,
  setInterval: false,
  setTimeout: false,
  skipWaiting: false,
  SubtleCrypto: false,
  TextDecoder: false,
  TextDecoderStream: false,
  TextEncoder: false,
  TextEncoderStream: false,
  TransformStream: false,
  TransformStreamDefaultController: false,
  URL: false,
  URLSearchParams: false,
  WebAssembly: false,
  WebSocket: false,
  WindowClient: false,
  Worker: false,
  WorkerGlobalScope: false,
  WritableStream: false,
  WritableStreamDefaultController: false,
  WritableStreamDefaultWriter: false,
  XMLHttpRequest: false
};
var atomtest = {
  advanceClock: false,
  atom: false,
  fakeClearInterval: false,
  fakeClearTimeout: false,
  fakeSetInterval: false,
  fakeSetTimeout: false,
  resetTimeouts: false,
  waitsForPromise: false
};
var embertest = {
  andThen: false,
  click: false,
  currentPath: false,
  currentRouteName: false,
  currentURL: false,
  fillIn: false,
  find: false,
  findAll: false,
  findWithAssert: false,
  keyEvent: false,
  pauseTest: false,
  resumeTest: false,
  triggerEvent: false,
  visit: false,
  wait: false
};
var protractor = {
  $: false,
  $$: false,
  browser: false,
  by: false,
  By: false,
  DartObject: false,
  element: false,
  protractor: false
};
var webextensions = {
  browser: false,
  chrome: false,
  opr: false
};
var greasemonkey = {
  cloneInto: false,
  createObjectIn: false,
  exportFunction: false,
  GM: false,
  GM_addElement: false,
  GM_addStyle: false,
  GM_addValueChangeListener: false,
  GM_deleteValue: false,
  GM_download: false,
  GM_getResourceText: false,
  GM_getResourceURL: false,
  GM_getTab: false,
  GM_getTabs: false,
  GM_getValue: false,
  GM_info: false,
  GM_listValues: false,
  GM_log: false,
  GM_notification: false,
  GM_openInTab: false,
  GM_registerMenuCommand: false,
  GM_removeValueChangeListener: false,
  GM_saveTab: false,
  GM_setClipboard: false,
  GM_setValue: false,
  GM_unregisterMenuCommand: false,
  GM_xmlhttpRequest: false,
  unsafeWindow: false
};
var devtools = {
  $: false,
  $_: false,
  $$: false,
  $0: false,
  $1: false,
  $2: false,
  $3: false,
  $4: false,
  $x: false,
  chrome: false,
  clear: false,
  copy: false,
  debug: false,
  dir: false,
  dirxml: false,
  getEventListeners: false,
  inspect: false,
  keys: false,
  monitor: false,
  monitorEvents: false,
  profile: false,
  profileEnd: false,
  queryObjects: false,
  table: false,
  undebug: false,
  unmonitor: false,
  unmonitorEvents: false,
  values: false
};
var require$$0$1 = {
  builtin,
  es5,
  es2015,
  es2017,
  es2020,
  es2021,
  browser: browser$1,
  worker,
  node,
  nodeBuiltin,
  commonjs,
  amd,
  mocha,
  jasmine,
  jest,
  qunit,
  phantomjs,
  couch,
  rhino,
  nashorn,
  wsh,
  jquery,
  yui,
  shelljs,
  prototypejs,
  meteor,
  mongo,
  applescript,
  serviceworker,
  atomtest,
  embertest,
  protractor,
  "shared-node-browser": {
    AbortController: false,
    AbortSignal: false,
    atob: false,
    Blob: false,
    BroadcastChannel: false,
    btoa: false,
    ByteLengthQueuingStrategy: false,
    clearInterval: false,
    clearTimeout: false,
    CompressionStream: false,
    console: false,
    CountQueuingStrategy: false,
    crypto: false,
    Crypto: false,
    CryptoKey: false,
    CustomEvent: false,
    DecompressionStream: false,
    DOMException: false,
    Event: false,
    EventTarget: false,
    fetch: false,
    File: false,
    FormData: false,
    Headers: false,
    "Intl": false,
    MessageChannel: false,
    MessageEvent: false,
    MessagePort: false,
    performance: false,
    PerformanceEntry: false,
    PerformanceMark: false,
    PerformanceMeasure: false,
    PerformanceObserver: false,
    PerformanceObserverEntryList: false,
    PerformanceResourceTiming: false,
    queueMicrotask: false,
    ReadableByteStreamController: false,
    ReadableStream: false,
    ReadableStreamBYOBReader: false,
    ReadableStreamBYOBRequest: false,
    ReadableStreamDefaultController: false,
    ReadableStreamDefaultReader: false,
    Request: false,
    Response: false,
    setInterval: false,
    setTimeout: false,
    structuredClone: false,
    SubtleCrypto: false,
    TextDecoder: false,
    TextDecoderStream: false,
    TextEncoder: false,
    TextEncoderStream: false,
    TransformStream: false,
    TransformStreamDefaultController: false,
    URL: false,
    URLSearchParams: false,
    WebAssembly: false,
    WritableStream: false,
    WritableStreamDefaultController: false,
    WritableStreamDefaultWriter: false
  },
  webextensions,
  greasemonkey,
  devtools
};
var globals$1;
var hasRequiredGlobals$1;
function requireGlobals$1() {
  if (hasRequiredGlobals$1) return globals$1;
  hasRequiredGlobals$1 = 1;
  globals$1 = require$$0$1;
  return globals$1;
}
var hasRequiredEslintrcUniversal;
function requireEslintrcUniversal() {
  if (hasRequiredEslintrcUniversal) return eslintrcUniversal;
  hasRequiredEslintrcUniversal = 1;
  Object.defineProperty(eslintrcUniversal, "__esModule", { value: true });
  var util2 = require$$0$3;
  var path = require$$0$3;
  var Ajv = requireAjv$1();
  var globals2 = /* @__PURE__ */ requireGlobals$1();
  function _interopDefaultLegacy(e2) {
    return e2 && typeof e2 === "object" && "default" in e2 ? e2 : { "default": e2 };
  }
  var util__default = /* @__PURE__ */ _interopDefaultLegacy(util2);
  var path__default = /* @__PURE__ */ _interopDefaultLegacy(path);
  var Ajv__default = /* @__PURE__ */ _interopDefaultLegacy(Ajv);
  var globals__default = /* @__PURE__ */ _interopDefaultLegacy(globals2);
  const RULE_SEVERITY_STRINGS = ["off", "warn", "error"], RULE_SEVERITY = RULE_SEVERITY_STRINGS.reduce((map, value, index) => {
    map[value] = index;
    return map;
  }, {}), VALID_SEVERITIES = /* @__PURE__ */ new Set([0, 1, 2, "off", "warn", "error"]);
  function getRuleSeverity(ruleConfig) {
    const severityValue = Array.isArray(ruleConfig) ? ruleConfig[0] : ruleConfig;
    if (severityValue === 0 || severityValue === 1 || severityValue === 2) {
      return severityValue;
    }
    if (typeof severityValue === "string") {
      return RULE_SEVERITY[severityValue.toLowerCase()] || 0;
    }
    return 0;
  }
  function normalizeToStrings(config2) {
    if (config2.rules) {
      Object.keys(config2.rules).forEach((ruleId) => {
        const ruleConfig = config2.rules[ruleId];
        if (typeof ruleConfig === "number") {
          config2.rules[ruleId] = RULE_SEVERITY_STRINGS[ruleConfig] || RULE_SEVERITY_STRINGS[0];
        } else if (Array.isArray(ruleConfig) && typeof ruleConfig[0] === "number") {
          ruleConfig[0] = RULE_SEVERITY_STRINGS[ruleConfig[0]] || RULE_SEVERITY_STRINGS[0];
        }
      });
    }
  }
  function isErrorSeverity(ruleConfig) {
    return getRuleSeverity(ruleConfig) === 2;
  }
  function isValidSeverity(ruleConfig) {
    let severity2 = Array.isArray(ruleConfig) ? ruleConfig[0] : ruleConfig;
    if (typeof severity2 === "string") {
      severity2 = severity2.toLowerCase();
    }
    return VALID_SEVERITIES.has(severity2);
  }
  function isEverySeverityValid(config2) {
    return Object.keys(config2).every((ruleId) => isValidSeverity(config2[ruleId]));
  }
  function normalizeConfigGlobal(configuredValue) {
    switch (configuredValue) {
      case "off":
        return "off";
      case true:
      case "true":
      case "writeable":
      case "writable":
        return "writable";
      case null:
      case false:
      case "false":
      case "readable":
      case "readonly":
        return "readonly";
      default:
        throw new Error(`'${configuredValue}' is not a valid configuration for a global (use 'readonly', 'writable', or 'off')`);
    }
  }
  var ConfigOps = {
    __proto__: null,
    getRuleSeverity,
    normalizeToStrings,
    isErrorSeverity,
    isValidSeverity,
    isEverySeverityValid,
    normalizeConfigGlobal
  };
  const deprecationWarningMessages = {
    ESLINT_LEGACY_ECMAFEATURES: "The 'ecmaFeatures' config file property is deprecated and has no effect.",
    ESLINT_PERSONAL_CONFIG_LOAD: "'~/.eslintrc.*' config files have been deprecated. Please use a config file per project or the '--config' option.",
    ESLINT_PERSONAL_CONFIG_SUPPRESS: "'~/.eslintrc.*' config files have been deprecated. Please remove it or add 'root:true' to the config files in your projects in order to avoid loading '~/.eslintrc.*' accidentally."
  };
  const sourceFileErrorCache = /* @__PURE__ */ new Set();
  function emitDeprecationWarning(source, errorCode) {
    const cacheKey = JSON.stringify({ source, errorCode });
    if (sourceFileErrorCache.has(cacheKey)) {
      return;
    }
    sourceFileErrorCache.add(cacheKey);
    const rel = path__default["default"].relative(process.cwd(), source);
    const message = deprecationWarningMessages[errorCode];
    process.emitWarning(
      `${message} (found in "${rel}")`,
      "DeprecationWarning",
      errorCode
    );
  }
  const metaSchema = {
    id: "http://json-schema.org/draft-04/schema#",
    $schema: "http://json-schema.org/draft-04/schema#",
    description: "Core schema meta-schema",
    definitions: {
      schemaArray: {
        type: "array",
        minItems: 1,
        items: { $ref: "#" }
      },
      positiveInteger: {
        type: "integer",
        minimum: 0
      },
      positiveIntegerDefault0: {
        allOf: [{ $ref: "#/definitions/positiveInteger" }, { default: 0 }]
      },
      simpleTypes: {
        enum: ["array", "boolean", "integer", "null", "number", "object", "string"]
      },
      stringArray: {
        type: "array",
        items: { type: "string" },
        minItems: 1,
        uniqueItems: true
      }
    },
    type: "object",
    properties: {
      id: {
        type: "string"
      },
      $schema: {
        type: "string"
      },
      title: {
        type: "string"
      },
      description: {
        type: "string"
      },
      default: {},
      multipleOf: {
        type: "number",
        minimum: 0,
        exclusiveMinimum: true
      },
      maximum: {
        type: "number"
      },
      exclusiveMaximum: {
        type: "boolean",
        default: false
      },
      minimum: {
        type: "number"
      },
      exclusiveMinimum: {
        type: "boolean",
        default: false
      },
      maxLength: { $ref: "#/definitions/positiveInteger" },
      minLength: { $ref: "#/definitions/positiveIntegerDefault0" },
      pattern: {
        type: "string",
        format: "regex"
      },
      additionalItems: {
        anyOf: [
          { type: "boolean" },
          { $ref: "#" }
        ],
        default: {}
      },
      items: {
        anyOf: [
          { $ref: "#" },
          { $ref: "#/definitions/schemaArray" }
        ],
        default: {}
      },
      maxItems: { $ref: "#/definitions/positiveInteger" },
      minItems: { $ref: "#/definitions/positiveIntegerDefault0" },
      uniqueItems: {
        type: "boolean",
        default: false
      },
      maxProperties: { $ref: "#/definitions/positiveInteger" },
      minProperties: { $ref: "#/definitions/positiveIntegerDefault0" },
      required: { $ref: "#/definitions/stringArray" },
      additionalProperties: {
        anyOf: [
          { type: "boolean" },
          { $ref: "#" }
        ],
        default: {}
      },
      definitions: {
        type: "object",
        additionalProperties: { $ref: "#" },
        default: {}
      },
      properties: {
        type: "object",
        additionalProperties: { $ref: "#" },
        default: {}
      },
      patternProperties: {
        type: "object",
        additionalProperties: { $ref: "#" },
        default: {}
      },
      dependencies: {
        type: "object",
        additionalProperties: {
          anyOf: [
            { $ref: "#" },
            { $ref: "#/definitions/stringArray" }
          ]
        }
      },
      enum: {
        type: "array",
        minItems: 1,
        uniqueItems: true
      },
      type: {
        anyOf: [
          { $ref: "#/definitions/simpleTypes" },
          {
            type: "array",
            items: { $ref: "#/definitions/simpleTypes" },
            minItems: 1,
            uniqueItems: true
          }
        ]
      },
      format: { type: "string" },
      allOf: { $ref: "#/definitions/schemaArray" },
      anyOf: { $ref: "#/definitions/schemaArray" },
      oneOf: { $ref: "#/definitions/schemaArray" },
      not: { $ref: "#" }
    },
    dependencies: {
      exclusiveMaximum: ["maximum"],
      exclusiveMinimum: ["minimum"]
    },
    default: {}
  };
  var ajvOrig = (additionalOptions = {}) => {
    const ajv3 = new Ajv__default["default"]({
      meta: false,
      useDefaults: true,
      validateSchema: false,
      missingRefs: "ignore",
      verbose: true,
      schemaId: "auto",
      ...additionalOptions
    });
    ajv3.addMetaSchema(metaSchema);
    ajv3._opts.defaultMeta = metaSchema.id;
    return ajv3;
  };
  function isObjectNotArray(value) {
    return typeof value === "object" && value !== null && !Array.isArray(value);
  }
  function deepMergeObjects(first, second) {
    if (second === void 0) {
      return first;
    }
    if (!isObjectNotArray(first) || !isObjectNotArray(second)) {
      return second;
    }
    const result = { ...first, ...second };
    for (const key of Object.keys(second)) {
      if (Object.prototype.propertyIsEnumerable.call(first, key)) {
        result[key] = deepMergeObjects(first[key], second[key]);
      }
    }
    return result;
  }
  function deepMergeArrays(first, second) {
    if (!first || !second) {
      return second || first || [];
    }
    return [
      ...first.map((value, i2) => deepMergeObjects(value, second[i2])),
      ...second.slice(first.length)
    ];
  }
  const baseConfigProperties = {
    $schema: { type: "string" },
    env: { type: "object" },
    extends: { $ref: "#/definitions/stringOrStrings" },
    globals: { type: "object" },
    overrides: {
      type: "array",
      items: { $ref: "#/definitions/overrideConfig" },
      additionalItems: false
    },
    parser: { type: ["string", "null"] },
    parserOptions: { type: "object" },
    plugins: { type: "array" },
    processor: { type: "string" },
    rules: { type: "object" },
    settings: { type: "object" },
    noInlineConfig: { type: "boolean" },
    reportUnusedDisableDirectives: { type: "boolean" },
    ecmaFeatures: { type: "object" }
    // deprecated; logs a warning when used
  };
  const configSchema = {
    definitions: {
      stringOrStrings: {
        oneOf: [
          { type: "string" },
          {
            type: "array",
            items: { type: "string" },
            additionalItems: false
          }
        ]
      },
      stringOrStringsRequired: {
        oneOf: [
          { type: "string" },
          {
            type: "array",
            items: { type: "string" },
            additionalItems: false,
            minItems: 1
          }
        ]
      },
      // Config at top-level.
      objectConfig: {
        type: "object",
        properties: {
          root: { type: "boolean" },
          ignorePatterns: { $ref: "#/definitions/stringOrStrings" },
          ...baseConfigProperties
        },
        additionalProperties: false
      },
      // Config in `overrides`.
      overrideConfig: {
        type: "object",
        properties: {
          excludedFiles: { $ref: "#/definitions/stringOrStrings" },
          files: { $ref: "#/definitions/stringOrStringsRequired" },
          ...baseConfigProperties
        },
        required: ["files"],
        additionalProperties: false
      }
    },
    $ref: "#/definitions/objectConfig"
  };
  function getDiff(current, prev) {
    const retv = {};
    for (const [key, value] of Object.entries(current)) {
      if (!Object.hasOwn(prev, key)) {
        retv[key] = value;
      }
    }
    return retv;
  }
  const newGlobals2015 = getDiff(globals__default["default"].es2015, globals__default["default"].es5);
  const newGlobals2017 = {
    Atomics: false,
    SharedArrayBuffer: false
  };
  const newGlobals2020 = {
    BigInt: false,
    BigInt64Array: false,
    BigUint64Array: false,
    globalThis: false
  };
  const newGlobals2021 = {
    AggregateError: false,
    FinalizationRegistry: false,
    WeakRef: false
  };
  var environments = new Map(Object.entries({
    // Language
    builtin: {
      globals: globals__default["default"].es5
    },
    es6: {
      globals: newGlobals2015,
      parserOptions: {
        ecmaVersion: 6
      }
    },
    es2015: {
      globals: newGlobals2015,
      parserOptions: {
        ecmaVersion: 6
      }
    },
    es2016: {
      globals: newGlobals2015,
      parserOptions: {
        ecmaVersion: 7
      }
    },
    es2017: {
      globals: { ...newGlobals2015, ...newGlobals2017 },
      parserOptions: {
        ecmaVersion: 8
      }
    },
    es2018: {
      globals: { ...newGlobals2015, ...newGlobals2017 },
      parserOptions: {
        ecmaVersion: 9
      }
    },
    es2019: {
      globals: { ...newGlobals2015, ...newGlobals2017 },
      parserOptions: {
        ecmaVersion: 10
      }
    },
    es2020: {
      globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020 },
      parserOptions: {
        ecmaVersion: 11
      }
    },
    es2021: {
      globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
      parserOptions: {
        ecmaVersion: 12
      }
    },
    es2022: {
      globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
      parserOptions: {
        ecmaVersion: 13
      }
    },
    es2023: {
      globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
      parserOptions: {
        ecmaVersion: 14
      }
    },
    es2024: {
      globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
      parserOptions: {
        ecmaVersion: 15
      }
    },
    // Platforms
    browser: {
      globals: globals__default["default"].browser
    },
    node: {
      globals: globals__default["default"].node,
      parserOptions: {
        ecmaFeatures: {
          globalReturn: true
        }
      }
    },
    "shared-node-browser": {
      globals: globals__default["default"]["shared-node-browser"]
    },
    worker: {
      globals: globals__default["default"].worker
    },
    serviceworker: {
      globals: globals__default["default"].serviceworker
    },
    // Frameworks
    commonjs: {
      globals: globals__default["default"].commonjs,
      parserOptions: {
        ecmaFeatures: {
          globalReturn: true
        }
      }
    },
    amd: {
      globals: globals__default["default"].amd
    },
    mocha: {
      globals: globals__default["default"].mocha
    },
    jasmine: {
      globals: globals__default["default"].jasmine
    },
    jest: {
      globals: globals__default["default"].jest
    },
    phantomjs: {
      globals: globals__default["default"].phantomjs
    },
    jquery: {
      globals: globals__default["default"].jquery
    },
    qunit: {
      globals: globals__default["default"].qunit
    },
    prototypejs: {
      globals: globals__default["default"].prototypejs
    },
    shelljs: {
      globals: globals__default["default"].shelljs
    },
    meteor: {
      globals: globals__default["default"].meteor
    },
    mongo: {
      globals: globals__default["default"].mongo
    },
    protractor: {
      globals: globals__default["default"].protractor
    },
    applescript: {
      globals: globals__default["default"].applescript
    },
    nashorn: {
      globals: globals__default["default"].nashorn
    },
    atomtest: {
      globals: globals__default["default"].atomtest
    },
    embertest: {
      globals: globals__default["default"].embertest
    },
    webextensions: {
      globals: globals__default["default"].webextensions
    },
    greasemonkey: {
      globals: globals__default["default"].greasemonkey
    }
  }));
  const ajv2 = ajvOrig();
  const ruleValidators = /* @__PURE__ */ new WeakMap();
  const noop2 = Function.prototype;
  let validateSchema;
  const severityMap = {
    error: 2,
    warn: 1,
    off: 0
  };
  const validated = /* @__PURE__ */ new WeakSet();
  const noOptionsSchema = Object.freeze({
    type: "array",
    minItems: 0,
    maxItems: 0
  });
  class ConfigValidator {
    constructor({ builtInRules = /* @__PURE__ */ new Map() } = {}) {
      this.builtInRules = builtInRules;
    }
    /**
     * Gets a complete options schema for a rule.
     * @param {Rule} rule A rule object
     * @throws {TypeError} If `meta.schema` is specified but is not an array, object or `false`.
     * @returns {Object|null} JSON Schema for the rule's options.
     *      `null` if rule wasn't passed or its `meta.schema` is `false`.
     */
    getRuleOptionsSchema(rule) {
      if (!rule) {
        return null;
      }
      if (!rule.meta) {
        return { ...noOptionsSchema };
      }
      const schema = rule.meta.schema;
      if (typeof schema === "undefined") {
        return { ...noOptionsSchema };
      }
      if (schema === false) {
        return null;
      }
      if (typeof schema !== "object" || schema === null) {
        throw new TypeError("Rule's `meta.schema` must be an array or object");
      }
      if (Array.isArray(schema)) {
        if (schema.length) {
          return {
            type: "array",
            items: schema,
            minItems: 0,
            maxItems: schema.length
          };
        }
        return { ...noOptionsSchema };
      }
      return schema;
    }
    /**
     * Validates a rule's severity and returns the severity value. Throws an error if the severity is invalid.
     * @param {options} options The given options for the rule.
     * @returns {number|string} The rule's severity value
     * @throws {Error} If the severity is invalid.
     */
    validateRuleSeverity(options) {
      const severity2 = Array.isArray(options) ? options[0] : options;
      const normSeverity = typeof severity2 === "string" ? severityMap[severity2.toLowerCase()] : severity2;
      if (normSeverity === 0 || normSeverity === 1 || normSeverity === 2) {
        return normSeverity;
      }
      throw new Error(`	Severity should be one of the following: 0 = off, 1 = warn, 2 = error (you passed '${util__default["default"].inspect(severity2).replace(/'/gu, '"').replace(/\n/gu, "")}').
`);
    }
    /**
     * Validates the non-severity options passed to a rule, based on its schema.
     * @param {{create: Function}} rule The rule to validate
     * @param {Array} localOptions The options for the rule, excluding severity
     * @returns {void}
     * @throws {Error} If the options are invalid.
     */
    validateRuleSchema(rule, localOptions) {
      if (!ruleValidators.has(rule)) {
        try {
          const schema = this.getRuleOptionsSchema(rule);
          if (schema) {
            ruleValidators.set(rule, ajv2.compile(schema));
          }
        } catch (err) {
          const errorWithCode = new Error(err.message, { cause: err });
          errorWithCode.code = "ESLINT_INVALID_RULE_OPTIONS_SCHEMA";
          throw errorWithCode;
        }
      }
      const validateRule = ruleValidators.get(rule);
      if (validateRule) {
        const mergedOptions = deepMergeArrays(rule.meta?.defaultOptions, localOptions);
        validateRule(mergedOptions);
        if (validateRule.errors) {
          throw new Error(validateRule.errors.map(
            (error) => `	Value ${JSON.stringify(error.data)} ${error.message}.
`
          ).join(""));
        }
      }
    }
    /**
     * Validates a rule's options against its schema.
     * @param {{create: Function}|null} rule The rule that the config is being validated for
     * @param {string} ruleId The rule's unique name.
     * @param {Array|number} options The given options for the rule.
     * @param {string|null} source The name of the configuration source to report in any errors. If null or undefined,
     * no source is prepended to the message.
     * @returns {void}
     * @throws {Error} If the options are invalid.
     */
    validateRuleOptions(rule, ruleId, options, source = null) {
      try {
        const severity2 = this.validateRuleSeverity(options);
        if (severity2 !== 0) {
          this.validateRuleSchema(rule, Array.isArray(options) ? options.slice(1) : []);
        }
      } catch (err) {
        let enhancedMessage = err.code === "ESLINT_INVALID_RULE_OPTIONS_SCHEMA" ? `Error while processing options validation schema of rule '${ruleId}': ${err.message}` : `Configuration for rule "${ruleId}" is invalid:
${err.message}`;
        if (typeof source === "string") {
          enhancedMessage = `${source}:
	${enhancedMessage}`;
        }
        const enhancedError = new Error(enhancedMessage, { cause: err });
        if (err.code) {
          enhancedError.code = err.code;
        }
        throw enhancedError;
      }
    }
    /**
     * Validates an environment object
     * @param {Object} environment The environment config object to validate.
     * @param {string} source The name of the configuration source to report in any errors.
     * @param {(envId:string) => Object} [getAdditionalEnv] A map from strings to loaded environments.
     * @returns {void}
     * @throws {Error} If the environment is invalid.
     */
    validateEnvironment(environment, source, getAdditionalEnv = noop2) {
      if (!environment) {
        return;
      }
      Object.keys(environment).forEach((id2) => {
        const env2 = getAdditionalEnv(id2) || environments.get(id2) || null;
        if (!env2) {
          const message = `${source}:
	Environment key "${id2}" is unknown
`;
          throw new Error(message);
        }
      });
    }
    /**
     * Validates a rules config object
     * @param {Object} rulesConfig The rules config object to validate.
     * @param {string} source The name of the configuration source to report in any errors.
     * @param {(ruleId:string) => Object} getAdditionalRule A map from strings to loaded rules
     * @returns {void}
     */
    validateRules(rulesConfig, source, getAdditionalRule = noop2) {
      if (!rulesConfig) {
        return;
      }
      Object.keys(rulesConfig).forEach((id2) => {
        const rule = getAdditionalRule(id2) || this.builtInRules.get(id2) || null;
        this.validateRuleOptions(rule, id2, rulesConfig[id2], source);
      });
    }
    /**
     * Validates a `globals` section of a config file
     * @param {Object} globalsConfig The `globals` section
     * @param {string|null} source The name of the configuration source to report in the event of an error.
     * @returns {void}
     */
    validateGlobals(globalsConfig, source = null) {
      if (!globalsConfig) {
        return;
      }
      Object.entries(globalsConfig).forEach(([configuredGlobal, configuredValue]) => {
        try {
          normalizeConfigGlobal(configuredValue);
        } catch (err) {
          throw new Error(`ESLint configuration of global '${configuredGlobal}' in ${source} is invalid:
${err.message}`);
        }
      });
    }
    /**
     * Validate `processor` configuration.
     * @param {string|undefined} processorName The processor name.
     * @param {string} source The name of config file.
     * @param {(id:string) => Processor} getProcessor The getter of defined processors.
     * @returns {void}
     * @throws {Error} If the processor is invalid.
     */
    validateProcessor(processorName, source, getProcessor) {
      if (processorName && !getProcessor(processorName)) {
        throw new Error(`ESLint configuration of processor in '${source}' is invalid: '${processorName}' was not found.`);
      }
    }
    /**
     * Formats an array of schema validation errors.
     * @param {Array} errors An array of error messages to format.
     * @returns {string} Formatted error message
     */
    formatErrors(errors) {
      return errors.map((error) => {
        if (error.keyword === "additionalProperties") {
          const formattedPropertyPath = error.dataPath.length ? `${error.dataPath.slice(1)}.${error.params.additionalProperty}` : error.params.additionalProperty;
          return `Unexpected top-level property "${formattedPropertyPath}"`;
        }
        if (error.keyword === "type") {
          const formattedField = error.dataPath.slice(1);
          const formattedExpectedType = Array.isArray(error.schema) ? error.schema.join("/") : error.schema;
          const formattedValue = JSON.stringify(error.data);
          return `Property "${formattedField}" is the wrong type (expected ${formattedExpectedType} but got \`${formattedValue}\`)`;
        }
        const field = error.dataPath[0] === "." ? error.dataPath.slice(1) : error.dataPath;
        return `"${field}" ${error.message}. Value: ${JSON.stringify(error.data)}`;
      }).map((message) => `	- ${message}.
`).join("");
    }
    /**
     * Validates the top level properties of the config object.
     * @param {Object} config The config object to validate.
     * @param {string} source The name of the configuration source to report in any errors.
     * @returns {void}
     * @throws {Error} If the config is invalid.
     */
    validateConfigSchema(config2, source = null) {
      validateSchema = validateSchema || ajv2.compile(configSchema);
      if (!validateSchema(config2)) {
        throw new Error(`ESLint configuration in ${source} is invalid:
${this.formatErrors(validateSchema.errors)}`);
      }
      if (Object.hasOwn(config2, "ecmaFeatures")) {
        emitDeprecationWarning(source, "ESLINT_LEGACY_ECMAFEATURES");
      }
    }
    /**
     * Validates an entire config object.
     * @param {Object} config The config object to validate.
     * @param {string} source The name of the configuration source to report in any errors.
     * @param {(ruleId:string) => Object} [getAdditionalRule] A map from strings to loaded rules.
     * @param {(envId:string) => Object} [getAdditionalEnv] A map from strings to loaded envs.
     * @returns {void}
     */
    validate(config2, source, getAdditionalRule, getAdditionalEnv) {
      this.validateConfigSchema(config2, source);
      this.validateRules(config2.rules, source, getAdditionalRule);
      this.validateEnvironment(config2.env, source, getAdditionalEnv);
      this.validateGlobals(config2.globals, source);
      for (const override of config2.overrides || []) {
        this.validateRules(override.rules, source, getAdditionalRule);
        this.validateEnvironment(override.env, source, getAdditionalEnv);
        this.validateGlobals(config2.globals, source);
      }
    }
    /**
     * Validate config array object.
     * @param {ConfigArray} configArray The config array to validate.
     * @returns {void}
     */
    validateConfigArray(configArray) {
      const getPluginEnv = Map.prototype.get.bind(configArray.pluginEnvironments);
      const getPluginProcessor = Map.prototype.get.bind(configArray.pluginProcessors);
      const getPluginRule = Map.prototype.get.bind(configArray.pluginRules);
      for (const element of configArray) {
        if (validated.has(element)) {
          continue;
        }
        validated.add(element);
        this.validateEnvironment(element.env, element.name, getPluginEnv);
        this.validateGlobals(element.globals, element.name);
        this.validateProcessor(element.processor, element.name, getPluginProcessor);
        this.validateRules(element.rules, element.name, getPluginRule);
      }
    }
  }
  const NAMESPACE_REGEX = /^@.*\//iu;
  function normalizePackageName(name, prefix) {
    let normalizedName = name;
    if (normalizedName.includes("\\")) {
      normalizedName = normalizedName.replace(/\\/gu, "/");
    }
    if (normalizedName.charAt(0) === "@") {
      const scopedPackageShortcutRegex = new RegExp(`^(@[^/]+)(?:/(?:${prefix})?)?$`, "u"), scopedPackageNameRegex = new RegExp(`^${prefix}(-|$)`, "u");
      if (scopedPackageShortcutRegex.test(normalizedName)) {
        normalizedName = normalizedName.replace(scopedPackageShortcutRegex, `$1/${prefix}`);
      } else if (!scopedPackageNameRegex.test(normalizedName.split("/")[1])) {
        normalizedName = normalizedName.replace(/^@([^/]+)\/(.*)$/u, `@$1/${prefix}-$2`);
      }
    } else if (!normalizedName.startsWith(`${prefix}-`)) {
      normalizedName = `${prefix}-${normalizedName}`;
    }
    return normalizedName;
  }
  function getShorthandName(fullname, prefix) {
    if (fullname[0] === "@") {
      let matchResult = new RegExp(`^(@[^/]+)/${prefix}$`, "u").exec(fullname);
      if (matchResult) {
        return matchResult[1];
      }
      matchResult = new RegExp(`^(@[^/]+)/${prefix}-(.+)$`, "u").exec(fullname);
      if (matchResult) {
        return `${matchResult[1]}/${matchResult[2]}`;
      }
    } else if (fullname.startsWith(`${prefix}-`)) {
      return fullname.slice(prefix.length + 1);
    }
    return fullname;
  }
  function getNamespaceFromTerm(term) {
    const match = term.match(NAMESPACE_REGEX);
    return match ? match[0] : "";
  }
  var naming = {
    __proto__: null,
    normalizePackageName,
    getShorthandName,
    getNamespaceFromTerm
  };
  const Legacy = {
    environments,
    // shared
    ConfigOps,
    ConfigValidator,
    naming
  };
  eslintrcUniversal.Legacy = Legacy;
  return eslintrcUniversal;
}
var src = { exports: {} };
var browser = { exports: {} };
var ms;
var hasRequiredMs;
function requireMs() {
  if (hasRequiredMs) return ms;
  hasRequiredMs = 1;
  var s2 = 1e3;
  var m2 = s2 * 60;
  var h2 = m2 * 60;
  var d2 = h2 * 24;
  var w = d2 * 7;
  var y2 = d2 * 365.25;
  ms = function(val, options) {
    options = options || {};
    var type2 = typeof val;
    if (type2 === "string" && val.length > 0) {
      return parse(val);
    } else if (type2 === "number" && isFinite(val)) {
      return options.long ? fmtLong(val) : fmtShort(val);
    }
    throw new Error(
      "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
    );
  };
  function parse(str) {
    str = String(str);
    if (str.length > 100) {
      return;
    }
    var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
      str
    );
    if (!match) {
      return;
    }
    var n2 = parseFloat(match[1]);
    var type2 = (match[2] || "ms").toLowerCase();
    switch (type2) {
      case "years":
      case "year":
      case "yrs":
      case "yr":
      case "y":
        return n2 * y2;
      case "weeks":
      case "week":
      case "w":
        return n2 * w;
      case "days":
      case "day":
      case "d":
        return n2 * d2;
      case "hours":
      case "hour":
      case "hrs":
      case "hr":
      case "h":
        return n2 * h2;
      case "minutes":
      case "minute":
      case "mins":
      case "min":
      case "m":
        return n2 * m2;
      case "seconds":
      case "second":
      case "secs":
      case "sec":
      case "s":
        return n2 * s2;
      case "milliseconds":
      case "millisecond":
      case "msecs":
      case "msec":
      case "ms":
        return n2;
      default:
        return void 0;
    }
  }
  function fmtShort(ms2) {
    var msAbs = Math.abs(ms2);
    if (msAbs >= d2) {
      return Math.round(ms2 / d2) + "d";
    }
    if (msAbs >= h2) {
      return Math.round(ms2 / h2) + "h";
    }
    if (msAbs >= m2) {
      return Math.round(ms2 / m2) + "m";
    }
    if (msAbs >= s2) {
      return Math.round(ms2 / s2) + "s";
    }
    return ms2 + "ms";
  }
  function fmtLong(ms2) {
    var msAbs = Math.abs(ms2);
    if (msAbs >= d2) {
      return plural(ms2, msAbs, d2, "day");
    }
    if (msAbs >= h2) {
      return plural(ms2, msAbs, h2, "hour");
    }
    if (msAbs >= m2) {
      return plural(ms2, msAbs, m2, "minute");
    }
    if (msAbs >= s2) {
      return plural(ms2, msAbs, s2, "second");
    }
    return ms2 + " ms";
  }
  function plural(ms2, msAbs, n2, name) {
    var isPlural = msAbs >= n2 * 1.5;
    return Math.round(ms2 / n2) + " " + name + (isPlural ? "s" : "");
  }
  return ms;
}
var common;
var hasRequiredCommon;
function requireCommon() {
  if (hasRequiredCommon) return common;
  hasRequiredCommon = 1;
  function setup(env2) {
    createDebug.debug = createDebug;
    createDebug.default = createDebug;
    createDebug.coerce = coerce;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = requireMs();
    createDebug.destroy = destroy;
    Object.keys(env2).forEach((key) => {
      createDebug[key] = env2[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};
    function selectColor(namespace) {
      let hash = 0;
      for (let i2 = 0; i2 < namespace.length; i2++) {
        hash = (hash << 5) - hash + namespace.charCodeAt(i2);
        hash |= 0;
      }
      return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    }
    createDebug.selectColor = selectColor;
    function createDebug(namespace) {
      let prevTime;
      let enableOverride = null;
      let namespacesCache;
      let enabledCache;
      function debug(...args) {
        if (!debug.enabled) {
          return;
        }
        const self2 = debug;
        const curr = Number(/* @__PURE__ */ new Date());
        const ms2 = curr - (prevTime || curr);
        self2.diff = ms2;
        self2.prev = prevTime;
        self2.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);
        if (typeof args[0] !== "string") {
          args.unshift("%O");
        }
        let index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format2) => {
          if (match === "%%") {
            return "%";
          }
          index++;
          const formatter = createDebug.formatters[format2];
          if (typeof formatter === "function") {
            const val = args[index];
            match = formatter.call(self2, val);
            args.splice(index, 1);
            index--;
          }
          return match;
        });
        createDebug.formatArgs.call(self2, args);
        const logFn = self2.log || createDebug.log;
        logFn.apply(self2, args);
      }
      debug.namespace = namespace;
      debug.useColors = createDebug.useColors();
      debug.color = createDebug.selectColor(namespace);
      debug.extend = extend;
      debug.destroy = createDebug.destroy;
      Object.defineProperty(debug, "enabled", {
        enumerable: true,
        configurable: false,
        get: () => {
          if (enableOverride !== null) {
            return enableOverride;
          }
          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }
          return enabledCache;
        },
        set: (v2) => {
          enableOverride = v2;
        }
      });
      if (typeof createDebug.init === "function") {
        createDebug.init(debug);
      }
      return debug;
    }
    function extend(namespace, delimiter2) {
      const newDebug = createDebug(this.namespace + (typeof delimiter2 === "undefined" ? ":" : delimiter2) + namespace);
      newDebug.log = this.log;
      return newDebug;
    }
    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(" ", ",").split(",").filter(Boolean);
      for (const ns of split) {
        if (ns[0] === "-") {
          createDebug.skips.push(ns.slice(1));
        } else {
          createDebug.names.push(ns);
        }
      }
    }
    function matchesTemplate(search, template) {
      let searchIndex = 0;
      let templateIndex = 0;
      let starIndex = -1;
      let matchIndex = 0;
      while (searchIndex < search.length) {
        if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
          if (template[templateIndex] === "*") {
            starIndex = templateIndex;
            matchIndex = searchIndex;
            templateIndex++;
          } else {
            searchIndex++;
            templateIndex++;
          }
        } else if (starIndex !== -1) {
          templateIndex = starIndex + 1;
          matchIndex++;
          searchIndex = matchIndex;
        } else {
          return false;
        }
      }
      while (templateIndex < template.length && template[templateIndex] === "*") {
        templateIndex++;
      }
      return templateIndex === template.length;
    }
    function disable() {
      const namespaces = [
        ...createDebug.names,
        ...createDebug.skips.map((namespace) => "-" + namespace)
      ].join(",");
      createDebug.enable("");
      return namespaces;
    }
    function enabled(name) {
      for (const skip of createDebug.skips) {
        if (matchesTemplate(name, skip)) {
          return false;
        }
      }
      for (const ns of createDebug.names) {
        if (matchesTemplate(name, ns)) {
          return true;
        }
      }
      return false;
    }
    function coerce(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }
      return val;
    }
    function destroy() {
      console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
    }
    createDebug.enable(createDebug.load());
    return createDebug;
  }
  common = setup;
  return common;
}
var hasRequiredBrowser;
function requireBrowser() {
  if (hasRequiredBrowser) return browser.exports;
  hasRequiredBrowser = 1;
  (function(module, exports$1) {
    exports$1.formatArgs = formatArgs;
    exports$1.save = save;
    exports$1.load = load;
    exports$1.useColors = useColors;
    exports$1.storage = localstorage();
    exports$1.destroy = /* @__PURE__ */ (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports$1.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      let m2;
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
      typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
      // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
      typeof navigator !== "undefined" && navigator.userAgent && (m2 = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m2[1], 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c2 = "color: " + this.color;
      args.splice(1, 0, c2, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c2);
    }
    exports$1.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports$1.storage.setItem("debug", namespaces);
        } else {
          exports$1.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    function load() {
      let r2;
      try {
        r2 = exports$1.storage.getItem("debug");
      } catch (error) {
      }
      if (!r2 && typeof browser$1$1 !== "undefined" && "env" in browser$1$1) {
        r2 = browser$1$1.env.DEBUG;
      }
      return r2;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    module.exports = requireCommon()(exports$1);
    const { formatters } = module.exports;
    formatters.j = function(v2) {
      try {
        return JSON.stringify(v2);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  })(browser, browser.exports);
  return browser.exports;
}
var hasRequiredSrc;
function requireSrc() {
  if (hasRequiredSrc) return src.exports;
  hasRequiredSrc = 1;
  {
    src.exports = requireBrowser();
  }
  return src.exports;
}
var traverser;
var hasRequiredTraverser;
function requireTraverser() {
  if (hasRequiredTraverser) return traverser;
  hasRequiredTraverser = 1;
  const vk = requireEslintVisitorKeys$2();
  const debug = requireSrc()("eslint:traverser");
  function noop2() {
  }
  function isNode(x2) {
    return x2 !== null && typeof x2 === "object" && typeof x2.type === "string";
  }
  function getVisitorKeys(visitorKeys, node2) {
    let keys = visitorKeys[node2.type];
    if (!keys) {
      keys = vk.getKeys(node2);
      debug(
        'Unknown node type "%s": Estimated visitor keys %j',
        node2.type,
        keys
      );
    }
    return keys;
  }
  class Traverser {
    constructor() {
      this._current = null;
      this._parents = [];
      this._skipped = false;
      this._broken = false;
      this._visitorKeys = null;
      this._enter = null;
      this._leave = null;
    }
    /**
     * Gives current node.
     * @returns {ASTNode} The current node.
     */
    current() {
      return this._current;
    }
    /**
     * Gives a copy of the ancestor nodes.
     * @returns {ASTNode[]} The ancestor nodes.
     */
    parents() {
      return this._parents.slice(0);
    }
    /**
     * Break the current traversal.
     * @returns {void}
     */
    break() {
      this._broken = true;
    }
    /**
     * Skip child nodes for the current traversal.
     * @returns {void}
     */
    skip() {
      this._skipped = true;
    }
    /**
     * Traverse the given AST tree.
     * @param {ASTNode} node The root node to traverse.
     * @param {Object} options The option object.
     * @param {Object} [options.visitorKeys=DEFAULT_VISITOR_KEYS] The keys of each node types to traverse child nodes. Default is `./default-visitor-keys.json`.
     * @param {Function} [options.enter=noop] The callback function which is called on entering each node.
     * @param {Function} [options.leave=noop] The callback function which is called on leaving each node.
     * @returns {void}
     */
    traverse(node2, options) {
      this._current = null;
      this._parents = [];
      this._skipped = false;
      this._broken = false;
      this._visitorKeys = options.visitorKeys || vk.KEYS;
      this._enter = options.enter || noop2;
      this._leave = options.leave || noop2;
      this._traverse(node2, null);
    }
    /**
     * Traverse the given AST tree recursively.
     * @param {ASTNode} node The current node.
     * @param {ASTNode|null} parent The parent node.
     * @returns {void}
     * @private
     */
    _traverse(node2, parent) {
      if (!isNode(node2)) {
        return;
      }
      this._current = node2;
      this._skipped = false;
      this._enter(node2, parent);
      if (!this._skipped && !this._broken) {
        const keys = getVisitorKeys(this._visitorKeys, node2);
        if (keys.length >= 1) {
          this._parents.push(node2);
          for (let i2 = 0; i2 < keys.length && !this._broken; ++i2) {
            const child = node2[keys[i2]];
            if (Array.isArray(child)) {
              for (let j = 0; j < child.length && !this._broken; ++j) {
                this._traverse(child[j], node2);
              }
            } else {
              this._traverse(child, node2);
            }
          }
          this._parents.pop();
        }
      }
      if (!this._broken) {
        this._leave(node2, parent);
      }
      this._current = parent;
    }
    /**
     * Calculates the keys to use for traversal.
     * @param {ASTNode} node The node to read keys from.
     * @returns {string[]} An array of keys to visit on the node.
     * @private
     */
    static getKeys(node2) {
      return vk.getKeys(node2);
    }
    /**
     * Traverse the given AST tree.
     * @param {ASTNode} node The root node to traverse.
     * @param {Object} options The option object.
     * @param {Object} [options.visitorKeys=DEFAULT_VISITOR_KEYS] The keys of each node types to traverse child nodes. Default is `./default-visitor-keys.json`.
     * @param {Function} [options.enter=noop] The callback function which is called on entering each node.
     * @param {Function} [options.leave=noop] The callback function which is called on leaving each node.
     * @returns {void}
     */
    static traverse(node2, options) {
      new Traverser().traverse(node2, options);
    }
    /**
     * The default visitor keys.
     * @type {Object}
     */
    static get DEFAULT_VISITOR_KEYS() {
      return vk.KEYS;
    }
  }
  traverser = Traverser;
  return traverser;
}
var eslintUtils = {};
var eslintVisitorKeys = {};
var hasRequiredEslintVisitorKeys;
function requireEslintVisitorKeys() {
  if (hasRequiredEslintVisitorKeys) return eslintVisitorKeys;
  hasRequiredEslintVisitorKeys = 1;
  Object.defineProperty(eslintVisitorKeys, "__esModule", { value: true });
  const KEYS = {
    ArrayExpression: [
      "elements"
    ],
    ArrayPattern: [
      "elements"
    ],
    ArrowFunctionExpression: [
      "params",
      "body"
    ],
    AssignmentExpression: [
      "left",
      "right"
    ],
    AssignmentPattern: [
      "left",
      "right"
    ],
    AwaitExpression: [
      "argument"
    ],
    BinaryExpression: [
      "left",
      "right"
    ],
    BlockStatement: [
      "body"
    ],
    BreakStatement: [
      "label"
    ],
    CallExpression: [
      "callee",
      "arguments"
    ],
    CatchClause: [
      "param",
      "body"
    ],
    ChainExpression: [
      "expression"
    ],
    ClassBody: [
      "body"
    ],
    ClassDeclaration: [
      "id",
      "superClass",
      "body"
    ],
    ClassExpression: [
      "id",
      "superClass",
      "body"
    ],
    ConditionalExpression: [
      "test",
      "consequent",
      "alternate"
    ],
    ContinueStatement: [
      "label"
    ],
    DebuggerStatement: [],
    DoWhileStatement: [
      "body",
      "test"
    ],
    EmptyStatement: [],
    ExperimentalRestProperty: [
      "argument"
    ],
    ExperimentalSpreadProperty: [
      "argument"
    ],
    ExportAllDeclaration: [
      "exported",
      "source"
    ],
    ExportDefaultDeclaration: [
      "declaration"
    ],
    ExportNamedDeclaration: [
      "declaration",
      "specifiers",
      "source"
    ],
    ExportSpecifier: [
      "exported",
      "local"
    ],
    ExpressionStatement: [
      "expression"
    ],
    ForInStatement: [
      "left",
      "right",
      "body"
    ],
    ForOfStatement: [
      "left",
      "right",
      "body"
    ],
    ForStatement: [
      "init",
      "test",
      "update",
      "body"
    ],
    FunctionDeclaration: [
      "id",
      "params",
      "body"
    ],
    FunctionExpression: [
      "id",
      "params",
      "body"
    ],
    Identifier: [],
    IfStatement: [
      "test",
      "consequent",
      "alternate"
    ],
    ImportDeclaration: [
      "specifiers",
      "source"
    ],
    ImportDefaultSpecifier: [
      "local"
    ],
    ImportExpression: [
      "source"
    ],
    ImportNamespaceSpecifier: [
      "local"
    ],
    ImportSpecifier: [
      "imported",
      "local"
    ],
    JSXAttribute: [
      "name",
      "value"
    ],
    JSXClosingElement: [
      "name"
    ],
    JSXClosingFragment: [],
    JSXElement: [
      "openingElement",
      "children",
      "closingElement"
    ],
    JSXEmptyExpression: [],
    JSXExpressionContainer: [
      "expression"
    ],
    JSXFragment: [
      "openingFragment",
      "children",
      "closingFragment"
    ],
    JSXIdentifier: [],
    JSXMemberExpression: [
      "object",
      "property"
    ],
    JSXNamespacedName: [
      "namespace",
      "name"
    ],
    JSXOpeningElement: [
      "name",
      "attributes"
    ],
    JSXOpeningFragment: [],
    JSXSpreadAttribute: [
      "argument"
    ],
    JSXSpreadChild: [
      "expression"
    ],
    JSXText: [],
    LabeledStatement: [
      "label",
      "body"
    ],
    Literal: [],
    LogicalExpression: [
      "left",
      "right"
    ],
    MemberExpression: [
      "object",
      "property"
    ],
    MetaProperty: [
      "meta",
      "property"
    ],
    MethodDefinition: [
      "key",
      "value"
    ],
    NewExpression: [
      "callee",
      "arguments"
    ],
    ObjectExpression: [
      "properties"
    ],
    ObjectPattern: [
      "properties"
    ],
    PrivateIdentifier: [],
    Program: [
      "body"
    ],
    Property: [
      "key",
      "value"
    ],
    PropertyDefinition: [
      "key",
      "value"
    ],
    RestElement: [
      "argument"
    ],
    ReturnStatement: [
      "argument"
    ],
    SequenceExpression: [
      "expressions"
    ],
    SpreadElement: [
      "argument"
    ],
    StaticBlock: [
      "body"
    ],
    Super: [],
    SwitchCase: [
      "test",
      "consequent"
    ],
    SwitchStatement: [
      "discriminant",
      "cases"
    ],
    TaggedTemplateExpression: [
      "tag",
      "quasi"
    ],
    TemplateElement: [],
    TemplateLiteral: [
      "quasis",
      "expressions"
    ],
    ThisExpression: [],
    ThrowStatement: [
      "argument"
    ],
    TryStatement: [
      "block",
      "handler",
      "finalizer"
    ],
    UnaryExpression: [
      "argument"
    ],
    UpdateExpression: [
      "argument"
    ],
    VariableDeclaration: [
      "declarations"
    ],
    VariableDeclarator: [
      "id",
      "init"
    ],
    WhileStatement: [
      "test",
      "body"
    ],
    WithStatement: [
      "object",
      "body"
    ],
    YieldExpression: [
      "argument"
    ]
  };
  const NODE_TYPES = Object.keys(KEYS);
  for (const type2 of NODE_TYPES) {
    Object.freeze(KEYS[type2]);
  }
  Object.freeze(KEYS);
  const KEY_BLACKLIST = /* @__PURE__ */ new Set([
    "parent",
    "leadingComments",
    "trailingComments"
  ]);
  function filterKey(key) {
    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
  }
  function getKeys(node2) {
    return Object.keys(node2).filter(filterKey);
  }
  function unionWith(additionalKeys) {
    const retv = (
      /** @type {{
          [type: string]: ReadonlyArray<string>
      }} */
      Object.assign({}, KEYS)
    );
    for (const type2 of Object.keys(additionalKeys)) {
      if (Object.prototype.hasOwnProperty.call(retv, type2)) {
        const keys = new Set(additionalKeys[type2]);
        for (const key of retv[type2]) {
          keys.add(key);
        }
        retv[type2] = Object.freeze(Array.from(keys));
      } else {
        retv[type2] = Object.freeze(Array.from(additionalKeys[type2]));
      }
    }
    return Object.freeze(retv);
  }
  eslintVisitorKeys.KEYS = KEYS;
  eslintVisitorKeys.getKeys = getKeys;
  eslintVisitorKeys.unionWith = unionWith;
  return eslintVisitorKeys;
}
var hasRequiredEslintUtils;
function requireEslintUtils() {
  if (hasRequiredEslintUtils) return eslintUtils;
  hasRequiredEslintUtils = 1;
  (function(exports$1) {
    Object.defineProperty(exports$1, "__esModule", { value: true });
    var eslintVisitorKeys2 = requireEslintVisitorKeys();
    function getInnermostScope(initialScope, node2) {
      const location = (
        /** @type {[number, number]} */
        node2.range[0]
      );
      let scope = initialScope;
      let found = false;
      do {
        found = false;
        for (const childScope of scope.childScopes) {
          const range = (
            /** @type {[number, number]} */
            childScope.block.range
          );
          if (range[0] <= location && location < range[1]) {
            scope = childScope;
            found = true;
            break;
          }
        }
      } while (found);
      return scope;
    }
    function findVariable(initialScope, nameOrNode) {
      let name = "";
      let scope = initialScope;
      if (typeof nameOrNode === "string") {
        name = nameOrNode;
      } else {
        name = nameOrNode.name;
        scope = getInnermostScope(scope, nameOrNode);
      }
      while (scope != null) {
        const variable = scope.set.get(name);
        if (variable != null) {
          return variable;
        }
        scope = scope.upper;
      }
      return null;
    }
    function negate(f2) {
      return (token) => !f2(token);
    }
    function isPunctuatorTokenWithValue(token, value) {
      return token.type === "Punctuator" && token.value === value;
    }
    function isArrowToken(token) {
      return isPunctuatorTokenWithValue(token, "=>");
    }
    function isCommaToken(token) {
      return isPunctuatorTokenWithValue(token, ",");
    }
    function isSemicolonToken(token) {
      return isPunctuatorTokenWithValue(token, ";");
    }
    function isColonToken(token) {
      return isPunctuatorTokenWithValue(token, ":");
    }
    function isOpeningParenToken(token) {
      return isPunctuatorTokenWithValue(token, "(");
    }
    function isClosingParenToken(token) {
      return isPunctuatorTokenWithValue(token, ")");
    }
    function isOpeningBracketToken(token) {
      return isPunctuatorTokenWithValue(token, "[");
    }
    function isClosingBracketToken(token) {
      return isPunctuatorTokenWithValue(token, "]");
    }
    function isOpeningBraceToken(token) {
      return isPunctuatorTokenWithValue(token, "{");
    }
    function isClosingBraceToken(token) {
      return isPunctuatorTokenWithValue(token, "}");
    }
    function isCommentToken(token) {
      return ["Block", "Line", "Shebang"].includes(token.type);
    }
    const isNotArrowToken = negate(isArrowToken);
    const isNotCommaToken = negate(isCommaToken);
    const isNotSemicolonToken = negate(isSemicolonToken);
    const isNotColonToken = negate(isColonToken);
    const isNotOpeningParenToken = negate(isOpeningParenToken);
    const isNotClosingParenToken = negate(isClosingParenToken);
    const isNotOpeningBracketToken = negate(isOpeningBracketToken);
    const isNotClosingBracketToken = negate(isClosingBracketToken);
    const isNotOpeningBraceToken = negate(isOpeningBraceToken);
    const isNotClosingBraceToken = negate(isClosingBraceToken);
    const isNotCommentToken = negate(isCommentToken);
    function getOpeningParenOfParams(node2, sourceCode2) {
      return node2.id ? (
        /** @type {Token} */
        sourceCode2.getTokenAfter(node2.id, isOpeningParenToken)
      ) : (
        /** @type {Token} */
        sourceCode2.getFirstToken(node2, isOpeningParenToken)
      );
    }
    function getFunctionHeadLocation(node2, sourceCode2) {
      const parent = (
        /** @type {RuleNode} */
        node2.parent
      );
      let start = null;
      let end = null;
      if (node2.type === "ArrowFunctionExpression") {
        const arrowToken = (
          /** @type {Token} */
          sourceCode2.getTokenBefore(node2.body, isArrowToken)
        );
        start = arrowToken.loc.start;
        end = arrowToken.loc.end;
      } else if (parent.type === "Property" || parent.type === "MethodDefinition" || parent.type === "PropertyDefinition") {
        start = /** @type {SourceLocation} */
        parent.loc.start;
        end = getOpeningParenOfParams(node2, sourceCode2).loc.start;
      } else {
        start = /** @type {SourceLocation} */
        node2.loc.start;
        end = getOpeningParenOfParams(node2, sourceCode2).loc.start;
      }
      return {
        start: { ...start },
        end: { ...end }
      };
    }
    const globalObject = typeof globalThis !== "undefined" ? globalThis : (
      // @ts-ignore
      typeof self !== "undefined" ? (
        // @ts-ignore
        self
      ) : (
        // @ts-ignore
        typeof window !== "undefined" ? (
          // @ts-ignore
          window
        ) : typeof global$1 !== "undefined" ? global$1 : {}
      )
    );
    const builtinNames = Object.freeze(
      /* @__PURE__ */ new Set([
        "Array",
        "ArrayBuffer",
        "BigInt",
        "BigInt64Array",
        "BigUint64Array",
        "Boolean",
        "DataView",
        "Date",
        "decodeURI",
        "decodeURIComponent",
        "encodeURI",
        "encodeURIComponent",
        "escape",
        "Float32Array",
        "Float64Array",
        "Function",
        "Infinity",
        "Int16Array",
        "Int32Array",
        "Int8Array",
        "isFinite",
        "isNaN",
        "isPrototypeOf",
        "JSON",
        "Map",
        "Math",
        "NaN",
        "Number",
        "Object",
        "parseFloat",
        "parseInt",
        "Promise",
        "Proxy",
        "Reflect",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "Uint16Array",
        "Uint32Array",
        "Uint8Array",
        "Uint8ClampedArray",
        "undefined",
        "unescape",
        "WeakMap",
        "WeakSet"
      ])
    );
    const callAllowed = new Set(
      [
        Array.isArray,
        Array.of,
        Array.prototype.at,
        Array.prototype.concat,
        Array.prototype.entries,
        Array.prototype.every,
        Array.prototype.filter,
        Array.prototype.find,
        Array.prototype.findIndex,
        Array.prototype.flat,
        Array.prototype.includes,
        Array.prototype.indexOf,
        Array.prototype.join,
        Array.prototype.keys,
        Array.prototype.lastIndexOf,
        Array.prototype.slice,
        Array.prototype.some,
        Array.prototype.toString,
        Array.prototype.values,
        typeof BigInt === "function" ? BigInt : void 0,
        Boolean,
        Date,
        Date.parse,
        decodeURI,
        decodeURIComponent,
        encodeURI,
        encodeURIComponent,
        escape,
        isFinite,
        isNaN,
        // @ts-ignore
        isPrototypeOf,
        Map,
        Map.prototype.entries,
        Map.prototype.get,
        Map.prototype.has,
        Map.prototype.keys,
        Map.prototype.values,
        .../** @type {(keyof typeof Math)[]} */
        Object.getOwnPropertyNames(Math).filter((k) => k !== "random").map((k) => Math[k]).filter((f2) => typeof f2 === "function"),
        Number,
        Number.isFinite,
        Number.isNaN,
        Number.parseFloat,
        Number.parseInt,
        Number.prototype.toExponential,
        Number.prototype.toFixed,
        Number.prototype.toPrecision,
        Number.prototype.toString,
        Object,
        Object.entries,
        Object.is,
        Object.isExtensible,
        Object.isFrozen,
        Object.isSealed,
        Object.keys,
        Object.values,
        parseFloat,
        parseInt,
        RegExp,
        Set,
        Set.prototype.entries,
        Set.prototype.has,
        Set.prototype.keys,
        Set.prototype.values,
        String,
        String.fromCharCode,
        String.fromCodePoint,
        String.raw,
        String.prototype.at,
        String.prototype.charAt,
        String.prototype.charCodeAt,
        String.prototype.codePointAt,
        String.prototype.concat,
        String.prototype.endsWith,
        String.prototype.includes,
        String.prototype.indexOf,
        String.prototype.lastIndexOf,
        String.prototype.normalize,
        String.prototype.padEnd,
        String.prototype.padStart,
        String.prototype.slice,
        String.prototype.startsWith,
        String.prototype.substr,
        String.prototype.substring,
        String.prototype.toLowerCase,
        String.prototype.toString,
        String.prototype.toUpperCase,
        String.prototype.trim,
        String.prototype.trimEnd,
        String.prototype.trimLeft,
        String.prototype.trimRight,
        String.prototype.trimStart,
        Symbol.for,
        Symbol.keyFor,
        unescape
      ].filter((f2) => typeof f2 === "function")
    );
    const callPassThrough = /* @__PURE__ */ new Set([
      Object.freeze,
      Object.preventExtensions,
      Object.seal
    ]);
    const getterAllowed = [
      [Map, /* @__PURE__ */ new Set(["size"])],
      [
        RegExp,
        /* @__PURE__ */ new Set([
          "dotAll",
          "flags",
          "global",
          "hasIndices",
          "ignoreCase",
          "multiline",
          "source",
          "sticky",
          "unicode"
        ])
      ],
      [Set, /* @__PURE__ */ new Set(["size"])]
    ];
    function getPropertyDescriptor(object, name) {
      let x2 = object;
      while ((typeof x2 === "object" || typeof x2 === "function") && x2 !== null) {
        const d2 = Object.getOwnPropertyDescriptor(x2, name);
        if (d2) {
          return d2;
        }
        x2 = Object.getPrototypeOf(x2);
      }
      return null;
    }
    function isGetter(object, name) {
      const d2 = getPropertyDescriptor(object, name);
      return d2 != null && d2.get != null;
    }
    function getElementValues(nodeList, initialScope) {
      const valueList = [];
      for (let i2 = 0; i2 < nodeList.length; ++i2) {
        const elementNode = nodeList[i2];
        if (elementNode == null) {
          valueList.length = i2 + 1;
        } else if (elementNode.type === "SpreadElement") {
          const argument = getStaticValueR(elementNode.argument, initialScope);
          if (argument == null) {
            return null;
          }
          valueList.push(.../** @type {Iterable<any>} */
          argument.value);
        } else {
          const element = getStaticValueR(elementNode, initialScope);
          if (element == null) {
            return null;
          }
          valueList.push(element.value);
        }
      }
      return valueList;
    }
    function isBuiltinGlobal(variable) {
      return variable != null && variable.defs.length === 0 && builtinNames.has(variable.name) && variable.name in globalObject;
    }
    function canBeConsideredConst(variable) {
      if (variable.defs.length !== 1) {
        return false;
      }
      const def = variable.defs[0];
      return Boolean(
        def.parent && def.type === "Variable" && (def.parent.kind === "const" || isEffectivelyConst(variable))
      );
    }
    function isEffectivelyConst(variable) {
      const refs = variable.references;
      const inits = refs.filter((r2) => r2.init).length;
      const reads = refs.filter((r2) => r2.isReadOnly()).length;
      if (inits === 1 && reads + inits === refs.length) {
        return true;
      }
      return false;
    }
    function hasMutationInProperty(variable, initialScope) {
      for (const ref2 of variable.references) {
        let node2 = (
          /** @type {TSESTreeNode} */
          ref2.identifier
        );
        while (node2 && node2.parent && node2.parent.type === "MemberExpression") {
          node2 = node2.parent;
        }
        if (!node2 || !node2.parent) {
          continue;
        }
        if (node2.parent.type === "AssignmentExpression" && node2.parent.left === node2 || node2.parent.type === "UpdateExpression" && node2.parent.argument === node2) {
          return true;
        }
        if (node2.parent.type === "CallExpression" && node2.parent.callee === node2 && node2.type === "MemberExpression") {
          const methodName = getStaticPropertyNameValue(node2, initialScope);
          if (isNameOfMutationArrayMethod(methodName)) {
            return true;
          }
        }
      }
      return false;
      function isNameOfMutationArrayMethod(methodName) {
        if (methodName == null || methodName.value == null) {
          return false;
        }
        const name = methodName.value;
        return name === "copyWithin" || name === "fill" || name === "pop" || name === "push" || name === "reverse" || name === "shift" || name === "sort" || name === "splice" || name === "unshift";
      }
    }
    const operations = Object.freeze({
      ArrayExpression(node2, initialScope) {
        const elements = getElementValues(node2.elements, initialScope);
        return elements != null ? { value: elements } : null;
      },
      AssignmentExpression(node2, initialScope) {
        if (node2.operator === "=") {
          return getStaticValueR(node2.right, initialScope);
        }
        return null;
      },
      //eslint-disable-next-line complexity
      BinaryExpression(node2, initialScope) {
        if (node2.operator === "in" || node2.operator === "instanceof") {
          return null;
        }
        const left = getStaticValueR(node2.left, initialScope);
        const right = getStaticValueR(node2.right, initialScope);
        if (left != null && right != null) {
          switch (node2.operator) {
            case "==":
              return { value: left.value == right.value };
            //eslint-disable-line eqeqeq
            case "!=":
              return { value: left.value != right.value };
            //eslint-disable-line eqeqeq
            case "===":
              return { value: left.value === right.value };
            case "!==":
              return { value: left.value !== right.value };
            case "<":
              return {
                value: (
                  /** @type {any} */
                  left.value < /** @type {any} */
                  right.value
                )
              };
            case "<=":
              return {
                value: (
                  /** @type {any} */
                  left.value <= /** @type {any} */
                  right.value
                )
              };
            case ">":
              return {
                value: (
                  /** @type {any} */
                  left.value > /** @type {any} */
                  right.value
                )
              };
            case ">=":
              return {
                value: (
                  /** @type {any} */
                  left.value >= /** @type {any} */
                  right.value
                )
              };
            case "<<":
              return {
                value: (
                  /** @type {any} */
                  left.value << /** @type {any} */
                  right.value
                )
              };
            case ">>":
              return {
                value: (
                  /** @type {any} */
                  left.value >> /** @type {any} */
                  right.value
                )
              };
            case ">>>":
              return {
                value: (
                  /** @type {any} */
                  left.value >>> /** @type {any} */
                  right.value
                )
              };
            case "+":
              return {
                value: (
                  /** @type {any} */
                  left.value + /** @type {any} */
                  right.value
                )
              };
            case "-":
              return {
                value: (
                  /** @type {any} */
                  left.value - /** @type {any} */
                  right.value
                )
              };
            case "*":
              return {
                value: (
                  /** @type {any} */
                  left.value * /** @type {any} */
                  right.value
                )
              };
            case "/":
              return {
                value: (
                  /** @type {any} */
                  left.value / /** @type {any} */
                  right.value
                )
              };
            case "%":
              return {
                value: (
                  /** @type {any} */
                  left.value % /** @type {any} */
                  right.value
                )
              };
            case "**":
              return {
                value: (
                  /** @type {any} */
                  left.value ** /** @type {any} */
                  right.value
                )
              };
            case "|":
              return {
                value: (
                  /** @type {any} */
                  left.value | /** @type {any} */
                  right.value
                )
              };
            case "^":
              return {
                value: (
                  /** @type {any} */
                  left.value ^ /** @type {any} */
                  right.value
                )
              };
            case "&":
              return {
                value: (
                  /** @type {any} */
                  left.value & /** @type {any} */
                  right.value
                )
              };
          }
        }
        return null;
      },
      CallExpression(node2, initialScope) {
        const calleeNode = node2.callee;
        const args = getElementValues(node2.arguments, initialScope);
        if (args != null) {
          if (calleeNode.type === "MemberExpression") {
            if (calleeNode.property.type === "PrivateIdentifier") {
              return null;
            }
            const object = getStaticValueR(calleeNode.object, initialScope);
            if (object != null) {
              if (object.value == null && (object.optional || node2.optional)) {
                return { value: void 0, optional: true };
              }
              const property = getStaticPropertyNameValue(
                calleeNode,
                initialScope
              );
              if (property != null) {
                const receiver = (
                  /** @type {Record<PropertyKey, (...args: any[]) => any>} */
                  object.value
                );
                const methodName = (
                  /** @type {PropertyKey} */
                  property.value
                );
                if (callAllowed.has(receiver[methodName])) {
                  return {
                    value: receiver[methodName](...args)
                  };
                }
                if (callPassThrough.has(receiver[methodName])) {
                  return { value: args[0] };
                }
              }
            }
          } else {
            const callee = getStaticValueR(calleeNode, initialScope);
            if (callee != null) {
              if (callee.value == null && node2.optional) {
                return { value: void 0, optional: true };
              }
              const func = (
                /** @type {(...args: any[]) => any} */
                callee.value
              );
              if (callAllowed.has(func)) {
                return { value: func(...args) };
              }
              if (callPassThrough.has(func)) {
                return { value: args[0] };
              }
            }
          }
        }
        return null;
      },
      ConditionalExpression(node2, initialScope) {
        const test = getStaticValueR(node2.test, initialScope);
        if (test != null) {
          return test.value ? getStaticValueR(node2.consequent, initialScope) : getStaticValueR(node2.alternate, initialScope);
        }
        return null;
      },
      ExpressionStatement(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      },
      Identifier(node2, initialScope) {
        if (initialScope != null) {
          const variable = findVariable(initialScope, node2);
          if (variable != null) {
            if (isBuiltinGlobal(variable)) {
              return { value: globalObject[variable.name] };
            }
            if (canBeConsideredConst(variable)) {
              const def = variable.defs[0];
              if (
                // TODO(mysticatea): don't support destructuring here.
                def.node.id.type === "Identifier"
              ) {
                const init = getStaticValueR(
                  def.node.init,
                  initialScope
                );
                if (init && typeof init.value === "object" && init.value !== null) {
                  if (hasMutationInProperty(variable, initialScope)) {
                    return null;
                  }
                }
                return init;
              }
            }
          }
        }
        return null;
      },
      Literal(node2) {
        const literal = (
          /** @type {Partial<Literal> & Partial<RegExpLiteral> & Partial<BigIntLiteral>} */
          node2
        );
        if ((literal.regex != null || literal.bigint != null) && literal.value == null) {
          return null;
        }
        return { value: literal.value };
      },
      LogicalExpression(node2, initialScope) {
        const left = getStaticValueR(node2.left, initialScope);
        if (left != null) {
          if (node2.operator === "||" && Boolean(left.value) === true || node2.operator === "&&" && Boolean(left.value) === false || node2.operator === "??" && left.value != null) {
            return left;
          }
          const right = getStaticValueR(node2.right, initialScope);
          if (right != null) {
            return right;
          }
        }
        return null;
      },
      MemberExpression(node2, initialScope) {
        if (node2.property.type === "PrivateIdentifier") {
          return null;
        }
        const object = getStaticValueR(node2.object, initialScope);
        if (object != null) {
          if (object.value == null && (object.optional || node2.optional)) {
            return { value: void 0, optional: true };
          }
          const property = getStaticPropertyNameValue(node2, initialScope);
          if (property != null) {
            if (!isGetter(
              /** @type {object} */
              object.value,
              /** @type {PropertyKey} */
              property.value
            )) {
              return {
                value: (
                  /** @type {Record<PropertyKey, unknown>} */
                  object.value[
                    /** @type {PropertyKey} */
                    property.value
                  ]
                )
              };
            }
            for (const [classFn, allowed] of getterAllowed) {
              if (object.value instanceof classFn && allowed.has(
                /** @type {string} */
                property.value
              )) {
                return {
                  value: (
                    /** @type {Record<PropertyKey, unknown>} */
                    object.value[
                      /** @type {PropertyKey} */
                      property.value
                    ]
                  )
                };
              }
            }
          }
        }
        return null;
      },
      ChainExpression(node2, initialScope) {
        const expression = getStaticValueR(node2.expression, initialScope);
        if (expression != null) {
          return { value: expression.value };
        }
        return null;
      },
      NewExpression(node2, initialScope) {
        const callee = getStaticValueR(node2.callee, initialScope);
        const args = getElementValues(node2.arguments, initialScope);
        if (callee != null && args != null) {
          const Func2 = (
            /** @type {new (...args: any[]) => any} */
            callee.value
          );
          if (callAllowed.has(Func2)) {
            return { value: new Func2(...args) };
          }
        }
        return null;
      },
      ObjectExpression(node2, initialScope) {
        const object = {};
        for (const propertyNode of node2.properties) {
          if (propertyNode.type === "Property") {
            if (propertyNode.kind !== "init") {
              return null;
            }
            const key = getStaticPropertyNameValue(
              propertyNode,
              initialScope
            );
            const value = getStaticValueR(propertyNode.value, initialScope);
            if (key == null || value == null) {
              return null;
            }
            object[
              /** @type {PropertyKey} */
              key.value
            ] = value.value;
          } else if (propertyNode.type === "SpreadElement" || // @ts-expect-error -- Backward compatibility
          propertyNode.type === "ExperimentalSpreadProperty") {
            const argument = getStaticValueR(
              propertyNode.argument,
              initialScope
            );
            if (argument == null) {
              return null;
            }
            Object.assign(object, argument.value);
          } else {
            return null;
          }
        }
        return { value: object };
      },
      SequenceExpression(node2, initialScope) {
        const last = node2.expressions[node2.expressions.length - 1];
        return getStaticValueR(last, initialScope);
      },
      TaggedTemplateExpression(node2, initialScope) {
        const tag = getStaticValueR(node2.tag, initialScope);
        const expressions = getElementValues(
          node2.quasi.expressions,
          initialScope
        );
        if (tag != null && expressions != null) {
          const func = (
            /** @type {(...args: any[]) => any} */
            tag.value
          );
          const strings = node2.quasi.quasis.map((q) => q.value.cooked);
          strings.raw = node2.quasi.quasis.map((q) => q.value.raw);
          if (func === String.raw) {
            return { value: func(strings, ...expressions) };
          }
        }
        return null;
      },
      TemplateLiteral(node2, initialScope) {
        const expressions = getElementValues(node2.expressions, initialScope);
        if (expressions != null) {
          let value = node2.quasis[0].value.cooked;
          for (let i2 = 0; i2 < expressions.length; ++i2) {
            value += expressions[i2];
            value += /** @type {string} */
            node2.quasis[i2 + 1].value.cooked;
          }
          return { value };
        }
        return null;
      },
      UnaryExpression(node2, initialScope) {
        if (node2.operator === "delete") {
          return null;
        }
        if (node2.operator === "void") {
          return { value: void 0 };
        }
        const arg = getStaticValueR(node2.argument, initialScope);
        if (arg != null) {
          switch (node2.operator) {
            case "-":
              return { value: -/** @type {any} */
              arg.value };
            case "+":
              return { value: +/** @type {any} */
              arg.value };
            //eslint-disable-line no-implicit-coercion
            case "!":
              return { value: !arg.value };
            case "~":
              return { value: ~/** @type {any} */
              arg.value };
            case "typeof":
              return { value: typeof arg.value };
          }
        }
        return null;
      },
      TSAsExpression(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      },
      TSSatisfiesExpression(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      },
      TSTypeAssertion(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      },
      TSNonNullExpression(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      },
      TSInstantiationExpression(node2, initialScope) {
        return getStaticValueR(node2.expression, initialScope);
      }
    });
    function getStaticValueR(node2, initialScope) {
      if (node2 != null && Object.hasOwnProperty.call(operations, node2.type)) {
        return (
          /** @type {VisitorCallback<any>} */
          operations[node2.type](
            /** @type {TSESTreeNode} */
            node2,
            initialScope
          )
        );
      }
      return null;
    }
    function getStaticPropertyNameValue(node2, initialScope) {
      const nameNode = node2.type === "Property" ? node2.key : node2.property;
      if (node2.computed) {
        return getStaticValueR(nameNode, initialScope);
      }
      if (nameNode.type === "Identifier") {
        return { value: nameNode.name };
      }
      if (nameNode.type === "Literal") {
        if (
          /** @type {Partial<BigIntLiteral>} */
          nameNode.bigint
        ) {
          return { value: (
            /** @type {BigIntLiteral} */
            nameNode.bigint
          ) };
        }
        return { value: String(nameNode.value) };
      }
      return null;
    }
    function getStaticValue(node2, initialScope = null) {
      try {
        return getStaticValueR(node2, initialScope);
      } catch (_error) {
        return null;
      }
    }
    function getStringIfConstant(node2, initialScope = null) {
      if (node2 && node2.type === "Literal" && node2.value === null) {
        const literal = (
          /** @type {Partial<SimpleLiteral> & Partial<RegExpLiteral> & Partial<BigIntLiteral>} */
          node2
        );
        if (literal.regex) {
          return `/${literal.regex.pattern}/${literal.regex.flags}`;
        }
        if (literal.bigint) {
          return literal.bigint;
        }
      }
      const evaluated = getStaticValue(node2, initialScope);
      if (evaluated) {
        try {
          return String(evaluated.value);
        } catch {
        }
      }
      return null;
    }
    function getPropertyName(node2, initialScope) {
      switch (node2.type) {
        case "MemberExpression":
          if (node2.computed) {
            return getStringIfConstant(node2.property, initialScope);
          }
          if (node2.property.type === "PrivateIdentifier") {
            return null;
          }
          return (
            /** @type {Partial<Identifier>} */
            node2.property.name
          );
        case "Property":
        case "MethodDefinition":
        case "PropertyDefinition":
          if (node2.computed) {
            return getStringIfConstant(node2.key, initialScope);
          }
          if (node2.key.type === "Literal") {
            return String(node2.key.value);
          }
          if (node2.key.type === "PrivateIdentifier") {
            return null;
          }
          return (
            /** @type {Partial<Identifier>} */
            node2.key.name
          );
      }
      return null;
    }
    function getFunctionNameWithKind(node2, sourceCode2) {
      const parent = (
        /** @type {RuleNode} */
        node2.parent
      );
      const tokens = [];
      const isObjectMethod = parent.type === "Property" && parent.value === node2;
      const isClassMethod = parent.type === "MethodDefinition" && parent.value === node2;
      const isClassFieldMethod = parent.type === "PropertyDefinition" && parent.value === node2;
      if (isClassMethod || isClassFieldMethod) {
        if (parent.static) {
          tokens.push("static");
        }
        if (parent.key.type === "PrivateIdentifier") {
          tokens.push("private");
        }
      }
      if (node2.async) {
        tokens.push("async");
      }
      if (node2.generator) {
        tokens.push("generator");
      }
      if (isObjectMethod || isClassMethod) {
        if (parent.kind === "constructor") {
          return "constructor";
        }
        if (parent.kind === "get") {
          tokens.push("getter");
        } else if (parent.kind === "set") {
          tokens.push("setter");
        } else {
          tokens.push("method");
        }
      } else if (isClassFieldMethod) {
        tokens.push("method");
      } else {
        if (node2.type === "ArrowFunctionExpression") {
          tokens.push("arrow");
        }
        tokens.push("function");
      }
      if (isObjectMethod || isClassMethod || isClassFieldMethod) {
        if (parent.key.type === "PrivateIdentifier") {
          tokens.push(`#${parent.key.name}`);
        } else {
          const name = getPropertyName(parent);
          if (name) {
            tokens.push(`'${name}'`);
          } else if (sourceCode2) {
            const keyText = sourceCode2.getText(parent.key);
            if (!keyText.includes("\n")) {
              tokens.push(`[${keyText}]`);
            }
          }
        }
      } else if (hasId(node2)) {
        tokens.push(`'${node2.id.name}'`);
      } else if (parent.type === "VariableDeclarator" && parent.id && parent.id.type === "Identifier") {
        tokens.push(`'${parent.id.name}'`);
      } else if ((parent.type === "AssignmentExpression" || parent.type === "AssignmentPattern") && parent.left && parent.left.type === "Identifier") {
        tokens.push(`'${parent.left.name}'`);
      } else if (parent.type === "ExportDefaultDeclaration" && parent.declaration === node2) {
        tokens.push("'default'");
      }
      return tokens.join(" ");
    }
    function hasId(node2) {
      return Boolean(
        /** @type {Partial<FunctionDeclaration | FunctionExpression>} */
        node2.id
      );
    }
    const typeConversionBinaryOps = Object.freeze(
      /* @__PURE__ */ new Set([
        "==",
        "!=",
        "<",
        "<=",
        ">",
        ">=",
        "<<",
        ">>",
        ">>>",
        "+",
        "-",
        "*",
        "/",
        "%",
        "|",
        "^",
        "&",
        "in"
      ])
    );
    const typeConversionUnaryOps = Object.freeze(/* @__PURE__ */ new Set(["-", "+", "!", "~"]));
    function isNode(x2) {
      return x2 !== null && typeof x2 === "object" && typeof x2.type === "string";
    }
    const visitor = Object.freeze(
      Object.assign(/* @__PURE__ */ Object.create(null), {
        /**
         * @param {Node} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        $visit(node2, options, visitorKeys) {
          const { type: type2 } = node2;
          if (typeof /** @type {any} */
          this[type2] === "function") {
            return (
              /** @type {any} */
              this[type2](
                node2,
                options,
                visitorKeys
              )
            );
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        /**
         * @param {Node} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        $visitChildren(node2, options, visitorKeys) {
          const { type: type2 } = node2;
          for (
            const key of
            /** @type {(keyof Node)[]} */
            visitorKeys[type2] || eslintVisitorKeys2.getKeys(node2)
          ) {
            const value = node2[key];
            if (Array.isArray(value)) {
              for (const element of value) {
                if (isNode(element) && this.$visit(element, options, visitorKeys)) {
                  return true;
                }
              }
            } else if (isNode(value) && this.$visit(value, options, visitorKeys)) {
              return true;
            }
          }
          return false;
        },
        ArrowFunctionExpression() {
          return false;
        },
        AssignmentExpression() {
          return true;
        },
        AwaitExpression() {
          return true;
        },
        /**
         * @param {BinaryExpression} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        BinaryExpression(node2, options, visitorKeys) {
          if (options.considerImplicitTypeConversion && typeConversionBinaryOps.has(node2.operator) && (node2.left.type !== "Literal" || node2.right.type !== "Literal")) {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        CallExpression() {
          return true;
        },
        FunctionExpression() {
          return false;
        },
        ImportExpression() {
          return true;
        },
        /**
         * @param {MemberExpression} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        MemberExpression(node2, options, visitorKeys) {
          if (options.considerGetters) {
            return true;
          }
          if (options.considerImplicitTypeConversion && node2.computed && node2.property.type !== "Literal") {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        /**
         * @param {MethodDefinition} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        MethodDefinition(node2, options, visitorKeys) {
          if (options.considerImplicitTypeConversion && node2.computed && node2.key.type !== "Literal") {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        NewExpression() {
          return true;
        },
        /**
         * @param {Property} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        Property(node2, options, visitorKeys) {
          if (options.considerImplicitTypeConversion && node2.computed && node2.key.type !== "Literal") {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        /**
         * @param {PropertyDefinition} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        PropertyDefinition(node2, options, visitorKeys) {
          if (options.considerImplicitTypeConversion && node2.computed && node2.key.type !== "Literal") {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        /**
         * @param {UnaryExpression} node
         * @param {HasSideEffectOptions} options
         * @param {Record<string, string[]>} visitorKeys
         */
        UnaryExpression(node2, options, visitorKeys) {
          if (node2.operator === "delete") {
            return true;
          }
          if (options.considerImplicitTypeConversion && typeConversionUnaryOps.has(node2.operator) && node2.argument.type !== "Literal") {
            return true;
          }
          return this.$visitChildren(node2, options, visitorKeys);
        },
        UpdateExpression() {
          return true;
        },
        YieldExpression() {
          return true;
        }
      })
    );
    function hasSideEffect(node2, sourceCode2, options = {}) {
      const { considerGetters = false, considerImplicitTypeConversion = false } = options;
      return visitor.$visit(
        node2,
        { considerGetters, considerImplicitTypeConversion },
        sourceCode2.visitorKeys || eslintVisitorKeys2.KEYS
      );
    }
    function getParentSyntaxParen(node2, sourceCode2) {
      const parent = (
        /** @type {RuleNode} */
        node2.parent
      );
      switch (parent.type) {
        case "CallExpression":
        case "NewExpression":
          if (parent.arguments.length === 1 && parent.arguments[0] === node2) {
            return sourceCode2.getTokenAfter(
              /** @type {RuleNode} */
              /** @type {unknown} */
              /** @type {TSNewExpression | TSCallExpression} */
              parent.typeParameters || parent.callee,
              isOpeningParenToken
            );
          }
          return null;
        case "DoWhileStatement":
          if (parent.test === node2) {
            return sourceCode2.getTokenAfter(
              parent.body,
              isOpeningParenToken
            );
          }
          return null;
        case "IfStatement":
        case "WhileStatement":
          if (parent.test === node2) {
            return sourceCode2.getFirstToken(parent, 1);
          }
          return null;
        case "ImportExpression":
          if (parent.source === node2) {
            return sourceCode2.getFirstToken(parent, 1);
          }
          return null;
        case "SwitchStatement":
          if (parent.discriminant === node2) {
            return sourceCode2.getFirstToken(parent, 1);
          }
          return null;
        case "WithStatement":
          if (parent.object === node2) {
            return sourceCode2.getFirstToken(parent, 1);
          }
          return null;
        default:
          return null;
      }
    }
    function isParenthesized(timesOrNode, nodeOrSourceCode, optionalSourceCode) {
      let times, node2, sourceCode2, maybeLeftParen, maybeRightParen;
      if (typeof timesOrNode === "number") {
        times = timesOrNode | 0;
        node2 = /** @type {RuleNode} */
        nodeOrSourceCode;
        sourceCode2 = /** @type {SourceCode} */
        optionalSourceCode;
        if (!(times >= 1)) {
          throw new TypeError("'times' should be a positive integer.");
        }
      } else {
        times = 1;
        node2 = /** @type {RuleNode} */
        timesOrNode;
        sourceCode2 = /** @type {SourceCode} */
        nodeOrSourceCode;
      }
      if (node2 == null || // `Program` can't be parenthesized
      node2.parent == null || // `CatchClause.param` can't be parenthesized, example `try {} catch (error) {}`
      node2.parent.type === "CatchClause" && node2.parent.param === node2) {
        return false;
      }
      maybeLeftParen = maybeRightParen = node2;
      do {
        maybeLeftParen = sourceCode2.getTokenBefore(maybeLeftParen);
        maybeRightParen = sourceCode2.getTokenAfter(maybeRightParen);
      } while (maybeLeftParen != null && maybeRightParen != null && isOpeningParenToken(maybeLeftParen) && isClosingParenToken(maybeRightParen) && // Avoid false positive such as `if (a) {}`
      maybeLeftParen !== getParentSyntaxParen(node2, sourceCode2) && --times > 0);
      return times === 0;
    }
    const placeholder = /\$(?:[$&`']|[1-9][0-9]?)/gu;
    const internal = /* @__PURE__ */ new WeakMap();
    function isEscaped(str, index2) {
      let escaped = false;
      for (let i2 = index2 - 1; i2 >= 0 && str.charCodeAt(i2) === 92; --i2) {
        escaped = !escaped;
      }
      return escaped;
    }
    function replaceS(matcher, str, replacement) {
      const chunks = [];
      let index2 = 0;
      function replacer(key, match) {
        switch (key) {
          case "$$":
            return "$";
          case "$&":
            return match[0];
          case "$`":
            return str.slice(0, match.index);
          case "$'":
            return str.slice(match.index + match[0].length);
          default: {
            const i2 = key.slice(1);
            if (i2 in match) {
              return match[
                /** @type {any} */
                i2
              ];
            }
            return key;
          }
        }
      }
      for (const match of matcher.execAll(str)) {
        chunks.push(str.slice(index2, match.index));
        chunks.push(
          replacement.replace(placeholder, (key) => replacer(key, match))
        );
        index2 = match.index + match[0].length;
      }
      chunks.push(str.slice(index2));
      return chunks.join("");
    }
    function replaceF(matcher, str, replace) {
      const chunks = [];
      let index2 = 0;
      for (const match of matcher.execAll(str)) {
        chunks.push(str.slice(index2, match.index));
        chunks.push(
          String(
            replace(
              .../** @type {[string, ...string[]]} */
              /** @type {string[]} */
              match,
              match.index,
              match.input
            )
          )
        );
        index2 = match.index + match[0].length;
      }
      chunks.push(str.slice(index2));
      return chunks.join("");
    }
    class PatternMatcher {
      /**
       * Initialize this matcher.
       * @param {RegExp} pattern The pattern to match.
       * @param {{escaped?:boolean}} [options] The options.
       */
      constructor(pattern2, options = {}) {
        const { escaped = false } = options;
        if (!(pattern2 instanceof RegExp)) {
          throw new TypeError("'pattern' should be a RegExp instance.");
        }
        if (!pattern2.flags.includes("g")) {
          throw new Error("'pattern' should contains 'g' flag.");
        }
        internal.set(this, {
          pattern: new RegExp(pattern2.source, pattern2.flags),
          escaped: Boolean(escaped)
        });
      }
      /**
       * Find the pattern in a given string.
       * @param {string} str The string to find.
       * @returns {IterableIterator<RegExpExecArray>} The iterator which iterate the matched information.
       */
      *execAll(str) {
        const { pattern: pattern2, escaped } = (
          /** @type {{pattern:RegExp,escaped:boolean}} */
          internal.get(this)
        );
        let match = null;
        let lastIndex = 0;
        pattern2.lastIndex = 0;
        while ((match = pattern2.exec(str)) != null) {
          if (escaped || !isEscaped(str, match.index)) {
            lastIndex = pattern2.lastIndex;
            yield match;
            pattern2.lastIndex = lastIndex;
          }
        }
      }
      /**
       * Check whether the pattern is found in a given string.
       * @param {string} str The string to check.
       * @returns {boolean} `true` if the pattern was found in the string.
       */
      test(str) {
        const it = this.execAll(str);
        const ret = it.next();
        return !ret.done;
      }
      /**
       * Replace a given string.
       * @param {string} str The string to be replaced.
       * @param {(string|((...strs:string[])=>string))} replacer The string or function to replace. This is the same as the 2nd argument of `String.prototype.replace`.
       * @returns {string} The replaced string.
       */
      [Symbol.replace](str, replacer) {
        return typeof replacer === "function" ? replaceF(this, String(str), replacer) : replaceS(this, String(str), String(replacer));
      }
    }
    const IMPORT_TYPE = /^(?:Import|Export(?:All|Default|Named))Declaration$/u;
    function isHasSource(node2) {
      return IMPORT_TYPE.test(node2.type) && /** @type {ImportDeclaration|ExportAllDeclaration|ExportNamedDeclaration} */
      node2.source != null;
    }
    const has = (
      /** @type {<T>(traceMap: TraceMap<unknown>, v: T) => v is (string extends T ? string : T)} */
      Function.call.bind(Object.hasOwnProperty)
    );
    const READ = Symbol("read");
    const CALL = Symbol("call");
    const CONSTRUCT = Symbol("construct");
    const ESM = Symbol("esm");
    const requireCall = { require: { [CALL]: true } };
    function isModifiedGlobal(variable) {
      return variable == null || variable.defs.length !== 0 || variable.references.some((r2) => r2.isWrite());
    }
    function isPassThrough(node2) {
      const parent = (
        /** @type {TSESTreeNode} */
        node2.parent
      );
      if (parent) {
        switch (parent.type) {
          case "ConditionalExpression":
            return parent.consequent === node2 || parent.alternate === node2;
          case "LogicalExpression":
            return true;
          case "SequenceExpression":
            return parent.expressions[parent.expressions.length - 1] === node2;
          case "ChainExpression":
            return true;
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSTypeAssertion":
          case "TSNonNullExpression":
          case "TSInstantiationExpression":
            return true;
          default:
            return false;
        }
      }
      return false;
    }
    class ReferenceTracker {
      /**
       * Initialize this tracker.
       * @param {Scope} globalScope The global scope.
       * @param {object} [options] The options.
       * @param {"legacy"|"strict"} [options.mode="strict"] The mode to determine the ImportDeclaration's behavior for CJS modules.
       * @param {string[]} [options.globalObjectNames=["global","globalThis","self","window"]] The variable names for Global Object.
       */
      constructor(globalScope, options = {}) {
        const {
          mode = "strict",
          globalObjectNames = ["global", "globalThis", "self", "window"]
        } = options;
        this.variableStack = [];
        this.globalScope = globalScope;
        this.mode = mode;
        this.globalObjectNames = globalObjectNames.slice(0);
      }
      /**
       * Iterate the references of global variables.
       * @template T
       * @param {TraceMap<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *iterateGlobalReferences(traceMap) {
        for (const key of Object.keys(traceMap)) {
          const nextTraceMap = traceMap[key];
          const path = [key];
          const variable = this.globalScope.set.get(key);
          if (isModifiedGlobal(variable)) {
            continue;
          }
          yield* this._iterateVariableReferences(
            /** @type {Variable} */
            variable,
            path,
            nextTraceMap,
            true
          );
        }
        for (const key of this.globalObjectNames) {
          const path = [];
          const variable = this.globalScope.set.get(key);
          if (isModifiedGlobal(variable)) {
            continue;
          }
          yield* this._iterateVariableReferences(
            /** @type {Variable} */
            variable,
            path,
            traceMap,
            false
          );
        }
      }
      /**
       * Iterate the references of CommonJS modules.
       * @template T
       * @param {TraceMap<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *iterateCjsReferences(traceMap) {
        for (const { node: node2 } of this.iterateGlobalReferences(requireCall)) {
          const key = getStringIfConstant(
            /** @type {CallExpression} */
            node2.arguments[0]
          );
          if (key == null || !has(traceMap, key)) {
            continue;
          }
          const nextTraceMap = traceMap[key];
          const path = [key];
          if (nextTraceMap[READ]) {
            yield {
              node: node2,
              path,
              type: READ,
              info: nextTraceMap[READ]
            };
          }
          yield* this._iteratePropertyReferences(
            /** @type {CallExpression} */
            node2,
            path,
            nextTraceMap
          );
        }
      }
      /**
       * Iterate the references of ES modules.
       * @template T
       * @param {TraceMap<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *iterateEsmReferences(traceMap) {
        const programNode = (
          /** @type {Program} */
          this.globalScope.block
        );
        for (const node2 of programNode.body) {
          if (!isHasSource(node2)) {
            continue;
          }
          const moduleId = (
            /** @type {string} */
            node2.source.value
          );
          if (!has(traceMap, moduleId)) {
            continue;
          }
          const nextTraceMap = traceMap[moduleId];
          const path = [moduleId];
          if (nextTraceMap[READ]) {
            yield {
              // eslint-disable-next-line object-shorthand -- apply type
              node: (
                /** @type {RuleNode} */
                node2
              ),
              path,
              type: READ,
              info: nextTraceMap[READ]
            };
          }
          if (node2.type === "ExportAllDeclaration") {
            for (const key of Object.keys(nextTraceMap)) {
              const exportTraceMap = nextTraceMap[key];
              if (exportTraceMap[READ]) {
                yield {
                  // eslint-disable-next-line object-shorthand -- apply type
                  node: (
                    /** @type {RuleNode} */
                    node2
                  ),
                  path: path.concat(key),
                  type: READ,
                  info: exportTraceMap[READ]
                };
              }
            }
          } else {
            for (const specifier of node2.specifiers) {
              const esm = has(nextTraceMap, ESM);
              const it = this._iterateImportReferences(
                specifier,
                path,
                esm ? nextTraceMap : this.mode === "legacy" ? { default: nextTraceMap, ...nextTraceMap } : { default: nextTraceMap }
              );
              if (esm) {
                yield* it;
              } else {
                for (const report of it) {
                  report.path = report.path.filter(exceptDefault);
                  if (report.path.length >= 2 || report.type !== READ) {
                    yield report;
                  }
                }
              }
            }
          }
        }
      }
      /**
       * Iterate the property references for a given expression AST node.
       * @template T
       * @param {Expression} node The expression AST node to iterate property references.
       * @param {TraceMap<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate property references.
       */
      *iteratePropertyReferences(node2, traceMap) {
        yield* this._iteratePropertyReferences(node2, [], traceMap);
      }
      /**
       * Iterate the references for a given variable.
       * @private
       * @template T
       * @param {Variable} variable The variable to iterate that references.
       * @param {string[]} path The current path.
       * @param {TraceMapObject<T>} traceMap The trace map.
       * @param {boolean} shouldReport = The flag to report those references.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *_iterateVariableReferences(variable, path, traceMap, shouldReport) {
        if (this.variableStack.includes(variable)) {
          return;
        }
        this.variableStack.push(variable);
        try {
          for (const reference of variable.references) {
            if (!reference.isRead()) {
              continue;
            }
            const node2 = (
              /** @type {RuleNode & Identifier} */
              reference.identifier
            );
            if (shouldReport && traceMap[READ]) {
              yield { node: node2, path, type: READ, info: traceMap[READ] };
            }
            yield* this._iteratePropertyReferences(node2, path, traceMap);
          }
        } finally {
          this.variableStack.pop();
        }
      }
      /**
       * Iterate the references for a given AST node.
       * @private
       * @template T
       * @param {Expression} rootNode The AST node to iterate references.
       * @param {string[]} path The current path.
       * @param {TraceMapObject<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      //eslint-disable-next-line complexity
      *_iteratePropertyReferences(rootNode, path, traceMap) {
        let node2 = rootNode;
        while (isPassThrough(node2)) {
          node2 = node2.parent;
        }
        const parent = (
          /** @type {RuleNode} */
          node2.parent
        );
        if (parent.type === "MemberExpression") {
          if (parent.object === node2) {
            const key = getPropertyName(parent);
            if (key == null || !has(traceMap, key)) {
              return;
            }
            path = path.concat(key);
            const nextTraceMap = traceMap[key];
            if (nextTraceMap[READ]) {
              yield {
                node: parent,
                path,
                type: READ,
                info: nextTraceMap[READ]
              };
            }
            yield* this._iteratePropertyReferences(
              parent,
              path,
              nextTraceMap
            );
          }
          return;
        }
        if (parent.type === "CallExpression") {
          if (parent.callee === node2 && traceMap[CALL]) {
            yield { node: parent, path, type: CALL, info: traceMap[CALL] };
          }
          return;
        }
        if (parent.type === "NewExpression") {
          if (parent.callee === node2 && traceMap[CONSTRUCT]) {
            yield {
              node: parent,
              path,
              type: CONSTRUCT,
              info: traceMap[CONSTRUCT]
            };
          }
          return;
        }
        if (parent.type === "AssignmentExpression") {
          if (parent.right === node2) {
            yield* this._iterateLhsReferences(parent.left, path, traceMap);
            yield* this._iteratePropertyReferences(parent, path, traceMap);
          }
          return;
        }
        if (parent.type === "AssignmentPattern") {
          if (parent.right === node2) {
            yield* this._iterateLhsReferences(parent.left, path, traceMap);
          }
          return;
        }
        if (parent.type === "VariableDeclarator") {
          if (parent.init === node2) {
            yield* this._iterateLhsReferences(parent.id, path, traceMap);
          }
        }
      }
      /**
       * Iterate the references for a given Pattern node.
       * @private
       * @template T
       * @param {Pattern} patternNode The Pattern node to iterate references.
       * @param {string[]} path The current path.
       * @param {TraceMapObject<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *_iterateLhsReferences(patternNode, path, traceMap) {
        if (patternNode.type === "Identifier") {
          const variable = findVariable(this.globalScope, patternNode);
          if (variable != null) {
            yield* this._iterateVariableReferences(
              variable,
              path,
              traceMap,
              false
            );
          }
          return;
        }
        if (patternNode.type === "ObjectPattern") {
          for (const property of patternNode.properties) {
            const key = getPropertyName(
              /** @type {AssignmentProperty} */
              property
            );
            if (key == null || !has(traceMap, key)) {
              continue;
            }
            const nextPath = path.concat(key);
            const nextTraceMap = traceMap[key];
            if (nextTraceMap[READ]) {
              yield {
                node: (
                  /** @type {RuleNode} */
                  property
                ),
                path: nextPath,
                type: READ,
                info: nextTraceMap[READ]
              };
            }
            yield* this._iterateLhsReferences(
              /** @type {AssignmentProperty} */
              property.value,
              nextPath,
              nextTraceMap
            );
          }
          return;
        }
        if (patternNode.type === "AssignmentPattern") {
          yield* this._iterateLhsReferences(patternNode.left, path, traceMap);
        }
      }
      /**
       * Iterate the references for a given ModuleSpecifier node.
       * @private
       * @template T
       * @param {ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier | ExportSpecifier} specifierNode The ModuleSpecifier node to iterate references.
       * @param {string[]} path The current path.
       * @param {TraceMapObject<T>} traceMap The trace map.
       * @returns {IterableIterator<TrackedReferences<T>>} The iterator to iterate references.
       */
      *_iterateImportReferences(specifierNode, path, traceMap) {
        const type2 = specifierNode.type;
        if (type2 === "ImportSpecifier" || type2 === "ImportDefaultSpecifier") {
          const key = type2 === "ImportDefaultSpecifier" ? "default" : specifierNode.imported.type === "Identifier" ? specifierNode.imported.name : specifierNode.imported.value;
          if (!has(traceMap, key)) {
            return;
          }
          path = path.concat(key);
          const nextTraceMap = traceMap[key];
          if (nextTraceMap[READ]) {
            yield {
              node: (
                /** @type {RuleNode} */
                specifierNode
              ),
              path,
              type: READ,
              info: nextTraceMap[READ]
            };
          }
          yield* this._iterateVariableReferences(
            /** @type {Variable} */
            findVariable(this.globalScope, specifierNode.local),
            path,
            nextTraceMap,
            false
          );
          return;
        }
        if (type2 === "ImportNamespaceSpecifier") {
          yield* this._iterateVariableReferences(
            /** @type {Variable} */
            findVariable(this.globalScope, specifierNode.local),
            path,
            traceMap,
            false
          );
          return;
        }
        if (type2 === "ExportSpecifier") {
          const key = specifierNode.local.type === "Identifier" ? specifierNode.local.name : specifierNode.local.value;
          if (!has(traceMap, key)) {
            return;
          }
          path = path.concat(key);
          const nextTraceMap = traceMap[key];
          if (nextTraceMap[READ]) {
            yield {
              node: (
                /** @type {RuleNode} */
                specifierNode
              ),
              path,
              type: READ,
              info: nextTraceMap[READ]
            };
          }
        }
      }
    }
    ReferenceTracker.READ = READ;
    ReferenceTracker.CALL = CALL;
    ReferenceTracker.CONSTRUCT = CONSTRUCT;
    ReferenceTracker.ESM = ESM;
    function exceptDefault(name, index2) {
      return !(index2 === 1 && name === "default");
    }
    var index = {
      CALL,
      CONSTRUCT,
      ESM,
      findVariable,
      getFunctionHeadLocation,
      getFunctionNameWithKind,
      getInnermostScope,
      getPropertyName,
      getStaticValue,
      getStringIfConstant,
      hasSideEffect,
      isArrowToken,
      isClosingBraceToken,
      isClosingBracketToken,
      isClosingParenToken,
      isColonToken,
      isCommaToken,
      isCommentToken,
      isNotArrowToken,
      isNotClosingBraceToken,
      isNotClosingBracketToken,
      isNotClosingParenToken,
      isNotColonToken,
      isNotCommaToken,
      isNotCommentToken,
      isNotOpeningBraceToken,
      isNotOpeningBracketToken,
      isNotOpeningParenToken,
      isNotSemicolonToken,
      isOpeningBraceToken,
      isOpeningBracketToken,
      isOpeningParenToken,
      isParenthesized,
      isSemicolonToken,
      PatternMatcher,
      READ,
      ReferenceTracker
    };
    exports$1.CALL = CALL;
    exports$1.CONSTRUCT = CONSTRUCT;
    exports$1.ESM = ESM;
    exports$1.PatternMatcher = PatternMatcher;
    exports$1.READ = READ;
    exports$1.ReferenceTracker = ReferenceTracker;
    exports$1["default"] = index;
    exports$1.findVariable = findVariable;
    exports$1.getFunctionHeadLocation = getFunctionHeadLocation;
    exports$1.getFunctionNameWithKind = getFunctionNameWithKind;
    exports$1.getInnermostScope = getInnermostScope;
    exports$1.getPropertyName = getPropertyName;
    exports$1.getStaticValue = getStaticValue;
    exports$1.getStringIfConstant = getStringIfConstant;
    exports$1.hasSideEffect = hasSideEffect;
    exports$1.isArrowToken = isArrowToken;
    exports$1.isClosingBraceToken = isClosingBraceToken;
    exports$1.isClosingBracketToken = isClosingBracketToken;
    exports$1.isClosingParenToken = isClosingParenToken;
    exports$1.isColonToken = isColonToken;
    exports$1.isCommaToken = isCommaToken;
    exports$1.isCommentToken = isCommentToken;
    exports$1.isNotArrowToken = isNotArrowToken;
    exports$1.isNotClosingBraceToken = isNotClosingBraceToken;
    exports$1.isNotClosingBracketToken = isNotClosingBracketToken;
    exports$1.isNotClosingParenToken = isNotClosingParenToken;
    exports$1.isNotColonToken = isNotColonToken;
    exports$1.isNotCommaToken = isNotCommaToken;
    exports$1.isNotCommentToken = isNotCommentToken;
    exports$1.isNotOpeningBraceToken = isNotOpeningBraceToken;
    exports$1.isNotOpeningBracketToken = isNotOpeningBracketToken;
    exports$1.isNotOpeningParenToken = isNotOpeningParenToken;
    exports$1.isNotSemicolonToken = isNotSemicolonToken;
    exports$1.isOpeningBraceToken = isOpeningBraceToken;
    exports$1.isOpeningBracketToken = isOpeningBracketToken;
    exports$1.isOpeningParenToken = isOpeningParenToken;
    exports$1.isParenthesized = isParenthesized;
    exports$1.isSemicolonToken = isSemicolonToken;
  })(eslintUtils);
  return eslintUtils;
}
var assert;
var hasRequiredAssert;
function requireAssert() {
  if (hasRequiredAssert) return assert;
  hasRequiredAssert = 1;
  function ok(value, message = "Assertion failed.") {
    if (!value) {
      throw new Error(message);
    }
  }
  assert = ok;
  return assert;
}
var cursor;
var hasRequiredCursor;
function requireCursor() {
  if (hasRequiredCursor) return cursor;
  hasRequiredCursor = 1;
  cursor = class Cursor {
    /**
     * Initializes this cursor.
     */
    constructor() {
      this.current = null;
    }
    /**
     * Gets the first token.
     * This consumes this cursor.
     * @returns {Token|Comment} The first token or null.
     */
    getOneToken() {
      return this.moveNext() ? this.current : null;
    }
    /**
     * Gets the first tokens.
     * This consumes this cursor.
     * @returns {(Token|Comment)[]} All tokens.
     */
    getAllTokens() {
      const tokens = [];
      while (this.moveNext()) {
        tokens.push(this.current);
      }
      return tokens;
    }
    /**
     * Moves this cursor to the next token.
     * @returns {boolean} `true` if the next token exists.
     * @abstract
     */
    /* c8 ignore next */
    // eslint-disable-next-line class-methods-use-this -- Unused
    moveNext() {
      throw new Error("Not implemented.");
    }
  };
  return cursor;
}
var utils$1 = {};
var hasRequiredUtils$1;
function requireUtils$1() {
  if (hasRequiredUtils$1) return utils$1;
  hasRequiredUtils$1 = 1;
  utils$1.search = function search(tokens, location) {
    for (let minIndex = 0, maxIndex = tokens.length - 1; minIndex <= maxIndex; ) {
      const index = (minIndex + maxIndex) / 2 | 0;
      const token = tokens[index];
      const tokenStartLocation = token.range[0];
      if (location <= tokenStartLocation) {
        if (index === minIndex) {
          return index;
        }
        maxIndex = index;
      } else {
        minIndex = index + 1;
      }
    }
    return tokens.length;
  };
  utils$1.getFirstIndex = function getFirstIndex(tokens, indexMap, startLoc) {
    if (startLoc in indexMap) {
      return indexMap[startLoc];
    }
    if (startLoc - 1 in indexMap) {
      const index = indexMap[startLoc - 1];
      const token = tokens[index];
      if (!token) {
        return tokens.length;
      }
      if (token.range[0] >= startLoc) {
        return index;
      }
      return index + 1;
    }
    return 0;
  };
  utils$1.getLastIndex = function getLastIndex(tokens, indexMap, endLoc) {
    if (endLoc in indexMap) {
      return indexMap[endLoc] - 1;
    }
    if (endLoc - 1 in indexMap) {
      const index = indexMap[endLoc - 1];
      const token = tokens[index];
      if (!token) {
        return tokens.length - 1;
      }
      if (token.range[1] > endLoc) {
        return index - 1;
      }
      return index;
    }
    return tokens.length - 1;
  };
  return utils$1;
}
var backwardTokenCommentCursor;
var hasRequiredBackwardTokenCommentCursor;
function requireBackwardTokenCommentCursor() {
  if (hasRequiredBackwardTokenCommentCursor) return backwardTokenCommentCursor;
  hasRequiredBackwardTokenCommentCursor = 1;
  const Cursor = requireCursor();
  const utils2 = requireUtils$1();
  backwardTokenCommentCursor = class BackwardTokenCommentCursor extends Cursor {
    /**
     * Initializes this cursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     */
    constructor(tokens, comments, indexMap, startLoc, endLoc) {
      super();
      this.tokens = tokens;
      this.comments = comments;
      this.tokenIndex = utils2.getLastIndex(tokens, indexMap, endLoc);
      this.commentIndex = utils2.search(comments, endLoc) - 1;
      this.border = startLoc;
    }
    /** @inheritdoc */
    moveNext() {
      const token = this.tokenIndex >= 0 ? this.tokens[this.tokenIndex] : null;
      const comment2 = this.commentIndex >= 0 ? this.comments[this.commentIndex] : null;
      if (token && (!comment2 || token.range[1] > comment2.range[1])) {
        this.current = token;
        this.tokenIndex -= 1;
      } else if (comment2) {
        this.current = comment2;
        this.commentIndex -= 1;
      } else {
        this.current = null;
      }
      return Boolean(this.current) && (this.border === -1 || this.current.range[0] >= this.border);
    }
  };
  return backwardTokenCommentCursor;
}
var backwardTokenCursor;
var hasRequiredBackwardTokenCursor;
function requireBackwardTokenCursor() {
  if (hasRequiredBackwardTokenCursor) return backwardTokenCursor;
  hasRequiredBackwardTokenCursor = 1;
  const Cursor = requireCursor();
  const { getLastIndex, getFirstIndex } = requireUtils$1();
  backwardTokenCursor = class BackwardTokenCursor extends Cursor {
    /**
     * Initializes this cursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     */
    constructor(tokens, comments, indexMap, startLoc, endLoc) {
      super();
      this.tokens = tokens;
      this.index = getLastIndex(tokens, indexMap, endLoc);
      this.indexEnd = getFirstIndex(tokens, indexMap, startLoc);
    }
    /** @inheritdoc */
    moveNext() {
      if (this.index >= this.indexEnd) {
        this.current = this.tokens[this.index];
        this.index -= 1;
        return true;
      }
      return false;
    }
    /*
     *
     * Shorthand for performance.
     *
     */
    /** @inheritdoc */
    getOneToken() {
      return this.index >= this.indexEnd ? this.tokens[this.index] : null;
    }
  };
  return backwardTokenCursor;
}
var decorativeCursor;
var hasRequiredDecorativeCursor;
function requireDecorativeCursor() {
  if (hasRequiredDecorativeCursor) return decorativeCursor;
  hasRequiredDecorativeCursor = 1;
  const Cursor = requireCursor();
  decorativeCursor = class DecorativeCursor extends Cursor {
    /**
     * Initializes this cursor.
     * @param {Cursor} cursor The cursor to be decorated.
     */
    constructor(cursor2) {
      super();
      this.cursor = cursor2;
    }
    /** @inheritdoc */
    moveNext() {
      const retv = this.cursor.moveNext();
      this.current = this.cursor.current;
      return retv;
    }
  };
  return decorativeCursor;
}
var filterCursor;
var hasRequiredFilterCursor;
function requireFilterCursor() {
  if (hasRequiredFilterCursor) return filterCursor;
  hasRequiredFilterCursor = 1;
  const DecorativeCursor = requireDecorativeCursor();
  filterCursor = class FilterCursor extends DecorativeCursor {
    /**
     * Initializes this cursor.
     * @param {Cursor} cursor The cursor to be decorated.
     * @param {Function} predicate The predicate function to decide tokens this cursor iterates.
     */
    constructor(cursor2, predicate) {
      super(cursor2);
      this.predicate = predicate;
    }
    /** @inheritdoc */
    moveNext() {
      const predicate = this.predicate;
      while (super.moveNext()) {
        if (predicate(this.current)) {
          return true;
        }
      }
      return false;
    }
  };
  return filterCursor;
}
var forwardTokenCommentCursor;
var hasRequiredForwardTokenCommentCursor;
function requireForwardTokenCommentCursor() {
  if (hasRequiredForwardTokenCommentCursor) return forwardTokenCommentCursor;
  hasRequiredForwardTokenCommentCursor = 1;
  const Cursor = requireCursor();
  const { getFirstIndex, search } = requireUtils$1();
  forwardTokenCommentCursor = class ForwardTokenCommentCursor extends Cursor {
    /**
     * Initializes this cursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     */
    constructor(tokens, comments, indexMap, startLoc, endLoc) {
      super();
      this.tokens = tokens;
      this.comments = comments;
      this.tokenIndex = getFirstIndex(tokens, indexMap, startLoc);
      this.commentIndex = search(comments, startLoc);
      this.border = endLoc;
    }
    /** @inheritdoc */
    moveNext() {
      const token = this.tokenIndex < this.tokens.length ? this.tokens[this.tokenIndex] : null;
      const comment2 = this.commentIndex < this.comments.length ? this.comments[this.commentIndex] : null;
      if (token && (!comment2 || token.range[0] < comment2.range[0])) {
        this.current = token;
        this.tokenIndex += 1;
      } else if (comment2) {
        this.current = comment2;
        this.commentIndex += 1;
      } else {
        this.current = null;
      }
      return Boolean(this.current) && (this.border === -1 || this.current.range[1] <= this.border);
    }
  };
  return forwardTokenCommentCursor;
}
var forwardTokenCursor;
var hasRequiredForwardTokenCursor;
function requireForwardTokenCursor() {
  if (hasRequiredForwardTokenCursor) return forwardTokenCursor;
  hasRequiredForwardTokenCursor = 1;
  const Cursor = requireCursor();
  const { getFirstIndex, getLastIndex } = requireUtils$1();
  forwardTokenCursor = class ForwardTokenCursor extends Cursor {
    /**
     * Initializes this cursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     */
    constructor(tokens, comments, indexMap, startLoc, endLoc) {
      super();
      this.tokens = tokens;
      this.index = getFirstIndex(tokens, indexMap, startLoc);
      this.indexEnd = getLastIndex(tokens, indexMap, endLoc);
    }
    /** @inheritdoc */
    moveNext() {
      if (this.index <= this.indexEnd) {
        this.current = this.tokens[this.index];
        this.index += 1;
        return true;
      }
      return false;
    }
    /*
     *
     * Shorthand for performance.
     *
     */
    /** @inheritdoc */
    getOneToken() {
      return this.index <= this.indexEnd ? this.tokens[this.index] : null;
    }
    /** @inheritdoc */
    getAllTokens() {
      return this.tokens.slice(this.index, this.indexEnd + 1);
    }
  };
  return forwardTokenCursor;
}
var limitCursor;
var hasRequiredLimitCursor;
function requireLimitCursor() {
  if (hasRequiredLimitCursor) return limitCursor;
  hasRequiredLimitCursor = 1;
  const DecorativeCursor = requireDecorativeCursor();
  limitCursor = class LimitCursor extends DecorativeCursor {
    /**
     * Initializes this cursor.
     * @param {Cursor} cursor The cursor to be decorated.
     * @param {number} count The count of tokens this cursor iterates.
     */
    constructor(cursor2, count) {
      super(cursor2);
      this.count = count;
    }
    /** @inheritdoc */
    moveNext() {
      if (this.count > 0) {
        this.count -= 1;
        return super.moveNext();
      }
      return false;
    }
  };
  return limitCursor;
}
var skipCursor;
var hasRequiredSkipCursor;
function requireSkipCursor() {
  if (hasRequiredSkipCursor) return skipCursor;
  hasRequiredSkipCursor = 1;
  const DecorativeCursor = requireDecorativeCursor();
  skipCursor = class SkipCursor extends DecorativeCursor {
    /**
     * Initializes this cursor.
     * @param {Cursor} cursor The cursor to be decorated.
     * @param {number} count The count of tokens this cursor skips.
     */
    constructor(cursor2, count) {
      super(cursor2);
      this.count = count;
    }
    /** @inheritdoc */
    moveNext() {
      while (this.count > 0) {
        this.count -= 1;
        if (!super.moveNext()) {
          return false;
        }
      }
      return super.moveNext();
    }
  };
  return skipCursor;
}
var cursors;
var hasRequiredCursors;
function requireCursors() {
  if (hasRequiredCursors) return cursors;
  hasRequiredCursors = 1;
  const BackwardTokenCommentCursor = requireBackwardTokenCommentCursor();
  const BackwardTokenCursor = requireBackwardTokenCursor();
  const FilterCursor = requireFilterCursor();
  const ForwardTokenCommentCursor = requireForwardTokenCommentCursor();
  const ForwardTokenCursor = requireForwardTokenCursor();
  const LimitCursor = requireLimitCursor();
  const SkipCursor = requireSkipCursor();
  class CursorFactory {
    /**
     * Initializes this cursor.
     * @param {Function} TokenCursor The class of the cursor which iterates tokens only.
     * @param {Function} TokenCommentCursor The class of the cursor which iterates the mix of tokens and comments.
     */
    constructor(TokenCursor, TokenCommentCursor) {
      this.TokenCursor = TokenCursor;
      this.TokenCommentCursor = TokenCommentCursor;
    }
    /**
     * Creates a base cursor instance that can be decorated by createCursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     * @param {boolean} includeComments The flag to iterate comments as well.
     * @returns {Cursor} The created base cursor.
     */
    createBaseCursor(tokens, comments, indexMap, startLoc, endLoc, includeComments) {
      const Cursor = includeComments ? this.TokenCommentCursor : this.TokenCursor;
      return new Cursor(tokens, comments, indexMap, startLoc, endLoc);
    }
    /**
     * Creates a cursor that iterates tokens with normalized options.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     * @param {boolean} includeComments The flag to iterate comments as well.
     * @param {Function|null} filter The predicate function to choose tokens.
     * @param {number} skip The count of tokens the cursor skips.
     * @param {number} count The maximum count of tokens the cursor iterates. Zero is no iteration for backward compatibility.
     * @returns {Cursor} The created cursor.
     */
    createCursor(tokens, comments, indexMap, startLoc, endLoc, includeComments, filter2, skip, count) {
      let cursor2 = this.createBaseCursor(
        tokens,
        comments,
        indexMap,
        startLoc,
        endLoc,
        includeComments
      );
      if (filter2) {
        cursor2 = new FilterCursor(cursor2, filter2);
      }
      if (skip >= 1) {
        cursor2 = new SkipCursor(cursor2, skip);
      }
      if (count >= 0) {
        cursor2 = new LimitCursor(cursor2, count);
      }
      return cursor2;
    }
  }
  cursors = {
    forward: new CursorFactory(ForwardTokenCursor, ForwardTokenCommentCursor),
    backward: new CursorFactory(
      BackwardTokenCursor,
      BackwardTokenCommentCursor
    )
  };
  return cursors;
}
var paddedTokenCursor;
var hasRequiredPaddedTokenCursor;
function requirePaddedTokenCursor() {
  if (hasRequiredPaddedTokenCursor) return paddedTokenCursor;
  hasRequiredPaddedTokenCursor = 1;
  const ForwardTokenCursor = requireForwardTokenCursor();
  paddedTokenCursor = class PaddedTokenCursor extends ForwardTokenCursor {
    /**
     * Initializes this cursor.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     * @param {Object} indexMap The map from locations to indices in `tokens`.
     * @param {number} startLoc The start location of the iteration range.
     * @param {number} endLoc The end location of the iteration range.
     * @param {number} beforeCount The number of tokens this cursor iterates before start.
     * @param {number} afterCount The number of tokens this cursor iterates after end.
     */
    constructor(tokens, comments, indexMap, startLoc, endLoc, beforeCount, afterCount) {
      super(tokens, comments, indexMap, startLoc, endLoc);
      this.index = Math.max(0, this.index - beforeCount);
      this.indexEnd = Math.min(tokens.length - 1, this.indexEnd + afterCount);
    }
  };
  return paddedTokenCursor;
}
var tokenStore;
var hasRequiredTokenStore;
function requireTokenStore() {
  if (hasRequiredTokenStore) return tokenStore;
  hasRequiredTokenStore = 1;
  const { isCommentToken } = /* @__PURE__ */ requireEslintUtils();
  const assert2 = requireAssert();
  const cursors2 = requireCursors();
  const ForwardTokenCursor = requireForwardTokenCursor();
  const PaddedTokenCursor = requirePaddedTokenCursor();
  const utils2 = requireUtils$1();
  const TOKENS = Symbol("tokens");
  const COMMENTS = Symbol("comments");
  const INDEX_MAP = Symbol("indexMap");
  function createIndexMap(tokens, comments) {
    const map = /* @__PURE__ */ Object.create(null);
    let tokenIndex = 0;
    let commentIndex = 0;
    let nextStart;
    let range;
    while (tokenIndex < tokens.length || commentIndex < comments.length) {
      nextStart = commentIndex < comments.length ? comments[commentIndex].range[0] : Number.MAX_SAFE_INTEGER;
      while (tokenIndex < tokens.length && (range = tokens[tokenIndex].range)[0] < nextStart) {
        map[range[0]] = tokenIndex;
        map[range[1] - 1] = tokenIndex;
        tokenIndex += 1;
      }
      nextStart = tokenIndex < tokens.length ? tokens[tokenIndex].range[0] : Number.MAX_SAFE_INTEGER;
      while (commentIndex < comments.length && (range = comments[commentIndex].range)[0] < nextStart) {
        map[range[0]] = tokenIndex;
        map[range[1] - 1] = tokenIndex;
        commentIndex += 1;
      }
    }
    return map;
  }
  function createCursorWithSkip(factory, tokens, comments, indexMap, startLoc, endLoc, opts) {
    let includeComments = false;
    let skip = 0;
    let filter2 = null;
    if (typeof opts === "number") {
      skip = opts | 0;
    } else if (typeof opts === "function") {
      filter2 = opts;
    } else if (opts) {
      includeComments = !!opts.includeComments;
      skip = opts.skip | 0;
      filter2 = opts.filter || null;
    }
    assert2(skip >= 0, "options.skip should be zero or a positive integer.");
    assert2(
      !filter2 || typeof filter2 === "function",
      "options.filter should be a function."
    );
    return factory.createCursor(
      tokens,
      comments,
      indexMap,
      startLoc,
      endLoc,
      includeComments,
      filter2,
      skip,
      -1
    );
  }
  function createCursorWithCount(factory, tokens, comments, indexMap, startLoc, endLoc, opts) {
    let includeComments = false;
    let count = 0;
    let countExists = false;
    let filter2 = null;
    if (typeof opts === "number") {
      count = opts | 0;
      countExists = true;
    } else if (typeof opts === "function") {
      filter2 = opts;
    } else if (opts) {
      includeComments = !!opts.includeComments;
      count = opts.count | 0;
      countExists = typeof opts.count === "number";
      filter2 = opts.filter || null;
    }
    assert2(count >= 0, "options.count should be zero or a positive integer.");
    assert2(
      !filter2 || typeof filter2 === "function",
      "options.filter should be a function."
    );
    return factory.createCursor(
      tokens,
      comments,
      indexMap,
      startLoc,
      endLoc,
      includeComments,
      filter2,
      0,
      countExists ? count : -1
    );
  }
  function createCursorWithPadding(tokens, comments, indexMap, startLoc, endLoc, beforeCount, afterCount) {
    if (typeof beforeCount === "undefined" && typeof afterCount === "undefined") {
      return new ForwardTokenCursor(
        tokens,
        comments,
        indexMap,
        startLoc,
        endLoc
      );
    }
    if (typeof beforeCount === "number" || typeof beforeCount === "undefined") {
      return new PaddedTokenCursor(
        tokens,
        comments,
        indexMap,
        startLoc,
        endLoc,
        beforeCount | 0,
        afterCount | 0
      );
    }
    return createCursorWithCount(
      cursors2.forward,
      tokens,
      comments,
      indexMap,
      startLoc,
      endLoc,
      beforeCount
    );
  }
  function getAdjacentCommentTokensFromCursor(cursor2) {
    const tokens = [];
    let currentToken = cursor2.getOneToken();
    while (currentToken && isCommentToken(currentToken)) {
      tokens.push(currentToken);
      currentToken = cursor2.getOneToken();
    }
    return tokens;
  }
  tokenStore = class TokenStore {
    /**
     * Initializes this token store.
     * @param {Token[]} tokens The array of tokens.
     * @param {Comment[]} comments The array of comments.
     */
    constructor(tokens, comments) {
      this[TOKENS] = tokens;
      this[COMMENTS] = comments;
      this[INDEX_MAP] = createIndexMap(tokens, comments);
    }
    //--------------------------------------------------------------------------
    // Gets single token.
    //--------------------------------------------------------------------------
    /**
     * Gets the token starting at the specified index.
     * @param {number} offset Index of the start of the token's range.
     * @param {Object} [options=0] The option object.
     * @param {boolean} [options.includeComments=false] The flag to iterate comments as well.
     * @returns {Token|null} The token starting at index, or null if no such token.
     */
    getTokenByRangeStart(offset, options) {
      const includeComments = options && options.includeComments;
      const token = cursors2.forward.createBaseCursor(
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        offset,
        -1,
        includeComments
      ).getOneToken();
      if (token && token.range[0] === offset) {
        return token;
      }
      return null;
    }
    /**
     * Gets the first token of the given node.
     * @param {ASTNode} node The AST node.
     * @param {number|Function|Object} [options=0] The option object. If this is a number then it's `options.skip`. If this is a function then it's `options.filter`.
     * @param {boolean} [options.includeComments=false] The flag to iterate comments as well.
     * @param {Function|null} [options.filter=null] The predicate function to choose tokens.
     * @param {number} [options.skip=0] The count of tokens the cursor skips.
     * @returns {Token|null} An object representing the token.
     */
    getFirstToken(node2, options) {
      return createCursorWithSkip(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[0],
        node2.range[1],
        options
      ).getOneToken();
    }
    /**
     * Gets the last token of the given node.
     * @param {ASTNode} node The AST node.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstToken()
     * @returns {Token|null} An object representing the token.
     */
    getLastToken(node2, options) {
      return createCursorWithSkip(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[0],
        node2.range[1],
        options
      ).getOneToken();
    }
    /**
     * Gets the token that precedes a given node or token.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstToken()
     * @returns {Token|null} An object representing the token.
     */
    getTokenBefore(node2, options) {
      return createCursorWithSkip(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        -1,
        node2.range[0],
        options
      ).getOneToken();
    }
    /**
     * Gets the token that follows a given node or token.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstToken()
     * @returns {Token|null} An object representing the token.
     */
    getTokenAfter(node2, options) {
      return createCursorWithSkip(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[1],
        -1,
        options
      ).getOneToken();
    }
    /**
     * Gets the first token between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstToken()
     * @returns {Token|null} An object representing the token.
     */
    getFirstTokenBetween(left, right, options) {
      return createCursorWithSkip(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        left.range[1],
        right.range[0],
        options
      ).getOneToken();
    }
    /**
     * Gets the last token between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstToken()
     * @returns {Token|null} An object representing the token.
     */
    getLastTokenBetween(left, right, options) {
      return createCursorWithSkip(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        left.range[1],
        right.range[0],
        options
      ).getOneToken();
    }
    /**
     * Gets the token that precedes a given node or token in the token stream.
     * This is defined for backward compatibility. Use `includeComments` option instead.
     * TODO: We have a plan to remove this in a future major version.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number} [skip=0] A number of tokens to skip.
     * @returns {Token|null} An object representing the token.
     * @deprecated
     */
    getTokenOrCommentBefore(node2, skip) {
      return this.getTokenBefore(node2, { includeComments: true, skip });
    }
    /**
     * Gets the token that follows a given node or token in the token stream.
     * This is defined for backward compatibility. Use `includeComments` option instead.
     * TODO: We have a plan to remove this in a future major version.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number} [skip=0] A number of tokens to skip.
     * @returns {Token|null} An object representing the token.
     * @deprecated
     */
    getTokenOrCommentAfter(node2, skip) {
      return this.getTokenAfter(node2, { includeComments: true, skip });
    }
    //--------------------------------------------------------------------------
    // Gets multiple tokens.
    //--------------------------------------------------------------------------
    /**
     * Gets the first `count` tokens of the given node.
     * @param {ASTNode} node The AST node.
     * @param {number|Function|Object} [options=0] The option object. If this is a number then it's `options.count`. If this is a function then it's `options.filter`.
     * @param {boolean} [options.includeComments=false] The flag to iterate comments as well.
     * @param {Function|null} [options.filter=null] The predicate function to choose tokens.
     * @param {number} [options.count=0] The maximum count of tokens the cursor iterates.
     * @returns {Token[]} Tokens.
     */
    getFirstTokens(node2, options) {
      return createCursorWithCount(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[0],
        node2.range[1],
        options
      ).getAllTokens();
    }
    /**
     * Gets the last `count` tokens of the given node.
     * @param {ASTNode} node The AST node.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstTokens()
     * @returns {Token[]} Tokens.
     */
    getLastTokens(node2, options) {
      return createCursorWithCount(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[0],
        node2.range[1],
        options
      ).getAllTokens().reverse();
    }
    /**
     * Gets the `count` tokens that precedes a given node or token.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstTokens()
     * @returns {Token[]} Tokens.
     */
    getTokensBefore(node2, options) {
      return createCursorWithCount(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        -1,
        node2.range[0],
        options
      ).getAllTokens().reverse();
    }
    /**
     * Gets the `count` tokens that follows a given node or token.
     * @param {ASTNode|Token|Comment} node The AST node or token.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstTokens()
     * @returns {Token[]} Tokens.
     */
    getTokensAfter(node2, options) {
      return createCursorWithCount(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[1],
        -1,
        options
      ).getAllTokens();
    }
    /**
     * Gets the first `count` tokens between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstTokens()
     * @returns {Token[]} Tokens between left and right.
     */
    getFirstTokensBetween(left, right, options) {
      return createCursorWithCount(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        left.range[1],
        right.range[0],
        options
      ).getAllTokens();
    }
    /**
     * Gets the last `count` tokens between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {number|Function|Object} [options=0] The option object. Same options as getFirstTokens()
     * @returns {Token[]} Tokens between left and right.
     */
    getLastTokensBetween(left, right, options) {
      return createCursorWithCount(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        left.range[1],
        right.range[0],
        options
      ).getAllTokens().reverse();
    }
    /**
     * Gets all tokens that are related to the given node.
     * @param {ASTNode} node The AST node.
     * @param {Function|Object} options The option object. If this is a function then it's `options.filter`.
     * @param {boolean} [options.includeComments=false] The flag to iterate comments as well.
     * @param {Function|null} [options.filter=null] The predicate function to choose tokens.
     * @param {number} [options.count=0] The maximum count of tokens the cursor iterates.
     * @returns {Token[]} Array of objects representing tokens.
     */
    /**
     * Gets all tokens that are related to the given node.
     * @param {ASTNode} node The AST node.
     * @param {number} [beforeCount=0] The number of tokens before the node to retrieve.
     * @param {number} [afterCount=0] The number of tokens after the node to retrieve.
     * @returns {Token[]} Array of objects representing tokens.
     */
    getTokens(node2, beforeCount, afterCount) {
      return createCursorWithPadding(
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        node2.range[0],
        node2.range[1],
        beforeCount,
        afterCount
      ).getAllTokens();
    }
    /**
     * Gets all of the tokens between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {Function|Object} options The option object. If this is a function then it's `options.filter`.
     * @param {boolean} [options.includeComments=false] The flag to iterate comments as well.
     * @param {Function|null} [options.filter=null] The predicate function to choose tokens.
     * @param {number} [options.count=0] The maximum count of tokens the cursor iterates.
     * @returns {Token[]} Tokens between left and right.
     */
    /**
     * Gets all of the tokens between two non-overlapping nodes.
     * @param {ASTNode|Token|Comment} left Node before the desired token range.
     * @param {ASTNode|Token|Comment} right Node after the desired token range.
     * @param {number} [padding=0] Number of extra tokens on either side of center.
     * @returns {Token[]} Tokens between left and right.
     */
    getTokensBetween(left, right, padding) {
      return createCursorWithPadding(
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        left.range[1],
        right.range[0],
        padding,
        padding
      ).getAllTokens();
    }
    //--------------------------------------------------------------------------
    // Others.
    //--------------------------------------------------------------------------
    /**
     * Checks whether any comments exist or not between the given 2 nodes.
     * @param {ASTNode} left The node to check.
     * @param {ASTNode} right The node to check.
     * @returns {boolean} `true` if one or more comments exist.
     */
    commentsExistBetween(left, right) {
      const index = utils2.search(this[COMMENTS], left.range[1]);
      return index < this[COMMENTS].length && this[COMMENTS][index].range[1] <= right.range[0];
    }
    /**
     * Gets all comment tokens directly before the given node or token.
     * @param {ASTNode|token} nodeOrToken The AST node or token to check for adjacent comment tokens.
     * @returns {Array} An array of comments in occurrence order.
     */
    getCommentsBefore(nodeOrToken) {
      const cursor2 = createCursorWithCount(
        cursors2.backward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        -1,
        nodeOrToken.range[0],
        { includeComments: true }
      );
      return getAdjacentCommentTokensFromCursor(cursor2).reverse();
    }
    /**
     * Gets all comment tokens directly after the given node or token.
     * @param {ASTNode|token} nodeOrToken The AST node or token to check for adjacent comment tokens.
     * @returns {Array} An array of comments in occurrence order.
     */
    getCommentsAfter(nodeOrToken) {
      const cursor2 = createCursorWithCount(
        cursors2.forward,
        this[TOKENS],
        this[COMMENTS],
        this[INDEX_MAP],
        nodeOrToken.range[1],
        -1,
        { includeComments: true }
      );
      return getAdjacentCommentTokensFromCursor(cursor2);
    }
    /**
     * Gets all comment tokens inside the given node.
     * @param {ASTNode} node The AST node to get the comments for.
     * @returns {Array} An array of comments in occurrence order.
     */
    getCommentsInside(node2) {
      return this.getTokens(node2, {
        includeComments: true,
        filter: isCommentToken
      });
    }
  };
  return tokenStore;
}
var astUtils$1;
var hasRequiredAstUtils$1;
function requireAstUtils$1() {
  if (hasRequiredAstUtils$1) return astUtils$1;
  hasRequiredAstUtils$1 = 1;
  const breakableTypePattern = /^(?:(?:Do)?While|For(?:In|Of)?|Switch)Statement$/u;
  const lineBreakPattern = /\r\n|[\r\n\u2028\u2029]/u;
  const shebangPattern = /^#!([^\r\n]+)/u;
  function createGlobalLinebreakMatcher() {
    return new RegExp(lineBreakPattern.source, "gu");
  }
  astUtils$1 = {
    breakableTypePattern,
    lineBreakPattern,
    createGlobalLinebreakMatcher,
    shebangPattern
  };
  return astUtils$1;
}
var globals;
var hasRequiredGlobals;
function requireGlobals() {
  if (hasRequiredGlobals) return globals;
  hasRequiredGlobals = 1;
  const commonjs2 = {
    exports: true,
    global: false,
    module: false,
    require: false
  };
  const es3 = {
    Array: false,
    Boolean: false,
    constructor: false,
    Date: false,
    decodeURI: false,
    decodeURIComponent: false,
    encodeURI: false,
    encodeURIComponent: false,
    Error: false,
    escape: false,
    eval: false,
    EvalError: false,
    Function: false,
    hasOwnProperty: false,
    Infinity: false,
    isFinite: false,
    isNaN: false,
    isPrototypeOf: false,
    Math: false,
    NaN: false,
    Number: false,
    Object: false,
    parseFloat: false,
    parseInt: false,
    propertyIsEnumerable: false,
    RangeError: false,
    ReferenceError: false,
    RegExp: false,
    String: false,
    SyntaxError: false,
    toLocaleString: false,
    toString: false,
    TypeError: false,
    undefined: false,
    unescape: false,
    URIError: false,
    valueOf: false
  };
  const es52 = {
    ...es3,
    JSON: false
  };
  const es20152 = {
    ...es52,
    ArrayBuffer: false,
    DataView: false,
    Float32Array: false,
    Float64Array: false,
    Int16Array: false,
    Int32Array: false,
    Int8Array: false,
    Intl: false,
    Map: false,
    Promise: false,
    Proxy: false,
    Reflect: false,
    Set: false,
    Symbol: false,
    Uint16Array: false,
    Uint32Array: false,
    Uint8Array: false,
    Uint8ClampedArray: false,
    WeakMap: false,
    WeakSet: false
  };
  const es2016 = {
    ...es20152
  };
  const es20172 = {
    ...es2016,
    Atomics: false,
    SharedArrayBuffer: false
  };
  const es2018 = {
    ...es20172
  };
  const es2019 = {
    ...es2018
  };
  const es20202 = {
    ...es2019,
    BigInt: false,
    BigInt64Array: false,
    BigUint64Array: false,
    globalThis: false
  };
  const es20212 = {
    ...es20202,
    AggregateError: false,
    FinalizationRegistry: false,
    WeakRef: false
  };
  const es2022 = {
    ...es20212
  };
  const es2023 = {
    ...es2022
  };
  const es2024 = {
    ...es2023
  };
  const es2025 = {
    ...es2024,
    Float16Array: false,
    Iterator: false
  };
  const es2026 = {
    ...es2025,
    AsyncDisposableStack: false,
    DisposableStack: false,
    SuppressedError: false
  };
  globals = {
    commonjs: commonjs2,
    es3,
    es5: es52,
    es2015: es20152,
    es2016,
    es2017: es20172,
    es2018,
    es2019,
    es2020: es20202,
    es2021: es20212,
    es2022,
    es2023,
    es2024,
    es2025,
    es2026
  };
  return globals;
}
var directives;
var hasRequiredDirectives;
function requireDirectives() {
  if (hasRequiredDirectives) return directives;
  hasRequiredDirectives = 1;
  const directivesPattern = /^(eslint(?:-env|-enable|-disable(?:(?:-next)?-line)?)?|exported|globals?)(?:\s|$)/u;
  directives = {
    directivesPattern
  };
  return directives;
}
var debugHelpers;
var hasRequiredDebugHelpers;
function requireDebugHelpers() {
  if (hasRequiredDebugHelpers) return debugHelpers;
  hasRequiredDebugHelpers = 1;
  const debug = requireSrc()("eslint:code-path");
  function getId(segment) {
    return segment.id + (segment.reachable ? "" : "!");
  }
  function nodeToString(node2, label) {
    const suffix = label ? `:${label}` : "";
    switch (node2.type) {
      case "Identifier":
        return `${node2.type}${suffix} (${node2.name})`;
      case "Literal":
        return `${node2.type}${suffix} (${node2.value})`;
      default:
        return `${node2.type}${suffix}`;
    }
  }
  debugHelpers = {
    /**
     * A flag that debug dumping is enabled or not.
     * @type {boolean}
     */
    enabled: debug.enabled,
    /**
     * Dumps given objects.
     * @param {...any} args objects to dump.
     * @returns {void}
     */
    dump: debug,
    /**
     * Dumps the current analyzing state.
     * @param {ASTNode} node A node to dump.
     * @param {CodePathState} state A state to dump.
     * @param {boolean} leaving A flag whether or not it's leaving
     * @returns {void}
     */
    dumpState: !debug.enabled ? debug : (
      /* c8 ignore next */
      (function(node2, state, leaving) {
        for (let i2 = 0; i2 < state.currentSegments.length; ++i2) {
          const segInternal = state.currentSegments[i2].internal;
          if (leaving) {
            const last = segInternal.nodes.length - 1;
            if (last >= 0 && segInternal.nodes[last] === nodeToString(node2, "enter")) {
              segInternal.nodes[last] = nodeToString(
                node2,
                void 0
              );
            } else {
              segInternal.nodes.push(nodeToString(node2, "exit"));
            }
          } else {
            segInternal.nodes.push(nodeToString(node2, "enter"));
          }
        }
        debug(
          [
            `${state.currentSegments.map(getId).join(",")})`,
            `${node2.type}${leaving ? ":exit" : ""}`
          ].join(" ")
        );
      })
    ),
    /**
     * Dumps a DOT code of a given code path.
     * The DOT code can be visualized with Graphvis.
     * @param {CodePath} codePath A code path to dump.
     * @returns {void}
     * @see http://www.graphviz.org
     * @see http://www.webgraphviz.com
     */
    dumpDot: !debug.enabled ? debug : (
      /* c8 ignore next */
      (function(codePath2) {
        let text = '\ndigraph {\nnode[shape=box,style="rounded,filled",fillcolor=white];\ninitial[label="",shape=circle,style=filled,fillcolor=black,width=0.25,height=0.25];\n';
        if (codePath2.returnedSegments.length > 0) {
          text += 'final[label="",shape=doublecircle,style=filled,fillcolor=black,width=0.25,height=0.25];\n';
        }
        if (codePath2.thrownSegments.length > 0) {
          text += 'thrown[label="✘",shape=circle,width=0.3,height=0.3,fixedsize=true];\n';
        }
        const traceMap = /* @__PURE__ */ Object.create(null);
        const arrows = this.makeDotArrows(codePath2, traceMap);
        for (const id2 in traceMap) {
          const segment = traceMap[id2];
          text += `${id2}[`;
          if (segment.reachable) {
            text += 'label="';
          } else {
            text += 'style="rounded,dashed,filled",fillcolor="#FF9800",label="<<unreachable>>\\n';
          }
          if (segment.internal.nodes.length > 0) {
            text += segment.internal.nodes.join("\\n");
          } else {
            text += "????";
          }
          text += '"];\n';
        }
        text += `${arrows}
`;
        text += "}";
        debug("DOT", text);
      })
    ),
    /**
     * Makes a DOT code of a given code path.
     * The DOT code can be visualized with Graphvis.
     * @param {CodePath} codePath A code path to make DOT.
     * @param {Object} traceMap Optional. A map to check whether or not segments had been done.
     * @returns {string} A DOT code of the code path.
     */
    makeDotArrows(codePath2, traceMap) {
      const stack = [[codePath2.initialSegment, 0]];
      const done = traceMap || /* @__PURE__ */ Object.create(null);
      let lastId = codePath2.initialSegment.id;
      let text = `initial->${codePath2.initialSegment.id}`;
      while (stack.length > 0) {
        const item = stack.pop();
        const segment = item[0];
        const index = item[1];
        if (done[segment.id] && index === 0) {
          continue;
        }
        done[segment.id] = segment;
        const nextSegment = segment.allNextSegments[index];
        if (!nextSegment) {
          continue;
        }
        if (lastId === segment.id) {
          text += `->${nextSegment.id}`;
        } else {
          text += `;
${segment.id}->${nextSegment.id}`;
        }
        lastId = nextSegment.id;
        stack.unshift([segment, 1 + index]);
        stack.push([nextSegment, 0]);
      }
      codePath2.returnedSegments.forEach((finalSegment) => {
        if (lastId === finalSegment.id) {
          text += "->final";
        } else {
          text += `;
${finalSegment.id}->final`;
        }
        lastId = null;
      });
      codePath2.thrownSegments.forEach((finalSegment) => {
        if (lastId === finalSegment.id) {
          text += "->thrown";
        } else {
          text += `;
${finalSegment.id}->thrown`;
        }
        lastId = null;
      });
      return `${text};`;
    }
  };
  return debugHelpers;
}
var codePathSegment;
var hasRequiredCodePathSegment;
function requireCodePathSegment() {
  if (hasRequiredCodePathSegment) return codePathSegment;
  hasRequiredCodePathSegment = 1;
  const debug = requireDebugHelpers();
  function isReachable(segment) {
    return segment.reachable;
  }
  class CodePathSegment {
    /**
     * Creates a new instance.
     * @param {string} id An identifier.
     * @param {CodePathSegment[]} allPrevSegments An array of the previous segments.
     *   This array includes unreachable segments.
     * @param {boolean} reachable A flag which shows this is reachable.
     */
    constructor(id2, allPrevSegments, reachable) {
      this.id = id2;
      this.nextSegments = [];
      this.prevSegments = allPrevSegments.filter(isReachable);
      this.allNextSegments = [];
      this.allPrevSegments = allPrevSegments;
      this.reachable = reachable;
      Object.defineProperty(this, "internal", {
        value: {
          // determines if the segment has been attached to the code path
          used: false,
          // array of previous segments coming from the end of a loop
          loopedPrevSegments: []
        }
      });
      if (debug.enabled) {
        this.internal.nodes = [];
      }
    }
    /**
     * Checks a given previous segment is coming from the end of a loop.
     * @param {CodePathSegment} segment A previous segment to check.
     * @returns {boolean} `true` if the segment is coming from the end of a loop.
     */
    isLoopedPrevSegment(segment) {
      return this.internal.loopedPrevSegments.includes(segment);
    }
    /**
     * Creates the root segment.
     * @param {string} id An identifier.
     * @returns {CodePathSegment} The created segment.
     */
    static newRoot(id2) {
      return new CodePathSegment(id2, [], true);
    }
    /**
     * Creates a new segment and appends it after the given segments.
     * @param {string} id An identifier.
     * @param {CodePathSegment[]} allPrevSegments An array of the previous segments
     *      to append to.
     * @returns {CodePathSegment} The created segment.
     */
    static newNext(id2, allPrevSegments) {
      return new CodePathSegment(
        id2,
        CodePathSegment.flattenUnusedSegments(allPrevSegments),
        allPrevSegments.some(isReachable)
      );
    }
    /**
     * Creates an unreachable segment and appends it after the given segments.
     * @param {string} id An identifier.
     * @param {CodePathSegment[]} allPrevSegments An array of the previous segments.
     * @returns {CodePathSegment} The created segment.
     */
    static newUnreachable(id2, allPrevSegments) {
      const segment = new CodePathSegment(
        id2,
        CodePathSegment.flattenUnusedSegments(allPrevSegments),
        false
      );
      CodePathSegment.markUsed(segment);
      return segment;
    }
    /**
     * Creates a segment that follows given segments.
     * This factory method does not connect with `allPrevSegments`.
     * But this inherits `reachable` flag.
     * @param {string} id An identifier.
     * @param {CodePathSegment[]} allPrevSegments An array of the previous segments.
     * @returns {CodePathSegment} The created segment.
     */
    static newDisconnected(id2, allPrevSegments) {
      return new CodePathSegment(id2, [], allPrevSegments.some(isReachable));
    }
    /**
     * Marks a given segment as used.
     *
     * And this function registers the segment into the previous segments as a next.
     * @param {CodePathSegment} segment A segment to mark.
     * @returns {void}
     */
    static markUsed(segment) {
      if (segment.internal.used) {
        return;
      }
      segment.internal.used = true;
      let i2;
      if (segment.reachable) {
        for (i2 = 0; i2 < segment.allPrevSegments.length; ++i2) {
          const prevSegment = segment.allPrevSegments[i2];
          prevSegment.allNextSegments.push(segment);
          prevSegment.nextSegments.push(segment);
        }
      } else {
        for (i2 = 0; i2 < segment.allPrevSegments.length; ++i2) {
          segment.allPrevSegments[i2].allNextSegments.push(segment);
        }
      }
    }
    /**
     * Marks a previous segment as looped.
     * @param {CodePathSegment} segment A segment.
     * @param {CodePathSegment} prevSegment A previous segment to mark.
     * @returns {void}
     */
    static markPrevSegmentAsLooped(segment, prevSegment) {
      segment.internal.loopedPrevSegments.push(prevSegment);
    }
    /**
     * Creates a new array based on an array of segments. If any segment in the
     * array is unused, then it is replaced by all of its previous segments.
     * All used segments are returned as-is without replacement.
     * @param {CodePathSegment[]} segments The array of segments to flatten.
     * @returns {CodePathSegment[]} The flattened array.
     */
    static flattenUnusedSegments(segments) {
      const done = /* @__PURE__ */ new Set();
      for (let i2 = 0; i2 < segments.length; ++i2) {
        const segment = segments[i2];
        if (done.has(segment)) {
          continue;
        }
        if (!segment.internal.used) {
          for (let j = 0; j < segment.allPrevSegments.length; ++j) {
            const prevSegment = segment.allPrevSegments[j];
            if (!done.has(prevSegment)) {
              done.add(prevSegment);
            }
          }
        } else {
          done.add(segment);
        }
      }
      return [...done];
    }
  }
  codePathSegment = CodePathSegment;
  return codePathSegment;
}
var forkContext;
var hasRequiredForkContext;
function requireForkContext() {
  if (hasRequiredForkContext) return forkContext;
  hasRequiredForkContext = 1;
  const assert2 = requireAssert(), CodePathSegment = requireCodePathSegment();
  function isReachable(segment) {
    return segment.reachable;
  }
  function createSegments(context, startIndex, endIndex, create) {
    const list = context.segmentsList;
    const normalizedBegin = startIndex >= 0 ? startIndex : list.length + startIndex;
    const normalizedEnd = endIndex >= 0 ? endIndex : list.length + endIndex;
    const segments = [];
    for (let i2 = 0; i2 < context.count; ++i2) {
      const allPrevSegments = [];
      for (let j = normalizedBegin; j <= normalizedEnd; ++j) {
        allPrevSegments.push(list[j][i2]);
      }
      segments.push(create(context.idGenerator.next(), allPrevSegments));
    }
    return segments;
  }
  function mergeExtraSegments(context, segments) {
    let currentSegments = segments;
    while (currentSegments.length > context.count) {
      const merged = [];
      for (let i2 = 0, length = Math.floor(currentSegments.length / 2); i2 < length; ++i2) {
        merged.push(
          CodePathSegment.newNext(context.idGenerator.next(), [
            currentSegments[i2],
            currentSegments[i2 + length]
          ])
        );
      }
      currentSegments = merged;
    }
    return currentSegments;
  }
  class ForkContext {
    /**
     * Creates a new instance.
     * @param {IdGenerator} idGenerator An identifier generator for segments.
     * @param {ForkContext|null} upper The preceding fork context.
     * @param {number} count The number of parallel segments in each element
     *      of `segmentsList`.
     */
    constructor(idGenerator2, upper, count) {
      this.idGenerator = idGenerator2;
      this.upper = upper;
      this.count = count;
      this.segmentsList = [];
    }
    /**
     * The segments that begin this fork context.
     * @type {Array<CodePathSegment>}
     */
    get head() {
      const list = this.segmentsList;
      return list.length === 0 ? [] : list.at(-1);
    }
    /**
     * Indicates if the context contains no segments.
     * @type {boolean}
     */
    get empty() {
      return this.segmentsList.length === 0;
    }
    /**
     * Indicates if there are any segments that are reachable.
     * @type {boolean}
     */
    get reachable() {
      const segments = this.head;
      return segments.length > 0 && segments.some(isReachable);
    }
    /**
     * Creates new segments in this context and appends them to the end of the
     * already existing `CodePathSegment`s specified by `startIndex` and
     * `endIndex`.
     * @param {number} startIndex The index of the first segment in the context
     *      that should be specified as previous segments for the newly created segments.
     * @param {number} endIndex The index of the last segment in the context
     *      that should be specified as previous segments for the newly created segments.
     * @returns {Array<CodePathSegment>} An array of the newly created segments.
     */
    makeNext(startIndex, endIndex) {
      return createSegments(
        this,
        startIndex,
        endIndex,
        CodePathSegment.newNext
      );
    }
    /**
     * Creates new unreachable segments in this context and appends them to the end of the
     * already existing `CodePathSegment`s specified by `startIndex` and
     * `endIndex`.
     * @param {number} startIndex The index of the first segment in the context
     *      that should be specified as previous segments for the newly created segments.
     * @param {number} endIndex The index of the last segment in the context
     *      that should be specified as previous segments for the newly created segments.
     * @returns {Array<CodePathSegment>} An array of the newly created segments.
     */
    makeUnreachable(startIndex, endIndex) {
      return createSegments(
        this,
        startIndex,
        endIndex,
        CodePathSegment.newUnreachable
      );
    }
    /**
     * Creates new segments in this context and does not append them to the end
     *  of the already existing `CodePathSegment`s specified by `startIndex` and
     * `endIndex`. The `startIndex` and `endIndex` are only used to determine if
     * the new segments should be reachable. If any of the segments in this range
     * are reachable then the new segments are also reachable; otherwise, the new
     * segments are unreachable.
     * @param {number} startIndex The index of the first segment in the context
     *      that should be considered for reachability.
     * @param {number} endIndex The index of the last segment in the context
     *      that should be considered for reachability.
     * @returns {Array<CodePathSegment>} An array of the newly created segments.
     */
    makeDisconnected(startIndex, endIndex) {
      return createSegments(
        this,
        startIndex,
        endIndex,
        CodePathSegment.newDisconnected
      );
    }
    /**
     * Adds segments to the head of this context.
     * @param {Array<CodePathSegment>} segments The segments to add.
     * @returns {void}
     */
    add(segments) {
      assert2(
        segments.length >= this.count,
        `${segments.length} >= ${this.count}`
      );
      this.segmentsList.push(mergeExtraSegments(this, segments));
    }
    /**
     * Replaces the head segments with the given segments.
     * The current head segments are removed.
     * @param {Array<CodePathSegment>} replacementHeadSegments The new head segments.
     * @returns {void}
     */
    replaceHead(replacementHeadSegments) {
      assert2(
        replacementHeadSegments.length >= this.count,
        `${replacementHeadSegments.length} >= ${this.count}`
      );
      this.segmentsList.splice(
        -1,
        1,
        mergeExtraSegments(this, replacementHeadSegments)
      );
    }
    /**
     * Adds all segments of a given fork context into this context.
     * @param {ForkContext} otherForkContext The fork context to add from.
     * @returns {void}
     */
    addAll(otherForkContext) {
      assert2(otherForkContext.count === this.count);
      this.segmentsList.push(...otherForkContext.segmentsList);
    }
    /**
     * Clears all segments in this context.
     * @returns {void}
     */
    clear() {
      this.segmentsList = [];
    }
    /**
     * Creates a new root context, meaning that there are no parent
     * fork contexts.
     * @param {IdGenerator} idGenerator An identifier generator for segments.
     * @returns {ForkContext} New fork context.
     */
    static newRoot(idGenerator2) {
      const context = new ForkContext(idGenerator2, null, 1);
      context.add([CodePathSegment.newRoot(idGenerator2.next())]);
      return context;
    }
    /**
     * Creates an empty fork context preceded by a given context.
     * @param {ForkContext} parentContext The parent fork context.
     * @param {boolean} shouldForkLeavingPath Indicates that we are inside of
     *      a `finally` block and should therefore fork the path that leaves
     *      `finally`.
     * @returns {ForkContext} New fork context.
     */
    static newEmpty(parentContext, shouldForkLeavingPath) {
      return new ForkContext(
        parentContext.idGenerator,
        parentContext,
        (shouldForkLeavingPath ? 2 : 1) * parentContext.count
      );
    }
  }
  forkContext = ForkContext;
  return forkContext;
}
var codePathState;
var hasRequiredCodePathState;
function requireCodePathState() {
  if (hasRequiredCodePathState) return codePathState;
  hasRequiredCodePathState = 1;
  const CodePathSegment = requireCodePathSegment(), ForkContext = requireForkContext();
  class BreakContext {
    /**
     * Creates a new instance.
     * @param {BreakContext} upperContext The previous `BreakContext`.
     * @param {boolean} breakable Indicates if we are inside a statement where
     *      `break` without a label will exit the statement.
     * @param {string|null} label The label for the statement.
     * @param {ForkContext} forkContext The current fork context.
     */
    constructor(upperContext, breakable, label, forkContext2) {
      this.upper = upperContext;
      this.breakable = breakable;
      this.label = label;
      this.brokenForkContext = ForkContext.newEmpty(forkContext2);
    }
  }
  class ChainContext {
    /**
     * Creates a new instance.
     * @param {ChainContext} upperContext The previous `ChainContext`.
     */
    constructor(upperContext) {
      this.upper = upperContext;
      this.choiceContextCount = 0;
    }
  }
  class ChoiceContext {
    /**
     * Creates a new instance.
     * @param {ChoiceContext} upperContext The previous `ChoiceContext`.
     * @param {string} kind The kind of choice. If it's a logical or assignment expression, this
     *      is `"&&"` or `"||"` or `"??"`; if it's an `if` statement or
     *      conditional expression, this is `"test"`; otherwise, this is `"loop"`.
     * @param {boolean} isForkingAsResult Indicates if the result of the choice
     *      creates a fork.
     * @param {ForkContext} forkContext The containing `ForkContext`.
     */
    constructor(upperContext, kind, isForkingAsResult, forkContext2) {
      this.upper = upperContext;
      this.kind = kind;
      this.isForkingAsResult = isForkingAsResult;
      this.trueForkContext = ForkContext.newEmpty(forkContext2);
      this.falseForkContext = ForkContext.newEmpty(forkContext2);
      this.nullishForkContext = ForkContext.newEmpty(forkContext2);
      this.processed = false;
    }
  }
  class LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string} type The AST node's `type` for the loop.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     */
    constructor(upperContext, type2, label, breakContext) {
      this.upper = upperContext;
      this.type = type2;
      this.label = label;
      this.brokenForkContext = breakContext.brokenForkContext;
    }
  }
  class WhileLoopContext extends LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     */
    constructor(upperContext, label, breakContext) {
      super(upperContext, "WhileStatement", label, breakContext);
      this.test = void 0;
      this.continueDestSegments = null;
    }
  }
  class DoWhileLoopContext extends LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     * @param {ForkContext} forkContext The enclosing fork context.
     */
    constructor(upperContext, label, breakContext, forkContext2) {
      super(upperContext, "DoWhileStatement", label, breakContext);
      this.test = void 0;
      this.entrySegments = null;
      this.continueForkContext = ForkContext.newEmpty(forkContext2);
    }
  }
  class ForLoopContext extends LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     */
    constructor(upperContext, label, breakContext) {
      super(upperContext, "ForStatement", label, breakContext);
      this.test = void 0;
      this.endOfInitSegments = null;
      this.testSegments = null;
      this.endOfTestSegments = null;
      this.updateSegments = null;
      this.endOfUpdateSegments = null;
      this.continueDestSegments = null;
    }
  }
  class ForInLoopContext extends LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     */
    constructor(upperContext, label, breakContext) {
      super(upperContext, "ForInStatement", label, breakContext);
      this.prevSegments = null;
      this.leftSegments = null;
      this.endOfLeftSegments = null;
      this.continueDestSegments = null;
    }
  }
  class ForOfLoopContext extends LoopContextBase {
    /**
     * Creates a new instance.
     * @param {LoopContext|null} upperContext The previous `LoopContext`.
     * @param {string|null} label The label for the loop from an enclosing `LabeledStatement`.
     * @param {BreakContext} breakContext The context for breaking the loop.
     */
    constructor(upperContext, label, breakContext) {
      super(upperContext, "ForOfStatement", label, breakContext);
      this.prevSegments = null;
      this.leftSegments = null;
      this.endOfLeftSegments = null;
      this.continueDestSegments = null;
    }
  }
  class SwitchContext {
    /**
     * Creates a new instance.
     * @param {SwitchContext} upperContext The previous context.
     * @param {boolean} hasCase Indicates if there is at least one `case` statement.
     *      `default` doesn't count.
     */
    constructor(upperContext, hasCase) {
      this.upper = upperContext;
      this.hasCase = hasCase;
      this.defaultSegments = null;
      this.defaultBodySegments = null;
      this.foundEmptyDefault = false;
      this.lastIsDefault = false;
      this.forkCount = 0;
    }
  }
  class TryContext {
    /**
     * Creates a new instance.
     * @param {TryContext} upperContext The previous context.
     * @param {boolean} hasFinalizer Indicates if the `try` statement has a
     *      `finally` block.
     * @param {ForkContext} forkContext The enclosing fork context.
     */
    constructor(upperContext, hasFinalizer, forkContext2) {
      this.upper = upperContext;
      this.hasFinalizer = hasFinalizer;
      this.position = "try";
      this.returnedForkContext = hasFinalizer ? ForkContext.newEmpty(forkContext2) : null;
      this.thrownForkContext = ForkContext.newEmpty(forkContext2);
      this.lastOfTryIsReachable = false;
      this.lastOfCatchIsReachable = false;
    }
  }
  function addToReturnedOrThrown(dest, others, all, segments) {
    for (let i2 = 0; i2 < segments.length; ++i2) {
      const segment = segments[i2];
      dest.push(segment);
      if (!others.includes(segment)) {
        all.push(segment);
      }
    }
  }
  function getContinueContext(state, label) {
    if (!label) {
      return state.loopContext;
    }
    let context = state.loopContext;
    while (context) {
      if (context.label === label) {
        return context;
      }
      context = context.upper;
    }
    return null;
  }
  function getBreakContext(state, label) {
    let context = state.breakContext;
    while (context) {
      if (label ? context.label === label : context.breakable) {
        return context;
      }
      context = context.upper;
    }
    return null;
  }
  function getReturnContext(state) {
    let context = state.tryContext;
    while (context) {
      if (context.hasFinalizer && context.position !== "finally") {
        return context;
      }
      context = context.upper;
    }
    return state;
  }
  function getThrowContext(state) {
    let context = state.tryContext;
    while (context) {
      if (context.position === "try" || context.hasFinalizer && context.position === "catch") {
        return context;
      }
      context = context.upper;
    }
    return state;
  }
  function removeFromArray(elements, value) {
    elements.splice(elements.indexOf(value), 1);
  }
  function disconnectSegments(prevSegments, nextSegments) {
    for (let i2 = 0; i2 < prevSegments.length; ++i2) {
      const prevSegment = prevSegments[i2];
      const nextSegment = nextSegments[i2];
      removeFromArray(prevSegment.nextSegments, nextSegment);
      removeFromArray(prevSegment.allNextSegments, nextSegment);
      removeFromArray(nextSegment.prevSegments, prevSegment);
      removeFromArray(nextSegment.allPrevSegments, prevSegment);
    }
  }
  function makeLooped(state, unflattenedFromSegments, unflattenedToSegments) {
    const fromSegments = CodePathSegment.flattenUnusedSegments(
      unflattenedFromSegments
    );
    const toSegments = CodePathSegment.flattenUnusedSegments(
      unflattenedToSegments
    );
    const end = Math.min(fromSegments.length, toSegments.length);
    for (let i2 = 0; i2 < end; ++i2) {
      const fromSegment = fromSegments[i2];
      const toSegment = toSegments[i2];
      if (toSegment.reachable) {
        fromSegment.nextSegments.push(toSegment);
      }
      if (fromSegment.reachable) {
        toSegment.prevSegments.push(fromSegment);
      }
      fromSegment.allNextSegments.push(toSegment);
      toSegment.allPrevSegments.push(fromSegment);
      if (toSegment.allPrevSegments.length >= 2) {
        CodePathSegment.markPrevSegmentAsLooped(toSegment, fromSegment);
      }
      state.notifyLooped(fromSegment, toSegment);
    }
  }
  function finalizeTestSegmentsOfFor(context, choiceContext, head) {
    if (!choiceContext.processed) {
      choiceContext.trueForkContext.add(head);
      choiceContext.falseForkContext.add(head);
      choiceContext.nullishForkContext.add(head);
    }
    if (context.test !== true) {
      context.brokenForkContext.addAll(choiceContext.falseForkContext);
    }
    context.endOfTestSegments = choiceContext.trueForkContext.makeNext(0, -1);
  }
  class CodePathState {
    /**
     * Creates a new instance.
     * @param {IdGenerator} idGenerator An id generator to generate id for code
     *   path segments.
     * @param {Function} onLooped A callback function to notify looping.
     */
    constructor(idGenerator2, onLooped) {
      this.idGenerator = idGenerator2;
      this.notifyLooped = onLooped;
      this.forkContext = ForkContext.newRoot(idGenerator2);
      this.choiceContext = null;
      this.switchContext = null;
      this.tryContext = null;
      this.loopContext = null;
      this.breakContext = null;
      this.chainContext = null;
      this.currentSegments = [];
      this.initialSegment = this.forkContext.head[0];
      this.finalSegments = [];
      this.returnedForkContext = [];
      this.thrownForkContext = [];
      const final = this.finalSegments;
      const returned = this.returnedForkContext;
      const thrown = this.thrownForkContext;
      returned.add = addToReturnedOrThrown.bind(
        null,
        returned,
        thrown,
        final
      );
      thrown.add = addToReturnedOrThrown.bind(null, thrown, returned, final);
    }
    /**
     * A passthrough property exposing the current pointer as part of the API.
     * @type {CodePathSegment[]}
     */
    get headSegments() {
      return this.forkContext.head;
    }
    /**
     * The parent forking context.
     * This is used for the root of new forks.
     * @type {ForkContext}
     */
    get parentForkContext() {
      const current = this.forkContext;
      return current && current.upper;
    }
    /**
     * Creates and stacks new forking context.
     * @param {boolean} forkLeavingPath A flag which shows being in a
     *   "finally" block.
     * @returns {ForkContext} The created context.
     */
    pushForkContext(forkLeavingPath) {
      this.forkContext = ForkContext.newEmpty(
        this.forkContext,
        forkLeavingPath
      );
      return this.forkContext;
    }
    /**
     * Pops and merges the last forking context.
     * @returns {ForkContext} The last context.
     */
    popForkContext() {
      const lastContext = this.forkContext;
      this.forkContext = lastContext.upper;
      this.forkContext.replaceHead(lastContext.makeNext(0, -1));
      return lastContext;
    }
    /**
     * Creates a new path.
     * @returns {void}
     */
    forkPath() {
      this.forkContext.add(this.parentForkContext.makeNext(-1, -1));
    }
    /**
     * Creates a bypass path.
     * This is used for such as IfStatement which does not have "else" chunk.
     * @returns {void}
     */
    forkBypassPath() {
      this.forkContext.add(this.parentForkContext.head);
    }
    //--------------------------------------------------------------------------
    // ConditionalExpression, LogicalExpression, IfStatement
    //--------------------------------------------------------------------------
    /**
     * Creates a context for ConditionalExpression, LogicalExpression, AssignmentExpression (logical assignments only),
     * IfStatement, WhileStatement, DoWhileStatement, or ForStatement.
     *
     * LogicalExpressions have cases that it goes different paths between the
     * `true` case and the `false` case.
     *
     * For Example:
     *
     *     if (a || b) {
     *         foo();
     *     } else {
     *         bar();
     *     }
     *
     * In this case, `b` is evaluated always in the code path of the `else`
     * block, but it's not so in the code path of the `if` block.
     * So there are 3 paths.
     *
     *     a -> foo();
     *     a -> b -> foo();
     *     a -> b -> bar();
     * @param {string} kind A kind string.
     *   If the new context is LogicalExpression's or AssignmentExpression's, this is `"&&"` or `"||"` or `"??"`.
     *   If it's IfStatement's or ConditionalExpression's, this is `"test"`.
     *   Otherwise, this is `"loop"`.
     * @param {boolean} isForkingAsResult Indicates if the result of the choice
     *      creates a fork.
     * @returns {void}
     */
    pushChoiceContext(kind, isForkingAsResult) {
      this.choiceContext = new ChoiceContext(
        this.choiceContext,
        kind,
        isForkingAsResult,
        this.forkContext
      );
    }
    /**
     * Pops the last choice context and finalizes it.
     * This is called upon leaving a node that represents a choice.
     * @throws {Error} (Unreachable.)
     * @returns {ChoiceContext} The popped context.
     */
    popChoiceContext() {
      const poppedChoiceContext = this.choiceContext;
      const forkContext2 = this.forkContext;
      const head = forkContext2.head;
      this.choiceContext = poppedChoiceContext.upper;
      switch (poppedChoiceContext.kind) {
        case "&&":
        case "||":
        case "??":
          if (!poppedChoiceContext.processed) {
            poppedChoiceContext.trueForkContext.add(head);
            poppedChoiceContext.falseForkContext.add(head);
            poppedChoiceContext.nullishForkContext.add(head);
          }
          if (poppedChoiceContext.isForkingAsResult) {
            const parentContext = this.choiceContext;
            parentContext.trueForkContext.addAll(
              poppedChoiceContext.trueForkContext
            );
            parentContext.falseForkContext.addAll(
              poppedChoiceContext.falseForkContext
            );
            parentContext.nullishForkContext.addAll(
              poppedChoiceContext.nullishForkContext
            );
            parentContext.processed = true;
            return poppedChoiceContext;
          }
          break;
        case "test":
          if (!poppedChoiceContext.processed) {
            poppedChoiceContext.trueForkContext.clear();
            poppedChoiceContext.trueForkContext.add(head);
          } else {
            poppedChoiceContext.falseForkContext.clear();
            poppedChoiceContext.falseForkContext.add(head);
          }
          break;
        case "loop":
          return poppedChoiceContext;
        /* c8 ignore next */
        default:
          throw new Error("unreachable");
      }
      const combinedForkContext = poppedChoiceContext.trueForkContext;
      combinedForkContext.addAll(poppedChoiceContext.falseForkContext);
      forkContext2.replaceHead(combinedForkContext.makeNext(0, -1));
      return poppedChoiceContext;
    }
    /**
     * Creates a code path segment to represent right-hand operand of a logical
     * expression.
     * This is called in the preprocessing phase when entering a node.
     * @throws {Error} (Unreachable.)
     * @returns {void}
     */
    makeLogicalRight() {
      const currentChoiceContext = this.choiceContext;
      const forkContext2 = this.forkContext;
      if (currentChoiceContext.processed) {
        let prevForkContext;
        switch (currentChoiceContext.kind) {
          case "&&":
            prevForkContext = currentChoiceContext.trueForkContext;
            break;
          case "||":
            prevForkContext = currentChoiceContext.falseForkContext;
            break;
          case "??":
            prevForkContext = currentChoiceContext.nullishForkContext;
            break;
          default:
            throw new Error("unreachable");
        }
        forkContext2.replaceHead(prevForkContext.makeNext(0, -1));
        prevForkContext.clear();
        currentChoiceContext.processed = false;
      } else {
        switch (currentChoiceContext.kind) {
          case "&&":
            currentChoiceContext.falseForkContext.add(forkContext2.head);
            currentChoiceContext.nullishForkContext.add(
              forkContext2.head
            );
            break;
          case "||":
            currentChoiceContext.trueForkContext.add(forkContext2.head);
            break;
          case "??":
            currentChoiceContext.trueForkContext.add(forkContext2.head);
            currentChoiceContext.falseForkContext.add(forkContext2.head);
            break;
          default:
            throw new Error("unreachable");
        }
        forkContext2.replaceHead(forkContext2.makeNext(-1, -1));
      }
    }
    /**
     * Makes a code path segment of the `if` block.
     * @returns {void}
     */
    makeIfConsequent() {
      const context = this.choiceContext;
      const forkContext2 = this.forkContext;
      if (!context.processed) {
        context.trueForkContext.add(forkContext2.head);
        context.falseForkContext.add(forkContext2.head);
        context.nullishForkContext.add(forkContext2.head);
      }
      context.processed = false;
      forkContext2.replaceHead(context.trueForkContext.makeNext(0, -1));
    }
    /**
     * Makes a code path segment of the `else` block.
     * @returns {void}
     */
    makeIfAlternate() {
      const context = this.choiceContext;
      const forkContext2 = this.forkContext;
      context.trueForkContext.clear();
      context.trueForkContext.add(forkContext2.head);
      context.processed = true;
      forkContext2.replaceHead(context.falseForkContext.makeNext(0, -1));
    }
    //--------------------------------------------------------------------------
    // ChainExpression
    //--------------------------------------------------------------------------
    /**
     * Pushes a new `ChainExpression` context to the stack. This method is
     * called when entering a `ChainExpression` node. A chain context is used to
     * count forking in the optional chain then merge them on the exiting from the
     * `ChainExpression` node.
     * @returns {void}
     */
    pushChainContext() {
      this.chainContext = new ChainContext(this.chainContext);
    }
    /**
     * Pop a `ChainExpression` context from the stack. This method is called on
     * exiting from each `ChainExpression` node. This merges all forks of the
     * last optional chaining.
     * @returns {void}
     */
    popChainContext() {
      const context = this.chainContext;
      this.chainContext = context.upper;
      for (let i2 = context.choiceContextCount; i2 > 0; --i2) {
        this.popChoiceContext();
      }
    }
    /**
     * Create a choice context for optional access.
     * This method is called on entering to each `(Call|Member)Expression[optional=true]` node.
     * This creates a choice context as similar to `LogicalExpression[operator="??"]` node.
     * @returns {void}
     */
    makeOptionalNode() {
      if (this.chainContext) {
        this.chainContext.choiceContextCount += 1;
        this.pushChoiceContext("??", false);
      }
    }
    /**
     * Create a fork.
     * This method is called on entering to the `arguments|property` property of each `(Call|Member)Expression` node.
     * @returns {void}
     */
    makeOptionalRight() {
      if (this.chainContext) {
        this.makeLogicalRight();
      }
    }
    //--------------------------------------------------------------------------
    // SwitchStatement
    //--------------------------------------------------------------------------
    /**
     * Creates a context object of SwitchStatement and stacks it.
     * @param {boolean} hasCase `true` if the switch statement has one or more
     *   case parts.
     * @param {string|null} label The label text.
     * @returns {void}
     */
    pushSwitchContext(hasCase, label) {
      this.switchContext = new SwitchContext(this.switchContext, hasCase);
      this.pushBreakContext(true, label);
    }
    /**
     * Pops the last context of SwitchStatement and finalizes it.
     *
     * - Disposes all forking stack for `case` and `default`.
     * - Creates the next code path segment from `context.brokenForkContext`.
     * - If the last `SwitchCase` node is not a `default` part, creates a path
     *   to the `default` body.
     * @returns {void}
     */
    popSwitchContext() {
      const context = this.switchContext;
      this.switchContext = context.upper;
      const forkContext2 = this.forkContext;
      const brokenForkContext = this.popBreakContext().brokenForkContext;
      if (context.forkCount === 0) {
        if (!brokenForkContext.empty) {
          brokenForkContext.add(forkContext2.makeNext(-1, -1));
          forkContext2.replaceHead(brokenForkContext.makeNext(0, -1));
        }
        return;
      }
      const lastSegments = forkContext2.head;
      this.forkBypassPath();
      const lastCaseSegments = forkContext2.head;
      brokenForkContext.add(lastSegments);
      if (!context.lastIsDefault) {
        if (context.defaultBodySegments) {
          disconnectSegments(
            context.defaultSegments,
            context.defaultBodySegments
          );
          makeLooped(this, lastCaseSegments, context.defaultBodySegments);
        } else {
          brokenForkContext.add(lastCaseSegments);
        }
      }
      for (let i2 = 0; i2 < context.forkCount; ++i2) {
        this.forkContext = this.forkContext.upper;
      }
      this.forkContext.replaceHead(brokenForkContext.makeNext(0, -1));
    }
    /**
     * Makes a code path segment for a `SwitchCase` node.
     * @param {boolean} isCaseBodyEmpty `true` if the body is empty.
     * @param {boolean} isDefaultCase `true` if the body is the default case.
     * @returns {void}
     */
    makeSwitchCaseBody(isCaseBodyEmpty, isDefaultCase) {
      const context = this.switchContext;
      if (!context.hasCase) {
        return;
      }
      const parentForkContext = this.forkContext;
      const forkContext2 = this.pushForkContext();
      forkContext2.add(parentForkContext.makeNext(0, -1));
      if (isDefaultCase) {
        context.defaultSegments = parentForkContext.head;
        if (isCaseBodyEmpty) {
          context.foundEmptyDefault = true;
        } else {
          context.defaultBodySegments = forkContext2.head;
        }
      } else {
        if (!isCaseBodyEmpty && context.foundEmptyDefault) {
          context.foundEmptyDefault = false;
          context.defaultBodySegments = forkContext2.head;
        }
      }
      context.lastIsDefault = isDefaultCase;
      context.forkCount += 1;
    }
    //--------------------------------------------------------------------------
    // TryStatement
    //--------------------------------------------------------------------------
    /**
     * Creates a context object of TryStatement and stacks it.
     * @param {boolean} hasFinalizer `true` if the try statement has a
     *   `finally` block.
     * @returns {void}
     */
    pushTryContext(hasFinalizer) {
      this.tryContext = new TryContext(
        this.tryContext,
        hasFinalizer,
        this.forkContext
      );
    }
    /**
     * Pops the last context of TryStatement and finalizes it.
     * @returns {void}
     */
    popTryContext() {
      const context = this.tryContext;
      this.tryContext = context.upper;
      if (context.position === "catch") {
        this.popForkContext();
        return;
      }
      const originalReturnedForkContext = context.returnedForkContext;
      const originalThrownForkContext = context.thrownForkContext;
      if (originalReturnedForkContext.empty && originalThrownForkContext.empty) {
        return;
      }
      const headSegments = this.forkContext.head;
      this.forkContext = this.forkContext.upper;
      const normalSegments = headSegments.slice(
        0,
        headSegments.length / 2 | 0
      );
      const leavingSegments = headSegments.slice(
        headSegments.length / 2 | 0
      );
      if (!originalReturnedForkContext.empty) {
        getReturnContext(this).returnedForkContext.add(leavingSegments);
      }
      if (!originalThrownForkContext.empty) {
        getThrowContext(this).thrownForkContext.add(leavingSegments);
      }
      this.forkContext.replaceHead(normalSegments);
      if (!context.lastOfTryIsReachable && !context.lastOfCatchIsReachable) {
        this.forkContext.makeUnreachable();
      }
    }
    /**
     * Makes a code path segment for a `catch` block.
     * @returns {void}
     */
    makeCatchBlock() {
      const context = this.tryContext;
      const forkContext2 = this.forkContext;
      const originalThrownForkContext = context.thrownForkContext;
      context.position = "catch";
      context.thrownForkContext = ForkContext.newEmpty(forkContext2);
      context.lastOfTryIsReachable = forkContext2.reachable;
      originalThrownForkContext.add(forkContext2.head);
      const thrownSegments = originalThrownForkContext.makeNext(0, -1);
      this.pushForkContext();
      this.forkBypassPath();
      this.forkContext.add(thrownSegments);
    }
    /**
     * Makes a code path segment for a `finally` block.
     *
     * In the `finally` block, parallel paths are created. The parallel paths
     * are used as leaving-paths. The leaving-paths are paths from `return`
     * statements and `throw` statements in a `try` block or a `catch` block.
     * @returns {void}
     */
    makeFinallyBlock() {
      const context = this.tryContext;
      let forkContext2 = this.forkContext;
      const originalReturnedForkContext = context.returnedForkContext;
      const originalThrownForContext = context.thrownForkContext;
      const headOfLeavingSegments = forkContext2.head;
      if (context.position === "catch") {
        this.popForkContext();
        forkContext2 = this.forkContext;
        context.lastOfCatchIsReachable = forkContext2.reachable;
      } else {
        context.lastOfTryIsReachable = forkContext2.reachable;
      }
      context.position = "finally";
      if (originalReturnedForkContext.empty && originalThrownForContext.empty) {
        return;
      }
      const segments = forkContext2.makeNext(-1, -1);
      for (let i2 = 0; i2 < forkContext2.count; ++i2) {
        const prevSegsOfLeavingSegment = [headOfLeavingSegments[i2]];
        for (let j = 0; j < originalReturnedForkContext.segmentsList.length; ++j) {
          prevSegsOfLeavingSegment.push(
            originalReturnedForkContext.segmentsList[j][i2]
          );
        }
        for (let j = 0; j < originalThrownForContext.segmentsList.length; ++j) {
          prevSegsOfLeavingSegment.push(
            originalThrownForContext.segmentsList[j][i2]
          );
        }
        segments.push(
          CodePathSegment.newNext(
            this.idGenerator.next(),
            prevSegsOfLeavingSegment
          )
        );
      }
      this.pushForkContext(true);
      this.forkContext.add(segments);
    }
    /**
     * Makes a code path segment from the first throwable node to the `catch`
     * block or the `finally` block.
     * @returns {void}
     */
    makeFirstThrowablePathInTryBlock() {
      const forkContext2 = this.forkContext;
      if (!forkContext2.reachable) {
        return;
      }
      const context = getThrowContext(this);
      if (context === this || context.position !== "try" || !context.thrownForkContext.empty) {
        return;
      }
      context.thrownForkContext.add(forkContext2.head);
      forkContext2.replaceHead(forkContext2.makeNext(-1, -1));
    }
    //--------------------------------------------------------------------------
    // Loop Statements
    //--------------------------------------------------------------------------
    /**
     * Creates a context object of a loop statement and stacks it.
     * @param {string} type The type of the node which was triggered. One of
     *   `WhileStatement`, `DoWhileStatement`, `ForStatement`, `ForInStatement`,
     *   and `ForStatement`.
     * @param {string|null} label A label of the node which was triggered.
     * @throws {Error} (Unreachable - unknown type.)
     * @returns {void}
     */
    pushLoopContext(type2, label) {
      const forkContext2 = this.forkContext;
      const breakContext = this.pushBreakContext(true, label);
      switch (type2) {
        case "WhileStatement":
          this.pushChoiceContext("loop", false);
          this.loopContext = new WhileLoopContext(
            this.loopContext,
            label,
            breakContext
          );
          break;
        case "DoWhileStatement":
          this.pushChoiceContext("loop", false);
          this.loopContext = new DoWhileLoopContext(
            this.loopContext,
            label,
            breakContext,
            forkContext2
          );
          break;
        case "ForStatement":
          this.pushChoiceContext("loop", false);
          this.loopContext = new ForLoopContext(
            this.loopContext,
            label,
            breakContext
          );
          break;
        case "ForInStatement":
          this.loopContext = new ForInLoopContext(
            this.loopContext,
            label,
            breakContext
          );
          break;
        case "ForOfStatement":
          this.loopContext = new ForOfLoopContext(
            this.loopContext,
            label,
            breakContext
          );
          break;
        /* c8 ignore next */
        default:
          throw new Error(`unknown type: "${type2}"`);
      }
    }
    /**
     * Pops the last context of a loop statement and finalizes it.
     * @throws {Error} (Unreachable - unknown type.)
     * @returns {void}
     */
    popLoopContext() {
      const context = this.loopContext;
      this.loopContext = context.upper;
      const forkContext2 = this.forkContext;
      const brokenForkContext = this.popBreakContext().brokenForkContext;
      switch (context.type) {
        case "WhileStatement":
        case "ForStatement":
          this.popChoiceContext();
          makeLooped(
            this,
            forkContext2.head,
            context.continueDestSegments
          );
          break;
        case "DoWhileStatement": {
          const choiceContext = this.popChoiceContext();
          if (!choiceContext.processed) {
            choiceContext.trueForkContext.add(forkContext2.head);
            choiceContext.falseForkContext.add(forkContext2.head);
          }
          if (context.test !== true) {
            brokenForkContext.addAll(choiceContext.falseForkContext);
          }
          const segmentsList = choiceContext.trueForkContext.segmentsList;
          for (let i2 = 0; i2 < segmentsList.length; ++i2) {
            makeLooped(this, segmentsList[i2], context.entrySegments);
          }
          break;
        }
        case "ForInStatement":
        case "ForOfStatement":
          brokenForkContext.add(forkContext2.head);
          makeLooped(this, forkContext2.head, context.leftSegments);
          break;
        /* c8 ignore next */
        default:
          throw new Error("unreachable");
      }
      if (brokenForkContext.empty) {
        forkContext2.replaceHead(forkContext2.makeUnreachable(-1, -1));
      } else {
        forkContext2.replaceHead(brokenForkContext.makeNext(0, -1));
      }
    }
    /**
     * Makes a code path segment for the test part of a WhileStatement.
     * @param {boolean|undefined} test The test value (only when constant).
     * @returns {void}
     */
    makeWhileTest(test) {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const testSegments = forkContext2.makeNext(0, -1);
      context.test = test;
      context.continueDestSegments = testSegments;
      forkContext2.replaceHead(testSegments);
    }
    /**
     * Makes a code path segment for the body part of a WhileStatement.
     * @returns {void}
     */
    makeWhileBody() {
      const context = this.loopContext;
      const choiceContext = this.choiceContext;
      const forkContext2 = this.forkContext;
      if (!choiceContext.processed) {
        choiceContext.trueForkContext.add(forkContext2.head);
        choiceContext.falseForkContext.add(forkContext2.head);
      }
      if (context.test !== true) {
        context.brokenForkContext.addAll(choiceContext.falseForkContext);
      }
      forkContext2.replaceHead(choiceContext.trueForkContext.makeNext(0, -1));
    }
    /**
     * Makes a code path segment for the body part of a DoWhileStatement.
     * @returns {void}
     */
    makeDoWhileBody() {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const bodySegments = forkContext2.makeNext(-1, -1);
      context.entrySegments = bodySegments;
      forkContext2.replaceHead(bodySegments);
    }
    /**
     * Makes a code path segment for the test part of a DoWhileStatement.
     * @param {boolean|undefined} test The test value (only when constant).
     * @returns {void}
     */
    makeDoWhileTest(test) {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      context.test = test;
      if (!context.continueForkContext.empty) {
        context.continueForkContext.add(forkContext2.head);
        const testSegments = context.continueForkContext.makeNext(0, -1);
        forkContext2.replaceHead(testSegments);
      }
    }
    /**
     * Makes a code path segment for the test part of a ForStatement.
     * @param {boolean|undefined} test The test value (only when constant).
     * @returns {void}
     */
    makeForTest(test) {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const endOfInitSegments = forkContext2.head;
      const testSegments = forkContext2.makeNext(-1, -1);
      context.test = test;
      context.endOfInitSegments = endOfInitSegments;
      context.continueDestSegments = context.testSegments = testSegments;
      forkContext2.replaceHead(testSegments);
    }
    /**
     * Makes a code path segment for the update part of a ForStatement.
     * @returns {void}
     */
    makeForUpdate() {
      const context = this.loopContext;
      const choiceContext = this.choiceContext;
      const forkContext2 = this.forkContext;
      if (context.testSegments) {
        finalizeTestSegmentsOfFor(context, choiceContext, forkContext2.head);
      } else {
        context.endOfInitSegments = forkContext2.head;
      }
      const updateSegments = forkContext2.makeDisconnected(-1, -1);
      context.continueDestSegments = context.updateSegments = updateSegments;
      forkContext2.replaceHead(updateSegments);
    }
    /**
     * Makes a code path segment for the body part of a ForStatement.
     * @returns {void}
     */
    makeForBody() {
      const context = this.loopContext;
      const choiceContext = this.choiceContext;
      const forkContext2 = this.forkContext;
      if (context.updateSegments) {
        context.endOfUpdateSegments = forkContext2.head;
        if (context.testSegments) {
          makeLooped(
            this,
            context.endOfUpdateSegments,
            context.testSegments
          );
        }
      } else if (context.testSegments) {
        finalizeTestSegmentsOfFor(context, choiceContext, forkContext2.head);
      } else {
        context.endOfInitSegments = forkContext2.head;
      }
      let bodySegments = context.endOfTestSegments;
      if (!bodySegments) {
        const prevForkContext = ForkContext.newEmpty(forkContext2);
        prevForkContext.add(context.endOfInitSegments);
        if (context.endOfUpdateSegments) {
          prevForkContext.add(context.endOfUpdateSegments);
        }
        bodySegments = prevForkContext.makeNext(0, -1);
      }
      context.continueDestSegments = context.continueDestSegments || bodySegments;
      forkContext2.replaceHead(bodySegments);
    }
    /**
     * Makes a code path segment for the left part of a ForInStatement and a
     * ForOfStatement.
     * @returns {void}
     */
    makeForInOfLeft() {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const leftSegments = forkContext2.makeDisconnected(-1, -1);
      context.prevSegments = forkContext2.head;
      context.leftSegments = context.continueDestSegments = leftSegments;
      forkContext2.replaceHead(leftSegments);
    }
    /**
     * Makes a code path segment for the right part of a ForInStatement and a
     * ForOfStatement.
     * @returns {void}
     */
    makeForInOfRight() {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const temp = ForkContext.newEmpty(forkContext2);
      temp.add(context.prevSegments);
      const rightSegments = temp.makeNext(-1, -1);
      context.endOfLeftSegments = forkContext2.head;
      forkContext2.replaceHead(rightSegments);
    }
    /**
     * Makes a code path segment for the body part of a ForInStatement and a
     * ForOfStatement.
     * @returns {void}
     */
    makeForInOfBody() {
      const context = this.loopContext;
      const forkContext2 = this.forkContext;
      const temp = ForkContext.newEmpty(forkContext2);
      temp.add(context.endOfLeftSegments);
      const bodySegments = temp.makeNext(-1, -1);
      makeLooped(this, forkContext2.head, context.leftSegments);
      context.brokenForkContext.add(forkContext2.head);
      forkContext2.replaceHead(bodySegments);
    }
    //--------------------------------------------------------------------------
    // Control Statements
    //--------------------------------------------------------------------------
    /**
     * Creates new context in which a `break` statement can be used. This occurs inside of a loop,
     * labeled statement, or switch statement.
     * @param {boolean} breakable Indicates if we are inside a statement where
     *      `break` without a label will exit the statement.
     * @param {string|null} label The label associated with the statement.
     * @returns {BreakContext} The new context.
     */
    pushBreakContext(breakable, label) {
      this.breakContext = new BreakContext(
        this.breakContext,
        breakable,
        label,
        this.forkContext
      );
      return this.breakContext;
    }
    /**
     * Removes the top item of the break context stack.
     * @returns {Object} The removed context.
     */
    popBreakContext() {
      const context = this.breakContext;
      const forkContext2 = this.forkContext;
      this.breakContext = context.upper;
      if (!context.breakable) {
        const brokenForkContext = context.brokenForkContext;
        if (!brokenForkContext.empty) {
          brokenForkContext.add(forkContext2.head);
          forkContext2.replaceHead(brokenForkContext.makeNext(0, -1));
        }
      }
      return context;
    }
    /**
     * Makes a path for a `break` statement.
     *
     * It registers the head segment to a context of `break`.
     * It makes new unreachable segment, then it set the head with the segment.
     * @param {string|null} label A label of the break statement.
     * @returns {void}
     */
    makeBreak(label) {
      const forkContext2 = this.forkContext;
      if (!forkContext2.reachable) {
        return;
      }
      const context = getBreakContext(this, label);
      if (context) {
        context.brokenForkContext.add(forkContext2.head);
      }
      forkContext2.replaceHead(forkContext2.makeUnreachable(-1, -1));
    }
    /**
     * Makes a path for a `continue` statement.
     *
     * It makes a looping path.
     * It makes new unreachable segment, then it set the head with the segment.
     * @param {string|null} label A label of the continue statement.
     * @returns {void}
     */
    makeContinue(label) {
      const forkContext2 = this.forkContext;
      if (!forkContext2.reachable) {
        return;
      }
      const context = getContinueContext(this, label);
      if (context) {
        if (context.continueDestSegments) {
          makeLooped(
            this,
            forkContext2.head,
            context.continueDestSegments
          );
          if (context.type === "ForInStatement" || context.type === "ForOfStatement") {
            context.brokenForkContext.add(forkContext2.head);
          }
        } else {
          context.continueForkContext.add(forkContext2.head);
        }
      }
      forkContext2.replaceHead(forkContext2.makeUnreachable(-1, -1));
    }
    /**
     * Makes a path for a `return` statement.
     *
     * It registers the head segment to a context of `return`.
     * It makes new unreachable segment, then it set the head with the segment.
     * @returns {void}
     */
    makeReturn() {
      const forkContext2 = this.forkContext;
      if (forkContext2.reachable) {
        getReturnContext(this).returnedForkContext.add(forkContext2.head);
        forkContext2.replaceHead(forkContext2.makeUnreachable(-1, -1));
      }
    }
    /**
     * Makes a path for a `throw` statement.
     *
     * It registers the head segment to a context of `throw`.
     * It makes new unreachable segment, then it set the head with the segment.
     * @returns {void}
     */
    makeThrow() {
      const forkContext2 = this.forkContext;
      if (forkContext2.reachable) {
        getThrowContext(this).thrownForkContext.add(forkContext2.head);
        forkContext2.replaceHead(forkContext2.makeUnreachable(-1, -1));
      }
    }
    /**
     * Makes the final path.
     * @returns {void}
     */
    makeFinal() {
      const segments = this.currentSegments;
      if (segments.length > 0 && segments[0].reachable) {
        this.returnedForkContext.add(segments);
      }
    }
  }
  codePathState = CodePathState;
  return codePathState;
}
var idGenerator;
var hasRequiredIdGenerator;
function requireIdGenerator() {
  if (hasRequiredIdGenerator) return idGenerator;
  hasRequiredIdGenerator = 1;
  class IdGenerator {
    /**
     * @param {string} prefix Optional. A prefix of generated ids.
     */
    constructor(prefix) {
      this.prefix = String(prefix);
      this.n = 0;
    }
    /**
     * Generates id.
     * @returns {string} A generated id.
     */
    next() {
      this.n = 1 + this.n | 0;
      if (this.n < 0) {
        this.n = 1;
      }
      return this.prefix + this.n;
    }
  }
  idGenerator = IdGenerator;
  return idGenerator;
}
var codePath;
var hasRequiredCodePath;
function requireCodePath() {
  if (hasRequiredCodePath) return codePath;
  hasRequiredCodePath = 1;
  const CodePathState = requireCodePathState();
  const IdGenerator = requireIdGenerator();
  class CodePath {
    /**
     * Creates a new instance.
     * @param {Object} options Options for the function (see below).
     * @param {string} options.id An identifier.
     * @param {string} options.origin The type of code path origin.
     * @param {CodePath|null} options.upper The code path of the upper function scope.
     * @param {Function} options.onLooped A callback function to notify looping.
     */
    constructor({ id: id2, origin, upper, onLooped }) {
      this.id = id2;
      this.origin = origin;
      this.upper = upper;
      this.childCodePaths = [];
      Object.defineProperty(this, "internal", {
        value: new CodePathState(new IdGenerator(`${id2}_`), onLooped)
      });
      if (upper) {
        upper.childCodePaths.push(this);
      }
    }
    /**
     * Gets the state of a given code path.
     * @param {CodePath} codePath A code path to get.
     * @returns {CodePathState} The state of the code path.
     */
    static getState(codePath2) {
      return codePath2.internal;
    }
    /**
     * The initial code path segment. This is the segment that is at the head
     * of the code path.
     * This is a passthrough to the underlying `CodePathState`.
     * @type {CodePathSegment}
     */
    get initialSegment() {
      return this.internal.initialSegment;
    }
    /**
     * Final code path segments. These are the terminal (tail) segments in the
     * code path, which is the combination of `returnedSegments` and `thrownSegments`.
     * All segments in this array are reachable.
     * This is a passthrough to the underlying `CodePathState`.
     * @type {CodePathSegment[]}
     */
    get finalSegments() {
      return this.internal.finalSegments;
    }
    /**
     * Final code path segments that represent normal completion of the code path.
     * For functions, this means both explicit `return` statements and implicit returns,
     * such as the last reachable segment in a function that does not have an
     * explicit `return` as this implicitly returns `undefined`. For scripts,
     * modules, class field initializers, and class static blocks, this means
     * all lines of code have been executed.
     * These segments are also present in `finalSegments`.
     * This is a passthrough to the underlying `CodePathState`.
     * @type {CodePathSegment[]}
     */
    get returnedSegments() {
      return this.internal.returnedForkContext;
    }
    /**
     * Final code path segments that represent `throw` statements.
     * This is a passthrough to the underlying `CodePathState`.
     * These segments are also present in `finalSegments`.
     * @type {CodePathSegment[]}
     */
    get thrownSegments() {
      return this.internal.thrownForkContext;
    }
    /**
     * Traverses all segments in this code path.
     *
     *     codePath.traverseSegments((segment, controller) => {
     *         // do something.
     *     });
     *
     * This method enumerates segments in order from the head.
     *
     * The `controller` argument has two methods:
     *
     * - `skip()` - skips the following segments in this branch
     * - `break()` - skips all following segments in the traversal
     *
     * A note on the parameters: the `options` argument is optional. This means
     * the first argument might be an options object or the callback function.
     * @param {Object} [optionsOrCallback] Optional first and last segments to traverse.
     * @param {CodePathSegment} [optionsOrCallback.first] The first segment to traverse.
     * @param {CodePathSegment} [optionsOrCallback.last] The last segment to traverse.
     * @param {Function} callback A callback function.
     * @returns {void}
     */
    traverseSegments(optionsOrCallback, callback) {
      let resolvedOptions;
      let resolvedCallback;
      if (typeof optionsOrCallback === "function") {
        resolvedCallback = optionsOrCallback;
        resolvedOptions = {};
      } else {
        resolvedOptions = optionsOrCallback || {};
        resolvedCallback = callback;
      }
      const startSegment = resolvedOptions.first || this.internal.initialSegment;
      const lastSegment = resolvedOptions.last;
      let record;
      let index;
      let end;
      let segment = null;
      const visited = /* @__PURE__ */ new Set();
      const stack = [[startSegment, 0]];
      const skipped = /* @__PURE__ */ new Set();
      let broken = false;
      const controller = {
        /**
         * Skip the following segments in this branch.
         * @returns {void}
         */
        skip() {
          skipped.add(segment);
        },
        /**
         * Stop traversal completely - do not traverse to any
         * other segments.
         * @returns {void}
         */
        break() {
          broken = true;
        }
      };
      function isVisited(prevSegment) {
        return visited.has(prevSegment) || segment.isLoopedPrevSegment(prevSegment);
      }
      function isSkipped(prevSegment) {
        return skipped.has(prevSegment) || segment.isLoopedPrevSegment(prevSegment);
      }
      while (stack.length > 0) {
        record = stack.at(-1);
        segment = record[0];
        index = record[1];
        if (index === 0) {
          if (visited.has(segment)) {
            stack.pop();
            continue;
          }
          if (segment !== startSegment && segment.prevSegments.length > 0 && !segment.prevSegments.every(isVisited)) {
            stack.pop();
            continue;
          }
          visited.add(segment);
          const shouldSkip = skipped.size > 0 && segment.prevSegments.length > 0 && segment.prevSegments.every(isSkipped);
          if (!shouldSkip) {
            resolvedCallback.call(this, segment, controller);
            if (segment === lastSegment) {
              controller.skip();
            }
            if (broken) {
              break;
            }
          } else {
            skipped.add(segment);
          }
        }
        end = segment.nextSegments.length - 1;
        if (index < end) {
          record[1] += 1;
          stack.push([segment.nextSegments[index], 0]);
        } else if (index === end) {
          record[0] = segment.nextSegments[index];
          record[1] = 0;
        } else {
          stack.pop();
        }
      }
    }
  }
  codePath = CodePath;
  return codePath;
}
var codePathAnalyzer;
var hasRequiredCodePathAnalyzer;
function requireCodePathAnalyzer() {
  if (hasRequiredCodePathAnalyzer) return codePathAnalyzer;
  hasRequiredCodePathAnalyzer = 1;
  const assert2 = requireAssert(), { breakableTypePattern } = requireAstUtils$1(), CodePath = requireCodePath(), CodePathSegment = requireCodePathSegment(), IdGenerator = requireIdGenerator(), debug = requireDebugHelpers();
  function isCaseNode(node2) {
    return Boolean(node2.test);
  }
  function isPropertyDefinitionValue(node2) {
    const parent = node2.parent;
    return parent && parent.type === "PropertyDefinition" && parent.value === node2;
  }
  function isHandledLogicalOperator(operator) {
    return operator === "&&" || operator === "||" || operator === "??";
  }
  function isLogicalAssignmentOperator(operator) {
    return operator === "&&=" || operator === "||=" || operator === "??=";
  }
  function getLabel(node2) {
    if (node2.parent.type === "LabeledStatement") {
      return node2.parent.label.name;
    }
    return null;
  }
  function isForkingByTrueOrFalse(node2) {
    const parent = node2.parent;
    switch (parent.type) {
      case "ConditionalExpression":
      case "IfStatement":
      case "WhileStatement":
      case "DoWhileStatement":
      case "ForStatement":
        return parent.test === node2;
      case "LogicalExpression":
        return isHandledLogicalOperator(parent.operator);
      case "AssignmentExpression":
        return isLogicalAssignmentOperator(parent.operator);
      default:
        return false;
    }
  }
  function getBooleanValueIfSimpleConstant(node2) {
    if (node2.type === "Literal") {
      return Boolean(node2.value);
    }
    return void 0;
  }
  function isIdentifierReference(node2) {
    const parent = node2.parent;
    switch (parent.type) {
      case "LabeledStatement":
      case "BreakStatement":
      case "ContinueStatement":
      case "ArrayPattern":
      case "RestElement":
      case "ImportSpecifier":
      case "ImportDefaultSpecifier":
      case "ImportNamespaceSpecifier":
      case "CatchClause":
        return false;
      case "FunctionDeclaration":
      case "FunctionExpression":
      case "ArrowFunctionExpression":
      case "ClassDeclaration":
      case "ClassExpression":
      case "VariableDeclarator":
        return parent.id !== node2;
      case "Property":
      case "PropertyDefinition":
      case "MethodDefinition":
        return parent.key !== node2 || parent.computed || parent.shorthand;
      case "AssignmentPattern":
        return parent.key !== node2;
      default:
        return true;
    }
  }
  function forwardCurrentToHead(analyzer, node2) {
    const codePath2 = analyzer.codePath;
    const state = CodePath.getState(codePath2);
    const currentSegments = state.currentSegments;
    const headSegments = state.headSegments;
    const end = Math.max(currentSegments.length, headSegments.length);
    let i2, currentSegment, headSegment;
    for (i2 = 0; i2 < end; ++i2) {
      currentSegment = currentSegments[i2];
      headSegment = headSegments[i2];
      if (currentSegment !== headSegment && currentSegment) {
        const eventName = currentSegment.reachable ? "onCodePathSegmentEnd" : "onUnreachableCodePathSegmentEnd";
        debug.dump(`${eventName} ${currentSegment.id}`);
        analyzer.emit(eventName, [currentSegment, node2]);
      }
    }
    state.currentSegments = headSegments;
    for (i2 = 0; i2 < end; ++i2) {
      currentSegment = currentSegments[i2];
      headSegment = headSegments[i2];
      if (currentSegment !== headSegment && headSegment) {
        const eventName = headSegment.reachable ? "onCodePathSegmentStart" : "onUnreachableCodePathSegmentStart";
        debug.dump(`${eventName} ${headSegment.id}`);
        CodePathSegment.markUsed(headSegment);
        analyzer.emit(eventName, [headSegment, node2]);
      }
    }
  }
  function leaveFromCurrentSegment(analyzer, node2) {
    const state = CodePath.getState(analyzer.codePath);
    const currentSegments = state.currentSegments;
    for (let i2 = 0; i2 < currentSegments.length; ++i2) {
      const currentSegment = currentSegments[i2];
      const eventName = currentSegment.reachable ? "onCodePathSegmentEnd" : "onUnreachableCodePathSegmentEnd";
      debug.dump(`${eventName} ${currentSegment.id}`);
      analyzer.emit(eventName, [currentSegment, node2]);
    }
    state.currentSegments = [];
  }
  function preprocess(analyzer, node2) {
    const codePath2 = analyzer.codePath;
    const state = CodePath.getState(codePath2);
    const parent = node2.parent;
    switch (parent.type) {
      // The `arguments.length == 0` case is in `postprocess` function.
      case "CallExpression":
        if (parent.optional === true && parent.arguments.length >= 1 && parent.arguments[0] === node2) {
          state.makeOptionalRight();
        }
        break;
      case "MemberExpression":
        if (parent.optional === true && parent.property === node2) {
          state.makeOptionalRight();
        }
        break;
      case "LogicalExpression":
        if (parent.right === node2 && isHandledLogicalOperator(parent.operator)) {
          state.makeLogicalRight();
        }
        break;
      case "AssignmentExpression":
        if (parent.right === node2 && isLogicalAssignmentOperator(parent.operator)) {
          state.makeLogicalRight();
        }
        break;
      case "ConditionalExpression":
      case "IfStatement":
        if (parent.consequent === node2) {
          state.makeIfConsequent();
        } else if (parent.alternate === node2) {
          state.makeIfAlternate();
        }
        break;
      case "SwitchCase":
        if (parent.consequent[0] === node2) {
          state.makeSwitchCaseBody(false, !parent.test);
        }
        break;
      case "TryStatement":
        if (parent.handler === node2) {
          state.makeCatchBlock();
        } else if (parent.finalizer === node2) {
          state.makeFinallyBlock();
        }
        break;
      case "WhileStatement":
        if (parent.test === node2) {
          state.makeWhileTest(getBooleanValueIfSimpleConstant(node2));
        } else {
          assert2(parent.body === node2);
          state.makeWhileBody();
        }
        break;
      case "DoWhileStatement":
        if (parent.body === node2) {
          state.makeDoWhileBody();
        } else {
          assert2(parent.test === node2);
          state.makeDoWhileTest(getBooleanValueIfSimpleConstant(node2));
        }
        break;
      case "ForStatement":
        if (parent.test === node2) {
          state.makeForTest(getBooleanValueIfSimpleConstant(node2));
        } else if (parent.update === node2) {
          state.makeForUpdate();
        } else if (parent.body === node2) {
          state.makeForBody();
        }
        break;
      case "ForInStatement":
      case "ForOfStatement":
        if (parent.left === node2) {
          state.makeForInOfLeft();
        } else if (parent.right === node2) {
          state.makeForInOfRight();
        } else {
          assert2(parent.body === node2);
          state.makeForInOfBody();
        }
        break;
      case "AssignmentPattern":
        if (parent.right === node2) {
          state.pushForkContext();
          state.forkBypassPath();
          state.forkPath();
        }
        break;
    }
  }
  function processCodePathToEnter(analyzer, node2) {
    let codePath2 = analyzer.codePath;
    let state = codePath2 && CodePath.getState(codePath2);
    const parent = node2.parent;
    function startCodePath(origin) {
      if (codePath2) {
        forwardCurrentToHead(analyzer, node2);
        debug.dumpState(node2, state, false);
      }
      codePath2 = analyzer.codePath = new CodePath({
        id: analyzer.idGenerator.next(),
        origin,
        upper: codePath2,
        onLooped: analyzer.onLooped
      });
      state = CodePath.getState(codePath2);
      debug.dump(`onCodePathStart ${codePath2.id}`);
      analyzer.emit("onCodePathStart", [codePath2, node2]);
    }
    if (isPropertyDefinitionValue(node2)) {
      startCodePath("class-field-initializer");
    }
    switch (node2.type) {
      case "Program":
        startCodePath("program");
        break;
      case "FunctionDeclaration":
      case "FunctionExpression":
      case "ArrowFunctionExpression":
        startCodePath("function");
        break;
      case "StaticBlock":
        startCodePath("class-static-block");
        break;
      case "ChainExpression":
        state.pushChainContext();
        break;
      case "CallExpression":
        if (node2.optional === true) {
          state.makeOptionalNode();
        }
        break;
      case "MemberExpression":
        if (node2.optional === true) {
          state.makeOptionalNode();
        }
        break;
      case "LogicalExpression":
        if (isHandledLogicalOperator(node2.operator)) {
          state.pushChoiceContext(
            node2.operator,
            isForkingByTrueOrFalse(node2)
          );
        }
        break;
      case "AssignmentExpression":
        if (isLogicalAssignmentOperator(node2.operator)) {
          state.pushChoiceContext(
            node2.operator.slice(0, -1),
            // removes `=` from the end
            isForkingByTrueOrFalse(node2)
          );
        }
        break;
      case "ConditionalExpression":
      case "IfStatement":
        state.pushChoiceContext("test", false);
        break;
      case "SwitchStatement":
        state.pushSwitchContext(
          node2.cases.some(isCaseNode),
          getLabel(node2)
        );
        break;
      case "TryStatement":
        state.pushTryContext(Boolean(node2.finalizer));
        break;
      case "SwitchCase":
        if (parent.discriminant !== node2 && parent.cases[0] !== node2) {
          state.forkPath();
        }
        break;
      case "WhileStatement":
      case "DoWhileStatement":
      case "ForStatement":
      case "ForInStatement":
      case "ForOfStatement":
        state.pushLoopContext(node2.type, getLabel(node2));
        break;
      case "LabeledStatement":
        if (!breakableTypePattern.test(node2.body.type)) {
          state.pushBreakContext(false, node2.label.name);
        }
        break;
    }
    forwardCurrentToHead(analyzer, node2);
    debug.dumpState(node2, state, false);
  }
  function processCodePathToExit(analyzer, node2) {
    const codePath2 = analyzer.codePath;
    const state = CodePath.getState(codePath2);
    let dontForward = false;
    switch (node2.type) {
      case "ChainExpression":
        state.popChainContext();
        break;
      case "IfStatement":
      case "ConditionalExpression":
        state.popChoiceContext();
        break;
      case "LogicalExpression":
        if (isHandledLogicalOperator(node2.operator)) {
          state.popChoiceContext();
        }
        break;
      case "AssignmentExpression":
        if (isLogicalAssignmentOperator(node2.operator)) {
          state.popChoiceContext();
        }
        break;
      case "SwitchStatement":
        state.popSwitchContext();
        break;
      case "SwitchCase":
        if (node2.consequent.length === 0) {
          state.makeSwitchCaseBody(true, !node2.test);
        }
        if (state.forkContext.reachable) {
          dontForward = true;
        }
        break;
      case "TryStatement":
        state.popTryContext();
        break;
      case "BreakStatement":
        forwardCurrentToHead(analyzer, node2);
        state.makeBreak(node2.label && node2.label.name);
        dontForward = true;
        break;
      case "ContinueStatement":
        forwardCurrentToHead(analyzer, node2);
        state.makeContinue(node2.label && node2.label.name);
        dontForward = true;
        break;
      case "ReturnStatement":
        forwardCurrentToHead(analyzer, node2);
        state.makeReturn();
        dontForward = true;
        break;
      case "ThrowStatement":
        forwardCurrentToHead(analyzer, node2);
        state.makeThrow();
        dontForward = true;
        break;
      case "Identifier":
        if (isIdentifierReference(node2)) {
          state.makeFirstThrowablePathInTryBlock();
          dontForward = true;
        }
        break;
      case "CallExpression":
      case "ImportExpression":
      case "MemberExpression":
      case "NewExpression":
      case "YieldExpression":
        state.makeFirstThrowablePathInTryBlock();
        break;
      case "WhileStatement":
      case "DoWhileStatement":
      case "ForStatement":
      case "ForInStatement":
      case "ForOfStatement":
        state.popLoopContext();
        break;
      case "AssignmentPattern":
        state.popForkContext();
        break;
      case "LabeledStatement":
        if (!breakableTypePattern.test(node2.body.type)) {
          state.popBreakContext();
        }
        break;
    }
    if (!dontForward) {
      forwardCurrentToHead(analyzer, node2);
    }
    debug.dumpState(node2, state, true);
  }
  function postprocess(analyzer, node2) {
    function endCodePath() {
      let codePath2 = analyzer.codePath;
      CodePath.getState(codePath2).makeFinal();
      leaveFromCurrentSegment(analyzer, node2);
      debug.dump(`onCodePathEnd ${codePath2.id}`);
      analyzer.emit("onCodePathEnd", [codePath2, node2]);
      debug.dumpDot(codePath2);
      codePath2 = analyzer.codePath = analyzer.codePath.upper;
      if (codePath2) {
        debug.dumpState(node2, CodePath.getState(codePath2), true);
      }
    }
    switch (node2.type) {
      case "Program":
      case "FunctionDeclaration":
      case "FunctionExpression":
      case "ArrowFunctionExpression":
      case "StaticBlock": {
        endCodePath();
        break;
      }
      // The `arguments.length >= 1` case is in `preprocess` function.
      case "CallExpression":
        if (node2.optional === true && node2.arguments.length === 0) {
          CodePath.getState(analyzer.codePath).makeOptionalRight();
        }
        break;
    }
    if (isPropertyDefinitionValue(node2)) {
      endCodePath();
    }
  }
  class CodePathAnalyzer {
    /**
     * @param {EventGenerator} eventGenerator An event generator to wrap.
     */
    constructor(eventGenerator) {
      this.original = eventGenerator;
      this.emit = eventGenerator.emit;
      this.codePath = null;
      this.idGenerator = new IdGenerator("s");
      this.currentNode = null;
      this.onLooped = this.onLooped.bind(this);
    }
    /**
     * Does the process to enter a given AST node.
     * This updates state of analysis and calls `enterNode` of the wrapped.
     * @param {ASTNode} node A node which is entering.
     * @returns {void}
     */
    enterNode(node2) {
      this.currentNode = node2;
      if (node2.parent) {
        preprocess(this, node2);
      }
      processCodePathToEnter(this, node2);
      this.original.enterNode(node2);
      this.currentNode = null;
    }
    /**
     * Does the process to leave a given AST node.
     * This updates state of analysis and calls `leaveNode` of the wrapped.
     * @param {ASTNode} node A node which is leaving.
     * @returns {void}
     */
    leaveNode(node2) {
      this.currentNode = node2;
      processCodePathToExit(this, node2);
      this.original.leaveNode(node2);
      postprocess(this, node2);
      this.currentNode = null;
    }
    /**
     * This is called on a code path looped.
     * Then this raises a looped event.
     * @param {CodePathSegment} fromSegment A segment of prev.
     * @param {CodePathSegment} toSegment A segment of next.
     * @returns {void}
     */
    onLooped(fromSegment, toSegment) {
      if (fromSegment.reachable && toSegment.reachable) {
        debug.dump(
          `onCodePathSegmentLoop ${fromSegment.id} -> ${toSegment.id}`
        );
        this.emit("onCodePathSegmentLoop", [
          fromSegment,
          toSegment,
          this.currentNode
        ]);
      }
    }
  }
  codePathAnalyzer = CodePathAnalyzer;
  return codePathAnalyzer;
}
var cjs$2 = {};
var lib$2 = { exports: {} };
var parseString = { exports: {} };
var Func;
var hasRequiredFunc;
function requireFunc() {
  if (hasRequiredFunc) return Func;
  hasRequiredFunc = 1;
  var apply, curry, flip, fix, over, memoize, toString$ = {}.toString;
  apply = curry$(function(f2, list) {
    return f2.apply(null, list);
  });
  curry = function(f2) {
    return curry$(f2);
  };
  flip = curry$(function(f2, x2, y2) {
    return f2(y2, x2);
  });
  fix = function(f2) {
    return /* @__PURE__ */ (function(g2) {
      return function() {
        return f2(g2(g2)).apply(null, arguments);
      };
    })(function(g2) {
      return function() {
        return f2(g2(g2)).apply(null, arguments);
      };
    });
  };
  over = curry$(function(f2, g2, x2, y2) {
    return f2(g2(x2), g2(y2));
  });
  memoize = function(f2) {
    var memo;
    memo = {};
    return function() {
      var args, res$, i$, to$, key, arg;
      res$ = [];
      for (i$ = 0, to$ = arguments.length; i$ < to$; ++i$) {
        res$.push(arguments[i$]);
      }
      args = res$;
      key = (function() {
        var i$2, ref$, len$, results$ = [];
        for (i$2 = 0, len$ = (ref$ = args).length; i$2 < len$; ++i$2) {
          arg = ref$[i$2];
          results$.push(arg + toString$.call(arg).slice(8, -1));
        }
        return results$;
      })().join("");
      return memo[key] = key in memo ? memo[key] : f2.apply(null, args);
    };
  };
  Func = {
    curry,
    flip,
    fix,
    apply,
    over,
    memoize
  };
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  return Func;
}
var List;
var hasRequiredList;
function requireList() {
  if (hasRequiredList) return List;
  hasRequiredList = 1;
  var each, map, compact, filter2, reject, remove, partition, find, head, first, tail, last, initial, empty, reverse, unique, uniqueBy, fold, foldl, fold1, foldl1, foldr, foldr1, unfoldr, concat, concatMap2, flatten, difference, intersection, union, countBy, groupBy, andList, orList, any, all, sort, sortWith, sortBy, sum, product, mean, average, maximum, minimum, maximumBy, minimumBy, scan, scanl, scan1, scanl1, scanr, scanr1, slice, take, drop, splitAt, takeWhile, dropWhile, span, breakList, zip, zipWith, zipAll, zipAllWith, at, elemIndex, elemIndices, findIndex, findIndices, toString$ = {}.toString;
  each = curry$(function(f2, xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      f2(x2);
    }
    return xs;
  });
  map = curry$(function(f2, xs) {
    var i$, len$, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      results$.push(f2(x2));
    }
    return results$;
  });
  compact = function(xs) {
    var i$, len$, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (x2) {
        results$.push(x2);
      }
    }
    return results$;
  };
  filter2 = curry$(function(f2, xs) {
    var i$, len$, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (f2(x2)) {
        results$.push(x2);
      }
    }
    return results$;
  });
  reject = curry$(function(f2, xs) {
    var i$, len$, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (!f2(x2)) {
        results$.push(x2);
      }
    }
    return results$;
  });
  remove = curry$(function(el, xs) {
    var i2, x$;
    i2 = elemIndex(el, xs);
    x$ = xs.slice();
    if (i2 != null) {
      x$.splice(i2, 1);
    }
    return x$;
  });
  partition = curry$(function(f2, xs) {
    var passed, failed, i$, len$, x2;
    passed = [];
    failed = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      (f2(x2) ? passed : failed).push(x2);
    }
    return [passed, failed];
  });
  find = curry$(function(f2, xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (f2(x2)) {
        return x2;
      }
    }
  });
  head = first = function(xs) {
    return xs[0];
  };
  tail = function(xs) {
    if (!xs.length) {
      return;
    }
    return xs.slice(1);
  };
  last = function(xs) {
    return xs[xs.length - 1];
  };
  initial = function(xs) {
    if (!xs.length) {
      return;
    }
    return xs.slice(0, -1);
  };
  empty = function(xs) {
    return !xs.length;
  };
  reverse = function(xs) {
    return xs.concat().reverse();
  };
  unique = function(xs) {
    var result, i$, len$, x2;
    result = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (!in$(x2, result)) {
        result.push(x2);
      }
    }
    return result;
  };
  uniqueBy = curry$(function(f2, xs) {
    var seen, i$, len$, x2, val, results$ = [];
    seen = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      val = f2(x2);
      if (in$(val, seen)) {
        continue;
      }
      seen.push(val);
      results$.push(x2);
    }
    return results$;
  });
  fold = foldl = curry$(function(f2, memo, xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      memo = f2(memo, x2);
    }
    return memo;
  });
  fold1 = foldl1 = curry$(function(f2, xs) {
    return fold(f2, xs[0], xs.slice(1));
  });
  foldr = curry$(function(f2, memo, xs) {
    var i$, x2;
    for (i$ = xs.length - 1; i$ >= 0; --i$) {
      x2 = xs[i$];
      memo = f2(x2, memo);
    }
    return memo;
  });
  foldr1 = curry$(function(f2, xs) {
    return foldr(f2, xs[xs.length - 1], xs.slice(0, -1));
  });
  unfoldr = curry$(function(f2, b) {
    var result, x2, that;
    result = [];
    x2 = b;
    while ((that = f2(x2)) != null) {
      result.push(that[0]);
      x2 = that[1];
    }
    return result;
  });
  concat = function(xss) {
    return [].concat.apply([], xss);
  };
  concatMap2 = curry$(function(f2, xs) {
    var x2;
    return [].concat.apply([], (function() {
      var i$, ref$, len$, results$ = [];
      for (i$ = 0, len$ = (ref$ = xs).length; i$ < len$; ++i$) {
        x2 = ref$[i$];
        results$.push(f2(x2));
      }
      return results$;
    })());
  });
  flatten = function(xs) {
    var x2;
    return [].concat.apply([], (function() {
      var i$, ref$, len$, results$ = [];
      for (i$ = 0, len$ = (ref$ = xs).length; i$ < len$; ++i$) {
        x2 = ref$[i$];
        if (toString$.call(x2).slice(8, -1) === "Array") {
          results$.push(flatten(x2));
        } else {
          results$.push(x2);
        }
      }
      return results$;
    })());
  };
  difference = function(xs) {
    var yss, res$, i$, to$, results, len$, x2, j$, len1$, ys;
    res$ = [];
    for (i$ = 1, to$ = arguments.length; i$ < to$; ++i$) {
      res$.push(arguments[i$]);
    }
    yss = res$;
    results = [];
    outer: for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      for (j$ = 0, len1$ = yss.length; j$ < len1$; ++j$) {
        ys = yss[j$];
        if (in$(x2, ys)) {
          continue outer;
        }
      }
      results.push(x2);
    }
    return results;
  };
  intersection = function(xs) {
    var yss, res$, i$, to$, results, len$, x2, j$, len1$, ys;
    res$ = [];
    for (i$ = 1, to$ = arguments.length; i$ < to$; ++i$) {
      res$.push(arguments[i$]);
    }
    yss = res$;
    results = [];
    outer: for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      for (j$ = 0, len1$ = yss.length; j$ < len1$; ++j$) {
        ys = yss[j$];
        if (!in$(x2, ys)) {
          continue outer;
        }
      }
      results.push(x2);
    }
    return results;
  };
  union = function() {
    var xss, res$, i$, to$, results, len$, xs, j$, len1$, x2;
    res$ = [];
    for (i$ = 0, to$ = arguments.length; i$ < to$; ++i$) {
      res$.push(arguments[i$]);
    }
    xss = res$;
    results = [];
    for (i$ = 0, len$ = xss.length; i$ < len$; ++i$) {
      xs = xss[i$];
      for (j$ = 0, len1$ = xs.length; j$ < len1$; ++j$) {
        x2 = xs[j$];
        if (!in$(x2, results)) {
          results.push(x2);
        }
      }
    }
    return results;
  };
  countBy = curry$(function(f2, xs) {
    var results, i$, len$, x2, key;
    results = {};
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      key = f2(x2);
      if (key in results) {
        results[key] += 1;
      } else {
        results[key] = 1;
      }
    }
    return results;
  });
  groupBy = curry$(function(f2, xs) {
    var results, i$, len$, x2, key;
    results = {};
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      key = f2(x2);
      if (key in results) {
        results[key].push(x2);
      } else {
        results[key] = [x2];
      }
    }
    return results;
  });
  andList = function(xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (!x2) {
        return false;
      }
    }
    return true;
  };
  orList = function(xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (x2) {
        return true;
      }
    }
    return false;
  };
  any = curry$(function(f2, xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (f2(x2)) {
        return true;
      }
    }
    return false;
  });
  all = curry$(function(f2, xs) {
    var i$, len$, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      if (!f2(x2)) {
        return false;
      }
    }
    return true;
  });
  sort = function(xs) {
    return xs.concat().sort(function(x2, y2) {
      if (x2 > y2) {
        return 1;
      } else if (x2 < y2) {
        return -1;
      } else {
        return 0;
      }
    });
  };
  sortWith = curry$(function(f2, xs) {
    return xs.concat().sort(f2);
  });
  sortBy = curry$(function(f2, xs) {
    return xs.concat().sort(function(x2, y2) {
      if (f2(x2) > f2(y2)) {
        return 1;
      } else if (f2(x2) < f2(y2)) {
        return -1;
      } else {
        return 0;
      }
    });
  });
  sum = function(xs) {
    var result, i$, len$, x2;
    result = 0;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      result += x2;
    }
    return result;
  };
  product = function(xs) {
    var result, i$, len$, x2;
    result = 1;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      result *= x2;
    }
    return result;
  };
  mean = average = function(xs) {
    var sum2, i$, len$, x2;
    sum2 = 0;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      x2 = xs[i$];
      sum2 += x2;
    }
    return sum2 / xs.length;
  };
  maximum = function(xs) {
    var max, i$, ref$, len$, x2;
    max = xs[0];
    for (i$ = 0, len$ = (ref$ = xs.slice(1)).length; i$ < len$; ++i$) {
      x2 = ref$[i$];
      if (x2 > max) {
        max = x2;
      }
    }
    return max;
  };
  minimum = function(xs) {
    var min, i$, ref$, len$, x2;
    min = xs[0];
    for (i$ = 0, len$ = (ref$ = xs.slice(1)).length; i$ < len$; ++i$) {
      x2 = ref$[i$];
      if (x2 < min) {
        min = x2;
      }
    }
    return min;
  };
  maximumBy = curry$(function(f2, xs) {
    var max, i$, ref$, len$, x2;
    max = xs[0];
    for (i$ = 0, len$ = (ref$ = xs.slice(1)).length; i$ < len$; ++i$) {
      x2 = ref$[i$];
      if (f2(x2) > f2(max)) {
        max = x2;
      }
    }
    return max;
  });
  minimumBy = curry$(function(f2, xs) {
    var min, i$, ref$, len$, x2;
    min = xs[0];
    for (i$ = 0, len$ = (ref$ = xs.slice(1)).length; i$ < len$; ++i$) {
      x2 = ref$[i$];
      if (f2(x2) < f2(min)) {
        min = x2;
      }
    }
    return min;
  });
  scan = scanl = curry$(function(f2, memo, xs) {
    var last2, x2;
    last2 = memo;
    return [memo].concat((function() {
      var i$, ref$, len$, results$ = [];
      for (i$ = 0, len$ = (ref$ = xs).length; i$ < len$; ++i$) {
        x2 = ref$[i$];
        results$.push(last2 = f2(last2, x2));
      }
      return results$;
    })());
  });
  scan1 = scanl1 = curry$(function(f2, xs) {
    if (!xs.length) {
      return;
    }
    return scan(f2, xs[0], xs.slice(1));
  });
  scanr = curry$(function(f2, memo, xs) {
    xs = xs.concat().reverse();
    return scan(f2, memo, xs).reverse();
  });
  scanr1 = curry$(function(f2, xs) {
    if (!xs.length) {
      return;
    }
    xs = xs.concat().reverse();
    return scan(f2, xs[0], xs.slice(1)).reverse();
  });
  slice = curry$(function(x2, y2, xs) {
    return xs.slice(x2, y2);
  });
  take = curry$(function(n2, xs) {
    if (n2 <= 0) {
      return xs.slice(0, 0);
    } else {
      return xs.slice(0, n2);
    }
  });
  drop = curry$(function(n2, xs) {
    if (n2 <= 0) {
      return xs;
    } else {
      return xs.slice(n2);
    }
  });
  splitAt = curry$(function(n2, xs) {
    return [take(n2, xs), drop(n2, xs)];
  });
  takeWhile = curry$(function(p2, xs) {
    var len, i2;
    len = xs.length;
    if (!len) {
      return xs;
    }
    i2 = 0;
    while (i2 < len && p2(xs[i2])) {
      i2 += 1;
    }
    return xs.slice(0, i2);
  });
  dropWhile = curry$(function(p2, xs) {
    var len, i2;
    len = xs.length;
    if (!len) {
      return xs;
    }
    i2 = 0;
    while (i2 < len && p2(xs[i2])) {
      i2 += 1;
    }
    return xs.slice(i2);
  });
  span = curry$(function(p2, xs) {
    return [takeWhile(p2, xs), dropWhile(p2, xs)];
  });
  breakList = curry$(function(p2, xs) {
    return span(compose$(p2, not$), xs);
  });
  zip = curry$(function(xs, ys) {
    var result, len, i$, len$, i2, x2;
    result = [];
    len = ys.length;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (i2 === len) {
        break;
      }
      result.push([x2, ys[i2]]);
    }
    return result;
  });
  zipWith = curry$(function(f2, xs, ys) {
    var result, len, i$, len$, i2, x2;
    result = [];
    len = ys.length;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (i2 === len) {
        break;
      }
      result.push(f2(x2, ys[i2]));
    }
    return result;
  });
  zipAll = function() {
    var xss, res$, i$, to$, minLength, len$, xs, ref$, i2, lresult$, j$, results$ = [];
    res$ = [];
    for (i$ = 0, to$ = arguments.length; i$ < to$; ++i$) {
      res$.push(arguments[i$]);
    }
    xss = res$;
    minLength = void 0;
    for (i$ = 0, len$ = xss.length; i$ < len$; ++i$) {
      xs = xss[i$];
      minLength <= (ref$ = xs.length) || (minLength = ref$);
    }
    for (i$ = 0; i$ < minLength; ++i$) {
      i2 = i$;
      lresult$ = [];
      for (j$ = 0, len$ = xss.length; j$ < len$; ++j$) {
        xs = xss[j$];
        lresult$.push(xs[i2]);
      }
      results$.push(lresult$);
    }
    return results$;
  };
  zipAllWith = function(f2) {
    var xss, res$, i$, to$, minLength, len$, xs, ref$, i2, results$ = [];
    res$ = [];
    for (i$ = 1, to$ = arguments.length; i$ < to$; ++i$) {
      res$.push(arguments[i$]);
    }
    xss = res$;
    minLength = void 0;
    for (i$ = 0, len$ = xss.length; i$ < len$; ++i$) {
      xs = xss[i$];
      minLength <= (ref$ = xs.length) || (minLength = ref$);
    }
    for (i$ = 0; i$ < minLength; ++i$) {
      i2 = i$;
      results$.push(f2.apply(null, fn$()));
    }
    return results$;
    function fn$() {
      var i$2, ref$2, len$2, results$2 = [];
      for (i$2 = 0, len$2 = (ref$2 = xss).length; i$2 < len$2; ++i$2) {
        xs = ref$2[i$2];
        results$2.push(xs[i2]);
      }
      return results$2;
    }
  };
  at = curry$(function(n2, xs) {
    if (n2 < 0) {
      return xs[xs.length + n2];
    } else {
      return xs[n2];
    }
  });
  elemIndex = curry$(function(el, xs) {
    var i$, len$, i2, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (x2 === el) {
        return i2;
      }
    }
  });
  elemIndices = curry$(function(el, xs) {
    var i$, len$, i2, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (x2 === el) {
        results$.push(i2);
      }
    }
    return results$;
  });
  findIndex = curry$(function(f2, xs) {
    var i$, len$, i2, x2;
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (f2(x2)) {
        return i2;
      }
    }
  });
  findIndices = curry$(function(f2, xs) {
    var i$, len$, i2, x2, results$ = [];
    for (i$ = 0, len$ = xs.length; i$ < len$; ++i$) {
      i2 = i$;
      x2 = xs[i$];
      if (f2(x2)) {
        results$.push(i2);
      }
    }
    return results$;
  });
  List = {
    each,
    map,
    filter: filter2,
    compact,
    reject,
    remove,
    partition,
    find,
    head,
    first,
    tail,
    last,
    initial,
    empty,
    reverse,
    difference,
    intersection,
    union,
    countBy,
    groupBy,
    fold,
    fold1,
    foldl,
    foldl1,
    foldr,
    foldr1,
    unfoldr,
    andList,
    orList,
    any,
    all,
    unique,
    uniqueBy,
    sort,
    sortWith,
    sortBy,
    sum,
    product,
    mean,
    average,
    concat,
    concatMap: concatMap2,
    flatten,
    maximum,
    minimum,
    maximumBy,
    minimumBy,
    scan,
    scan1,
    scanl,
    scanl1,
    scanr,
    scanr1,
    slice,
    take,
    drop,
    splitAt,
    takeWhile,
    dropWhile,
    span,
    breakList,
    zip,
    zipWith,
    zipAll,
    zipAllWith,
    at,
    elemIndex,
    elemIndices,
    findIndex,
    findIndices
  };
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  function in$(x2, xs) {
    var i2 = -1, l2 = xs.length >>> 0;
    while (++i2 < l2) if (x2 === xs[i2]) return true;
    return false;
  }
  function compose$() {
    var functions = arguments;
    return function() {
      var i2, result;
      result = functions[0].apply(this, arguments);
      for (i2 = 1; i2 < functions.length; ++i2) {
        result = functions[i2](result);
      }
      return result;
    };
  }
  function not$(x2) {
    return !x2;
  }
  return List;
}
var Obj;
var hasRequiredObj;
function requireObj() {
  if (hasRequiredObj) return Obj;
  hasRequiredObj = 1;
  var values, keys, pairsToObj, objToPairs, listsToObj, objToLists, empty, each, map, compact, filter2, reject, partition, find;
  values = function(object) {
    var i$, x2, results$ = [];
    for (i$ in object) {
      x2 = object[i$];
      results$.push(x2);
    }
    return results$;
  };
  keys = function(object) {
    var x2, results$ = [];
    for (x2 in object) {
      results$.push(x2);
    }
    return results$;
  };
  pairsToObj = function(object) {
    var i$, len$, x2, resultObj$ = {};
    for (i$ = 0, len$ = object.length; i$ < len$; ++i$) {
      x2 = object[i$];
      resultObj$[x2[0]] = x2[1];
    }
    return resultObj$;
  };
  objToPairs = function(object) {
    var key, value, results$ = [];
    for (key in object) {
      value = object[key];
      results$.push([key, value]);
    }
    return results$;
  };
  listsToObj = curry$(function(keys2, values2) {
    var i$, len$, i2, key, resultObj$ = {};
    for (i$ = 0, len$ = keys2.length; i$ < len$; ++i$) {
      i2 = i$;
      key = keys2[i$];
      resultObj$[key] = values2[i2];
    }
    return resultObj$;
  });
  objToLists = function(object) {
    var keys2, values2, key, value;
    keys2 = [];
    values2 = [];
    for (key in object) {
      value = object[key];
      keys2.push(key);
      values2.push(value);
    }
    return [keys2, values2];
  };
  empty = function(object) {
    var x2;
    for (x2 in object) {
      return false;
    }
    return true;
  };
  each = curry$(function(f2, object) {
    var i$, x2;
    for (i$ in object) {
      x2 = object[i$];
      f2(x2);
    }
    return object;
  });
  map = curry$(function(f2, object) {
    var k, x2, resultObj$ = {};
    for (k in object) {
      x2 = object[k];
      resultObj$[k] = f2(x2);
    }
    return resultObj$;
  });
  compact = function(object) {
    var k, x2, resultObj$ = {};
    for (k in object) {
      x2 = object[k];
      if (x2) {
        resultObj$[k] = x2;
      }
    }
    return resultObj$;
  };
  filter2 = curry$(function(f2, object) {
    var k, x2, resultObj$ = {};
    for (k in object) {
      x2 = object[k];
      if (f2(x2)) {
        resultObj$[k] = x2;
      }
    }
    return resultObj$;
  });
  reject = curry$(function(f2, object) {
    var k, x2, resultObj$ = {};
    for (k in object) {
      x2 = object[k];
      if (!f2(x2)) {
        resultObj$[k] = x2;
      }
    }
    return resultObj$;
  });
  partition = curry$(function(f2, object) {
    var passed, failed, k, x2;
    passed = {};
    failed = {};
    for (k in object) {
      x2 = object[k];
      (f2(x2) ? passed : failed)[k] = x2;
    }
    return [passed, failed];
  });
  find = curry$(function(f2, object) {
    var i$, x2;
    for (i$ in object) {
      x2 = object[i$];
      if (f2(x2)) {
        return x2;
      }
    }
  });
  Obj = {
    values,
    keys,
    pairsToObj,
    objToPairs,
    listsToObj,
    objToLists,
    empty,
    each,
    map,
    filter: filter2,
    compact,
    reject,
    partition,
    find
  };
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  return Obj;
}
var Str;
var hasRequiredStr;
function requireStr() {
  if (hasRequiredStr) return Str;
  hasRequiredStr = 1;
  var split, join2, lines, unlines, words, unwords, chars, unchars, reverse, repeat, capitalize, camelize, dasherize;
  split = curry$(function(sep2, str) {
    return str.split(sep2);
  });
  join2 = curry$(function(sep2, xs) {
    return xs.join(sep2);
  });
  lines = function(str) {
    if (!str.length) {
      return [];
    }
    return str.split("\n");
  };
  unlines = function(it) {
    return it.join("\n");
  };
  words = function(str) {
    if (!str.length) {
      return [];
    }
    return str.split(/[ ]+/);
  };
  unwords = function(it) {
    return it.join(" ");
  };
  chars = function(it) {
    return it.split("");
  };
  unchars = function(it) {
    return it.join("");
  };
  reverse = function(str) {
    return str.split("").reverse().join("");
  };
  repeat = curry$(function(n2, str) {
    var result, i$;
    result = "";
    for (i$ = 0; i$ < n2; ++i$) {
      result += str;
    }
    return result;
  });
  capitalize = function(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
  };
  camelize = function(it) {
    return it.replace(/[-_]+(.)?/g, function(arg$, c2) {
      return (c2 != null ? c2 : "").toUpperCase();
    });
  };
  dasherize = function(str) {
    return str.replace(/([^-A-Z])([A-Z]+)/g, function(arg$, lower, upper) {
      return lower + "-" + (upper.length > 1 ? upper : upper.toLowerCase());
    }).replace(/^([A-Z]+)/, function(arg$, upper) {
      if (upper.length > 1) {
        return upper + "-";
      } else {
        return upper.toLowerCase();
      }
    });
  };
  Str = {
    split,
    join: join2,
    lines,
    unlines,
    words,
    unwords,
    chars,
    unchars,
    reverse,
    repeat,
    capitalize,
    camelize,
    dasherize
  };
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  return Str;
}
var Num;
var hasRequiredNum;
function requireNum() {
  if (hasRequiredNum) return Num;
  hasRequiredNum = 1;
  var max, min, negate, abs, signum, quot, rem, div, mod, recip, pi, tau, exp, sqrt, ln, pow, sin, tan, cos, asin, acos, atan, atan2, truncate, round, ceiling, floor, isItNaN, even, odd, gcd, lcm;
  max = curry$(function(x$, y$) {
    return x$ > y$ ? x$ : y$;
  });
  min = curry$(function(x$, y$) {
    return x$ < y$ ? x$ : y$;
  });
  negate = function(x2) {
    return -x2;
  };
  abs = Math.abs;
  signum = function(x2) {
    if (x2 < 0) {
      return -1;
    } else if (x2 > 0) {
      return 1;
    } else {
      return 0;
    }
  };
  quot = curry$(function(x2, y2) {
    return ~~(x2 / y2);
  });
  rem = curry$(function(x$, y$) {
    return x$ % y$;
  });
  div = curry$(function(x2, y2) {
    return Math.floor(x2 / y2);
  });
  mod = curry$(function(x$, y$) {
    var ref$;
    return (x$ % (ref$ = y$) + ref$) % ref$;
  });
  recip = (function(it) {
    return 1 / it;
  });
  pi = Math.PI;
  tau = pi * 2;
  exp = Math.exp;
  sqrt = Math.sqrt;
  ln = Math.log;
  pow = curry$(function(x$, y$) {
    return Math.pow(x$, y$);
  });
  sin = Math.sin;
  tan = Math.tan;
  cos = Math.cos;
  asin = Math.asin;
  acos = Math.acos;
  atan = Math.atan;
  atan2 = curry$(function(x2, y2) {
    return Math.atan2(x2, y2);
  });
  truncate = function(x2) {
    return ~~x2;
  };
  round = Math.round;
  ceiling = Math.ceil;
  floor = Math.floor;
  isItNaN = function(x2) {
    return x2 !== x2;
  };
  even = function(x2) {
    return x2 % 2 === 0;
  };
  odd = function(x2) {
    return x2 % 2 !== 0;
  };
  gcd = curry$(function(x2, y2) {
    var z;
    x2 = Math.abs(x2);
    y2 = Math.abs(y2);
    while (y2 !== 0) {
      z = x2 % y2;
      x2 = y2;
      y2 = z;
    }
    return x2;
  });
  lcm = curry$(function(x2, y2) {
    return Math.abs(Math.floor(x2 / gcd(x2, y2) * y2));
  });
  Num = {
    max,
    min,
    negate,
    abs,
    signum,
    quot,
    rem,
    div,
    mod,
    recip,
    pi,
    tau,
    exp,
    sqrt,
    ln,
    pow,
    sin,
    tan,
    cos,
    acos,
    asin,
    atan,
    atan2,
    truncate,
    round,
    ceiling,
    floor,
    isItNaN,
    even,
    odd,
    gcd,
    lcm
  };
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  return Num;
}
var lib$1;
var hasRequiredLib$2;
function requireLib$2() {
  if (hasRequiredLib$2) return lib$1;
  hasRequiredLib$2 = 1;
  var Func2, List2, Obj2, Str2, Num2, id2, isType, replicate, prelude, toString$ = {}.toString;
  Func2 = requireFunc();
  List2 = requireList();
  Obj2 = requireObj();
  Str2 = requireStr();
  Num2 = requireNum();
  id2 = function(x2) {
    return x2;
  };
  isType = curry$(function(type2, x2) {
    return toString$.call(x2).slice(8, -1) === type2;
  });
  replicate = curry$(function(n2, x2) {
    var i$, results$ = [];
    for (i$ = 0; i$ < n2; ++i$) {
      results$.push(x2);
    }
    return results$;
  });
  Str2.empty = List2.empty;
  Str2.slice = List2.slice;
  Str2.take = List2.take;
  Str2.drop = List2.drop;
  Str2.splitAt = List2.splitAt;
  Str2.takeWhile = List2.takeWhile;
  Str2.dropWhile = List2.dropWhile;
  Str2.span = List2.span;
  Str2.breakStr = List2.breakList;
  prelude = {
    Func: Func2,
    List: List2,
    Obj: Obj2,
    Str: Str2,
    Num: Num2,
    id: id2,
    isType,
    replicate
  };
  prelude.each = List2.each;
  prelude.map = List2.map;
  prelude.filter = List2.filter;
  prelude.compact = List2.compact;
  prelude.reject = List2.reject;
  prelude.partition = List2.partition;
  prelude.find = List2.find;
  prelude.head = List2.head;
  prelude.first = List2.first;
  prelude.tail = List2.tail;
  prelude.last = List2.last;
  prelude.initial = List2.initial;
  prelude.empty = List2.empty;
  prelude.reverse = List2.reverse;
  prelude.difference = List2.difference;
  prelude.intersection = List2.intersection;
  prelude.union = List2.union;
  prelude.countBy = List2.countBy;
  prelude.groupBy = List2.groupBy;
  prelude.fold = List2.fold;
  prelude.foldl = List2.foldl;
  prelude.fold1 = List2.fold1;
  prelude.foldl1 = List2.foldl1;
  prelude.foldr = List2.foldr;
  prelude.foldr1 = List2.foldr1;
  prelude.unfoldr = List2.unfoldr;
  prelude.andList = List2.andList;
  prelude.orList = List2.orList;
  prelude.any = List2.any;
  prelude.all = List2.all;
  prelude.unique = List2.unique;
  prelude.uniqueBy = List2.uniqueBy;
  prelude.sort = List2.sort;
  prelude.sortWith = List2.sortWith;
  prelude.sortBy = List2.sortBy;
  prelude.sum = List2.sum;
  prelude.product = List2.product;
  prelude.mean = List2.mean;
  prelude.average = List2.average;
  prelude.concat = List2.concat;
  prelude.concatMap = List2.concatMap;
  prelude.flatten = List2.flatten;
  prelude.maximum = List2.maximum;
  prelude.minimum = List2.minimum;
  prelude.maximumBy = List2.maximumBy;
  prelude.minimumBy = List2.minimumBy;
  prelude.scan = List2.scan;
  prelude.scanl = List2.scanl;
  prelude.scan1 = List2.scan1;
  prelude.scanl1 = List2.scanl1;
  prelude.scanr = List2.scanr;
  prelude.scanr1 = List2.scanr1;
  prelude.slice = List2.slice;
  prelude.take = List2.take;
  prelude.drop = List2.drop;
  prelude.splitAt = List2.splitAt;
  prelude.takeWhile = List2.takeWhile;
  prelude.dropWhile = List2.dropWhile;
  prelude.span = List2.span;
  prelude.breakList = List2.breakList;
  prelude.zip = List2.zip;
  prelude.zipWith = List2.zipWith;
  prelude.zipAll = List2.zipAll;
  prelude.zipAllWith = List2.zipAllWith;
  prelude.at = List2.at;
  prelude.elemIndex = List2.elemIndex;
  prelude.elemIndices = List2.elemIndices;
  prelude.findIndex = List2.findIndex;
  prelude.findIndices = List2.findIndices;
  prelude.apply = Func2.apply;
  prelude.curry = Func2.curry;
  prelude.flip = Func2.flip;
  prelude.fix = Func2.fix;
  prelude.over = Func2.over;
  prelude.split = Str2.split;
  prelude.join = Str2.join;
  prelude.lines = Str2.lines;
  prelude.unlines = Str2.unlines;
  prelude.words = Str2.words;
  prelude.unwords = Str2.unwords;
  prelude.chars = Str2.chars;
  prelude.unchars = Str2.unchars;
  prelude.repeat = Str2.repeat;
  prelude.capitalize = Str2.capitalize;
  prelude.camelize = Str2.camelize;
  prelude.dasherize = Str2.dasherize;
  prelude.values = Obj2.values;
  prelude.keys = Obj2.keys;
  prelude.pairsToObj = Obj2.pairsToObj;
  prelude.objToPairs = Obj2.objToPairs;
  prelude.listsToObj = Obj2.listsToObj;
  prelude.objToLists = Obj2.objToLists;
  prelude.max = Num2.max;
  prelude.min = Num2.min;
  prelude.negate = Num2.negate;
  prelude.abs = Num2.abs;
  prelude.signum = Num2.signum;
  prelude.quot = Num2.quot;
  prelude.rem = Num2.rem;
  prelude.div = Num2.div;
  prelude.mod = Num2.mod;
  prelude.recip = Num2.recip;
  prelude.pi = Num2.pi;
  prelude.tau = Num2.tau;
  prelude.exp = Num2.exp;
  prelude.sqrt = Num2.sqrt;
  prelude.ln = Num2.ln;
  prelude.pow = Num2.pow;
  prelude.sin = Num2.sin;
  prelude.tan = Num2.tan;
  prelude.cos = Num2.cos;
  prelude.acos = Num2.acos;
  prelude.asin = Num2.asin;
  prelude.atan = Num2.atan;
  prelude.atan2 = Num2.atan2;
  prelude.truncate = Num2.truncate;
  prelude.round = Num2.round;
  prelude.ceiling = Num2.ceiling;
  prelude.floor = Num2.floor;
  prelude.isItNaN = Num2.isItNaN;
  prelude.even = Num2.even;
  prelude.odd = Num2.odd;
  prelude.gcd = Num2.gcd;
  prelude.lcm = Num2.lcm;
  prelude.VERSION = "1.2.1";
  lib$1 = prelude;
  function curry$(f2, bound) {
    var context, _curry = function(args) {
      return f2.length > 1 ? function() {
        var params = args ? args.concat() : [];
        context = this;
        return params.push.apply(params, arguments) < f2.length && arguments.length ? _curry.call(context, params) : f2.apply(context, params);
      } : f2;
    };
    return _curry();
  }
  return lib$1;
}
var hasRequiredParseString;
function requireParseString() {
  if (hasRequiredParseString) return parseString.exports;
  hasRequiredParseString = 1;
  (function() {
    var reject, special, tokenRegex;
    reject = requireLib$2().reject;
    function consumeOp(tokens, op) {
      if (tokens[0] === op) {
        return tokens.shift();
      } else {
        throw new Error("Expected '" + op + "', but got '" + tokens[0] + "' instead in " + JSON.stringify(tokens) + ".");
      }
    }
    function maybeConsumeOp(tokens, op) {
      if (tokens[0] === op) {
        return tokens.shift();
      }
    }
    function consumeList(tokens, arg$, hasDelimiters) {
      var open, close, result, untilTest;
      open = arg$[0], close = arg$[1];
      if (hasDelimiters) {
        consumeOp(tokens, open);
      }
      result = [];
      untilTest = "," + (hasDelimiters ? close : "");
      while (tokens.length && (hasDelimiters && tokens[0] !== close)) {
        result.push(consumeElement(tokens, untilTest));
        maybeConsumeOp(tokens, ",");
      }
      if (hasDelimiters) {
        consumeOp(tokens, close);
      }
      return result;
    }
    function consumeArray(tokens, hasDelimiters) {
      return consumeList(tokens, ["[", "]"], hasDelimiters);
    }
    function consumeTuple(tokens, hasDelimiters) {
      return consumeList(tokens, ["(", ")"], hasDelimiters);
    }
    function consumeFields(tokens, hasDelimiters) {
      var result, untilTest, key;
      if (hasDelimiters) {
        consumeOp(tokens, "{");
      }
      result = {};
      untilTest = "," + (hasDelimiters ? "}" : "");
      while (tokens.length && (!hasDelimiters || tokens[0] !== "}")) {
        key = consumeValue(tokens, ":");
        consumeOp(tokens, ":");
        result[key] = consumeElement(tokens, untilTest);
        maybeConsumeOp(tokens, ",");
      }
      if (hasDelimiters) {
        consumeOp(tokens, "}");
      }
      return result;
    }
    function consumeValue(tokens, untilTest) {
      var out;
      untilTest == null && (untilTest = "");
      out = "";
      while (tokens.length && -1 === untilTest.indexOf(tokens[0])) {
        out += tokens.shift();
      }
      return out;
    }
    function consumeElement(tokens, untilTest) {
      switch (tokens[0]) {
        case "[":
          return consumeArray(tokens, true);
        case "(":
          return consumeTuple(tokens, true);
        case "{":
          return consumeFields(tokens, true);
        default:
          return consumeValue(tokens, untilTest);
      }
    }
    function consumeTopLevel(tokens, types, options) {
      var ref$, type2, structure, origTokens, result, finalResult, x$, y$;
      ref$ = types[0], type2 = ref$.type, structure = ref$.structure;
      origTokens = tokens.concat();
      if (!options.explicit && types.length === 1 && (!type2 && structure || (type2 === "Array" || type2 === "Object"))) {
        result = structure === "array" || type2 === "Array" ? consumeArray(tokens, tokens[0] === "[") : structure === "tuple" ? consumeTuple(tokens, tokens[0] === "(") : consumeFields(tokens, tokens[0] === "{");
        finalResult = tokens.length ? consumeElement(structure === "array" || type2 === "Array" ? (x$ = origTokens, x$.unshift("["), x$.push("]"), x$) : (y$ = origTokens, y$.unshift("("), y$.push(")"), y$)) : result;
      } else {
        finalResult = consumeElement(tokens);
      }
      return finalResult;
    }
    special = /\[\]\(\)}{:,/.source;
    tokenRegex = RegExp(`("(?:\\\\"|[^"])*")|('(?:\\\\'|[^'])*')|(/(?:\\\\/|[^/])*/[a-zA-Z]*)|(#.*#)|([` + special + "])|([^\\s" + special + "](?:\\s*[^\\s" + special + "]+)*)|\\s*");
    parseString.exports = function(types, string, options) {
      var tokens, node2;
      options == null && (options = {});
      if (!options.explicit && types.length === 1 && types[0].type === "String") {
        return string;
      }
      tokens = reject(not$, string.split(tokenRegex));
      node2 = consumeTopLevel(tokens, types, options);
      if (!node2) {
        throw new Error("Error parsing '" + string + "'.");
      }
      return node2;
    };
    function not$(x2) {
      return !x2;
    }
  }).call(this);
  return parseString.exports;
}
var cast = { exports: {} };
var lib = { exports: {} };
var parseType = { exports: {} };
var hasRequiredParseType;
function requireParseType() {
  if (hasRequiredParseType) return parseType.exports;
  hasRequiredParseType = 1;
  (function() {
    var identifierRegex, tokenRegex;
    identifierRegex = /[\$\w]+/;
    function peek(tokens) {
      var token;
      token = tokens[0];
      if (token == null) {
        throw new Error("Unexpected end of input.");
      }
      return token;
    }
    function consumeIdent(tokens) {
      var token;
      token = peek(tokens);
      if (!identifierRegex.test(token)) {
        throw new Error("Expected text, got '" + token + "' instead.");
      }
      return tokens.shift();
    }
    function consumeOp(tokens, op) {
      var token;
      token = peek(tokens);
      if (token !== op) {
        throw new Error("Expected '" + op + "', got '" + token + "' instead.");
      }
      return tokens.shift();
    }
    function maybeConsumeOp(tokens, op) {
      var token;
      token = tokens[0];
      if (token === op) {
        return tokens.shift();
      } else {
        return null;
      }
    }
    function consumeArray(tokens) {
      var types;
      consumeOp(tokens, "[");
      if (peek(tokens) === "]") {
        throw new Error("Must specify type of Array - eg. [Type], got [] instead.");
      }
      types = consumeTypes(tokens);
      consumeOp(tokens, "]");
      return {
        structure: "array",
        of: types
      };
    }
    function consumeTuple(tokens) {
      var components;
      components = [];
      consumeOp(tokens, "(");
      if (peek(tokens) === ")") {
        throw new Error("Tuple must be of at least length 1 - eg. (Type), got () instead.");
      }
      for (; ; ) {
        components.push(consumeTypes(tokens));
        maybeConsumeOp(tokens, ",");
        if (")" === peek(tokens)) {
          break;
        }
      }
      consumeOp(tokens, ")");
      return {
        structure: "tuple",
        of: components
      };
    }
    function consumeFields(tokens) {
      var fields, subset, ref$, key, types;
      fields = {};
      consumeOp(tokens, "{");
      subset = false;
      for (; ; ) {
        if (maybeConsumeOp(tokens, "...")) {
          subset = true;
          break;
        }
        ref$ = consumeField(tokens), key = ref$[0], types = ref$[1];
        fields[key] = types;
        maybeConsumeOp(tokens, ",");
        if ("}" === peek(tokens)) {
          break;
        }
      }
      consumeOp(tokens, "}");
      return {
        structure: "fields",
        of: fields,
        subset
      };
    }
    function consumeField(tokens) {
      var key, types;
      key = consumeIdent(tokens);
      consumeOp(tokens, ":");
      types = consumeTypes(tokens);
      return [key, types];
    }
    function maybeConsumeStructure(tokens) {
      switch (tokens[0]) {
        case "[":
          return consumeArray(tokens);
        case "(":
          return consumeTuple(tokens);
        case "{":
          return consumeFields(tokens);
      }
    }
    function consumeType(tokens) {
      var token, wildcard, type2, structure;
      token = peek(tokens);
      wildcard = token === "*";
      if (wildcard || identifierRegex.test(token)) {
        type2 = wildcard ? consumeOp(tokens, "*") : consumeIdent(tokens);
        structure = maybeConsumeStructure(tokens);
        if (structure) {
          return structure.type = type2, structure;
        } else {
          return {
            type: type2
          };
        }
      } else {
        structure = maybeConsumeStructure(tokens);
        if (!structure) {
          throw new Error("Unexpected character: " + token);
        }
        return structure;
      }
    }
    function consumeTypes(tokens) {
      var lookahead, types, typesSoFar, typeObj, type2, structure;
      if ("::" === peek(tokens)) {
        throw new Error("No comment before comment separator '::' found.");
      }
      lookahead = tokens[1];
      if (lookahead != null && lookahead === "::") {
        tokens.shift();
        tokens.shift();
      }
      types = [];
      typesSoFar = {};
      if ("Maybe" === peek(tokens)) {
        tokens.shift();
        types = [
          {
            type: "Undefined"
          },
          {
            type: "Null"
          }
        ];
        typesSoFar = {
          Undefined: true,
          Null: true
        };
      }
      for (; ; ) {
        typeObj = consumeType(tokens), type2 = typeObj.type, structure = typeObj.structure;
        if (!typesSoFar[type2]) {
          types.push(typeObj);
        }
        if (structure == null) {
          typesSoFar[type2] = true;
        }
        if (!maybeConsumeOp(tokens, "|")) {
          break;
        }
      }
      return types;
    }
    tokenRegex = RegExp("\\.\\.\\.|::|->|" + identifierRegex.source + "|\\S", "g");
    parseType.exports = function(input) {
      var tokens, e2;
      if (!input.length) {
        throw new Error("No type specified.");
      }
      tokens = input.match(tokenRegex) || [];
      if (in$("->", tokens)) {
        throw new Error("Function types are not supported. To validate that something is a function, you may use 'Function'.");
      }
      try {
        return consumeTypes(tokens);
      } catch (e$) {
        e2 = e$;
        throw new Error(e2.message + " - Remaining tokens: " + JSON.stringify(tokens) + " - Initial input: '" + input + "'");
      }
    };
    function in$(x2, xs) {
      var i2 = -1, l2 = xs.length >>> 0;
      while (++i2 < l2) if (x2 === xs[i2]) return true;
      return false;
    }
  }).call(this);
  return parseType.exports;
}
var check = { exports: {} };
var hasRequiredCheck;
function requireCheck() {
  if (hasRequiredCheck) return check.exports;
  hasRequiredCheck = 1;
  (function() {
    var ref$, any, all, isItNaN, types, defaultType, toString$ = {}.toString;
    ref$ = requireLib$2(), any = ref$.any, all = ref$.all, isItNaN = ref$.isItNaN;
    types = {
      Number: {
        typeOf: "Number",
        validate: function(it) {
          return !isItNaN(it);
        }
      },
      NaN: {
        typeOf: "Number",
        validate: isItNaN
      },
      Int: {
        typeOf: "Number",
        validate: function(it) {
          return !isItNaN(it) && it % 1 === 0;
        }
      },
      Float: {
        typeOf: "Number",
        validate: function(it) {
          return !isItNaN(it);
        }
      },
      Date: {
        typeOf: "Date",
        validate: function(it) {
          return !isItNaN(it.getTime());
        }
      }
    };
    defaultType = {
      array: "Array",
      tuple: "Array"
    };
    function checkArray(input, type2, options) {
      return all(function(it) {
        return checkMultiple(it, type2.of, options);
      }, input);
    }
    function checkTuple(input, type2, options) {
      var i2, i$, ref$2, len$, types2;
      i2 = 0;
      for (i$ = 0, len$ = (ref$2 = type2.of).length; i$ < len$; ++i$) {
        types2 = ref$2[i$];
        if (!checkMultiple(input[i2], types2, options)) {
          return false;
        }
        i2++;
      }
      return input.length <= i2;
    }
    function checkFields(input, type2, options) {
      var inputKeys, numInputKeys, k, numOfKeys, key, ref$2, types2;
      inputKeys = {};
      numInputKeys = 0;
      for (k in input) {
        inputKeys[k] = true;
        numInputKeys++;
      }
      numOfKeys = 0;
      for (key in ref$2 = type2.of) {
        types2 = ref$2[key];
        if (!checkMultiple(input[key], types2, options)) {
          return false;
        }
        if (inputKeys[key]) {
          numOfKeys++;
        }
      }
      return type2.subset || numInputKeys === numOfKeys;
    }
    function checkStructure(input, type2, options) {
      if (!(input instanceof Object)) {
        return false;
      }
      switch (type2.structure) {
        case "fields":
          return checkFields(input, type2, options);
        case "array":
          return checkArray(input, type2, options);
        case "tuple":
          return checkTuple(input, type2, options);
      }
    }
    function check$1(input, typeObj, options) {
      var type2, structure, setting, that;
      type2 = typeObj.type, structure = typeObj.structure;
      if (type2) {
        if (type2 === "*") {
          return true;
        }
        setting = options.customTypes[type2] || types[type2];
        if (setting) {
          return (setting.typeOf === void 0 || setting.typeOf === toString$.call(input).slice(8, -1)) && setting.validate(input);
        } else {
          return type2 === toString$.call(input).slice(8, -1) && (!structure || checkStructure(input, typeObj, options));
        }
      } else if (structure) {
        if (that = defaultType[structure]) {
          if (that !== toString$.call(input).slice(8, -1)) {
            return false;
          }
        }
        return checkStructure(input, typeObj, options);
      } else {
        throw new Error("No type defined. Input: " + input + ".");
      }
    }
    function checkMultiple(input, types2, options) {
      if (toString$.call(types2).slice(8, -1) !== "Array") {
        throw new Error("Types must be in an array. Input: " + input + ".");
      }
      return any(function(it) {
        return check$1(input, it, options);
      }, types2);
    }
    check.exports = function(parsedType, input, options) {
      options == null && (options = {});
      if (options.customTypes == null) {
        options.customTypes = {};
      }
      return checkMultiple(input, parsedType, options);
    };
  }).call(this);
  return check.exports;
}
var hasRequiredLib$1;
function requireLib$1() {
  if (hasRequiredLib$1) return lib.exports;
  hasRequiredLib$1 = 1;
  (function() {
    var VERSION, parseType2, parsedTypeCheck, typeCheck;
    VERSION = "0.4.0";
    parseType2 = requireParseType();
    parsedTypeCheck = requireCheck();
    typeCheck = function(type2, input, options) {
      return parsedTypeCheck(parseType2(type2), input, options);
    };
    lib.exports = {
      VERSION,
      typeCheck,
      parsedTypeCheck,
      parseType: parseType2
    };
  }).call(this);
  return lib.exports;
}
var hasRequiredCast;
function requireCast() {
  if (hasRequiredCast) return cast.exports;
  hasRequiredCast = 1;
  (function() {
    var parsedTypeCheck, types, toString$ = {}.toString;
    parsedTypeCheck = requireLib$1().parsedTypeCheck;
    types = {
      "*": function(value, options) {
        switch (toString$.call(value).slice(8, -1)) {
          case "Array":
            return typeCast(value, {
              type: "Array"
            }, options);
          case "Object":
            return typeCast(value, {
              type: "Object"
            }, options);
          default:
            return {
              type: "Just",
              value: typesCast(value, [
                {
                  type: "Undefined"
                },
                {
                  type: "Null"
                },
                {
                  type: "NaN"
                },
                {
                  type: "Boolean"
                },
                {
                  type: "Number"
                },
                {
                  type: "Date"
                },
                {
                  type: "RegExp"
                },
                {
                  type: "Array"
                },
                {
                  type: "Object"
                },
                {
                  type: "String"
                }
              ], (options.explicit = true, options))
            };
        }
      },
      Undefined: function(it) {
        if (it === "undefined" || it === void 0) {
          return {
            type: "Just",
            value: void 0
          };
        } else {
          return {
            type: "Nothing"
          };
        }
      },
      Null: function(it) {
        if (it === "null") {
          return {
            type: "Just",
            value: null
          };
        } else {
          return {
            type: "Nothing"
          };
        }
      },
      NaN: function(it) {
        if (it === "NaN") {
          return {
            type: "Just",
            value: NaN
          };
        } else {
          return {
            type: "Nothing"
          };
        }
      },
      Boolean: function(it) {
        if (it === "true") {
          return {
            type: "Just",
            value: true
          };
        } else if (it === "false") {
          return {
            type: "Just",
            value: false
          };
        } else {
          return {
            type: "Nothing"
          };
        }
      },
      Number: function(it) {
        return {
          type: "Just",
          value: +it
        };
      },
      Int: function(it) {
        return {
          type: "Just",
          value: +it
        };
      },
      Float: function(it) {
        return {
          type: "Just",
          value: +it
        };
      },
      Date: function(value, options) {
        var that;
        if (that = /^\#([\s\S]*)\#$/.exec(value)) {
          return {
            type: "Just",
            value: new Date(+that[1] || that[1])
          };
        } else if (options.explicit) {
          return {
            type: "Nothing"
          };
        } else {
          return {
            type: "Just",
            value: new Date(+value || value)
          };
        }
      },
      RegExp: function(value, options) {
        var that;
        if (that = /^\/([\s\S]*)\/([gimy]*)$/.exec(value)) {
          return {
            type: "Just",
            value: new RegExp(that[1], that[2])
          };
        } else if (options.explicit) {
          return {
            type: "Nothing"
          };
        } else {
          return {
            type: "Just",
            value: new RegExp(value)
          };
        }
      },
      Array: function(value, options) {
        return castArray(value, {
          of: [{
            type: "*"
          }]
        }, options);
      },
      Object: function(value, options) {
        return castFields(value, {
          of: {}
        }, options);
      },
      String: function(it) {
        var replace, that;
        if (toString$.call(it).slice(8, -1) !== "String") {
          return {
            type: "Nothing"
          };
        }
        replace = function(value, quote) {
          return value.replace(/\\([^u]|u[0-9a-fA-F]{4})/g, function(all, escaped) {
            switch (escaped[0]) {
              case quote:
                return quote;
              case "\\":
                return "\\";
              case "b":
                return "\b";
              case "f":
                return "\f";
              case "n":
                return "\n";
              case "r":
                return "\r";
              case "t":
                return "	";
              case "u":
                return JSON.parse('"' + all + '"');
              default:
                return escaped;
            }
          });
        };
        if (that = it.match(/^'([\s\S]*)'$/)) {
          return {
            type: "Just",
            value: replace(that[1], "'")
          };
        } else if (that = it.match(/^"([\s\S]*)"$/)) {
          return {
            type: "Just",
            value: replace(that[1], '"')
          };
        } else {
          return {
            type: "Just",
            value: it
          };
        }
      }
    };
    function castArray(node2, type2, options) {
      var typeOf, element;
      if (toString$.call(node2).slice(8, -1) !== "Array") {
        return {
          type: "Nothing"
        };
      }
      typeOf = type2.of;
      return {
        type: "Just",
        value: (function() {
          var i$, ref$, len$, results$ = [];
          for (i$ = 0, len$ = (ref$ = node2).length; i$ < len$; ++i$) {
            element = ref$[i$];
            results$.push(typesCast(element, typeOf, options));
          }
          return results$;
        })()
      };
    }
    function castTuple(node2, type2, options) {
      var result, i2, i$, ref$, len$, types2, cast2;
      if (toString$.call(node2).slice(8, -1) !== "Array") {
        return {
          type: "Nothing"
        };
      }
      result = [];
      i2 = 0;
      for (i$ = 0, len$ = (ref$ = type2.of).length; i$ < len$; ++i$) {
        types2 = ref$[i$];
        cast2 = typesCast(node2[i2], types2, options);
        if (toString$.call(cast2).slice(8, -1) !== "Undefined") {
          result.push(cast2);
        }
        i2++;
      }
      if (node2.length <= i2) {
        return {
          type: "Just",
          value: result
        };
      } else {
        return {
          type: "Nothing"
        };
      }
    }
    function castFields(node2, type2, options) {
      var typeOf, key, value;
      if (toString$.call(node2).slice(8, -1) !== "Object") {
        return {
          type: "Nothing"
        };
      }
      typeOf = type2.of;
      return {
        type: "Just",
        value: (function() {
          var ref$, resultObj$ = {};
          for (key in ref$ = node2) {
            value = ref$[key];
            resultObj$[typesCast(key, [{
              type: "String"
            }], options)] = typesCast(value, typeOf[key] || [{
              type: "*"
            }], options);
          }
          return resultObj$;
        })()
      };
    }
    function typeCast(node2, typeObj, options) {
      var type2, structure, castFunc, ref$;
      type2 = typeObj.type, structure = typeObj.structure;
      if (type2) {
        castFunc = ((ref$ = options.customTypes[type2]) != null ? ref$.cast : void 0) || types[type2];
        if (!castFunc) {
          throw new Error("Type not defined: " + type2 + ".");
        }
        return castFunc(node2, options, typesCast);
      } else {
        switch (structure) {
          case "array":
            return castArray(node2, typeObj, options);
          case "tuple":
            return castTuple(node2, typeObj, options);
          case "fields":
            return castFields(node2, typeObj, options);
        }
      }
    }
    function typesCast(node2, types2, options) {
      var i$, len$, type2, ref$, valueType, value;
      for (i$ = 0, len$ = types2.length; i$ < len$; ++i$) {
        type2 = types2[i$];
        ref$ = typeCast(node2, type2, options), valueType = ref$.type, value = ref$.value;
        if (valueType === "Nothing") {
          continue;
        }
        if (parsedTypeCheck([type2], value, {
          customTypes: options.customTypes
        })) {
          return value;
        }
      }
      throw new Error("Value " + JSON.stringify(node2) + " does not type check against " + JSON.stringify(types2) + ".");
    }
    cast.exports = function(node2, types2, options) {
      if (!options.explicit && types2.length === 1 && types2[0].type === "String") {
        return node2;
      }
      return typesCast(node2, types2, options);
    };
  }).call(this);
  return cast.exports;
}
var hasRequiredLib;
function requireLib() {
  if (hasRequiredLib) return lib$2.exports;
  hasRequiredLib = 1;
  (function() {
    var parseString2, cast2, parseType2, VERSION, parsedTypeParse, parse;
    parseString2 = requireParseString();
    cast2 = requireCast();
    parseType2 = requireLib$1().parseType;
    VERSION = "0.4.1";
    parsedTypeParse = function(parsedType, string, options) {
      options == null && (options = {});
      options.explicit == null && (options.explicit = false);
      options.customTypes == null && (options.customTypes = {});
      return cast2(parseString2(parsedType, string, options), parsedType, options);
    };
    parse = function(type2, string, options) {
      return parsedTypeParse(parseType2(type2), string, options);
    };
    lib$2.exports = {
      VERSION,
      parse,
      parsedTypeParse
    };
  }).call(this);
  return lib$2.exports;
}
var hasRequiredCjs$2;
function requireCjs$2() {
  if (hasRequiredCjs$2) return cjs$2;
  hasRequiredCjs$2 = 1;
  var levn = requireLib();
  const directivesPattern = /^([a-z]+(?:-[a-z]+)*)(?:\s|$)/u;
  const validSeverities = /* @__PURE__ */ new Set([0, 1, 2, "off", "warn", "error"]);
  function isSeverityValid(ruleConfig) {
    const severity2 = Array.isArray(ruleConfig) ? ruleConfig[0] : ruleConfig;
    return validSeverities.has(severity2);
  }
  function isEverySeverityValid(rulesConfig) {
    return Object.values(rulesConfig).every(isSeverityValid);
  }
  class DirectiveComment {
    /**
     * The label of the directive, such as "eslint", "eslint-disable", etc.
     * @type {string}
     */
    label = "";
    /**
     * The value of the directive (the string after the label).
     * @type {string}
     */
    value = "";
    /**
     * The justification of the directive (the string after the --).
     * @type {string}
     */
    justification = "";
    /**
     * Creates a new directive comment.
     * @param {string} label The label of the directive.
     * @param {string} value The value of the directive.
     * @param {string} justification The justification of the directive.
     */
    constructor(label, value, justification) {
      this.label = label;
      this.value = value;
      this.justification = justification;
    }
  }
  class ConfigCommentParser {
    /**
     * Parses a list of "name:string_value" or/and "name" options divided by comma or
     * whitespace. Used for "global" comments.
     * @param {string} string The string to parse.
     * @returns {StringConfig} Result map object of names and string values, or null values if no value was provided.
     */
    parseStringConfig(string) {
      const items2 = (
        /** @type {StringConfig} */
        {}
      );
      const trimmedString = string.trim().replace(new RegExp("(?<!\\s)\\s*([:,])\\s*", "gu"), "$1");
      trimmedString.split(/\s|,+/u).forEach((name) => {
        if (!name) {
          return;
        }
        const [key, value = null] = name.split(":");
        items2[key] = value;
      });
      return items2;
    }
    /**
     * Parses a JSON-like config.
     * @param {string} string The string to parse.
     * @returns {({ok: true, config: RulesConfig}|{ok: false, error: {message: string}})} Result map object
     */
    parseJSONLikeConfig(string) {
      try {
        const items2 = (
          /** @type {RulesConfig} */
          levn.parse("Object", string) || {}
        );
        if (isEverySeverityValid(items2)) {
          return {
            ok: true,
            config: items2
          };
        }
      } catch {
      }
      const normalizedString = string.replace(new RegExp("(?<![-a-zA-Z0-9/])([-a-zA-Z0-9/]+):", "gu"), '"$1":').replace(/([\]0-9])\s+(?=")/u, "$1,");
      try {
        const items2 = JSON.parse(`{${normalizedString}}`);
        return {
          ok: true,
          config: items2
        };
      } catch (ex) {
        const errorMessage = ex instanceof Error ? ex.message : String(ex);
        return {
          ok: false,
          error: {
            message: `Failed to parse JSON from '${normalizedString}': ${errorMessage}`
          }
        };
      }
    }
    /**
     * Parses a config of values separated by comma.
     * @param {string} string The string to parse.
     * @returns {BooleanConfig} Result map of values and true values
     */
    parseListConfig(string) {
      const items2 = (
        /** @type {BooleanConfig} */
        {}
      );
      string.split(",").forEach((name) => {
        const trimmedName = name.trim().replace(
          /^(?<quote>['"]?)(?<ruleId>.*)\k<quote>$/su,
          "$<ruleId>"
        );
        if (trimmedName) {
          items2[trimmedName] = true;
        }
      });
      return items2;
    }
    /**
     * Extract the directive and the justification from a given directive comment and trim them.
     * @param {string} value The comment text to extract.
     * @returns {{directivePart: string, justificationPart: string}} The extracted directive and justification.
     */
    #extractDirectiveComment(value) {
      const match = /\s-{2,}\s/u.exec(value);
      if (!match) {
        return { directivePart: value.trim(), justificationPart: "" };
      }
      const directive = value.slice(0, match.index).trim();
      const justification = value.slice(match.index + match[0].length).trim();
      return { directivePart: directive, justificationPart: justification };
    }
    /**
     * Parses a directive comment into directive text and value.
     * @param {string} string The string with the directive to be parsed.
     * @returns {DirectiveComment|undefined} The parsed directive or `undefined` if the directive is invalid.
     */
    parseDirective(string) {
      const { directivePart, justificationPart } = this.#extractDirectiveComment(string);
      const match = directivesPattern.exec(directivePart);
      if (!match) {
        return void 0;
      }
      const directiveText = match[1];
      const directiveValue = directivePart.slice(
        match.index + directiveText.length
      );
      return new DirectiveComment(
        directiveText,
        directiveValue.trim(),
        justificationPart
      );
    }
  }
  function hasESTreeStyleLoc(node2) {
    return "loc" in node2;
  }
  function hasPosStyleLoc(node2) {
    return "position" in node2;
  }
  function hasESTreeStyleRange(node2) {
    return "range" in node2;
  }
  function hasPosStyleRange(node2) {
    return "position" in node2;
  }
  function findLineNumberBinarySearch(lineStartIndices, targetIndex) {
    let low = 0;
    let high = lineStartIndices.length - 1;
    while (low < high) {
      const mid = (low + high) / 2 | 0;
      if (targetIndex < lineStartIndices[mid]) {
        high = mid;
      } else {
        low = mid + 1;
      }
    }
    return low;
  }
  class VisitNodeStep {
    /**
     * The type of the step.
     * @type {"visit"}
     * @readonly
     */
    type = "visit";
    /**
     * The kind of the step. Represents the same data as the `type` property
     * but it's a number for performance.
     * @type {1}
     * @readonly
     */
    kind = 1;
    /**
     * The target of the step.
     * @type {object}
     */
    target;
    /**
     * The phase of the step.
     * @type {1|2}
     */
    phase;
    /**
     * The arguments of the step.
     * @type {Array<any>}
     */
    args;
    /**
     * Creates a new instance.
     * @param {Object} options The options for the step.
     * @param {object} options.target The target of the step.
     * @param {1|2} options.phase The phase of the step.
     * @param {Array<any>} options.args The arguments of the step.
     */
    constructor({ target, phase, args }) {
      this.target = target;
      this.phase = phase;
      this.args = args;
    }
  }
  class CallMethodStep {
    /**
     * The type of the step.
     * @type {"call"}
     * @readonly
     */
    type = "call";
    /**
     * The kind of the step. Represents the same data as the `type` property
     * but it's a number for performance.
     * @type {2}
     * @readonly
     */
    kind = 2;
    /**
     * The name of the method to call.
     * @type {string}
     */
    target;
    /**
     * The arguments to pass to the method.
     * @type {Array<any>}
     */
    args;
    /**
     * Creates a new instance.
     * @param {Object} options The options for the step.
     * @param {string} options.target The target of the step.
     * @param {Array<any>} options.args The arguments of the step.
     */
    constructor({ target, args }) {
      this.target = target;
      this.args = args;
    }
  }
  class Directive {
    /**
     * The type of directive.
     * @type {DirectiveType}
     * @readonly
     */
    type;
    /**
     * The node representing the directive.
     * @type {unknown}
     * @readonly
     */
    node;
    /**
     * Everything after the "eslint-disable" portion of the directive,
     * but before the "--" that indicates the justification.
     * @type {string}
     * @readonly
     */
    value;
    /**
     * The justification for the directive.
     * @type {string}
     * @readonly
     */
    justification;
    /**
     * Creates a new instance.
     * @param {Object} options The options for the directive.
     * @param {"disable"|"enable"|"disable-next-line"|"disable-line"} options.type The type of directive.
     * @param {unknown} options.node The node representing the directive.
     * @param {string} options.value The value of the directive.
     * @param {string} options.justification The justification for the directive.
     */
    constructor({ type: type2, node: node2, value, justification }) {
      this.type = type2;
      this.node = node2;
      this.value = value;
      this.justification = justification;
    }
  }
  class TextSourceCodeBase {
    /**
     * The lines of text in the source code.
     * @type {Array<string>}
     */
    #lines = [];
    /**
     * The indices of the start of each line in the source code.
     * @type {Array<number>}
     */
    #lineStartIndices = [0];
    /**
     * The pattern to match lineEndings in the source code.
     * @type {RegExp}
     */
    #lineEndingPattern;
    /**
     * The AST of the source code.
     * @type {Options['RootNode']}
     */
    ast;
    /**
     * The text of the source code.
     * @type {string}
     */
    text;
    /**
     * Creates a new instance.
     * @param {Object} options The options for the instance.
     * @param {string} options.text The source code text.
     * @param {Options['RootNode']} options.ast The root AST node.
     * @param {RegExp} [options.lineEndingPattern] The pattern to match lineEndings in the source code. Defaults to `/\r?\n/u`.
     */
    constructor({ text, ast: ast2, lineEndingPattern = /\r?\n/u }) {
      this.ast = ast2;
      this.text = text;
      this.#lineEndingPattern = new RegExp(
        lineEndingPattern.source,
        lineEndingPattern.flags.replace(/[gy]/gu, "")
      );
    }
    /**
     * Finds the next line in the source text and updates `#lines` and `#lineStartIndices`.
     * @param {string} text The text to search for the next line.
     * @returns {boolean} `true` if a next line was found, `false` otherwise.
     */
    #findNextLine(text) {
      const match = this.#lineEndingPattern.exec(text);
      if (!match) {
        return false;
      }
      this.#lines.push(text.slice(0, match.index));
      this.#lineStartIndices.push(
        (this.#lineStartIndices.at(-1) ?? 0) + match.index + match[0].length
      );
      return true;
    }
    /**
     * Ensures `#lines` is lazily calculated from the source text.
     * @returns {void}
     */
    #ensureLines() {
      if (this.#lines.length === this.#lineStartIndices.length) {
        return;
      }
      while (this.#findNextLine(this.text.slice(this.#lineStartIndices.at(-1)))) {
      }
      this.#lines.push(this.text.slice(this.#lineStartIndices.at(-1)));
      Object.freeze(this.#lines);
    }
    /**
     * Ensures `#lineStartIndices` is lazily calculated up to the specified index.
     * @param {number} index The index of a character in a file.
     * @returns {void}
     */
    #ensureLineStartIndicesFromIndex(index) {
      if (index <= (this.#lineStartIndices.at(-1) ?? 0)) {
        return;
      }
      while (index > (this.#lineStartIndices.at(-1) ?? 0) && this.#findNextLine(this.text.slice(this.#lineStartIndices.at(-1)))) {
      }
    }
    /**
     * Ensures `#lineStartIndices` is lazily calculated up to the specified loc.
     * @param {Object} loc A line/column location.
     * @param {number} loc.line The line number of the location. (0 or 1-indexed based on language.)
     * @param {number} lineStart The line number at which the parser starts counting.
     * @returns {void}
     */
    #ensureLineStartIndicesFromLoc(loc, lineStart) {
      const nextLocLineIndex = loc.line - lineStart + 1;
      const lastCalculatedLineIndex = this.#lineStartIndices.length - 1;
      let additionalLinesNeeded = nextLocLineIndex - lastCalculatedLineIndex;
      if (additionalLinesNeeded <= 0) {
        return;
      }
      while (additionalLinesNeeded > 0 && this.#findNextLine(this.text.slice(this.#lineStartIndices.at(-1)))) {
        additionalLinesNeeded -= 1;
      }
    }
    /**
     * Returns the loc information for the given node or token.
     * @param {Options['SyntaxElementWithLoc']} nodeOrToken The node or token to get the loc information for.
     * @returns {SourceLocation} The loc information for the node or token.
     * @throws {Error} If the node or token does not have loc information.
     */
    getLoc(nodeOrToken) {
      if (hasESTreeStyleLoc(nodeOrToken)) {
        return nodeOrToken.loc;
      }
      if (hasPosStyleLoc(nodeOrToken)) {
        return nodeOrToken.position;
      }
      throw new Error(
        "Custom getLoc() method must be implemented in the subclass."
      );
    }
    /**
     * Converts a source text index into a `{ line: number, column: number }` pair.
     * @param {number} index The index of a character in a file.
     * @throws {TypeError|RangeError} If non-numeric index or index out of range.
     * @returns {{line: number, column: number}} A `{ line: number, column: number }` location object with 0 or 1-indexed line and 0 or 1-indexed column based on language.
     * @public
     */
    getLocFromIndex(index) {
      if (typeof index !== "number") {
        throw new TypeError("Expected `index` to be a number.");
      }
      if (index < 0 || index > this.text.length) {
        throw new RangeError(
          `Index out of range (requested index ${index}, but source text has length ${this.text.length}).`
        );
      }
      const {
        start: { line: lineStart, column: columnStart },
        end: { line: lineEnd, column: columnEnd }
      } = this.getLoc(this.ast);
      if (index === 0) {
        return {
          line: lineStart,
          column: columnStart
        };
      }
      if (index === this.text.length) {
        return {
          line: lineEnd,
          column: columnEnd
        };
      }
      this.#ensureLineStartIndicesFromIndex(index);
      const lineNumber = (index >= (this.#lineStartIndices.at(-1) ?? 0) ? this.#lineStartIndices.length : findLineNumberBinarySearch(this.#lineStartIndices, index)) - 1 + lineStart;
      return {
        line: lineNumber,
        column: index - this.#lineStartIndices[lineNumber - lineStart] + columnStart
      };
    }
    /**
     * Converts a `{ line: number, column: number }` pair into a source text index.
     * @param {Object} loc A line/column location.
     * @param {number} loc.line The line number of the location. (0 or 1-indexed based on language.)
     * @param {number} loc.column The column number of the location. (0 or 1-indexed based on language.)
     * @throws {TypeError|RangeError} If `loc` is not an object with a numeric
     * `line` and `column`, if the `line` is less than or equal to zero or
     * the `line` or `column` is out of the expected range.
     * @returns {number} The index of the line/column location in a file.
     * @public
     */
    getIndexFromLoc(loc) {
      if (loc === null || typeof loc !== "object" || typeof loc.line !== "number" || typeof loc.column !== "number") {
        throw new TypeError(
          "Expected `loc` to be an object with numeric `line` and `column` properties."
        );
      }
      const {
        start: { line: lineStart, column: columnStart },
        end: { line: lineEnd, column: columnEnd }
      } = this.getLoc(this.ast);
      if (loc.line < lineStart || lineEnd < loc.line) {
        throw new RangeError(
          `Line number out of range (line ${loc.line} requested). Valid range: ${lineStart}-${lineEnd}`
        );
      }
      if (loc.line === lineStart && loc.column === columnStart) {
        return 0;
      }
      if (loc.line === lineEnd && loc.column === columnEnd) {
        return this.text.length;
      }
      this.#ensureLineStartIndicesFromLoc(loc, lineStart)