/*
 * Decompiled with CFR 0.152.
 */
package cn.tealc.wwt.export;

import cn.tealc.wutheringwavestool.base.Config;
import cn.tealc.wutheringwavestool.model.CardInfo;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelWriter.class);
    private static final ResourceBundle language = ResourceBundle.getBundle("cn/tealc/wwt/export/language/local", Config.setting.getLanguage());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToExcel(String fileName, Map<String, List<CardInfo>> map, File dir) {
        block19: {
            XSSFWorkbook workbook = new XSSFWorkbook();
            CellStyle ssr = workbook.createCellStyle();
            ssr.setFillForegroundColor(IndexedColors.GOLD.getIndex());
            ssr.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            CellStyle sr = workbook.createCellStyle();
            XSSFColor color = new XSSFColor(new Color(170, 124, 181), null);
            sr.setFillForegroundColor(color);
            sr.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            for (String key : map.keySet()) {
                Sheet sheet = workbook.createSheet(key);
                sheet.setColumnWidth(0, 10240);
                sheet.setColumnWidth(3, 10240);
                sheet.setColumnWidth(6, 10240);
                List<CardInfo> list = map.get(key);
                Row titleRow = sheet.createRow(0);
                titleRow.createCell(0).setCellValue(language.getString("plugin.export.excel.col01"));
                titleRow.createCell(1).setCellValue(language.getString("plugin.export.excel.col02"));
                titleRow.createCell(2).setCellValue(language.getString("plugin.export.excel.col03"));
                titleRow.createCell(3).setCellValue(language.getString("plugin.export.excel.col04"));
                titleRow.createCell(4).setCellValue(language.getString("plugin.export.excel.col05"));
                titleRow.createCell(5).setCellValue(language.getString("plugin.export.excel.col06"));
                titleRow.createCell(6).setCellValue(language.getString("plugin.export.excel.col07"));
                for (int i = 0; i < list.size(); ++i) {
                    CardInfo cardInfo = list.get(i);
                    Row row = sheet.createRow(i + 1);
                    row.createCell(0).setCellValue(cardInfo.getName());
                    row.createCell(1).setCellValue(cardInfo.getResourceType());
                    row.createCell(2).setCellValue(cardInfo.getQualityLevel());
                    row.createCell(3).setCellValue(cardInfo.getTime());
                    row.createCell(4).setCellValue(cardInfo.getCount());
                    row.createCell(5).setCellValue(cardInfo.getResourceId());
                    row.createCell(6).setCellValue(cardInfo.getCardPoolType());
                    if (cardInfo.getQualityLevel() == 5) {
                        row.cellIterator().forEachRemaining(cell -> cell.setCellStyle(ssr));
                        continue;
                    }
                    if (cardInfo.getQualityLevel() != 4) continue;
                    row.cellIterator().forEachRemaining(cell -> cell.setCellStyle(sr));
                }
            }
            Sheet sheet = workbook.createSheet(fileName);
            Row row = sheet.createRow(0);
            row.createCell(0).setCellValue(language.getString("plugin.export.excel.tip"));
            try {
                boolean bl;
                FileOutputStream fileOut = new FileOutputStream(String.valueOf(dir.getAbsoluteFile()) + File.separator + fileName + ".xlsx");
                try {
                    workbook.write(fileOut);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fileOut.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        System.out.println(e.getMessage());
                        LOG.error(e.getMessage(), (Throwable)e);
                        break block19;
                    }
                }
                fileOut.close();
                return bl;
            }
            finally {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }
}

