/*
 * Decompiled with CFR 0.152.
 */
package cn.tealc.wwt.export;

import cn.tealc.fxplugin.FxPlugin;
import cn.tealc.fxplugin.model.FxPluginType;
import cn.tealc.wutheringwavestool.base.Config;
import cn.tealc.wutheringwavestool.base.NotificationManager;
import cn.tealc.wutheringwavestool.model.message.MessageInfo;
import cn.tealc.wutheringwavestool.model.message.MessageType;
import cn.tealc.wwt.export.ExcelMapper;
import com.jfoenixN.controls.JFXDialogLayout;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.material2.Material2AL;
import org.kordamp.ikonli.material2.Material2OutlinedMZ;

public class Main
extends JFXDialogLayout
implements FxPlugin {
    private final MenuButton exportButton;
    private final Button importButton;
    private Consumer<Object> finished;
    private Consumer<Object> failed;
    private ResourceBundle language = ResourceBundle.getBundle("cn/tealc/wwt/export/language/local", Config.setting.getLanguage());

    public Main() {
        File[] players;
        Label title = new Label(this.language.getString("plugin.export.title"));
        title.getStyleClass().add((Object)"title-3");
        this.setHeading(new Node[]{title});
        this.exportButton = new MenuButton(this.language.getString("plugin.export.button.export"), (Node)new FontIcon((Ikon)Material2OutlinedMZ.SAVE));
        File dir = new File("data");
        if (dir.exists() && (players = dir.listFiles(File::isDirectory)) != null) {
            for (File player : players) {
                MenuItem item = new MenuItem(player.getName());
                item.setOnAction(event -> this.export(player.getName()));
                this.exportButton.getItems().add((Object)item);
            }
        }
        this.importButton = new Button(this.language.getString("plugin.export.button.import"), (Node)new FontIcon((Ikon)Material2AL.FOLDER_OPEN));
        this.importButton.setOnAction(event -> this.importExcel());
        HBox hBox = new HBox(20.0, new Node[]{this.exportButton, this.importButton});
        hBox.setAlignment(Pos.CENTER);
        Label tip = new Label(this.language.getString("plugin.export.tip"));
        tip.getStyleClass().addAll((Object[])new String[]{"text-subtle"});
        VBox vBox = new VBox(40.0, new Node[]{hBox, tip});
        vBox.setAlignment(Pos.CENTER);
        this.setBody(new Node[]{vBox});
        Button cancelBtn = new Button(this.language.getString("plugin.export.button.cancel"));
        cancelBtn.setCancelButton(true);
        this.setActions(new Node[]{cancelBtn});
    }

    private void export(String playerId) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.language.getString("plugin.export.dir"));
        directoryChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        File dir = directoryChooser.showDialog(this.exportButton.getScene().getWindow());
        if (dir != null) {
            ExcelMapper excelMapper = new ExcelMapper();
            boolean status = excelMapper.toExcel(playerId, dir);
            if (status) {
                NotificationManager.message((MessageInfo)new MessageInfo(MessageType.SUCCESS, this.language.getString("plugin.export.message01")));
            } else {
                NotificationManager.message((MessageInfo)new MessageInfo(MessageType.ERROR, this.language.getString("plugin.export.message02")));
            }
        }
    }

    private void importExcel() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.language.getString("plugin.export.file"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Excel", new String[]{"*.xlsx"}));
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        File file = fileChooser.showOpenDialog(this.importButton.getScene().getWindow());
        if (file != null) {
            ExcelMapper excelMapper = new ExcelMapper();
            String playerId = excelMapper.readExcel(file);
            if (playerId != null) {
                NotificationManager.message((MessageInfo)new MessageInfo(MessageType.SUCCESS, this.language.getString("plugin.export.message03")));
                this.finished.accept(playerId);
            } else {
                NotificationManager.message((MessageInfo)new MessageInfo(MessageType.ERROR, this.language.getString("plugin.export.message04")));
            }
        }
    }

    public Optional<String> getPId() {
        return Optional.empty();
    }

    public Optional<String> getName() {
        return Optional.empty();
    }

    public Optional<String> getVersion() {
        return Optional.empty();
    }

    public Optional<String> getAuthor() {
        return Optional.empty();
    }

    public FxPluginType getType() {
        return FxPluginType.VIEW;
    }

    public Optional<Object> run(Map<String, Object> map) {
        return Optional.of(this);
    }

    public void setOnFinished(Consumer<Object> consumer) {
        this.finished = consumer;
    }

    public void setOnFailed(Consumer<Object> consumer) {
        this.failed = consumer;
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<Map<String, Object>> getData() {
        return Optional.empty();
    }
}

