#!/bin/sh

regal_sysfs="/sys/class/regal_class"

regal_dev_list="regal_wb regal_tmp regal_img regal_cinfo regal_waveform"

regal_dev_node_path="/dev"

if [ "$1" ];then
	is_create_node="$1"
else
	is_create_node="1"
fi

if [ ! -e "${regal_sysfs}" ];then
	echo " \"${regal_sysfs}\" not exist ! BW version ?" 1>&2 
	exit 1
fi

for dev_name in ${regal_dev_list}
do
	if [ ! -e "${regal_sysfs}/${dev_name}" ];then
		echo "\"${dev_name}\" not exist ! please check !" 1>&2 
		continue
	fi
	dev_major="$(cat "${regal_sysfs}/${dev_name}/dev"|awk -F: '{print $1}')"
	dev_minor="$(cat "${regal_sysfs}/${dev_name}/dev"|awk -F: '{print $2}')"
	if [ ! -e "${regal_dev_node_path}/${dev_name}" ];then
		echo "\"${regal_dev_node_path}/${dev_name}\" not exist " 1>&2 
		if [ "${is_create_node}" = "1" ];then
			echo -n "creating \"${regal_dev_node_path}/${dev_name}\" ..." 1>&2 
			mknod "${regal_dev_node_path}/${dev_name}" c ${dev_major} ${dev_minor}
			if [ $? = 0 ];then
				echo "[OK]" 1>&2 
			else 
				echo "[FAIL]" 1>&2 
			fi
		fi
	else 
		ls -l "${regal_dev_node_path}/${dev_name}" 1>&2
	fi

done

exit 0

