// -----------------------------------------------------------------------------
// <copyright file="ResourceInstanceResult.cs" company="Microsoft Corporation">
//     Copyright (c) Microsoft Corporation. Licensed under the MIT License.
// </copyright>
// -----------------------------------------------------------------------------

namespace Microsoft.Management.Configuration.Processor.DSCv3.Schema_2024_04.Metadata
{
    using System;
    using System.Text.Json.Serialization;

    /// <summary>
    /// Defines metadata DSC returns for a DSC configuration operation against a resource instance.
    /// </summary>
    internal class ResourceInstanceResult
    {
        /// <summary>
        /// Gets or sets the context metadata for this instance result.
        /// </summary>
        [JsonRequired]
        [JsonPropertyName("Microsoft.DSC")]
        public ContextMetadata? MicrosoftDSC { get; set; }

        /// <summary>
        /// Contains properties generated by the DSC v3 platform.
        /// </summary>
        public class ContextMetadata
        {
            /// <summary>
            /// Gets or sets the duration of a resource instance execution.
            /// </summary>
            [JsonRequired]
            public TimeSpan Duration { get; set; }
        }
    }
}
