"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const fs_extra_1 = __importDefault(require("fs-extra"));
class StorageSubsystem {
    checkFileName(name) {
        const blackList = ["\\", "/", ".."];
        for (const ch of blackList) {
            if (name.includes(ch))
                return false;
        }
        return true;
    }
    writeFile(name, data) {
        const targetPath = path_1.default.normalize(path_1.default.join(StorageSubsystem.DATA_PATH, name));
        fs_extra_1.default.writeFileSync(targetPath, data, { encoding: "utf-8" });
    }
    readFile(name) {
        const targetPath = path_1.default.normalize(path_1.default.join(StorageSubsystem.DATA_PATH, name));
        return fs_extra_1.default.readFileSync(targetPath, { encoding: "utf-8" });
    }
    readDir(dirName) {
        const targetPath = path_1.default.normalize(path_1.default.join(StorageSubsystem.DATA_PATH, dirName));
        if (!fs_extra_1.default.existsSync(targetPath))
            return [];
        const files = fs_extra_1.default.readdirSync(targetPath).map((v) => path_1.default.normalize(path_1.default.join(dirName, v)));
        return files;
    }
    deleteFile(name) {
        const targetPath = path_1.default.normalize(path_1.default.join(StorageSubsystem.DATA_PATH, name));
        fs_extra_1.default.removeSync(targetPath);
    }
    fileExists(name) {
        const targetPath = path_1.default.normalize(path_1.default.join(StorageSubsystem.DATA_PATH, name));
        return fs_extra_1.default.existsSync(targetPath);
    }
    // Stored in local file based on class definition and identifier
    store(category, uuid, object) {
        const dirPath = path_1.default.join(StorageSubsystem.DATA_PATH, category);
        if (!fs_extra_1.default.existsSync(dirPath))
            fs_extra_1.default.mkdirsSync(dirPath);
        if (!this.checkFileName(uuid))
            throw new Error(`UUID ${uuid} does not conform to specification`);
        const filePath = path_1.default.join(dirPath, `${uuid}.json`);
        const data = JSON.stringify(object, null, 4);
        fs_extra_1.default.writeFileSync(filePath, data, { encoding: "utf-8" });
    }
    // deep copy of the primitive type with the copy target as the prototype
    defineAttr(target, object) {
        for (const v of Object.keys(target)) {
            const objectValue = object[v];
            if (objectValue === undefined)
                continue;
            if (objectValue instanceof Array) {
                target[v] = objectValue;
                continue;
            }
            if (objectValue instanceof Object && typeof objectValue === "object") {
                this.defineAttr(target[v], objectValue);
                continue;
            }
            target[v] = objectValue;
        }
        return target;
    }
    /**
     * Instantiate an object based on the class definition and identifier
     */
    load(category, classz, uuid) {
        const dirPath = path_1.default.join(StorageSubsystem.DATA_PATH, category);
        if (!fs_extra_1.default.existsSync(dirPath))
            fs_extra_1.default.mkdirsSync(dirPath);
        if (!this.checkFileName(uuid))
            throw new Error(`UUID ${uuid} does not conform to specification`);
        const filePath = path_1.default.join(dirPath, `${uuid}.json`);
        if (!fs_extra_1.default.existsSync(filePath))
            return null;
        const data = fs_extra_1.default.readFileSync(filePath, { encoding: "utf-8" });
        const dataObject = JSON.parse(data);
        const target = new classz();
        // for (const v of Object. keys(target)) {
        // if (dataObject[v] !== undefined) target[v] = dataObject[v];
        // }
        // deep object copy
        return this.defineAttr(target, dataObject);
    }
    /**
     * Return all identifiers related to this class through the class definition
     */
    list(category) {
        const dirPath = path_1.default.join(StorageSubsystem.DATA_PATH, category);
        if (!fs_extra_1.default.existsSync(dirPath))
            fs_extra_1.default.mkdirsSync(dirPath);
        const files = fs_extra_1.default.readdirSync(dirPath);
        const result = new Array();
        files.forEach((name) => {
            result.push(name.replace(path_1.default.extname(name), ""));
        });
        return result;
    }
    /**
     * Delete an identifier instance of the specified type through the class definition
     */
    delete(category, uuid) {
        const filePath = path_1.default.join(StorageSubsystem.DATA_PATH, category, `${uuid}.json`);
        if (!fs_extra_1.default.existsSync(filePath))
            return;
        fs_extra_1.default.removeSync(filePath);
    }
}
exports.default = StorageSubsystem;
StorageSubsystem.DATA_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "data"));
StorageSubsystem.INDEX_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "data", "index"));
//# sourceMappingURL=system_storage.js.map